/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RepositoryStatsSnapshot
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RepositoryStatsSnapshot> {
    @Nonnull
    private final Map<String, String> repositoryLocation;
    @Nullable
    private final String repositoryName;
    @Nullable
    private final String repositoryType;
    @Nonnull
    private final Map<String, Long> requestCounts;
    @Nonnull
    private final Map<String, Long> requestFailuresTotal;
    @Nonnull
    private final Map<String, Long> requestRetryCountTotal;
    @Nonnull
    private final Map<String, Long> requestSuccessTotal;
    @Nonnull
    private final Map<String, Long> requestTimeInMillis;
    public static final JsonpDeserializer<RepositoryStatsSnapshot> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RepositoryStatsSnapshot::setupRepositoryStatsSnapshotDeserializer);

    private RepositoryStatsSnapshot(Builder builder) {
        this.repositoryLocation = ApiTypeHelper.unmodifiable(builder.repositoryLocation);
        this.repositoryName = builder.repositoryName;
        this.repositoryType = builder.repositoryType;
        this.requestCounts = ApiTypeHelper.unmodifiable(builder.requestCounts);
        this.requestFailuresTotal = ApiTypeHelper.unmodifiable(builder.requestFailuresTotal);
        this.requestRetryCountTotal = ApiTypeHelper.unmodifiable(builder.requestRetryCountTotal);
        this.requestSuccessTotal = ApiTypeHelper.unmodifiable(builder.requestSuccessTotal);
        this.requestTimeInMillis = ApiTypeHelper.unmodifiable(builder.requestTimeInMillis);
    }

    public static RepositoryStatsSnapshot of(Function<Builder, ObjectBuilder<RepositoryStatsSnapshot>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, String> repositoryLocation() {
        return this.repositoryLocation;
    }

    @Nullable
    public final String repositoryName() {
        return this.repositoryName;
    }

    @Nullable
    public final String repositoryType() {
        return this.repositoryType;
    }

    @Nonnull
    public final Map<String, Long> requestCounts() {
        return this.requestCounts;
    }

    @Nonnull
    public final Map<String, Long> requestFailuresTotal() {
        return this.requestFailuresTotal;
    }

    @Nonnull
    public final Map<String, Long> requestRetryCountTotal() {
        return this.requestRetryCountTotal;
    }

    @Nonnull
    public final Map<String, Long> requestSuccessTotal() {
        return this.requestSuccessTotal;
    }

    @Nonnull
    public final Map<String, Long> requestTimeInMillis() {
        return this.requestTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.repositoryLocation)) {
            generator.writeKey("repository_location");
            generator.writeStartObject();
            for (Map.Entry<String, String> entry : this.repositoryLocation.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.repositoryName != null) {
            generator.writeKey("repository_name");
            generator.write(this.repositoryName);
        }
        if (this.repositoryType != null) {
            generator.writeKey("repository_type");
            generator.write(this.repositoryType);
        }
        if (ApiTypeHelper.isDefined(this.requestCounts)) {
            generator.writeKey("request_counts");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.requestCounts.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(((Long)entry.getValue()).longValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.requestFailuresTotal)) {
            generator.writeKey("request_failures_total");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.requestFailuresTotal.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(((Long)entry.getValue()).longValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.requestRetryCountTotal)) {
            generator.writeKey("request_retry_count_total");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.requestRetryCountTotal.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(((Long)entry.getValue()).longValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.requestSuccessTotal)) {
            generator.writeKey("request_success_total");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.requestSuccessTotal.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(((Long)entry.getValue()).longValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.requestTimeInMillis)) {
            generator.writeKey("request_time_in_millis");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.requestTimeInMillis.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write(((Long)entry.getValue()).longValue());
            }
            generator.writeEnd();
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRepositoryStatsSnapshotDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::repositoryLocation, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "repository_location");
        op.add(Builder::repositoryName, JsonpDeserializer.stringDeserializer(), "repository_name");
        op.add(Builder::repositoryType, JsonpDeserializer.stringDeserializer(), "repository_type");
        op.add(Builder::requestCounts, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "request_counts");
        op.add(Builder::requestFailuresTotal, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "request_failures_total");
        op.add(Builder::requestRetryCountTotal, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "request_retry_count_total");
        op.add(Builder::requestSuccessTotal, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "request_success_total");
        op.add(Builder::requestTimeInMillis, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "request_time_in_millis");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.repositoryLocation);
        result = 31 * result + Objects.hashCode(this.repositoryName);
        result = 31 * result + Objects.hashCode(this.repositoryType);
        result = 31 * result + Objects.hashCode(this.requestCounts);
        result = 31 * result + Objects.hashCode(this.requestFailuresTotal);
        result = 31 * result + Objects.hashCode(this.requestRetryCountTotal);
        result = 31 * result + Objects.hashCode(this.requestSuccessTotal);
        result = 31 * result + Objects.hashCode(this.requestTimeInMillis);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryStatsSnapshot other = (RepositoryStatsSnapshot)o;
        return Objects.equals(this.repositoryLocation, other.repositoryLocation) && Objects.equals(this.repositoryName, other.repositoryName) && Objects.equals(this.repositoryType, other.repositoryType) && Objects.equals(this.requestCounts, other.requestCounts) && Objects.equals(this.requestFailuresTotal, other.requestFailuresTotal) && Objects.equals(this.requestRetryCountTotal, other.requestRetryCountTotal) && Objects.equals(this.requestSuccessTotal, other.requestSuccessTotal) && Objects.equals(this.requestTimeInMillis, other.requestTimeInMillis);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RepositoryStatsSnapshot> {
        @Nullable
        private Map<String, String> repositoryLocation;
        @Nullable
        private String repositoryName;
        @Nullable
        private String repositoryType;
        @Nullable
        private Map<String, Long> requestCounts;
        @Nullable
        private Map<String, Long> requestFailuresTotal;
        @Nullable
        private Map<String, Long> requestRetryCountTotal;
        @Nullable
        private Map<String, Long> requestSuccessTotal;
        @Nullable
        private Map<String, Long> requestTimeInMillis;

        public Builder() {
        }

        private Builder(RepositoryStatsSnapshot o) {
            this.repositoryLocation = Builder._mapCopy(o.repositoryLocation);
            this.repositoryName = o.repositoryName;
            this.repositoryType = o.repositoryType;
            this.requestCounts = Builder._mapCopy(o.requestCounts);
            this.requestFailuresTotal = Builder._mapCopy(o.requestFailuresTotal);
            this.requestRetryCountTotal = Builder._mapCopy(o.requestRetryCountTotal);
            this.requestSuccessTotal = Builder._mapCopy(o.requestSuccessTotal);
            this.requestTimeInMillis = Builder._mapCopy(o.requestTimeInMillis);
        }

        private Builder(Builder o) {
            this.repositoryLocation = Builder._mapCopy(o.repositoryLocation);
            this.repositoryName = o.repositoryName;
            this.repositoryType = o.repositoryType;
            this.requestCounts = Builder._mapCopy(o.requestCounts);
            this.requestFailuresTotal = Builder._mapCopy(o.requestFailuresTotal);
            this.requestRetryCountTotal = Builder._mapCopy(o.requestRetryCountTotal);
            this.requestSuccessTotal = Builder._mapCopy(o.requestSuccessTotal);
            this.requestTimeInMillis = Builder._mapCopy(o.requestTimeInMillis);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder repositoryLocation(Map<String, String> map) {
            this.repositoryLocation = Builder._mapPutAll(this.repositoryLocation, map);
            return this;
        }

        @Nonnull
        public final Builder repositoryLocation(String key, String value) {
            this.repositoryLocation = Builder._mapPut(this.repositoryLocation, key, value);
            return this;
        }

        @Nonnull
        public final Builder repositoryName(@Nullable String value) {
            this.repositoryName = value;
            return this;
        }

        @Nonnull
        public final Builder repositoryType(@Nullable String value) {
            this.repositoryType = value;
            return this;
        }

        @Nonnull
        public final Builder requestCounts(Map<String, Long> map) {
            this.requestCounts = Builder._mapPutAll(this.requestCounts, map);
            return this;
        }

        @Nonnull
        public final Builder requestCounts(String key, Long value) {
            this.requestCounts = Builder._mapPut(this.requestCounts, key, value);
            return this;
        }

        @Nonnull
        public final Builder requestFailuresTotal(Map<String, Long> map) {
            this.requestFailuresTotal = Builder._mapPutAll(this.requestFailuresTotal, map);
            return this;
        }

        @Nonnull
        public final Builder requestFailuresTotal(String key, Long value) {
            this.requestFailuresTotal = Builder._mapPut(this.requestFailuresTotal, key, value);
            return this;
        }

        @Nonnull
        public final Builder requestRetryCountTotal(Map<String, Long> map) {
            this.requestRetryCountTotal = Builder._mapPutAll(this.requestRetryCountTotal, map);
            return this;
        }

        @Nonnull
        public final Builder requestRetryCountTotal(String key, Long value) {
            this.requestRetryCountTotal = Builder._mapPut(this.requestRetryCountTotal, key, value);
            return this;
        }

        @Nonnull
        public final Builder requestSuccessTotal(Map<String, Long> map) {
            this.requestSuccessTotal = Builder._mapPutAll(this.requestSuccessTotal, map);
            return this;
        }

        @Nonnull
        public final Builder requestSuccessTotal(String key, Long value) {
            this.requestSuccessTotal = Builder._mapPut(this.requestSuccessTotal, key, value);
            return this;
        }

        @Nonnull
        public final Builder requestTimeInMillis(Map<String, Long> map) {
            this.requestTimeInMillis = Builder._mapPutAll(this.requestTimeInMillis, map);
            return this;
        }

        @Nonnull
        public final Builder requestTimeInMillis(String key, Long value) {
            this.requestTimeInMillis = Builder._mapPut(this.requestTimeInMillis, key, value);
            return this;
        }

        @Override
        @Nonnull
        public RepositoryStatsSnapshot build() {
            this._checkSingleUse();
            return new RepositoryStatsSnapshot(this);
        }
    }
}

