"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WRONG_THROTTLE_WARNING = exports.URL = exports.PLUGIN_NAME = exports.OPEN_SEARCH_PREFIX = exports.MONITORS_NAV_ID = exports.MAX_THROTTLE_VALUE = exports.INDEX_PREFIX = exports.INDEX = exports.DESTINATIONS_NAV_ID = exports.ALERTS_NAV_ID = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Keeping index prefix as 'opendistro' as migrating the system index is currently difficult to complete
const OPEN_SEARCH_PREFIX = exports.OPEN_SEARCH_PREFIX = 'opendistro';
const PLUGIN_NAME = exports.PLUGIN_NAME = `alerting`;
const INDEX_PREFIX = exports.INDEX_PREFIX = `${OPEN_SEARCH_PREFIX}-alerting`;
const INDEX = exports.INDEX = {
  SCHEDULED_JOBS: `.${INDEX_PREFIX}-config`,
  ALERTS: `.${INDEX_PREFIX}-alerts`,
  ALL_ALERTS: `.${INDEX_PREFIX}-alert*`,
  ALERT_HISTORY_WRITE: `.${INDEX_PREFIX}-alert-history-write`
};
const URL = exports.URL = {
  MUSTACHE: 'https://mustache.github.io/mustache.5.html',
  DOCUMENTATION: 'https://docs-beta.opensearch.org/monitoring-plugins/alerting/',
  CREATE_MONITOR_DOCUMENTATION: 'https://opensearch.org/docs/monitoring-plugins/alerting/monitors/#create-monitors'
};
const MAX_THROTTLE_VALUE = exports.MAX_THROTTLE_VALUE = 1440;
const WRONG_THROTTLE_WARNING = exports.WRONG_THROTTLE_WARNING = `Throttle value must be greater than 0 and less than ${MAX_THROTTLE_VALUE}.`;
const ALERTS_NAV_ID = exports.ALERTS_NAV_ID = `alerts`;
const DESTINATIONS_NAV_ID = exports.DESTINATIONS_NAV_ID = `destinations`;
const MONITORS_NAV_ID = exports.MONITORS_NAV_ID = `monitors`;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJPUEVOX1NFQVJDSF9QUkVGSVgiLCJleHBvcnRzIiwiUExVR0lOX05BTUUiLCJJTkRFWF9QUkVGSVgiLCJJTkRFWCIsIlNDSEVEVUxFRF9KT0JTIiwiQUxFUlRTIiwiQUxMX0FMRVJUUyIsIkFMRVJUX0hJU1RPUllfV1JJVEUiLCJVUkwiLCJNVVNUQUNIRSIsIkRPQ1VNRU5UQVRJT04iLCJDUkVBVEVfTU9OSVRPUl9ET0NVTUVOVEFUSU9OIiwiTUFYX1RIUk9UVExFX1ZBTFVFIiwiV1JPTkdfVEhST1RUTEVfV0FSTklORyIsIkFMRVJUU19OQVZfSUQiLCJERVNUSU5BVElPTlNfTkFWX0lEIiwiTU9OSVRPUlNfTkFWX0lEIl0sInNvdXJjZXMiOlsiY29uc3RhbnRzLmpzIl0sInNvdXJjZXNDb250ZW50IjpbIi8qXG4gKiBDb3B5cmlnaHQgT3BlblNlYXJjaCBDb250cmlidXRvcnNcbiAqIFNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4gKi9cblxuLy8gS2VlcGluZyBpbmRleCBwcmVmaXggYXMgJ29wZW5kaXN0cm8nIGFzIG1pZ3JhdGluZyB0aGUgc3lzdGVtIGluZGV4IGlzIGN1cnJlbnRseSBkaWZmaWN1bHQgdG8gY29tcGxldGVcbmV4cG9ydCBjb25zdCBPUEVOX1NFQVJDSF9QUkVGSVggPSAnb3BlbmRpc3Rybyc7XG5cbmV4cG9ydCBjb25zdCBQTFVHSU5fTkFNRSA9IGBhbGVydGluZ2A7XG5leHBvcnQgY29uc3QgSU5ERVhfUFJFRklYID0gYCR7T1BFTl9TRUFSQ0hfUFJFRklYfS1hbGVydGluZ2A7XG5leHBvcnQgY29uc3QgSU5ERVggPSB7XG4gIFNDSEVEVUxFRF9KT0JTOiBgLiR7SU5ERVhfUFJFRklYfS1jb25maWdgLFxuICBBTEVSVFM6IGAuJHtJTkRFWF9QUkVGSVh9LWFsZXJ0c2AsXG4gIEFMTF9BTEVSVFM6IGAuJHtJTkRFWF9QUkVGSVh9LWFsZXJ0KmAsXG4gIEFMRVJUX0hJU1RPUllfV1JJVEU6IGAuJHtJTkRFWF9QUkVGSVh9LWFsZXJ0LWhpc3Rvcnktd3JpdGVgLFxufTtcblxuZXhwb3J0IGNvbnN0IFVSTCA9IHtcbiAgTVVTVEFDSEU6ICdodHRwczovL211c3RhY2hlLmdpdGh1Yi5pby9tdXN0YWNoZS41Lmh0bWwnLFxuICBET0NVTUVOVEFUSU9OOiAnaHR0cHM6Ly9kb2NzLWJldGEub3BlbnNlYXJjaC5vcmcvbW9uaXRvcmluZy1wbHVnaW5zL2FsZXJ0aW5nLycsXG4gIENSRUFURV9NT05JVE9SX0RPQ1VNRU5UQVRJT046XG4gICAgJ2h0dHBzOi8vb3BlbnNlYXJjaC5vcmcvZG9jcy9tb25pdG9yaW5nLXBsdWdpbnMvYWxlcnRpbmcvbW9uaXRvcnMvI2NyZWF0ZS1tb25pdG9ycycsXG59O1xuXG5leHBvcnQgY29uc3QgTUFYX1RIUk9UVExFX1ZBTFVFID0gMTQ0MDtcbmV4cG9ydCBjb25zdCBXUk9OR19USFJPVFRMRV9XQVJOSU5HID0gYFRocm90dGxlIHZhbHVlIG11c3QgYmUgZ3JlYXRlciB0aGFuIDAgYW5kIGxlc3MgdGhhbiAke01BWF9USFJPVFRMRV9WQUxVRX0uYDtcbmV4cG9ydCBjb25zdCBBTEVSVFNfTkFWX0lEID0gYGFsZXJ0c2A7XG5leHBvcnQgY29uc3QgREVTVElOQVRJT05TX05BVl9JRCA9IGBkZXN0aW5hdGlvbnNgO1xuZXhwb3J0IGNvbnN0IE1PTklUT1JTX05BVl9JRCA9IGBtb25pdG9yc2A7XG4iXSwibWFwcGluZ3MiOiI7Ozs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBOztBQUVBO0FBQ08sTUFBTUEsa0JBQWtCLEdBQUFDLE9BQUEsQ0FBQUQsa0JBQUEsR0FBRyxZQUFZO0FBRXZDLE1BQU1FLFdBQVcsR0FBQUQsT0FBQSxDQUFBQyxXQUFBLEdBQUksVUFBUztBQUM5QixNQUFNQyxZQUFZLEdBQUFGLE9BQUEsQ0FBQUUsWUFBQSxHQUFJLEdBQUVILGtCQUFtQixXQUFVO0FBQ3JELE1BQU1JLEtBQUssR0FBQUgsT0FBQSxDQUFBRyxLQUFBLEdBQUc7RUFDbkJDLGNBQWMsRUFBRyxJQUFHRixZQUFhLFNBQVE7RUFDekNHLE1BQU0sRUFBRyxJQUFHSCxZQUFhLFNBQVE7RUFDakNJLFVBQVUsRUFBRyxJQUFHSixZQUFhLFNBQVE7RUFDckNLLG1CQUFtQixFQUFHLElBQUdMLFlBQWE7QUFDeEMsQ0FBQztBQUVNLE1BQU1NLEdBQUcsR0FBQVIsT0FBQSxDQUFBUSxHQUFBLEdBQUc7RUFDakJDLFFBQVEsRUFBRSw0Q0FBNEM7RUFDdERDLGFBQWEsRUFBRSwrREFBK0Q7RUFDOUVDLDRCQUE0QixFQUMxQjtBQUNKLENBQUM7QUFFTSxNQUFNQyxrQkFBa0IsR0FBQVosT0FBQSxDQUFBWSxrQkFBQSxHQUFHLElBQUk7QUFDL0IsTUFBTUMsc0JBQXNCLEdBQUFiLE9BQUEsQ0FBQWEsc0JBQUEsR0FBSSx1REFBc0RELGtCQUFtQixHQUFFO0FBQzNHLE1BQU1FLGFBQWEsR0FBQWQsT0FBQSxDQUFBYyxhQUFBLEdBQUksUUFBTztBQUM5QixNQUFNQyxtQkFBbUIsR0FBQWYsT0FBQSxDQUFBZSxtQkFBQSxHQUFJLGNBQWE7QUFDMUMsTUFBTUMsZUFBZSxHQUFBaEIsT0FBQSxDQUFBZ0IsZUFBQSxHQUFJLFVBQVMifQ==