/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.url;

import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Map;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.blobstore.DeleteResult;
import org.opensearch.common.blobstore.support.AbstractBlobContainer;
import org.opensearch.common.blobstore.url.URLBlobStore;
import org.opensearch.secure_sm.AccessController;

public class URLBlobContainer
extends AbstractBlobContainer {
    protected final URLBlobStore blobStore;
    protected final URL path;

    public URLBlobContainer(URLBlobStore blobStore, BlobPath blobPath, URL path) {
        super(blobPath);
        this.blobStore = blobStore;
        this.path = path;
    }

    public URL url() {
        return this.path;
    }

    public boolean blobExists(String blobName) throws IOException {
        try {
            this.readBlob(blobName);
            return true;
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }

    public Map<String, BlobMetadata> listBlobs() throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public Map<String, BlobContainer> children() throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(String blobNamePrefix) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) {
        throw new UnsupportedOperationException("URL repository is read only");
    }

    public DeleteResult delete() {
        throw new UnsupportedOperationException("URL repository is read only");
    }

    public InputStream readBlob(String name) throws IOException {
        try {
            return new BufferedInputStream(URLBlobContainer.getInputStream(this.path.toURI().resolve(name).toURL()), this.blobStore.bufferSizeInBytes());
        }
        catch (FileNotFoundException fnfe) {
            throw new NoSuchFileException("[" + name + "] blob not found");
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    public void writeBlobAtomic(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        throw new UnsupportedOperationException("URL repository doesn't support this operation");
    }

    @SuppressForbidden(reason="We call connect in doPrivileged and provide SocketPermission")
    private static InputStream getInputStream(URL url) throws IOException {
        return (InputStream)AccessController.doPrivilegedChecked(url::openStream);
    }
}

