/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tasks;

import java.io.IOException;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.tasks.SearchShardTaskCancellationStats;
import org.opensearch.tasks.SearchTaskCancellationStats;

public class TaskCancellationStats
implements ToXContentFragment,
Writeable {
    private final SearchTaskCancellationStats searchTaskCancellationStats;
    private final SearchShardTaskCancellationStats searchShardTaskCancellationStats;

    public TaskCancellationStats(SearchTaskCancellationStats searchTaskCancellationStats, SearchShardTaskCancellationStats searchShardTaskCancellationStats) {
        this.searchTaskCancellationStats = searchTaskCancellationStats;
        this.searchShardTaskCancellationStats = searchShardTaskCancellationStats;
    }

    public TaskCancellationStats(StreamInput in) throws IOException {
        this.searchTaskCancellationStats = in.getVersion().onOrAfter(Version.V_3_0_0) ? new SearchTaskCancellationStats(in) : new SearchTaskCancellationStats(0L, 0L);
        this.searchShardTaskCancellationStats = new SearchShardTaskCancellationStats(in);
    }

    protected SearchShardTaskCancellationStats getSearchShardTaskCancellationStats() {
        return this.searchShardTaskCancellationStats;
    }

    protected SearchTaskCancellationStats getSearchTaskCancellationStats() {
        return this.searchTaskCancellationStats;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("task_cancellation");
        builder.field("search_task", (ToXContent)this.searchTaskCancellationStats);
        builder.field("search_shard_task", (ToXContent)this.searchShardTaskCancellationStats);
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_3_0_0)) {
            this.searchTaskCancellationStats.writeTo(out);
        }
        this.searchShardTaskCancellationStats.writeTo(out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskCancellationStats that = (TaskCancellationStats)o;
        return Objects.equals(this.searchTaskCancellationStats, that.searchTaskCancellationStats) && Objects.equals(this.searchShardTaskCancellationStats, that.searchShardTaskCancellationStats);
    }

    public int hashCode() {
        return Objects.hash(this.searchTaskCancellationStats, this.searchShardTaskCancellationStats);
    }
}

