/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

public class HashUtils {
    public static int getV6SignatureSaltSizeInBytes(int hashAlgorithm) {
        switch (hashAlgorithm) {
            case 8: 
            case 11: 
            case 12: 
            case 313: {
                return 16;
            }
            case 9: {
                return 24;
            }
            case 10: 
            case 14: 
            case 315: {
                return 32;
            }
        }
        throw new IllegalArgumentException("Salt size not specified for Hash Algorithm with ID " + hashAlgorithm);
    }

    public boolean saltSizeMatchesSpec(int hashAlgorithm, int saltSize) {
        try {
            return saltSize == HashUtils.getV6SignatureSaltSizeInBytes(hashAlgorithm);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

