/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fil extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_NR = "Nauru";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "Arabic";
        final String metaValue_bn = "Bangla";
        final String metaValue_bo = "Tibetan";
        final String metaValue_el = "Greek";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebrew";
        final String metaValue_hy = "Armenian";
        final String metaValue_ja = "Japanese";
        final String metaValue_ka = "Georgian";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korean";
        final String metaValue_la = "Latin";
        final String metaValue_lo = "Lao";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolian";
        final String metaValue_or = "Odia";
        final String metaValue_si = "Sinhala";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final Object[][] data = new Object[][] {
            { "ksh", "Colognian" },
            { "mwl", "Mirandese" },
            { "Zsym", "Mga Simbolo" },
            { "type.nu.lanatham", "Tai Tham Tham na Mga Digit" },
            { "Zsye", "Emoji" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "rap", "Rapanui" },
            { "AC", "Acsencion island" },
            { "rar", "Rarotongan" },
            { "tet", "Tetum" },
            { "AD", "Andorra" },
            { "AE", "United Arab Emirates" },
            { "nl_BE", "Flemish" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua & Barbuda" },
            { "type.nu.mroo", "Mro na Mga Digit" },
            { "type.ca.ethiopic", "Kalendaryo ng Ethiopia" },
            { "AI", "Anguilla" },
            { "key.tz", "Time Zone" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentina" },
            { "AS", "American Samoa" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "en_US", "Ingles na American" },
            { "AX", "\u00c5land Islands" },
            { "AZ", "Azerbaijan" },
            { "BA", "Bosnia and Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "Cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "Kumyk" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "myv", "Erzya" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribbean Netherlands" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "xog", "Soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet Island" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "type.ca.persian", "Kalendaryong Persian" },
            { "type.nu.hebr", "Mga Hebrew Numeral" },
            { "CA", "Canada" },
            { "CC", "Cocos (Keeling) Islands" },
            { "mzn", "Mazanderani" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Central African Republic" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cook Islands" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Clipperton Island" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas Island" },
            { "CY", "Cyprus" },
            { "type.nu.bali", "Balinese na Mga Digit" },
            { "CZ", "Czechia" },
            { "eka", "Ekajuk" },
            { "DE", "Germany" },
            { "ace", "Achinese" },
            { "cgg", "Chiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "Mga Devanagari Digit" },
            { "DJ", "Djibouti" },
            { "DK", "Denmark" },
            { "ach", "Acoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "Armenian Lowercase Numerals" },
            { "DO", "Dominican Republic" },
            { "gor", "Gorontalo" },
            { "zun", "Zuni" },
            { "tig", "Tigre" },
            { "DZ", "Algeria" },
            { "pag", "Pangasinan" },
            { "type.d0.hwidth", "Hanggang sa Halfwidth" },
            { "EA", "Ceuta & Melilla" },
            { "pam", "Pampanga" },
            { "EC", "Ecuador" },
            { "pap", "Papiamento" },
            { "ada", "Adangme" },
            { "EE", "Estonia" },
            { "EG", "Egypt" },
            { "EH", "Kanlurang Sahara" },
            { "pau", "Palauan" },
            { "chk", "Chuukese" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "type.nu.mathbold", "Matematikal na Bold na Mga Digit" },
            { "chr", "Cherokee" },
            { "ER", "Eritrea" },
            { "ES", "Spain" },
            { "ET", "Ethiopia" },
            { "EU", "European Union" },
            { "type.ca.gregorian", "Gregorian na Kalendaryo" },
            { "EZ", "Eurozone" },
            { "chy", "Cheyenne" },
            { "type.nu.gujr", "Mga Gujarati Digit" },
            { "ady", "Adyghe" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falkland Islands" },
            { "FM", "Micronesia" },
            { "key.va", "Lokal na Variant" },
            { "FO", "Faroe Islands" },
            { "Taml", metaValue_ta },
            { "FR", "France" },
            { "root", "Root" },
            { "type.ca.indian", "Pambansang Kalendaryong Indian" },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "pcm", "Nigerian Pidgin" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "French Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorial Guinea" },
            { "GR", "Greece" },
            { "GS", "South Georgia & South Sandwich Islands" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "type.nu.mathmono", "Matematikal na Mga Digit na May Isang Puwang" },
            { "GW", "Guinea-Bissau" },
            { "tlh", "Klingon" },
            { "GY", "Guyana" },
            { "ckb", "Central Kurdish" },
            { "zxx", "Walang nilalaman na ukol sa wika" },
            { "de_AT", "Austrian German" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Heard & McDonald Islands" },
            { "HN", "Honduras" },
            { "HR", "Croatia" },
            { "agq", "Aghem" },
            { "gsw", "Swiss German" },
            { "type.ca.islamic-umalqura", "Kalendaryong Islamiko (Umm al-Qura)" },
            { "HT", "Haiti" },
            { "HU", "Hungary" },
            { "IC", "Canary Islands" },
            { "ID", "Indonesia" },
            { "type.nu.kali", "Kayah Li na Mga Digit" },
            { "IE", "Ireland" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "zza", "Zaza" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "type.co.eor", "Mga Tuntunin ng European na Pagkakasunud-sunod" },
            { "IO", "British Indian Ocean Territory" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Iceland" },
            { "IT", "Italy" },
            { "Zmth", "Mathematical Notation" },
            { "type.nu.thai", "Mga Thai na Digit" },
            { "type.nu.beng", "Mga Bengali Digit" },
            { "type.nu.cyrl", "Cyrillic na Mga Numero" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "Kalendaryong Islamic" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "ain", "Ainu" },
            { "guz", "Gusii" },
            { "type.nu.knda", "Mga Kannada na Digit" },
            { "de_CH", "Swiss High German" },
            { "type.co.phonetic", "Phonetic na Ayos ng Pag-uuri-uri" },
            { "type.ca.buddhist", "Kalendaryo ng Buddhist" },
            { "KE", "Kenya" },
            { "419", "Latin America" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Cambodia" },
            { "KI", "Kiribati" },
            { "KM", "Comoros" },
            { "Knda", metaValue_kn },
            { "KN", "St. Kitts & Nevis" },
            { "fr_CA", "French sa Canada" },
            { "KP", "Hilagang Korea" },
            { "KR", "Timog Korea" },
            { "fr_CH", "Swiss na French" },
            { "KW", "Kuwait" },
            { "tpi", "Tok Pisin" },
            { "KY", "Cayman Islands" },
            { "KZ", "Kazakhstan" },
            { "Cyrl", "Cyrillic" },
            { "LA", "Laos" },
            { "LB", "Lebanon" },
            { "LC", "Saint Lucia" },
            { "gwi", "Gwich\u02bcin" },
            { "nds", "Low German" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lithuania" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "Kana", "Katakana" },
            { "LY", "Libya" },
            { "lad", "Ladino" },
            { "vun", "Vunjo" },
            { "lag", "Langi" },
            { "Thaa", "Thaana" },
            { "MA", "Morocco" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagascar" },
            { "Thai", metaValue_th },
            { "MH", "Marshall Islands" },
            { "ale", "Aleut" },
            { "type.nu.vaii", "Mga Vai na Digit" },
            { "MK", "Macedonia" },
            { "type.nu.mathdbl", "Matematikal na Dobleng-Struck na Mga Digit" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "Newari" },
            { "MO", "Macau SAR China" },
            { "MP", "Northern Mariana Islands" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "type.m0.ungegn", "UN GEGN na Transliteration" },
            { "MU", "Mauritius" },
            { "alt", "Southern Altai" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "Kalendaryong Japanese" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "202", "Sub-Saharan Africa" },
            { "type.ca.hebrew", "Hebrew na Kalendaryo" },
            { "type.co.dictionary", "Pagkakasunud-sunod ng Pag-uuri ng Diksyunaryo" },
            { "NC", "New Caledonia" },
            { "%%WADEGILE", "Wade-Giles Romanization" },
            { "NE", "Niger" },
            { "NF", "Norfolk Island" },
            { "NG", "Nigeria" },
            { "trv", "Taroko" },
            { "NI", "Nicaragua" },
            { "NL", "Netherlands" },
            { "NO", "Norway" },
            { "NP", "Nepal" },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "rof", "Rombo" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "anp", "Angika" },
            { "crs", "Seselwa Creole French" },
            { "type.nu.hmng", "Pahawh Hmong na Mga Digit" },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "Kalendaryong Islamic-Civil" },
            { "en_GB", "Ingles na British" },
            { "PE", "Peru" },
            { "PF", "French Polynesia" },
            { "PG", "Papua New Guinea" },
            { "PH", "Pilipinas" },
            { "PK", "Pakistan" },
            { "PL", "Poland" },
            { "ewo", "Ewondo" },
            { "PM", "St. Pierre & Miquelon" },
            { "PN", "Pitcairn Islands" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestinian Territories" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "Nias" },
            { "type.nu.greklow", "Greek Lowercase na Mga Numeral" },
            { "PY", "Paraguay" },
            { "tum", "Tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "niu", "Niuean" },
            { "QO", "Outlying Oceania" },
            { "lez", "Lezghian" },
            { "type.nu.ahom", "Ahom na mga Digit" },
            { "tvl", metaValue_TV },
            { "001", "Mundo" },
            { "002", "Africa" },
            { "003", "Hilagang Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "Timog Amerika" },
            { "jbo", "Lojban" },
            { "009", "Oceania" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russia" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Solomon Islands" },
            { "twq", "Tasawaq" },
            { "011", "Kanlurang Africa" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "013", "Gitnang Amerika" },
            { "SE", "Sweden" },
            { "014", "Silangang Africa" },
            { "015", "Hilagang Africa" },
            { "SG", "Singapore" },
            { "SH", "St. Helena" },
            { "type.lb.strict", "Mahigpit na Istilo ng Line Break" },
            { "017", "Gitnang Africa" },
            { "SI", "Slovenia" },
            { "type.nu.mymrtlng", "Myanmar Tai Laing na Mga Digit" },
            { "018", "Katimugang Africa" },
            { "SJ", "Svalbard & Jan Mayen" },
            { "019", "Americas" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "type.nu.taml", "Tamil na Mga Numeral" },
            { "SR", "Suriname" },
            { "SS", "Timog Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 & Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "SZ", "Swaziland" },
            { "TA", "Tristan de Cunha" },
            { "asa", "Asu" },
            { "type.ms.ussystem", "Sistema ng Pagsukat sa US" },
            { "021", "Northern America" },
            { "TC", "Turks & Caicos Islands" },
            { "yav", "Yangben" },
            { "TD", "Chad" },
            { "TF", "French Southern Territories" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "029", "Carribbean" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "ybb", "Yemba" },
            { "type.co.searchjl", "Maghanap Ayon sa Unang Katinig ng Hangul" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Turkey" },
            { "TT", "Trinidad & Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "ast", "Asturian" },
            { "TZ", "Tanzania" },
            { "nmg", "Kwasio" },
            { "Zzzz", "Hindi Kilalang Script" },
            { "UA", "Ukraine" },
            { "rup", "Aromanian" },
            { "030", "Silangang Asya" },
            { "tyv", "Tuvinian" },
            { "sw_CD", "Congo Swahili" },
            { "034", "Katimugang Asya" },
            { "035", "Timog-Silangang Asya" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "Pagkakasunud-sunod ng Pag-uuri ng Pinyin" },
            { "039", "Katimugang Europe" },
            { "Sinh", metaValue_si },
            { "UM", "U.S. Outlying Islands" },
            { "UN", "United Nations" },
            { "US", "Estados Unidos" },
            { "haw", "Hawaiian" },
            { "type.co.gb2312han", "Pagkakasunud-sunod ng Pag-uuri ng Pinasimpleng Chinese - GB2312" },
            { "UY", "Uruguay" },
            { "prg", "Prussian" },
            { "UZ", "Uzbekistan" },
            { "tzm", "Central Atlas Tamazight" },
            { "type.co.stroke", "Pagkakasunud-sunod ng Pag-uuri ng Stroke" },
            { "nnh", "Ngiemboon" },
            { "VA", "Vatican City" },
            { "VC", "St. Vincent & Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "British Virgin Islands" },
            { "VI", "U.S. Virgin Islands" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "Nogai" },
            { "rwk", "Rwa" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "WF", "Wallis & Futuna" },
            { "type.co.traditional", "Tradisyunal na Pagkakasunud-sunod ng Pag-uuri" },
            { "057", "Rehiyon ng Micronesia" },
            { "jgo", "Ngomba" },
            { "lkt", "Lakota" },
            { "type.nu.finance", "Mga Pampinansyang Numeral" },
            { "type.co.compat", "Nakaraang Pagkakasunud-sunod ng Pag-uuri, para sa compatibility" },
            { "wae", "Walser" },
            { "WS", "Samoa" },
            { "type.nu.mtei", "Meetei Mayek na Mga Digit" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "awa", "Awadhi" },
            { "061", "Polynesia" },
            { "XK", "Kosovo" },
            { "type.nu.brah", "Brahmi na Mga Digit" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "Hindi Nakasulat" },
            { "wbp", "Warlpiri" },
            { "YE", "Yemen" },
            { "nqo", "N\u2019Ko" },
            { "type.co.standard", "Karaniwang Pagkakasunud-sunod ng Ayos" },
            { "YT", "Mayotte" },
            { "type.nu.cham", "Cham na Mga Digit" },
            { "ZA", "South Africa" },
            { "type.lb.loose", "Loose na Istilo ng Line Break" },
            { "Deva", "Devanagari" },
            { "type.nu.geor", "Georgian na Mga Numeral" },
            { "type.co.zhuyin", "Zhuyin na Pagkakasunud-sunod ng Pag-uuri" },
            { "Hira", "Hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "Pinyin Romanization" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Hindi Kilalang Rehiyon" },
            { "type.ms.metric", "Metrikong Sistema" },
            { "type.ca.iso8601", "ISO-8601 na Kalendaryo" },
            { "nso", "Hilagang Sotho" },
            { "type.nu.telu", "Mga Telugu na Digit" },
            { "lou", "Louisiana Creole" },
            { "loz", "Lozi" },
            { "jmc", "Machame" },
            { "type.nu.hansfin", "Simplified Chinese na Mga Numeral para sa Pananalapi" },
            { "hil", "Hiligaynon" },
            { "type.nu.arabext", "Extendend Arabic-Indic na Mga Digit" },
            { "nus", "Nuer" },
            { "dak", "Dakota" },
            { "type.nu.fullwide", "Mga Full-Width Digit" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "lrc", "Hilagang Luri" },
            { "type.co.emoji", "Pagkakasunud-sunod ng Pag-uuri ng Emoji" },
            { "udm", "Udmurt" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "Kalendaryong Islamiko (Saudi Arabia, sighting)" },
            { "sad", "Sandawe" },
            { "type.nu.roman", "Mga Roman Numeral" },
            { "sah", "Sakha" },
            { "saq", "Samburu" },
            { "sat", "Santali" },
            { "type.d0.npinyin", "Numeric" },
            { "type.nu.native", "Mga Native na Digit" },
            { "sba", "Ngambay" },
            { "Guru", "Gurmukhi" },
            { "lua", "Luba-Lulua" },
            { "type.d0.fwidth", "Hanggang sa Fullwidth" },
            { "sbp", "Sangu" },
            { "nyn", "Nyankole" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "fil", "Filipino" },
            { "hmn", "Hmong" },
            { "lus", "Mizo" },
            { "ban", "Balinese" },
            { "luy", "Luyia" },
            { "bas", "Basaa" },
            { "es_ES", "European Spanish" },
            { "sco", "Scots" },
            { "scn", "Sicilian" },
            { "aa", "Afar" },
            { "ab", "Abkhazian" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "type.nu.cakm", "Chakma na Mga Digit" },
            { "am", "Amharic" },
            { "Arab", metaValue_ar },
            { "an", "Aragonese" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "Japanese syllabaries" },
            { "as", "Assamese" },
            { "av", "Avaric" },
            { "sdh", "Katimugang Kurdish" },
            { "ay", "Aymara" },
            { "az", "Azerbaijani" },
            { "ba", "Bashkir" },
            { "type.co.unihan", "Pagkakasunud-sunod ng Pag-uuri ng Radical-Stroke" },
            { "be", "Belarusian" },
            { "bg", "Bulgarian" },
            { "bi", "Bislama" },
            { "type.nu.java", "Javanese na Mga Digit" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "Dogrib" },
            { "br", "Breton" },
            { "bs", "Bosnian" },
            { "Mymr", "Myanmar" },
            { "type.nu.laoo", "Mga Lao na Digit" },
            { "seh", "Sena" },
            { "ca", "Catalan" },
            { "ses", "Koyraboro Senni" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Corsican" },
            { "Orya", metaValue_or },
            { "cs", "Czech" },
            { "cu", "Church Slavic" },
            { "cv", "Chuvash" },
            { "cy", "Welsh" },
            { "type.nu.ethi", "Mga Ethiopic Numeral" },
            { "da", "Danish" },
            { "pt_PT", "European Portuguese" },
            { "de", "German" },
            { "type.cf.standard", "Karaniwang Format ng Pera" },
            { "bem", "Bemba" },
            { "type.nu.mong", "Mongolian Digits" },
            { "dv", "Divehi" },
            { "es_419", "Latin American na Espanyol" },
            { "dz", "Dzongkha" },
            { "bez", "Bena" },
            { "type.ca.chinese", "Kalendaryong Chinese" },
            { "dje", "Zarma" },
            { "type.nu.grek", "Greek na Mga Numeral" },
            { "ee", "Ewe" },
            { "type.lb.normal", "Normal na Istilo ng Line Break" },
            { "ro_MD", "Moldavian" },
            { "el", metaValue_el },
            { "en", "Ingles" },
            { "eo", "Esperanto" },
            { "type.co.big5han", "Pagkakasunod-sunod ng Pag-uuri ng Tradisyunal na Chinese - Big5" },
            { "es", "Spanish" },
            { "et", "Estonian" },
            { "Hanb", "Hanb" },
            { "eu", "Basque" },
            { "Hang", "Hangul" },
            { "shi", "Tachelhit" },
            { "hsb", "Upper Sorbian" },
            { "Hani", "Han" },
            { "shn", "Shan" },
            { "fa", "Persian" },
            { "Hans", "Pinasimple" },
            { "type.nu.latn", "Mga Kanluraning Digit" },
            { "Hant", "Tradisyonal" },
            { "ff", "Fulah" },
            { "fi", "Finnish" },
            { "fj", "Fijian" },
            { "fon", "Fon" },
            { "bgn", "Kanlurang Balochi" },
            { "yue", "Cantonese" },
            { "fo", "Faroese" },
            { "type.m0.bgn", "US BGN na Transliteration" },
            { "umb", "Umbundu" },
            { "fr", "French" },
            { "fy", "Kanlurang Frisian" },
            { "ga", "Irish" },
            { "gd", "Scottish Gaelic" },
            { "gl", "Galician" },
            { "gn", "Guarani" },
            { "bho", "Bhojpuri" },
            { "und", "Hindi Kilalang Wika" },
            { "type.ca.ethiopic-amete-alem", "Kalendaryong Ethiopic Amete Alem" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "Kalendaryong Islamiko (tabular, astronomikal na epoch)" },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hup", "Hupa" },
            { "bin", "Bini" },
            { "hr", "Croatian" },
            { "ht", "Haitian" },
            { "hu", "Hungarian" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "frc", "Cajun French" },
            { "ia", "Interlingua" },
            { "Jamo", "Jamo" },
            { "id", "Indonesian" },
            { "type.nu.tibt", "Mga Tibetan na Digit" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "io", "Ido" },
            { "is", "Icelandic" },
            { "it", "Italian" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "type.nu.lepc", "Lepcha Mga Digit" },
            { "sma", "Katimugang Sami" },
            { "jv", "Javanese" },
            { "mad", "Madurese" },
            { "smj", "Lule Sami" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "smn", "Inari Sami" },
            { "ka", metaValue_ka },
            { "bla", "Siksika" },
            { "mak", "Makasar" },
            { "sms", "Skolt Sami" },
            { "kg", "Kongo" },
            { "ki", "Kikuyu" },
            { "mas", "Masai" },
            { "kj", "Kuanyama" },
            { "kk", "Kazakh" },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmiri" },
            { "ku", "Kurdish" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirghiz" },
            { "snk", "Soninke" },
            { "la", metaValue_la },
            { "lb", "Luxembourgish" },
            { "type.nu.mlym", "Mga Malayalam na Digit" },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "Tibt", metaValue_bo },
            { "ln", "Lingala" },
            { "fur", "Friulian" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "Sistemang Imperial na Pagsukat" },
            { "type.nu.lana", "Tai Tham Hora na Mga Digit" },
            { "lt", "Lithuanian" },
            { "lu", "Luba-Katanga" },
            { "lv", "Latvian" },
            { "mg", "Malagasy" },
            { "mh", "Marshallese" },
            { "type.co.ducet", "Default na Pagkakasunud-sunod ng Ayos ng Unicode" },
            { "mi", "Maori" },
            { "mk", "Macedonian" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malay" },
            { "mt", "Maltese" },
            { "my", "Burmese" },
            { "Armn", metaValue_hy },
            { "mdf", "Moksha" },
            { "dsb", "Lower Sorbian" },
            { "na", metaValue_NR },
            { "type.co.search", "Pangkalahatang Paghahanap" },
            { "nb", "Norwegian Bokm\u00e5l" },
            { "nd", "Hilagang Ndebele" },
            { "ne", "Nepali" },
            { "ng", "Ndonga" },
            { "nl", "Dutch" },
            { "nn", "Norwegian Nynorsk" },
            { "no", "Norwegian" },
            { "nr", "South Ndebele" },
            { "type.nu.modi", "Modi na Mga Digit" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "kac", "Kachin" },
            { "kab", "Kabyle" },
            { "oc", "Occitan" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "men", "Mende" },
            { "mer", "Meru" },
            { "type.nu.armn", "Mga Armenian Numeral" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetic" },
            { "kbd", "Kabardian" },
            { "mfe", "Morisyen" },
            { "srn", "Sranan Tongo" },
            { "pa", "Punjabi" },
            { "dua", "Duala" },
            { "pl", "Polish" },
            { "type.ca.dangi", "Dangi na Kalendaryo" },
            { "ps", "Pashto" },
            { "pt", "Portuguese" },
            { "key.co", "Pagkakasunud-sunod ng Ayos" },
            { "pt_BR", "Portuges ng Brasil" },
            { "kcg", "Tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "Format ng Pera" },
            { "type.nu.nkoo", "N\u2019Ko na Mga Digit" },
            { "key.ca", "Kalendaryo" },
            { "Laoo", metaValue_lo },
            { "mgo", "Meta\u2019" },
            { "type.hc.h23", "24 na Oras na Sistema (0\u201323)" },
            { "type.hc.h24", "24 na Oras na Sistema (1\u201324)" },
            { "ssy", "Saho" },
            { "type.nu.mymr", "Mga Myanmar na Digit" },
            { "qu", "Quechua" },
            { "brx", "Bodo" },
            { "kde", "Makonde" },
            { "Ethi", "Ethiopic" },
            { "type.hc.h12", "12 Oras na Sistema (1\u201312)" },
            { "type.hc.h11", "12 Oras na Sistema (0\u201311)" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "key.cu", "Pera" },
            { "ro", "Romanian" },
            { "type.nu.orya", "Mga Oriya na Digit" },
            { "type.nu.hanidec", "Mga Chinese Decimal na Numeral" },
            { "ru", "Russian" },
            { "rw", "Kinyarwanda" },
            { "kea", "Kabuverdianu" },
            { "mic", "Micmac" },
            { "suk", "Sukuma" },
            { "en_AU", "Ingles ng Australya" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinian" },
            { "sd", "Sindhi" },
            { "se", "Hilagang Sami" },
            { "min", "Minangkabau" },
            { "sg", "Sango" },
            { "sh", "Serbo-Croatian" },
            { "si", metaValue_si },
            { "sk", "Slovak" },
            { "sl", "Slovenian" },
            { "sm", "Samoan" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "type.nu.arab", "Arabic-Indic na Mga Digit" },
            { "sq", "Albanian" },
            { "sr", "Serbian" },
            { "ss", "Swati" },
            { "type.cf.account", "Format ng Pera sa Accounting" },
            { "st", "Katimugang Sotho" },
            { "su", "Sundanese" },
            { "sv", "Swedish" },
            { "sw", "Swahili" },
            { "type.nu.hantfin", "Traditional Chinese na Mga Numeral para sa Pananalapi" },
            { "ibb", "Ibibio" },
            { "iba", "Iban" },
            { "ta", metaValue_ta },
            { "142", "Asya" },
            { "143", "Gitnang Asya" },
            { "te", metaValue_te },
            { "145", "Kanlurang Asya" },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "ti", "Tigrinya" },
            { "bug", "Buginese" },
            { "kfo", "Koro" },
            { "en_CA", "Ingles sa Canada" },
            { "tk", "Turkmen" },
            { "tl", "Tagalog" },
            { "tn", "Tswana" },
            { "to", "Tongan" },
            { "dyo", "Jola-Fonyi" },
            { "type.nu.jpan", "Mga Japanese Numeral" },
            { "tr", "Turkish" },
            { "ts", "Tsonga" },
            { "swb", "Comorian" },
            { "tt", "Tatar" },
            { "tw", "Twi" },
            { "ty", "Tahitian" },
            { "150", "Europe" },
            { "151", "Silangang Europe" },
            { "type.nu.mathsanb", "Matematikal na Sans-Serif Bold na Mga Digit" },
            { "154", "Hilagang Europe" },
            { "dzg", "Dazaga" },
            { "155", "Kanlurang Europe" },
            { "ug", "Uyghur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "Karaniwan" },
            { "uk", "Ukranian" },
            { "type.ca.coptic", "Coptic Calendar" },
            { "ur", "Urdu" },
            { "xal", "Kalmyk" },
            { "uz", "Uzbek" },
            { "kha", "Khasi" },
            { "nds_NL", "Low Saxon" },
            { "ve", "Venda" },
            { "type.ca.roc", "Kalendaryong Minguo" },
            { "vi", "Vietnamese" },
            { "khq", "Koyra Chiini" },
            { "key.hc", "Siklo ng Oras (12 laban sa 24)" },
            { "vo", "Volap\u00fck" },
            { "type.nu.mathsans", "Matematikal na Sans-Serif na Mga Digit" },
            { "quc", "K\u02bciche\u02bc" },
            { "type.nu.gonm", "Masaram Gondi na mga digit" },
            { "gaa", "Ga" },
            { "wa", "Walloon" },
            { "gag", "Gagauz" },
            { "syr", "Syriac" },
            { "Grek", metaValue_el },
            { "wo", "Wolof" },
            { "zgh", "Standard Moroccan Tamazight" },
            { "ar_001", "Modernong Karaniwang Arabic" },
            { "Mong", metaValue_mn },
            { "mni", "Manipuri" },
            { "Latn", metaValue_la },
            { "type.nu.hans", "Simplified Chinese na Mga Numeral" },
            { "type.nu.hant", "Traditional Chinese na Mga Numeral" },
            { "xh", "Xhosa" },
            { "type.nu.romanlow", "Roman Lowercase na Mga Numeral" },
            { "byn", "Blin" },
            { "moh", "Mohawk" },
            { "kkj", "Kako" },
            { "yi", "Yiddish" },
            { "mos", "Mossi" },
            { "yo", "Yoruba" },
            { "type.nu.traditional", "Mga Tradisyunal na Numeral" },
            { "es_MX", "Mexican na Espanyol" },
            { "vai", "Vai" },
            { "kln", "Kalenjin" },
            { "zh", "Chinese" },
            { "Bopo", "Bopomofo" },
            { "key.lb", "Istilo ng Putol ng Linya" },
            { "zu", "Zulu" },
            { "type.co.phonebook", "Pagkakasunud-sunod ng Pag-uuri ng Phonebook" },
            { "Geor", metaValue_ka },
            { "kmb", "Kimbundu" },
            { "type.nu.jpanfin", "Mga Japanese Numeral sa Pananalapi" },
            { "gez", "Geez" },
            { "type.nu.mymrshan", "Maynmar Shan na Mga Digit" },
            { "type.co.reformed", "Pagkakasunud-sunod ng Pag-uuri ng Na-reform" },
            { "ebu", "Embu" },
            { "zh_Hans", "Pinasimpleng Chinese" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani" },
            { "type.nu.limb", "Limbu na Mga Digit" },
            { "zh_Hant", "Tradisyonal na Chinese" },
            { "kpe", "Kpelle" },
            { "type.nu.khmr", "Mga Khmer na Digit" },
            { "ilo", "Iloko" },
            { "mua", "Mundang" },
            { "type.nu.guru", "Mga Gurmukhi Digit" },
            { "mul", "Maramihang Wika" },
            { "key.ms", "Sistema ng Pagsukat" },
            { "mus", "Creek" },
            { "gil", "Gilbertese" },
            { "type.nu.tamldec", "Mga Tamil na Digit" },
            { "krc", "Karachay-Balkar" },
            { "inh", "Ingush" },
            { "krl", "Karelian" },
            { "efi", "Efik" },
            { "key.nu", "Mga Numero" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "Telu", metaValue_te },
            { "ksf", "Bafia" },
        };
        return data;
    }
}
