/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.httpclient;

public class RetryConfig {
    private final int maxRetries;
    private final long initialBackoffMillis;
    private final double backoffMultiplier;
    private final boolean useJitter;
    private final double jitterFactor;
    private final int connectionTimeoutMillis;
    private final int socketTimeoutMillis;

    private RetryConfig(Builder builder) {
        this.maxRetries = builder.maxRetries;
        this.initialBackoffMillis = builder.initialBackoffMillis;
        this.backoffMultiplier = builder.backoffMultiplier;
        this.useJitter = builder.useJitter;
        this.jitterFactor = builder.jitterFactor;
        this.connectionTimeoutMillis = builder.connectionTimeoutMillis;
        this.socketTimeoutMillis = builder.socketTimeoutMillis;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public long getInitialBackoffMillis() {
        return this.initialBackoffMillis;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public int getConnectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    public int getSocketTimeoutMillis() {
        return this.socketTimeoutMillis;
    }

    public boolean isUseJitter() {
        return this.useJitter;
    }

    public double getJitterFactor() {
        return this.jitterFactor;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RetryConfig that = (RetryConfig)obj;
        if (this.maxRetries != that.maxRetries) {
            return false;
        }
        if (this.initialBackoffMillis != that.initialBackoffMillis) {
            return false;
        }
        if (Double.compare(this.backoffMultiplier, that.backoffMultiplier) != 0) {
            return false;
        }
        if (this.useJitter != that.useJitter) {
            return false;
        }
        if (Double.compare(this.jitterFactor, that.jitterFactor) != 0) {
            return false;
        }
        if (this.connectionTimeoutMillis != that.connectionTimeoutMillis) {
            return false;
        }
        return this.socketTimeoutMillis == that.socketTimeoutMillis;
    }

    public int hashCode() {
        int result = this.maxRetries;
        result = 31 * result + (int)(this.initialBackoffMillis ^ this.initialBackoffMillis >>> 32);
        long temp = Double.doubleToLongBits(this.backoffMultiplier);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.useJitter ? 1 : 0);
        temp = Double.doubleToLongBits(this.jitterFactor);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.connectionTimeoutMillis;
        result = 31 * result + this.socketTimeoutMillis;
        return result;
    }

    public static class Builder {
        private int maxRetries = 0;
        private long initialBackoffMillis = 1000L;
        private double backoffMultiplier = 2.0;
        private boolean useJitter = true;
        private double jitterFactor = 0.5;
        private int connectionTimeoutMillis = 10000;
        private int socketTimeoutMillis = 10000;

        public Builder maxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder initialBackoffMillis(long initialBackoffMillis) {
            this.initialBackoffMillis = initialBackoffMillis;
            return this;
        }

        public Builder backoffMultiplier(double backoffMultiplier) {
            this.backoffMultiplier = backoffMultiplier;
            return this;
        }

        public Builder connectionTimeoutMillis(int connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public Builder socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
            return this;
        }

        public Builder useJitter(boolean useJitter) {
            this.useJitter = useJitter;
            return this;
        }

        public Builder jitterFactor(double jitterFactor) {
            this.jitterFactor = jitterFactor;
            return this;
        }

        public RetryConfig build() {
            return new RetryConfig(this);
        }
    }
}

