/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.vertx;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.quarkus.micrometer.runtime.binder.vertx.NetworkMetrics;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;

public class VertxUdpMetrics
implements DatagramSocketMetrics {
    private volatile Tags tags;
    private final Meter.MeterProvider<DistributionSummary> read;
    private final Meter.MeterProvider<DistributionSummary> sent;
    private final Meter.MeterProvider<Counter> exceptions;

    public VertxUdpMetrics(MeterRegistry registry, String prefix, Tags tags) {
        this.tags = tags;
        this.read = DistributionSummary.builder((String)(prefix + ".bytes.read")).description("Number of bytes read").withRegistry(registry);
        this.sent = DistributionSummary.builder((String)(prefix + ".bytes.written")).description("Number of bytes written").withRegistry(registry);
        this.exceptions = Counter.builder((String)(prefix + ".errors")).description("Number of exceptions").withRegistry(registry);
    }

    public void listening(String localName, SocketAddress localAddress) {
        this.tags = this.tags.and("address", NetworkMetrics.toString(localAddress));
    }

    public void bytesRead(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        ((DistributionSummary)this.read.withTags((Iterable)this.tags.and("remote-address", NetworkMetrics.toString(remoteAddress)))).record((double)numberOfBytes);
    }

    public void bytesWritten(Void socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        ((DistributionSummary)this.sent.withTags((Iterable)this.tags.and("remote-address", NetworkMetrics.toString(remoteAddress)))).record((double)numberOfBytes);
    }

    public void exceptionOccurred(Void socketMetric, SocketAddress remoteAddress, Throwable t) {
        Tags copy = this.tags.and(new Tag[]{Tag.of((String)"class", (String)t.getClass().getName())});
        ((Counter)this.exceptions.withTags((Iterable)copy)).increment();
    }
}

