/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.net.ServerSocketFactory;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.Util;

public class NamedSocketFactory
implements SocketFactory {
    private final Supplier<javax.net.SocketFactory> socketFactory;
    private final Supplier<ServerSocketFactory> serverSocketFactory;
    private String name;
    private BiConsumer<String, Socket> socketConfigurator;
    private BiConsumer<String, ServerSocket> serverSocketConfigurator;

    public NamedSocketFactory(Supplier<javax.net.SocketFactory> socketFactory, Supplier<ServerSocketFactory> serverSocketFactory) {
        this.socketConfigurator = (c, s) -> {};
        this.serverSocketConfigurator = (c, s) -> {};
        this.socketFactory = socketFactory;
        this.serverSocketFactory = serverSocketFactory;
    }

    NamedSocketFactory(NamedSocketFactory original, String name) {
        this.socketConfigurator = (c, s) -> {};
        this.serverSocketConfigurator = (c, s) -> {};
        this.socketFactory = original.socketFactory;
        this.serverSocketFactory = original.serverSocketFactory;
        this.socketConfigurator = original.socketConfigurator;
        this.serverSocketConfigurator = original.serverSocketConfigurator;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private Socket configureSocket(Socket socket) {
        this.socketConfigurator.accept(this.name, socket);
        return socket;
    }

    private ServerSocket configureSocket(ServerSocket socket) {
        this.serverSocketConfigurator.accept(this.name, socket);
        return socket;
    }

    public Socket createSocket(String s) throws IOException {
        return this.configureSocket(this.socketFactory.get().createSocket());
    }

    public Socket createSocket(String s, String host, int port) throws IOException {
        return this.configureSocket(this.socketFactory.get().createSocket(host, port));
    }

    public Socket createSocket(String s, InetAddress host, int port) throws IOException {
        return this.configureSocket(this.socketFactory.get().createSocket(host, port));
    }

    public Socket createSocket(String s, String host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.configureSocket(this.socketFactory.get().createSocket(host, port, localHost, localPort));
    }

    public Socket createSocket(String s, InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
        return this.configureSocket(this.socketFactory.get().createSocket(host, port, localHost, localPort));
    }

    public ServerSocket createServerSocket(String s) throws IOException {
        return this.configureSocket(this.serverSocketFactory.get().createServerSocket());
    }

    public ServerSocket createServerSocket(String s, int port) throws IOException {
        return this.configureSocket(this.serverSocketFactory.get().createServerSocket(port));
    }

    public ServerSocket createServerSocket(String s, int port, int backlog) throws IOException {
        return this.configureSocket(this.serverSocketFactory.get().createServerSocket(port, backlog));
    }

    public ServerSocket createServerSocket(String s, int port, int backlog, InetAddress bindAddress) throws IOException {
        return this.configureSocket(this.serverSocketFactory.get().createServerSocket(port, backlog, bindAddress));
    }

    public DatagramSocket createDatagramSocket(String service_name) throws SocketException {
        return new DatagramSocket();
    }

    public DatagramSocket createDatagramSocket(String service_name, SocketAddress bindaddr) throws SocketException {
        return new DatagramSocket(bindaddr);
    }

    public DatagramSocket createDatagramSocket(String service_name, int port) throws SocketException {
        return new DatagramSocket(port);
    }

    public DatagramSocket createDatagramSocket(String service_name, int port, InetAddress laddr) throws SocketException {
        return new DatagramSocket(port, laddr);
    }

    public MulticastSocket createMulticastSocket(String service_name) throws IOException {
        return new MulticastSocket();
    }

    public MulticastSocket createMulticastSocket(String service_name, int port) throws IOException {
        return new MulticastSocket(port);
    }

    public MulticastSocket createMulticastSocket(String service_name, SocketAddress bindaddr) throws IOException {
        return new MulticastSocket(bindaddr);
    }

    public void close(Socket socket) throws IOException {
        Util.close((Closeable)socket);
    }

    public void close(ServerSocket serverSocket) throws IOException {
        Util.close((Closeable)serverSocket);
    }

    public void close(DatagramSocket datagramSocket) {
        Util.close((Closeable)datagramSocket);
    }
}

