/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.url;

import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.urls.HostnameProvider;
import org.keycloak.urls.UrlType;
import org.keycloak.utils.StringUtil;

public class HostnameV2Provider
implements HostnameProvider {
    private final KeycloakSession session;
    private final String hostname;
    private final URI hostnameUrl;
    private final URI adminUrl;
    private final Boolean backchannelDynamic;
    private static final UrlType defaultUrlType = UrlType.FRONTEND;
    private final Logger logger = Logger.getLogger(HostnameV2Provider.class);

    public HostnameV2Provider(KeycloakSession session, String hostname, URI hostnameUrl, URI adminUrl, Boolean backchannelDynamic) {
        this.session = session;
        this.hostname = hostname;
        this.hostnameUrl = hostnameUrl;
        this.adminUrl = adminUrl;
        this.backchannelDynamic = backchannelDynamic;
    }

    public URI getBaseUri(UriInfo originalUriInfo, UrlType type) {
        UriBuilder builder;
        switch (type) {
            case ADMIN: {
                builder = this.getAdminUriBuilder(originalUriInfo);
                break;
            }
            case LOCAL_ADMIN: {
                builder = originalUriInfo.getBaseUriBuilder();
                builder.host("localhost");
                break;
            }
            case BACKEND: {
                builder = this.backchannelDynamic != false && !this.isFrontendRequest(originalUriInfo) ? originalUriInfo.getBaseUriBuilder() : this.getFrontUriBuilder(originalUriInfo);
                break;
            }
            case FRONTEND: {
                builder = this.getFrontUriBuilder(originalUriInfo);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown URL type");
            }
        }
        URI uri = builder.build(new Object[0]);
        int normalizedPort = this.normalizedPort(uri);
        if (normalizedPort != uri.getPort()) {
            builder.port(normalizedPort);
            uri = builder.build(new Object[0]);
        }
        return uri;
    }

    private int normalizedPort(URI uri) {
        if (uri.getScheme().equals("http") && uri.getPort() == 80 || uri.getScheme().equals("https") && uri.getPort() == 443) {
            return -1;
        }
        return uri.getPort();
    }

    private boolean isFrontendRequest(UriInfo originalUriInfo) {
        URI frontend = this.getFrontUriBuilder(originalUriInfo).build(new Object[0]);
        return frontend.getScheme().equals(originalUriInfo.getBaseUri().getScheme()) && frontend.getHost().equals(originalUriInfo.getBaseUri().getHost()) && frontend.getPort() == this.normalizedPort(originalUriInfo.getBaseUri());
    }

    private UriBuilder getFrontUriBuilder(UriInfo originalUriInfo) {
        UriBuilder builder = this.getRealmFrontUriBuilder();
        if (builder != null) {
            return builder;
        }
        if (this.hostnameUrl != null) {
            builder = UriBuilder.fromUri((URI)this.hostnameUrl);
        } else {
            builder = originalUriInfo.getBaseUriBuilder();
            if (this.hostname != null) {
                builder.host(this.hostname);
            }
        }
        return builder;
    }

    private UriBuilder getRealmFrontUriBuilder() {
        return Optional.ofNullable(this.session).map(s -> s.getContext()).map(c -> c.getRealm()).map(r -> r.getAttribute("frontendUrl")).filter(url -> StringUtil.isNotBlank((String)url)).filter(url -> {
            try {
                UriUtils.checkUrl((SslRequired)SslRequired.NONE, (String)url, (String)"Realm frontendUrl");
            }
            catch (IllegalArgumentException e) {
                this.logger.errorf((Throwable)e, "Failed to parse realm frontendUrl '%s'. Falling back to global value.", url);
                return false;
            }
            return true;
        }).map(UriBuilder::fromUri).orElse(null);
    }

    private UriBuilder getAdminUriBuilder(UriInfo originalUriInfo) {
        return this.adminUrl != null ? UriBuilder.fromUri((URI)this.adminUrl) : this.getFrontUriBuilder(originalUriInfo);
    }

    public String getScheme(UriInfo originalUriInfo, UrlType type) {
        return this.getBaseUri(originalUriInfo, type).getScheme();
    }

    public String getScheme(UriInfo originalUriInfo) {
        return this.getScheme(originalUriInfo, defaultUrlType);
    }

    public String getHostname(UriInfo originalUriInfo, UrlType type) {
        return this.getBaseUri(originalUriInfo, type).getHost();
    }

    public String getHostname(UriInfo originalUriInfo) {
        return this.getHostname(originalUriInfo, defaultUrlType);
    }

    public int getPort(UriInfo originalUriInfo, UrlType type) {
        return this.getBaseUri(originalUriInfo, type).getPort();
    }

    public int getPort(UriInfo originalUriInfo) {
        return this.getPort(originalUriInfo, defaultUrlType);
    }

    public String getContextPath(UriInfo originalUriInfo, UrlType type) {
        return this.getBaseUri(originalUriInfo, type).getPath();
    }

    public String getContextPath(UriInfo originalUriInfo) {
        return this.getContextPath(originalUriInfo, defaultUrlType);
    }
}

