/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.rc.tasks;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerUtil;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilerBuilder;
import org.gradle.language.rc.internal.DefaultWindowsResourceCompileSpec;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeCompileSpec;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;
import org.gradle.work.DisableCachingByDefault;
import org.gradle.work.Incremental;
import org.gradle.work.InputChanges;

@Incubating
@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class WindowsResourceCompile
extends DefaultTask {
    private File outputDir;
    private Map<String, String> macros = new LinkedHashMap<String, String>();
    private transient IncrementalCompilerBuilder.IncrementalCompiler incrementalCompiler;

    public WindowsResourceCompile() {
        this.getInputs().property("outputType", (Object)new Callable<String>(){

            @Override
            public String call() {
                NativeToolChainInternal nativeToolChain = (NativeToolChainInternal)WindowsResourceCompile.this.getToolChain().get();
                NativePlatformInternal nativePlatform = (NativePlatformInternal)WindowsResourceCompile.this.getTargetPlatform().get();
                return NativeToolChainInternal.Identifier.identify((NativeToolChainInternal)nativeToolChain, (NativePlatformInternal)nativePlatform);
            }
        });
    }

    private IncrementalCompilerBuilder.IncrementalCompiler getIncrementalCompiler() {
        if (this.incrementalCompiler == null) {
            this.incrementalCompiler = this.getIncrementalCompilerBuilder().newCompiler((TaskInternal)this, (FileCollection)this.getSource(), (FileCollection)this.getIncludes(), this.macros, (Provider<Boolean>)Providers.FALSE);
        }
        return this.incrementalCompiler;
    }

    @Inject
    public abstract IncrementalCompilerBuilder getIncrementalCompilerBuilder();

    @Inject
    public abstract BuildOperationLoggerFactory getOperationLoggerFactory();

    @TaskAction
    public void compile(InputChanges inputs) {
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        DefaultWindowsResourceCompileSpec spec = new DefaultWindowsResourceCompileSpec();
        spec.setTempDir(this.getTemporaryDir());
        spec.setObjectFileDir(this.getOutputDir());
        spec.include((Iterable)this.getIncludes());
        spec.source((Iterable)this.getSource());
        spec.setMacros(this.getMacros());
        spec.args((List)this.getCompilerArgs().get());
        spec.setIncrementalCompile(inputs.isIncremental());
        spec.setOperationLogger(operationLogger);
        NativeToolChainInternal nativeToolChain = (NativeToolChainInternal)this.getToolChain().get();
        NativePlatformInternal nativePlatform = (NativePlatformInternal)this.getTargetPlatform().get();
        PlatformToolProvider platformToolProvider = nativeToolChain.select(nativePlatform);
        WorkResult result = this.doCompile(spec, platformToolProvider);
        this.setDidWork(result.getDidWork());
    }

    private <T extends NativeCompileSpec> WorkResult doCompile(T spec, PlatformToolProvider platformToolProvider) {
        Class specType = (Class)Cast.uncheckedCast(spec.getClass());
        Compiler baseCompiler = platformToolProvider.newCompiler(specType);
        Compiler incrementalCompiler = this.getIncrementalCompiler().createCompiler(baseCompiler);
        Compiler loggingCompiler = BuildOperationLoggingCompilerDecorator.wrap(incrementalCompiler);
        return CompilerUtil.castCompiler((Compiler)loggingCompiler).execute(spec);
    }

    @Internal
    public abstract Property<NativeToolChain> getToolChain();

    @Nested
    public abstract Property<NativePlatform> getTargetPlatform();

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Incremental
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    public abstract ConfigurableFileCollection getIncludes();

    public void includes(Object includeRoots) {
        this.getIncludes().from(new Object[]{includeRoots});
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getSource();

    public void source(Object sourceFiles) {
        this.getSource().from(new Object[]{sourceFiles});
    }

    @Input
    public Map<String, String> getMacros() {
        return this.macros;
    }

    public void setMacros(Map<String, String> macros) {
        this.macros = macros;
    }

    @Input
    public abstract ListProperty<String> getCompilerArgs();

    @Incremental
    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    protected FileCollection getHeaderDependencies() {
        return this.getIncrementalCompiler().getHeaderFiles();
    }
}

