/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.relocation.AbstractElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.X86_64_ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.X86_64_ElfRelocationType;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationResult;
import ghidra.util.exception.NotFoundException;
import java.util.Map;

public class X86_64_ElfRelocationHandler
extends AbstractElfRelocationHandler<X86_64_ElfRelocationType, X86_64_ElfRelocationContext> {
    public X86_64_ElfRelocationHandler() {
        super(X86_64_ElfRelocationType.class);
    }

    public boolean canRelocate(ElfHeader elf) {
        return elf.e_machine() == 62;
    }

    public int getRelrRelocationType() {
        return X86_64_ElfRelocationType.R_X86_64_RELATIVE.typeId;
    }

    public X86_64_ElfRelocationContext createRelocationContext(ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        return new X86_64_ElfRelocationContext(this, loadHelper, symbolMap);
    }

    protected RelocationResult relocate(X86_64_ElfRelocationContext elfRelocationContext, ElfRelocation relocation, X86_64_ElfRelocationType type, Address relocationAddress, ElfSymbol sym, Address symbolAddr, long symbolValue, String symbolName) throws MemoryAccessException {
        Program program = elfRelocationContext.getProgram();
        Memory memory = program.getMemory();
        long addend = relocation.hasAddend() ? relocation.getAddend() : memory.getLong(relocationAddress);
        long offset = relocationAddress.getOffset();
        int symbolIndex = relocation.getSymbolIndex();
        int byteLength = 8;
        switch (type) {
            case R_X86_64_RELATIVE: 
            case R_X86_64_RELATIVE64: {
                long imageBaseAdjustment = elfRelocationContext.getImageBaseWordAdjustmentOffset();
                long value = elfRelocationContext.getElfHeader().isPreLinked() ? memory.getLong(relocationAddress) + imageBaseAdjustment : addend + imageBaseAdjustment;
                memory.setLong(relocationAddress, value);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_X86_64_IRELATIVE: {
                long value = addend + elfRelocationContext.getImageBaseWordAdjustmentOffset();
                memory.setLong(relocationAddress, value);
                return new RelocationResult(Relocation.Status.APPLIED, byteLength);
            }
            case R_X86_64_DTPMOD64: 
            case R_X86_64_DTPOFF64: 
            case R_X86_64_TPOFF64: 
            case R_X86_64_TLSDESC: {
                this.markAsWarning(program, relocationAddress, type, symbolName, symbolIndex, "Thread Local Symbol relocation not supported", elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
            case R_X86_64_COPY: {
                this.markAsUnsupportedCopy(program, relocationAddress, type, symbolName, symbolIndex, sym.getSize(), elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        if (this.handleUnresolvedSymbol((ElfRelocationContext)elfRelocationContext, relocation, relocationAddress)) {
            return RelocationResult.FAILURE;
        }
        switch (type) {
            case R_X86_64_64: {
                long value = symbolValue + addend;
                memory.setLong(relocationAddress, value);
                if (symbolIndex == 0 || addend == 0L || sym.isSection()) break;
                X86_64_ElfRelocationHandler.warnExternalOffsetRelocation((Program)program, (Address)relocationAddress, (Address)symbolAddr, (String)symbolName, (long)addend, (MessageLog)elfRelocationContext.getLog());
                X86_64_ElfRelocationHandler.applyComponentOffsetPointer((Program)program, (Address)relocationAddress, (long)addend);
                break;
            }
            case R_X86_64_16: {
                long value = symbolValue + addend;
                memory.setShort(relocationAddress, (short)(value &= 0xFFFFL));
                byteLength = 2;
                break;
            }
            case R_X86_64_8: {
                long value = symbolValue + addend;
                memory.setByte(relocationAddress, (byte)(value &= 0xFFL));
                byteLength = 1;
                break;
            }
            case R_X86_64_PC32: {
                long value = symbolValue + addend - offset;
                memory.setInt(relocationAddress, (int)(value &= 0xFFFFFFFFFFFFFFFFL));
                byteLength = 4;
                break;
            }
            case R_X86_64_PC16: {
                long value = symbolValue + addend - offset;
                memory.setShort(relocationAddress, (short)(value &= 0xFFFFL));
                byteLength = 2;
                break;
            }
            case R_X86_64_PC8: {
                long value = symbolValue + addend - offset;
                memory.setByte(relocationAddress, (byte)(value &= 0xFFL));
                byteLength = 1;
                break;
            }
            case R_X86_64_GOT32: {
                long value = symbolValue + addend;
                memory.setInt(relocationAddress, (int)value);
                byteLength = 4;
                break;
            }
            case R_X86_64_PLT32: {
                long value = symbolValue + addend - offset;
                memory.setInt(relocationAddress, (int)value);
                byteLength = 4;
                break;
            }
            case R_X86_64_GLOB_DAT: 
            case R_X86_64_JUMP_SLOT: {
                long value = symbolValue + addend;
                memory.setLong(relocationAddress, value);
                break;
            }
            case R_X86_64_GOTOFF64: {
                try {
                    long dotgot = elfRelocationContext.getGOTValue();
                    long value = symbolValue + addend - dotgot;
                    memory.setLong(relocationAddress, value);
                    break;
                }
                catch (NotFoundException e) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "GOT allocation failure", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
            }
            case R_X86_64_32: 
            case R_X86_64_32S: {
                long value = (symbolValue += addend) & 0xFFFFFFFFFFFFFFFFL;
                memory.setInt(relocationAddress, (int)value);
                byteLength = 4;
                break;
            }
            case R_X86_64_SIZE32: {
                long value = sym.getSize() + addend;
                memory.setInt(relocationAddress, (int)(value &= 0xFFFFFFFFFFFFFFFFL));
                byteLength = 4;
                break;
            }
            case R_X86_64_SIZE64: {
                long value = sym.getSize() + addend;
                memory.setLong(relocationAddress, value);
                break;
            }
            case R_X86_64_GOTPC32: {
                try {
                    long dotgot = elfRelocationContext.getGOTValue();
                    long value = dotgot + addend - offset;
                    memory.setInt(relocationAddress, (int)value);
                    byteLength = 4;
                    break;
                }
                catch (NotFoundException e) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, e.getMessage(), elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
            }
            case R_X86_64_GOTPCRELX: 
            case R_X86_64_REX_GOTPCRELX: {
                Address opAddr = relocationAddress.subtract(2L);
                Address modRMAddr = relocationAddress.subtract(1L);
                Address directValueAddr = null;
                byte op = memory.getByte(opAddr);
                byte modRM = memory.getByte(modRMAddr);
                byte symbolType = sym.getType();
                if (symbolType >= 0 && symbolType <= 5) {
                    if (op == -117) {
                        elfRelocationContext.getLoadHelper().addArtificialRelocTableEntry(opAddr, 2);
                        memory.setByte(opAddr, (byte)-115);
                        directValueAddr = relocationAddress;
                    } else if (op == -1) {
                        if (modRM == 37) {
                            elfRelocationContext.getLoadHelper().addArtificialRelocTableEntry(opAddr, 2);
                            memory.setByte(opAddr, (byte)-23);
                            memory.setByte(relocationAddress.add(3L), (byte)-112);
                            directValueAddr = modRMAddr;
                            ++addend;
                        } else if (modRM == 21) {
                            elfRelocationContext.getLoadHelper().addArtificialRelocTableEntry(opAddr, 2);
                            memory.setByte(opAddr, (byte)103);
                            memory.setByte(modRMAddr, (byte)-24);
                            directValueAddr = relocationAddress;
                        }
                    }
                }
                if (directValueAddr != null) {
                    long value = symbolValue + addend - offset;
                    memory.setInt(directValueAddr, (int)value);
                    byteLength = 4;
                    break;
                }
            }
            case R_X86_64_GOTPCREL: {
                Address symbolGotAddress = elfRelocationContext.getGotEntryAddress(sym);
                if (symbolGotAddress == null) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "GOT allocation failure", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                long value = symbolGotAddress.getOffset() + addend - offset;
                memory.setInt(relocationAddress, (int)value);
                byteLength = 4;
                break;
            }
            case R_X86_64_GOTPCREL64: {
                Address symbolGotAddress = elfRelocationContext.getGotEntryAddress(sym);
                if (symbolGotAddress == null) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "GOT allocation failure", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                long value = symbolGotAddress.getOffset() + addend - offset;
                memory.setLong(relocationAddress, value);
                break;
            }
            case R_X86_64_GOT64: {
                Address symbolGotAddress = elfRelocationContext.getGotEntryAddress(sym);
                if (symbolGotAddress == null) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "GOT allocation failure", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                long value = symbolGotAddress.getOffset() + addend;
                memory.setLong(relocationAddress, value);
                break;
            }
            case R_X86_64_PLTOFF64: {
                long dotgot;
                try {
                    dotgot = elfRelocationContext.getGOTValue();
                }
                catch (NotFoundException e) {
                    this.markAsError(program, relocationAddress, type, symbolName, symbolIndex, "GOT allocation failure", elfRelocationContext.getLog());
                    return RelocationResult.FAILURE;
                }
                long value = symbolValue - dotgot + addend;
                memory.setLong(relocationAddress, value);
                break;
            }
            default: {
                this.markAsUnhandled(program, relocationAddress, type, symbolIndex, symbolName, elfRelocationContext.getLog());
                return RelocationResult.UNSUPPORTED;
            }
        }
        return new RelocationResult(Relocation.Status.APPLIED, byteLength);
    }
}

