/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;

public class CreateArrayCmd
implements Command<Program> {
    private String msg;
    private Address addr;
    private int numElements;
    private int elementLength;
    private DataType dataType;

    public CreateArrayCmd(Address addr, int numElements, DataType dt, int elementLength) {
        this.addr = addr;
        this.numElements = numElements;
        this.dataType = dt;
        this.elementLength = elementLength;
    }

    public boolean applyTo(Program program) {
        Listing listing = program.getListing();
        try {
            ArrayDataType adt = new ArrayDataType(this.dataType, this.numElements, this.elementLength, (DataTypeManager)program.getDataTypeManager());
            int length = adt.getLength();
            Address endAddr = this.addr.addNoWrap((long)(length - 1));
            AddressSet set = new AddressSet(this.addr, endAddr);
            InstructionIterator iter = listing.getInstructions((AddressSetView)set, true);
            if (iter.hasNext()) {
                this.msg = "Can't create data because the current selection contains instructions";
                return false;
            }
            listing.clearCodeUnits(this.addr, endAddr, false);
            listing.createData(this.addr, (DataType)adt, adt.getLength());
        }
        catch (AddressOverflowException e1) {
            this.msg = "Can't create data because length exceeds address space";
            return false;
        }
        catch (CodeUnitInsertionException | IllegalArgumentException e) {
            this.msg = e.getMessage();
            return false;
        }
        catch (RuntimeException e) {
            this.msg = "Unexpected error: " + e.toString();
            Msg.error((Object)this, (Object)this.msg, (Throwable)e);
            return false;
        }
        return true;
    }

    public String getStatusMsg() {
        return this.msg;
    }

    public String getName() {
        return "Create Array";
    }
}

