/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.plugin.core.decompile.DecompilePlugin;
import ghidra.app.plugin.core.decompile.actions.ConvertConstantAction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.util.HelpLocation;
import ghidra.util.StringUtilities;

public class ConvertBinaryAction
extends ConvertConstantAction {
    public ConvertBinaryAction(DecompilePlugin plugin) {
        super(plugin, "Convert To Binary", 4);
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionConvert"));
        this.setPopupMenuData(new MenuData(new String[]{"Binary"}, "Decompile"));
    }

    @Override
    public String getMenuPrefix() {
        return "Binary: ";
    }

    @Override
    public String getMenuDisplay(long value, int size, boolean isSigned, Program program) {
        String bitString;
        int bitlen;
        long v;
        Scalar scalar = new Scalar(size * 8, value);
        String prefix = "0b";
        if (isSigned) {
            v = scalar.getSignedValue();
            if (v < 0L) {
                v = -v;
                prefix = "-0b";
            }
        } else {
            v = scalar.getUnsignedValue();
        }
        bitlen = (bitlen = (bitString = Long.toBinaryString(v)).length()) <= 8 ? 8 : (bitlen <= 16 ? 16 : (bitlen <= 32 ? 32 : 64));
        return prefix + StringUtilities.pad((String)bitString, (char)'0', (int)bitlen);
    }

    @Override
    public String getEquateName(long value, int size, boolean isSigned, Program program) {
        String valueStr = Long.toBinaryString(value);
        valueStr = StringUtilities.pad((String)valueStr, (char)'0', (int)(size * 8));
        return valueStr + "b";
    }
}

