/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.property;

import io.sf.carte.doc.DOMSyntaxException;
import io.sf.carte.doc.style.css.CSSCountersValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.property.AbstractCounterValue;
import io.sf.carte.doc.style.css.property.PrimitiveValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import org.w3c.dom.DOMException;

class CountersValue
extends AbstractCounterValue
implements CSSCountersValue {
    private static final long serialVersionUID = 1L;
    private String separator = "";

    public CountersValue() {
        super(CSSValue.Type.COUNTERS);
    }

    protected CountersValue(CountersValue copied) {
        super(copied);
        this.separator = copied.separator;
    }

    @Override
    public CountersValue clone() {
        return new CountersValue(this);
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    @Override
    CSSValueSyntax.Match matchesComponent(CSSValueSyntax syntax) {
        CSSValueSyntax.Category cat = syntax.getCategory();
        if (cat == CSSValueSyntax.Category.universal || cat == CSSValueSyntax.Category.counter) {
            return CSSValueSyntax.Match.TRUE;
        }
        return CSSValueSyntax.Match.FALSE;
    }

    @Override
    PrimitiveValue.LexicalSetter newLexicalSetter() {
        return new MyLexicalSetter();
    }

    @Override
    public String getCssText() {
        String listStyle;
        StringBuilder buf = new StringBuilder();
        buf.append("counters(").append(this.getName());
        String separator = this.getSeparator();
        buf.append(", ");
        CountersValue.quoteSeparator(separator, buf);
        PrimitiveValue style = this.getCounterStyle();
        if (style != null && !"decimal".equalsIgnoreCase(listStyle = style.getCssText())) {
            buf.append(", ").append(listStyle);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public String getMinifiedCssText(String propertyName) {
        String listStyle;
        StringBuilder buf = new StringBuilder();
        buf.append("counters(").append(this.getName());
        String separator = this.getSeparator();
        buf.append(',');
        CountersValue.quoteSeparator(separator, buf);
        PrimitiveValue style = this.getCounterStyle();
        if (style != null && !"decimal".equalsIgnoreCase(listStyle = style.getCssText())) {
            buf.append(',').append(listStyle);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public void writeCssText(SimpleWriter wri) throws IOException {
        wri.write((CharSequence)"counters(");
        wri.write((CharSequence)this.getName());
        String separator = this.getSeparator();
        wri.write((CharSequence)", ");
        if (!separator.contains("'")) {
            wri.write('\'');
            wri.write((CharSequence)separator);
            wri.write('\'');
        } else {
            wri.write('\"');
            wri.write((CharSequence)separator);
            wri.write('\"');
        }
        PrimitiveValue listStyle = this.getCounterStyle();
        if (listStyle != null && !CountersValue.isCSSIdentifier(listStyle, "decimal")) {
            wri.write((CharSequence)", ");
            listStyle.writeCssText(wri);
        }
        wri.write(')');
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        CountersValue other = (CountersValue)obj;
        if (this.separator == null) {
            return other.separator == null;
        }
        return this.separator.equals(other.separator);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        if (this.separator != null) {
            result = 31 * result + this.separator.hashCode();
        }
        return result;
    }

    class MyLexicalSetter
    extends PrimitiveValue.LexicalSetter {
        MyLexicalSetter() {
            super(CountersValue.this);
        }

        @Override
        void setLexicalUnit(LexicalUnit lunit) {
            LexicalUnit lu = lunit.getParameters();
            if (lu.getLexicalUnitType() != LexicalUnit.LexicalType.IDENT) {
                this.checkProxyValue(lu);
                throw new DOMException(17, "Invalid counters() name.");
            }
            CountersValue.this.setName(lu.getStringValue());
            lu = lu.getNextLexicalUnit();
            if (lu != null) {
                if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                    if ((lu = lu.getNextLexicalUnit()) == null) {
                        this.badSyntax(lunit);
                    }
                    if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.STRING) {
                        CountersValue.this.setSeparator(lu.getStringValue());
                    } else {
                        this.checkProxyValue(lu);
                        this.badSyntax(lunit);
                    }
                    lu = lu.getNextLexicalUnit();
                    if (lu != null) {
                        if (lu.getLexicalUnitType() == LexicalUnit.LexicalType.OPERATOR_COMMA) {
                            LexicalUnit.LexicalType lutype;
                            if ((lu = lu.getNextLexicalUnit()) == null) {
                                this.badSyntax(lunit);
                            }
                            if ((lutype = lu.getLexicalUnitType()) == LexicalUnit.LexicalType.IDENT || lutype == LexicalUnit.LexicalType.FUNCTION && "symbols".equalsIgnoreCase(lu.getFunctionName())) {
                                ValueFactory vf = new ValueFactory();
                                PrimitiveValue.LexicalSetter item = vf.createCSSPrimitiveValueItem(lu, false, false);
                                CountersValue.this.setCounterStyle(item.getCSSValue());
                                if (item.getNextLexicalUnit() != null) {
                                    this.badSyntax(lunit);
                                }
                            } else {
                                this.checkProxyValue(lu);
                                this.badSyntax(lunit);
                            }
                        } else {
                            this.checkProxyValue(lu);
                            this.badSyntax(lunit);
                        }
                    }
                } else {
                    this.checkProxyValue(lu);
                    this.badSyntax(lunit);
                }
            }
            this.nextLexicalUnit = lunit.getNextLexicalUnit();
        }

        private void badSyntax(LexicalUnit lunit) {
            throw new DOMSyntaxException("Invalid counters syntax: " + lunit.toString());
        }
    }
}

