/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.googleai.Json;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import org.jspecify.annotations.Nullable;

public final class GeminiFiles {
    private static final String BASE_URL = "https://generativelanguage.googleapis.com";
    private static final String DELETE_FILE_PATH = "/v1beta";
    private static final String GET_FILE_PATH = "/v1beta";
    private static final String LIST_FILES_PATH = "/v1beta/files";
    private static final String UPLOAD_PATH = "/upload/v1beta/files";
    private static final String API_KEY_HEADER_NAME = "x-goog-api-key";
    private static final String UPLOAD_URL_HEADER = "x-goog-upload-url";
    private final HttpClient httpClient;
    private final String baseUrl;
    private final String apiKey;

    private GeminiFiles(Builder builder) {
        this.apiKey = ValidationUtils.ensureNotBlank((String)builder.apiKey, (String)"apiKey");
        this.httpClient = (HttpClient)Utils.firstNotNull((String)"httpClient", (Object[])new HttpClient[]{builder.httpClient, HttpClient.newHttpClient()});
        this.baseUrl = (String)Utils.firstNotNull((String)"baseUrl", (Object[])new String[]{builder.baseUrl, BASE_URL});
    }

    public static Builder builder() {
        return new Builder();
    }

    public GeminiFile uploadFile(Path filePath, @Nullable String displayName) throws IOException, InterruptedException {
        ValidationUtils.ensureNotNull((Object)filePath, (String)"filePath");
        return this.uploadFile(Files.readAllBytes(filePath), this.detectMimeType(filePath), displayName != null ? displayName : filePath.getFileName().toString());
    }

    public GeminiFile uploadFile(byte[] fileBytes, String mimeType, String name) throws InterruptedException {
        ValidationUtils.ensureNotNull((Object)fileBytes, (String)"fileBytes");
        ValidationUtils.ensureNotNull((Object)mimeType, (String)"mimeType");
        ValidationUtils.ensureNotNull((Object)name, (String)"name");
        String uploadUrl = this.initiateResumableUpload(fileBytes.length, mimeType, name);
        GeminiFileResponse response = this.uploadFileBytes(uploadUrl, fileBytes);
        return response.file();
    }

    public GeminiFile getMetadata(String name) throws IOException, InterruptedException {
        ValidationUtils.ensureNotBlank((String)name, (String)"name");
        String url = this.baseUrl + "/v1beta/" + name;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header(API_KEY_HEADER_NAME, this.apiKey).GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new GeminiUploadFailureException("Failed to retrieve metadata for file: " + name + ". Status code: " + response.statusCode());
        }
        return Json.fromJson(response.body(), GeminiFile.class);
    }

    public List<GeminiFile> listFiles() throws IOException, InterruptedException {
        String url = this.baseUrl + LIST_FILES_PATH;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header(API_KEY_HEADER_NAME, this.apiKey).GET().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        GeminiFilesListResponse listResponse = Json.fromJson(response.body(), GeminiFilesListResponse.class);
        return listResponse.files() != null ? listResponse.files() : List.of();
    }

    public void deleteFile(String name) throws IOException, InterruptedException {
        ValidationUtils.ensureNotBlank((String)name, (String)"name");
        String url = this.baseUrl + "/v1beta/" + name;
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header(API_KEY_HEADER_NAME, this.apiKey).DELETE().build();
        HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
        if (!List.of(Integer.valueOf(200), Integer.valueOf(204)).contains(response.statusCode())) {
            throw new GeminiUploadFailureException("Failed to delete file: " + name + ". Status code: " + response.statusCode());
        }
    }

    private String initiateResumableUpload(long contentLength, String mimeType, String displayName) throws InterruptedException {
        String url = this.baseUrl + UPLOAD_PATH;
        GeminiFileMetadata metadata = new GeminiFileMetadata(new GeminiFileMetadata.FileInfo(displayName));
        String jsonBody = Json.toJson(metadata);
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).header("Content-Type", "application/json").header("User-Agent", "LangChain4j").header(API_KEY_HEADER_NAME, this.apiKey).header("X-Goog-Upload-Protocol", "resumable").header("X-Goog-Upload-Command", "start").header("X-Goog-Upload-Header-Content-Length", String.valueOf(contentLength)).header("X-Goog-Upload-Header-Content-Type", mimeType).POST(HttpRequest.BodyPublishers.ofString(jsonBody)).build();
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            List<String> uploadUrlList = response.headers().allValues(UPLOAD_URL_HEADER);
            if (uploadUrlList.isEmpty() || uploadUrlList.get(0) == null || uploadUrlList.get(0).isEmpty()) {
                throw new IllegalStateException("Upload URL not found in response headers");
            }
            return uploadUrlList.get(0).trim();
        }
        catch (IOException e) {
            throw new GeminiUploadFailureException("Failed to initiate resumable upload", e);
        }
    }

    private GeminiFileResponse uploadFileBytes(String uploadUrl, byte[] fileBytes) throws InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(uploadUrl)).header("X-Goog-Upload-Offset", "0").header("X-Goog-Upload-Command", "upload, finalize").POST(HttpRequest.BodyPublishers.ofByteArray(fileBytes)).build();
        try {
            HttpResponse<String> response = this.httpClient.send(request, HttpResponse.BodyHandlers.ofString());
            return Json.fromJson(response.body(), GeminiFileResponse.class);
        }
        catch (IOException e) {
            throw new GeminiUploadFailureException("Failed to upload file bytes", e);
        }
    }

    private String detectMimeType(Path filePath) throws IOException {
        String mimeType = Files.probeContentType(filePath);
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return mimeType;
    }

    public static class Builder {
        private String apiKey;
        private HttpClient httpClient;
        private String baseUrl;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public GeminiFiles build() {
            return new GeminiFiles(this);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public record GeminiFile(String name, @Nullable String displayName, String mimeType, Long sizeBytes, String createTime, String updateTime, String expirationTime, String sha256Hash, String uri, String state) {
        public boolean isActive() {
            return "ACTIVE".equals(this.state);
        }

        public boolean isProcessing() {
            return "PROCESSING".equals(this.state);
        }

        public boolean isFailed() {
            return "FAILED".equals(this.state);
        }
    }

    record GeminiFileResponse(GeminiFile file) {
    }

    static class GeminiUploadFailureException
    extends RuntimeException {
        GeminiUploadFailureException(String message, Throwable cause) {
            super(message, cause);
        }

        GeminiUploadFailureException(String message) {
            super(message);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    record GeminiFilesListResponse(List<GeminiFile> files) {
    }

    private record GeminiFileMetadata(FileInfo file) {

        record FileInfo(String display_name) {
        }
    }
}

