/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.utils.CommonUtils;

public class OracleDataTypeManager
extends SQLObjectEditor<OracleDataType, OracleSchema> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, OracleDataType> getObjectsCache(@NotNull OracleDataType object) {
        return object.getSchema().dataTypeCache;
    }

    public boolean canCreateObject(@NotNull Object container) {
        return container instanceof OracleSchema;
    }

    protected OracleDataType createDatabaseObject(@NotNull DBRProgressMonitor monitor, @NotNull DBECommandContext context, Object container, Object copyFrom, @NotNull Map<String, Object> options) {
        OracleSchema schema = (OracleSchema)container;
        OracleDataType dataType = new OracleDataType(schema, "DataType", false);
        dataType.setObjectDefinitionText("TYPE " + dataType.getName() + " AS OBJECT\n(\n)");
        return dataType;
    }

    protected void addObjectCreateActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectCreateCommand objectCreateCommand, @NotNull Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(monitor, executionContext, actions, (OracleDataType)objectCreateCommand.getObject());
    }

    protected void addObjectDeleteActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actions, @NotNull SQLObjectEditor.ObjectDeleteCommand objectDeleteCommand, @NotNull Map<String, Object> options) {
        OracleDataType object = (OracleDataType)objectDeleteCommand.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop type", "DROP TYPE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL)));
    }

    protected void addObjectModifyActions(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull SQLObjectEditor.ObjectChangeCommand objectChangeCommand, @NotNull Map<String, Object> options) {
        this.createOrReplaceProcedureQuery(monitor, executionContext, actionList, (OracleDataType)objectChangeCommand.getObject());
    }

    public long getMakerOptions(@NotNull DBPDataSource dataSource) {
        return 4L;
    }

    private void createOrReplaceProcedureQuery(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext executionContext, @NotNull List<DBEPersistAction> actionList, @NotNull OracleDataType dataType) {
        String body;
        String header = OracleUtils.normalizeSourceName(monitor, dataType, false);
        if (!CommonUtils.isEmpty((String)header)) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Create type header", "CREATE OR REPLACE " + header));
        }
        if (!CommonUtils.isEmpty((String)(body = OracleUtils.normalizeSourceName(monitor, dataType, true)))) {
            actionList.add((DBEPersistAction)new SQLDatabasePersistAction("Create type body", "CREATE OR REPLACE " + body));
        }
        OracleUtils.addSchemaChangeActions(executionContext, actionList, dataType);
    }
}

