﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sns/SNSRequest.h>
#include <aws/sns/SNS_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SNS {
namespace Model {

/**
 * <p>Input for <code>GetEndpointAttributes</code> action.</p><p><h3>See Also:</h3>
 * <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/sns-2010-03-31/GetEndpointAttributesInput">AWS
 * API Reference</a></p>
 */
class GetEndpointAttributesRequest : public SNSRequest {
 public:
  AWS_SNS_API GetEndpointAttributesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetEndpointAttributes"; }

  AWS_SNS_API Aws::String SerializePayload() const override;

 protected:
  AWS_SNS_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p> <code>EndpointArn</code> for <code>GetEndpointAttributes</code> input.</p>
   */
  inline const Aws::String& GetEndpointArn() const { return m_endpointArn; }
  inline bool EndpointArnHasBeenSet() const { return m_endpointArnHasBeenSet; }
  template <typename EndpointArnT = Aws::String>
  void SetEndpointArn(EndpointArnT&& value) {
    m_endpointArnHasBeenSet = true;
    m_endpointArn = std::forward<EndpointArnT>(value);
  }
  template <typename EndpointArnT = Aws::String>
  GetEndpointAttributesRequest& WithEndpointArn(EndpointArnT&& value) {
    SetEndpointArn(std::forward<EndpointArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_endpointArn;
  bool m_endpointArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace SNS
}  // namespace Aws
