/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.routing;

import net.osmand.plus.OsmAndFormatter;
import net.osmand.router.TurnType;
import net.sourceforge.offroad.OsmWindow;

public class RouteDirectionInfo {
    public int routePointOffset;
    public int routeEndPointOffset = 0;
    private TurnType turnType;
    private String descriptionRoute = "";
    private float averageSpeed;
    private String ref;
    private String streetName;
    private String destinationName;
    public int afterLeftTime;
    public int distance;

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public RouteDirectionInfo(float averageSpeed, TurnType turnType) {
        this.averageSpeed = averageSpeed == 0.0f ? 1.0f : averageSpeed;
        this.turnType = turnType;
    }

    public String getDescriptionRoute(OsmWindow ctx) {
        return this.descriptionRoute + " " + OsmAndFormatter.getFormattedDistance(this.distance, ctx);
    }

    public String getDescriptionRoutePart() {
        return this.descriptionRoute;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getStreetName() {
        return this.streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }

    public void setDescriptionRoute(String descriptionRoute) {
        this.descriptionRoute = descriptionRoute;
    }

    public float getAverageSpeed() {
        return this.averageSpeed;
    }

    public void setAverageSpeed(float averageSpeed) {
        this.averageSpeed = averageSpeed == 0.0f ? 1.0f : averageSpeed;
    }

    public int getExpectedTime() {
        return (int)((float)this.distance / this.averageSpeed);
    }

    public TurnType getTurnType() {
        return this.turnType;
    }
}

