/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLSocketFactory;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.util.logging.OutputController;

public class UrlUtils {
    private static final String UTF8 = "utf-8";

    public static URL normalizeUrlAndStripParams(URL url, boolean encodeFileUrls) {
        if (url == null) {
            return null;
        }
        try {
            String[] urlParts = url.toString().split("\\?");
            URL strippedUrl = new URL(urlParts[0]);
            return UrlUtils.normalizeUrl(strippedUrl, encodeFileUrls);
        }
        catch (IOException | URISyntaxException e) {
            OutputController.getLogger().log(e);
            return url;
        }
    }

    public static URL normalizeUrlAndStripParams(URL url) {
        return UrlUtils.normalizeUrlAndStripParams(url, false);
    }

    public static boolean isLocalFile(URL url) {
        return !(!url.getProtocol().equals("file") || url.getAuthority() != null && !url.getAuthority().equals("") || url.getHost() != null && !url.getHost().equals(""));
    }

    public static URL decodeUrlQuietly(URL url) {
        try {
            return new URL(URLDecoder.decode(url.toString(), UTF8));
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            return url;
        }
    }

    public static boolean isValidRFC2396Url(URL url) {
        try {
            url.toURI();
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public static URL normalizeUrl(URL url, boolean encodeFileUrls) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        boolean shouldEncode;
        if (url == null) {
            return null;
        }
        String protocol = url.getProtocol();
        boolean bl = shouldEncode = encodeFileUrls || !"file".equals(protocol);
        if (protocol == null || !shouldEncode || url.getPath() == null || UrlUtils.isValidRFC2396Url(url)) {
            return url;
        }
        URL decodedURL = new URL(URLDecoder.decode(url.toString(), UTF8));
        URI uri = new URI(decodedURL.getProtocol(), null, decodedURL.getHost(), decodedURL.getPort(), decodedURL.getPath(), decodedURL.getQuery(), null);
        URL encodedURL = new URL(uri.toASCIIString());
        return encodedURL;
    }

    public static URL normalizeUrl(URL url) throws MalformedURLException, UnsupportedEncodingException, URISyntaxException {
        return UrlUtils.normalizeUrl(url, false);
    }

    public static URL normalizeUrlQuietly(URL url, boolean encodeFileUrls) {
        try {
            return UrlUtils.normalizeUrl(url, encodeFileUrls);
        }
        catch (UnsupportedEncodingException | MalformedURLException | URISyntaxException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            return url;
        }
    }

    public static URL normalizeUrlQuietly(URL url) {
        return UrlUtils.normalizeUrlQuietly(url, false);
    }

    public static File decodeUrlAsFile(URL url) {
        return new File(UrlUtils.decodeUrlQuietly(url).getFile());
    }

    public static URL removeFileName(URL src) {
        int i2;
        if (src == null) {
            return src;
        }
        URL nsrc = UrlUtils.normalizeUrlAndStripParams(src);
        String s = nsrc.getPath();
        int i1 = s.lastIndexOf("/");
        int i = Math.max(i1, i2 = s.lastIndexOf("\\"));
        if (i < 0) {
            return src;
        }
        s = s.substring(0, i);
        try {
            return UrlUtils.sanitizeLastSlash(new URL(src.getProtocol(), src.getHost(), src.getPort(), s));
        }
        catch (MalformedURLException ex) {
            OutputController.getLogger().log(ex);
            return nsrc;
        }
    }

    public static String setOfUrlsToHtmlList(Iterable<URL> remoteUrls) {
        if (remoteUrls == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<ul>");
        for (URL url : remoteUrls) {
            sb.append("<li>").append(url.toExternalForm()).append("</li>");
        }
        sb.append("</ul>");
        return sb.toString();
    }

    public static URL sanitizeLastSlash(URL in) throws MalformedURLException {
        if (in == null) {
            return null;
        }
        String s = UrlUtils.sanitizeLastSlash(in.toExternalForm());
        return new URL(s);
    }

    public static String sanitizeLastSlash(String in) {
        if (in == null) {
            return null;
        }
        String s = in;
        while (s.endsWith("/") || s.endsWith("\\")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static boolean equalsIgnoreLastSlash(URL u1, URL u2) {
        try {
            if (u1 == null && u2 == null) {
                return true;
            }
            if (u1 == null && u2 != null) {
                return false;
            }
            if (u1 != null && u2 == null) {
                return false;
            }
            return UrlUtils.sanitizeLastSlash(u1).equals(UrlUtils.sanitizeLastSlash(u2));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static URL guessCodeBase(JNLPFile file) {
        if (file.getCodeBase() != null) {
            return file.getCodeBase();
        }
        return file.getResources().getMainJAR().getLocation();
    }

    public static boolean urlEquals(URL u1, URL u2) {
        if (u1 == u2) {
            return true;
        }
        if (u1 == null || u2 == null) {
            return false;
        }
        if (UrlUtils.notNullUrlEquals(u1, u2)) {
            return true;
        }
        try {
            URL nu1 = UrlUtils.normalizeUrl(u1);
            URL nu2 = UrlUtils.normalizeUrl(u2);
            if (UrlUtils.notNullUrlEquals(nu1, nu2)) {
                return true;
            }
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
        }
        return false;
    }

    public static boolean urlRelativeTo(URL url, URL codebaseUrl) {
        if (codebaseUrl == url) {
            return true;
        }
        if (codebaseUrl == null || url == null) {
            return false;
        }
        try {
            URL nu = UrlUtils.sanitizeLastSlash(UrlUtils.normalizeUrl(url));
            URL nup = UrlUtils.sanitizeLastSlash(UrlUtils.normalizeUrl(codebaseUrl));
            if (!UrlUtils.getHostAndPort(nu).equals(UrlUtils.getHostAndPort(nup))) {
                return false;
            }
            if (!nu.getProtocol().equals(nup.getProtocol())) {
                return false;
            }
            if (nu.getPath().contains("..")) {
                return false;
            }
            if (nu.getPath().startsWith(nup.getPath())) {
                return true;
            }
        }
        catch (UnsupportedEncodingException | MalformedURLException | URISyntaxException e) {
            OutputController.getLogger().log(e);
        }
        return false;
    }

    static boolean notNullUrlEquals(URL u1, URL u2) {
        return UrlUtils.compareNullableStrings(u1.getProtocol(), u2.getProtocol(), true) && UrlUtils.compareNullableStrings(u1.getHost(), u2.getHost(), true) && UrlUtils.compareNullableStrings(u1.getPath(), u2.getPath(), false) && UrlUtils.compareNullableStrings(u1.getQuery(), u2.getQuery(), false) && UrlUtils.compareNullableStrings(u1.getRef(), u2.getRef(), false);
    }

    static boolean compareNullableStrings(String s1, String s2, boolean ignore) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        if (ignore) {
            return s1.equalsIgnoreCase(s2);
        }
        return s1.equals(s2);
    }

    public static int getSanitizedPort(URL u) {
        if (u.getPort() < 0) {
            return u.getDefaultPort();
        }
        return u.getPort();
    }

    public static int getPort(URL url) {
        return UrlUtils.getSanitizedPort(url);
    }

    public static String getHostAndPort(URL url) {
        return url.getHost() + ":" + UrlUtils.getSanitizedPort(url);
    }

    public static URL ensureSlashTail(URL u) {
        if (u == null) {
            return null;
        }
        String s = UrlUtils.ensureSlashTail(u.toExternalForm());
        try {
            return new URL(s);
        }
        catch (MalformedURLException ex) {
            OutputController.getLogger().log(ex);
            return u;
        }
    }

    public static String ensureSlashTail(String s) {
        if (s.endsWith("/")) {
            return s;
        }
        if (s.endsWith("\\")) {
            return s;
        }
        if (s.contains("/")) {
            return s + "/";
        }
        if (s.contains("\\")) {
            return s + "\\";
        }
        return s + "/";
    }

    public static String stripFile(URL documentbase) {
        return UrlUtils.ensureSlashTail(UrlUtils.stripFileImp(documentbase));
    }

    private static String stripFileImp(URL documentbase) {
        try {
            String normalized = UrlUtils.normalizeUrlAndStripParams(documentbase).toExternalForm().trim();
            if (normalized.endsWith("/") || normalized.endsWith("\\")) {
                return normalized;
            }
            URL middleway = new URL(normalized);
            String file = middleway.getFile();
            int i = Math.max(file.lastIndexOf(47), file.lastIndexOf(92));
            if (i < 0) {
                return normalized;
            }
            String parent = file.substring(0, i + 1);
            String stripped = normalized.replace(file, parent);
            return stripped;
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            return documentbase.toExternalForm();
        }
    }

    public static String loadUrl(URL url) throws IOException {
        return UrlUtils.loadUrl(url, StandardCharsets.UTF_8);
    }

    public static String loadUrl(URL url, Charset ch) throws IOException {
        StringBuilder all = new StringBuilder();
        int tries = 0;
        InputStream is = null;
        while (true) {
            block20: {
                URLConnection connection = url.openConnection();
                ++tries;
                try {
                    is = connection.getInputStream();
                }
                catch (IOException ioe) {
                    HttpURLConnection httpConn;
                    int statusCode;
                    OutputController.getLogger().log(ioe);
                    if (!(connection instanceof HttpURLConnection) || (statusCode = (httpConn = (HttpURLConnection)connection).getResponseCode()) == 200) break block20;
                    is = httpConn.getErrorStream();
                }
            }
            if (tries > 6) {
                throw new IOException("Failed " + url + " on " + tries + " attempts");
            }
            if (is != null) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, ch));){
            String line;
            while ((line = br.readLine()) != null) {
                all.append(line).append("\n");
            }
        }
        return all.toString();
    }

    private static byte[] getRemainingBytes(InputStream is) throws IOException {
        int len;
        byte[] buf = new byte[2048];
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((len = is.read(buf)) != -1) {
            bos.write(buf, 0, len);
        }
        bos.close();
        return bos.toByteArray();
    }

    public static Object[] loadUrlWithInvalidHeaderBytes(URL url) throws IOException {
        try (Socket s = UrlUtils.createSocketFromUrl(url);){
            UrlUtils.writeRequest(s.getOutputStream(), url);
            String head = new String();
            byte[] body = new byte[]{};
            try (InputStream is = s.getInputStream();){
                int readChar;
                while ((readChar = is.read()) >= 0) {
                    if (!(head = head + (char)readChar).endsWith("\n\n") && !head.endsWith("\r\n\r\n") && !head.endsWith("\n\r\n\r") && !head.endsWith("\r\r")) continue;
                    body = UrlUtils.getRemainingBytes(is);
                }
            }
            Object[] objectArray = new Object[]{head, body};
            return objectArray;
        }
    }

    public static String[] loadUrlWithInvalidHeader(URL url) throws IOException {
        return UrlUtils.loadUrlWithInvalidHeader(url, StandardCharsets.US_ASCII);
    }

    public static String[] loadUrlWithInvalidHeader(URL url, Charset ch) throws IOException {
        try (Socket s = UrlUtils.createSocketFromUrl(url);){
            UrlUtils.writeRequest(s.getOutputStream(), url);
            StringBuilder all = new StringBuilder();
            StringBuilder head = new StringBuilder();
            StringBuilder body = new StringBuilder();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(s.getInputStream(), ch));){
                String line;
                StringBuilder second = head;
                while ((line = br.readLine()) != null) {
                    all.append(line).append("\n");
                    if (line.isEmpty()) {
                        second = body;
                        continue;
                    }
                    second.append(line).append("\n");
                }
            }
            String[] stringArray = new String[]{all.toString(), head.toString(), body.toString()};
            return stringArray;
        }
    }

    private static void writeRequest(OutputStream s, URL url) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(s, StandardCharsets.US_ASCII);
        String file = url.getFile();
        if (file.isEmpty()) {
            file = "/";
        }
        w.write("GET " + file + " HTTP/1.0\r\n");
        w.write("Host: " + url.getHost() + "\r\n");
        w.write("User-Agent: javaws (icedtea-web)\r\n");
        w.write("Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\r\n");
        w.write("Referer: " + url.toExternalForm() + "\r\n");
        w.write("\r\n");
        ((Writer)w).flush();
    }

    private static Socket createSocketFromUrl(URL url) throws IOException {
        int p = url.getPort();
        if (p < 0) {
            p = url.getDefaultPort();
        }
        Socket s = url.getProtocol().equals("https") ? SSLSocketFactory.getDefault().createSocket(url.getHost(), p) : new Socket(url.getHost(), p);
        return s;
    }
}

