/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.LaTeXGenericCommand;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import java.io.IOException;

public class L2HGlsStyleList
extends ControlSequence {
    protected String styleName;
    protected String cssClass;
    protected boolean hasNavHeader = false;
    protected boolean hasGroupHeadings;

    public L2HGlsStyleList(String string, String string2) {
        this(string, string2, false, false);
    }

    public L2HGlsStyleList(String string, String string2, boolean bl, boolean bl2) {
        this("@glsstyle@" + string, string, string2, bl, bl2);
    }

    public L2HGlsStyleList(String string, String string2, String string3, boolean bl, boolean bl2) {
        super(string);
        this.styleName = string2;
        this.cssClass = string3;
        this.hasNavHeader = bl;
        this.hasGroupHeadings = bl2;
    }

    @Override
    public Object clone() {
        return new L2HGlsStyleList(this.getName(), this.styleName, this.cssClass, this.hasNavHeader, this.hasGroupHeadings);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        TeXObjectList teXObjectList3 = l2HConverter.createStack();
        ControlSequence controlSequence = teXParser.getControlSequence("glslistinit");
        if (controlSequence != null) {
            teXObjectList3.add(controlSequence);
        }
        StartElement startElement = new StartElement("dl", true);
        if (this.cssClass != null) {
            startElement.putAttribute("class", this.cssClass + " " + this.styleName);
        } else {
            startElement.putAttribute("class", this.styleName);
        }
        teXObjectList3.add(startElement);
        TeXObjectList teXObjectList4 = l2HConverter.createStack();
        teXObjectList4.add(new EndElement("dl", true));
        l2HConverter.newenvironment(Overwrite.ALLOW, "renewenvironment", "theglossary", 0, null, teXObjectList3, teXObjectList4);
        if (this.hasNavHeader) {
            teXObjectList2 = l2HConverter.createStack();
            teXObjectList2.add(new TeXCsRef("glslistnavigation"));
            teXObjectList2.add(TeXParserUtils.createGroup(l2HConverter, new TeXCsRef("glsnavigation")));
        } else {
            l2HConverter.putControlSequence(true, new GenericCommand(true, "glossaryheader"));
        }
        if (this.hasGroupHeadings) {
            teXObjectList2 = l2HConverter.createStack();
            startElement = new StartElement("dt");
            startElement.putAttribute("class", "header");
            teXObjectList2.add(startElement);
            teXObjectList2.add(new TeXCsRef("glslistgroupheaderfmt"));
            Group group = l2HConverter.createGroup();
            teXObjectList2.add(group);
            if (this.hasNavHeader) {
                group.add(new TeXCsRef("glsnavhypertarget"));
                group.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(1)));
                Group group2 = l2HConverter.createGroup();
                group.add(group2);
                group = group2;
            }
            group.add(new TeXCsRef("glsgetgrouptitle"));
            group.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(1)));
            teXObjectList2.add(new EndElement("dt"));
            l2HConverter.putControlSequence(true, new LaTeXGenericCommand(true, "glsgroupheading", "m", teXObjectList2));
        } else {
            l2HConverter.putControlSequence(true, new AtGobble("glsgroupheading"));
        }
        teXObjectList2 = l2HConverter.createStack();
        teXObjectList2.add(new StartElement("dt"));
        teXObjectList2.add(new TeXCsRef("glsentryitem"));
        teXObjectList2.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(1)));
        teXObjectList2.add(new TeXCsRef("glstarget"));
        teXObjectList2.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(1)));
        teXObjectList2.add(TeXParserUtils.createGroup(l2HConverter, new TeXCsRef("glossentryname"), TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(1))));
        teXObjectList2.add(new EndElement("dt"));
        teXObjectList2.add(new StartElement("dd"));
        if (teXParser.getControlSequence("glslistdesc") != null) {
            teXObjectList2.add(new TeXCsRef("glslistdesc"));
            teXObjectList2.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(1)));
        } else {
            teXObjectList2.add(new TeXCsRef("glossentrydesc"));
            teXObjectList2.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(1)));
            teXObjectList2.add(new TeXCsRef("glspostdescription"));
        }
        if (teXParser.getControlSequence("glslistprelocation") != null) {
            teXObjectList2.add(new TeXCsRef("glslistprelocation"));
        } else {
            teXObjectList2.add(new TeXCsRef("space"));
        }
        teXObjectList2.add(l2HConverter.getParam(2));
        teXObjectList2.add(new EndElement("dd"));
        l2HConverter.putControlSequence(true, new LaTeXGenericCommand(true, "glossentry", "mm", teXObjectList2));
        teXObjectList2 = l2HConverter.createStack();
        teXObjectList2.add(new StartElement("dt"));
        teXObjectList2.add(new TeXCsRef("glssubentryitem"));
        teXObjectList2.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(2)));
        teXObjectList2.add(new TeXCsRef("glstarget"));
        teXObjectList2.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(2)));
        teXObjectList2.add(l2HConverter.createGroup());
        teXObjectList2.add(new EndElement("dt"));
        teXObjectList2.add(new StartElement("dd"));
        teXObjectList2.add(new TeXCsRef("glossentrydesc"));
        teXObjectList2.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(2)));
        teXObjectList2.add(new TeXCsRef("glspostdescription"));
        if (teXParser.getControlSequence("glslistchildprelocation") != null) {
            teXObjectList2.add(new TeXCsRef("glslistchildprelocation"));
        } else {
            teXObjectList2.add(new TeXCsRef("space"));
        }
        teXObjectList2.add(l2HConverter.getParam(3));
        if (teXParser.getControlSequence("glslistchildpostlocation") != null) {
            teXObjectList2.add(new TeXCsRef("glslistchildpostlocation"));
        } else {
            teXObjectList2.add(l2HConverter.getOther(46));
        }
        teXObjectList2.add(new EndElement("dd"));
        l2HConverter.putControlSequence(true, new LaTeXGenericCommand(true, "subglossentry", "mmm", teXObjectList2));
        teXObjectList2 = l2HConverter.createStack();
        teXObjectList2.add(new TeXCsRef("ifglsnogroupskip"));
        teXObjectList2.add(new TeXCsRef("else"));
        teXObjectList2.add(new TeXCsRef("indexspace"));
        teXObjectList2.add(new TeXCsRef("fi"));
        l2HConverter.putControlSequence(true, new GenericCommand(true, "glsgroupskip", null, teXObjectList2));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

