/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.plan.rel;

import java.util.List;
import lombok.Generated;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rex.RexNode;
import org.opensearch.sql.exception.CalciteUnsupportedException;

public abstract class Dedup
extends SingleRel {
    final List<RexNode> dedupeFields;
    final Integer allowedDuplication;
    final Boolean keepEmpty;
    final Boolean consecutive;

    protected Dedup(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<RexNode> dedupeFields, Integer allowedDuplication, Boolean keepEmpty, Boolean consecutive) {
        super(cluster, traitSet, input);
        if (allowedDuplication <= 0) {
            throw new IllegalArgumentException("Number of duplicate events must be greater than 0");
        }
        if (consecutive.booleanValue()) {
            throw new CalciteUnsupportedException("Consecutive deduplication is unsupported in Calcite");
        }
        this.dedupeFields = dedupeFields;
        this.allowedDuplication = allowedDuplication;
        this.keepEmpty = keepEmpty;
        this.consecutive = consecutive;
    }

    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, (RelNode)Dedup.sole(inputs), this.dedupeFields, this.allowedDuplication, this.keepEmpty, this.consecutive);
    }

    public abstract Dedup copy(RelTraitSet var1, RelNode var2, List<RexNode> var3, Integer var4, Boolean var5, Boolean var6);

    public Dedup copy(RelNode input, List<RexNode> dedupeFields) {
        return this.copy(this.getTraitSet(), input, dedupeFields, this.allowedDuplication, this.keepEmpty, this.consecutive);
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("dedup_fields", this.dedupeFields).item("allowed_dedup", (Object)this.allowedDuplication).item("keepEmpty", (Object)this.keepEmpty).item("consecutive", (Object)this.consecutive);
    }

    public void register(RelOptPlanner planner) {
    }

    @Generated
    public List<RexNode> getDedupeFields() {
        return this.dedupeFields;
    }

    @Generated
    public Integer getAllowedDuplication() {
        return this.allowedDuplication;
    }

    @Generated
    public Boolean getKeepEmpty() {
        return this.keepEmpty;
    }

    @Generated
    public Boolean getConsecutive() {
        return this.consecutive;
    }
}

