/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.Status;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.net.ssl.SSLEngine;
import org.opensearch.rest.RestRequest;
import org.opensearch.security.filter.SecurityRequestChannel;
import org.opensearch.security.filter.SecurityResponse;

public class GrpcRequestChannel
implements SecurityRequestChannel {
    private final ServerCall<?, ?> serverCall;
    private final Map<String, List<String>> headers;
    private Optional<SecurityResponse> queuedResponse = Optional.empty();
    private static final Map<String, RestRequest.Method> SERVICE_METHOD_MAP = Map.of("grpc.health.v1.Health", RestRequest.Method.GET, "grpc.reflection.v1alpha.ServerReflection", RestRequest.Method.GET, "org.opensearch.protobufs.services.SearchService", RestRequest.Method.GET, "org.opensearch.protobufs.services.DocumentService", RestRequest.Method.POST);

    public GrpcRequestChannel(ServerCall<?, ?> serverCall, Metadata metadata) {
        this.serverCall = serverCall;
        this.headers = this.extractHeaders(metadata);
    }

    private Map<String, List<String>> extractHeaders(Metadata metadata) {
        TreeMap<String, List<String>> headerMap = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (String key : metadata.keys()) {
            String value;
            if (key.endsWith("-bin") || (value = (String)metadata.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER))) == null) continue;
            headerMap.put(key, List.of(value));
        }
        return headerMap;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public SSLEngine getSSLEngine() {
        throw new UnsupportedOperationException("Client certificate authentication not supported for gRPC");
    }

    @Override
    public String path() {
        return this.serverCall.getMethodDescriptor().getFullMethodName();
    }

    @Override
    public String uri() {
        return this.serverCall.getMethodDescriptor().getFullMethodName();
    }

    @Override
    public RestRequest.Method method() {
        String servicePath = this.path();
        return SERVICE_METHOD_MAP.entrySet().stream().filter(entry -> servicePath.contains((CharSequence)entry.getKey())).map(Map.Entry::getValue).findFirst().orElse(RestRequest.Method.GET);
    }

    @Override
    public Optional<InetSocketAddress> getRemoteAddress() {
        try {
            SocketAddress remoteAddr = (SocketAddress)this.serverCall.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
            if (remoteAddr instanceof InetSocketAddress) {
                return Optional.of((InetSocketAddress)remoteAddr);
            }
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    @Override
    public Map<String, String> params() {
        return Collections.emptyMap();
    }

    @Override
    public Set<String> getUnconsumedParams() {
        return Set.of();
    }

    @Override
    public void queueForSending(SecurityResponse response) {
        this.queuedResponse = Optional.of(response);
    }

    @Override
    public Optional<SecurityResponse> getQueuedResponse() {
        return this.queuedResponse;
    }

    public Status getQueuedResponseGrpcStatus() {
        return this.queuedResponse.map(securityResponse -> this.mapToGrpcStatus(securityResponse.getStatus()).withDescription(securityResponse.getBody())).orElse(Status.INTERNAL);
    }

    private Status mapToGrpcStatus(int httpStatus) {
        return switch (httpStatus) {
            case 100, 101, 200, 201, 202, 203, 204, 205, 206 -> Status.OK;
            case 300, 301, 302, 303, 304, 305, 307, 411, 412, 417, 423, 424 -> Status.FAILED_PRECONDITION;
            case 400, 406, 414, 415, 421, 422 -> Status.INVALID_ARGUMENT;
            case 401, 407 -> Status.UNAUTHENTICATED;
            case 402, 403 -> Status.PERMISSION_DENIED;
            case 404, 410 -> Status.NOT_FOUND;
            case 405, 501, 505 -> Status.UNIMPLEMENTED;
            case 408, 504 -> Status.DEADLINE_EXCEEDED;
            case 409 -> Status.ABORTED;
            case 413, 416 -> Status.OUT_OF_RANGE;
            case 429, 507 -> Status.RESOURCE_EXHAUSTED;
            case 500 -> Status.INTERNAL;
            case 502, 503 -> Status.UNAVAILABLE;
            default -> Status.UNKNOWN;
        };
    }
}

