/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.contextmanager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.contextmanager.ContextManager;
import org.opensearch.ml.common.contextmanager.ContextManagerConfig;
import org.opensearch.ml.common.contextmanager.ContextManagerContext;
import org.opensearch.ml.common.hooks.HookProvider;
import org.opensearch.ml.common.hooks.HookRegistry;
import org.opensearch.ml.common.hooks.PostMemoryEvent;
import org.opensearch.ml.common.hooks.PostToolEvent;
import org.opensearch.ml.common.hooks.PreLLMEvent;

public class ContextManagerHookProvider
implements HookProvider {
    @Generated
    private static final Logger log = LogManager.getLogger(ContextManagerHookProvider.class);
    private final List<ContextManager> contextManagers;
    private final Map<String, List<ContextManager>> hookToManagersMap;

    public ContextManagerHookProvider(List<ContextManager> contextManagers) {
        this.contextManagers = new ArrayList<ContextManager>(contextManagers);
        this.hookToManagersMap = new ConcurrentHashMap<String, List<ContextManager>>();
    }

    public ContextManagerHookProvider(List<ContextManager> contextManagers, Map<String, List<ContextManagerConfig>> hookConfiguration) {
        this.contextManagers = new ArrayList<ContextManager>(contextManagers);
        this.hookToManagersMap = new ConcurrentHashMap<String, List<ContextManager>>();
        if (hookConfiguration != null && !hookConfiguration.isEmpty()) {
            this.organizeManagersByHookConfiguration(hookConfiguration);
        }
    }

    @Override
    public void registerHooks(HookRegistry registry) {
        registry.addCallback(PreLLMEvent.class, this::handlePreLLM);
        registry.addCallback(PostToolEvent.class, this::handlePostTool);
        registry.addCallback(PostMemoryEvent.class, this::handlePostMemory);
        log.info("Registered context manager hooks for {} managers", (Object)this.contextManagers.size());
    }

    private void handlePreLLM(PreLLMEvent event) {
        log.debug("Handling PreLLM event");
        this.executeManagersForHook("PRE_LLM", event.getContext());
    }

    private void handlePostTool(PostToolEvent event) {
        log.debug("Handling PostTool event");
        this.executeManagersForHook("POST_TOOL", event.getContext());
    }

    private void handlePostMemory(PostMemoryEvent event) {
        log.debug("Handling PostMemory event");
        this.executeManagersForHook("POST_MEMORY", event.getContext());
    }

    private void executeManagersForHook(String hookName, ContextManagerContext context) {
        List<ContextManager> managers = this.hookToManagersMap.get(hookName);
        if (managers != null && !managers.isEmpty()) {
            log.debug("Executing {} context managers for hook: {}", (Object)managers.size(), (Object)hookName);
            for (ContextManager manager : managers) {
                try {
                    if (manager.shouldActivate(context)) {
                        log.debug("Executing context manager: {}", (Object)manager.getType());
                        manager.execute(context);
                        log.debug("Successfully executed context manager: {}", (Object)manager.getType());
                        continue;
                    }
                    log.debug("Context manager {} activation conditions not met, skipping", (Object)manager.getType());
                }
                catch (Exception e) {
                    log.error("Context manager {} failed: {}", (Object)manager.getType(), (Object)e.getMessage(), (Object)e);
                }
            }
        } else {
            log.debug("No context managers registered for hook: {}", (Object)hookName);
        }
    }

    private void organizeManagersByHookConfiguration(Map<String, List<ContextManagerConfig>> hookConfiguration) {
        this.hookToManagersMap.clear();
        for (Map.Entry<String, List<ContextManagerConfig>> entry : hookConfiguration.entrySet()) {
            String hookName = entry.getKey();
            List<ContextManagerConfig> configs = entry.getValue();
            for (ContextManagerConfig config : configs) {
                ContextManager manager = this.findManagerByType(config.getType());
                if (manager != null) {
                    this.addManagerToHook(hookName, manager);
                    continue;
                }
                log.warn("Context manager of type {} not found for hook {}", (Object)config.getType(), (Object)hookName);
            }
        }
        log.info("Organized {} context managers across {} hooks from configuration", (Object)this.contextManagers.size(), (Object)hookConfiguration.size());
    }

    private void addManagerToHook(String hookName, ContextManager manager) {
        this.hookToManagersMap.computeIfAbsent(hookName, k -> new ArrayList()).add(manager);
        log.debug("Added manager {} to hook {}", (Object)manager.getType(), (Object)hookName);
    }

    public void updateHookConfiguration(Map<String, List<ContextManagerConfig>> hookConfiguration) {
        this.organizeManagersByHookConfiguration(hookConfiguration);
        log.info("Updated hook configuration with {} hooks", (Object)hookConfiguration.size());
    }

    private ContextManager findManagerByType(String type) {
        return this.contextManagers.stream().filter(manager -> type.equals(manager.getType())).findFirst().orElse(null);
    }

    public int getManagerCount(String hookName) {
        List<ContextManager> managers = this.hookToManagersMap.get(hookName);
        return managers != null ? managers.size() : 0;
    }
}

