/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.contextmanagement;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ml.action.contextmanagement.ContextManagementTemplateService;
import org.opensearch.ml.common.transport.contextmanagement.MLCreateContextManagementTemplateRequest;
import org.opensearch.ml.common.transport.contextmanagement.MLCreateContextManagementTemplateResponse;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class CreateContextManagementTemplateTransportAction
extends HandledTransportAction<MLCreateContextManagementTemplateRequest, MLCreateContextManagementTemplateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(CreateContextManagementTemplateTransportAction.class);
    private final Client client;
    private final ContextManagementTemplateService contextManagementTemplateService;

    @Inject
    public CreateContextManagementTemplateTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ContextManagementTemplateService contextManagementTemplateService) {
        super("cluster:admin/opensearch/ml/context_management/create", transportService, actionFilters, MLCreateContextManagementTemplateRequest::new);
        this.client = client;
        this.contextManagementTemplateService = contextManagementTemplateService;
    }

    protected void doExecute(Task task, MLCreateContextManagementTemplateRequest request, ActionListener<MLCreateContextManagementTemplateResponse> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            log.info("Creating context management template: {}", (Object)request.getTemplateName());
            this.contextManagementTemplateService.saveTemplate(request.getTemplateName(), request.getTemplate(), (ActionListener<Boolean>)ActionListener.wrap(success -> {
                if (success.booleanValue()) {
                    log.info("Successfully created context management template: {}", (Object)request.getTemplateName());
                    listener.onResponse((Object)new MLCreateContextManagementTemplateResponse(request.getTemplateName(), "created"));
                } else {
                    log.error("Failed to create context management template: {}", (Object)request.getTemplateName());
                    listener.onFailure((Exception)new RuntimeException("Failed to create context management template"));
                }
            }, exception -> {
                log.error("Error creating context management template: {}", (Object)request.getTemplateName(), exception);
                listener.onFailure(exception);
            }));
        }
        catch (Exception e) {
            log.error("Unexpected error creating context management template: {}", (Object)request.getTemplateName(), (Object)e);
            listener.onFailure(e);
        }
    }
}

