/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers;

import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.EncryptionContext;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.AsymmetricRawMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.DecryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.EncryptionMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.materials.SymmetricRawMaterials;
import com.amazonaws.services.dynamodbv2.datamodeling.encryption.providers.EncryptionMaterialsProvider;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableEntryException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class KeyStoreMaterialsProvider
implements EncryptionMaterialsProvider {
    private final Map<String, String> description;
    private final String encryptionAlias;
    private final String signingAlias;
    private final KeyStore.ProtectionParameter encryptionProtection;
    private final KeyStore.ProtectionParameter signingProtection;
    private final KeyStore keyStore;
    private final AtomicReference<CurrentMaterials> currMaterials = new AtomicReference();

    public KeyStoreMaterialsProvider(KeyStore keyStore, String encryptionAlias, String signingAlias, Map<String, String> description) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        this(keyStore, encryptionAlias, signingAlias, null, null, description);
    }

    public KeyStoreMaterialsProvider(KeyStore keyStore, String encryptionAlias, String signingAlias, KeyStore.ProtectionParameter encryptionProtection, KeyStore.ProtectionParameter signingProtection, Map<String, String> description) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableEntryException {
        this.keyStore = keyStore;
        this.encryptionAlias = encryptionAlias;
        this.signingAlias = signingAlias;
        this.encryptionProtection = encryptionProtection;
        this.signingProtection = signingProtection;
        this.description = Collections.unmodifiableMap(new HashMap<String, String>(description));
        this.validateKeys();
        this.loadKeys();
    }

    @Override
    public DecryptionMaterials getDecryptionMaterials(EncryptionContext context) {
        CurrentMaterials materials = this.currMaterials.get();
        if (context.getMaterialDescription().entrySet().containsAll(this.description.entrySet())) {
            if (materials.encryptionEntry instanceof KeyStore.SecretKeyEntry) {
                return materials.symRawMaterials;
            }
            try {
                return this.makeAsymMaterials(materials, context.getMaterialDescription());
            }
            catch (GeneralSecurityException ex) {
                throw new DynamoDBMappingException("Unable to decrypt envelope key", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public EncryptionMaterials getEncryptionMaterials(EncryptionContext context) {
        CurrentMaterials materials = this.currMaterials.get();
        if (materials.encryptionEntry instanceof KeyStore.SecretKeyEntry) {
            return materials.symRawMaterials;
        }
        try {
            return this.makeAsymMaterials(materials, this.description);
        }
        catch (GeneralSecurityException ex) {
            throw new DynamoDBMappingException("Unable to encrypt envelope key", (Throwable)ex);
        }
    }

    private AsymmetricRawMaterials makeAsymMaterials(CurrentMaterials materials, Map<String, String> description) throws GeneralSecurityException {
        KeyPair encryptionPair = KeyStoreMaterialsProvider.entry2Pair(materials.encryptionEntry);
        if (materials.signingEntry instanceof KeyStore.SecretKeyEntry) {
            return new AsymmetricRawMaterials(encryptionPair, ((KeyStore.SecretKeyEntry)materials.signingEntry).getSecretKey(), description);
        }
        return new AsymmetricRawMaterials(encryptionPair, KeyStoreMaterialsProvider.entry2Pair(materials.signingEntry), description);
    }

    private static KeyPair entry2Pair(KeyStore.Entry entry) {
        PublicKey pub = null;
        PrivateKey priv = null;
        if (entry instanceof KeyStore.PrivateKeyEntry) {
            KeyStore.PrivateKeyEntry pk = (KeyStore.PrivateKeyEntry)entry;
            if (pk.getCertificate() != null) {
                pub = pk.getCertificate().getPublicKey();
            }
            priv = pk.getPrivateKey();
        } else if (entry instanceof KeyStore.TrustedCertificateEntry) {
            KeyStore.TrustedCertificateEntry tc = (KeyStore.TrustedCertificateEntry)entry;
            pub = tc.getTrustedCertificate().getPublicKey();
        } else {
            throw new IllegalArgumentException("Only entry types PrivateKeyEntry and TrustedCertificateEntry are supported.");
        }
        return new KeyPair(pub, priv);
    }

    @Override
    public void refresh() {
        try {
            this.loadKeys();
        }
        catch (GeneralSecurityException ex) {
            throw new DynamoDBMappingException("Unable to load keys from keystore", (Throwable)ex);
        }
    }

    private void validateKeys() throws KeyStoreException {
        if (!this.keyStore.containsAlias(this.encryptionAlias)) {
            throw new IllegalArgumentException("Keystore does not contain alias: " + this.encryptionAlias);
        }
        if (!this.keyStore.containsAlias(this.signingAlias)) {
            throw new IllegalArgumentException("Keystore does not contain alias: " + this.signingAlias);
        }
    }

    private void loadKeys() throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        KeyStore.Entry encryptionEntry = this.keyStore.getEntry(this.encryptionAlias, this.encryptionProtection);
        KeyStore.Entry signingEntry = this.keyStore.getEntry(this.signingAlias, this.signingProtection);
        CurrentMaterials newMaterials = new CurrentMaterials(encryptionEntry, signingEntry);
        this.currMaterials.set(newMaterials);
    }

    private class CurrentMaterials {
        public final KeyStore.Entry encryptionEntry;
        public final KeyStore.Entry signingEntry;
        public final SymmetricRawMaterials symRawMaterials;

        public CurrentMaterials(KeyStore.Entry encryptionEntry, KeyStore.Entry signingEntry) {
            this.encryptionEntry = encryptionEntry;
            this.signingEntry = signingEntry;
            this.symRawMaterials = encryptionEntry instanceof KeyStore.SecretKeyEntry ? (signingEntry instanceof KeyStore.SecretKeyEntry ? new SymmetricRawMaterials(((KeyStore.SecretKeyEntry)encryptionEntry).getSecretKey(), ((KeyStore.SecretKeyEntry)signingEntry).getSecretKey(), (Map<String, String>)KeyStoreMaterialsProvider.this.description) : new SymmetricRawMaterials(((KeyStore.SecretKeyEntry)encryptionEntry).getSecretKey(), KeyStoreMaterialsProvider.entry2Pair(signingEntry), (Map<String, String>)KeyStoreMaterialsProvider.this.description)) : null;
        }
    }
}

