/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import com.oracle.labs.mlrg.olcut.util.MutableNumber;

public final class MutableLong
extends MutableNumber {
    private static final long serialVersionUID = 1L;
    private long value;

    public MutableLong(long value) {
        this.value = value;
    }

    public MutableLong() {
        this.value = 0L;
    }

    public MutableLong(MutableLong other) {
        this.value = other.value;
    }

    public MutableLong(Number other) {
        this.value = other.longValue();
    }

    public void increment(long other) {
        this.value += other;
    }

    public void increment(MutableLong other) {
        this.value += other.value;
    }

    public void increment() {
        ++this.value;
    }

    public void decrement(long other) {
        this.value -= other;
    }

    public void decrement(MutableLong other) {
        this.value -= other.value;
    }

    public void decrement() {
        --this.value;
    }

    public void set(long other) {
        this.value = other;
    }

    public void multiply(long other) {
        this.value *= other;
    }

    public void multiply(MutableLong other) {
        this.value *= other.value;
    }

    public void divide(long other) {
        this.value /= other;
    }

    public void divide(MutableLong other) {
        this.value /= other.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return "" + this.value;
    }

    @Override
    public MutableLong copy() {
        return new MutableLong(this.value);
    }
}

