/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal.resolver;

import java.io.File;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.vcs.internal.VersionControlRepositoryConnection;
import org.gradle.vcs.internal.VersionRef;
import org.gradle.vcs.internal.resolver.PersistentVcsMetadataCache;
import org.gradle.vcs.internal.resolver.VcsVersionWorkingDirResolver;
import org.jspecify.annotations.Nullable;

public class OfflineVcsVersionWorkingDirResolver
implements VcsVersionWorkingDirResolver {
    private final PersistentVcsMetadataCache persistentCache;

    public OfflineVcsVersionWorkingDirResolver(PersistentVcsMetadataCache persistentCache) {
        this.persistentCache = persistentCache;
    }

    @Override
    public @Nullable File selectVersion(ModuleComponentSelector selector, VersionControlRepositoryConnection repository) {
        VersionRef previousVersion = this.persistentCache.getVersionForSelector(repository, selector.getVersionConstraint());
        if (previousVersion == null) {
            throw new ModuleVersionResolveException((ComponentSelector)selector, () -> String.format("Cannot resolve %s from %s in offline mode.", selector.getDisplayName(), repository.getDisplayName()));
        }
        return repository.populate(previousVersion);
    }
}

