/* Common code for zcat and zgrep
   Copyright (C) 2010-2021 Antonio Diaz Diaz.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef O_BINARY
#define O_BINARY 0
#endif


int simple_extension_index( const std::string & name )
  {
  for( int i = 0; i < num_formats; ++i )
    {
    const std::string ext( simple_extensions[i] );
    if( name.size() > ext.size() &&
        name.compare( name.size() - ext.size(), ext.size(), ext ) == 0 )
      return i;
    }
  return -1;
  }


int open_instream( std::string & input_filename, const bool search,
                   const bool no_messages = false )
  {
  int infd = open( input_filename.c_str(), O_RDONLY | O_BINARY );
  if( infd < 0 )
    {
    const int saved_errno = errno;
    if( search && simple_extension_index( input_filename ) < 0 )
      {
      for( int i = 0; i < num_formats; ++i )
        if( enabled_format( format_order[i] ) )
          {
          const std::string name( input_filename +
                                  simple_extensions[format_order[i]] );
          infd = open( name.c_str(), O_RDONLY | O_BINARY );
          if( infd >= 0 ) { input_filename = name; break; }
          }
      }
    if( infd < 0 && !no_messages )
      show_file_error( input_filename.c_str(), "Can't open input file",
                       saved_errno );
    }
  return infd;
  }
