.TH XLBIFF 1 2022-01-23
.SH NAME
xlbiff \- mail notification pop-up with configurable message scans
.SH SYNOPSIS
.B xlbiff
[ \fI\-option\fP ... ]
[ \fImail_file_or_imap_server\fP ]
.SH DESCRIPTION
Is \*(lqyou have mail\*(rq not quite enough detail?  Is a per-message
notification too much?  Welcome to
.BR xlbiff ,
the X Literate Biff.
.PP
.B xlbiff
presents enough information to tell you: Is this new mail worth
reading right now?  And it stops distracting you once you decide.
.PP
.B xlbiff
waits in the background, monitoring your mailbox file or IMAP server (or
running your custom check-mail script).  When a new message arrives,
it invokes the MH
.BR scan (1)
command (or your custom mail-scanning
script) and pops up a window with the output (typically the
.I From
and
.I Subject
line of each new message).  If more mail arrives,
.B xlbiff
scans again and resizes its preview window accordingly.
.PP
Clicking the left mouse button anywhere in the window causes it to
vanish.  It will also vanish if the mailbox becomes empty.
.B xlbiff
stays out of your way when there is no new mail and pops up only
when something requests your attention.
.PP
Features:
.PD 0
.IP "" 2
\(bu occupies no screen real estate until mail comes in
.IP "" 2
\(bu supports scripts for checking mail
.IP "" 2
\(bu has configurable screen location, color, and font
.IP "" 2
\(bu can notify by bell and/or keyboard LED
.IP "" 2
\(bu shows all new messages in one, easy-to-dismiss window
.IP "" 2
\(bu lets you click anywhere on it; no trying to select a tiny \*(lqx\*(rq
.PD
.SH "GETTING STARTED"
If your new mail arrives in a local mail file in the usual system directory:
.PP
.RS 4
.ft C
.nf
xlbiff
.fi
.ft
.RE
.PP
If your mail file is in a different location, you will need to specify
the filename:
.PP
.RS 4
.ft C
.nf
xlbiff ~/Mailbox
.fi
.ft
.RE
.PP
If your mail is on an IMAP server, specify the server's name:
.PP
.RS 4
.ft C
.nf
xlbiff imap.example.com
.fi
.ft
.RE
.PP
Whichever way you start xlbiff, if you have new mail, it should pop up a
window displaying summary lines for the new messages.
(If you don't have new mail, you won't see any window, which is how
.B xlbiff
tries to stay out of your way.)
The window will stay visible until you click it away or read the new mail.
.PP
You may need an entry in
.I ~/.netrc
to provide login credentials for your IMAP server.
The format of this file is described in
.BR mailbox-preview (1).
.PP
When you have the correct options to
.B xlbiff
figured out, you will probably want to run it in the background or
start it at the beginning of your X session.
.SH OPTIONS
.B xlbiff
accepts all of the standard X Toolkit command line options along with the
additional options listed below:
.TP 8
\fB\-file\fP \fIfile_or_server_name\fP
This option specifies the name of the file or IMAP server that should
be monitored.  By default, it watches file /var/mail/\fIusername\fP,
where \fIusername\fP is your login name.
.IP
If given the name of an IMAP server,
.BR xlbiff ,
assisted by its default
.I checkCommand/scanCommand
script
.BR mailbox-preview (1),
will peek at your new messages on this server.
.IP
The
.B \-file
is optional; a non-option argument will be treated the same.
.TP 8
.B \-bottom
This option tells
.B xlbiff
to realize/unrealize() the output window instead of using XtPopup/down().
This has the effect of causing the window manager to reposition the window
each time it pops up, and is useful for when you specify negative Y
coordinates, i.e., at the bottom of the screen.  Running
.B xlbiff
in this situation without \-bottom would cause new lines to run off the
bottom edge of the screen.
.TP 8
.B +bottom
Opposite of \-bottom.
.TP 8
\fB\-rows\fP \fIheight\fP
This option specifies the maximum height, in lines of text, of the
.B xlbiff
window.  The default is 20.
.TP 8
\fB\-columns\fP \fIwidth\fP
This option specifies the maximum width, in characters, of the
.B xlbiff
window.  The default is 80.
.TP 8
.B \-resetSaver
If this option is set,
.B xlbiff
will reset the screen saver when new mail comes in.  This is useful if
you're doing something near your workstation but not on it.
.TP 8
.B +resetSaver
Opposite of \-resetSaver.
.TP 8
\fB\-update\fP \fIseconds\fP
This option specifies the frequency in seconds at which
.B xlbiff
should update its display.  The default is 15 seconds.
.TP 8
\fB\-fade\fP \fIseconds\fP
Number of seconds to wait before popping window back down.  This option
can be used to monitor events of non-lasting importance, such as syslog
or UUCP queues.  The default value of 0 disables the
.B fade
option.
.TP 8
\fB\-led\fP \fIledNum\fP
This option specifies a keyboard LED to light up when there is mail waiting
in the \fIfile.\fP  The default is zero (do not light a LED).
.TP 8
.B \-ledPopdown
This option indicates that the LED should be turned off when xlbiff is
popped down.  Ordinarily the LED stays lit to remind one of awaiting mail.
This option has no effect if the \-led option is disabled.
.TP 8
.B +ledPopdown
Opposite of \-ledPopdown.
.TP 8
\fB\-refresh\fP \fIseconds\fP
This option specifies the number of seconds to wait before re-posting the
mail window after you acknowledge it, and it still contains the same mail.
The default is 0 (no refresh).  A useful value for this is 1800 (30 minutes).
.TP 8
\fB\-mailerCommand\fP \fIcommand\fP
Specifies the command to invoke when the mailer() action,
described below, is activated.
Due to mailbox consistency considerations, the
mailerCommand should not exit before it is finished with the mailbox, i.e.,
it should not run its command in the background.
.IP
Example
.B mailerCommand
values:
.IP
.RS 12
.ft C
.nf
xterm -e alpine
emacsclient --eval '(mh-rmail)' --suppress-output
.fi
.ft
.RE
.IP
There is no default
.BR mailerCommand .
.TP 8
\fB\-scanCommand\fP \fIcommand\fP
Specifies a shell command to be executed to list the contents of mailbox
\fBfile\fP.  The specified string value is used as the
argument to a
.BR popen (3)
call and may therefore contain I/O redirection.
The command's stdout is used to generate the window.
Internally, the command is generated as
.IP
.RS 12
.ft C
.nf
sprintf(buf, scanCommand, file, columns, rows)
.fi
.ft
.RE
.IP
so a %s, %d and %d respectively in \fBscanCommand\fP will generate the values
of \fBfile\fP, \fBcolumns\fP, and \fBrows\fP.  The default
.BR scanCommand ,
specified by the
.I XLbiff
application resources file, is
.IP
.RS 12
.ft C
.nf
mailbox\-preview %s \-\-width %d \-\-max\-messages %d 2>&1
.fi
.ft
.RE
.IP
If a
.B scanCommand
is used to change the way the mailbox is accessed (as opposed to
change the way the content is displayed), you will need to supply
a compatible
.BR checkCommand .
.TP 8
\fB\-checkCommand\fP \fIcommand\fP
Specifies a shell command to be executed to check for new mail (or some
other condition) rather than simply examining the size of the mail file.
The specified string value is used as the argument to a
.BR popen (3)
call, and the output generated is important.  Like
.BR xbiff ,
an exit status of
.RS 2
.PD 0
.na
.IP
\(bu 0 indicates that a change in condition demands a new
evaluation of scanCommand and subsequent popup,
.IP
\(bu 1 indicates no change
in status, and
.IP
\(bu 2 indicates that the condition has been cleared and the
.B xlbiff
window should pop down.
.ad
.PD
.RE
.IP
The default, specified by the
.I XLbiff
application resources file, is
.IP
.RS 12
.ft C
.nf
mailbox\-preview %s \-\-check %d
.fi
.ft
.RE
.IP
Similarly to scanCommand, the checkCommand is generated internally as
.IP
.RS 12
.ft C
.nf
sprintf(buf, checkCommand, file, previous)
.fi
.ft
.RE
.IP
.B previous
is the numeric value output by the last time checkCommand was run, or
zero the first time.  This is useful for allowing the checkCommand to
maintain state.
.IP
See the EXAMPLES section, below, for different ways to use checkCommand.
.TP 8
\fB\-volume\fP \fIpercentage\fP
This option specifies how loud the bell should be rung when new mail comes in.
.PP
The following standard X Toolkit command line arguments are commonly used with
.BR xlbiff :
.TP 8
\fB\-display\fP \fIdisplay\fP
This option specifies the X server to contact.
.TP 8
\fB\-geometry\fP \fI+x+y\fP
This option specifies the preferred position of the scan window.
.TP 8
\fB\-bg\fP \fIcolor\fP
This option specifies the color to use for the background of the window.
.TP 8
\fB\-fg\fP \fIcolor\fP
This option specifies the color to use for the foreground of the window.
.TP 8
\fB\-xrm\fP \fIresourcestring\fP
This option specifies a resource string to be used.  This is especially
useful for setting resources that do not have separate command line options.
.TP 8
.B \-help
This option indicates that a brief summary of the allowed options should be
printed on standard output.
.SH RESOURCES
The application class name is XLbiff.
It understands all of the core resource names and classes as well as:
.TP 8
\fBbottom\fP (class \fBBottom\fP)
Same as the \fB\-bottom\fP option.
.TP 8
\fBfile\fP (class \fBFile\fP)
Same as the \fB\-file\fP option.
.TP 8
\fBmailerCommand\fP (class \fBMailerCommand\fP)
Same as the \fB\-mailerCommand\fP option.
.TP 8
\fBscanCommand\fP (class \fBScanCommand\fP)
Same as the \fB\-scanCommand\fP option.
.TP 8
\fBcheckCommand\fP (class \fBCheckCommand\fP)
Same as the \fB\-checkCommand\fP option.
.TP 8
\fBresetSaver\fP (class \fBResetSaver\fP)
Same as the \fB\-resetSaver\fP option.
.TP 8
\fBupdate\fP (class \fBInterval\fP)
Same as the \fB\-update\fP option.
.TP 8
\fBfade\fP (class \fBFade\fP)
Same as the \fB\-fade\fP option.
.TP 8
\fBcolumns\fP (class \fBColumns\fP)
Same as the \fB\-columns\fP option.
.TP 8
\fBrows\fP (class \fBRows\fP)
Specifies the maximum height, in lines, of the
.I xlbiff
window.  The default is 20.
.TP 8
\fBled\fP (class \fBLed\fP)
Same as the \fB\-led\fP option.
.TP 8
\fBledPopdown\fP (class \fBLedPopdown\fP)
Same as the \fB\-ledPopdown\fP option.
.TP 8
\fBrefresh\fP (class \fBRefresh\fP)
Same as the \fB\-refresh\fP option.
.TP 8
\fBsound\fP (class \fBSound\fP)
Specify a command to be run in place of a bell when new mail arrives.
For example, on a Sun Sparc you might use:
.IP
.nf
*sound: /usr/demo/SOUND/play \-v %d /usr/demo/SOUND/sounds/doorbell.au
.fi
.IP
The command is generated internally with
.BR sprintf (3),
so the characters \*(lq%d\*(rq will be replaced with the numeric value of the
.B volume
resource.
.TP 8
\fBvolume\fP (class \fBVolume\fP)
Same as the \fB\-volume\fP option.
.SH ACTIONS
.B xlbiff
provides the following actions for use in event translations:
.TP 8
.B popdown()
This action causes the window to vanish.
.TP 8
.B mailer()
This action causes
.B xlbiff
to pop down the main window and run the defined
.B mailerCommand
(if any), waiting for it to exit.  Then
.B xlbiff
will check for new mail, and if necessary pop up again.
.TP 8
.B exit()
This action causes
.B xlbiff
to exit.
.PP
The default translations are
.PP
.RS 4
.ft C
.nf
<Button1Press>:  popdown()
<Button2Press>:  mailer()
<Button3Press>:  exit()
.fi
.ft
.RE
.SH CUSTOMIZING
You may want to tweak some values in an app-defaults file and/or add
some resources to your .Xdefaults or .Xresources file.  See the system
app-defaults file
.I /etc/X11/app-defaults/XLbiff
for examples of what you can customize.
.PP
You also probably want to tell your
window manager not to put borders or titlebars or whatever around the
.B xlbiff
window.
.PP
Note that an MH format file,
.IR xlbiff.form ,
is included.  This form
.PD 0
.na
.IP "" 2
\(bu omits message number, which is meaningless in this context
.IP "" 2
\(bu omits message size, since \fIscan\ \-file\fP can't figure it out
.IP "" 2
\(bu puts a \*(lq*\*(rq next to the message if your name is on the To: list
(to distinguish from mailing lists and cc's)
.IP "" 2
\(bu displays the date in a friendly format
.IP "" 2
\(bu packs as much subject and body into one line as possible.
.ad
.PD
.SH EXAMPLES
.SS "Bulk maildrops"
.B xlbiff
ships with two sample scripts,
.I Bcheck
and
.IR Bscan ,
intended to be
used in conjunction.  These are for checking mail in \*(lqbulk\*(rq maildrops.
See
.I README.bulk
for more info.
.SS "Laptop fan speed"
.B xlbiff
can be used to display your laptop's temperature sensors only when the
fan is running.  This example uses the
.BR sensors (1)
program as a scanCommand to display the sensor values.  To pop up the
info only when the laptop is hot, we can use a check command that
extracts from the sensors output whether the fan is running and whether
its speed has changed.  Here is a possible check script:
.PP
.RS 4
.ft C
.nf
fan1_speed=$(sensors | sed -E -n '/^fan/{s/.* ([0-9]+).*/\e1/p;q}')
echo "$fan1_speed"
[ "$fan1_speed" = 0 ] && exit 2
[ "$fan1_speed" = "$1" ] && exit 1
exit 0
.fi
.ft
.RE
.PP
If the script is called
.IR xlbiff-fan-check.sh ,
you can use it by running xlbiff like this:
.PP
.RS 4
.ft C
.nf
xlbiff \-checkCommand 'xlbiff\-fan\-check.sh %d' \-scanCommand sensors
.fi
.ft
.RE
.SH ENVIRONMENT
.TP 8
.B DISPLAY
is used to get the default host and display number.
.SH FILES
.TP 8
.I /var/mail/$USER
Default mail file to check.
.TP 8
.I /etc/X11/app-defaults/XLbiff
System app-defaults file for X11 resources.
Override entries here in your own app-defaults file or your own
.I ~/.Xdefaults
or
.I ~/.Xresources
file.
.TP 8
.I ~/.netrc
Login info for your IMAP server.  See
.BR mailbox-preview (1).
.SH "SEE ALSO"
.BR mailbox-preview (1),
.BR scan (1),
.BR X (7)
.SH BUGS
Specifying dimensions in
.B \-geometry
causes badness.
.PP
The \fBled\fP option does not work on Suns before SunOS 4.1/X11R5.
.SH AUTHOR
Ed Santiago <ed@edsantiago.com>
.SH ACKNOWLEDGMENTS
.B xlbiff
took shape around the \fBxgoodbye\fP sample program
in the O'Reilly \fIX Toolkit Intrinsics Programming Manual\fP.  A lot of
code was copied from \fBxbiff\fP, including this man page.  Thanks also
to Stephen Gildea (gildea@expo.lcs.mit.edu) for the many, many
contributions that made
.B xlbiff
grow from a midnight hack to a more mature product.
.PP
The
.I xlbiff.form
file was copied and hacked from Jerry Peek's
excellent Nutshell book
.IR "MH & xmh: Email for Users & Programmers" .
