#include "main.ih"

int handle(exception_ptr ptr)
try
{
    rethrow_exception(ptr);
}
catch(exception const &err)     // handle exceptions
{
    cerr << err.what() << '\n';

                                            // preventa a directory change 
    noInput();                              // if --input wasn't specified

    return Selector::ERROR;
}
catch(int x)
{
    if (ArgConfig::instance().option("hv"))
        x = Selector::USAGE;
    else if (x == Selector::NO_SOLUTIONS)
        cerr << "No Solutions\n";

    noInput();

    return x;
}





