(* This file is generated by Why3's Coq 8.4 driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.

Axiom person : Type.
Parameter person_WhyType : WhyType person.
Existing Instance person_WhyType.

(* Why3 assumption *)
Inductive gender :=
  | Male : gender
  | Female : gender.
Axiom gender_WhyType : WhyType gender.
Existing Instance gender_WhyType.

Parameter gender1: person -> gender.

Parameter father: person -> person.

Parameter mother: person -> person.

Axiom Father_gender : forall (p:person), ((gender1 (father p)) = Male).

Axiom Mother_gender : forall (p:person), ((gender1 (mother p)) = Female).

(* Why3 assumption *)
Definition parent (p:person) (c:person): Prop := (p = (father c)) \/
  (p = (mother c)).

(* Why3 assumption *)
Definition son (s:person) (p:person): Prop := ((gender1 s) = Male) /\ (parent
  p s).

(* Why3 assumption *)
Definition daughter (d:person) (p:person): Prop := ((gender1 d) = Female) /\
  (parent p d).

(* Why3 goal *)
Theorem Child_is_son_or_daughter : forall (c:person) (p:person), (parent p
  c) <-> ((son c p) \/ (daughter c p)).
(* Why3 intros c p. *)
intros c p.
unfold son, daughter, parent.
split.
intros [h|h].
subst p.
destruct (gender1 c).
  left.
  split.
  trivial.
  left.
  trivial.

  right.
  split.
  trivial.
  left.
  trivial.

subst p.
destruct (gender1 c).
  left.
  split.
  trivial.
  right.
  trivial.

  right.
  split.
  trivial.
  right.
  trivial.

intros [(h1,h2)|(h1,h2)].
  trivial.
  trivial.
Qed.


