[comment {-*- tcl -*- doctools manpage}]
[manpage_begin tooltip n 1.6]
[keywords balloon]
[keywords help]
[keywords hover]
[keywords tooltip]
[copyright {1996-2008, Jeffrey Hobbs}]
[moddesc   {Tooltip management}]
[titledesc {Tooltip management}]
[require Tcl 8.5]
[require msgcat 1.3]
[require tooltip [opt 1.6]]
[description]
[para]

This package provides tooltips, small text messages that can be displayed
when the mouse hovers over a widget, menu item, canvas item, listbox or
ttk::treeview item, ttk::notebook tab or text widget tag.

[section {COMMANDS}]

[list_begin definitions]

[call [cmd ::tooltip::tooltip] [arg command] [opt [arg options]]]

Manage the tooltip package using the following subcommands.

[list_begin options]

[opt_def clear [opt [arg pattern]]]

Prevents the specified widgets from showing tooltips. [arg pattern]
is a glob pattern and defaults to matching all widgets.

[opt_def configure [opt "[arg option] [opt "[arg "value option value"] ..."]"]]

Queries or modifies the configuration options of the tooltip. The supported
options are [option -backgroud], [option -foreground] and [option -font]. If no
[arg option] is specified, returns a dictionary of the option values. If one
[arg option] is specified with no value, returns the value of that option.
Otherwise, sets the given [arg option]s to the corresponding [arg value]s.

[opt_def delay [opt [arg millisecs]]]

Query or set the hover delay. This is the interval that the pointer must remain
over the widget before the tooltip is displayed. The delay is specified in
milliseconds and must be greater than or equal to 50 ms.
With no argument the current delay is returned.

[opt_def fade [opt [arg boolean]]]

Enable or disable fading of the tooltip.  The fading is enabled by default on
Win32 and Aqua.  The tooltip will fade away on Leave events instead
disappearing.

[opt_def disable]
[opt_def off]

Disable all tooltips

[opt_def enable]
[opt_def on]

Enables tooltips for defined widgets.

[list_end]

[para]

[call [cmd ::tooltip::tooltip] \
     [arg pathName] [opt [arg "option value"]] [arg message]]

This command arranges for widget [arg pathName] to display a tooltip with
message [arg message].  The tooltip uses a late-binding msgcat call on the
passed in message to allow for on-the-fly language changes in an application.
If the widget specified is a menu, canvas, listbox, ttk::treeview,
ttk::notebook or text widget then additional options are used to tie the
tooltip to specific menu, canvas, listbox or ttk::treeview items, ttk::notebook
tabs or text widget tags.

[list_begin options]

[opt_def -index [arg index]]

This option is used to set a tooltip on a menu item. The index may be
either the entry index or the entry label. The widget must be a menu
widget but the entries do not have to exist when the tooltip is set.

[opt_def -items [arg items]]

This option is used to set a tooltip for canvas, listbox or ttk::treview items.
For the canvas widget, the item must already be present in the canvas and will
be found with a [cmd "find withtag"] lookup.
For listbox and ttk::treview widgets the item(s) may be created later but the
programmer is responsible for managing the link between the listbox or
ttk::treview item index and the corresponding tooltip. If the listbox or
ttk::treview items are re-ordered, the tooltips will need amending.
[para]
If the widget is not a canvas, listbox or ttk::treview then an error is raised.

[opt_def -tab [arg tabId]]

The [option -tab] option can be used to set a tooltip for a ttk::notebook tab.
The tab should already be present when this command is called, or an error will
be returned. The widget must be a ttk::notebook widget.

[opt_def -tag [arg name]]

The [option -tag] option can be used to set a tooltip for a text widget tag.
The tag should already be present when this command is called, or an error will
be returned. The widget must be a text widget.

[opt_def --]

The [option --] option marks the end of options.
The argument following this one will be treated as [arg message] even if it
starts with a -.

[list_end]

[list_end]

[section EXAMPLE]

[example {
# Demonstrate widget tooltip
package require tooltip
pack [label .l -text "label"]
tooltip::tooltip .l "This is a label widget"
}]

[example {
# Demonstrate menu tooltip
package require tooltip
. configure -menu [menu .menu]
.menu add cascade -label Test -menu [menu .menu.test -tearoff 0]
.menu.test add command -label Tooltip
tooltip::tooltip .menu.test -index 0 "This is a menu tooltip"
}]

[example {
# Demonstrate canvas item tooltip
package require tooltip
pack [canvas .c]
set item [.c create rectangle 10 10 80 80 -fill red]
tooltip::tooltip .c -item $item "Canvas item tooltip"
}]

[example {
# Demonstrate listbox item tooltip
package require tooltip
pack [listbox .lb]
.lb insert 0 "item one"
tooltip::tooltip .lb -item 0 "Listbox item tooltip"
}]

[example {
# Demonstrate ttk::notebook tab tooltip
package require tooltip
pack [ttk::notebook .nb]
.nb add [frame .nb.f1 -height 50] -text "First tab"
.nb add [frame .nb.f2 -height 50] -text "Second tab"
tooltip::tooltip .nb -tab 0 "Tooltip for the 1st notebook tab"
tooltip::tooltip .nb -tab 1 "Tooltip for the 2nd notebook tab"
}]

[example {
# Demonstrate text tag tooltip
package require tooltip
pack [text .txt]
.txt tag configure TIP-1 -underline 1
tooltip::tooltip .txt -tag TIP-1 "tooltip one text"
.txt insert end "An example of a " {} "tooltip" TIP-1 " tag.\n" {}
}]
[vset CATEGORY tooltip]
[include ../../support/devel/doc/feedback.inc]
[manpage_end]
