; Full set of standard character sets for SRFI-14.
; Implementors: Generally you can use the 'pre-compiled'
; file, charsets.scm

; Definitions of standard character sets

(define (build-char-set members)
  (list->char-set (filter (lambda (x) x)
                          (map %code-point->char members))))

(define char-set:empty (make-char-set 0))

(define char-set:upper-case
  (build-char-set
   '( #x0041	;LATIN CAPITAL LETTER A
      #x0042	;LATIN CAPITAL LETTER B
      #x0043	;LATIN CAPITAL LETTER C
      #x0044	;LATIN CAPITAL LETTER D
      #x0045	;LATIN CAPITAL LETTER E
      #x0046	;LATIN CAPITAL LETTER F
      #x0047	;LATIN CAPITAL LETTER G
      #x0048	;LATIN CAPITAL LETTER H
      #x0049	;LATIN CAPITAL LETTER I
      #x004A	;LATIN CAPITAL LETTER J
      #x004B	;LATIN CAPITAL LETTER K
      #x004C	;LATIN CAPITAL LETTER L
      #x004D	;LATIN CAPITAL LETTER M
      #x004E	;LATIN CAPITAL LETTER N
      #x004F	;LATIN CAPITAL LETTER O
      #x0050	;LATIN CAPITAL LETTER P
      #x0051	;LATIN CAPITAL LETTER Q
      #x0052	;LATIN CAPITAL LETTER R
      #x0053	;LATIN CAPITAL LETTER S
      #x0054	;LATIN CAPITAL LETTER T
      #x0055	;LATIN CAPITAL LETTER U
      #x0056	;LATIN CAPITAL LETTER V
      #x0057	;LATIN CAPITAL LETTER W
      #x0058	;LATIN CAPITAL LETTER X
      #x0059	;LATIN CAPITAL LETTER Y
      #x005A	;LATIN CAPITAL LETTER Z
      #x00C0	;LATIN CAPITAL LETTER A WITH GRAVE
      #x00C1	;LATIN CAPITAL LETTER A WITH ACUTE
      #x00C2	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX
      #x00C3	;LATIN CAPITAL LETTER A WITH TILDE
      #x00C4	;LATIN CAPITAL LETTER A WITH DIAERESIS
      #x00C5	;LATIN CAPITAL LETTER A WITH RING ABOVE
      #x00C6	;LATIN CAPITAL LETTER AE
      #x00C7	;LATIN CAPITAL LETTER C WITH CEDILLA
      #x00C8	;LATIN CAPITAL LETTER E WITH GRAVE
      #x00C9	;LATIN CAPITAL LETTER E WITH ACUTE
      #x00CA	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX
      #x00CB	;LATIN CAPITAL LETTER E WITH DIAERESIS
      #x00CC	;LATIN CAPITAL LETTER I WITH GRAVE
      #x00CD	;LATIN CAPITAL LETTER I WITH ACUTE
      #x00CE	;LATIN CAPITAL LETTER I WITH CIRCUMFLEX
      #x00CF	;LATIN CAPITAL LETTER I WITH DIAERESIS
      #x00D0	;LATIN CAPITAL LETTER ETH
      #x00D1	;LATIN CAPITAL LETTER N WITH TILDE
      #x00D2	;LATIN CAPITAL LETTER O WITH GRAVE
      #x00D3	;LATIN CAPITAL LETTER O WITH ACUTE
      #x00D4	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX
      #x00D5	;LATIN CAPITAL LETTER O WITH TILDE
      #x00D6	;LATIN CAPITAL LETTER O WITH DIAERESIS
      #x00D8	;LATIN CAPITAL LETTER O WITH STROKE
      #x00D9	;LATIN CAPITAL LETTER U WITH GRAVE
      #x00DA	;LATIN CAPITAL LETTER U WITH ACUTE
      #x00DB	;LATIN CAPITAL LETTER U WITH CIRCUMFLEX
      #x00DC	;LATIN CAPITAL LETTER U WITH DIAERESIS
      #x00DD	;LATIN CAPITAL LETTER Y WITH ACUTE
      #x00DE	;LATIN CAPITAL LETTER THORN
      #x0100	;LATIN CAPITAL LETTER A WITH MACRON
      #x0102	;LATIN CAPITAL LETTER A WITH BREVE
      #x0104	;LATIN CAPITAL LETTER A WITH OGONEK
      #x0106	;LATIN CAPITAL LETTER C WITH ACUTE
      #x0108	;LATIN CAPITAL LETTER C WITH CIRCUMFLEX
      #x010A	;LATIN CAPITAL LETTER C WITH DOT ABOVE
      #x010C	;LATIN CAPITAL LETTER C WITH CARON
      #x010E	;LATIN CAPITAL LETTER D WITH CARON
      #x0110	;LATIN CAPITAL LETTER D WITH STROKE
      #x0112	;LATIN CAPITAL LETTER E WITH MACRON
      #x0114	;LATIN CAPITAL LETTER E WITH BREVE
      #x0116	;LATIN CAPITAL LETTER E WITH DOT ABOVE
      #x0118	;LATIN CAPITAL LETTER E WITH OGONEK
      #x011A	;LATIN CAPITAL LETTER E WITH CARON
      #x011C	;LATIN CAPITAL LETTER G WITH CIRCUMFLEX
      #x011E	;LATIN CAPITAL LETTER G WITH BREVE
      #x0120	;LATIN CAPITAL LETTER G WITH DOT ABOVE
      #x0122	;LATIN CAPITAL LETTER G WITH CEDILLA
      #x0124	;LATIN CAPITAL LETTER H WITH CIRCUMFLEX
      #x0126	;LATIN CAPITAL LETTER H WITH STROKE
      #x0128	;LATIN CAPITAL LETTER I WITH TILDE
      #x012A	;LATIN CAPITAL LETTER I WITH MACRON
      #x012C	;LATIN CAPITAL LETTER I WITH BREVE
      #x012E	;LATIN CAPITAL LETTER I WITH OGONEK
      #x0130	;LATIN CAPITAL LETTER I WITH DOT ABOVE
      #x0132	;LATIN CAPITAL LIGATURE IJ
      #x0134	;LATIN CAPITAL LETTER J WITH CIRCUMFLEX
      #x0136	;LATIN CAPITAL LETTER K WITH CEDILLA
      #x0139	;LATIN CAPITAL LETTER L WITH ACUTE
      #x013B	;LATIN CAPITAL LETTER L WITH CEDILLA
      #x013D	;LATIN CAPITAL LETTER L WITH CARON
      #x013F	;LATIN CAPITAL LETTER L WITH MIDDLE DOT
      #x0141	;LATIN CAPITAL LETTER L WITH STROKE
      #x0143	;LATIN CAPITAL LETTER N WITH ACUTE
      #x0145	;LATIN CAPITAL LETTER N WITH CEDILLA
      #x0147	;LATIN CAPITAL LETTER N WITH CARON
      #x014A	;LATIN CAPITAL LETTER ENG
      #x014C	;LATIN CAPITAL LETTER O WITH MACRON
      #x014E	;LATIN CAPITAL LETTER O WITH BREVE
      #x0150	;LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
      #x0152	;LATIN CAPITAL LIGATURE OE
      #x0154	;LATIN CAPITAL LETTER R WITH ACUTE
      #x0156	;LATIN CAPITAL LETTER R WITH CEDILLA
      #x0158	;LATIN CAPITAL LETTER R WITH CARON
      #x015A	;LATIN CAPITAL LETTER S WITH ACUTE
      #x015C	;LATIN CAPITAL LETTER S WITH CIRCUMFLEX
      #x015E	;LATIN CAPITAL LETTER S WITH CEDILLA
      #x0160	;LATIN CAPITAL LETTER S WITH CARON
      #x0162	;LATIN CAPITAL LETTER T WITH CEDILLA
      #x0164	;LATIN CAPITAL LETTER T WITH CARON
      #x0166	;LATIN CAPITAL LETTER T WITH STROKE
      #x0168	;LATIN CAPITAL LETTER U WITH TILDE
      #x016A	;LATIN CAPITAL LETTER U WITH MACRON
      #x016C	;LATIN CAPITAL LETTER U WITH BREVE
      #x016E	;LATIN CAPITAL LETTER U WITH RING ABOVE
      #x0170	;LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
      #x0172	;LATIN CAPITAL LETTER U WITH OGONEK
      #x0174	;LATIN CAPITAL LETTER W WITH CIRCUMFLEX
      #x0176	;LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
      #x0178	;LATIN CAPITAL LETTER Y WITH DIAERESIS
      #x0179	;LATIN CAPITAL LETTER Z WITH ACUTE
      #x017B	;LATIN CAPITAL LETTER Z WITH DOT ABOVE
      #x017D	;LATIN CAPITAL LETTER Z WITH CARON
      #x0181	;LATIN CAPITAL LETTER B WITH HOOK
      #x0182	;LATIN CAPITAL LETTER B WITH TOPBAR
      #x0184	;LATIN CAPITAL LETTER TONE SIX
      #x0186	;LATIN CAPITAL LETTER OPEN O
      #x0187	;LATIN CAPITAL LETTER C WITH HOOK
      #x0189	;LATIN CAPITAL LETTER AFRICAN D
      #x018A	;LATIN CAPITAL LETTER D WITH HOOK
      #x018B	;LATIN CAPITAL LETTER D WITH TOPBAR
      #x018E	;LATIN CAPITAL LETTER REVERSED E
      #x018F	;LATIN CAPITAL LETTER SCHWA
      #x0190	;LATIN CAPITAL LETTER OPEN E
      #x0191	;LATIN CAPITAL LETTER F WITH HOOK
      #x0193	;LATIN CAPITAL LETTER G WITH HOOK
      #x0194	;LATIN CAPITAL LETTER GAMMA
      #x0196	;LATIN CAPITAL LETTER IOTA
      #x0197	;LATIN CAPITAL LETTER I WITH STROKE
      #x0198	;LATIN CAPITAL LETTER K WITH HOOK
      #x019C	;LATIN CAPITAL LETTER TURNED M
      #x019D	;LATIN CAPITAL LETTER N WITH LEFT HOOK
      #x019F	;LATIN CAPITAL LETTER O WITH MIDDLE TILDE
      #x01A0	;LATIN CAPITAL LETTER O WITH HORN
      #x01A2	;LATIN CAPITAL LETTER OI
      #x01A4	;LATIN CAPITAL LETTER P WITH HOOK
      #x01A6	;LATIN LETTER YR
      #x01A7	;LATIN CAPITAL LETTER TONE TWO
      #x01A9	;LATIN CAPITAL LETTER ESH
      #x01AC	;LATIN CAPITAL LETTER T WITH HOOK
      #x01AE	;LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
      #x01AF	;LATIN CAPITAL LETTER U WITH HORN
      #x01B1	;LATIN CAPITAL LETTER UPSILON
      #x01B2	;LATIN CAPITAL LETTER V WITH HOOK
      #x01B3	;LATIN CAPITAL LETTER Y WITH HOOK
      #x01B5	;LATIN CAPITAL LETTER Z WITH STROKE
      #x01B7	;LATIN CAPITAL LETTER EZH
      #x01B8	;LATIN CAPITAL LETTER EZH REVERSED
      #x01BC	;LATIN CAPITAL LETTER TONE FIVE
      #x01C4	;LATIN CAPITAL LETTER DZ WITH CARON
      #x01C7	;LATIN CAPITAL LETTER LJ
      #x01CA	;LATIN CAPITAL LETTER NJ
      #x01CD	;LATIN CAPITAL LETTER A WITH CARON
      #x01CF	;LATIN CAPITAL LETTER I WITH CARON
      #x01D1	;LATIN CAPITAL LETTER O WITH CARON
      #x01D3	;LATIN CAPITAL LETTER U WITH CARON
      #x01D5	;LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
      #x01D7	;LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
      #x01D9	;LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
      #x01DB	;LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
      #x01DE	;LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
      #x01E0	;LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
      #x01E2	;LATIN CAPITAL LETTER AE WITH MACRON
      #x01E4	;LATIN CAPITAL LETTER G WITH STROKE
      #x01E6	;LATIN CAPITAL LETTER G WITH CARON
      #x01E8	;LATIN CAPITAL LETTER K WITH CARON
      #x01EA	;LATIN CAPITAL LETTER O WITH OGONEK
      #x01EC	;LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
      #x01EE	;LATIN CAPITAL LETTER EZH WITH CARON
      #x01F1	;LATIN CAPITAL LETTER DZ
      #x01F4	;LATIN CAPITAL LETTER G WITH ACUTE
      #x01F6	;LATIN CAPITAL LETTER HWAIR
      #x01F7	;LATIN CAPITAL LETTER WYNN
      #x01F8	;LATIN CAPITAL LETTER N WITH GRAVE
      #x01FA	;LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
      #x01FC	;LATIN CAPITAL LETTER AE WITH ACUTE
      #x01FE	;LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
      #x0200	;LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
      #x0202	;LATIN CAPITAL LETTER A WITH INVERTED BREVE
      #x0204	;LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
      #x0206	;LATIN CAPITAL LETTER E WITH INVERTED BREVE
      #x0208	;LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
      #x020A	;LATIN CAPITAL LETTER I WITH INVERTED BREVE
      #x020C	;LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
      #x020E	;LATIN CAPITAL LETTER O WITH INVERTED BREVE
      #x0210	;LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
      #x0212	;LATIN CAPITAL LETTER R WITH INVERTED BREVE
      #x0214	;LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
      #x0216	;LATIN CAPITAL LETTER U WITH INVERTED BREVE
      #x0218	;LATIN CAPITAL LETTER S WITH COMMA BELOW
      #x021A	;LATIN CAPITAL LETTER T WITH COMMA BELOW
      #x021C	;LATIN CAPITAL LETTER YOGH
      #x021E	;LATIN CAPITAL LETTER H WITH CARON
      #x0220	;LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
      #x0222	;LATIN CAPITAL LETTER OU
      #x0224	;LATIN CAPITAL LETTER Z WITH HOOK
      #x0226	;LATIN CAPITAL LETTER A WITH DOT ABOVE
      #x0228	;LATIN CAPITAL LETTER E WITH CEDILLA
      #x022A	;LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
      #x022C	;LATIN CAPITAL LETTER O WITH TILDE AND MACRON
      #x022E	;LATIN CAPITAL LETTER O WITH DOT ABOVE
      #x0230	;LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
      #x0232	;LATIN CAPITAL LETTER Y WITH MACRON
      #x0386	;GREEK CAPITAL LETTER ALPHA WITH TONOS
      #x0388	;GREEK CAPITAL LETTER EPSILON WITH TONOS
      #x0389	;GREEK CAPITAL LETTER ETA WITH TONOS
      #x038A	;GREEK CAPITAL LETTER IOTA WITH TONOS
      #x038C	;GREEK CAPITAL LETTER OMICRON WITH TONOS
      #x038E	;GREEK CAPITAL LETTER UPSILON WITH TONOS
      #x038F	;GREEK CAPITAL LETTER OMEGA WITH TONOS
      #x0391	;GREEK CAPITAL LETTER ALPHA
      #x0392	;GREEK CAPITAL LETTER BETA
      #x0393	;GREEK CAPITAL LETTER GAMMA
      #x0394	;GREEK CAPITAL LETTER DELTA
      #x0395	;GREEK CAPITAL LETTER EPSILON
      #x0396	;GREEK CAPITAL LETTER ZETA
      #x0397	;GREEK CAPITAL LETTER ETA
      #x0398	;GREEK CAPITAL LETTER THETA
      #x0399	;GREEK CAPITAL LETTER IOTA
      #x039A	;GREEK CAPITAL LETTER KAPPA
      #x039B	;GREEK CAPITAL LETTER LAMDA
      #x039C	;GREEK CAPITAL LETTER MU
      #x039D	;GREEK CAPITAL LETTER NU
      #x039E	;GREEK CAPITAL LETTER XI
      #x039F	;GREEK CAPITAL LETTER OMICRON
      #x03A0	;GREEK CAPITAL LETTER PI
      #x03A1	;GREEK CAPITAL LETTER RHO
      #x03A3	;GREEK CAPITAL LETTER SIGMA
      #x03A4	;GREEK CAPITAL LETTER TAU
      #x03A5	;GREEK CAPITAL LETTER UPSILON
      #x03A6	;GREEK CAPITAL LETTER PHI
      #x03A7	;GREEK CAPITAL LETTER CHI
      #x03A8	;GREEK CAPITAL LETTER PSI
      #x03A9	;GREEK CAPITAL LETTER OMEGA
      #x03AA	;GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
      #x03AB	;GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
      #x03D8	;GREEK LETTER ARCHAIC KOPPA
      #x03DA	;GREEK LETTER STIGMA
      #x03DC	;GREEK LETTER DIGAMMA
      #x03DE	;GREEK LETTER KOPPA
      #x03E0	;GREEK LETTER SAMPI
      #x03E2	;COPTIC CAPITAL LETTER SHEI
      #x03E4	;COPTIC CAPITAL LETTER FEI
      #x03E6	;COPTIC CAPITAL LETTER KHEI
      #x03E8	;COPTIC CAPITAL LETTER HORI
      #x03EA	;COPTIC CAPITAL LETTER GANGIA
      #x03EC	;COPTIC CAPITAL LETTER SHIMA
      #x03EE	;COPTIC CAPITAL LETTER DEI
      #x03F4	;GREEK CAPITAL THETA SYMBOL
      #x03F7	;GREEK CAPITAL LETTER SHO
      #x03F9	;GREEK CAPITAL LUNATE SIGMA SYMBOL
      #x03FA	;GREEK CAPITAL LETTER SAN
      #x0400	;CYRILLIC CAPITAL LETTER IE WITH GRAVE
      #x0401	;CYRILLIC CAPITAL LETTER IO
      #x0402	;CYRILLIC CAPITAL LETTER DJE
      #x0403	;CYRILLIC CAPITAL LETTER GJE
      #x0404	;CYRILLIC CAPITAL LETTER UKRAINIAN IE
      #x0405	;CYRILLIC CAPITAL LETTER DZE
      #x0406	;CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
      #x0407	;CYRILLIC CAPITAL LETTER YI
      #x0408	;CYRILLIC CAPITAL LETTER JE
      #x0409	;CYRILLIC CAPITAL LETTER LJE
      #x040A	;CYRILLIC CAPITAL LETTER NJE
      #x040B	;CYRILLIC CAPITAL LETTER TSHE
      #x040C	;CYRILLIC CAPITAL LETTER KJE
      #x040D	;CYRILLIC CAPITAL LETTER I WITH GRAVE
      #x040E	;CYRILLIC CAPITAL LETTER SHORT U
      #x040F	;CYRILLIC CAPITAL LETTER DZHE
      #x0410	;CYRILLIC CAPITAL LETTER A
      #x0411	;CYRILLIC CAPITAL LETTER BE
      #x0412	;CYRILLIC CAPITAL LETTER VE
      #x0413	;CYRILLIC CAPITAL LETTER GHE
      #x0414	;CYRILLIC CAPITAL LETTER DE
      #x0415	;CYRILLIC CAPITAL LETTER IE
      #x0416	;CYRILLIC CAPITAL LETTER ZHE
      #x0417	;CYRILLIC CAPITAL LETTER ZE
      #x0418	;CYRILLIC CAPITAL LETTER I
      #x0419	;CYRILLIC CAPITAL LETTER SHORT I
      #x041A	;CYRILLIC CAPITAL LETTER KA
      #x041B	;CYRILLIC CAPITAL LETTER EL
      #x041C	;CYRILLIC CAPITAL LETTER EM
      #x041D	;CYRILLIC CAPITAL LETTER EN
      #x041E	;CYRILLIC CAPITAL LETTER O
      #x041F	;CYRILLIC CAPITAL LETTER PE
      #x0420	;CYRILLIC CAPITAL LETTER ER
      #x0421	;CYRILLIC CAPITAL LETTER ES
      #x0422	;CYRILLIC CAPITAL LETTER TE
      #x0423	;CYRILLIC CAPITAL LETTER U
      #x0424	;CYRILLIC CAPITAL LETTER EF
      #x0425	;CYRILLIC CAPITAL LETTER HA
      #x0426	;CYRILLIC CAPITAL LETTER TSE
      #x0427	;CYRILLIC CAPITAL LETTER CHE
      #x0428	;CYRILLIC CAPITAL LETTER SHA
      #x0429	;CYRILLIC CAPITAL LETTER SHCHA
      #x042A	;CYRILLIC CAPITAL LETTER HARD SIGN
      #x042B	;CYRILLIC CAPITAL LETTER YERU
      #x042C	;CYRILLIC CAPITAL LETTER SOFT SIGN
      #x042D	;CYRILLIC CAPITAL LETTER E
      #x042E	;CYRILLIC CAPITAL LETTER YU
      #x042F	;CYRILLIC CAPITAL LETTER YA
      #x0460	;CYRILLIC CAPITAL LETTER OMEGA
      #x0462	;CYRILLIC CAPITAL LETTER YAT
      #x0464	;CYRILLIC CAPITAL LETTER IOTIFIED E
      #x0466	;CYRILLIC CAPITAL LETTER LITTLE YUS
      #x0468	;CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
      #x046A	;CYRILLIC CAPITAL LETTER BIG YUS
      #x046C	;CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
      #x046E	;CYRILLIC CAPITAL LETTER KSI
      #x0470	;CYRILLIC CAPITAL LETTER PSI
      #x0472	;CYRILLIC CAPITAL LETTER FITA
      #x0474	;CYRILLIC CAPITAL LETTER IZHITSA
      #x0476	;CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
      #x0478	;CYRILLIC CAPITAL LETTER UK
      #x047A	;CYRILLIC CAPITAL LETTER ROUND OMEGA
      #x047C	;CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
      #x047E	;CYRILLIC CAPITAL LETTER OT
      #x0480	;CYRILLIC CAPITAL LETTER KOPPA
      #x048A	;CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
      #x048C	;CYRILLIC CAPITAL LETTER SEMISOFT SIGN
      #x048E	;CYRILLIC CAPITAL LETTER ER WITH TICK
      #x0490	;CYRILLIC CAPITAL LETTER GHE WITH UPTURN
      #x0492	;CYRILLIC CAPITAL LETTER GHE WITH STROKE
      #x0494	;CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
      #x0496	;CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
      #x0498	;CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
      #x049A	;CYRILLIC CAPITAL LETTER KA WITH DESCENDER
      #x049C	;CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
      #x049E	;CYRILLIC CAPITAL LETTER KA WITH STROKE
      #x04A0	;CYRILLIC CAPITAL LETTER BASHKIR KA
      #x04A2	;CYRILLIC CAPITAL LETTER EN WITH DESCENDER
      #x04A4	;CYRILLIC CAPITAL LIGATURE EN GHE
      #x04A6	;CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
      #x04A8	;CYRILLIC CAPITAL LETTER ABKHASIAN HA
      #x04AA	;CYRILLIC CAPITAL LETTER ES WITH DESCENDER
      #x04AC	;CYRILLIC CAPITAL LETTER TE WITH DESCENDER
      #x04AE	;CYRILLIC CAPITAL LETTER STRAIGHT U
      #x04B0	;CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
      #x04B2	;CYRILLIC CAPITAL LETTER HA WITH DESCENDER
      #x04B4	;CYRILLIC CAPITAL LIGATURE TE TSE
      #x04B6	;CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
      #x04B8	;CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
      #x04BA	;CYRILLIC CAPITAL LETTER SHHA
      #x04BC	;CYRILLIC CAPITAL LETTER ABKHASIAN CHE
      #x04BE	;CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
      #x04C1	;CYRILLIC CAPITAL LETTER ZHE WITH BREVE
      #x04C3	;CYRILLIC CAPITAL LETTER KA WITH HOOK
      #x04C5	;CYRILLIC CAPITAL LETTER EL WITH TAIL
      #x04C7	;CYRILLIC CAPITAL LETTER EN WITH HOOK
      #x04C9	;CYRILLIC CAPITAL LETTER EN WITH TAIL
      #x04CB	;CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
      #x04CD	;CYRILLIC CAPITAL LETTER EM WITH TAIL
      #x04D0	;CYRILLIC CAPITAL LETTER A WITH BREVE
      #x04D2	;CYRILLIC CAPITAL LETTER A WITH DIAERESIS
      #x04D4	;CYRILLIC CAPITAL LIGATURE A IE
      #x04D6	;CYRILLIC CAPITAL LETTER IE WITH BREVE
      #x04D8	;CYRILLIC CAPITAL LETTER SCHWA
      #x04DA	;CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
      #x04DC	;CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
      #x04DE	;CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
      #x04E0	;CYRILLIC CAPITAL LETTER ABKHASIAN DZE
      #x04E2	;CYRILLIC CAPITAL LETTER I WITH MACRON
      #x04E4	;CYRILLIC CAPITAL LETTER I WITH DIAERESIS
      #x04E6	;CYRILLIC CAPITAL LETTER O WITH DIAERESIS
      #x04E8	;CYRILLIC CAPITAL LETTER BARRED O
      #x04EA	;CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
      #x04EC	;CYRILLIC CAPITAL LETTER E WITH DIAERESIS
      #x04EE	;CYRILLIC CAPITAL LETTER U WITH MACRON
      #x04F0	;CYRILLIC CAPITAL LETTER U WITH DIAERESIS
      #x04F2	;CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
      #x04F4	;CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
      #x04F8	;CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
      #x0500	;CYRILLIC CAPITAL LETTER KOMI DE
      #x0502	;CYRILLIC CAPITAL LETTER KOMI DJE
      #x0504	;CYRILLIC CAPITAL LETTER KOMI ZJE
      #x0506	;CYRILLIC CAPITAL LETTER KOMI DZJE
      #x0508	;CYRILLIC CAPITAL LETTER KOMI LJE
      #x050A	;CYRILLIC CAPITAL LETTER KOMI NJE
      #x050C	;CYRILLIC CAPITAL LETTER KOMI SJE
      #x050E	;CYRILLIC CAPITAL LETTER KOMI TJE
      #x0531	;ARMENIAN CAPITAL LETTER AYB
      #x0532	;ARMENIAN CAPITAL LETTER BEN
      #x0533	;ARMENIAN CAPITAL LETTER GIM
      #x0534	;ARMENIAN CAPITAL LETTER DA
      #x0535	;ARMENIAN CAPITAL LETTER ECH
      #x0536	;ARMENIAN CAPITAL LETTER ZA
      #x0537	;ARMENIAN CAPITAL LETTER EH
      #x0538	;ARMENIAN CAPITAL LETTER ET
      #x0539	;ARMENIAN CAPITAL LETTER TO
      #x053A	;ARMENIAN CAPITAL LETTER ZHE
      #x053B	;ARMENIAN CAPITAL LETTER INI
      #x053C	;ARMENIAN CAPITAL LETTER LIWN
      #x053D	;ARMENIAN CAPITAL LETTER XEH
      #x053E	;ARMENIAN CAPITAL LETTER CA
      #x053F	;ARMENIAN CAPITAL LETTER KEN
      #x0540	;ARMENIAN CAPITAL LETTER HO
      #x0541	;ARMENIAN CAPITAL LETTER JA
      #x0542	;ARMENIAN CAPITAL LETTER GHAD
      #x0543	;ARMENIAN CAPITAL LETTER CHEH
      #x0544	;ARMENIAN CAPITAL LETTER MEN
      #x0545	;ARMENIAN CAPITAL LETTER YI
      #x0546	;ARMENIAN CAPITAL LETTER NOW
      #x0547	;ARMENIAN CAPITAL LETTER SHA
      #x0548	;ARMENIAN CAPITAL LETTER VO
      #x0549	;ARMENIAN CAPITAL LETTER CHA
      #x054A	;ARMENIAN CAPITAL LETTER PEH
      #x054B	;ARMENIAN CAPITAL LETTER JHEH
      #x054C	;ARMENIAN CAPITAL LETTER RA
      #x054D	;ARMENIAN CAPITAL LETTER SEH
      #x054E	;ARMENIAN CAPITAL LETTER VEW
      #x054F	;ARMENIAN CAPITAL LETTER TIWN
      #x0550	;ARMENIAN CAPITAL LETTER REH
      #x0551	;ARMENIAN CAPITAL LETTER CO
      #x0552	;ARMENIAN CAPITAL LETTER YIWN
      #x0553	;ARMENIAN CAPITAL LETTER PIWR
      #x0554	;ARMENIAN CAPITAL LETTER KEH
      #x0555	;ARMENIAN CAPITAL LETTER OH
      #x0556	;ARMENIAN CAPITAL LETTER FEH
      #x10A0	;GEORGIAN CAPITAL LETTER AN
      #x10A1	;GEORGIAN CAPITAL LETTER BAN
      #x10A2	;GEORGIAN CAPITAL LETTER GAN
      #x10A3	;GEORGIAN CAPITAL LETTER DON
      #x10A4	;GEORGIAN CAPITAL LETTER EN
      #x10A5	;GEORGIAN CAPITAL LETTER VIN
      #x10A6	;GEORGIAN CAPITAL LETTER ZEN
      #x10A7	;GEORGIAN CAPITAL LETTER TAN
      #x10A8	;GEORGIAN CAPITAL LETTER IN
      #x10A9	;GEORGIAN CAPITAL LETTER KAN
      #x10AA	;GEORGIAN CAPITAL LETTER LAS
      #x10AB	;GEORGIAN CAPITAL LETTER MAN
      #x10AC	;GEORGIAN CAPITAL LETTER NAR
      #x10AD	;GEORGIAN CAPITAL LETTER ON
      #x10AE	;GEORGIAN CAPITAL LETTER PAR
      #x10AF	;GEORGIAN CAPITAL LETTER ZHAR
      #x10B0	;GEORGIAN CAPITAL LETTER RAE
      #x10B1	;GEORGIAN CAPITAL LETTER SAN
      #x10B2	;GEORGIAN CAPITAL LETTER TAR
      #x10B3	;GEORGIAN CAPITAL LETTER UN
      #x10B4	;GEORGIAN CAPITAL LETTER PHAR
      #x10B5	;GEORGIAN CAPITAL LETTER KHAR
      #x10B6	;GEORGIAN CAPITAL LETTER GHAN
      #x10B7	;GEORGIAN CAPITAL LETTER QAR
      #x10B8	;GEORGIAN CAPITAL LETTER SHIN
      #x10B9	;GEORGIAN CAPITAL LETTER CHIN
      #x10BA	;GEORGIAN CAPITAL LETTER CAN
      #x10BB	;GEORGIAN CAPITAL LETTER JIL
      #x10BC	;GEORGIAN CAPITAL LETTER CIL
      #x10BD	;GEORGIAN CAPITAL LETTER CHAR
      #x10BE	;GEORGIAN CAPITAL LETTER XAN
      #x10BF	;GEORGIAN CAPITAL LETTER JHAN
      #x10C0	;GEORGIAN CAPITAL LETTER HAE
      #x10C1	;GEORGIAN CAPITAL LETTER HE
      #x10C2	;GEORGIAN CAPITAL LETTER HIE
      #x10C3	;GEORGIAN CAPITAL LETTER WE
      #x10C4	;GEORGIAN CAPITAL LETTER HAR
      #x10C5	;GEORGIAN CAPITAL LETTER HOE
      #x1E00	;LATIN CAPITAL LETTER A WITH RING BELOW
      #x1E02	;LATIN CAPITAL LETTER B WITH DOT ABOVE
      #x1E04	;LATIN CAPITAL LETTER B WITH DOT BELOW
      #x1E06	;LATIN CAPITAL LETTER B WITH LINE BELOW
      #x1E08	;LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
      #x1E0A	;LATIN CAPITAL LETTER D WITH DOT ABOVE
      #x1E0C	;LATIN CAPITAL LETTER D WITH DOT BELOW
      #x1E0E	;LATIN CAPITAL LETTER D WITH LINE BELOW
      #x1E10	;LATIN CAPITAL LETTER D WITH CEDILLA
      #x1E12	;LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
      #x1E14	;LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
      #x1E16	;LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
      #x1E18	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
      #x1E1A	;LATIN CAPITAL LETTER E WITH TILDE BELOW
      #x1E1C	;LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
      #x1E1E	;LATIN CAPITAL LETTER F WITH DOT ABOVE
      #x1E20	;LATIN CAPITAL LETTER G WITH MACRON
      #x1E22	;LATIN CAPITAL LETTER H WITH DOT ABOVE
      #x1E24	;LATIN CAPITAL LETTER H WITH DOT BELOW
      #x1E26	;LATIN CAPITAL LETTER H WITH DIAERESIS
      #x1E28	;LATIN CAPITAL LETTER H WITH CEDILLA
      #x1E2A	;LATIN CAPITAL LETTER H WITH BREVE BELOW
      #x1E2C	;LATIN CAPITAL LETTER I WITH TILDE BELOW
      #x1E2E	;LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
      #x1E30	;LATIN CAPITAL LETTER K WITH ACUTE
      #x1E32	;LATIN CAPITAL LETTER K WITH DOT BELOW
      #x1E34	;LATIN CAPITAL LETTER K WITH LINE BELOW
      #x1E36	;LATIN CAPITAL LETTER L WITH DOT BELOW
      #x1E38	;LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
      #x1E3A	;LATIN CAPITAL LETTER L WITH LINE BELOW
      #x1E3C	;LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
      #x1E3E	;LATIN CAPITAL LETTER M WITH ACUTE
      #x1E40	;LATIN CAPITAL LETTER M WITH DOT ABOVE
      #x1E42	;LATIN CAPITAL LETTER M WITH DOT BELOW
      #x1E44	;LATIN CAPITAL LETTER N WITH DOT ABOVE
      #x1E46	;LATIN CAPITAL LETTER N WITH DOT BELOW
      #x1E48	;LATIN CAPITAL LETTER N WITH LINE BELOW
      #x1E4A	;LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
      #x1E4C	;LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
      #x1E4E	;LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
      #x1E50	;LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
      #x1E52	;LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
      #x1E54	;LATIN CAPITAL LETTER P WITH ACUTE
      #x1E56	;LATIN CAPITAL LETTER P WITH DOT ABOVE
      #x1E58	;LATIN CAPITAL LETTER R WITH DOT ABOVE
      #x1E5A	;LATIN CAPITAL LETTER R WITH DOT BELOW
      #x1E5C	;LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
      #x1E5E	;LATIN CAPITAL LETTER R WITH LINE BELOW
      #x1E60	;LATIN CAPITAL LETTER S WITH DOT ABOVE
      #x1E62	;LATIN CAPITAL LETTER S WITH DOT BELOW
      #x1E64	;LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
      #x1E66	;LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
      #x1E68	;LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
      #x1E6A	;LATIN CAPITAL LETTER T WITH DOT ABOVE
      #x1E6C	;LATIN CAPITAL LETTER T WITH DOT BELOW
      #x1E6E	;LATIN CAPITAL LETTER T WITH LINE BELOW
      #x1E70	;LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
      #x1E72	;LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
      #x1E74	;LATIN CAPITAL LETTER U WITH TILDE BELOW
      #x1E76	;LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
      #x1E78	;LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
      #x1E7A	;LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
      #x1E7C	;LATIN CAPITAL LETTER V WITH TILDE
      #x1E7E	;LATIN CAPITAL LETTER V WITH DOT BELOW
      #x1E80	;LATIN CAPITAL LETTER W WITH GRAVE
      #x1E82	;LATIN CAPITAL LETTER W WITH ACUTE
      #x1E84	;LATIN CAPITAL LETTER W WITH DIAERESIS
      #x1E86	;LATIN CAPITAL LETTER W WITH DOT ABOVE
      #x1E88	;LATIN CAPITAL LETTER W WITH DOT BELOW
      #x1E8A	;LATIN CAPITAL LETTER X WITH DOT ABOVE
      #x1E8C	;LATIN CAPITAL LETTER X WITH DIAERESIS
      #x1E8E	;LATIN CAPITAL LETTER Y WITH DOT ABOVE
      #x1E90	;LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
      #x1E92	;LATIN CAPITAL LETTER Z WITH DOT BELOW
      #x1E94	;LATIN CAPITAL LETTER Z WITH LINE BELOW
      #x1EA0	;LATIN CAPITAL LETTER A WITH DOT BELOW
      #x1EA2	;LATIN CAPITAL LETTER A WITH HOOK ABOVE
      #x1EA4	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
      #x1EA6	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
      #x1EA8	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EAA	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
      #x1EAC	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
      #x1EAE	;LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
      #x1EB0	;LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
      #x1EB2	;LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
      #x1EB4	;LATIN CAPITAL LETTER A WITH BREVE AND TILDE
      #x1EB6	;LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
      #x1EB8	;LATIN CAPITAL LETTER E WITH DOT BELOW
      #x1EBA	;LATIN CAPITAL LETTER E WITH HOOK ABOVE
      #x1EBC	;LATIN CAPITAL LETTER E WITH TILDE
      #x1EBE	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
      #x1EC0	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
      #x1EC2	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EC4	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
      #x1EC6	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
      #x1EC8	;LATIN CAPITAL LETTER I WITH HOOK ABOVE
      #x1ECA	;LATIN CAPITAL LETTER I WITH DOT BELOW
      #x1ECC	;LATIN CAPITAL LETTER O WITH DOT BELOW
      #x1ECE	;LATIN CAPITAL LETTER O WITH HOOK ABOVE
      #x1ED0	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
      #x1ED2	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
      #x1ED4	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
      #x1ED6	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
      #x1ED8	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
      #x1EDA	;LATIN CAPITAL LETTER O WITH HORN AND ACUTE
      #x1EDC	;LATIN CAPITAL LETTER O WITH HORN AND GRAVE
      #x1EDE	;LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
      #x1EE0	;LATIN CAPITAL LETTER O WITH HORN AND TILDE
      #x1EE2	;LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
      #x1EE4	;LATIN CAPITAL LETTER U WITH DOT BELOW
      #x1EE6	;LATIN CAPITAL LETTER U WITH HOOK ABOVE
      #x1EE8	;LATIN CAPITAL LETTER U WITH HORN AND ACUTE
      #x1EEA	;LATIN CAPITAL LETTER U WITH HORN AND GRAVE
      #x1EEC	;LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
      #x1EEE	;LATIN CAPITAL LETTER U WITH HORN AND TILDE
      #x1EF0	;LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
      #x1EF2	;LATIN CAPITAL LETTER Y WITH GRAVE
      #x1EF4	;LATIN CAPITAL LETTER Y WITH DOT BELOW
      #x1EF6	;LATIN CAPITAL LETTER Y WITH HOOK ABOVE
      #x1EF8	;LATIN CAPITAL LETTER Y WITH TILDE
      #x1F08	;GREEK CAPITAL LETTER ALPHA WITH PSILI
      #x1F09	;GREEK CAPITAL LETTER ALPHA WITH DASIA
      #x1F0A	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
      #x1F0B	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
      #x1F0C	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
      #x1F0D	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
      #x1F0E	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
      #x1F0F	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
      #x1F18	;GREEK CAPITAL LETTER EPSILON WITH PSILI
      #x1F19	;GREEK CAPITAL LETTER EPSILON WITH DASIA
      #x1F1A	;GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
      #x1F1B	;GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
      #x1F1C	;GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
      #x1F1D	;GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
      #x1F28	;GREEK CAPITAL LETTER ETA WITH PSILI
      #x1F29	;GREEK CAPITAL LETTER ETA WITH DASIA
      #x1F2A	;GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
      #x1F2B	;GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
      #x1F2C	;GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
      #x1F2D	;GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
      #x1F2E	;GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
      #x1F2F	;GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
      #x1F38	;GREEK CAPITAL LETTER IOTA WITH PSILI
      #x1F39	;GREEK CAPITAL LETTER IOTA WITH DASIA
      #x1F3A	;GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
      #x1F3B	;GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
      #x1F3C	;GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
      #x1F3D	;GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
      #x1F3E	;GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
      #x1F3F	;GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
      #x1F48	;GREEK CAPITAL LETTER OMICRON WITH PSILI
      #x1F49	;GREEK CAPITAL LETTER OMICRON WITH DASIA
      #x1F4A	;GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
      #x1F4B	;GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
      #x1F4C	;GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
      #x1F4D	;GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
      #x1F59	;GREEK CAPITAL LETTER UPSILON WITH DASIA
      #x1F5B	;GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
      #x1F5D	;GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
      #x1F5F	;GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
      #x1F68	;GREEK CAPITAL LETTER OMEGA WITH PSILI
      #x1F69	;GREEK CAPITAL LETTER OMEGA WITH DASIA
      #x1F6A	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
      #x1F6B	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
      #x1F6C	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
      #x1F6D	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
      #x1F6E	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
      #x1F6F	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
      #x1F88	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
      #x1F89	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
      #x1F8A	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1F8B	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1F8C	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1F8D	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1F8E	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F8F	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F98	;GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
      #x1F99	;GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
      #x1F9A	;GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1F9B	;GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1F9C	;GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1F9D	;GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1F9E	;GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F9F	;GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FA8	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
      #x1FA9	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
      #x1FAA	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1FAB	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1FAC	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1FAD	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1FAE	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FAF	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FB8	;GREEK CAPITAL LETTER ALPHA WITH VRACHY
      #x1FB9	;GREEK CAPITAL LETTER ALPHA WITH MACRON
      #x1FBA	;GREEK CAPITAL LETTER ALPHA WITH VARIA
      #x1FBB	;GREEK CAPITAL LETTER ALPHA WITH OXIA
      #x1FBC	;GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
      #x1FC8	;GREEK CAPITAL LETTER EPSILON WITH VARIA
      #x1FC9	;GREEK CAPITAL LETTER EPSILON WITH OXIA
      #x1FCA	;GREEK CAPITAL LETTER ETA WITH VARIA
      #x1FCB	;GREEK CAPITAL LETTER ETA WITH OXIA
      #x1FCC	;GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
      #x1FD8	;GREEK CAPITAL LETTER IOTA WITH VRACHY
      #x1FD9	;GREEK CAPITAL LETTER IOTA WITH MACRON
      #x1FDA	;GREEK CAPITAL LETTER IOTA WITH VARIA
      #x1FDB	;GREEK CAPITAL LETTER IOTA WITH OXIA
      #x1FE8	;GREEK CAPITAL LETTER UPSILON WITH VRACHY
      #x1FE9	;GREEK CAPITAL LETTER UPSILON WITH MACRON
      #x1FEA	;GREEK CAPITAL LETTER UPSILON WITH VARIA
      #x1FEB	;GREEK CAPITAL LETTER UPSILON WITH OXIA
      #x1FEC	;GREEK CAPITAL LETTER RHO WITH DASIA
      #x1FF8	;GREEK CAPITAL LETTER OMICRON WITH VARIA
      #x1FF9	;GREEK CAPITAL LETTER OMICRON WITH OXIA
      #x1FFA	;GREEK CAPITAL LETTER OMEGA WITH VARIA
      #x1FFB	;GREEK CAPITAL LETTER OMEGA WITH OXIA
      #x1FFC	;GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
      #xFF21	;FULLWIDTH LATIN CAPITAL LETTER A
      #xFF22	;FULLWIDTH LATIN CAPITAL LETTER B
      #xFF23	;FULLWIDTH LATIN CAPITAL LETTER C
      #xFF24	;FULLWIDTH LATIN CAPITAL LETTER D
      #xFF25	;FULLWIDTH LATIN CAPITAL LETTER E
      #xFF26	;FULLWIDTH LATIN CAPITAL LETTER F
      #xFF27	;FULLWIDTH LATIN CAPITAL LETTER G
      #xFF28	;FULLWIDTH LATIN CAPITAL LETTER H
      #xFF29	;FULLWIDTH LATIN CAPITAL LETTER I
      #xFF2A	;FULLWIDTH LATIN CAPITAL LETTER J
      #xFF2B	;FULLWIDTH LATIN CAPITAL LETTER K
      #xFF2C	;FULLWIDTH LATIN CAPITAL LETTER L
      #xFF2D	;FULLWIDTH LATIN CAPITAL LETTER M
      #xFF2E	;FULLWIDTH LATIN CAPITAL LETTER N
      #xFF2F	;FULLWIDTH LATIN CAPITAL LETTER O
      #xFF30	;FULLWIDTH LATIN CAPITAL LETTER P
      #xFF31	;FULLWIDTH LATIN CAPITAL LETTER Q
      #xFF32	;FULLWIDTH LATIN CAPITAL LETTER R
      #xFF33	;FULLWIDTH LATIN CAPITAL LETTER S
      #xFF34	;FULLWIDTH LATIN CAPITAL LETTER T
      #xFF35	;FULLWIDTH LATIN CAPITAL LETTER U
      #xFF36	;FULLWIDTH LATIN CAPITAL LETTER V
      #xFF37	;FULLWIDTH LATIN CAPITAL LETTER W
      #xFF38	;FULLWIDTH LATIN CAPITAL LETTER X
      #xFF39	;FULLWIDTH LATIN CAPITAL LETTER Y
      #xFF3A	;FULLWIDTH LATIN CAPITAL LETTER Z
      #x10400	;DESERET CAPITAL LETTER LONG I
      #x10401	;DESERET CAPITAL LETTER LONG E
      #x10402	;DESERET CAPITAL LETTER LONG A
      #x10403	;DESERET CAPITAL LETTER LONG AH
      #x10404	;DESERET CAPITAL LETTER LONG O
      #x10405	;DESERET CAPITAL LETTER LONG OO
      #x10406	;DESERET CAPITAL LETTER SHORT I
      #x10407	;DESERET CAPITAL LETTER SHORT E
      #x10408	;DESERET CAPITAL LETTER SHORT A
      #x10409	;DESERET CAPITAL LETTER SHORT AH
      #x1040A	;DESERET CAPITAL LETTER SHORT O
      #x1040B	;DESERET CAPITAL LETTER SHORT OO
      #x1040C	;DESERET CAPITAL LETTER AY
      #x1040D	;DESERET CAPITAL LETTER OW
      #x1040E	;DESERET CAPITAL LETTER WU
      #x1040F	;DESERET CAPITAL LETTER YEE
      #x10410	;DESERET CAPITAL LETTER H
      #x10411	;DESERET CAPITAL LETTER PEE
      #x10412	;DESERET CAPITAL LETTER BEE
      #x10413	;DESERET CAPITAL LETTER TEE
      #x10414	;DESERET CAPITAL LETTER DEE
      #x10415	;DESERET CAPITAL LETTER CHEE
      #x10416	;DESERET CAPITAL LETTER JEE
      #x10417	;DESERET CAPITAL LETTER KAY
      #x10418	;DESERET CAPITAL LETTER GAY
      #x10419	;DESERET CAPITAL LETTER EF
      #x1041A	;DESERET CAPITAL LETTER VEE
      #x1041B	;DESERET CAPITAL LETTER ETH
      #x1041C	;DESERET CAPITAL LETTER THEE
      #x1041D	;DESERET CAPITAL LETTER ES
      #x1041E	;DESERET CAPITAL LETTER ZEE
      #x1041F	;DESERET CAPITAL LETTER ESH
      #x10420	;DESERET CAPITAL LETTER ZHEE
      #x10421	;DESERET CAPITAL LETTER ER
      #x10422	;DESERET CAPITAL LETTER EL
      #x10423	;DESERET CAPITAL LETTER EM
      #x10424	;DESERET CAPITAL LETTER EN
      #x10425	;DESERET CAPITAL LETTER ENG
      #x10426	;DESERET CAPITAL LETTER OI
      #x10427	;DESERET CAPITAL LETTER EW
      #xE0041	;TAG LATIN CAPITAL LETTER A
      #xE0042	;TAG LATIN CAPITAL LETTER B
      #xE0043	;TAG LATIN CAPITAL LETTER C
      #xE0044	;TAG LATIN CAPITAL LETTER D
      #xE0045	;TAG LATIN CAPITAL LETTER E
      #xE0046	;TAG LATIN CAPITAL LETTER F
      #xE0047	;TAG LATIN CAPITAL LETTER G
      #xE0048	;TAG LATIN CAPITAL LETTER H
      #xE0049	;TAG LATIN CAPITAL LETTER I
      #xE004A	;TAG LATIN CAPITAL LETTER J
      #xE004B	;TAG LATIN CAPITAL LETTER K
      #xE004C	;TAG LATIN CAPITAL LETTER L
      #xE004D	;TAG LATIN CAPITAL LETTER M
      #xE004E	;TAG LATIN CAPITAL LETTER N
      #xE004F	;TAG LATIN CAPITAL LETTER O
      #xE0050	;TAG LATIN CAPITAL LETTER P
      #xE0051	;TAG LATIN CAPITAL LETTER Q
      #xE0052	;TAG LATIN CAPITAL LETTER R
      #xE0053	;TAG LATIN CAPITAL LETTER S
      #xE0054	;TAG LATIN CAPITAL LETTER T
      #xE0055	;TAG LATIN CAPITAL LETTER U
      #xE0056	;TAG LATIN CAPITAL LETTER V
      #xE0057	;TAG LATIN CAPITAL LETTER W
      #xE0058	;TAG LATIN CAPITAL LETTER X
      #xE0059	;TAG LATIN CAPITAL LETTER Y
      #xE005A	;TAG LATIN CAPITAL LETTER Z
)))

(define char-set:lower-case
  (build-char-set
   '( #x0061	;LATIN SMALL LETTER A
      #x0062	;LATIN SMALL LETTER B
      #x0063	;LATIN SMALL LETTER C
      #x0064	;LATIN SMALL LETTER D
      #x0065	;LATIN SMALL LETTER E
      #x0066	;LATIN SMALL LETTER F
      #x0067	;LATIN SMALL LETTER G
      #x0068	;LATIN SMALL LETTER H
      #x0069	;LATIN SMALL LETTER I
      #x006A	;LATIN SMALL LETTER J
      #x006B	;LATIN SMALL LETTER K
      #x006C	;LATIN SMALL LETTER L
      #x006D	;LATIN SMALL LETTER M
      #x006E	;LATIN SMALL LETTER N
      #x006F	;LATIN SMALL LETTER O
      #x0070	;LATIN SMALL LETTER P
      #x0071	;LATIN SMALL LETTER Q
      #x0072	;LATIN SMALL LETTER R
      #x0073	;LATIN SMALL LETTER S
      #x0074	;LATIN SMALL LETTER T
      #x0075	;LATIN SMALL LETTER U
      #x0076	;LATIN SMALL LETTER V
      #x0077	;LATIN SMALL LETTER W
      #x0078	;LATIN SMALL LETTER X
      #x0079	;LATIN SMALL LETTER Y
      #x007A	;LATIN SMALL LETTER Z
      #x00B5	;MICRO SIGN
      #x00DF	;LATIN SMALL LETTER SHARP S
      #x00E0	;LATIN SMALL LETTER A WITH GRAVE
      #x00E1	;LATIN SMALL LETTER A WITH ACUTE
      #x00E2	;LATIN SMALL LETTER A WITH CIRCUMFLEX
      #x00E3	;LATIN SMALL LETTER A WITH TILDE
      #x00E4	;LATIN SMALL LETTER A WITH DIAERESIS
      #x00E5	;LATIN SMALL LETTER A WITH RING ABOVE
      #x00E6	;LATIN SMALL LETTER AE
      #x00E7	;LATIN SMALL LETTER C WITH CEDILLA
      #x00E8	;LATIN SMALL LETTER E WITH GRAVE
      #x00E9	;LATIN SMALL LETTER E WITH ACUTE
      #x00EA	;LATIN SMALL LETTER E WITH CIRCUMFLEX
      #x00EB	;LATIN SMALL LETTER E WITH DIAERESIS
      #x00EC	;LATIN SMALL LETTER I WITH GRAVE
      #x00ED	;LATIN SMALL LETTER I WITH ACUTE
      #x00EE	;LATIN SMALL LETTER I WITH CIRCUMFLEX
      #x00EF	;LATIN SMALL LETTER I WITH DIAERESIS
      #x00F0	;LATIN SMALL LETTER ETH
      #x00F1	;LATIN SMALL LETTER N WITH TILDE
      #x00F2	;LATIN SMALL LETTER O WITH GRAVE
      #x00F3	;LATIN SMALL LETTER O WITH ACUTE
      #x00F4	;LATIN SMALL LETTER O WITH CIRCUMFLEX
      #x00F5	;LATIN SMALL LETTER O WITH TILDE
      #x00F6	;LATIN SMALL LETTER O WITH DIAERESIS
      #x00F8	;LATIN SMALL LETTER O WITH STROKE
      #x00F9	;LATIN SMALL LETTER U WITH GRAVE
      #x00FA	;LATIN SMALL LETTER U WITH ACUTE
      #x00FB	;LATIN SMALL LETTER U WITH CIRCUMFLEX
      #x00FC	;LATIN SMALL LETTER U WITH DIAERESIS
      #x00FD	;LATIN SMALL LETTER Y WITH ACUTE
      #x00FE	;LATIN SMALL LETTER THORN
      #x00FF	;LATIN SMALL LETTER Y WITH DIAERESIS
      #x0101	;LATIN SMALL LETTER A WITH MACRON
      #x0103	;LATIN SMALL LETTER A WITH BREVE
      #x0105	;LATIN SMALL LETTER A WITH OGONEK
      #x0107	;LATIN SMALL LETTER C WITH ACUTE
      #x0109	;LATIN SMALL LETTER C WITH CIRCUMFLEX
      #x010B	;LATIN SMALL LETTER C WITH DOT ABOVE
      #x010D	;LATIN SMALL LETTER C WITH CARON
      #x010F	;LATIN SMALL LETTER D WITH CARON
      #x0111	;LATIN SMALL LETTER D WITH STROKE
      #x0113	;LATIN SMALL LETTER E WITH MACRON
      #x0115	;LATIN SMALL LETTER E WITH BREVE
      #x0117	;LATIN SMALL LETTER E WITH DOT ABOVE
      #x0119	;LATIN SMALL LETTER E WITH OGONEK
      #x011B	;LATIN SMALL LETTER E WITH CARON
      #x011D	;LATIN SMALL LETTER G WITH CIRCUMFLEX
      #x011F	;LATIN SMALL LETTER G WITH BREVE
      #x0121	;LATIN SMALL LETTER G WITH DOT ABOVE
      #x0123	;LATIN SMALL LETTER G WITH CEDILLA
      #x0125	;LATIN SMALL LETTER H WITH CIRCUMFLEX
      #x0127	;LATIN SMALL LETTER H WITH STROKE
      #x0129	;LATIN SMALL LETTER I WITH TILDE
      #x012B	;LATIN SMALL LETTER I WITH MACRON
      #x012D	;LATIN SMALL LETTER I WITH BREVE
      #x012F	;LATIN SMALL LETTER I WITH OGONEK
      #x0131	;LATIN SMALL LETTER DOTLESS I
      #x0133	;LATIN SMALL LIGATURE IJ
      #x0135	;LATIN SMALL LETTER J WITH CIRCUMFLEX
      #x0137	;LATIN SMALL LETTER K WITH CEDILLA
      #x0138	;LATIN SMALL LETTER KRA
      #x013A	;LATIN SMALL LETTER L WITH ACUTE
      #x013C	;LATIN SMALL LETTER L WITH CEDILLA
      #x013E	;LATIN SMALL LETTER L WITH CARON
      #x0140	;LATIN SMALL LETTER L WITH MIDDLE DOT
      #x0142	;LATIN SMALL LETTER L WITH STROKE
      #x0144	;LATIN SMALL LETTER N WITH ACUTE
      #x0146	;LATIN SMALL LETTER N WITH CEDILLA
      #x0148	;LATIN SMALL LETTER N WITH CARON
      #x0149	;LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
      #x014B	;LATIN SMALL LETTER ENG
      #x014D	;LATIN SMALL LETTER O WITH MACRON
      #x014F	;LATIN SMALL LETTER O WITH BREVE
      #x0151	;LATIN SMALL LETTER O WITH DOUBLE ACUTE
      #x0153	;LATIN SMALL LIGATURE OE
      #x0155	;LATIN SMALL LETTER R WITH ACUTE
      #x0157	;LATIN SMALL LETTER R WITH CEDILLA
      #x0159	;LATIN SMALL LETTER R WITH CARON
      #x015B	;LATIN SMALL LETTER S WITH ACUTE
      #x015D	;LATIN SMALL LETTER S WITH CIRCUMFLEX
      #x015F	;LATIN SMALL LETTER S WITH CEDILLA
      #x0161	;LATIN SMALL LETTER S WITH CARON
      #x0163	;LATIN SMALL LETTER T WITH CEDILLA
      #x0165	;LATIN SMALL LETTER T WITH CARON
      #x0167	;LATIN SMALL LETTER T WITH STROKE
      #x0169	;LATIN SMALL LETTER U WITH TILDE
      #x016B	;LATIN SMALL LETTER U WITH MACRON
      #x016D	;LATIN SMALL LETTER U WITH BREVE
      #x016F	;LATIN SMALL LETTER U WITH RING ABOVE
      #x0171	;LATIN SMALL LETTER U WITH DOUBLE ACUTE
      #x0173	;LATIN SMALL LETTER U WITH OGONEK
      #x0175	;LATIN SMALL LETTER W WITH CIRCUMFLEX
      #x0177	;LATIN SMALL LETTER Y WITH CIRCUMFLEX
      #x017A	;LATIN SMALL LETTER Z WITH ACUTE
      #x017C	;LATIN SMALL LETTER Z WITH DOT ABOVE
      #x017E	;LATIN SMALL LETTER Z WITH CARON
      #x017F	;LATIN SMALL LETTER LONG S
      #x0180	;LATIN SMALL LETTER B WITH STROKE
      #x0183	;LATIN SMALL LETTER B WITH TOPBAR
      #x0185	;LATIN SMALL LETTER TONE SIX
      #x0188	;LATIN SMALL LETTER C WITH HOOK
      #x018C	;LATIN SMALL LETTER D WITH TOPBAR
      #x018D	;LATIN SMALL LETTER TURNED DELTA
      #x0192	;LATIN SMALL LETTER F WITH HOOK
      #x0195	;LATIN SMALL LETTER HV
      #x0199	;LATIN SMALL LETTER K WITH HOOK
      #x019A	;LATIN SMALL LETTER L WITH BAR
      #x019B	;LATIN SMALL LETTER LAMBDA WITH STROKE
      #x019E	;LATIN SMALL LETTER N WITH LONG RIGHT LEG
      #x01A1	;LATIN SMALL LETTER O WITH HORN
      #x01A3	;LATIN SMALL LETTER OI
      #x01A5	;LATIN SMALL LETTER P WITH HOOK
      #x01A8	;LATIN SMALL LETTER TONE TWO
      #x01AB	;LATIN SMALL LETTER T WITH PALATAL HOOK
      #x01AD	;LATIN SMALL LETTER T WITH HOOK
      #x01B0	;LATIN SMALL LETTER U WITH HORN
      #x01B4	;LATIN SMALL LETTER Y WITH HOOK
      #x01B6	;LATIN SMALL LETTER Z WITH STROKE
      #x01B9	;LATIN SMALL LETTER EZH REVERSED
      #x01BA	;LATIN SMALL LETTER EZH WITH TAIL
      #x01BD	;LATIN SMALL LETTER TONE FIVE
      #x01BF	;LATIN LETTER WYNN
      #x01C6	;LATIN SMALL LETTER DZ WITH CARON
      #x01C9	;LATIN SMALL LETTER LJ
      #x01CC	;LATIN SMALL LETTER NJ
      #x01CE	;LATIN SMALL LETTER A WITH CARON
      #x01D0	;LATIN SMALL LETTER I WITH CARON
      #x01D2	;LATIN SMALL LETTER O WITH CARON
      #x01D4	;LATIN SMALL LETTER U WITH CARON
      #x01D6	;LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
      #x01D8	;LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
      #x01DA	;LATIN SMALL LETTER U WITH DIAERESIS AND CARON
      #x01DC	;LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
      #x01DD	;LATIN SMALL LETTER TURNED E
      #x01DF	;LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
      #x01E1	;LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
      #x01E3	;LATIN SMALL LETTER AE WITH MACRON
      #x01E5	;LATIN SMALL LETTER G WITH STROKE
      #x01E7	;LATIN SMALL LETTER G WITH CARON
      #x01E9	;LATIN SMALL LETTER K WITH CARON
      #x01EB	;LATIN SMALL LETTER O WITH OGONEK
      #x01ED	;LATIN SMALL LETTER O WITH OGONEK AND MACRON
      #x01EF	;LATIN SMALL LETTER EZH WITH CARON
      #x01F0	;LATIN SMALL LETTER J WITH CARON
      #x01F3	;LATIN SMALL LETTER DZ
      #x01F5	;LATIN SMALL LETTER G WITH ACUTE
      #x01F9	;LATIN SMALL LETTER N WITH GRAVE
      #x01FB	;LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
      #x01FD	;LATIN SMALL LETTER AE WITH ACUTE
      #x01FF	;LATIN SMALL LETTER O WITH STROKE AND ACUTE
      #x0201	;LATIN SMALL LETTER A WITH DOUBLE GRAVE
      #x0203	;LATIN SMALL LETTER A WITH INVERTED BREVE
      #x0205	;LATIN SMALL LETTER E WITH DOUBLE GRAVE
      #x0207	;LATIN SMALL LETTER E WITH INVERTED BREVE
      #x0209	;LATIN SMALL LETTER I WITH DOUBLE GRAVE
      #x020B	;LATIN SMALL LETTER I WITH INVERTED BREVE
      #x020D	;LATIN SMALL LETTER O WITH DOUBLE GRAVE
      #x020F	;LATIN SMALL LETTER O WITH INVERTED BREVE
      #x0211	;LATIN SMALL LETTER R WITH DOUBLE GRAVE
      #x0213	;LATIN SMALL LETTER R WITH INVERTED BREVE
      #x0215	;LATIN SMALL LETTER U WITH DOUBLE GRAVE
      #x0217	;LATIN SMALL LETTER U WITH INVERTED BREVE
      #x0219	;LATIN SMALL LETTER S WITH COMMA BELOW
      #x021B	;LATIN SMALL LETTER T WITH COMMA BELOW
      #x021D	;LATIN SMALL LETTER YOGH
      #x021F	;LATIN SMALL LETTER H WITH CARON
      #x0221	;LATIN SMALL LETTER D WITH CURL
      #x0223	;LATIN SMALL LETTER OU
      #x0225	;LATIN SMALL LETTER Z WITH HOOK
      #x0227	;LATIN SMALL LETTER A WITH DOT ABOVE
      #x0229	;LATIN SMALL LETTER E WITH CEDILLA
      #x022B	;LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
      #x022D	;LATIN SMALL LETTER O WITH TILDE AND MACRON
      #x022F	;LATIN SMALL LETTER O WITH DOT ABOVE
      #x0231	;LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
      #x0233	;LATIN SMALL LETTER Y WITH MACRON
      #x0234	;LATIN SMALL LETTER L WITH CURL
      #x0235	;LATIN SMALL LETTER N WITH CURL
      #x0236	;LATIN SMALL LETTER T WITH CURL
      #x0250	;LATIN SMALL LETTER TURNED A
      #x0251	;LATIN SMALL LETTER ALPHA
      #x0252	;LATIN SMALL LETTER TURNED ALPHA
      #x0253	;LATIN SMALL LETTER B WITH HOOK
      #x0254	;LATIN SMALL LETTER OPEN O
      #x0255	;LATIN SMALL LETTER C WITH CURL
      #x0256	;LATIN SMALL LETTER D WITH TAIL
      #x0257	;LATIN SMALL LETTER D WITH HOOK
      #x0258	;LATIN SMALL LETTER REVERSED E
      #x0259	;LATIN SMALL LETTER SCHWA
      #x025A	;LATIN SMALL LETTER SCHWA WITH HOOK
      #x025B	;LATIN SMALL LETTER OPEN E
      #x025C	;LATIN SMALL LETTER REVERSED OPEN E
      #x025D	;LATIN SMALL LETTER REVERSED OPEN E WITH HOOK
      #x025E	;LATIN SMALL LETTER CLOSED REVERSED OPEN E
      #x025F	;LATIN SMALL LETTER DOTLESS J WITH STROKE
      #x0260	;LATIN SMALL LETTER G WITH HOOK
      #x0261	;LATIN SMALL LETTER SCRIPT G
      #x0263	;LATIN SMALL LETTER GAMMA
      #x0264	;LATIN SMALL LETTER RAMS HORN
      #x0265	;LATIN SMALL LETTER TURNED H
      #x0266	;LATIN SMALL LETTER H WITH HOOK
      #x0267	;LATIN SMALL LETTER HENG WITH HOOK
      #x0268	;LATIN SMALL LETTER I WITH STROKE
      #x0269	;LATIN SMALL LETTER IOTA
      #x026B	;LATIN SMALL LETTER L WITH MIDDLE TILDE
      #x026C	;LATIN SMALL LETTER L WITH BELT
      #x026D	;LATIN SMALL LETTER L WITH RETROFLEX HOOK
      #x026E	;LATIN SMALL LETTER LEZH
      #x026F	;LATIN SMALL LETTER TURNED M
      #x0270	;LATIN SMALL LETTER TURNED M WITH LONG LEG
      #x0271	;LATIN SMALL LETTER M WITH HOOK
      #x0272	;LATIN SMALL LETTER N WITH LEFT HOOK
      #x0273	;LATIN SMALL LETTER N WITH RETROFLEX HOOK
      #x0275	;LATIN SMALL LETTER BARRED O
      #x0277	;LATIN SMALL LETTER CLOSED OMEGA
      #x0278	;LATIN SMALL LETTER PHI
      #x0279	;LATIN SMALL LETTER TURNED R
      #x027A	;LATIN SMALL LETTER TURNED R WITH LONG LEG
      #x027B	;LATIN SMALL LETTER TURNED R WITH HOOK
      #x027C	;LATIN SMALL LETTER R WITH LONG LEG
      #x027D	;LATIN SMALL LETTER R WITH TAIL
      #x027E	;LATIN SMALL LETTER R WITH FISHHOOK
      #x027F	;LATIN SMALL LETTER REVERSED R WITH FISHHOOK
      #x0280	;LATIN LETTER SMALL CAPITAL R
      #x0282	;LATIN SMALL LETTER S WITH HOOK
      #x0283	;LATIN SMALL LETTER ESH
      #x0284	;LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK
      #x0285	;LATIN SMALL LETTER SQUAT REVERSED ESH
      #x0286	;LATIN SMALL LETTER ESH WITH CURL
      #x0287	;LATIN SMALL LETTER TURNED T
      #x0288	;LATIN SMALL LETTER T WITH RETROFLEX HOOK
      #x0289	;LATIN SMALL LETTER U BAR
      #x028A	;LATIN SMALL LETTER UPSILON
      #x028B	;LATIN SMALL LETTER V WITH HOOK
      #x028C	;LATIN SMALL LETTER TURNED V
      #x028D	;LATIN SMALL LETTER TURNED W
      #x028E	;LATIN SMALL LETTER TURNED Y
      #x0290	;LATIN SMALL LETTER Z WITH RETROFLEX HOOK
      #x0291	;LATIN SMALL LETTER Z WITH CURL
      #x0292	;LATIN SMALL LETTER EZH
      #x0293	;LATIN SMALL LETTER EZH WITH CURL
      #x029A	;LATIN SMALL LETTER CLOSED OPEN E
      #x029D	;LATIN SMALL LETTER J WITH CROSSED-TAIL
      #x029E	;LATIN SMALL LETTER TURNED K
      #x02A0	;LATIN SMALL LETTER Q WITH HOOK
      #x02A3	;LATIN SMALL LETTER DZ DIGRAPH
      #x02A4	;LATIN SMALL LETTER DEZH DIGRAPH
      #x02A5	;LATIN SMALL LETTER DZ DIGRAPH WITH CURL
      #x02A6	;LATIN SMALL LETTER TS DIGRAPH
      #x02A7	;LATIN SMALL LETTER TESH DIGRAPH
      #x02A8	;LATIN SMALL LETTER TC DIGRAPH WITH CURL
      #x02A9	;LATIN SMALL LETTER FENG DIGRAPH
      #x02AA	;LATIN SMALL LETTER LS DIGRAPH
      #x02AB	;LATIN SMALL LETTER LZ DIGRAPH
      #x02AE	;LATIN SMALL LETTER TURNED H WITH FISHHOOK
      #x02AF	;LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
      #x0345	;COMBINING GREEK YPOGEGRAMMENI
      #x0363	;COMBINING LATIN SMALL LETTER A
      #x0364	;COMBINING LATIN SMALL LETTER E
      #x0365	;COMBINING LATIN SMALL LETTER I
      #x0366	;COMBINING LATIN SMALL LETTER O
      #x0367	;COMBINING LATIN SMALL LETTER U
      #x0368	;COMBINING LATIN SMALL LETTER C
      #x0369	;COMBINING LATIN SMALL LETTER D
      #x036A	;COMBINING LATIN SMALL LETTER H
      #x036B	;COMBINING LATIN SMALL LETTER M
      #x036C	;COMBINING LATIN SMALL LETTER R
      #x036D	;COMBINING LATIN SMALL LETTER T
      #x036E	;COMBINING LATIN SMALL LETTER V
      #x036F	;COMBINING LATIN SMALL LETTER X
      #x0390	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
      #x03AC	;GREEK SMALL LETTER ALPHA WITH TONOS
      #x03AD	;GREEK SMALL LETTER EPSILON WITH TONOS
      #x03AE	;GREEK SMALL LETTER ETA WITH TONOS
      #x03AF	;GREEK SMALL LETTER IOTA WITH TONOS
      #x03B0	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
      #x03B1	;GREEK SMALL LETTER ALPHA
      #x03B2	;GREEK SMALL LETTER BETA
      #x03B3	;GREEK SMALL LETTER GAMMA
      #x03B4	;GREEK SMALL LETTER DELTA
      #x03B5	;GREEK SMALL LETTER EPSILON
      #x03B6	;GREEK SMALL LETTER ZETA
      #x03B7	;GREEK SMALL LETTER ETA
      #x03B8	;GREEK SMALL LETTER THETA
      #x03B9	;GREEK SMALL LETTER IOTA
      #x03BA	;GREEK SMALL LETTER KAPPA
      #x03BB	;GREEK SMALL LETTER LAMDA
      #x03BC	;GREEK SMALL LETTER MU
      #x03BD	;GREEK SMALL LETTER NU
      #x03BE	;GREEK SMALL LETTER XI
      #x03BF	;GREEK SMALL LETTER OMICRON
      #x03C0	;GREEK SMALL LETTER PI
      #x03C1	;GREEK SMALL LETTER RHO
      #x03C2	;GREEK SMALL LETTER FINAL SIGMA
      #x03C3	;GREEK SMALL LETTER SIGMA
      #x03C4	;GREEK SMALL LETTER TAU
      #x03C5	;GREEK SMALL LETTER UPSILON
      #x03C6	;GREEK SMALL LETTER PHI
      #x03C7	;GREEK SMALL LETTER CHI
      #x03C8	;GREEK SMALL LETTER PSI
      #x03C9	;GREEK SMALL LETTER OMEGA
      #x03CA	;GREEK SMALL LETTER IOTA WITH DIALYTIKA
      #x03CB	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA
      #x03CC	;GREEK SMALL LETTER OMICRON WITH TONOS
      #x03CD	;GREEK SMALL LETTER UPSILON WITH TONOS
      #x03CE	;GREEK SMALL LETTER OMEGA WITH TONOS
      #x03D0	;GREEK BETA SYMBOL
      #x03D1	;GREEK THETA SYMBOL
      #x03D5	;GREEK PHI SYMBOL
      #x03D6	;GREEK PI SYMBOL
      #x03D9	;GREEK SMALL LETTER ARCHAIC KOPPA
      #x03DB	;GREEK SMALL LETTER STIGMA
      #x03DD	;GREEK SMALL LETTER DIGAMMA
      #x03DF	;GREEK SMALL LETTER KOPPA
      #x03E1	;GREEK SMALL LETTER SAMPI
      #x03E3	;COPTIC SMALL LETTER SHEI
      #x03E5	;COPTIC SMALL LETTER FEI
      #x03E7	;COPTIC SMALL LETTER KHEI
      #x03E9	;COPTIC SMALL LETTER HORI
      #x03EB	;COPTIC SMALL LETTER GANGIA
      #x03ED	;COPTIC SMALL LETTER SHIMA
      #x03EF	;COPTIC SMALL LETTER DEI
      #x03F0	;GREEK KAPPA SYMBOL
      #x03F1	;GREEK RHO SYMBOL
      #x03F2	;GREEK LUNATE SIGMA SYMBOL
      #x03F5	;GREEK LUNATE EPSILON SYMBOL
      #x03F8	;GREEK SMALL LETTER SHO
      #x03FB	;GREEK SMALL LETTER SAN
      #x0430	;CYRILLIC SMALL LETTER A
      #x0431	;CYRILLIC SMALL LETTER BE
      #x0432	;CYRILLIC SMALL LETTER VE
      #x0433	;CYRILLIC SMALL LETTER GHE
      #x0434	;CYRILLIC SMALL LETTER DE
      #x0435	;CYRILLIC SMALL LETTER IE
      #x0436	;CYRILLIC SMALL LETTER ZHE
      #x0437	;CYRILLIC SMALL LETTER ZE
      #x0438	;CYRILLIC SMALL LETTER I
      #x0439	;CYRILLIC SMALL LETTER SHORT I
      #x043A	;CYRILLIC SMALL LETTER KA
      #x043B	;CYRILLIC SMALL LETTER EL
      #x043C	;CYRILLIC SMALL LETTER EM
      #x043D	;CYRILLIC SMALL LETTER EN
      #x043E	;CYRILLIC SMALL LETTER O
      #x043F	;CYRILLIC SMALL LETTER PE
      #x0440	;CYRILLIC SMALL LETTER ER
      #x0441	;CYRILLIC SMALL LETTER ES
      #x0442	;CYRILLIC SMALL LETTER TE
      #x0443	;CYRILLIC SMALL LETTER U
      #x0444	;CYRILLIC SMALL LETTER EF
      #x0445	;CYRILLIC SMALL LETTER HA
      #x0446	;CYRILLIC SMALL LETTER TSE
      #x0447	;CYRILLIC SMALL LETTER CHE
      #x0448	;CYRILLIC SMALL LETTER SHA
      #x0449	;CYRILLIC SMALL LETTER SHCHA
      #x044A	;CYRILLIC SMALL LETTER HARD SIGN
      #x044B	;CYRILLIC SMALL LETTER YERU
      #x044C	;CYRILLIC SMALL LETTER SOFT SIGN
      #x044D	;CYRILLIC SMALL LETTER E
      #x044E	;CYRILLIC SMALL LETTER YU
      #x044F	;CYRILLIC SMALL LETTER YA
      #x0450	;CYRILLIC SMALL LETTER IE WITH GRAVE
      #x0451	;CYRILLIC SMALL LETTER IO
      #x0452	;CYRILLIC SMALL LETTER DJE
      #x0453	;CYRILLIC SMALL LETTER GJE
      #x0454	;CYRILLIC SMALL LETTER UKRAINIAN IE
      #x0455	;CYRILLIC SMALL LETTER DZE
      #x0456	;CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
      #x0457	;CYRILLIC SMALL LETTER YI
      #x0458	;CYRILLIC SMALL LETTER JE
      #x0459	;CYRILLIC SMALL LETTER LJE
      #x045A	;CYRILLIC SMALL LETTER NJE
      #x045B	;CYRILLIC SMALL LETTER TSHE
      #x045C	;CYRILLIC SMALL LETTER KJE
      #x045D	;CYRILLIC SMALL LETTER I WITH GRAVE
      #x045E	;CYRILLIC SMALL LETTER SHORT U
      #x045F	;CYRILLIC SMALL LETTER DZHE
      #x0461	;CYRILLIC SMALL LETTER OMEGA
      #x0463	;CYRILLIC SMALL LETTER YAT
      #x0465	;CYRILLIC SMALL LETTER IOTIFIED E
      #x0467	;CYRILLIC SMALL LETTER LITTLE YUS
      #x0469	;CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
      #x046B	;CYRILLIC SMALL LETTER BIG YUS
      #x046D	;CYRILLIC SMALL LETTER IOTIFIED BIG YUS
      #x046F	;CYRILLIC SMALL LETTER KSI
      #x0471	;CYRILLIC SMALL LETTER PSI
      #x0473	;CYRILLIC SMALL LETTER FITA
      #x0475	;CYRILLIC SMALL LETTER IZHITSA
      #x0477	;CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
      #x0479	;CYRILLIC SMALL LETTER UK
      #x047B	;CYRILLIC SMALL LETTER ROUND OMEGA
      #x047D	;CYRILLIC SMALL LETTER OMEGA WITH TITLO
      #x047F	;CYRILLIC SMALL LETTER OT
      #x0481	;CYRILLIC SMALL LETTER KOPPA
      #x048B	;CYRILLIC SMALL LETTER SHORT I WITH TAIL
      #x048D	;CYRILLIC SMALL LETTER SEMISOFT SIGN
      #x048F	;CYRILLIC SMALL LETTER ER WITH TICK
      #x0491	;CYRILLIC SMALL LETTER GHE WITH UPTURN
      #x0493	;CYRILLIC SMALL LETTER GHE WITH STROKE
      #x0495	;CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
      #x0497	;CYRILLIC SMALL LETTER ZHE WITH DESCENDER
      #x0499	;CYRILLIC SMALL LETTER ZE WITH DESCENDER
      #x049B	;CYRILLIC SMALL LETTER KA WITH DESCENDER
      #x049D	;CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
      #x049F	;CYRILLIC SMALL LETTER KA WITH STROKE
      #x04A1	;CYRILLIC SMALL LETTER BASHKIR KA
      #x04A3	;CYRILLIC SMALL LETTER EN WITH DESCENDER
      #x04A5	;CYRILLIC SMALL LIGATURE EN GHE
      #x04A7	;CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
      #x04A9	;CYRILLIC SMALL LETTER ABKHASIAN HA
      #x04AB	;CYRILLIC SMALL LETTER ES WITH DESCENDER
      #x04AD	;CYRILLIC SMALL LETTER TE WITH DESCENDER
      #x04AF	;CYRILLIC SMALL LETTER STRAIGHT U
      #x04B1	;CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
      #x04B3	;CYRILLIC SMALL LETTER HA WITH DESCENDER
      #x04B5	;CYRILLIC SMALL LIGATURE TE TSE
      #x04B7	;CYRILLIC SMALL LETTER CHE WITH DESCENDER
      #x04B9	;CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
      #x04BB	;CYRILLIC SMALL LETTER SHHA
      #x04BD	;CYRILLIC SMALL LETTER ABKHASIAN CHE
      #x04BF	;CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
      #x04C2	;CYRILLIC SMALL LETTER ZHE WITH BREVE
      #x04C4	;CYRILLIC SMALL LETTER KA WITH HOOK
      #x04C6	;CYRILLIC SMALL LETTER EL WITH TAIL
      #x04C8	;CYRILLIC SMALL LETTER EN WITH HOOK
      #x04CA	;CYRILLIC SMALL LETTER EN WITH TAIL
      #x04CC	;CYRILLIC SMALL LETTER KHAKASSIAN CHE
      #x04CE	;CYRILLIC SMALL LETTER EM WITH TAIL
      #x04D1	;CYRILLIC SMALL LETTER A WITH BREVE
      #x04D3	;CYRILLIC SMALL LETTER A WITH DIAERESIS
      #x04D5	;CYRILLIC SMALL LIGATURE A IE
      #x04D7	;CYRILLIC SMALL LETTER IE WITH BREVE
      #x04D9	;CYRILLIC SMALL LETTER SCHWA
      #x04DB	;CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
      #x04DD	;CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
      #x04DF	;CYRILLIC SMALL LETTER ZE WITH DIAERESIS
      #x04E1	;CYRILLIC SMALL LETTER ABKHASIAN DZE
      #x04E3	;CYRILLIC SMALL LETTER I WITH MACRON
      #x04E5	;CYRILLIC SMALL LETTER I WITH DIAERESIS
      #x04E7	;CYRILLIC SMALL LETTER O WITH DIAERESIS
      #x04E9	;CYRILLIC SMALL LETTER BARRED O
      #x04EB	;CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
      #x04ED	;CYRILLIC SMALL LETTER E WITH DIAERESIS
      #x04EF	;CYRILLIC SMALL LETTER U WITH MACRON
      #x04F1	;CYRILLIC SMALL LETTER U WITH DIAERESIS
      #x04F3	;CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
      #x04F5	;CYRILLIC SMALL LETTER CHE WITH DIAERESIS
      #x04F9	;CYRILLIC SMALL LETTER YERU WITH DIAERESIS
      #x0501	;CYRILLIC SMALL LETTER KOMI DE
      #x0503	;CYRILLIC SMALL LETTER KOMI DJE
      #x0505	;CYRILLIC SMALL LETTER KOMI ZJE
      #x0507	;CYRILLIC SMALL LETTER KOMI DZJE
      #x0509	;CYRILLIC SMALL LETTER KOMI LJE
      #x050B	;CYRILLIC SMALL LETTER KOMI NJE
      #x050D	;CYRILLIC SMALL LETTER KOMI SJE
      #x050F	;CYRILLIC SMALL LETTER KOMI TJE
      #x0561	;ARMENIAN SMALL LETTER AYB
      #x0562	;ARMENIAN SMALL LETTER BEN
      #x0563	;ARMENIAN SMALL LETTER GIM
      #x0564	;ARMENIAN SMALL LETTER DA
      #x0565	;ARMENIAN SMALL LETTER ECH
      #x0566	;ARMENIAN SMALL LETTER ZA
      #x0567	;ARMENIAN SMALL LETTER EH
      #x0568	;ARMENIAN SMALL LETTER ET
      #x0569	;ARMENIAN SMALL LETTER TO
      #x056A	;ARMENIAN SMALL LETTER ZHE
      #x056B	;ARMENIAN SMALL LETTER INI
      #x056C	;ARMENIAN SMALL LETTER LIWN
      #x056D	;ARMENIAN SMALL LETTER XEH
      #x056E	;ARMENIAN SMALL LETTER CA
      #x056F	;ARMENIAN SMALL LETTER KEN
      #x0570	;ARMENIAN SMALL LETTER HO
      #x0571	;ARMENIAN SMALL LETTER JA
      #x0572	;ARMENIAN SMALL LETTER GHAD
      #x0573	;ARMENIAN SMALL LETTER CHEH
      #x0574	;ARMENIAN SMALL LETTER MEN
      #x0575	;ARMENIAN SMALL LETTER YI
      #x0576	;ARMENIAN SMALL LETTER NOW
      #x0577	;ARMENIAN SMALL LETTER SHA
      #x0578	;ARMENIAN SMALL LETTER VO
      #x0579	;ARMENIAN SMALL LETTER CHA
      #x057A	;ARMENIAN SMALL LETTER PEH
      #x057B	;ARMENIAN SMALL LETTER JHEH
      #x057C	;ARMENIAN SMALL LETTER RA
      #x057D	;ARMENIAN SMALL LETTER SEH
      #x057E	;ARMENIAN SMALL LETTER VEW
      #x057F	;ARMENIAN SMALL LETTER TIWN
      #x0580	;ARMENIAN SMALL LETTER REH
      #x0581	;ARMENIAN SMALL LETTER CO
      #x0582	;ARMENIAN SMALL LETTER YIWN
      #x0583	;ARMENIAN SMALL LETTER PIWR
      #x0584	;ARMENIAN SMALL LETTER KEH
      #x0585	;ARMENIAN SMALL LETTER OH
      #x0586	;ARMENIAN SMALL LETTER FEH
      #x0587	;ARMENIAN SMALL LIGATURE ECH YIWN
      #x1930	;LIMBU SMALL LETTER KA
      #x1931	;LIMBU SMALL LETTER NGA
      #x1932	;LIMBU SMALL LETTER ANUSVARA
      #x1933	;LIMBU SMALL LETTER TA
      #x1934	;LIMBU SMALL LETTER NA
      #x1935	;LIMBU SMALL LETTER PA
      #x1936	;LIMBU SMALL LETTER MA
      #x1937	;LIMBU SMALL LETTER RA
      #x1938	;LIMBU SMALL LETTER LA
      #x1D02	;LATIN SMALL LETTER TURNED AE
      #x1D08	;LATIN SMALL LETTER TURNED OPEN E
      #x1D09	;LATIN SMALL LETTER TURNED I
      #x1D11	;LATIN SMALL LETTER SIDEWAYS O
      #x1D12	;LATIN SMALL LETTER SIDEWAYS OPEN O
      #x1D13	;LATIN SMALL LETTER SIDEWAYS O WITH STROKE
      #x1D14	;LATIN SMALL LETTER TURNED OE
      #x1D16	;LATIN SMALL LETTER TOP HALF O
      #x1D17	;LATIN SMALL LETTER BOTTOM HALF O
      #x1D1D	;LATIN SMALL LETTER SIDEWAYS U
      #x1D1E	;LATIN SMALL LETTER SIDEWAYS DIAERESIZED U
      #x1D1F	;LATIN SMALL LETTER SIDEWAYS TURNED M
      #x1D62	;LATIN SUBSCRIPT SMALL LETTER I
      #x1D63	;LATIN SUBSCRIPT SMALL LETTER R
      #x1D64	;LATIN SUBSCRIPT SMALL LETTER U
      #x1D65	;LATIN SUBSCRIPT SMALL LETTER V
      #x1D66	;GREEK SUBSCRIPT SMALL LETTER BETA
      #x1D67	;GREEK SUBSCRIPT SMALL LETTER GAMMA
      #x1D68	;GREEK SUBSCRIPT SMALL LETTER RHO
      #x1D69	;GREEK SUBSCRIPT SMALL LETTER PHI
      #x1D6A	;GREEK SUBSCRIPT SMALL LETTER CHI
      #x1D6B	;LATIN SMALL LETTER UE
      #x1E01	;LATIN SMALL LETTER A WITH RING BELOW
      #x1E03	;LATIN SMALL LETTER B WITH DOT ABOVE
      #x1E05	;LATIN SMALL LETTER B WITH DOT BELOW
      #x1E07	;LATIN SMALL LETTER B WITH LINE BELOW
      #x1E09	;LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
      #x1E0B	;LATIN SMALL LETTER D WITH DOT ABOVE
      #x1E0D	;LATIN SMALL LETTER D WITH DOT BELOW
      #x1E0F	;LATIN SMALL LETTER D WITH LINE BELOW
      #x1E11	;LATIN SMALL LETTER D WITH CEDILLA
      #x1E13	;LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
      #x1E15	;LATIN SMALL LETTER E WITH MACRON AND GRAVE
      #x1E17	;LATIN SMALL LETTER E WITH MACRON AND ACUTE
      #x1E19	;LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
      #x1E1B	;LATIN SMALL LETTER E WITH TILDE BELOW
      #x1E1D	;LATIN SMALL LETTER E WITH CEDILLA AND BREVE
      #x1E1F	;LATIN SMALL LETTER F WITH DOT ABOVE
      #x1E21	;LATIN SMALL LETTER G WITH MACRON
      #x1E23	;LATIN SMALL LETTER H WITH DOT ABOVE
      #x1E25	;LATIN SMALL LETTER H WITH DOT BELOW
      #x1E27	;LATIN SMALL LETTER H WITH DIAERESIS
      #x1E29	;LATIN SMALL LETTER H WITH CEDILLA
      #x1E2B	;LATIN SMALL LETTER H WITH BREVE BELOW
      #x1E2D	;LATIN SMALL LETTER I WITH TILDE BELOW
      #x1E2F	;LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
      #x1E31	;LATIN SMALL LETTER K WITH ACUTE
      #x1E33	;LATIN SMALL LETTER K WITH DOT BELOW
      #x1E35	;LATIN SMALL LETTER K WITH LINE BELOW
      #x1E37	;LATIN SMALL LETTER L WITH DOT BELOW
      #x1E39	;LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
      #x1E3B	;LATIN SMALL LETTER L WITH LINE BELOW
      #x1E3D	;LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
      #x1E3F	;LATIN SMALL LETTER M WITH ACUTE
      #x1E41	;LATIN SMALL LETTER M WITH DOT ABOVE
      #x1E43	;LATIN SMALL LETTER M WITH DOT BELOW
      #x1E45	;LATIN SMALL LETTER N WITH DOT ABOVE
      #x1E47	;LATIN SMALL LETTER N WITH DOT BELOW
      #x1E49	;LATIN SMALL LETTER N WITH LINE BELOW
      #x1E4B	;LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
      #x1E4D	;LATIN SMALL LETTER O WITH TILDE AND ACUTE
      #x1E4F	;LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
      #x1E51	;LATIN SMALL LETTER O WITH MACRON AND GRAVE
      #x1E53	;LATIN SMALL LETTER O WITH MACRON AND ACUTE
      #x1E55	;LATIN SMALL LETTER P WITH ACUTE
      #x1E57	;LATIN SMALL LETTER P WITH DOT ABOVE
      #x1E59	;LATIN SMALL LETTER R WITH DOT ABOVE
      #x1E5B	;LATIN SMALL LETTER R WITH DOT BELOW
      #x1E5D	;LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
      #x1E5F	;LATIN SMALL LETTER R WITH LINE BELOW
      #x1E61	;LATIN SMALL LETTER S WITH DOT ABOVE
      #x1E63	;LATIN SMALL LETTER S WITH DOT BELOW
      #x1E65	;LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
      #x1E67	;LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
      #x1E69	;LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
      #x1E6B	;LATIN SMALL LETTER T WITH DOT ABOVE
      #x1E6D	;LATIN SMALL LETTER T WITH DOT BELOW
      #x1E6F	;LATIN SMALL LETTER T WITH LINE BELOW
      #x1E71	;LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
      #x1E73	;LATIN SMALL LETTER U WITH DIAERESIS BELOW
      #x1E75	;LATIN SMALL LETTER U WITH TILDE BELOW
      #x1E77	;LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
      #x1E79	;LATIN SMALL LETTER U WITH TILDE AND ACUTE
      #x1E7B	;LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
      #x1E7D	;LATIN SMALL LETTER V WITH TILDE
      #x1E7F	;LATIN SMALL LETTER V WITH DOT BELOW
      #x1E81	;LATIN SMALL LETTER W WITH GRAVE
      #x1E83	;LATIN SMALL LETTER W WITH ACUTE
      #x1E85	;LATIN SMALL LETTER W WITH DIAERESIS
      #x1E87	;LATIN SMALL LETTER W WITH DOT ABOVE
      #x1E89	;LATIN SMALL LETTER W WITH DOT BELOW
      #x1E8B	;LATIN SMALL LETTER X WITH DOT ABOVE
      #x1E8D	;LATIN SMALL LETTER X WITH DIAERESIS
      #x1E8F	;LATIN SMALL LETTER Y WITH DOT ABOVE
      #x1E91	;LATIN SMALL LETTER Z WITH CIRCUMFLEX
      #x1E93	;LATIN SMALL LETTER Z WITH DOT BELOW
      #x1E95	;LATIN SMALL LETTER Z WITH LINE BELOW
      #x1E96	;LATIN SMALL LETTER H WITH LINE BELOW
      #x1E97	;LATIN SMALL LETTER T WITH DIAERESIS
      #x1E98	;LATIN SMALL LETTER W WITH RING ABOVE
      #x1E99	;LATIN SMALL LETTER Y WITH RING ABOVE
      #x1E9A	;LATIN SMALL LETTER A WITH RIGHT HALF RING
      #x1E9B	;LATIN SMALL LETTER LONG S WITH DOT ABOVE
      #x1EA1	;LATIN SMALL LETTER A WITH DOT BELOW
      #x1EA3	;LATIN SMALL LETTER A WITH HOOK ABOVE
      #x1EA5	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
      #x1EA7	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
      #x1EA9	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EAB	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
      #x1EAD	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
      #x1EAF	;LATIN SMALL LETTER A WITH BREVE AND ACUTE
      #x1EB1	;LATIN SMALL LETTER A WITH BREVE AND GRAVE
      #x1EB3	;LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
      #x1EB5	;LATIN SMALL LETTER A WITH BREVE AND TILDE
      #x1EB7	;LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
      #x1EB9	;LATIN SMALL LETTER E WITH DOT BELOW
      #x1EBB	;LATIN SMALL LETTER E WITH HOOK ABOVE
      #x1EBD	;LATIN SMALL LETTER E WITH TILDE
      #x1EBF	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
      #x1EC1	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
      #x1EC3	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EC5	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
      #x1EC7	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
      #x1EC9	;LATIN SMALL LETTER I WITH HOOK ABOVE
      #x1ECB	;LATIN SMALL LETTER I WITH DOT BELOW
      #x1ECD	;LATIN SMALL LETTER O WITH DOT BELOW
      #x1ECF	;LATIN SMALL LETTER O WITH HOOK ABOVE
      #x1ED1	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
      #x1ED3	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
      #x1ED5	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
      #x1ED7	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
      #x1ED9	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
      #x1EDB	;LATIN SMALL LETTER O WITH HORN AND ACUTE
      #x1EDD	;LATIN SMALL LETTER O WITH HORN AND GRAVE
      #x1EDF	;LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
      #x1EE1	;LATIN SMALL LETTER O WITH HORN AND TILDE
      #x1EE3	;LATIN SMALL LETTER O WITH HORN AND DOT BELOW
      #x1EE5	;LATIN SMALL LETTER U WITH DOT BELOW
      #x1EE7	;LATIN SMALL LETTER U WITH HOOK ABOVE
      #x1EE9	;LATIN SMALL LETTER U WITH HORN AND ACUTE
      #x1EEB	;LATIN SMALL LETTER U WITH HORN AND GRAVE
      #x1EED	;LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
      #x1EEF	;LATIN SMALL LETTER U WITH HORN AND TILDE
      #x1EF1	;LATIN SMALL LETTER U WITH HORN AND DOT BELOW
      #x1EF3	;LATIN SMALL LETTER Y WITH GRAVE
      #x1EF5	;LATIN SMALL LETTER Y WITH DOT BELOW
      #x1EF7	;LATIN SMALL LETTER Y WITH HOOK ABOVE
      #x1EF9	;LATIN SMALL LETTER Y WITH TILDE
      #x1F00	;GREEK SMALL LETTER ALPHA WITH PSILI
      #x1F01	;GREEK SMALL LETTER ALPHA WITH DASIA
      #x1F02	;GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA
      #x1F03	;GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA
      #x1F04	;GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA
      #x1F05	;GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA
      #x1F06	;GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI
      #x1F07	;GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
      #x1F10	;GREEK SMALL LETTER EPSILON WITH PSILI
      #x1F11	;GREEK SMALL LETTER EPSILON WITH DASIA
      #x1F12	;GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA
      #x1F13	;GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA
      #x1F14	;GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA
      #x1F15	;GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
      #x1F20	;GREEK SMALL LETTER ETA WITH PSILI
      #x1F21	;GREEK SMALL LETTER ETA WITH DASIA
      #x1F22	;GREEK SMALL LETTER ETA WITH PSILI AND VARIA
      #x1F23	;GREEK SMALL LETTER ETA WITH DASIA AND VARIA
      #x1F24	;GREEK SMALL LETTER ETA WITH PSILI AND OXIA
      #x1F25	;GREEK SMALL LETTER ETA WITH DASIA AND OXIA
      #x1F26	;GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI
      #x1F27	;GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
      #x1F30	;GREEK SMALL LETTER IOTA WITH PSILI
      #x1F31	;GREEK SMALL LETTER IOTA WITH DASIA
      #x1F32	;GREEK SMALL LETTER IOTA WITH PSILI AND VARIA
      #x1F33	;GREEK SMALL LETTER IOTA WITH DASIA AND VARIA
      #x1F34	;GREEK SMALL LETTER IOTA WITH PSILI AND OXIA
      #x1F35	;GREEK SMALL LETTER IOTA WITH DASIA AND OXIA
      #x1F36	;GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI
      #x1F37	;GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
      #x1F40	;GREEK SMALL LETTER OMICRON WITH PSILI
      #x1F41	;GREEK SMALL LETTER OMICRON WITH DASIA
      #x1F42	;GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA
      #x1F43	;GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA
      #x1F44	;GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA
      #x1F45	;GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
      #x1F50	;GREEK SMALL LETTER UPSILON WITH PSILI
      #x1F51	;GREEK SMALL LETTER UPSILON WITH DASIA
      #x1F52	;GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
      #x1F53	;GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
      #x1F54	;GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
      #x1F55	;GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
      #x1F56	;GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
      #x1F57	;GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
      #x1F60	;GREEK SMALL LETTER OMEGA WITH PSILI
      #x1F61	;GREEK SMALL LETTER OMEGA WITH DASIA
      #x1F62	;GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA
      #x1F63	;GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA
      #x1F64	;GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA
      #x1F65	;GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA
      #x1F66	;GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI
      #x1F67	;GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
      #x1F70	;GREEK SMALL LETTER ALPHA WITH VARIA
      #x1F71	;GREEK SMALL LETTER ALPHA WITH OXIA
      #x1F72	;GREEK SMALL LETTER EPSILON WITH VARIA
      #x1F73	;GREEK SMALL LETTER EPSILON WITH OXIA
      #x1F74	;GREEK SMALL LETTER ETA WITH VARIA
      #x1F75	;GREEK SMALL LETTER ETA WITH OXIA
      #x1F76	;GREEK SMALL LETTER IOTA WITH VARIA
      #x1F77	;GREEK SMALL LETTER IOTA WITH OXIA
      #x1F78	;GREEK SMALL LETTER OMICRON WITH VARIA
      #x1F79	;GREEK SMALL LETTER OMICRON WITH OXIA
      #x1F7A	;GREEK SMALL LETTER UPSILON WITH VARIA
      #x1F7B	;GREEK SMALL LETTER UPSILON WITH OXIA
      #x1F7C	;GREEK SMALL LETTER OMEGA WITH VARIA
      #x1F7D	;GREEK SMALL LETTER OMEGA WITH OXIA
      #x1F80	;GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
      #x1F81	;GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
      #x1F82	;GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      #x1F83	;GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      #x1F84	;GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      #x1F85	;GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      #x1F86	;GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F87	;GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F90	;GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
      #x1F91	;GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
      #x1F92	;GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      #x1F93	;GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      #x1F94	;GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      #x1F95	;GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      #x1F96	;GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F97	;GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      #x1FA0	;GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
      #x1FA1	;GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
      #x1FA2	;GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      #x1FA3	;GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      #x1FA4	;GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      #x1FA5	;GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      #x1FA6	;GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      #x1FA7	;GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      #x1FB0	;GREEK SMALL LETTER ALPHA WITH VRACHY
      #x1FB1	;GREEK SMALL LETTER ALPHA WITH MACRON
      #x1FB2	;GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
      #x1FB3	;GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
      #x1FB4	;GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
      #x1FB6	;GREEK SMALL LETTER ALPHA WITH PERISPOMENI
      #x1FB7	;GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
      #x1FBE	;GREEK PROSGEGRAMMENI
      #x1FC2	;GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
      #x1FC3	;GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
      #x1FC4	;GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
      #x1FC6	;GREEK SMALL LETTER ETA WITH PERISPOMENI
      #x1FC7	;GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
      #x1FD0	;GREEK SMALL LETTER IOTA WITH VRACHY
      #x1FD1	;GREEK SMALL LETTER IOTA WITH MACRON
      #x1FD2	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
      #x1FD3	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
      #x1FD6	;GREEK SMALL LETTER IOTA WITH PERISPOMENI
      #x1FD7	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
      #x1FE0	;GREEK SMALL LETTER UPSILON WITH VRACHY
      #x1FE1	;GREEK SMALL LETTER UPSILON WITH MACRON
      #x1FE2	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
      #x1FE3	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
      #x1FE4	;GREEK SMALL LETTER RHO WITH PSILI
      #x1FE5	;GREEK SMALL LETTER RHO WITH DASIA
      #x1FE6	;GREEK SMALL LETTER UPSILON WITH PERISPOMENI
      #x1FE7	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
      #x1FF2	;GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
      #x1FF3	;GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
      #x1FF4	;GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
      #x1FF6	;GREEK SMALL LETTER OMEGA WITH PERISPOMENI
      #x1FF7	;GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
      #xFB00	;LATIN SMALL LIGATURE FF
      #xFB01	;LATIN SMALL LIGATURE FI
      #xFB02	;LATIN SMALL LIGATURE FL
      #xFB03	;LATIN SMALL LIGATURE FFI
      #xFB04	;LATIN SMALL LIGATURE FFL
      #xFB05	;LATIN SMALL LIGATURE LONG S T
      #xFB06	;LATIN SMALL LIGATURE ST
      #xFB13	;ARMENIAN SMALL LIGATURE MEN NOW
      #xFB14	;ARMENIAN SMALL LIGATURE MEN ECH
      #xFB15	;ARMENIAN SMALL LIGATURE MEN INI
      #xFB16	;ARMENIAN SMALL LIGATURE VEW NOW
      #xFB17	;ARMENIAN SMALL LIGATURE MEN XEH
      #xFF41	;FULLWIDTH LATIN SMALL LETTER A
      #xFF42	;FULLWIDTH LATIN SMALL LETTER B
      #xFF43	;FULLWIDTH LATIN SMALL LETTER C
      #xFF44	;FULLWIDTH LATIN SMALL LETTER D
      #xFF45	;FULLWIDTH LATIN SMALL LETTER E
      #xFF46	;FULLWIDTH LATIN SMALL LETTER F
      #xFF47	;FULLWIDTH LATIN SMALL LETTER G
      #xFF48	;FULLWIDTH LATIN SMALL LETTER H
      #xFF49	;FULLWIDTH LATIN SMALL LETTER I
      #xFF4A	;FULLWIDTH LATIN SMALL LETTER J
      #xFF4B	;FULLWIDTH LATIN SMALL LETTER K
      #xFF4C	;FULLWIDTH LATIN SMALL LETTER L
      #xFF4D	;FULLWIDTH LATIN SMALL LETTER M
      #xFF4E	;FULLWIDTH LATIN SMALL LETTER N
      #xFF4F	;FULLWIDTH LATIN SMALL LETTER O
      #xFF50	;FULLWIDTH LATIN SMALL LETTER P
      #xFF51	;FULLWIDTH LATIN SMALL LETTER Q
      #xFF52	;FULLWIDTH LATIN SMALL LETTER R
      #xFF53	;FULLWIDTH LATIN SMALL LETTER S
      #xFF54	;FULLWIDTH LATIN SMALL LETTER T
      #xFF55	;FULLWIDTH LATIN SMALL LETTER U
      #xFF56	;FULLWIDTH LATIN SMALL LETTER V
      #xFF57	;FULLWIDTH LATIN SMALL LETTER W
      #xFF58	;FULLWIDTH LATIN SMALL LETTER X
      #xFF59	;FULLWIDTH LATIN SMALL LETTER Y
      #xFF5A	;FULLWIDTH LATIN SMALL LETTER Z
      #x10428	;DESERET SMALL LETTER LONG I
      #x10429	;DESERET SMALL LETTER LONG E
      #x1042A	;DESERET SMALL LETTER LONG A
      #x1042B	;DESERET SMALL LETTER LONG AH
      #x1042C	;DESERET SMALL LETTER LONG O
      #x1042D	;DESERET SMALL LETTER LONG OO
      #x1042E	;DESERET SMALL LETTER SHORT I
      #x1042F	;DESERET SMALL LETTER SHORT E
      #x10430	;DESERET SMALL LETTER SHORT A
      #x10431	;DESERET SMALL LETTER SHORT AH
      #x10432	;DESERET SMALL LETTER SHORT O
      #x10433	;DESERET SMALL LETTER SHORT OO
      #x10434	;DESERET SMALL LETTER AY
      #x10435	;DESERET SMALL LETTER OW
      #x10436	;DESERET SMALL LETTER WU
      #x10437	;DESERET SMALL LETTER YEE
      #x10438	;DESERET SMALL LETTER H
      #x10439	;DESERET SMALL LETTER PEE
      #x1043A	;DESERET SMALL LETTER BEE
      #x1043B	;DESERET SMALL LETTER TEE
      #x1043C	;DESERET SMALL LETTER DEE
      #x1043D	;DESERET SMALL LETTER CHEE
      #x1043E	;DESERET SMALL LETTER JEE
      #x1043F	;DESERET SMALL LETTER KAY
      #x10440	;DESERET SMALL LETTER GAY
      #x10441	;DESERET SMALL LETTER EF
      #x10442	;DESERET SMALL LETTER VEE
      #x10443	;DESERET SMALL LETTER ETH
      #x10444	;DESERET SMALL LETTER THEE
      #x10445	;DESERET SMALL LETTER ES
      #x10446	;DESERET SMALL LETTER ZEE
      #x10447	;DESERET SMALL LETTER ESH
      #x10448	;DESERET SMALL LETTER ZHEE
      #x10449	;DESERET SMALL LETTER ER
      #x1044A	;DESERET SMALL LETTER EL
      #x1044B	;DESERET SMALL LETTER EM
      #x1044C	;DESERET SMALL LETTER EN
      #x1044D	;DESERET SMALL LETTER ENG
      #x1044E	;DESERET SMALL LETTER OI
      #x1044F	;DESERET SMALL LETTER EW
      #xE0061	;TAG LATIN SMALL LETTER A
      #xE0062	;TAG LATIN SMALL LETTER B
      #xE0063	;TAG LATIN SMALL LETTER C
      #xE0064	;TAG LATIN SMALL LETTER D
      #xE0065	;TAG LATIN SMALL LETTER E
      #xE0066	;TAG LATIN SMALL LETTER F
      #xE0067	;TAG LATIN SMALL LETTER G
      #xE0068	;TAG LATIN SMALL LETTER H
      #xE0069	;TAG LATIN SMALL LETTER I
      #xE006A	;TAG LATIN SMALL LETTER J
      #xE006B	;TAG LATIN SMALL LETTER K
      #xE006C	;TAG LATIN SMALL LETTER L
      #xE006D	;TAG LATIN SMALL LETTER M
      #xE006E	;TAG LATIN SMALL LETTER N
      #xE006F	;TAG LATIN SMALL LETTER O
      #xE0070	;TAG LATIN SMALL LETTER P
      #xE0071	;TAG LATIN SMALL LETTER Q
      #xE0072	;TAG LATIN SMALL LETTER R
      #xE0073	;TAG LATIN SMALL LETTER S
      #xE0074	;TAG LATIN SMALL LETTER T
      #xE0075	;TAG LATIN SMALL LETTER U
      #xE0076	;TAG LATIN SMALL LETTER V
      #xE0077	;TAG LATIN SMALL LETTER W
      #xE0078	;TAG LATIN SMALL LETTER X
      #xE0079	;TAG LATIN SMALL LETTER Y
      #xE007A	;TAG LATIN SMALL LETTER Z
)))

(define char-set:title-case
  (build-char-set
   '( #x01C5	;LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
      #x01C8	;LATIN CAPITAL LETTER L WITH SMALL LETTER J
      #x01CB	;LATIN CAPITAL LETTER N WITH SMALL LETTER J
      #x01F2	;LATIN CAPITAL LETTER D WITH SMALL LETTER Z
      #x1F88	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
      #x1F89	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
      #x1F8A	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1F8B	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1F8C	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1F8D	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1F8E	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F8F	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F98	;GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
      #x1F99	;GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
      #x1F9A	;GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1F9B	;GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1F9C	;GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1F9D	;GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1F9E	;GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F9F	;GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FA8	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
      #x1FA9	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
      #x1FAA	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1FAB	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1FAC	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1FAD	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1FAE	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FAF	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FBC	;GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
      #x1FCC	;GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
      #x1FFC	;GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
)))

(define char-set:letter
  (build-char-set
   '( #x0041	;LATIN CAPITAL LETTER A
      #x0042	;LATIN CAPITAL LETTER B
      #x0043	;LATIN CAPITAL LETTER C
      #x0044	;LATIN CAPITAL LETTER D
      #x0045	;LATIN CAPITAL LETTER E
      #x0046	;LATIN CAPITAL LETTER F
      #x0047	;LATIN CAPITAL LETTER G
      #x0048	;LATIN CAPITAL LETTER H
      #x0049	;LATIN CAPITAL LETTER I
      #x004A	;LATIN CAPITAL LETTER J
      #x004B	;LATIN CAPITAL LETTER K
      #x004C	;LATIN CAPITAL LETTER L
      #x004D	;LATIN CAPITAL LETTER M
      #x004E	;LATIN CAPITAL LETTER N
      #x004F	;LATIN CAPITAL LETTER O
      #x0050	;LATIN CAPITAL LETTER P
      #x0051	;LATIN CAPITAL LETTER Q
      #x0052	;LATIN CAPITAL LETTER R
      #x0053	;LATIN CAPITAL LETTER S
      #x0054	;LATIN CAPITAL LETTER T
      #x0055	;LATIN CAPITAL LETTER U
      #x0056	;LATIN CAPITAL LETTER V
      #x0057	;LATIN CAPITAL LETTER W
      #x0058	;LATIN CAPITAL LETTER X
      #x0059	;LATIN CAPITAL LETTER Y
      #x005A	;LATIN CAPITAL LETTER Z
      #x0061	;LATIN SMALL LETTER A
      #x0062	;LATIN SMALL LETTER B
      #x0063	;LATIN SMALL LETTER C
      #x0064	;LATIN SMALL LETTER D
      #x0065	;LATIN SMALL LETTER E
      #x0066	;LATIN SMALL LETTER F
      #x0067	;LATIN SMALL LETTER G
      #x0068	;LATIN SMALL LETTER H
      #x0069	;LATIN SMALL LETTER I
      #x006A	;LATIN SMALL LETTER J
      #x006B	;LATIN SMALL LETTER K
      #x006C	;LATIN SMALL LETTER L
      #x006D	;LATIN SMALL LETTER M
      #x006E	;LATIN SMALL LETTER N
      #x006F	;LATIN SMALL LETTER O
      #x0070	;LATIN SMALL LETTER P
      #x0071	;LATIN SMALL LETTER Q
      #x0072	;LATIN SMALL LETTER R
      #x0073	;LATIN SMALL LETTER S
      #x0074	;LATIN SMALL LETTER T
      #x0075	;LATIN SMALL LETTER U
      #x0076	;LATIN SMALL LETTER V
      #x0077	;LATIN SMALL LETTER W
      #x0078	;LATIN SMALL LETTER X
      #x0079	;LATIN SMALL LETTER Y
      #x007A	;LATIN SMALL LETTER Z
      #x00AA	;FEMININE ORDINAL INDICATOR
      #x00B5	;MICRO SIGN
      #x00BA	;MASCULINE ORDINAL INDICATOR
      #x00C0	;LATIN CAPITAL LETTER A WITH GRAVE
      #x00C1	;LATIN CAPITAL LETTER A WITH ACUTE
      #x00C2	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX
      #x00C3	;LATIN CAPITAL LETTER A WITH TILDE
      #x00C4	;LATIN CAPITAL LETTER A WITH DIAERESIS
      #x00C5	;LATIN CAPITAL LETTER A WITH RING ABOVE
      #x00C6	;LATIN CAPITAL LETTER AE
      #x00C7	;LATIN CAPITAL LETTER C WITH CEDILLA
      #x00C8	;LATIN CAPITAL LETTER E WITH GRAVE
      #x00C9	;LATIN CAPITAL LETTER E WITH ACUTE
      #x00CA	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX
      #x00CB	;LATIN CAPITAL LETTER E WITH DIAERESIS
      #x00CC	;LATIN CAPITAL LETTER I WITH GRAVE
      #x00CD	;LATIN CAPITAL LETTER I WITH ACUTE
      #x00CE	;LATIN CAPITAL LETTER I WITH CIRCUMFLEX
      #x00CF	;LATIN CAPITAL LETTER I WITH DIAERESIS
      #x00D0	;LATIN CAPITAL LETTER ETH
      #x00D1	;LATIN CAPITAL LETTER N WITH TILDE
      #x00D2	;LATIN CAPITAL LETTER O WITH GRAVE
      #x00D3	;LATIN CAPITAL LETTER O WITH ACUTE
      #x00D4	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX
      #x00D5	;LATIN CAPITAL LETTER O WITH TILDE
      #x00D6	;LATIN CAPITAL LETTER O WITH DIAERESIS
      #x00D8	;LATIN CAPITAL LETTER O WITH STROKE
      #x00D9	;LATIN CAPITAL LETTER U WITH GRAVE
      #x00DA	;LATIN CAPITAL LETTER U WITH ACUTE
      #x00DB	;LATIN CAPITAL LETTER U WITH CIRCUMFLEX
      #x00DC	;LATIN CAPITAL LETTER U WITH DIAERESIS
      #x00DD	;LATIN CAPITAL LETTER Y WITH ACUTE
      #x00DE	;LATIN CAPITAL LETTER THORN
      #x00DF	;LATIN SMALL LETTER SHARP S
      #x00E0	;LATIN SMALL LETTER A WITH GRAVE
      #x00E1	;LATIN SMALL LETTER A WITH ACUTE
      #x00E2	;LATIN SMALL LETTER A WITH CIRCUMFLEX
      #x00E3	;LATIN SMALL LETTER A WITH TILDE
      #x00E4	;LATIN SMALL LETTER A WITH DIAERESIS
      #x00E5	;LATIN SMALL LETTER A WITH RING ABOVE
      #x00E6	;LATIN SMALL LETTER AE
      #x00E7	;LATIN SMALL LETTER C WITH CEDILLA
      #x00E8	;LATIN SMALL LETTER E WITH GRAVE
      #x00E9	;LATIN SMALL LETTER E WITH ACUTE
      #x00EA	;LATIN SMALL LETTER E WITH CIRCUMFLEX
      #x00EB	;LATIN SMALL LETTER E WITH DIAERESIS
      #x00EC	;LATIN SMALL LETTER I WITH GRAVE
      #x00ED	;LATIN SMALL LETTER I WITH ACUTE
      #x00EE	;LATIN SMALL LETTER I WITH CIRCUMFLEX
      #x00EF	;LATIN SMALL LETTER I WITH DIAERESIS
      #x00F0	;LATIN SMALL LETTER ETH
      #x00F1	;LATIN SMALL LETTER N WITH TILDE
      #x00F2	;LATIN SMALL LETTER O WITH GRAVE
      #x00F3	;LATIN SMALL LETTER O WITH ACUTE
      #x00F4	;LATIN SMALL LETTER O WITH CIRCUMFLEX
      #x00F5	;LATIN SMALL LETTER O WITH TILDE
      #x00F6	;LATIN SMALL LETTER O WITH DIAERESIS
      #x00F8	;LATIN SMALL LETTER O WITH STROKE
      #x00F9	;LATIN SMALL LETTER U WITH GRAVE
      #x00FA	;LATIN SMALL LETTER U WITH ACUTE
      #x00FB	;LATIN SMALL LETTER U WITH CIRCUMFLEX
      #x00FC	;LATIN SMALL LETTER U WITH DIAERESIS
      #x00FD	;LATIN SMALL LETTER Y WITH ACUTE
      #x00FE	;LATIN SMALL LETTER THORN
      #x00FF	;LATIN SMALL LETTER Y WITH DIAERESIS
      #x0100	;LATIN CAPITAL LETTER A WITH MACRON
      #x0101	;LATIN SMALL LETTER A WITH MACRON
      #x0102	;LATIN CAPITAL LETTER A WITH BREVE
      #x0103	;LATIN SMALL LETTER A WITH BREVE
      #x0104	;LATIN CAPITAL LETTER A WITH OGONEK
      #x0105	;LATIN SMALL LETTER A WITH OGONEK
      #x0106	;LATIN CAPITAL LETTER C WITH ACUTE
      #x0107	;LATIN SMALL LETTER C WITH ACUTE
      #x0108	;LATIN CAPITAL LETTER C WITH CIRCUMFLEX
      #x0109	;LATIN SMALL LETTER C WITH CIRCUMFLEX
      #x010A	;LATIN CAPITAL LETTER C WITH DOT ABOVE
      #x010B	;LATIN SMALL LETTER C WITH DOT ABOVE
      #x010C	;LATIN CAPITAL LETTER C WITH CARON
      #x010D	;LATIN SMALL LETTER C WITH CARON
      #x010E	;LATIN CAPITAL LETTER D WITH CARON
      #x010F	;LATIN SMALL LETTER D WITH CARON
      #x0110	;LATIN CAPITAL LETTER D WITH STROKE
      #x0111	;LATIN SMALL LETTER D WITH STROKE
      #x0112	;LATIN CAPITAL LETTER E WITH MACRON
      #x0113	;LATIN SMALL LETTER E WITH MACRON
      #x0114	;LATIN CAPITAL LETTER E WITH BREVE
      #x0115	;LATIN SMALL LETTER E WITH BREVE
      #x0116	;LATIN CAPITAL LETTER E WITH DOT ABOVE
      #x0117	;LATIN SMALL LETTER E WITH DOT ABOVE
      #x0118	;LATIN CAPITAL LETTER E WITH OGONEK
      #x0119	;LATIN SMALL LETTER E WITH OGONEK
      #x011A	;LATIN CAPITAL LETTER E WITH CARON
      #x011B	;LATIN SMALL LETTER E WITH CARON
      #x011C	;LATIN CAPITAL LETTER G WITH CIRCUMFLEX
      #x011D	;LATIN SMALL LETTER G WITH CIRCUMFLEX
      #x011E	;LATIN CAPITAL LETTER G WITH BREVE
      #x011F	;LATIN SMALL LETTER G WITH BREVE
      #x0120	;LATIN CAPITAL LETTER G WITH DOT ABOVE
      #x0121	;LATIN SMALL LETTER G WITH DOT ABOVE
      #x0122	;LATIN CAPITAL LETTER G WITH CEDILLA
      #x0123	;LATIN SMALL LETTER G WITH CEDILLA
      #x0124	;LATIN CAPITAL LETTER H WITH CIRCUMFLEX
      #x0125	;LATIN SMALL LETTER H WITH CIRCUMFLEX
      #x0126	;LATIN CAPITAL LETTER H WITH STROKE
      #x0127	;LATIN SMALL LETTER H WITH STROKE
      #x0128	;LATIN CAPITAL LETTER I WITH TILDE
      #x0129	;LATIN SMALL LETTER I WITH TILDE
      #x012A	;LATIN CAPITAL LETTER I WITH MACRON
      #x012B	;LATIN SMALL LETTER I WITH MACRON
      #x012C	;LATIN CAPITAL LETTER I WITH BREVE
      #x012D	;LATIN SMALL LETTER I WITH BREVE
      #x012E	;LATIN CAPITAL LETTER I WITH OGONEK
      #x012F	;LATIN SMALL LETTER I WITH OGONEK
      #x0130	;LATIN CAPITAL LETTER I WITH DOT ABOVE
      #x0131	;LATIN SMALL LETTER DOTLESS I
      #x0132	;LATIN CAPITAL LIGATURE IJ
      #x0133	;LATIN SMALL LIGATURE IJ
      #x0134	;LATIN CAPITAL LETTER J WITH CIRCUMFLEX
      #x0135	;LATIN SMALL LETTER J WITH CIRCUMFLEX
      #x0136	;LATIN CAPITAL LETTER K WITH CEDILLA
      #x0137	;LATIN SMALL LETTER K WITH CEDILLA
      #x0138	;LATIN SMALL LETTER KRA
      #x0139	;LATIN CAPITAL LETTER L WITH ACUTE
      #x013A	;LATIN SMALL LETTER L WITH ACUTE
      #x013B	;LATIN CAPITAL LETTER L WITH CEDILLA
      #x013C	;LATIN SMALL LETTER L WITH CEDILLA
      #x013D	;LATIN CAPITAL LETTER L WITH CARON
      #x013E	;LATIN SMALL LETTER L WITH CARON
      #x013F	;LATIN CAPITAL LETTER L WITH MIDDLE DOT
      #x0140	;LATIN SMALL LETTER L WITH MIDDLE DOT
      #x0141	;LATIN CAPITAL LETTER L WITH STROKE
      #x0142	;LATIN SMALL LETTER L WITH STROKE
      #x0143	;LATIN CAPITAL LETTER N WITH ACUTE
      #x0144	;LATIN SMALL LETTER N WITH ACUTE
      #x0145	;LATIN CAPITAL LETTER N WITH CEDILLA
      #x0146	;LATIN SMALL LETTER N WITH CEDILLA
      #x0147	;LATIN CAPITAL LETTER N WITH CARON
      #x0148	;LATIN SMALL LETTER N WITH CARON
      #x0149	;LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
      #x014A	;LATIN CAPITAL LETTER ENG
      #x014B	;LATIN SMALL LETTER ENG
      #x014C	;LATIN CAPITAL LETTER O WITH MACRON
      #x014D	;LATIN SMALL LETTER O WITH MACRON
      #x014E	;LATIN CAPITAL LETTER O WITH BREVE
      #x014F	;LATIN SMALL LETTER O WITH BREVE
      #x0150	;LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
      #x0151	;LATIN SMALL LETTER O WITH DOUBLE ACUTE
      #x0152	;LATIN CAPITAL LIGATURE OE
      #x0153	;LATIN SMALL LIGATURE OE
      #x0154	;LATIN CAPITAL LETTER R WITH ACUTE
      #x0155	;LATIN SMALL LETTER R WITH ACUTE
      #x0156	;LATIN CAPITAL LETTER R WITH CEDILLA
      #x0157	;LATIN SMALL LETTER R WITH CEDILLA
      #x0158	;LATIN CAPITAL LETTER R WITH CARON
      #x0159	;LATIN SMALL LETTER R WITH CARON
      #x015A	;LATIN CAPITAL LETTER S WITH ACUTE
      #x015B	;LATIN SMALL LETTER S WITH ACUTE
      #x015C	;LATIN CAPITAL LETTER S WITH CIRCUMFLEX
      #x015D	;LATIN SMALL LETTER S WITH CIRCUMFLEX
      #x015E	;LATIN CAPITAL LETTER S WITH CEDILLA
      #x015F	;LATIN SMALL LETTER S WITH CEDILLA
      #x0160	;LATIN CAPITAL LETTER S WITH CARON
      #x0161	;LATIN SMALL LETTER S WITH CARON
      #x0162	;LATIN CAPITAL LETTER T WITH CEDILLA
      #x0163	;LATIN SMALL LETTER T WITH CEDILLA
      #x0164	;LATIN CAPITAL LETTER T WITH CARON
      #x0165	;LATIN SMALL LETTER T WITH CARON
      #x0166	;LATIN CAPITAL LETTER T WITH STROKE
      #x0167	;LATIN SMALL LETTER T WITH STROKE
      #x0168	;LATIN CAPITAL LETTER U WITH TILDE
      #x0169	;LATIN SMALL LETTER U WITH TILDE
      #x016A	;LATIN CAPITAL LETTER U WITH MACRON
      #x016B	;LATIN SMALL LETTER U WITH MACRON
      #x016C	;LATIN CAPITAL LETTER U WITH BREVE
      #x016D	;LATIN SMALL LETTER U WITH BREVE
      #x016E	;LATIN CAPITAL LETTER U WITH RING ABOVE
      #x016F	;LATIN SMALL LETTER U WITH RING ABOVE
      #x0170	;LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
      #x0171	;LATIN SMALL LETTER U WITH DOUBLE ACUTE
      #x0172	;LATIN CAPITAL LETTER U WITH OGONEK
      #x0173	;LATIN SMALL LETTER U WITH OGONEK
      #x0174	;LATIN CAPITAL LETTER W WITH CIRCUMFLEX
      #x0175	;LATIN SMALL LETTER W WITH CIRCUMFLEX
      #x0176	;LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
      #x0177	;LATIN SMALL LETTER Y WITH CIRCUMFLEX
      #x0178	;LATIN CAPITAL LETTER Y WITH DIAERESIS
      #x0179	;LATIN CAPITAL LETTER Z WITH ACUTE
      #x017A	;LATIN SMALL LETTER Z WITH ACUTE
      #x017B	;LATIN CAPITAL LETTER Z WITH DOT ABOVE
      #x017C	;LATIN SMALL LETTER Z WITH DOT ABOVE
      #x017D	;LATIN CAPITAL LETTER Z WITH CARON
      #x017E	;LATIN SMALL LETTER Z WITH CARON
      #x017F	;LATIN SMALL LETTER LONG S
      #x0180	;LATIN SMALL LETTER B WITH STROKE
      #x0181	;LATIN CAPITAL LETTER B WITH HOOK
      #x0182	;LATIN CAPITAL LETTER B WITH TOPBAR
      #x0183	;LATIN SMALL LETTER B WITH TOPBAR
      #x0184	;LATIN CAPITAL LETTER TONE SIX
      #x0185	;LATIN SMALL LETTER TONE SIX
      #x0186	;LATIN CAPITAL LETTER OPEN O
      #x0187	;LATIN CAPITAL LETTER C WITH HOOK
      #x0188	;LATIN SMALL LETTER C WITH HOOK
      #x0189	;LATIN CAPITAL LETTER AFRICAN D
      #x018A	;LATIN CAPITAL LETTER D WITH HOOK
      #x018B	;LATIN CAPITAL LETTER D WITH TOPBAR
      #x018C	;LATIN SMALL LETTER D WITH TOPBAR
      #x018D	;LATIN SMALL LETTER TURNED DELTA
      #x018E	;LATIN CAPITAL LETTER REVERSED E
      #x018F	;LATIN CAPITAL LETTER SCHWA
      #x0190	;LATIN CAPITAL LETTER OPEN E
      #x0191	;LATIN CAPITAL LETTER F WITH HOOK
      #x0192	;LATIN SMALL LETTER F WITH HOOK
      #x0193	;LATIN CAPITAL LETTER G WITH HOOK
      #x0194	;LATIN CAPITAL LETTER GAMMA
      #x0195	;LATIN SMALL LETTER HV
      #x0196	;LATIN CAPITAL LETTER IOTA
      #x0197	;LATIN CAPITAL LETTER I WITH STROKE
      #x0198	;LATIN CAPITAL LETTER K WITH HOOK
      #x0199	;LATIN SMALL LETTER K WITH HOOK
      #x019A	;LATIN SMALL LETTER L WITH BAR
      #x019B	;LATIN SMALL LETTER LAMBDA WITH STROKE
      #x019C	;LATIN CAPITAL LETTER TURNED M
      #x019D	;LATIN CAPITAL LETTER N WITH LEFT HOOK
      #x019E	;LATIN SMALL LETTER N WITH LONG RIGHT LEG
      #x019F	;LATIN CAPITAL LETTER O WITH MIDDLE TILDE
      #x01A0	;LATIN CAPITAL LETTER O WITH HORN
      #x01A1	;LATIN SMALL LETTER O WITH HORN
      #x01A2	;LATIN CAPITAL LETTER OI
      #x01A3	;LATIN SMALL LETTER OI
      #x01A4	;LATIN CAPITAL LETTER P WITH HOOK
      #x01A5	;LATIN SMALL LETTER P WITH HOOK
      #x01A6	;LATIN LETTER YR
      #x01A7	;LATIN CAPITAL LETTER TONE TWO
      #x01A8	;LATIN SMALL LETTER TONE TWO
      #x01A9	;LATIN CAPITAL LETTER ESH
      #x01AA	;LATIN LETTER REVERSED ESH LOOP
      #x01AB	;LATIN SMALL LETTER T WITH PALATAL HOOK
      #x01AC	;LATIN CAPITAL LETTER T WITH HOOK
      #x01AD	;LATIN SMALL LETTER T WITH HOOK
      #x01AE	;LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
      #x01AF	;LATIN CAPITAL LETTER U WITH HORN
      #x01B0	;LATIN SMALL LETTER U WITH HORN
      #x01B1	;LATIN CAPITAL LETTER UPSILON
      #x01B2	;LATIN CAPITAL LETTER V WITH HOOK
      #x01B3	;LATIN CAPITAL LETTER Y WITH HOOK
      #x01B4	;LATIN SMALL LETTER Y WITH HOOK
      #x01B5	;LATIN CAPITAL LETTER Z WITH STROKE
      #x01B6	;LATIN SMALL LETTER Z WITH STROKE
      #x01B7	;LATIN CAPITAL LETTER EZH
      #x01B8	;LATIN CAPITAL LETTER EZH REVERSED
      #x01B9	;LATIN SMALL LETTER EZH REVERSED
      #x01BA	;LATIN SMALL LETTER EZH WITH TAIL
      #x01BB	;LATIN LETTER TWO WITH STROKE
      #x01BC	;LATIN CAPITAL LETTER TONE FIVE
      #x01BD	;LATIN SMALL LETTER TONE FIVE
      #x01BE	;LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE
      #x01BF	;LATIN LETTER WYNN
      #x01C0	;LATIN LETTER DENTAL CLICK
      #x01C1	;LATIN LETTER LATERAL CLICK
      #x01C2	;LATIN LETTER ALVEOLAR CLICK
      #x01C3	;LATIN LETTER RETROFLEX CLICK
      #x01C4	;LATIN CAPITAL LETTER DZ WITH CARON
      #x01C5	;LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
      #x01C6	;LATIN SMALL LETTER DZ WITH CARON
      #x01C7	;LATIN CAPITAL LETTER LJ
      #x01C8	;LATIN CAPITAL LETTER L WITH SMALL LETTER J
      #x01C9	;LATIN SMALL LETTER LJ
      #x01CA	;LATIN CAPITAL LETTER NJ
      #x01CB	;LATIN CAPITAL LETTER N WITH SMALL LETTER J
      #x01CC	;LATIN SMALL LETTER NJ
      #x01CD	;LATIN CAPITAL LETTER A WITH CARON
      #x01CE	;LATIN SMALL LETTER A WITH CARON
      #x01CF	;LATIN CAPITAL LETTER I WITH CARON
      #x01D0	;LATIN SMALL LETTER I WITH CARON
      #x01D1	;LATIN CAPITAL LETTER O WITH CARON
      #x01D2	;LATIN SMALL LETTER O WITH CARON
      #x01D3	;LATIN CAPITAL LETTER U WITH CARON
      #x01D4	;LATIN SMALL LETTER U WITH CARON
      #x01D5	;LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
      #x01D6	;LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
      #x01D7	;LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
      #x01D8	;LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
      #x01D9	;LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
      #x01DA	;LATIN SMALL LETTER U WITH DIAERESIS AND CARON
      #x01DB	;LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
      #x01DC	;LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
      #x01DD	;LATIN SMALL LETTER TURNED E
      #x01DE	;LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
      #x01DF	;LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
      #x01E0	;LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
      #x01E1	;LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
      #x01E2	;LATIN CAPITAL LETTER AE WITH MACRON
      #x01E3	;LATIN SMALL LETTER AE WITH MACRON
      #x01E4	;LATIN CAPITAL LETTER G WITH STROKE
      #x01E5	;LATIN SMALL LETTER G WITH STROKE
      #x01E6	;LATIN CAPITAL LETTER G WITH CARON
      #x01E7	;LATIN SMALL LETTER G WITH CARON
      #x01E8	;LATIN CAPITAL LETTER K WITH CARON
      #x01E9	;LATIN SMALL LETTER K WITH CARON
      #x01EA	;LATIN CAPITAL LETTER O WITH OGONEK
      #x01EB	;LATIN SMALL LETTER O WITH OGONEK
      #x01EC	;LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
      #x01ED	;LATIN SMALL LETTER O WITH OGONEK AND MACRON
      #x01EE	;LATIN CAPITAL LETTER EZH WITH CARON
      #x01EF	;LATIN SMALL LETTER EZH WITH CARON
      #x01F0	;LATIN SMALL LETTER J WITH CARON
      #x01F1	;LATIN CAPITAL LETTER DZ
      #x01F2	;LATIN CAPITAL LETTER D WITH SMALL LETTER Z
      #x01F3	;LATIN SMALL LETTER DZ
      #x01F4	;LATIN CAPITAL LETTER G WITH ACUTE
      #x01F5	;LATIN SMALL LETTER G WITH ACUTE
      #x01F6	;LATIN CAPITAL LETTER HWAIR
      #x01F7	;LATIN CAPITAL LETTER WYNN
      #x01F8	;LATIN CAPITAL LETTER N WITH GRAVE
      #x01F9	;LATIN SMALL LETTER N WITH GRAVE
      #x01FA	;LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
      #x01FB	;LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
      #x01FC	;LATIN CAPITAL LETTER AE WITH ACUTE
      #x01FD	;LATIN SMALL LETTER AE WITH ACUTE
      #x01FE	;LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
      #x01FF	;LATIN SMALL LETTER O WITH STROKE AND ACUTE
      #x0200	;LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
      #x0201	;LATIN SMALL LETTER A WITH DOUBLE GRAVE
      #x0202	;LATIN CAPITAL LETTER A WITH INVERTED BREVE
      #x0203	;LATIN SMALL LETTER A WITH INVERTED BREVE
      #x0204	;LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
      #x0205	;LATIN SMALL LETTER E WITH DOUBLE GRAVE
      #x0206	;LATIN CAPITAL LETTER E WITH INVERTED BREVE
      #x0207	;LATIN SMALL LETTER E WITH INVERTED BREVE
      #x0208	;LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
      #x0209	;LATIN SMALL LETTER I WITH DOUBLE GRAVE
      #x020A	;LATIN CAPITAL LETTER I WITH INVERTED BREVE
      #x020B	;LATIN SMALL LETTER I WITH INVERTED BREVE
      #x020C	;LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
      #x020D	;LATIN SMALL LETTER O WITH DOUBLE GRAVE
      #x020E	;LATIN CAPITAL LETTER O WITH INVERTED BREVE
      #x020F	;LATIN SMALL LETTER O WITH INVERTED BREVE
      #x0210	;LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
      #x0211	;LATIN SMALL LETTER R WITH DOUBLE GRAVE
      #x0212	;LATIN CAPITAL LETTER R WITH INVERTED BREVE
      #x0213	;LATIN SMALL LETTER R WITH INVERTED BREVE
      #x0214	;LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
      #x0215	;LATIN SMALL LETTER U WITH DOUBLE GRAVE
      #x0216	;LATIN CAPITAL LETTER U WITH INVERTED BREVE
      #x0217	;LATIN SMALL LETTER U WITH INVERTED BREVE
      #x0218	;LATIN CAPITAL LETTER S WITH COMMA BELOW
      #x0219	;LATIN SMALL LETTER S WITH COMMA BELOW
      #x021A	;LATIN CAPITAL LETTER T WITH COMMA BELOW
      #x021B	;LATIN SMALL LETTER T WITH COMMA BELOW
      #x021C	;LATIN CAPITAL LETTER YOGH
      #x021D	;LATIN SMALL LETTER YOGH
      #x021E	;LATIN CAPITAL LETTER H WITH CARON
      #x021F	;LATIN SMALL LETTER H WITH CARON
      #x0220	;LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
      #x0221	;LATIN SMALL LETTER D WITH CURL
      #x0222	;LATIN CAPITAL LETTER OU
      #x0223	;LATIN SMALL LETTER OU
      #x0224	;LATIN CAPITAL LETTER Z WITH HOOK
      #x0225	;LATIN SMALL LETTER Z WITH HOOK
      #x0226	;LATIN CAPITAL LETTER A WITH DOT ABOVE
      #x0227	;LATIN SMALL LETTER A WITH DOT ABOVE
      #x0228	;LATIN CAPITAL LETTER E WITH CEDILLA
      #x0229	;LATIN SMALL LETTER E WITH CEDILLA
      #x022A	;LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
      #x022B	;LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
      #x022C	;LATIN CAPITAL LETTER O WITH TILDE AND MACRON
      #x022D	;LATIN SMALL LETTER O WITH TILDE AND MACRON
      #x022E	;LATIN CAPITAL LETTER O WITH DOT ABOVE
      #x022F	;LATIN SMALL LETTER O WITH DOT ABOVE
      #x0230	;LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
      #x0231	;LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
      #x0232	;LATIN CAPITAL LETTER Y WITH MACRON
      #x0233	;LATIN SMALL LETTER Y WITH MACRON
      #x0234	;LATIN SMALL LETTER L WITH CURL
      #x0235	;LATIN SMALL LETTER N WITH CURL
      #x0236	;LATIN SMALL LETTER T WITH CURL
      #x0250	;LATIN SMALL LETTER TURNED A
      #x0251	;LATIN SMALL LETTER ALPHA
      #x0252	;LATIN SMALL LETTER TURNED ALPHA
      #x0253	;LATIN SMALL LETTER B WITH HOOK
      #x0254	;LATIN SMALL LETTER OPEN O
      #x0255	;LATIN SMALL LETTER C WITH CURL
      #x0256	;LATIN SMALL LETTER D WITH TAIL
      #x0257	;LATIN SMALL LETTER D WITH HOOK
      #x0258	;LATIN SMALL LETTER REVERSED E
      #x0259	;LATIN SMALL LETTER SCHWA
      #x025A	;LATIN SMALL LETTER SCHWA WITH HOOK
      #x025B	;LATIN SMALL LETTER OPEN E
      #x025C	;LATIN SMALL LETTER REVERSED OPEN E
      #x025D	;LATIN SMALL LETTER REVERSED OPEN E WITH HOOK
      #x025E	;LATIN SMALL LETTER CLOSED REVERSED OPEN E
      #x025F	;LATIN SMALL LETTER DOTLESS J WITH STROKE
      #x0260	;LATIN SMALL LETTER G WITH HOOK
      #x0261	;LATIN SMALL LETTER SCRIPT G
      #x0262	;LATIN LETTER SMALL CAPITAL G
      #x0263	;LATIN SMALL LETTER GAMMA
      #x0264	;LATIN SMALL LETTER RAMS HORN
      #x0265	;LATIN SMALL LETTER TURNED H
      #x0266	;LATIN SMALL LETTER H WITH HOOK
      #x0267	;LATIN SMALL LETTER HENG WITH HOOK
      #x0268	;LATIN SMALL LETTER I WITH STROKE
      #x0269	;LATIN SMALL LETTER IOTA
      #x026A	;LATIN LETTER SMALL CAPITAL I
      #x026B	;LATIN SMALL LETTER L WITH MIDDLE TILDE
      #x026C	;LATIN SMALL LETTER L WITH BELT
      #x026D	;LATIN SMALL LETTER L WITH RETROFLEX HOOK
      #x026E	;LATIN SMALL LETTER LEZH
      #x026F	;LATIN SMALL LETTER TURNED M
      #x0270	;LATIN SMALL LETTER TURNED M WITH LONG LEG
      #x0271	;LATIN SMALL LETTER M WITH HOOK
      #x0272	;LATIN SMALL LETTER N WITH LEFT HOOK
      #x0273	;LATIN SMALL LETTER N WITH RETROFLEX HOOK
      #x0274	;LATIN LETTER SMALL CAPITAL N
      #x0275	;LATIN SMALL LETTER BARRED O
      #x0276	;LATIN LETTER SMALL CAPITAL OE
      #x0277	;LATIN SMALL LETTER CLOSED OMEGA
      #x0278	;LATIN SMALL LETTER PHI
      #x0279	;LATIN SMALL LETTER TURNED R
      #x027A	;LATIN SMALL LETTER TURNED R WITH LONG LEG
      #x027B	;LATIN SMALL LETTER TURNED R WITH HOOK
      #x027C	;LATIN SMALL LETTER R WITH LONG LEG
      #x027D	;LATIN SMALL LETTER R WITH TAIL
      #x027E	;LATIN SMALL LETTER R WITH FISHHOOK
      #x027F	;LATIN SMALL LETTER REVERSED R WITH FISHHOOK
      #x0280	;LATIN LETTER SMALL CAPITAL R
      #x0281	;LATIN LETTER SMALL CAPITAL INVERTED R
      #x0282	;LATIN SMALL LETTER S WITH HOOK
      #x0283	;LATIN SMALL LETTER ESH
      #x0284	;LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK
      #x0285	;LATIN SMALL LETTER SQUAT REVERSED ESH
      #x0286	;LATIN SMALL LETTER ESH WITH CURL
      #x0287	;LATIN SMALL LETTER TURNED T
      #x0288	;LATIN SMALL LETTER T WITH RETROFLEX HOOK
      #x0289	;LATIN SMALL LETTER U BAR
      #x028A	;LATIN SMALL LETTER UPSILON
      #x028B	;LATIN SMALL LETTER V WITH HOOK
      #x028C	;LATIN SMALL LETTER TURNED V
      #x028D	;LATIN SMALL LETTER TURNED W
      #x028E	;LATIN SMALL LETTER TURNED Y
      #x028F	;LATIN LETTER SMALL CAPITAL Y
      #x0290	;LATIN SMALL LETTER Z WITH RETROFLEX HOOK
      #x0291	;LATIN SMALL LETTER Z WITH CURL
      #x0292	;LATIN SMALL LETTER EZH
      #x0293	;LATIN SMALL LETTER EZH WITH CURL
      #x0294	;LATIN LETTER GLOTTAL STOP
      #x0295	;LATIN LETTER PHARYNGEAL VOICED FRICATIVE
      #x0296	;LATIN LETTER INVERTED GLOTTAL STOP
      #x0297	;LATIN LETTER STRETCHED C
      #x0298	;LATIN LETTER BILABIAL CLICK
      #x0299	;LATIN LETTER SMALL CAPITAL B
      #x029A	;LATIN SMALL LETTER CLOSED OPEN E
      #x029B	;LATIN LETTER SMALL CAPITAL G WITH HOOK
      #x029C	;LATIN LETTER SMALL CAPITAL H
      #x029D	;LATIN SMALL LETTER J WITH CROSSED-TAIL
      #x029E	;LATIN SMALL LETTER TURNED K
      #x029F	;LATIN LETTER SMALL CAPITAL L
      #x02A0	;LATIN SMALL LETTER Q WITH HOOK
      #x02A1	;LATIN LETTER GLOTTAL STOP WITH STROKE
      #x02A2	;LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE
      #x02A3	;LATIN SMALL LETTER DZ DIGRAPH
      #x02A4	;LATIN SMALL LETTER DEZH DIGRAPH
      #x02A5	;LATIN SMALL LETTER DZ DIGRAPH WITH CURL
      #x02A6	;LATIN SMALL LETTER TS DIGRAPH
      #x02A7	;LATIN SMALL LETTER TESH DIGRAPH
      #x02A8	;LATIN SMALL LETTER TC DIGRAPH WITH CURL
      #x02A9	;LATIN SMALL LETTER FENG DIGRAPH
      #x02AA	;LATIN SMALL LETTER LS DIGRAPH
      #x02AB	;LATIN SMALL LETTER LZ DIGRAPH
      #x02AC	;LATIN LETTER BILABIAL PERCUSSIVE
      #x02AD	;LATIN LETTER BIDENTAL PERCUSSIVE
      #x02AE	;LATIN SMALL LETTER TURNED H WITH FISHHOOK
      #x02AF	;LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
      #x02B0	;MODIFIER LETTER SMALL H
      #x02B1	;MODIFIER LETTER SMALL H WITH HOOK
      #x02B2	;MODIFIER LETTER SMALL J
      #x02B3	;MODIFIER LETTER SMALL R
      #x02B4	;MODIFIER LETTER SMALL TURNED R
      #x02B5	;MODIFIER LETTER SMALL TURNED R WITH HOOK
      #x02B6	;MODIFIER LETTER SMALL CAPITAL INVERTED R
      #x02B7	;MODIFIER LETTER SMALL W
      #x02B8	;MODIFIER LETTER SMALL Y
      #x02B9	;MODIFIER LETTER PRIME
      #x02BA	;MODIFIER LETTER DOUBLE PRIME
      #x02BB	;MODIFIER LETTER TURNED COMMA
      #x02BC	;MODIFIER LETTER APOSTROPHE
      #x02BD	;MODIFIER LETTER REVERSED COMMA
      #x02BE	;MODIFIER LETTER RIGHT HALF RING
      #x02BF	;MODIFIER LETTER LEFT HALF RING
      #x02C0	;MODIFIER LETTER GLOTTAL STOP
      #x02C1	;MODIFIER LETTER REVERSED GLOTTAL STOP
      #x02C6	;MODIFIER LETTER CIRCUMFLEX ACCENT
      #x02C7	;CARON
      #x02C8	;MODIFIER LETTER VERTICAL LINE
      #x02C9	;MODIFIER LETTER MACRON
      #x02CA	;MODIFIER LETTER ACUTE ACCENT
      #x02CB	;MODIFIER LETTER GRAVE ACCENT
      #x02CC	;MODIFIER LETTER LOW VERTICAL LINE
      #x02CD	;MODIFIER LETTER LOW MACRON
      #x02CE	;MODIFIER LETTER LOW GRAVE ACCENT
      #x02CF	;MODIFIER LETTER LOW ACUTE ACCENT
      #x02D0	;MODIFIER LETTER TRIANGULAR COLON
      #x02D1	;MODIFIER LETTER HALF TRIANGULAR COLON
      #x02E0	;MODIFIER LETTER SMALL GAMMA
      #x02E1	;MODIFIER LETTER SMALL L
      #x02E2	;MODIFIER LETTER SMALL S
      #x02E3	;MODIFIER LETTER SMALL X
      #x02E4	;MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
      #x02EE	;MODIFIER LETTER DOUBLE APOSTROPHE
      #x037A	;GREEK YPOGEGRAMMENI
      #x0386	;GREEK CAPITAL LETTER ALPHA WITH TONOS
      #x0388	;GREEK CAPITAL LETTER EPSILON WITH TONOS
      #x0389	;GREEK CAPITAL LETTER ETA WITH TONOS
      #x038A	;GREEK CAPITAL LETTER IOTA WITH TONOS
      #x038C	;GREEK CAPITAL LETTER OMICRON WITH TONOS
      #x038E	;GREEK CAPITAL LETTER UPSILON WITH TONOS
      #x038F	;GREEK CAPITAL LETTER OMEGA WITH TONOS
      #x0390	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
      #x0391	;GREEK CAPITAL LETTER ALPHA
      #x0392	;GREEK CAPITAL LETTER BETA
      #x0393	;GREEK CAPITAL LETTER GAMMA
      #x0394	;GREEK CAPITAL LETTER DELTA
      #x0395	;GREEK CAPITAL LETTER EPSILON
      #x0396	;GREEK CAPITAL LETTER ZETA
      #x0397	;GREEK CAPITAL LETTER ETA
      #x0398	;GREEK CAPITAL LETTER THETA
      #x0399	;GREEK CAPITAL LETTER IOTA
      #x039A	;GREEK CAPITAL LETTER KAPPA
      #x039B	;GREEK CAPITAL LETTER LAMDA
      #x039C	;GREEK CAPITAL LETTER MU
      #x039D	;GREEK CAPITAL LETTER NU
      #x039E	;GREEK CAPITAL LETTER XI
      #x039F	;GREEK CAPITAL LETTER OMICRON
      #x03A0	;GREEK CAPITAL LETTER PI
      #x03A1	;GREEK CAPITAL LETTER RHO
      #x03A3	;GREEK CAPITAL LETTER SIGMA
      #x03A4	;GREEK CAPITAL LETTER TAU
      #x03A5	;GREEK CAPITAL LETTER UPSILON
      #x03A6	;GREEK CAPITAL LETTER PHI
      #x03A7	;GREEK CAPITAL LETTER CHI
      #x03A8	;GREEK CAPITAL LETTER PSI
      #x03A9	;GREEK CAPITAL LETTER OMEGA
      #x03AA	;GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
      #x03AB	;GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
      #x03AC	;GREEK SMALL LETTER ALPHA WITH TONOS
      #x03AD	;GREEK SMALL LETTER EPSILON WITH TONOS
      #x03AE	;GREEK SMALL LETTER ETA WITH TONOS
      #x03AF	;GREEK SMALL LETTER IOTA WITH TONOS
      #x03B0	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
      #x03B1	;GREEK SMALL LETTER ALPHA
      #x03B2	;GREEK SMALL LETTER BETA
      #x03B3	;GREEK SMALL LETTER GAMMA
      #x03B4	;GREEK SMALL LETTER DELTA
      #x03B5	;GREEK SMALL LETTER EPSILON
      #x03B6	;GREEK SMALL LETTER ZETA
      #x03B7	;GREEK SMALL LETTER ETA
      #x03B8	;GREEK SMALL LETTER THETA
      #x03B9	;GREEK SMALL LETTER IOTA
      #x03BA	;GREEK SMALL LETTER KAPPA
      #x03BB	;GREEK SMALL LETTER LAMDA
      #x03BC	;GREEK SMALL LETTER MU
      #x03BD	;GREEK SMALL LETTER NU
      #x03BE	;GREEK SMALL LETTER XI
      #x03BF	;GREEK SMALL LETTER OMICRON
      #x03C0	;GREEK SMALL LETTER PI
      #x03C1	;GREEK SMALL LETTER RHO
      #x03C2	;GREEK SMALL LETTER FINAL SIGMA
      #x03C3	;GREEK SMALL LETTER SIGMA
      #x03C4	;GREEK SMALL LETTER TAU
      #x03C5	;GREEK SMALL LETTER UPSILON
      #x03C6	;GREEK SMALL LETTER PHI
      #x03C7	;GREEK SMALL LETTER CHI
      #x03C8	;GREEK SMALL LETTER PSI
      #x03C9	;GREEK SMALL LETTER OMEGA
      #x03CA	;GREEK SMALL LETTER IOTA WITH DIALYTIKA
      #x03CB	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA
      #x03CC	;GREEK SMALL LETTER OMICRON WITH TONOS
      #x03CD	;GREEK SMALL LETTER UPSILON WITH TONOS
      #x03CE	;GREEK SMALL LETTER OMEGA WITH TONOS
      #x03D0	;GREEK BETA SYMBOL
      #x03D1	;GREEK THETA SYMBOL
      #x03D2	;GREEK UPSILON WITH HOOK SYMBOL
      #x03D3	;GREEK UPSILON WITH ACUTE AND HOOK SYMBOL
      #x03D4	;GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
      #x03D5	;GREEK PHI SYMBOL
      #x03D6	;GREEK PI SYMBOL
      #x03D7	;GREEK KAI SYMBOL
      #x03D8	;GREEK LETTER ARCHAIC KOPPA
      #x03D9	;GREEK SMALL LETTER ARCHAIC KOPPA
      #x03DA	;GREEK LETTER STIGMA
      #x03DB	;GREEK SMALL LETTER STIGMA
      #x03DC	;GREEK LETTER DIGAMMA
      #x03DD	;GREEK SMALL LETTER DIGAMMA
      #x03DE	;GREEK LETTER KOPPA
      #x03DF	;GREEK SMALL LETTER KOPPA
      #x03E0	;GREEK LETTER SAMPI
      #x03E1	;GREEK SMALL LETTER SAMPI
      #x03E2	;COPTIC CAPITAL LETTER SHEI
      #x03E3	;COPTIC SMALL LETTER SHEI
      #x03E4	;COPTIC CAPITAL LETTER FEI
      #x03E5	;COPTIC SMALL LETTER FEI
      #x03E6	;COPTIC CAPITAL LETTER KHEI
      #x03E7	;COPTIC SMALL LETTER KHEI
      #x03E8	;COPTIC CAPITAL LETTER HORI
      #x03E9	;COPTIC SMALL LETTER HORI
      #x03EA	;COPTIC CAPITAL LETTER GANGIA
      #x03EB	;COPTIC SMALL LETTER GANGIA
      #x03EC	;COPTIC CAPITAL LETTER SHIMA
      #x03ED	;COPTIC SMALL LETTER SHIMA
      #x03EE	;COPTIC CAPITAL LETTER DEI
      #x03EF	;COPTIC SMALL LETTER DEI
      #x03F0	;GREEK KAPPA SYMBOL
      #x03F1	;GREEK RHO SYMBOL
      #x03F2	;GREEK LUNATE SIGMA SYMBOL
      #x03F3	;GREEK LETTER YOT
      #x03F4	;GREEK CAPITAL THETA SYMBOL
      #x03F5	;GREEK LUNATE EPSILON SYMBOL
      #x03F7	;GREEK CAPITAL LETTER SHO
      #x03F8	;GREEK SMALL LETTER SHO
      #x03F9	;GREEK CAPITAL LUNATE SIGMA SYMBOL
      #x03FA	;GREEK CAPITAL LETTER SAN
      #x03FB	;GREEK SMALL LETTER SAN
      #x0400	;CYRILLIC CAPITAL LETTER IE WITH GRAVE
      #x0401	;CYRILLIC CAPITAL LETTER IO
      #x0402	;CYRILLIC CAPITAL LETTER DJE
      #x0403	;CYRILLIC CAPITAL LETTER GJE
      #x0404	;CYRILLIC CAPITAL LETTER UKRAINIAN IE
      #x0405	;CYRILLIC CAPITAL LETTER DZE
      #x0406	;CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
      #x0407	;CYRILLIC CAPITAL LETTER YI
      #x0408	;CYRILLIC CAPITAL LETTER JE
      #x0409	;CYRILLIC CAPITAL LETTER LJE
      #x040A	;CYRILLIC CAPITAL LETTER NJE
      #x040B	;CYRILLIC CAPITAL LETTER TSHE
      #x040C	;CYRILLIC CAPITAL LETTER KJE
      #x040D	;CYRILLIC CAPITAL LETTER I WITH GRAVE
      #x040E	;CYRILLIC CAPITAL LETTER SHORT U
      #x040F	;CYRILLIC CAPITAL LETTER DZHE
      #x0410	;CYRILLIC CAPITAL LETTER A
      #x0411	;CYRILLIC CAPITAL LETTER BE
      #x0412	;CYRILLIC CAPITAL LETTER VE
      #x0413	;CYRILLIC CAPITAL LETTER GHE
      #x0414	;CYRILLIC CAPITAL LETTER DE
      #x0415	;CYRILLIC CAPITAL LETTER IE
      #x0416	;CYRILLIC CAPITAL LETTER ZHE
      #x0417	;CYRILLIC CAPITAL LETTER ZE
      #x0418	;CYRILLIC CAPITAL LETTER I
      #x0419	;CYRILLIC CAPITAL LETTER SHORT I
      #x041A	;CYRILLIC CAPITAL LETTER KA
      #x041B	;CYRILLIC CAPITAL LETTER EL
      #x041C	;CYRILLIC CAPITAL LETTER EM
      #x041D	;CYRILLIC CAPITAL LETTER EN
      #x041E	;CYRILLIC CAPITAL LETTER O
      #x041F	;CYRILLIC CAPITAL LETTER PE
      #x0420	;CYRILLIC CAPITAL LETTER ER
      #x0421	;CYRILLIC CAPITAL LETTER ES
      #x0422	;CYRILLIC CAPITAL LETTER TE
      #x0423	;CYRILLIC CAPITAL LETTER U
      #x0424	;CYRILLIC CAPITAL LETTER EF
      #x0425	;CYRILLIC CAPITAL LETTER HA
      #x0426	;CYRILLIC CAPITAL LETTER TSE
      #x0427	;CYRILLIC CAPITAL LETTER CHE
      #x0428	;CYRILLIC CAPITAL LETTER SHA
      #x0429	;CYRILLIC CAPITAL LETTER SHCHA
      #x042A	;CYRILLIC CAPITAL LETTER HARD SIGN
      #x042B	;CYRILLIC CAPITAL LETTER YERU
      #x042C	;CYRILLIC CAPITAL LETTER SOFT SIGN
      #x042D	;CYRILLIC CAPITAL LETTER E
      #x042E	;CYRILLIC CAPITAL LETTER YU
      #x042F	;CYRILLIC CAPITAL LETTER YA
      #x0430	;CYRILLIC SMALL LETTER A
      #x0431	;CYRILLIC SMALL LETTER BE
      #x0432	;CYRILLIC SMALL LETTER VE
      #x0433	;CYRILLIC SMALL LETTER GHE
      #x0434	;CYRILLIC SMALL LETTER DE
      #x0435	;CYRILLIC SMALL LETTER IE
      #x0436	;CYRILLIC SMALL LETTER ZHE
      #x0437	;CYRILLIC SMALL LETTER ZE
      #x0438	;CYRILLIC SMALL LETTER I
      #x0439	;CYRILLIC SMALL LETTER SHORT I
      #x043A	;CYRILLIC SMALL LETTER KA
      #x043B	;CYRILLIC SMALL LETTER EL
      #x043C	;CYRILLIC SMALL LETTER EM
      #x043D	;CYRILLIC SMALL LETTER EN
      #x043E	;CYRILLIC SMALL LETTER O
      #x043F	;CYRILLIC SMALL LETTER PE
      #x0440	;CYRILLIC SMALL LETTER ER
      #x0441	;CYRILLIC SMALL LETTER ES
      #x0442	;CYRILLIC SMALL LETTER TE
      #x0443	;CYRILLIC SMALL LETTER U
      #x0444	;CYRILLIC SMALL LETTER EF
      #x0445	;CYRILLIC SMALL LETTER HA
      #x0446	;CYRILLIC SMALL LETTER TSE
      #x0447	;CYRILLIC SMALL LETTER CHE
      #x0448	;CYRILLIC SMALL LETTER SHA
      #x0449	;CYRILLIC SMALL LETTER SHCHA
      #x044A	;CYRILLIC SMALL LETTER HARD SIGN
      #x044B	;CYRILLIC SMALL LETTER YERU
      #x044C	;CYRILLIC SMALL LETTER SOFT SIGN
      #x044D	;CYRILLIC SMALL LETTER E
      #x044E	;CYRILLIC SMALL LETTER YU
      #x044F	;CYRILLIC SMALL LETTER YA
      #x0450	;CYRILLIC SMALL LETTER IE WITH GRAVE
      #x0451	;CYRILLIC SMALL LETTER IO
      #x0452	;CYRILLIC SMALL LETTER DJE
      #x0453	;CYRILLIC SMALL LETTER GJE
      #x0454	;CYRILLIC SMALL LETTER UKRAINIAN IE
      #x0455	;CYRILLIC SMALL LETTER DZE
      #x0456	;CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
      #x0457	;CYRILLIC SMALL LETTER YI
      #x0458	;CYRILLIC SMALL LETTER JE
      #x0459	;CYRILLIC SMALL LETTER LJE
      #x045A	;CYRILLIC SMALL LETTER NJE
      #x045B	;CYRILLIC SMALL LETTER TSHE
      #x045C	;CYRILLIC SMALL LETTER KJE
      #x045D	;CYRILLIC SMALL LETTER I WITH GRAVE
      #x045E	;CYRILLIC SMALL LETTER SHORT U
      #x045F	;CYRILLIC SMALL LETTER DZHE
      #x0460	;CYRILLIC CAPITAL LETTER OMEGA
      #x0461	;CYRILLIC SMALL LETTER OMEGA
      #x0462	;CYRILLIC CAPITAL LETTER YAT
      #x0463	;CYRILLIC SMALL LETTER YAT
      #x0464	;CYRILLIC CAPITAL LETTER IOTIFIED E
      #x0465	;CYRILLIC SMALL LETTER IOTIFIED E
      #x0466	;CYRILLIC CAPITAL LETTER LITTLE YUS
      #x0467	;CYRILLIC SMALL LETTER LITTLE YUS
      #x0468	;CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
      #x0469	;CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
      #x046A	;CYRILLIC CAPITAL LETTER BIG YUS
      #x046B	;CYRILLIC SMALL LETTER BIG YUS
      #x046C	;CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
      #x046D	;CYRILLIC SMALL LETTER IOTIFIED BIG YUS
      #x046E	;CYRILLIC CAPITAL LETTER KSI
      #x046F	;CYRILLIC SMALL LETTER KSI
      #x0470	;CYRILLIC CAPITAL LETTER PSI
      #x0471	;CYRILLIC SMALL LETTER PSI
      #x0472	;CYRILLIC CAPITAL LETTER FITA
      #x0473	;CYRILLIC SMALL LETTER FITA
      #x0474	;CYRILLIC CAPITAL LETTER IZHITSA
      #x0475	;CYRILLIC SMALL LETTER IZHITSA
      #x0476	;CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
      #x0477	;CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
      #x0478	;CYRILLIC CAPITAL LETTER UK
      #x0479	;CYRILLIC SMALL LETTER UK
      #x047A	;CYRILLIC CAPITAL LETTER ROUND OMEGA
      #x047B	;CYRILLIC SMALL LETTER ROUND OMEGA
      #x047C	;CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
      #x047D	;CYRILLIC SMALL LETTER OMEGA WITH TITLO
      #x047E	;CYRILLIC CAPITAL LETTER OT
      #x047F	;CYRILLIC SMALL LETTER OT
      #x0480	;CYRILLIC CAPITAL LETTER KOPPA
      #x0481	;CYRILLIC SMALL LETTER KOPPA
      #x048A	;CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
      #x048B	;CYRILLIC SMALL LETTER SHORT I WITH TAIL
      #x048C	;CYRILLIC CAPITAL LETTER SEMISOFT SIGN
      #x048D	;CYRILLIC SMALL LETTER SEMISOFT SIGN
      #x048E	;CYRILLIC CAPITAL LETTER ER WITH TICK
      #x048F	;CYRILLIC SMALL LETTER ER WITH TICK
      #x0490	;CYRILLIC CAPITAL LETTER GHE WITH UPTURN
      #x0491	;CYRILLIC SMALL LETTER GHE WITH UPTURN
      #x0492	;CYRILLIC CAPITAL LETTER GHE WITH STROKE
      #x0493	;CYRILLIC SMALL LETTER GHE WITH STROKE
      #x0494	;CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
      #x0495	;CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
      #x0496	;CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
      #x0497	;CYRILLIC SMALL LETTER ZHE WITH DESCENDER
      #x0498	;CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
      #x0499	;CYRILLIC SMALL LETTER ZE WITH DESCENDER
      #x049A	;CYRILLIC CAPITAL LETTER KA WITH DESCENDER
      #x049B	;CYRILLIC SMALL LETTER KA WITH DESCENDER
      #x049C	;CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
      #x049D	;CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
      #x049E	;CYRILLIC CAPITAL LETTER KA WITH STROKE
      #x049F	;CYRILLIC SMALL LETTER KA WITH STROKE
      #x04A0	;CYRILLIC CAPITAL LETTER BASHKIR KA
      #x04A1	;CYRILLIC SMALL LETTER BASHKIR KA
      #x04A2	;CYRILLIC CAPITAL LETTER EN WITH DESCENDER
      #x04A3	;CYRILLIC SMALL LETTER EN WITH DESCENDER
      #x04A4	;CYRILLIC CAPITAL LIGATURE EN GHE
      #x04A5	;CYRILLIC SMALL LIGATURE EN GHE
      #x04A6	;CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
      #x04A7	;CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
      #x04A8	;CYRILLIC CAPITAL LETTER ABKHASIAN HA
      #x04A9	;CYRILLIC SMALL LETTER ABKHASIAN HA
      #x04AA	;CYRILLIC CAPITAL LETTER ES WITH DESCENDER
      #x04AB	;CYRILLIC SMALL LETTER ES WITH DESCENDER
      #x04AC	;CYRILLIC CAPITAL LETTER TE WITH DESCENDER
      #x04AD	;CYRILLIC SMALL LETTER TE WITH DESCENDER
      #x04AE	;CYRILLIC CAPITAL LETTER STRAIGHT U
      #x04AF	;CYRILLIC SMALL LETTER STRAIGHT U
      #x04B0	;CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
      #x04B1	;CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
      #x04B2	;CYRILLIC CAPITAL LETTER HA WITH DESCENDER
      #x04B3	;CYRILLIC SMALL LETTER HA WITH DESCENDER
      #x04B4	;CYRILLIC CAPITAL LIGATURE TE TSE
      #x04B5	;CYRILLIC SMALL LIGATURE TE TSE
      #x04B6	;CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
      #x04B7	;CYRILLIC SMALL LETTER CHE WITH DESCENDER
      #x04B8	;CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
      #x04B9	;CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
      #x04BA	;CYRILLIC CAPITAL LETTER SHHA
      #x04BB	;CYRILLIC SMALL LETTER SHHA
      #x04BC	;CYRILLIC CAPITAL LETTER ABKHASIAN CHE
      #x04BD	;CYRILLIC SMALL LETTER ABKHASIAN CHE
      #x04BE	;CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
      #x04BF	;CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
      #x04C0	;CYRILLIC LETTER PALOCHKA
      #x04C1	;CYRILLIC CAPITAL LETTER ZHE WITH BREVE
      #x04C2	;CYRILLIC SMALL LETTER ZHE WITH BREVE
      #x04C3	;CYRILLIC CAPITAL LETTER KA WITH HOOK
      #x04C4	;CYRILLIC SMALL LETTER KA WITH HOOK
      #x04C5	;CYRILLIC CAPITAL LETTER EL WITH TAIL
      #x04C6	;CYRILLIC SMALL LETTER EL WITH TAIL
      #x04C7	;CYRILLIC CAPITAL LETTER EN WITH HOOK
      #x04C8	;CYRILLIC SMALL LETTER EN WITH HOOK
      #x04C9	;CYRILLIC CAPITAL LETTER EN WITH TAIL
      #x04CA	;CYRILLIC SMALL LETTER EN WITH TAIL
      #x04CB	;CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
      #x04CC	;CYRILLIC SMALL LETTER KHAKASSIAN CHE
      #x04CD	;CYRILLIC CAPITAL LETTER EM WITH TAIL
      #x04CE	;CYRILLIC SMALL LETTER EM WITH TAIL
      #x04D0	;CYRILLIC CAPITAL LETTER A WITH BREVE
      #x04D1	;CYRILLIC SMALL LETTER A WITH BREVE
      #x04D2	;CYRILLIC CAPITAL LETTER A WITH DIAERESIS
      #x04D3	;CYRILLIC SMALL LETTER A WITH DIAERESIS
      #x04D4	;CYRILLIC CAPITAL LIGATURE A IE
      #x04D5	;CYRILLIC SMALL LIGATURE A IE
      #x04D6	;CYRILLIC CAPITAL LETTER IE WITH BREVE
      #x04D7	;CYRILLIC SMALL LETTER IE WITH BREVE
      #x04D8	;CYRILLIC CAPITAL LETTER SCHWA
      #x04D9	;CYRILLIC SMALL LETTER SCHWA
      #x04DA	;CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
      #x04DB	;CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
      #x04DC	;CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
      #x04DD	;CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
      #x04DE	;CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
      #x04DF	;CYRILLIC SMALL LETTER ZE WITH DIAERESIS
      #x04E0	;CYRILLIC CAPITAL LETTER ABKHASIAN DZE
      #x04E1	;CYRILLIC SMALL LETTER ABKHASIAN DZE
      #x04E2	;CYRILLIC CAPITAL LETTER I WITH MACRON
      #x04E3	;CYRILLIC SMALL LETTER I WITH MACRON
      #x04E4	;CYRILLIC CAPITAL LETTER I WITH DIAERESIS
      #x04E5	;CYRILLIC SMALL LETTER I WITH DIAERESIS
      #x04E6	;CYRILLIC CAPITAL LETTER O WITH DIAERESIS
      #x04E7	;CYRILLIC SMALL LETTER O WITH DIAERESIS
      #x04E8	;CYRILLIC CAPITAL LETTER BARRED O
      #x04E9	;CYRILLIC SMALL LETTER BARRED O
      #x04EA	;CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
      #x04EB	;CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
      #x04EC	;CYRILLIC CAPITAL LETTER E WITH DIAERESIS
      #x04ED	;CYRILLIC SMALL LETTER E WITH DIAERESIS
      #x04EE	;CYRILLIC CAPITAL LETTER U WITH MACRON
      #x04EF	;CYRILLIC SMALL LETTER U WITH MACRON
      #x04F0	;CYRILLIC CAPITAL LETTER U WITH DIAERESIS
      #x04F1	;CYRILLIC SMALL LETTER U WITH DIAERESIS
      #x04F2	;CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
      #x04F3	;CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
      #x04F4	;CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
      #x04F5	;CYRILLIC SMALL LETTER CHE WITH DIAERESIS
      #x04F8	;CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
      #x04F9	;CYRILLIC SMALL LETTER YERU WITH DIAERESIS
      #x0500	;CYRILLIC CAPITAL LETTER KOMI DE
      #x0501	;CYRILLIC SMALL LETTER KOMI DE
      #x0502	;CYRILLIC CAPITAL LETTER KOMI DJE
      #x0503	;CYRILLIC SMALL LETTER KOMI DJE
      #x0504	;CYRILLIC CAPITAL LETTER KOMI ZJE
      #x0505	;CYRILLIC SMALL LETTER KOMI ZJE
      #x0506	;CYRILLIC CAPITAL LETTER KOMI DZJE
      #x0507	;CYRILLIC SMALL LETTER KOMI DZJE
      #x0508	;CYRILLIC CAPITAL LETTER KOMI LJE
      #x0509	;CYRILLIC SMALL LETTER KOMI LJE
      #x050A	;CYRILLIC CAPITAL LETTER KOMI NJE
      #x050B	;CYRILLIC SMALL LETTER KOMI NJE
      #x050C	;CYRILLIC CAPITAL LETTER KOMI SJE
      #x050D	;CYRILLIC SMALL LETTER KOMI SJE
      #x050E	;CYRILLIC CAPITAL LETTER KOMI TJE
      #x050F	;CYRILLIC SMALL LETTER KOMI TJE
      #x0531	;ARMENIAN CAPITAL LETTER AYB
      #x0532	;ARMENIAN CAPITAL LETTER BEN
      #x0533	;ARMENIAN CAPITAL LETTER GIM
      #x0534	;ARMENIAN CAPITAL LETTER DA
      #x0535	;ARMENIAN CAPITAL LETTER ECH
      #x0536	;ARMENIAN CAPITAL LETTER ZA
      #x0537	;ARMENIAN CAPITAL LETTER EH
      #x0538	;ARMENIAN CAPITAL LETTER ET
      #x0539	;ARMENIAN CAPITAL LETTER TO
      #x053A	;ARMENIAN CAPITAL LETTER ZHE
      #x053B	;ARMENIAN CAPITAL LETTER INI
      #x053C	;ARMENIAN CAPITAL LETTER LIWN
      #x053D	;ARMENIAN CAPITAL LETTER XEH
      #x053E	;ARMENIAN CAPITAL LETTER CA
      #x053F	;ARMENIAN CAPITAL LETTER KEN
      #x0540	;ARMENIAN CAPITAL LETTER HO
      #x0541	;ARMENIAN CAPITAL LETTER JA
      #x0542	;ARMENIAN CAPITAL LETTER GHAD
      #x0543	;ARMENIAN CAPITAL LETTER CHEH
      #x0544	;ARMENIAN CAPITAL LETTER MEN
      #x0545	;ARMENIAN CAPITAL LETTER YI
      #x0546	;ARMENIAN CAPITAL LETTER NOW
      #x0547	;ARMENIAN CAPITAL LETTER SHA
      #x0548	;ARMENIAN CAPITAL LETTER VO
      #x0549	;ARMENIAN CAPITAL LETTER CHA
      #x054A	;ARMENIAN CAPITAL LETTER PEH
      #x054B	;ARMENIAN CAPITAL LETTER JHEH
      #x054C	;ARMENIAN CAPITAL LETTER RA
      #x054D	;ARMENIAN CAPITAL LETTER SEH
      #x054E	;ARMENIAN CAPITAL LETTER VEW
      #x054F	;ARMENIAN CAPITAL LETTER TIWN
      #x0550	;ARMENIAN CAPITAL LETTER REH
      #x0551	;ARMENIAN CAPITAL LETTER CO
      #x0552	;ARMENIAN CAPITAL LETTER YIWN
      #x0553	;ARMENIAN CAPITAL LETTER PIWR
      #x0554	;ARMENIAN CAPITAL LETTER KEH
      #x0555	;ARMENIAN CAPITAL LETTER OH
      #x0556	;ARMENIAN CAPITAL LETTER FEH
      #x0559	;ARMENIAN MODIFIER LETTER LEFT HALF RING
      #x0561	;ARMENIAN SMALL LETTER AYB
      #x0562	;ARMENIAN SMALL LETTER BEN
      #x0563	;ARMENIAN SMALL LETTER GIM
      #x0564	;ARMENIAN SMALL LETTER DA
      #x0565	;ARMENIAN SMALL LETTER ECH
      #x0566	;ARMENIAN SMALL LETTER ZA
      #x0567	;ARMENIAN SMALL LETTER EH
      #x0568	;ARMENIAN SMALL LETTER ET
      #x0569	;ARMENIAN SMALL LETTER TO
      #x056A	;ARMENIAN SMALL LETTER ZHE
      #x056B	;ARMENIAN SMALL LETTER INI
      #x056C	;ARMENIAN SMALL LETTER LIWN
      #x056D	;ARMENIAN SMALL LETTER XEH
      #x056E	;ARMENIAN SMALL LETTER CA
      #x056F	;ARMENIAN SMALL LETTER KEN
      #x0570	;ARMENIAN SMALL LETTER HO
      #x0571	;ARMENIAN SMALL LETTER JA
      #x0572	;ARMENIAN SMALL LETTER GHAD
      #x0573	;ARMENIAN SMALL LETTER CHEH
      #x0574	;ARMENIAN SMALL LETTER MEN
      #x0575	;ARMENIAN SMALL LETTER YI
      #x0576	;ARMENIAN SMALL LETTER NOW
      #x0577	;ARMENIAN SMALL LETTER SHA
      #x0578	;ARMENIAN SMALL LETTER VO
      #x0579	;ARMENIAN SMALL LETTER CHA
      #x057A	;ARMENIAN SMALL LETTER PEH
      #x057B	;ARMENIAN SMALL LETTER JHEH
      #x057C	;ARMENIAN SMALL LETTER RA
      #x057D	;ARMENIAN SMALL LETTER SEH
      #x057E	;ARMENIAN SMALL LETTER VEW
      #x057F	;ARMENIAN SMALL LETTER TIWN
      #x0580	;ARMENIAN SMALL LETTER REH
      #x0581	;ARMENIAN SMALL LETTER CO
      #x0582	;ARMENIAN SMALL LETTER YIWN
      #x0583	;ARMENIAN SMALL LETTER PIWR
      #x0584	;ARMENIAN SMALL LETTER KEH
      #x0585	;ARMENIAN SMALL LETTER OH
      #x0586	;ARMENIAN SMALL LETTER FEH
      #x0587	;ARMENIAN SMALL LIGATURE ECH YIWN
      #x05D0	;HEBREW LETTER ALEF
      #x05D1	;HEBREW LETTER BET
      #x05D2	;HEBREW LETTER GIMEL
      #x05D3	;HEBREW LETTER DALET
      #x05D4	;HEBREW LETTER HE
      #x05D5	;HEBREW LETTER VAV
      #x05D6	;HEBREW LETTER ZAYIN
      #x05D7	;HEBREW LETTER HET
      #x05D8	;HEBREW LETTER TET
      #x05D9	;HEBREW LETTER YOD
      #x05DA	;HEBREW LETTER FINAL KAF
      #x05DB	;HEBREW LETTER KAF
      #x05DC	;HEBREW LETTER LAMED
      #x05DD	;HEBREW LETTER FINAL MEM
      #x05DE	;HEBREW LETTER MEM
      #x05DF	;HEBREW LETTER FINAL NUN
      #x05E0	;HEBREW LETTER NUN
      #x05E1	;HEBREW LETTER SAMEKH
      #x05E2	;HEBREW LETTER AYIN
      #x05E3	;HEBREW LETTER FINAL PE
      #x05E4	;HEBREW LETTER PE
      #x05E5	;HEBREW LETTER FINAL TSADI
      #x05E6	;HEBREW LETTER TSADI
      #x05E7	;HEBREW LETTER QOF
      #x05E8	;HEBREW LETTER RESH
      #x05E9	;HEBREW LETTER SHIN
      #x05EA	;HEBREW LETTER TAV
      #x05F0	;HEBREW LIGATURE YIDDISH DOUBLE VAV
      #x05F1	;HEBREW LIGATURE YIDDISH VAV YOD
      #x05F2	;HEBREW LIGATURE YIDDISH DOUBLE YOD
      #x0621	;ARABIC LETTER HAMZA
      #x0622	;ARABIC LETTER ALEF WITH MADDA ABOVE
      #x0623	;ARABIC LETTER ALEF WITH HAMZA ABOVE
      #x0624	;ARABIC LETTER WAW WITH HAMZA ABOVE
      #x0625	;ARABIC LETTER ALEF WITH HAMZA BELOW
      #x0626	;ARABIC LETTER YEH WITH HAMZA ABOVE
      #x0627	;ARABIC LETTER ALEF
      #x0628	;ARABIC LETTER BEH
      #x0629	;ARABIC LETTER TEH MARBUTA
      #x062A	;ARABIC LETTER TEH
      #x062B	;ARABIC LETTER THEH
      #x062C	;ARABIC LETTER JEEM
      #x062D	;ARABIC LETTER HAH
      #x062E	;ARABIC LETTER KHAH
      #x062F	;ARABIC LETTER DAL
      #x0630	;ARABIC LETTER THAL
      #x0631	;ARABIC LETTER REH
      #x0632	;ARABIC LETTER ZAIN
      #x0633	;ARABIC LETTER SEEN
      #x0634	;ARABIC LETTER SHEEN
      #x0635	;ARABIC LETTER SAD
      #x0636	;ARABIC LETTER DAD
      #x0637	;ARABIC LETTER TAH
      #x0638	;ARABIC LETTER ZAH
      #x0639	;ARABIC LETTER AIN
      #x063A	;ARABIC LETTER GHAIN
      #x0640	;ARABIC TATWEEL
      #x0641	;ARABIC LETTER FEH
      #x0642	;ARABIC LETTER QAF
      #x0643	;ARABIC LETTER KAF
      #x0644	;ARABIC LETTER LAM
      #x0645	;ARABIC LETTER MEEM
      #x0646	;ARABIC LETTER NOON
      #x0647	;ARABIC LETTER HEH
      #x0648	;ARABIC LETTER WAW
      #x0649	;ARABIC LETTER ALEF MAKSURA
      #x064A	;ARABIC LETTER YEH
      #x066E	;ARABIC LETTER DOTLESS BEH
      #x066F	;ARABIC LETTER DOTLESS QAF
      #x0671	;ARABIC LETTER ALEF WASLA
      #x0672	;ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE
      #x0673	;ARABIC LETTER ALEF WITH WAVY HAMZA BELOW
      #x0674	;ARABIC LETTER HIGH HAMZA
      #x0675	;ARABIC LETTER HIGH HAMZA ALEF
      #x0676	;ARABIC LETTER HIGH HAMZA WAW
      #x0677	;ARABIC LETTER U WITH HAMZA ABOVE
      #x0678	;ARABIC LETTER HIGH HAMZA YEH
      #x0679	;ARABIC LETTER TTEH
      #x067A	;ARABIC LETTER TTEHEH
      #x067B	;ARABIC LETTER BEEH
      #x067C	;ARABIC LETTER TEH WITH RING
      #x067D	;ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS
      #x067E	;ARABIC LETTER PEH
      #x067F	;ARABIC LETTER TEHEH
      #x0680	;ARABIC LETTER BEHEH
      #x0681	;ARABIC LETTER HAH WITH HAMZA ABOVE
      #x0682	;ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE
      #x0683	;ARABIC LETTER NYEH
      #x0684	;ARABIC LETTER DYEH
      #x0685	;ARABIC LETTER HAH WITH THREE DOTS ABOVE
      #x0686	;ARABIC LETTER TCHEH
      #x0687	;ARABIC LETTER TCHEHEH
      #x0688	;ARABIC LETTER DDAL
      #x0689	;ARABIC LETTER DAL WITH RING
      #x068A	;ARABIC LETTER DAL WITH DOT BELOW
      #x068B	;ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH
      #x068C	;ARABIC LETTER DAHAL
      #x068D	;ARABIC LETTER DDAHAL
      #x068E	;ARABIC LETTER DUL
      #x068F	;ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS
      #x0690	;ARABIC LETTER DAL WITH FOUR DOTS ABOVE
      #x0691	;ARABIC LETTER RREH
      #x0692	;ARABIC LETTER REH WITH SMALL V
      #x0693	;ARABIC LETTER REH WITH RING
      #x0694	;ARABIC LETTER REH WITH DOT BELOW
      #x0695	;ARABIC LETTER REH WITH SMALL V BELOW
      #x0696	;ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE
      #x0697	;ARABIC LETTER REH WITH TWO DOTS ABOVE
      #x0698	;ARABIC LETTER JEH
      #x0699	;ARABIC LETTER REH WITH FOUR DOTS ABOVE
      #x069A	;ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE
      #x069B	;ARABIC LETTER SEEN WITH THREE DOTS BELOW
      #x069C	;ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE
      #x069D	;ARABIC LETTER SAD WITH TWO DOTS BELOW
      #x069E	;ARABIC LETTER SAD WITH THREE DOTS ABOVE
      #x069F	;ARABIC LETTER TAH WITH THREE DOTS ABOVE
      #x06A0	;ARABIC LETTER AIN WITH THREE DOTS ABOVE
      #x06A1	;ARABIC LETTER DOTLESS FEH
      #x06A2	;ARABIC LETTER FEH WITH DOT MOVED BELOW
      #x06A3	;ARABIC LETTER FEH WITH DOT BELOW
      #x06A4	;ARABIC LETTER VEH
      #x06A5	;ARABIC LETTER FEH WITH THREE DOTS BELOW
      #x06A6	;ARABIC LETTER PEHEH
      #x06A7	;ARABIC LETTER QAF WITH DOT ABOVE
      #x06A8	;ARABIC LETTER QAF WITH THREE DOTS ABOVE
      #x06A9	;ARABIC LETTER KEHEH
      #x06AA	;ARABIC LETTER SWASH KAF
      #x06AB	;ARABIC LETTER KAF WITH RING
      #x06AC	;ARABIC LETTER KAF WITH DOT ABOVE
      #x06AD	;ARABIC LETTER NG
      #x06AE	;ARABIC LETTER KAF WITH THREE DOTS BELOW
      #x06AF	;ARABIC LETTER GAF
      #x06B0	;ARABIC LETTER GAF WITH RING
      #x06B1	;ARABIC LETTER NGOEH
      #x06B2	;ARABIC LETTER GAF WITH TWO DOTS BELOW
      #x06B3	;ARABIC LETTER GUEH
      #x06B4	;ARABIC LETTER GAF WITH THREE DOTS ABOVE
      #x06B5	;ARABIC LETTER LAM WITH SMALL V
      #x06B6	;ARABIC LETTER LAM WITH DOT ABOVE
      #x06B7	;ARABIC LETTER LAM WITH THREE DOTS ABOVE
      #x06B8	;ARABIC LETTER LAM WITH THREE DOTS BELOW
      #x06B9	;ARABIC LETTER NOON WITH DOT BELOW
      #x06BA	;ARABIC LETTER NOON GHUNNA
      #x06BB	;ARABIC LETTER RNOON
      #x06BC	;ARABIC LETTER NOON WITH RING
      #x06BD	;ARABIC LETTER NOON WITH THREE DOTS ABOVE
      #x06BE	;ARABIC LETTER HEH DOACHASHMEE
      #x06BF	;ARABIC LETTER TCHEH WITH DOT ABOVE
      #x06C0	;ARABIC LETTER HEH WITH YEH ABOVE
      #x06C1	;ARABIC LETTER HEH GOAL
      #x06C2	;ARABIC LETTER HEH GOAL WITH HAMZA ABOVE
      #x06C3	;ARABIC LETTER TEH MARBUTA GOAL
      #x06C4	;ARABIC LETTER WAW WITH RING
      #x06C5	;ARABIC LETTER KIRGHIZ OE
      #x06C6	;ARABIC LETTER OE
      #x06C7	;ARABIC LETTER U
      #x06C8	;ARABIC LETTER YU
      #x06C9	;ARABIC LETTER KIRGHIZ YU
      #x06CA	;ARABIC LETTER WAW WITH TWO DOTS ABOVE
      #x06CB	;ARABIC LETTER VE
      #x06CC	;ARABIC LETTER FARSI YEH
      #x06CD	;ARABIC LETTER YEH WITH TAIL
      #x06CE	;ARABIC LETTER YEH WITH SMALL V
      #x06CF	;ARABIC LETTER WAW WITH DOT ABOVE
      #x06D0	;ARABIC LETTER E
      #x06D1	;ARABIC LETTER YEH WITH THREE DOTS BELOW
      #x06D2	;ARABIC LETTER YEH BARREE
      #x06D3	;ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
      #x06D5	;ARABIC LETTER AE
      #x06E5	;ARABIC SMALL WAW
      #x06E6	;ARABIC SMALL YEH
      #x06EE	;ARABIC LETTER DAL WITH INVERTED V
      #x06EF	;ARABIC LETTER REH WITH INVERTED V
      #x06FA	;ARABIC LETTER SHEEN WITH DOT BELOW
      #x06FB	;ARABIC LETTER DAD WITH DOT BELOW
      #x06FC	;ARABIC LETTER GHAIN WITH DOT BELOW
      #x06FF	;ARABIC LETTER HEH WITH INVERTED V
      #x0710	;SYRIAC LETTER ALAPH
      #x0712	;SYRIAC LETTER BETH
      #x0713	;SYRIAC LETTER GAMAL
      #x0714	;SYRIAC LETTER GAMAL GARSHUNI
      #x0715	;SYRIAC LETTER DALATH
      #x0716	;SYRIAC LETTER DOTLESS DALATH RISH
      #x0717	;SYRIAC LETTER HE
      #x0718	;SYRIAC LETTER WAW
      #x0719	;SYRIAC LETTER ZAIN
      #x071A	;SYRIAC LETTER HETH
      #x071B	;SYRIAC LETTER TETH
      #x071C	;SYRIAC LETTER TETH GARSHUNI
      #x071D	;SYRIAC LETTER YUDH
      #x071E	;SYRIAC LETTER YUDH HE
      #x071F	;SYRIAC LETTER KAPH
      #x0720	;SYRIAC LETTER LAMADH
      #x0721	;SYRIAC LETTER MIM
      #x0722	;SYRIAC LETTER NUN
      #x0723	;SYRIAC LETTER SEMKATH
      #x0724	;SYRIAC LETTER FINAL SEMKATH
      #x0725	;SYRIAC LETTER E
      #x0726	;SYRIAC LETTER PE
      #x0727	;SYRIAC LETTER REVERSED PE
      #x0728	;SYRIAC LETTER SADHE
      #x0729	;SYRIAC LETTER QAPH
      #x072A	;SYRIAC LETTER RISH
      #x072B	;SYRIAC LETTER SHIN
      #x072C	;SYRIAC LETTER TAW
      #x072D	;SYRIAC LETTER PERSIAN BHETH
      #x072E	;SYRIAC LETTER PERSIAN GHAMAL
      #x072F	;SYRIAC LETTER PERSIAN DHALATH
      #x074D	;SYRIAC LETTER SOGDIAN ZHAIN
      #x074E	;SYRIAC LETTER SOGDIAN KHAPH
      #x074F	;SYRIAC LETTER SOGDIAN FE
      #x0780	;THAANA LETTER HAA
      #x0781	;THAANA LETTER SHAVIYANI
      #x0782	;THAANA LETTER NOONU
      #x0783	;THAANA LETTER RAA
      #x0784	;THAANA LETTER BAA
      #x0785	;THAANA LETTER LHAVIYANI
      #x0786	;THAANA LETTER KAAFU
      #x0787	;THAANA LETTER ALIFU
      #x0788	;THAANA LETTER VAAVU
      #x0789	;THAANA LETTER MEEMU
      #x078A	;THAANA LETTER FAAFU
      #x078B	;THAANA LETTER DHAALU
      #x078C	;THAANA LETTER THAA
      #x078D	;THAANA LETTER LAAMU
      #x078E	;THAANA LETTER GAAFU
      #x078F	;THAANA LETTER GNAVIYANI
      #x0790	;THAANA LETTER SEENU
      #x0791	;THAANA LETTER DAVIYANI
      #x0792	;THAANA LETTER ZAVIYANI
      #x0793	;THAANA LETTER TAVIYANI
      #x0794	;THAANA LETTER YAA
      #x0795	;THAANA LETTER PAVIYANI
      #x0796	;THAANA LETTER JAVIYANI
      #x0797	;THAANA LETTER CHAVIYANI
      #x0798	;THAANA LETTER TTAA
      #x0799	;THAANA LETTER HHAA
      #x079A	;THAANA LETTER KHAA
      #x079B	;THAANA LETTER THAALU
      #x079C	;THAANA LETTER ZAA
      #x079D	;THAANA LETTER SHEENU
      #x079E	;THAANA LETTER SAADHU
      #x079F	;THAANA LETTER DAADHU
      #x07A0	;THAANA LETTER TO
      #x07A1	;THAANA LETTER ZO
      #x07A2	;THAANA LETTER AINU
      #x07A3	;THAANA LETTER GHAINU
      #x07A4	;THAANA LETTER QAAFU
      #x07A5	;THAANA LETTER WAAVU
      #x07B1	;THAANA LETTER NAA
      #x0904	;DEVANAGARI LETTER SHORT A
      #x0905	;DEVANAGARI LETTER A
      #x0906	;DEVANAGARI LETTER AA
      #x0907	;DEVANAGARI LETTER I
      #x0908	;DEVANAGARI LETTER II
      #x0909	;DEVANAGARI LETTER U
      #x090A	;DEVANAGARI LETTER UU
      #x090B	;DEVANAGARI LETTER VOCALIC R
      #x090C	;DEVANAGARI LETTER VOCALIC L
      #x090D	;DEVANAGARI LETTER CANDRA E
      #x090E	;DEVANAGARI LETTER SHORT E
      #x090F	;DEVANAGARI LETTER E
      #x0910	;DEVANAGARI LETTER AI
      #x0911	;DEVANAGARI LETTER CANDRA O
      #x0912	;DEVANAGARI LETTER SHORT O
      #x0913	;DEVANAGARI LETTER O
      #x0914	;DEVANAGARI LETTER AU
      #x0915	;DEVANAGARI LETTER KA
      #x0916	;DEVANAGARI LETTER KHA
      #x0917	;DEVANAGARI LETTER GA
      #x0918	;DEVANAGARI LETTER GHA
      #x0919	;DEVANAGARI LETTER NGA
      #x091A	;DEVANAGARI LETTER CA
      #x091B	;DEVANAGARI LETTER CHA
      #x091C	;DEVANAGARI LETTER JA
      #x091D	;DEVANAGARI LETTER JHA
      #x091E	;DEVANAGARI LETTER NYA
      #x091F	;DEVANAGARI LETTER TTA
      #x0920	;DEVANAGARI LETTER TTHA
      #x0921	;DEVANAGARI LETTER DDA
      #x0922	;DEVANAGARI LETTER DDHA
      #x0923	;DEVANAGARI LETTER NNA
      #x0924	;DEVANAGARI LETTER TA
      #x0925	;DEVANAGARI LETTER THA
      #x0926	;DEVANAGARI LETTER DA
      #x0927	;DEVANAGARI LETTER DHA
      #x0928	;DEVANAGARI LETTER NA
      #x0929	;DEVANAGARI LETTER NNNA
      #x092A	;DEVANAGARI LETTER PA
      #x092B	;DEVANAGARI LETTER PHA
      #x092C	;DEVANAGARI LETTER BA
      #x092D	;DEVANAGARI LETTER BHA
      #x092E	;DEVANAGARI LETTER MA
      #x092F	;DEVANAGARI LETTER YA
      #x0930	;DEVANAGARI LETTER RA
      #x0931	;DEVANAGARI LETTER RRA
      #x0932	;DEVANAGARI LETTER LA
      #x0933	;DEVANAGARI LETTER LLA
      #x0934	;DEVANAGARI LETTER LLLA
      #x0935	;DEVANAGARI LETTER VA
      #x0936	;DEVANAGARI LETTER SHA
      #x0937	;DEVANAGARI LETTER SSA
      #x0938	;DEVANAGARI LETTER SA
      #x0939	;DEVANAGARI LETTER HA
      #x093D	;DEVANAGARI SIGN AVAGRAHA
      #x0950	;DEVANAGARI OM
      #x0958	;DEVANAGARI LETTER QA
      #x0959	;DEVANAGARI LETTER KHHA
      #x095A	;DEVANAGARI LETTER GHHA
      #x095B	;DEVANAGARI LETTER ZA
      #x095C	;DEVANAGARI LETTER DDDHA
      #x095D	;DEVANAGARI LETTER RHA
      #x095E	;DEVANAGARI LETTER FA
      #x095F	;DEVANAGARI LETTER YYA
      #x0960	;DEVANAGARI LETTER VOCALIC RR
      #x0961	;DEVANAGARI LETTER VOCALIC LL
      #x0985	;BENGALI LETTER A
      #x0986	;BENGALI LETTER AA
      #x0987	;BENGALI LETTER I
      #x0988	;BENGALI LETTER II
      #x0989	;BENGALI LETTER U
      #x098A	;BENGALI LETTER UU
      #x098B	;BENGALI LETTER VOCALIC R
      #x098C	;BENGALI LETTER VOCALIC L
      #x098F	;BENGALI LETTER E
      #x0990	;BENGALI LETTER AI
      #x0993	;BENGALI LETTER O
      #x0994	;BENGALI LETTER AU
      #x0995	;BENGALI LETTER KA
      #x0996	;BENGALI LETTER KHA
      #x0997	;BENGALI LETTER GA
      #x0998	;BENGALI LETTER GHA
      #x0999	;BENGALI LETTER NGA
      #x099A	;BENGALI LETTER CA
      #x099B	;BENGALI LETTER CHA
      #x099C	;BENGALI LETTER JA
      #x099D	;BENGALI LETTER JHA
      #x099E	;BENGALI LETTER NYA
      #x099F	;BENGALI LETTER TTA
      #x09A0	;BENGALI LETTER TTHA
      #x09A1	;BENGALI LETTER DDA
      #x09A2	;BENGALI LETTER DDHA
      #x09A3	;BENGALI LETTER NNA
      #x09A4	;BENGALI LETTER TA
      #x09A5	;BENGALI LETTER THA
      #x09A6	;BENGALI LETTER DA
      #x09A7	;BENGALI LETTER DHA
      #x09A8	;BENGALI LETTER NA
      #x09AA	;BENGALI LETTER PA
      #x09AB	;BENGALI LETTER PHA
      #x09AC	;BENGALI LETTER BA
      #x09AD	;BENGALI LETTER BHA
      #x09AE	;BENGALI LETTER MA
      #x09AF	;BENGALI LETTER YA
      #x09B0	;BENGALI LETTER RA
      #x09B2	;BENGALI LETTER LA
      #x09B6	;BENGALI LETTER SHA
      #x09B7	;BENGALI LETTER SSA
      #x09B8	;BENGALI LETTER SA
      #x09B9	;BENGALI LETTER HA
      #x09BD	;BENGALI SIGN AVAGRAHA
      #x09DC	;BENGALI LETTER RRA
      #x09DD	;BENGALI LETTER RHA
      #x09DF	;BENGALI LETTER YYA
      #x09E0	;BENGALI LETTER VOCALIC RR
      #x09E1	;BENGALI LETTER VOCALIC LL
      #x09F0	;BENGALI LETTER RA WITH MIDDLE DIAGONAL
      #x09F1	;BENGALI LETTER RA WITH LOWER DIAGONAL
      #x0A05	;GURMUKHI LETTER A
      #x0A06	;GURMUKHI LETTER AA
      #x0A07	;GURMUKHI LETTER I
      #x0A08	;GURMUKHI LETTER II
      #x0A09	;GURMUKHI LETTER U
      #x0A0A	;GURMUKHI LETTER UU
      #x0A0F	;GURMUKHI LETTER EE
      #x0A10	;GURMUKHI LETTER AI
      #x0A13	;GURMUKHI LETTER OO
      #x0A14	;GURMUKHI LETTER AU
      #x0A15	;GURMUKHI LETTER KA
      #x0A16	;GURMUKHI LETTER KHA
      #x0A17	;GURMUKHI LETTER GA
      #x0A18	;GURMUKHI LETTER GHA
      #x0A19	;GURMUKHI LETTER NGA
      #x0A1A	;GURMUKHI LETTER CA
      #x0A1B	;GURMUKHI LETTER CHA
      #x0A1C	;GURMUKHI LETTER JA
      #x0A1D	;GURMUKHI LETTER JHA
      #x0A1E	;GURMUKHI LETTER NYA
      #x0A1F	;GURMUKHI LETTER TTA
      #x0A20	;GURMUKHI LETTER TTHA
      #x0A21	;GURMUKHI LETTER DDA
      #x0A22	;GURMUKHI LETTER DDHA
      #x0A23	;GURMUKHI LETTER NNA
      #x0A24	;GURMUKHI LETTER TA
      #x0A25	;GURMUKHI LETTER THA
      #x0A26	;GURMUKHI LETTER DA
      #x0A27	;GURMUKHI LETTER DHA
      #x0A28	;GURMUKHI LETTER NA
      #x0A2A	;GURMUKHI LETTER PA
      #x0A2B	;GURMUKHI LETTER PHA
      #x0A2C	;GURMUKHI LETTER BA
      #x0A2D	;GURMUKHI LETTER BHA
      #x0A2E	;GURMUKHI LETTER MA
      #x0A2F	;GURMUKHI LETTER YA
      #x0A30	;GURMUKHI LETTER RA
      #x0A32	;GURMUKHI LETTER LA
      #x0A33	;GURMUKHI LETTER LLA
      #x0A35	;GURMUKHI LETTER VA
      #x0A36	;GURMUKHI LETTER SHA
      #x0A38	;GURMUKHI LETTER SA
      #x0A39	;GURMUKHI LETTER HA
      #x0A59	;GURMUKHI LETTER KHHA
      #x0A5A	;GURMUKHI LETTER GHHA
      #x0A5B	;GURMUKHI LETTER ZA
      #x0A5C	;GURMUKHI LETTER RRA
      #x0A5E	;GURMUKHI LETTER FA
      #x0A72	;GURMUKHI IRI
      #x0A73	;GURMUKHI URA
      #x0A74	;GURMUKHI EK ONKAR
      #x0A85	;GUJARATI LETTER A
      #x0A86	;GUJARATI LETTER AA
      #x0A87	;GUJARATI LETTER I
      #x0A88	;GUJARATI LETTER II
      #x0A89	;GUJARATI LETTER U
      #x0A8A	;GUJARATI LETTER UU
      #x0A8B	;GUJARATI LETTER VOCALIC R
      #x0A8C	;GUJARATI LETTER VOCALIC L
      #x0A8D	;GUJARATI VOWEL CANDRA E
      #x0A8F	;GUJARATI LETTER E
      #x0A90	;GUJARATI LETTER AI
      #x0A91	;GUJARATI VOWEL CANDRA O
      #x0A93	;GUJARATI LETTER O
      #x0A94	;GUJARATI LETTER AU
      #x0A95	;GUJARATI LETTER KA
      #x0A96	;GUJARATI LETTER KHA
      #x0A97	;GUJARATI LETTER GA
      #x0A98	;GUJARATI LETTER GHA
      #x0A99	;GUJARATI LETTER NGA
      #x0A9A	;GUJARATI LETTER CA
      #x0A9B	;GUJARATI LETTER CHA
      #x0A9C	;GUJARATI LETTER JA
      #x0A9D	;GUJARATI LETTER JHA
      #x0A9E	;GUJARATI LETTER NYA
      #x0A9F	;GUJARATI LETTER TTA
      #x0AA0	;GUJARATI LETTER TTHA
      #x0AA1	;GUJARATI LETTER DDA
      #x0AA2	;GUJARATI LETTER DDHA
      #x0AA3	;GUJARATI LETTER NNA
      #x0AA4	;GUJARATI LETTER TA
      #x0AA5	;GUJARATI LETTER THA
      #x0AA6	;GUJARATI LETTER DA
      #x0AA7	;GUJARATI LETTER DHA
      #x0AA8	;GUJARATI LETTER NA
      #x0AAA	;GUJARATI LETTER PA
      #x0AAB	;GUJARATI LETTER PHA
      #x0AAC	;GUJARATI LETTER BA
      #x0AAD	;GUJARATI LETTER BHA
      #x0AAE	;GUJARATI LETTER MA
      #x0AAF	;GUJARATI LETTER YA
      #x0AB0	;GUJARATI LETTER RA
      #x0AB2	;GUJARATI LETTER LA
      #x0AB3	;GUJARATI LETTER LLA
      #x0AB5	;GUJARATI LETTER VA
      #x0AB6	;GUJARATI LETTER SHA
      #x0AB7	;GUJARATI LETTER SSA
      #x0AB8	;GUJARATI LETTER SA
      #x0AB9	;GUJARATI LETTER HA
      #x0ABD	;GUJARATI SIGN AVAGRAHA
      #x0AD0	;GUJARATI OM
      #x0AE0	;GUJARATI LETTER VOCALIC RR
      #x0AE1	;GUJARATI LETTER VOCALIC LL
      #x0B05	;ORIYA LETTER A
      #x0B06	;ORIYA LETTER AA
      #x0B07	;ORIYA LETTER I
      #x0B08	;ORIYA LETTER II
      #x0B09	;ORIYA LETTER U
      #x0B0A	;ORIYA LETTER UU
      #x0B0B	;ORIYA LETTER VOCALIC R
      #x0B0C	;ORIYA LETTER VOCALIC L
      #x0B0F	;ORIYA LETTER E
      #x0B10	;ORIYA LETTER AI
      #x0B13	;ORIYA LETTER O
      #x0B14	;ORIYA LETTER AU
      #x0B15	;ORIYA LETTER KA
      #x0B16	;ORIYA LETTER KHA
      #x0B17	;ORIYA LETTER GA
      #x0B18	;ORIYA LETTER GHA
      #x0B19	;ORIYA LETTER NGA
      #x0B1A	;ORIYA LETTER CA
      #x0B1B	;ORIYA LETTER CHA
      #x0B1C	;ORIYA LETTER JA
      #x0B1D	;ORIYA LETTER JHA
      #x0B1E	;ORIYA LETTER NYA
      #x0B1F	;ORIYA LETTER TTA
      #x0B20	;ORIYA LETTER TTHA
      #x0B21	;ORIYA LETTER DDA
      #x0B22	;ORIYA LETTER DDHA
      #x0B23	;ORIYA LETTER NNA
      #x0B24	;ORIYA LETTER TA
      #x0B25	;ORIYA LETTER THA
      #x0B26	;ORIYA LETTER DA
      #x0B27	;ORIYA LETTER DHA
      #x0B28	;ORIYA LETTER NA
      #x0B2A	;ORIYA LETTER PA
      #x0B2B	;ORIYA LETTER PHA
      #x0B2C	;ORIYA LETTER BA
      #x0B2D	;ORIYA LETTER BHA
      #x0B2E	;ORIYA LETTER MA
      #x0B2F	;ORIYA LETTER YA
      #x0B30	;ORIYA LETTER RA
      #x0B32	;ORIYA LETTER LA
      #x0B33	;ORIYA LETTER LLA
      #x0B35	;ORIYA LETTER VA
      #x0B36	;ORIYA LETTER SHA
      #x0B37	;ORIYA LETTER SSA
      #x0B38	;ORIYA LETTER SA
      #x0B39	;ORIYA LETTER HA
      #x0B3D	;ORIYA SIGN AVAGRAHA
      #x0B5C	;ORIYA LETTER RRA
      #x0B5D	;ORIYA LETTER RHA
      #x0B5F	;ORIYA LETTER YYA
      #x0B60	;ORIYA LETTER VOCALIC RR
      #x0B61	;ORIYA LETTER VOCALIC LL
      #x0B71	;ORIYA LETTER WA
      #x0B83	;TAMIL SIGN VISARGA
      #x0B85	;TAMIL LETTER A
      #x0B86	;TAMIL LETTER AA
      #x0B87	;TAMIL LETTER I
      #x0B88	;TAMIL LETTER II
      #x0B89	;TAMIL LETTER U
      #x0B8A	;TAMIL LETTER UU
      #x0B8E	;TAMIL LETTER E
      #x0B8F	;TAMIL LETTER EE
      #x0B90	;TAMIL LETTER AI
      #x0B92	;TAMIL LETTER O
      #x0B93	;TAMIL LETTER OO
      #x0B94	;TAMIL LETTER AU
      #x0B95	;TAMIL LETTER KA
      #x0B99	;TAMIL LETTER NGA
      #x0B9A	;TAMIL LETTER CA
      #x0B9C	;TAMIL LETTER JA
      #x0B9E	;TAMIL LETTER NYA
      #x0B9F	;TAMIL LETTER TTA
      #x0BA3	;TAMIL LETTER NNA
      #x0BA4	;TAMIL LETTER TA
      #x0BA8	;TAMIL LETTER NA
      #x0BA9	;TAMIL LETTER NNNA
      #x0BAA	;TAMIL LETTER PA
      #x0BAE	;TAMIL LETTER MA
      #x0BAF	;TAMIL LETTER YA
      #x0BB0	;TAMIL LETTER RA
      #x0BB1	;TAMIL LETTER RRA
      #x0BB2	;TAMIL LETTER LA
      #x0BB3	;TAMIL LETTER LLA
      #x0BB4	;TAMIL LETTER LLLA
      #x0BB5	;TAMIL LETTER VA
      #x0BB7	;TAMIL LETTER SSA
      #x0BB8	;TAMIL LETTER SA
      #x0BB9	;TAMIL LETTER HA
      #x0C05	;TELUGU LETTER A
      #x0C06	;TELUGU LETTER AA
      #x0C07	;TELUGU LETTER I
      #x0C08	;TELUGU LETTER II
      #x0C09	;TELUGU LETTER U
      #x0C0A	;TELUGU LETTER UU
      #x0C0B	;TELUGU LETTER VOCALIC R
      #x0C0C	;TELUGU LETTER VOCALIC L
      #x0C0E	;TELUGU LETTER E
      #x0C0F	;TELUGU LETTER EE
      #x0C10	;TELUGU LETTER AI
      #x0C12	;TELUGU LETTER O
      #x0C13	;TELUGU LETTER OO
      #x0C14	;TELUGU LETTER AU
      #x0C15	;TELUGU LETTER KA
      #x0C16	;TELUGU LETTER KHA
      #x0C17	;TELUGU LETTER GA
      #x0C18	;TELUGU LETTER GHA
      #x0C19	;TELUGU LETTER NGA
      #x0C1A	;TELUGU LETTER CA
      #x0C1B	;TELUGU LETTER CHA
      #x0C1C	;TELUGU LETTER JA
      #x0C1D	;TELUGU LETTER JHA
      #x0C1E	;TELUGU LETTER NYA
      #x0C1F	;TELUGU LETTER TTA
      #x0C20	;TELUGU LETTER TTHA
      #x0C21	;TELUGU LETTER DDA
      #x0C22	;TELUGU LETTER DDHA
      #x0C23	;TELUGU LETTER NNA
      #x0C24	;TELUGU LETTER TA
      #x0C25	;TELUGU LETTER THA
      #x0C26	;TELUGU LETTER DA
      #x0C27	;TELUGU LETTER DHA
      #x0C28	;TELUGU LETTER NA
      #x0C2A	;TELUGU LETTER PA
      #x0C2B	;TELUGU LETTER PHA
      #x0C2C	;TELUGU LETTER BA
      #x0C2D	;TELUGU LETTER BHA
      #x0C2E	;TELUGU LETTER MA
      #x0C2F	;TELUGU LETTER YA
      #x0C30	;TELUGU LETTER RA
      #x0C31	;TELUGU LETTER RRA
      #x0C32	;TELUGU LETTER LA
      #x0C33	;TELUGU LETTER LLA
      #x0C35	;TELUGU LETTER VA
      #x0C36	;TELUGU LETTER SHA
      #x0C37	;TELUGU LETTER SSA
      #x0C38	;TELUGU LETTER SA
      #x0C39	;TELUGU LETTER HA
      #x0C60	;TELUGU LETTER VOCALIC RR
      #x0C61	;TELUGU LETTER VOCALIC LL
      #x0C85	;KANNADA LETTER A
      #x0C86	;KANNADA LETTER AA
      #x0C87	;KANNADA LETTER I
      #x0C88	;KANNADA LETTER II
      #x0C89	;KANNADA LETTER U
      #x0C8A	;KANNADA LETTER UU
      #x0C8B	;KANNADA LETTER VOCALIC R
      #x0C8C	;KANNADA LETTER VOCALIC L
      #x0C8E	;KANNADA LETTER E
      #x0C8F	;KANNADA LETTER EE
      #x0C90	;KANNADA LETTER AI
      #x0C92	;KANNADA LETTER O
      #x0C93	;KANNADA LETTER OO
      #x0C94	;KANNADA LETTER AU
      #x0C95	;KANNADA LETTER KA
      #x0C96	;KANNADA LETTER KHA
      #x0C97	;KANNADA LETTER GA
      #x0C98	;KANNADA LETTER GHA
      #x0C99	;KANNADA LETTER NGA
      #x0C9A	;KANNADA LETTER CA
      #x0C9B	;KANNADA LETTER CHA
      #x0C9C	;KANNADA LETTER JA
      #x0C9D	;KANNADA LETTER JHA
      #x0C9E	;KANNADA LETTER NYA
      #x0C9F	;KANNADA LETTER TTA
      #x0CA0	;KANNADA LETTER TTHA
      #x0CA1	;KANNADA LETTER DDA
      #x0CA2	;KANNADA LETTER DDHA
      #x0CA3	;KANNADA LETTER NNA
      #x0CA4	;KANNADA LETTER TA
      #x0CA5	;KANNADA LETTER THA
      #x0CA6	;KANNADA LETTER DA
      #x0CA7	;KANNADA LETTER DHA
      #x0CA8	;KANNADA LETTER NA
      #x0CAA	;KANNADA LETTER PA
      #x0CAB	;KANNADA LETTER PHA
      #x0CAC	;KANNADA LETTER BA
      #x0CAD	;KANNADA LETTER BHA
      #x0CAE	;KANNADA LETTER MA
      #x0CAF	;KANNADA LETTER YA
      #x0CB0	;KANNADA LETTER RA
      #x0CB1	;KANNADA LETTER RRA
      #x0CB2	;KANNADA LETTER LA
      #x0CB3	;KANNADA LETTER LLA
      #x0CB5	;KANNADA LETTER VA
      #x0CB6	;KANNADA LETTER SHA
      #x0CB7	;KANNADA LETTER SSA
      #x0CB8	;KANNADA LETTER SA
      #x0CB9	;KANNADA LETTER HA
      #x0CBD	;KANNADA SIGN AVAGRAHA
      #x0CDE	;KANNADA LETTER FA
      #x0CE0	;KANNADA LETTER VOCALIC RR
      #x0CE1	;KANNADA LETTER VOCALIC LL
      #x0D05	;MALAYALAM LETTER A
      #x0D06	;MALAYALAM LETTER AA
      #x0D07	;MALAYALAM LETTER I
      #x0D08	;MALAYALAM LETTER II
      #x0D09	;MALAYALAM LETTER U
      #x0D0A	;MALAYALAM LETTER UU
      #x0D0B	;MALAYALAM LETTER VOCALIC R
      #x0D0C	;MALAYALAM LETTER VOCALIC L
      #x0D0E	;MALAYALAM LETTER E
      #x0D0F	;MALAYALAM LETTER EE
      #x0D10	;MALAYALAM LETTER AI
      #x0D12	;MALAYALAM LETTER O
      #x0D13	;MALAYALAM LETTER OO
      #x0D14	;MALAYALAM LETTER AU
      #x0D15	;MALAYALAM LETTER KA
      #x0D16	;MALAYALAM LETTER KHA
      #x0D17	;MALAYALAM LETTER GA
      #x0D18	;MALAYALAM LETTER GHA
      #x0D19	;MALAYALAM LETTER NGA
      #x0D1A	;MALAYALAM LETTER CA
      #x0D1B	;MALAYALAM LETTER CHA
      #x0D1C	;MALAYALAM LETTER JA
      #x0D1D	;MALAYALAM LETTER JHA
      #x0D1E	;MALAYALAM LETTER NYA
      #x0D1F	;MALAYALAM LETTER TTA
      #x0D20	;MALAYALAM LETTER TTHA
      #x0D21	;MALAYALAM LETTER DDA
      #x0D22	;MALAYALAM LETTER DDHA
      #x0D23	;MALAYALAM LETTER NNA
      #x0D24	;MALAYALAM LETTER TA
      #x0D25	;MALAYALAM LETTER THA
      #x0D26	;MALAYALAM LETTER DA
      #x0D27	;MALAYALAM LETTER DHA
      #x0D28	;MALAYALAM LETTER NA
      #x0D2A	;MALAYALAM LETTER PA
      #x0D2B	;MALAYALAM LETTER PHA
      #x0D2C	;MALAYALAM LETTER BA
      #x0D2D	;MALAYALAM LETTER BHA
      #x0D2E	;MALAYALAM LETTER MA
      #x0D2F	;MALAYALAM LETTER YA
      #x0D30	;MALAYALAM LETTER RA
      #x0D31	;MALAYALAM LETTER RRA
      #x0D32	;MALAYALAM LETTER LA
      #x0D33	;MALAYALAM LETTER LLA
      #x0D34	;MALAYALAM LETTER LLLA
      #x0D35	;MALAYALAM LETTER VA
      #x0D36	;MALAYALAM LETTER SHA
      #x0D37	;MALAYALAM LETTER SSA
      #x0D38	;MALAYALAM LETTER SA
      #x0D39	;MALAYALAM LETTER HA
      #x0D60	;MALAYALAM LETTER VOCALIC RR
      #x0D61	;MALAYALAM LETTER VOCALIC LL
      #x0D85	;SINHALA LETTER AYANNA
      #x0D86	;SINHALA LETTER AAYANNA
      #x0D87	;SINHALA LETTER AEYANNA
      #x0D88	;SINHALA LETTER AEEYANNA
      #x0D89	;SINHALA LETTER IYANNA
      #x0D8A	;SINHALA LETTER IIYANNA
      #x0D8B	;SINHALA LETTER UYANNA
      #x0D8C	;SINHALA LETTER UUYANNA
      #x0D8D	;SINHALA LETTER IRUYANNA
      #x0D8E	;SINHALA LETTER IRUUYANNA
      #x0D8F	;SINHALA LETTER ILUYANNA
      #x0D90	;SINHALA LETTER ILUUYANNA
      #x0D91	;SINHALA LETTER EYANNA
      #x0D92	;SINHALA LETTER EEYANNA
      #x0D93	;SINHALA LETTER AIYANNA
      #x0D94	;SINHALA LETTER OYANNA
      #x0D95	;SINHALA LETTER OOYANNA
      #x0D96	;SINHALA LETTER AUYANNA
      #x0D9A	;SINHALA LETTER ALPAPRAANA KAYANNA
      #x0D9B	;SINHALA LETTER MAHAAPRAANA KAYANNA
      #x0D9C	;SINHALA LETTER ALPAPRAANA GAYANNA
      #x0D9D	;SINHALA LETTER MAHAAPRAANA GAYANNA
      #x0D9E	;SINHALA LETTER KANTAJA NAASIKYAYA
      #x0D9F	;SINHALA LETTER SANYAKA GAYANNA
      #x0DA0	;SINHALA LETTER ALPAPRAANA CAYANNA
      #x0DA1	;SINHALA LETTER MAHAAPRAANA CAYANNA
      #x0DA2	;SINHALA LETTER ALPAPRAANA JAYANNA
      #x0DA3	;SINHALA LETTER MAHAAPRAANA JAYANNA
      #x0DA4	;SINHALA LETTER TAALUJA NAASIKYAYA
      #x0DA5	;SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA
      #x0DA6	;SINHALA LETTER SANYAKA JAYANNA
      #x0DA7	;SINHALA LETTER ALPAPRAANA TTAYANNA
      #x0DA8	;SINHALA LETTER MAHAAPRAANA TTAYANNA
      #x0DA9	;SINHALA LETTER ALPAPRAANA DDAYANNA
      #x0DAA	;SINHALA LETTER MAHAAPRAANA DDAYANNA
      #x0DAB	;SINHALA LETTER MUURDHAJA NAYANNA
      #x0DAC	;SINHALA LETTER SANYAKA DDAYANNA
      #x0DAD	;SINHALA LETTER ALPAPRAANA TAYANNA
      #x0DAE	;SINHALA LETTER MAHAAPRAANA TAYANNA
      #x0DAF	;SINHALA LETTER ALPAPRAANA DAYANNA
      #x0DB0	;SINHALA LETTER MAHAAPRAANA DAYANNA
      #x0DB1	;SINHALA LETTER DANTAJA NAYANNA
      #x0DB3	;SINHALA LETTER SANYAKA DAYANNA
      #x0DB4	;SINHALA LETTER ALPAPRAANA PAYANNA
      #x0DB5	;SINHALA LETTER MAHAAPRAANA PAYANNA
      #x0DB6	;SINHALA LETTER ALPAPRAANA BAYANNA
      #x0DB7	;SINHALA LETTER MAHAAPRAANA BAYANNA
      #x0DB8	;SINHALA LETTER MAYANNA
      #x0DB9	;SINHALA LETTER AMBA BAYANNA
      #x0DBA	;SINHALA LETTER YAYANNA
      #x0DBB	;SINHALA LETTER RAYANNA
      #x0DBD	;SINHALA LETTER DANTAJA LAYANNA
      #x0DC0	;SINHALA LETTER VAYANNA
      #x0DC1	;SINHALA LETTER TAALUJA SAYANNA
      #x0DC2	;SINHALA LETTER MUURDHAJA SAYANNA
      #x0DC3	;SINHALA LETTER DANTAJA SAYANNA
      #x0DC4	;SINHALA LETTER HAYANNA
      #x0DC5	;SINHALA LETTER MUURDHAJA LAYANNA
      #x0DC6	;SINHALA LETTER FAYANNA
      #x0E01	;THAI CHARACTER KO KAI
      #x0E02	;THAI CHARACTER KHO KHAI
      #x0E03	;THAI CHARACTER KHO KHUAT
      #x0E04	;THAI CHARACTER KHO KHWAI
      #x0E05	;THAI CHARACTER KHO KHON
      #x0E06	;THAI CHARACTER KHO RAKHANG
      #x0E07	;THAI CHARACTER NGO NGU
      #x0E08	;THAI CHARACTER CHO CHAN
      #x0E09	;THAI CHARACTER CHO CHING
      #x0E0A	;THAI CHARACTER CHO CHANG
      #x0E0B	;THAI CHARACTER SO SO
      #x0E0C	;THAI CHARACTER CHO CHOE
      #x0E0D	;THAI CHARACTER YO YING
      #x0E0E	;THAI CHARACTER DO CHADA
      #x0E0F	;THAI CHARACTER TO PATAK
      #x0E10	;THAI CHARACTER THO THAN
      #x0E11	;THAI CHARACTER THO NANGMONTHO
      #x0E12	;THAI CHARACTER THO PHUTHAO
      #x0E13	;THAI CHARACTER NO NEN
      #x0E14	;THAI CHARACTER DO DEK
      #x0E15	;THAI CHARACTER TO TAO
      #x0E16	;THAI CHARACTER THO THUNG
      #x0E17	;THAI CHARACTER THO THAHAN
      #x0E18	;THAI CHARACTER THO THONG
      #x0E19	;THAI CHARACTER NO NU
      #x0E1A	;THAI CHARACTER BO BAIMAI
      #x0E1B	;THAI CHARACTER PO PLA
      #x0E1C	;THAI CHARACTER PHO PHUNG
      #x0E1D	;THAI CHARACTER FO FA
      #x0E1E	;THAI CHARACTER PHO PHAN
      #x0E1F	;THAI CHARACTER FO FAN
      #x0E20	;THAI CHARACTER PHO SAMPHAO
      #x0E21	;THAI CHARACTER MO MA
      #x0E22	;THAI CHARACTER YO YAK
      #x0E23	;THAI CHARACTER RO RUA
      #x0E24	;THAI CHARACTER RU
      #x0E25	;THAI CHARACTER LO LING
      #x0E26	;THAI CHARACTER LU
      #x0E27	;THAI CHARACTER WO WAEN
      #x0E28	;THAI CHARACTER SO SALA
      #x0E29	;THAI CHARACTER SO RUSI
      #x0E2A	;THAI CHARACTER SO SUA
      #x0E2B	;THAI CHARACTER HO HIP
      #x0E2C	;THAI CHARACTER LO CHULA
      #x0E2D	;THAI CHARACTER O ANG
      #x0E2E	;THAI CHARACTER HO NOKHUK
      #x0E2F	;THAI CHARACTER PAIYANNOI
      #x0E30	;THAI CHARACTER SARA A
      #x0E32	;THAI CHARACTER SARA AA
      #x0E33	;THAI CHARACTER SARA AM
      #x0E40	;THAI CHARACTER SARA E
      #x0E41	;THAI CHARACTER SARA AE
      #x0E42	;THAI CHARACTER SARA O
      #x0E43	;THAI CHARACTER SARA AI MAIMUAN
      #x0E44	;THAI CHARACTER SARA AI MAIMALAI
      #x0E45	;THAI CHARACTER LAKKHANGYAO
      #x0E46	;THAI CHARACTER MAIYAMOK
      #x0E81	;LAO LETTER KO
      #x0E82	;LAO LETTER KHO SUNG
      #x0E84	;LAO LETTER KHO TAM
      #x0E87	;LAO LETTER NGO
      #x0E88	;LAO LETTER CO
      #x0E8A	;LAO LETTER SO TAM
      #x0E8D	;LAO LETTER NYO
      #x0E94	;LAO LETTER DO
      #x0E95	;LAO LETTER TO
      #x0E96	;LAO LETTER THO SUNG
      #x0E97	;LAO LETTER THO TAM
      #x0E99	;LAO LETTER NO
      #x0E9A	;LAO LETTER BO
      #x0E9B	;LAO LETTER PO
      #x0E9C	;LAO LETTER PHO SUNG
      #x0E9D	;LAO LETTER FO TAM
      #x0E9E	;LAO LETTER PHO TAM
      #x0E9F	;LAO LETTER FO SUNG
      #x0EA1	;LAO LETTER MO
      #x0EA2	;LAO LETTER YO
      #x0EA3	;LAO LETTER LO LING
      #x0EA5	;LAO LETTER LO LOOT
      #x0EA7	;LAO LETTER WO
      #x0EAA	;LAO LETTER SO SUNG
      #x0EAB	;LAO LETTER HO SUNG
      #x0EAD	;LAO LETTER O
      #x0EAE	;LAO LETTER HO TAM
      #x0EAF	;LAO ELLIPSIS
      #x0EB0	;LAO VOWEL SIGN A
      #x0EB2	;LAO VOWEL SIGN AA
      #x0EB3	;LAO VOWEL SIGN AM
      #x0EBD	;LAO SEMIVOWEL SIGN NYO
      #x0EC0	;LAO VOWEL SIGN E
      #x0EC1	;LAO VOWEL SIGN EI
      #x0EC2	;LAO VOWEL SIGN O
      #x0EC3	;LAO VOWEL SIGN AY
      #x0EC4	;LAO VOWEL SIGN AI
      #x0EC6	;LAO KO LA
      #x0EDC	;LAO HO NO
      #x0EDD	;LAO HO MO
      #x0F00	;TIBETAN SYLLABLE OM
      #x0F40	;TIBETAN LETTER KA
      #x0F41	;TIBETAN LETTER KHA
      #x0F42	;TIBETAN LETTER GA
      #x0F43	;TIBETAN LETTER GHA
      #x0F44	;TIBETAN LETTER NGA
      #x0F45	;TIBETAN LETTER CA
      #x0F46	;TIBETAN LETTER CHA
      #x0F47	;TIBETAN LETTER JA
      #x0F49	;TIBETAN LETTER NYA
      #x0F4A	;TIBETAN LETTER TTA
      #x0F4B	;TIBETAN LETTER TTHA
      #x0F4C	;TIBETAN LETTER DDA
      #x0F4D	;TIBETAN LETTER DDHA
      #x0F4E	;TIBETAN LETTER NNA
      #x0F4F	;TIBETAN LETTER TA
      #x0F50	;TIBETAN LETTER THA
      #x0F51	;TIBETAN LETTER DA
      #x0F52	;TIBETAN LETTER DHA
      #x0F53	;TIBETAN LETTER NA
      #x0F54	;TIBETAN LETTER PA
      #x0F55	;TIBETAN LETTER PHA
      #x0F56	;TIBETAN LETTER BA
      #x0F57	;TIBETAN LETTER BHA
      #x0F58	;TIBETAN LETTER MA
      #x0F59	;TIBETAN LETTER TSA
      #x0F5A	;TIBETAN LETTER TSHA
      #x0F5B	;TIBETAN LETTER DZA
      #x0F5C	;TIBETAN LETTER DZHA
      #x0F5D	;TIBETAN LETTER WA
      #x0F5E	;TIBETAN LETTER ZHA
      #x0F5F	;TIBETAN LETTER ZA
      #x0F60	;TIBETAN LETTER -A
      #x0F61	;TIBETAN LETTER YA
      #x0F62	;TIBETAN LETTER RA
      #x0F63	;TIBETAN LETTER LA
      #x0F64	;TIBETAN LETTER SHA
      #x0F65	;TIBETAN LETTER SSA
      #x0F66	;TIBETAN LETTER SA
      #x0F67	;TIBETAN LETTER HA
      #x0F68	;TIBETAN LETTER A
      #x0F69	;TIBETAN LETTER KSSA
      #x0F6A	;TIBETAN LETTER FIXED-FORM RA
      #x0F88	;TIBETAN SIGN LCE TSA CAN
      #x0F89	;TIBETAN SIGN MCHU CAN
      #x0F8A	;TIBETAN SIGN GRU CAN RGYINGS
      #x0F8B	;TIBETAN SIGN GRU MED RGYINGS
      #x1000	;MYANMAR LETTER KA
      #x1001	;MYANMAR LETTER KHA
      #x1002	;MYANMAR LETTER GA
      #x1003	;MYANMAR LETTER GHA
      #x1004	;MYANMAR LETTER NGA
      #x1005	;MYANMAR LETTER CA
      #x1006	;MYANMAR LETTER CHA
      #x1007	;MYANMAR LETTER JA
      #x1008	;MYANMAR LETTER JHA
      #x1009	;MYANMAR LETTER NYA
      #x100A	;MYANMAR LETTER NNYA
      #x100B	;MYANMAR LETTER TTA
      #x100C	;MYANMAR LETTER TTHA
      #x100D	;MYANMAR LETTER DDA
      #x100E	;MYANMAR LETTER DDHA
      #x100F	;MYANMAR LETTER NNA
      #x1010	;MYANMAR LETTER TA
      #x1011	;MYANMAR LETTER THA
      #x1012	;MYANMAR LETTER DA
      #x1013	;MYANMAR LETTER DHA
      #x1014	;MYANMAR LETTER NA
      #x1015	;MYANMAR LETTER PA
      #x1016	;MYANMAR LETTER PHA
      #x1017	;MYANMAR LETTER BA
      #x1018	;MYANMAR LETTER BHA
      #x1019	;MYANMAR LETTER MA
      #x101A	;MYANMAR LETTER YA
      #x101B	;MYANMAR LETTER RA
      #x101C	;MYANMAR LETTER LA
      #x101D	;MYANMAR LETTER WA
      #x101E	;MYANMAR LETTER SA
      #x101F	;MYANMAR LETTER HA
      #x1020	;MYANMAR LETTER LLA
      #x1021	;MYANMAR LETTER A
      #x1023	;MYANMAR LETTER I
      #x1024	;MYANMAR LETTER II
      #x1025	;MYANMAR LETTER U
      #x1026	;MYANMAR LETTER UU
      #x1027	;MYANMAR LETTER E
      #x1029	;MYANMAR LETTER O
      #x102A	;MYANMAR LETTER AU
      #x1050	;MYANMAR LETTER SHA
      #x1051	;MYANMAR LETTER SSA
      #x1052	;MYANMAR LETTER VOCALIC R
      #x1053	;MYANMAR LETTER VOCALIC RR
      #x1054	;MYANMAR LETTER VOCALIC L
      #x1055	;MYANMAR LETTER VOCALIC LL
      #x10A0	;GEORGIAN CAPITAL LETTER AN
      #x10A1	;GEORGIAN CAPITAL LETTER BAN
      #x10A2	;GEORGIAN CAPITAL LETTER GAN
      #x10A3	;GEORGIAN CAPITAL LETTER DON
      #x10A4	;GEORGIAN CAPITAL LETTER EN
      #x10A5	;GEORGIAN CAPITAL LETTER VIN
      #x10A6	;GEORGIAN CAPITAL LETTER ZEN
      #x10A7	;GEORGIAN CAPITAL LETTER TAN
      #x10A8	;GEORGIAN CAPITAL LETTER IN
      #x10A9	;GEORGIAN CAPITAL LETTER KAN
      #x10AA	;GEORGIAN CAPITAL LETTER LAS
      #x10AB	;GEORGIAN CAPITAL LETTER MAN
      #x10AC	;GEORGIAN CAPITAL LETTER NAR
      #x10AD	;GEORGIAN CAPITAL LETTER ON
      #x10AE	;GEORGIAN CAPITAL LETTER PAR
      #x10AF	;GEORGIAN CAPITAL LETTER ZHAR
      #x10B0	;GEORGIAN CAPITAL LETTER RAE
      #x10B1	;GEORGIAN CAPITAL LETTER SAN
      #x10B2	;GEORGIAN CAPITAL LETTER TAR
      #x10B3	;GEORGIAN CAPITAL LETTER UN
      #x10B4	;GEORGIAN CAPITAL LETTER PHAR
      #x10B5	;GEORGIAN CAPITAL LETTER KHAR
      #x10B6	;GEORGIAN CAPITAL LETTER GHAN
      #x10B7	;GEORGIAN CAPITAL LETTER QAR
      #x10B8	;GEORGIAN CAPITAL LETTER SHIN
      #x10B9	;GEORGIAN CAPITAL LETTER CHIN
      #x10BA	;GEORGIAN CAPITAL LETTER CAN
      #x10BB	;GEORGIAN CAPITAL LETTER JIL
      #x10BC	;GEORGIAN CAPITAL LETTER CIL
      #x10BD	;GEORGIAN CAPITAL LETTER CHAR
      #x10BE	;GEORGIAN CAPITAL LETTER XAN
      #x10BF	;GEORGIAN CAPITAL LETTER JHAN
      #x10C0	;GEORGIAN CAPITAL LETTER HAE
      #x10C1	;GEORGIAN CAPITAL LETTER HE
      #x10C2	;GEORGIAN CAPITAL LETTER HIE
      #x10C3	;GEORGIAN CAPITAL LETTER WE
      #x10C4	;GEORGIAN CAPITAL LETTER HAR
      #x10C5	;GEORGIAN CAPITAL LETTER HOE
      #x10D0	;GEORGIAN LETTER AN
      #x10D1	;GEORGIAN LETTER BAN
      #x10D2	;GEORGIAN LETTER GAN
      #x10D3	;GEORGIAN LETTER DON
      #x10D4	;GEORGIAN LETTER EN
      #x10D5	;GEORGIAN LETTER VIN
      #x10D6	;GEORGIAN LETTER ZEN
      #x10D7	;GEORGIAN LETTER TAN
      #x10D8	;GEORGIAN LETTER IN
      #x10D9	;GEORGIAN LETTER KAN
      #x10DA	;GEORGIAN LETTER LAS
      #x10DB	;GEORGIAN LETTER MAN
      #x10DC	;GEORGIAN LETTER NAR
      #x10DD	;GEORGIAN LETTER ON
      #x10DE	;GEORGIAN LETTER PAR
      #x10DF	;GEORGIAN LETTER ZHAR
      #x10E0	;GEORGIAN LETTER RAE
      #x10E1	;GEORGIAN LETTER SAN
      #x10E2	;GEORGIAN LETTER TAR
      #x10E3	;GEORGIAN LETTER UN
      #x10E4	;GEORGIAN LETTER PHAR
      #x10E5	;GEORGIAN LETTER KHAR
      #x10E6	;GEORGIAN LETTER GHAN
      #x10E7	;GEORGIAN LETTER QAR
      #x10E8	;GEORGIAN LETTER SHIN
      #x10E9	;GEORGIAN LETTER CHIN
      #x10EA	;GEORGIAN LETTER CAN
      #x10EB	;GEORGIAN LETTER JIL
      #x10EC	;GEORGIAN LETTER CIL
      #x10ED	;GEORGIAN LETTER CHAR
      #x10EE	;GEORGIAN LETTER XAN
      #x10EF	;GEORGIAN LETTER JHAN
      #x10F0	;GEORGIAN LETTER HAE
      #x10F1	;GEORGIAN LETTER HE
      #x10F2	;GEORGIAN LETTER HIE
      #x10F3	;GEORGIAN LETTER WE
      #x10F4	;GEORGIAN LETTER HAR
      #x10F5	;GEORGIAN LETTER HOE
      #x10F6	;GEORGIAN LETTER FI
      #x10F7	;GEORGIAN LETTER YN
      #x10F8	;GEORGIAN LETTER ELIFI
      #x1100	;HANGUL CHOSEONG KIYEOK
      #x1101	;HANGUL CHOSEONG SSANGKIYEOK
      #x1102	;HANGUL CHOSEONG NIEUN
      #x1103	;HANGUL CHOSEONG TIKEUT
      #x1104	;HANGUL CHOSEONG SSANGTIKEUT
      #x1105	;HANGUL CHOSEONG RIEUL
      #x1106	;HANGUL CHOSEONG MIEUM
      #x1107	;HANGUL CHOSEONG PIEUP
      #x1108	;HANGUL CHOSEONG SSANGPIEUP
      #x1109	;HANGUL CHOSEONG SIOS
      #x110A	;HANGUL CHOSEONG SSANGSIOS
      #x110B	;HANGUL CHOSEONG IEUNG
      #x110C	;HANGUL CHOSEONG CIEUC
      #x110D	;HANGUL CHOSEONG SSANGCIEUC
      #x110E	;HANGUL CHOSEONG CHIEUCH
      #x110F	;HANGUL CHOSEONG KHIEUKH
      #x1110	;HANGUL CHOSEONG THIEUTH
      #x1111	;HANGUL CHOSEONG PHIEUPH
      #x1112	;HANGUL CHOSEONG HIEUH
      #x1113	;HANGUL CHOSEONG NIEUN-KIYEOK
      #x1114	;HANGUL CHOSEONG SSANGNIEUN
      #x1115	;HANGUL CHOSEONG NIEUN-TIKEUT
      #x1116	;HANGUL CHOSEONG NIEUN-PIEUP
      #x1117	;HANGUL CHOSEONG TIKEUT-KIYEOK
      #x1118	;HANGUL CHOSEONG RIEUL-NIEUN
      #x1119	;HANGUL CHOSEONG SSANGRIEUL
      #x111A	;HANGUL CHOSEONG RIEUL-HIEUH
      #x111B	;HANGUL CHOSEONG KAPYEOUNRIEUL
      #x111C	;HANGUL CHOSEONG MIEUM-PIEUP
      #x111D	;HANGUL CHOSEONG KAPYEOUNMIEUM
      #x111E	;HANGUL CHOSEONG PIEUP-KIYEOK
      #x111F	;HANGUL CHOSEONG PIEUP-NIEUN
      #x1120	;HANGUL CHOSEONG PIEUP-TIKEUT
      #x1121	;HANGUL CHOSEONG PIEUP-SIOS
      #x1122	;HANGUL CHOSEONG PIEUP-SIOS-KIYEOK
      #x1123	;HANGUL CHOSEONG PIEUP-SIOS-TIKEUT
      #x1124	;HANGUL CHOSEONG PIEUP-SIOS-PIEUP
      #x1125	;HANGUL CHOSEONG PIEUP-SSANGSIOS
      #x1126	;HANGUL CHOSEONG PIEUP-SIOS-CIEUC
      #x1127	;HANGUL CHOSEONG PIEUP-CIEUC
      #x1128	;HANGUL CHOSEONG PIEUP-CHIEUCH
      #x1129	;HANGUL CHOSEONG PIEUP-THIEUTH
      #x112A	;HANGUL CHOSEONG PIEUP-PHIEUPH
      #x112B	;HANGUL CHOSEONG KAPYEOUNPIEUP
      #x112C	;HANGUL CHOSEONG KAPYEOUNSSANGPIEUP
      #x112D	;HANGUL CHOSEONG SIOS-KIYEOK
      #x112E	;HANGUL CHOSEONG SIOS-NIEUN
      #x112F	;HANGUL CHOSEONG SIOS-TIKEUT
      #x1130	;HANGUL CHOSEONG SIOS-RIEUL
      #x1131	;HANGUL CHOSEONG SIOS-MIEUM
      #x1132	;HANGUL CHOSEONG SIOS-PIEUP
      #x1133	;HANGUL CHOSEONG SIOS-PIEUP-KIYEOK
      #x1134	;HANGUL CHOSEONG SIOS-SSANGSIOS
      #x1135	;HANGUL CHOSEONG SIOS-IEUNG
      #x1136	;HANGUL CHOSEONG SIOS-CIEUC
      #x1137	;HANGUL CHOSEONG SIOS-CHIEUCH
      #x1138	;HANGUL CHOSEONG SIOS-KHIEUKH
      #x1139	;HANGUL CHOSEONG SIOS-THIEUTH
      #x113A	;HANGUL CHOSEONG SIOS-PHIEUPH
      #x113B	;HANGUL CHOSEONG SIOS-HIEUH
      #x113C	;HANGUL CHOSEONG CHITUEUMSIOS
      #x113D	;HANGUL CHOSEONG CHITUEUMSSANGSIOS
      #x113E	;HANGUL CHOSEONG CEONGCHIEUMSIOS
      #x113F	;HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS
      #x1140	;HANGUL CHOSEONG PANSIOS
      #x1141	;HANGUL CHOSEONG IEUNG-KIYEOK
      #x1142	;HANGUL CHOSEONG IEUNG-TIKEUT
      #x1143	;HANGUL CHOSEONG IEUNG-MIEUM
      #x1144	;HANGUL CHOSEONG IEUNG-PIEUP
      #x1145	;HANGUL CHOSEONG IEUNG-SIOS
      #x1146	;HANGUL CHOSEONG IEUNG-PANSIOS
      #x1147	;HANGUL CHOSEONG SSANGIEUNG
      #x1148	;HANGUL CHOSEONG IEUNG-CIEUC
      #x1149	;HANGUL CHOSEONG IEUNG-CHIEUCH
      #x114A	;HANGUL CHOSEONG IEUNG-THIEUTH
      #x114B	;HANGUL CHOSEONG IEUNG-PHIEUPH
      #x114C	;HANGUL CHOSEONG YESIEUNG
      #x114D	;HANGUL CHOSEONG CIEUC-IEUNG
      #x114E	;HANGUL CHOSEONG CHITUEUMCIEUC
      #x114F	;HANGUL CHOSEONG CHITUEUMSSANGCIEUC
      #x1150	;HANGUL CHOSEONG CEONGCHIEUMCIEUC
      #x1151	;HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC
      #x1152	;HANGUL CHOSEONG CHIEUCH-KHIEUKH
      #x1153	;HANGUL CHOSEONG CHIEUCH-HIEUH
      #x1154	;HANGUL CHOSEONG CHITUEUMCHIEUCH
      #x1155	;HANGUL CHOSEONG CEONGCHIEUMCHIEUCH
      #x1156	;HANGUL CHOSEONG PHIEUPH-PIEUP
      #x1157	;HANGUL CHOSEONG KAPYEOUNPHIEUPH
      #x1158	;HANGUL CHOSEONG SSANGHIEUH
      #x1159	;HANGUL CHOSEONG YEORINHIEUH
      #x115F	;HANGUL CHOSEONG FILLER
      #x1160	;HANGUL JUNGSEONG FILLER
      #x1161	;HANGUL JUNGSEONG A
      #x1162	;HANGUL JUNGSEONG AE
      #x1163	;HANGUL JUNGSEONG YA
      #x1164	;HANGUL JUNGSEONG YAE
      #x1165	;HANGUL JUNGSEONG EO
      #x1166	;HANGUL JUNGSEONG E
      #x1167	;HANGUL JUNGSEONG YEO
      #x1168	;HANGUL JUNGSEONG YE
      #x1169	;HANGUL JUNGSEONG O
      #x116A	;HANGUL JUNGSEONG WA
      #x116B	;HANGUL JUNGSEONG WAE
      #x116C	;HANGUL JUNGSEONG OE
      #x116D	;HANGUL JUNGSEONG YO
      #x116E	;HANGUL JUNGSEONG U
      #x116F	;HANGUL JUNGSEONG WEO
      #x1170	;HANGUL JUNGSEONG WE
      #x1171	;HANGUL JUNGSEONG WI
      #x1172	;HANGUL JUNGSEONG YU
      #x1173	;HANGUL JUNGSEONG EU
      #x1174	;HANGUL JUNGSEONG YI
      #x1175	;HANGUL JUNGSEONG I
      #x1176	;HANGUL JUNGSEONG A-O
      #x1177	;HANGUL JUNGSEONG A-U
      #x1178	;HANGUL JUNGSEONG YA-O
      #x1179	;HANGUL JUNGSEONG YA-YO
      #x117A	;HANGUL JUNGSEONG EO-O
      #x117B	;HANGUL JUNGSEONG EO-U
      #x117C	;HANGUL JUNGSEONG EO-EU
      #x117D	;HANGUL JUNGSEONG YEO-O
      #x117E	;HANGUL JUNGSEONG YEO-U
      #x117F	;HANGUL JUNGSEONG O-EO
      #x1180	;HANGUL JUNGSEONG O-E
      #x1181	;HANGUL JUNGSEONG O-YE
      #x1182	;HANGUL JUNGSEONG O-O
      #x1183	;HANGUL JUNGSEONG O-U
      #x1184	;HANGUL JUNGSEONG YO-YA
      #x1185	;HANGUL JUNGSEONG YO-YAE
      #x1186	;HANGUL JUNGSEONG YO-YEO
      #x1187	;HANGUL JUNGSEONG YO-O
      #x1188	;HANGUL JUNGSEONG YO-I
      #x1189	;HANGUL JUNGSEONG U-A
      #x118A	;HANGUL JUNGSEONG U-AE
      #x118B	;HANGUL JUNGSEONG U-EO-EU
      #x118C	;HANGUL JUNGSEONG U-YE
      #x118D	;HANGUL JUNGSEONG U-U
      #x118E	;HANGUL JUNGSEONG YU-A
      #x118F	;HANGUL JUNGSEONG YU-EO
      #x1190	;HANGUL JUNGSEONG YU-E
      #x1191	;HANGUL JUNGSEONG YU-YEO
      #x1192	;HANGUL JUNGSEONG YU-YE
      #x1193	;HANGUL JUNGSEONG YU-U
      #x1194	;HANGUL JUNGSEONG YU-I
      #x1195	;HANGUL JUNGSEONG EU-U
      #x1196	;HANGUL JUNGSEONG EU-EU
      #x1197	;HANGUL JUNGSEONG YI-U
      #x1198	;HANGUL JUNGSEONG I-A
      #x1199	;HANGUL JUNGSEONG I-YA
      #x119A	;HANGUL JUNGSEONG I-O
      #x119B	;HANGUL JUNGSEONG I-U
      #x119C	;HANGUL JUNGSEONG I-EU
      #x119D	;HANGUL JUNGSEONG I-ARAEA
      #x119E	;HANGUL JUNGSEONG ARAEA
      #x119F	;HANGUL JUNGSEONG ARAEA-EO
      #x11A0	;HANGUL JUNGSEONG ARAEA-U
      #x11A1	;HANGUL JUNGSEONG ARAEA-I
      #x11A2	;HANGUL JUNGSEONG SSANGARAEA
      #x11A8	;HANGUL JONGSEONG KIYEOK
      #x11A9	;HANGUL JONGSEONG SSANGKIYEOK
      #x11AA	;HANGUL JONGSEONG KIYEOK-SIOS
      #x11AB	;HANGUL JONGSEONG NIEUN
      #x11AC	;HANGUL JONGSEONG NIEUN-CIEUC
      #x11AD	;HANGUL JONGSEONG NIEUN-HIEUH
      #x11AE	;HANGUL JONGSEONG TIKEUT
      #x11AF	;HANGUL JONGSEONG RIEUL
      #x11B0	;HANGUL JONGSEONG RIEUL-KIYEOK
      #x11B1	;HANGUL JONGSEONG RIEUL-MIEUM
      #x11B2	;HANGUL JONGSEONG RIEUL-PIEUP
      #x11B3	;HANGUL JONGSEONG RIEUL-SIOS
      #x11B4	;HANGUL JONGSEONG RIEUL-THIEUTH
      #x11B5	;HANGUL JONGSEONG RIEUL-PHIEUPH
      #x11B6	;HANGUL JONGSEONG RIEUL-HIEUH
      #x11B7	;HANGUL JONGSEONG MIEUM
      #x11B8	;HANGUL JONGSEONG PIEUP
      #x11B9	;HANGUL JONGSEONG PIEUP-SIOS
      #x11BA	;HANGUL JONGSEONG SIOS
      #x11BB	;HANGUL JONGSEONG SSANGSIOS
      #x11BC	;HANGUL JONGSEONG IEUNG
      #x11BD	;HANGUL JONGSEONG CIEUC
      #x11BE	;HANGUL JONGSEONG CHIEUCH
      #x11BF	;HANGUL JONGSEONG KHIEUKH
      #x11C0	;HANGUL JONGSEONG THIEUTH
      #x11C1	;HANGUL JONGSEONG PHIEUPH
      #x11C2	;HANGUL JONGSEONG HIEUH
      #x11C3	;HANGUL JONGSEONG KIYEOK-RIEUL
      #x11C4	;HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK
      #x11C5	;HANGUL JONGSEONG NIEUN-KIYEOK
      #x11C6	;HANGUL JONGSEONG NIEUN-TIKEUT
      #x11C7	;HANGUL JONGSEONG NIEUN-SIOS
      #x11C8	;HANGUL JONGSEONG NIEUN-PANSIOS
      #x11C9	;HANGUL JONGSEONG NIEUN-THIEUTH
      #x11CA	;HANGUL JONGSEONG TIKEUT-KIYEOK
      #x11CB	;HANGUL JONGSEONG TIKEUT-RIEUL
      #x11CC	;HANGUL JONGSEONG RIEUL-KIYEOK-SIOS
      #x11CD	;HANGUL JONGSEONG RIEUL-NIEUN
      #x11CE	;HANGUL JONGSEONG RIEUL-TIKEUT
      #x11CF	;HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH
      #x11D0	;HANGUL JONGSEONG SSANGRIEUL
      #x11D1	;HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK
      #x11D2	;HANGUL JONGSEONG RIEUL-MIEUM-SIOS
      #x11D3	;HANGUL JONGSEONG RIEUL-PIEUP-SIOS
      #x11D4	;HANGUL JONGSEONG RIEUL-PIEUP-HIEUH
      #x11D5	;HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP
      #x11D6	;HANGUL JONGSEONG RIEUL-SSANGSIOS
      #x11D7	;HANGUL JONGSEONG RIEUL-PANSIOS
      #x11D8	;HANGUL JONGSEONG RIEUL-KHIEUKH
      #x11D9	;HANGUL JONGSEONG RIEUL-YEORINHIEUH
      #x11DA	;HANGUL JONGSEONG MIEUM-KIYEOK
      #x11DB	;HANGUL JONGSEONG MIEUM-RIEUL
      #x11DC	;HANGUL JONGSEONG MIEUM-PIEUP
      #x11DD	;HANGUL JONGSEONG MIEUM-SIOS
      #x11DE	;HANGUL JONGSEONG MIEUM-SSANGSIOS
      #x11DF	;HANGUL JONGSEONG MIEUM-PANSIOS
      #x11E0	;HANGUL JONGSEONG MIEUM-CHIEUCH
      #x11E1	;HANGUL JONGSEONG MIEUM-HIEUH
      #x11E2	;HANGUL JONGSEONG KAPYEOUNMIEUM
      #x11E3	;HANGUL JONGSEONG PIEUP-RIEUL
      #x11E4	;HANGUL JONGSEONG PIEUP-PHIEUPH
      #x11E5	;HANGUL JONGSEONG PIEUP-HIEUH
      #x11E6	;HANGUL JONGSEONG KAPYEOUNPIEUP
      #x11E7	;HANGUL JONGSEONG SIOS-KIYEOK
      #x11E8	;HANGUL JONGSEONG SIOS-TIKEUT
      #x11E9	;HANGUL JONGSEONG SIOS-RIEUL
      #x11EA	;HANGUL JONGSEONG SIOS-PIEUP
      #x11EB	;HANGUL JONGSEONG PANSIOS
      #x11EC	;HANGUL JONGSEONG IEUNG-KIYEOK
      #x11ED	;HANGUL JONGSEONG IEUNG-SSANGKIYEOK
      #x11EE	;HANGUL JONGSEONG SSANGIEUNG
      #x11EF	;HANGUL JONGSEONG IEUNG-KHIEUKH
      #x11F0	;HANGUL JONGSEONG YESIEUNG
      #x11F1	;HANGUL JONGSEONG YESIEUNG-SIOS
      #x11F2	;HANGUL JONGSEONG YESIEUNG-PANSIOS
      #x11F3	;HANGUL JONGSEONG PHIEUPH-PIEUP
      #x11F4	;HANGUL JONGSEONG KAPYEOUNPHIEUPH
      #x11F5	;HANGUL JONGSEONG HIEUH-NIEUN
      #x11F6	;HANGUL JONGSEONG HIEUH-RIEUL
      #x11F7	;HANGUL JONGSEONG HIEUH-MIEUM
      #x11F8	;HANGUL JONGSEONG HIEUH-PIEUP
      #x11F9	;HANGUL JONGSEONG YEORINHIEUH
      #x1200	;ETHIOPIC SYLLABLE HA
      #x1201	;ETHIOPIC SYLLABLE HU
      #x1202	;ETHIOPIC SYLLABLE HI
      #x1203	;ETHIOPIC SYLLABLE HAA
      #x1204	;ETHIOPIC SYLLABLE HEE
      #x1205	;ETHIOPIC SYLLABLE HE
      #x1206	;ETHIOPIC SYLLABLE HO
      #x1208	;ETHIOPIC SYLLABLE LA
      #x1209	;ETHIOPIC SYLLABLE LU
      #x120A	;ETHIOPIC SYLLABLE LI
      #x120B	;ETHIOPIC SYLLABLE LAA
      #x120C	;ETHIOPIC SYLLABLE LEE
      #x120D	;ETHIOPIC SYLLABLE LE
      #x120E	;ETHIOPIC SYLLABLE LO
      #x120F	;ETHIOPIC SYLLABLE LWA
      #x1210	;ETHIOPIC SYLLABLE HHA
      #x1211	;ETHIOPIC SYLLABLE HHU
      #x1212	;ETHIOPIC SYLLABLE HHI
      #x1213	;ETHIOPIC SYLLABLE HHAA
      #x1214	;ETHIOPIC SYLLABLE HHEE
      #x1215	;ETHIOPIC SYLLABLE HHE
      #x1216	;ETHIOPIC SYLLABLE HHO
      #x1217	;ETHIOPIC SYLLABLE HHWA
      #x1218	;ETHIOPIC SYLLABLE MA
      #x1219	;ETHIOPIC SYLLABLE MU
      #x121A	;ETHIOPIC SYLLABLE MI
      #x121B	;ETHIOPIC SYLLABLE MAA
      #x121C	;ETHIOPIC SYLLABLE MEE
      #x121D	;ETHIOPIC SYLLABLE ME
      #x121E	;ETHIOPIC SYLLABLE MO
      #x121F	;ETHIOPIC SYLLABLE MWA
      #x1220	;ETHIOPIC SYLLABLE SZA
      #x1221	;ETHIOPIC SYLLABLE SZU
      #x1222	;ETHIOPIC SYLLABLE SZI
      #x1223	;ETHIOPIC SYLLABLE SZAA
      #x1224	;ETHIOPIC SYLLABLE SZEE
      #x1225	;ETHIOPIC SYLLABLE SZE
      #x1226	;ETHIOPIC SYLLABLE SZO
      #x1227	;ETHIOPIC SYLLABLE SZWA
      #x1228	;ETHIOPIC SYLLABLE RA
      #x1229	;ETHIOPIC SYLLABLE RU
      #x122A	;ETHIOPIC SYLLABLE RI
      #x122B	;ETHIOPIC SYLLABLE RAA
      #x122C	;ETHIOPIC SYLLABLE REE
      #x122D	;ETHIOPIC SYLLABLE RE
      #x122E	;ETHIOPIC SYLLABLE RO
      #x122F	;ETHIOPIC SYLLABLE RWA
      #x1230	;ETHIOPIC SYLLABLE SA
      #x1231	;ETHIOPIC SYLLABLE SU
      #x1232	;ETHIOPIC SYLLABLE SI
      #x1233	;ETHIOPIC SYLLABLE SAA
      #x1234	;ETHIOPIC SYLLABLE SEE
      #x1235	;ETHIOPIC SYLLABLE SE
      #x1236	;ETHIOPIC SYLLABLE SO
      #x1237	;ETHIOPIC SYLLABLE SWA
      #x1238	;ETHIOPIC SYLLABLE SHA
      #x1239	;ETHIOPIC SYLLABLE SHU
      #x123A	;ETHIOPIC SYLLABLE SHI
      #x123B	;ETHIOPIC SYLLABLE SHAA
      #x123C	;ETHIOPIC SYLLABLE SHEE
      #x123D	;ETHIOPIC SYLLABLE SHE
      #x123E	;ETHIOPIC SYLLABLE SHO
      #x123F	;ETHIOPIC SYLLABLE SHWA
      #x1240	;ETHIOPIC SYLLABLE QA
      #x1241	;ETHIOPIC SYLLABLE QU
      #x1242	;ETHIOPIC SYLLABLE QI
      #x1243	;ETHIOPIC SYLLABLE QAA
      #x1244	;ETHIOPIC SYLLABLE QEE
      #x1245	;ETHIOPIC SYLLABLE QE
      #x1246	;ETHIOPIC SYLLABLE QO
      #x1248	;ETHIOPIC SYLLABLE QWA
      #x124A	;ETHIOPIC SYLLABLE QWI
      #x124B	;ETHIOPIC SYLLABLE QWAA
      #x124C	;ETHIOPIC SYLLABLE QWEE
      #x124D	;ETHIOPIC SYLLABLE QWE
      #x1250	;ETHIOPIC SYLLABLE QHA
      #x1251	;ETHIOPIC SYLLABLE QHU
      #x1252	;ETHIOPIC SYLLABLE QHI
      #x1253	;ETHIOPIC SYLLABLE QHAA
      #x1254	;ETHIOPIC SYLLABLE QHEE
      #x1255	;ETHIOPIC SYLLABLE QHE
      #x1256	;ETHIOPIC SYLLABLE QHO
      #x1258	;ETHIOPIC SYLLABLE QHWA
      #x125A	;ETHIOPIC SYLLABLE QHWI
      #x125B	;ETHIOPIC SYLLABLE QHWAA
      #x125C	;ETHIOPIC SYLLABLE QHWEE
      #x125D	;ETHIOPIC SYLLABLE QHWE
      #x1260	;ETHIOPIC SYLLABLE BA
      #x1261	;ETHIOPIC SYLLABLE BU
      #x1262	;ETHIOPIC SYLLABLE BI
      #x1263	;ETHIOPIC SYLLABLE BAA
      #x1264	;ETHIOPIC SYLLABLE BEE
      #x1265	;ETHIOPIC SYLLABLE BE
      #x1266	;ETHIOPIC SYLLABLE BO
      #x1267	;ETHIOPIC SYLLABLE BWA
      #x1268	;ETHIOPIC SYLLABLE VA
      #x1269	;ETHIOPIC SYLLABLE VU
      #x126A	;ETHIOPIC SYLLABLE VI
      #x126B	;ETHIOPIC SYLLABLE VAA
      #x126C	;ETHIOPIC SYLLABLE VEE
      #x126D	;ETHIOPIC SYLLABLE VE
      #x126E	;ETHIOPIC SYLLABLE VO
      #x126F	;ETHIOPIC SYLLABLE VWA
      #x1270	;ETHIOPIC SYLLABLE TA
      #x1271	;ETHIOPIC SYLLABLE TU
      #x1272	;ETHIOPIC SYLLABLE TI
      #x1273	;ETHIOPIC SYLLABLE TAA
      #x1274	;ETHIOPIC SYLLABLE TEE
      #x1275	;ETHIOPIC SYLLABLE TE
      #x1276	;ETHIOPIC SYLLABLE TO
      #x1277	;ETHIOPIC SYLLABLE TWA
      #x1278	;ETHIOPIC SYLLABLE CA
      #x1279	;ETHIOPIC SYLLABLE CU
      #x127A	;ETHIOPIC SYLLABLE CI
      #x127B	;ETHIOPIC SYLLABLE CAA
      #x127C	;ETHIOPIC SYLLABLE CEE
      #x127D	;ETHIOPIC SYLLABLE CE
      #x127E	;ETHIOPIC SYLLABLE CO
      #x127F	;ETHIOPIC SYLLABLE CWA
      #x1280	;ETHIOPIC SYLLABLE XA
      #x1281	;ETHIOPIC SYLLABLE XU
      #x1282	;ETHIOPIC SYLLABLE XI
      #x1283	;ETHIOPIC SYLLABLE XAA
      #x1284	;ETHIOPIC SYLLABLE XEE
      #x1285	;ETHIOPIC SYLLABLE XE
      #x1286	;ETHIOPIC SYLLABLE XO
      #x1288	;ETHIOPIC SYLLABLE XWA
      #x128A	;ETHIOPIC SYLLABLE XWI
      #x128B	;ETHIOPIC SYLLABLE XWAA
      #x128C	;ETHIOPIC SYLLABLE XWEE
      #x128D	;ETHIOPIC SYLLABLE XWE
      #x1290	;ETHIOPIC SYLLABLE NA
      #x1291	;ETHIOPIC SYLLABLE NU
      #x1292	;ETHIOPIC SYLLABLE NI
      #x1293	;ETHIOPIC SYLLABLE NAA
      #x1294	;ETHIOPIC SYLLABLE NEE
      #x1295	;ETHIOPIC SYLLABLE NE
      #x1296	;ETHIOPIC SYLLABLE NO
      #x1297	;ETHIOPIC SYLLABLE NWA
      #x1298	;ETHIOPIC SYLLABLE NYA
      #x1299	;ETHIOPIC SYLLABLE NYU
      #x129A	;ETHIOPIC SYLLABLE NYI
      #x129B	;ETHIOPIC SYLLABLE NYAA
      #x129C	;ETHIOPIC SYLLABLE NYEE
      #x129D	;ETHIOPIC SYLLABLE NYE
      #x129E	;ETHIOPIC SYLLABLE NYO
      #x129F	;ETHIOPIC SYLLABLE NYWA
      #x12A0	;ETHIOPIC SYLLABLE GLOTTAL A
      #x12A1	;ETHIOPIC SYLLABLE GLOTTAL U
      #x12A2	;ETHIOPIC SYLLABLE GLOTTAL I
      #x12A3	;ETHIOPIC SYLLABLE GLOTTAL AA
      #x12A4	;ETHIOPIC SYLLABLE GLOTTAL EE
      #x12A5	;ETHIOPIC SYLLABLE GLOTTAL E
      #x12A6	;ETHIOPIC SYLLABLE GLOTTAL O
      #x12A7	;ETHIOPIC SYLLABLE GLOTTAL WA
      #x12A8	;ETHIOPIC SYLLABLE KA
      #x12A9	;ETHIOPIC SYLLABLE KU
      #x12AA	;ETHIOPIC SYLLABLE KI
      #x12AB	;ETHIOPIC SYLLABLE KAA
      #x12AC	;ETHIOPIC SYLLABLE KEE
      #x12AD	;ETHIOPIC SYLLABLE KE
      #x12AE	;ETHIOPIC SYLLABLE KO
      #x12B0	;ETHIOPIC SYLLABLE KWA
      #x12B2	;ETHIOPIC SYLLABLE KWI
      #x12B3	;ETHIOPIC SYLLABLE KWAA
      #x12B4	;ETHIOPIC SYLLABLE KWEE
      #x12B5	;ETHIOPIC SYLLABLE KWE
      #x12B8	;ETHIOPIC SYLLABLE KXA
      #x12B9	;ETHIOPIC SYLLABLE KXU
      #x12BA	;ETHIOPIC SYLLABLE KXI
      #x12BB	;ETHIOPIC SYLLABLE KXAA
      #x12BC	;ETHIOPIC SYLLABLE KXEE
      #x12BD	;ETHIOPIC SYLLABLE KXE
      #x12BE	;ETHIOPIC SYLLABLE KXO
      #x12C0	;ETHIOPIC SYLLABLE KXWA
      #x12C2	;ETHIOPIC SYLLABLE KXWI
      #x12C3	;ETHIOPIC SYLLABLE KXWAA
      #x12C4	;ETHIOPIC SYLLABLE KXWEE
      #x12C5	;ETHIOPIC SYLLABLE KXWE
      #x12C8	;ETHIOPIC SYLLABLE WA
      #x12C9	;ETHIOPIC SYLLABLE WU
      #x12CA	;ETHIOPIC SYLLABLE WI
      #x12CB	;ETHIOPIC SYLLABLE WAA
      #x12CC	;ETHIOPIC SYLLABLE WEE
      #x12CD	;ETHIOPIC SYLLABLE WE
      #x12CE	;ETHIOPIC SYLLABLE WO
      #x12D0	;ETHIOPIC SYLLABLE PHARYNGEAL A
      #x12D1	;ETHIOPIC SYLLABLE PHARYNGEAL U
      #x12D2	;ETHIOPIC SYLLABLE PHARYNGEAL I
      #x12D3	;ETHIOPIC SYLLABLE PHARYNGEAL AA
      #x12D4	;ETHIOPIC SYLLABLE PHARYNGEAL EE
      #x12D5	;ETHIOPIC SYLLABLE PHARYNGEAL E
      #x12D6	;ETHIOPIC SYLLABLE PHARYNGEAL O
      #x12D8	;ETHIOPIC SYLLABLE ZA
      #x12D9	;ETHIOPIC SYLLABLE ZU
      #x12DA	;ETHIOPIC SYLLABLE ZI
      #x12DB	;ETHIOPIC SYLLABLE ZAA
      #x12DC	;ETHIOPIC SYLLABLE ZEE
      #x12DD	;ETHIOPIC SYLLABLE ZE
      #x12DE	;ETHIOPIC SYLLABLE ZO
      #x12DF	;ETHIOPIC SYLLABLE ZWA
      #x12E0	;ETHIOPIC SYLLABLE ZHA
      #x12E1	;ETHIOPIC SYLLABLE ZHU
      #x12E2	;ETHIOPIC SYLLABLE ZHI
      #x12E3	;ETHIOPIC SYLLABLE ZHAA
      #x12E4	;ETHIOPIC SYLLABLE ZHEE
      #x12E5	;ETHIOPIC SYLLABLE ZHE
      #x12E6	;ETHIOPIC SYLLABLE ZHO
      #x12E7	;ETHIOPIC SYLLABLE ZHWA
      #x12E8	;ETHIOPIC SYLLABLE YA
      #x12E9	;ETHIOPIC SYLLABLE YU
      #x12EA	;ETHIOPIC SYLLABLE YI
      #x12EB	;ETHIOPIC SYLLABLE YAA
      #x12EC	;ETHIOPIC SYLLABLE YEE
      #x12ED	;ETHIOPIC SYLLABLE YE
      #x12EE	;ETHIOPIC SYLLABLE YO
      #x12F0	;ETHIOPIC SYLLABLE DA
      #x12F1	;ETHIOPIC SYLLABLE DU
      #x12F2	;ETHIOPIC SYLLABLE DI
      #x12F3	;ETHIOPIC SYLLABLE DAA
      #x12F4	;ETHIOPIC SYLLABLE DEE
      #x12F5	;ETHIOPIC SYLLABLE DE
      #x12F6	;ETHIOPIC SYLLABLE DO
      #x12F7	;ETHIOPIC SYLLABLE DWA
      #x12F8	;ETHIOPIC SYLLABLE DDA
      #x12F9	;ETHIOPIC SYLLABLE DDU
      #x12FA	;ETHIOPIC SYLLABLE DDI
      #x12FB	;ETHIOPIC SYLLABLE DDAA
      #x12FC	;ETHIOPIC SYLLABLE DDEE
      #x12FD	;ETHIOPIC SYLLABLE DDE
      #x12FE	;ETHIOPIC SYLLABLE DDO
      #x12FF	;ETHIOPIC SYLLABLE DDWA
      #x1300	;ETHIOPIC SYLLABLE JA
      #x1301	;ETHIOPIC SYLLABLE JU
      #x1302	;ETHIOPIC SYLLABLE JI
      #x1303	;ETHIOPIC SYLLABLE JAA
      #x1304	;ETHIOPIC SYLLABLE JEE
      #x1305	;ETHIOPIC SYLLABLE JE
      #x1306	;ETHIOPIC SYLLABLE JO
      #x1307	;ETHIOPIC SYLLABLE JWA
      #x1308	;ETHIOPIC SYLLABLE GA
      #x1309	;ETHIOPIC SYLLABLE GU
      #x130A	;ETHIOPIC SYLLABLE GI
      #x130B	;ETHIOPIC SYLLABLE GAA
      #x130C	;ETHIOPIC SYLLABLE GEE
      #x130D	;ETHIOPIC SYLLABLE GE
      #x130E	;ETHIOPIC SYLLABLE GO
      #x1310	;ETHIOPIC SYLLABLE GWA
      #x1312	;ETHIOPIC SYLLABLE GWI
      #x1313	;ETHIOPIC SYLLABLE GWAA
      #x1314	;ETHIOPIC SYLLABLE GWEE
      #x1315	;ETHIOPIC SYLLABLE GWE
      #x1318	;ETHIOPIC SYLLABLE GGA
      #x1319	;ETHIOPIC SYLLABLE GGU
      #x131A	;ETHIOPIC SYLLABLE GGI
      #x131B	;ETHIOPIC SYLLABLE GGAA
      #x131C	;ETHIOPIC SYLLABLE GGEE
      #x131D	;ETHIOPIC SYLLABLE GGE
      #x131E	;ETHIOPIC SYLLABLE GGO
      #x1320	;ETHIOPIC SYLLABLE THA
      #x1321	;ETHIOPIC SYLLABLE THU
      #x1322	;ETHIOPIC SYLLABLE THI
      #x1323	;ETHIOPIC SYLLABLE THAA
      #x1324	;ETHIOPIC SYLLABLE THEE
      #x1325	;ETHIOPIC SYLLABLE THE
      #x1326	;ETHIOPIC SYLLABLE THO
      #x1327	;ETHIOPIC SYLLABLE THWA
      #x1328	;ETHIOPIC SYLLABLE CHA
      #x1329	;ETHIOPIC SYLLABLE CHU
      #x132A	;ETHIOPIC SYLLABLE CHI
      #x132B	;ETHIOPIC SYLLABLE CHAA
      #x132C	;ETHIOPIC SYLLABLE CHEE
      #x132D	;ETHIOPIC SYLLABLE CHE
      #x132E	;ETHIOPIC SYLLABLE CHO
      #x132F	;ETHIOPIC SYLLABLE CHWA
      #x1330	;ETHIOPIC SYLLABLE PHA
      #x1331	;ETHIOPIC SYLLABLE PHU
      #x1332	;ETHIOPIC SYLLABLE PHI
      #x1333	;ETHIOPIC SYLLABLE PHAA
      #x1334	;ETHIOPIC SYLLABLE PHEE
      #x1335	;ETHIOPIC SYLLABLE PHE
      #x1336	;ETHIOPIC SYLLABLE PHO
      #x1337	;ETHIOPIC SYLLABLE PHWA
      #x1338	;ETHIOPIC SYLLABLE TSA
      #x1339	;ETHIOPIC SYLLABLE TSU
      #x133A	;ETHIOPIC SYLLABLE TSI
      #x133B	;ETHIOPIC SYLLABLE TSAA
      #x133C	;ETHIOPIC SYLLABLE TSEE
      #x133D	;ETHIOPIC SYLLABLE TSE
      #x133E	;ETHIOPIC SYLLABLE TSO
      #x133F	;ETHIOPIC SYLLABLE TSWA
      #x1340	;ETHIOPIC SYLLABLE TZA
      #x1341	;ETHIOPIC SYLLABLE TZU
      #x1342	;ETHIOPIC SYLLABLE TZI
      #x1343	;ETHIOPIC SYLLABLE TZAA
      #x1344	;ETHIOPIC SYLLABLE TZEE
      #x1345	;ETHIOPIC SYLLABLE TZE
      #x1346	;ETHIOPIC SYLLABLE TZO
      #x1348	;ETHIOPIC SYLLABLE FA
      #x1349	;ETHIOPIC SYLLABLE FU
      #x134A	;ETHIOPIC SYLLABLE FI
      #x134B	;ETHIOPIC SYLLABLE FAA
      #x134C	;ETHIOPIC SYLLABLE FEE
      #x134D	;ETHIOPIC SYLLABLE FE
      #x134E	;ETHIOPIC SYLLABLE FO
      #x134F	;ETHIOPIC SYLLABLE FWA
      #x1350	;ETHIOPIC SYLLABLE PA
      #x1351	;ETHIOPIC SYLLABLE PU
      #x1352	;ETHIOPIC SYLLABLE PI
      #x1353	;ETHIOPIC SYLLABLE PAA
      #x1354	;ETHIOPIC SYLLABLE PEE
      #x1355	;ETHIOPIC SYLLABLE PE
      #x1356	;ETHIOPIC SYLLABLE PO
      #x1357	;ETHIOPIC SYLLABLE PWA
      #x1358	;ETHIOPIC SYLLABLE RYA
      #x1359	;ETHIOPIC SYLLABLE MYA
      #x135A	;ETHIOPIC SYLLABLE FYA
      #x13A0	;CHEROKEE LETTER A
      #x13A1	;CHEROKEE LETTER E
      #x13A2	;CHEROKEE LETTER I
      #x13A3	;CHEROKEE LETTER O
      #x13A4	;CHEROKEE LETTER U
      #x13A5	;CHEROKEE LETTER V
      #x13A6	;CHEROKEE LETTER GA
      #x13A7	;CHEROKEE LETTER KA
      #x13A8	;CHEROKEE LETTER GE
      #x13A9	;CHEROKEE LETTER GI
      #x13AA	;CHEROKEE LETTER GO
      #x13AB	;CHEROKEE LETTER GU
      #x13AC	;CHEROKEE LETTER GV
      #x13AD	;CHEROKEE LETTER HA
      #x13AE	;CHEROKEE LETTER HE
      #x13AF	;CHEROKEE LETTER HI
      #x13B0	;CHEROKEE LETTER HO
      #x13B1	;CHEROKEE LETTER HU
      #x13B2	;CHEROKEE LETTER HV
      #x13B3	;CHEROKEE LETTER LA
      #x13B4	;CHEROKEE LETTER LE
      #x13B5	;CHEROKEE LETTER LI
      #x13B6	;CHEROKEE LETTER LO
      #x13B7	;CHEROKEE LETTER LU
      #x13B8	;CHEROKEE LETTER LV
      #x13B9	;CHEROKEE LETTER MA
      #x13BA	;CHEROKEE LETTER ME
      #x13BB	;CHEROKEE LETTER MI
      #x13BC	;CHEROKEE LETTER MO
      #x13BD	;CHEROKEE LETTER MU
      #x13BE	;CHEROKEE LETTER NA
      #x13BF	;CHEROKEE LETTER HNA
      #x13C0	;CHEROKEE LETTER NAH
      #x13C1	;CHEROKEE LETTER NE
      #x13C2	;CHEROKEE LETTER NI
      #x13C3	;CHEROKEE LETTER NO
      #x13C4	;CHEROKEE LETTER NU
      #x13C5	;CHEROKEE LETTER NV
      #x13C6	;CHEROKEE LETTER QUA
      #x13C7	;CHEROKEE LETTER QUE
      #x13C8	;CHEROKEE LETTER QUI
      #x13C9	;CHEROKEE LETTER QUO
      #x13CA	;CHEROKEE LETTER QUU
      #x13CB	;CHEROKEE LETTER QUV
      #x13CC	;CHEROKEE LETTER SA
      #x13CD	;CHEROKEE LETTER S
      #x13CE	;CHEROKEE LETTER SE
      #x13CF	;CHEROKEE LETTER SI
      #x13D0	;CHEROKEE LETTER SO
      #x13D1	;CHEROKEE LETTER SU
      #x13D2	;CHEROKEE LETTER SV
      #x13D3	;CHEROKEE LETTER DA
      #x13D4	;CHEROKEE LETTER TA
      #x13D5	;CHEROKEE LETTER DE
      #x13D6	;CHEROKEE LETTER TE
      #x13D7	;CHEROKEE LETTER DI
      #x13D8	;CHEROKEE LETTER TI
      #x13D9	;CHEROKEE LETTER DO
      #x13DA	;CHEROKEE LETTER DU
      #x13DB	;CHEROKEE LETTER DV
      #x13DC	;CHEROKEE LETTER DLA
      #x13DD	;CHEROKEE LETTER TLA
      #x13DE	;CHEROKEE LETTER TLE
      #x13DF	;CHEROKEE LETTER TLI
      #x13E0	;CHEROKEE LETTER TLO
      #x13E1	;CHEROKEE LETTER TLU
      #x13E2	;CHEROKEE LETTER TLV
      #x13E3	;CHEROKEE LETTER TSA
      #x13E4	;CHEROKEE LETTER TSE
      #x13E5	;CHEROKEE LETTER TSI
      #x13E6	;CHEROKEE LETTER TSO
      #x13E7	;CHEROKEE LETTER TSU
      #x13E8	;CHEROKEE LETTER TSV
      #x13E9	;CHEROKEE LETTER WA
      #x13EA	;CHEROKEE LETTER WE
      #x13EB	;CHEROKEE LETTER WI
      #x13EC	;CHEROKEE LETTER WO
      #x13ED	;CHEROKEE LETTER WU
      #x13EE	;CHEROKEE LETTER WV
      #x13EF	;CHEROKEE LETTER YA
      #x13F0	;CHEROKEE LETTER YE
      #x13F1	;CHEROKEE LETTER YI
      #x13F2	;CHEROKEE LETTER YO
      #x13F3	;CHEROKEE LETTER YU
      #x13F4	;CHEROKEE LETTER YV
      #x1401	;CANADIAN SYLLABICS E
      #x1402	;CANADIAN SYLLABICS AAI
      #x1403	;CANADIAN SYLLABICS I
      #x1404	;CANADIAN SYLLABICS II
      #x1405	;CANADIAN SYLLABICS O
      #x1406	;CANADIAN SYLLABICS OO
      #x1407	;CANADIAN SYLLABICS Y-CREE OO
      #x1408	;CANADIAN SYLLABICS CARRIER EE
      #x1409	;CANADIAN SYLLABICS CARRIER I
      #x140A	;CANADIAN SYLLABICS A
      #x140B	;CANADIAN SYLLABICS AA
      #x140C	;CANADIAN SYLLABICS WE
      #x140D	;CANADIAN SYLLABICS WEST-CREE WE
      #x140E	;CANADIAN SYLLABICS WI
      #x140F	;CANADIAN SYLLABICS WEST-CREE WI
      #x1410	;CANADIAN SYLLABICS WII
      #x1411	;CANADIAN SYLLABICS WEST-CREE WII
      #x1412	;CANADIAN SYLLABICS WO
      #x1413	;CANADIAN SYLLABICS WEST-CREE WO
      #x1414	;CANADIAN SYLLABICS WOO
      #x1415	;CANADIAN SYLLABICS WEST-CREE WOO
      #x1416	;CANADIAN SYLLABICS NASKAPI WOO
      #x1417	;CANADIAN SYLLABICS WA
      #x1418	;CANADIAN SYLLABICS WEST-CREE WA
      #x1419	;CANADIAN SYLLABICS WAA
      #x141A	;CANADIAN SYLLABICS WEST-CREE WAA
      #x141B	;CANADIAN SYLLABICS NASKAPI WAA
      #x141C	;CANADIAN SYLLABICS AI
      #x141D	;CANADIAN SYLLABICS Y-CREE W
      #x141E	;CANADIAN SYLLABICS GLOTTAL STOP
      #x141F	;CANADIAN SYLLABICS FINAL ACUTE
      #x1420	;CANADIAN SYLLABICS FINAL GRAVE
      #x1421	;CANADIAN SYLLABICS FINAL BOTTOM HALF RING
      #x1422	;CANADIAN SYLLABICS FINAL TOP HALF RING
      #x1423	;CANADIAN SYLLABICS FINAL RIGHT HALF RING
      #x1424	;CANADIAN SYLLABICS FINAL RING
      #x1425	;CANADIAN SYLLABICS FINAL DOUBLE ACUTE
      #x1426	;CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES
      #x1427	;CANADIAN SYLLABICS FINAL MIDDLE DOT
      #x1428	;CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE
      #x1429	;CANADIAN SYLLABICS FINAL PLUS
      #x142A	;CANADIAN SYLLABICS FINAL DOWN TACK
      #x142B	;CANADIAN SYLLABICS EN
      #x142C	;CANADIAN SYLLABICS IN
      #x142D	;CANADIAN SYLLABICS ON
      #x142E	;CANADIAN SYLLABICS AN
      #x142F	;CANADIAN SYLLABICS PE
      #x1430	;CANADIAN SYLLABICS PAAI
      #x1431	;CANADIAN SYLLABICS PI
      #x1432	;CANADIAN SYLLABICS PII
      #x1433	;CANADIAN SYLLABICS PO
      #x1434	;CANADIAN SYLLABICS POO
      #x1435	;CANADIAN SYLLABICS Y-CREE POO
      #x1436	;CANADIAN SYLLABICS CARRIER HEE
      #x1437	;CANADIAN SYLLABICS CARRIER HI
      #x1438	;CANADIAN SYLLABICS PA
      #x1439	;CANADIAN SYLLABICS PAA
      #x143A	;CANADIAN SYLLABICS PWE
      #x143B	;CANADIAN SYLLABICS WEST-CREE PWE
      #x143C	;CANADIAN SYLLABICS PWI
      #x143D	;CANADIAN SYLLABICS WEST-CREE PWI
      #x143E	;CANADIAN SYLLABICS PWII
      #x143F	;CANADIAN SYLLABICS WEST-CREE PWII
      #x1440	;CANADIAN SYLLABICS PWO
      #x1441	;CANADIAN SYLLABICS WEST-CREE PWO
      #x1442	;CANADIAN SYLLABICS PWOO
      #x1443	;CANADIAN SYLLABICS WEST-CREE PWOO
      #x1444	;CANADIAN SYLLABICS PWA
      #x1445	;CANADIAN SYLLABICS WEST-CREE PWA
      #x1446	;CANADIAN SYLLABICS PWAA
      #x1447	;CANADIAN SYLLABICS WEST-CREE PWAA
      #x1448	;CANADIAN SYLLABICS Y-CREE PWAA
      #x1449	;CANADIAN SYLLABICS P
      #x144A	;CANADIAN SYLLABICS WEST-CREE P
      #x144B	;CANADIAN SYLLABICS CARRIER H
      #x144C	;CANADIAN SYLLABICS TE
      #x144D	;CANADIAN SYLLABICS TAAI
      #x144E	;CANADIAN SYLLABICS TI
      #x144F	;CANADIAN SYLLABICS TII
      #x1450	;CANADIAN SYLLABICS TO
      #x1451	;CANADIAN SYLLABICS TOO
      #x1452	;CANADIAN SYLLABICS Y-CREE TOO
      #x1453	;CANADIAN SYLLABICS CARRIER DEE
      #x1454	;CANADIAN SYLLABICS CARRIER DI
      #x1455	;CANADIAN SYLLABICS TA
      #x1456	;CANADIAN SYLLABICS TAA
      #x1457	;CANADIAN SYLLABICS TWE
      #x1458	;CANADIAN SYLLABICS WEST-CREE TWE
      #x1459	;CANADIAN SYLLABICS TWI
      #x145A	;CANADIAN SYLLABICS WEST-CREE TWI
      #x145B	;CANADIAN SYLLABICS TWII
      #x145C	;CANADIAN SYLLABICS WEST-CREE TWII
      #x145D	;CANADIAN SYLLABICS TWO
      #x145E	;CANADIAN SYLLABICS WEST-CREE TWO
      #x145F	;CANADIAN SYLLABICS TWOO
      #x1460	;CANADIAN SYLLABICS WEST-CREE TWOO
      #x1461	;CANADIAN SYLLABICS TWA
      #x1462	;CANADIAN SYLLABICS WEST-CREE TWA
      #x1463	;CANADIAN SYLLABICS TWAA
      #x1464	;CANADIAN SYLLABICS WEST-CREE TWAA
      #x1465	;CANADIAN SYLLABICS NASKAPI TWAA
      #x1466	;CANADIAN SYLLABICS T
      #x1467	;CANADIAN SYLLABICS TTE
      #x1468	;CANADIAN SYLLABICS TTI
      #x1469	;CANADIAN SYLLABICS TTO
      #x146A	;CANADIAN SYLLABICS TTA
      #x146B	;CANADIAN SYLLABICS KE
      #x146C	;CANADIAN SYLLABICS KAAI
      #x146D	;CANADIAN SYLLABICS KI
      #x146E	;CANADIAN SYLLABICS KII
      #x146F	;CANADIAN SYLLABICS KO
      #x1470	;CANADIAN SYLLABICS KOO
      #x1471	;CANADIAN SYLLABICS Y-CREE KOO
      #x1472	;CANADIAN SYLLABICS KA
      #x1473	;CANADIAN SYLLABICS KAA
      #x1474	;CANADIAN SYLLABICS KWE
      #x1475	;CANADIAN SYLLABICS WEST-CREE KWE
      #x1476	;CANADIAN SYLLABICS KWI
      #x1477	;CANADIAN SYLLABICS WEST-CREE KWI
      #x1478	;CANADIAN SYLLABICS KWII
      #x1479	;CANADIAN SYLLABICS WEST-CREE KWII
      #x147A	;CANADIAN SYLLABICS KWO
      #x147B	;CANADIAN SYLLABICS WEST-CREE KWO
      #x147C	;CANADIAN SYLLABICS KWOO
      #x147D	;CANADIAN SYLLABICS WEST-CREE KWOO
      #x147E	;CANADIAN SYLLABICS KWA
      #x147F	;CANADIAN SYLLABICS WEST-CREE KWA
      #x1480	;CANADIAN SYLLABICS KWAA
      #x1481	;CANADIAN SYLLABICS WEST-CREE KWAA
      #x1482	;CANADIAN SYLLABICS NASKAPI KWAA
      #x1483	;CANADIAN SYLLABICS K
      #x1484	;CANADIAN SYLLABICS KW
      #x1485	;CANADIAN SYLLABICS SOUTH-SLAVEY KEH
      #x1486	;CANADIAN SYLLABICS SOUTH-SLAVEY KIH
      #x1487	;CANADIAN SYLLABICS SOUTH-SLAVEY KOH
      #x1488	;CANADIAN SYLLABICS SOUTH-SLAVEY KAH
      #x1489	;CANADIAN SYLLABICS CE
      #x148A	;CANADIAN SYLLABICS CAAI
      #x148B	;CANADIAN SYLLABICS CI
      #x148C	;CANADIAN SYLLABICS CII
      #x148D	;CANADIAN SYLLABICS CO
      #x148E	;CANADIAN SYLLABICS COO
      #x148F	;CANADIAN SYLLABICS Y-CREE COO
      #x1490	;CANADIAN SYLLABICS CA
      #x1491	;CANADIAN SYLLABICS CAA
      #x1492	;CANADIAN SYLLABICS CWE
      #x1493	;CANADIAN SYLLABICS WEST-CREE CWE
      #x1494	;CANADIAN SYLLABICS CWI
      #x1495	;CANADIAN SYLLABICS WEST-CREE CWI
      #x1496	;CANADIAN SYLLABICS CWII
      #x1497	;CANADIAN SYLLABICS WEST-CREE CWII
      #x1498	;CANADIAN SYLLABICS CWO
      #x1499	;CANADIAN SYLLABICS WEST-CREE CWO
      #x149A	;CANADIAN SYLLABICS CWOO
      #x149B	;CANADIAN SYLLABICS WEST-CREE CWOO
      #x149C	;CANADIAN SYLLABICS CWA
      #x149D	;CANADIAN SYLLABICS WEST-CREE CWA
      #x149E	;CANADIAN SYLLABICS CWAA
      #x149F	;CANADIAN SYLLABICS WEST-CREE CWAA
      #x14A0	;CANADIAN SYLLABICS NASKAPI CWAA
      #x14A1	;CANADIAN SYLLABICS C
      #x14A2	;CANADIAN SYLLABICS SAYISI TH
      #x14A3	;CANADIAN SYLLABICS ME
      #x14A4	;CANADIAN SYLLABICS MAAI
      #x14A5	;CANADIAN SYLLABICS MI
      #x14A6	;CANADIAN SYLLABICS MII
      #x14A7	;CANADIAN SYLLABICS MO
      #x14A8	;CANADIAN SYLLABICS MOO
      #x14A9	;CANADIAN SYLLABICS Y-CREE MOO
      #x14AA	;CANADIAN SYLLABICS MA
      #x14AB	;CANADIAN SYLLABICS MAA
      #x14AC	;CANADIAN SYLLABICS MWE
      #x14AD	;CANADIAN SYLLABICS WEST-CREE MWE
      #x14AE	;CANADIAN SYLLABICS MWI
      #x14AF	;CANADIAN SYLLABICS WEST-CREE MWI
      #x14B0	;CANADIAN SYLLABICS MWII
      #x14B1	;CANADIAN SYLLABICS WEST-CREE MWII
      #x14B2	;CANADIAN SYLLABICS MWO
      #x14B3	;CANADIAN SYLLABICS WEST-CREE MWO
      #x14B4	;CANADIAN SYLLABICS MWOO
      #x14B5	;CANADIAN SYLLABICS WEST-CREE MWOO
      #x14B6	;CANADIAN SYLLABICS MWA
      #x14B7	;CANADIAN SYLLABICS WEST-CREE MWA
      #x14B8	;CANADIAN SYLLABICS MWAA
      #x14B9	;CANADIAN SYLLABICS WEST-CREE MWAA
      #x14BA	;CANADIAN SYLLABICS NASKAPI MWAA
      #x14BB	;CANADIAN SYLLABICS M
      #x14BC	;CANADIAN SYLLABICS WEST-CREE M
      #x14BD	;CANADIAN SYLLABICS MH
      #x14BE	;CANADIAN SYLLABICS ATHAPASCAN M
      #x14BF	;CANADIAN SYLLABICS SAYISI M
      #x14C0	;CANADIAN SYLLABICS NE
      #x14C1	;CANADIAN SYLLABICS NAAI
      #x14C2	;CANADIAN SYLLABICS NI
      #x14C3	;CANADIAN SYLLABICS NII
      #x14C4	;CANADIAN SYLLABICS NO
      #x14C5	;CANADIAN SYLLABICS NOO
      #x14C6	;CANADIAN SYLLABICS Y-CREE NOO
      #x14C7	;CANADIAN SYLLABICS NA
      #x14C8	;CANADIAN SYLLABICS NAA
      #x14C9	;CANADIAN SYLLABICS NWE
      #x14CA	;CANADIAN SYLLABICS WEST-CREE NWE
      #x14CB	;CANADIAN SYLLABICS NWA
      #x14CC	;CANADIAN SYLLABICS WEST-CREE NWA
      #x14CD	;CANADIAN SYLLABICS NWAA
      #x14CE	;CANADIAN SYLLABICS WEST-CREE NWAA
      #x14CF	;CANADIAN SYLLABICS NASKAPI NWAA
      #x14D0	;CANADIAN SYLLABICS N
      #x14D1	;CANADIAN SYLLABICS CARRIER NG
      #x14D2	;CANADIAN SYLLABICS NH
      #x14D3	;CANADIAN SYLLABICS LE
      #x14D4	;CANADIAN SYLLABICS LAAI
      #x14D5	;CANADIAN SYLLABICS LI
      #x14D6	;CANADIAN SYLLABICS LII
      #x14D7	;CANADIAN SYLLABICS LO
      #x14D8	;CANADIAN SYLLABICS LOO
      #x14D9	;CANADIAN SYLLABICS Y-CREE LOO
      #x14DA	;CANADIAN SYLLABICS LA
      #x14DB	;CANADIAN SYLLABICS LAA
      #x14DC	;CANADIAN SYLLABICS LWE
      #x14DD	;CANADIAN SYLLABICS WEST-CREE LWE
      #x14DE	;CANADIAN SYLLABICS LWI
      #x14DF	;CANADIAN SYLLABICS WEST-CREE LWI
      #x14E0	;CANADIAN SYLLABICS LWII
      #x14E1	;CANADIAN SYLLABICS WEST-CREE LWII
      #x14E2	;CANADIAN SYLLABICS LWO
      #x14E3	;CANADIAN SYLLABICS WEST-CREE LWO
      #x14E4	;CANADIAN SYLLABICS LWOO
      #x14E5	;CANADIAN SYLLABICS WEST-CREE LWOO
      #x14E6	;CANADIAN SYLLABICS LWA
      #x14E7	;CANADIAN SYLLABICS WEST-CREE LWA
      #x14E8	;CANADIAN SYLLABICS LWAA
      #x14E9	;CANADIAN SYLLABICS WEST-CREE LWAA
      #x14EA	;CANADIAN SYLLABICS L
      #x14EB	;CANADIAN SYLLABICS WEST-CREE L
      #x14EC	;CANADIAN SYLLABICS MEDIAL L
      #x14ED	;CANADIAN SYLLABICS SE
      #x14EE	;CANADIAN SYLLABICS SAAI
      #x14EF	;CANADIAN SYLLABICS SI
      #x14F0	;CANADIAN SYLLABICS SII
      #x14F1	;CANADIAN SYLLABICS SO
      #x14F2	;CANADIAN SYLLABICS SOO
      #x14F3	;CANADIAN SYLLABICS Y-CREE SOO
      #x14F4	;CANADIAN SYLLABICS SA
      #x14F5	;CANADIAN SYLLABICS SAA
      #x14F6	;CANADIAN SYLLABICS SWE
      #x14F7	;CANADIAN SYLLABICS WEST-CREE SWE
      #x14F8	;CANADIAN SYLLABICS SWI
      #x14F9	;CANADIAN SYLLABICS WEST-CREE SWI
      #x14FA	;CANADIAN SYLLABICS SWII
      #x14FB	;CANADIAN SYLLABICS WEST-CREE SWII
      #x14FC	;CANADIAN SYLLABICS SWO
      #x14FD	;CANADIAN SYLLABICS WEST-CREE SWO
      #x14FE	;CANADIAN SYLLABICS SWOO
      #x14FF	;CANADIAN SYLLABICS WEST-CREE SWOO
      #x1500	;CANADIAN SYLLABICS SWA
      #x1501	;CANADIAN SYLLABICS WEST-CREE SWA
      #x1502	;CANADIAN SYLLABICS SWAA
      #x1503	;CANADIAN SYLLABICS WEST-CREE SWAA
      #x1504	;CANADIAN SYLLABICS NASKAPI SWAA
      #x1505	;CANADIAN SYLLABICS S
      #x1506	;CANADIAN SYLLABICS ATHAPASCAN S
      #x1507	;CANADIAN SYLLABICS SW
      #x1508	;CANADIAN SYLLABICS BLACKFOOT S
      #x1509	;CANADIAN SYLLABICS MOOSE-CREE SK
      #x150A	;CANADIAN SYLLABICS NASKAPI SKW
      #x150B	;CANADIAN SYLLABICS NASKAPI S-W
      #x150C	;CANADIAN SYLLABICS NASKAPI SPWA
      #x150D	;CANADIAN SYLLABICS NASKAPI STWA
      #x150E	;CANADIAN SYLLABICS NASKAPI SKWA
      #x150F	;CANADIAN SYLLABICS NASKAPI SCWA
      #x1510	;CANADIAN SYLLABICS SHE
      #x1511	;CANADIAN SYLLABICS SHI
      #x1512	;CANADIAN SYLLABICS SHII
      #x1513	;CANADIAN SYLLABICS SHO
      #x1514	;CANADIAN SYLLABICS SHOO
      #x1515	;CANADIAN SYLLABICS SHA
      #x1516	;CANADIAN SYLLABICS SHAA
      #x1517	;CANADIAN SYLLABICS SHWE
      #x1518	;CANADIAN SYLLABICS WEST-CREE SHWE
      #x1519	;CANADIAN SYLLABICS SHWI
      #x151A	;CANADIAN SYLLABICS WEST-CREE SHWI
      #x151B	;CANADIAN SYLLABICS SHWII
      #x151C	;CANADIAN SYLLABICS WEST-CREE SHWII
      #x151D	;CANADIAN SYLLABICS SHWO
      #x151E	;CANADIAN SYLLABICS WEST-CREE SHWO
      #x151F	;CANADIAN SYLLABICS SHWOO
      #x1520	;CANADIAN SYLLABICS WEST-CREE SHWOO
      #x1521	;CANADIAN SYLLABICS SHWA
      #x1522	;CANADIAN SYLLABICS WEST-CREE SHWA
      #x1523	;CANADIAN SYLLABICS SHWAA
      #x1524	;CANADIAN SYLLABICS WEST-CREE SHWAA
      #x1525	;CANADIAN SYLLABICS SH
      #x1526	;CANADIAN SYLLABICS YE
      #x1527	;CANADIAN SYLLABICS YAAI
      #x1528	;CANADIAN SYLLABICS YI
      #x1529	;CANADIAN SYLLABICS YII
      #x152A	;CANADIAN SYLLABICS YO
      #x152B	;CANADIAN SYLLABICS YOO
      #x152C	;CANADIAN SYLLABICS Y-CREE YOO
      #x152D	;CANADIAN SYLLABICS YA
      #x152E	;CANADIAN SYLLABICS YAA
      #x152F	;CANADIAN SYLLABICS YWE
      #x1530	;CANADIAN SYLLABICS WEST-CREE YWE
      #x1531	;CANADIAN SYLLABICS YWI
      #x1532	;CANADIAN SYLLABICS WEST-CREE YWI
      #x1533	;CANADIAN SYLLABICS YWII
      #x1534	;CANADIAN SYLLABICS WEST-CREE YWII
      #x1535	;CANADIAN SYLLABICS YWO
      #x1536	;CANADIAN SYLLABICS WEST-CREE YWO
      #x1537	;CANADIAN SYLLABICS YWOO
      #x1538	;CANADIAN SYLLABICS WEST-CREE YWOO
      #x1539	;CANADIAN SYLLABICS YWA
      #x153A	;CANADIAN SYLLABICS WEST-CREE YWA
      #x153B	;CANADIAN SYLLABICS YWAA
      #x153C	;CANADIAN SYLLABICS WEST-CREE YWAA
      #x153D	;CANADIAN SYLLABICS NASKAPI YWAA
      #x153E	;CANADIAN SYLLABICS Y
      #x153F	;CANADIAN SYLLABICS BIBLE-CREE Y
      #x1540	;CANADIAN SYLLABICS WEST-CREE Y
      #x1541	;CANADIAN SYLLABICS SAYISI YI
      #x1542	;CANADIAN SYLLABICS RE
      #x1543	;CANADIAN SYLLABICS R-CREE RE
      #x1544	;CANADIAN SYLLABICS WEST-CREE LE
      #x1545	;CANADIAN SYLLABICS RAAI
      #x1546	;CANADIAN SYLLABICS RI
      #x1547	;CANADIAN SYLLABICS RII
      #x1548	;CANADIAN SYLLABICS RO
      #x1549	;CANADIAN SYLLABICS ROO
      #x154A	;CANADIAN SYLLABICS WEST-CREE LO
      #x154B	;CANADIAN SYLLABICS RA
      #x154C	;CANADIAN SYLLABICS RAA
      #x154D	;CANADIAN SYLLABICS WEST-CREE LA
      #x154E	;CANADIAN SYLLABICS RWAA
      #x154F	;CANADIAN SYLLABICS WEST-CREE RWAA
      #x1550	;CANADIAN SYLLABICS R
      #x1551	;CANADIAN SYLLABICS WEST-CREE R
      #x1552	;CANADIAN SYLLABICS MEDIAL R
      #x1553	;CANADIAN SYLLABICS FE
      #x1554	;CANADIAN SYLLABICS FAAI
      #x1555	;CANADIAN SYLLABICS FI
      #x1556	;CANADIAN SYLLABICS FII
      #x1557	;CANADIAN SYLLABICS FO
      #x1558	;CANADIAN SYLLABICS FOO
      #x1559	;CANADIAN SYLLABICS FA
      #x155A	;CANADIAN SYLLABICS FAA
      #x155B	;CANADIAN SYLLABICS FWAA
      #x155C	;CANADIAN SYLLABICS WEST-CREE FWAA
      #x155D	;CANADIAN SYLLABICS F
      #x155E	;CANADIAN SYLLABICS THE
      #x155F	;CANADIAN SYLLABICS N-CREE THE
      #x1560	;CANADIAN SYLLABICS THI
      #x1561	;CANADIAN SYLLABICS N-CREE THI
      #x1562	;CANADIAN SYLLABICS THII
      #x1563	;CANADIAN SYLLABICS N-CREE THII
      #x1564	;CANADIAN SYLLABICS THO
      #x1565	;CANADIAN SYLLABICS THOO
      #x1566	;CANADIAN SYLLABICS THA
      #x1567	;CANADIAN SYLLABICS THAA
      #x1568	;CANADIAN SYLLABICS THWAA
      #x1569	;CANADIAN SYLLABICS WEST-CREE THWAA
      #x156A	;CANADIAN SYLLABICS TH
      #x156B	;CANADIAN SYLLABICS TTHE
      #x156C	;CANADIAN SYLLABICS TTHI
      #x156D	;CANADIAN SYLLABICS TTHO
      #x156E	;CANADIAN SYLLABICS TTHA
      #x156F	;CANADIAN SYLLABICS TTH
      #x1570	;CANADIAN SYLLABICS TYE
      #x1571	;CANADIAN SYLLABICS TYI
      #x1572	;CANADIAN SYLLABICS TYO
      #x1573	;CANADIAN SYLLABICS TYA
      #x1574	;CANADIAN SYLLABICS NUNAVIK HE
      #x1575	;CANADIAN SYLLABICS NUNAVIK HI
      #x1576	;CANADIAN SYLLABICS NUNAVIK HII
      #x1577	;CANADIAN SYLLABICS NUNAVIK HO
      #x1578	;CANADIAN SYLLABICS NUNAVIK HOO
      #x1579	;CANADIAN SYLLABICS NUNAVIK HA
      #x157A	;CANADIAN SYLLABICS NUNAVIK HAA
      #x157B	;CANADIAN SYLLABICS NUNAVIK H
      #x157C	;CANADIAN SYLLABICS NUNAVUT H
      #x157D	;CANADIAN SYLLABICS HK
      #x157E	;CANADIAN SYLLABICS QAAI
      #x157F	;CANADIAN SYLLABICS QI
      #x1580	;CANADIAN SYLLABICS QII
      #x1581	;CANADIAN SYLLABICS QO
      #x1582	;CANADIAN SYLLABICS QOO
      #x1583	;CANADIAN SYLLABICS QA
      #x1584	;CANADIAN SYLLABICS QAA
      #x1585	;CANADIAN SYLLABICS Q
      #x1586	;CANADIAN SYLLABICS TLHE
      #x1587	;CANADIAN SYLLABICS TLHI
      #x1588	;CANADIAN SYLLABICS TLHO
      #x1589	;CANADIAN SYLLABICS TLHA
      #x158A	;CANADIAN SYLLABICS WEST-CREE RE
      #x158B	;CANADIAN SYLLABICS WEST-CREE RI
      #x158C	;CANADIAN SYLLABICS WEST-CREE RO
      #x158D	;CANADIAN SYLLABICS WEST-CREE RA
      #x158E	;CANADIAN SYLLABICS NGAAI
      #x158F	;CANADIAN SYLLABICS NGI
      #x1590	;CANADIAN SYLLABICS NGII
      #x1591	;CANADIAN SYLLABICS NGO
      #x1592	;CANADIAN SYLLABICS NGOO
      #x1593	;CANADIAN SYLLABICS NGA
      #x1594	;CANADIAN SYLLABICS NGAA
      #x1595	;CANADIAN SYLLABICS NG
      #x1596	;CANADIAN SYLLABICS NNG
      #x1597	;CANADIAN SYLLABICS SAYISI SHE
      #x1598	;CANADIAN SYLLABICS SAYISI SHI
      #x1599	;CANADIAN SYLLABICS SAYISI SHO
      #x159A	;CANADIAN SYLLABICS SAYISI SHA
      #x159B	;CANADIAN SYLLABICS WOODS-CREE THE
      #x159C	;CANADIAN SYLLABICS WOODS-CREE THI
      #x159D	;CANADIAN SYLLABICS WOODS-CREE THO
      #x159E	;CANADIAN SYLLABICS WOODS-CREE THA
      #x159F	;CANADIAN SYLLABICS WOODS-CREE TH
      #x15A0	;CANADIAN SYLLABICS LHI
      #x15A1	;CANADIAN SYLLABICS LHII
      #x15A2	;CANADIAN SYLLABICS LHO
      #x15A3	;CANADIAN SYLLABICS LHOO
      #x15A4	;CANADIAN SYLLABICS LHA
      #x15A5	;CANADIAN SYLLABICS LHAA
      #x15A6	;CANADIAN SYLLABICS LH
      #x15A7	;CANADIAN SYLLABICS TH-CREE THE
      #x15A8	;CANADIAN SYLLABICS TH-CREE THI
      #x15A9	;CANADIAN SYLLABICS TH-CREE THII
      #x15AA	;CANADIAN SYLLABICS TH-CREE THO
      #x15AB	;CANADIAN SYLLABICS TH-CREE THOO
      #x15AC	;CANADIAN SYLLABICS TH-CREE THA
      #x15AD	;CANADIAN SYLLABICS TH-CREE THAA
      #x15AE	;CANADIAN SYLLABICS TH-CREE TH
      #x15AF	;CANADIAN SYLLABICS AIVILIK B
      #x15B0	;CANADIAN SYLLABICS BLACKFOOT E
      #x15B1	;CANADIAN SYLLABICS BLACKFOOT I
      #x15B2	;CANADIAN SYLLABICS BLACKFOOT O
      #x15B3	;CANADIAN SYLLABICS BLACKFOOT A
      #x15B4	;CANADIAN SYLLABICS BLACKFOOT WE
      #x15B5	;CANADIAN SYLLABICS BLACKFOOT WI
      #x15B6	;CANADIAN SYLLABICS BLACKFOOT WO
      #x15B7	;CANADIAN SYLLABICS BLACKFOOT WA
      #x15B8	;CANADIAN SYLLABICS BLACKFOOT NE
      #x15B9	;CANADIAN SYLLABICS BLACKFOOT NI
      #x15BA	;CANADIAN SYLLABICS BLACKFOOT NO
      #x15BB	;CANADIAN SYLLABICS BLACKFOOT NA
      #x15BC	;CANADIAN SYLLABICS BLACKFOOT KE
      #x15BD	;CANADIAN SYLLABICS BLACKFOOT KI
      #x15BE	;CANADIAN SYLLABICS BLACKFOOT KO
      #x15BF	;CANADIAN SYLLABICS BLACKFOOT KA
      #x15C0	;CANADIAN SYLLABICS SAYISI HE
      #x15C1	;CANADIAN SYLLABICS SAYISI HI
      #x15C2	;CANADIAN SYLLABICS SAYISI HO
      #x15C3	;CANADIAN SYLLABICS SAYISI HA
      #x15C4	;CANADIAN SYLLABICS CARRIER GHU
      #x15C5	;CANADIAN SYLLABICS CARRIER GHO
      #x15C6	;CANADIAN SYLLABICS CARRIER GHE
      #x15C7	;CANADIAN SYLLABICS CARRIER GHEE
      #x15C8	;CANADIAN SYLLABICS CARRIER GHI
      #x15C9	;CANADIAN SYLLABICS CARRIER GHA
      #x15CA	;CANADIAN SYLLABICS CARRIER RU
      #x15CB	;CANADIAN SYLLABICS CARRIER RO
      #x15CC	;CANADIAN SYLLABICS CARRIER RE
      #x15CD	;CANADIAN SYLLABICS CARRIER REE
      #x15CE	;CANADIAN SYLLABICS CARRIER RI
      #x15CF	;CANADIAN SYLLABICS CARRIER RA
      #x15D0	;CANADIAN SYLLABICS CARRIER WU
      #x15D1	;CANADIAN SYLLABICS CARRIER WO
      #x15D2	;CANADIAN SYLLABICS CARRIER WE
      #x15D3	;CANADIAN SYLLABICS CARRIER WEE
      #x15D4	;CANADIAN SYLLABICS CARRIER WI
      #x15D5	;CANADIAN SYLLABICS CARRIER WA
      #x15D6	;CANADIAN SYLLABICS CARRIER HWU
      #x15D7	;CANADIAN SYLLABICS CARRIER HWO
      #x15D8	;CANADIAN SYLLABICS CARRIER HWE
      #x15D9	;CANADIAN SYLLABICS CARRIER HWEE
      #x15DA	;CANADIAN SYLLABICS CARRIER HWI
      #x15DB	;CANADIAN SYLLABICS CARRIER HWA
      #x15DC	;CANADIAN SYLLABICS CARRIER THU
      #x15DD	;CANADIAN SYLLABICS CARRIER THO
      #x15DE	;CANADIAN SYLLABICS CARRIER THE
      #x15DF	;CANADIAN SYLLABICS CARRIER THEE
      #x15E0	;CANADIAN SYLLABICS CARRIER THI
      #x15E1	;CANADIAN SYLLABICS CARRIER THA
      #x15E2	;CANADIAN SYLLABICS CARRIER TTU
      #x15E3	;CANADIAN SYLLABICS CARRIER TTO
      #x15E4	;CANADIAN SYLLABICS CARRIER TTE
      #x15E5	;CANADIAN SYLLABICS CARRIER TTEE
      #x15E6	;CANADIAN SYLLABICS CARRIER TTI
      #x15E7	;CANADIAN SYLLABICS CARRIER TTA
      #x15E8	;CANADIAN SYLLABICS CARRIER PU
      #x15E9	;CANADIAN SYLLABICS CARRIER PO
      #x15EA	;CANADIAN SYLLABICS CARRIER PE
      #x15EB	;CANADIAN SYLLABICS CARRIER PEE
      #x15EC	;CANADIAN SYLLABICS CARRIER PI
      #x15ED	;CANADIAN SYLLABICS CARRIER PA
      #x15EE	;CANADIAN SYLLABICS CARRIER P
      #x15EF	;CANADIAN SYLLABICS CARRIER GU
      #x15F0	;CANADIAN SYLLABICS CARRIER GO
      #x15F1	;CANADIAN SYLLABICS CARRIER GE
      #x15F2	;CANADIAN SYLLABICS CARRIER GEE
      #x15F3	;CANADIAN SYLLABICS CARRIER GI
      #x15F4	;CANADIAN SYLLABICS CARRIER GA
      #x15F5	;CANADIAN SYLLABICS CARRIER KHU
      #x15F6	;CANADIAN SYLLABICS CARRIER KHO
      #x15F7	;CANADIAN SYLLABICS CARRIER KHE
      #x15F8	;CANADIAN SYLLABICS CARRIER KHEE
      #x15F9	;CANADIAN SYLLABICS CARRIER KHI
      #x15FA	;CANADIAN SYLLABICS CARRIER KHA
      #x15FB	;CANADIAN SYLLABICS CARRIER KKU
      #x15FC	;CANADIAN SYLLABICS CARRIER KKO
      #x15FD	;CANADIAN SYLLABICS CARRIER KKE
      #x15FE	;CANADIAN SYLLABICS CARRIER KKEE
      #x15FF	;CANADIAN SYLLABICS CARRIER KKI
      #x1600	;CANADIAN SYLLABICS CARRIER KKA
      #x1601	;CANADIAN SYLLABICS CARRIER KK
      #x1602	;CANADIAN SYLLABICS CARRIER NU
      #x1603	;CANADIAN SYLLABICS CARRIER NO
      #x1604	;CANADIAN SYLLABICS CARRIER NE
      #x1605	;CANADIAN SYLLABICS CARRIER NEE
      #x1606	;CANADIAN SYLLABICS CARRIER NI
      #x1607	;CANADIAN SYLLABICS CARRIER NA
      #x1608	;CANADIAN SYLLABICS CARRIER MU
      #x1609	;CANADIAN SYLLABICS CARRIER MO
      #x160A	;CANADIAN SYLLABICS CARRIER ME
      #x160B	;CANADIAN SYLLABICS CARRIER MEE
      #x160C	;CANADIAN SYLLABICS CARRIER MI
      #x160D	;CANADIAN SYLLABICS CARRIER MA
      #x160E	;CANADIAN SYLLABICS CARRIER YU
      #x160F	;CANADIAN SYLLABICS CARRIER YO
      #x1610	;CANADIAN SYLLABICS CARRIER YE
      #x1611	;CANADIAN SYLLABICS CARRIER YEE
      #x1612	;CANADIAN SYLLABICS CARRIER YI
      #x1613	;CANADIAN SYLLABICS CARRIER YA
      #x1614	;CANADIAN SYLLABICS CARRIER JU
      #x1615	;CANADIAN SYLLABICS SAYISI JU
      #x1616	;CANADIAN SYLLABICS CARRIER JO
      #x1617	;CANADIAN SYLLABICS CARRIER JE
      #x1618	;CANADIAN SYLLABICS CARRIER JEE
      #x1619	;CANADIAN SYLLABICS CARRIER JI
      #x161A	;CANADIAN SYLLABICS SAYISI JI
      #x161B	;CANADIAN SYLLABICS CARRIER JA
      #x161C	;CANADIAN SYLLABICS CARRIER JJU
      #x161D	;CANADIAN SYLLABICS CARRIER JJO
      #x161E	;CANADIAN SYLLABICS CARRIER JJE
      #x161F	;CANADIAN SYLLABICS CARRIER JJEE
      #x1620	;CANADIAN SYLLABICS CARRIER JJI
      #x1621	;CANADIAN SYLLABICS CARRIER JJA
      #x1622	;CANADIAN SYLLABICS CARRIER LU
      #x1623	;CANADIAN SYLLABICS CARRIER LO
      #x1624	;CANADIAN SYLLABICS CARRIER LE
      #x1625	;CANADIAN SYLLABICS CARRIER LEE
      #x1626	;CANADIAN SYLLABICS CARRIER LI
      #x1627	;CANADIAN SYLLABICS CARRIER LA
      #x1628	;CANADIAN SYLLABICS CARRIER DLU
      #x1629	;CANADIAN SYLLABICS CARRIER DLO
      #x162A	;CANADIAN SYLLABICS CARRIER DLE
      #x162B	;CANADIAN SYLLABICS CARRIER DLEE
      #x162C	;CANADIAN SYLLABICS CARRIER DLI
      #x162D	;CANADIAN SYLLABICS CARRIER DLA
      #x162E	;CANADIAN SYLLABICS CARRIER LHU
      #x162F	;CANADIAN SYLLABICS CARRIER LHO
      #x1630	;CANADIAN SYLLABICS CARRIER LHE
      #x1631	;CANADIAN SYLLABICS CARRIER LHEE
      #x1632	;CANADIAN SYLLABICS CARRIER LHI
      #x1633	;CANADIAN SYLLABICS CARRIER LHA
      #x1634	;CANADIAN SYLLABICS CARRIER TLHU
      #x1635	;CANADIAN SYLLABICS CARRIER TLHO
      #x1636	;CANADIAN SYLLABICS CARRIER TLHE
      #x1637	;CANADIAN SYLLABICS CARRIER TLHEE
      #x1638	;CANADIAN SYLLABICS CARRIER TLHI
      #x1639	;CANADIAN SYLLABICS CARRIER TLHA
      #x163A	;CANADIAN SYLLABICS CARRIER TLU
      #x163B	;CANADIAN SYLLABICS CARRIER TLO
      #x163C	;CANADIAN SYLLABICS CARRIER TLE
      #x163D	;CANADIAN SYLLABICS CARRIER TLEE
      #x163E	;CANADIAN SYLLABICS CARRIER TLI
      #x163F	;CANADIAN SYLLABICS CARRIER TLA
      #x1640	;CANADIAN SYLLABICS CARRIER ZU
      #x1641	;CANADIAN SYLLABICS CARRIER ZO
      #x1642	;CANADIAN SYLLABICS CARRIER ZE
      #x1643	;CANADIAN SYLLABICS CARRIER ZEE
      #x1644	;CANADIAN SYLLABICS CARRIER ZI
      #x1645	;CANADIAN SYLLABICS CARRIER ZA
      #x1646	;CANADIAN SYLLABICS CARRIER Z
      #x1647	;CANADIAN SYLLABICS CARRIER INITIAL Z
      #x1648	;CANADIAN SYLLABICS CARRIER DZU
      #x1649	;CANADIAN SYLLABICS CARRIER DZO
      #x164A	;CANADIAN SYLLABICS CARRIER DZE
      #x164B	;CANADIAN SYLLABICS CARRIER DZEE
      #x164C	;CANADIAN SYLLABICS CARRIER DZI
      #x164D	;CANADIAN SYLLABICS CARRIER DZA
      #x164E	;CANADIAN SYLLABICS CARRIER SU
      #x164F	;CANADIAN SYLLABICS CARRIER SO
      #x1650	;CANADIAN SYLLABICS CARRIER SE
      #x1651	;CANADIAN SYLLABICS CARRIER SEE
      #x1652	;CANADIAN SYLLABICS CARRIER SI
      #x1653	;CANADIAN SYLLABICS CARRIER SA
      #x1654	;CANADIAN SYLLABICS CARRIER SHU
      #x1655	;CANADIAN SYLLABICS CARRIER SHO
      #x1656	;CANADIAN SYLLABICS CARRIER SHE
      #x1657	;CANADIAN SYLLABICS CARRIER SHEE
      #x1658	;CANADIAN SYLLABICS CARRIER SHI
      #x1659	;CANADIAN SYLLABICS CARRIER SHA
      #x165A	;CANADIAN SYLLABICS CARRIER SH
      #x165B	;CANADIAN SYLLABICS CARRIER TSU
      #x165C	;CANADIAN SYLLABICS CARRIER TSO
      #x165D	;CANADIAN SYLLABICS CARRIER TSE
      #x165E	;CANADIAN SYLLABICS CARRIER TSEE
      #x165F	;CANADIAN SYLLABICS CARRIER TSI
      #x1660	;CANADIAN SYLLABICS CARRIER TSA
      #x1661	;CANADIAN SYLLABICS CARRIER CHU
      #x1662	;CANADIAN SYLLABICS CARRIER CHO
      #x1663	;CANADIAN SYLLABICS CARRIER CHE
      #x1664	;CANADIAN SYLLABICS CARRIER CHEE
      #x1665	;CANADIAN SYLLABICS CARRIER CHI
      #x1666	;CANADIAN SYLLABICS CARRIER CHA
      #x1667	;CANADIAN SYLLABICS CARRIER TTSU
      #x1668	;CANADIAN SYLLABICS CARRIER TTSO
      #x1669	;CANADIAN SYLLABICS CARRIER TTSE
      #x166A	;CANADIAN SYLLABICS CARRIER TTSEE
      #x166B	;CANADIAN SYLLABICS CARRIER TTSI
      #x166C	;CANADIAN SYLLABICS CARRIER TTSA
      #x166F	;CANADIAN SYLLABICS QAI
      #x1670	;CANADIAN SYLLABICS NGAI
      #x1671	;CANADIAN SYLLABICS NNGI
      #x1672	;CANADIAN SYLLABICS NNGII
      #x1673	;CANADIAN SYLLABICS NNGO
      #x1674	;CANADIAN SYLLABICS NNGOO
      #x1675	;CANADIAN SYLLABICS NNGA
      #x1676	;CANADIAN SYLLABICS NNGAA
      #x1681	;OGHAM LETTER BEITH
      #x1682	;OGHAM LETTER LUIS
      #x1683	;OGHAM LETTER FEARN
      #x1684	;OGHAM LETTER SAIL
      #x1685	;OGHAM LETTER NION
      #x1686	;OGHAM LETTER UATH
      #x1687	;OGHAM LETTER DAIR
      #x1688	;OGHAM LETTER TINNE
      #x1689	;OGHAM LETTER COLL
      #x168A	;OGHAM LETTER CEIRT
      #x168B	;OGHAM LETTER MUIN
      #x168C	;OGHAM LETTER GORT
      #x168D	;OGHAM LETTER NGEADAL
      #x168E	;OGHAM LETTER STRAIF
      #x168F	;OGHAM LETTER RUIS
      #x1690	;OGHAM LETTER AILM
      #x1691	;OGHAM LETTER ONN
      #x1692	;OGHAM LETTER UR
      #x1693	;OGHAM LETTER EADHADH
      #x1694	;OGHAM LETTER IODHADH
      #x1695	;OGHAM LETTER EABHADH
      #x1696	;OGHAM LETTER OR
      #x1697	;OGHAM LETTER UILLEANN
      #x1698	;OGHAM LETTER IFIN
      #x1699	;OGHAM LETTER EAMHANCHOLL
      #x169A	;OGHAM LETTER PEITH
      #x16A0	;RUNIC LETTER FEHU FEOH FE F
      #x16A1	;RUNIC LETTER V
      #x16A2	;RUNIC LETTER URUZ UR U
      #x16A3	;RUNIC LETTER YR
      #x16A4	;RUNIC LETTER Y
      #x16A5	;RUNIC LETTER W
      #x16A6	;RUNIC LETTER THURISAZ THURS THORN
      #x16A7	;RUNIC LETTER ETH
      #x16A8	;RUNIC LETTER ANSUZ A
      #x16A9	;RUNIC LETTER OS O
      #x16AA	;RUNIC LETTER AC A
      #x16AB	;RUNIC LETTER AESC
      #x16AC	;RUNIC LETTER LONG-BRANCH-OSS O
      #x16AD	;RUNIC LETTER SHORT-TWIG-OSS O
      #x16AE	;RUNIC LETTER O
      #x16AF	;RUNIC LETTER OE
      #x16B0	;RUNIC LETTER ON
      #x16B1	;RUNIC LETTER RAIDO RAD REID R
      #x16B2	;RUNIC LETTER KAUNA
      #x16B3	;RUNIC LETTER CEN
      #x16B4	;RUNIC LETTER KAUN K
      #x16B5	;RUNIC LETTER G
      #x16B6	;RUNIC LETTER ENG
      #x16B7	;RUNIC LETTER GEBO GYFU G
      #x16B8	;RUNIC LETTER GAR
      #x16B9	;RUNIC LETTER WUNJO WYNN W
      #x16BA	;RUNIC LETTER HAGLAZ H
      #x16BB	;RUNIC LETTER HAEGL H
      #x16BC	;RUNIC LETTER LONG-BRANCH-HAGALL H
      #x16BD	;RUNIC LETTER SHORT-TWIG-HAGALL H
      #x16BE	;RUNIC LETTER NAUDIZ NYD NAUD N
      #x16BF	;RUNIC LETTER SHORT-TWIG-NAUD N
      #x16C0	;RUNIC LETTER DOTTED-N
      #x16C1	;RUNIC LETTER ISAZ IS ISS I
      #x16C2	;RUNIC LETTER E
      #x16C3	;RUNIC LETTER JERAN J
      #x16C4	;RUNIC LETTER GER
      #x16C5	;RUNIC LETTER LONG-BRANCH-AR AE
      #x16C6	;RUNIC LETTER SHORT-TWIG-AR A
      #x16C7	;RUNIC LETTER IWAZ EOH
      #x16C8	;RUNIC LETTER PERTHO PEORTH P
      #x16C9	;RUNIC LETTER ALGIZ EOLHX
      #x16CA	;RUNIC LETTER SOWILO S
      #x16CB	;RUNIC LETTER SIGEL LONG-BRANCH-SOL S
      #x16CC	;RUNIC LETTER SHORT-TWIG-SOL S
      #x16CD	;RUNIC LETTER C
      #x16CE	;RUNIC LETTER Z
      #x16CF	;RUNIC LETTER TIWAZ TIR TYR T
      #x16D0	;RUNIC LETTER SHORT-TWIG-TYR T
      #x16D1	;RUNIC LETTER D
      #x16D2	;RUNIC LETTER BERKANAN BEORC BJARKAN B
      #x16D3	;RUNIC LETTER SHORT-TWIG-BJARKAN B
      #x16D4	;RUNIC LETTER DOTTED-P
      #x16D5	;RUNIC LETTER OPEN-P
      #x16D6	;RUNIC LETTER EHWAZ EH E
      #x16D7	;RUNIC LETTER MANNAZ MAN M
      #x16D8	;RUNIC LETTER LONG-BRANCH-MADR M
      #x16D9	;RUNIC LETTER SHORT-TWIG-MADR M
      #x16DA	;RUNIC LETTER LAUKAZ LAGU LOGR L
      #x16DB	;RUNIC LETTER DOTTED-L
      #x16DC	;RUNIC LETTER INGWAZ
      #x16DD	;RUNIC LETTER ING
      #x16DE	;RUNIC LETTER DAGAZ DAEG D
      #x16DF	;RUNIC LETTER OTHALAN ETHEL O
      #x16E0	;RUNIC LETTER EAR
      #x16E1	;RUNIC LETTER IOR
      #x16E2	;RUNIC LETTER CWEORTH
      #x16E3	;RUNIC LETTER CALC
      #x16E4	;RUNIC LETTER CEALC
      #x16E5	;RUNIC LETTER STAN
      #x16E6	;RUNIC LETTER LONG-BRANCH-YR
      #x16E7	;RUNIC LETTER SHORT-TWIG-YR
      #x16E8	;RUNIC LETTER ICELANDIC-YR
      #x16E9	;RUNIC LETTER Q
      #x16EA	;RUNIC LETTER X
      #x1700	;TAGALOG LETTER A
      #x1701	;TAGALOG LETTER I
      #x1702	;TAGALOG LETTER U
      #x1703	;TAGALOG LETTER KA
      #x1704	;TAGALOG LETTER GA
      #x1705	;TAGALOG LETTER NGA
      #x1706	;TAGALOG LETTER TA
      #x1707	;TAGALOG LETTER DA
      #x1708	;TAGALOG LETTER NA
      #x1709	;TAGALOG LETTER PA
      #x170A	;TAGALOG LETTER BA
      #x170B	;TAGALOG LETTER MA
      #x170C	;TAGALOG LETTER YA
      #x170E	;TAGALOG LETTER LA
      #x170F	;TAGALOG LETTER WA
      #x1710	;TAGALOG LETTER SA
      #x1711	;TAGALOG LETTER HA
      #x1720	;HANUNOO LETTER A
      #x1721	;HANUNOO LETTER I
      #x1722	;HANUNOO LETTER U
      #x1723	;HANUNOO LETTER KA
      #x1724	;HANUNOO LETTER GA
      #x1725	;HANUNOO LETTER NGA
      #x1726	;HANUNOO LETTER TA
      #x1727	;HANUNOO LETTER DA
      #x1728	;HANUNOO LETTER NA
      #x1729	;HANUNOO LETTER PA
      #x172A	;HANUNOO LETTER BA
      #x172B	;HANUNOO LETTER MA
      #x172C	;HANUNOO LETTER YA
      #x172D	;HANUNOO LETTER RA
      #x172E	;HANUNOO LETTER LA
      #x172F	;HANUNOO LETTER WA
      #x1730	;HANUNOO LETTER SA
      #x1731	;HANUNOO LETTER HA
      #x1740	;BUHID LETTER A
      #x1741	;BUHID LETTER I
      #x1742	;BUHID LETTER U
      #x1743	;BUHID LETTER KA
      #x1744	;BUHID LETTER GA
      #x1745	;BUHID LETTER NGA
      #x1746	;BUHID LETTER TA
      #x1747	;BUHID LETTER DA
      #x1748	;BUHID LETTER NA
      #x1749	;BUHID LETTER PA
      #x174A	;BUHID LETTER BA
      #x174B	;BUHID LETTER MA
      #x174C	;BUHID LETTER YA
      #x174D	;BUHID LETTER RA
      #x174E	;BUHID LETTER LA
      #x174F	;BUHID LETTER WA
      #x1750	;BUHID LETTER SA
      #x1751	;BUHID LETTER HA
      #x1760	;TAGBANWA LETTER A
      #x1761	;TAGBANWA LETTER I
      #x1762	;TAGBANWA LETTER U
      #x1763	;TAGBANWA LETTER KA
      #x1764	;TAGBANWA LETTER GA
      #x1765	;TAGBANWA LETTER NGA
      #x1766	;TAGBANWA LETTER TA
      #x1767	;TAGBANWA LETTER DA
      #x1768	;TAGBANWA LETTER NA
      #x1769	;TAGBANWA LETTER PA
      #x176A	;TAGBANWA LETTER BA
      #x176B	;TAGBANWA LETTER MA
      #x176C	;TAGBANWA LETTER YA
      #x176E	;TAGBANWA LETTER LA
      #x176F	;TAGBANWA LETTER WA
      #x1770	;TAGBANWA LETTER SA
      #x1780	;KHMER LETTER KA
      #x1781	;KHMER LETTER KHA
      #x1782	;KHMER LETTER KO
      #x1783	;KHMER LETTER KHO
      #x1784	;KHMER LETTER NGO
      #x1785	;KHMER LETTER CA
      #x1786	;KHMER LETTER CHA
      #x1787	;KHMER LETTER CO
      #x1788	;KHMER LETTER CHO
      #x1789	;KHMER LETTER NYO
      #x178A	;KHMER LETTER DA
      #x178B	;KHMER LETTER TTHA
      #x178C	;KHMER LETTER DO
      #x178D	;KHMER LETTER TTHO
      #x178E	;KHMER LETTER NNO
      #x178F	;KHMER LETTER TA
      #x1790	;KHMER LETTER THA
      #x1791	;KHMER LETTER TO
      #x1792	;KHMER LETTER THO
      #x1793	;KHMER LETTER NO
      #x1794	;KHMER LETTER BA
      #x1795	;KHMER LETTER PHA
      #x1796	;KHMER LETTER PO
      #x1797	;KHMER LETTER PHO
      #x1798	;KHMER LETTER MO
      #x1799	;KHMER LETTER YO
      #x179A	;KHMER LETTER RO
      #x179B	;KHMER LETTER LO
      #x179C	;KHMER LETTER VO
      #x179D	;KHMER LETTER SHA
      #x179E	;KHMER LETTER SSO
      #x179F	;KHMER LETTER SA
      #x17A0	;KHMER LETTER HA
      #x17A1	;KHMER LETTER LA
      #x17A2	;KHMER LETTER QA
      #x17A3	;KHMER INDEPENDENT VOWEL QAQ
      #x17A4	;KHMER INDEPENDENT VOWEL QAA
      #x17A5	;KHMER INDEPENDENT VOWEL QI
      #x17A6	;KHMER INDEPENDENT VOWEL QII
      #x17A7	;KHMER INDEPENDENT VOWEL QU
      #x17A8	;KHMER INDEPENDENT VOWEL QUK
      #x17A9	;KHMER INDEPENDENT VOWEL QUU
      #x17AA	;KHMER INDEPENDENT VOWEL QUUV
      #x17AB	;KHMER INDEPENDENT VOWEL RY
      #x17AC	;KHMER INDEPENDENT VOWEL RYY
      #x17AD	;KHMER INDEPENDENT VOWEL LY
      #x17AE	;KHMER INDEPENDENT VOWEL LYY
      #x17AF	;KHMER INDEPENDENT VOWEL QE
      #x17B0	;KHMER INDEPENDENT VOWEL QAI
      #x17B1	;KHMER INDEPENDENT VOWEL QOO TYPE ONE
      #x17B2	;KHMER INDEPENDENT VOWEL QOO TYPE TWO
      #x17B3	;KHMER INDEPENDENT VOWEL QAU
      #x17D7	;KHMER SIGN LEK TOO
      #x17DC	;KHMER SIGN AVAKRAHASANYA
      #x1820	;MONGOLIAN LETTER A
      #x1821	;MONGOLIAN LETTER E
      #x1822	;MONGOLIAN LETTER I
      #x1823	;MONGOLIAN LETTER O
      #x1824	;MONGOLIAN LETTER U
      #x1825	;MONGOLIAN LETTER OE
      #x1826	;MONGOLIAN LETTER UE
      #x1827	;MONGOLIAN LETTER EE
      #x1828	;MONGOLIAN LETTER NA
      #x1829	;MONGOLIAN LETTER ANG
      #x182A	;MONGOLIAN LETTER BA
      #x182B	;MONGOLIAN LETTER PA
      #x182C	;MONGOLIAN LETTER QA
      #x182D	;MONGOLIAN LETTER GA
      #x182E	;MONGOLIAN LETTER MA
      #x182F	;MONGOLIAN LETTER LA
      #x1830	;MONGOLIAN LETTER SA
      #x1831	;MONGOLIAN LETTER SHA
      #x1832	;MONGOLIAN LETTER TA
      #x1833	;MONGOLIAN LETTER DA
      #x1834	;MONGOLIAN LETTER CHA
      #x1835	;MONGOLIAN LETTER JA
      #x1836	;MONGOLIAN LETTER YA
      #x1837	;MONGOLIAN LETTER RA
      #x1838	;MONGOLIAN LETTER WA
      #x1839	;MONGOLIAN LETTER FA
      #x183A	;MONGOLIAN LETTER KA
      #x183B	;MONGOLIAN LETTER KHA
      #x183C	;MONGOLIAN LETTER TSA
      #x183D	;MONGOLIAN LETTER ZA
      #x183E	;MONGOLIAN LETTER HAA
      #x183F	;MONGOLIAN LETTER ZRA
      #x1840	;MONGOLIAN LETTER LHA
      #x1841	;MONGOLIAN LETTER ZHI
      #x1842	;MONGOLIAN LETTER CHI
      #x1843	;MONGOLIAN LETTER TODO LONG VOWEL SIGN
      #x1844	;MONGOLIAN LETTER TODO E
      #x1845	;MONGOLIAN LETTER TODO I
      #x1846	;MONGOLIAN LETTER TODO O
      #x1847	;MONGOLIAN LETTER TODO U
      #x1848	;MONGOLIAN LETTER TODO OE
      #x1849	;MONGOLIAN LETTER TODO UE
      #x184A	;MONGOLIAN LETTER TODO ANG
      #x184B	;MONGOLIAN LETTER TODO BA
      #x184C	;MONGOLIAN LETTER TODO PA
      #x184D	;MONGOLIAN LETTER TODO QA
      #x184E	;MONGOLIAN LETTER TODO GA
      #x184F	;MONGOLIAN LETTER TODO MA
      #x1850	;MONGOLIAN LETTER TODO TA
      #x1851	;MONGOLIAN LETTER TODO DA
      #x1852	;MONGOLIAN LETTER TODO CHA
      #x1853	;MONGOLIAN LETTER TODO JA
      #x1854	;MONGOLIAN LETTER TODO TSA
      #x1855	;MONGOLIAN LETTER TODO YA
      #x1856	;MONGOLIAN LETTER TODO WA
      #x1857	;MONGOLIAN LETTER TODO KA
      #x1858	;MONGOLIAN LETTER TODO GAA
      #x1859	;MONGOLIAN LETTER TODO HAA
      #x185A	;MONGOLIAN LETTER TODO JIA
      #x185B	;MONGOLIAN LETTER TODO NIA
      #x185C	;MONGOLIAN LETTER TODO DZA
      #x185D	;MONGOLIAN LETTER SIBE E
      #x185E	;MONGOLIAN LETTER SIBE I
      #x185F	;MONGOLIAN LETTER SIBE IY
      #x1860	;MONGOLIAN LETTER SIBE UE
      #x1861	;MONGOLIAN LETTER SIBE U
      #x1862	;MONGOLIAN LETTER SIBE ANG
      #x1863	;MONGOLIAN LETTER SIBE KA
      #x1864	;MONGOLIAN LETTER SIBE GA
      #x1865	;MONGOLIAN LETTER SIBE HA
      #x1866	;MONGOLIAN LETTER SIBE PA
      #x1867	;MONGOLIAN LETTER SIBE SHA
      #x1868	;MONGOLIAN LETTER SIBE TA
      #x1869	;MONGOLIAN LETTER SIBE DA
      #x186A	;MONGOLIAN LETTER SIBE JA
      #x186B	;MONGOLIAN LETTER SIBE FA
      #x186C	;MONGOLIAN LETTER SIBE GAA
      #x186D	;MONGOLIAN LETTER SIBE HAA
      #x186E	;MONGOLIAN LETTER SIBE TSA
      #x186F	;MONGOLIAN LETTER SIBE ZA
      #x1870	;MONGOLIAN LETTER SIBE RAA
      #x1871	;MONGOLIAN LETTER SIBE CHA
      #x1872	;MONGOLIAN LETTER SIBE ZHA
      #x1873	;MONGOLIAN LETTER MANCHU I
      #x1874	;MONGOLIAN LETTER MANCHU KA
      #x1875	;MONGOLIAN LETTER MANCHU RA
      #x1876	;MONGOLIAN LETTER MANCHU FA
      #x1877	;MONGOLIAN LETTER MANCHU ZHA
      #x1880	;MONGOLIAN LETTER ALI GALI ANUSVARA ONE
      #x1881	;MONGOLIAN LETTER ALI GALI VISARGA ONE
      #x1882	;MONGOLIAN LETTER ALI GALI DAMARU
      #x1883	;MONGOLIAN LETTER ALI GALI UBADAMA
      #x1884	;MONGOLIAN LETTER ALI GALI INVERTED UBADAMA
      #x1885	;MONGOLIAN LETTER ALI GALI BALUDA
      #x1886	;MONGOLIAN LETTER ALI GALI THREE BALUDA
      #x1887	;MONGOLIAN LETTER ALI GALI A
      #x1888	;MONGOLIAN LETTER ALI GALI I
      #x1889	;MONGOLIAN LETTER ALI GALI KA
      #x188A	;MONGOLIAN LETTER ALI GALI NGA
      #x188B	;MONGOLIAN LETTER ALI GALI CA
      #x188C	;MONGOLIAN LETTER ALI GALI TTA
      #x188D	;MONGOLIAN LETTER ALI GALI TTHA
      #x188E	;MONGOLIAN LETTER ALI GALI DDA
      #x188F	;MONGOLIAN LETTER ALI GALI NNA
      #x1890	;MONGOLIAN LETTER ALI GALI TA
      #x1891	;MONGOLIAN LETTER ALI GALI DA
      #x1892	;MONGOLIAN LETTER ALI GALI PA
      #x1893	;MONGOLIAN LETTER ALI GALI PHA
      #x1894	;MONGOLIAN LETTER ALI GALI SSA
      #x1895	;MONGOLIAN LETTER ALI GALI ZHA
      #x1896	;MONGOLIAN LETTER ALI GALI ZA
      #x1897	;MONGOLIAN LETTER ALI GALI AH
      #x1898	;MONGOLIAN LETTER TODO ALI GALI TA
      #x1899	;MONGOLIAN LETTER TODO ALI GALI ZHA
      #x189A	;MONGOLIAN LETTER MANCHU ALI GALI GHA
      #x189B	;MONGOLIAN LETTER MANCHU ALI GALI NGA
      #x189C	;MONGOLIAN LETTER MANCHU ALI GALI CA
      #x189D	;MONGOLIAN LETTER MANCHU ALI GALI JHA
      #x189E	;MONGOLIAN LETTER MANCHU ALI GALI TTA
      #x189F	;MONGOLIAN LETTER MANCHU ALI GALI DDHA
      #x18A0	;MONGOLIAN LETTER MANCHU ALI GALI TA
      #x18A1	;MONGOLIAN LETTER MANCHU ALI GALI DHA
      #x18A2	;MONGOLIAN LETTER MANCHU ALI GALI SSA
      #x18A3	;MONGOLIAN LETTER MANCHU ALI GALI CYA
      #x18A4	;MONGOLIAN LETTER MANCHU ALI GALI ZHA
      #x18A5	;MONGOLIAN LETTER MANCHU ALI GALI ZA
      #x18A6	;MONGOLIAN LETTER ALI GALI HALF U
      #x18A7	;MONGOLIAN LETTER ALI GALI HALF YA
      #x18A8	;MONGOLIAN LETTER MANCHU ALI GALI BHA
      #x1900	;LIMBU VOWEL-CARRIER LETTER
      #x1901	;LIMBU LETTER KA
      #x1902	;LIMBU LETTER KHA
      #x1903	;LIMBU LETTER GA
      #x1904	;LIMBU LETTER GHA
      #x1905	;LIMBU LETTER NGA
      #x1906	;LIMBU LETTER CA
      #x1907	;LIMBU LETTER CHA
      #x1908	;LIMBU LETTER JA
      #x1909	;LIMBU LETTER JHA
      #x190A	;LIMBU LETTER YAN
      #x190B	;LIMBU LETTER TA
      #x190C	;LIMBU LETTER THA
      #x190D	;LIMBU LETTER DA
      #x190E	;LIMBU LETTER DHA
      #x190F	;LIMBU LETTER NA
      #x1910	;LIMBU LETTER PA
      #x1911	;LIMBU LETTER PHA
      #x1912	;LIMBU LETTER BA
      #x1913	;LIMBU LETTER BHA
      #x1914	;LIMBU LETTER MA
      #x1915	;LIMBU LETTER YA
      #x1916	;LIMBU LETTER RA
      #x1917	;LIMBU LETTER LA
      #x1918	;LIMBU LETTER WA
      #x1919	;LIMBU LETTER SHA
      #x191A	;LIMBU LETTER SSA
      #x191B	;LIMBU LETTER SA
      #x191C	;LIMBU LETTER HA
      #x1950	;TAI LE LETTER KA
      #x1951	;TAI LE LETTER XA
      #x1952	;TAI LE LETTER NGA
      #x1953	;TAI LE LETTER TSA
      #x1954	;TAI LE LETTER SA
      #x1955	;TAI LE LETTER YA
      #x1956	;TAI LE LETTER TA
      #x1957	;TAI LE LETTER THA
      #x1958	;TAI LE LETTER LA
      #x1959	;TAI LE LETTER PA
      #x195A	;TAI LE LETTER PHA
      #x195B	;TAI LE LETTER MA
      #x195C	;TAI LE LETTER FA
      #x195D	;TAI LE LETTER VA
      #x195E	;TAI LE LETTER HA
      #x195F	;TAI LE LETTER QA
      #x1960	;TAI LE LETTER KHA
      #x1961	;TAI LE LETTER TSHA
      #x1962	;TAI LE LETTER NA
      #x1963	;TAI LE LETTER A
      #x1964	;TAI LE LETTER I
      #x1965	;TAI LE LETTER EE
      #x1966	;TAI LE LETTER EH
      #x1967	;TAI LE LETTER U
      #x1968	;TAI LE LETTER OO
      #x1969	;TAI LE LETTER O
      #x196A	;TAI LE LETTER UE
      #x196B	;TAI LE LETTER E
      #x196C	;TAI LE LETTER AUE
      #x196D	;TAI LE LETTER AI
      #x1970	;TAI LE LETTER TONE-2
      #x1971	;TAI LE LETTER TONE-3
      #x1972	;TAI LE LETTER TONE-4
      #x1973	;TAI LE LETTER TONE-5
      #x1974	;TAI LE LETTER TONE-6
      #x1D00	;LATIN LETTER SMALL CAPITAL A
      #x1D01	;LATIN LETTER SMALL CAPITAL AE
      #x1D02	;LATIN SMALL LETTER TURNED AE
      #x1D03	;LATIN LETTER SMALL CAPITAL BARRED B
      #x1D04	;LATIN LETTER SMALL CAPITAL C
      #x1D05	;LATIN LETTER SMALL CAPITAL D
      #x1D06	;LATIN LETTER SMALL CAPITAL ETH
      #x1D07	;LATIN LETTER SMALL CAPITAL E
      #x1D08	;LATIN SMALL LETTER TURNED OPEN E
      #x1D09	;LATIN SMALL LETTER TURNED I
      #x1D0A	;LATIN LETTER SMALL CAPITAL J
      #x1D0B	;LATIN LETTER SMALL CAPITAL K
      #x1D0C	;LATIN LETTER SMALL CAPITAL L WITH STROKE
      #x1D0D	;LATIN LETTER SMALL CAPITAL M
      #x1D0E	;LATIN LETTER SMALL CAPITAL REVERSED N
      #x1D0F	;LATIN LETTER SMALL CAPITAL O
      #x1D10	;LATIN LETTER SMALL CAPITAL OPEN O
      #x1D11	;LATIN SMALL LETTER SIDEWAYS O
      #x1D12	;LATIN SMALL LETTER SIDEWAYS OPEN O
      #x1D13	;LATIN SMALL LETTER SIDEWAYS O WITH STROKE
      #x1D14	;LATIN SMALL LETTER TURNED OE
      #x1D15	;LATIN LETTER SMALL CAPITAL OU
      #x1D16	;LATIN SMALL LETTER TOP HALF O
      #x1D17	;LATIN SMALL LETTER BOTTOM HALF O
      #x1D18	;LATIN LETTER SMALL CAPITAL P
      #x1D19	;LATIN LETTER SMALL CAPITAL REVERSED R
      #x1D1A	;LATIN LETTER SMALL CAPITAL TURNED R
      #x1D1B	;LATIN LETTER SMALL CAPITAL T
      #x1D1C	;LATIN LETTER SMALL CAPITAL U
      #x1D1D	;LATIN SMALL LETTER SIDEWAYS U
      #x1D1E	;LATIN SMALL LETTER SIDEWAYS DIAERESIZED U
      #x1D1F	;LATIN SMALL LETTER SIDEWAYS TURNED M
      #x1D20	;LATIN LETTER SMALL CAPITAL V
      #x1D21	;LATIN LETTER SMALL CAPITAL W
      #x1D22	;LATIN LETTER SMALL CAPITAL Z
      #x1D23	;LATIN LETTER SMALL CAPITAL EZH
      #x1D24	;LATIN LETTER VOICED LARYNGEAL SPIRANT
      #x1D25	;LATIN LETTER AIN
      #x1D26	;GREEK LETTER SMALL CAPITAL GAMMA
      #x1D27	;GREEK LETTER SMALL CAPITAL LAMDA
      #x1D28	;GREEK LETTER SMALL CAPITAL PI
      #x1D29	;GREEK LETTER SMALL CAPITAL RHO
      #x1D2A	;GREEK LETTER SMALL CAPITAL PSI
      #x1D2B	;CYRILLIC LETTER SMALL CAPITAL EL
      #x1D2C	;MODIFIER LETTER CAPITAL A
      #x1D2D	;MODIFIER LETTER CAPITAL AE
      #x1D2E	;MODIFIER LETTER CAPITAL B
      #x1D2F	;MODIFIER LETTER CAPITAL BARRED B
      #x1D30	;MODIFIER LETTER CAPITAL D
      #x1D31	;MODIFIER LETTER CAPITAL E
      #x1D32	;MODIFIER LETTER CAPITAL REVERSED E
      #x1D33	;MODIFIER LETTER CAPITAL G
      #x1D34	;MODIFIER LETTER CAPITAL H
      #x1D35	;MODIFIER LETTER CAPITAL I
      #x1D36	;MODIFIER LETTER CAPITAL J
      #x1D37	;MODIFIER LETTER CAPITAL K
      #x1D38	;MODIFIER LETTER CAPITAL L
      #x1D39	;MODIFIER LETTER CAPITAL M
      #x1D3A	;MODIFIER LETTER CAPITAL N
      #x1D3B	;MODIFIER LETTER CAPITAL REVERSED N
      #x1D3C	;MODIFIER LETTER CAPITAL O
      #x1D3D	;MODIFIER LETTER CAPITAL OU
      #x1D3E	;MODIFIER LETTER CAPITAL P
      #x1D3F	;MODIFIER LETTER CAPITAL R
      #x1D40	;MODIFIER LETTER CAPITAL T
      #x1D41	;MODIFIER LETTER CAPITAL U
      #x1D42	;MODIFIER LETTER CAPITAL W
      #x1D43	;MODIFIER LETTER SMALL A
      #x1D44	;MODIFIER LETTER SMALL TURNED A
      #x1D45	;MODIFIER LETTER SMALL ALPHA
      #x1D46	;MODIFIER LETTER SMALL TURNED AE
      #x1D47	;MODIFIER LETTER SMALL B
      #x1D48	;MODIFIER LETTER SMALL D
      #x1D49	;MODIFIER LETTER SMALL E
      #x1D4A	;MODIFIER LETTER SMALL SCHWA
      #x1D4B	;MODIFIER LETTER SMALL OPEN E
      #x1D4C	;MODIFIER LETTER SMALL TURNED OPEN E
      #x1D4D	;MODIFIER LETTER SMALL G
      #x1D4E	;MODIFIER LETTER SMALL TURNED I
      #x1D4F	;MODIFIER LETTER SMALL K
      #x1D50	;MODIFIER LETTER SMALL M
      #x1D51	;MODIFIER LETTER SMALL ENG
      #x1D52	;MODIFIER LETTER SMALL O
      #x1D53	;MODIFIER LETTER SMALL OPEN O
      #x1D54	;MODIFIER LETTER SMALL TOP HALF O
      #x1D55	;MODIFIER LETTER SMALL BOTTOM HALF O
      #x1D56	;MODIFIER LETTER SMALL P
      #x1D57	;MODIFIER LETTER SMALL T
      #x1D58	;MODIFIER LETTER SMALL U
      #x1D59	;MODIFIER LETTER SMALL SIDEWAYS U
      #x1D5A	;MODIFIER LETTER SMALL TURNED M
      #x1D5B	;MODIFIER LETTER SMALL V
      #x1D5C	;MODIFIER LETTER SMALL AIN
      #x1D5D	;MODIFIER LETTER SMALL BETA
      #x1D5E	;MODIFIER LETTER SMALL GREEK GAMMA
      #x1D5F	;MODIFIER LETTER SMALL DELTA
      #x1D60	;MODIFIER LETTER SMALL GREEK PHI
      #x1D61	;MODIFIER LETTER SMALL CHI
      #x1D62	;LATIN SUBSCRIPT SMALL LETTER I
      #x1D63	;LATIN SUBSCRIPT SMALL LETTER R
      #x1D64	;LATIN SUBSCRIPT SMALL LETTER U
      #x1D65	;LATIN SUBSCRIPT SMALL LETTER V
      #x1D66	;GREEK SUBSCRIPT SMALL LETTER BETA
      #x1D67	;GREEK SUBSCRIPT SMALL LETTER GAMMA
      #x1D68	;GREEK SUBSCRIPT SMALL LETTER RHO
      #x1D69	;GREEK SUBSCRIPT SMALL LETTER PHI
      #x1D6A	;GREEK SUBSCRIPT SMALL LETTER CHI
      #x1D6B	;LATIN SMALL LETTER UE
      #x1E00	;LATIN CAPITAL LETTER A WITH RING BELOW
      #x1E01	;LATIN SMALL LETTER A WITH RING BELOW
      #x1E02	;LATIN CAPITAL LETTER B WITH DOT ABOVE
      #x1E03	;LATIN SMALL LETTER B WITH DOT ABOVE
      #x1E04	;LATIN CAPITAL LETTER B WITH DOT BELOW
      #x1E05	;LATIN SMALL LETTER B WITH DOT BELOW
      #x1E06	;LATIN CAPITAL LETTER B WITH LINE BELOW
      #x1E07	;LATIN SMALL LETTER B WITH LINE BELOW
      #x1E08	;LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
      #x1E09	;LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
      #x1E0A	;LATIN CAPITAL LETTER D WITH DOT ABOVE
      #x1E0B	;LATIN SMALL LETTER D WITH DOT ABOVE
      #x1E0C	;LATIN CAPITAL LETTER D WITH DOT BELOW
      #x1E0D	;LATIN SMALL LETTER D WITH DOT BELOW
      #x1E0E	;LATIN CAPITAL LETTER D WITH LINE BELOW
      #x1E0F	;LATIN SMALL LETTER D WITH LINE BELOW
      #x1E10	;LATIN CAPITAL LETTER D WITH CEDILLA
      #x1E11	;LATIN SMALL LETTER D WITH CEDILLA
      #x1E12	;LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
      #x1E13	;LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
      #x1E14	;LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
      #x1E15	;LATIN SMALL LETTER E WITH MACRON AND GRAVE
      #x1E16	;LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
      #x1E17	;LATIN SMALL LETTER E WITH MACRON AND ACUTE
      #x1E18	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
      #x1E19	;LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
      #x1E1A	;LATIN CAPITAL LETTER E WITH TILDE BELOW
      #x1E1B	;LATIN SMALL LETTER E WITH TILDE BELOW
      #x1E1C	;LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
      #x1E1D	;LATIN SMALL LETTER E WITH CEDILLA AND BREVE
      #x1E1E	;LATIN CAPITAL LETTER F WITH DOT ABOVE
      #x1E1F	;LATIN SMALL LETTER F WITH DOT ABOVE
      #x1E20	;LATIN CAPITAL LETTER G WITH MACRON
      #x1E21	;LATIN SMALL LETTER G WITH MACRON
      #x1E22	;LATIN CAPITAL LETTER H WITH DOT ABOVE
      #x1E23	;LATIN SMALL LETTER H WITH DOT ABOVE
      #x1E24	;LATIN CAPITAL LETTER H WITH DOT BELOW
      #x1E25	;LATIN SMALL LETTER H WITH DOT BELOW
      #x1E26	;LATIN CAPITAL LETTER H WITH DIAERESIS
      #x1E27	;LATIN SMALL LETTER H WITH DIAERESIS
      #x1E28	;LATIN CAPITAL LETTER H WITH CEDILLA
      #x1E29	;LATIN SMALL LETTER H WITH CEDILLA
      #x1E2A	;LATIN CAPITAL LETTER H WITH BREVE BELOW
      #x1E2B	;LATIN SMALL LETTER H WITH BREVE BELOW
      #x1E2C	;LATIN CAPITAL LETTER I WITH TILDE BELOW
      #x1E2D	;LATIN SMALL LETTER I WITH TILDE BELOW
      #x1E2E	;LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
      #x1E2F	;LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
      #x1E30	;LATIN CAPITAL LETTER K WITH ACUTE
      #x1E31	;LATIN SMALL LETTER K WITH ACUTE
      #x1E32	;LATIN CAPITAL LETTER K WITH DOT BELOW
      #x1E33	;LATIN SMALL LETTER K WITH DOT BELOW
      #x1E34	;LATIN CAPITAL LETTER K WITH LINE BELOW
      #x1E35	;LATIN SMALL LETTER K WITH LINE BELOW
      #x1E36	;LATIN CAPITAL LETTER L WITH DOT BELOW
      #x1E37	;LATIN SMALL LETTER L WITH DOT BELOW
      #x1E38	;LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
      #x1E39	;LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
      #x1E3A	;LATIN CAPITAL LETTER L WITH LINE BELOW
      #x1E3B	;LATIN SMALL LETTER L WITH LINE BELOW
      #x1E3C	;LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
      #x1E3D	;LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
      #x1E3E	;LATIN CAPITAL LETTER M WITH ACUTE
      #x1E3F	;LATIN SMALL LETTER M WITH ACUTE
      #x1E40	;LATIN CAPITAL LETTER M WITH DOT ABOVE
      #x1E41	;LATIN SMALL LETTER M WITH DOT ABOVE
      #x1E42	;LATIN CAPITAL LETTER M WITH DOT BELOW
      #x1E43	;LATIN SMALL LETTER M WITH DOT BELOW
      #x1E44	;LATIN CAPITAL LETTER N WITH DOT ABOVE
      #x1E45	;LATIN SMALL LETTER N WITH DOT ABOVE
      #x1E46	;LATIN CAPITAL LETTER N WITH DOT BELOW
      #x1E47	;LATIN SMALL LETTER N WITH DOT BELOW
      #x1E48	;LATIN CAPITAL LETTER N WITH LINE BELOW
      #x1E49	;LATIN SMALL LETTER N WITH LINE BELOW
      #x1E4A	;LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
      #x1E4B	;LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
      #x1E4C	;LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
      #x1E4D	;LATIN SMALL LETTER O WITH TILDE AND ACUTE
      #x1E4E	;LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
      #x1E4F	;LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
      #x1E50	;LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
      #x1E51	;LATIN SMALL LETTER O WITH MACRON AND GRAVE
      #x1E52	;LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
      #x1E53	;LATIN SMALL LETTER O WITH MACRON AND ACUTE
      #x1E54	;LATIN CAPITAL LETTER P WITH ACUTE
      #x1E55	;LATIN SMALL LETTER P WITH ACUTE
      #x1E56	;LATIN CAPITAL LETTER P WITH DOT ABOVE
      #x1E57	;LATIN SMALL LETTER P WITH DOT ABOVE
      #x1E58	;LATIN CAPITAL LETTER R WITH DOT ABOVE
      #x1E59	;LATIN SMALL LETTER R WITH DOT ABOVE
      #x1E5A	;LATIN CAPITAL LETTER R WITH DOT BELOW
      #x1E5B	;LATIN SMALL LETTER R WITH DOT BELOW
      #x1E5C	;LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
      #x1E5D	;LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
      #x1E5E	;LATIN CAPITAL LETTER R WITH LINE BELOW
      #x1E5F	;LATIN SMALL LETTER R WITH LINE BELOW
      #x1E60	;LATIN CAPITAL LETTER S WITH DOT ABOVE
      #x1E61	;LATIN SMALL LETTER S WITH DOT ABOVE
      #x1E62	;LATIN CAPITAL LETTER S WITH DOT BELOW
      #x1E63	;LATIN SMALL LETTER S WITH DOT BELOW
      #x1E64	;LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
      #x1E65	;LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
      #x1E66	;LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
      #x1E67	;LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
      #x1E68	;LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
      #x1E69	;LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
      #x1E6A	;LATIN CAPITAL LETTER T WITH DOT ABOVE
      #x1E6B	;LATIN SMALL LETTER T WITH DOT ABOVE
      #x1E6C	;LATIN CAPITAL LETTER T WITH DOT BELOW
      #x1E6D	;LATIN SMALL LETTER T WITH DOT BELOW
      #x1E6E	;LATIN CAPITAL LETTER T WITH LINE BELOW
      #x1E6F	;LATIN SMALL LETTER T WITH LINE BELOW
      #x1E70	;LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
      #x1E71	;LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
      #x1E72	;LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
      #x1E73	;LATIN SMALL LETTER U WITH DIAERESIS BELOW
      #x1E74	;LATIN CAPITAL LETTER U WITH TILDE BELOW
      #x1E75	;LATIN SMALL LETTER U WITH TILDE BELOW
      #x1E76	;LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
      #x1E77	;LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
      #x1E78	;LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
      #x1E79	;LATIN SMALL LETTER U WITH TILDE AND ACUTE
      #x1E7A	;LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
      #x1E7B	;LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
      #x1E7C	;LATIN CAPITAL LETTER V WITH TILDE
      #x1E7D	;LATIN SMALL LETTER V WITH TILDE
      #x1E7E	;LATIN CAPITAL LETTER V WITH DOT BELOW
      #x1E7F	;LATIN SMALL LETTER V WITH DOT BELOW
      #x1E80	;LATIN CAPITAL LETTER W WITH GRAVE
      #x1E81	;LATIN SMALL LETTER W WITH GRAVE
      #x1E82	;LATIN CAPITAL LETTER W WITH ACUTE
      #x1E83	;LATIN SMALL LETTER W WITH ACUTE
      #x1E84	;LATIN CAPITAL LETTER W WITH DIAERESIS
      #x1E85	;LATIN SMALL LETTER W WITH DIAERESIS
      #x1E86	;LATIN CAPITAL LETTER W WITH DOT ABOVE
      #x1E87	;LATIN SMALL LETTER W WITH DOT ABOVE
      #x1E88	;LATIN CAPITAL LETTER W WITH DOT BELOW
      #x1E89	;LATIN SMALL LETTER W WITH DOT BELOW
      #x1E8A	;LATIN CAPITAL LETTER X WITH DOT ABOVE
      #x1E8B	;LATIN SMALL LETTER X WITH DOT ABOVE
      #x1E8C	;LATIN CAPITAL LETTER X WITH DIAERESIS
      #x1E8D	;LATIN SMALL LETTER X WITH DIAERESIS
      #x1E8E	;LATIN CAPITAL LETTER Y WITH DOT ABOVE
      #x1E8F	;LATIN SMALL LETTER Y WITH DOT ABOVE
      #x1E90	;LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
      #x1E91	;LATIN SMALL LETTER Z WITH CIRCUMFLEX
      #x1E92	;LATIN CAPITAL LETTER Z WITH DOT BELOW
      #x1E93	;LATIN SMALL LETTER Z WITH DOT BELOW
      #x1E94	;LATIN CAPITAL LETTER Z WITH LINE BELOW
      #x1E95	;LATIN SMALL LETTER Z WITH LINE BELOW
      #x1E96	;LATIN SMALL LETTER H WITH LINE BELOW
      #x1E97	;LATIN SMALL LETTER T WITH DIAERESIS
      #x1E98	;LATIN SMALL LETTER W WITH RING ABOVE
      #x1E99	;LATIN SMALL LETTER Y WITH RING ABOVE
      #x1E9A	;LATIN SMALL LETTER A WITH RIGHT HALF RING
      #x1E9B	;LATIN SMALL LETTER LONG S WITH DOT ABOVE
      #x1EA0	;LATIN CAPITAL LETTER A WITH DOT BELOW
      #x1EA1	;LATIN SMALL LETTER A WITH DOT BELOW
      #x1EA2	;LATIN CAPITAL LETTER A WITH HOOK ABOVE
      #x1EA3	;LATIN SMALL LETTER A WITH HOOK ABOVE
      #x1EA4	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
      #x1EA5	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
      #x1EA6	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
      #x1EA7	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
      #x1EA8	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EA9	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EAA	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
      #x1EAB	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
      #x1EAC	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
      #x1EAD	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
      #x1EAE	;LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
      #x1EAF	;LATIN SMALL LETTER A WITH BREVE AND ACUTE
      #x1EB0	;LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
      #x1EB1	;LATIN SMALL LETTER A WITH BREVE AND GRAVE
      #x1EB2	;LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
      #x1EB3	;LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
      #x1EB4	;LATIN CAPITAL LETTER A WITH BREVE AND TILDE
      #x1EB5	;LATIN SMALL LETTER A WITH BREVE AND TILDE
      #x1EB6	;LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
      #x1EB7	;LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
      #x1EB8	;LATIN CAPITAL LETTER E WITH DOT BELOW
      #x1EB9	;LATIN SMALL LETTER E WITH DOT BELOW
      #x1EBA	;LATIN CAPITAL LETTER E WITH HOOK ABOVE
      #x1EBB	;LATIN SMALL LETTER E WITH HOOK ABOVE
      #x1EBC	;LATIN CAPITAL LETTER E WITH TILDE
      #x1EBD	;LATIN SMALL LETTER E WITH TILDE
      #x1EBE	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
      #x1EBF	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
      #x1EC0	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
      #x1EC1	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
      #x1EC2	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EC3	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EC4	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
      #x1EC5	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
      #x1EC6	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
      #x1EC7	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
      #x1EC8	;LATIN CAPITAL LETTER I WITH HOOK ABOVE
      #x1EC9	;LATIN SMALL LETTER I WITH HOOK ABOVE
      #x1ECA	;LATIN CAPITAL LETTER I WITH DOT BELOW
      #x1ECB	;LATIN SMALL LETTER I WITH DOT BELOW
      #x1ECC	;LATIN CAPITAL LETTER O WITH DOT BELOW
      #x1ECD	;LATIN SMALL LETTER O WITH DOT BELOW
      #x1ECE	;LATIN CAPITAL LETTER O WITH HOOK ABOVE
      #x1ECF	;LATIN SMALL LETTER O WITH HOOK ABOVE
      #x1ED0	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
      #x1ED1	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
      #x1ED2	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
      #x1ED3	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
      #x1ED4	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
      #x1ED5	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
      #x1ED6	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
      #x1ED7	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
      #x1ED8	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
      #x1ED9	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
      #x1EDA	;LATIN CAPITAL LETTER O WITH HORN AND ACUTE
      #x1EDB	;LATIN SMALL LETTER O WITH HORN AND ACUTE
      #x1EDC	;LATIN CAPITAL LETTER O WITH HORN AND GRAVE
      #x1EDD	;LATIN SMALL LETTER O WITH HORN AND GRAVE
      #x1EDE	;LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
      #x1EDF	;LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
      #x1EE0	;LATIN CAPITAL LETTER O WITH HORN AND TILDE
      #x1EE1	;LATIN SMALL LETTER O WITH HORN AND TILDE
      #x1EE2	;LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
      #x1EE3	;LATIN SMALL LETTER O WITH HORN AND DOT BELOW
      #x1EE4	;LATIN CAPITAL LETTER U WITH DOT BELOW
      #x1EE5	;LATIN SMALL LETTER U WITH DOT BELOW
      #x1EE6	;LATIN CAPITAL LETTER U WITH HOOK ABOVE
      #x1EE7	;LATIN SMALL LETTER U WITH HOOK ABOVE
      #x1EE8	;LATIN CAPITAL LETTER U WITH HORN AND ACUTE
      #x1EE9	;LATIN SMALL LETTER U WITH HORN AND ACUTE
      #x1EEA	;LATIN CAPITAL LETTER U WITH HORN AND GRAVE
      #x1EEB	;LATIN SMALL LETTER U WITH HORN AND GRAVE
      #x1EEC	;LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
      #x1EED	;LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
      #x1EEE	;LATIN CAPITAL LETTER U WITH HORN AND TILDE
      #x1EEF	;LATIN SMALL LETTER U WITH HORN AND TILDE
      #x1EF0	;LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
      #x1EF1	;LATIN SMALL LETTER U WITH HORN AND DOT BELOW
      #x1EF2	;LATIN CAPITAL LETTER Y WITH GRAVE
      #x1EF3	;LATIN SMALL LETTER Y WITH GRAVE
      #x1EF4	;LATIN CAPITAL LETTER Y WITH DOT BELOW
      #x1EF5	;LATIN SMALL LETTER Y WITH DOT BELOW
      #x1EF6	;LATIN CAPITAL LETTER Y WITH HOOK ABOVE
      #x1EF7	;LATIN SMALL LETTER Y WITH HOOK ABOVE
      #x1EF8	;LATIN CAPITAL LETTER Y WITH TILDE
      #x1EF9	;LATIN SMALL LETTER Y WITH TILDE
      #x1F00	;GREEK SMALL LETTER ALPHA WITH PSILI
      #x1F01	;GREEK SMALL LETTER ALPHA WITH DASIA
      #x1F02	;GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA
      #x1F03	;GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA
      #x1F04	;GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA
      #x1F05	;GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA
      #x1F06	;GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI
      #x1F07	;GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
      #x1F08	;GREEK CAPITAL LETTER ALPHA WITH PSILI
      #x1F09	;GREEK CAPITAL LETTER ALPHA WITH DASIA
      #x1F0A	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
      #x1F0B	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
      #x1F0C	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
      #x1F0D	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
      #x1F0E	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
      #x1F0F	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
      #x1F10	;GREEK SMALL LETTER EPSILON WITH PSILI
      #x1F11	;GREEK SMALL LETTER EPSILON WITH DASIA
      #x1F12	;GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA
      #x1F13	;GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA
      #x1F14	;GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA
      #x1F15	;GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
      #x1F18	;GREEK CAPITAL LETTER EPSILON WITH PSILI
      #x1F19	;GREEK CAPITAL LETTER EPSILON WITH DASIA
      #x1F1A	;GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
      #x1F1B	;GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
      #x1F1C	;GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
      #x1F1D	;GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
      #x1F20	;GREEK SMALL LETTER ETA WITH PSILI
      #x1F21	;GREEK SMALL LETTER ETA WITH DASIA
      #x1F22	;GREEK SMALL LETTER ETA WITH PSILI AND VARIA
      #x1F23	;GREEK SMALL LETTER ETA WITH DASIA AND VARIA
      #x1F24	;GREEK SMALL LETTER ETA WITH PSILI AND OXIA
      #x1F25	;GREEK SMALL LETTER ETA WITH DASIA AND OXIA
      #x1F26	;GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI
      #x1F27	;GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
      #x1F28	;GREEK CAPITAL LETTER ETA WITH PSILI
      #x1F29	;GREEK CAPITAL LETTER ETA WITH DASIA
      #x1F2A	;GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
      #x1F2B	;GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
      #x1F2C	;GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
      #x1F2D	;GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
      #x1F2E	;GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
      #x1F2F	;GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
      #x1F30	;GREEK SMALL LETTER IOTA WITH PSILI
      #x1F31	;GREEK SMALL LETTER IOTA WITH DASIA
      #x1F32	;GREEK SMALL LETTER IOTA WITH PSILI AND VARIA
      #x1F33	;GREEK SMALL LETTER IOTA WITH DASIA AND VARIA
      #x1F34	;GREEK SMALL LETTER IOTA WITH PSILI AND OXIA
      #x1F35	;GREEK SMALL LETTER IOTA WITH DASIA AND OXIA
      #x1F36	;GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI
      #x1F37	;GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
      #x1F38	;GREEK CAPITAL LETTER IOTA WITH PSILI
      #x1F39	;GREEK CAPITAL LETTER IOTA WITH DASIA
      #x1F3A	;GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
      #x1F3B	;GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
      #x1F3C	;GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
      #x1F3D	;GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
      #x1F3E	;GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
      #x1F3F	;GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
      #x1F40	;GREEK SMALL LETTER OMICRON WITH PSILI
      #x1F41	;GREEK SMALL LETTER OMICRON WITH DASIA
      #x1F42	;GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA
      #x1F43	;GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA
      #x1F44	;GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA
      #x1F45	;GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
      #x1F48	;GREEK CAPITAL LETTER OMICRON WITH PSILI
      #x1F49	;GREEK CAPITAL LETTER OMICRON WITH DASIA
      #x1F4A	;GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
      #x1F4B	;GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
      #x1F4C	;GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
      #x1F4D	;GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
      #x1F50	;GREEK SMALL LETTER UPSILON WITH PSILI
      #x1F51	;GREEK SMALL LETTER UPSILON WITH DASIA
      #x1F52	;GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
      #x1F53	;GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
      #x1F54	;GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
      #x1F55	;GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
      #x1F56	;GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
      #x1F57	;GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
      #x1F59	;GREEK CAPITAL LETTER UPSILON WITH DASIA
      #x1F5B	;GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
      #x1F5D	;GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
      #x1F5F	;GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
      #x1F60	;GREEK SMALL LETTER OMEGA WITH PSILI
      #x1F61	;GREEK SMALL LETTER OMEGA WITH DASIA
      #x1F62	;GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA
      #x1F63	;GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA
      #x1F64	;GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA
      #x1F65	;GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA
      #x1F66	;GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI
      #x1F67	;GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
      #x1F68	;GREEK CAPITAL LETTER OMEGA WITH PSILI
      #x1F69	;GREEK CAPITAL LETTER OMEGA WITH DASIA
      #x1F6A	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
      #x1F6B	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
      #x1F6C	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
      #x1F6D	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
      #x1F6E	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
      #x1F6F	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
      #x1F70	;GREEK SMALL LETTER ALPHA WITH VARIA
      #x1F71	;GREEK SMALL LETTER ALPHA WITH OXIA
      #x1F72	;GREEK SMALL LETTER EPSILON WITH VARIA
      #x1F73	;GREEK SMALL LETTER EPSILON WITH OXIA
      #x1F74	;GREEK SMALL LETTER ETA WITH VARIA
      #x1F75	;GREEK SMALL LETTER ETA WITH OXIA
      #x1F76	;GREEK SMALL LETTER IOTA WITH VARIA
      #x1F77	;GREEK SMALL LETTER IOTA WITH OXIA
      #x1F78	;GREEK SMALL LETTER OMICRON WITH VARIA
      #x1F79	;GREEK SMALL LETTER OMICRON WITH OXIA
      #x1F7A	;GREEK SMALL LETTER UPSILON WITH VARIA
      #x1F7B	;GREEK SMALL LETTER UPSILON WITH OXIA
      #x1F7C	;GREEK SMALL LETTER OMEGA WITH VARIA
      #x1F7D	;GREEK SMALL LETTER OMEGA WITH OXIA
      #x1F80	;GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
      #x1F81	;GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
      #x1F82	;GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      #x1F83	;GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      #x1F84	;GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      #x1F85	;GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      #x1F86	;GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F87	;GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F88	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
      #x1F89	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
      #x1F8A	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1F8B	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1F8C	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1F8D	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1F8E	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F8F	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F90	;GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
      #x1F91	;GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
      #x1F92	;GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      #x1F93	;GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      #x1F94	;GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      #x1F95	;GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      #x1F96	;GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F97	;GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F98	;GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
      #x1F99	;GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
      #x1F9A	;GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1F9B	;GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1F9C	;GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1F9D	;GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1F9E	;GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F9F	;GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FA0	;GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
      #x1FA1	;GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
      #x1FA2	;GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      #x1FA3	;GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      #x1FA4	;GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      #x1FA5	;GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      #x1FA6	;GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      #x1FA7	;GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      #x1FA8	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
      #x1FA9	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
      #x1FAA	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1FAB	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1FAC	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1FAD	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1FAE	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FAF	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FB0	;GREEK SMALL LETTER ALPHA WITH VRACHY
      #x1FB1	;GREEK SMALL LETTER ALPHA WITH MACRON
      #x1FB2	;GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
      #x1FB3	;GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
      #x1FB4	;GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
      #x1FB6	;GREEK SMALL LETTER ALPHA WITH PERISPOMENI
      #x1FB7	;GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
      #x1FB8	;GREEK CAPITAL LETTER ALPHA WITH VRACHY
      #x1FB9	;GREEK CAPITAL LETTER ALPHA WITH MACRON
      #x1FBA	;GREEK CAPITAL LETTER ALPHA WITH VARIA
      #x1FBB	;GREEK CAPITAL LETTER ALPHA WITH OXIA
      #x1FBC	;GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
      #x1FBE	;GREEK PROSGEGRAMMENI
      #x1FC2	;GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
      #x1FC3	;GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
      #x1FC4	;GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
      #x1FC6	;GREEK SMALL LETTER ETA WITH PERISPOMENI
      #x1FC7	;GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
      #x1FC8	;GREEK CAPITAL LETTER EPSILON WITH VARIA
      #x1FC9	;GREEK CAPITAL LETTER EPSILON WITH OXIA
      #x1FCA	;GREEK CAPITAL LETTER ETA WITH VARIA
      #x1FCB	;GREEK CAPITAL LETTER ETA WITH OXIA
      #x1FCC	;GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
      #x1FD0	;GREEK SMALL LETTER IOTA WITH VRACHY
      #x1FD1	;GREEK SMALL LETTER IOTA WITH MACRON
      #x1FD2	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
      #x1FD3	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
      #x1FD6	;GREEK SMALL LETTER IOTA WITH PERISPOMENI
      #x1FD7	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
      #x1FD8	;GREEK CAPITAL LETTER IOTA WITH VRACHY
      #x1FD9	;GREEK CAPITAL LETTER IOTA WITH MACRON
      #x1FDA	;GREEK CAPITAL LETTER IOTA WITH VARIA
      #x1FDB	;GREEK CAPITAL LETTER IOTA WITH OXIA
      #x1FE0	;GREEK SMALL LETTER UPSILON WITH VRACHY
      #x1FE1	;GREEK SMALL LETTER UPSILON WITH MACRON
      #x1FE2	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
      #x1FE3	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
      #x1FE4	;GREEK SMALL LETTER RHO WITH PSILI
      #x1FE5	;GREEK SMALL LETTER RHO WITH DASIA
      #x1FE6	;GREEK SMALL LETTER UPSILON WITH PERISPOMENI
      #x1FE7	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
      #x1FE8	;GREEK CAPITAL LETTER UPSILON WITH VRACHY
      #x1FE9	;GREEK CAPITAL LETTER UPSILON WITH MACRON
      #x1FEA	;GREEK CAPITAL LETTER UPSILON WITH VARIA
      #x1FEB	;GREEK CAPITAL LETTER UPSILON WITH OXIA
      #x1FEC	;GREEK CAPITAL LETTER RHO WITH DASIA
      #x1FF2	;GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
      #x1FF3	;GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
      #x1FF4	;GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
      #x1FF6	;GREEK SMALL LETTER OMEGA WITH PERISPOMENI
      #x1FF7	;GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
      #x1FF8	;GREEK CAPITAL LETTER OMICRON WITH VARIA
      #x1FF9	;GREEK CAPITAL LETTER OMICRON WITH OXIA
      #x1FFA	;GREEK CAPITAL LETTER OMEGA WITH VARIA
      #x1FFB	;GREEK CAPITAL LETTER OMEGA WITH OXIA
      #x1FFC	;GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
      #x2071	;SUPERSCRIPT LATIN SMALL LETTER I
      #x207F	;SUPERSCRIPT LATIN SMALL LETTER N
      #x2102	;DOUBLE-STRUCK CAPITAL C
      #x2107	;EULER CONSTANT
      #x210A	;SCRIPT SMALL G
      #x210B	;SCRIPT CAPITAL H
      #x210C	;BLACK-LETTER CAPITAL H
      #x210D	;DOUBLE-STRUCK CAPITAL H
      #x210E	;PLANCK CONSTANT
      #x210F	;PLANCK CONSTANT OVER TWO PI
      #x2110	;SCRIPT CAPITAL I
      #x2111	;BLACK-LETTER CAPITAL I
      #x2112	;SCRIPT CAPITAL L
      #x2113	;SCRIPT SMALL L
      #x2115	;DOUBLE-STRUCK CAPITAL N
      #x2119	;DOUBLE-STRUCK CAPITAL P
      #x211A	;DOUBLE-STRUCK CAPITAL Q
      #x211B	;SCRIPT CAPITAL R
      #x211C	;BLACK-LETTER CAPITAL R
      #x211D	;DOUBLE-STRUCK CAPITAL R
      #x2124	;DOUBLE-STRUCK CAPITAL Z
      #x2126	;OHM SIGN
      #x2128	;BLACK-LETTER CAPITAL Z
      #x212A	;KELVIN SIGN
      #x212B	;ANGSTROM SIGN
      #x212C	;SCRIPT CAPITAL B
      #x212D	;BLACK-LETTER CAPITAL C
      #x212F	;SCRIPT SMALL E
      #x2130	;SCRIPT CAPITAL E
      #x2131	;SCRIPT CAPITAL F
      #x2133	;SCRIPT CAPITAL M
      #x2134	;SCRIPT SMALL O
      #x2135	;ALEF SYMBOL
      #x2136	;BET SYMBOL
      #x2137	;GIMEL SYMBOL
      #x2138	;DALET SYMBOL
      #x2139	;INFORMATION SOURCE
      #x213D	;DOUBLE-STRUCK SMALL GAMMA
      #x213E	;DOUBLE-STRUCK CAPITAL GAMMA
      #x213F	;DOUBLE-STRUCK CAPITAL PI
      #x2145	;DOUBLE-STRUCK ITALIC CAPITAL D
      #x2146	;DOUBLE-STRUCK ITALIC SMALL D
      #x2147	;DOUBLE-STRUCK ITALIC SMALL E
      #x2148	;DOUBLE-STRUCK ITALIC SMALL I
      #x2149	;DOUBLE-STRUCK ITALIC SMALL J
      #x3005	;IDEOGRAPHIC ITERATION MARK
      #x3006	;IDEOGRAPHIC CLOSING MARK
      #x3031	;VERTICAL KANA REPEAT MARK
      #x3032	;VERTICAL KANA REPEAT WITH VOICED SOUND MARK
      #x3033	;VERTICAL KANA REPEAT MARK UPPER HALF
      #x3034	;VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF
      #x3035	;VERTICAL KANA REPEAT MARK LOWER HALF
      #x303B	;VERTICAL IDEOGRAPHIC ITERATION MARK
      #x303C	;MASU MARK
      #x3041	;HIRAGANA LETTER SMALL A
      #x3042	;HIRAGANA LETTER A
      #x3043	;HIRAGANA LETTER SMALL I
      #x3044	;HIRAGANA LETTER I
      #x3045	;HIRAGANA LETTER SMALL U
      #x3046	;HIRAGANA LETTER U
      #x3047	;HIRAGANA LETTER SMALL E
      #x3048	;HIRAGANA LETTER E
      #x3049	;HIRAGANA LETTER SMALL O
      #x304A	;HIRAGANA LETTER O
      #x304B	;HIRAGANA LETTER KA
      #x304C	;HIRAGANA LETTER GA
      #x304D	;HIRAGANA LETTER KI
      #x304E	;HIRAGANA LETTER GI
      #x304F	;HIRAGANA LETTER KU
      #x3050	;HIRAGANA LETTER GU
      #x3051	;HIRAGANA LETTER KE
      #x3052	;HIRAGANA LETTER GE
      #x3053	;HIRAGANA LETTER KO
      #x3054	;HIRAGANA LETTER GO
      #x3055	;HIRAGANA LETTER SA
      #x3056	;HIRAGANA LETTER ZA
      #x3057	;HIRAGANA LETTER SI
      #x3058	;HIRAGANA LETTER ZI
      #x3059	;HIRAGANA LETTER SU
      #x305A	;HIRAGANA LETTER ZU
      #x305B	;HIRAGANA LETTER SE
      #x305C	;HIRAGANA LETTER ZE
      #x305D	;HIRAGANA LETTER SO
      #x305E	;HIRAGANA LETTER ZO
      #x305F	;HIRAGANA LETTER TA
      #x3060	;HIRAGANA LETTER DA
      #x3061	;HIRAGANA LETTER TI
      #x3062	;HIRAGANA LETTER DI
      #x3063	;HIRAGANA LETTER SMALL TU
      #x3064	;HIRAGANA LETTER TU
      #x3065	;HIRAGANA LETTER DU
      #x3066	;HIRAGANA LETTER TE
      #x3067	;HIRAGANA LETTER DE
      #x3068	;HIRAGANA LETTER TO
      #x3069	;HIRAGANA LETTER DO
      #x306A	;HIRAGANA LETTER NA
      #x306B	;HIRAGANA LETTER NI
      #x306C	;HIRAGANA LETTER NU
      #x306D	;HIRAGANA LETTER NE
      #x306E	;HIRAGANA LETTER NO
      #x306F	;HIRAGANA LETTER HA
      #x3070	;HIRAGANA LETTER BA
      #x3071	;HIRAGANA LETTER PA
      #x3072	;HIRAGANA LETTER HI
      #x3073	;HIRAGANA LETTER BI
      #x3074	;HIRAGANA LETTER PI
      #x3075	;HIRAGANA LETTER HU
      #x3076	;HIRAGANA LETTER BU
      #x3077	;HIRAGANA LETTER PU
      #x3078	;HIRAGANA LETTER HE
      #x3079	;HIRAGANA LETTER BE
      #x307A	;HIRAGANA LETTER PE
      #x307B	;HIRAGANA LETTER HO
      #x307C	;HIRAGANA LETTER BO
      #x307D	;HIRAGANA LETTER PO
      #x307E	;HIRAGANA LETTER MA
      #x307F	;HIRAGANA LETTER MI
      #x3080	;HIRAGANA LETTER MU
      #x3081	;HIRAGANA LETTER ME
      #x3082	;HIRAGANA LETTER MO
      #x3083	;HIRAGANA LETTER SMALL YA
      #x3084	;HIRAGANA LETTER YA
      #x3085	;HIRAGANA LETTER SMALL YU
      #x3086	;HIRAGANA LETTER YU
      #x3087	;HIRAGANA LETTER SMALL YO
      #x3088	;HIRAGANA LETTER YO
      #x3089	;HIRAGANA LETTER RA
      #x308A	;HIRAGANA LETTER RI
      #x308B	;HIRAGANA LETTER RU
      #x308C	;HIRAGANA LETTER RE
      #x308D	;HIRAGANA LETTER RO
      #x308E	;HIRAGANA LETTER SMALL WA
      #x308F	;HIRAGANA LETTER WA
      #x3090	;HIRAGANA LETTER WI
      #x3091	;HIRAGANA LETTER WE
      #x3092	;HIRAGANA LETTER WO
      #x3093	;HIRAGANA LETTER N
      #x3094	;HIRAGANA LETTER VU
      #x3095	;HIRAGANA LETTER SMALL KA
      #x3096	;HIRAGANA LETTER SMALL KE
      #x309D	;HIRAGANA ITERATION MARK
      #x309E	;HIRAGANA VOICED ITERATION MARK
      #x309F	;HIRAGANA DIGRAPH YORI
      #x30A1	;KATAKANA LETTER SMALL A
      #x30A2	;KATAKANA LETTER A
      #x30A3	;KATAKANA LETTER SMALL I
      #x30A4	;KATAKANA LETTER I
      #x30A5	;KATAKANA LETTER SMALL U
      #x30A6	;KATAKANA LETTER U
      #x30A7	;KATAKANA LETTER SMALL E
      #x30A8	;KATAKANA LETTER E
      #x30A9	;KATAKANA LETTER SMALL O
      #x30AA	;KATAKANA LETTER O
      #x30AB	;KATAKANA LETTER KA
      #x30AC	;KATAKANA LETTER GA
      #x30AD	;KATAKANA LETTER KI
      #x30AE	;KATAKANA LETTER GI
      #x30AF	;KATAKANA LETTER KU
      #x30B0	;KATAKANA LETTER GU
      #x30B1	;KATAKANA LETTER KE
      #x30B2	;KATAKANA LETTER GE
      #x30B3	;KATAKANA LETTER KO
      #x30B4	;KATAKANA LETTER GO
      #x30B5	;KATAKANA LETTER SA
      #x30B6	;KATAKANA LETTER ZA
      #x30B7	;KATAKANA LETTER SI
      #x30B8	;KATAKANA LETTER ZI
      #x30B9	;KATAKANA LETTER SU
      #x30BA	;KATAKANA LETTER ZU
      #x30BB	;KATAKANA LETTER SE
      #x30BC	;KATAKANA LETTER ZE
      #x30BD	;KATAKANA LETTER SO
      #x30BE	;KATAKANA LETTER ZO
      #x30BF	;KATAKANA LETTER TA
      #x30C0	;KATAKANA LETTER DA
      #x30C1	;KATAKANA LETTER TI
      #x30C2	;KATAKANA LETTER DI
      #x30C3	;KATAKANA LETTER SMALL TU
      #x30C4	;KATAKANA LETTER TU
      #x30C5	;KATAKANA LETTER DU
      #x30C6	;KATAKANA LETTER TE
      #x30C7	;KATAKANA LETTER DE
      #x30C8	;KATAKANA LETTER TO
      #x30C9	;KATAKANA LETTER DO
      #x30CA	;KATAKANA LETTER NA
      #x30CB	;KATAKANA LETTER NI
      #x30CC	;KATAKANA LETTER NU
      #x30CD	;KATAKANA LETTER NE
      #x30CE	;KATAKANA LETTER NO
      #x30CF	;KATAKANA LETTER HA
      #x30D0	;KATAKANA LETTER BA
      #x30D1	;KATAKANA LETTER PA
      #x30D2	;KATAKANA LETTER HI
      #x30D3	;KATAKANA LETTER BI
      #x30D4	;KATAKANA LETTER PI
      #x30D5	;KATAKANA LETTER HU
      #x30D6	;KATAKANA LETTER BU
      #x30D7	;KATAKANA LETTER PU
      #x30D8	;KATAKANA LETTER HE
      #x30D9	;KATAKANA LETTER BE
      #x30DA	;KATAKANA LETTER PE
      #x30DB	;KATAKANA LETTER HO
      #x30DC	;KATAKANA LETTER BO
      #x30DD	;KATAKANA LETTER PO
      #x30DE	;KATAKANA LETTER MA
      #x30DF	;KATAKANA LETTER MI
      #x30E0	;KATAKANA LETTER MU
      #x30E1	;KATAKANA LETTER ME
      #x30E2	;KATAKANA LETTER MO
      #x30E3	;KATAKANA LETTER SMALL YA
      #x30E4	;KATAKANA LETTER YA
      #x30E5	;KATAKANA LETTER SMALL YU
      #x30E6	;KATAKANA LETTER YU
      #x30E7	;KATAKANA LETTER SMALL YO
      #x30E8	;KATAKANA LETTER YO
      #x30E9	;KATAKANA LETTER RA
      #x30EA	;KATAKANA LETTER RI
      #x30EB	;KATAKANA LETTER RU
      #x30EC	;KATAKANA LETTER RE
      #x30ED	;KATAKANA LETTER RO
      #x30EE	;KATAKANA LETTER SMALL WA
      #x30EF	;KATAKANA LETTER WA
      #x30F0	;KATAKANA LETTER WI
      #x30F1	;KATAKANA LETTER WE
      #x30F2	;KATAKANA LETTER WO
      #x30F3	;KATAKANA LETTER N
      #x30F4	;KATAKANA LETTER VU
      #x30F5	;KATAKANA LETTER SMALL KA
      #x30F6	;KATAKANA LETTER SMALL KE
      #x30F7	;KATAKANA LETTER VA
      #x30F8	;KATAKANA LETTER VI
      #x30F9	;KATAKANA LETTER VE
      #x30FA	;KATAKANA LETTER VO
      #x30FC	;KATAKANA-HIRAGANA PROLONGED SOUND MARK
      #x30FD	;KATAKANA ITERATION MARK
      #x30FE	;KATAKANA VOICED ITERATION MARK
      #x30FF	;KATAKANA DIGRAPH KOTO
      #x3105	;BOPOMOFO LETTER B
      #x3106	;BOPOMOFO LETTER P
      #x3107	;BOPOMOFO LETTER M
      #x3108	;BOPOMOFO LETTER F
      #x3109	;BOPOMOFO LETTER D
      #x310A	;BOPOMOFO LETTER T
      #x310B	;BOPOMOFO LETTER N
      #x310C	;BOPOMOFO LETTER L
      #x310D	;BOPOMOFO LETTER G
      #x310E	;BOPOMOFO LETTER K
      #x310F	;BOPOMOFO LETTER H
      #x3110	;BOPOMOFO LETTER J
      #x3111	;BOPOMOFO LETTER Q
      #x3112	;BOPOMOFO LETTER X
      #x3113	;BOPOMOFO LETTER ZH
      #x3114	;BOPOMOFO LETTER CH
      #x3115	;BOPOMOFO LETTER SH
      #x3116	;BOPOMOFO LETTER R
      #x3117	;BOPOMOFO LETTER Z
      #x3118	;BOPOMOFO LETTER C
      #x3119	;BOPOMOFO LETTER S
      #x311A	;BOPOMOFO LETTER A
      #x311B	;BOPOMOFO LETTER O
      #x311C	;BOPOMOFO LETTER E
      #x311D	;BOPOMOFO LETTER EH
      #x311E	;BOPOMOFO LETTER AI
      #x311F	;BOPOMOFO LETTER EI
      #x3120	;BOPOMOFO LETTER AU
      #x3121	;BOPOMOFO LETTER OU
      #x3122	;BOPOMOFO LETTER AN
      #x3123	;BOPOMOFO LETTER EN
      #x3124	;BOPOMOFO LETTER ANG
      #x3125	;BOPOMOFO LETTER ENG
      #x3126	;BOPOMOFO LETTER ER
      #x3127	;BOPOMOFO LETTER I
      #x3128	;BOPOMOFO LETTER U
      #x3129	;BOPOMOFO LETTER IU
      #x312A	;BOPOMOFO LETTER V
      #x312B	;BOPOMOFO LETTER NG
      #x312C	;BOPOMOFO LETTER GN
      #x3131	;HANGUL LETTER KIYEOK
      #x3132	;HANGUL LETTER SSANGKIYEOK
      #x3133	;HANGUL LETTER KIYEOK-SIOS
      #x3134	;HANGUL LETTER NIEUN
      #x3135	;HANGUL LETTER NIEUN-CIEUC
      #x3136	;HANGUL LETTER NIEUN-HIEUH
      #x3137	;HANGUL LETTER TIKEUT
      #x3138	;HANGUL LETTER SSANGTIKEUT
      #x3139	;HANGUL LETTER RIEUL
      #x313A	;HANGUL LETTER RIEUL-KIYEOK
      #x313B	;HANGUL LETTER RIEUL-MIEUM
      #x313C	;HANGUL LETTER RIEUL-PIEUP
      #x313D	;HANGUL LETTER RIEUL-SIOS
      #x313E	;HANGUL LETTER RIEUL-THIEUTH
      #x313F	;HANGUL LETTER RIEUL-PHIEUPH
      #x3140	;HANGUL LETTER RIEUL-HIEUH
      #x3141	;HANGUL LETTER MIEUM
      #x3142	;HANGUL LETTER PIEUP
      #x3143	;HANGUL LETTER SSANGPIEUP
      #x3144	;HANGUL LETTER PIEUP-SIOS
      #x3145	;HANGUL LETTER SIOS
      #x3146	;HANGUL LETTER SSANGSIOS
      #x3147	;HANGUL LETTER IEUNG
      #x3148	;HANGUL LETTER CIEUC
      #x3149	;HANGUL LETTER SSANGCIEUC
      #x314A	;HANGUL LETTER CHIEUCH
      #x314B	;HANGUL LETTER KHIEUKH
      #x314C	;HANGUL LETTER THIEUTH
      #x314D	;HANGUL LETTER PHIEUPH
      #x314E	;HANGUL LETTER HIEUH
      #x314F	;HANGUL LETTER A
      #x3150	;HANGUL LETTER AE
      #x3151	;HANGUL LETTER YA
      #x3152	;HANGUL LETTER YAE
      #x3153	;HANGUL LETTER EO
      #x3154	;HANGUL LETTER E
      #x3155	;HANGUL LETTER YEO
      #x3156	;HANGUL LETTER YE
      #x3157	;HANGUL LETTER O
      #x3158	;HANGUL LETTER WA
      #x3159	;HANGUL LETTER WAE
      #x315A	;HANGUL LETTER OE
      #x315B	;HANGUL LETTER YO
      #x315C	;HANGUL LETTER U
      #x315D	;HANGUL LETTER WEO
      #x315E	;HANGUL LETTER WE
      #x315F	;HANGUL LETTER WI
      #x3160	;HANGUL LETTER YU
      #x3161	;HANGUL LETTER EU
      #x3162	;HANGUL LETTER YI
      #x3163	;HANGUL LETTER I
      #x3164	;HANGUL FILLER
      #x3165	;HANGUL LETTER SSANGNIEUN
      #x3166	;HANGUL LETTER NIEUN-TIKEUT
      #x3167	;HANGUL LETTER NIEUN-SIOS
      #x3168	;HANGUL LETTER NIEUN-PANSIOS
      #x3169	;HANGUL LETTER RIEUL-KIYEOK-SIOS
      #x316A	;HANGUL LETTER RIEUL-TIKEUT
      #x316B	;HANGUL LETTER RIEUL-PIEUP-SIOS
      #x316C	;HANGUL LETTER RIEUL-PANSIOS
      #x316D	;HANGUL LETTER RIEUL-YEORINHIEUH
      #x316E	;HANGUL LETTER MIEUM-PIEUP
      #x316F	;HANGUL LETTER MIEUM-SIOS
      #x3170	;HANGUL LETTER MIEUM-PANSIOS
      #x3171	;HANGUL LETTER KAPYEOUNMIEUM
      #x3172	;HANGUL LETTER PIEUP-KIYEOK
      #x3173	;HANGUL LETTER PIEUP-TIKEUT
      #x3174	;HANGUL LETTER PIEUP-SIOS-KIYEOK
      #x3175	;HANGUL LETTER PIEUP-SIOS-TIKEUT
      #x3176	;HANGUL LETTER PIEUP-CIEUC
      #x3177	;HANGUL LETTER PIEUP-THIEUTH
      #x3178	;HANGUL LETTER KAPYEOUNPIEUP
      #x3179	;HANGUL LETTER KAPYEOUNSSANGPIEUP
      #x317A	;HANGUL LETTER SIOS-KIYEOK
      #x317B	;HANGUL LETTER SIOS-NIEUN
      #x317C	;HANGUL LETTER SIOS-TIKEUT
      #x317D	;HANGUL LETTER SIOS-PIEUP
      #x317E	;HANGUL LETTER SIOS-CIEUC
      #x317F	;HANGUL LETTER PANSIOS
      #x3180	;HANGUL LETTER SSANGIEUNG
      #x3181	;HANGUL LETTER YESIEUNG
      #x3182	;HANGUL LETTER YESIEUNG-SIOS
      #x3183	;HANGUL LETTER YESIEUNG-PANSIOS
      #x3184	;HANGUL LETTER KAPYEOUNPHIEUPH
      #x3185	;HANGUL LETTER SSANGHIEUH
      #x3186	;HANGUL LETTER YEORINHIEUH
      #x3187	;HANGUL LETTER YO-YA
      #x3188	;HANGUL LETTER YO-YAE
      #x3189	;HANGUL LETTER YO-I
      #x318A	;HANGUL LETTER YU-YEO
      #x318B	;HANGUL LETTER YU-YE
      #x318C	;HANGUL LETTER YU-I
      #x318D	;HANGUL LETTER ARAEA
      #x318E	;HANGUL LETTER ARAEAE
      #x31A0	;BOPOMOFO LETTER BU
      #x31A1	;BOPOMOFO LETTER ZI
      #x31A2	;BOPOMOFO LETTER JI
      #x31A3	;BOPOMOFO LETTER GU
      #x31A4	;BOPOMOFO LETTER EE
      #x31A5	;BOPOMOFO LETTER ENN
      #x31A6	;BOPOMOFO LETTER OO
      #x31A7	;BOPOMOFO LETTER ONN
      #x31A8	;BOPOMOFO LETTER IR
      #x31A9	;BOPOMOFO LETTER ANN
      #x31AA	;BOPOMOFO LETTER INN
      #x31AB	;BOPOMOFO LETTER UNN
      #x31AC	;BOPOMOFO LETTER IM
      #x31AD	;BOPOMOFO LETTER NGG
      #x31AE	;BOPOMOFO LETTER AINN
      #x31AF	;BOPOMOFO LETTER AUNN
      #x31B0	;BOPOMOFO LETTER AM
      #x31B1	;BOPOMOFO LETTER OM
      #x31B2	;BOPOMOFO LETTER ONG
      #x31B3	;BOPOMOFO LETTER INNN
      #x31B4	;BOPOMOFO FINAL LETTER P
      #x31B5	;BOPOMOFO FINAL LETTER T
      #x31B6	;BOPOMOFO FINAL LETTER K
      #x31B7	;BOPOMOFO FINAL LETTER H
      #x31F0	;KATAKANA LETTER SMALL KU
      #x31F1	;KATAKANA LETTER SMALL SI
      #x31F2	;KATAKANA LETTER SMALL SU
      #x31F3	;KATAKANA LETTER SMALL TO
      #x31F4	;KATAKANA LETTER SMALL NU
      #x31F5	;KATAKANA LETTER SMALL HA
      #x31F6	;KATAKANA LETTER SMALL HI
      #x31F7	;KATAKANA LETTER SMALL HU
      #x31F8	;KATAKANA LETTER SMALL HE
      #x31F9	;KATAKANA LETTER SMALL HO
      #x31FA	;KATAKANA LETTER SMALL MU
      #x31FB	;KATAKANA LETTER SMALL RA
      #x31FC	;KATAKANA LETTER SMALL RI
      #x31FD	;KATAKANA LETTER SMALL RU
      #x31FE	;KATAKANA LETTER SMALL RE
      #x31FF	;KATAKANA LETTER SMALL RO
      #x3400	;<CJK Ideograph Extension A, First>
      #x4DB5	;<CJK Ideograph Extension A, Last>
      #x4E00	;<CJK Ideograph, First>
      #x9FA5	;<CJK Ideograph, Last>
      #xA000	;YI SYLLABLE IT
      #xA001	;YI SYLLABLE IX
      #xA002	;YI SYLLABLE I
      #xA003	;YI SYLLABLE IP
      #xA004	;YI SYLLABLE IET
      #xA005	;YI SYLLABLE IEX
      #xA006	;YI SYLLABLE IE
      #xA007	;YI SYLLABLE IEP
      #xA008	;YI SYLLABLE AT
      #xA009	;YI SYLLABLE AX
      #xA00A	;YI SYLLABLE A
      #xA00B	;YI SYLLABLE AP
      #xA00C	;YI SYLLABLE UOX
      #xA00D	;YI SYLLABLE UO
      #xA00E	;YI SYLLABLE UOP
      #xA00F	;YI SYLLABLE OT
      #xA010	;YI SYLLABLE OX
      #xA011	;YI SYLLABLE O
      #xA012	;YI SYLLABLE OP
      #xA013	;YI SYLLABLE EX
      #xA014	;YI SYLLABLE E
      #xA015	;YI SYLLABLE WU
      #xA016	;YI SYLLABLE BIT
      #xA017	;YI SYLLABLE BIX
      #xA018	;YI SYLLABLE BI
      #xA019	;YI SYLLABLE BIP
      #xA01A	;YI SYLLABLE BIET
      #xA01B	;YI SYLLABLE BIEX
      #xA01C	;YI SYLLABLE BIE
      #xA01D	;YI SYLLABLE BIEP
      #xA01E	;YI SYLLABLE BAT
      #xA01F	;YI SYLLABLE BAX
      #xA020	;YI SYLLABLE BA
      #xA021	;YI SYLLABLE BAP
      #xA022	;YI SYLLABLE BUOX
      #xA023	;YI SYLLABLE BUO
      #xA024	;YI SYLLABLE BUOP
      #xA025	;YI SYLLABLE BOT
      #xA026	;YI SYLLABLE BOX
      #xA027	;YI SYLLABLE BO
      #xA028	;YI SYLLABLE BOP
      #xA029	;YI SYLLABLE BEX
      #xA02A	;YI SYLLABLE BE
      #xA02B	;YI SYLLABLE BEP
      #xA02C	;YI SYLLABLE BUT
      #xA02D	;YI SYLLABLE BUX
      #xA02E	;YI SYLLABLE BU
      #xA02F	;YI SYLLABLE BUP
      #xA030	;YI SYLLABLE BURX
      #xA031	;YI SYLLABLE BUR
      #xA032	;YI SYLLABLE BYT
      #xA033	;YI SYLLABLE BYX
      #xA034	;YI SYLLABLE BY
      #xA035	;YI SYLLABLE BYP
      #xA036	;YI SYLLABLE BYRX
      #xA037	;YI SYLLABLE BYR
      #xA038	;YI SYLLABLE PIT
      #xA039	;YI SYLLABLE PIX
      #xA03A	;YI SYLLABLE PI
      #xA03B	;YI SYLLABLE PIP
      #xA03C	;YI SYLLABLE PIEX
      #xA03D	;YI SYLLABLE PIE
      #xA03E	;YI SYLLABLE PIEP
      #xA03F	;YI SYLLABLE PAT
      #xA040	;YI SYLLABLE PAX
      #xA041	;YI SYLLABLE PA
      #xA042	;YI SYLLABLE PAP
      #xA043	;YI SYLLABLE PUOX
      #xA044	;YI SYLLABLE PUO
      #xA045	;YI SYLLABLE PUOP
      #xA046	;YI SYLLABLE POT
      #xA047	;YI SYLLABLE POX
      #xA048	;YI SYLLABLE PO
      #xA049	;YI SYLLABLE POP
      #xA04A	;YI SYLLABLE PUT
      #xA04B	;YI SYLLABLE PUX
      #xA04C	;YI SYLLABLE PU
      #xA04D	;YI SYLLABLE PUP
      #xA04E	;YI SYLLABLE PURX
      #xA04F	;YI SYLLABLE PUR
      #xA050	;YI SYLLABLE PYT
      #xA051	;YI SYLLABLE PYX
      #xA052	;YI SYLLABLE PY
      #xA053	;YI SYLLABLE PYP
      #xA054	;YI SYLLABLE PYRX
      #xA055	;YI SYLLABLE PYR
      #xA056	;YI SYLLABLE BBIT
      #xA057	;YI SYLLABLE BBIX
      #xA058	;YI SYLLABLE BBI
      #xA059	;YI SYLLABLE BBIP
      #xA05A	;YI SYLLABLE BBIET
      #xA05B	;YI SYLLABLE BBIEX
      #xA05C	;YI SYLLABLE BBIE
      #xA05D	;YI SYLLABLE BBIEP
      #xA05E	;YI SYLLABLE BBAT
      #xA05F	;YI SYLLABLE BBAX
      #xA060	;YI SYLLABLE BBA
      #xA061	;YI SYLLABLE BBAP
      #xA062	;YI SYLLABLE BBUOX
      #xA063	;YI SYLLABLE BBUO
      #xA064	;YI SYLLABLE BBUOP
      #xA065	;YI SYLLABLE BBOT
      #xA066	;YI SYLLABLE BBOX
      #xA067	;YI SYLLABLE BBO
      #xA068	;YI SYLLABLE BBOP
      #xA069	;YI SYLLABLE BBEX
      #xA06A	;YI SYLLABLE BBE
      #xA06B	;YI SYLLABLE BBEP
      #xA06C	;YI SYLLABLE BBUT
      #xA06D	;YI SYLLABLE BBUX
      #xA06E	;YI SYLLABLE BBU
      #xA06F	;YI SYLLABLE BBUP
      #xA070	;YI SYLLABLE BBURX
      #xA071	;YI SYLLABLE BBUR
      #xA072	;YI SYLLABLE BBYT
      #xA073	;YI SYLLABLE BBYX
      #xA074	;YI SYLLABLE BBY
      #xA075	;YI SYLLABLE BBYP
      #xA076	;YI SYLLABLE NBIT
      #xA077	;YI SYLLABLE NBIX
      #xA078	;YI SYLLABLE NBI
      #xA079	;YI SYLLABLE NBIP
      #xA07A	;YI SYLLABLE NBIEX
      #xA07B	;YI SYLLABLE NBIE
      #xA07C	;YI SYLLABLE NBIEP
      #xA07D	;YI SYLLABLE NBAT
      #xA07E	;YI SYLLABLE NBAX
      #xA07F	;YI SYLLABLE NBA
      #xA080	;YI SYLLABLE NBAP
      #xA081	;YI SYLLABLE NBOT
      #xA082	;YI SYLLABLE NBOX
      #xA083	;YI SYLLABLE NBO
      #xA084	;YI SYLLABLE NBOP
      #xA085	;YI SYLLABLE NBUT
      #xA086	;YI SYLLABLE NBUX
      #xA087	;YI SYLLABLE NBU
      #xA088	;YI SYLLABLE NBUP
      #xA089	;YI SYLLABLE NBURX
      #xA08A	;YI SYLLABLE NBUR
      #xA08B	;YI SYLLABLE NBYT
      #xA08C	;YI SYLLABLE NBYX
      #xA08D	;YI SYLLABLE NBY
      #xA08E	;YI SYLLABLE NBYP
      #xA08F	;YI SYLLABLE NBYRX
      #xA090	;YI SYLLABLE NBYR
      #xA091	;YI SYLLABLE HMIT
      #xA092	;YI SYLLABLE HMIX
      #xA093	;YI SYLLABLE HMI
      #xA094	;YI SYLLABLE HMIP
      #xA095	;YI SYLLABLE HMIEX
      #xA096	;YI SYLLABLE HMIE
      #xA097	;YI SYLLABLE HMIEP
      #xA098	;YI SYLLABLE HMAT
      #xA099	;YI SYLLABLE HMAX
      #xA09A	;YI SYLLABLE HMA
      #xA09B	;YI SYLLABLE HMAP
      #xA09C	;YI SYLLABLE HMUOX
      #xA09D	;YI SYLLABLE HMUO
      #xA09E	;YI SYLLABLE HMUOP
      #xA09F	;YI SYLLABLE HMOT
      #xA0A0	;YI SYLLABLE HMOX
      #xA0A1	;YI SYLLABLE HMO
      #xA0A2	;YI SYLLABLE HMOP
      #xA0A3	;YI SYLLABLE HMUT
      #xA0A4	;YI SYLLABLE HMUX
      #xA0A5	;YI SYLLABLE HMU
      #xA0A6	;YI SYLLABLE HMUP
      #xA0A7	;YI SYLLABLE HMURX
      #xA0A8	;YI SYLLABLE HMUR
      #xA0A9	;YI SYLLABLE HMYX
      #xA0AA	;YI SYLLABLE HMY
      #xA0AB	;YI SYLLABLE HMYP
      #xA0AC	;YI SYLLABLE HMYRX
      #xA0AD	;YI SYLLABLE HMYR
      #xA0AE	;YI SYLLABLE MIT
      #xA0AF	;YI SYLLABLE MIX
      #xA0B0	;YI SYLLABLE MI
      #xA0B1	;YI SYLLABLE MIP
      #xA0B2	;YI SYLLABLE MIEX
      #xA0B3	;YI SYLLABLE MIE
      #xA0B4	;YI SYLLABLE MIEP
      #xA0B5	;YI SYLLABLE MAT
      #xA0B6	;YI SYLLABLE MAX
      #xA0B7	;YI SYLLABLE MA
      #xA0B8	;YI SYLLABLE MAP
      #xA0B9	;YI SYLLABLE MUOT
      #xA0BA	;YI SYLLABLE MUOX
      #xA0BB	;YI SYLLABLE MUO
      #xA0BC	;YI SYLLABLE MUOP
      #xA0BD	;YI SYLLABLE MOT
      #xA0BE	;YI SYLLABLE MOX
      #xA0BF	;YI SYLLABLE MO
      #xA0C0	;YI SYLLABLE MOP
      #xA0C1	;YI SYLLABLE MEX
      #xA0C2	;YI SYLLABLE ME
      #xA0C3	;YI SYLLABLE MUT
      #xA0C4	;YI SYLLABLE MUX
      #xA0C5	;YI SYLLABLE MU
      #xA0C6	;YI SYLLABLE MUP
      #xA0C7	;YI SYLLABLE MURX
      #xA0C8	;YI SYLLABLE MUR
      #xA0C9	;YI SYLLABLE MYT
      #xA0CA	;YI SYLLABLE MYX
      #xA0CB	;YI SYLLABLE MY
      #xA0CC	;YI SYLLABLE MYP
      #xA0CD	;YI SYLLABLE FIT
      #xA0CE	;YI SYLLABLE FIX
      #xA0CF	;YI SYLLABLE FI
      #xA0D0	;YI SYLLABLE FIP
      #xA0D1	;YI SYLLABLE FAT
      #xA0D2	;YI SYLLABLE FAX
      #xA0D3	;YI SYLLABLE FA
      #xA0D4	;YI SYLLABLE FAP
      #xA0D5	;YI SYLLABLE FOX
      #xA0D6	;YI SYLLABLE FO
      #xA0D7	;YI SYLLABLE FOP
      #xA0D8	;YI SYLLABLE FUT
      #xA0D9	;YI SYLLABLE FUX
      #xA0DA	;YI SYLLABLE FU
      #xA0DB	;YI SYLLABLE FUP
      #xA0DC	;YI SYLLABLE FURX
      #xA0DD	;YI SYLLABLE FUR
      #xA0DE	;YI SYLLABLE FYT
      #xA0DF	;YI SYLLABLE FYX
      #xA0E0	;YI SYLLABLE FY
      #xA0E1	;YI SYLLABLE FYP
      #xA0E2	;YI SYLLABLE VIT
      #xA0E3	;YI SYLLABLE VIX
      #xA0E4	;YI SYLLABLE VI
      #xA0E5	;YI SYLLABLE VIP
      #xA0E6	;YI SYLLABLE VIET
      #xA0E7	;YI SYLLABLE VIEX
      #xA0E8	;YI SYLLABLE VIE
      #xA0E9	;YI SYLLABLE VIEP
      #xA0EA	;YI SYLLABLE VAT
      #xA0EB	;YI SYLLABLE VAX
      #xA0EC	;YI SYLLABLE VA
      #xA0ED	;YI SYLLABLE VAP
      #xA0EE	;YI SYLLABLE VOT
      #xA0EF	;YI SYLLABLE VOX
      #xA0F0	;YI SYLLABLE VO
      #xA0F1	;YI SYLLABLE VOP
      #xA0F2	;YI SYLLABLE VEX
      #xA0F3	;YI SYLLABLE VEP
      #xA0F4	;YI SYLLABLE VUT
      #xA0F5	;YI SYLLABLE VUX
      #xA0F6	;YI SYLLABLE VU
      #xA0F7	;YI SYLLABLE VUP
      #xA0F8	;YI SYLLABLE VURX
      #xA0F9	;YI SYLLABLE VUR
      #xA0FA	;YI SYLLABLE VYT
      #xA0FB	;YI SYLLABLE VYX
      #xA0FC	;YI SYLLABLE VY
      #xA0FD	;YI SYLLABLE VYP
      #xA0FE	;YI SYLLABLE VYRX
      #xA0FF	;YI SYLLABLE VYR
      #xA100	;YI SYLLABLE DIT
      #xA101	;YI SYLLABLE DIX
      #xA102	;YI SYLLABLE DI
      #xA103	;YI SYLLABLE DIP
      #xA104	;YI SYLLABLE DIEX
      #xA105	;YI SYLLABLE DIE
      #xA106	;YI SYLLABLE DIEP
      #xA107	;YI SYLLABLE DAT
      #xA108	;YI SYLLABLE DAX
      #xA109	;YI SYLLABLE DA
      #xA10A	;YI SYLLABLE DAP
      #xA10B	;YI SYLLABLE DUOX
      #xA10C	;YI SYLLABLE DUO
      #xA10D	;YI SYLLABLE DOT
      #xA10E	;YI SYLLABLE DOX
      #xA10F	;YI SYLLABLE DO
      #xA110	;YI SYLLABLE DOP
      #xA111	;YI SYLLABLE DEX
      #xA112	;YI SYLLABLE DE
      #xA113	;YI SYLLABLE DEP
      #xA114	;YI SYLLABLE DUT
      #xA115	;YI SYLLABLE DUX
      #xA116	;YI SYLLABLE DU
      #xA117	;YI SYLLABLE DUP
      #xA118	;YI SYLLABLE DURX
      #xA119	;YI SYLLABLE DUR
      #xA11A	;YI SYLLABLE TIT
      #xA11B	;YI SYLLABLE TIX
      #xA11C	;YI SYLLABLE TI
      #xA11D	;YI SYLLABLE TIP
      #xA11E	;YI SYLLABLE TIEX
      #xA11F	;YI SYLLABLE TIE
      #xA120	;YI SYLLABLE TIEP
      #xA121	;YI SYLLABLE TAT
      #xA122	;YI SYLLABLE TAX
      #xA123	;YI SYLLABLE TA
      #xA124	;YI SYLLABLE TAP
      #xA125	;YI SYLLABLE TUOT
      #xA126	;YI SYLLABLE TUOX
      #xA127	;YI SYLLABLE TUO
      #xA128	;YI SYLLABLE TUOP
      #xA129	;YI SYLLABLE TOT
      #xA12A	;YI SYLLABLE TOX
      #xA12B	;YI SYLLABLE TO
      #xA12C	;YI SYLLABLE TOP
      #xA12D	;YI SYLLABLE TEX
      #xA12E	;YI SYLLABLE TE
      #xA12F	;YI SYLLABLE TEP
      #xA130	;YI SYLLABLE TUT
      #xA131	;YI SYLLABLE TUX
      #xA132	;YI SYLLABLE TU
      #xA133	;YI SYLLABLE TUP
      #xA134	;YI SYLLABLE TURX
      #xA135	;YI SYLLABLE TUR
      #xA136	;YI SYLLABLE DDIT
      #xA137	;YI SYLLABLE DDIX
      #xA138	;YI SYLLABLE DDI
      #xA139	;YI SYLLABLE DDIP
      #xA13A	;YI SYLLABLE DDIEX
      #xA13B	;YI SYLLABLE DDIE
      #xA13C	;YI SYLLABLE DDIEP
      #xA13D	;YI SYLLABLE DDAT
      #xA13E	;YI SYLLABLE DDAX
      #xA13F	;YI SYLLABLE DDA
      #xA140	;YI SYLLABLE DDAP
      #xA141	;YI SYLLABLE DDUOX
      #xA142	;YI SYLLABLE DDUO
      #xA143	;YI SYLLABLE DDUOP
      #xA144	;YI SYLLABLE DDOT
      #xA145	;YI SYLLABLE DDOX
      #xA146	;YI SYLLABLE DDO
      #xA147	;YI SYLLABLE DDOP
      #xA148	;YI SYLLABLE DDEX
      #xA149	;YI SYLLABLE DDE
      #xA14A	;YI SYLLABLE DDEP
      #xA14B	;YI SYLLABLE DDUT
      #xA14C	;YI SYLLABLE DDUX
      #xA14D	;YI SYLLABLE DDU
      #xA14E	;YI SYLLABLE DDUP
      #xA14F	;YI SYLLABLE DDURX
      #xA150	;YI SYLLABLE DDUR
      #xA151	;YI SYLLABLE NDIT
      #xA152	;YI SYLLABLE NDIX
      #xA153	;YI SYLLABLE NDI
      #xA154	;YI SYLLABLE NDIP
      #xA155	;YI SYLLABLE NDIEX
      #xA156	;YI SYLLABLE NDIE
      #xA157	;YI SYLLABLE NDAT
      #xA158	;YI SYLLABLE NDAX
      #xA159	;YI SYLLABLE NDA
      #xA15A	;YI SYLLABLE NDAP
      #xA15B	;YI SYLLABLE NDOT
      #xA15C	;YI SYLLABLE NDOX
      #xA15D	;YI SYLLABLE NDO
      #xA15E	;YI SYLLABLE NDOP
      #xA15F	;YI SYLLABLE NDEX
      #xA160	;YI SYLLABLE NDE
      #xA161	;YI SYLLABLE NDEP
      #xA162	;YI SYLLABLE NDUT
      #xA163	;YI SYLLABLE NDUX
      #xA164	;YI SYLLABLE NDU
      #xA165	;YI SYLLABLE NDUP
      #xA166	;YI SYLLABLE NDURX
      #xA167	;YI SYLLABLE NDUR
      #xA168	;YI SYLLABLE HNIT
      #xA169	;YI SYLLABLE HNIX
      #xA16A	;YI SYLLABLE HNI
      #xA16B	;YI SYLLABLE HNIP
      #xA16C	;YI SYLLABLE HNIET
      #xA16D	;YI SYLLABLE HNIEX
      #xA16E	;YI SYLLABLE HNIE
      #xA16F	;YI SYLLABLE HNIEP
      #xA170	;YI SYLLABLE HNAT
      #xA171	;YI SYLLABLE HNAX
      #xA172	;YI SYLLABLE HNA
      #xA173	;YI SYLLABLE HNAP
      #xA174	;YI SYLLABLE HNUOX
      #xA175	;YI SYLLABLE HNUO
      #xA176	;YI SYLLABLE HNOT
      #xA177	;YI SYLLABLE HNOX
      #xA178	;YI SYLLABLE HNOP
      #xA179	;YI SYLLABLE HNEX
      #xA17A	;YI SYLLABLE HNE
      #xA17B	;YI SYLLABLE HNEP
      #xA17C	;YI SYLLABLE HNUT
      #xA17D	;YI SYLLABLE NIT
      #xA17E	;YI SYLLABLE NIX
      #xA17F	;YI SYLLABLE NI
      #xA180	;YI SYLLABLE NIP
      #xA181	;YI SYLLABLE NIEX
      #xA182	;YI SYLLABLE NIE
      #xA183	;YI SYLLABLE NIEP
      #xA184	;YI SYLLABLE NAX
      #xA185	;YI SYLLABLE NA
      #xA186	;YI SYLLABLE NAP
      #xA187	;YI SYLLABLE NUOX
      #xA188	;YI SYLLABLE NUO
      #xA189	;YI SYLLABLE NUOP
      #xA18A	;YI SYLLABLE NOT
      #xA18B	;YI SYLLABLE NOX
      #xA18C	;YI SYLLABLE NO
      #xA18D	;YI SYLLABLE NOP
      #xA18E	;YI SYLLABLE NEX
      #xA18F	;YI SYLLABLE NE
      #xA190	;YI SYLLABLE NEP
      #xA191	;YI SYLLABLE NUT
      #xA192	;YI SYLLABLE NUX
      #xA193	;YI SYLLABLE NU
      #xA194	;YI SYLLABLE NUP
      #xA195	;YI SYLLABLE NURX
      #xA196	;YI SYLLABLE NUR
      #xA197	;YI SYLLABLE HLIT
      #xA198	;YI SYLLABLE HLIX
      #xA199	;YI SYLLABLE HLI
      #xA19A	;YI SYLLABLE HLIP
      #xA19B	;YI SYLLABLE HLIEX
      #xA19C	;YI SYLLABLE HLIE
      #xA19D	;YI SYLLABLE HLIEP
      #xA19E	;YI SYLLABLE HLAT
      #xA19F	;YI SYLLABLE HLAX
      #xA1A0	;YI SYLLABLE HLA
      #xA1A1	;YI SYLLABLE HLAP
      #xA1A2	;YI SYLLABLE HLUOX
      #xA1A3	;YI SYLLABLE HLUO
      #xA1A4	;YI SYLLABLE HLUOP
      #xA1A5	;YI SYLLABLE HLOX
      #xA1A6	;YI SYLLABLE HLO
      #xA1A7	;YI SYLLABLE HLOP
      #xA1A8	;YI SYLLABLE HLEX
      #xA1A9	;YI SYLLABLE HLE
      #xA1AA	;YI SYLLABLE HLEP
      #xA1AB	;YI SYLLABLE HLUT
      #xA1AC	;YI SYLLABLE HLUX
      #xA1AD	;YI SYLLABLE HLU
      #xA1AE	;YI SYLLABLE HLUP
      #xA1AF	;YI SYLLABLE HLURX
      #xA1B0	;YI SYLLABLE HLUR
      #xA1B1	;YI SYLLABLE HLYT
      #xA1B2	;YI SYLLABLE HLYX
      #xA1B3	;YI SYLLABLE HLY
      #xA1B4	;YI SYLLABLE HLYP
      #xA1B5	;YI SYLLABLE HLYRX
      #xA1B6	;YI SYLLABLE HLYR
      #xA1B7	;YI SYLLABLE LIT
      #xA1B8	;YI SYLLABLE LIX
      #xA1B9	;YI SYLLABLE LI
      #xA1BA	;YI SYLLABLE LIP
      #xA1BB	;YI SYLLABLE LIET
      #xA1BC	;YI SYLLABLE LIEX
      #xA1BD	;YI SYLLABLE LIE
      #xA1BE	;YI SYLLABLE LIEP
      #xA1BF	;YI SYLLABLE LAT
      #xA1C0	;YI SYLLABLE LAX
      #xA1C1	;YI SYLLABLE LA
      #xA1C2	;YI SYLLABLE LAP
      #xA1C3	;YI SYLLABLE LUOT
      #xA1C4	;YI SYLLABLE LUOX
      #xA1C5	;YI SYLLABLE LUO
      #xA1C6	;YI SYLLABLE LUOP
      #xA1C7	;YI SYLLABLE LOT
      #xA1C8	;YI SYLLABLE LOX
      #xA1C9	;YI SYLLABLE LO
      #xA1CA	;YI SYLLABLE LOP
      #xA1CB	;YI SYLLABLE LEX
      #xA1CC	;YI SYLLABLE LE
      #xA1CD	;YI SYLLABLE LEP
      #xA1CE	;YI SYLLABLE LUT
      #xA1CF	;YI SYLLABLE LUX
      #xA1D0	;YI SYLLABLE LU
      #xA1D1	;YI SYLLABLE LUP
      #xA1D2	;YI SYLLABLE LURX
      #xA1D3	;YI SYLLABLE LUR
      #xA1D4	;YI SYLLABLE LYT
      #xA1D5	;YI SYLLABLE LYX
      #xA1D6	;YI SYLLABLE LY
      #xA1D7	;YI SYLLABLE LYP
      #xA1D8	;YI SYLLABLE LYRX
      #xA1D9	;YI SYLLABLE LYR
      #xA1DA	;YI SYLLABLE GIT
      #xA1DB	;YI SYLLABLE GIX
      #xA1DC	;YI SYLLABLE GI
      #xA1DD	;YI SYLLABLE GIP
      #xA1DE	;YI SYLLABLE GIET
      #xA1DF	;YI SYLLABLE GIEX
      #xA1E0	;YI SYLLABLE GIE
      #xA1E1	;YI SYLLABLE GIEP
      #xA1E2	;YI SYLLABLE GAT
      #xA1E3	;YI SYLLABLE GAX
      #xA1E4	;YI SYLLABLE GA
      #xA1E5	;YI SYLLABLE GAP
      #xA1E6	;YI SYLLABLE GUOT
      #xA1E7	;YI SYLLABLE GUOX
      #xA1E8	;YI SYLLABLE GUO
      #xA1E9	;YI SYLLABLE GUOP
      #xA1EA	;YI SYLLABLE GOT
      #xA1EB	;YI SYLLABLE GOX
      #xA1EC	;YI SYLLABLE GO
      #xA1ED	;YI SYLLABLE GOP
      #xA1EE	;YI SYLLABLE GET
      #xA1EF	;YI SYLLABLE GEX
      #xA1F0	;YI SYLLABLE GE
      #xA1F1	;YI SYLLABLE GEP
      #xA1F2	;YI SYLLABLE GUT
      #xA1F3	;YI SYLLABLE GUX
      #xA1F4	;YI SYLLABLE GU
      #xA1F5	;YI SYLLABLE GUP
      #xA1F6	;YI SYLLABLE GURX
      #xA1F7	;YI SYLLABLE GUR
      #xA1F8	;YI SYLLABLE KIT
      #xA1F9	;YI SYLLABLE KIX
      #xA1FA	;YI SYLLABLE KI
      #xA1FB	;YI SYLLABLE KIP
      #xA1FC	;YI SYLLABLE KIEX
      #xA1FD	;YI SYLLABLE KIE
      #xA1FE	;YI SYLLABLE KIEP
      #xA1FF	;YI SYLLABLE KAT
      #xA200	;YI SYLLABLE KAX
      #xA201	;YI SYLLABLE KA
      #xA202	;YI SYLLABLE KAP
      #xA203	;YI SYLLABLE KUOX
      #xA204	;YI SYLLABLE KUO
      #xA205	;YI SYLLABLE KUOP
      #xA206	;YI SYLLABLE KOT
      #xA207	;YI SYLLABLE KOX
      #xA208	;YI SYLLABLE KO
      #xA209	;YI SYLLABLE KOP
      #xA20A	;YI SYLLABLE KET
      #xA20B	;YI SYLLABLE KEX
      #xA20C	;YI SYLLABLE KE
      #xA20D	;YI SYLLABLE KEP
      #xA20E	;YI SYLLABLE KUT
      #xA20F	;YI SYLLABLE KUX
      #xA210	;YI SYLLABLE KU
      #xA211	;YI SYLLABLE KUP
      #xA212	;YI SYLLABLE KURX
      #xA213	;YI SYLLABLE KUR
      #xA214	;YI SYLLABLE GGIT
      #xA215	;YI SYLLABLE GGIX
      #xA216	;YI SYLLABLE GGI
      #xA217	;YI SYLLABLE GGIEX
      #xA218	;YI SYLLABLE GGIE
      #xA219	;YI SYLLABLE GGIEP
      #xA21A	;YI SYLLABLE GGAT
      #xA21B	;YI SYLLABLE GGAX
      #xA21C	;YI SYLLABLE GGA
      #xA21D	;YI SYLLABLE GGAP
      #xA21E	;YI SYLLABLE GGUOT
      #xA21F	;YI SYLLABLE GGUOX
      #xA220	;YI SYLLABLE GGUO
      #xA221	;YI SYLLABLE GGUOP
      #xA222	;YI SYLLABLE GGOT
      #xA223	;YI SYLLABLE GGOX
      #xA224	;YI SYLLABLE GGO
      #xA225	;YI SYLLABLE GGOP
      #xA226	;YI SYLLABLE GGET
      #xA227	;YI SYLLABLE GGEX
      #xA228	;YI SYLLABLE GGE
      #xA229	;YI SYLLABLE GGEP
      #xA22A	;YI SYLLABLE GGUT
      #xA22B	;YI SYLLABLE GGUX
      #xA22C	;YI SYLLABLE GGU
      #xA22D	;YI SYLLABLE GGUP
      #xA22E	;YI SYLLABLE GGURX
      #xA22F	;YI SYLLABLE GGUR
      #xA230	;YI SYLLABLE MGIEX
      #xA231	;YI SYLLABLE MGIE
      #xA232	;YI SYLLABLE MGAT
      #xA233	;YI SYLLABLE MGAX
      #xA234	;YI SYLLABLE MGA
      #xA235	;YI SYLLABLE MGAP
      #xA236	;YI SYLLABLE MGUOX
      #xA237	;YI SYLLABLE MGUO
      #xA238	;YI SYLLABLE MGUOP
      #xA239	;YI SYLLABLE MGOT
      #xA23A	;YI SYLLABLE MGOX
      #xA23B	;YI SYLLABLE MGO
      #xA23C	;YI SYLLABLE MGOP
      #xA23D	;YI SYLLABLE MGEX
      #xA23E	;YI SYLLABLE MGE
      #xA23F	;YI SYLLABLE MGEP
      #xA240	;YI SYLLABLE MGUT
      #xA241	;YI SYLLABLE MGUX
      #xA242	;YI SYLLABLE MGU
      #xA243	;YI SYLLABLE MGUP
      #xA244	;YI SYLLABLE MGURX
      #xA245	;YI SYLLABLE MGUR
      #xA246	;YI SYLLABLE HXIT
      #xA247	;YI SYLLABLE HXIX
      #xA248	;YI SYLLABLE HXI
      #xA249	;YI SYLLABLE HXIP
      #xA24A	;YI SYLLABLE HXIET
      #xA24B	;YI SYLLABLE HXIEX
      #xA24C	;YI SYLLABLE HXIE
      #xA24D	;YI SYLLABLE HXIEP
      #xA24E	;YI SYLLABLE HXAT
      #xA24F	;YI SYLLABLE HXAX
      #xA250	;YI SYLLABLE HXA
      #xA251	;YI SYLLABLE HXAP
      #xA252	;YI SYLLABLE HXUOT
      #xA253	;YI SYLLABLE HXUOX
      #xA254	;YI SYLLABLE HXUO
      #xA255	;YI SYLLABLE HXUOP
      #xA256	;YI SYLLABLE HXOT
      #xA257	;YI SYLLABLE HXOX
      #xA258	;YI SYLLABLE HXO
      #xA259	;YI SYLLABLE HXOP
      #xA25A	;YI SYLLABLE HXEX
      #xA25B	;YI SYLLABLE HXE
      #xA25C	;YI SYLLABLE HXEP
      #xA25D	;YI SYLLABLE NGIEX
      #xA25E	;YI SYLLABLE NGIE
      #xA25F	;YI SYLLABLE NGIEP
      #xA260	;YI SYLLABLE NGAT
      #xA261	;YI SYLLABLE NGAX
      #xA262	;YI SYLLABLE NGA
      #xA263	;YI SYLLABLE NGAP
      #xA264	;YI SYLLABLE NGUOT
      #xA265	;YI SYLLABLE NGUOX
      #xA266	;YI SYLLABLE NGUO
      #xA267	;YI SYLLABLE NGOT
      #xA268	;YI SYLLABLE NGOX
      #xA269	;YI SYLLABLE NGO
      #xA26A	;YI SYLLABLE NGOP
      #xA26B	;YI SYLLABLE NGEX
      #xA26C	;YI SYLLABLE NGE
      #xA26D	;YI SYLLABLE NGEP
      #xA26E	;YI SYLLABLE HIT
      #xA26F	;YI SYLLABLE HIEX
      #xA270	;YI SYLLABLE HIE
      #xA271	;YI SYLLABLE HAT
      #xA272	;YI SYLLABLE HAX
      #xA273	;YI SYLLABLE HA
      #xA274	;YI SYLLABLE HAP
      #xA275	;YI SYLLABLE HUOT
      #xA276	;YI SYLLABLE HUOX
      #xA277	;YI SYLLABLE HUO
      #xA278	;YI SYLLABLE HUOP
      #xA279	;YI SYLLABLE HOT
      #xA27A	;YI SYLLABLE HOX
      #xA27B	;YI SYLLABLE HO
      #xA27C	;YI SYLLABLE HOP
      #xA27D	;YI SYLLABLE HEX
      #xA27E	;YI SYLLABLE HE
      #xA27F	;YI SYLLABLE HEP
      #xA280	;YI SYLLABLE WAT
      #xA281	;YI SYLLABLE WAX
      #xA282	;YI SYLLABLE WA
      #xA283	;YI SYLLABLE WAP
      #xA284	;YI SYLLABLE WUOX
      #xA285	;YI SYLLABLE WUO
      #xA286	;YI SYLLABLE WUOP
      #xA287	;YI SYLLABLE WOX
      #xA288	;YI SYLLABLE WO
      #xA289	;YI SYLLABLE WOP
      #xA28A	;YI SYLLABLE WEX
      #xA28B	;YI SYLLABLE WE
      #xA28C	;YI SYLLABLE WEP
      #xA28D	;YI SYLLABLE ZIT
      #xA28E	;YI SYLLABLE ZIX
      #xA28F	;YI SYLLABLE ZI
      #xA290	;YI SYLLABLE ZIP
      #xA291	;YI SYLLABLE ZIEX
      #xA292	;YI SYLLABLE ZIE
      #xA293	;YI SYLLABLE ZIEP
      #xA294	;YI SYLLABLE ZAT
      #xA295	;YI SYLLABLE ZAX
      #xA296	;YI SYLLABLE ZA
      #xA297	;YI SYLLABLE ZAP
      #xA298	;YI SYLLABLE ZUOX
      #xA299	;YI SYLLABLE ZUO
      #xA29A	;YI SYLLABLE ZUOP
      #xA29B	;YI SYLLABLE ZOT
      #xA29C	;YI SYLLABLE ZOX
      #xA29D	;YI SYLLABLE ZO
      #xA29E	;YI SYLLABLE ZOP
      #xA29F	;YI SYLLABLE ZEX
      #xA2A0	;YI SYLLABLE ZE
      #xA2A1	;YI SYLLABLE ZEP
      #xA2A2	;YI SYLLABLE ZUT
      #xA2A3	;YI SYLLABLE ZUX
      #xA2A4	;YI SYLLABLE ZU
      #xA2A5	;YI SYLLABLE ZUP
      #xA2A6	;YI SYLLABLE ZURX
      #xA2A7	;YI SYLLABLE ZUR
      #xA2A8	;YI SYLLABLE ZYT
      #xA2A9	;YI SYLLABLE ZYX
      #xA2AA	;YI SYLLABLE ZY
      #xA2AB	;YI SYLLABLE ZYP
      #xA2AC	;YI SYLLABLE ZYRX
      #xA2AD	;YI SYLLABLE ZYR
      #xA2AE	;YI SYLLABLE CIT
      #xA2AF	;YI SYLLABLE CIX
      #xA2B0	;YI SYLLABLE CI
      #xA2B1	;YI SYLLABLE CIP
      #xA2B2	;YI SYLLABLE CIET
      #xA2B3	;YI SYLLABLE CIEX
      #xA2B4	;YI SYLLABLE CIE
      #xA2B5	;YI SYLLABLE CIEP
      #xA2B6	;YI SYLLABLE CAT
      #xA2B7	;YI SYLLABLE CAX
      #xA2B8	;YI SYLLABLE CA
      #xA2B9	;YI SYLLABLE CAP
      #xA2BA	;YI SYLLABLE CUOX
      #xA2BB	;YI SYLLABLE CUO
      #xA2BC	;YI SYLLABLE CUOP
      #xA2BD	;YI SYLLABLE COT
      #xA2BE	;YI SYLLABLE COX
      #xA2BF	;YI SYLLABLE CO
      #xA2C0	;YI SYLLABLE COP
      #xA2C1	;YI SYLLABLE CEX
      #xA2C2	;YI SYLLABLE CE
      #xA2C3	;YI SYLLABLE CEP
      #xA2C4	;YI SYLLABLE CUT
      #xA2C5	;YI SYLLABLE CUX
      #xA2C6	;YI SYLLABLE CU
      #xA2C7	;YI SYLLABLE CUP
      #xA2C8	;YI SYLLABLE CURX
      #xA2C9	;YI SYLLABLE CUR
      #xA2CA	;YI SYLLABLE CYT
      #xA2CB	;YI SYLLABLE CYX
      #xA2CC	;YI SYLLABLE CY
      #xA2CD	;YI SYLLABLE CYP
      #xA2CE	;YI SYLLABLE CYRX
      #xA2CF	;YI SYLLABLE CYR
      #xA2D0	;YI SYLLABLE ZZIT
      #xA2D1	;YI SYLLABLE ZZIX
      #xA2D2	;YI SYLLABLE ZZI
      #xA2D3	;YI SYLLABLE ZZIP
      #xA2D4	;YI SYLLABLE ZZIET
      #xA2D5	;YI SYLLABLE ZZIEX
      #xA2D6	;YI SYLLABLE ZZIE
      #xA2D7	;YI SYLLABLE ZZIEP
      #xA2D8	;YI SYLLABLE ZZAT
      #xA2D9	;YI SYLLABLE ZZAX
      #xA2DA	;YI SYLLABLE ZZA
      #xA2DB	;YI SYLLABLE ZZAP
      #xA2DC	;YI SYLLABLE ZZOX
      #xA2DD	;YI SYLLABLE ZZO
      #xA2DE	;YI SYLLABLE ZZOP
      #xA2DF	;YI SYLLABLE ZZEX
      #xA2E0	;YI SYLLABLE ZZE
      #xA2E1	;YI SYLLABLE ZZEP
      #xA2E2	;YI SYLLABLE ZZUX
      #xA2E3	;YI SYLLABLE ZZU
      #xA2E4	;YI SYLLABLE ZZUP
      #xA2E5	;YI SYLLABLE ZZURX
      #xA2E6	;YI SYLLABLE ZZUR
      #xA2E7	;YI SYLLABLE ZZYT
      #xA2E8	;YI SYLLABLE ZZYX
      #xA2E9	;YI SYLLABLE ZZY
      #xA2EA	;YI SYLLABLE ZZYP
      #xA2EB	;YI SYLLABLE ZZYRX
      #xA2EC	;YI SYLLABLE ZZYR
      #xA2ED	;YI SYLLABLE NZIT
      #xA2EE	;YI SYLLABLE NZIX
      #xA2EF	;YI SYLLABLE NZI
      #xA2F0	;YI SYLLABLE NZIP
      #xA2F1	;YI SYLLABLE NZIEX
      #xA2F2	;YI SYLLABLE NZIE
      #xA2F3	;YI SYLLABLE NZIEP
      #xA2F4	;YI SYLLABLE NZAT
      #xA2F5	;YI SYLLABLE NZAX
      #xA2F6	;YI SYLLABLE NZA
      #xA2F7	;YI SYLLABLE NZAP
      #xA2F8	;YI SYLLABLE NZUOX
      #xA2F9	;YI SYLLABLE NZUO
      #xA2FA	;YI SYLLABLE NZOX
      #xA2FB	;YI SYLLABLE NZOP
      #xA2FC	;YI SYLLABLE NZEX
      #xA2FD	;YI SYLLABLE NZE
      #xA2FE	;YI SYLLABLE NZUX
      #xA2FF	;YI SYLLABLE NZU
      #xA300	;YI SYLLABLE NZUP
      #xA301	;YI SYLLABLE NZURX
      #xA302	;YI SYLLABLE NZUR
      #xA303	;YI SYLLABLE NZYT
      #xA304	;YI SYLLABLE NZYX
      #xA305	;YI SYLLABLE NZY
      #xA306	;YI SYLLABLE NZYP
      #xA307	;YI SYLLABLE NZYRX
      #xA308	;YI SYLLABLE NZYR
      #xA309	;YI SYLLABLE SIT
      #xA30A	;YI SYLLABLE SIX
      #xA30B	;YI SYLLABLE SI
      #xA30C	;YI SYLLABLE SIP
      #xA30D	;YI SYLLABLE SIEX
      #xA30E	;YI SYLLABLE SIE
      #xA30F	;YI SYLLABLE SIEP
      #xA310	;YI SYLLABLE SAT
      #xA311	;YI SYLLABLE SAX
      #xA312	;YI SYLLABLE SA
      #xA313	;YI SYLLABLE SAP
      #xA314	;YI SYLLABLE SUOX
      #xA315	;YI SYLLABLE SUO
      #xA316	;YI SYLLABLE SUOP
      #xA317	;YI SYLLABLE SOT
      #xA318	;YI SYLLABLE SOX
      #xA319	;YI SYLLABLE SO
      #xA31A	;YI SYLLABLE SOP
      #xA31B	;YI SYLLABLE SEX
      #xA31C	;YI SYLLABLE SE
      #xA31D	;YI SYLLABLE SEP
      #xA31E	;YI SYLLABLE SUT
      #xA31F	;YI SYLLABLE SUX
      #xA320	;YI SYLLABLE SU
      #xA321	;YI SYLLABLE SUP
      #xA322	;YI SYLLABLE SURX
      #xA323	;YI SYLLABLE SUR
      #xA324	;YI SYLLABLE SYT
      #xA325	;YI SYLLABLE SYX
      #xA326	;YI SYLLABLE SY
      #xA327	;YI SYLLABLE SYP
      #xA328	;YI SYLLABLE SYRX
      #xA329	;YI SYLLABLE SYR
      #xA32A	;YI SYLLABLE SSIT
      #xA32B	;YI SYLLABLE SSIX
      #xA32C	;YI SYLLABLE SSI
      #xA32D	;YI SYLLABLE SSIP
      #xA32E	;YI SYLLABLE SSIEX
      #xA32F	;YI SYLLABLE SSIE
      #xA330	;YI SYLLABLE SSIEP
      #xA331	;YI SYLLABLE SSAT
      #xA332	;YI SYLLABLE SSAX
      #xA333	;YI SYLLABLE SSA
      #xA334	;YI SYLLABLE SSAP
      #xA335	;YI SYLLABLE SSOT
      #xA336	;YI SYLLABLE SSOX
      #xA337	;YI SYLLABLE SSO
      #xA338	;YI SYLLABLE SSOP
      #xA339	;YI SYLLABLE SSEX
      #xA33A	;YI SYLLABLE SSE
      #xA33B	;YI SYLLABLE SSEP
      #xA33C	;YI SYLLABLE SSUT
      #xA33D	;YI SYLLABLE SSUX
      #xA33E	;YI SYLLABLE SSU
      #xA33F	;YI SYLLABLE SSUP
      #xA340	;YI SYLLABLE SSYT
      #xA341	;YI SYLLABLE SSYX
      #xA342	;YI SYLLABLE SSY
      #xA343	;YI SYLLABLE SSYP
      #xA344	;YI SYLLABLE SSYRX
      #xA345	;YI SYLLABLE SSYR
      #xA346	;YI SYLLABLE ZHAT
      #xA347	;YI SYLLABLE ZHAX
      #xA348	;YI SYLLABLE ZHA
      #xA349	;YI SYLLABLE ZHAP
      #xA34A	;YI SYLLABLE ZHUOX
      #xA34B	;YI SYLLABLE ZHUO
      #xA34C	;YI SYLLABLE ZHUOP
      #xA34D	;YI SYLLABLE ZHOT
      #xA34E	;YI SYLLABLE ZHOX
      #xA34F	;YI SYLLABLE ZHO
      #xA350	;YI SYLLABLE ZHOP
      #xA351	;YI SYLLABLE ZHET
      #xA352	;YI SYLLABLE ZHEX
      #xA353	;YI SYLLABLE ZHE
      #xA354	;YI SYLLABLE ZHEP
      #xA355	;YI SYLLABLE ZHUT
      #xA356	;YI SYLLABLE ZHUX
      #xA357	;YI SYLLABLE ZHU
      #xA358	;YI SYLLABLE ZHUP
      #xA359	;YI SYLLABLE ZHURX
      #xA35A	;YI SYLLABLE ZHUR
      #xA35B	;YI SYLLABLE ZHYT
      #xA35C	;YI SYLLABLE ZHYX
      #xA35D	;YI SYLLABLE ZHY
      #xA35E	;YI SYLLABLE ZHYP
      #xA35F	;YI SYLLABLE ZHYRX
      #xA360	;YI SYLLABLE ZHYR
      #xA361	;YI SYLLABLE CHAT
      #xA362	;YI SYLLABLE CHAX
      #xA363	;YI SYLLABLE CHA
      #xA364	;YI SYLLABLE CHAP
      #xA365	;YI SYLLABLE CHUOT
      #xA366	;YI SYLLABLE CHUOX
      #xA367	;YI SYLLABLE CHUO
      #xA368	;YI SYLLABLE CHUOP
      #xA369	;YI SYLLABLE CHOT
      #xA36A	;YI SYLLABLE CHOX
      #xA36B	;YI SYLLABLE CHO
      #xA36C	;YI SYLLABLE CHOP
      #xA36D	;YI SYLLABLE CHET
      #xA36E	;YI SYLLABLE CHEX
      #xA36F	;YI SYLLABLE CHE
      #xA370	;YI SYLLABLE CHEP
      #xA371	;YI SYLLABLE CHUX
      #xA372	;YI SYLLABLE CHU
      #xA373	;YI SYLLABLE CHUP
      #xA374	;YI SYLLABLE CHURX
      #xA375	;YI SYLLABLE CHUR
      #xA376	;YI SYLLABLE CHYT
      #xA377	;YI SYLLABLE CHYX
      #xA378	;YI SYLLABLE CHY
      #xA379	;YI SYLLABLE CHYP
      #xA37A	;YI SYLLABLE CHYRX
      #xA37B	;YI SYLLABLE CHYR
      #xA37C	;YI SYLLABLE RRAX
      #xA37D	;YI SYLLABLE RRA
      #xA37E	;YI SYLLABLE RRUOX
      #xA37F	;YI SYLLABLE RRUO
      #xA380	;YI SYLLABLE RROT
      #xA381	;YI SYLLABLE RROX
      #xA382	;YI SYLLABLE RRO
      #xA383	;YI SYLLABLE RROP
      #xA384	;YI SYLLABLE RRET
      #xA385	;YI SYLLABLE RREX
      #xA386	;YI SYLLABLE RRE
      #xA387	;YI SYLLABLE RREP
      #xA388	;YI SYLLABLE RRUT
      #xA389	;YI SYLLABLE RRUX
      #xA38A	;YI SYLLABLE RRU
      #xA38B	;YI SYLLABLE RRUP
      #xA38C	;YI SYLLABLE RRURX
      #xA38D	;YI SYLLABLE RRUR
      #xA38E	;YI SYLLABLE RRYT
      #xA38F	;YI SYLLABLE RRYX
      #xA390	;YI SYLLABLE RRY
      #xA391	;YI SYLLABLE RRYP
      #xA392	;YI SYLLABLE RRYRX
      #xA393	;YI SYLLABLE RRYR
      #xA394	;YI SYLLABLE NRAT
      #xA395	;YI SYLLABLE NRAX
      #xA396	;YI SYLLABLE NRA
      #xA397	;YI SYLLABLE NRAP
      #xA398	;YI SYLLABLE NROX
      #xA399	;YI SYLLABLE NRO
      #xA39A	;YI SYLLABLE NROP
      #xA39B	;YI SYLLABLE NRET
      #xA39C	;YI SYLLABLE NREX
      #xA39D	;YI SYLLABLE NRE
      #xA39E	;YI SYLLABLE NREP
      #xA39F	;YI SYLLABLE NRUT
      #xA3A0	;YI SYLLABLE NRUX
      #xA3A1	;YI SYLLABLE NRU
      #xA3A2	;YI SYLLABLE NRUP
      #xA3A3	;YI SYLLABLE NRURX
      #xA3A4	;YI SYLLABLE NRUR
      #xA3A5	;YI SYLLABLE NRYT
      #xA3A6	;YI SYLLABLE NRYX
      #xA3A7	;YI SYLLABLE NRY
      #xA3A8	;YI SYLLABLE NRYP
      #xA3A9	;YI SYLLABLE NRYRX
      #xA3AA	;YI SYLLABLE NRYR
      #xA3AB	;YI SYLLABLE SHAT
      #xA3AC	;YI SYLLABLE SHAX
      #xA3AD	;YI SYLLABLE SHA
      #xA3AE	;YI SYLLABLE SHAP
      #xA3AF	;YI SYLLABLE SHUOX
      #xA3B0	;YI SYLLABLE SHUO
      #xA3B1	;YI SYLLABLE SHUOP
      #xA3B2	;YI SYLLABLE SHOT
      #xA3B3	;YI SYLLABLE SHOX
      #xA3B4	;YI SYLLABLE SHO
      #xA3B5	;YI SYLLABLE SHOP
      #xA3B6	;YI SYLLABLE SHET
      #xA3B7	;YI SYLLABLE SHEX
      #xA3B8	;YI SYLLABLE SHE
      #xA3B9	;YI SYLLABLE SHEP
      #xA3BA	;YI SYLLABLE SHUT
      #xA3BB	;YI SYLLABLE SHUX
      #xA3BC	;YI SYLLABLE SHU
      #xA3BD	;YI SYLLABLE SHUP
      #xA3BE	;YI SYLLABLE SHURX
      #xA3BF	;YI SYLLABLE SHUR
      #xA3C0	;YI SYLLABLE SHYT
      #xA3C1	;YI SYLLABLE SHYX
      #xA3C2	;YI SYLLABLE SHY
      #xA3C3	;YI SYLLABLE SHYP
      #xA3C4	;YI SYLLABLE SHYRX
      #xA3C5	;YI SYLLABLE SHYR
      #xA3C6	;YI SYLLABLE RAT
      #xA3C7	;YI SYLLABLE RAX
      #xA3C8	;YI SYLLABLE RA
      #xA3C9	;YI SYLLABLE RAP
      #xA3CA	;YI SYLLABLE RUOX
      #xA3CB	;YI SYLLABLE RUO
      #xA3CC	;YI SYLLABLE RUOP
      #xA3CD	;YI SYLLABLE ROT
      #xA3CE	;YI SYLLABLE ROX
      #xA3CF	;YI SYLLABLE RO
      #xA3D0	;YI SYLLABLE ROP
      #xA3D1	;YI SYLLABLE REX
      #xA3D2	;YI SYLLABLE RE
      #xA3D3	;YI SYLLABLE REP
      #xA3D4	;YI SYLLABLE RUT
      #xA3D5	;YI SYLLABLE RUX
      #xA3D6	;YI SYLLABLE RU
      #xA3D7	;YI SYLLABLE RUP
      #xA3D8	;YI SYLLABLE RURX
      #xA3D9	;YI SYLLABLE RUR
      #xA3DA	;YI SYLLABLE RYT
      #xA3DB	;YI SYLLABLE RYX
      #xA3DC	;YI SYLLABLE RY
      #xA3DD	;YI SYLLABLE RYP
      #xA3DE	;YI SYLLABLE RYRX
      #xA3DF	;YI SYLLABLE RYR
      #xA3E0	;YI SYLLABLE JIT
      #xA3E1	;YI SYLLABLE JIX
      #xA3E2	;YI SYLLABLE JI
      #xA3E3	;YI SYLLABLE JIP
      #xA3E4	;YI SYLLABLE JIET
      #xA3E5	;YI SYLLABLE JIEX
      #xA3E6	;YI SYLLABLE JIE
      #xA3E7	;YI SYLLABLE JIEP
      #xA3E8	;YI SYLLABLE JUOT
      #xA3E9	;YI SYLLABLE JUOX
      #xA3EA	;YI SYLLABLE JUO
      #xA3EB	;YI SYLLABLE JUOP
      #xA3EC	;YI SYLLABLE JOT
      #xA3ED	;YI SYLLABLE JOX
      #xA3EE	;YI SYLLABLE JO
      #xA3EF	;YI SYLLABLE JOP
      #xA3F0	;YI SYLLABLE JUT
      #xA3F1	;YI SYLLABLE JUX
      #xA3F2	;YI SYLLABLE JU
      #xA3F3	;YI SYLLABLE JUP
      #xA3F4	;YI SYLLABLE JURX
      #xA3F5	;YI SYLLABLE JUR
      #xA3F6	;YI SYLLABLE JYT
      #xA3F7	;YI SYLLABLE JYX
      #xA3F8	;YI SYLLABLE JY
      #xA3F9	;YI SYLLABLE JYP
      #xA3FA	;YI SYLLABLE JYRX
      #xA3FB	;YI SYLLABLE JYR
      #xA3FC	;YI SYLLABLE QIT
      #xA3FD	;YI SYLLABLE QIX
      #xA3FE	;YI SYLLABLE QI
      #xA3FF	;YI SYLLABLE QIP
      #xA400	;YI SYLLABLE QIET
      #xA401	;YI SYLLABLE QIEX
      #xA402	;YI SYLLABLE QIE
      #xA403	;YI SYLLABLE QIEP
      #xA404	;YI SYLLABLE QUOT
      #xA405	;YI SYLLABLE QUOX
      #xA406	;YI SYLLABLE QUO
      #xA407	;YI SYLLABLE QUOP
      #xA408	;YI SYLLABLE QOT
      #xA409	;YI SYLLABLE QOX
      #xA40A	;YI SYLLABLE QO
      #xA40B	;YI SYLLABLE QOP
      #xA40C	;YI SYLLABLE QUT
      #xA40D	;YI SYLLABLE QUX
      #xA40E	;YI SYLLABLE QU
      #xA40F	;YI SYLLABLE QUP
      #xA410	;YI SYLLABLE QURX
      #xA411	;YI SYLLABLE QUR
      #xA412	;YI SYLLABLE QYT
      #xA413	;YI SYLLABLE QYX
      #xA414	;YI SYLLABLE QY
      #xA415	;YI SYLLABLE QYP
      #xA416	;YI SYLLABLE QYRX
      #xA417	;YI SYLLABLE QYR
      #xA418	;YI SYLLABLE JJIT
      #xA419	;YI SYLLABLE JJIX
      #xA41A	;YI SYLLABLE JJI
      #xA41B	;YI SYLLABLE JJIP
      #xA41C	;YI SYLLABLE JJIET
      #xA41D	;YI SYLLABLE JJIEX
      #xA41E	;YI SYLLABLE JJIE
      #xA41F	;YI SYLLABLE JJIEP
      #xA420	;YI SYLLABLE JJUOX
      #xA421	;YI SYLLABLE JJUO
      #xA422	;YI SYLLABLE JJUOP
      #xA423	;YI SYLLABLE JJOT
      #xA424	;YI SYLLABLE JJOX
      #xA425	;YI SYLLABLE JJO
      #xA426	;YI SYLLABLE JJOP
      #xA427	;YI SYLLABLE JJUT
      #xA428	;YI SYLLABLE JJUX
      #xA429	;YI SYLLABLE JJU
      #xA42A	;YI SYLLABLE JJUP
      #xA42B	;YI SYLLABLE JJURX
      #xA42C	;YI SYLLABLE JJUR
      #xA42D	;YI SYLLABLE JJYT
      #xA42E	;YI SYLLABLE JJYX
      #xA42F	;YI SYLLABLE JJY
      #xA430	;YI SYLLABLE JJYP
      #xA431	;YI SYLLABLE NJIT
      #xA432	;YI SYLLABLE NJIX
      #xA433	;YI SYLLABLE NJI
      #xA434	;YI SYLLABLE NJIP
      #xA435	;YI SYLLABLE NJIET
      #xA436	;YI SYLLABLE NJIEX
      #xA437	;YI SYLLABLE NJIE
      #xA438	;YI SYLLABLE NJIEP
      #xA439	;YI SYLLABLE NJUOX
      #xA43A	;YI SYLLABLE NJUO
      #xA43B	;YI SYLLABLE NJOT
      #xA43C	;YI SYLLABLE NJOX
      #xA43D	;YI SYLLABLE NJO
      #xA43E	;YI SYLLABLE NJOP
      #xA43F	;YI SYLLABLE NJUX
      #xA440	;YI SYLLABLE NJU
      #xA441	;YI SYLLABLE NJUP
      #xA442	;YI SYLLABLE NJURX
      #xA443	;YI SYLLABLE NJUR
      #xA444	;YI SYLLABLE NJYT
      #xA445	;YI SYLLABLE NJYX
      #xA446	;YI SYLLABLE NJY
      #xA447	;YI SYLLABLE NJYP
      #xA448	;YI SYLLABLE NJYRX
      #xA449	;YI SYLLABLE NJYR
      #xA44A	;YI SYLLABLE NYIT
      #xA44B	;YI SYLLABLE NYIX
      #xA44C	;YI SYLLABLE NYI
      #xA44D	;YI SYLLABLE NYIP
      #xA44E	;YI SYLLABLE NYIET
      #xA44F	;YI SYLLABLE NYIEX
      #xA450	;YI SYLLABLE NYIE
      #xA451	;YI SYLLABLE NYIEP
      #xA452	;YI SYLLABLE NYUOX
      #xA453	;YI SYLLABLE NYUO
      #xA454	;YI SYLLABLE NYUOP
      #xA455	;YI SYLLABLE NYOT
      #xA456	;YI SYLLABLE NYOX
      #xA457	;YI SYLLABLE NYO
      #xA458	;YI SYLLABLE NYOP
      #xA459	;YI SYLLABLE NYUT
      #xA45A	;YI SYLLABLE NYUX
      #xA45B	;YI SYLLABLE NYU
      #xA45C	;YI SYLLABLE NYUP
      #xA45D	;YI SYLLABLE XIT
      #xA45E	;YI SYLLABLE XIX
      #xA45F	;YI SYLLABLE XI
      #xA460	;YI SYLLABLE XIP
      #xA461	;YI SYLLABLE XIET
      #xA462	;YI SYLLABLE XIEX
      #xA463	;YI SYLLABLE XIE
      #xA464	;YI SYLLABLE XIEP
      #xA465	;YI SYLLABLE XUOX
      #xA466	;YI SYLLABLE XUO
      #xA467	;YI SYLLABLE XOT
      #xA468	;YI SYLLABLE XOX
      #xA469	;YI SYLLABLE XO
      #xA46A	;YI SYLLABLE XOP
      #xA46B	;YI SYLLABLE XYT
      #xA46C	;YI SYLLABLE XYX
      #xA46D	;YI SYLLABLE XY
      #xA46E	;YI SYLLABLE XYP
      #xA46F	;YI SYLLABLE XYRX
      #xA470	;YI SYLLABLE XYR
      #xA471	;YI SYLLABLE YIT
      #xA472	;YI SYLLABLE YIX
      #xA473	;YI SYLLABLE YI
      #xA474	;YI SYLLABLE YIP
      #xA475	;YI SYLLABLE YIET
      #xA476	;YI SYLLABLE YIEX
      #xA477	;YI SYLLABLE YIE
      #xA478	;YI SYLLABLE YIEP
      #xA479	;YI SYLLABLE YUOT
      #xA47A	;YI SYLLABLE YUOX
      #xA47B	;YI SYLLABLE YUO
      #xA47C	;YI SYLLABLE YUOP
      #xA47D	;YI SYLLABLE YOT
      #xA47E	;YI SYLLABLE YOX
      #xA47F	;YI SYLLABLE YO
      #xA480	;YI SYLLABLE YOP
      #xA481	;YI SYLLABLE YUT
      #xA482	;YI SYLLABLE YUX
      #xA483	;YI SYLLABLE YU
      #xA484	;YI SYLLABLE YUP
      #xA485	;YI SYLLABLE YURX
      #xA486	;YI SYLLABLE YUR
      #xA487	;YI SYLLABLE YYT
      #xA488	;YI SYLLABLE YYX
      #xA489	;YI SYLLABLE YY
      #xA48A	;YI SYLLABLE YYP
      #xA48B	;YI SYLLABLE YYRX
      #xA48C	;YI SYLLABLE YYR
      #xAC00	;<Hangul Syllable, First>
      #xD7A3	;<Hangul Syllable, Last>
      #xF900	;CJK COMPATIBILITY IDEOGRAPH-F900
      #xF901	;CJK COMPATIBILITY IDEOGRAPH-F901
      #xF902	;CJK COMPATIBILITY IDEOGRAPH-F902
      #xF903	;CJK COMPATIBILITY IDEOGRAPH-F903
      #xF904	;CJK COMPATIBILITY IDEOGRAPH-F904
      #xF905	;CJK COMPATIBILITY IDEOGRAPH-F905
      #xF906	;CJK COMPATIBILITY IDEOGRAPH-F906
      #xF907	;CJK COMPATIBILITY IDEOGRAPH-F907
      #xF908	;CJK COMPATIBILITY IDEOGRAPH-F908
      #xF909	;CJK COMPATIBILITY IDEOGRAPH-F909
      #xF90A	;CJK COMPATIBILITY IDEOGRAPH-F90A
      #xF90B	;CJK COMPATIBILITY IDEOGRAPH-F90B
      #xF90C	;CJK COMPATIBILITY IDEOGRAPH-F90C
      #xF90D	;CJK COMPATIBILITY IDEOGRAPH-F90D
      #xF90E	;CJK COMPATIBILITY IDEOGRAPH-F90E
      #xF90F	;CJK COMPATIBILITY IDEOGRAPH-F90F
      #xF910	;CJK COMPATIBILITY IDEOGRAPH-F910
      #xF911	;CJK COMPATIBILITY IDEOGRAPH-F911
      #xF912	;CJK COMPATIBILITY IDEOGRAPH-F912
      #xF913	;CJK COMPATIBILITY IDEOGRAPH-F913
      #xF914	;CJK COMPATIBILITY IDEOGRAPH-F914
      #xF915	;CJK COMPATIBILITY IDEOGRAPH-F915
      #xF916	;CJK COMPATIBILITY IDEOGRAPH-F916
      #xF917	;CJK COMPATIBILITY IDEOGRAPH-F917
      #xF918	;CJK COMPATIBILITY IDEOGRAPH-F918
      #xF919	;CJK COMPATIBILITY IDEOGRAPH-F919
      #xF91A	;CJK COMPATIBILITY IDEOGRAPH-F91A
      #xF91B	;CJK COMPATIBILITY IDEOGRAPH-F91B
      #xF91C	;CJK COMPATIBILITY IDEOGRAPH-F91C
      #xF91D	;CJK COMPATIBILITY IDEOGRAPH-F91D
      #xF91E	;CJK COMPATIBILITY IDEOGRAPH-F91E
      #xF91F	;CJK COMPATIBILITY IDEOGRAPH-F91F
      #xF920	;CJK COMPATIBILITY IDEOGRAPH-F920
      #xF921	;CJK COMPATIBILITY IDEOGRAPH-F921
      #xF922	;CJK COMPATIBILITY IDEOGRAPH-F922
      #xF923	;CJK COMPATIBILITY IDEOGRAPH-F923
      #xF924	;CJK COMPATIBILITY IDEOGRAPH-F924
      #xF925	;CJK COMPATIBILITY IDEOGRAPH-F925
      #xF926	;CJK COMPATIBILITY IDEOGRAPH-F926
      #xF927	;CJK COMPATIBILITY IDEOGRAPH-F927
      #xF928	;CJK COMPATIBILITY IDEOGRAPH-F928
      #xF929	;CJK COMPATIBILITY IDEOGRAPH-F929
      #xF92A	;CJK COMPATIBILITY IDEOGRAPH-F92A
      #xF92B	;CJK COMPATIBILITY IDEOGRAPH-F92B
      #xF92C	;CJK COMPATIBILITY IDEOGRAPH-F92C
      #xF92D	;CJK COMPATIBILITY IDEOGRAPH-F92D
      #xF92E	;CJK COMPATIBILITY IDEOGRAPH-F92E
      #xF92F	;CJK COMPATIBILITY IDEOGRAPH-F92F
      #xF930	;CJK COMPATIBILITY IDEOGRAPH-F930
      #xF931	;CJK COMPATIBILITY IDEOGRAPH-F931
      #xF932	;CJK COMPATIBILITY IDEOGRAPH-F932
      #xF933	;CJK COMPATIBILITY IDEOGRAPH-F933
      #xF934	;CJK COMPATIBILITY IDEOGRAPH-F934
      #xF935	;CJK COMPATIBILITY IDEOGRAPH-F935
      #xF936	;CJK COMPATIBILITY IDEOGRAPH-F936
      #xF937	;CJK COMPATIBILITY IDEOGRAPH-F937
      #xF938	;CJK COMPATIBILITY IDEOGRAPH-F938
      #xF939	;CJK COMPATIBILITY IDEOGRAPH-F939
      #xF93A	;CJK COMPATIBILITY IDEOGRAPH-F93A
      #xF93B	;CJK COMPATIBILITY IDEOGRAPH-F93B
      #xF93C	;CJK COMPATIBILITY IDEOGRAPH-F93C
      #xF93D	;CJK COMPATIBILITY IDEOGRAPH-F93D
      #xF93E	;CJK COMPATIBILITY IDEOGRAPH-F93E
      #xF93F	;CJK COMPATIBILITY IDEOGRAPH-F93F
      #xF940	;CJK COMPATIBILITY IDEOGRAPH-F940
      #xF941	;CJK COMPATIBILITY IDEOGRAPH-F941
      #xF942	;CJK COMPATIBILITY IDEOGRAPH-F942
      #xF943	;CJK COMPATIBILITY IDEOGRAPH-F943
      #xF944	;CJK COMPATIBILITY IDEOGRAPH-F944
      #xF945	;CJK COMPATIBILITY IDEOGRAPH-F945
      #xF946	;CJK COMPATIBILITY IDEOGRAPH-F946
      #xF947	;CJK COMPATIBILITY IDEOGRAPH-F947
      #xF948	;CJK COMPATIBILITY IDEOGRAPH-F948
      #xF949	;CJK COMPATIBILITY IDEOGRAPH-F949
      #xF94A	;CJK COMPATIBILITY IDEOGRAPH-F94A
      #xF94B	;CJK COMPATIBILITY IDEOGRAPH-F94B
      #xF94C	;CJK COMPATIBILITY IDEOGRAPH-F94C
      #xF94D	;CJK COMPATIBILITY IDEOGRAPH-F94D
      #xF94E	;CJK COMPATIBILITY IDEOGRAPH-F94E
      #xF94F	;CJK COMPATIBILITY IDEOGRAPH-F94F
      #xF950	;CJK COMPATIBILITY IDEOGRAPH-F950
      #xF951	;CJK COMPATIBILITY IDEOGRAPH-F951
      #xF952	;CJK COMPATIBILITY IDEOGRAPH-F952
      #xF953	;CJK COMPATIBILITY IDEOGRAPH-F953
      #xF954	;CJK COMPATIBILITY IDEOGRAPH-F954
      #xF955	;CJK COMPATIBILITY IDEOGRAPH-F955
      #xF956	;CJK COMPATIBILITY IDEOGRAPH-F956
      #xF957	;CJK COMPATIBILITY IDEOGRAPH-F957
      #xF958	;CJK COMPATIBILITY IDEOGRAPH-F958
      #xF959	;CJK COMPATIBILITY IDEOGRAPH-F959
      #xF95A	;CJK COMPATIBILITY IDEOGRAPH-F95A
      #xF95B	;CJK COMPATIBILITY IDEOGRAPH-F95B
      #xF95C	;CJK COMPATIBILITY IDEOGRAPH-F95C
      #xF95D	;CJK COMPATIBILITY IDEOGRAPH-F95D
      #xF95E	;CJK COMPATIBILITY IDEOGRAPH-F95E
      #xF95F	;CJK COMPATIBILITY IDEOGRAPH-F95F
      #xF960	;CJK COMPATIBILITY IDEOGRAPH-F960
      #xF961	;CJK COMPATIBILITY IDEOGRAPH-F961
      #xF962	;CJK COMPATIBILITY IDEOGRAPH-F962
      #xF963	;CJK COMPATIBILITY IDEOGRAPH-F963
      #xF964	;CJK COMPATIBILITY IDEOGRAPH-F964
      #xF965	;CJK COMPATIBILITY IDEOGRAPH-F965
      #xF966	;CJK COMPATIBILITY IDEOGRAPH-F966
      #xF967	;CJK COMPATIBILITY IDEOGRAPH-F967
      #xF968	;CJK COMPATIBILITY IDEOGRAPH-F968
      #xF969	;CJK COMPATIBILITY IDEOGRAPH-F969
      #xF96A	;CJK COMPATIBILITY IDEOGRAPH-F96A
      #xF96B	;CJK COMPATIBILITY IDEOGRAPH-F96B
      #xF96C	;CJK COMPATIBILITY IDEOGRAPH-F96C
      #xF96D	;CJK COMPATIBILITY IDEOGRAPH-F96D
      #xF96E	;CJK COMPATIBILITY IDEOGRAPH-F96E
      #xF96F	;CJK COMPATIBILITY IDEOGRAPH-F96F
      #xF970	;CJK COMPATIBILITY IDEOGRAPH-F970
      #xF971	;CJK COMPATIBILITY IDEOGRAPH-F971
      #xF972	;CJK COMPATIBILITY IDEOGRAPH-F972
      #xF973	;CJK COMPATIBILITY IDEOGRAPH-F973
      #xF974	;CJK COMPATIBILITY IDEOGRAPH-F974
      #xF975	;CJK COMPATIBILITY IDEOGRAPH-F975
      #xF976	;CJK COMPATIBILITY IDEOGRAPH-F976
      #xF977	;CJK COMPATIBILITY IDEOGRAPH-F977
      #xF978	;CJK COMPATIBILITY IDEOGRAPH-F978
      #xF979	;CJK COMPATIBILITY IDEOGRAPH-F979
      #xF97A	;CJK COMPATIBILITY IDEOGRAPH-F97A
      #xF97B	;CJK COMPATIBILITY IDEOGRAPH-F97B
      #xF97C	;CJK COMPATIBILITY IDEOGRAPH-F97C
      #xF97D	;CJK COMPATIBILITY IDEOGRAPH-F97D
      #xF97E	;CJK COMPATIBILITY IDEOGRAPH-F97E
      #xF97F	;CJK COMPATIBILITY IDEOGRAPH-F97F
      #xF980	;CJK COMPATIBILITY IDEOGRAPH-F980
      #xF981	;CJK COMPATIBILITY IDEOGRAPH-F981
      #xF982	;CJK COMPATIBILITY IDEOGRAPH-F982
      #xF983	;CJK COMPATIBILITY IDEOGRAPH-F983
      #xF984	;CJK COMPATIBILITY IDEOGRAPH-F984
      #xF985	;CJK COMPATIBILITY IDEOGRAPH-F985
      #xF986	;CJK COMPATIBILITY IDEOGRAPH-F986
      #xF987	;CJK COMPATIBILITY IDEOGRAPH-F987
      #xF988	;CJK COMPATIBILITY IDEOGRAPH-F988
      #xF989	;CJK COMPATIBILITY IDEOGRAPH-F989
      #xF98A	;CJK COMPATIBILITY IDEOGRAPH-F98A
      #xF98B	;CJK COMPATIBILITY IDEOGRAPH-F98B
      #xF98C	;CJK COMPATIBILITY IDEOGRAPH-F98C
      #xF98D	;CJK COMPATIBILITY IDEOGRAPH-F98D
      #xF98E	;CJK COMPATIBILITY IDEOGRAPH-F98E
      #xF98F	;CJK COMPATIBILITY IDEOGRAPH-F98F
      #xF990	;CJK COMPATIBILITY IDEOGRAPH-F990
      #xF991	;CJK COMPATIBILITY IDEOGRAPH-F991
      #xF992	;CJK COMPATIBILITY IDEOGRAPH-F992
      #xF993	;CJK COMPATIBILITY IDEOGRAPH-F993
      #xF994	;CJK COMPATIBILITY IDEOGRAPH-F994
      #xF995	;CJK COMPATIBILITY IDEOGRAPH-F995
      #xF996	;CJK COMPATIBILITY IDEOGRAPH-F996
      #xF997	;CJK COMPATIBILITY IDEOGRAPH-F997
      #xF998	;CJK COMPATIBILITY IDEOGRAPH-F998
      #xF999	;CJK COMPATIBILITY IDEOGRAPH-F999
      #xF99A	;CJK COMPATIBILITY IDEOGRAPH-F99A
      #xF99B	;CJK COMPATIBILITY IDEOGRAPH-F99B
      #xF99C	;CJK COMPATIBILITY IDEOGRAPH-F99C
      #xF99D	;CJK COMPATIBILITY IDEOGRAPH-F99D
      #xF99E	;CJK COMPATIBILITY IDEOGRAPH-F99E
      #xF99F	;CJK COMPATIBILITY IDEOGRAPH-F99F
      #xF9A0	;CJK COMPATIBILITY IDEOGRAPH-F9A0
      #xF9A1	;CJK COMPATIBILITY IDEOGRAPH-F9A1
      #xF9A2	;CJK COMPATIBILITY IDEOGRAPH-F9A2
      #xF9A3	;CJK COMPATIBILITY IDEOGRAPH-F9A3
      #xF9A4	;CJK COMPATIBILITY IDEOGRAPH-F9A4
      #xF9A5	;CJK COMPATIBILITY IDEOGRAPH-F9A5
      #xF9A6	;CJK COMPATIBILITY IDEOGRAPH-F9A6
      #xF9A7	;CJK COMPATIBILITY IDEOGRAPH-F9A7
      #xF9A8	;CJK COMPATIBILITY IDEOGRAPH-F9A8
      #xF9A9	;CJK COMPATIBILITY IDEOGRAPH-F9A9
      #xF9AA	;CJK COMPATIBILITY IDEOGRAPH-F9AA
      #xF9AB	;CJK COMPATIBILITY IDEOGRAPH-F9AB
      #xF9AC	;CJK COMPATIBILITY IDEOGRAPH-F9AC
      #xF9AD	;CJK COMPATIBILITY IDEOGRAPH-F9AD
      #xF9AE	;CJK COMPATIBILITY IDEOGRAPH-F9AE
      #xF9AF	;CJK COMPATIBILITY IDEOGRAPH-F9AF
      #xF9B0	;CJK COMPATIBILITY IDEOGRAPH-F9B0
      #xF9B1	;CJK COMPATIBILITY IDEOGRAPH-F9B1
      #xF9B2	;CJK COMPATIBILITY IDEOGRAPH-F9B2
      #xF9B3	;CJK COMPATIBILITY IDEOGRAPH-F9B3
      #xF9B4	;CJK COMPATIBILITY IDEOGRAPH-F9B4
      #xF9B5	;CJK COMPATIBILITY IDEOGRAPH-F9B5
      #xF9B6	;CJK COMPATIBILITY IDEOGRAPH-F9B6
      #xF9B7	;CJK COMPATIBILITY IDEOGRAPH-F9B7
      #xF9B8	;CJK COMPATIBILITY IDEOGRAPH-F9B8
      #xF9B9	;CJK COMPATIBILITY IDEOGRAPH-F9B9
      #xF9BA	;CJK COMPATIBILITY IDEOGRAPH-F9BA
      #xF9BB	;CJK COMPATIBILITY IDEOGRAPH-F9BB
      #xF9BC	;CJK COMPATIBILITY IDEOGRAPH-F9BC
      #xF9BD	;CJK COMPATIBILITY IDEOGRAPH-F9BD
      #xF9BE	;CJK COMPATIBILITY IDEOGRAPH-F9BE
      #xF9BF	;CJK COMPATIBILITY IDEOGRAPH-F9BF
      #xF9C0	;CJK COMPATIBILITY IDEOGRAPH-F9C0
      #xF9C1	;CJK COMPATIBILITY IDEOGRAPH-F9C1
      #xF9C2	;CJK COMPATIBILITY IDEOGRAPH-F9C2
      #xF9C3	;CJK COMPATIBILITY IDEOGRAPH-F9C3
      #xF9C4	;CJK COMPATIBILITY IDEOGRAPH-F9C4
      #xF9C5	;CJK COMPATIBILITY IDEOGRAPH-F9C5
      #xF9C6	;CJK COMPATIBILITY IDEOGRAPH-F9C6
      #xF9C7	;CJK COMPATIBILITY IDEOGRAPH-F9C7
      #xF9C8	;CJK COMPATIBILITY IDEOGRAPH-F9C8
      #xF9C9	;CJK COMPATIBILITY IDEOGRAPH-F9C9
      #xF9CA	;CJK COMPATIBILITY IDEOGRAPH-F9CA
      #xF9CB	;CJK COMPATIBILITY IDEOGRAPH-F9CB
      #xF9CC	;CJK COMPATIBILITY IDEOGRAPH-F9CC
      #xF9CD	;CJK COMPATIBILITY IDEOGRAPH-F9CD
      #xF9CE	;CJK COMPATIBILITY IDEOGRAPH-F9CE
      #xF9CF	;CJK COMPATIBILITY IDEOGRAPH-F9CF
      #xF9D0	;CJK COMPATIBILITY IDEOGRAPH-F9D0
      #xF9D1	;CJK COMPATIBILITY IDEOGRAPH-F9D1
      #xF9D2	;CJK COMPATIBILITY IDEOGRAPH-F9D2
      #xF9D3	;CJK COMPATIBILITY IDEOGRAPH-F9D3
      #xF9D4	;CJK COMPATIBILITY IDEOGRAPH-F9D4
      #xF9D5	;CJK COMPATIBILITY IDEOGRAPH-F9D5
      #xF9D6	;CJK COMPATIBILITY IDEOGRAPH-F9D6
      #xF9D7	;CJK COMPATIBILITY IDEOGRAPH-F9D7
      #xF9D8	;CJK COMPATIBILITY IDEOGRAPH-F9D8
      #xF9D9	;CJK COMPATIBILITY IDEOGRAPH-F9D9
      #xF9DA	;CJK COMPATIBILITY IDEOGRAPH-F9DA
      #xF9DB	;CJK COMPATIBILITY IDEOGRAPH-F9DB
      #xF9DC	;CJK COMPATIBILITY IDEOGRAPH-F9DC
      #xF9DD	;CJK COMPATIBILITY IDEOGRAPH-F9DD
      #xF9DE	;CJK COMPATIBILITY IDEOGRAPH-F9DE
      #xF9DF	;CJK COMPATIBILITY IDEOGRAPH-F9DF
      #xF9E0	;CJK COMPATIBILITY IDEOGRAPH-F9E0
      #xF9E1	;CJK COMPATIBILITY IDEOGRAPH-F9E1
      #xF9E2	;CJK COMPATIBILITY IDEOGRAPH-F9E2
      #xF9E3	;CJK COMPATIBILITY IDEOGRAPH-F9E3
      #xF9E4	;CJK COMPATIBILITY IDEOGRAPH-F9E4
      #xF9E5	;CJK COMPATIBILITY IDEOGRAPH-F9E5
      #xF9E6	;CJK COMPATIBILITY IDEOGRAPH-F9E6
      #xF9E7	;CJK COMPATIBILITY IDEOGRAPH-F9E7
      #xF9E8	;CJK COMPATIBILITY IDEOGRAPH-F9E8
      #xF9E9	;CJK COMPATIBILITY IDEOGRAPH-F9E9
      #xF9EA	;CJK COMPATIBILITY IDEOGRAPH-F9EA
      #xF9EB	;CJK COMPATIBILITY IDEOGRAPH-F9EB
      #xF9EC	;CJK COMPATIBILITY IDEOGRAPH-F9EC
      #xF9ED	;CJK COMPATIBILITY IDEOGRAPH-F9ED
      #xF9EE	;CJK COMPATIBILITY IDEOGRAPH-F9EE
      #xF9EF	;CJK COMPATIBILITY IDEOGRAPH-F9EF
      #xF9F0	;CJK COMPATIBILITY IDEOGRAPH-F9F0
      #xF9F1	;CJK COMPATIBILITY IDEOGRAPH-F9F1
      #xF9F2	;CJK COMPATIBILITY IDEOGRAPH-F9F2
      #xF9F3	;CJK COMPATIBILITY IDEOGRAPH-F9F3
      #xF9F4	;CJK COMPATIBILITY IDEOGRAPH-F9F4
      #xF9F5	;CJK COMPATIBILITY IDEOGRAPH-F9F5
      #xF9F6	;CJK COMPATIBILITY IDEOGRAPH-F9F6
      #xF9F7	;CJK COMPATIBILITY IDEOGRAPH-F9F7
      #xF9F8	;CJK COMPATIBILITY IDEOGRAPH-F9F8
      #xF9F9	;CJK COMPATIBILITY IDEOGRAPH-F9F9
      #xF9FA	;CJK COMPATIBILITY IDEOGRAPH-F9FA
      #xF9FB	;CJK COMPATIBILITY IDEOGRAPH-F9FB
      #xF9FC	;CJK COMPATIBILITY IDEOGRAPH-F9FC
      #xF9FD	;CJK COMPATIBILITY IDEOGRAPH-F9FD
      #xF9FE	;CJK COMPATIBILITY IDEOGRAPH-F9FE
      #xF9FF	;CJK COMPATIBILITY IDEOGRAPH-F9FF
      #xFA00	;CJK COMPATIBILITY IDEOGRAPH-FA00
      #xFA01	;CJK COMPATIBILITY IDEOGRAPH-FA01
      #xFA02	;CJK COMPATIBILITY IDEOGRAPH-FA02
      #xFA03	;CJK COMPATIBILITY IDEOGRAPH-FA03
      #xFA04	;CJK COMPATIBILITY IDEOGRAPH-FA04
      #xFA05	;CJK COMPATIBILITY IDEOGRAPH-FA05
      #xFA06	;CJK COMPATIBILITY IDEOGRAPH-FA06
      #xFA07	;CJK COMPATIBILITY IDEOGRAPH-FA07
      #xFA08	;CJK COMPATIBILITY IDEOGRAPH-FA08
      #xFA09	;CJK COMPATIBILITY IDEOGRAPH-FA09
      #xFA0A	;CJK COMPATIBILITY IDEOGRAPH-FA0A
      #xFA0B	;CJK COMPATIBILITY IDEOGRAPH-FA0B
      #xFA0C	;CJK COMPATIBILITY IDEOGRAPH-FA0C
      #xFA0D	;CJK COMPATIBILITY IDEOGRAPH-FA0D
      #xFA0E	;CJK COMPATIBILITY IDEOGRAPH-FA0E
      #xFA0F	;CJK COMPATIBILITY IDEOGRAPH-FA0F
      #xFA10	;CJK COMPATIBILITY IDEOGRAPH-FA10
      #xFA11	;CJK COMPATIBILITY IDEOGRAPH-FA11
      #xFA12	;CJK COMPATIBILITY IDEOGRAPH-FA12
      #xFA13	;CJK COMPATIBILITY IDEOGRAPH-FA13
      #xFA14	;CJK COMPATIBILITY IDEOGRAPH-FA14
      #xFA15	;CJK COMPATIBILITY IDEOGRAPH-FA15
      #xFA16	;CJK COMPATIBILITY IDEOGRAPH-FA16
      #xFA17	;CJK COMPATIBILITY IDEOGRAPH-FA17
      #xFA18	;CJK COMPATIBILITY IDEOGRAPH-FA18
      #xFA19	;CJK COMPATIBILITY IDEOGRAPH-FA19
      #xFA1A	;CJK COMPATIBILITY IDEOGRAPH-FA1A
      #xFA1B	;CJK COMPATIBILITY IDEOGRAPH-FA1B
      #xFA1C	;CJK COMPATIBILITY IDEOGRAPH-FA1C
      #xFA1D	;CJK COMPATIBILITY IDEOGRAPH-FA1D
      #xFA1E	;CJK COMPATIBILITY IDEOGRAPH-FA1E
      #xFA1F	;CJK COMPATIBILITY IDEOGRAPH-FA1F
      #xFA20	;CJK COMPATIBILITY IDEOGRAPH-FA20
      #xFA21	;CJK COMPATIBILITY IDEOGRAPH-FA21
      #xFA22	;CJK COMPATIBILITY IDEOGRAPH-FA22
      #xFA23	;CJK COMPATIBILITY IDEOGRAPH-FA23
      #xFA24	;CJK COMPATIBILITY IDEOGRAPH-FA24
      #xFA25	;CJK COMPATIBILITY IDEOGRAPH-FA25
      #xFA26	;CJK COMPATIBILITY IDEOGRAPH-FA26
      #xFA27	;CJK COMPATIBILITY IDEOGRAPH-FA27
      #xFA28	;CJK COMPATIBILITY IDEOGRAPH-FA28
      #xFA29	;CJK COMPATIBILITY IDEOGRAPH-FA29
      #xFA2A	;CJK COMPATIBILITY IDEOGRAPH-FA2A
      #xFA2B	;CJK COMPATIBILITY IDEOGRAPH-FA2B
      #xFA2C	;CJK COMPATIBILITY IDEOGRAPH-FA2C
      #xFA2D	;CJK COMPATIBILITY IDEOGRAPH-FA2D
      #xFA30	;CJK COMPATIBILITY IDEOGRAPH-FA30
      #xFA31	;CJK COMPATIBILITY IDEOGRAPH-FA31
      #xFA32	;CJK COMPATIBILITY IDEOGRAPH-FA32
      #xFA33	;CJK COMPATIBILITY IDEOGRAPH-FA33
      #xFA34	;CJK COMPATIBILITY IDEOGRAPH-FA34
      #xFA35	;CJK COMPATIBILITY IDEOGRAPH-FA35
      #xFA36	;CJK COMPATIBILITY IDEOGRAPH-FA36
      #xFA37	;CJK COMPATIBILITY IDEOGRAPH-FA37
      #xFA38	;CJK COMPATIBILITY IDEOGRAPH-FA38
      #xFA39	;CJK COMPATIBILITY IDEOGRAPH-FA39
      #xFA3A	;CJK COMPATIBILITY IDEOGRAPH-FA3A
      #xFA3B	;CJK COMPATIBILITY IDEOGRAPH-FA3B
      #xFA3C	;CJK COMPATIBILITY IDEOGRAPH-FA3C
      #xFA3D	;CJK COMPATIBILITY IDEOGRAPH-FA3D
      #xFA3E	;CJK COMPATIBILITY IDEOGRAPH-FA3E
      #xFA3F	;CJK COMPATIBILITY IDEOGRAPH-FA3F
      #xFA40	;CJK COMPATIBILITY IDEOGRAPH-FA40
      #xFA41	;CJK COMPATIBILITY IDEOGRAPH-FA41
      #xFA42	;CJK COMPATIBILITY IDEOGRAPH-FA42
      #xFA43	;CJK COMPATIBILITY IDEOGRAPH-FA43
      #xFA44	;CJK COMPATIBILITY IDEOGRAPH-FA44
      #xFA45	;CJK COMPATIBILITY IDEOGRAPH-FA45
      #xFA46	;CJK COMPATIBILITY IDEOGRAPH-FA46
      #xFA47	;CJK COMPATIBILITY IDEOGRAPH-FA47
      #xFA48	;CJK COMPATIBILITY IDEOGRAPH-FA48
      #xFA49	;CJK COMPATIBILITY IDEOGRAPH-FA49
      #xFA4A	;CJK COMPATIBILITY IDEOGRAPH-FA4A
      #xFA4B	;CJK COMPATIBILITY IDEOGRAPH-FA4B
      #xFA4C	;CJK COMPATIBILITY IDEOGRAPH-FA4C
      #xFA4D	;CJK COMPATIBILITY IDEOGRAPH-FA4D
      #xFA4E	;CJK COMPATIBILITY IDEOGRAPH-FA4E
      #xFA4F	;CJK COMPATIBILITY IDEOGRAPH-FA4F
      #xFA50	;CJK COMPATIBILITY IDEOGRAPH-FA50
      #xFA51	;CJK COMPATIBILITY IDEOGRAPH-FA51
      #xFA52	;CJK COMPATIBILITY IDEOGRAPH-FA52
      #xFA53	;CJK COMPATIBILITY IDEOGRAPH-FA53
      #xFA54	;CJK COMPATIBILITY IDEOGRAPH-FA54
      #xFA55	;CJK COMPATIBILITY IDEOGRAPH-FA55
      #xFA56	;CJK COMPATIBILITY IDEOGRAPH-FA56
      #xFA57	;CJK COMPATIBILITY IDEOGRAPH-FA57
      #xFA58	;CJK COMPATIBILITY IDEOGRAPH-FA58
      #xFA59	;CJK COMPATIBILITY IDEOGRAPH-FA59
      #xFA5A	;CJK COMPATIBILITY IDEOGRAPH-FA5A
      #xFA5B	;CJK COMPATIBILITY IDEOGRAPH-FA5B
      #xFA5C	;CJK COMPATIBILITY IDEOGRAPH-FA5C
      #xFA5D	;CJK COMPATIBILITY IDEOGRAPH-FA5D
      #xFA5E	;CJK COMPATIBILITY IDEOGRAPH-FA5E
      #xFA5F	;CJK COMPATIBILITY IDEOGRAPH-FA5F
      #xFA60	;CJK COMPATIBILITY IDEOGRAPH-FA60
      #xFA61	;CJK COMPATIBILITY IDEOGRAPH-FA61
      #xFA62	;CJK COMPATIBILITY IDEOGRAPH-FA62
      #xFA63	;CJK COMPATIBILITY IDEOGRAPH-FA63
      #xFA64	;CJK COMPATIBILITY IDEOGRAPH-FA64
      #xFA65	;CJK COMPATIBILITY IDEOGRAPH-FA65
      #xFA66	;CJK COMPATIBILITY IDEOGRAPH-FA66
      #xFA67	;CJK COMPATIBILITY IDEOGRAPH-FA67
      #xFA68	;CJK COMPATIBILITY IDEOGRAPH-FA68
      #xFA69	;CJK COMPATIBILITY IDEOGRAPH-FA69
      #xFA6A	;CJK COMPATIBILITY IDEOGRAPH-FA6A
      #xFB00	;LATIN SMALL LIGATURE FF
      #xFB01	;LATIN SMALL LIGATURE FI
      #xFB02	;LATIN SMALL LIGATURE FL
      #xFB03	;LATIN SMALL LIGATURE FFI
      #xFB04	;LATIN SMALL LIGATURE FFL
      #xFB05	;LATIN SMALL LIGATURE LONG S T
      #xFB06	;LATIN SMALL LIGATURE ST
      #xFB13	;ARMENIAN SMALL LIGATURE MEN NOW
      #xFB14	;ARMENIAN SMALL LIGATURE MEN ECH
      #xFB15	;ARMENIAN SMALL LIGATURE MEN INI
      #xFB16	;ARMENIAN SMALL LIGATURE VEW NOW
      #xFB17	;ARMENIAN SMALL LIGATURE MEN XEH
      #xFB1D	;HEBREW LETTER YOD WITH HIRIQ
      #xFB1F	;HEBREW LIGATURE YIDDISH YOD YOD PATAH
      #xFB20	;HEBREW LETTER ALTERNATIVE AYIN
      #xFB21	;HEBREW LETTER WIDE ALEF
      #xFB22	;HEBREW LETTER WIDE DALET
      #xFB23	;HEBREW LETTER WIDE HE
      #xFB24	;HEBREW LETTER WIDE KAF
      #xFB25	;HEBREW LETTER WIDE LAMED
      #xFB26	;HEBREW LETTER WIDE FINAL MEM
      #xFB27	;HEBREW LETTER WIDE RESH
      #xFB28	;HEBREW LETTER WIDE TAV
      #xFB2A	;HEBREW LETTER SHIN WITH SHIN DOT
      #xFB2B	;HEBREW LETTER SHIN WITH SIN DOT
      #xFB2C	;HEBREW LETTER SHIN WITH DAGESH AND SHIN DOT
      #xFB2D	;HEBREW LETTER SHIN WITH DAGESH AND SIN DOT
      #xFB2E	;HEBREW LETTER ALEF WITH PATAH
      #xFB2F	;HEBREW LETTER ALEF WITH QAMATS
      #xFB30	;HEBREW LETTER ALEF WITH MAPIQ
      #xFB31	;HEBREW LETTER BET WITH DAGESH
      #xFB32	;HEBREW LETTER GIMEL WITH DAGESH
      #xFB33	;HEBREW LETTER DALET WITH DAGESH
      #xFB34	;HEBREW LETTER HE WITH MAPIQ
      #xFB35	;HEBREW LETTER VAV WITH DAGESH
      #xFB36	;HEBREW LETTER ZAYIN WITH DAGESH
      #xFB38	;HEBREW LETTER TET WITH DAGESH
      #xFB39	;HEBREW LETTER YOD WITH DAGESH
      #xFB3A	;HEBREW LETTER FINAL KAF WITH DAGESH
      #xFB3B	;HEBREW LETTER KAF WITH DAGESH
      #xFB3C	;HEBREW LETTER LAMED WITH DAGESH
      #xFB3E	;HEBREW LETTER MEM WITH DAGESH
      #xFB40	;HEBREW LETTER NUN WITH DAGESH
      #xFB41	;HEBREW LETTER SAMEKH WITH DAGESH
      #xFB43	;HEBREW LETTER FINAL PE WITH DAGESH
      #xFB44	;HEBREW LETTER PE WITH DAGESH
      #xFB46	;HEBREW LETTER TSADI WITH DAGESH
      #xFB47	;HEBREW LETTER QOF WITH DAGESH
      #xFB48	;HEBREW LETTER RESH WITH DAGESH
      #xFB49	;HEBREW LETTER SHIN WITH DAGESH
      #xFB4A	;HEBREW LETTER TAV WITH DAGESH
      #xFB4B	;HEBREW LETTER VAV WITH HOLAM
      #xFB4C	;HEBREW LETTER BET WITH RAFE
      #xFB4D	;HEBREW LETTER KAF WITH RAFE
      #xFB4E	;HEBREW LETTER PE WITH RAFE
      #xFB4F	;HEBREW LIGATURE ALEF LAMED
      #xFB50	;ARABIC LETTER ALEF WASLA ISOLATED FORM
      #xFB51	;ARABIC LETTER ALEF WASLA FINAL FORM
      #xFB52	;ARABIC LETTER BEEH ISOLATED FORM
      #xFB53	;ARABIC LETTER BEEH FINAL FORM
      #xFB54	;ARABIC LETTER BEEH INITIAL FORM
      #xFB55	;ARABIC LETTER BEEH MEDIAL FORM
      #xFB56	;ARABIC LETTER PEH ISOLATED FORM
      #xFB57	;ARABIC LETTER PEH FINAL FORM
      #xFB58	;ARABIC LETTER PEH INITIAL FORM
      #xFB59	;ARABIC LETTER PEH MEDIAL FORM
      #xFB5A	;ARABIC LETTER BEHEH ISOLATED FORM
      #xFB5B	;ARABIC LETTER BEHEH FINAL FORM
      #xFB5C	;ARABIC LETTER BEHEH INITIAL FORM
      #xFB5D	;ARABIC LETTER BEHEH MEDIAL FORM
      #xFB5E	;ARABIC LETTER TTEHEH ISOLATED FORM
      #xFB5F	;ARABIC LETTER TTEHEH FINAL FORM
      #xFB60	;ARABIC LETTER TTEHEH INITIAL FORM
      #xFB61	;ARABIC LETTER TTEHEH MEDIAL FORM
      #xFB62	;ARABIC LETTER TEHEH ISOLATED FORM
      #xFB63	;ARABIC LETTER TEHEH FINAL FORM
      #xFB64	;ARABIC LETTER TEHEH INITIAL FORM
      #xFB65	;ARABIC LETTER TEHEH MEDIAL FORM
      #xFB66	;ARABIC LETTER TTEH ISOLATED FORM
      #xFB67	;ARABIC LETTER TTEH FINAL FORM
      #xFB68	;ARABIC LETTER TTEH INITIAL FORM
      #xFB69	;ARABIC LETTER TTEH MEDIAL FORM
      #xFB6A	;ARABIC LETTER VEH ISOLATED FORM
      #xFB6B	;ARABIC LETTER VEH FINAL FORM
      #xFB6C	;ARABIC LETTER VEH INITIAL FORM
      #xFB6D	;ARABIC LETTER VEH MEDIAL FORM
      #xFB6E	;ARABIC LETTER PEHEH ISOLATED FORM
      #xFB6F	;ARABIC LETTER PEHEH FINAL FORM
      #xFB70	;ARABIC LETTER PEHEH INITIAL FORM
      #xFB71	;ARABIC LETTER PEHEH MEDIAL FORM
      #xFB72	;ARABIC LETTER DYEH ISOLATED FORM
      #xFB73	;ARABIC LETTER DYEH FINAL FORM
      #xFB74	;ARABIC LETTER DYEH INITIAL FORM
      #xFB75	;ARABIC LETTER DYEH MEDIAL FORM
      #xFB76	;ARABIC LETTER NYEH ISOLATED FORM
      #xFB77	;ARABIC LETTER NYEH FINAL FORM
      #xFB78	;ARABIC LETTER NYEH INITIAL FORM
      #xFB79	;ARABIC LETTER NYEH MEDIAL FORM
      #xFB7A	;ARABIC LETTER TCHEH ISOLATED FORM
      #xFB7B	;ARABIC LETTER TCHEH FINAL FORM
      #xFB7C	;ARABIC LETTER TCHEH INITIAL FORM
      #xFB7D	;ARABIC LETTER TCHEH MEDIAL FORM
      #xFB7E	;ARABIC LETTER TCHEHEH ISOLATED FORM
      #xFB7F	;ARABIC LETTER TCHEHEH FINAL FORM
      #xFB80	;ARABIC LETTER TCHEHEH INITIAL FORM
      #xFB81	;ARABIC LETTER TCHEHEH MEDIAL FORM
      #xFB82	;ARABIC LETTER DDAHAL ISOLATED FORM
      #xFB83	;ARABIC LETTER DDAHAL FINAL FORM
      #xFB84	;ARABIC LETTER DAHAL ISOLATED FORM
      #xFB85	;ARABIC LETTER DAHAL FINAL FORM
      #xFB86	;ARABIC LETTER DUL ISOLATED FORM
      #xFB87	;ARABIC LETTER DUL FINAL FORM
      #xFB88	;ARABIC LETTER DDAL ISOLATED FORM
      #xFB89	;ARABIC LETTER DDAL FINAL FORM
      #xFB8A	;ARABIC LETTER JEH ISOLATED FORM
      #xFB8B	;ARABIC LETTER JEH FINAL FORM
      #xFB8C	;ARABIC LETTER RREH ISOLATED FORM
      #xFB8D	;ARABIC LETTER RREH FINAL FORM
      #xFB8E	;ARABIC LETTER KEHEH ISOLATED FORM
      #xFB8F	;ARABIC LETTER KEHEH FINAL FORM
      #xFB90	;ARABIC LETTER KEHEH INITIAL FORM
      #xFB91	;ARABIC LETTER KEHEH MEDIAL FORM
      #xFB92	;ARABIC LETTER GAF ISOLATED FORM
      #xFB93	;ARABIC LETTER GAF FINAL FORM
      #xFB94	;ARABIC LETTER GAF INITIAL FORM
      #xFB95	;ARABIC LETTER GAF MEDIAL FORM
      #xFB96	;ARABIC LETTER GUEH ISOLATED FORM
      #xFB97	;ARABIC LETTER GUEH FINAL FORM
      #xFB98	;ARABIC LETTER GUEH INITIAL FORM
      #xFB99	;ARABIC LETTER GUEH MEDIAL FORM
      #xFB9A	;ARABIC LETTER NGOEH ISOLATED FORM
      #xFB9B	;ARABIC LETTER NGOEH FINAL FORM
      #xFB9C	;ARABIC LETTER NGOEH INITIAL FORM
      #xFB9D	;ARABIC LETTER NGOEH MEDIAL FORM
      #xFB9E	;ARABIC LETTER NOON GHUNNA ISOLATED FORM
      #xFB9F	;ARABIC LETTER NOON GHUNNA FINAL FORM
      #xFBA0	;ARABIC LETTER RNOON ISOLATED FORM
      #xFBA1	;ARABIC LETTER RNOON FINAL FORM
      #xFBA2	;ARABIC LETTER RNOON INITIAL FORM
      #xFBA3	;ARABIC LETTER RNOON MEDIAL FORM
      #xFBA4	;ARABIC LETTER HEH WITH YEH ABOVE ISOLATED FORM
      #xFBA5	;ARABIC LETTER HEH WITH YEH ABOVE FINAL FORM
      #xFBA6	;ARABIC LETTER HEH GOAL ISOLATED FORM
      #xFBA7	;ARABIC LETTER HEH GOAL FINAL FORM
      #xFBA8	;ARABIC LETTER HEH GOAL INITIAL FORM
      #xFBA9	;ARABIC LETTER HEH GOAL MEDIAL FORM
      #xFBAA	;ARABIC LETTER HEH DOACHASHMEE ISOLATED FORM
      #xFBAB	;ARABIC LETTER HEH DOACHASHMEE FINAL FORM
      #xFBAC	;ARABIC LETTER HEH DOACHASHMEE INITIAL FORM
      #xFBAD	;ARABIC LETTER HEH DOACHASHMEE MEDIAL FORM
      #xFBAE	;ARABIC LETTER YEH BARREE ISOLATED FORM
      #xFBAF	;ARABIC LETTER YEH BARREE FINAL FORM
      #xFBB0	;ARABIC LETTER YEH BARREE WITH HAMZA ABOVE ISOLATED FORM
      #xFBB1	;ARABIC LETTER YEH BARREE WITH HAMZA ABOVE FINAL FORM
      #xFBD3	;ARABIC LETTER NG ISOLATED FORM
      #xFBD4	;ARABIC LETTER NG FINAL FORM
      #xFBD5	;ARABIC LETTER NG INITIAL FORM
      #xFBD6	;ARABIC LETTER NG MEDIAL FORM
      #xFBD7	;ARABIC LETTER U ISOLATED FORM
      #xFBD8	;ARABIC LETTER U FINAL FORM
      #xFBD9	;ARABIC LETTER OE ISOLATED FORM
      #xFBDA	;ARABIC LETTER OE FINAL FORM
      #xFBDB	;ARABIC LETTER YU ISOLATED FORM
      #xFBDC	;ARABIC LETTER YU FINAL FORM
      #xFBDD	;ARABIC LETTER U WITH HAMZA ABOVE ISOLATED FORM
      #xFBDE	;ARABIC LETTER VE ISOLATED FORM
      #xFBDF	;ARABIC LETTER VE FINAL FORM
      #xFBE0	;ARABIC LETTER KIRGHIZ OE ISOLATED FORM
      #xFBE1	;ARABIC LETTER KIRGHIZ OE FINAL FORM
      #xFBE2	;ARABIC LETTER KIRGHIZ YU ISOLATED FORM
      #xFBE3	;ARABIC LETTER KIRGHIZ YU FINAL FORM
      #xFBE4	;ARABIC LETTER E ISOLATED FORM
      #xFBE5	;ARABIC LETTER E FINAL FORM
      #xFBE6	;ARABIC LETTER E INITIAL FORM
      #xFBE7	;ARABIC LETTER E MEDIAL FORM
      #xFBE8	;ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA INITIAL FORM
      #xFBE9	;ARABIC LETTER UIGHUR KAZAKH KIRGHIZ ALEF MAKSURA MEDIAL FORM
      #xFBEA	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF ISOLATED FORM
      #xFBEB	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF FINAL FORM
      #xFBEC	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE ISOLATED FORM
      #xFBED	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH AE FINAL FORM
      #xFBEE	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW ISOLATED FORM
      #xFBEF	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH WAW FINAL FORM
      #xFBF0	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U ISOLATED FORM
      #xFBF1	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH U FINAL FORM
      #xFBF2	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE ISOLATED FORM
      #xFBF3	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH OE FINAL FORM
      #xFBF4	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU ISOLATED FORM
      #xFBF5	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YU FINAL FORM
      #xFBF6	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E ISOLATED FORM
      #xFBF7	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E FINAL FORM
      #xFBF8	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH E INITIAL FORM
      #xFBF9	;ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM
      #xFBFA	;ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM
      #xFBFB	;ARABIC LIGATURE UIGHUR KIRGHIZ YEH WITH HAMZA ABOVE WITH ALEF MAKSURA INITIAL FORM
      #xFBFC	;ARABIC LETTER FARSI YEH ISOLATED FORM
      #xFBFD	;ARABIC LETTER FARSI YEH FINAL FORM
      #xFBFE	;ARABIC LETTER FARSI YEH INITIAL FORM
      #xFBFF	;ARABIC LETTER FARSI YEH MEDIAL FORM
      #xFC00	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM ISOLATED FORM
      #xFC01	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH ISOLATED FORM
      #xFC02	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM ISOLATED FORM
      #xFC03	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA ISOLATED FORM
      #xFC04	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH ISOLATED FORM
      #xFC05	;ARABIC LIGATURE BEH WITH JEEM ISOLATED FORM
      #xFC06	;ARABIC LIGATURE BEH WITH HAH ISOLATED FORM
      #xFC07	;ARABIC LIGATURE BEH WITH KHAH ISOLATED FORM
      #xFC08	;ARABIC LIGATURE BEH WITH MEEM ISOLATED FORM
      #xFC09	;ARABIC LIGATURE BEH WITH ALEF MAKSURA ISOLATED FORM
      #xFC0A	;ARABIC LIGATURE BEH WITH YEH ISOLATED FORM
      #xFC0B	;ARABIC LIGATURE TEH WITH JEEM ISOLATED FORM
      #xFC0C	;ARABIC LIGATURE TEH WITH HAH ISOLATED FORM
      #xFC0D	;ARABIC LIGATURE TEH WITH KHAH ISOLATED FORM
      #xFC0E	;ARABIC LIGATURE TEH WITH MEEM ISOLATED FORM
      #xFC0F	;ARABIC LIGATURE TEH WITH ALEF MAKSURA ISOLATED FORM
      #xFC10	;ARABIC LIGATURE TEH WITH YEH ISOLATED FORM
      #xFC11	;ARABIC LIGATURE THEH WITH JEEM ISOLATED FORM
      #xFC12	;ARABIC LIGATURE THEH WITH MEEM ISOLATED FORM
      #xFC13	;ARABIC LIGATURE THEH WITH ALEF MAKSURA ISOLATED FORM
      #xFC14	;ARABIC LIGATURE THEH WITH YEH ISOLATED FORM
      #xFC15	;ARABIC LIGATURE JEEM WITH HAH ISOLATED FORM
      #xFC16	;ARABIC LIGATURE JEEM WITH MEEM ISOLATED FORM
      #xFC17	;ARABIC LIGATURE HAH WITH JEEM ISOLATED FORM
      #xFC18	;ARABIC LIGATURE HAH WITH MEEM ISOLATED FORM
      #xFC19	;ARABIC LIGATURE KHAH WITH JEEM ISOLATED FORM
      #xFC1A	;ARABIC LIGATURE KHAH WITH HAH ISOLATED FORM
      #xFC1B	;ARABIC LIGATURE KHAH WITH MEEM ISOLATED FORM
      #xFC1C	;ARABIC LIGATURE SEEN WITH JEEM ISOLATED FORM
      #xFC1D	;ARABIC LIGATURE SEEN WITH HAH ISOLATED FORM
      #xFC1E	;ARABIC LIGATURE SEEN WITH KHAH ISOLATED FORM
      #xFC1F	;ARABIC LIGATURE SEEN WITH MEEM ISOLATED FORM
      #xFC20	;ARABIC LIGATURE SAD WITH HAH ISOLATED FORM
      #xFC21	;ARABIC LIGATURE SAD WITH MEEM ISOLATED FORM
      #xFC22	;ARABIC LIGATURE DAD WITH JEEM ISOLATED FORM
      #xFC23	;ARABIC LIGATURE DAD WITH HAH ISOLATED FORM
      #xFC24	;ARABIC LIGATURE DAD WITH KHAH ISOLATED FORM
      #xFC25	;ARABIC LIGATURE DAD WITH MEEM ISOLATED FORM
      #xFC26	;ARABIC LIGATURE TAH WITH HAH ISOLATED FORM
      #xFC27	;ARABIC LIGATURE TAH WITH MEEM ISOLATED FORM
      #xFC28	;ARABIC LIGATURE ZAH WITH MEEM ISOLATED FORM
      #xFC29	;ARABIC LIGATURE AIN WITH JEEM ISOLATED FORM
      #xFC2A	;ARABIC LIGATURE AIN WITH MEEM ISOLATED FORM
      #xFC2B	;ARABIC LIGATURE GHAIN WITH JEEM ISOLATED FORM
      #xFC2C	;ARABIC LIGATURE GHAIN WITH MEEM ISOLATED FORM
      #xFC2D	;ARABIC LIGATURE FEH WITH JEEM ISOLATED FORM
      #xFC2E	;ARABIC LIGATURE FEH WITH HAH ISOLATED FORM
      #xFC2F	;ARABIC LIGATURE FEH WITH KHAH ISOLATED FORM
      #xFC30	;ARABIC LIGATURE FEH WITH MEEM ISOLATED FORM
      #xFC31	;ARABIC LIGATURE FEH WITH ALEF MAKSURA ISOLATED FORM
      #xFC32	;ARABIC LIGATURE FEH WITH YEH ISOLATED FORM
      #xFC33	;ARABIC LIGATURE QAF WITH HAH ISOLATED FORM
      #xFC34	;ARABIC LIGATURE QAF WITH MEEM ISOLATED FORM
      #xFC35	;ARABIC LIGATURE QAF WITH ALEF MAKSURA ISOLATED FORM
      #xFC36	;ARABIC LIGATURE QAF WITH YEH ISOLATED FORM
      #xFC37	;ARABIC LIGATURE KAF WITH ALEF ISOLATED FORM
      #xFC38	;ARABIC LIGATURE KAF WITH JEEM ISOLATED FORM
      #xFC39	;ARABIC LIGATURE KAF WITH HAH ISOLATED FORM
      #xFC3A	;ARABIC LIGATURE KAF WITH KHAH ISOLATED FORM
      #xFC3B	;ARABIC LIGATURE KAF WITH LAM ISOLATED FORM
      #xFC3C	;ARABIC LIGATURE KAF WITH MEEM ISOLATED FORM
      #xFC3D	;ARABIC LIGATURE KAF WITH ALEF MAKSURA ISOLATED FORM
      #xFC3E	;ARABIC LIGATURE KAF WITH YEH ISOLATED FORM
      #xFC3F	;ARABIC LIGATURE LAM WITH JEEM ISOLATED FORM
      #xFC40	;ARABIC LIGATURE LAM WITH HAH ISOLATED FORM
      #xFC41	;ARABIC LIGATURE LAM WITH KHAH ISOLATED FORM
      #xFC42	;ARABIC LIGATURE LAM WITH MEEM ISOLATED FORM
      #xFC43	;ARABIC LIGATURE LAM WITH ALEF MAKSURA ISOLATED FORM
      #xFC44	;ARABIC LIGATURE LAM WITH YEH ISOLATED FORM
      #xFC45	;ARABIC LIGATURE MEEM WITH JEEM ISOLATED FORM
      #xFC46	;ARABIC LIGATURE MEEM WITH HAH ISOLATED FORM
      #xFC47	;ARABIC LIGATURE MEEM WITH KHAH ISOLATED FORM
      #xFC48	;ARABIC LIGATURE MEEM WITH MEEM ISOLATED FORM
      #xFC49	;ARABIC LIGATURE MEEM WITH ALEF MAKSURA ISOLATED FORM
      #xFC4A	;ARABIC LIGATURE MEEM WITH YEH ISOLATED FORM
      #xFC4B	;ARABIC LIGATURE NOON WITH JEEM ISOLATED FORM
      #xFC4C	;ARABIC LIGATURE NOON WITH HAH ISOLATED FORM
      #xFC4D	;ARABIC LIGATURE NOON WITH KHAH ISOLATED FORM
      #xFC4E	;ARABIC LIGATURE NOON WITH MEEM ISOLATED FORM
      #xFC4F	;ARABIC LIGATURE NOON WITH ALEF MAKSURA ISOLATED FORM
      #xFC50	;ARABIC LIGATURE NOON WITH YEH ISOLATED FORM
      #xFC51	;ARABIC LIGATURE HEH WITH JEEM ISOLATED FORM
      #xFC52	;ARABIC LIGATURE HEH WITH MEEM ISOLATED FORM
      #xFC53	;ARABIC LIGATURE HEH WITH ALEF MAKSURA ISOLATED FORM
      #xFC54	;ARABIC LIGATURE HEH WITH YEH ISOLATED FORM
      #xFC55	;ARABIC LIGATURE YEH WITH JEEM ISOLATED FORM
      #xFC56	;ARABIC LIGATURE YEH WITH HAH ISOLATED FORM
      #xFC57	;ARABIC LIGATURE YEH WITH KHAH ISOLATED FORM
      #xFC58	;ARABIC LIGATURE YEH WITH MEEM ISOLATED FORM
      #xFC59	;ARABIC LIGATURE YEH WITH ALEF MAKSURA ISOLATED FORM
      #xFC5A	;ARABIC LIGATURE YEH WITH YEH ISOLATED FORM
      #xFC5B	;ARABIC LIGATURE THAL WITH SUPERSCRIPT ALEF ISOLATED FORM
      #xFC5C	;ARABIC LIGATURE REH WITH SUPERSCRIPT ALEF ISOLATED FORM
      #xFC5D	;ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF ISOLATED FORM
      #xFC5E	;ARABIC LIGATURE SHADDA WITH DAMMATAN ISOLATED FORM
      #xFC5F	;ARABIC LIGATURE SHADDA WITH KASRATAN ISOLATED FORM
      #xFC60	;ARABIC LIGATURE SHADDA WITH FATHA ISOLATED FORM
      #xFC61	;ARABIC LIGATURE SHADDA WITH DAMMA ISOLATED FORM
      #xFC62	;ARABIC LIGATURE SHADDA WITH KASRA ISOLATED FORM
      #xFC63	;ARABIC LIGATURE SHADDA WITH SUPERSCRIPT ALEF ISOLATED FORM
      #xFC64	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH REH FINAL FORM
      #xFC65	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ZAIN FINAL FORM
      #xFC66	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM FINAL FORM
      #xFC67	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH NOON FINAL FORM
      #xFC68	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH ALEF MAKSURA FINAL FORM
      #xFC69	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH YEH FINAL FORM
      #xFC6A	;ARABIC LIGATURE BEH WITH REH FINAL FORM
      #xFC6B	;ARABIC LIGATURE BEH WITH ZAIN FINAL FORM
      #xFC6C	;ARABIC LIGATURE BEH WITH MEEM FINAL FORM
      #xFC6D	;ARABIC LIGATURE BEH WITH NOON FINAL FORM
      #xFC6E	;ARABIC LIGATURE BEH WITH ALEF MAKSURA FINAL FORM
      #xFC6F	;ARABIC LIGATURE BEH WITH YEH FINAL FORM
      #xFC70	;ARABIC LIGATURE TEH WITH REH FINAL FORM
      #xFC71	;ARABIC LIGATURE TEH WITH ZAIN FINAL FORM
      #xFC72	;ARABIC LIGATURE TEH WITH MEEM FINAL FORM
      #xFC73	;ARABIC LIGATURE TEH WITH NOON FINAL FORM
      #xFC74	;ARABIC LIGATURE TEH WITH ALEF MAKSURA FINAL FORM
      #xFC75	;ARABIC LIGATURE TEH WITH YEH FINAL FORM
      #xFC76	;ARABIC LIGATURE THEH WITH REH FINAL FORM
      #xFC77	;ARABIC LIGATURE THEH WITH ZAIN FINAL FORM
      #xFC78	;ARABIC LIGATURE THEH WITH MEEM FINAL FORM
      #xFC79	;ARABIC LIGATURE THEH WITH NOON FINAL FORM
      #xFC7A	;ARABIC LIGATURE THEH WITH ALEF MAKSURA FINAL FORM
      #xFC7B	;ARABIC LIGATURE THEH WITH YEH FINAL FORM
      #xFC7C	;ARABIC LIGATURE FEH WITH ALEF MAKSURA FINAL FORM
      #xFC7D	;ARABIC LIGATURE FEH WITH YEH FINAL FORM
      #xFC7E	;ARABIC LIGATURE QAF WITH ALEF MAKSURA FINAL FORM
      #xFC7F	;ARABIC LIGATURE QAF WITH YEH FINAL FORM
      #xFC80	;ARABIC LIGATURE KAF WITH ALEF FINAL FORM
      #xFC81	;ARABIC LIGATURE KAF WITH LAM FINAL FORM
      #xFC82	;ARABIC LIGATURE KAF WITH MEEM FINAL FORM
      #xFC83	;ARABIC LIGATURE KAF WITH ALEF MAKSURA FINAL FORM
      #xFC84	;ARABIC LIGATURE KAF WITH YEH FINAL FORM
      #xFC85	;ARABIC LIGATURE LAM WITH MEEM FINAL FORM
      #xFC86	;ARABIC LIGATURE LAM WITH ALEF MAKSURA FINAL FORM
      #xFC87	;ARABIC LIGATURE LAM WITH YEH FINAL FORM
      #xFC88	;ARABIC LIGATURE MEEM WITH ALEF FINAL FORM
      #xFC89	;ARABIC LIGATURE MEEM WITH MEEM FINAL FORM
      #xFC8A	;ARABIC LIGATURE NOON WITH REH FINAL FORM
      #xFC8B	;ARABIC LIGATURE NOON WITH ZAIN FINAL FORM
      #xFC8C	;ARABIC LIGATURE NOON WITH MEEM FINAL FORM
      #xFC8D	;ARABIC LIGATURE NOON WITH NOON FINAL FORM
      #xFC8E	;ARABIC LIGATURE NOON WITH ALEF MAKSURA FINAL FORM
      #xFC8F	;ARABIC LIGATURE NOON WITH YEH FINAL FORM
      #xFC90	;ARABIC LIGATURE ALEF MAKSURA WITH SUPERSCRIPT ALEF FINAL FORM
      #xFC91	;ARABIC LIGATURE YEH WITH REH FINAL FORM
      #xFC92	;ARABIC LIGATURE YEH WITH ZAIN FINAL FORM
      #xFC93	;ARABIC LIGATURE YEH WITH MEEM FINAL FORM
      #xFC94	;ARABIC LIGATURE YEH WITH NOON FINAL FORM
      #xFC95	;ARABIC LIGATURE YEH WITH ALEF MAKSURA FINAL FORM
      #xFC96	;ARABIC LIGATURE YEH WITH YEH FINAL FORM
      #xFC97	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH JEEM INITIAL FORM
      #xFC98	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HAH INITIAL FORM
      #xFC99	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH KHAH INITIAL FORM
      #xFC9A	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM INITIAL FORM
      #xFC9B	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH INITIAL FORM
      #xFC9C	;ARABIC LIGATURE BEH WITH JEEM INITIAL FORM
      #xFC9D	;ARABIC LIGATURE BEH WITH HAH INITIAL FORM
      #xFC9E	;ARABIC LIGATURE BEH WITH KHAH INITIAL FORM
      #xFC9F	;ARABIC LIGATURE BEH WITH MEEM INITIAL FORM
      #xFCA0	;ARABIC LIGATURE BEH WITH HEH INITIAL FORM
      #xFCA1	;ARABIC LIGATURE TEH WITH JEEM INITIAL FORM
      #xFCA2	;ARABIC LIGATURE TEH WITH HAH INITIAL FORM
      #xFCA3	;ARABIC LIGATURE TEH WITH KHAH INITIAL FORM
      #xFCA4	;ARABIC LIGATURE TEH WITH MEEM INITIAL FORM
      #xFCA5	;ARABIC LIGATURE TEH WITH HEH INITIAL FORM
      #xFCA6	;ARABIC LIGATURE THEH WITH MEEM INITIAL FORM
      #xFCA7	;ARABIC LIGATURE JEEM WITH HAH INITIAL FORM
      #xFCA8	;ARABIC LIGATURE JEEM WITH MEEM INITIAL FORM
      #xFCA9	;ARABIC LIGATURE HAH WITH JEEM INITIAL FORM
      #xFCAA	;ARABIC LIGATURE HAH WITH MEEM INITIAL FORM
      #xFCAB	;ARABIC LIGATURE KHAH WITH JEEM INITIAL FORM
      #xFCAC	;ARABIC LIGATURE KHAH WITH MEEM INITIAL FORM
      #xFCAD	;ARABIC LIGATURE SEEN WITH JEEM INITIAL FORM
      #xFCAE	;ARABIC LIGATURE SEEN WITH HAH INITIAL FORM
      #xFCAF	;ARABIC LIGATURE SEEN WITH KHAH INITIAL FORM
      #xFCB0	;ARABIC LIGATURE SEEN WITH MEEM INITIAL FORM
      #xFCB1	;ARABIC LIGATURE SAD WITH HAH INITIAL FORM
      #xFCB2	;ARABIC LIGATURE SAD WITH KHAH INITIAL FORM
      #xFCB3	;ARABIC LIGATURE SAD WITH MEEM INITIAL FORM
      #xFCB4	;ARABIC LIGATURE DAD WITH JEEM INITIAL FORM
      #xFCB5	;ARABIC LIGATURE DAD WITH HAH INITIAL FORM
      #xFCB6	;ARABIC LIGATURE DAD WITH KHAH INITIAL FORM
      #xFCB7	;ARABIC LIGATURE DAD WITH MEEM INITIAL FORM
      #xFCB8	;ARABIC LIGATURE TAH WITH HAH INITIAL FORM
      #xFCB9	;ARABIC LIGATURE ZAH WITH MEEM INITIAL FORM
      #xFCBA	;ARABIC LIGATURE AIN WITH JEEM INITIAL FORM
      #xFCBB	;ARABIC LIGATURE AIN WITH MEEM INITIAL FORM
      #xFCBC	;ARABIC LIGATURE GHAIN WITH JEEM INITIAL FORM
      #xFCBD	;ARABIC LIGATURE GHAIN WITH MEEM INITIAL FORM
      #xFCBE	;ARABIC LIGATURE FEH WITH JEEM INITIAL FORM
      #xFCBF	;ARABIC LIGATURE FEH WITH HAH INITIAL FORM
      #xFCC0	;ARABIC LIGATURE FEH WITH KHAH INITIAL FORM
      #xFCC1	;ARABIC LIGATURE FEH WITH MEEM INITIAL FORM
      #xFCC2	;ARABIC LIGATURE QAF WITH HAH INITIAL FORM
      #xFCC3	;ARABIC LIGATURE QAF WITH MEEM INITIAL FORM
      #xFCC4	;ARABIC LIGATURE KAF WITH JEEM INITIAL FORM
      #xFCC5	;ARABIC LIGATURE KAF WITH HAH INITIAL FORM
      #xFCC6	;ARABIC LIGATURE KAF WITH KHAH INITIAL FORM
      #xFCC7	;ARABIC LIGATURE KAF WITH LAM INITIAL FORM
      #xFCC8	;ARABIC LIGATURE KAF WITH MEEM INITIAL FORM
      #xFCC9	;ARABIC LIGATURE LAM WITH JEEM INITIAL FORM
      #xFCCA	;ARABIC LIGATURE LAM WITH HAH INITIAL FORM
      #xFCCB	;ARABIC LIGATURE LAM WITH KHAH INITIAL FORM
      #xFCCC	;ARABIC LIGATURE LAM WITH MEEM INITIAL FORM
      #xFCCD	;ARABIC LIGATURE LAM WITH HEH INITIAL FORM
      #xFCCE	;ARABIC LIGATURE MEEM WITH JEEM INITIAL FORM
      #xFCCF	;ARABIC LIGATURE MEEM WITH HAH INITIAL FORM
      #xFCD0	;ARABIC LIGATURE MEEM WITH KHAH INITIAL FORM
      #xFCD1	;ARABIC LIGATURE MEEM WITH MEEM INITIAL FORM
      #xFCD2	;ARABIC LIGATURE NOON WITH JEEM INITIAL FORM
      #xFCD3	;ARABIC LIGATURE NOON WITH HAH INITIAL FORM
      #xFCD4	;ARABIC LIGATURE NOON WITH KHAH INITIAL FORM
      #xFCD5	;ARABIC LIGATURE NOON WITH MEEM INITIAL FORM
      #xFCD6	;ARABIC LIGATURE NOON WITH HEH INITIAL FORM
      #xFCD7	;ARABIC LIGATURE HEH WITH JEEM INITIAL FORM
      #xFCD8	;ARABIC LIGATURE HEH WITH MEEM INITIAL FORM
      #xFCD9	;ARABIC LIGATURE HEH WITH SUPERSCRIPT ALEF INITIAL FORM
      #xFCDA	;ARABIC LIGATURE YEH WITH JEEM INITIAL FORM
      #xFCDB	;ARABIC LIGATURE YEH WITH HAH INITIAL FORM
      #xFCDC	;ARABIC LIGATURE YEH WITH KHAH INITIAL FORM
      #xFCDD	;ARABIC LIGATURE YEH WITH MEEM INITIAL FORM
      #xFCDE	;ARABIC LIGATURE YEH WITH HEH INITIAL FORM
      #xFCDF	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH MEEM MEDIAL FORM
      #xFCE0	;ARABIC LIGATURE YEH WITH HAMZA ABOVE WITH HEH MEDIAL FORM
      #xFCE1	;ARABIC LIGATURE BEH WITH MEEM MEDIAL FORM
      #xFCE2	;ARABIC LIGATURE BEH WITH HEH MEDIAL FORM
      #xFCE3	;ARABIC LIGATURE TEH WITH MEEM MEDIAL FORM
      #xFCE4	;ARABIC LIGATURE TEH WITH HEH MEDIAL FORM
      #xFCE5	;ARABIC LIGATURE THEH WITH MEEM MEDIAL FORM
      #xFCE6	;ARABIC LIGATURE THEH WITH HEH MEDIAL FORM
      #xFCE7	;ARABIC LIGATURE SEEN WITH MEEM MEDIAL FORM
      #xFCE8	;ARABIC LIGATURE SEEN WITH HEH MEDIAL FORM
      #xFCE9	;ARABIC LIGATURE SHEEN WITH MEEM MEDIAL FORM
      #xFCEA	;ARABIC LIGATURE SHEEN WITH HEH MEDIAL FORM
      #xFCEB	;ARABIC LIGATURE KAF WITH LAM MEDIAL FORM
      #xFCEC	;ARABIC LIGATURE KAF WITH MEEM MEDIAL FORM
      #xFCED	;ARABIC LIGATURE LAM WITH MEEM MEDIAL FORM
      #xFCEE	;ARABIC LIGATURE NOON WITH MEEM MEDIAL FORM
      #xFCEF	;ARABIC LIGATURE NOON WITH HEH MEDIAL FORM
      #xFCF0	;ARABIC LIGATURE YEH WITH MEEM MEDIAL FORM
      #xFCF1	;ARABIC LIGATURE YEH WITH HEH MEDIAL FORM
      #xFCF2	;ARABIC LIGATURE SHADDA WITH FATHA MEDIAL FORM
      #xFCF3	;ARABIC LIGATURE SHADDA WITH DAMMA MEDIAL FORM
      #xFCF4	;ARABIC LIGATURE SHADDA WITH KASRA MEDIAL FORM
      #xFCF5	;ARABIC LIGATURE TAH WITH ALEF MAKSURA ISOLATED FORM
      #xFCF6	;ARABIC LIGATURE TAH WITH YEH ISOLATED FORM
      #xFCF7	;ARABIC LIGATURE AIN WITH ALEF MAKSURA ISOLATED FORM
      #xFCF8	;ARABIC LIGATURE AIN WITH YEH ISOLATED FORM
      #xFCF9	;ARABIC LIGATURE GHAIN WITH ALEF MAKSURA ISOLATED FORM
      #xFCFA	;ARABIC LIGATURE GHAIN WITH YEH ISOLATED FORM
      #xFCFB	;ARABIC LIGATURE SEEN WITH ALEF MAKSURA ISOLATED FORM
      #xFCFC	;ARABIC LIGATURE SEEN WITH YEH ISOLATED FORM
      #xFCFD	;ARABIC LIGATURE SHEEN WITH ALEF MAKSURA ISOLATED FORM
      #xFCFE	;ARABIC LIGATURE SHEEN WITH YEH ISOLATED FORM
      #xFCFF	;ARABIC LIGATURE HAH WITH ALEF MAKSURA ISOLATED FORM
      #xFD00	;ARABIC LIGATURE HAH WITH YEH ISOLATED FORM
      #xFD01	;ARABIC LIGATURE JEEM WITH ALEF MAKSURA ISOLATED FORM
      #xFD02	;ARABIC LIGATURE JEEM WITH YEH ISOLATED FORM
      #xFD03	;ARABIC LIGATURE KHAH WITH ALEF MAKSURA ISOLATED FORM
      #xFD04	;ARABIC LIGATURE KHAH WITH YEH ISOLATED FORM
      #xFD05	;ARABIC LIGATURE SAD WITH ALEF MAKSURA ISOLATED FORM
      #xFD06	;ARABIC LIGATURE SAD WITH YEH ISOLATED FORM
      #xFD07	;ARABIC LIGATURE DAD WITH ALEF MAKSURA ISOLATED FORM
      #xFD08	;ARABIC LIGATURE DAD WITH YEH ISOLATED FORM
      #xFD09	;ARABIC LIGATURE SHEEN WITH JEEM ISOLATED FORM
      #xFD0A	;ARABIC LIGATURE SHEEN WITH HAH ISOLATED FORM
      #xFD0B	;ARABIC LIGATURE SHEEN WITH KHAH ISOLATED FORM
      #xFD0C	;ARABIC LIGATURE SHEEN WITH MEEM ISOLATED FORM
      #xFD0D	;ARABIC LIGATURE SHEEN WITH REH ISOLATED FORM
      #xFD0E	;ARABIC LIGATURE SEEN WITH REH ISOLATED FORM
      #xFD0F	;ARABIC LIGATURE SAD WITH REH ISOLATED FORM
      #xFD10	;ARABIC LIGATURE DAD WITH REH ISOLATED FORM
      #xFD11	;ARABIC LIGATURE TAH WITH ALEF MAKSURA FINAL FORM
      #xFD12	;ARABIC LIGATURE TAH WITH YEH FINAL FORM
      #xFD13	;ARABIC LIGATURE AIN WITH ALEF MAKSURA FINAL FORM
      #xFD14	;ARABIC LIGATURE AIN WITH YEH FINAL FORM
      #xFD15	;ARABIC LIGATURE GHAIN WITH ALEF MAKSURA FINAL FORM
      #xFD16	;ARABIC LIGATURE GHAIN WITH YEH FINAL FORM
      #xFD17	;ARABIC LIGATURE SEEN WITH ALEF MAKSURA FINAL FORM
      #xFD18	;ARABIC LIGATURE SEEN WITH YEH FINAL FORM
      #xFD19	;ARABIC LIGATURE SHEEN WITH ALEF MAKSURA FINAL FORM
      #xFD1A	;ARABIC LIGATURE SHEEN WITH YEH FINAL FORM
      #xFD1B	;ARABIC LIGATURE HAH WITH ALEF MAKSURA FINAL FORM
      #xFD1C	;ARABIC LIGATURE HAH WITH YEH FINAL FORM
      #xFD1D	;ARABIC LIGATURE JEEM WITH ALEF MAKSURA FINAL FORM
      #xFD1E	;ARABIC LIGATURE JEEM WITH YEH FINAL FORM
      #xFD1F	;ARABIC LIGATURE KHAH WITH ALEF MAKSURA FINAL FORM
      #xFD20	;ARABIC LIGATURE KHAH WITH YEH FINAL FORM
      #xFD21	;ARABIC LIGATURE SAD WITH ALEF MAKSURA FINAL FORM
      #xFD22	;ARABIC LIGATURE SAD WITH YEH FINAL FORM
      #xFD23	;ARABIC LIGATURE DAD WITH ALEF MAKSURA FINAL FORM
      #xFD24	;ARABIC LIGATURE DAD WITH YEH FINAL FORM
      #xFD25	;ARABIC LIGATURE SHEEN WITH JEEM FINAL FORM
      #xFD26	;ARABIC LIGATURE SHEEN WITH HAH FINAL FORM
      #xFD27	;ARABIC LIGATURE SHEEN WITH KHAH FINAL FORM
      #xFD28	;ARABIC LIGATURE SHEEN WITH MEEM FINAL FORM
      #xFD29	;ARABIC LIGATURE SHEEN WITH REH FINAL FORM
      #xFD2A	;ARABIC LIGATURE SEEN WITH REH FINAL FORM
      #xFD2B	;ARABIC LIGATURE SAD WITH REH FINAL FORM
      #xFD2C	;ARABIC LIGATURE DAD WITH REH FINAL FORM
      #xFD2D	;ARABIC LIGATURE SHEEN WITH JEEM INITIAL FORM
      #xFD2E	;ARABIC LIGATURE SHEEN WITH HAH INITIAL FORM
      #xFD2F	;ARABIC LIGATURE SHEEN WITH KHAH INITIAL FORM
      #xFD30	;ARABIC LIGATURE SHEEN WITH MEEM INITIAL FORM
      #xFD31	;ARABIC LIGATURE SEEN WITH HEH INITIAL FORM
      #xFD32	;ARABIC LIGATURE SHEEN WITH HEH INITIAL FORM
      #xFD33	;ARABIC LIGATURE TAH WITH MEEM INITIAL FORM
      #xFD34	;ARABIC LIGATURE SEEN WITH JEEM MEDIAL FORM
      #xFD35	;ARABIC LIGATURE SEEN WITH HAH MEDIAL FORM
      #xFD36	;ARABIC LIGATURE SEEN WITH KHAH MEDIAL FORM
      #xFD37	;ARABIC LIGATURE SHEEN WITH JEEM MEDIAL FORM
      #xFD38	;ARABIC LIGATURE SHEEN WITH HAH MEDIAL FORM
      #xFD39	;ARABIC LIGATURE SHEEN WITH KHAH MEDIAL FORM
      #xFD3A	;ARABIC LIGATURE TAH WITH MEEM MEDIAL FORM
      #xFD3B	;ARABIC LIGATURE ZAH WITH MEEM MEDIAL FORM
      #xFD3C	;ARABIC LIGATURE ALEF WITH FATHATAN FINAL FORM
      #xFD3D	;ARABIC LIGATURE ALEF WITH FATHATAN ISOLATED FORM
      #xFD50	;ARABIC LIGATURE TEH WITH JEEM WITH MEEM INITIAL FORM
      #xFD51	;ARABIC LIGATURE TEH WITH HAH WITH JEEM FINAL FORM
      #xFD52	;ARABIC LIGATURE TEH WITH HAH WITH JEEM INITIAL FORM
      #xFD53	;ARABIC LIGATURE TEH WITH HAH WITH MEEM INITIAL FORM
      #xFD54	;ARABIC LIGATURE TEH WITH KHAH WITH MEEM INITIAL FORM
      #xFD55	;ARABIC LIGATURE TEH WITH MEEM WITH JEEM INITIAL FORM
      #xFD56	;ARABIC LIGATURE TEH WITH MEEM WITH HAH INITIAL FORM
      #xFD57	;ARABIC LIGATURE TEH WITH MEEM WITH KHAH INITIAL FORM
      #xFD58	;ARABIC LIGATURE JEEM WITH MEEM WITH HAH FINAL FORM
      #xFD59	;ARABIC LIGATURE JEEM WITH MEEM WITH HAH INITIAL FORM
      #xFD5A	;ARABIC LIGATURE HAH WITH MEEM WITH YEH FINAL FORM
      #xFD5B	;ARABIC LIGATURE HAH WITH MEEM WITH ALEF MAKSURA FINAL FORM
      #xFD5C	;ARABIC LIGATURE SEEN WITH HAH WITH JEEM INITIAL FORM
      #xFD5D	;ARABIC LIGATURE SEEN WITH JEEM WITH HAH INITIAL FORM
      #xFD5E	;ARABIC LIGATURE SEEN WITH JEEM WITH ALEF MAKSURA FINAL FORM
      #xFD5F	;ARABIC LIGATURE SEEN WITH MEEM WITH HAH FINAL FORM
      #xFD60	;ARABIC LIGATURE SEEN WITH MEEM WITH HAH INITIAL FORM
      #xFD61	;ARABIC LIGATURE SEEN WITH MEEM WITH JEEM INITIAL FORM
      #xFD62	;ARABIC LIGATURE SEEN WITH MEEM WITH MEEM FINAL FORM
      #xFD63	;ARABIC LIGATURE SEEN WITH MEEM WITH MEEM INITIAL FORM
      #xFD64	;ARABIC LIGATURE SAD WITH HAH WITH HAH FINAL FORM
      #xFD65	;ARABIC LIGATURE SAD WITH HAH WITH HAH INITIAL FORM
      #xFD66	;ARABIC LIGATURE SAD WITH MEEM WITH MEEM FINAL FORM
      #xFD67	;ARABIC LIGATURE SHEEN WITH HAH WITH MEEM FINAL FORM
      #xFD68	;ARABIC LIGATURE SHEEN WITH HAH WITH MEEM INITIAL FORM
      #xFD69	;ARABIC LIGATURE SHEEN WITH JEEM WITH YEH FINAL FORM
      #xFD6A	;ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH FINAL FORM
      #xFD6B	;ARABIC LIGATURE SHEEN WITH MEEM WITH KHAH INITIAL FORM
      #xFD6C	;ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM FINAL FORM
      #xFD6D	;ARABIC LIGATURE SHEEN WITH MEEM WITH MEEM INITIAL FORM
      #xFD6E	;ARABIC LIGATURE DAD WITH HAH WITH ALEF MAKSURA FINAL FORM
      #xFD6F	;ARABIC LIGATURE DAD WITH KHAH WITH MEEM FINAL FORM
      #xFD70	;ARABIC LIGATURE DAD WITH KHAH WITH MEEM INITIAL FORM
      #xFD71	;ARABIC LIGATURE TAH WITH MEEM WITH HAH FINAL FORM
      #xFD72	;ARABIC LIGATURE TAH WITH MEEM WITH HAH INITIAL FORM
      #xFD73	;ARABIC LIGATURE TAH WITH MEEM WITH MEEM INITIAL FORM
      #xFD74	;ARABIC LIGATURE TAH WITH MEEM WITH YEH FINAL FORM
      #xFD75	;ARABIC LIGATURE AIN WITH JEEM WITH MEEM FINAL FORM
      #xFD76	;ARABIC LIGATURE AIN WITH MEEM WITH MEEM FINAL FORM
      #xFD77	;ARABIC LIGATURE AIN WITH MEEM WITH MEEM INITIAL FORM
      #xFD78	;ARABIC LIGATURE AIN WITH MEEM WITH ALEF MAKSURA FINAL FORM
      #xFD79	;ARABIC LIGATURE GHAIN WITH MEEM WITH MEEM FINAL FORM
      #xFD7A	;ARABIC LIGATURE GHAIN WITH MEEM WITH YEH FINAL FORM
      #xFD7B	;ARABIC LIGATURE GHAIN WITH MEEM WITH ALEF MAKSURA FINAL FORM
      #xFD7C	;ARABIC LIGATURE FEH WITH KHAH WITH MEEM FINAL FORM
      #xFD7D	;ARABIC LIGATURE FEH WITH KHAH WITH MEEM INITIAL FORM
      #xFD7E	;ARABIC LIGATURE QAF WITH MEEM WITH HAH FINAL FORM
      #xFD7F	;ARABIC LIGATURE QAF WITH MEEM WITH MEEM FINAL FORM
      #xFD80	;ARABIC LIGATURE LAM WITH HAH WITH MEEM FINAL FORM
      #xFD81	;ARABIC LIGATURE LAM WITH HAH WITH YEH FINAL FORM
      #xFD82	;ARABIC LIGATURE LAM WITH HAH WITH ALEF MAKSURA FINAL FORM
      #xFD83	;ARABIC LIGATURE LAM WITH JEEM WITH JEEM INITIAL FORM
      #xFD84	;ARABIC LIGATURE LAM WITH JEEM WITH JEEM FINAL FORM
      #xFD85	;ARABIC LIGATURE LAM WITH KHAH WITH MEEM FINAL FORM
      #xFD86	;ARABIC LIGATURE LAM WITH KHAH WITH MEEM INITIAL FORM
      #xFD87	;ARABIC LIGATURE LAM WITH MEEM WITH HAH FINAL FORM
      #xFD88	;ARABIC LIGATURE LAM WITH MEEM WITH HAH INITIAL FORM
      #xFD89	;ARABIC LIGATURE MEEM WITH HAH WITH JEEM INITIAL FORM
      #xFD8A	;ARABIC LIGATURE MEEM WITH HAH WITH MEEM INITIAL FORM
      #xFD8B	;ARABIC LIGATURE MEEM WITH HAH WITH YEH FINAL FORM
      #xFD8C	;ARABIC LIGATURE MEEM WITH JEEM WITH HAH INITIAL FORM
      #xFD8D	;ARABIC LIGATURE MEEM WITH JEEM WITH MEEM INITIAL FORM
      #xFD8E	;ARABIC LIGATURE MEEM WITH KHAH WITH JEEM INITIAL FORM
      #xFD8F	;ARABIC LIGATURE MEEM WITH KHAH WITH MEEM INITIAL FORM
      #xFD92	;ARABIC LIGATURE MEEM WITH JEEM WITH KHAH INITIAL FORM
      #xFD93	;ARABIC LIGATURE HEH WITH MEEM WITH JEEM INITIAL FORM
      #xFD94	;ARABIC LIGATURE HEH WITH MEEM WITH MEEM INITIAL FORM
      #xFD95	;ARABIC LIGATURE NOON WITH HAH WITH MEEM INITIAL FORM
      #xFD96	;ARABIC LIGATURE NOON WITH HAH WITH ALEF MAKSURA FINAL FORM
      #xFD97	;ARABIC LIGATURE NOON WITH JEEM WITH MEEM FINAL FORM
      #xFD98	;ARABIC LIGATURE NOON WITH JEEM WITH MEEM INITIAL FORM
      #xFD99	;ARABIC LIGATURE NOON WITH JEEM WITH ALEF MAKSURA FINAL FORM
      #xFD9A	;ARABIC LIGATURE NOON WITH MEEM WITH YEH FINAL FORM
      #xFD9B	;ARABIC LIGATURE NOON WITH MEEM WITH ALEF MAKSURA FINAL FORM
      #xFD9C	;ARABIC LIGATURE YEH WITH MEEM WITH MEEM FINAL FORM
      #xFD9D	;ARABIC LIGATURE YEH WITH MEEM WITH MEEM INITIAL FORM
      #xFD9E	;ARABIC LIGATURE BEH WITH KHAH WITH YEH FINAL FORM
      #xFD9F	;ARABIC LIGATURE TEH WITH JEEM WITH YEH FINAL FORM
      #xFDA0	;ARABIC LIGATURE TEH WITH JEEM WITH ALEF MAKSURA FINAL FORM
      #xFDA1	;ARABIC LIGATURE TEH WITH KHAH WITH YEH FINAL FORM
      #xFDA2	;ARABIC LIGATURE TEH WITH KHAH WITH ALEF MAKSURA FINAL FORM
      #xFDA3	;ARABIC LIGATURE TEH WITH MEEM WITH YEH FINAL FORM
      #xFDA4	;ARABIC LIGATURE TEH WITH MEEM WITH ALEF MAKSURA FINAL FORM
      #xFDA5	;ARABIC LIGATURE JEEM WITH MEEM WITH YEH FINAL FORM
      #xFDA6	;ARABIC LIGATURE JEEM WITH HAH WITH ALEF MAKSURA FINAL FORM
      #xFDA7	;ARABIC LIGATURE JEEM WITH MEEM WITH ALEF MAKSURA FINAL FORM
      #xFDA8	;ARABIC LIGATURE SEEN WITH KHAH WITH ALEF MAKSURA FINAL FORM
      #xFDA9	;ARABIC LIGATURE SAD WITH HAH WITH YEH FINAL FORM
      #xFDAA	;ARABIC LIGATURE SHEEN WITH HAH WITH YEH FINAL FORM
      #xFDAB	;ARABIC LIGATURE DAD WITH HAH WITH YEH FINAL FORM
      #xFDAC	;ARABIC LIGATURE LAM WITH JEEM WITH YEH FINAL FORM
      #xFDAD	;ARABIC LIGATURE LAM WITH MEEM WITH YEH FINAL FORM
      #xFDAE	;ARABIC LIGATURE YEH WITH HAH WITH YEH FINAL FORM
      #xFDAF	;ARABIC LIGATURE YEH WITH JEEM WITH YEH FINAL FORM
      #xFDB0	;ARABIC LIGATURE YEH WITH MEEM WITH YEH FINAL FORM
      #xFDB1	;ARABIC LIGATURE MEEM WITH MEEM WITH YEH FINAL FORM
      #xFDB2	;ARABIC LIGATURE QAF WITH MEEM WITH YEH FINAL FORM
      #xFDB3	;ARABIC LIGATURE NOON WITH HAH WITH YEH FINAL FORM
      #xFDB4	;ARABIC LIGATURE QAF WITH MEEM WITH HAH INITIAL FORM
      #xFDB5	;ARABIC LIGATURE LAM WITH HAH WITH MEEM INITIAL FORM
      #xFDB6	;ARABIC LIGATURE AIN WITH MEEM WITH YEH FINAL FORM
      #xFDB7	;ARABIC LIGATURE KAF WITH MEEM WITH YEH FINAL FORM
      #xFDB8	;ARABIC LIGATURE NOON WITH JEEM WITH HAH INITIAL FORM
      #xFDB9	;ARABIC LIGATURE MEEM WITH KHAH WITH YEH FINAL FORM
      #xFDBA	;ARABIC LIGATURE LAM WITH JEEM WITH MEEM INITIAL FORM
      #xFDBB	;ARABIC LIGATURE KAF WITH MEEM WITH MEEM FINAL FORM
      #xFDBC	;ARABIC LIGATURE LAM WITH JEEM WITH MEEM FINAL FORM
      #xFDBD	;ARABIC LIGATURE NOON WITH JEEM WITH HAH FINAL FORM
      #xFDBE	;ARABIC LIGATURE JEEM WITH HAH WITH YEH FINAL FORM
      #xFDBF	;ARABIC LIGATURE HAH WITH JEEM WITH YEH FINAL FORM
      #xFDC0	;ARABIC LIGATURE MEEM WITH JEEM WITH YEH FINAL FORM
      #xFDC1	;ARABIC LIGATURE FEH WITH MEEM WITH YEH FINAL FORM
      #xFDC2	;ARABIC LIGATURE BEH WITH HAH WITH YEH FINAL FORM
      #xFDC3	;ARABIC LIGATURE KAF WITH MEEM WITH MEEM INITIAL FORM
      #xFDC4	;ARABIC LIGATURE AIN WITH JEEM WITH MEEM INITIAL FORM
      #xFDC5	;ARABIC LIGATURE SAD WITH MEEM WITH MEEM INITIAL FORM
      #xFDC6	;ARABIC LIGATURE SEEN WITH KHAH WITH YEH FINAL FORM
      #xFDC7	;ARABIC LIGATURE NOON WITH JEEM WITH YEH FINAL FORM
      #xFDF0	;ARABIC LIGATURE SALLA USED AS KORANIC STOP SIGN ISOLATED FORM
      #xFDF1	;ARABIC LIGATURE QALA USED AS KORANIC STOP SIGN ISOLATED FORM
      #xFDF2	;ARABIC LIGATURE ALLAH ISOLATED FORM
      #xFDF3	;ARABIC LIGATURE AKBAR ISOLATED FORM
      #xFDF4	;ARABIC LIGATURE MOHAMMAD ISOLATED FORM
      #xFDF5	;ARABIC LIGATURE SALAM ISOLATED FORM
      #xFDF6	;ARABIC LIGATURE RASOUL ISOLATED FORM
      #xFDF7	;ARABIC LIGATURE ALAYHE ISOLATED FORM
      #xFDF8	;ARABIC LIGATURE WASALLAM ISOLATED FORM
      #xFDF9	;ARABIC LIGATURE SALLA ISOLATED FORM
      #xFDFA	;ARABIC LIGATURE SALLALLAHOU ALAYHE WASALLAM
      #xFDFB	;ARABIC LIGATURE JALLAJALALOUHOU
      #xFE70	;ARABIC FATHATAN ISOLATED FORM
      #xFE71	;ARABIC TATWEEL WITH FATHATAN ABOVE
      #xFE72	;ARABIC DAMMATAN ISOLATED FORM
      #xFE73	;ARABIC TAIL FRAGMENT
      #xFE74	;ARABIC KASRATAN ISOLATED FORM
      #xFE76	;ARABIC FATHA ISOLATED FORM
      #xFE77	;ARABIC FATHA MEDIAL FORM
      #xFE78	;ARABIC DAMMA ISOLATED FORM
      #xFE79	;ARABIC DAMMA MEDIAL FORM
      #xFE7A	;ARABIC KASRA ISOLATED FORM
      #xFE7B	;ARABIC KASRA MEDIAL FORM
      #xFE7C	;ARABIC SHADDA ISOLATED FORM
      #xFE7D	;ARABIC SHADDA MEDIAL FORM
      #xFE7E	;ARABIC SUKUN ISOLATED FORM
      #xFE7F	;ARABIC SUKUN MEDIAL FORM
      #xFE80	;ARABIC LETTER HAMZA ISOLATED FORM
      #xFE81	;ARABIC LETTER ALEF WITH MADDA ABOVE ISOLATED FORM
      #xFE82	;ARABIC LETTER ALEF WITH MADDA ABOVE FINAL FORM
      #xFE83	;ARABIC LETTER ALEF WITH HAMZA ABOVE ISOLATED FORM
      #xFE84	;ARABIC LETTER ALEF WITH HAMZA ABOVE FINAL FORM
      #xFE85	;ARABIC LETTER WAW WITH HAMZA ABOVE ISOLATED FORM
      #xFE86	;ARABIC LETTER WAW WITH HAMZA ABOVE FINAL FORM
      #xFE87	;ARABIC LETTER ALEF WITH HAMZA BELOW ISOLATED FORM
      #xFE88	;ARABIC LETTER ALEF WITH HAMZA BELOW FINAL FORM
      #xFE89	;ARABIC LETTER YEH WITH HAMZA ABOVE ISOLATED FORM
      #xFE8A	;ARABIC LETTER YEH WITH HAMZA ABOVE FINAL FORM
      #xFE8B	;ARABIC LETTER YEH WITH HAMZA ABOVE INITIAL FORM
      #xFE8C	;ARABIC LETTER YEH WITH HAMZA ABOVE MEDIAL FORM
      #xFE8D	;ARABIC LETTER ALEF ISOLATED FORM
      #xFE8E	;ARABIC LETTER ALEF FINAL FORM
      #xFE8F	;ARABIC LETTER BEH ISOLATED FORM
      #xFE90	;ARABIC LETTER BEH FINAL FORM
      #xFE91	;ARABIC LETTER BEH INITIAL FORM
      #xFE92	;ARABIC LETTER BEH MEDIAL FORM
      #xFE93	;ARABIC LETTER TEH MARBUTA ISOLATED FORM
      #xFE94	;ARABIC LETTER TEH MARBUTA FINAL FORM
      #xFE95	;ARABIC LETTER TEH ISOLATED FORM
      #xFE96	;ARABIC LETTER TEH FINAL FORM
      #xFE97	;ARABIC LETTER TEH INITIAL FORM
      #xFE98	;ARABIC LETTER TEH MEDIAL FORM
      #xFE99	;ARABIC LETTER THEH ISOLATED FORM
      #xFE9A	;ARABIC LETTER THEH FINAL FORM
      #xFE9B	;ARABIC LETTER THEH INITIAL FORM
      #xFE9C	;ARABIC LETTER THEH MEDIAL FORM
      #xFE9D	;ARABIC LETTER JEEM ISOLATED FORM
      #xFE9E	;ARABIC LETTER JEEM FINAL FORM
      #xFE9F	;ARABIC LETTER JEEM INITIAL FORM
      #xFEA0	;ARABIC LETTER JEEM MEDIAL FORM
      #xFEA1	;ARABIC LETTER HAH ISOLATED FORM
      #xFEA2	;ARABIC LETTER HAH FINAL FORM
      #xFEA3	;ARABIC LETTER HAH INITIAL FORM
      #xFEA4	;ARABIC LETTER HAH MEDIAL FORM
      #xFEA5	;ARABIC LETTER KHAH ISOLATED FORM
      #xFEA6	;ARABIC LETTER KHAH FINAL FORM
      #xFEA7	;ARABIC LETTER KHAH INITIAL FORM
      #xFEA8	;ARABIC LETTER KHAH MEDIAL FORM
      #xFEA9	;ARABIC LETTER DAL ISOLATED FORM
      #xFEAA	;ARABIC LETTER DAL FINAL FORM
      #xFEAB	;ARABIC LETTER THAL ISOLATED FORM
      #xFEAC	;ARABIC LETTER THAL FINAL FORM
      #xFEAD	;ARABIC LETTER REH ISOLATED FORM
      #xFEAE	;ARABIC LETTER REH FINAL FORM
      #xFEAF	;ARABIC LETTER ZAIN ISOLATED FORM
      #xFEB0	;ARABIC LETTER ZAIN FINAL FORM
      #xFEB1	;ARABIC LETTER SEEN ISOLATED FORM
      #xFEB2	;ARABIC LETTER SEEN FINAL FORM
      #xFEB3	;ARABIC LETTER SEEN INITIAL FORM
      #xFEB4	;ARABIC LETTER SEEN MEDIAL FORM
      #xFEB5	;ARABIC LETTER SHEEN ISOLATED FORM
      #xFEB6	;ARABIC LETTER SHEEN FINAL FORM
      #xFEB7	;ARABIC LETTER SHEEN INITIAL FORM
      #xFEB8	;ARABIC LETTER SHEEN MEDIAL FORM
      #xFEB9	;ARABIC LETTER SAD ISOLATED FORM
      #xFEBA	;ARABIC LETTER SAD FINAL FORM
      #xFEBB	;ARABIC LETTER SAD INITIAL FORM
      #xFEBC	;ARABIC LETTER SAD MEDIAL FORM
      #xFEBD	;ARABIC LETTER DAD ISOLATED FORM
      #xFEBE	;ARABIC LETTER DAD FINAL FORM
      #xFEBF	;ARABIC LETTER DAD INITIAL FORM
      #xFEC0	;ARABIC LETTER DAD MEDIAL FORM
      #xFEC1	;ARABIC LETTER TAH ISOLATED FORM
      #xFEC2	;ARABIC LETTER TAH FINAL FORM
      #xFEC3	;ARABIC LETTER TAH INITIAL FORM
      #xFEC4	;ARABIC LETTER TAH MEDIAL FORM
      #xFEC5	;ARABIC LETTER ZAH ISOLATED FORM
      #xFEC6	;ARABIC LETTER ZAH FINAL FORM
      #xFEC7	;ARABIC LETTER ZAH INITIAL FORM
      #xFEC8	;ARABIC LETTER ZAH MEDIAL FORM
      #xFEC9	;ARABIC LETTER AIN ISOLATED FORM
      #xFECA	;ARABIC LETTER AIN FINAL FORM
      #xFECB	;ARABIC LETTER AIN INITIAL FORM
      #xFECC	;ARABIC LETTER AIN MEDIAL FORM
      #xFECD	;ARABIC LETTER GHAIN ISOLATED FORM
      #xFECE	;ARABIC LETTER GHAIN FINAL FORM
      #xFECF	;ARABIC LETTER GHAIN INITIAL FORM
      #xFED0	;ARABIC LETTER GHAIN MEDIAL FORM
      #xFED1	;ARABIC LETTER FEH ISOLATED FORM
      #xFED2	;ARABIC LETTER FEH FINAL FORM
      #xFED3	;ARABIC LETTER FEH INITIAL FORM
      #xFED4	;ARABIC LETTER FEH MEDIAL FORM
      #xFED5	;ARABIC LETTER QAF ISOLATED FORM
      #xFED6	;ARABIC LETTER QAF FINAL FORM
      #xFED7	;ARABIC LETTER QAF INITIAL FORM
      #xFED8	;ARABIC LETTER QAF MEDIAL FORM
      #xFED9	;ARABIC LETTER KAF ISOLATED FORM
      #xFEDA	;ARABIC LETTER KAF FINAL FORM
      #xFEDB	;ARABIC LETTER KAF INITIAL FORM
      #xFEDC	;ARABIC LETTER KAF MEDIAL FORM
      #xFEDD	;ARABIC LETTER LAM ISOLATED FORM
      #xFEDE	;ARABIC LETTER LAM FINAL FORM
      #xFEDF	;ARABIC LETTER LAM INITIAL FORM
      #xFEE0	;ARABIC LETTER LAM MEDIAL FORM
      #xFEE1	;ARABIC LETTER MEEM ISOLATED FORM
      #xFEE2	;ARABIC LETTER MEEM FINAL FORM
      #xFEE3	;ARABIC LETTER MEEM INITIAL FORM
      #xFEE4	;ARABIC LETTER MEEM MEDIAL FORM
      #xFEE5	;ARABIC LETTER NOON ISOLATED FORM
      #xFEE6	;ARABIC LETTER NOON FINAL FORM
      #xFEE7	;ARABIC LETTER NOON INITIAL FORM
      #xFEE8	;ARABIC LETTER NOON MEDIAL FORM
      #xFEE9	;ARABIC LETTER HEH ISOLATED FORM
      #xFEEA	;ARABIC LETTER HEH FINAL FORM
      #xFEEB	;ARABIC LETTER HEH INITIAL FORM
      #xFEEC	;ARABIC LETTER HEH MEDIAL FORM
      #xFEED	;ARABIC LETTER WAW ISOLATED FORM
      #xFEEE	;ARABIC LETTER WAW FINAL FORM
      #xFEEF	;ARABIC LETTER ALEF MAKSURA ISOLATED FORM
      #xFEF0	;ARABIC LETTER ALEF MAKSURA FINAL FORM
      #xFEF1	;ARABIC LETTER YEH ISOLATED FORM
      #xFEF2	;ARABIC LETTER YEH FINAL FORM
      #xFEF3	;ARABIC LETTER YEH INITIAL FORM
      #xFEF4	;ARABIC LETTER YEH MEDIAL FORM
      #xFEF5	;ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE ISOLATED FORM
      #xFEF6	;ARABIC LIGATURE LAM WITH ALEF WITH MADDA ABOVE FINAL FORM
      #xFEF7	;ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE ISOLATED FORM
      #xFEF8	;ARABIC LIGATURE LAM WITH ALEF WITH HAMZA ABOVE FINAL FORM
      #xFEF9	;ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW ISOLATED FORM
      #xFEFA	;ARABIC LIGATURE LAM WITH ALEF WITH HAMZA BELOW FINAL FORM
      #xFEFB	;ARABIC LIGATURE LAM WITH ALEF ISOLATED FORM
      #xFEFC	;ARABIC LIGATURE LAM WITH ALEF FINAL FORM
      #xFF21	;FULLWIDTH LATIN CAPITAL LETTER A
      #xFF22	;FULLWIDTH LATIN CAPITAL LETTER B
      #xFF23	;FULLWIDTH LATIN CAPITAL LETTER C
      #xFF24	;FULLWIDTH LATIN CAPITAL LETTER D
      #xFF25	;FULLWIDTH LATIN CAPITAL LETTER E
      #xFF26	;FULLWIDTH LATIN CAPITAL LETTER F
      #xFF27	;FULLWIDTH LATIN CAPITAL LETTER G
      #xFF28	;FULLWIDTH LATIN CAPITAL LETTER H
      #xFF29	;FULLWIDTH LATIN CAPITAL LETTER I
      #xFF2A	;FULLWIDTH LATIN CAPITAL LETTER J
      #xFF2B	;FULLWIDTH LATIN CAPITAL LETTER K
      #xFF2C	;FULLWIDTH LATIN CAPITAL LETTER L
      #xFF2D	;FULLWIDTH LATIN CAPITAL LETTER M
      #xFF2E	;FULLWIDTH LATIN CAPITAL LETTER N
      #xFF2F	;FULLWIDTH LATIN CAPITAL LETTER O
      #xFF30	;FULLWIDTH LATIN CAPITAL LETTER P
      #xFF31	;FULLWIDTH LATIN CAPITAL LETTER Q
      #xFF32	;FULLWIDTH LATIN CAPITAL LETTER R
      #xFF33	;FULLWIDTH LATIN CAPITAL LETTER S
      #xFF34	;FULLWIDTH LATIN CAPITAL LETTER T
      #xFF35	;FULLWIDTH LATIN CAPITAL LETTER U
      #xFF36	;FULLWIDTH LATIN CAPITAL LETTER V
      #xFF37	;FULLWIDTH LATIN CAPITAL LETTER W
      #xFF38	;FULLWIDTH LATIN CAPITAL LETTER X
      #xFF39	;FULLWIDTH LATIN CAPITAL LETTER Y
      #xFF3A	;FULLWIDTH LATIN CAPITAL LETTER Z
      #xFF41	;FULLWIDTH LATIN SMALL LETTER A
      #xFF42	;FULLWIDTH LATIN SMALL LETTER B
      #xFF43	;FULLWIDTH LATIN SMALL LETTER C
      #xFF44	;FULLWIDTH LATIN SMALL LETTER D
      #xFF45	;FULLWIDTH LATIN SMALL LETTER E
      #xFF46	;FULLWIDTH LATIN SMALL LETTER F
      #xFF47	;FULLWIDTH LATIN SMALL LETTER G
      #xFF48	;FULLWIDTH LATIN SMALL LETTER H
      #xFF49	;FULLWIDTH LATIN SMALL LETTER I
      #xFF4A	;FULLWIDTH LATIN SMALL LETTER J
      #xFF4B	;FULLWIDTH LATIN SMALL LETTER K
      #xFF4C	;FULLWIDTH LATIN SMALL LETTER L
      #xFF4D	;FULLWIDTH LATIN SMALL LETTER M
      #xFF4E	;FULLWIDTH LATIN SMALL LETTER N
      #xFF4F	;FULLWIDTH LATIN SMALL LETTER O
      #xFF50	;FULLWIDTH LATIN SMALL LETTER P
      #xFF51	;FULLWIDTH LATIN SMALL LETTER Q
      #xFF52	;FULLWIDTH LATIN SMALL LETTER R
      #xFF53	;FULLWIDTH LATIN SMALL LETTER S
      #xFF54	;FULLWIDTH LATIN SMALL LETTER T
      #xFF55	;FULLWIDTH LATIN SMALL LETTER U
      #xFF56	;FULLWIDTH LATIN SMALL LETTER V
      #xFF57	;FULLWIDTH LATIN SMALL LETTER W
      #xFF58	;FULLWIDTH LATIN SMALL LETTER X
      #xFF59	;FULLWIDTH LATIN SMALL LETTER Y
      #xFF5A	;FULLWIDTH LATIN SMALL LETTER Z
      #xFF66	;HALFWIDTH KATAKANA LETTER WO
      #xFF67	;HALFWIDTH KATAKANA LETTER SMALL A
      #xFF68	;HALFWIDTH KATAKANA LETTER SMALL I
      #xFF69	;HALFWIDTH KATAKANA LETTER SMALL U
      #xFF6A	;HALFWIDTH KATAKANA LETTER SMALL E
      #xFF6B	;HALFWIDTH KATAKANA LETTER SMALL O
      #xFF6C	;HALFWIDTH KATAKANA LETTER SMALL YA
      #xFF6D	;HALFWIDTH KATAKANA LETTER SMALL YU
      #xFF6E	;HALFWIDTH KATAKANA LETTER SMALL YO
      #xFF6F	;HALFWIDTH KATAKANA LETTER SMALL TU
      #xFF70	;HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
      #xFF71	;HALFWIDTH KATAKANA LETTER A
      #xFF72	;HALFWIDTH KATAKANA LETTER I
      #xFF73	;HALFWIDTH KATAKANA LETTER U
      #xFF74	;HALFWIDTH KATAKANA LETTER E
      #xFF75	;HALFWIDTH KATAKANA LETTER O
      #xFF76	;HALFWIDTH KATAKANA LETTER KA
      #xFF77	;HALFWIDTH KATAKANA LETTER KI
      #xFF78	;HALFWIDTH KATAKANA LETTER KU
      #xFF79	;HALFWIDTH KATAKANA LETTER KE
      #xFF7A	;HALFWIDTH KATAKANA LETTER KO
      #xFF7B	;HALFWIDTH KATAKANA LETTER SA
      #xFF7C	;HALFWIDTH KATAKANA LETTER SI
      #xFF7D	;HALFWIDTH KATAKANA LETTER SU
      #xFF7E	;HALFWIDTH KATAKANA LETTER SE
      #xFF7F	;HALFWIDTH KATAKANA LETTER SO
      #xFF80	;HALFWIDTH KATAKANA LETTER TA
      #xFF81	;HALFWIDTH KATAKANA LETTER TI
      #xFF82	;HALFWIDTH KATAKANA LETTER TU
      #xFF83	;HALFWIDTH KATAKANA LETTER TE
      #xFF84	;HALFWIDTH KATAKANA LETTER TO
      #xFF85	;HALFWIDTH KATAKANA LETTER NA
      #xFF86	;HALFWIDTH KATAKANA LETTER NI
      #xFF87	;HALFWIDTH KATAKANA LETTER NU
      #xFF88	;HALFWIDTH KATAKANA LETTER NE
      #xFF89	;HALFWIDTH KATAKANA LETTER NO
      #xFF8A	;HALFWIDTH KATAKANA LETTER HA
      #xFF8B	;HALFWIDTH KATAKANA LETTER HI
      #xFF8C	;HALFWIDTH KATAKANA LETTER HU
      #xFF8D	;HALFWIDTH KATAKANA LETTER HE
      #xFF8E	;HALFWIDTH KATAKANA LETTER HO
      #xFF8F	;HALFWIDTH KATAKANA LETTER MA
      #xFF90	;HALFWIDTH KATAKANA LETTER MI
      #xFF91	;HALFWIDTH KATAKANA LETTER MU
      #xFF92	;HALFWIDTH KATAKANA LETTER ME
      #xFF93	;HALFWIDTH KATAKANA LETTER MO
      #xFF94	;HALFWIDTH KATAKANA LETTER YA
      #xFF95	;HALFWIDTH KATAKANA LETTER YU
      #xFF96	;HALFWIDTH KATAKANA LETTER YO
      #xFF97	;HALFWIDTH KATAKANA LETTER RA
      #xFF98	;HALFWIDTH KATAKANA LETTER RI
      #xFF99	;HALFWIDTH KATAKANA LETTER RU
      #xFF9A	;HALFWIDTH KATAKANA LETTER RE
      #xFF9B	;HALFWIDTH KATAKANA LETTER RO
      #xFF9C	;HALFWIDTH KATAKANA LETTER WA
      #xFF9D	;HALFWIDTH KATAKANA LETTER N
      #xFF9E	;HALFWIDTH KATAKANA VOICED SOUND MARK
      #xFF9F	;HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
      #xFFA0	;HALFWIDTH HANGUL FILLER
      #xFFA1	;HALFWIDTH HANGUL LETTER KIYEOK
      #xFFA2	;HALFWIDTH HANGUL LETTER SSANGKIYEOK
      #xFFA3	;HALFWIDTH HANGUL LETTER KIYEOK-SIOS
      #xFFA4	;HALFWIDTH HANGUL LETTER NIEUN
      #xFFA5	;HALFWIDTH HANGUL LETTER NIEUN-CIEUC
      #xFFA6	;HALFWIDTH HANGUL LETTER NIEUN-HIEUH
      #xFFA7	;HALFWIDTH HANGUL LETTER TIKEUT
      #xFFA8	;HALFWIDTH HANGUL LETTER SSANGTIKEUT
      #xFFA9	;HALFWIDTH HANGUL LETTER RIEUL
      #xFFAA	;HALFWIDTH HANGUL LETTER RIEUL-KIYEOK
      #xFFAB	;HALFWIDTH HANGUL LETTER RIEUL-MIEUM
      #xFFAC	;HALFWIDTH HANGUL LETTER RIEUL-PIEUP
      #xFFAD	;HALFWIDTH HANGUL LETTER RIEUL-SIOS
      #xFFAE	;HALFWIDTH HANGUL LETTER RIEUL-THIEUTH
      #xFFAF	;HALFWIDTH HANGUL LETTER RIEUL-PHIEUPH
      #xFFB0	;HALFWIDTH HANGUL LETTER RIEUL-HIEUH
      #xFFB1	;HALFWIDTH HANGUL LETTER MIEUM
      #xFFB2	;HALFWIDTH HANGUL LETTER PIEUP
      #xFFB3	;HALFWIDTH HANGUL LETTER SSANGPIEUP
      #xFFB4	;HALFWIDTH HANGUL LETTER PIEUP-SIOS
      #xFFB5	;HALFWIDTH HANGUL LETTER SIOS
      #xFFB6	;HALFWIDTH HANGUL LETTER SSANGSIOS
      #xFFB7	;HALFWIDTH HANGUL LETTER IEUNG
      #xFFB8	;HALFWIDTH HANGUL LETTER CIEUC
      #xFFB9	;HALFWIDTH HANGUL LETTER SSANGCIEUC
      #xFFBA	;HALFWIDTH HANGUL LETTER CHIEUCH
      #xFFBB	;HALFWIDTH HANGUL LETTER KHIEUKH
      #xFFBC	;HALFWIDTH HANGUL LETTER THIEUTH
      #xFFBD	;HALFWIDTH HANGUL LETTER PHIEUPH
      #xFFBE	;HALFWIDTH HANGUL LETTER HIEUH
      #xFFC2	;HALFWIDTH HANGUL LETTER A
      #xFFC3	;HALFWIDTH HANGUL LETTER AE
      #xFFC4	;HALFWIDTH HANGUL LETTER YA
      #xFFC5	;HALFWIDTH HANGUL LETTER YAE
      #xFFC6	;HALFWIDTH HANGUL LETTER EO
      #xFFC7	;HALFWIDTH HANGUL LETTER E
      #xFFCA	;HALFWIDTH HANGUL LETTER YEO
      #xFFCB	;HALFWIDTH HANGUL LETTER YE
      #xFFCC	;HALFWIDTH HANGUL LETTER O
      #xFFCD	;HALFWIDTH HANGUL LETTER WA
      #xFFCE	;HALFWIDTH HANGUL LETTER WAE
      #xFFCF	;HALFWIDTH HANGUL LETTER OE
      #xFFD2	;HALFWIDTH HANGUL LETTER YO
      #xFFD3	;HALFWIDTH HANGUL LETTER U
      #xFFD4	;HALFWIDTH HANGUL LETTER WEO
      #xFFD5	;HALFWIDTH HANGUL LETTER WE
      #xFFD6	;HALFWIDTH HANGUL LETTER WI
      #xFFD7	;HALFWIDTH HANGUL LETTER YU
      #xFFDA	;HALFWIDTH HANGUL LETTER EU
      #xFFDB	;HALFWIDTH HANGUL LETTER YI
      #xFFDC	;HALFWIDTH HANGUL LETTER I
      #x10000	;LINEAR B SYLLABLE B008 A
      #x10001	;LINEAR B SYLLABLE B038 E
      #x10002	;LINEAR B SYLLABLE B028 I
      #x10003	;LINEAR B SYLLABLE B061 O
      #x10004	;LINEAR B SYLLABLE B010 U
      #x10005	;LINEAR B SYLLABLE B001 DA
      #x10006	;LINEAR B SYLLABLE B045 DE
      #x10007	;LINEAR B SYLLABLE B007 DI
      #x10008	;LINEAR B SYLLABLE B014 DO
      #x10009	;LINEAR B SYLLABLE B051 DU
      #x1000A	;LINEAR B SYLLABLE B057 JA
      #x1000B	;LINEAR B SYLLABLE B046 JE
      #x1000D	;LINEAR B SYLLABLE B036 JO
      #x1000E	;LINEAR B SYLLABLE B065 JU
      #x1000F	;LINEAR B SYLLABLE B077 KA
      #x10010	;LINEAR B SYLLABLE B044 KE
      #x10011	;LINEAR B SYLLABLE B067 KI
      #x10012	;LINEAR B SYLLABLE B070 KO
      #x10013	;LINEAR B SYLLABLE B081 KU
      #x10014	;LINEAR B SYLLABLE B080 MA
      #x10015	;LINEAR B SYLLABLE B013 ME
      #x10016	;LINEAR B SYLLABLE B073 MI
      #x10017	;LINEAR B SYLLABLE B015 MO
      #x10018	;LINEAR B SYLLABLE B023 MU
      #x10019	;LINEAR B SYLLABLE B006 NA
      #x1001A	;LINEAR B SYLLABLE B024 NE
      #x1001B	;LINEAR B SYLLABLE B030 NI
      #x1001C	;LINEAR B SYLLABLE B052 NO
      #x1001D	;LINEAR B SYLLABLE B055 NU
      #x1001E	;LINEAR B SYLLABLE B003 PA
      #x1001F	;LINEAR B SYLLABLE B072 PE
      #x10020	;LINEAR B SYLLABLE B039 PI
      #x10021	;LINEAR B SYLLABLE B011 PO
      #x10022	;LINEAR B SYLLABLE B050 PU
      #x10023	;LINEAR B SYLLABLE B016 QA
      #x10024	;LINEAR B SYLLABLE B078 QE
      #x10025	;LINEAR B SYLLABLE B021 QI
      #x10026	;LINEAR B SYLLABLE B032 QO
      #x10028	;LINEAR B SYLLABLE B060 RA
      #x10029	;LINEAR B SYLLABLE B027 RE
      #x1002A	;LINEAR B SYLLABLE B053 RI
      #x1002B	;LINEAR B SYLLABLE B002 RO
      #x1002C	;LINEAR B SYLLABLE B026 RU
      #x1002D	;LINEAR B SYLLABLE B031 SA
      #x1002E	;LINEAR B SYLLABLE B009 SE
      #x1002F	;LINEAR B SYLLABLE B041 SI
      #x10030	;LINEAR B SYLLABLE B012 SO
      #x10031	;LINEAR B SYLLABLE B058 SU
      #x10032	;LINEAR B SYLLABLE B059 TA
      #x10033	;LINEAR B SYLLABLE B004 TE
      #x10034	;LINEAR B SYLLABLE B037 TI
      #x10035	;LINEAR B SYLLABLE B005 TO
      #x10036	;LINEAR B SYLLABLE B069 TU
      #x10037	;LINEAR B SYLLABLE B054 WA
      #x10038	;LINEAR B SYLLABLE B075 WE
      #x10039	;LINEAR B SYLLABLE B040 WI
      #x1003A	;LINEAR B SYLLABLE B042 WO
      #x1003C	;LINEAR B SYLLABLE B017 ZA
      #x1003D	;LINEAR B SYLLABLE B074 ZE
      #x1003F	;LINEAR B SYLLABLE B020 ZO
      #x10040	;LINEAR B SYLLABLE B025 A2
      #x10041	;LINEAR B SYLLABLE B043 A3
      #x10042	;LINEAR B SYLLABLE B085 AU
      #x10043	;LINEAR B SYLLABLE B071 DWE
      #x10044	;LINEAR B SYLLABLE B090 DWO
      #x10045	;LINEAR B SYLLABLE B048 NWA
      #x10046	;LINEAR B SYLLABLE B029 PU2
      #x10047	;LINEAR B SYLLABLE B062 PTE
      #x10048	;LINEAR B SYLLABLE B076 RA2
      #x10049	;LINEAR B SYLLABLE B033 RA3
      #x1004A	;LINEAR B SYLLABLE B068 RO2
      #x1004B	;LINEAR B SYLLABLE B066 TA2
      #x1004C	;LINEAR B SYLLABLE B087 TWE
      #x1004D	;LINEAR B SYLLABLE B091 TWO
      #x10050	;LINEAR B SYMBOL B018
      #x10051	;LINEAR B SYMBOL B019
      #x10052	;LINEAR B SYMBOL B022
      #x10053	;LINEAR B SYMBOL B034
      #x10054	;LINEAR B SYMBOL B047
      #x10055	;LINEAR B SYMBOL B049
      #x10056	;LINEAR B SYMBOL B056
      #x10057	;LINEAR B SYMBOL B063
      #x10058	;LINEAR B SYMBOL B064
      #x10059	;LINEAR B SYMBOL B079
      #x1005A	;LINEAR B SYMBOL B082
      #x1005B	;LINEAR B SYMBOL B083
      #x1005C	;LINEAR B SYMBOL B086
      #x1005D	;LINEAR B SYMBOL B089
      #x10080	;LINEAR B IDEOGRAM B100 MAN
      #x10081	;LINEAR B IDEOGRAM B102 WOMAN
      #x10082	;LINEAR B IDEOGRAM B104 DEER
      #x10083	;LINEAR B IDEOGRAM B105 EQUID
      #x10084	;LINEAR B IDEOGRAM B105F MARE
      #x10085	;LINEAR B IDEOGRAM B105M STALLION
      #x10086	;LINEAR B IDEOGRAM B106F EWE
      #x10087	;LINEAR B IDEOGRAM B106M RAM
      #x10088	;LINEAR B IDEOGRAM B107F SHE-GOAT
      #x10089	;LINEAR B IDEOGRAM B107M HE-GOAT
      #x1008A	;LINEAR B IDEOGRAM B108F SOW
      #x1008B	;LINEAR B IDEOGRAM B108M BOAR
      #x1008C	;LINEAR B IDEOGRAM B109F COW
      #x1008D	;LINEAR B IDEOGRAM B109M BULL
      #x1008E	;LINEAR B IDEOGRAM B120 WHEAT
      #x1008F	;LINEAR B IDEOGRAM B121 BARLEY
      #x10090	;LINEAR B IDEOGRAM B122 OLIVE
      #x10091	;LINEAR B IDEOGRAM B123 SPICE
      #x10092	;LINEAR B IDEOGRAM B125 CYPERUS
      #x10093	;LINEAR B MONOGRAM B127 KAPO
      #x10094	;LINEAR B MONOGRAM B128 KANAKO
      #x10095	;LINEAR B IDEOGRAM B130 OIL
      #x10096	;LINEAR B IDEOGRAM B131 WINE
      #x10097	;LINEAR B IDEOGRAM B132
      #x10098	;LINEAR B MONOGRAM B133 AREPA
      #x10099	;LINEAR B MONOGRAM B135 MERI
      #x1009A	;LINEAR B IDEOGRAM B140 BRONZE
      #x1009B	;LINEAR B IDEOGRAM B141 GOLD
      #x1009C	;LINEAR B IDEOGRAM B142
      #x1009D	;LINEAR B IDEOGRAM B145 WOOL
      #x1009E	;LINEAR B IDEOGRAM B146
      #x1009F	;LINEAR B IDEOGRAM B150
      #x100A0	;LINEAR B IDEOGRAM B151 HORN
      #x100A1	;LINEAR B IDEOGRAM B152
      #x100A2	;LINEAR B IDEOGRAM B153
      #x100A3	;LINEAR B IDEOGRAM B154
      #x100A4	;LINEAR B MONOGRAM B156 TURO2
      #x100A5	;LINEAR B IDEOGRAM B157
      #x100A6	;LINEAR B IDEOGRAM B158
      #x100A7	;LINEAR B IDEOGRAM B159 CLOTH
      #x100A8	;LINEAR B IDEOGRAM B160
      #x100A9	;LINEAR B IDEOGRAM B161
      #x100AA	;LINEAR B IDEOGRAM B162 GARMENT
      #x100AB	;LINEAR B IDEOGRAM B163 ARMOUR
      #x100AC	;LINEAR B IDEOGRAM B164
      #x100AD	;LINEAR B IDEOGRAM B165
      #x100AE	;LINEAR B IDEOGRAM B166
      #x100AF	;LINEAR B IDEOGRAM B167
      #x100B0	;LINEAR B IDEOGRAM B168
      #x100B1	;LINEAR B IDEOGRAM B169
      #x100B2	;LINEAR B IDEOGRAM B170
      #x100B3	;LINEAR B IDEOGRAM B171
      #x100B4	;LINEAR B IDEOGRAM B172
      #x100B5	;LINEAR B IDEOGRAM B173 MONTH
      #x100B6	;LINEAR B IDEOGRAM B174
      #x100B7	;LINEAR B IDEOGRAM B176 TREE
      #x100B8	;LINEAR B IDEOGRAM B177
      #x100B9	;LINEAR B IDEOGRAM B178
      #x100BA	;LINEAR B IDEOGRAM B179
      #x100BB	;LINEAR B IDEOGRAM B180
      #x100BC	;LINEAR B IDEOGRAM B181
      #x100BD	;LINEAR B IDEOGRAM B182
      #x100BE	;LINEAR B IDEOGRAM B183
      #x100BF	;LINEAR B IDEOGRAM B184
      #x100C0	;LINEAR B IDEOGRAM B185
      #x100C1	;LINEAR B IDEOGRAM B189
      #x100C2	;LINEAR B IDEOGRAM B190
      #x100C3	;LINEAR B IDEOGRAM B191 HELMET
      #x100C4	;LINEAR B IDEOGRAM B220 FOOTSTOOL
      #x100C5	;LINEAR B IDEOGRAM B225 BATHTUB
      #x100C6	;LINEAR B IDEOGRAM B230 SPEAR
      #x100C7	;LINEAR B IDEOGRAM B231 ARROW
      #x100C8	;LINEAR B IDEOGRAM B232
      #x100C9	;LINEAR B IDEOGRAM B233 SWORD
      #x100CA	;LINEAR B IDEOGRAM B234
      #x100CB	;LINEAR B IDEOGRAM B236
      #x100CC	;LINEAR B IDEOGRAM B240 WHEELED CHARIOT
      #x100CD	;LINEAR B IDEOGRAM B241 CHARIOT
      #x100CE	;LINEAR B IDEOGRAM B242 CHARIOT FRAME
      #x100CF	;LINEAR B IDEOGRAM B243 WHEEL
      #x100D0	;LINEAR B IDEOGRAM B245
      #x100D1	;LINEAR B IDEOGRAM B246
      #x100D2	;LINEAR B MONOGRAM B247 DIPTE
      #x100D3	;LINEAR B IDEOGRAM B248
      #x100D4	;LINEAR B IDEOGRAM B249
      #x100D5	;LINEAR B IDEOGRAM B251
      #x100D6	;LINEAR B IDEOGRAM B252
      #x100D7	;LINEAR B IDEOGRAM B253
      #x100D8	;LINEAR B IDEOGRAM B254 DART
      #x100D9	;LINEAR B IDEOGRAM B255
      #x100DA	;LINEAR B IDEOGRAM B256
      #x100DB	;LINEAR B IDEOGRAM B257
      #x100DC	;LINEAR B IDEOGRAM B258
      #x100DD	;LINEAR B IDEOGRAM B259
      #x100DE	;LINEAR B IDEOGRAM VESSEL B155
      #x100DF	;LINEAR B IDEOGRAM VESSEL B200
      #x100E0	;LINEAR B IDEOGRAM VESSEL B201
      #x100E1	;LINEAR B IDEOGRAM VESSEL B202
      #x100E2	;LINEAR B IDEOGRAM VESSEL B203
      #x100E3	;LINEAR B IDEOGRAM VESSEL B204
      #x100E4	;LINEAR B IDEOGRAM VESSEL B205
      #x100E5	;LINEAR B IDEOGRAM VESSEL B206
      #x100E6	;LINEAR B IDEOGRAM VESSEL B207
      #x100E7	;LINEAR B IDEOGRAM VESSEL B208
      #x100E8	;LINEAR B IDEOGRAM VESSEL B209
      #x100E9	;LINEAR B IDEOGRAM VESSEL B210
      #x100EA	;LINEAR B IDEOGRAM VESSEL B211
      #x100EB	;LINEAR B IDEOGRAM VESSEL B212
      #x100EC	;LINEAR B IDEOGRAM VESSEL B213
      #x100ED	;LINEAR B IDEOGRAM VESSEL B214
      #x100EE	;LINEAR B IDEOGRAM VESSEL B215
      #x100EF	;LINEAR B IDEOGRAM VESSEL B216
      #x100F0	;LINEAR B IDEOGRAM VESSEL B217
      #x100F1	;LINEAR B IDEOGRAM VESSEL B218
      #x100F2	;LINEAR B IDEOGRAM VESSEL B219
      #x100F3	;LINEAR B IDEOGRAM VESSEL B221
      #x100F4	;LINEAR B IDEOGRAM VESSEL B222
      #x100F5	;LINEAR B IDEOGRAM VESSEL B226
      #x100F6	;LINEAR B IDEOGRAM VESSEL B227
      #x100F7	;LINEAR B IDEOGRAM VESSEL B228
      #x100F8	;LINEAR B IDEOGRAM VESSEL B229
      #x100F9	;LINEAR B IDEOGRAM VESSEL B250
      #x100FA	;LINEAR B IDEOGRAM VESSEL B305
      #x10300	;OLD ITALIC LETTER A
      #x10301	;OLD ITALIC LETTER BE
      #x10302	;OLD ITALIC LETTER KE
      #x10303	;OLD ITALIC LETTER DE
      #x10304	;OLD ITALIC LETTER E
      #x10305	;OLD ITALIC LETTER VE
      #x10306	;OLD ITALIC LETTER ZE
      #x10307	;OLD ITALIC LETTER HE
      #x10308	;OLD ITALIC LETTER THE
      #x10309	;OLD ITALIC LETTER I
      #x1030A	;OLD ITALIC LETTER KA
      #x1030B	;OLD ITALIC LETTER EL
      #x1030C	;OLD ITALIC LETTER EM
      #x1030D	;OLD ITALIC LETTER EN
      #x1030E	;OLD ITALIC LETTER ESH
      #x1030F	;OLD ITALIC LETTER O
      #x10310	;OLD ITALIC LETTER PE
      #x10311	;OLD ITALIC LETTER SHE
      #x10312	;OLD ITALIC LETTER KU
      #x10313	;OLD ITALIC LETTER ER
      #x10314	;OLD ITALIC LETTER ES
      #x10315	;OLD ITALIC LETTER TE
      #x10316	;OLD ITALIC LETTER U
      #x10317	;OLD ITALIC LETTER EKS
      #x10318	;OLD ITALIC LETTER PHE
      #x10319	;OLD ITALIC LETTER KHE
      #x1031A	;OLD ITALIC LETTER EF
      #x1031B	;OLD ITALIC LETTER ERS
      #x1031C	;OLD ITALIC LETTER CHE
      #x1031D	;OLD ITALIC LETTER II
      #x1031E	;OLD ITALIC LETTER UU
      #x10330	;GOTHIC LETTER AHSA
      #x10331	;GOTHIC LETTER BAIRKAN
      #x10332	;GOTHIC LETTER GIBA
      #x10333	;GOTHIC LETTER DAGS
      #x10334	;GOTHIC LETTER AIHVUS
      #x10335	;GOTHIC LETTER QAIRTHRA
      #x10336	;GOTHIC LETTER IUJA
      #x10337	;GOTHIC LETTER HAGL
      #x10338	;GOTHIC LETTER THIUTH
      #x10339	;GOTHIC LETTER EIS
      #x1033A	;GOTHIC LETTER KUSMA
      #x1033B	;GOTHIC LETTER LAGUS
      #x1033C	;GOTHIC LETTER MANNA
      #x1033D	;GOTHIC LETTER NAUTHS
      #x1033E	;GOTHIC LETTER JER
      #x1033F	;GOTHIC LETTER URUS
      #x10340	;GOTHIC LETTER PAIRTHRA
      #x10341	;GOTHIC LETTER NINETY
      #x10342	;GOTHIC LETTER RAIDA
      #x10343	;GOTHIC LETTER SAUIL
      #x10344	;GOTHIC LETTER TEIWS
      #x10345	;GOTHIC LETTER WINJA
      #x10346	;GOTHIC LETTER FAIHU
      #x10347	;GOTHIC LETTER IGGWS
      #x10348	;GOTHIC LETTER HWAIR
      #x10349	;GOTHIC LETTER OTHAL
      #x10380	;UGARITIC LETTER ALPA
      #x10381	;UGARITIC LETTER BETA
      #x10382	;UGARITIC LETTER GAMLA
      #x10383	;UGARITIC LETTER KHA
      #x10384	;UGARITIC LETTER DELTA
      #x10385	;UGARITIC LETTER HO
      #x10386	;UGARITIC LETTER WO
      #x10387	;UGARITIC LETTER ZETA
      #x10388	;UGARITIC LETTER HOTA
      #x10389	;UGARITIC LETTER TET
      #x1038A	;UGARITIC LETTER YOD
      #x1038B	;UGARITIC LETTER KAF
      #x1038C	;UGARITIC LETTER SHIN
      #x1038D	;UGARITIC LETTER LAMDA
      #x1038E	;UGARITIC LETTER MEM
      #x1038F	;UGARITIC LETTER DHAL
      #x10390	;UGARITIC LETTER NUN
      #x10391	;UGARITIC LETTER ZU
      #x10392	;UGARITIC LETTER SAMKA
      #x10393	;UGARITIC LETTER AIN
      #x10394	;UGARITIC LETTER PU
      #x10395	;UGARITIC LETTER SADE
      #x10396	;UGARITIC LETTER QOPA
      #x10397	;UGARITIC LETTER RASHA
      #x10398	;UGARITIC LETTER THANNA
      #x10399	;UGARITIC LETTER GHAIN
      #x1039A	;UGARITIC LETTER TO
      #x1039B	;UGARITIC LETTER I
      #x1039C	;UGARITIC LETTER U
      #x1039D	;UGARITIC LETTER SSU
      #x10400	;DESERET CAPITAL LETTER LONG I
      #x10401	;DESERET CAPITAL LETTER LONG E
      #x10402	;DESERET CAPITAL LETTER LONG A
      #x10403	;DESERET CAPITAL LETTER LONG AH
      #x10404	;DESERET CAPITAL LETTER LONG O
      #x10405	;DESERET CAPITAL LETTER LONG OO
      #x10406	;DESERET CAPITAL LETTER SHORT I
      #x10407	;DESERET CAPITAL LETTER SHORT E
      #x10408	;DESERET CAPITAL LETTER SHORT A
      #x10409	;DESERET CAPITAL LETTER SHORT AH
      #x1040A	;DESERET CAPITAL LETTER SHORT O
      #x1040B	;DESERET CAPITAL LETTER SHORT OO
      #x1040C	;DESERET CAPITAL LETTER AY
      #x1040D	;DESERET CAPITAL LETTER OW
      #x1040E	;DESERET CAPITAL LETTER WU
      #x1040F	;DESERET CAPITAL LETTER YEE
      #x10410	;DESERET CAPITAL LETTER H
      #x10411	;DESERET CAPITAL LETTER PEE
      #x10412	;DESERET CAPITAL LETTER BEE
      #x10413	;DESERET CAPITAL LETTER TEE
      #x10414	;DESERET CAPITAL LETTER DEE
      #x10415	;DESERET CAPITAL LETTER CHEE
      #x10416	;DESERET CAPITAL LETTER JEE
      #x10417	;DESERET CAPITAL LETTER KAY
      #x10418	;DESERET CAPITAL LETTER GAY
      #x10419	;DESERET CAPITAL LETTER EF
      #x1041A	;DESERET CAPITAL LETTER VEE
      #x1041B	;DESERET CAPITAL LETTER ETH
      #x1041C	;DESERET CAPITAL LETTER THEE
      #x1041D	;DESERET CAPITAL LETTER ES
      #x1041E	;DESERET CAPITAL LETTER ZEE
      #x1041F	;DESERET CAPITAL LETTER ESH
      #x10420	;DESERET CAPITAL LETTER ZHEE
      #x10421	;DESERET CAPITAL LETTER ER
      #x10422	;DESERET CAPITAL LETTER EL
      #x10423	;DESERET CAPITAL LETTER EM
      #x10424	;DESERET CAPITAL LETTER EN
      #x10425	;DESERET CAPITAL LETTER ENG
      #x10426	;DESERET CAPITAL LETTER OI
      #x10427	;DESERET CAPITAL LETTER EW
      #x10428	;DESERET SMALL LETTER LONG I
      #x10429	;DESERET SMALL LETTER LONG E
      #x1042A	;DESERET SMALL LETTER LONG A
      #x1042B	;DESERET SMALL LETTER LONG AH
      #x1042C	;DESERET SMALL LETTER LONG O
      #x1042D	;DESERET SMALL LETTER LONG OO
      #x1042E	;DESERET SMALL LETTER SHORT I
      #x1042F	;DESERET SMALL LETTER SHORT E
      #x10430	;DESERET SMALL LETTER SHORT A
      #x10431	;DESERET SMALL LETTER SHORT AH
      #x10432	;DESERET SMALL LETTER SHORT O
      #x10433	;DESERET SMALL LETTER SHORT OO
      #x10434	;DESERET SMALL LETTER AY
      #x10435	;DESERET SMALL LETTER OW
      #x10436	;DESERET SMALL LETTER WU
      #x10437	;DESERET SMALL LETTER YEE
      #x10438	;DESERET SMALL LETTER H
      #x10439	;DESERET SMALL LETTER PEE
      #x1043A	;DESERET SMALL LETTER BEE
      #x1043B	;DESERET SMALL LETTER TEE
      #x1043C	;DESERET SMALL LETTER DEE
      #x1043D	;DESERET SMALL LETTER CHEE
      #x1043E	;DESERET SMALL LETTER JEE
      #x1043F	;DESERET SMALL LETTER KAY
      #x10440	;DESERET SMALL LETTER GAY
      #x10441	;DESERET SMALL LETTER EF
      #x10442	;DESERET SMALL LETTER VEE
      #x10443	;DESERET SMALL LETTER ETH
      #x10444	;DESERET SMALL LETTER THEE
      #x10445	;DESERET SMALL LETTER ES
      #x10446	;DESERET SMALL LETTER ZEE
      #x10447	;DESERET SMALL LETTER ESH
      #x10448	;DESERET SMALL LETTER ZHEE
      #x10449	;DESERET SMALL LETTER ER
      #x1044A	;DESERET SMALL LETTER EL
      #x1044B	;DESERET SMALL LETTER EM
      #x1044C	;DESERET SMALL LETTER EN
      #x1044D	;DESERET SMALL LETTER ENG
      #x1044E	;DESERET SMALL LETTER OI
      #x1044F	;DESERET SMALL LETTER EW
      #x10450	;SHAVIAN LETTER PEEP
      #x10451	;SHAVIAN LETTER TOT
      #x10452	;SHAVIAN LETTER KICK
      #x10453	;SHAVIAN LETTER FEE
      #x10454	;SHAVIAN LETTER THIGH
      #x10455	;SHAVIAN LETTER SO
      #x10456	;SHAVIAN LETTER SURE
      #x10457	;SHAVIAN LETTER CHURCH
      #x10458	;SHAVIAN LETTER YEA
      #x10459	;SHAVIAN LETTER HUNG
      #x1045A	;SHAVIAN LETTER BIB
      #x1045B	;SHAVIAN LETTER DEAD
      #x1045C	;SHAVIAN LETTER GAG
      #x1045D	;SHAVIAN LETTER VOW
      #x1045E	;SHAVIAN LETTER THEY
      #x1045F	;SHAVIAN LETTER ZOO
      #x10460	;SHAVIAN LETTER MEASURE
      #x10461	;SHAVIAN LETTER JUDGE
      #x10462	;SHAVIAN LETTER WOE
      #x10463	;SHAVIAN LETTER HA-HA
      #x10464	;SHAVIAN LETTER LOLL
      #x10465	;SHAVIAN LETTER MIME
      #x10466	;SHAVIAN LETTER IF
      #x10467	;SHAVIAN LETTER EGG
      #x10468	;SHAVIAN LETTER ASH
      #x10469	;SHAVIAN LETTER ADO
      #x1046A	;SHAVIAN LETTER ON
      #x1046B	;SHAVIAN LETTER WOOL
      #x1046C	;SHAVIAN LETTER OUT
      #x1046D	;SHAVIAN LETTER AH
      #x1046E	;SHAVIAN LETTER ROAR
      #x1046F	;SHAVIAN LETTER NUN
      #x10470	;SHAVIAN LETTER EAT
      #x10471	;SHAVIAN LETTER AGE
      #x10472	;SHAVIAN LETTER ICE
      #x10473	;SHAVIAN LETTER UP
      #x10474	;SHAVIAN LETTER OAK
      #x10475	;SHAVIAN LETTER OOZE
      #x10476	;SHAVIAN LETTER OIL
      #x10477	;SHAVIAN LETTER AWE
      #x10478	;SHAVIAN LETTER ARE
      #x10479	;SHAVIAN LETTER OR
      #x1047A	;SHAVIAN LETTER AIR
      #x1047B	;SHAVIAN LETTER ERR
      #x1047C	;SHAVIAN LETTER ARRAY
      #x1047D	;SHAVIAN LETTER EAR
      #x1047E	;SHAVIAN LETTER IAN
      #x1047F	;SHAVIAN LETTER YEW
      #x10480	;OSMANYA LETTER ALEF
      #x10481	;OSMANYA LETTER BA
      #x10482	;OSMANYA LETTER TA
      #x10483	;OSMANYA LETTER JA
      #x10484	;OSMANYA LETTER XA
      #x10485	;OSMANYA LETTER KHA
      #x10486	;OSMANYA LETTER DEEL
      #x10487	;OSMANYA LETTER RA
      #x10488	;OSMANYA LETTER SA
      #x10489	;OSMANYA LETTER SHIIN
      #x1048A	;OSMANYA LETTER DHA
      #x1048B	;OSMANYA LETTER CAYN
      #x1048C	;OSMANYA LETTER GA
      #x1048D	;OSMANYA LETTER FA
      #x1048E	;OSMANYA LETTER QAAF
      #x1048F	;OSMANYA LETTER KAAF
      #x10490	;OSMANYA LETTER LAAN
      #x10491	;OSMANYA LETTER MIIN
      #x10492	;OSMANYA LETTER NUUN
      #x10493	;OSMANYA LETTER WAW
      #x10494	;OSMANYA LETTER HA
      #x10495	;OSMANYA LETTER YA
      #x10496	;OSMANYA LETTER A
      #x10497	;OSMANYA LETTER E
      #x10498	;OSMANYA LETTER I
      #x10499	;OSMANYA LETTER O
      #x1049A	;OSMANYA LETTER U
      #x1049B	;OSMANYA LETTER AA
      #x1049C	;OSMANYA LETTER EE
      #x1049D	;OSMANYA LETTER OO
      #x10800	;CYPRIOT SYLLABLE A
      #x10801	;CYPRIOT SYLLABLE E
      #x10802	;CYPRIOT SYLLABLE I
      #x10803	;CYPRIOT SYLLABLE O
      #x10804	;CYPRIOT SYLLABLE U
      #x10805	;CYPRIOT SYLLABLE JA
      #x10808	;CYPRIOT SYLLABLE JO
      #x1080A	;CYPRIOT SYLLABLE KA
      #x1080B	;CYPRIOT SYLLABLE KE
      #x1080C	;CYPRIOT SYLLABLE KI
      #x1080D	;CYPRIOT SYLLABLE KO
      #x1080E	;CYPRIOT SYLLABLE KU
      #x1080F	;CYPRIOT SYLLABLE LA
      #x10810	;CYPRIOT SYLLABLE LE
      #x10811	;CYPRIOT SYLLABLE LI
      #x10812	;CYPRIOT SYLLABLE LO
      #x10813	;CYPRIOT SYLLABLE LU
      #x10814	;CYPRIOT SYLLABLE MA
      #x10815	;CYPRIOT SYLLABLE ME
      #x10816	;CYPRIOT SYLLABLE MI
      #x10817	;CYPRIOT SYLLABLE MO
      #x10818	;CYPRIOT SYLLABLE MU
      #x10819	;CYPRIOT SYLLABLE NA
      #x1081A	;CYPRIOT SYLLABLE NE
      #x1081B	;CYPRIOT SYLLABLE NI
      #x1081C	;CYPRIOT SYLLABLE NO
      #x1081D	;CYPRIOT SYLLABLE NU
      #x1081E	;CYPRIOT SYLLABLE PA
      #x1081F	;CYPRIOT SYLLABLE PE
      #x10820	;CYPRIOT SYLLABLE PI
      #x10821	;CYPRIOT SYLLABLE PO
      #x10822	;CYPRIOT SYLLABLE PU
      #x10823	;CYPRIOT SYLLABLE RA
      #x10824	;CYPRIOT SYLLABLE RE
      #x10825	;CYPRIOT SYLLABLE RI
      #x10826	;CYPRIOT SYLLABLE RO
      #x10827	;CYPRIOT SYLLABLE RU
      #x10828	;CYPRIOT SYLLABLE SA
      #x10829	;CYPRIOT SYLLABLE SE
      #x1082A	;CYPRIOT SYLLABLE SI
      #x1082B	;CYPRIOT SYLLABLE SO
      #x1082C	;CYPRIOT SYLLABLE SU
      #x1082D	;CYPRIOT SYLLABLE TA
      #x1082E	;CYPRIOT SYLLABLE TE
      #x1082F	;CYPRIOT SYLLABLE TI
      #x10830	;CYPRIOT SYLLABLE TO
      #x10831	;CYPRIOT SYLLABLE TU
      #x10832	;CYPRIOT SYLLABLE WA
      #x10833	;CYPRIOT SYLLABLE WE
      #x10834	;CYPRIOT SYLLABLE WI
      #x10835	;CYPRIOT SYLLABLE WO
      #x10837	;CYPRIOT SYLLABLE XA
      #x10838	;CYPRIOT SYLLABLE XE
      #x1083C	;CYPRIOT SYLLABLE ZA
      #x1083F	;CYPRIOT SYLLABLE ZO
      #x1D400	;MATHEMATICAL BOLD CAPITAL A
      #x1D401	;MATHEMATICAL BOLD CAPITAL B
      #x1D402	;MATHEMATICAL BOLD CAPITAL C
      #x1D403	;MATHEMATICAL BOLD CAPITAL D
      #x1D404	;MATHEMATICAL BOLD CAPITAL E
      #x1D405	;MATHEMATICAL BOLD CAPITAL F
      #x1D406	;MATHEMATICAL BOLD CAPITAL G
      #x1D407	;MATHEMATICAL BOLD CAPITAL H
      #x1D408	;MATHEMATICAL BOLD CAPITAL I
      #x1D409	;MATHEMATICAL BOLD CAPITAL J
      #x1D40A	;MATHEMATICAL BOLD CAPITAL K
      #x1D40B	;MATHEMATICAL BOLD CAPITAL L
      #x1D40C	;MATHEMATICAL BOLD CAPITAL M
      #x1D40D	;MATHEMATICAL BOLD CAPITAL N
      #x1D40E	;MATHEMATICAL BOLD CAPITAL O
      #x1D40F	;MATHEMATICAL BOLD CAPITAL P
      #x1D410	;MATHEMATICAL BOLD CAPITAL Q
      #x1D411	;MATHEMATICAL BOLD CAPITAL R
      #x1D412	;MATHEMATICAL BOLD CAPITAL S
      #x1D413	;MATHEMATICAL BOLD CAPITAL T
      #x1D414	;MATHEMATICAL BOLD CAPITAL U
      #x1D415	;MATHEMATICAL BOLD CAPITAL V
      #x1D416	;MATHEMATICAL BOLD CAPITAL W
      #x1D417	;MATHEMATICAL BOLD CAPITAL X
      #x1D418	;MATHEMATICAL BOLD CAPITAL Y
      #x1D419	;MATHEMATICAL BOLD CAPITAL Z
      #x1D41A	;MATHEMATICAL BOLD SMALL A
      #x1D41B	;MATHEMATICAL BOLD SMALL B
      #x1D41C	;MATHEMATICAL BOLD SMALL C
      #x1D41D	;MATHEMATICAL BOLD SMALL D
      #x1D41E	;MATHEMATICAL BOLD SMALL E
      #x1D41F	;MATHEMATICAL BOLD SMALL F
      #x1D420	;MATHEMATICAL BOLD SMALL G
      #x1D421	;MATHEMATICAL BOLD SMALL H
      #x1D422	;MATHEMATICAL BOLD SMALL I
      #x1D423	;MATHEMATICAL BOLD SMALL J
      #x1D424	;MATHEMATICAL BOLD SMALL K
      #x1D425	;MATHEMATICAL BOLD SMALL L
      #x1D426	;MATHEMATICAL BOLD SMALL M
      #x1D427	;MATHEMATICAL BOLD SMALL N
      #x1D428	;MATHEMATICAL BOLD SMALL O
      #x1D429	;MATHEMATICAL BOLD SMALL P
      #x1D42A	;MATHEMATICAL BOLD SMALL Q
      #x1D42B	;MATHEMATICAL BOLD SMALL R
      #x1D42C	;MATHEMATICAL BOLD SMALL S
      #x1D42D	;MATHEMATICAL BOLD SMALL T
      #x1D42E	;MATHEMATICAL BOLD SMALL U
      #x1D42F	;MATHEMATICAL BOLD SMALL V
      #x1D430	;MATHEMATICAL BOLD SMALL W
      #x1D431	;MATHEMATICAL BOLD SMALL X
      #x1D432	;MATHEMATICAL BOLD SMALL Y
      #x1D433	;MATHEMATICAL BOLD SMALL Z
      #x1D434	;MATHEMATICAL ITALIC CAPITAL A
      #x1D435	;MATHEMATICAL ITALIC CAPITAL B
      #x1D436	;MATHEMATICAL ITALIC CAPITAL C
      #x1D437	;MATHEMATICAL ITALIC CAPITAL D
      #x1D438	;MATHEMATICAL ITALIC CAPITAL E
      #x1D439	;MATHEMATICAL ITALIC CAPITAL F
      #x1D43A	;MATHEMATICAL ITALIC CAPITAL G
      #x1D43B	;MATHEMATICAL ITALIC CAPITAL H
      #x1D43C	;MATHEMATICAL ITALIC CAPITAL I
      #x1D43D	;MATHEMATICAL ITALIC CAPITAL J
      #x1D43E	;MATHEMATICAL ITALIC CAPITAL K
      #x1D43F	;MATHEMATICAL ITALIC CAPITAL L
      #x1D440	;MATHEMATICAL ITALIC CAPITAL M
      #x1D441	;MATHEMATICAL ITALIC CAPITAL N
      #x1D442	;MATHEMATICAL ITALIC CAPITAL O
      #x1D443	;MATHEMATICAL ITALIC CAPITAL P
      #x1D444	;MATHEMATICAL ITALIC CAPITAL Q
      #x1D445	;MATHEMATICAL ITALIC CAPITAL R
      #x1D446	;MATHEMATICAL ITALIC CAPITAL S
      #x1D447	;MATHEMATICAL ITALIC CAPITAL T
      #x1D448	;MATHEMATICAL ITALIC CAPITAL U
      #x1D449	;MATHEMATICAL ITALIC CAPITAL V
      #x1D44A	;MATHEMATICAL ITALIC CAPITAL W
      #x1D44B	;MATHEMATICAL ITALIC CAPITAL X
      #x1D44C	;MATHEMATICAL ITALIC CAPITAL Y
      #x1D44D	;MATHEMATICAL ITALIC CAPITAL Z
      #x1D44E	;MATHEMATICAL ITALIC SMALL A
      #x1D44F	;MATHEMATICAL ITALIC SMALL B
      #x1D450	;MATHEMATICAL ITALIC SMALL C
      #x1D451	;MATHEMATICAL ITALIC SMALL D
      #x1D452	;MATHEMATICAL ITALIC SMALL E
      #x1D453	;MATHEMATICAL ITALIC SMALL F
      #x1D454	;MATHEMATICAL ITALIC SMALL G
      #x1D456	;MATHEMATICAL ITALIC SMALL I
      #x1D457	;MATHEMATICAL ITALIC SMALL J
      #x1D458	;MATHEMATICAL ITALIC SMALL K
      #x1D459	;MATHEMATICAL ITALIC SMALL L
      #x1D45A	;MATHEMATICAL ITALIC SMALL M
      #x1D45B	;MATHEMATICAL ITALIC SMALL N
      #x1D45C	;MATHEMATICAL ITALIC SMALL O
      #x1D45D	;MATHEMATICAL ITALIC SMALL P
      #x1D45E	;MATHEMATICAL ITALIC SMALL Q
      #x1D45F	;MATHEMATICAL ITALIC SMALL R
      #x1D460	;MATHEMATICAL ITALIC SMALL S
      #x1D461	;MATHEMATICAL ITALIC SMALL T
      #x1D462	;MATHEMATICAL ITALIC SMALL U
      #x1D463	;MATHEMATICAL ITALIC SMALL V
      #x1D464	;MATHEMATICAL ITALIC SMALL W
      #x1D465	;MATHEMATICAL ITALIC SMALL X
      #x1D466	;MATHEMATICAL ITALIC SMALL Y
      #x1D467	;MATHEMATICAL ITALIC SMALL Z
      #x1D468	;MATHEMATICAL BOLD ITALIC CAPITAL A
      #x1D469	;MATHEMATICAL BOLD ITALIC CAPITAL B
      #x1D46A	;MATHEMATICAL BOLD ITALIC CAPITAL C
      #x1D46B	;MATHEMATICAL BOLD ITALIC CAPITAL D
      #x1D46C	;MATHEMATICAL BOLD ITALIC CAPITAL E
      #x1D46D	;MATHEMATICAL BOLD ITALIC CAPITAL F
      #x1D46E	;MATHEMATICAL BOLD ITALIC CAPITAL G
      #x1D46F	;MATHEMATICAL BOLD ITALIC CAPITAL H
      #x1D470	;MATHEMATICAL BOLD ITALIC CAPITAL I
      #x1D471	;MATHEMATICAL BOLD ITALIC CAPITAL J
      #x1D472	;MATHEMATICAL BOLD ITALIC CAPITAL K
      #x1D473	;MATHEMATICAL BOLD ITALIC CAPITAL L
      #x1D474	;MATHEMATICAL BOLD ITALIC CAPITAL M
      #x1D475	;MATHEMATICAL BOLD ITALIC CAPITAL N
      #x1D476	;MATHEMATICAL BOLD ITALIC CAPITAL O
      #x1D477	;MATHEMATICAL BOLD ITALIC CAPITAL P
      #x1D478	;MATHEMATICAL BOLD ITALIC CAPITAL Q
      #x1D479	;MATHEMATICAL BOLD ITALIC CAPITAL R
      #x1D47A	;MATHEMATICAL BOLD ITALIC CAPITAL S
      #x1D47B	;MATHEMATICAL BOLD ITALIC CAPITAL T
      #x1D47C	;MATHEMATICAL BOLD ITALIC CAPITAL U
      #x1D47D	;MATHEMATICAL BOLD ITALIC CAPITAL V
      #x1D47E	;MATHEMATICAL BOLD ITALIC CAPITAL W
      #x1D47F	;MATHEMATICAL BOLD ITALIC CAPITAL X
      #x1D480	;MATHEMATICAL BOLD ITALIC CAPITAL Y
      #x1D481	;MATHEMATICAL BOLD ITALIC CAPITAL Z
      #x1D482	;MATHEMATICAL BOLD ITALIC SMALL A
      #x1D483	;MATHEMATICAL BOLD ITALIC SMALL B
      #x1D484	;MATHEMATICAL BOLD ITALIC SMALL C
      #x1D485	;MATHEMATICAL BOLD ITALIC SMALL D
      #x1D486	;MATHEMATICAL BOLD ITALIC SMALL E
      #x1D487	;MATHEMATICAL BOLD ITALIC SMALL F
      #x1D488	;MATHEMATICAL BOLD ITALIC SMALL G
      #x1D489	;MATHEMATICAL BOLD ITALIC SMALL H
      #x1D48A	;MATHEMATICAL BOLD ITALIC SMALL I
      #x1D48B	;MATHEMATICAL BOLD ITALIC SMALL J
      #x1D48C	;MATHEMATICAL BOLD ITALIC SMALL K
      #x1D48D	;MATHEMATICAL BOLD ITALIC SMALL L
      #x1D48E	;MATHEMATICAL BOLD ITALIC SMALL M
      #x1D48F	;MATHEMATICAL BOLD ITALIC SMALL N
      #x1D490	;MATHEMATICAL BOLD ITALIC SMALL O
      #x1D491	;MATHEMATICAL BOLD ITALIC SMALL P
      #x1D492	;MATHEMATICAL BOLD ITALIC SMALL Q
      #x1D493	;MATHEMATICAL BOLD ITALIC SMALL R
      #x1D494	;MATHEMATICAL BOLD ITALIC SMALL S
      #x1D495	;MATHEMATICAL BOLD ITALIC SMALL T
      #x1D496	;MATHEMATICAL BOLD ITALIC SMALL U
      #x1D497	;MATHEMATICAL BOLD ITALIC SMALL V
      #x1D498	;MATHEMATICAL BOLD ITALIC SMALL W
      #x1D499	;MATHEMATICAL BOLD ITALIC SMALL X
      #x1D49A	;MATHEMATICAL BOLD ITALIC SMALL Y
      #x1D49B	;MATHEMATICAL BOLD ITALIC SMALL Z
      #x1D49C	;MATHEMATICAL SCRIPT CAPITAL A
      #x1D49E	;MATHEMATICAL SCRIPT CAPITAL C
      #x1D49F	;MATHEMATICAL SCRIPT CAPITAL D
      #x1D4A2	;MATHEMATICAL SCRIPT CAPITAL G
      #x1D4A5	;MATHEMATICAL SCRIPT CAPITAL J
      #x1D4A6	;MATHEMATICAL SCRIPT CAPITAL K
      #x1D4A9	;MATHEMATICAL SCRIPT CAPITAL N
      #x1D4AA	;MATHEMATICAL SCRIPT CAPITAL O
      #x1D4AB	;MATHEMATICAL SCRIPT CAPITAL P
      #x1D4AC	;MATHEMATICAL SCRIPT CAPITAL Q
      #x1D4AE	;MATHEMATICAL SCRIPT CAPITAL S
      #x1D4AF	;MATHEMATICAL SCRIPT CAPITAL T
      #x1D4B0	;MATHEMATICAL SCRIPT CAPITAL U
      #x1D4B1	;MATHEMATICAL SCRIPT CAPITAL V
      #x1D4B2	;MATHEMATICAL SCRIPT CAPITAL W
      #x1D4B3	;MATHEMATICAL SCRIPT CAPITAL X
      #x1D4B4	;MATHEMATICAL SCRIPT CAPITAL Y
      #x1D4B5	;MATHEMATICAL SCRIPT CAPITAL Z
      #x1D4B6	;MATHEMATICAL SCRIPT SMALL A
      #x1D4B7	;MATHEMATICAL SCRIPT SMALL B
      #x1D4B8	;MATHEMATICAL SCRIPT SMALL C
      #x1D4B9	;MATHEMATICAL SCRIPT SMALL D
      #x1D4BB	;MATHEMATICAL SCRIPT SMALL F
      #x1D4BD	;MATHEMATICAL SCRIPT SMALL H
      #x1D4BE	;MATHEMATICAL SCRIPT SMALL I
      #x1D4BF	;MATHEMATICAL SCRIPT SMALL J
      #x1D4C0	;MATHEMATICAL SCRIPT SMALL K
      #x1D4C1	;MATHEMATICAL SCRIPT SMALL L
      #x1D4C2	;MATHEMATICAL SCRIPT SMALL M
      #x1D4C3	;MATHEMATICAL SCRIPT SMALL N
      #x1D4C5	;MATHEMATICAL SCRIPT SMALL P
      #x1D4C6	;MATHEMATICAL SCRIPT SMALL Q
      #x1D4C7	;MATHEMATICAL SCRIPT SMALL R
      #x1D4C8	;MATHEMATICAL SCRIPT SMALL S
      #x1D4C9	;MATHEMATICAL SCRIPT SMALL T
      #x1D4CA	;MATHEMATICAL SCRIPT SMALL U
      #x1D4CB	;MATHEMATICAL SCRIPT SMALL V
      #x1D4CC	;MATHEMATICAL SCRIPT SMALL W
      #x1D4CD	;MATHEMATICAL SCRIPT SMALL X
      #x1D4CE	;MATHEMATICAL SCRIPT SMALL Y
      #x1D4CF	;MATHEMATICAL SCRIPT SMALL Z
      #x1D4D0	;MATHEMATICAL BOLD SCRIPT CAPITAL A
      #x1D4D1	;MATHEMATICAL BOLD SCRIPT CAPITAL B
      #x1D4D2	;MATHEMATICAL BOLD SCRIPT CAPITAL C
      #x1D4D3	;MATHEMATICAL BOLD SCRIPT CAPITAL D
      #x1D4D4	;MATHEMATICAL BOLD SCRIPT CAPITAL E
      #x1D4D5	;MATHEMATICAL BOLD SCRIPT CAPITAL F
      #x1D4D6	;MATHEMATICAL BOLD SCRIPT CAPITAL G
      #x1D4D7	;MATHEMATICAL BOLD SCRIPT CAPITAL H
      #x1D4D8	;MATHEMATICAL BOLD SCRIPT CAPITAL I
      #x1D4D9	;MATHEMATICAL BOLD SCRIPT CAPITAL J
      #x1D4DA	;MATHEMATICAL BOLD SCRIPT CAPITAL K
      #x1D4DB	;MATHEMATICAL BOLD SCRIPT CAPITAL L
      #x1D4DC	;MATHEMATICAL BOLD SCRIPT CAPITAL M
      #x1D4DD	;MATHEMATICAL BOLD SCRIPT CAPITAL N
      #x1D4DE	;MATHEMATICAL BOLD SCRIPT CAPITAL O
      #x1D4DF	;MATHEMATICAL BOLD SCRIPT CAPITAL P
      #x1D4E0	;MATHEMATICAL BOLD SCRIPT CAPITAL Q
      #x1D4E1	;MATHEMATICAL BOLD SCRIPT CAPITAL R
      #x1D4E2	;MATHEMATICAL BOLD SCRIPT CAPITAL S
      #x1D4E3	;MATHEMATICAL BOLD SCRIPT CAPITAL T
      #x1D4E4	;MATHEMATICAL BOLD SCRIPT CAPITAL U
      #x1D4E5	;MATHEMATICAL BOLD SCRIPT CAPITAL V
      #x1D4E6	;MATHEMATICAL BOLD SCRIPT CAPITAL W
      #x1D4E7	;MATHEMATICAL BOLD SCRIPT CAPITAL X
      #x1D4E8	;MATHEMATICAL BOLD SCRIPT CAPITAL Y
      #x1D4E9	;MATHEMATICAL BOLD SCRIPT CAPITAL Z
      #x1D4EA	;MATHEMATICAL BOLD SCRIPT SMALL A
      #x1D4EB	;MATHEMATICAL BOLD SCRIPT SMALL B
      #x1D4EC	;MATHEMATICAL BOLD SCRIPT SMALL C
      #x1D4ED	;MATHEMATICAL BOLD SCRIPT SMALL D
      #x1D4EE	;MATHEMATICAL BOLD SCRIPT SMALL E
      #x1D4EF	;MATHEMATICAL BOLD SCRIPT SMALL F
      #x1D4F0	;MATHEMATICAL BOLD SCRIPT SMALL G
      #x1D4F1	;MATHEMATICAL BOLD SCRIPT SMALL H
      #x1D4F2	;MATHEMATICAL BOLD SCRIPT SMALL I
      #x1D4F3	;MATHEMATICAL BOLD SCRIPT SMALL J
      #x1D4F4	;MATHEMATICAL BOLD SCRIPT SMALL K
      #x1D4F5	;MATHEMATICAL BOLD SCRIPT SMALL L
      #x1D4F6	;MATHEMATICAL BOLD SCRIPT SMALL M
      #x1D4F7	;MATHEMATICAL BOLD SCRIPT SMALL N
      #x1D4F8	;MATHEMATICAL BOLD SCRIPT SMALL O
      #x1D4F9	;MATHEMATICAL BOLD SCRIPT SMALL P
      #x1D4FA	;MATHEMATICAL BOLD SCRIPT SMALL Q
      #x1D4FB	;MATHEMATICAL BOLD SCRIPT SMALL R
      #x1D4FC	;MATHEMATICAL BOLD SCRIPT SMALL S
      #x1D4FD	;MATHEMATICAL BOLD SCRIPT SMALL T
      #x1D4FE	;MATHEMATICAL BOLD SCRIPT SMALL U
      #x1D4FF	;MATHEMATICAL BOLD SCRIPT SMALL V
      #x1D500	;MATHEMATICAL BOLD SCRIPT SMALL W
      #x1D501	;MATHEMATICAL BOLD SCRIPT SMALL X
      #x1D502	;MATHEMATICAL BOLD SCRIPT SMALL Y
      #x1D503	;MATHEMATICAL BOLD SCRIPT SMALL Z
      #x1D504	;MATHEMATICAL FRAKTUR CAPITAL A
      #x1D505	;MATHEMATICAL FRAKTUR CAPITAL B
      #x1D507	;MATHEMATICAL FRAKTUR CAPITAL D
      #x1D508	;MATHEMATICAL FRAKTUR CAPITAL E
      #x1D509	;MATHEMATICAL FRAKTUR CAPITAL F
      #x1D50A	;MATHEMATICAL FRAKTUR CAPITAL G
      #x1D50D	;MATHEMATICAL FRAKTUR CAPITAL J
      #x1D50E	;MATHEMATICAL FRAKTUR CAPITAL K
      #x1D50F	;MATHEMATICAL FRAKTUR CAPITAL L
      #x1D510	;MATHEMATICAL FRAKTUR CAPITAL M
      #x1D511	;MATHEMATICAL FRAKTUR CAPITAL N
      #x1D512	;MATHEMATICAL FRAKTUR CAPITAL O
      #x1D513	;MATHEMATICAL FRAKTUR CAPITAL P
      #x1D514	;MATHEMATICAL FRAKTUR CAPITAL Q
      #x1D516	;MATHEMATICAL FRAKTUR CAPITAL S
      #x1D517	;MATHEMATICAL FRAKTUR CAPITAL T
      #x1D518	;MATHEMATICAL FRAKTUR CAPITAL U
      #x1D519	;MATHEMATICAL FRAKTUR CAPITAL V
      #x1D51A	;MATHEMATICAL FRAKTUR CAPITAL W
      #x1D51B	;MATHEMATICAL FRAKTUR CAPITAL X
      #x1D51C	;MATHEMATICAL FRAKTUR CAPITAL Y
      #x1D51E	;MATHEMATICAL FRAKTUR SMALL A
      #x1D51F	;MATHEMATICAL FRAKTUR SMALL B
      #x1D520	;MATHEMATICAL FRAKTUR SMALL C
      #x1D521	;MATHEMATICAL FRAKTUR SMALL D
      #x1D522	;MATHEMATICAL FRAKTUR SMALL E
      #x1D523	;MATHEMATICAL FRAKTUR SMALL F
      #x1D524	;MATHEMATICAL FRAKTUR SMALL G
      #x1D525	;MATHEMATICAL FRAKTUR SMALL H
      #x1D526	;MATHEMATICAL FRAKTUR SMALL I
      #x1D527	;MATHEMATICAL FRAKTUR SMALL J
      #x1D528	;MATHEMATICAL FRAKTUR SMALL K
      #x1D529	;MATHEMATICAL FRAKTUR SMALL L
      #x1D52A	;MATHEMATICAL FRAKTUR SMALL M
      #x1D52B	;MATHEMATICAL FRAKTUR SMALL N
      #x1D52C	;MATHEMATICAL FRAKTUR SMALL O
      #x1D52D	;MATHEMATICAL FRAKTUR SMALL P
      #x1D52E	;MATHEMATICAL FRAKTUR SMALL Q
      #x1D52F	;MATHEMATICAL FRAKTUR SMALL R
      #x1D530	;MATHEMATICAL FRAKTUR SMALL S
      #x1D531	;MATHEMATICAL FRAKTUR SMALL T
      #x1D532	;MATHEMATICAL FRAKTUR SMALL U
      #x1D533	;MATHEMATICAL FRAKTUR SMALL V
      #x1D534	;MATHEMATICAL FRAKTUR SMALL W
      #x1D535	;MATHEMATICAL FRAKTUR SMALL X
      #x1D536	;MATHEMATICAL FRAKTUR SMALL Y
      #x1D537	;MATHEMATICAL FRAKTUR SMALL Z
      #x1D538	;MATHEMATICAL DOUBLE-STRUCK CAPITAL A
      #x1D539	;MATHEMATICAL DOUBLE-STRUCK CAPITAL B
      #x1D53B	;MATHEMATICAL DOUBLE-STRUCK CAPITAL D
      #x1D53C	;MATHEMATICAL DOUBLE-STRUCK CAPITAL E
      #x1D53D	;MATHEMATICAL DOUBLE-STRUCK CAPITAL F
      #x1D53E	;MATHEMATICAL DOUBLE-STRUCK CAPITAL G
      #x1D540	;MATHEMATICAL DOUBLE-STRUCK CAPITAL I
      #x1D541	;MATHEMATICAL DOUBLE-STRUCK CAPITAL J
      #x1D542	;MATHEMATICAL DOUBLE-STRUCK CAPITAL K
      #x1D543	;MATHEMATICAL DOUBLE-STRUCK CAPITAL L
      #x1D544	;MATHEMATICAL DOUBLE-STRUCK CAPITAL M
      #x1D546	;MATHEMATICAL DOUBLE-STRUCK CAPITAL O
      #x1D54A	;MATHEMATICAL DOUBLE-STRUCK CAPITAL S
      #x1D54B	;MATHEMATICAL DOUBLE-STRUCK CAPITAL T
      #x1D54C	;MATHEMATICAL DOUBLE-STRUCK CAPITAL U
      #x1D54D	;MATHEMATICAL DOUBLE-STRUCK CAPITAL V
      #x1D54E	;MATHEMATICAL DOUBLE-STRUCK CAPITAL W
      #x1D54F	;MATHEMATICAL DOUBLE-STRUCK CAPITAL X
      #x1D550	;MATHEMATICAL DOUBLE-STRUCK CAPITAL Y
      #x1D552	;MATHEMATICAL DOUBLE-STRUCK SMALL A
      #x1D553	;MATHEMATICAL DOUBLE-STRUCK SMALL B
      #x1D554	;MATHEMATICAL DOUBLE-STRUCK SMALL C
      #x1D555	;MATHEMATICAL DOUBLE-STRUCK SMALL D
      #x1D556	;MATHEMATICAL DOUBLE-STRUCK SMALL E
      #x1D557	;MATHEMATICAL DOUBLE-STRUCK SMALL F
      #x1D558	;MATHEMATICAL DOUBLE-STRUCK SMALL G
      #x1D559	;MATHEMATICAL DOUBLE-STRUCK SMALL H
      #x1D55A	;MATHEMATICAL DOUBLE-STRUCK SMALL I
      #x1D55B	;MATHEMATICAL DOUBLE-STRUCK SMALL J
      #x1D55C	;MATHEMATICAL DOUBLE-STRUCK SMALL K
      #x1D55D	;MATHEMATICAL DOUBLE-STRUCK SMALL L
      #x1D55E	;MATHEMATICAL DOUBLE-STRUCK SMALL M
      #x1D55F	;MATHEMATICAL DOUBLE-STRUCK SMALL N
      #x1D560	;MATHEMATICAL DOUBLE-STRUCK SMALL O
      #x1D561	;MATHEMATICAL DOUBLE-STRUCK SMALL P
      #x1D562	;MATHEMATICAL DOUBLE-STRUCK SMALL Q
      #x1D563	;MATHEMATICAL DOUBLE-STRUCK SMALL R
      #x1D564	;MATHEMATICAL DOUBLE-STRUCK SMALL S
      #x1D565	;MATHEMATICAL DOUBLE-STRUCK SMALL T
      #x1D566	;MATHEMATICAL DOUBLE-STRUCK SMALL U
      #x1D567	;MATHEMATICAL DOUBLE-STRUCK SMALL V
      #x1D568	;MATHEMATICAL DOUBLE-STRUCK SMALL W
      #x1D569	;MATHEMATICAL DOUBLE-STRUCK SMALL X
      #x1D56A	;MATHEMATICAL DOUBLE-STRUCK SMALL Y
      #x1D56B	;MATHEMATICAL DOUBLE-STRUCK SMALL Z
      #x1D56C	;MATHEMATICAL BOLD FRAKTUR CAPITAL A
      #x1D56D	;MATHEMATICAL BOLD FRAKTUR CAPITAL B
      #x1D56E	;MATHEMATICAL BOLD FRAKTUR CAPITAL C
      #x1D56F	;MATHEMATICAL BOLD FRAKTUR CAPITAL D
      #x1D570	;MATHEMATICAL BOLD FRAKTUR CAPITAL E
      #x1D571	;MATHEMATICAL BOLD FRAKTUR CAPITAL F
      #x1D572	;MATHEMATICAL BOLD FRAKTUR CAPITAL G
      #x1D573	;MATHEMATICAL BOLD FRAKTUR CAPITAL H
      #x1D574	;MATHEMATICAL BOLD FRAKTUR CAPITAL I
      #x1D575	;MATHEMATICAL BOLD FRAKTUR CAPITAL J
      #x1D576	;MATHEMATICAL BOLD FRAKTUR CAPITAL K
      #x1D577	;MATHEMATICAL BOLD FRAKTUR CAPITAL L
      #x1D578	;MATHEMATICAL BOLD FRAKTUR CAPITAL M
      #x1D579	;MATHEMATICAL BOLD FRAKTUR CAPITAL N
      #x1D57A	;MATHEMATICAL BOLD FRAKTUR CAPITAL O
      #x1D57B	;MATHEMATICAL BOLD FRAKTUR CAPITAL P
      #x1D57C	;MATHEMATICAL BOLD FRAKTUR CAPITAL Q
      #x1D57D	;MATHEMATICAL BOLD FRAKTUR CAPITAL R
      #x1D57E	;MATHEMATICAL BOLD FRAKTUR CAPITAL S
      #x1D57F	;MATHEMATICAL BOLD FRAKTUR CAPITAL T
      #x1D580	;MATHEMATICAL BOLD FRAKTUR CAPITAL U
      #x1D581	;MATHEMATICAL BOLD FRAKTUR CAPITAL V
      #x1D582	;MATHEMATICAL BOLD FRAKTUR CAPITAL W
      #x1D583	;MATHEMATICAL BOLD FRAKTUR CAPITAL X
      #x1D584	;MATHEMATICAL BOLD FRAKTUR CAPITAL Y
      #x1D585	;MATHEMATICAL BOLD FRAKTUR CAPITAL Z
      #x1D586	;MATHEMATICAL BOLD FRAKTUR SMALL A
      #x1D587	;MATHEMATICAL BOLD FRAKTUR SMALL B
      #x1D588	;MATHEMATICAL BOLD FRAKTUR SMALL C
      #x1D589	;MATHEMATICAL BOLD FRAKTUR SMALL D
      #x1D58A	;MATHEMATICAL BOLD FRAKTUR SMALL E
      #x1D58B	;MATHEMATICAL BOLD FRAKTUR SMALL F
      #x1D58C	;MATHEMATICAL BOLD FRAKTUR SMALL G
      #x1D58D	;MATHEMATICAL BOLD FRAKTUR SMALL H
      #x1D58E	;MATHEMATICAL BOLD FRAKTUR SMALL I
      #x1D58F	;MATHEMATICAL BOLD FRAKTUR SMALL J
      #x1D590	;MATHEMATICAL BOLD FRAKTUR SMALL K
      #x1D591	;MATHEMATICAL BOLD FRAKTUR SMALL L
      #x1D592	;MATHEMATICAL BOLD FRAKTUR SMALL M
      #x1D593	;MATHEMATICAL BOLD FRAKTUR SMALL N
      #x1D594	;MATHEMATICAL BOLD FRAKTUR SMALL O
      #x1D595	;MATHEMATICAL BOLD FRAKTUR SMALL P
      #x1D596	;MATHEMATICAL BOLD FRAKTUR SMALL Q
      #x1D597	;MATHEMATICAL BOLD FRAKTUR SMALL R
      #x1D598	;MATHEMATICAL BOLD FRAKTUR SMALL S
      #x1D599	;MATHEMATICAL BOLD FRAKTUR SMALL T
      #x1D59A	;MATHEMATICAL BOLD FRAKTUR SMALL U
      #x1D59B	;MATHEMATICAL BOLD FRAKTUR SMALL V
      #x1D59C	;MATHEMATICAL BOLD FRAKTUR SMALL W
      #x1D59D	;MATHEMATICAL BOLD FRAKTUR SMALL X
      #x1D59E	;MATHEMATICAL BOLD FRAKTUR SMALL Y
      #x1D59F	;MATHEMATICAL BOLD FRAKTUR SMALL Z
      #x1D5A0	;MATHEMATICAL SANS-SERIF CAPITAL A
      #x1D5A1	;MATHEMATICAL SANS-SERIF CAPITAL B
      #x1D5A2	;MATHEMATICAL SANS-SERIF CAPITAL C
      #x1D5A3	;MATHEMATICAL SANS-SERIF CAPITAL D
      #x1D5A4	;MATHEMATICAL SANS-SERIF CAPITAL E
      #x1D5A5	;MATHEMATICAL SANS-SERIF CAPITAL F
      #x1D5A6	;MATHEMATICAL SANS-SERIF CAPITAL G
      #x1D5A7	;MATHEMATICAL SANS-SERIF CAPITAL H
      #x1D5A8	;MATHEMATICAL SANS-SERIF CAPITAL I
      #x1D5A9	;MATHEMATICAL SANS-SERIF CAPITAL J
      #x1D5AA	;MATHEMATICAL SANS-SERIF CAPITAL K
      #x1D5AB	;MATHEMATICAL SANS-SERIF CAPITAL L
      #x1D5AC	;MATHEMATICAL SANS-SERIF CAPITAL M
      #x1D5AD	;MATHEMATICAL SANS-SERIF CAPITAL N
      #x1D5AE	;MATHEMATICAL SANS-SERIF CAPITAL O
      #x1D5AF	;MATHEMATICAL SANS-SERIF CAPITAL P
      #x1D5B0	;MATHEMATICAL SANS-SERIF CAPITAL Q
      #x1D5B1	;MATHEMATICAL SANS-SERIF CAPITAL R
      #x1D5B2	;MATHEMATICAL SANS-SERIF CAPITAL S
      #x1D5B3	;MATHEMATICAL SANS-SERIF CAPITAL T
      #x1D5B4	;MATHEMATICAL SANS-SERIF CAPITAL U
      #x1D5B5	;MATHEMATICAL SANS-SERIF CAPITAL V
      #x1D5B6	;MATHEMATICAL SANS-SERIF CAPITAL W
      #x1D5B7	;MATHEMATICAL SANS-SERIF CAPITAL X
      #x1D5B8	;MATHEMATICAL SANS-SERIF CAPITAL Y
      #x1D5B9	;MATHEMATICAL SANS-SERIF CAPITAL Z
      #x1D5BA	;MATHEMATICAL SANS-SERIF SMALL A
      #x1D5BB	;MATHEMATICAL SANS-SERIF SMALL B
      #x1D5BC	;MATHEMATICAL SANS-SERIF SMALL C
      #x1D5BD	;MATHEMATICAL SANS-SERIF SMALL D
      #x1D5BE	;MATHEMATICAL SANS-SERIF SMALL E
      #x1D5BF	;MATHEMATICAL SANS-SERIF SMALL F
      #x1D5C0	;MATHEMATICAL SANS-SERIF SMALL G
      #x1D5C1	;MATHEMATICAL SANS-SERIF SMALL H
      #x1D5C2	;MATHEMATICAL SANS-SERIF SMALL I
      #x1D5C3	;MATHEMATICAL SANS-SERIF SMALL J
      #x1D5C4	;MATHEMATICAL SANS-SERIF SMALL K
      #x1D5C5	;MATHEMATICAL SANS-SERIF SMALL L
      #x1D5C6	;MATHEMATICAL SANS-SERIF SMALL M
      #x1D5C7	;MATHEMATICAL SANS-SERIF SMALL N
      #x1D5C8	;MATHEMATICAL SANS-SERIF SMALL O
      #x1D5C9	;MATHEMATICAL SANS-SERIF SMALL P
      #x1D5CA	;MATHEMATICAL SANS-SERIF SMALL Q
      #x1D5CB	;MATHEMATICAL SANS-SERIF SMALL R
      #x1D5CC	;MATHEMATICAL SANS-SERIF SMALL S
      #x1D5CD	;MATHEMATICAL SANS-SERIF SMALL T
      #x1D5CE	;MATHEMATICAL SANS-SERIF SMALL U
      #x1D5CF	;MATHEMATICAL SANS-SERIF SMALL V
      #x1D5D0	;MATHEMATICAL SANS-SERIF SMALL W
      #x1D5D1	;MATHEMATICAL SANS-SERIF SMALL X
      #x1D5D2	;MATHEMATICAL SANS-SERIF SMALL Y
      #x1D5D3	;MATHEMATICAL SANS-SERIF SMALL Z
      #x1D5D4	;MATHEMATICAL SANS-SERIF BOLD CAPITAL A
      #x1D5D5	;MATHEMATICAL SANS-SERIF BOLD CAPITAL B
      #x1D5D6	;MATHEMATICAL SANS-SERIF BOLD CAPITAL C
      #x1D5D7	;MATHEMATICAL SANS-SERIF BOLD CAPITAL D
      #x1D5D8	;MATHEMATICAL SANS-SERIF BOLD CAPITAL E
      #x1D5D9	;MATHEMATICAL SANS-SERIF BOLD CAPITAL F
      #x1D5DA	;MATHEMATICAL SANS-SERIF BOLD CAPITAL G
      #x1D5DB	;MATHEMATICAL SANS-SERIF BOLD CAPITAL H
      #x1D5DC	;MATHEMATICAL SANS-SERIF BOLD CAPITAL I
      #x1D5DD	;MATHEMATICAL SANS-SERIF BOLD CAPITAL J
      #x1D5DE	;MATHEMATICAL SANS-SERIF BOLD CAPITAL K
      #x1D5DF	;MATHEMATICAL SANS-SERIF BOLD CAPITAL L
      #x1D5E0	;MATHEMATICAL SANS-SERIF BOLD CAPITAL M
      #x1D5E1	;MATHEMATICAL SANS-SERIF BOLD CAPITAL N
      #x1D5E2	;MATHEMATICAL SANS-SERIF BOLD CAPITAL O
      #x1D5E3	;MATHEMATICAL SANS-SERIF BOLD CAPITAL P
      #x1D5E4	;MATHEMATICAL SANS-SERIF BOLD CAPITAL Q
      #x1D5E5	;MATHEMATICAL SANS-SERIF BOLD CAPITAL R
      #x1D5E6	;MATHEMATICAL SANS-SERIF BOLD CAPITAL S
      #x1D5E7	;MATHEMATICAL SANS-SERIF BOLD CAPITAL T
      #x1D5E8	;MATHEMATICAL SANS-SERIF BOLD CAPITAL U
      #x1D5E9	;MATHEMATICAL SANS-SERIF BOLD CAPITAL V
      #x1D5EA	;MATHEMATICAL SANS-SERIF BOLD CAPITAL W
      #x1D5EB	;MATHEMATICAL SANS-SERIF BOLD CAPITAL X
      #x1D5EC	;MATHEMATICAL SANS-SERIF BOLD CAPITAL Y
      #x1D5ED	;MATHEMATICAL SANS-SERIF BOLD CAPITAL Z
      #x1D5EE	;MATHEMATICAL SANS-SERIF BOLD SMALL A
      #x1D5EF	;MATHEMATICAL SANS-SERIF BOLD SMALL B
      #x1D5F0	;MATHEMATICAL SANS-SERIF BOLD SMALL C
      #x1D5F1	;MATHEMATICAL SANS-SERIF BOLD SMALL D
      #x1D5F2	;MATHEMATICAL SANS-SERIF BOLD SMALL E
      #x1D5F3	;MATHEMATICAL SANS-SERIF BOLD SMALL F
      #x1D5F4	;MATHEMATICAL SANS-SERIF BOLD SMALL G
      #x1D5F5	;MATHEMATICAL SANS-SERIF BOLD SMALL H
      #x1D5F6	;MATHEMATICAL SANS-SERIF BOLD SMALL I
      #x1D5F7	;MATHEMATICAL SANS-SERIF BOLD SMALL J
      #x1D5F8	;MATHEMATICAL SANS-SERIF BOLD SMALL K
      #x1D5F9	;MATHEMATICAL SANS-SERIF BOLD SMALL L
      #x1D5FA	;MATHEMATICAL SANS-SERIF BOLD SMALL M
      #x1D5FB	;MATHEMATICAL SANS-SERIF BOLD SMALL N
      #x1D5FC	;MATHEMATICAL SANS-SERIF BOLD SMALL O
      #x1D5FD	;MATHEMATICAL SANS-SERIF BOLD SMALL P
      #x1D5FE	;MATHEMATICAL SANS-SERIF BOLD SMALL Q
      #x1D5FF	;MATHEMATICAL SANS-SERIF BOLD SMALL R
      #x1D600	;MATHEMATICAL SANS-SERIF BOLD SMALL S
      #x1D601	;MATHEMATICAL SANS-SERIF BOLD SMALL T
      #x1D602	;MATHEMATICAL SANS-SERIF BOLD SMALL U
      #x1D603	;MATHEMATICAL SANS-SERIF BOLD SMALL V
      #x1D604	;MATHEMATICAL SANS-SERIF BOLD SMALL W
      #x1D605	;MATHEMATICAL SANS-SERIF BOLD SMALL X
      #x1D606	;MATHEMATICAL SANS-SERIF BOLD SMALL Y
      #x1D607	;MATHEMATICAL SANS-SERIF BOLD SMALL Z
      #x1D608	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL A
      #x1D609	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL B
      #x1D60A	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL C
      #x1D60B	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL D
      #x1D60C	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL E
      #x1D60D	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL F
      #x1D60E	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL G
      #x1D60F	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL H
      #x1D610	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL I
      #x1D611	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL J
      #x1D612	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL K
      #x1D613	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL L
      #x1D614	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL M
      #x1D615	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL N
      #x1D616	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL O
      #x1D617	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL P
      #x1D618	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL Q
      #x1D619	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL R
      #x1D61A	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL S
      #x1D61B	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL T
      #x1D61C	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL U
      #x1D61D	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL V
      #x1D61E	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL W
      #x1D61F	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL X
      #x1D620	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL Y
      #x1D621	;MATHEMATICAL SANS-SERIF ITALIC CAPITAL Z
      #x1D622	;MATHEMATICAL SANS-SERIF ITALIC SMALL A
      #x1D623	;MATHEMATICAL SANS-SERIF ITALIC SMALL B
      #x1D624	;MATHEMATICAL SANS-SERIF ITALIC SMALL C
      #x1D625	;MATHEMATICAL SANS-SERIF ITALIC SMALL D
      #x1D626	;MATHEMATICAL SANS-SERIF ITALIC SMALL E
      #x1D627	;MATHEMATICAL SANS-SERIF ITALIC SMALL F
      #x1D628	;MATHEMATICAL SANS-SERIF ITALIC SMALL G
      #x1D629	;MATHEMATICAL SANS-SERIF ITALIC SMALL H
      #x1D62A	;MATHEMATICAL SANS-SERIF ITALIC SMALL I
      #x1D62B	;MATHEMATICAL SANS-SERIF ITALIC SMALL J
      #x1D62C	;MATHEMATICAL SANS-SERIF ITALIC SMALL K
      #x1D62D	;MATHEMATICAL SANS-SERIF ITALIC SMALL L
      #x1D62E	;MATHEMATICAL SANS-SERIF ITALIC SMALL M
      #x1D62F	;MATHEMATICAL SANS-SERIF ITALIC SMALL N
      #x1D630	;MATHEMATICAL SANS-SERIF ITALIC SMALL O
      #x1D631	;MATHEMATICAL SANS-SERIF ITALIC SMALL P
      #x1D632	;MATHEMATICAL SANS-SERIF ITALIC SMALL Q
      #x1D633	;MATHEMATICAL SANS-SERIF ITALIC SMALL R
      #x1D634	;MATHEMATICAL SANS-SERIF ITALIC SMALL S
      #x1D635	;MATHEMATICAL SANS-SERIF ITALIC SMALL T
      #x1D636	;MATHEMATICAL SANS-SERIF ITALIC SMALL U
      #x1D637	;MATHEMATICAL SANS-SERIF ITALIC SMALL V
      #x1D638	;MATHEMATICAL SANS-SERIF ITALIC SMALL W
      #x1D639	;MATHEMATICAL SANS-SERIF ITALIC SMALL X
      #x1D63A	;MATHEMATICAL SANS-SERIF ITALIC SMALL Y
      #x1D63B	;MATHEMATICAL SANS-SERIF ITALIC SMALL Z
      #x1D63C	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL A
      #x1D63D	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL B
      #x1D63E	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL C
      #x1D63F	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL D
      #x1D640	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL E
      #x1D641	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL F
      #x1D642	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL G
      #x1D643	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL H
      #x1D644	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL I
      #x1D645	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL J
      #x1D646	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL K
      #x1D647	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL L
      #x1D648	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL M
      #x1D649	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL N
      #x1D64A	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL O
      #x1D64B	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL P
      #x1D64C	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Q
      #x1D64D	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL R
      #x1D64E	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL S
      #x1D64F	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL T
      #x1D650	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL U
      #x1D651	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL V
      #x1D652	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL W
      #x1D653	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL X
      #x1D654	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Y
      #x1D655	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL Z
      #x1D656	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL A
      #x1D657	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL B
      #x1D658	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL C
      #x1D659	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL D
      #x1D65A	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL E
      #x1D65B	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL F
      #x1D65C	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL G
      #x1D65D	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL H
      #x1D65E	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL I
      #x1D65F	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL J
      #x1D660	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL K
      #x1D661	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL L
      #x1D662	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL M
      #x1D663	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL N
      #x1D664	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL O
      #x1D665	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL P
      #x1D666	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Q
      #x1D667	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL R
      #x1D668	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL S
      #x1D669	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL T
      #x1D66A	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL U
      #x1D66B	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL V
      #x1D66C	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL W
      #x1D66D	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL X
      #x1D66E	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Y
      #x1D66F	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL Z
      #x1D670	;MATHEMATICAL MONOSPACE CAPITAL A
      #x1D671	;MATHEMATICAL MONOSPACE CAPITAL B
      #x1D672	;MATHEMATICAL MONOSPACE CAPITAL C
      #x1D673	;MATHEMATICAL MONOSPACE CAPITAL D
      #x1D674	;MATHEMATICAL MONOSPACE CAPITAL E
      #x1D675	;MATHEMATICAL MONOSPACE CAPITAL F
      #x1D676	;MATHEMATICAL MONOSPACE CAPITAL G
      #x1D677	;MATHEMATICAL MONOSPACE CAPITAL H
      #x1D678	;MATHEMATICAL MONOSPACE CAPITAL I
      #x1D679	;MATHEMATICAL MONOSPACE CAPITAL J
      #x1D67A	;MATHEMATICAL MONOSPACE CAPITAL K
      #x1D67B	;MATHEMATICAL MONOSPACE CAPITAL L
      #x1D67C	;MATHEMATICAL MONOSPACE CAPITAL M
      #x1D67D	;MATHEMATICAL MONOSPACE CAPITAL N
      #x1D67E	;MATHEMATICAL MONOSPACE CAPITAL O
      #x1D67F	;MATHEMATICAL MONOSPACE CAPITAL P
      #x1D680	;MATHEMATICAL MONOSPACE CAPITAL Q
      #x1D681	;MATHEMATICAL MONOSPACE CAPITAL R
      #x1D682	;MATHEMATICAL MONOSPACE CAPITAL S
      #x1D683	;MATHEMATICAL MONOSPACE CAPITAL T
      #x1D684	;MATHEMATICAL MONOSPACE CAPITAL U
      #x1D685	;MATHEMATICAL MONOSPACE CAPITAL V
      #x1D686	;MATHEMATICAL MONOSPACE CAPITAL W
      #x1D687	;MATHEMATICAL MONOSPACE CAPITAL X
      #x1D688	;MATHEMATICAL MONOSPACE CAPITAL Y
      #x1D689	;MATHEMATICAL MONOSPACE CAPITAL Z
      #x1D68A	;MATHEMATICAL MONOSPACE SMALL A
      #x1D68B	;MATHEMATICAL MONOSPACE SMALL B
      #x1D68C	;MATHEMATICAL MONOSPACE SMALL C
      #x1D68D	;MATHEMATICAL MONOSPACE SMALL D
      #x1D68E	;MATHEMATICAL MONOSPACE SMALL E
      #x1D68F	;MATHEMATICAL MONOSPACE SMALL F
      #x1D690	;MATHEMATICAL MONOSPACE SMALL G
      #x1D691	;MATHEMATICAL MONOSPACE SMALL H
      #x1D692	;MATHEMATICAL MONOSPACE SMALL I
      #x1D693	;MATHEMATICAL MONOSPACE SMALL J
      #x1D694	;MATHEMATICAL MONOSPACE SMALL K
      #x1D695	;MATHEMATICAL MONOSPACE SMALL L
      #x1D696	;MATHEMATICAL MONOSPACE SMALL M
      #x1D697	;MATHEMATICAL MONOSPACE SMALL N
      #x1D698	;MATHEMATICAL MONOSPACE SMALL O
      #x1D699	;MATHEMATICAL MONOSPACE SMALL P
      #x1D69A	;MATHEMATICAL MONOSPACE SMALL Q
      #x1D69B	;MATHEMATICAL MONOSPACE SMALL R
      #x1D69C	;MATHEMATICAL MONOSPACE SMALL S
      #x1D69D	;MATHEMATICAL MONOSPACE SMALL T
      #x1D69E	;MATHEMATICAL MONOSPACE SMALL U
      #x1D69F	;MATHEMATICAL MONOSPACE SMALL V
      #x1D6A0	;MATHEMATICAL MONOSPACE SMALL W
      #x1D6A1	;MATHEMATICAL MONOSPACE SMALL X
      #x1D6A2	;MATHEMATICAL MONOSPACE SMALL Y
      #x1D6A3	;MATHEMATICAL MONOSPACE SMALL Z
      #x1D6A8	;MATHEMATICAL BOLD CAPITAL ALPHA
      #x1D6A9	;MATHEMATICAL BOLD CAPITAL BETA
      #x1D6AA	;MATHEMATICAL BOLD CAPITAL GAMMA
      #x1D6AB	;MATHEMATICAL BOLD CAPITAL DELTA
      #x1D6AC	;MATHEMATICAL BOLD CAPITAL EPSILON
      #x1D6AD	;MATHEMATICAL BOLD CAPITAL ZETA
      #x1D6AE	;MATHEMATICAL BOLD CAPITAL ETA
      #x1D6AF	;MATHEMATICAL BOLD CAPITAL THETA
      #x1D6B0	;MATHEMATICAL BOLD CAPITAL IOTA
      #x1D6B1	;MATHEMATICAL BOLD CAPITAL KAPPA
      #x1D6B2	;MATHEMATICAL BOLD CAPITAL LAMDA
      #x1D6B3	;MATHEMATICAL BOLD CAPITAL MU
      #x1D6B4	;MATHEMATICAL BOLD CAPITAL NU
      #x1D6B5	;MATHEMATICAL BOLD CAPITAL XI
      #x1D6B6	;MATHEMATICAL BOLD CAPITAL OMICRON
      #x1D6B7	;MATHEMATICAL BOLD CAPITAL PI
      #x1D6B8	;MATHEMATICAL BOLD CAPITAL RHO
      #x1D6B9	;MATHEMATICAL BOLD CAPITAL THETA SYMBOL
      #x1D6BA	;MATHEMATICAL BOLD CAPITAL SIGMA
      #x1D6BB	;MATHEMATICAL BOLD CAPITAL TAU
      #x1D6BC	;MATHEMATICAL BOLD CAPITAL UPSILON
      #x1D6BD	;MATHEMATICAL BOLD CAPITAL PHI
      #x1D6BE	;MATHEMATICAL BOLD CAPITAL CHI
      #x1D6BF	;MATHEMATICAL BOLD CAPITAL PSI
      #x1D6C0	;MATHEMATICAL BOLD CAPITAL OMEGA
      #x1D6C2	;MATHEMATICAL BOLD SMALL ALPHA
      #x1D6C3	;MATHEMATICAL BOLD SMALL BETA
      #x1D6C4	;MATHEMATICAL BOLD SMALL GAMMA
      #x1D6C5	;MATHEMATICAL BOLD SMALL DELTA
      #x1D6C6	;MATHEMATICAL BOLD SMALL EPSILON
      #x1D6C7	;MATHEMATICAL BOLD SMALL ZETA
      #x1D6C8	;MATHEMATICAL BOLD SMALL ETA
      #x1D6C9	;MATHEMATICAL BOLD SMALL THETA
      #x1D6CA	;MATHEMATICAL BOLD SMALL IOTA
      #x1D6CB	;MATHEMATICAL BOLD SMALL KAPPA
      #x1D6CC	;MATHEMATICAL BOLD SMALL LAMDA
      #x1D6CD	;MATHEMATICAL BOLD SMALL MU
      #x1D6CE	;MATHEMATICAL BOLD SMALL NU
      #x1D6CF	;MATHEMATICAL BOLD SMALL XI
      #x1D6D0	;MATHEMATICAL BOLD SMALL OMICRON
      #x1D6D1	;MATHEMATICAL BOLD SMALL PI
      #x1D6D2	;MATHEMATICAL BOLD SMALL RHO
      #x1D6D3	;MATHEMATICAL BOLD SMALL FINAL SIGMA
      #x1D6D4	;MATHEMATICAL BOLD SMALL SIGMA
      #x1D6D5	;MATHEMATICAL BOLD SMALL TAU
      #x1D6D6	;MATHEMATICAL BOLD SMALL UPSILON
      #x1D6D7	;MATHEMATICAL BOLD SMALL PHI
      #x1D6D8	;MATHEMATICAL BOLD SMALL CHI
      #x1D6D9	;MATHEMATICAL BOLD SMALL PSI
      #x1D6DA	;MATHEMATICAL BOLD SMALL OMEGA
      #x1D6DC	;MATHEMATICAL BOLD EPSILON SYMBOL
      #x1D6DD	;MATHEMATICAL BOLD THETA SYMBOL
      #x1D6DE	;MATHEMATICAL BOLD KAPPA SYMBOL
      #x1D6DF	;MATHEMATICAL BOLD PHI SYMBOL
      #x1D6E0	;MATHEMATICAL BOLD RHO SYMBOL
      #x1D6E1	;MATHEMATICAL BOLD PI SYMBOL
      #x1D6E2	;MATHEMATICAL ITALIC CAPITAL ALPHA
      #x1D6E3	;MATHEMATICAL ITALIC CAPITAL BETA
      #x1D6E4	;MATHEMATICAL ITALIC CAPITAL GAMMA
      #x1D6E5	;MATHEMATICAL ITALIC CAPITAL DELTA
      #x1D6E6	;MATHEMATICAL ITALIC CAPITAL EPSILON
      #x1D6E7	;MATHEMATICAL ITALIC CAPITAL ZETA
      #x1D6E8	;MATHEMATICAL ITALIC CAPITAL ETA
      #x1D6E9	;MATHEMATICAL ITALIC CAPITAL THETA
      #x1D6EA	;MATHEMATICAL ITALIC CAPITAL IOTA
      #x1D6EB	;MATHEMATICAL ITALIC CAPITAL KAPPA
      #x1D6EC	;MATHEMATICAL ITALIC CAPITAL LAMDA
      #x1D6ED	;MATHEMATICAL ITALIC CAPITAL MU
      #x1D6EE	;MATHEMATICAL ITALIC CAPITAL NU
      #x1D6EF	;MATHEMATICAL ITALIC CAPITAL XI
      #x1D6F0	;MATHEMATICAL ITALIC CAPITAL OMICRON
      #x1D6F1	;MATHEMATICAL ITALIC CAPITAL PI
      #x1D6F2	;MATHEMATICAL ITALIC CAPITAL RHO
      #x1D6F3	;MATHEMATICAL ITALIC CAPITAL THETA SYMBOL
      #x1D6F4	;MATHEMATICAL ITALIC CAPITAL SIGMA
      #x1D6F5	;MATHEMATICAL ITALIC CAPITAL TAU
      #x1D6F6	;MATHEMATICAL ITALIC CAPITAL UPSILON
      #x1D6F7	;MATHEMATICAL ITALIC CAPITAL PHI
      #x1D6F8	;MATHEMATICAL ITALIC CAPITAL CHI
      #x1D6F9	;MATHEMATICAL ITALIC CAPITAL PSI
      #x1D6FA	;MATHEMATICAL ITALIC CAPITAL OMEGA
      #x1D6FC	;MATHEMATICAL ITALIC SMALL ALPHA
      #x1D6FD	;MATHEMATICAL ITALIC SMALL BETA
      #x1D6FE	;MATHEMATICAL ITALIC SMALL GAMMA
      #x1D6FF	;MATHEMATICAL ITALIC SMALL DELTA
      #x1D700	;MATHEMATICAL ITALIC SMALL EPSILON
      #x1D701	;MATHEMATICAL ITALIC SMALL ZETA
      #x1D702	;MATHEMATICAL ITALIC SMALL ETA
      #x1D703	;MATHEMATICAL ITALIC SMALL THETA
      #x1D704	;MATHEMATICAL ITALIC SMALL IOTA
      #x1D705	;MATHEMATICAL ITALIC SMALL KAPPA
      #x1D706	;MATHEMATICAL ITALIC SMALL LAMDA
      #x1D707	;MATHEMATICAL ITALIC SMALL MU
      #x1D708	;MATHEMATICAL ITALIC SMALL NU
      #x1D709	;MATHEMATICAL ITALIC SMALL XI
      #x1D70A	;MATHEMATICAL ITALIC SMALL OMICRON
      #x1D70B	;MATHEMATICAL ITALIC SMALL PI
      #x1D70C	;MATHEMATICAL ITALIC SMALL RHO
      #x1D70D	;MATHEMATICAL ITALIC SMALL FINAL SIGMA
      #x1D70E	;MATHEMATICAL ITALIC SMALL SIGMA
      #x1D70F	;MATHEMATICAL ITALIC SMALL TAU
      #x1D710	;MATHEMATICAL ITALIC SMALL UPSILON
      #x1D711	;MATHEMATICAL ITALIC SMALL PHI
      #x1D712	;MATHEMATICAL ITALIC SMALL CHI
      #x1D713	;MATHEMATICAL ITALIC SMALL PSI
      #x1D714	;MATHEMATICAL ITALIC SMALL OMEGA
      #x1D716	;MATHEMATICAL ITALIC EPSILON SYMBOL
      #x1D717	;MATHEMATICAL ITALIC THETA SYMBOL
      #x1D718	;MATHEMATICAL ITALIC KAPPA SYMBOL
      #x1D719	;MATHEMATICAL ITALIC PHI SYMBOL
      #x1D71A	;MATHEMATICAL ITALIC RHO SYMBOL
      #x1D71B	;MATHEMATICAL ITALIC PI SYMBOL
      #x1D71C	;MATHEMATICAL BOLD ITALIC CAPITAL ALPHA
      #x1D71D	;MATHEMATICAL BOLD ITALIC CAPITAL BETA
      #x1D71E	;MATHEMATICAL BOLD ITALIC CAPITAL GAMMA
      #x1D71F	;MATHEMATICAL BOLD ITALIC CAPITAL DELTA
      #x1D720	;MATHEMATICAL BOLD ITALIC CAPITAL EPSILON
      #x1D721	;MATHEMATICAL BOLD ITALIC CAPITAL ZETA
      #x1D722	;MATHEMATICAL BOLD ITALIC CAPITAL ETA
      #x1D723	;MATHEMATICAL BOLD ITALIC CAPITAL THETA
      #x1D724	;MATHEMATICAL BOLD ITALIC CAPITAL IOTA
      #x1D725	;MATHEMATICAL BOLD ITALIC CAPITAL KAPPA
      #x1D726	;MATHEMATICAL BOLD ITALIC CAPITAL LAMDA
      #x1D727	;MATHEMATICAL BOLD ITALIC CAPITAL MU
      #x1D728	;MATHEMATICAL BOLD ITALIC CAPITAL NU
      #x1D729	;MATHEMATICAL BOLD ITALIC CAPITAL XI
      #x1D72A	;MATHEMATICAL BOLD ITALIC CAPITAL OMICRON
      #x1D72B	;MATHEMATICAL BOLD ITALIC CAPITAL PI
      #x1D72C	;MATHEMATICAL BOLD ITALIC CAPITAL RHO
      #x1D72D	;MATHEMATICAL BOLD ITALIC CAPITAL THETA SYMBOL
      #x1D72E	;MATHEMATICAL BOLD ITALIC CAPITAL SIGMA
      #x1D72F	;MATHEMATICAL BOLD ITALIC CAPITAL TAU
      #x1D730	;MATHEMATICAL BOLD ITALIC CAPITAL UPSILON
      #x1D731	;MATHEMATICAL BOLD ITALIC CAPITAL PHI
      #x1D732	;MATHEMATICAL BOLD ITALIC CAPITAL CHI
      #x1D733	;MATHEMATICAL BOLD ITALIC CAPITAL PSI
      #x1D734	;MATHEMATICAL BOLD ITALIC CAPITAL OMEGA
      #x1D736	;MATHEMATICAL BOLD ITALIC SMALL ALPHA
      #x1D737	;MATHEMATICAL BOLD ITALIC SMALL BETA
      #x1D738	;MATHEMATICAL BOLD ITALIC SMALL GAMMA
      #x1D739	;MATHEMATICAL BOLD ITALIC SMALL DELTA
      #x1D73A	;MATHEMATICAL BOLD ITALIC SMALL EPSILON
      #x1D73B	;MATHEMATICAL BOLD ITALIC SMALL ZETA
      #x1D73C	;MATHEMATICAL BOLD ITALIC SMALL ETA
      #x1D73D	;MATHEMATICAL BOLD ITALIC SMALL THETA
      #x1D73E	;MATHEMATICAL BOLD ITALIC SMALL IOTA
      #x1D73F	;MATHEMATICAL BOLD ITALIC SMALL KAPPA
      #x1D740	;MATHEMATICAL BOLD ITALIC SMALL LAMDA
      #x1D741	;MATHEMATICAL BOLD ITALIC SMALL MU
      #x1D742	;MATHEMATICAL BOLD ITALIC SMALL NU
      #x1D743	;MATHEMATICAL BOLD ITALIC SMALL XI
      #x1D744	;MATHEMATICAL BOLD ITALIC SMALL OMICRON
      #x1D745	;MATHEMATICAL BOLD ITALIC SMALL PI
      #x1D746	;MATHEMATICAL BOLD ITALIC SMALL RHO
      #x1D747	;MATHEMATICAL BOLD ITALIC SMALL FINAL SIGMA
      #x1D748	;MATHEMATICAL BOLD ITALIC SMALL SIGMA
      #x1D749	;MATHEMATICAL BOLD ITALIC SMALL TAU
      #x1D74A	;MATHEMATICAL BOLD ITALIC SMALL UPSILON
      #x1D74B	;MATHEMATICAL BOLD ITALIC SMALL PHI
      #x1D74C	;MATHEMATICAL BOLD ITALIC SMALL CHI
      #x1D74D	;MATHEMATICAL BOLD ITALIC SMALL PSI
      #x1D74E	;MATHEMATICAL BOLD ITALIC SMALL OMEGA
      #x1D750	;MATHEMATICAL BOLD ITALIC EPSILON SYMBOL
      #x1D751	;MATHEMATICAL BOLD ITALIC THETA SYMBOL
      #x1D752	;MATHEMATICAL BOLD ITALIC KAPPA SYMBOL
      #x1D753	;MATHEMATICAL BOLD ITALIC PHI SYMBOL
      #x1D754	;MATHEMATICAL BOLD ITALIC RHO SYMBOL
      #x1D755	;MATHEMATICAL BOLD ITALIC PI SYMBOL
      #x1D756	;MATHEMATICAL SANS-SERIF BOLD CAPITAL ALPHA
      #x1D757	;MATHEMATICAL SANS-SERIF BOLD CAPITAL BETA
      #x1D758	;MATHEMATICAL SANS-SERIF BOLD CAPITAL GAMMA
      #x1D759	;MATHEMATICAL SANS-SERIF BOLD CAPITAL DELTA
      #x1D75A	;MATHEMATICAL SANS-SERIF BOLD CAPITAL EPSILON
      #x1D75B	;MATHEMATICAL SANS-SERIF BOLD CAPITAL ZETA
      #x1D75C	;MATHEMATICAL SANS-SERIF BOLD CAPITAL ETA
      #x1D75D	;MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA
      #x1D75E	;MATHEMATICAL SANS-SERIF BOLD CAPITAL IOTA
      #x1D75F	;MATHEMATICAL SANS-SERIF BOLD CAPITAL KAPPA
      #x1D760	;MATHEMATICAL SANS-SERIF BOLD CAPITAL LAMDA
      #x1D761	;MATHEMATICAL SANS-SERIF BOLD CAPITAL MU
      #x1D762	;MATHEMATICAL SANS-SERIF BOLD CAPITAL NU
      #x1D763	;MATHEMATICAL SANS-SERIF BOLD CAPITAL XI
      #x1D764	;MATHEMATICAL SANS-SERIF BOLD CAPITAL OMICRON
      #x1D765	;MATHEMATICAL SANS-SERIF BOLD CAPITAL PI
      #x1D766	;MATHEMATICAL SANS-SERIF BOLD CAPITAL RHO
      #x1D767	;MATHEMATICAL SANS-SERIF BOLD CAPITAL THETA SYMBOL
      #x1D768	;MATHEMATICAL SANS-SERIF BOLD CAPITAL SIGMA
      #x1D769	;MATHEMATICAL SANS-SERIF BOLD CAPITAL TAU
      #x1D76A	;MATHEMATICAL SANS-SERIF BOLD CAPITAL UPSILON
      #x1D76B	;MATHEMATICAL SANS-SERIF BOLD CAPITAL PHI
      #x1D76C	;MATHEMATICAL SANS-SERIF BOLD CAPITAL CHI
      #x1D76D	;MATHEMATICAL SANS-SERIF BOLD CAPITAL PSI
      #x1D76E	;MATHEMATICAL SANS-SERIF BOLD CAPITAL OMEGA
      #x1D770	;MATHEMATICAL SANS-SERIF BOLD SMALL ALPHA
      #x1D771	;MATHEMATICAL SANS-SERIF BOLD SMALL BETA
      #x1D772	;MATHEMATICAL SANS-SERIF BOLD SMALL GAMMA
      #x1D773	;MATHEMATICAL SANS-SERIF BOLD SMALL DELTA
      #x1D774	;MATHEMATICAL SANS-SERIF BOLD SMALL EPSILON
      #x1D775	;MATHEMATICAL SANS-SERIF BOLD SMALL ZETA
      #x1D776	;MATHEMATICAL SANS-SERIF BOLD SMALL ETA
      #x1D777	;MATHEMATICAL SANS-SERIF BOLD SMALL THETA
      #x1D778	;MATHEMATICAL SANS-SERIF BOLD SMALL IOTA
      #x1D779	;MATHEMATICAL SANS-SERIF BOLD SMALL KAPPA
      #x1D77A	;MATHEMATICAL SANS-SERIF BOLD SMALL LAMDA
      #x1D77B	;MATHEMATICAL SANS-SERIF BOLD SMALL MU
      #x1D77C	;MATHEMATICAL SANS-SERIF BOLD SMALL NU
      #x1D77D	;MATHEMATICAL SANS-SERIF BOLD SMALL XI
      #x1D77E	;MATHEMATICAL SANS-SERIF BOLD SMALL OMICRON
      #x1D77F	;MATHEMATICAL SANS-SERIF BOLD SMALL PI
      #x1D780	;MATHEMATICAL SANS-SERIF BOLD SMALL RHO
      #x1D781	;MATHEMATICAL SANS-SERIF BOLD SMALL FINAL SIGMA
      #x1D782	;MATHEMATICAL SANS-SERIF BOLD SMALL SIGMA
      #x1D783	;MATHEMATICAL SANS-SERIF BOLD SMALL TAU
      #x1D784	;MATHEMATICAL SANS-SERIF BOLD SMALL UPSILON
      #x1D785	;MATHEMATICAL SANS-SERIF BOLD SMALL PHI
      #x1D786	;MATHEMATICAL SANS-SERIF BOLD SMALL CHI
      #x1D787	;MATHEMATICAL SANS-SERIF BOLD SMALL PSI
      #x1D788	;MATHEMATICAL SANS-SERIF BOLD SMALL OMEGA
      #x1D78A	;MATHEMATICAL SANS-SERIF BOLD EPSILON SYMBOL
      #x1D78B	;MATHEMATICAL SANS-SERIF BOLD THETA SYMBOL
      #x1D78C	;MATHEMATICAL SANS-SERIF BOLD KAPPA SYMBOL
      #x1D78D	;MATHEMATICAL SANS-SERIF BOLD PHI SYMBOL
      #x1D78E	;MATHEMATICAL SANS-SERIF BOLD RHO SYMBOL
      #x1D78F	;MATHEMATICAL SANS-SERIF BOLD PI SYMBOL
      #x1D790	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ALPHA
      #x1D791	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL BETA
      #x1D792	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL GAMMA
      #x1D793	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL DELTA
      #x1D794	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL EPSILON
      #x1D795	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ZETA
      #x1D796	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL ETA
      #x1D797	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA
      #x1D798	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL IOTA
      #x1D799	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL KAPPA
      #x1D79A	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL LAMDA
      #x1D79B	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL MU
      #x1D79C	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL NU
      #x1D79D	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL XI
      #x1D79E	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMICRON
      #x1D79F	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PI
      #x1D7A0	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL RHO
      #x1D7A1	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL THETA SYMBOL
      #x1D7A2	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL SIGMA
      #x1D7A3	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL TAU
      #x1D7A4	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL UPSILON
      #x1D7A5	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PHI
      #x1D7A6	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL CHI
      #x1D7A7	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL PSI
      #x1D7A8	;MATHEMATICAL SANS-SERIF BOLD ITALIC CAPITAL OMEGA
      #x1D7AA	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ALPHA
      #x1D7AB	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL BETA
      #x1D7AC	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL GAMMA
      #x1D7AD	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL DELTA
      #x1D7AE	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL EPSILON
      #x1D7AF	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ZETA
      #x1D7B0	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL ETA
      #x1D7B1	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL THETA
      #x1D7B2	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL IOTA
      #x1D7B3	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL KAPPA
      #x1D7B4	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL LAMDA
      #x1D7B5	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL MU
      #x1D7B6	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL NU
      #x1D7B7	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL XI
      #x1D7B8	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMICRON
      #x1D7B9	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PI
      #x1D7BA	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL RHO
      #x1D7BB	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL FINAL SIGMA
      #x1D7BC	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL SIGMA
      #x1D7BD	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL TAU
      #x1D7BE	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL UPSILON
      #x1D7BF	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PHI
      #x1D7C0	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL CHI
      #x1D7C1	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL PSI
      #x1D7C2	;MATHEMATICAL SANS-SERIF BOLD ITALIC SMALL OMEGA
      #x1D7C4	;MATHEMATICAL SANS-SERIF BOLD ITALIC EPSILON SYMBOL
      #x1D7C5	;MATHEMATICAL SANS-SERIF BOLD ITALIC THETA SYMBOL
      #x1D7C6	;MATHEMATICAL SANS-SERIF BOLD ITALIC KAPPA SYMBOL
      #x1D7C7	;MATHEMATICAL SANS-SERIF BOLD ITALIC PHI SYMBOL
      #x1D7C8	;MATHEMATICAL SANS-SERIF BOLD ITALIC RHO SYMBOL
      #x1D7C9	;MATHEMATICAL SANS-SERIF BOLD ITALIC PI SYMBOL
      #x20000	;<CJK Ideograph Extension B, First>
      #x2A6D6	;<CJK Ideograph Extension B, Last>
      #x2F800	;CJK COMPATIBILITY IDEOGRAPH-2F800
      #x2F801	;CJK COMPATIBILITY IDEOGRAPH-2F801
      #x2F802	;CJK COMPATIBILITY IDEOGRAPH-2F802
      #x2F803	;CJK COMPATIBILITY IDEOGRAPH-2F803
      #x2F804	;CJK COMPATIBILITY IDEOGRAPH-2F804
      #x2F805	;CJK COMPATIBILITY IDEOGRAPH-2F805
      #x2F806	;CJK COMPATIBILITY IDEOGRAPH-2F806
      #x2F807	;CJK COMPATIBILITY IDEOGRAPH-2F807
      #x2F808	;CJK COMPATIBILITY IDEOGRAPH-2F808
      #x2F809	;CJK COMPATIBILITY IDEOGRAPH-2F809
      #x2F80A	;CJK COMPATIBILITY IDEOGRAPH-2F80A
      #x2F80B	;CJK COMPATIBILITY IDEOGRAPH-2F80B
      #x2F80C	;CJK COMPATIBILITY IDEOGRAPH-2F80C
      #x2F80D	;CJK COMPATIBILITY IDEOGRAPH-2F80D
      #x2F80E	;CJK COMPATIBILITY IDEOGRAPH-2F80E
      #x2F80F	;CJK COMPATIBILITY IDEOGRAPH-2F80F
      #x2F810	;CJK COMPATIBILITY IDEOGRAPH-2F810
      #x2F811	;CJK COMPATIBILITY IDEOGRAPH-2F811
      #x2F812	;CJK COMPATIBILITY IDEOGRAPH-2F812
      #x2F813	;CJK COMPATIBILITY IDEOGRAPH-2F813
      #x2F814	;CJK COMPATIBILITY IDEOGRAPH-2F814
      #x2F815	;CJK COMPATIBILITY IDEOGRAPH-2F815
      #x2F816	;CJK COMPATIBILITY IDEOGRAPH-2F816
      #x2F817	;CJK COMPATIBILITY IDEOGRAPH-2F817
      #x2F818	;CJK COMPATIBILITY IDEOGRAPH-2F818
      #x2F819	;CJK COMPATIBILITY IDEOGRAPH-2F819
      #x2F81A	;CJK COMPATIBILITY IDEOGRAPH-2F81A
      #x2F81B	;CJK COMPATIBILITY IDEOGRAPH-2F81B
      #x2F81C	;CJK COMPATIBILITY IDEOGRAPH-2F81C
      #x2F81D	;CJK COMPATIBILITY IDEOGRAPH-2F81D
      #x2F81E	;CJK COMPATIBILITY IDEOGRAPH-2F81E
      #x2F81F	;CJK COMPATIBILITY IDEOGRAPH-2F81F
      #x2F820	;CJK COMPATIBILITY IDEOGRAPH-2F820
      #x2F821	;CJK COMPATIBILITY IDEOGRAPH-2F821
      #x2F822	;CJK COMPATIBILITY IDEOGRAPH-2F822
      #x2F823	;CJK COMPATIBILITY IDEOGRAPH-2F823
      #x2F824	;CJK COMPATIBILITY IDEOGRAPH-2F824
      #x2F825	;CJK COMPATIBILITY IDEOGRAPH-2F825
      #x2F826	;CJK COMPATIBILITY IDEOGRAPH-2F826
      #x2F827	;CJK COMPATIBILITY IDEOGRAPH-2F827
      #x2F828	;CJK COMPATIBILITY IDEOGRAPH-2F828
      #x2F829	;CJK COMPATIBILITY IDEOGRAPH-2F829
      #x2F82A	;CJK COMPATIBILITY IDEOGRAPH-2F82A
      #x2F82B	;CJK COMPATIBILITY IDEOGRAPH-2F82B
      #x2F82C	;CJK COMPATIBILITY IDEOGRAPH-2F82C
      #x2F82D	;CJK COMPATIBILITY IDEOGRAPH-2F82D
      #x2F82E	;CJK COMPATIBILITY IDEOGRAPH-2F82E
      #x2F82F	;CJK COMPATIBILITY IDEOGRAPH-2F82F
      #x2F830	;CJK COMPATIBILITY IDEOGRAPH-2F830
      #x2F831	;CJK COMPATIBILITY IDEOGRAPH-2F831
      #x2F832	;CJK COMPATIBILITY IDEOGRAPH-2F832
      #x2F833	;CJK COMPATIBILITY IDEOGRAPH-2F833
      #x2F834	;CJK COMPATIBILITY IDEOGRAPH-2F834
      #x2F835	;CJK COMPATIBILITY IDEOGRAPH-2F835
      #x2F836	;CJK COMPATIBILITY IDEOGRAPH-2F836
      #x2F837	;CJK COMPATIBILITY IDEOGRAPH-2F837
      #x2F838	;CJK COMPATIBILITY IDEOGRAPH-2F838
      #x2F839	;CJK COMPATIBILITY IDEOGRAPH-2F839
      #x2F83A	;CJK COMPATIBILITY IDEOGRAPH-2F83A
      #x2F83B	;CJK COMPATIBILITY IDEOGRAPH-2F83B
      #x2F83C	;CJK COMPATIBILITY IDEOGRAPH-2F83C
      #x2F83D	;CJK COMPATIBILITY IDEOGRAPH-2F83D
      #x2F83E	;CJK COMPATIBILITY IDEOGRAPH-2F83E
      #x2F83F	;CJK COMPATIBILITY IDEOGRAPH-2F83F
      #x2F840	;CJK COMPATIBILITY IDEOGRAPH-2F840
      #x2F841	;CJK COMPATIBILITY IDEOGRAPH-2F841
      #x2F842	;CJK COMPATIBILITY IDEOGRAPH-2F842
      #x2F843	;CJK COMPATIBILITY IDEOGRAPH-2F843
      #x2F844	;CJK COMPATIBILITY IDEOGRAPH-2F844
      #x2F845	;CJK COMPATIBILITY IDEOGRAPH-2F845
      #x2F846	;CJK COMPATIBILITY IDEOGRAPH-2F846
      #x2F847	;CJK COMPATIBILITY IDEOGRAPH-2F847
      #x2F848	;CJK COMPATIBILITY IDEOGRAPH-2F848
      #x2F849	;CJK COMPATIBILITY IDEOGRAPH-2F849
      #x2F84A	;CJK COMPATIBILITY IDEOGRAPH-2F84A
      #x2F84B	;CJK COMPATIBILITY IDEOGRAPH-2F84B
      #x2F84C	;CJK COMPATIBILITY IDEOGRAPH-2F84C
      #x2F84D	;CJK COMPATIBILITY IDEOGRAPH-2F84D
      #x2F84E	;CJK COMPATIBILITY IDEOGRAPH-2F84E
      #x2F84F	;CJK COMPATIBILITY IDEOGRAPH-2F84F
      #x2F850	;CJK COMPATIBILITY IDEOGRAPH-2F850
      #x2F851	;CJK COMPATIBILITY IDEOGRAPH-2F851
      #x2F852	;CJK COMPATIBILITY IDEOGRAPH-2F852
      #x2F853	;CJK COMPATIBILITY IDEOGRAPH-2F853
      #x2F854	;CJK COMPATIBILITY IDEOGRAPH-2F854
      #x2F855	;CJK COMPATIBILITY IDEOGRAPH-2F855
      #x2F856	;CJK COMPATIBILITY IDEOGRAPH-2F856
      #x2F857	;CJK COMPATIBILITY IDEOGRAPH-2F857
      #x2F858	;CJK COMPATIBILITY IDEOGRAPH-2F858
      #x2F859	;CJK COMPATIBILITY IDEOGRAPH-2F859
      #x2F85A	;CJK COMPATIBILITY IDEOGRAPH-2F85A
      #x2F85B	;CJK COMPATIBILITY IDEOGRAPH-2F85B
      #x2F85C	;CJK COMPATIBILITY IDEOGRAPH-2F85C
      #x2F85D	;CJK COMPATIBILITY IDEOGRAPH-2F85D
      #x2F85E	;CJK COMPATIBILITY IDEOGRAPH-2F85E
      #x2F85F	;CJK COMPATIBILITY IDEOGRAPH-2F85F
      #x2F860	;CJK COMPATIBILITY IDEOGRAPH-2F860
      #x2F861	;CJK COMPATIBILITY IDEOGRAPH-2F861
      #x2F862	;CJK COMPATIBILITY IDEOGRAPH-2F862
      #x2F863	;CJK COMPATIBILITY IDEOGRAPH-2F863
      #x2F864	;CJK COMPATIBILITY IDEOGRAPH-2F864
      #x2F865	;CJK COMPATIBILITY IDEOGRAPH-2F865
      #x2F866	;CJK COMPATIBILITY IDEOGRAPH-2F866
      #x2F867	;CJK COMPATIBILITY IDEOGRAPH-2F867
      #x2F868	;CJK COMPATIBILITY IDEOGRAPH-2F868
      #x2F869	;CJK COMPATIBILITY IDEOGRAPH-2F869
      #x2F86A	;CJK COMPATIBILITY IDEOGRAPH-2F86A
      #x2F86B	;CJK COMPATIBILITY IDEOGRAPH-2F86B
      #x2F86C	;CJK COMPATIBILITY IDEOGRAPH-2F86C
      #x2F86D	;CJK COMPATIBILITY IDEOGRAPH-2F86D
      #x2F86E	;CJK COMPATIBILITY IDEOGRAPH-2F86E
      #x2F86F	;CJK COMPATIBILITY IDEOGRAPH-2F86F
      #x2F870	;CJK COMPATIBILITY IDEOGRAPH-2F870
      #x2F871	;CJK COMPATIBILITY IDEOGRAPH-2F871
      #x2F872	;CJK COMPATIBILITY IDEOGRAPH-2F872
      #x2F873	;CJK COMPATIBILITY IDEOGRAPH-2F873
      #x2F874	;CJK COMPATIBILITY IDEOGRAPH-2F874
      #x2F875	;CJK COMPATIBILITY IDEOGRAPH-2F875
      #x2F876	;CJK COMPATIBILITY IDEOGRAPH-2F876
      #x2F877	;CJK COMPATIBILITY IDEOGRAPH-2F877
      #x2F878	;CJK COMPATIBILITY IDEOGRAPH-2F878
      #x2F879	;CJK COMPATIBILITY IDEOGRAPH-2F879
      #x2F87A	;CJK COMPATIBILITY IDEOGRAPH-2F87A
      #x2F87B	;CJK COMPATIBILITY IDEOGRAPH-2F87B
      #x2F87C	;CJK COMPATIBILITY IDEOGRAPH-2F87C
      #x2F87D	;CJK COMPATIBILITY IDEOGRAPH-2F87D
      #x2F87E	;CJK COMPATIBILITY IDEOGRAPH-2F87E
      #x2F87F	;CJK COMPATIBILITY IDEOGRAPH-2F87F
      #x2F880	;CJK COMPATIBILITY IDEOGRAPH-2F880
      #x2F881	;CJK COMPATIBILITY IDEOGRAPH-2F881
      #x2F882	;CJK COMPATIBILITY IDEOGRAPH-2F882
      #x2F883	;CJK COMPATIBILITY IDEOGRAPH-2F883
      #x2F884	;CJK COMPATIBILITY IDEOGRAPH-2F884
      #x2F885	;CJK COMPATIBILITY IDEOGRAPH-2F885
      #x2F886	;CJK COMPATIBILITY IDEOGRAPH-2F886
      #x2F887	;CJK COMPATIBILITY IDEOGRAPH-2F887
      #x2F888	;CJK COMPATIBILITY IDEOGRAPH-2F888
      #x2F889	;CJK COMPATIBILITY IDEOGRAPH-2F889
      #x2F88A	;CJK COMPATIBILITY IDEOGRAPH-2F88A
      #x2F88B	;CJK COMPATIBILITY IDEOGRAPH-2F88B
      #x2F88C	;CJK COMPATIBILITY IDEOGRAPH-2F88C
      #x2F88D	;CJK COMPATIBILITY IDEOGRAPH-2F88D
      #x2F88E	;CJK COMPATIBILITY IDEOGRAPH-2F88E
      #x2F88F	;CJK COMPATIBILITY IDEOGRAPH-2F88F
      #x2F890	;CJK COMPATIBILITY IDEOGRAPH-2F890
      #x2F891	;CJK COMPATIBILITY IDEOGRAPH-2F891
      #x2F892	;CJK COMPATIBILITY IDEOGRAPH-2F892
      #x2F893	;CJK COMPATIBILITY IDEOGRAPH-2F893
      #x2F894	;CJK COMPATIBILITY IDEOGRAPH-2F894
      #x2F895	;CJK COMPATIBILITY IDEOGRAPH-2F895
      #x2F896	;CJK COMPATIBILITY IDEOGRAPH-2F896
      #x2F897	;CJK COMPATIBILITY IDEOGRAPH-2F897
      #x2F898	;CJK COMPATIBILITY IDEOGRAPH-2F898
      #x2F899	;CJK COMPATIBILITY IDEOGRAPH-2F899
      #x2F89A	;CJK COMPATIBILITY IDEOGRAPH-2F89A
      #x2F89B	;CJK COMPATIBILITY IDEOGRAPH-2F89B
      #x2F89C	;CJK COMPATIBILITY IDEOGRAPH-2F89C
      #x2F89D	;CJK COMPATIBILITY IDEOGRAPH-2F89D
      #x2F89E	;CJK COMPATIBILITY IDEOGRAPH-2F89E
      #x2F89F	;CJK COMPATIBILITY IDEOGRAPH-2F89F
      #x2F8A0	;CJK COMPATIBILITY IDEOGRAPH-2F8A0
      #x2F8A1	;CJK COMPATIBILITY IDEOGRAPH-2F8A1
      #x2F8A2	;CJK COMPATIBILITY IDEOGRAPH-2F8A2
      #x2F8A3	;CJK COMPATIBILITY IDEOGRAPH-2F8A3
      #x2F8A4	;CJK COMPATIBILITY IDEOGRAPH-2F8A4
      #x2F8A5	;CJK COMPATIBILITY IDEOGRAPH-2F8A5
      #x2F8A6	;CJK COMPATIBILITY IDEOGRAPH-2F8A6
      #x2F8A7	;CJK COMPATIBILITY IDEOGRAPH-2F8A7
      #x2F8A8	;CJK COMPATIBILITY IDEOGRAPH-2F8A8
      #x2F8A9	;CJK COMPATIBILITY IDEOGRAPH-2F8A9
      #x2F8AA	;CJK COMPATIBILITY IDEOGRAPH-2F8AA
      #x2F8AB	;CJK COMPATIBILITY IDEOGRAPH-2F8AB
      #x2F8AC	;CJK COMPATIBILITY IDEOGRAPH-2F8AC
      #x2F8AD	;CJK COMPATIBILITY IDEOGRAPH-2F8AD
      #x2F8AE	;CJK COMPATIBILITY IDEOGRAPH-2F8AE
      #x2F8AF	;CJK COMPATIBILITY IDEOGRAPH-2F8AF
      #x2F8B0	;CJK COMPATIBILITY IDEOGRAPH-2F8B0
      #x2F8B1	;CJK COMPATIBILITY IDEOGRAPH-2F8B1
      #x2F8B2	;CJK COMPATIBILITY IDEOGRAPH-2F8B2
      #x2F8B3	;CJK COMPATIBILITY IDEOGRAPH-2F8B3
      #x2F8B4	;CJK COMPATIBILITY IDEOGRAPH-2F8B4
      #x2F8B5	;CJK COMPATIBILITY IDEOGRAPH-2F8B5
      #x2F8B6	;CJK COMPATIBILITY IDEOGRAPH-2F8B6
      #x2F8B7	;CJK COMPATIBILITY IDEOGRAPH-2F8B7
      #x2F8B8	;CJK COMPATIBILITY IDEOGRAPH-2F8B8
      #x2F8B9	;CJK COMPATIBILITY IDEOGRAPH-2F8B9
      #x2F8BA	;CJK COMPATIBILITY IDEOGRAPH-2F8BA
      #x2F8BB	;CJK COMPATIBILITY IDEOGRAPH-2F8BB
      #x2F8BC	;CJK COMPATIBILITY IDEOGRAPH-2F8BC
      #x2F8BD	;CJK COMPATIBILITY IDEOGRAPH-2F8BD
      #x2F8BE	;CJK COMPATIBILITY IDEOGRAPH-2F8BE
      #x2F8BF	;CJK COMPATIBILITY IDEOGRAPH-2F8BF
      #x2F8C0	;CJK COMPATIBILITY IDEOGRAPH-2F8C0
      #x2F8C1	;CJK COMPATIBILITY IDEOGRAPH-2F8C1
      #x2F8C2	;CJK COMPATIBILITY IDEOGRAPH-2F8C2
      #x2F8C3	;CJK COMPATIBILITY IDEOGRAPH-2F8C3
      #x2F8C4	;CJK COMPATIBILITY IDEOGRAPH-2F8C4
      #x2F8C5	;CJK COMPATIBILITY IDEOGRAPH-2F8C5
      #x2F8C6	;CJK COMPATIBILITY IDEOGRAPH-2F8C6
      #x2F8C7	;CJK COMPATIBILITY IDEOGRAPH-2F8C7
      #x2F8C8	;CJK COMPATIBILITY IDEOGRAPH-2F8C8
      #x2F8C9	;CJK COMPATIBILITY IDEOGRAPH-2F8C9
      #x2F8CA	;CJK COMPATIBILITY IDEOGRAPH-2F8CA
      #x2F8CB	;CJK COMPATIBILITY IDEOGRAPH-2F8CB
      #x2F8CC	;CJK COMPATIBILITY IDEOGRAPH-2F8CC
      #x2F8CD	;CJK COMPATIBILITY IDEOGRAPH-2F8CD
      #x2F8CE	;CJK COMPATIBILITY IDEOGRAPH-2F8CE
      #x2F8CF	;CJK COMPATIBILITY IDEOGRAPH-2F8CF
      #x2F8D0	;CJK COMPATIBILITY IDEOGRAPH-2F8D0
      #x2F8D1	;CJK COMPATIBILITY IDEOGRAPH-2F8D1
      #x2F8D2	;CJK COMPATIBILITY IDEOGRAPH-2F8D2
      #x2F8D3	;CJK COMPATIBILITY IDEOGRAPH-2F8D3
      #x2F8D4	;CJK COMPATIBILITY IDEOGRAPH-2F8D4
      #x2F8D5	;CJK COMPATIBILITY IDEOGRAPH-2F8D5
      #x2F8D6	;CJK COMPATIBILITY IDEOGRAPH-2F8D6
      #x2F8D7	;CJK COMPATIBILITY IDEOGRAPH-2F8D7
      #x2F8D8	;CJK COMPATIBILITY IDEOGRAPH-2F8D8
      #x2F8D9	;CJK COMPATIBILITY IDEOGRAPH-2F8D9
      #x2F8DA	;CJK COMPATIBILITY IDEOGRAPH-2F8DA
      #x2F8DB	;CJK COMPATIBILITY IDEOGRAPH-2F8DB
      #x2F8DC	;CJK COMPATIBILITY IDEOGRAPH-2F8DC
      #x2F8DD	;CJK COMPATIBILITY IDEOGRAPH-2F8DD
      #x2F8DE	;CJK COMPATIBILITY IDEOGRAPH-2F8DE
      #x2F8DF	;CJK COMPATIBILITY IDEOGRAPH-2F8DF
      #x2F8E0	;CJK COMPATIBILITY IDEOGRAPH-2F8E0
      #x2F8E1	;CJK COMPATIBILITY IDEOGRAPH-2F8E1
      #x2F8E2	;CJK COMPATIBILITY IDEOGRAPH-2F8E2
      #x2F8E3	;CJK COMPATIBILITY IDEOGRAPH-2F8E3
      #x2F8E4	;CJK COMPATIBILITY IDEOGRAPH-2F8E4
      #x2F8E5	;CJK COMPATIBILITY IDEOGRAPH-2F8E5
      #x2F8E6	;CJK COMPATIBILITY IDEOGRAPH-2F8E6
      #x2F8E7	;CJK COMPATIBILITY IDEOGRAPH-2F8E7
      #x2F8E8	;CJK COMPATIBILITY IDEOGRAPH-2F8E8
      #x2F8E9	;CJK COMPATIBILITY IDEOGRAPH-2F8E9
      #x2F8EA	;CJK COMPATIBILITY IDEOGRAPH-2F8EA
      #x2F8EB	;CJK COMPATIBILITY IDEOGRAPH-2F8EB
      #x2F8EC	;CJK COMPATIBILITY IDEOGRAPH-2F8EC
      #x2F8ED	;CJK COMPATIBILITY IDEOGRAPH-2F8ED
      #x2F8EE	;CJK COMPATIBILITY IDEOGRAPH-2F8EE
      #x2F8EF	;CJK COMPATIBILITY IDEOGRAPH-2F8EF
      #x2F8F0	;CJK COMPATIBILITY IDEOGRAPH-2F8F0
      #x2F8F1	;CJK COMPATIBILITY IDEOGRAPH-2F8F1
      #x2F8F2	;CJK COMPATIBILITY IDEOGRAPH-2F8F2
      #x2F8F3	;CJK COMPATIBILITY IDEOGRAPH-2F8F3
      #x2F8F4	;CJK COMPATIBILITY IDEOGRAPH-2F8F4
      #x2F8F5	;CJK COMPATIBILITY IDEOGRAPH-2F8F5
      #x2F8F6	;CJK COMPATIBILITY IDEOGRAPH-2F8F6
      #x2F8F7	;CJK COMPATIBILITY IDEOGRAPH-2F8F7
      #x2F8F8	;CJK COMPATIBILITY IDEOGRAPH-2F8F8
      #x2F8F9	;CJK COMPATIBILITY IDEOGRAPH-2F8F9
      #x2F8FA	;CJK COMPATIBILITY IDEOGRAPH-2F8FA
      #x2F8FB	;CJK COMPATIBILITY IDEOGRAPH-2F8FB
      #x2F8FC	;CJK COMPATIBILITY IDEOGRAPH-2F8FC
      #x2F8FD	;CJK COMPATIBILITY IDEOGRAPH-2F8FD
      #x2F8FE	;CJK COMPATIBILITY IDEOGRAPH-2F8FE
      #x2F8FF	;CJK COMPATIBILITY IDEOGRAPH-2F8FF
      #x2F900	;CJK COMPATIBILITY IDEOGRAPH-2F900
      #x2F901	;CJK COMPATIBILITY IDEOGRAPH-2F901
      #x2F902	;CJK COMPATIBILITY IDEOGRAPH-2F902
      #x2F903	;CJK COMPATIBILITY IDEOGRAPH-2F903
      #x2F904	;CJK COMPATIBILITY IDEOGRAPH-2F904
      #x2F905	;CJK COMPATIBILITY IDEOGRAPH-2F905
      #x2F906	;CJK COMPATIBILITY IDEOGRAPH-2F906
      #x2F907	;CJK COMPATIBILITY IDEOGRAPH-2F907
      #x2F908	;CJK COMPATIBILITY IDEOGRAPH-2F908
      #x2F909	;CJK COMPATIBILITY IDEOGRAPH-2F909
      #x2F90A	;CJK COMPATIBILITY IDEOGRAPH-2F90A
      #x2F90B	;CJK COMPATIBILITY IDEOGRAPH-2F90B
      #x2F90C	;CJK COMPATIBILITY IDEOGRAPH-2F90C
      #x2F90D	;CJK COMPATIBILITY IDEOGRAPH-2F90D
      #x2F90E	;CJK COMPATIBILITY IDEOGRAPH-2F90E
      #x2F90F	;CJK COMPATIBILITY IDEOGRAPH-2F90F
      #x2F910	;CJK COMPATIBILITY IDEOGRAPH-2F910
      #x2F911	;CJK COMPATIBILITY IDEOGRAPH-2F911
      #x2F912	;CJK COMPATIBILITY IDEOGRAPH-2F912
      #x2F913	;CJK COMPATIBILITY IDEOGRAPH-2F913
      #x2F914	;CJK COMPATIBILITY IDEOGRAPH-2F914
      #x2F915	;CJK COMPATIBILITY IDEOGRAPH-2F915
      #x2F916	;CJK COMPATIBILITY IDEOGRAPH-2F916
      #x2F917	;CJK COMPATIBILITY IDEOGRAPH-2F917
      #x2F918	;CJK COMPATIBILITY IDEOGRAPH-2F918
      #x2F919	;CJK COMPATIBILITY IDEOGRAPH-2F919
      #x2F91A	;CJK COMPATIBILITY IDEOGRAPH-2F91A
      #x2F91B	;CJK COMPATIBILITY IDEOGRAPH-2F91B
      #x2F91C	;CJK COMPATIBILITY IDEOGRAPH-2F91C
      #x2F91D	;CJK COMPATIBILITY IDEOGRAPH-2F91D
      #x2F91E	;CJK COMPATIBILITY IDEOGRAPH-2F91E
      #x2F91F	;CJK COMPATIBILITY IDEOGRAPH-2F91F
      #x2F920	;CJK COMPATIBILITY IDEOGRAPH-2F920
      #x2F921	;CJK COMPATIBILITY IDEOGRAPH-2F921
      #x2F922	;CJK COMPATIBILITY IDEOGRAPH-2F922
      #x2F923	;CJK COMPATIBILITY IDEOGRAPH-2F923
      #x2F924	;CJK COMPATIBILITY IDEOGRAPH-2F924
      #x2F925	;CJK COMPATIBILITY IDEOGRAPH-2F925
      #x2F926	;CJK COMPATIBILITY IDEOGRAPH-2F926
      #x2F927	;CJK COMPATIBILITY IDEOGRAPH-2F927
      #x2F928	;CJK COMPATIBILITY IDEOGRAPH-2F928
      #x2F929	;CJK COMPATIBILITY IDEOGRAPH-2F929
      #x2F92A	;CJK COMPATIBILITY IDEOGRAPH-2F92A
      #x2F92B	;CJK COMPATIBILITY IDEOGRAPH-2F92B
      #x2F92C	;CJK COMPATIBILITY IDEOGRAPH-2F92C
      #x2F92D	;CJK COMPATIBILITY IDEOGRAPH-2F92D
      #x2F92E	;CJK COMPATIBILITY IDEOGRAPH-2F92E
      #x2F92F	;CJK COMPATIBILITY IDEOGRAPH-2F92F
      #x2F930	;CJK COMPATIBILITY IDEOGRAPH-2F930
      #x2F931	;CJK COMPATIBILITY IDEOGRAPH-2F931
      #x2F932	;CJK COMPATIBILITY IDEOGRAPH-2F932
      #x2F933	;CJK COMPATIBILITY IDEOGRAPH-2F933
      #x2F934	;CJK COMPATIBILITY IDEOGRAPH-2F934
      #x2F935	;CJK COMPATIBILITY IDEOGRAPH-2F935
      #x2F936	;CJK COMPATIBILITY IDEOGRAPH-2F936
      #x2F937	;CJK COMPATIBILITY IDEOGRAPH-2F937
      #x2F938	;CJK COMPATIBILITY IDEOGRAPH-2F938
      #x2F939	;CJK COMPATIBILITY IDEOGRAPH-2F939
      #x2F93A	;CJK COMPATIBILITY IDEOGRAPH-2F93A
      #x2F93B	;CJK COMPATIBILITY IDEOGRAPH-2F93B
      #x2F93C	;CJK COMPATIBILITY IDEOGRAPH-2F93C
      #x2F93D	;CJK COMPATIBILITY IDEOGRAPH-2F93D
      #x2F93E	;CJK COMPATIBILITY IDEOGRAPH-2F93E
      #x2F93F	;CJK COMPATIBILITY IDEOGRAPH-2F93F
      #x2F940	;CJK COMPATIBILITY IDEOGRAPH-2F940
      #x2F941	;CJK COMPATIBILITY IDEOGRAPH-2F941
      #x2F942	;CJK COMPATIBILITY IDEOGRAPH-2F942
      #x2F943	;CJK COMPATIBILITY IDEOGRAPH-2F943
      #x2F944	;CJK COMPATIBILITY IDEOGRAPH-2F944
      #x2F945	;CJK COMPATIBILITY IDEOGRAPH-2F945
      #x2F946	;CJK COMPATIBILITY IDEOGRAPH-2F946
      #x2F947	;CJK COMPATIBILITY IDEOGRAPH-2F947
      #x2F948	;CJK COMPATIBILITY IDEOGRAPH-2F948
      #x2F949	;CJK COMPATIBILITY IDEOGRAPH-2F949
      #x2F94A	;CJK COMPATIBILITY IDEOGRAPH-2F94A
      #x2F94B	;CJK COMPATIBILITY IDEOGRAPH-2F94B
      #x2F94C	;CJK COMPATIBILITY IDEOGRAPH-2F94C
      #x2F94D	;CJK COMPATIBILITY IDEOGRAPH-2F94D
      #x2F94E	;CJK COMPATIBILITY IDEOGRAPH-2F94E
      #x2F94F	;CJK COMPATIBILITY IDEOGRAPH-2F94F
      #x2F950	;CJK COMPATIBILITY IDEOGRAPH-2F950
      #x2F951	;CJK COMPATIBILITY IDEOGRAPH-2F951
      #x2F952	;CJK COMPATIBILITY IDEOGRAPH-2F952
      #x2F953	;CJK COMPATIBILITY IDEOGRAPH-2F953
      #x2F954	;CJK COMPATIBILITY IDEOGRAPH-2F954
      #x2F955	;CJK COMPATIBILITY IDEOGRAPH-2F955
      #x2F956	;CJK COMPATIBILITY IDEOGRAPH-2F956
      #x2F957	;CJK COMPATIBILITY IDEOGRAPH-2F957
      #x2F958	;CJK COMPATIBILITY IDEOGRAPH-2F958
      #x2F959	;CJK COMPATIBILITY IDEOGRAPH-2F959
      #x2F95A	;CJK COMPATIBILITY IDEOGRAPH-2F95A
      #x2F95B	;CJK COMPATIBILITY IDEOGRAPH-2F95B
      #x2F95C	;CJK COMPATIBILITY IDEOGRAPH-2F95C
      #x2F95D	;CJK COMPATIBILITY IDEOGRAPH-2F95D
      #x2F95E	;CJK COMPATIBILITY IDEOGRAPH-2F95E
      #x2F95F	;CJK COMPATIBILITY IDEOGRAPH-2F95F
      #x2F960	;CJK COMPATIBILITY IDEOGRAPH-2F960
      #x2F961	;CJK COMPATIBILITY IDEOGRAPH-2F961
      #x2F962	;CJK COMPATIBILITY IDEOGRAPH-2F962
      #x2F963	;CJK COMPATIBILITY IDEOGRAPH-2F963
      #x2F964	;CJK COMPATIBILITY IDEOGRAPH-2F964
      #x2F965	;CJK COMPATIBILITY IDEOGRAPH-2F965
      #x2F966	;CJK COMPATIBILITY IDEOGRAPH-2F966
      #x2F967	;CJK COMPATIBILITY IDEOGRAPH-2F967
      #x2F968	;CJK COMPATIBILITY IDEOGRAPH-2F968
      #x2F969	;CJK COMPATIBILITY IDEOGRAPH-2F969
      #x2F96A	;CJK COMPATIBILITY IDEOGRAPH-2F96A
      #x2F96B	;CJK COMPATIBILITY IDEOGRAPH-2F96B
      #x2F96C	;CJK COMPATIBILITY IDEOGRAPH-2F96C
      #x2F96D	;CJK COMPATIBILITY IDEOGRAPH-2F96D
      #x2F96E	;CJK COMPATIBILITY IDEOGRAPH-2F96E
      #x2F96F	;CJK COMPATIBILITY IDEOGRAPH-2F96F
      #x2F970	;CJK COMPATIBILITY IDEOGRAPH-2F970
      #x2F971	;CJK COMPATIBILITY IDEOGRAPH-2F971
      #x2F972	;CJK COMPATIBILITY IDEOGRAPH-2F972
      #x2F973	;CJK COMPATIBILITY IDEOGRAPH-2F973
      #x2F974	;CJK COMPATIBILITY IDEOGRAPH-2F974
      #x2F975	;CJK COMPATIBILITY IDEOGRAPH-2F975
      #x2F976	;CJK COMPATIBILITY IDEOGRAPH-2F976
      #x2F977	;CJK COMPATIBILITY IDEOGRAPH-2F977
      #x2F978	;CJK COMPATIBILITY IDEOGRAPH-2F978
      #x2F979	;CJK COMPATIBILITY IDEOGRAPH-2F979
      #x2F97A	;CJK COMPATIBILITY IDEOGRAPH-2F97A
      #x2F97B	;CJK COMPATIBILITY IDEOGRAPH-2F97B
      #x2F97C	;CJK COMPATIBILITY IDEOGRAPH-2F97C
      #x2F97D	;CJK COMPATIBILITY IDEOGRAPH-2F97D
      #x2F97E	;CJK COMPATIBILITY IDEOGRAPH-2F97E
      #x2F97F	;CJK COMPATIBILITY IDEOGRAPH-2F97F
      #x2F980	;CJK COMPATIBILITY IDEOGRAPH-2F980
      #x2F981	;CJK COMPATIBILITY IDEOGRAPH-2F981
      #x2F982	;CJK COMPATIBILITY IDEOGRAPH-2F982
      #x2F983	;CJK COMPATIBILITY IDEOGRAPH-2F983
      #x2F984	;CJK COMPATIBILITY IDEOGRAPH-2F984
      #x2F985	;CJK COMPATIBILITY IDEOGRAPH-2F985
      #x2F986	;CJK COMPATIBILITY IDEOGRAPH-2F986
      #x2F987	;CJK COMPATIBILITY IDEOGRAPH-2F987
      #x2F988	;CJK COMPATIBILITY IDEOGRAPH-2F988
      #x2F989	;CJK COMPATIBILITY IDEOGRAPH-2F989
      #x2F98A	;CJK COMPATIBILITY IDEOGRAPH-2F98A
      #x2F98B	;CJK COMPATIBILITY IDEOGRAPH-2F98B
      #x2F98C	;CJK COMPATIBILITY IDEOGRAPH-2F98C
      #x2F98D	;CJK COMPATIBILITY IDEOGRAPH-2F98D
      #x2F98E	;CJK COMPATIBILITY IDEOGRAPH-2F98E
      #x2F98F	;CJK COMPATIBILITY IDEOGRAPH-2F98F
      #x2F990	;CJK COMPATIBILITY IDEOGRAPH-2F990
      #x2F991	;CJK COMPATIBILITY IDEOGRAPH-2F991
      #x2F992	;CJK COMPATIBILITY IDEOGRAPH-2F992
      #x2F993	;CJK COMPATIBILITY IDEOGRAPH-2F993
      #x2F994	;CJK COMPATIBILITY IDEOGRAPH-2F994
      #x2F995	;CJK COMPATIBILITY IDEOGRAPH-2F995
      #x2F996	;CJK COMPATIBILITY IDEOGRAPH-2F996
      #x2F997	;CJK COMPATIBILITY IDEOGRAPH-2F997
      #x2F998	;CJK COMPATIBILITY IDEOGRAPH-2F998
      #x2F999	;CJK COMPATIBILITY IDEOGRAPH-2F999
      #x2F99A	;CJK COMPATIBILITY IDEOGRAPH-2F99A
      #x2F99B	;CJK COMPATIBILITY IDEOGRAPH-2F99B
      #x2F99C	;CJK COMPATIBILITY IDEOGRAPH-2F99C
      #x2F99D	;CJK COMPATIBILITY IDEOGRAPH-2F99D
      #x2F99E	;CJK COMPATIBILITY IDEOGRAPH-2F99E
      #x2F99F	;CJK COMPATIBILITY IDEOGRAPH-2F99F
      #x2F9A0	;CJK COMPATIBILITY IDEOGRAPH-2F9A0
      #x2F9A1	;CJK COMPATIBILITY IDEOGRAPH-2F9A1
      #x2F9A2	;CJK COMPATIBILITY IDEOGRAPH-2F9A2
      #x2F9A3	;CJK COMPATIBILITY IDEOGRAPH-2F9A3
      #x2F9A4	;CJK COMPATIBILITY IDEOGRAPH-2F9A4
      #x2F9A5	;CJK COMPATIBILITY IDEOGRAPH-2F9A5
      #x2F9A6	;CJK COMPATIBILITY IDEOGRAPH-2F9A6
      #x2F9A7	;CJK COMPATIBILITY IDEOGRAPH-2F9A7
      #x2F9A8	;CJK COMPATIBILITY IDEOGRAPH-2F9A8
      #x2F9A9	;CJK COMPATIBILITY IDEOGRAPH-2F9A9
      #x2F9AA	;CJK COMPATIBILITY IDEOGRAPH-2F9AA
      #x2F9AB	;CJK COMPATIBILITY IDEOGRAPH-2F9AB
      #x2F9AC	;CJK COMPATIBILITY IDEOGRAPH-2F9AC
      #x2F9AD	;CJK COMPATIBILITY IDEOGRAPH-2F9AD
      #x2F9AE	;CJK COMPATIBILITY IDEOGRAPH-2F9AE
      #x2F9AF	;CJK COMPATIBILITY IDEOGRAPH-2F9AF
      #x2F9B0	;CJK COMPATIBILITY IDEOGRAPH-2F9B0
      #x2F9B1	;CJK COMPATIBILITY IDEOGRAPH-2F9B1
      #x2F9B2	;CJK COMPATIBILITY IDEOGRAPH-2F9B2
      #x2F9B3	;CJK COMPATIBILITY IDEOGRAPH-2F9B3
      #x2F9B4	;CJK COMPATIBILITY IDEOGRAPH-2F9B4
      #x2F9B5	;CJK COMPATIBILITY IDEOGRAPH-2F9B5
      #x2F9B6	;CJK COMPATIBILITY IDEOGRAPH-2F9B6
      #x2F9B7	;CJK COMPATIBILITY IDEOGRAPH-2F9B7
      #x2F9B8	;CJK COMPATIBILITY IDEOGRAPH-2F9B8
      #x2F9B9	;CJK COMPATIBILITY IDEOGRAPH-2F9B9
      #x2F9BA	;CJK COMPATIBILITY IDEOGRAPH-2F9BA
      #x2F9BB	;CJK COMPATIBILITY IDEOGRAPH-2F9BB
      #x2F9BC	;CJK COMPATIBILITY IDEOGRAPH-2F9BC
      #x2F9BD	;CJK COMPATIBILITY IDEOGRAPH-2F9BD
      #x2F9BE	;CJK COMPATIBILITY IDEOGRAPH-2F9BE
      #x2F9BF	;CJK COMPATIBILITY IDEOGRAPH-2F9BF
      #x2F9C0	;CJK COMPATIBILITY IDEOGRAPH-2F9C0
      #x2F9C1	;CJK COMPATIBILITY IDEOGRAPH-2F9C1
      #x2F9C2	;CJK COMPATIBILITY IDEOGRAPH-2F9C2
      #x2F9C3	;CJK COMPATIBILITY IDEOGRAPH-2F9C3
      #x2F9C4	;CJK COMPATIBILITY IDEOGRAPH-2F9C4
      #x2F9C5	;CJK COMPATIBILITY IDEOGRAPH-2F9C5
      #x2F9C6	;CJK COMPATIBILITY IDEOGRAPH-2F9C6
      #x2F9C7	;CJK COMPATIBILITY IDEOGRAPH-2F9C7
      #x2F9C8	;CJK COMPATIBILITY IDEOGRAPH-2F9C8
      #x2F9C9	;CJK COMPATIBILITY IDEOGRAPH-2F9C9
      #x2F9CA	;CJK COMPATIBILITY IDEOGRAPH-2F9CA
      #x2F9CB	;CJK COMPATIBILITY IDEOGRAPH-2F9CB
      #x2F9CC	;CJK COMPATIBILITY IDEOGRAPH-2F9CC
      #x2F9CD	;CJK COMPATIBILITY IDEOGRAPH-2F9CD
      #x2F9CE	;CJK COMPATIBILITY IDEOGRAPH-2F9CE
      #x2F9CF	;CJK COMPATIBILITY IDEOGRAPH-2F9CF
      #x2F9D0	;CJK COMPATIBILITY IDEOGRAPH-2F9D0
      #x2F9D1	;CJK COMPATIBILITY IDEOGRAPH-2F9D1
      #x2F9D2	;CJK COMPATIBILITY IDEOGRAPH-2F9D2
      #x2F9D3	;CJK COMPATIBILITY IDEOGRAPH-2F9D3
      #x2F9D4	;CJK COMPATIBILITY IDEOGRAPH-2F9D4
      #x2F9D5	;CJK COMPATIBILITY IDEOGRAPH-2F9D5
      #x2F9D6	;CJK COMPATIBILITY IDEOGRAPH-2F9D6
      #x2F9D7	;CJK COMPATIBILITY IDEOGRAPH-2F9D7
      #x2F9D8	;CJK COMPATIBILITY IDEOGRAPH-2F9D8
      #x2F9D9	;CJK COMPATIBILITY IDEOGRAPH-2F9D9
      #x2F9DA	;CJK COMPATIBILITY IDEOGRAPH-2F9DA
      #x2F9DB	;CJK COMPATIBILITY IDEOGRAPH-2F9DB
      #x2F9DC	;CJK COMPATIBILITY IDEOGRAPH-2F9DC
      #x2F9DD	;CJK COMPATIBILITY IDEOGRAPH-2F9DD
      #x2F9DE	;CJK COMPATIBILITY IDEOGRAPH-2F9DE
      #x2F9DF	;CJK COMPATIBILITY IDEOGRAPH-2F9DF
      #x2F9E0	;CJK COMPATIBILITY IDEOGRAPH-2F9E0
      #x2F9E1	;CJK COMPATIBILITY IDEOGRAPH-2F9E1
      #x2F9E2	;CJK COMPATIBILITY IDEOGRAPH-2F9E2
      #x2F9E3	;CJK COMPATIBILITY IDEOGRAPH-2F9E3
      #x2F9E4	;CJK COMPATIBILITY IDEOGRAPH-2F9E4
      #x2F9E5	;CJK COMPATIBILITY IDEOGRAPH-2F9E5
      #x2F9E6	;CJK COMPATIBILITY IDEOGRAPH-2F9E6
      #x2F9E7	;CJK COMPATIBILITY IDEOGRAPH-2F9E7
      #x2F9E8	;CJK COMPATIBILITY IDEOGRAPH-2F9E8
      #x2F9E9	;CJK COMPATIBILITY IDEOGRAPH-2F9E9
      #x2F9EA	;CJK COMPATIBILITY IDEOGRAPH-2F9EA
      #x2F9EB	;CJK COMPATIBILITY IDEOGRAPH-2F9EB
      #x2F9EC	;CJK COMPATIBILITY IDEOGRAPH-2F9EC
      #x2F9ED	;CJK COMPATIBILITY IDEOGRAPH-2F9ED
      #x2F9EE	;CJK COMPATIBILITY IDEOGRAPH-2F9EE
      #x2F9EF	;CJK COMPATIBILITY IDEOGRAPH-2F9EF
      #x2F9F0	;CJK COMPATIBILITY IDEOGRAPH-2F9F0
      #x2F9F1	;CJK COMPATIBILITY IDEOGRAPH-2F9F1
      #x2F9F2	;CJK COMPATIBILITY IDEOGRAPH-2F9F2
      #x2F9F3	;CJK COMPATIBILITY IDEOGRAPH-2F9F3
      #x2F9F4	;CJK COMPATIBILITY IDEOGRAPH-2F9F4
      #x2F9F5	;CJK COMPATIBILITY IDEOGRAPH-2F9F5
      #x2F9F6	;CJK COMPATIBILITY IDEOGRAPH-2F9F6
      #x2F9F7	;CJK COMPATIBILITY IDEOGRAPH-2F9F7
      #x2F9F8	;CJK COMPATIBILITY IDEOGRAPH-2F9F8
      #x2F9F9	;CJK COMPATIBILITY IDEOGRAPH-2F9F9
      #x2F9FA	;CJK COMPATIBILITY IDEOGRAPH-2F9FA
      #x2F9FB	;CJK COMPATIBILITY IDEOGRAPH-2F9FB
      #x2F9FC	;CJK COMPATIBILITY IDEOGRAPH-2F9FC
      #x2F9FD	;CJK COMPATIBILITY IDEOGRAPH-2F9FD
      #x2F9FE	;CJK COMPATIBILITY IDEOGRAPH-2F9FE
      #x2F9FF	;CJK COMPATIBILITY IDEOGRAPH-2F9FF
      #x2FA00	;CJK COMPATIBILITY IDEOGRAPH-2FA00
      #x2FA01	;CJK COMPATIBILITY IDEOGRAPH-2FA01
      #x2FA02	;CJK COMPATIBILITY IDEOGRAPH-2FA02
      #x2FA03	;CJK COMPATIBILITY IDEOGRAPH-2FA03
      #x2FA04	;CJK COMPATIBILITY IDEOGRAPH-2FA04
      #x2FA05	;CJK COMPATIBILITY IDEOGRAPH-2FA05
      #x2FA06	;CJK COMPATIBILITY IDEOGRAPH-2FA06
      #x2FA07	;CJK COMPATIBILITY IDEOGRAPH-2FA07
      #x2FA08	;CJK COMPATIBILITY IDEOGRAPH-2FA08
      #x2FA09	;CJK COMPATIBILITY IDEOGRAPH-2FA09
      #x2FA0A	;CJK COMPATIBILITY IDEOGRAPH-2FA0A
      #x2FA0B	;CJK COMPATIBILITY IDEOGRAPH-2FA0B
      #x2FA0C	;CJK COMPATIBILITY IDEOGRAPH-2FA0C
      #x2FA0D	;CJK COMPATIBILITY IDEOGRAPH-2FA0D
      #x2FA0E	;CJK COMPATIBILITY IDEOGRAPH-2FA0E
      #x2FA0F	;CJK COMPATIBILITY IDEOGRAPH-2FA0F
      #x2FA10	;CJK COMPATIBILITY IDEOGRAPH-2FA10
      #x2FA11	;CJK COMPATIBILITY IDEOGRAPH-2FA11
      #x2FA12	;CJK COMPATIBILITY IDEOGRAPH-2FA12
      #x2FA13	;CJK COMPATIBILITY IDEOGRAPH-2FA13
      #x2FA14	;CJK COMPATIBILITY IDEOGRAPH-2FA14
      #x2FA15	;CJK COMPATIBILITY IDEOGRAPH-2FA15
      #x2FA16	;CJK COMPATIBILITY IDEOGRAPH-2FA16
      #x2FA17	;CJK COMPATIBILITY IDEOGRAPH-2FA17
      #x2FA18	;CJK COMPATIBILITY IDEOGRAPH-2FA18
      #x2FA19	;CJK COMPATIBILITY IDEOGRAPH-2FA19
      #x2FA1A	;CJK COMPATIBILITY IDEOGRAPH-2FA1A
      #x2FA1B	;CJK COMPATIBILITY IDEOGRAPH-2FA1B
      #x2FA1C	;CJK COMPATIBILITY IDEOGRAPH-2FA1C
      #x2FA1D	;CJK COMPATIBILITY IDEOGRAPH-2FA1D
)))

(define char-set:digit
  (build-char-set
   '( #x0030	;DIGIT ZERO
      #x0031	;DIGIT ONE
      #x0032	;DIGIT TWO
      #x0033	;DIGIT THREE
      #x0034	;DIGIT FOUR
      #x0035	;DIGIT FIVE
      #x0036	;DIGIT SIX
      #x0037	;DIGIT SEVEN
      #x0038	;DIGIT EIGHT
      #x0039	;DIGIT NINE
      #x0660	;ARABIC-INDIC DIGIT ZERO
      #x0661	;ARABIC-INDIC DIGIT ONE
      #x0662	;ARABIC-INDIC DIGIT TWO
      #x0663	;ARABIC-INDIC DIGIT THREE
      #x0664	;ARABIC-INDIC DIGIT FOUR
      #x0665	;ARABIC-INDIC DIGIT FIVE
      #x0666	;ARABIC-INDIC DIGIT SIX
      #x0667	;ARABIC-INDIC DIGIT SEVEN
      #x0668	;ARABIC-INDIC DIGIT EIGHT
      #x0669	;ARABIC-INDIC DIGIT NINE
      #x06F0	;EXTENDED ARABIC-INDIC DIGIT ZERO
      #x06F1	;EXTENDED ARABIC-INDIC DIGIT ONE
      #x06F2	;EXTENDED ARABIC-INDIC DIGIT TWO
      #x06F3	;EXTENDED ARABIC-INDIC DIGIT THREE
      #x06F4	;EXTENDED ARABIC-INDIC DIGIT FOUR
      #x06F5	;EXTENDED ARABIC-INDIC DIGIT FIVE
      #x06F6	;EXTENDED ARABIC-INDIC DIGIT SIX
      #x06F7	;EXTENDED ARABIC-INDIC DIGIT SEVEN
      #x06F8	;EXTENDED ARABIC-INDIC DIGIT EIGHT
      #x06F9	;EXTENDED ARABIC-INDIC DIGIT NINE
      #x0966	;DEVANAGARI DIGIT ZERO
      #x0967	;DEVANAGARI DIGIT ONE
      #x0968	;DEVANAGARI DIGIT TWO
      #x0969	;DEVANAGARI DIGIT THREE
      #x096A	;DEVANAGARI DIGIT FOUR
      #x096B	;DEVANAGARI DIGIT FIVE
      #x096C	;DEVANAGARI DIGIT SIX
      #x096D	;DEVANAGARI DIGIT SEVEN
      #x096E	;DEVANAGARI DIGIT EIGHT
      #x096F	;DEVANAGARI DIGIT NINE
      #x09E6	;BENGALI DIGIT ZERO
      #x09E7	;BENGALI DIGIT ONE
      #x09E8	;BENGALI DIGIT TWO
      #x09E9	;BENGALI DIGIT THREE
      #x09EA	;BENGALI DIGIT FOUR
      #x09EB	;BENGALI DIGIT FIVE
      #x09EC	;BENGALI DIGIT SIX
      #x09ED	;BENGALI DIGIT SEVEN
      #x09EE	;BENGALI DIGIT EIGHT
      #x09EF	;BENGALI DIGIT NINE
      #x0A66	;GURMUKHI DIGIT ZERO
      #x0A67	;GURMUKHI DIGIT ONE
      #x0A68	;GURMUKHI DIGIT TWO
      #x0A69	;GURMUKHI DIGIT THREE
      #x0A6A	;GURMUKHI DIGIT FOUR
      #x0A6B	;GURMUKHI DIGIT FIVE
      #x0A6C	;GURMUKHI DIGIT SIX
      #x0A6D	;GURMUKHI DIGIT SEVEN
      #x0A6E	;GURMUKHI DIGIT EIGHT
      #x0A6F	;GURMUKHI DIGIT NINE
      #x0AE6	;GUJARATI DIGIT ZERO
      #x0AE7	;GUJARATI DIGIT ONE
      #x0AE8	;GUJARATI DIGIT TWO
      #x0AE9	;GUJARATI DIGIT THREE
      #x0AEA	;GUJARATI DIGIT FOUR
      #x0AEB	;GUJARATI DIGIT FIVE
      #x0AEC	;GUJARATI DIGIT SIX
      #x0AED	;GUJARATI DIGIT SEVEN
      #x0AEE	;GUJARATI DIGIT EIGHT
      #x0AEF	;GUJARATI DIGIT NINE
      #x0B66	;ORIYA DIGIT ZERO
      #x0B67	;ORIYA DIGIT ONE
      #x0B68	;ORIYA DIGIT TWO
      #x0B69	;ORIYA DIGIT THREE
      #x0B6A	;ORIYA DIGIT FOUR
      #x0B6B	;ORIYA DIGIT FIVE
      #x0B6C	;ORIYA DIGIT SIX
      #x0B6D	;ORIYA DIGIT SEVEN
      #x0B6E	;ORIYA DIGIT EIGHT
      #x0B6F	;ORIYA DIGIT NINE
      #x0BE7	;TAMIL DIGIT ONE
      #x0BE8	;TAMIL DIGIT TWO
      #x0BE9	;TAMIL DIGIT THREE
      #x0BEA	;TAMIL DIGIT FOUR
      #x0BEB	;TAMIL DIGIT FIVE
      #x0BEC	;TAMIL DIGIT SIX
      #x0BED	;TAMIL DIGIT SEVEN
      #x0BEE	;TAMIL DIGIT EIGHT
      #x0BEF	;TAMIL DIGIT NINE
      #x0C66	;TELUGU DIGIT ZERO
      #x0C67	;TELUGU DIGIT ONE
      #x0C68	;TELUGU DIGIT TWO
      #x0C69	;TELUGU DIGIT THREE
      #x0C6A	;TELUGU DIGIT FOUR
      #x0C6B	;TELUGU DIGIT FIVE
      #x0C6C	;TELUGU DIGIT SIX
      #x0C6D	;TELUGU DIGIT SEVEN
      #x0C6E	;TELUGU DIGIT EIGHT
      #x0C6F	;TELUGU DIGIT NINE
      #x0CE6	;KANNADA DIGIT ZERO
      #x0CE7	;KANNADA DIGIT ONE
      #x0CE8	;KANNADA DIGIT TWO
      #x0CE9	;KANNADA DIGIT THREE
      #x0CEA	;KANNADA DIGIT FOUR
      #x0CEB	;KANNADA DIGIT FIVE
      #x0CEC	;KANNADA DIGIT SIX
      #x0CED	;KANNADA DIGIT SEVEN
      #x0CEE	;KANNADA DIGIT EIGHT
      #x0CEF	;KANNADA DIGIT NINE
      #x0D66	;MALAYALAM DIGIT ZERO
      #x0D67	;MALAYALAM DIGIT ONE
      #x0D68	;MALAYALAM DIGIT TWO
      #x0D69	;MALAYALAM DIGIT THREE
      #x0D6A	;MALAYALAM DIGIT FOUR
      #x0D6B	;MALAYALAM DIGIT FIVE
      #x0D6C	;MALAYALAM DIGIT SIX
      #x0D6D	;MALAYALAM DIGIT SEVEN
      #x0D6E	;MALAYALAM DIGIT EIGHT
      #x0D6F	;MALAYALAM DIGIT NINE
      #x0E50	;THAI DIGIT ZERO
      #x0E51	;THAI DIGIT ONE
      #x0E52	;THAI DIGIT TWO
      #x0E53	;THAI DIGIT THREE
      #x0E54	;THAI DIGIT FOUR
      #x0E55	;THAI DIGIT FIVE
      #x0E56	;THAI DIGIT SIX
      #x0E57	;THAI DIGIT SEVEN
      #x0E58	;THAI DIGIT EIGHT
      #x0E59	;THAI DIGIT NINE
      #x0ED0	;LAO DIGIT ZERO
      #x0ED1	;LAO DIGIT ONE
      #x0ED2	;LAO DIGIT TWO
      #x0ED3	;LAO DIGIT THREE
      #x0ED4	;LAO DIGIT FOUR
      #x0ED5	;LAO DIGIT FIVE
      #x0ED6	;LAO DIGIT SIX
      #x0ED7	;LAO DIGIT SEVEN
      #x0ED8	;LAO DIGIT EIGHT
      #x0ED9	;LAO DIGIT NINE
      #x0F20	;TIBETAN DIGIT ZERO
      #x0F21	;TIBETAN DIGIT ONE
      #x0F22	;TIBETAN DIGIT TWO
      #x0F23	;TIBETAN DIGIT THREE
      #x0F24	;TIBETAN DIGIT FOUR
      #x0F25	;TIBETAN DIGIT FIVE
      #x0F26	;TIBETAN DIGIT SIX
      #x0F27	;TIBETAN DIGIT SEVEN
      #x0F28	;TIBETAN DIGIT EIGHT
      #x0F29	;TIBETAN DIGIT NINE
      #x1040	;MYANMAR DIGIT ZERO
      #x1041	;MYANMAR DIGIT ONE
      #x1042	;MYANMAR DIGIT TWO
      #x1043	;MYANMAR DIGIT THREE
      #x1044	;MYANMAR DIGIT FOUR
      #x1045	;MYANMAR DIGIT FIVE
      #x1046	;MYANMAR DIGIT SIX
      #x1047	;MYANMAR DIGIT SEVEN
      #x1048	;MYANMAR DIGIT EIGHT
      #x1049	;MYANMAR DIGIT NINE
      #x1369	;ETHIOPIC DIGIT ONE
      #x136A	;ETHIOPIC DIGIT TWO
      #x136B	;ETHIOPIC DIGIT THREE
      #x136C	;ETHIOPIC DIGIT FOUR
      #x136D	;ETHIOPIC DIGIT FIVE
      #x136E	;ETHIOPIC DIGIT SIX
      #x136F	;ETHIOPIC DIGIT SEVEN
      #x1370	;ETHIOPIC DIGIT EIGHT
      #x1371	;ETHIOPIC DIGIT NINE
      #x17E0	;KHMER DIGIT ZERO
      #x17E1	;KHMER DIGIT ONE
      #x17E2	;KHMER DIGIT TWO
      #x17E3	;KHMER DIGIT THREE
      #x17E4	;KHMER DIGIT FOUR
      #x17E5	;KHMER DIGIT FIVE
      #x17E6	;KHMER DIGIT SIX
      #x17E7	;KHMER DIGIT SEVEN
      #x17E8	;KHMER DIGIT EIGHT
      #x17E9	;KHMER DIGIT NINE
      #x1810	;MONGOLIAN DIGIT ZERO
      #x1811	;MONGOLIAN DIGIT ONE
      #x1812	;MONGOLIAN DIGIT TWO
      #x1813	;MONGOLIAN DIGIT THREE
      #x1814	;MONGOLIAN DIGIT FOUR
      #x1815	;MONGOLIAN DIGIT FIVE
      #x1816	;MONGOLIAN DIGIT SIX
      #x1817	;MONGOLIAN DIGIT SEVEN
      #x1818	;MONGOLIAN DIGIT EIGHT
      #x1819	;MONGOLIAN DIGIT NINE
      #x1946	;LIMBU DIGIT ZERO
      #x1947	;LIMBU DIGIT ONE
      #x1948	;LIMBU DIGIT TWO
      #x1949	;LIMBU DIGIT THREE
      #x194A	;LIMBU DIGIT FOUR
      #x194B	;LIMBU DIGIT FIVE
      #x194C	;LIMBU DIGIT SIX
      #x194D	;LIMBU DIGIT SEVEN
      #x194E	;LIMBU DIGIT EIGHT
      #x194F	;LIMBU DIGIT NINE
      #xFF10	;FULLWIDTH DIGIT ZERO
      #xFF11	;FULLWIDTH DIGIT ONE
      #xFF12	;FULLWIDTH DIGIT TWO
      #xFF13	;FULLWIDTH DIGIT THREE
      #xFF14	;FULLWIDTH DIGIT FOUR
      #xFF15	;FULLWIDTH DIGIT FIVE
      #xFF16	;FULLWIDTH DIGIT SIX
      #xFF17	;FULLWIDTH DIGIT SEVEN
      #xFF18	;FULLWIDTH DIGIT EIGHT
      #xFF19	;FULLWIDTH DIGIT NINE
      #x104A0	;OSMANYA DIGIT ZERO
      #x104A1	;OSMANYA DIGIT ONE
      #x104A2	;OSMANYA DIGIT TWO
      #x104A3	;OSMANYA DIGIT THREE
      #x104A4	;OSMANYA DIGIT FOUR
      #x104A5	;OSMANYA DIGIT FIVE
      #x104A6	;OSMANYA DIGIT SIX
      #x104A7	;OSMANYA DIGIT SEVEN
      #x104A8	;OSMANYA DIGIT EIGHT
      #x104A9	;OSMANYA DIGIT NINE
      #x1D7CE	;MATHEMATICAL BOLD DIGIT ZERO
      #x1D7CF	;MATHEMATICAL BOLD DIGIT ONE
      #x1D7D0	;MATHEMATICAL BOLD DIGIT TWO
      #x1D7D1	;MATHEMATICAL BOLD DIGIT THREE
      #x1D7D2	;MATHEMATICAL BOLD DIGIT FOUR
      #x1D7D3	;MATHEMATICAL BOLD DIGIT FIVE
      #x1D7D4	;MATHEMATICAL BOLD DIGIT SIX
      #x1D7D5	;MATHEMATICAL BOLD DIGIT SEVEN
      #x1D7D6	;MATHEMATICAL BOLD DIGIT EIGHT
      #x1D7D7	;MATHEMATICAL BOLD DIGIT NINE
      #x1D7D8	;MATHEMATICAL DOUBLE-STRUCK DIGIT ZERO
      #x1D7D9	;MATHEMATICAL DOUBLE-STRUCK DIGIT ONE
      #x1D7DA	;MATHEMATICAL DOUBLE-STRUCK DIGIT TWO
      #x1D7DB	;MATHEMATICAL DOUBLE-STRUCK DIGIT THREE
      #x1D7DC	;MATHEMATICAL DOUBLE-STRUCK DIGIT FOUR
      #x1D7DD	;MATHEMATICAL DOUBLE-STRUCK DIGIT FIVE
      #x1D7DE	;MATHEMATICAL DOUBLE-STRUCK DIGIT SIX
      #x1D7DF	;MATHEMATICAL DOUBLE-STRUCK DIGIT SEVEN
      #x1D7E0	;MATHEMATICAL DOUBLE-STRUCK DIGIT EIGHT
      #x1D7E1	;MATHEMATICAL DOUBLE-STRUCK DIGIT NINE
      #x1D7E2	;MATHEMATICAL SANS-SERIF DIGIT ZERO
      #x1D7E3	;MATHEMATICAL SANS-SERIF DIGIT ONE
      #x1D7E4	;MATHEMATICAL SANS-SERIF DIGIT TWO
      #x1D7E5	;MATHEMATICAL SANS-SERIF DIGIT THREE
      #x1D7E6	;MATHEMATICAL SANS-SERIF DIGIT FOUR
      #x1D7E7	;MATHEMATICAL SANS-SERIF DIGIT FIVE
      #x1D7E8	;MATHEMATICAL SANS-SERIF DIGIT SIX
      #x1D7E9	;MATHEMATICAL SANS-SERIF DIGIT SEVEN
      #x1D7EA	;MATHEMATICAL SANS-SERIF DIGIT EIGHT
      #x1D7EB	;MATHEMATICAL SANS-SERIF DIGIT NINE
      #x1D7EC	;MATHEMATICAL SANS-SERIF BOLD DIGIT ZERO
      #x1D7ED	;MATHEMATICAL SANS-SERIF BOLD DIGIT ONE
      #x1D7EE	;MATHEMATICAL SANS-SERIF BOLD DIGIT TWO
      #x1D7EF	;MATHEMATICAL SANS-SERIF BOLD DIGIT THREE
      #x1D7F0	;MATHEMATICAL SANS-SERIF BOLD DIGIT FOUR
      #x1D7F1	;MATHEMATICAL SANS-SERIF BOLD DIGIT FIVE
      #x1D7F2	;MATHEMATICAL SANS-SERIF BOLD DIGIT SIX
      #x1D7F3	;MATHEMATICAL SANS-SERIF BOLD DIGIT SEVEN
      #x1D7F4	;MATHEMATICAL SANS-SERIF BOLD DIGIT EIGHT
      #x1D7F5	;MATHEMATICAL SANS-SERIF BOLD DIGIT NINE
      #x1D7F6	;MATHEMATICAL MONOSPACE DIGIT ZERO
      #x1D7F7	;MATHEMATICAL MONOSPACE DIGIT ONE
      #x1D7F8	;MATHEMATICAL MONOSPACE DIGIT TWO
      #x1D7F9	;MATHEMATICAL MONOSPACE DIGIT THREE
      #x1D7FA	;MATHEMATICAL MONOSPACE DIGIT FOUR
      #x1D7FB	;MATHEMATICAL MONOSPACE DIGIT FIVE
      #x1D7FC	;MATHEMATICAL MONOSPACE DIGIT SIX
      #x1D7FD	;MATHEMATICAL MONOSPACE DIGIT SEVEN
      #x1D7FE	;MATHEMATICAL MONOSPACE DIGIT EIGHT
      #x1D7FF	;MATHEMATICAL MONOSPACE DIGIT NINE
)))

(define char-set:whitespace
  (build-char-set
   '( #x0009 	;HORIZONTAL TABULATION
      #x000A 	;LINE FEED
      #x000B 	;VERTICAL TABULATION
      #x000C 	;FORM FEED
      #x000D 	;CARRIAGE RETURN
      #x0020 	;SPACE
      #x00A0 	;NO-BREAK SPACE 	
      #x1680 	;OGHAM SPACE MARK 	
      #x2000 	;EN QUAD 	
      #x2001 	;EM QUAD 	
      #x2002 	;EN SPACE 	
      #x2003 	;EM SPACE 	
      #x2004 	;THREE-PER-EM SPACE 	
      #x2005 	;FOUR-PER-EM SPACE 	
      #x2006 	;SIX-PER-EM SPACE 	
      #x2007 	;FIGURE SPACE 	
      #x2008 	;PUNCTUATION SPACE 	
      #x2009 	;THIN SPACE 	
      #x200A 	;HAIR SPACE 	
      #x200B 	;ZERO WIDTH SPACE 	
      #x2028 	;LINE SEPARATOR 
      #x2029 	;PARAGRAPH SEPARATOR
      #x202F 	;NARROW NO-BREAK SPACE 	
      #x3000 	;IDEOGRAPHIC SPACE 	
)))

(define char-set:punctuation
  (build-char-set
   '( #x0021	;EXCLAMATION MARK
      #x0022	;QUOTATION MARK
      #x0023	;NUMBER SIGN
      #x0025	;PERCENT SIGN
      #x0026	;AMPERSAND
      #x0027	;APOSTROPHE
      #x0028	;LEFT PARENTHESIS
      #x0029	;RIGHT PARENTHESIS
      #x002A	;ASTERISK
      #x002C	;COMMA
      #x002D	;HYPHEN-MINUS
      #x002E	;FULL STOP
      #x002F	;SOLIDUS
      #x003A	;COLON
      #x003B	;SEMICOLON
      #x003F	;QUESTION MARK
      #x0040	;COMMERCIAL AT
      #x005B	;LEFT SQUARE BRACKET
      #x005C	;REVERSE SOLIDUS
      #x005D	;RIGHT SQUARE BRACKET
      #x005F	;LOW LINE
      #x007B	;LEFT CURLY BRACKET
      #x007D	;RIGHT CURLY BRACKET
      #x00A1	;INVERTED EXCLAMATION MARK
      #x00AB	;LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
      #x00B7	;MIDDLE DOT
      #x00BB	;RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
      #x00BF	;INVERTED QUESTION MARK
      #x037E	;GREEK QUESTION MARK
      #x0387	;GREEK ANO TELEIA
      #x055A	;ARMENIAN APOSTROPHE
      #x055B	;ARMENIAN EMPHASIS MARK
      #x055C	;ARMENIAN EXCLAMATION MARK
      #x055D	;ARMENIAN COMMA
      #x055E	;ARMENIAN QUESTION MARK
      #x055F	;ARMENIAN ABBREVIATION MARK
      #x0589	;ARMENIAN FULL STOP
      #x058A	;ARMENIAN HYPHEN
      #x05BE	;HEBREW PUNCTUATION MAQAF
      #x05C0	;HEBREW PUNCTUATION PASEQ
      #x05C3	;HEBREW PUNCTUATION SOF PASUQ
      #x05F3	;HEBREW PUNCTUATION GERESH
      #x05F4	;HEBREW PUNCTUATION GERSHAYIM
      #x060C	;ARABIC COMMA
      #x060D	;ARABIC DATE SEPARATOR
      #x061B	;ARABIC SEMICOLON
      #x061F	;ARABIC QUESTION MARK
      #x066A	;ARABIC PERCENT SIGN
      #x066B	;ARABIC DECIMAL SEPARATOR
      #x066C	;ARABIC THOUSANDS SEPARATOR
      #x066D	;ARABIC FIVE POINTED STAR
      #x06D4	;ARABIC FULL STOP
      #x0700	;SYRIAC END OF PARAGRAPH
      #x0701	;SYRIAC SUPRALINEAR FULL STOP
      #x0702	;SYRIAC SUBLINEAR FULL STOP
      #x0703	;SYRIAC SUPRALINEAR COLON
      #x0704	;SYRIAC SUBLINEAR COLON
      #x0705	;SYRIAC HORIZONTAL COLON
      #x0706	;SYRIAC COLON SKEWED LEFT
      #x0707	;SYRIAC COLON SKEWED RIGHT
      #x0708	;SYRIAC SUPRALINEAR COLON SKEWED LEFT
      #x0709	;SYRIAC SUBLINEAR COLON SKEWED RIGHT
      #x070A	;SYRIAC CONTRACTION
      #x070B	;SYRIAC HARKLEAN OBELUS
      #x070C	;SYRIAC HARKLEAN METOBELUS
      #x070D	;SYRIAC HARKLEAN ASTERISCUS
      #x0964	;DEVANAGARI DANDA
      #x0965	;DEVANAGARI DOUBLE DANDA
      #x0970	;DEVANAGARI ABBREVIATION SIGN
      #x0DF4	;SINHALA PUNCTUATION KUNDDALIYA
      #x0E4F	;THAI CHARACTER FONGMAN
      #x0E5A	;THAI CHARACTER ANGKHANKHU
      #x0E5B	;THAI CHARACTER KHOMUT
      #x0F04	;TIBETAN MARK INITIAL YIG MGO MDUN MA
      #x0F05	;TIBETAN MARK CLOSING YIG MGO SGAB MA
      #x0F06	;TIBETAN MARK CARET YIG MGO PHUR SHAD MA
      #x0F07	;TIBETAN MARK YIG MGO TSHEG SHAD MA
      #x0F08	;TIBETAN MARK SBRUL SHAD
      #x0F09	;TIBETAN MARK BSKUR YIG MGO
      #x0F0A	;TIBETAN MARK BKA- SHOG YIG MGO
      #x0F0B	;TIBETAN MARK INTERSYLLABIC TSHEG
      #x0F0C	;TIBETAN MARK DELIMITER TSHEG BSTAR
      #x0F0D	;TIBETAN MARK SHAD
      #x0F0E	;TIBETAN MARK NYIS SHAD
      #x0F0F	;TIBETAN MARK TSHEG SHAD
      #x0F10	;TIBETAN MARK NYIS TSHEG SHAD
      #x0F11	;TIBETAN MARK RIN CHEN SPUNGS SHAD
      #x0F12	;TIBETAN MARK RGYA GRAM SHAD
      #x0F3A	;TIBETAN MARK GUG RTAGS GYON
      #x0F3B	;TIBETAN MARK GUG RTAGS GYAS
      #x0F3C	;TIBETAN MARK ANG KHANG GYON
      #x0F3D	;TIBETAN MARK ANG KHANG GYAS
      #x0F85	;TIBETAN MARK PALUTA
      #x104A	;MYANMAR SIGN LITTLE SECTION
      #x104B	;MYANMAR SIGN SECTION
      #x104C	;MYANMAR SYMBOL LOCATIVE
      #x104D	;MYANMAR SYMBOL COMPLETED
      #x104E	;MYANMAR SYMBOL AFOREMENTIONED
      #x104F	;MYANMAR SYMBOL GENITIVE
      #x10FB	;GEORGIAN PARAGRAPH SEPARATOR
      #x1361	;ETHIOPIC WORDSPACE
      #x1362	;ETHIOPIC FULL STOP
      #x1363	;ETHIOPIC COMMA
      #x1364	;ETHIOPIC SEMICOLON
      #x1365	;ETHIOPIC COLON
      #x1366	;ETHIOPIC PREFACE COLON
      #x1367	;ETHIOPIC QUESTION MARK
      #x1368	;ETHIOPIC PARAGRAPH SEPARATOR
      #x166D	;CANADIAN SYLLABICS CHI SIGN
      #x166E	;CANADIAN SYLLABICS FULL STOP
      #x169B	;OGHAM FEATHER MARK
      #x169C	;OGHAM REVERSED FEATHER MARK
      #x16EB	;RUNIC SINGLE PUNCTUATION
      #x16EC	;RUNIC MULTIPLE PUNCTUATION
      #x16ED	;RUNIC CROSS PUNCTUATION
      #x1735	;PHILIPPINE SINGLE PUNCTUATION
      #x1736	;PHILIPPINE DOUBLE PUNCTUATION
      #x17D4	;KHMER SIGN KHAN
      #x17D5	;KHMER SIGN BARIYOOSAN
      #x17D6	;KHMER SIGN CAMNUC PII KUUH
      #x17D8	;KHMER SIGN BEYYAL
      #x17D9	;KHMER SIGN PHNAEK MUAN
      #x17DA	;KHMER SIGN KOOMUUT
      #x1800	;MONGOLIAN BIRGA
      #x1801	;MONGOLIAN ELLIPSIS
      #x1802	;MONGOLIAN COMMA
      #x1803	;MONGOLIAN FULL STOP
      #x1804	;MONGOLIAN COLON
      #x1805	;MONGOLIAN FOUR DOTS
      #x1806	;MONGOLIAN TODO SOFT HYPHEN
      #x1807	;MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER
      #x1808	;MONGOLIAN MANCHU COMMA
      #x1809	;MONGOLIAN MANCHU FULL STOP
      #x180A	;MONGOLIAN NIRUGU
      #x1944	;LIMBU EXCLAMATION MARK
      #x1945	;LIMBU QUESTION MARK
      #x2010	;HYPHEN
      #x2011	;NON-BREAKING HYPHEN
      #x2012	;FIGURE DASH
      #x2013	;EN DASH
      #x2014	;EM DASH
      #x2015	;HORIZONTAL BAR
      #x2016	;DOUBLE VERTICAL LINE
      #x2017	;DOUBLE LOW LINE
      #x2018	;LEFT SINGLE QUOTATION MARK
      #x2019	;RIGHT SINGLE QUOTATION MARK
      #x201A	;SINGLE LOW-9 QUOTATION MARK
      #x201B	;SINGLE HIGH-REVERSED-9 QUOTATION MARK
      #x201C	;LEFT DOUBLE QUOTATION MARK
      #x201D	;RIGHT DOUBLE QUOTATION MARK
      #x201E	;DOUBLE LOW-9 QUOTATION MARK
      #x201F	;DOUBLE HIGH-REVERSED-9 QUOTATION MARK
      #x2020	;DAGGER
      #x2021	;DOUBLE DAGGER
      #x2022	;BULLET
      #x2023	;TRIANGULAR BULLET
      #x2024	;ONE DOT LEADER
      #x2025	;TWO DOT LEADER
      #x2026	;HORIZONTAL ELLIPSIS
      #x2027	;HYPHENATION POINT
      #x2030	;PER MILLE SIGN
      #x2031	;PER TEN THOUSAND SIGN
      #x2032	;PRIME
      #x2033	;DOUBLE PRIME
      #x2034	;TRIPLE PRIME
      #x2035	;REVERSED PRIME
      #x2036	;REVERSED DOUBLE PRIME
      #x2037	;REVERSED TRIPLE PRIME
      #x2038	;CARET
      #x2039	;SINGLE LEFT-POINTING ANGLE QUOTATION MARK
      #x203A	;SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
      #x203B	;REFERENCE MARK
      #x203C	;DOUBLE EXCLAMATION MARK
      #x203D	;INTERROBANG
      #x203E	;OVERLINE
      #x203F	;UNDERTIE
      #x2040	;CHARACTER TIE
      #x2041	;CARET INSERTION POINT
      #x2042	;ASTERISM
      #x2043	;HYPHEN BULLET
      #x2045	;LEFT SQUARE BRACKET WITH QUILL
      #x2046	;RIGHT SQUARE BRACKET WITH QUILL
      #x2047	;DOUBLE QUESTION MARK
      #x2048	;QUESTION EXCLAMATION MARK
      #x2049	;EXCLAMATION QUESTION MARK
      #x204A	;TIRONIAN SIGN ET
      #x204B	;REVERSED PILCROW SIGN
      #x204C	;BLACK LEFTWARDS BULLET
      #x204D	;BLACK RIGHTWARDS BULLET
      #x204E	;LOW ASTERISK
      #x204F	;REVERSED SEMICOLON
      #x2050	;CLOSE UP
      #x2051	;TWO ASTERISKS ALIGNED VERTICALLY
      #x2053	;SWUNG DASH
      #x2054	;INVERTED UNDERTIE
      #x2057	;QUADRUPLE PRIME
      #x207D	;SUPERSCRIPT LEFT PARENTHESIS
      #x207E	;SUPERSCRIPT RIGHT PARENTHESIS
      #x208D	;SUBSCRIPT LEFT PARENTHESIS
      #x208E	;SUBSCRIPT RIGHT PARENTHESIS
      #x2329	;LEFT-POINTING ANGLE BRACKET
      #x232A	;RIGHT-POINTING ANGLE BRACKET
      #x23B4	;TOP SQUARE BRACKET
      #x23B5	;BOTTOM SQUARE BRACKET
      #x23B6	;BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET
      #x2768	;MEDIUM LEFT PARENTHESIS ORNAMENT
      #x2769	;MEDIUM RIGHT PARENTHESIS ORNAMENT
      #x276A	;MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT
      #x276B	;MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT
      #x276C	;MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT
      #x276D	;MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT
      #x276E	;HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT
      #x276F	;HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT
      #x2770	;HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT
      #x2771	;HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT
      #x2772	;LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT
      #x2773	;LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT
      #x2774	;MEDIUM LEFT CURLY BRACKET ORNAMENT
      #x2775	;MEDIUM RIGHT CURLY BRACKET ORNAMENT
      #x27E6	;MATHEMATICAL LEFT WHITE SQUARE BRACKET
      #x27E7	;MATHEMATICAL RIGHT WHITE SQUARE BRACKET
      #x27E8	;MATHEMATICAL LEFT ANGLE BRACKET
      #x27E9	;MATHEMATICAL RIGHT ANGLE BRACKET
      #x27EA	;MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
      #x27EB	;MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
      #x2983	;LEFT WHITE CURLY BRACKET
      #x2984	;RIGHT WHITE CURLY BRACKET
      #x2985	;LEFT WHITE PARENTHESIS
      #x2986	;RIGHT WHITE PARENTHESIS
      #x2987	;Z NOTATION LEFT IMAGE BRACKET
      #x2988	;Z NOTATION RIGHT IMAGE BRACKET
      #x2989	;Z NOTATION LEFT BINDING BRACKET
      #x298A	;Z NOTATION RIGHT BINDING BRACKET
      #x298B	;LEFT SQUARE BRACKET WITH UNDERBAR
      #x298C	;RIGHT SQUARE BRACKET WITH UNDERBAR
      #x298D	;LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
      #x298E	;RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
      #x298F	;LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
      #x2990	;RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
      #x2991	;LEFT ANGLE BRACKET WITH DOT
      #x2992	;RIGHT ANGLE BRACKET WITH DOT
      #x2993	;LEFT ARC LESS-THAN BRACKET
      #x2994	;RIGHT ARC GREATER-THAN BRACKET
      #x2995	;DOUBLE LEFT ARC GREATER-THAN BRACKET
      #x2996	;DOUBLE RIGHT ARC LESS-THAN BRACKET
      #x2997	;LEFT BLACK TORTOISE SHELL BRACKET
      #x2998	;RIGHT BLACK TORTOISE SHELL BRACKET
      #x29D8	;LEFT WIGGLY FENCE
      #x29D9	;RIGHT WIGGLY FENCE
      #x29DA	;LEFT DOUBLE WIGGLY FENCE
      #x29DB	;RIGHT DOUBLE WIGGLY FENCE
      #x29FC	;LEFT-POINTING CURVED ANGLE BRACKET
      #x29FD	;RIGHT-POINTING CURVED ANGLE BRACKET
      #x3001	;IDEOGRAPHIC COMMA
      #x3002	;IDEOGRAPHIC FULL STOP
      #x3003	;DITTO MARK
      #x3008	;LEFT ANGLE BRACKET
      #x3009	;RIGHT ANGLE BRACKET
      #x300A	;LEFT DOUBLE ANGLE BRACKET
      #x300B	;RIGHT DOUBLE ANGLE BRACKET
      #x300C	;LEFT CORNER BRACKET
      #x300D	;RIGHT CORNER BRACKET
      #x300E	;LEFT WHITE CORNER BRACKET
      #x300F	;RIGHT WHITE CORNER BRACKET
      #x3010	;LEFT BLACK LENTICULAR BRACKET
      #x3011	;RIGHT BLACK LENTICULAR BRACKET
      #x3014	;LEFT TORTOISE SHELL BRACKET
      #x3015	;RIGHT TORTOISE SHELL BRACKET
      #x3016	;LEFT WHITE LENTICULAR BRACKET
      #x3017	;RIGHT WHITE LENTICULAR BRACKET
      #x3018	;LEFT WHITE TORTOISE SHELL BRACKET
      #x3019	;RIGHT WHITE TORTOISE SHELL BRACKET
      #x301A	;LEFT WHITE SQUARE BRACKET
      #x301B	;RIGHT WHITE SQUARE BRACKET
      #x301C	;WAVE DASH
      #x301D	;REVERSED DOUBLE PRIME QUOTATION MARK
      #x301E	;DOUBLE PRIME QUOTATION MARK
      #x301F	;LOW DOUBLE PRIME QUOTATION MARK
      #x3030	;WAVY DASH
      #x303D	;PART ALTERNATION MARK
      #x30A0	;KATAKANA-HIRAGANA DOUBLE HYPHEN
      #x30FB	;KATAKANA MIDDLE DOT
      #xFD3E	;ORNATE LEFT PARENTHESIS
      #xFD3F	;ORNATE RIGHT PARENTHESIS
      #xFE30	;PRESENTATION FORM FOR VERTICAL TWO DOT LEADER
      #xFE31	;PRESENTATION FORM FOR VERTICAL EM DASH
      #xFE32	;PRESENTATION FORM FOR VERTICAL EN DASH
      #xFE33	;PRESENTATION FORM FOR VERTICAL LOW LINE
      #xFE34	;PRESENTATION FORM FOR VERTICAL WAVY LOW LINE
      #xFE35	;PRESENTATION FORM FOR VERTICAL LEFT PARENTHESIS
      #xFE36	;PRESENTATION FORM FOR VERTICAL RIGHT PARENTHESIS
      #xFE37	;PRESENTATION FORM FOR VERTICAL LEFT CURLY BRACKET
      #xFE38	;PRESENTATION FORM FOR VERTICAL RIGHT CURLY BRACKET
      #xFE39	;PRESENTATION FORM FOR VERTICAL LEFT TORTOISE SHELL BRACKET
      #xFE3A	;PRESENTATION FORM FOR VERTICAL RIGHT TORTOISE SHELL BRACKET
      #xFE3B	;PRESENTATION FORM FOR VERTICAL LEFT BLACK LENTICULAR BRACKET
      #xFE3C	;PRESENTATION FORM FOR VERTICAL RIGHT BLACK LENTICULAR BRACKET
      #xFE3D	;PRESENTATION FORM FOR VERTICAL LEFT DOUBLE ANGLE BRACKET
      #xFE3E	;PRESENTATION FORM FOR VERTICAL RIGHT DOUBLE ANGLE BRACKET
      #xFE3F	;PRESENTATION FORM FOR VERTICAL LEFT ANGLE BRACKET
      #xFE40	;PRESENTATION FORM FOR VERTICAL RIGHT ANGLE BRACKET
      #xFE41	;PRESENTATION FORM FOR VERTICAL LEFT CORNER BRACKET
      #xFE42	;PRESENTATION FORM FOR VERTICAL RIGHT CORNER BRACKET
      #xFE43	;PRESENTATION FORM FOR VERTICAL LEFT WHITE CORNER BRACKET
      #xFE44	;PRESENTATION FORM FOR VERTICAL RIGHT WHITE CORNER BRACKET
      #xFE45	;SESAME DOT
      #xFE46	;WHITE SESAME DOT
      #xFE47	;PRESENTATION FORM FOR VERTICAL LEFT SQUARE BRACKET
      #xFE48	;PRESENTATION FORM FOR VERTICAL RIGHT SQUARE BRACKET
      #xFE49	;DASHED OVERLINE
      #xFE4A	;CENTRELINE OVERLINE
      #xFE4B	;WAVY OVERLINE
      #xFE4C	;DOUBLE WAVY OVERLINE
      #xFE4D	;DASHED LOW LINE
      #xFE4E	;CENTRELINE LOW LINE
      #xFE4F	;WAVY LOW LINE
      #xFE50	;SMALL COMMA
      #xFE51	;SMALL IDEOGRAPHIC COMMA
      #xFE52	;SMALL FULL STOP
      #xFE54	;SMALL SEMICOLON
      #xFE55	;SMALL COLON
      #xFE56	;SMALL QUESTION MARK
      #xFE57	;SMALL EXCLAMATION MARK
      #xFE58	;SMALL EM DASH
      #xFE59	;SMALL LEFT PARENTHESIS
      #xFE5A	;SMALL RIGHT PARENTHESIS
      #xFE5B	;SMALL LEFT CURLY BRACKET
      #xFE5C	;SMALL RIGHT CURLY BRACKET
      #xFE5D	;SMALL LEFT TORTOISE SHELL BRACKET
      #xFE5E	;SMALL RIGHT TORTOISE SHELL BRACKET
      #xFE5F	;SMALL NUMBER SIGN
      #xFE60	;SMALL AMPERSAND
      #xFE61	;SMALL ASTERISK
      #xFE63	;SMALL HYPHEN-MINUS
      #xFE68	;SMALL REVERSE SOLIDUS
      #xFE6A	;SMALL PERCENT SIGN
      #xFE6B	;SMALL COMMERCIAL AT
      #xFF01	;FULLWIDTH EXCLAMATION MARK
      #xFF02	;FULLWIDTH QUOTATION MARK
      #xFF03	;FULLWIDTH NUMBER SIGN
      #xFF05	;FULLWIDTH PERCENT SIGN
      #xFF06	;FULLWIDTH AMPERSAND
      #xFF07	;FULLWIDTH APOSTROPHE
      #xFF08	;FULLWIDTH LEFT PARENTHESIS
      #xFF09	;FULLWIDTH RIGHT PARENTHESIS
      #xFF0A	;FULLWIDTH ASTERISK
      #xFF0C	;FULLWIDTH COMMA
      #xFF0D	;FULLWIDTH HYPHEN-MINUS
      #xFF0E	;FULLWIDTH FULL STOP
      #xFF0F	;FULLWIDTH SOLIDUS
      #xFF1A	;FULLWIDTH COLON
      #xFF1B	;FULLWIDTH SEMICOLON
      #xFF1F	;FULLWIDTH QUESTION MARK
      #xFF20	;FULLWIDTH COMMERCIAL AT
      #xFF3B	;FULLWIDTH LEFT SQUARE BRACKET
      #xFF3C	;FULLWIDTH REVERSE SOLIDUS
      #xFF3D	;FULLWIDTH RIGHT SQUARE BRACKET
      #xFF3F	;FULLWIDTH LOW LINE
      #xFF5B	;FULLWIDTH LEFT CURLY BRACKET
      #xFF5D	;FULLWIDTH RIGHT CURLY BRACKET
      #xFF5F	;FULLWIDTH LEFT WHITE PARENTHESIS
      #xFF60	;FULLWIDTH RIGHT WHITE PARENTHESIS
      #xFF61	;HALFWIDTH IDEOGRAPHIC FULL STOP
      #xFF62	;HALFWIDTH LEFT CORNER BRACKET
      #xFF63	;HALFWIDTH RIGHT CORNER BRACKET
      #xFF64	;HALFWIDTH IDEOGRAPHIC COMMA
      #xFF65	;HALFWIDTH KATAKANA MIDDLE DOT
      #x10100	;AEGEAN WORD SEPARATOR LINE
      #x10101	;AEGEAN WORD SEPARATOR DOT
      #x1039F	;UGARITIC WORD DIVIDER
)))

(define char-set:symbol
  (build-char-set
   '( #x0024	;DOLLAR SIGN
      #x002B	;PLUS SIGN
      #x003C	;LESS-THAN SIGN
      #x003D	;EQUALS SIGN
      #x003E	;GREATER-THAN SIGN
      #x005E	;CIRCUMFLEX ACCENT
      #x0060	;GRAVE ACCENT
      #x007C	;VERTICAL LINE
      #x007E	;TILDE
      #x00A2	;CENT SIGN
      #x00A3	;POUND SIGN
      #x00A4	;CURRENCY SIGN
      #x00A5	;YEN SIGN
      #x00A6	;BROKEN BAR
      #x00A7	;SECTION SIGN
      #x00A8	;DIAERESIS
      #x00A9	;COPYRIGHT SIGN
      #x00AC	;NOT SIGN
      #x00AE	;REGISTERED SIGN
      #x00AF	;MACRON
      #x00B0	;DEGREE SIGN
      #x00B1	;PLUS-MINUS SIGN
      #x00B4	;ACUTE ACCENT
      #x00B6	;PILCROW SIGN
      #x00B8	;CEDILLA
      #x00D7	;MULTIPLICATION SIGN
      #x00F7	;DIVISION SIGN
      #x02C2	;MODIFIER LETTER LEFT ARROWHEAD
      #x02C3	;MODIFIER LETTER RIGHT ARROWHEAD
      #x02C4	;MODIFIER LETTER UP ARROWHEAD
      #x02C5	;MODIFIER LETTER DOWN ARROWHEAD
      #x02D2	;MODIFIER LETTER CENTRED RIGHT HALF RING
      #x02D3	;MODIFIER LETTER CENTRED LEFT HALF RING
      #x02D4	;MODIFIER LETTER UP TACK
      #x02D5	;MODIFIER LETTER DOWN TACK
      #x02D6	;MODIFIER LETTER PLUS SIGN
      #x02D7	;MODIFIER LETTER MINUS SIGN
      #x02D8	;BREVE
      #x02D9	;DOT ABOVE
      #x02DA	;RING ABOVE
      #x02DB	;OGONEK
      #x02DC	;SMALL TILDE
      #x02DD	;DOUBLE ACUTE ACCENT
      #x02DE	;MODIFIER LETTER RHOTIC HOOK
      #x02DF	;MODIFIER LETTER CROSS ACCENT
      #x02E5	;MODIFIER LETTER EXTRA-HIGH TONE BAR
      #x02E6	;MODIFIER LETTER HIGH TONE BAR
      #x02E7	;MODIFIER LETTER MID TONE BAR
      #x02E8	;MODIFIER LETTER LOW TONE BAR
      #x02E9	;MODIFIER LETTER EXTRA-LOW TONE BAR
      #x02EA	;MODIFIER LETTER YIN DEPARTING TONE MARK
      #x02EB	;MODIFIER LETTER YANG DEPARTING TONE MARK
      #x02EC	;MODIFIER LETTER VOICING
      #x02ED	;MODIFIER LETTER UNASPIRATED
      #x02EF	;MODIFIER LETTER LOW DOWN ARROWHEAD
      #x02F0	;MODIFIER LETTER LOW UP ARROWHEAD
      #x02F1	;MODIFIER LETTER LOW LEFT ARROWHEAD
      #x02F2	;MODIFIER LETTER LOW RIGHT ARROWHEAD
      #x02F3	;MODIFIER LETTER LOW RING
      #x02F4	;MODIFIER LETTER MIDDLE GRAVE ACCENT
      #x02F5	;MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT
      #x02F6	;MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT
      #x02F7	;MODIFIER LETTER LOW TILDE
      #x02F8	;MODIFIER LETTER RAISED COLON
      #x02F9	;MODIFIER LETTER BEGIN HIGH TONE
      #x02FA	;MODIFIER LETTER END HIGH TONE
      #x02FB	;MODIFIER LETTER BEGIN LOW TONE
      #x02FC	;MODIFIER LETTER END LOW TONE
      #x02FD	;MODIFIER LETTER SHELF
      #x02FE	;MODIFIER LETTER OPEN SHELF
      #x02FF	;MODIFIER LETTER LOW LEFT ARROW
      #x0374	;GREEK NUMERAL SIGN
      #x0375	;GREEK LOWER NUMERAL SIGN
      #x0384	;GREEK TONOS
      #x0385	;GREEK DIALYTIKA TONOS
      #x03F6	;GREEK REVERSED LUNATE EPSILON SYMBOL
      #x0482	;CYRILLIC THOUSANDS SIGN
      #x060E	;ARABIC POETIC VERSE SIGN
      #x060F	;ARABIC SIGN MISRA
      #x06E9	;ARABIC PLACE OF SAJDAH
      #x06FD	;ARABIC SIGN SINDHI AMPERSAND
      #x06FE	;ARABIC SIGN SINDHI POSTPOSITION MEN
      #x09F2	;BENGALI RUPEE MARK
      #x09F3	;BENGALI RUPEE SIGN
      #x09FA	;BENGALI ISSHAR
      #x0AF1	;GUJARATI RUPEE SIGN
      #x0B70	;ORIYA ISSHAR
      #x0BF3	;TAMIL DAY SIGN
      #x0BF4	;TAMIL MONTH SIGN
      #x0BF5	;TAMIL YEAR SIGN
      #x0BF6	;TAMIL DEBIT SIGN
      #x0BF7	;TAMIL CREDIT SIGN
      #x0BF8	;TAMIL AS ABOVE SIGN
      #x0BF9	;TAMIL RUPEE SIGN
      #x0BFA	;TAMIL NUMBER SIGN
      #x0E3F	;THAI CURRENCY SYMBOL BAHT
      #x0F01	;TIBETAN MARK GTER YIG MGO TRUNCATED A
      #x0F02	;TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA
      #x0F03	;TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA
      #x0F13	;TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN
      #x0F14	;TIBETAN MARK GTER TSHEG
      #x0F15	;TIBETAN LOGOTYPE SIGN CHAD RTAGS
      #x0F16	;TIBETAN LOGOTYPE SIGN LHAG RTAGS
      #x0F17	;TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS
      #x0F1A	;TIBETAN SIGN RDEL DKAR GCIG
      #x0F1B	;TIBETAN SIGN RDEL DKAR GNYIS
      #x0F1C	;TIBETAN SIGN RDEL DKAR GSUM
      #x0F1D	;TIBETAN SIGN RDEL NAG GCIG
      #x0F1E	;TIBETAN SIGN RDEL NAG GNYIS
      #x0F1F	;TIBETAN SIGN RDEL DKAR RDEL NAG
      #x0F34	;TIBETAN MARK BSDUS RTAGS
      #x0F36	;TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN
      #x0F38	;TIBETAN MARK CHE MGO
      #x0FBE	;TIBETAN KU RU KHA
      #x0FBF	;TIBETAN KU RU KHA BZHI MIG CAN
      #x0FC0	;TIBETAN CANTILLATION SIGN HEAVY BEAT
      #x0FC1	;TIBETAN CANTILLATION SIGN LIGHT BEAT
      #x0FC2	;TIBETAN CANTILLATION SIGN CANG TE-U
      #x0FC3	;TIBETAN CANTILLATION SIGN SBUB -CHAL
      #x0FC4	;TIBETAN SYMBOL DRIL BU
      #x0FC5	;TIBETAN SYMBOL RDO RJE
      #x0FC7	;TIBETAN SYMBOL RDO RJE RGYA GRAM
      #x0FC8	;TIBETAN SYMBOL PHUR PA
      #x0FC9	;TIBETAN SYMBOL NOR BU
      #x0FCA	;TIBETAN SYMBOL NOR BU NYIS -KHYIL
      #x0FCB	;TIBETAN SYMBOL NOR BU GSUM -KHYIL
      #x0FCC	;TIBETAN SYMBOL NOR BU BZHI -KHYIL
      #x0FCF	;TIBETAN SIGN RDEL NAG GSUM
      #x17DB	;KHMER CURRENCY SYMBOL RIEL
      #x1940	;LIMBU SIGN LOO
      #x19E0	;KHMER SYMBOL PATHAMASAT
      #x19E1	;KHMER SYMBOL MUOY KOET
      #x19E2	;KHMER SYMBOL PII KOET
      #x19E3	;KHMER SYMBOL BEI KOET
      #x19E4	;KHMER SYMBOL BUON KOET
      #x19E5	;KHMER SYMBOL PRAM KOET
      #x19E6	;KHMER SYMBOL PRAM-MUOY KOET
      #x19E7	;KHMER SYMBOL PRAM-PII KOET
      #x19E8	;KHMER SYMBOL PRAM-BEI KOET
      #x19E9	;KHMER SYMBOL PRAM-BUON KOET
      #x19EA	;KHMER SYMBOL DAP KOET
      #x19EB	;KHMER SYMBOL DAP-MUOY KOET
      #x19EC	;KHMER SYMBOL DAP-PII KOET
      #x19ED	;KHMER SYMBOL DAP-BEI KOET
      #x19EE	;KHMER SYMBOL DAP-BUON KOET
      #x19EF	;KHMER SYMBOL DAP-PRAM KOET
      #x19F0	;KHMER SYMBOL TUTEYASAT
      #x19F1	;KHMER SYMBOL MUOY ROC
      #x19F2	;KHMER SYMBOL PII ROC
      #x19F3	;KHMER SYMBOL BEI ROC
      #x19F4	;KHMER SYMBOL BUON ROC
      #x19F5	;KHMER SYMBOL PRAM ROC
      #x19F6	;KHMER SYMBOL PRAM-MUOY ROC
      #x19F7	;KHMER SYMBOL PRAM-PII ROC
      #x19F8	;KHMER SYMBOL PRAM-BEI ROC
      #x19F9	;KHMER SYMBOL PRAM-BUON ROC
      #x19FA	;KHMER SYMBOL DAP ROC
      #x19FB	;KHMER SYMBOL DAP-MUOY ROC
      #x19FC	;KHMER SYMBOL DAP-PII ROC
      #x19FD	;KHMER SYMBOL DAP-BEI ROC
      #x19FE	;KHMER SYMBOL DAP-BUON ROC
      #x19FF	;KHMER SYMBOL DAP-PRAM ROC
      #x1FBD	;GREEK KORONIS
      #x1FBF	;GREEK PSILI
      #x1FC0	;GREEK PERISPOMENI
      #x1FC1	;GREEK DIALYTIKA AND PERISPOMENI
      #x1FCD	;GREEK PSILI AND VARIA
      #x1FCE	;GREEK PSILI AND OXIA
      #x1FCF	;GREEK PSILI AND PERISPOMENI
      #x1FDD	;GREEK DASIA AND VARIA
      #x1FDE	;GREEK DASIA AND OXIA
      #x1FDF	;GREEK DASIA AND PERISPOMENI
      #x1FED	;GREEK DIALYTIKA AND VARIA
      #x1FEE	;GREEK DIALYTIKA AND OXIA
      #x1FEF	;GREEK VARIA
      #x1FFD	;GREEK OXIA
      #x1FFE	;GREEK DASIA
      #x2044	;FRACTION SLASH
      #x2052	;COMMERCIAL MINUS SIGN
      #x207A	;SUPERSCRIPT PLUS SIGN
      #x207B	;SUPERSCRIPT MINUS
      #x207C	;SUPERSCRIPT EQUALS SIGN
      #x208A	;SUBSCRIPT PLUS SIGN
      #x208B	;SUBSCRIPT MINUS
      #x208C	;SUBSCRIPT EQUALS SIGN
      #x20A0	;EURO-CURRENCY SIGN
      #x20A1	;COLON SIGN
      #x20A2	;CRUZEIRO SIGN
      #x20A3	;FRENCH FRANC SIGN
      #x20A4	;LIRA SIGN
      #x20A5	;MILL SIGN
      #x20A6	;NAIRA SIGN
      #x20A7	;PESETA SIGN
      #x20A8	;RUPEE SIGN
      #x20A9	;WON SIGN
      #x20AA	;NEW SHEQEL SIGN
      #x20AB	;DONG SIGN
      #x20AC	;EURO SIGN
      #x20AD	;KIP SIGN
      #x20AE	;TUGRIK SIGN
      #x20AF	;DRACHMA SIGN
      #x20B0	;GERMAN PENNY SIGN
      #x20B1	;PESO SIGN
      #x2100	;ACCOUNT OF
      #x2101	;ADDRESSED TO THE SUBJECT
      #x2103	;DEGREE CELSIUS
      #x2104	;CENTRE LINE SYMBOL
      #x2105	;CARE OF
      #x2106	;CADA UNA
      #x2108	;SCRUPLE
      #x2109	;DEGREE FAHRENHEIT
      #x2114	;L B BAR SYMBOL
      #x2116	;NUMERO SIGN
      #x2117	;SOUND RECORDING COPYRIGHT
      #x2118	;SCRIPT CAPITAL P
      #x211E	;PRESCRIPTION TAKE
      #x211F	;RESPONSE
      #x2120	;SERVICE MARK
      #x2121	;TELEPHONE SIGN
      #x2122	;TRADE MARK SIGN
      #x2123	;VERSICLE
      #x2125	;OUNCE SIGN
      #x2127	;INVERTED OHM SIGN
      #x2129	;TURNED GREEK SMALL LETTER IOTA
      #x212E	;ESTIMATED SYMBOL
      #x2132	;TURNED CAPITAL F
      #x213A	;ROTATED CAPITAL Q
      #x213B	;FACSIMILE SIGN
      #x2140	;DOUBLE-STRUCK N-ARY SUMMATION
      #x2141	;TURNED SANS-SERIF CAPITAL G
      #x2142	;TURNED SANS-SERIF CAPITAL L
      #x2143	;REVERSED SANS-SERIF CAPITAL L
      #x2144	;TURNED SANS-SERIF CAPITAL Y
      #x214A	;PROPERTY LINE
      #x214B	;TURNED AMPERSAND
      #x2190	;LEFTWARDS ARROW
      #x2191	;UPWARDS ARROW
      #x2192	;RIGHTWARDS ARROW
      #x2193	;DOWNWARDS ARROW
      #x2194	;LEFT RIGHT ARROW
      #x2195	;UP DOWN ARROW
      #x2196	;NORTH WEST ARROW
      #x2197	;NORTH EAST ARROW
      #x2198	;SOUTH EAST ARROW
      #x2199	;SOUTH WEST ARROW
      #x219A	;LEFTWARDS ARROW WITH STROKE
      #x219B	;RIGHTWARDS ARROW WITH STROKE
      #x219C	;LEFTWARDS WAVE ARROW
      #x219D	;RIGHTWARDS WAVE ARROW
      #x219E	;LEFTWARDS TWO HEADED ARROW
      #x219F	;UPWARDS TWO HEADED ARROW
      #x21A0	;RIGHTWARDS TWO HEADED ARROW
      #x21A1	;DOWNWARDS TWO HEADED ARROW
      #x21A2	;LEFTWARDS ARROW WITH TAIL
      #x21A3	;RIGHTWARDS ARROW WITH TAIL
      #x21A4	;LEFTWARDS ARROW FROM BAR
      #x21A5	;UPWARDS ARROW FROM BAR
      #x21A6	;RIGHTWARDS ARROW FROM BAR
      #x21A7	;DOWNWARDS ARROW FROM BAR
      #x21A8	;UP DOWN ARROW WITH BASE
      #x21A9	;LEFTWARDS ARROW WITH HOOK
      #x21AA	;RIGHTWARDS ARROW WITH HOOK
      #x21AB	;LEFTWARDS ARROW WITH LOOP
      #x21AC	;RIGHTWARDS ARROW WITH LOOP
      #x21AD	;LEFT RIGHT WAVE ARROW
      #x21AE	;LEFT RIGHT ARROW WITH STROKE
      #x21AF	;DOWNWARDS ZIGZAG ARROW
      #x21B0	;UPWARDS ARROW WITH TIP LEFTWARDS
      #x21B1	;UPWARDS ARROW WITH TIP RIGHTWARDS
      #x21B2	;DOWNWARDS ARROW WITH TIP LEFTWARDS
      #x21B3	;DOWNWARDS ARROW WITH TIP RIGHTWARDS
      #x21B4	;RIGHTWARDS ARROW WITH CORNER DOWNWARDS
      #x21B5	;DOWNWARDS ARROW WITH CORNER LEFTWARDS
      #x21B6	;ANTICLOCKWISE TOP SEMICIRCLE ARROW
      #x21B7	;CLOCKWISE TOP SEMICIRCLE ARROW
      #x21B8	;NORTH WEST ARROW TO LONG BAR
      #x21B9	;LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR
      #x21BA	;ANTICLOCKWISE OPEN CIRCLE ARROW
      #x21BB	;CLOCKWISE OPEN CIRCLE ARROW
      #x21BC	;LEFTWARDS HARPOON WITH BARB UPWARDS
      #x21BD	;LEFTWARDS HARPOON WITH BARB DOWNWARDS
      #x21BE	;UPWARDS HARPOON WITH BARB RIGHTWARDS
      #x21BF	;UPWARDS HARPOON WITH BARB LEFTWARDS
      #x21C0	;RIGHTWARDS HARPOON WITH BARB UPWARDS
      #x21C1	;RIGHTWARDS HARPOON WITH BARB DOWNWARDS
      #x21C2	;DOWNWARDS HARPOON WITH BARB RIGHTWARDS
      #x21C3	;DOWNWARDS HARPOON WITH BARB LEFTWARDS
      #x21C4	;RIGHTWARDS ARROW OVER LEFTWARDS ARROW
      #x21C5	;UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW
      #x21C6	;LEFTWARDS ARROW OVER RIGHTWARDS ARROW
      #x21C7	;LEFTWARDS PAIRED ARROWS
      #x21C8	;UPWARDS PAIRED ARROWS
      #x21C9	;RIGHTWARDS PAIRED ARROWS
      #x21CA	;DOWNWARDS PAIRED ARROWS
      #x21CB	;LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON
      #x21CC	;RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON
      #x21CD	;LEFTWARDS DOUBLE ARROW WITH STROKE
      #x21CE	;LEFT RIGHT DOUBLE ARROW WITH STROKE
      #x21CF	;RIGHTWARDS DOUBLE ARROW WITH STROKE
      #x21D0	;LEFTWARDS DOUBLE ARROW
      #x21D1	;UPWARDS DOUBLE ARROW
      #x21D2	;RIGHTWARDS DOUBLE ARROW
      #x21D3	;DOWNWARDS DOUBLE ARROW
      #x21D4	;LEFT RIGHT DOUBLE ARROW
      #x21D5	;UP DOWN DOUBLE ARROW
      #x21D6	;NORTH WEST DOUBLE ARROW
      #x21D7	;NORTH EAST DOUBLE ARROW
      #x21D8	;SOUTH EAST DOUBLE ARROW
      #x21D9	;SOUTH WEST DOUBLE ARROW
      #x21DA	;LEFTWARDS TRIPLE ARROW
      #x21DB	;RIGHTWARDS TRIPLE ARROW
      #x21DC	;LEFTWARDS SQUIGGLE ARROW
      #x21DD	;RIGHTWARDS SQUIGGLE ARROW
      #x21DE	;UPWARDS ARROW WITH DOUBLE STROKE
      #x21DF	;DOWNWARDS ARROW WITH DOUBLE STROKE
      #x21E0	;LEFTWARDS DASHED ARROW
      #x21E1	;UPWARDS DASHED ARROW
      #x21E2	;RIGHTWARDS DASHED ARROW
      #x21E3	;DOWNWARDS DASHED ARROW
      #x21E4	;LEFTWARDS ARROW TO BAR
      #x21E5	;RIGHTWARDS ARROW TO BAR
      #x21E6	;LEFTWARDS WHITE ARROW
      #x21E7	;UPWARDS WHITE ARROW
      #x21E8	;RIGHTWARDS WHITE ARROW
      #x21E9	;DOWNWARDS WHITE ARROW
      #x21EA	;UPWARDS WHITE ARROW FROM BAR
      #x21EB	;UPWARDS WHITE ARROW ON PEDESTAL
      #x21EC	;UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR
      #x21ED	;UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR
      #x21EE	;UPWARDS WHITE DOUBLE ARROW
      #x21EF	;UPWARDS WHITE DOUBLE ARROW ON PEDESTAL
      #x21F0	;RIGHTWARDS WHITE ARROW FROM WALL
      #x21F1	;NORTH WEST ARROW TO CORNER
      #x21F2	;SOUTH EAST ARROW TO CORNER
      #x21F3	;UP DOWN WHITE ARROW
      #x21F4	;RIGHT ARROW WITH SMALL CIRCLE
      #x21F5	;DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW
      #x21F6	;THREE RIGHTWARDS ARROWS
      #x21F7	;LEFTWARDS ARROW WITH VERTICAL STROKE
      #x21F8	;RIGHTWARDS ARROW WITH VERTICAL STROKE
      #x21F9	;LEFT RIGHT ARROW WITH VERTICAL STROKE
      #x21FA	;LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE
      #x21FB	;RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE
      #x21FC	;LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE
      #x21FD	;LEFTWARDS OPEN-HEADED ARROW
      #x21FE	;RIGHTWARDS OPEN-HEADED ARROW
      #x21FF	;LEFT RIGHT OPEN-HEADED ARROW
      #x2200	;FOR ALL
      #x2201	;COMPLEMENT
      #x2202	;PARTIAL DIFFERENTIAL
      #x2203	;THERE EXISTS
      #x2204	;THERE DOES NOT EXIST
      #x2205	;EMPTY SET
      #x2206	;INCREMENT
      #x2207	;NABLA
      #x2208	;ELEMENT OF
      #x2209	;NOT AN ELEMENT OF
      #x220A	;SMALL ELEMENT OF
      #x220B	;CONTAINS AS MEMBER
      #x220C	;DOES NOT CONTAIN AS MEMBER
      #x220D	;SMALL CONTAINS AS MEMBER
      #x220E	;END OF PROOF
      #x220F	;N-ARY PRODUCT
      #x2210	;N-ARY COPRODUCT
      #x2211	;N-ARY SUMMATION
      #x2212	;MINUS SIGN
      #x2213	;MINUS-OR-PLUS SIGN
      #x2214	;DOT PLUS
      #x2215	;DIVISION SLASH
      #x2216	;SET MINUS
      #x2217	;ASTERISK OPERATOR
      #x2218	;RING OPERATOR
      #x2219	;BULLET OPERATOR
      #x221A	;SQUARE ROOT
      #x221B	;CUBE ROOT
      #x221C	;FOURTH ROOT
      #x221D	;PROPORTIONAL TO
      #x221E	;INFINITY
      #x221F	;RIGHT ANGLE
      #x2220	;ANGLE
      #x2221	;MEASURED ANGLE
      #x2222	;SPHERICAL ANGLE
      #x2223	;DIVIDES
      #x2224	;DOES NOT DIVIDE
      #x2225	;PARALLEL TO
      #x2226	;NOT PARALLEL TO
      #x2227	;LOGICAL AND
      #x2228	;LOGICAL OR
      #x2229	;INTERSECTION
      #x222A	;UNION
      #x222B	;INTEGRAL
      #x222C	;DOUBLE INTEGRAL
      #x222D	;TRIPLE INTEGRAL
      #x222E	;CONTOUR INTEGRAL
      #x222F	;SURFACE INTEGRAL
      #x2230	;VOLUME INTEGRAL
      #x2231	;CLOCKWISE INTEGRAL
      #x2232	;CLOCKWISE CONTOUR INTEGRAL
      #x2233	;ANTICLOCKWISE CONTOUR INTEGRAL
      #x2234	;THEREFORE
      #x2235	;BECAUSE
      #x2236	;RATIO
      #x2237	;PROPORTION
      #x2238	;DOT MINUS
      #x2239	;EXCESS
      #x223A	;GEOMETRIC PROPORTION
      #x223B	;HOMOTHETIC
      #x223C	;TILDE OPERATOR
      #x223D	;REVERSED TILDE
      #x223E	;INVERTED LAZY S
      #x223F	;SINE WAVE
      #x2240	;WREATH PRODUCT
      #x2241	;NOT TILDE
      #x2242	;MINUS TILDE
      #x2243	;ASYMPTOTICALLY EQUAL TO
      #x2244	;NOT ASYMPTOTICALLY EQUAL TO
      #x2245	;APPROXIMATELY EQUAL TO
      #x2246	;APPROXIMATELY BUT NOT ACTUALLY EQUAL TO
      #x2247	;NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
      #x2248	;ALMOST EQUAL TO
      #x2249	;NOT ALMOST EQUAL TO
      #x224A	;ALMOST EQUAL OR EQUAL TO
      #x224B	;TRIPLE TILDE
      #x224C	;ALL EQUAL TO
      #x224D	;EQUIVALENT TO
      #x224E	;GEOMETRICALLY EQUIVALENT TO
      #x224F	;DIFFERENCE BETWEEN
      #x2250	;APPROACHES THE LIMIT
      #x2251	;GEOMETRICALLY EQUAL TO
      #x2252	;APPROXIMATELY EQUAL TO OR THE IMAGE OF
      #x2253	;IMAGE OF OR APPROXIMATELY EQUAL TO
      #x2254	;COLON EQUALS
      #x2255	;EQUALS COLON
      #x2256	;RING IN EQUAL TO
      #x2257	;RING EQUAL TO
      #x2258	;CORRESPONDS TO
      #x2259	;ESTIMATES
      #x225A	;EQUIANGULAR TO
      #x225B	;STAR EQUALS
      #x225C	;DELTA EQUAL TO
      #x225D	;EQUAL TO BY DEFINITION
      #x225E	;MEASURED BY
      #x225F	;QUESTIONED EQUAL TO
      #x2260	;NOT EQUAL TO
      #x2261	;IDENTICAL TO
      #x2262	;NOT IDENTICAL TO
      #x2263	;STRICTLY EQUIVALENT TO
      #x2264	;LESS-THAN OR EQUAL TO
      #x2265	;GREATER-THAN OR EQUAL TO
      #x2266	;LESS-THAN OVER EQUAL TO
      #x2267	;GREATER-THAN OVER EQUAL TO
      #x2268	;LESS-THAN BUT NOT EQUAL TO
      #x2269	;GREATER-THAN BUT NOT EQUAL TO
      #x226A	;MUCH LESS-THAN
      #x226B	;MUCH GREATER-THAN
      #x226C	;BETWEEN
      #x226D	;NOT EQUIVALENT TO
      #x226E	;NOT LESS-THAN
      #x226F	;NOT GREATER-THAN
      #x2270	;NEITHER LESS-THAN NOR EQUAL TO
      #x2271	;NEITHER GREATER-THAN NOR EQUAL TO
      #x2272	;LESS-THAN OR EQUIVALENT TO
      #x2273	;GREATER-THAN OR EQUIVALENT TO
      #x2274	;NEITHER LESS-THAN NOR EQUIVALENT TO
      #x2275	;NEITHER GREATER-THAN NOR EQUIVALENT TO
      #x2276	;LESS-THAN OR GREATER-THAN
      #x2277	;GREATER-THAN OR LESS-THAN
      #x2278	;NEITHER LESS-THAN NOR GREATER-THAN
      #x2279	;NEITHER GREATER-THAN NOR LESS-THAN
      #x227A	;PRECEDES
      #x227B	;SUCCEEDS
      #x227C	;PRECEDES OR EQUAL TO
      #x227D	;SUCCEEDS OR EQUAL TO
      #x227E	;PRECEDES OR EQUIVALENT TO
      #x227F	;SUCCEEDS OR EQUIVALENT TO
      #x2280	;DOES NOT PRECEDE
      #x2281	;DOES NOT SUCCEED
      #x2282	;SUBSET OF
      #x2283	;SUPERSET OF
      #x2284	;NOT A SUBSET OF
      #x2285	;NOT A SUPERSET OF
      #x2286	;SUBSET OF OR EQUAL TO
      #x2287	;SUPERSET OF OR EQUAL TO
      #x2288	;NEITHER A SUBSET OF NOR EQUAL TO
      #x2289	;NEITHER A SUPERSET OF NOR EQUAL TO
      #x228A	;SUBSET OF WITH NOT EQUAL TO
      #x228B	;SUPERSET OF WITH NOT EQUAL TO
      #x228C	;MULTISET
      #x228D	;MULTISET MULTIPLICATION
      #x228E	;MULTISET UNION
      #x228F	;SQUARE IMAGE OF
      #x2290	;SQUARE ORIGINAL OF
      #x2291	;SQUARE IMAGE OF OR EQUAL TO
      #x2292	;SQUARE ORIGINAL OF OR EQUAL TO
      #x2293	;SQUARE CAP
      #x2294	;SQUARE CUP
      #x2295	;CIRCLED PLUS
      #x2296	;CIRCLED MINUS
      #x2297	;CIRCLED TIMES
      #x2298	;CIRCLED DIVISION SLASH
      #x2299	;CIRCLED DOT OPERATOR
      #x229A	;CIRCLED RING OPERATOR
      #x229B	;CIRCLED ASTERISK OPERATOR
      #x229C	;CIRCLED EQUALS
      #x229D	;CIRCLED DASH
      #x229E	;SQUARED PLUS
      #x229F	;SQUARED MINUS
      #x22A0	;SQUARED TIMES
      #x22A1	;SQUARED DOT OPERATOR
      #x22A2	;RIGHT TACK
      #x22A3	;LEFT TACK
      #x22A4	;DOWN TACK
      #x22A5	;UP TACK
      #x22A6	;ASSERTION
      #x22A7	;MODELS
      #x22A8	;TRUE
      #x22A9	;FORCES
      #x22AA	;TRIPLE VERTICAL BAR RIGHT TURNSTILE
      #x22AB	;DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
      #x22AC	;DOES NOT PROVE
      #x22AD	;NOT TRUE
      #x22AE	;DOES NOT FORCE
      #x22AF	;NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
      #x22B0	;PRECEDES UNDER RELATION
      #x22B1	;SUCCEEDS UNDER RELATION
      #x22B2	;NORMAL SUBGROUP OF
      #x22B3	;CONTAINS AS NORMAL SUBGROUP
      #x22B4	;NORMAL SUBGROUP OF OR EQUAL TO
      #x22B5	;CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
      #x22B6	;ORIGINAL OF
      #x22B7	;IMAGE OF
      #x22B8	;MULTIMAP
      #x22B9	;HERMITIAN CONJUGATE MATRIX
      #x22BA	;INTERCALATE
      #x22BB	;XOR
      #x22BC	;NAND
      #x22BD	;NOR
      #x22BE	;RIGHT ANGLE WITH ARC
      #x22BF	;RIGHT TRIANGLE
      #x22C0	;N-ARY LOGICAL AND
      #x22C1	;N-ARY LOGICAL OR
      #x22C2	;N-ARY INTERSECTION
      #x22C3	;N-ARY UNION
      #x22C4	;DIAMOND OPERATOR
      #x22C5	;DOT OPERATOR
      #x22C6	;STAR OPERATOR
      #x22C7	;DIVISION TIMES
      #x22C8	;BOWTIE
      #x22C9	;LEFT NORMAL FACTOR SEMIDIRECT PRODUCT
      #x22CA	;RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT
      #x22CB	;LEFT SEMIDIRECT PRODUCT
      #x22CC	;RIGHT SEMIDIRECT PRODUCT
      #x22CD	;REVERSED TILDE EQUALS
      #x22CE	;CURLY LOGICAL OR
      #x22CF	;CURLY LOGICAL AND
      #x22D0	;DOUBLE SUBSET
      #x22D1	;DOUBLE SUPERSET
      #x22D2	;DOUBLE INTERSECTION
      #x22D3	;DOUBLE UNION
      #x22D4	;PITCHFORK
      #x22D5	;EQUAL AND PARALLEL TO
      #x22D6	;LESS-THAN WITH DOT
      #x22D7	;GREATER-THAN WITH DOT
      #x22D8	;VERY MUCH LESS-THAN
      #x22D9	;VERY MUCH GREATER-THAN
      #x22DA	;LESS-THAN EQUAL TO OR GREATER-THAN
      #x22DB	;GREATER-THAN EQUAL TO OR LESS-THAN
      #x22DC	;EQUAL TO OR LESS-THAN
      #x22DD	;EQUAL TO OR GREATER-THAN
      #x22DE	;EQUAL TO OR PRECEDES
      #x22DF	;EQUAL TO OR SUCCEEDS
      #x22E0	;DOES NOT PRECEDE OR EQUAL
      #x22E1	;DOES NOT SUCCEED OR EQUAL
      #x22E2	;NOT SQUARE IMAGE OF OR EQUAL TO
      #x22E3	;NOT SQUARE ORIGINAL OF OR EQUAL TO
      #x22E4	;SQUARE IMAGE OF OR NOT EQUAL TO
      #x22E5	;SQUARE ORIGINAL OF OR NOT EQUAL TO
      #x22E6	;LESS-THAN BUT NOT EQUIVALENT TO
      #x22E7	;GREATER-THAN BUT NOT EQUIVALENT TO
      #x22E8	;PRECEDES BUT NOT EQUIVALENT TO
      #x22E9	;SUCCEEDS BUT NOT EQUIVALENT TO
      #x22EA	;NOT NORMAL SUBGROUP OF
      #x22EB	;DOES NOT CONTAIN AS NORMAL SUBGROUP
      #x22EC	;NOT NORMAL SUBGROUP OF OR EQUAL TO
      #x22ED	;DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
      #x22EE	;VERTICAL ELLIPSIS
      #x22EF	;MIDLINE HORIZONTAL ELLIPSIS
      #x22F0	;UP RIGHT DIAGONAL ELLIPSIS
      #x22F1	;DOWN RIGHT DIAGONAL ELLIPSIS
      #x22F2	;ELEMENT OF WITH LONG HORIZONTAL STROKE
      #x22F3	;ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
      #x22F4	;SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
      #x22F5	;ELEMENT OF WITH DOT ABOVE
      #x22F6	;ELEMENT OF WITH OVERBAR
      #x22F7	;SMALL ELEMENT OF WITH OVERBAR
      #x22F8	;ELEMENT OF WITH UNDERBAR
      #x22F9	;ELEMENT OF WITH TWO HORIZONTAL STROKES
      #x22FA	;CONTAINS WITH LONG HORIZONTAL STROKE
      #x22FB	;CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
      #x22FC	;SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
      #x22FD	;CONTAINS WITH OVERBAR
      #x22FE	;SMALL CONTAINS WITH OVERBAR
      #x22FF	;Z NOTATION BAG MEMBERSHIP
      #x2300	;DIAMETER SIGN
      #x2301	;ELECTRIC ARROW
      #x2302	;HOUSE
      #x2303	;UP ARROWHEAD
      #x2304	;DOWN ARROWHEAD
      #x2305	;PROJECTIVE
      #x2306	;PERSPECTIVE
      #x2307	;WAVY LINE
      #x2308	;LEFT CEILING
      #x2309	;RIGHT CEILING
      #x230A	;LEFT FLOOR
      #x230B	;RIGHT FLOOR
      #x230C	;BOTTOM RIGHT CROP
      #x230D	;BOTTOM LEFT CROP
      #x230E	;TOP RIGHT CROP
      #x230F	;TOP LEFT CROP
      #x2310	;REVERSED NOT SIGN
      #x2311	;SQUARE LOZENGE
      #x2312	;ARC
      #x2313	;SEGMENT
      #x2314	;SECTOR
      #x2315	;TELEPHONE RECORDER
      #x2316	;POSITION INDICATOR
      #x2317	;VIEWDATA SQUARE
      #x2318	;PLACE OF INTEREST SIGN
      #x2319	;TURNED NOT SIGN
      #x231A	;WATCH
      #x231B	;HOURGLASS
      #x231C	;TOP LEFT CORNER
      #x231D	;TOP RIGHT CORNER
      #x231E	;BOTTOM LEFT CORNER
      #x231F	;BOTTOM RIGHT CORNER
      #x2320	;TOP HALF INTEGRAL
      #x2321	;BOTTOM HALF INTEGRAL
      #x2322	;FROWN
      #x2323	;SMILE
      #x2324	;UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS
      #x2325	;OPTION KEY
      #x2326	;ERASE TO THE RIGHT
      #x2327	;X IN A RECTANGLE BOX
      #x2328	;KEYBOARD
      #x232B	;ERASE TO THE LEFT
      #x232C	;BENZENE RING
      #x232D	;CYLINDRICITY
      #x232E	;ALL AROUND-PROFILE
      #x232F	;SYMMETRY
      #x2330	;TOTAL RUNOUT
      #x2331	;DIMENSION ORIGIN
      #x2332	;CONICAL TAPER
      #x2333	;SLOPE
      #x2334	;COUNTERBORE
      #x2335	;COUNTERSINK
      #x2336	;APL FUNCTIONAL SYMBOL I-BEAM
      #x2337	;APL FUNCTIONAL SYMBOL SQUISH QUAD
      #x2338	;APL FUNCTIONAL SYMBOL QUAD EQUAL
      #x2339	;APL FUNCTIONAL SYMBOL QUAD DIVIDE
      #x233A	;APL FUNCTIONAL SYMBOL QUAD DIAMOND
      #x233B	;APL FUNCTIONAL SYMBOL QUAD JOT
      #x233C	;APL FUNCTIONAL SYMBOL QUAD CIRCLE
      #x233D	;APL FUNCTIONAL SYMBOL CIRCLE STILE
      #x233E	;APL FUNCTIONAL SYMBOL CIRCLE JOT
      #x233F	;APL FUNCTIONAL SYMBOL SLASH BAR
      #x2340	;APL FUNCTIONAL SYMBOL BACKSLASH BAR
      #x2341	;APL FUNCTIONAL SYMBOL QUAD SLASH
      #x2342	;APL FUNCTIONAL SYMBOL QUAD BACKSLASH
      #x2343	;APL FUNCTIONAL SYMBOL QUAD LESS-THAN
      #x2344	;APL FUNCTIONAL SYMBOL QUAD GREATER-THAN
      #x2345	;APL FUNCTIONAL SYMBOL LEFTWARDS VANE
      #x2346	;APL FUNCTIONAL SYMBOL RIGHTWARDS VANE
      #x2347	;APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW
      #x2348	;APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW
      #x2349	;APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH
      #x234A	;APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR
      #x234B	;APL FUNCTIONAL SYMBOL DELTA STILE
      #x234C	;APL FUNCTIONAL SYMBOL QUAD DOWN CARET
      #x234D	;APL FUNCTIONAL SYMBOL QUAD DELTA
      #x234E	;APL FUNCTIONAL SYMBOL DOWN TACK JOT
      #x234F	;APL FUNCTIONAL SYMBOL UPWARDS VANE
      #x2350	;APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW
      #x2351	;APL FUNCTIONAL SYMBOL UP TACK OVERBAR
      #x2352	;APL FUNCTIONAL SYMBOL DEL STILE
      #x2353	;APL FUNCTIONAL SYMBOL QUAD UP CARET
      #x2354	;APL FUNCTIONAL SYMBOL QUAD DEL
      #x2355	;APL FUNCTIONAL SYMBOL UP TACK JOT
      #x2356	;APL FUNCTIONAL SYMBOL DOWNWARDS VANE
      #x2357	;APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW
      #x2358	;APL FUNCTIONAL SYMBOL QUOTE UNDERBAR
      #x2359	;APL FUNCTIONAL SYMBOL DELTA UNDERBAR
      #x235A	;APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR
      #x235B	;APL FUNCTIONAL SYMBOL JOT UNDERBAR
      #x235C	;APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR
      #x235D	;APL FUNCTIONAL SYMBOL UP SHOE JOT
      #x235E	;APL FUNCTIONAL SYMBOL QUOTE QUAD
      #x235F	;APL FUNCTIONAL SYMBOL CIRCLE STAR
      #x2360	;APL FUNCTIONAL SYMBOL QUAD COLON
      #x2361	;APL FUNCTIONAL SYMBOL UP TACK DIAERESIS
      #x2362	;APL FUNCTIONAL SYMBOL DEL DIAERESIS
      #x2363	;APL FUNCTIONAL SYMBOL STAR DIAERESIS
      #x2364	;APL FUNCTIONAL SYMBOL JOT DIAERESIS
      #x2365	;APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS
      #x2366	;APL FUNCTIONAL SYMBOL DOWN SHOE STILE
      #x2367	;APL FUNCTIONAL SYMBOL LEFT SHOE STILE
      #x2368	;APL FUNCTIONAL SYMBOL TILDE DIAERESIS
      #x2369	;APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS
      #x236A	;APL FUNCTIONAL SYMBOL COMMA BAR
      #x236B	;APL FUNCTIONAL SYMBOL DEL TILDE
      #x236C	;APL FUNCTIONAL SYMBOL ZILDE
      #x236D	;APL FUNCTIONAL SYMBOL STILE TILDE
      #x236E	;APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR
      #x236F	;APL FUNCTIONAL SYMBOL QUAD NOT EQUAL
      #x2370	;APL FUNCTIONAL SYMBOL QUAD QUESTION
      #x2371	;APL FUNCTIONAL SYMBOL DOWN CARET TILDE
      #x2372	;APL FUNCTIONAL SYMBOL UP CARET TILDE
      #x2373	;APL FUNCTIONAL SYMBOL IOTA
      #x2374	;APL FUNCTIONAL SYMBOL RHO
      #x2375	;APL FUNCTIONAL SYMBOL OMEGA
      #x2376	;APL FUNCTIONAL SYMBOL ALPHA UNDERBAR
      #x2377	;APL FUNCTIONAL SYMBOL EPSILON UNDERBAR
      #x2378	;APL FUNCTIONAL SYMBOL IOTA UNDERBAR
      #x2379	;APL FUNCTIONAL SYMBOL OMEGA UNDERBAR
      #x237A	;APL FUNCTIONAL SYMBOL ALPHA
      #x237B	;NOT CHECK MARK
      #x237C	;RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
      #x237D	;SHOULDERED OPEN BOX
      #x237E	;BELL SYMBOL
      #x237F	;VERTICAL LINE WITH MIDDLE DOT
      #x2380	;INSERTION SYMBOL
      #x2381	;CONTINUOUS UNDERLINE SYMBOL
      #x2382	;DISCONTINUOUS UNDERLINE SYMBOL
      #x2383	;EMPHASIS SYMBOL
      #x2384	;COMPOSITION SYMBOL
      #x2385	;WHITE SQUARE WITH CENTRE VERTICAL LINE
      #x2386	;ENTER SYMBOL
      #x2387	;ALTERNATIVE KEY SYMBOL
      #x2388	;HELM SYMBOL
      #x2389	;CIRCLED HORIZONTAL BAR WITH NOTCH
      #x238A	;CIRCLED TRIANGLE DOWN
      #x238B	;BROKEN CIRCLE WITH NORTHWEST ARROW
      #x238C	;UNDO SYMBOL
      #x238D	;MONOSTABLE SYMBOL
      #x238E	;HYSTERESIS SYMBOL
      #x238F	;OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL
      #x2390	;OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL
      #x2391	;PASSIVE-PULL-DOWN-OUTPUT SYMBOL
      #x2392	;PASSIVE-PULL-UP-OUTPUT SYMBOL
      #x2393	;DIRECT CURRENT SYMBOL FORM TWO
      #x2394	;SOFTWARE-FUNCTION SYMBOL
      #x2395	;APL FUNCTIONAL SYMBOL QUAD
      #x2396	;DECIMAL SEPARATOR KEY SYMBOL
      #x2397	;PREVIOUS PAGE
      #x2398	;NEXT PAGE
      #x2399	;PRINT SCREEN SYMBOL
      #x239A	;CLEAR SCREEN SYMBOL
      #x239B	;LEFT PARENTHESIS UPPER HOOK
      #x239C	;LEFT PARENTHESIS EXTENSION
      #x239D	;LEFT PARENTHESIS LOWER HOOK
      #x239E	;RIGHT PARENTHESIS UPPER HOOK
      #x239F	;RIGHT PARENTHESIS EXTENSION
      #x23A0	;RIGHT PARENTHESIS LOWER HOOK
      #x23A1	;LEFT SQUARE BRACKET UPPER CORNER
      #x23A2	;LEFT SQUARE BRACKET EXTENSION
      #x23A3	;LEFT SQUARE BRACKET LOWER CORNER
      #x23A4	;RIGHT SQUARE BRACKET UPPER CORNER
      #x23A5	;RIGHT SQUARE BRACKET EXTENSION
      #x23A6	;RIGHT SQUARE BRACKET LOWER CORNER
      #x23A7	;LEFT CURLY BRACKET UPPER HOOK
      #x23A8	;LEFT CURLY BRACKET MIDDLE PIECE
      #x23A9	;LEFT CURLY BRACKET LOWER HOOK
      #x23AA	;CURLY BRACKET EXTENSION
      #x23AB	;RIGHT CURLY BRACKET UPPER HOOK
      #x23AC	;RIGHT CURLY BRACKET MIDDLE PIECE
      #x23AD	;RIGHT CURLY BRACKET LOWER HOOK
      #x23AE	;INTEGRAL EXTENSION
      #x23AF	;HORIZONTAL LINE EXTENSION
      #x23B0	;UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION
      #x23B1	;UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION
      #x23B2	;SUMMATION TOP
      #x23B3	;SUMMATION BOTTOM
      #x23B7	;RADICAL SYMBOL BOTTOM
      #x23B8	;LEFT VERTICAL BOX LINE
      #x23B9	;RIGHT VERTICAL BOX LINE
      #x23BA	;HORIZONTAL SCAN LINE-1
      #x23BB	;HORIZONTAL SCAN LINE-3
      #x23BC	;HORIZONTAL SCAN LINE-7
      #x23BD	;HORIZONTAL SCAN LINE-9
      #x23BE	;DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT
      #x23BF	;DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT
      #x23C0	;DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE
      #x23C1	;DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE
      #x23C2	;DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE
      #x23C3	;DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE
      #x23C4	;DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE
      #x23C5	;DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE
      #x23C6	;DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE
      #x23C7	;DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE
      #x23C8	;DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE
      #x23C9	;DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL
      #x23CA	;DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL
      #x23CB	;DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT
      #x23CC	;DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT
      #x23CD	;SQUARE FOOT
      #x23CE	;RETURN SYMBOL
      #x23CF	;EJECT SYMBOL
      #x23D0	;VERTICAL LINE EXTENSION
      #x2400	;SYMBOL FOR NULL
      #x2401	;SYMBOL FOR START OF HEADING
      #x2402	;SYMBOL FOR START OF TEXT
      #x2403	;SYMBOL FOR END OF TEXT
      #x2404	;SYMBOL FOR END OF TRANSMISSION
      #x2405	;SYMBOL FOR ENQUIRY
      #x2406	;SYMBOL FOR ACKNOWLEDGE
      #x2407	;SYMBOL FOR BELL
      #x2408	;SYMBOL FOR BACKSPACE
      #x2409	;SYMBOL FOR HORIZONTAL TABULATION
      #x240A	;SYMBOL FOR LINE FEED
      #x240B	;SYMBOL FOR VERTICAL TABULATION
      #x240C	;SYMBOL FOR FORM FEED
      #x240D	;SYMBOL FOR CARRIAGE RETURN
      #x240E	;SYMBOL FOR SHIFT OUT
      #x240F	;SYMBOL FOR SHIFT IN
      #x2410	;SYMBOL FOR DATA LINK ESCAPE
      #x2411	;SYMBOL FOR DEVICE CONTROL ONE
      #x2412	;SYMBOL FOR DEVICE CONTROL TWO
      #x2413	;SYMBOL FOR DEVICE CONTROL THREE
      #x2414	;SYMBOL FOR DEVICE CONTROL FOUR
      #x2415	;SYMBOL FOR NEGATIVE ACKNOWLEDGE
      #x2416	;SYMBOL FOR SYNCHRONOUS IDLE
      #x2417	;SYMBOL FOR END OF TRANSMISSION BLOCK
      #x2418	;SYMBOL FOR CANCEL
      #x2419	;SYMBOL FOR END OF MEDIUM
      #x241A	;SYMBOL FOR SUBSTITUTE
      #x241B	;SYMBOL FOR ESCAPE
      #x241C	;SYMBOL FOR FILE SEPARATOR
      #x241D	;SYMBOL FOR GROUP SEPARATOR
      #x241E	;SYMBOL FOR RECORD SEPARATOR
      #x241F	;SYMBOL FOR UNIT SEPARATOR
      #x2420	;SYMBOL FOR SPACE
      #x2421	;SYMBOL FOR DELETE
      #x2422	;BLANK SYMBOL
      #x2423	;OPEN BOX
      #x2424	;SYMBOL FOR NEWLINE
      #x2425	;SYMBOL FOR DELETE FORM TWO
      #x2426	;SYMBOL FOR SUBSTITUTE FORM TWO
      #x2440	;OCR HOOK
      #x2441	;OCR CHAIR
      #x2442	;OCR FORK
      #x2443	;OCR INVERTED FORK
      #x2444	;OCR BELT BUCKLE
      #x2445	;OCR BOW TIE
      #x2446	;OCR BRANCH BANK IDENTIFICATION
      #x2447	;OCR AMOUNT OF CHECK
      #x2448	;OCR DASH
      #x2449	;OCR CUSTOMER ACCOUNT NUMBER
      #x244A	;OCR DOUBLE BACKSLASH
      #x249C	;PARENTHESIZED LATIN SMALL LETTER A
      #x249D	;PARENTHESIZED LATIN SMALL LETTER B
      #x249E	;PARENTHESIZED LATIN SMALL LETTER C
      #x249F	;PARENTHESIZED LATIN SMALL LETTER D
      #x24A0	;PARENTHESIZED LATIN SMALL LETTER E
      #x24A1	;PARENTHESIZED LATIN SMALL LETTER F
      #x24A2	;PARENTHESIZED LATIN SMALL LETTER G
      #x24A3	;PARENTHESIZED LATIN SMALL LETTER H
      #x24A4	;PARENTHESIZED LATIN SMALL LETTER I
      #x24A5	;PARENTHESIZED LATIN SMALL LETTER J
      #x24A6	;PARENTHESIZED LATIN SMALL LETTER K
      #x24A7	;PARENTHESIZED LATIN SMALL LETTER L
      #x24A8	;PARENTHESIZED LATIN SMALL LETTER M
      #x24A9	;PARENTHESIZED LATIN SMALL LETTER N
      #x24AA	;PARENTHESIZED LATIN SMALL LETTER O
      #x24AB	;PARENTHESIZED LATIN SMALL LETTER P
      #x24AC	;PARENTHESIZED LATIN SMALL LETTER Q
      #x24AD	;PARENTHESIZED LATIN SMALL LETTER R
      #x24AE	;PARENTHESIZED LATIN SMALL LETTER S
      #x24AF	;PARENTHESIZED LATIN SMALL LETTER T
      #x24B0	;PARENTHESIZED LATIN SMALL LETTER U
      #x24B1	;PARENTHESIZED LATIN SMALL LETTER V
      #x24B2	;PARENTHESIZED LATIN SMALL LETTER W
      #x24B3	;PARENTHESIZED LATIN SMALL LETTER X
      #x24B4	;PARENTHESIZED LATIN SMALL LETTER Y
      #x24B5	;PARENTHESIZED LATIN SMALL LETTER Z
      #x24B6	;CIRCLED LATIN CAPITAL LETTER A
      #x24B7	;CIRCLED LATIN CAPITAL LETTER B
      #x24B8	;CIRCLED LATIN CAPITAL LETTER C
      #x24B9	;CIRCLED LATIN CAPITAL LETTER D
      #x24BA	;CIRCLED LATIN CAPITAL LETTER E
      #x24BB	;CIRCLED LATIN CAPITAL LETTER F
      #x24BC	;CIRCLED LATIN CAPITAL LETTER G
      #x24BD	;CIRCLED LATIN CAPITAL LETTER H
      #x24BE	;CIRCLED LATIN CAPITAL LETTER I
      #x24BF	;CIRCLED LATIN CAPITAL LETTER J
      #x24C0	;CIRCLED LATIN CAPITAL LETTER K
      #x24C1	;CIRCLED LATIN CAPITAL LETTER L
      #x24C2	;CIRCLED LATIN CAPITAL LETTER M
      #x24C3	;CIRCLED LATIN CAPITAL LETTER N
      #x24C4	;CIRCLED LATIN CAPITAL LETTER O
      #x24C5	;CIRCLED LATIN CAPITAL LETTER P
      #x24C6	;CIRCLED LATIN CAPITAL LETTER Q
      #x24C7	;CIRCLED LATIN CAPITAL LETTER R
      #x24C8	;CIRCLED LATIN CAPITAL LETTER S
      #x24C9	;CIRCLED LATIN CAPITAL LETTER T
      #x24CA	;CIRCLED LATIN CAPITAL LETTER U
      #x24CB	;CIRCLED LATIN CAPITAL LETTER V
      #x24CC	;CIRCLED LATIN CAPITAL LETTER W
      #x24CD	;CIRCLED LATIN CAPITAL LETTER X
      #x24CE	;CIRCLED LATIN CAPITAL LETTER Y
      #x24CF	;CIRCLED LATIN CAPITAL LETTER Z
      #x24D0	;CIRCLED LATIN SMALL LETTER A
      #x24D1	;CIRCLED LATIN SMALL LETTER B
      #x24D2	;CIRCLED LATIN SMALL LETTER C
      #x24D3	;CIRCLED LATIN SMALL LETTER D
      #x24D4	;CIRCLED LATIN SMALL LETTER E
      #x24D5	;CIRCLED LATIN SMALL LETTER F
      #x24D6	;CIRCLED LATIN SMALL LETTER G
      #x24D7	;CIRCLED LATIN SMALL LETTER H
      #x24D8	;CIRCLED LATIN SMALL LETTER I
      #x24D9	;CIRCLED LATIN SMALL LETTER J
      #x24DA	;CIRCLED LATIN SMALL LETTER K
      #x24DB	;CIRCLED LATIN SMALL LETTER L
      #x24DC	;CIRCLED LATIN SMALL LETTER M
      #x24DD	;CIRCLED LATIN SMALL LETTER N
      #x24DE	;CIRCLED LATIN SMALL LETTER O
      #x24DF	;CIRCLED LATIN SMALL LETTER P
      #x24E0	;CIRCLED LATIN SMALL LETTER Q
      #x24E1	;CIRCLED LATIN SMALL LETTER R
      #x24E2	;CIRCLED LATIN SMALL LETTER S
      #x24E3	;CIRCLED LATIN SMALL LETTER T
      #x24E4	;CIRCLED LATIN SMALL LETTER U
      #x24E5	;CIRCLED LATIN SMALL LETTER V
      #x24E6	;CIRCLED LATIN SMALL LETTER W
      #x24E7	;CIRCLED LATIN SMALL LETTER X
      #x24E8	;CIRCLED LATIN SMALL LETTER Y
      #x24E9	;CIRCLED LATIN SMALL LETTER Z
      #x2500	;BOX DRAWINGS LIGHT HORIZONTAL
      #x2501	;BOX DRAWINGS HEAVY HORIZONTAL
      #x2502	;BOX DRAWINGS LIGHT VERTICAL
      #x2503	;BOX DRAWINGS HEAVY VERTICAL
      #x2504	;BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
      #x2505	;BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
      #x2506	;BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
      #x2507	;BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
      #x2508	;BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
      #x2509	;BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
      #x250A	;BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
      #x250B	;BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
      #x250C	;BOX DRAWINGS LIGHT DOWN AND RIGHT
      #x250D	;BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
      #x250E	;BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
      #x250F	;BOX DRAWINGS HEAVY DOWN AND RIGHT
      #x2510	;BOX DRAWINGS LIGHT DOWN AND LEFT
      #x2511	;BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
      #x2512	;BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
      #x2513	;BOX DRAWINGS HEAVY DOWN AND LEFT
      #x2514	;BOX DRAWINGS LIGHT UP AND RIGHT
      #x2515	;BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
      #x2516	;BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
      #x2517	;BOX DRAWINGS HEAVY UP AND RIGHT
      #x2518	;BOX DRAWINGS LIGHT UP AND LEFT
      #x2519	;BOX DRAWINGS UP LIGHT AND LEFT HEAVY
      #x251A	;BOX DRAWINGS UP HEAVY AND LEFT LIGHT
      #x251B	;BOX DRAWINGS HEAVY UP AND LEFT
      #x251C	;BOX DRAWINGS LIGHT VERTICAL AND RIGHT
      #x251D	;BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
      #x251E	;BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
      #x251F	;BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
      #x2520	;BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
      #x2521	;BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
      #x2522	;BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
      #x2523	;BOX DRAWINGS HEAVY VERTICAL AND RIGHT
      #x2524	;BOX DRAWINGS LIGHT VERTICAL AND LEFT
      #x2525	;BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
      #x2526	;BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
      #x2527	;BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
      #x2528	;BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
      #x2529	;BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
      #x252A	;BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
      #x252B	;BOX DRAWINGS HEAVY VERTICAL AND LEFT
      #x252C	;BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
      #x252D	;BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
      #x252E	;BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
      #x252F	;BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
      #x2530	;BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
      #x2531	;BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
      #x2532	;BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
      #x2533	;BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
      #x2534	;BOX DRAWINGS LIGHT UP AND HORIZONTAL
      #x2535	;BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
      #x2536	;BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
      #x2537	;BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
      #x2538	;BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
      #x2539	;BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
      #x253A	;BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
      #x253B	;BOX DRAWINGS HEAVY UP AND HORIZONTAL
      #x253C	;BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
      #x253D	;BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
      #x253E	;BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
      #x253F	;BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
      #x2540	;BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
      #x2541	;BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
      #x2542	;BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
      #x2543	;BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
      #x2544	;BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
      #x2545	;BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
      #x2546	;BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
      #x2547	;BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
      #x2548	;BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
      #x2549	;BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
      #x254A	;BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
      #x254B	;BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
      #x254C	;BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL
      #x254D	;BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL
      #x254E	;BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL
      #x254F	;BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL
      #x2550	;BOX DRAWINGS DOUBLE HORIZONTAL
      #x2551	;BOX DRAWINGS DOUBLE VERTICAL
      #x2552	;BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
      #x2553	;BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
      #x2554	;BOX DRAWINGS DOUBLE DOWN AND RIGHT
      #x2555	;BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
      #x2556	;BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
      #x2557	;BOX DRAWINGS DOUBLE DOWN AND LEFT
      #x2558	;BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
      #x2559	;BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
      #x255A	;BOX DRAWINGS DOUBLE UP AND RIGHT
      #x255B	;BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
      #x255C	;BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
      #x255D	;BOX DRAWINGS DOUBLE UP AND LEFT
      #x255E	;BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
      #x255F	;BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
      #x2560	;BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
      #x2561	;BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
      #x2562	;BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
      #x2563	;BOX DRAWINGS DOUBLE VERTICAL AND LEFT
      #x2564	;BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
      #x2565	;BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
      #x2566	;BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
      #x2567	;BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
      #x2568	;BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
      #x2569	;BOX DRAWINGS DOUBLE UP AND HORIZONTAL
      #x256A	;BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
      #x256B	;BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
      #x256C	;BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
      #x256D	;BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
      #x256E	;BOX DRAWINGS LIGHT ARC DOWN AND LEFT
      #x256F	;BOX DRAWINGS LIGHT ARC UP AND LEFT
      #x2570	;BOX DRAWINGS LIGHT ARC UP AND RIGHT
      #x2571	;BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
      #x2572	;BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
      #x2573	;BOX DRAWINGS LIGHT DIAGONAL CROSS
      #x2574	;BOX DRAWINGS LIGHT LEFT
      #x2575	;BOX DRAWINGS LIGHT UP
      #x2576	;BOX DRAWINGS LIGHT RIGHT
      #x2577	;BOX DRAWINGS LIGHT DOWN
      #x2578	;BOX DRAWINGS HEAVY LEFT
      #x2579	;BOX DRAWINGS HEAVY UP
      #x257A	;BOX DRAWINGS HEAVY RIGHT
      #x257B	;BOX DRAWINGS HEAVY DOWN
      #x257C	;BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT
      #x257D	;BOX DRAWINGS LIGHT UP AND HEAVY DOWN
      #x257E	;BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT
      #x257F	;BOX DRAWINGS HEAVY UP AND LIGHT DOWN
      #x2580	;UPPER HALF BLOCK
      #x2581	;LOWER ONE EIGHTH BLOCK
      #x2582	;LOWER ONE QUARTER BLOCK
      #x2583	;LOWER THREE EIGHTHS BLOCK
      #x2584	;LOWER HALF BLOCK
      #x2585	;LOWER FIVE EIGHTHS BLOCK
      #x2586	;LOWER THREE QUARTERS BLOCK
      #x2587	;LOWER SEVEN EIGHTHS BLOCK
      #x2588	;FULL BLOCK
      #x2589	;LEFT SEVEN EIGHTHS BLOCK
      #x258A	;LEFT THREE QUARTERS BLOCK
      #x258B	;LEFT FIVE EIGHTHS BLOCK
      #x258C	;LEFT HALF BLOCK
      #x258D	;LEFT THREE EIGHTHS BLOCK
      #x258E	;LEFT ONE QUARTER BLOCK
      #x258F	;LEFT ONE EIGHTH BLOCK
      #x2590	;RIGHT HALF BLOCK
      #x2591	;LIGHT SHADE
      #x2592	;MEDIUM SHADE
      #x2593	;DARK SHADE
      #x2594	;UPPER ONE EIGHTH BLOCK
      #x2595	;RIGHT ONE EIGHTH BLOCK
      #x2596	;QUADRANT LOWER LEFT
      #x2597	;QUADRANT LOWER RIGHT
      #x2598	;QUADRANT UPPER LEFT
      #x2599	;QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT
      #x259A	;QUADRANT UPPER LEFT AND LOWER RIGHT
      #x259B	;QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT
      #x259C	;QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT
      #x259D	;QUADRANT UPPER RIGHT
      #x259E	;QUADRANT UPPER RIGHT AND LOWER LEFT
      #x259F	;QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT
      #x25A0	;BLACK SQUARE
      #x25A1	;WHITE SQUARE
      #x25A2	;WHITE SQUARE WITH ROUNDED CORNERS
      #x25A3	;WHITE SQUARE CONTAINING BLACK SMALL SQUARE
      #x25A4	;SQUARE WITH HORIZONTAL FILL
      #x25A5	;SQUARE WITH VERTICAL FILL
      #x25A6	;SQUARE WITH ORTHOGONAL CROSSHATCH FILL
      #x25A7	;SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
      #x25A8	;SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
      #x25A9	;SQUARE WITH DIAGONAL CROSSHATCH FILL
      #x25AA	;BLACK SMALL SQUARE
      #x25AB	;WHITE SMALL SQUARE
      #x25AC	;BLACK RECTANGLE
      #x25AD	;WHITE RECTANGLE
      #x25AE	;BLACK VERTICAL RECTANGLE
      #x25AF	;WHITE VERTICAL RECTANGLE
      #x25B0	;BLACK PARALLELOGRAM
      #x25B1	;WHITE PARALLELOGRAM
      #x25B2	;BLACK UP-POINTING TRIANGLE
      #x25B3	;WHITE UP-POINTING TRIANGLE
      #x25B4	;BLACK UP-POINTING SMALL TRIANGLE
      #x25B5	;WHITE UP-POINTING SMALL TRIANGLE
      #x25B6	;BLACK RIGHT-POINTING TRIANGLE
      #x25B7	;WHITE RIGHT-POINTING TRIANGLE
      #x25B8	;BLACK RIGHT-POINTING SMALL TRIANGLE
      #x25B9	;WHITE RIGHT-POINTING SMALL TRIANGLE
      #x25BA	;BLACK RIGHT-POINTING POINTER
      #x25BB	;WHITE RIGHT-POINTING POINTER
      #x25BC	;BLACK DOWN-POINTING TRIANGLE
      #x25BD	;WHITE DOWN-POINTING TRIANGLE
      #x25BE	;BLACK DOWN-POINTING SMALL TRIANGLE
      #x25BF	;WHITE DOWN-POINTING SMALL TRIANGLE
      #x25C0	;BLACK LEFT-POINTING TRIANGLE
      #x25C1	;WHITE LEFT-POINTING TRIANGLE
      #x25C2	;BLACK LEFT-POINTING SMALL TRIANGLE
      #x25C3	;WHITE LEFT-POINTING SMALL TRIANGLE
      #x25C4	;BLACK LEFT-POINTING POINTER
      #x25C5	;WHITE LEFT-POINTING POINTER
      #x25C6	;BLACK DIAMOND
      #x25C7	;WHITE DIAMOND
      #x25C8	;WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
      #x25C9	;FISHEYE
      #x25CA	;LOZENGE
      #x25CB	;WHITE CIRCLE
      #x25CC	;DOTTED CIRCLE
      #x25CD	;CIRCLE WITH VERTICAL FILL
      #x25CE	;BULLSEYE
      #x25CF	;BLACK CIRCLE
      #x25D0	;CIRCLE WITH LEFT HALF BLACK
      #x25D1	;CIRCLE WITH RIGHT HALF BLACK
      #x25D2	;CIRCLE WITH LOWER HALF BLACK
      #x25D3	;CIRCLE WITH UPPER HALF BLACK
      #x25D4	;CIRCLE WITH UPPER RIGHT QUADRANT BLACK
      #x25D5	;CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK
      #x25D6	;LEFT HALF BLACK CIRCLE
      #x25D7	;RIGHT HALF BLACK CIRCLE
      #x25D8	;INVERSE BULLET
      #x25D9	;INVERSE WHITE CIRCLE
      #x25DA	;UPPER HALF INVERSE WHITE CIRCLE
      #x25DB	;LOWER HALF INVERSE WHITE CIRCLE
      #x25DC	;UPPER LEFT QUADRANT CIRCULAR ARC
      #x25DD	;UPPER RIGHT QUADRANT CIRCULAR ARC
      #x25DE	;LOWER RIGHT QUADRANT CIRCULAR ARC
      #x25DF	;LOWER LEFT QUADRANT CIRCULAR ARC
      #x25E0	;UPPER HALF CIRCLE
      #x25E1	;LOWER HALF CIRCLE
      #x25E2	;BLACK LOWER RIGHT TRIANGLE
      #x25E3	;BLACK LOWER LEFT TRIANGLE
      #x25E4	;BLACK UPPER LEFT TRIANGLE
      #x25E5	;BLACK UPPER RIGHT TRIANGLE
      #x25E6	;WHITE BULLET
      #x25E7	;SQUARE WITH LEFT HALF BLACK
      #x25E8	;SQUARE WITH RIGHT HALF BLACK
      #x25E9	;SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK
      #x25EA	;SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK
      #x25EB	;WHITE SQUARE WITH VERTICAL BISECTING LINE
      #x25EC	;WHITE UP-POINTING TRIANGLE WITH DOT
      #x25ED	;UP-POINTING TRIANGLE WITH LEFT HALF BLACK
      #x25EE	;UP-POINTING TRIANGLE WITH RIGHT HALF BLACK
      #x25EF	;LARGE CIRCLE
      #x25F0	;WHITE SQUARE WITH UPPER LEFT QUADRANT
      #x25F1	;WHITE SQUARE WITH LOWER LEFT QUADRANT
      #x25F2	;WHITE SQUARE WITH LOWER RIGHT QUADRANT
      #x25F3	;WHITE SQUARE WITH UPPER RIGHT QUADRANT
      #x25F4	;WHITE CIRCLE WITH UPPER LEFT QUADRANT
      #x25F5	;WHITE CIRCLE WITH LOWER LEFT QUADRANT
      #x25F6	;WHITE CIRCLE WITH LOWER RIGHT QUADRANT
      #x25F7	;WHITE CIRCLE WITH UPPER RIGHT QUADRANT
      #x25F8	;UPPER LEFT TRIANGLE
      #x25F9	;UPPER RIGHT TRIANGLE
      #x25FA	;LOWER LEFT TRIANGLE
      #x25FB	;WHITE MEDIUM SQUARE
      #x25FC	;BLACK MEDIUM SQUARE
      #x25FD	;WHITE MEDIUM SMALL SQUARE
      #x25FE	;BLACK MEDIUM SMALL SQUARE
      #x25FF	;LOWER RIGHT TRIANGLE
      #x2600	;BLACK SUN WITH RAYS
      #x2601	;CLOUD
      #x2602	;UMBRELLA
      #x2603	;SNOWMAN
      #x2604	;COMET
      #x2605	;BLACK STAR
      #x2606	;WHITE STAR
      #x2607	;LIGHTNING
      #x2608	;THUNDERSTORM
      #x2609	;SUN
      #x260A	;ASCENDING NODE
      #x260B	;DESCENDING NODE
      #x260C	;CONJUNCTION
      #x260D	;OPPOSITION
      #x260E	;BLACK TELEPHONE
      #x260F	;WHITE TELEPHONE
      #x2610	;BALLOT BOX
      #x2611	;BALLOT BOX WITH CHECK
      #x2612	;BALLOT BOX WITH X
      #x2613	;SALTIRE
      #x2614	;UMBRELLA WITH RAIN DROPS
      #x2615	;HOT BEVERAGE
      #x2616	;WHITE SHOGI PIECE
      #x2617	;BLACK SHOGI PIECE
      #x2619	;REVERSED ROTATED FLORAL HEART BULLET
      #x261A	;BLACK LEFT POINTING INDEX
      #x261B	;BLACK RIGHT POINTING INDEX
      #x261C	;WHITE LEFT POINTING INDEX
      #x261D	;WHITE UP POINTING INDEX
      #x261E	;WHITE RIGHT POINTING INDEX
      #x261F	;WHITE DOWN POINTING INDEX
      #x2620	;SKULL AND CROSSBONES
      #x2621	;CAUTION SIGN
      #x2622	;RADIOACTIVE SIGN
      #x2623	;BIOHAZARD SIGN
      #x2624	;CADUCEUS
      #x2625	;ANKH
      #x2626	;ORTHODOX CROSS
      #x2627	;CHI RHO
      #x2628	;CROSS OF LORRAINE
      #x2629	;CROSS OF JERUSALEM
      #x262A	;STAR AND CRESCENT
      #x262B	;FARSI SYMBOL
      #x262C	;ADI SHAKTI
      #x262D	;HAMMER AND SICKLE
      #x262E	;PEACE SYMBOL
      #x262F	;YIN YANG
      #x2630	;TRIGRAM FOR HEAVEN
      #x2631	;TRIGRAM FOR LAKE
      #x2632	;TRIGRAM FOR FIRE
      #x2633	;TRIGRAM FOR THUNDER
      #x2634	;TRIGRAM FOR WIND
      #x2635	;TRIGRAM FOR WATER
      #x2636	;TRIGRAM FOR MOUNTAIN
      #x2637	;TRIGRAM FOR EARTH
      #x2638	;WHEEL OF DHARMA
      #x2639	;WHITE FROWNING FACE
      #x263A	;WHITE SMILING FACE
      #x263B	;BLACK SMILING FACE
      #x263C	;WHITE SUN WITH RAYS
      #x263D	;FIRST QUARTER MOON
      #x263E	;LAST QUARTER MOON
      #x263F	;MERCURY
      #x2640	;FEMALE SIGN
      #x2641	;EARTH
      #x2642	;MALE SIGN
      #x2643	;JUPITER
      #x2644	;SATURN
      #x2645	;URANUS
      #x2646	;NEPTUNE
      #x2647	;PLUTO
      #x2648	;ARIES
      #x2649	;TAURUS
      #x264A	;GEMINI
      #x264B	;CANCER
      #x264C	;LEO
      #x264D	;VIRGO
      #x264E	;LIBRA
      #x264F	;SCORPIUS
      #x2650	;SAGITTARIUS
      #x2651	;CAPRICORN
      #x2652	;AQUARIUS
      #x2653	;PISCES
      #x2654	;WHITE CHESS KING
      #x2655	;WHITE CHESS QUEEN
      #x2656	;WHITE CHESS ROOK
      #x2657	;WHITE CHESS BISHOP
      #x2658	;WHITE CHESS KNIGHT
      #x2659	;WHITE CHESS PAWN
      #x265A	;BLACK CHESS KING
      #x265B	;BLACK CHESS QUEEN
      #x265C	;BLACK CHESS ROOK
      #x265D	;BLACK CHESS BISHOP
      #x265E	;BLACK CHESS KNIGHT
      #x265F	;BLACK CHESS PAWN
      #x2660	;BLACK SPADE SUIT
      #x2661	;WHITE HEART SUIT
      #x2662	;WHITE DIAMOND SUIT
      #x2663	;BLACK CLUB SUIT
      #x2664	;WHITE SPADE SUIT
      #x2665	;BLACK HEART SUIT
      #x2666	;BLACK DIAMOND SUIT
      #x2667	;WHITE CLUB SUIT
      #x2668	;HOT SPRINGS
      #x2669	;QUARTER NOTE
      #x266A	;EIGHTH NOTE
      #x266B	;BEAMED EIGHTH NOTES
      #x266C	;BEAMED SIXTEENTH NOTES
      #x266D	;MUSIC FLAT SIGN
      #x266E	;MUSIC NATURAL SIGN
      #x266F	;MUSIC SHARP SIGN
      #x2670	;WEST SYRIAC CROSS
      #x2671	;EAST SYRIAC CROSS
      #x2672	;UNIVERSAL RECYCLING SYMBOL
      #x2673	;RECYCLING SYMBOL FOR TYPE-1 PLASTICS
      #x2674	;RECYCLING SYMBOL FOR TYPE-2 PLASTICS
      #x2675	;RECYCLING SYMBOL FOR TYPE-3 PLASTICS
      #x2676	;RECYCLING SYMBOL FOR TYPE-4 PLASTICS
      #x2677	;RECYCLING SYMBOL FOR TYPE-5 PLASTICS
      #x2678	;RECYCLING SYMBOL FOR TYPE-6 PLASTICS
      #x2679	;RECYCLING SYMBOL FOR TYPE-7 PLASTICS
      #x267A	;RECYCLING SYMBOL FOR GENERIC MATERIALS
      #x267B	;BLACK UNIVERSAL RECYCLING SYMBOL
      #x267C	;RECYCLED PAPER SYMBOL
      #x267D	;PARTIALLY-RECYCLED PAPER SYMBOL
      #x2680	;DIE FACE-1
      #x2681	;DIE FACE-2
      #x2682	;DIE FACE-3
      #x2683	;DIE FACE-4
      #x2684	;DIE FACE-5
      #x2685	;DIE FACE-6
      #x2686	;WHITE CIRCLE WITH DOT RIGHT
      #x2687	;WHITE CIRCLE WITH TWO DOTS
      #x2688	;BLACK CIRCLE WITH WHITE DOT RIGHT
      #x2689	;BLACK CIRCLE WITH TWO WHITE DOTS
      #x268A	;MONOGRAM FOR YANG
      #x268B	;MONOGRAM FOR YIN
      #x268C	;DIGRAM FOR GREATER YANG
      #x268D	;DIGRAM FOR LESSER YIN
      #x268E	;DIGRAM FOR LESSER YANG
      #x268F	;DIGRAM FOR GREATER YIN
      #x2690	;WHITE FLAG
      #x2691	;BLACK FLAG
      #x26A0	;WARNING SIGN
      #x26A1	;HIGH VOLTAGE SIGN
      #x2701	;UPPER BLADE SCISSORS
      #x2702	;BLACK SCISSORS
      #x2703	;LOWER BLADE SCISSORS
      #x2704	;WHITE SCISSORS
      #x2706	;TELEPHONE LOCATION SIGN
      #x2707	;TAPE DRIVE
      #x2708	;AIRPLANE
      #x2709	;ENVELOPE
      #x270C	;VICTORY HAND
      #x270D	;WRITING HAND
      #x270E	;LOWER RIGHT PENCIL
      #x270F	;PENCIL
      #x2710	;UPPER RIGHT PENCIL
      #x2711	;WHITE NIB
      #x2712	;BLACK NIB
      #x2713	;CHECK MARK
      #x2714	;HEAVY CHECK MARK
      #x2715	;MULTIPLICATION X
      #x2716	;HEAVY MULTIPLICATION X
      #x2717	;BALLOT X
      #x2718	;HEAVY BALLOT X
      #x2719	;OUTLINED GREEK CROSS
      #x271A	;HEAVY GREEK CROSS
      #x271B	;OPEN CENTRE CROSS
      #x271C	;HEAVY OPEN CENTRE CROSS
      #x271D	;LATIN CROSS
      #x271E	;SHADOWED WHITE LATIN CROSS
      #x271F	;OUTLINED LATIN CROSS
      #x2720	;MALTESE CROSS
      #x2721	;STAR OF DAVID
      #x2722	;FOUR TEARDROP-SPOKED ASTERISK
      #x2723	;FOUR BALLOON-SPOKED ASTERISK
      #x2724	;HEAVY FOUR BALLOON-SPOKED ASTERISK
      #x2725	;FOUR CLUB-SPOKED ASTERISK
      #x2726	;BLACK FOUR POINTED STAR
      #x2727	;WHITE FOUR POINTED STAR
      #x2729	;STRESS OUTLINED WHITE STAR
      #x272A	;CIRCLED WHITE STAR
      #x272B	;OPEN CENTRE BLACK STAR
      #x272C	;BLACK CENTRE WHITE STAR
      #x272D	;OUTLINED BLACK STAR
      #x272E	;HEAVY OUTLINED BLACK STAR
      #x272F	;PINWHEEL STAR
      #x2730	;SHADOWED WHITE STAR
      #x2731	;HEAVY ASTERISK
      #x2732	;OPEN CENTRE ASTERISK
      #x2733	;EIGHT SPOKED ASTERISK
      #x2734	;EIGHT POINTED BLACK STAR
      #x2735	;EIGHT POINTED PINWHEEL STAR
      #x2736	;SIX POINTED BLACK STAR
      #x2737	;EIGHT POINTED RECTILINEAR BLACK STAR
      #x2738	;HEAVY EIGHT POINTED RECTILINEAR BLACK STAR
      #x2739	;TWELVE POINTED BLACK STAR
      #x273A	;SIXTEEN POINTED ASTERISK
      #x273B	;TEARDROP-SPOKED ASTERISK
      #x273C	;OPEN CENTRE TEARDROP-SPOKED ASTERISK
      #x273D	;HEAVY TEARDROP-SPOKED ASTERISK
      #x273E	;SIX PETALLED BLACK AND WHITE FLORETTE
      #x273F	;BLACK FLORETTE
      #x2740	;WHITE FLORETTE
      #x2741	;EIGHT PETALLED OUTLINED BLACK FLORETTE
      #x2742	;CIRCLED OPEN CENTRE EIGHT POINTED STAR
      #x2743	;HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK
      #x2744	;SNOWFLAKE
      #x2745	;TIGHT TRIFOLIATE SNOWFLAKE
      #x2746	;HEAVY CHEVRON SNOWFLAKE
      #x2747	;SPARKLE
      #x2748	;HEAVY SPARKLE
      #x2749	;BALLOON-SPOKED ASTERISK
      #x274A	;EIGHT TEARDROP-SPOKED PROPELLER ASTERISK
      #x274B	;HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK
      #x274D	;SHADOWED WHITE CIRCLE
      #x274F	;LOWER RIGHT DROP-SHADOWED WHITE SQUARE
      #x2750	;UPPER RIGHT DROP-SHADOWED WHITE SQUARE
      #x2751	;LOWER RIGHT SHADOWED WHITE SQUARE
      #x2752	;UPPER RIGHT SHADOWED WHITE SQUARE
      #x2756	;BLACK DIAMOND MINUS WHITE X
      #x2758	;LIGHT VERTICAL BAR
      #x2759	;MEDIUM VERTICAL BAR
      #x275A	;HEAVY VERTICAL BAR
      #x275B	;HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT
      #x275C	;HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT
      #x275D	;HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT
      #x275E	;HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT
      #x2761	;CURVED STEM PARAGRAPH SIGN ORNAMENT
      #x2762	;HEAVY EXCLAMATION MARK ORNAMENT
      #x2763	;HEAVY HEART EXCLAMATION MARK ORNAMENT
      #x2764	;HEAVY BLACK HEART
      #x2765	;ROTATED HEAVY BLACK HEART BULLET
      #x2766	;FLORAL HEART
      #x2767	;ROTATED FLORAL HEART BULLET
      #x2794	;HEAVY WIDE-HEADED RIGHTWARDS ARROW
      #x2798	;HEAVY SOUTH EAST ARROW
      #x2799	;HEAVY RIGHTWARDS ARROW
      #x279A	;HEAVY NORTH EAST ARROW
      #x279B	;DRAFTING POINT RIGHTWARDS ARROW
      #x279C	;HEAVY ROUND-TIPPED RIGHTWARDS ARROW
      #x279D	;TRIANGLE-HEADED RIGHTWARDS ARROW
      #x279E	;HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW
      #x279F	;DASHED TRIANGLE-HEADED RIGHTWARDS ARROW
      #x27A0	;HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW
      #x27A1	;BLACK RIGHTWARDS ARROW
      #x27A2	;THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD
      #x27A3	;THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD
      #x27A4	;BLACK RIGHTWARDS ARROWHEAD
      #x27A5	;HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW
      #x27A6	;HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW
      #x27A7	;SQUAT BLACK RIGHTWARDS ARROW
      #x27A8	;HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW
      #x27A9	;RIGHT-SHADED WHITE RIGHTWARDS ARROW
      #x27AA	;LEFT-SHADED WHITE RIGHTWARDS ARROW
      #x27AB	;BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW
      #x27AC	;FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW
      #x27AD	;HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
      #x27AE	;HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
      #x27AF	;NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
      #x27B1	;NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
      #x27B2	;CIRCLED HEAVY WHITE RIGHTWARDS ARROW
      #x27B3	;WHITE-FEATHERED RIGHTWARDS ARROW
      #x27B4	;BLACK-FEATHERED SOUTH EAST ARROW
      #x27B5	;BLACK-FEATHERED RIGHTWARDS ARROW
      #x27B6	;BLACK-FEATHERED NORTH EAST ARROW
      #x27B7	;HEAVY BLACK-FEATHERED SOUTH EAST ARROW
      #x27B8	;HEAVY BLACK-FEATHERED RIGHTWARDS ARROW
      #x27B9	;HEAVY BLACK-FEATHERED NORTH EAST ARROW
      #x27BA	;TEARDROP-BARBED RIGHTWARDS ARROW
      #x27BB	;HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW
      #x27BC	;WEDGE-TAILED RIGHTWARDS ARROW
      #x27BD	;HEAVY WEDGE-TAILED RIGHTWARDS ARROW
      #x27BE	;OPEN-OUTLINED RIGHTWARDS ARROW
      #x27D0	;WHITE DIAMOND WITH CENTRED DOT
      #x27D1	;AND WITH DOT
      #x27D2	;ELEMENT OF OPENING UPWARDS
      #x27D3	;LOWER RIGHT CORNER WITH DOT
      #x27D4	;UPPER LEFT CORNER WITH DOT
      #x27D5	;LEFT OUTER JOIN
      #x27D6	;RIGHT OUTER JOIN
      #x27D7	;FULL OUTER JOIN
      #x27D8	;LARGE UP TACK
      #x27D9	;LARGE DOWN TACK
      #x27DA	;LEFT AND RIGHT DOUBLE TURNSTILE
      #x27DB	;LEFT AND RIGHT TACK
      #x27DC	;LEFT MULTIMAP
      #x27DD	;LONG RIGHT TACK
      #x27DE	;LONG LEFT TACK
      #x27DF	;UP TACK WITH CIRCLE ABOVE
      #x27E0	;LOZENGE DIVIDED BY HORIZONTAL RULE
      #x27E1	;WHITE CONCAVE-SIDED DIAMOND
      #x27E2	;WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK
      #x27E3	;WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK
      #x27E4	;WHITE SQUARE WITH LEFTWARDS TICK
      #x27E5	;WHITE SQUARE WITH RIGHTWARDS TICK
      #x27F0	;UPWARDS QUADRUPLE ARROW
      #x27F1	;DOWNWARDS QUADRUPLE ARROW
      #x27F2	;ANTICLOCKWISE GAPPED CIRCLE ARROW
      #x27F3	;CLOCKWISE GAPPED CIRCLE ARROW
      #x27F4	;RIGHT ARROW WITH CIRCLED PLUS
      #x27F5	;LONG LEFTWARDS ARROW
      #x27F6	;LONG RIGHTWARDS ARROW
      #x27F7	;LONG LEFT RIGHT ARROW
      #x27F8	;LONG LEFTWARDS DOUBLE ARROW
      #x27F9	;LONG RIGHTWARDS DOUBLE ARROW
      #x27FA	;LONG LEFT RIGHT DOUBLE ARROW
      #x27FB	;LONG LEFTWARDS ARROW FROM BAR
      #x27FC	;LONG RIGHTWARDS ARROW FROM BAR
      #x27FD	;LONG LEFTWARDS DOUBLE ARROW FROM BAR
      #x27FE	;LONG RIGHTWARDS DOUBLE ARROW FROM BAR
      #x27FF	;LONG RIGHTWARDS SQUIGGLE ARROW
      #x2800	;BRAILLE PATTERN BLANK
      #x2801	;BRAILLE PATTERN DOTS-1
      #x2802	;BRAILLE PATTERN DOTS-2
      #x2803	;BRAILLE PATTERN DOTS-12
      #x2804	;BRAILLE PATTERN DOTS-3
      #x2805	;BRAILLE PATTERN DOTS-13
      #x2806	;BRAILLE PATTERN DOTS-23
      #x2807	;BRAILLE PATTERN DOTS-123
      #x2808	;BRAILLE PATTERN DOTS-4
      #x2809	;BRAILLE PATTERN DOTS-14
      #x280A	;BRAILLE PATTERN DOTS-24
      #x280B	;BRAILLE PATTERN DOTS-124
      #x280C	;BRAILLE PATTERN DOTS-34
      #x280D	;BRAILLE PATTERN DOTS-134
      #x280E	;BRAILLE PATTERN DOTS-234
      #x280F	;BRAILLE PATTERN DOTS-1234
      #x2810	;BRAILLE PATTERN DOTS-5
      #x2811	;BRAILLE PATTERN DOTS-15
      #x2812	;BRAILLE PATTERN DOTS-25
      #x2813	;BRAILLE PATTERN DOTS-125
      #x2814	;BRAILLE PATTERN DOTS-35
      #x2815	;BRAILLE PATTERN DOTS-135
      #x2816	;BRAILLE PATTERN DOTS-235
      #x2817	;BRAILLE PATTERN DOTS-1235
      #x2818	;BRAILLE PATTERN DOTS-45
      #x2819	;BRAILLE PATTERN DOTS-145
      #x281A	;BRAILLE PATTERN DOTS-245
      #x281B	;BRAILLE PATTERN DOTS-1245
      #x281C	;BRAILLE PATTERN DOTS-345
      #x281D	;BRAILLE PATTERN DOTS-1345
      #x281E	;BRAILLE PATTERN DOTS-2345
      #x281F	;BRAILLE PATTERN DOTS-12345
      #x2820	;BRAILLE PATTERN DOTS-6
      #x2821	;BRAILLE PATTERN DOTS-16
      #x2822	;BRAILLE PATTERN DOTS-26
      #x2823	;BRAILLE PATTERN DOTS-126
      #x2824	;BRAILLE PATTERN DOTS-36
      #x2825	;BRAILLE PATTERN DOTS-136
      #x2826	;BRAILLE PATTERN DOTS-236
      #x2827	;BRAILLE PATTERN DOTS-1236
      #x2828	;BRAILLE PATTERN DOTS-46
      #x2829	;BRAILLE PATTERN DOTS-146
      #x282A	;BRAILLE PATTERN DOTS-246
      #x282B	;BRAILLE PATTERN DOTS-1246
      #x282C	;BRAILLE PATTERN DOTS-346
      #x282D	;BRAILLE PATTERN DOTS-1346
      #x282E	;BRAILLE PATTERN DOTS-2346
      #x282F	;BRAILLE PATTERN DOTS-12346
      #x2830	;BRAILLE PATTERN DOTS-56
      #x2831	;BRAILLE PATTERN DOTS-156
      #x2832	;BRAILLE PATTERN DOTS-256
      #x2833	;BRAILLE PATTERN DOTS-1256
      #x2834	;BRAILLE PATTERN DOTS-356
      #x2835	;BRAILLE PATTERN DOTS-1356
      #x2836	;BRAILLE PATTERN DOTS-2356
      #x2837	;BRAILLE PATTERN DOTS-12356
      #x2838	;BRAILLE PATTERN DOTS-456
      #x2839	;BRAILLE PATTERN DOTS-1456
      #x283A	;BRAILLE PATTERN DOTS-2456
      #x283B	;BRAILLE PATTERN DOTS-12456
      #x283C	;BRAILLE PATTERN DOTS-3456
      #x283D	;BRAILLE PATTERN DOTS-13456
      #x283E	;BRAILLE PATTERN DOTS-23456
      #x283F	;BRAILLE PATTERN DOTS-123456
      #x2840	;BRAILLE PATTERN DOTS-7
      #x2841	;BRAILLE PATTERN DOTS-17
      #x2842	;BRAILLE PATTERN DOTS-27
      #x2843	;BRAILLE PATTERN DOTS-127
      #x2844	;BRAILLE PATTERN DOTS-37
      #x2845	;BRAILLE PATTERN DOTS-137
      #x2846	;BRAILLE PATTERN DOTS-237
      #x2847	;BRAILLE PATTERN DOTS-1237
      #x2848	;BRAILLE PATTERN DOTS-47
      #x2849	;BRAILLE PATTERN DOTS-147
      #x284A	;BRAILLE PATTERN DOTS-247
      #x284B	;BRAILLE PATTERN DOTS-1247
      #x284C	;BRAILLE PATTERN DOTS-347
      #x284D	;BRAILLE PATTERN DOTS-1347
      #x284E	;BRAILLE PATTERN DOTS-2347
      #x284F	;BRAILLE PATTERN DOTS-12347
      #x2850	;BRAILLE PATTERN DOTS-57
      #x2851	;BRAILLE PATTERN DOTS-157
      #x2852	;BRAILLE PATTERN DOTS-257
      #x2853	;BRAILLE PATTERN DOTS-1257
      #x2854	;BRAILLE PATTERN DOTS-357
      #x2855	;BRAILLE PATTERN DOTS-1357
      #x2856	;BRAILLE PATTERN DOTS-2357
      #x2857	;BRAILLE PATTERN DOTS-12357
      #x2858	;BRAILLE PATTERN DOTS-457
      #x2859	;BRAILLE PATTERN DOTS-1457
      #x285A	;BRAILLE PATTERN DOTS-2457
      #x285B	;BRAILLE PATTERN DOTS-12457
      #x285C	;BRAILLE PATTERN DOTS-3457
      #x285D	;BRAILLE PATTERN DOTS-13457
      #x285E	;BRAILLE PATTERN DOTS-23457
      #x285F	;BRAILLE PATTERN DOTS-123457
      #x2860	;BRAILLE PATTERN DOTS-67
      #x2861	;BRAILLE PATTERN DOTS-167
      #x2862	;BRAILLE PATTERN DOTS-267
      #x2863	;BRAILLE PATTERN DOTS-1267
      #x2864	;BRAILLE PATTERN DOTS-367
      #x2865	;BRAILLE PATTERN DOTS-1367
      #x2866	;BRAILLE PATTERN DOTS-2367
      #x2867	;BRAILLE PATTERN DOTS-12367
      #x2868	;BRAILLE PATTERN DOTS-467
      #x2869	;BRAILLE PATTERN DOTS-1467
      #x286A	;BRAILLE PATTERN DOTS-2467
      #x286B	;BRAILLE PATTERN DOTS-12467
      #x286C	;BRAILLE PATTERN DOTS-3467
      #x286D	;BRAILLE PATTERN DOTS-13467
      #x286E	;BRAILLE PATTERN DOTS-23467
      #x286F	;BRAILLE PATTERN DOTS-123467
      #x2870	;BRAILLE PATTERN DOTS-567
      #x2871	;BRAILLE PATTERN DOTS-1567
      #x2872	;BRAILLE PATTERN DOTS-2567
      #x2873	;BRAILLE PATTERN DOTS-12567
      #x2874	;BRAILLE PATTERN DOTS-3567
      #x2875	;BRAILLE PATTERN DOTS-13567
      #x2876	;BRAILLE PATTERN DOTS-23567
      #x2877	;BRAILLE PATTERN DOTS-123567
      #x2878	;BRAILLE PATTERN DOTS-4567
      #x2879	;BRAILLE PATTERN DOTS-14567
      #x287A	;BRAILLE PATTERN DOTS-24567
      #x287B	;BRAILLE PATTERN DOTS-124567
      #x287C	;BRAILLE PATTERN DOTS-34567
      #x287D	;BRAILLE PATTERN DOTS-134567
      #x287E	;BRAILLE PATTERN DOTS-234567
      #x287F	;BRAILLE PATTERN DOTS-1234567
      #x2880	;BRAILLE PATTERN DOTS-8
      #x2881	;BRAILLE PATTERN DOTS-18
      #x2882	;BRAILLE PATTERN DOTS-28
      #x2883	;BRAILLE PATTERN DOTS-128
      #x2884	;BRAILLE PATTERN DOTS-38
      #x2885	;BRAILLE PATTERN DOTS-138
      #x2886	;BRAILLE PATTERN DOTS-238
      #x2887	;BRAILLE PATTERN DOTS-1238
      #x2888	;BRAILLE PATTERN DOTS-48
      #x2889	;BRAILLE PATTERN DOTS-148
      #x288A	;BRAILLE PATTERN DOTS-248
      #x288B	;BRAILLE PATTERN DOTS-1248
      #x288C	;BRAILLE PATTERN DOTS-348
      #x288D	;BRAILLE PATTERN DOTS-1348
      #x288E	;BRAILLE PATTERN DOTS-2348
      #x288F	;BRAILLE PATTERN DOTS-12348
      #x2890	;BRAILLE PATTERN DOTS-58
      #x2891	;BRAILLE PATTERN DOTS-158
      #x2892	;BRAILLE PATTERN DOTS-258
      #x2893	;BRAILLE PATTERN DOTS-1258
      #x2894	;BRAILLE PATTERN DOTS-358
      #x2895	;BRAILLE PATTERN DOTS-1358
      #x2896	;BRAILLE PATTERN DOTS-2358
      #x2897	;BRAILLE PATTERN DOTS-12358
      #x2898	;BRAILLE PATTERN DOTS-458
      #x2899	;BRAILLE PATTERN DOTS-1458
      #x289A	;BRAILLE PATTERN DOTS-2458
      #x289B	;BRAILLE PATTERN DOTS-12458
      #x289C	;BRAILLE PATTERN DOTS-3458
      #x289D	;BRAILLE PATTERN DOTS-13458
      #x289E	;BRAILLE PATTERN DOTS-23458
      #x289F	;BRAILLE PATTERN DOTS-123458
      #x28A0	;BRAILLE PATTERN DOTS-68
      #x28A1	;BRAILLE PATTERN DOTS-168
      #x28A2	;BRAILLE PATTERN DOTS-268
      #x28A3	;BRAILLE PATTERN DOTS-1268
      #x28A4	;BRAILLE PATTERN DOTS-368
      #x28A5	;BRAILLE PATTERN DOTS-1368
      #x28A6	;BRAILLE PATTERN DOTS-2368
      #x28A7	;BRAILLE PATTERN DOTS-12368
      #x28A8	;BRAILLE PATTERN DOTS-468
      #x28A9	;BRAILLE PATTERN DOTS-1468
      #x28AA	;BRAILLE PATTERN DOTS-2468
      #x28AB	;BRAILLE PATTERN DOTS-12468
      #x28AC	;BRAILLE PATTERN DOTS-3468
      #x28AD	;BRAILLE PATTERN DOTS-13468
      #x28AE	;BRAILLE PATTERN DOTS-23468
      #x28AF	;BRAILLE PATTERN DOTS-123468
      #x28B0	;BRAILLE PATTERN DOTS-568
      #x28B1	;BRAILLE PATTERN DOTS-1568
      #x28B2	;BRAILLE PATTERN DOTS-2568
      #x28B3	;BRAILLE PATTERN DOTS-12568
      #x28B4	;BRAILLE PATTERN DOTS-3568
      #x28B5	;BRAILLE PATTERN DOTS-13568
      #x28B6	;BRAILLE PATTERN DOTS-23568
      #x28B7	;BRAILLE PATTERN DOTS-123568
      #x28B8	;BRAILLE PATTERN DOTS-4568
      #x28B9	;BRAILLE PATTERN DOTS-14568
      #x28BA	;BRAILLE PATTERN DOTS-24568
      #x28BB	;BRAILLE PATTERN DOTS-124568
      #x28BC	;BRAILLE PATTERN DOTS-34568
      #x28BD	;BRAILLE PATTERN DOTS-134568
      #x28BE	;BRAILLE PATTERN DOTS-234568
      #x28BF	;BRAILLE PATTERN DOTS-1234568
      #x28C0	;BRAILLE PATTERN DOTS-78
      #x28C1	;BRAILLE PATTERN DOTS-178
      #x28C2	;BRAILLE PATTERN DOTS-278
      #x28C3	;BRAILLE PATTERN DOTS-1278
      #x28C4	;BRAILLE PATTERN DOTS-378
      #x28C5	;BRAILLE PATTERN DOTS-1378
      #x28C6	;BRAILLE PATTERN DOTS-2378
      #x28C7	;BRAILLE PATTERN DOTS-12378
      #x28C8	;BRAILLE PATTERN DOTS-478
      #x28C9	;BRAILLE PATTERN DOTS-1478
      #x28CA	;BRAILLE PATTERN DOTS-2478
      #x28CB	;BRAILLE PATTERN DOTS-12478
      #x28CC	;BRAILLE PATTERN DOTS-3478
      #x28CD	;BRAILLE PATTERN DOTS-13478
      #x28CE	;BRAILLE PATTERN DOTS-23478
      #x28CF	;BRAILLE PATTERN DOTS-123478
      #x28D0	;BRAILLE PATTERN DOTS-578
      #x28D1	;BRAILLE PATTERN DOTS-1578
      #x28D2	;BRAILLE PATTERN DOTS-2578
      #x28D3	;BRAILLE PATTERN DOTS-12578
      #x28D4	;BRAILLE PATTERN DOTS-3578
      #x28D5	;BRAILLE PATTERN DOTS-13578
      #x28D6	;BRAILLE PATTERN DOTS-23578
      #x28D7	;BRAILLE PATTERN DOTS-123578
      #x28D8	;BRAILLE PATTERN DOTS-4578
      #x28D9	;BRAILLE PATTERN DOTS-14578
      #x28DA	;BRAILLE PATTERN DOTS-24578
      #x28DB	;BRAILLE PATTERN DOTS-124578
      #x28DC	;BRAILLE PATTERN DOTS-34578
      #x28DD	;BRAILLE PATTERN DOTS-134578
      #x28DE	;BRAILLE PATTERN DOTS-234578
      #x28DF	;BRAILLE PATTERN DOTS-1234578
      #x28E0	;BRAILLE PATTERN DOTS-678
      #x28E1	;BRAILLE PATTERN DOTS-1678
      #x28E2	;BRAILLE PATTERN DOTS-2678
      #x28E3	;BRAILLE PATTERN DOTS-12678
      #x28E4	;BRAILLE PATTERN DOTS-3678
      #x28E5	;BRAILLE PATTERN DOTS-13678
      #x28E6	;BRAILLE PATTERN DOTS-23678
      #x28E7	;BRAILLE PATTERN DOTS-123678
      #x28E8	;BRAILLE PATTERN DOTS-4678
      #x28E9	;BRAILLE PATTERN DOTS-14678
      #x28EA	;BRAILLE PATTERN DOTS-24678
      #x28EB	;BRAILLE PATTERN DOTS-124678
      #x28EC	;BRAILLE PATTERN DOTS-34678
      #x28ED	;BRAILLE PATTERN DOTS-134678
      #x28EE	;BRAILLE PATTERN DOTS-234678
      #x28EF	;BRAILLE PATTERN DOTS-1234678
      #x28F0	;BRAILLE PATTERN DOTS-5678
      #x28F1	;BRAILLE PATTERN DOTS-15678
      #x28F2	;BRAILLE PATTERN DOTS-25678
      #x28F3	;BRAILLE PATTERN DOTS-125678
      #x28F4	;BRAILLE PATTERN DOTS-35678
      #x28F5	;BRAILLE PATTERN DOTS-135678
      #x28F6	;BRAILLE PATTERN DOTS-235678
      #x28F7	;BRAILLE PATTERN DOTS-1235678
      #x28F8	;BRAILLE PATTERN DOTS-45678
      #x28F9	;BRAILLE PATTERN DOTS-145678
      #x28FA	;BRAILLE PATTERN DOTS-245678
      #x28FB	;BRAILLE PATTERN DOTS-1245678
      #x28FC	;BRAILLE PATTERN DOTS-345678
      #x28FD	;BRAILLE PATTERN DOTS-1345678
      #x28FE	;BRAILLE PATTERN DOTS-2345678
      #x28FF	;BRAILLE PATTERN DOTS-12345678
      #x2900	;RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
      #x2901	;RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
      #x2902	;LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE
      #x2903	;RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE
      #x2904	;LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE
      #x2905	;RIGHTWARDS TWO-HEADED ARROW FROM BAR
      #x2906	;LEFTWARDS DOUBLE ARROW FROM BAR
      #x2907	;RIGHTWARDS DOUBLE ARROW FROM BAR
      #x2908	;DOWNWARDS ARROW WITH HORIZONTAL STROKE
      #x2909	;UPWARDS ARROW WITH HORIZONTAL STROKE
      #x290A	;UPWARDS TRIPLE ARROW
      #x290B	;DOWNWARDS TRIPLE ARROW
      #x290C	;LEFTWARDS DOUBLE DASH ARROW
      #x290D	;RIGHTWARDS DOUBLE DASH ARROW
      #x290E	;LEFTWARDS TRIPLE DASH ARROW
      #x290F	;RIGHTWARDS TRIPLE DASH ARROW
      #x2910	;RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW
      #x2911	;RIGHTWARDS ARROW WITH DOTTED STEM
      #x2912	;UPWARDS ARROW TO BAR
      #x2913	;DOWNWARDS ARROW TO BAR
      #x2914	;RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE
      #x2915	;RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
      #x2916	;RIGHTWARDS TWO-HEADED ARROW WITH TAIL
      #x2917	;RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE
      #x2918	;RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
      #x2919	;LEFTWARDS ARROW-TAIL
      #x291A	;RIGHTWARDS ARROW-TAIL
      #x291B	;LEFTWARDS DOUBLE ARROW-TAIL
      #x291C	;RIGHTWARDS DOUBLE ARROW-TAIL
      #x291D	;LEFTWARDS ARROW TO BLACK DIAMOND
      #x291E	;RIGHTWARDS ARROW TO BLACK DIAMOND
      #x291F	;LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND
      #x2920	;RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND
      #x2921	;NORTH WEST AND SOUTH EAST ARROW
      #x2922	;NORTH EAST AND SOUTH WEST ARROW
      #x2923	;NORTH WEST ARROW WITH HOOK
      #x2924	;NORTH EAST ARROW WITH HOOK
      #x2925	;SOUTH EAST ARROW WITH HOOK
      #x2926	;SOUTH WEST ARROW WITH HOOK
      #x2927	;NORTH WEST ARROW AND NORTH EAST ARROW
      #x2928	;NORTH EAST ARROW AND SOUTH EAST ARROW
      #x2929	;SOUTH EAST ARROW AND SOUTH WEST ARROW
      #x292A	;SOUTH WEST ARROW AND NORTH WEST ARROW
      #x292B	;RISING DIAGONAL CROSSING FALLING DIAGONAL
      #x292C	;FALLING DIAGONAL CROSSING RISING DIAGONAL
      #x292D	;SOUTH EAST ARROW CROSSING NORTH EAST ARROW
      #x292E	;NORTH EAST ARROW CROSSING SOUTH EAST ARROW
      #x292F	;FALLING DIAGONAL CROSSING NORTH EAST ARROW
      #x2930	;RISING DIAGONAL CROSSING SOUTH EAST ARROW
      #x2931	;NORTH EAST ARROW CROSSING NORTH WEST ARROW
      #x2932	;NORTH WEST ARROW CROSSING NORTH EAST ARROW
      #x2933	;WAVE ARROW POINTING DIRECTLY RIGHT
      #x2934	;ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS
      #x2935	;ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS
      #x2936	;ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS
      #x2937	;ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS
      #x2938	;RIGHT-SIDE ARC CLOCKWISE ARROW
      #x2939	;LEFT-SIDE ARC ANTICLOCKWISE ARROW
      #x293A	;TOP ARC ANTICLOCKWISE ARROW
      #x293B	;BOTTOM ARC ANTICLOCKWISE ARROW
      #x293C	;TOP ARC CLOCKWISE ARROW WITH MINUS
      #x293D	;TOP ARC ANTICLOCKWISE ARROW WITH PLUS
      #x293E	;LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW
      #x293F	;LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW
      #x2940	;ANTICLOCKWISE CLOSED CIRCLE ARROW
      #x2941	;CLOCKWISE CLOSED CIRCLE ARROW
      #x2942	;RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW
      #x2943	;LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW
      #x2944	;SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW
      #x2945	;RIGHTWARDS ARROW WITH PLUS BELOW
      #x2946	;LEFTWARDS ARROW WITH PLUS BELOW
      #x2947	;RIGHTWARDS ARROW THROUGH X
      #x2948	;LEFT RIGHT ARROW THROUGH SMALL CIRCLE
      #x2949	;UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE
      #x294A	;LEFT BARB UP RIGHT BARB DOWN HARPOON
      #x294B	;LEFT BARB DOWN RIGHT BARB UP HARPOON
      #x294C	;UP BARB RIGHT DOWN BARB LEFT HARPOON
      #x294D	;UP BARB LEFT DOWN BARB RIGHT HARPOON
      #x294E	;LEFT BARB UP RIGHT BARB UP HARPOON
      #x294F	;UP BARB RIGHT DOWN BARB RIGHT HARPOON
      #x2950	;LEFT BARB DOWN RIGHT BARB DOWN HARPOON
      #x2951	;UP BARB LEFT DOWN BARB LEFT HARPOON
      #x2952	;LEFTWARDS HARPOON WITH BARB UP TO BAR
      #x2953	;RIGHTWARDS HARPOON WITH BARB UP TO BAR
      #x2954	;UPWARDS HARPOON WITH BARB RIGHT TO BAR
      #x2955	;DOWNWARDS HARPOON WITH BARB RIGHT TO BAR
      #x2956	;LEFTWARDS HARPOON WITH BARB DOWN TO BAR
      #x2957	;RIGHTWARDS HARPOON WITH BARB DOWN TO BAR
      #x2958	;UPWARDS HARPOON WITH BARB LEFT TO BAR
      #x2959	;DOWNWARDS HARPOON WITH BARB LEFT TO BAR
      #x295A	;LEFTWARDS HARPOON WITH BARB UP FROM BAR
      #x295B	;RIGHTWARDS HARPOON WITH BARB UP FROM BAR
      #x295C	;UPWARDS HARPOON WITH BARB RIGHT FROM BAR
      #x295D	;DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR
      #x295E	;LEFTWARDS HARPOON WITH BARB DOWN FROM BAR
      #x295F	;RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR
      #x2960	;UPWARDS HARPOON WITH BARB LEFT FROM BAR
      #x2961	;DOWNWARDS HARPOON WITH BARB LEFT FROM BAR
      #x2962	;LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN
      #x2963	;UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
      #x2964	;RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
      #x2965	;DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
      #x2966	;LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP
      #x2967	;LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
      #x2968	;RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP
      #x2969	;RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN
      #x296A	;LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
      #x296B	;LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
      #x296C	;RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
      #x296D	;RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
      #x296E	;UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
      #x296F	;DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
      #x2970	;RIGHT DOUBLE ARROW WITH ROUNDED HEAD
      #x2971	;EQUALS SIGN ABOVE RIGHTWARDS ARROW
      #x2972	;TILDE OPERATOR ABOVE RIGHTWARDS ARROW
      #x2973	;LEFTWARDS ARROW ABOVE TILDE OPERATOR
      #x2974	;RIGHTWARDS ARROW ABOVE TILDE OPERATOR
      #x2975	;RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO
      #x2976	;LESS-THAN ABOVE LEFTWARDS ARROW
      #x2977	;LEFTWARDS ARROW THROUGH LESS-THAN
      #x2978	;GREATER-THAN ABOVE RIGHTWARDS ARROW
      #x2979	;SUBSET ABOVE RIGHTWARDS ARROW
      #x297A	;LEFTWARDS ARROW THROUGH SUBSET
      #x297B	;SUPERSET ABOVE LEFTWARDS ARROW
      #x297C	;LEFT FISH TAIL
      #x297D	;RIGHT FISH TAIL
      #x297E	;UP FISH TAIL
      #x297F	;DOWN FISH TAIL
      #x2980	;TRIPLE VERTICAL BAR DELIMITER
      #x2981	;Z NOTATION SPOT
      #x2982	;Z NOTATION TYPE COLON
      #x2999	;DOTTED FENCE
      #x299A	;VERTICAL ZIGZAG LINE
      #x299B	;MEASURED ANGLE OPENING LEFT
      #x299C	;RIGHT ANGLE VARIANT WITH SQUARE
      #x299D	;MEASURED RIGHT ANGLE WITH DOT
      #x299E	;ANGLE WITH S INSIDE
      #x299F	;ACUTE ANGLE
      #x29A0	;SPHERICAL ANGLE OPENING LEFT
      #x29A1	;SPHERICAL ANGLE OPENING UP
      #x29A2	;TURNED ANGLE
      #x29A3	;REVERSED ANGLE
      #x29A4	;ANGLE WITH UNDERBAR
      #x29A5	;REVERSED ANGLE WITH UNDERBAR
      #x29A6	;OBLIQUE ANGLE OPENING UP
      #x29A7	;OBLIQUE ANGLE OPENING DOWN
      #x29A8	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT
      #x29A9	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT
      #x29AA	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT
      #x29AB	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT
      #x29AC	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP
      #x29AD	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP
      #x29AE	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN
      #x29AF	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN
      #x29B0	;REVERSED EMPTY SET
      #x29B1	;EMPTY SET WITH OVERBAR
      #x29B2	;EMPTY SET WITH SMALL CIRCLE ABOVE
      #x29B3	;EMPTY SET WITH RIGHT ARROW ABOVE
      #x29B4	;EMPTY SET WITH LEFT ARROW ABOVE
      #x29B5	;CIRCLE WITH HORIZONTAL BAR
      #x29B6	;CIRCLED VERTICAL BAR
      #x29B7	;CIRCLED PARALLEL
      #x29B8	;CIRCLED REVERSE SOLIDUS
      #x29B9	;CIRCLED PERPENDICULAR
      #x29BA	;CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR
      #x29BB	;CIRCLE WITH SUPERIMPOSED X
      #x29BC	;CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN
      #x29BD	;UP ARROW THROUGH CIRCLE
      #x29BE	;CIRCLED WHITE BULLET
      #x29BF	;CIRCLED BULLET
      #x29C0	;CIRCLED LESS-THAN
      #x29C1	;CIRCLED GREATER-THAN
      #x29C2	;CIRCLE WITH SMALL CIRCLE TO THE RIGHT
      #x29C3	;CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT
      #x29C4	;SQUARED RISING DIAGONAL SLASH
      #x29C5	;SQUARED FALLING DIAGONAL SLASH
      #x29C6	;SQUARED ASTERISK
      #x29C7	;SQUARED SMALL CIRCLE
      #x29C8	;SQUARED SQUARE
      #x29C9	;TWO JOINED SQUARES
      #x29CA	;TRIANGLE WITH DOT ABOVE
      #x29CB	;TRIANGLE WITH UNDERBAR
      #x29CC	;S IN TRIANGLE
      #x29CD	;TRIANGLE WITH SERIFS AT BOTTOM
      #x29CE	;RIGHT TRIANGLE ABOVE LEFT TRIANGLE
      #x29CF	;LEFT TRIANGLE BESIDE VERTICAL BAR
      #x29D0	;VERTICAL BAR BESIDE RIGHT TRIANGLE
      #x29D1	;BOWTIE WITH LEFT HALF BLACK
      #x29D2	;BOWTIE WITH RIGHT HALF BLACK
      #x29D3	;BLACK BOWTIE
      #x29D4	;TIMES WITH LEFT HALF BLACK
      #x29D5	;TIMES WITH RIGHT HALF BLACK
      #x29D6	;WHITE HOURGLASS
      #x29D7	;BLACK HOURGLASS
      #x29DC	;INCOMPLETE INFINITY
      #x29DD	;TIE OVER INFINITY
      #x29DE	;INFINITY NEGATED WITH VERTICAL BAR
      #x29DF	;DOUBLE-ENDED MULTIMAP
      #x29E0	;SQUARE WITH CONTOURED OUTLINE
      #x29E1	;INCREASES AS
      #x29E2	;SHUFFLE PRODUCT
      #x29E3	;EQUALS SIGN AND SLANTED PARALLEL
      #x29E4	;EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE
      #x29E5	;IDENTICAL TO AND SLANTED PARALLEL
      #x29E6	;GLEICH STARK
      #x29E7	;THERMODYNAMIC
      #x29E8	;DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK
      #x29E9	;DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK
      #x29EA	;BLACK DIAMOND WITH DOWN ARROW
      #x29EB	;BLACK LOZENGE
      #x29EC	;WHITE CIRCLE WITH DOWN ARROW
      #x29ED	;BLACK CIRCLE WITH DOWN ARROW
      #x29EE	;ERROR-BARRED WHITE SQUARE
      #x29EF	;ERROR-BARRED BLACK SQUARE
      #x29F0	;ERROR-BARRED WHITE DIAMOND
      #x29F1	;ERROR-BARRED BLACK DIAMOND
      #x29F2	;ERROR-BARRED WHITE CIRCLE
      #x29F3	;ERROR-BARRED BLACK CIRCLE
      #x29F4	;RULE-DELAYED
      #x29F5	;REVERSE SOLIDUS OPERATOR
      #x29F6	;SOLIDUS WITH OVERBAR
      #x29F7	;REVERSE SOLIDUS WITH HORIZONTAL STROKE
      #x29F8	;BIG SOLIDUS
      #x29F9	;BIG REVERSE SOLIDUS
      #x29FA	;DOUBLE PLUS
      #x29FB	;TRIPLE PLUS
      #x29FE	;TINY
      #x29FF	;MINY
      #x2A00	;N-ARY CIRCLED DOT OPERATOR
      #x2A01	;N-ARY CIRCLED PLUS OPERATOR
      #x2A02	;N-ARY CIRCLED TIMES OPERATOR
      #x2A03	;N-ARY UNION OPERATOR WITH DOT
      #x2A04	;N-ARY UNION OPERATOR WITH PLUS
      #x2A05	;N-ARY SQUARE INTERSECTION OPERATOR
      #x2A06	;N-ARY SQUARE UNION OPERATOR
      #x2A07	;TWO LOGICAL AND OPERATOR
      #x2A08	;TWO LOGICAL OR OPERATOR
      #x2A09	;N-ARY TIMES OPERATOR
      #x2A0A	;MODULO TWO SUM
      #x2A0B	;SUMMATION WITH INTEGRAL
      #x2A0C	;QUADRUPLE INTEGRAL OPERATOR
      #x2A0D	;FINITE PART INTEGRAL
      #x2A0E	;INTEGRAL WITH DOUBLE STROKE
      #x2A0F	;INTEGRAL AVERAGE WITH SLASH
      #x2A10	;CIRCULATION FUNCTION
      #x2A11	;ANTICLOCKWISE INTEGRATION
      #x2A12	;LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE
      #x2A13	;LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE
      #x2A14	;LINE INTEGRATION NOT INCLUDING THE POLE
      #x2A15	;INTEGRAL AROUND A POINT OPERATOR
      #x2A16	;QUATERNION INTEGRAL OPERATOR
      #x2A17	;INTEGRAL WITH LEFTWARDS ARROW WITH HOOK
      #x2A18	;INTEGRAL WITH TIMES SIGN
      #x2A19	;INTEGRAL WITH INTERSECTION
      #x2A1A	;INTEGRAL WITH UNION
      #x2A1B	;INTEGRAL WITH OVERBAR
      #x2A1C	;INTEGRAL WITH UNDERBAR
      #x2A1D	;JOIN
      #x2A1E	;LARGE LEFT TRIANGLE OPERATOR
      #x2A1F	;Z NOTATION SCHEMA COMPOSITION
      #x2A20	;Z NOTATION SCHEMA PIPING
      #x2A21	;Z NOTATION SCHEMA PROJECTION
      #x2A22	;PLUS SIGN WITH SMALL CIRCLE ABOVE
      #x2A23	;PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE
      #x2A24	;PLUS SIGN WITH TILDE ABOVE
      #x2A25	;PLUS SIGN WITH DOT BELOW
      #x2A26	;PLUS SIGN WITH TILDE BELOW
      #x2A27	;PLUS SIGN WITH SUBSCRIPT TWO
      #x2A28	;PLUS SIGN WITH BLACK TRIANGLE
      #x2A29	;MINUS SIGN WITH COMMA ABOVE
      #x2A2A	;MINUS SIGN WITH DOT BELOW
      #x2A2B	;MINUS SIGN WITH FALLING DOTS
      #x2A2C	;MINUS SIGN WITH RISING DOTS
      #x2A2D	;PLUS SIGN IN LEFT HALF CIRCLE
      #x2A2E	;PLUS SIGN IN RIGHT HALF CIRCLE
      #x2A2F	;VECTOR OR CROSS PRODUCT
      #x2A30	;MULTIPLICATION SIGN WITH DOT ABOVE
      #x2A31	;MULTIPLICATION SIGN WITH UNDERBAR
      #x2A32	;SEMIDIRECT PRODUCT WITH BOTTOM CLOSED
      #x2A33	;SMASH PRODUCT
      #x2A34	;MULTIPLICATION SIGN IN LEFT HALF CIRCLE
      #x2A35	;MULTIPLICATION SIGN IN RIGHT HALF CIRCLE
      #x2A36	;CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT
      #x2A37	;MULTIPLICATION SIGN IN DOUBLE CIRCLE
      #x2A38	;CIRCLED DIVISION SIGN
      #x2A39	;PLUS SIGN IN TRIANGLE
      #x2A3A	;MINUS SIGN IN TRIANGLE
      #x2A3B	;MULTIPLICATION SIGN IN TRIANGLE
      #x2A3C	;INTERIOR PRODUCT
      #x2A3D	;RIGHTHAND INTERIOR PRODUCT
      #x2A3E	;Z NOTATION RELATIONAL COMPOSITION
      #x2A3F	;AMALGAMATION OR COPRODUCT
      #x2A40	;INTERSECTION WITH DOT
      #x2A41	;UNION WITH MINUS SIGN
      #x2A42	;UNION WITH OVERBAR
      #x2A43	;INTERSECTION WITH OVERBAR
      #x2A44	;INTERSECTION WITH LOGICAL AND
      #x2A45	;UNION WITH LOGICAL OR
      #x2A46	;UNION ABOVE INTERSECTION
      #x2A47	;INTERSECTION ABOVE UNION
      #x2A48	;UNION ABOVE BAR ABOVE INTERSECTION
      #x2A49	;INTERSECTION ABOVE BAR ABOVE UNION
      #x2A4A	;UNION BESIDE AND JOINED WITH UNION
      #x2A4B	;INTERSECTION BESIDE AND JOINED WITH INTERSECTION
      #x2A4C	;CLOSED UNION WITH SERIFS
      #x2A4D	;CLOSED INTERSECTION WITH SERIFS
      #x2A4E	;DOUBLE SQUARE INTERSECTION
      #x2A4F	;DOUBLE SQUARE UNION
      #x2A50	;CLOSED UNION WITH SERIFS AND SMASH PRODUCT
      #x2A51	;LOGICAL AND WITH DOT ABOVE
      #x2A52	;LOGICAL OR WITH DOT ABOVE
      #x2A53	;DOUBLE LOGICAL AND
      #x2A54	;DOUBLE LOGICAL OR
      #x2A55	;TWO INTERSECTING LOGICAL AND
      #x2A56	;TWO INTERSECTING LOGICAL OR
      #x2A57	;SLOPING LARGE OR
      #x2A58	;SLOPING LARGE AND
      #x2A59	;LOGICAL OR OVERLAPPING LOGICAL AND
      #x2A5A	;LOGICAL AND WITH MIDDLE STEM
      #x2A5B	;LOGICAL OR WITH MIDDLE STEM
      #x2A5C	;LOGICAL AND WITH HORIZONTAL DASH
      #x2A5D	;LOGICAL OR WITH HORIZONTAL DASH
      #x2A5E	;LOGICAL AND WITH DOUBLE OVERBAR
      #x2A5F	;LOGICAL AND WITH UNDERBAR
      #x2A60	;LOGICAL AND WITH DOUBLE UNDERBAR
      #x2A61	;SMALL VEE WITH UNDERBAR
      #x2A62	;LOGICAL OR WITH DOUBLE OVERBAR
      #x2A63	;LOGICAL OR WITH DOUBLE UNDERBAR
      #x2A64	;Z NOTATION DOMAIN ANTIRESTRICTION
      #x2A65	;Z NOTATION RANGE ANTIRESTRICTION
      #x2A66	;EQUALS SIGN WITH DOT BELOW
      #x2A67	;IDENTICAL WITH DOT ABOVE
      #x2A68	;TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE
      #x2A69	;TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE
      #x2A6A	;TILDE OPERATOR WITH DOT ABOVE
      #x2A6B	;TILDE OPERATOR WITH RISING DOTS
      #x2A6C	;SIMILAR MINUS SIMILAR
      #x2A6D	;CONGRUENT WITH DOT ABOVE
      #x2A6E	;EQUALS WITH ASTERISK
      #x2A6F	;ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT
      #x2A70	;APPROXIMATELY EQUAL OR EQUAL TO
      #x2A71	;EQUALS SIGN ABOVE PLUS SIGN
      #x2A72	;PLUS SIGN ABOVE EQUALS SIGN
      #x2A73	;EQUALS SIGN ABOVE TILDE OPERATOR
      #x2A74	;DOUBLE COLON EQUAL
      #x2A75	;TWO CONSECUTIVE EQUALS SIGNS
      #x2A76	;THREE CONSECUTIVE EQUALS SIGNS
      #x2A77	;EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW
      #x2A78	;EQUIVALENT WITH FOUR DOTS ABOVE
      #x2A79	;LESS-THAN WITH CIRCLE INSIDE
      #x2A7A	;GREATER-THAN WITH CIRCLE INSIDE
      #x2A7B	;LESS-THAN WITH QUESTION MARK ABOVE
      #x2A7C	;GREATER-THAN WITH QUESTION MARK ABOVE
      #x2A7D	;LESS-THAN OR SLANTED EQUAL TO
      #x2A7E	;GREATER-THAN OR SLANTED EQUAL TO
      #x2A7F	;LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
      #x2A80	;GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
      #x2A81	;LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
      #x2A82	;GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
      #x2A83	;LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT
      #x2A84	;GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT
      #x2A85	;LESS-THAN OR APPROXIMATE
      #x2A86	;GREATER-THAN OR APPROXIMATE
      #x2A87	;LESS-THAN AND SINGLE-LINE NOT EQUAL TO
      #x2A88	;GREATER-THAN AND SINGLE-LINE NOT EQUAL TO
      #x2A89	;LESS-THAN AND NOT APPROXIMATE
      #x2A8A	;GREATER-THAN AND NOT APPROXIMATE
      #x2A8B	;LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN
      #x2A8C	;GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN
      #x2A8D	;LESS-THAN ABOVE SIMILAR OR EQUAL
      #x2A8E	;GREATER-THAN ABOVE SIMILAR OR EQUAL
      #x2A8F	;LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN
      #x2A90	;GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN
      #x2A91	;LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL
      #x2A92	;GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL
      #x2A93	;LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL
      #x2A94	;GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL
      #x2A95	;SLANTED EQUAL TO OR LESS-THAN
      #x2A96	;SLANTED EQUAL TO OR GREATER-THAN
      #x2A97	;SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE
      #x2A98	;SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE
      #x2A99	;DOUBLE-LINE EQUAL TO OR LESS-THAN
      #x2A9A	;DOUBLE-LINE EQUAL TO OR GREATER-THAN
      #x2A9B	;DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN
      #x2A9C	;DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN
      #x2A9D	;SIMILAR OR LESS-THAN
      #x2A9E	;SIMILAR OR GREATER-THAN
      #x2A9F	;SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN
      #x2AA0	;SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN
      #x2AA1	;DOUBLE NESTED LESS-THAN
      #x2AA2	;DOUBLE NESTED GREATER-THAN
      #x2AA3	;DOUBLE NESTED LESS-THAN WITH UNDERBAR
      #x2AA4	;GREATER-THAN OVERLAPPING LESS-THAN
      #x2AA5	;GREATER-THAN BESIDE LESS-THAN
      #x2AA6	;LESS-THAN CLOSED BY CURVE
      #x2AA7	;GREATER-THAN CLOSED BY CURVE
      #x2AA8	;LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
      #x2AA9	;GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
      #x2AAA	;SMALLER THAN
      #x2AAB	;LARGER THAN
      #x2AAC	;SMALLER THAN OR EQUAL TO
      #x2AAD	;LARGER THAN OR EQUAL TO
      #x2AAE	;EQUALS SIGN WITH BUMPY ABOVE
      #x2AAF	;PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
      #x2AB0	;SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
      #x2AB1	;PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO
      #x2AB2	;SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO
      #x2AB3	;PRECEDES ABOVE EQUALS SIGN
      #x2AB4	;SUCCEEDS ABOVE EQUALS SIGN
      #x2AB5	;PRECEDES ABOVE NOT EQUAL TO
      #x2AB6	;SUCCEEDS ABOVE NOT EQUAL TO
      #x2AB7	;PRECEDES ABOVE ALMOST EQUAL TO
      #x2AB8	;SUCCEEDS ABOVE ALMOST EQUAL TO
      #x2AB9	;PRECEDES ABOVE NOT ALMOST EQUAL TO
      #x2ABA	;SUCCEEDS ABOVE NOT ALMOST EQUAL TO
      #x2ABB	;DOUBLE PRECEDES
      #x2ABC	;DOUBLE SUCCEEDS
      #x2ABD	;SUBSET WITH DOT
      #x2ABE	;SUPERSET WITH DOT
      #x2ABF	;SUBSET WITH PLUS SIGN BELOW
      #x2AC0	;SUPERSET WITH PLUS SIGN BELOW
      #x2AC1	;SUBSET WITH MULTIPLICATION SIGN BELOW
      #x2AC2	;SUPERSET WITH MULTIPLICATION SIGN BELOW
      #x2AC3	;SUBSET OF OR EQUAL TO WITH DOT ABOVE
      #x2AC4	;SUPERSET OF OR EQUAL TO WITH DOT ABOVE
      #x2AC5	;SUBSET OF ABOVE EQUALS SIGN
      #x2AC6	;SUPERSET OF ABOVE EQUALS SIGN
      #x2AC7	;SUBSET OF ABOVE TILDE OPERATOR
      #x2AC8	;SUPERSET OF ABOVE TILDE OPERATOR
      #x2AC9	;SUBSET OF ABOVE ALMOST EQUAL TO
      #x2ACA	;SUPERSET OF ABOVE ALMOST EQUAL TO
      #x2ACB	;SUBSET OF ABOVE NOT EQUAL TO
      #x2ACC	;SUPERSET OF ABOVE NOT EQUAL TO
      #x2ACD	;SQUARE LEFT OPEN BOX OPERATOR
      #x2ACE	;SQUARE RIGHT OPEN BOX OPERATOR
      #x2ACF	;CLOSED SUBSET
      #x2AD0	;CLOSED SUPERSET
      #x2AD1	;CLOSED SUBSET OR EQUAL TO
      #x2AD2	;CLOSED SUPERSET OR EQUAL TO
      #x2AD3	;SUBSET ABOVE SUPERSET
      #x2AD4	;SUPERSET ABOVE SUBSET
      #x2AD5	;SUBSET ABOVE SUBSET
      #x2AD6	;SUPERSET ABOVE SUPERSET
      #x2AD7	;SUPERSET BESIDE SUBSET
      #x2AD8	;SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET
      #x2AD9	;ELEMENT OF OPENING DOWNWARDS
      #x2ADA	;PITCHFORK WITH TEE TOP
      #x2ADB	;TRANSVERSAL INTERSECTION
      #x2ADC	;FORKING
      #x2ADD	;NONFORKING
      #x2ADE	;SHORT LEFT TACK
      #x2ADF	;SHORT DOWN TACK
      #x2AE0	;SHORT UP TACK
      #x2AE1	;PERPENDICULAR WITH S
      #x2AE2	;VERTICAL BAR TRIPLE RIGHT TURNSTILE
      #x2AE3	;DOUBLE VERTICAL BAR LEFT TURNSTILE
      #x2AE4	;VERTICAL BAR DOUBLE LEFT TURNSTILE
      #x2AE5	;DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE
      #x2AE6	;LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL
      #x2AE7	;SHORT DOWN TACK WITH OVERBAR
      #x2AE8	;SHORT UP TACK WITH UNDERBAR
      #x2AE9	;SHORT UP TACK ABOVE SHORT DOWN TACK
      #x2AEA	;DOUBLE DOWN TACK
      #x2AEB	;DOUBLE UP TACK
      #x2AEC	;DOUBLE STROKE NOT SIGN
      #x2AED	;REVERSED DOUBLE STROKE NOT SIGN
      #x2AEE	;DOES NOT DIVIDE WITH REVERSED NEGATION SLASH
      #x2AEF	;VERTICAL LINE WITH CIRCLE ABOVE
      #x2AF0	;VERTICAL LINE WITH CIRCLE BELOW
      #x2AF1	;DOWN TACK WITH CIRCLE BELOW
      #x2AF2	;PARALLEL WITH HORIZONTAL STROKE
      #x2AF3	;PARALLEL WITH TILDE OPERATOR
      #x2AF4	;TRIPLE VERTICAL BAR BINARY RELATION
      #x2AF5	;TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE
      #x2AF6	;TRIPLE COLON OPERATOR
      #x2AF7	;TRIPLE NESTED LESS-THAN
      #x2AF8	;TRIPLE NESTED GREATER-THAN
      #x2AF9	;DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO
      #x2AFA	;DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO
      #x2AFB	;TRIPLE SOLIDUS BINARY RELATION
      #x2AFC	;LARGE TRIPLE VERTICAL BAR OPERATOR
      #x2AFD	;DOUBLE SOLIDUS OPERATOR
      #x2AFE	;WHITE VERTICAL BAR
      #x2AFF	;N-ARY WHITE VERTICAL BAR
      #x2B00	;NORTH EAST WHITE ARROW
      #x2B01	;NORTH WEST WHITE ARROW
      #x2B02	;SOUTH EAST WHITE ARROW
      #x2B03	;SOUTH WEST WHITE ARROW
      #x2B04	;LEFT RIGHT WHITE ARROW
      #x2B05	;LEFTWARDS BLACK ARROW
      #x2B06	;UPWARDS BLACK ARROW
      #x2B07	;DOWNWARDS BLACK ARROW
      #x2B08	;NORTH EAST BLACK ARROW
      #x2B09	;NORTH WEST BLACK ARROW
      #x2B0A	;SOUTH EAST BLACK ARROW
      #x2B0B	;SOUTH WEST BLACK ARROW
      #x2B0C	;LEFT RIGHT BLACK ARROW
      #x2B0D	;UP DOWN BLACK ARROW
      #x2E80	;CJK RADICAL REPEAT
      #x2E81	;CJK RADICAL CLIFF
      #x2E82	;CJK RADICAL SECOND ONE
      #x2E83	;CJK RADICAL SECOND TWO
      #x2E84	;CJK RADICAL SECOND THREE
      #x2E85	;CJK RADICAL PERSON
      #x2E86	;CJK RADICAL BOX
      #x2E87	;CJK RADICAL TABLE
      #x2E88	;CJK RADICAL KNIFE ONE
      #x2E89	;CJK RADICAL KNIFE TWO
      #x2E8A	;CJK RADICAL DIVINATION
      #x2E8B	;CJK RADICAL SEAL
      #x2E8C	;CJK RADICAL SMALL ONE
      #x2E8D	;CJK RADICAL SMALL TWO
      #x2E8E	;CJK RADICAL LAME ONE
      #x2E8F	;CJK RADICAL LAME TWO
      #x2E90	;CJK RADICAL LAME THREE
      #x2E91	;CJK RADICAL LAME FOUR
      #x2E92	;CJK RADICAL SNAKE
      #x2E93	;CJK RADICAL THREAD
      #x2E94	;CJK RADICAL SNOUT ONE
      #x2E95	;CJK RADICAL SNOUT TWO
      #x2E96	;CJK RADICAL HEART ONE
      #x2E97	;CJK RADICAL HEART TWO
      #x2E98	;CJK RADICAL HAND
      #x2E99	;CJK RADICAL RAP
      #x2E9B	;CJK RADICAL CHOKE
      #x2E9C	;CJK RADICAL SUN
      #x2E9D	;CJK RADICAL MOON
      #x2E9E	;CJK RADICAL DEATH
      #x2E9F	;CJK RADICAL MOTHER
      #x2EA0	;CJK RADICAL CIVILIAN
      #x2EA1	;CJK RADICAL WATER ONE
      #x2EA2	;CJK RADICAL WATER TWO
      #x2EA3	;CJK RADICAL FIRE
      #x2EA4	;CJK RADICAL PAW ONE
      #x2EA5	;CJK RADICAL PAW TWO
      #x2EA6	;CJK RADICAL SIMPLIFIED HALF TREE TRUNK
      #x2EA7	;CJK RADICAL COW
      #x2EA8	;CJK RADICAL DOG
      #x2EA9	;CJK RADICAL JADE
      #x2EAA	;CJK RADICAL BOLT OF CLOTH
      #x2EAB	;CJK RADICAL EYE
      #x2EAC	;CJK RADICAL SPIRIT ONE
      #x2EAD	;CJK RADICAL SPIRIT TWO
      #x2EAE	;CJK RADICAL BAMBOO
      #x2EAF	;CJK RADICAL SILK
      #x2EB0	;CJK RADICAL C-SIMPLIFIED SILK
      #x2EB1	;CJK RADICAL NET ONE
      #x2EB2	;CJK RADICAL NET TWO
      #x2EB3	;CJK RADICAL NET THREE
      #x2EB4	;CJK RADICAL NET FOUR
      #x2EB5	;CJK RADICAL MESH
      #x2EB6	;CJK RADICAL SHEEP
      #x2EB7	;CJK RADICAL RAM
      #x2EB8	;CJK RADICAL EWE
      #x2EB9	;CJK RADICAL OLD
      #x2EBA	;CJK RADICAL BRUSH ONE
      #x2EBB	;CJK RADICAL BRUSH TWO
      #x2EBC	;CJK RADICAL MEAT
      #x2EBD	;CJK RADICAL MORTAR
      #x2EBE	;CJK RADICAL GRASS ONE
      #x2EBF	;CJK RADICAL GRASS TWO
      #x2EC0	;CJK RADICAL GRASS THREE
      #x2EC1	;CJK RADICAL TIGER
      #x2EC2	;CJK RADICAL CLOTHES
      #x2EC3	;CJK RADICAL WEST ONE
      #x2EC4	;CJK RADICAL WEST TWO
      #x2EC5	;CJK RADICAL C-SIMPLIFIED SEE
      #x2EC6	;CJK RADICAL SIMPLIFIED HORN
      #x2EC7	;CJK RADICAL HORN
      #x2EC8	;CJK RADICAL C-SIMPLIFIED SPEECH
      #x2EC9	;CJK RADICAL C-SIMPLIFIED SHELL
      #x2ECA	;CJK RADICAL FOOT
      #x2ECB	;CJK RADICAL C-SIMPLIFIED CART
      #x2ECC	;CJK RADICAL SIMPLIFIED WALK
      #x2ECD	;CJK RADICAL WALK ONE
      #x2ECE	;CJK RADICAL WALK TWO
      #x2ECF	;CJK RADICAL CITY
      #x2ED0	;CJK RADICAL C-SIMPLIFIED GOLD
      #x2ED1	;CJK RADICAL LONG ONE
      #x2ED2	;CJK RADICAL LONG TWO
      #x2ED3	;CJK RADICAL C-SIMPLIFIED LONG
      #x2ED4	;CJK RADICAL C-SIMPLIFIED GATE
      #x2ED5	;CJK RADICAL MOUND ONE
      #x2ED6	;CJK RADICAL MOUND TWO
      #x2ED7	;CJK RADICAL RAIN
      #x2ED8	;CJK RADICAL BLUE
      #x2ED9	;CJK RADICAL C-SIMPLIFIED TANNED LEATHER
      #x2EDA	;CJK RADICAL C-SIMPLIFIED LEAF
      #x2EDB	;CJK RADICAL C-SIMPLIFIED WIND
      #x2EDC	;CJK RADICAL C-SIMPLIFIED FLY
      #x2EDD	;CJK RADICAL EAT ONE
      #x2EDE	;CJK RADICAL EAT TWO
      #x2EDF	;CJK RADICAL EAT THREE
      #x2EE0	;CJK RADICAL C-SIMPLIFIED EAT
      #x2EE1	;CJK RADICAL HEAD
      #x2EE2	;CJK RADICAL C-SIMPLIFIED HORSE
      #x2EE3	;CJK RADICAL BONE
      #x2EE4	;CJK RADICAL GHOST
      #x2EE5	;CJK RADICAL C-SIMPLIFIED FISH
      #x2EE6	;CJK RADICAL C-SIMPLIFIED BIRD
      #x2EE7	;CJK RADICAL C-SIMPLIFIED SALT
      #x2EE8	;CJK RADICAL SIMPLIFIED WHEAT
      #x2EE9	;CJK RADICAL SIMPLIFIED YELLOW
      #x2EEA	;CJK RADICAL C-SIMPLIFIED FROG
      #x2EEB	;CJK RADICAL J-SIMPLIFIED EVEN
      #x2EEC	;CJK RADICAL C-SIMPLIFIED EVEN
      #x2EED	;CJK RADICAL J-SIMPLIFIED TOOTH
      #x2EEE	;CJK RADICAL C-SIMPLIFIED TOOTH
      #x2EEF	;CJK RADICAL J-SIMPLIFIED DRAGON
      #x2EF0	;CJK RADICAL C-SIMPLIFIED DRAGON
      #x2EF1	;CJK RADICAL TURTLE
      #x2EF2	;CJK RADICAL J-SIMPLIFIED TURTLE
      #x2EF3	;CJK RADICAL C-SIMPLIFIED TURTLE
      #x2F00	;KANGXI RADICAL ONE
      #x2F01	;KANGXI RADICAL LINE
      #x2F02	;KANGXI RADICAL DOT
      #x2F03	;KANGXI RADICAL SLASH
      #x2F04	;KANGXI RADICAL SECOND
      #x2F05	;KANGXI RADICAL HOOK
      #x2F06	;KANGXI RADICAL TWO
      #x2F07	;KANGXI RADICAL LID
      #x2F08	;KANGXI RADICAL MAN
      #x2F09	;KANGXI RADICAL LEGS
      #x2F0A	;KANGXI RADICAL ENTER
      #x2F0B	;KANGXI RADICAL EIGHT
      #x2F0C	;KANGXI RADICAL DOWN BOX
      #x2F0D	;KANGXI RADICAL COVER
      #x2F0E	;KANGXI RADICAL ICE
      #x2F0F	;KANGXI RADICAL TABLE
      #x2F10	;KANGXI RADICAL OPEN BOX
      #x2F11	;KANGXI RADICAL KNIFE
      #x2F12	;KANGXI RADICAL POWER
      #x2F13	;KANGXI RADICAL WRAP
      #x2F14	;KANGXI RADICAL SPOON
      #x2F15	;KANGXI RADICAL RIGHT OPEN BOX
      #x2F16	;KANGXI RADICAL HIDING ENCLOSURE
      #x2F17	;KANGXI RADICAL TEN
      #x2F18	;KANGXI RADICAL DIVINATION
      #x2F19	;KANGXI RADICAL SEAL
      #x2F1A	;KANGXI RADICAL CLIFF
      #x2F1B	;KANGXI RADICAL PRIVATE
      #x2F1C	;KANGXI RADICAL AGAIN
      #x2F1D	;KANGXI RADICAL MOUTH
      #x2F1E	;KANGXI RADICAL ENCLOSURE
      #x2F1F	;KANGXI RADICAL EARTH
      #x2F20	;KANGXI RADICAL SCHOLAR
      #x2F21	;KANGXI RADICAL GO
      #x2F22	;KANGXI RADICAL GO SLOWLY
      #x2F23	;KANGXI RADICAL EVENING
      #x2F24	;KANGXI RADICAL BIG
      #x2F25	;KANGXI RADICAL WOMAN
      #x2F26	;KANGXI RADICAL CHILD
      #x2F27	;KANGXI RADICAL ROOF
      #x2F28	;KANGXI RADICAL INCH
      #x2F29	;KANGXI RADICAL SMALL
      #x2F2A	;KANGXI RADICAL LAME
      #x2F2B	;KANGXI RADICAL CORPSE
      #x2F2C	;KANGXI RADICAL SPROUT
      #x2F2D	;KANGXI RADICAL MOUNTAIN
      #x2F2E	;KANGXI RADICAL RIVER
      #x2F2F	;KANGXI RADICAL WORK
      #x2F30	;KANGXI RADICAL ONESELF
      #x2F31	;KANGXI RADICAL TURBAN
      #x2F32	;KANGXI RADICAL DRY
      #x2F33	;KANGXI RADICAL SHORT THREAD
      #x2F34	;KANGXI RADICAL DOTTED CLIFF
      #x2F35	;KANGXI RADICAL LONG STRIDE
      #x2F36	;KANGXI RADICAL TWO HANDS
      #x2F37	;KANGXI RADICAL SHOOT
      #x2F38	;KANGXI RADICAL BOW
      #x2F39	;KANGXI RADICAL SNOUT
      #x2F3A	;KANGXI RADICAL BRISTLE
      #x2F3B	;KANGXI RADICAL STEP
      #x2F3C	;KANGXI RADICAL HEART
      #x2F3D	;KANGXI RADICAL HALBERD
      #x2F3E	;KANGXI RADICAL DOOR
      #x2F3F	;KANGXI RADICAL HAND
      #x2F40	;KANGXI RADICAL BRANCH
      #x2F41	;KANGXI RADICAL RAP
      #x2F42	;KANGXI RADICAL SCRIPT
      #x2F43	;KANGXI RADICAL DIPPER
      #x2F44	;KANGXI RADICAL AXE
      #x2F45	;KANGXI RADICAL SQUARE
      #x2F46	;KANGXI RADICAL NOT
      #x2F47	;KANGXI RADICAL SUN
      #x2F48	;KANGXI RADICAL SAY
      #x2F49	;KANGXI RADICAL MOON
      #x2F4A	;KANGXI RADICAL TREE
      #x2F4B	;KANGXI RADICAL LACK
      #x2F4C	;KANGXI RADICAL STOP
      #x2F4D	;KANGXI RADICAL DEATH
      #x2F4E	;KANGXI RADICAL WEAPON
      #x2F4F	;KANGXI RADICAL DO NOT
      #x2F50	;KANGXI RADICAL COMPARE
      #x2F51	;KANGXI RADICAL FUR
      #x2F52	;KANGXI RADICAL CLAN
      #x2F53	;KANGXI RADICAL STEAM
      #x2F54	;KANGXI RADICAL WATER
      #x2F55	;KANGXI RADICAL FIRE
      #x2F56	;KANGXI RADICAL CLAW
      #x2F57	;KANGXI RADICAL FATHER
      #x2F58	;KANGXI RADICAL DOUBLE X
      #x2F59	;KANGXI RADICAL HALF TREE TRUNK
      #x2F5A	;KANGXI RADICAL SLICE
      #x2F5B	;KANGXI RADICAL FANG
      #x2F5C	;KANGXI RADICAL COW
      #x2F5D	;KANGXI RADICAL DOG
      #x2F5E	;KANGXI RADICAL PROFOUND
      #x2F5F	;KANGXI RADICAL JADE
      #x2F60	;KANGXI RADICAL MELON
      #x2F61	;KANGXI RADICAL TILE
      #x2F62	;KANGXI RADICAL SWEET
      #x2F63	;KANGXI RADICAL LIFE
      #x2F64	;KANGXI RADICAL USE
      #x2F65	;KANGXI RADICAL FIELD
      #x2F66	;KANGXI RADICAL BOLT OF CLOTH
      #x2F67	;KANGXI RADICAL SICKNESS
      #x2F68	;KANGXI RADICAL DOTTED TENT
      #x2F69	;KANGXI RADICAL WHITE
      #x2F6A	;KANGXI RADICAL SKIN
      #x2F6B	;KANGXI RADICAL DISH
      #x2F6C	;KANGXI RADICAL EYE
      #x2F6D	;KANGXI RADICAL SPEAR
      #x2F6E	;KANGXI RADICAL ARROW
      #x2F6F	;KANGXI RADICAL STONE
      #x2F70	;KANGXI RADICAL SPIRIT
      #x2F71	;KANGXI RADICAL TRACK
      #x2F72	;KANGXI RADICAL GRAIN
      #x2F73	;KANGXI RADICAL CAVE
      #x2F74	;KANGXI RADICAL STAND
      #x2F75	;KANGXI RADICAL BAMBOO
      #x2F76	;KANGXI RADICAL RICE
      #x2F77	;KANGXI RADICAL SILK
      #x2F78	;KANGXI RADICAL JAR
      #x2F79	;KANGXI RADICAL NET
      #x2F7A	;KANGXI RADICAL SHEEP
      #x2F7B	;KANGXI RADICAL FEATHER
      #x2F7C	;KANGXI RADICAL OLD
      #x2F7D	;KANGXI RADICAL AND
      #x2F7E	;KANGXI RADICAL PLOW
      #x2F7F	;KANGXI RADICAL EAR
      #x2F80	;KANGXI RADICAL BRUSH
      #x2F81	;KANGXI RADICAL MEAT
      #x2F82	;KANGXI RADICAL MINISTER
      #x2F83	;KANGXI RADICAL SELF
      #x2F84	;KANGXI RADICAL ARRIVE
      #x2F85	;KANGXI RADICAL MORTAR
      #x2F86	;KANGXI RADICAL TONGUE
      #x2F87	;KANGXI RADICAL OPPOSE
      #x2F88	;KANGXI RADICAL BOAT
      #x2F89	;KANGXI RADICAL STOPPING
      #x2F8A	;KANGXI RADICAL COLOR
      #x2F8B	;KANGXI RADICAL GRASS
      #x2F8C	;KANGXI RADICAL TIGER
      #x2F8D	;KANGXI RADICAL INSECT
      #x2F8E	;KANGXI RADICAL BLOOD
      #x2F8F	;KANGXI RADICAL WALK ENCLOSURE
      #x2F90	;KANGXI RADICAL CLOTHES
      #x2F91	;KANGXI RADICAL WEST
      #x2F92	;KANGXI RADICAL SEE
      #x2F93	;KANGXI RADICAL HORN
      #x2F94	;KANGXI RADICAL SPEECH
      #x2F95	;KANGXI RADICAL VALLEY
      #x2F96	;KANGXI RADICAL BEAN
      #x2F97	;KANGXI RADICAL PIG
      #x2F98	;KANGXI RADICAL BADGER
      #x2F99	;KANGXI RADICAL SHELL
      #x2F9A	;KANGXI RADICAL RED
      #x2F9B	;KANGXI RADICAL RUN
      #x2F9C	;KANGXI RADICAL FOOT
      #x2F9D	;KANGXI RADICAL BODY
      #x2F9E	;KANGXI RADICAL CART
      #x2F9F	;KANGXI RADICAL BITTER
      #x2FA0	;KANGXI RADICAL MORNING
      #x2FA1	;KANGXI RADICAL WALK
      #x2FA2	;KANGXI RADICAL CITY
      #x2FA3	;KANGXI RADICAL WINE
      #x2FA4	;KANGXI RADICAL DISTINGUISH
      #x2FA5	;KANGXI RADICAL VILLAGE
      #x2FA6	;KANGXI RADICAL GOLD
      #x2FA7	;KANGXI RADICAL LONG
      #x2FA8	;KANGXI RADICAL GATE
      #x2FA9	;KANGXI RADICAL MOUND
      #x2FAA	;KANGXI RADICAL SLAVE
      #x2FAB	;KANGXI RADICAL SHORT TAILED BIRD
      #x2FAC	;KANGXI RADICAL RAIN
      #x2FAD	;KANGXI RADICAL BLUE
      #x2FAE	;KANGXI RADICAL WRONG
      #x2FAF	;KANGXI RADICAL FACE
      #x2FB0	;KANGXI RADICAL LEATHER
      #x2FB1	;KANGXI RADICAL TANNED LEATHER
      #x2FB2	;KANGXI RADICAL LEEK
      #x2FB3	;KANGXI RADICAL SOUND
      #x2FB4	;KANGXI RADICAL LEAF
      #x2FB5	;KANGXI RADICAL WIND
      #x2FB6	;KANGXI RADICAL FLY
      #x2FB7	;KANGXI RADICAL EAT
      #x2FB8	;KANGXI RADICAL HEAD
      #x2FB9	;KANGXI RADICAL FRAGRANT
      #x2FBA	;KANGXI RADICAL HORSE
      #x2FBB	;KANGXI RADICAL BONE
      #x2FBC	;KANGXI RADICAL TALL
      #x2FBD	;KANGXI RADICAL HAIR
      #x2FBE	;KANGXI RADICAL FIGHT
      #x2FBF	;KANGXI RADICAL SACRIFICIAL WINE
      #x2FC0	;KANGXI RADICAL CAULDRON
      #x2FC1	;KANGXI RADICAL GHOST
      #x2FC2	;KANGXI RADICAL FISH
      #x2FC3	;KANGXI RADICAL BIRD
      #x2FC4	;KANGXI RADICAL SALT
      #x2FC5	;KANGXI RADICAL DEER
      #x2FC6	;KANGXI RADICAL WHEAT
      #x2FC7	;KANGXI RADICAL HEMP
      #x2FC8	;KANGXI RADICAL YELLOW
      #x2FC9	;KANGXI RADICAL MILLET
      #x2FCA	;KANGXI RADICAL BLACK
      #x2FCB	;KANGXI RADICAL EMBROIDERY
      #x2FCC	;KANGXI RADICAL FROG
      #x2FCD	;KANGXI RADICAL TRIPOD
      #x2FCE	;KANGXI RADICAL DRUM
      #x2FCF	;KANGXI RADICAL RAT
      #x2FD0	;KANGXI RADICAL NOSE
      #x2FD1	;KANGXI RADICAL EVEN
      #x2FD2	;KANGXI RADICAL TOOTH
      #x2FD3	;KANGXI RADICAL DRAGON
      #x2FD4	;KANGXI RADICAL TURTLE
      #x2FD5	;KANGXI RADICAL FLUTE
      #x2FF0	;IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT
      #x2FF1	;IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW
      #x2FF2	;IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT
      #x2FF3	;IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW
      #x2FF4	;IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND
      #x2FF5	;IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE
      #x2FF6	;IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM BELOW
      #x2FF7	;IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LEFT
      #x2FF8	;IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER LEFT
      #x2FF9	;IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM UPPER RIGHT
      #x2FFA	;IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM LOWER LEFT
      #x2FFB	;IDEOGRAPHIC DESCRIPTION CHARACTER OVERLAID
      #x3004	;JAPANESE INDUSTRIAL STANDARD SYMBOL
      #x3012	;POSTAL MARK
      #x3013	;GETA MARK
      #x3020	;POSTAL MARK FACE
      #x3036	;CIRCLED POSTAL MARK
      #x3037	;IDEOGRAPHIC TELEGRAPH LINE FEED SEPARATOR SYMBOL
      #x303E	;IDEOGRAPHIC VARIATION INDICATOR
      #x303F	;IDEOGRAPHIC HALF FILL SPACE
      #x309B	;KATAKANA-HIRAGANA VOICED SOUND MARK
      #x309C	;KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK
      #x3190	;IDEOGRAPHIC ANNOTATION LINKING MARK
      #x3191	;IDEOGRAPHIC ANNOTATION REVERSE MARK
      #x3196	;IDEOGRAPHIC ANNOTATION TOP MARK
      #x3197	;IDEOGRAPHIC ANNOTATION MIDDLE MARK
      #x3198	;IDEOGRAPHIC ANNOTATION BOTTOM MARK
      #x3199	;IDEOGRAPHIC ANNOTATION FIRST MARK
      #x319A	;IDEOGRAPHIC ANNOTATION SECOND MARK
      #x319B	;IDEOGRAPHIC ANNOTATION THIRD MARK
      #x319C	;IDEOGRAPHIC ANNOTATION FOURTH MARK
      #x319D	;IDEOGRAPHIC ANNOTATION HEAVEN MARK
      #x319E	;IDEOGRAPHIC ANNOTATION EARTH MARK
      #x319F	;IDEOGRAPHIC ANNOTATION MAN MARK
      #x3200	;PARENTHESIZED HANGUL KIYEOK
      #x3201	;PARENTHESIZED HANGUL NIEUN
      #x3202	;PARENTHESIZED HANGUL TIKEUT
      #x3203	;PARENTHESIZED HANGUL RIEUL
      #x3204	;PARENTHESIZED HANGUL MIEUM
      #x3205	;PARENTHESIZED HANGUL PIEUP
      #x3206	;PARENTHESIZED HANGUL SIOS
      #x3207	;PARENTHESIZED HANGUL IEUNG
      #x3208	;PARENTHESIZED HANGUL CIEUC
      #x3209	;PARENTHESIZED HANGUL CHIEUCH
      #x320A	;PARENTHESIZED HANGUL KHIEUKH
      #x320B	;PARENTHESIZED HANGUL THIEUTH
      #x320C	;PARENTHESIZED HANGUL PHIEUPH
      #x320D	;PARENTHESIZED HANGUL HIEUH
      #x320E	;PARENTHESIZED HANGUL KIYEOK A
      #x320F	;PARENTHESIZED HANGUL NIEUN A
      #x3210	;PARENTHESIZED HANGUL TIKEUT A
      #x3211	;PARENTHESIZED HANGUL RIEUL A
      #x3212	;PARENTHESIZED HANGUL MIEUM A
      #x3213	;PARENTHESIZED HANGUL PIEUP A
      #x3214	;PARENTHESIZED HANGUL SIOS A
      #x3215	;PARENTHESIZED HANGUL IEUNG A
      #x3216	;PARENTHESIZED HANGUL CIEUC A
      #x3217	;PARENTHESIZED HANGUL CHIEUCH A
      #x3218	;PARENTHESIZED HANGUL KHIEUKH A
      #x3219	;PARENTHESIZED HANGUL THIEUTH A
      #x321A	;PARENTHESIZED HANGUL PHIEUPH A
      #x321B	;PARENTHESIZED HANGUL HIEUH A
      #x321C	;PARENTHESIZED HANGUL CIEUC U
      #x321D	;PARENTHESIZED KOREAN CHARACTER OJEON
      #x321E	;PARENTHESIZED KOREAN CHARACTER O HU
      #x322A	;PARENTHESIZED IDEOGRAPH MOON
      #x322B	;PARENTHESIZED IDEOGRAPH FIRE
      #x322C	;PARENTHESIZED IDEOGRAPH WATER
      #x322D	;PARENTHESIZED IDEOGRAPH WOOD
      #x322E	;PARENTHESIZED IDEOGRAPH METAL
      #x322F	;PARENTHESIZED IDEOGRAPH EARTH
      #x3230	;PARENTHESIZED IDEOGRAPH SUN
      #x3231	;PARENTHESIZED IDEOGRAPH STOCK
      #x3232	;PARENTHESIZED IDEOGRAPH HAVE
      #x3233	;PARENTHESIZED IDEOGRAPH SOCIETY
      #x3234	;PARENTHESIZED IDEOGRAPH NAME
      #x3235	;PARENTHESIZED IDEOGRAPH SPECIAL
      #x3236	;PARENTHESIZED IDEOGRAPH FINANCIAL
      #x3237	;PARENTHESIZED IDEOGRAPH CONGRATULATION
      #x3238	;PARENTHESIZED IDEOGRAPH LABOR
      #x3239	;PARENTHESIZED IDEOGRAPH REPRESENT
      #x323A	;PARENTHESIZED IDEOGRAPH CALL
      #x323B	;PARENTHESIZED IDEOGRAPH STUDY
      #x323C	;PARENTHESIZED IDEOGRAPH SUPERVISE
      #x323D	;PARENTHESIZED IDEOGRAPH ENTERPRISE
      #x323E	;PARENTHESIZED IDEOGRAPH RESOURCE
      #x323F	;PARENTHESIZED IDEOGRAPH ALLIANCE
      #x3240	;PARENTHESIZED IDEOGRAPH FESTIVAL
      #x3241	;PARENTHESIZED IDEOGRAPH REST
      #x3242	;PARENTHESIZED IDEOGRAPH SELF
      #x3243	;PARENTHESIZED IDEOGRAPH REACH
      #x3250	;PARTNERSHIP SIGN
      #x3260	;CIRCLED HANGUL KIYEOK
      #x3261	;CIRCLED HANGUL NIEUN
      #x3262	;CIRCLED HANGUL TIKEUT
      #x3263	;CIRCLED HANGUL RIEUL
      #x3264	;CIRCLED HANGUL MIEUM
      #x3265	;CIRCLED HANGUL PIEUP
      #x3266	;CIRCLED HANGUL SIOS
      #x3267	;CIRCLED HANGUL IEUNG
      #x3268	;CIRCLED HANGUL CIEUC
      #x3269	;CIRCLED HANGUL CHIEUCH
      #x326A	;CIRCLED HANGUL KHIEUKH
      #x326B	;CIRCLED HANGUL THIEUTH
      #x326C	;CIRCLED HANGUL PHIEUPH
      #x326D	;CIRCLED HANGUL HIEUH
      #x326E	;CIRCLED HANGUL KIYEOK A
      #x326F	;CIRCLED HANGUL NIEUN A
      #x3270	;CIRCLED HANGUL TIKEUT A
      #x3271	;CIRCLED HANGUL RIEUL A
      #x3272	;CIRCLED HANGUL MIEUM A
      #x3273	;CIRCLED HANGUL PIEUP A
      #x3274	;CIRCLED HANGUL SIOS A
      #x3275	;CIRCLED HANGUL IEUNG A
      #x3276	;CIRCLED HANGUL CIEUC A
      #x3277	;CIRCLED HANGUL CHIEUCH A
      #x3278	;CIRCLED HANGUL KHIEUKH A
      #x3279	;CIRCLED HANGUL THIEUTH A
      #x327A	;CIRCLED HANGUL PHIEUPH A
      #x327B	;CIRCLED HANGUL HIEUH A
      #x327C	;CIRCLED KOREAN CHARACTER CHAMKO
      #x327D	;CIRCLED KOREAN CHARACTER JUEUI
      #x327F	;KOREAN STANDARD SYMBOL
      #x328A	;CIRCLED IDEOGRAPH MOON
      #x328B	;CIRCLED IDEOGRAPH FIRE
      #x328C	;CIRCLED IDEOGRAPH WATER
      #x328D	;CIRCLED IDEOGRAPH WOOD
      #x328E	;CIRCLED IDEOGRAPH METAL
      #x328F	;CIRCLED IDEOGRAPH EARTH
      #x3290	;CIRCLED IDEOGRAPH SUN
      #x3291	;CIRCLED IDEOGRAPH STOCK
      #x3292	;CIRCLED IDEOGRAPH HAVE
      #x3293	;CIRCLED IDEOGRAPH SOCIETY
      #x3294	;CIRCLED IDEOGRAPH NAME
      #x3295	;CIRCLED IDEOGRAPH SPECIAL
      #x3296	;CIRCLED IDEOGRAPH FINANCIAL
      #x3297	;CIRCLED IDEOGRAPH CONGRATULATION
      #x3298	;CIRCLED IDEOGRAPH LABOR
      #x3299	;CIRCLED IDEOGRAPH SECRET
      #x329A	;CIRCLED IDEOGRAPH MALE
      #x329B	;CIRCLED IDEOGRAPH FEMALE
      #x329C	;CIRCLED IDEOGRAPH SUITABLE
      #x329D	;CIRCLED IDEOGRAPH EXCELLENT
      #x329E	;CIRCLED IDEOGRAPH PRINT
      #x329F	;CIRCLED IDEOGRAPH ATTENTION
      #x32A0	;CIRCLED IDEOGRAPH ITEM
      #x32A1	;CIRCLED IDEOGRAPH REST
      #x32A2	;CIRCLED IDEOGRAPH COPY
      #x32A3	;CIRCLED IDEOGRAPH CORRECT
      #x32A4	;CIRCLED IDEOGRAPH HIGH
      #x32A5	;CIRCLED IDEOGRAPH CENTRE
      #x32A6	;CIRCLED IDEOGRAPH LOW
      #x32A7	;CIRCLED IDEOGRAPH LEFT
      #x32A8	;CIRCLED IDEOGRAPH RIGHT
      #x32A9	;CIRCLED IDEOGRAPH MEDICINE
      #x32AA	;CIRCLED IDEOGRAPH RELIGION
      #x32AB	;CIRCLED IDEOGRAPH STUDY
      #x32AC	;CIRCLED IDEOGRAPH SUPERVISE
      #x32AD	;CIRCLED IDEOGRAPH ENTERPRISE
      #x32AE	;CIRCLED IDEOGRAPH RESOURCE
      #x32AF	;CIRCLED IDEOGRAPH ALLIANCE
      #x32B0	;CIRCLED IDEOGRAPH NIGHT
      #x32C0	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR JANUARY
      #x32C1	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR FEBRUARY
      #x32C2	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR MARCH
      #x32C3	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR APRIL
      #x32C4	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR MAY
      #x32C5	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR JUNE
      #x32C6	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR JULY
      #x32C7	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR AUGUST
      #x32C8	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR SEPTEMBER
      #x32C9	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR OCTOBER
      #x32CA	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR NOVEMBER
      #x32CB	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DECEMBER
      #x32CC	;SQUARE HG
      #x32CD	;SQUARE ERG
      #x32CE	;SQUARE EV
      #x32CF	;LIMITED LIABILITY SIGN
      #x32D0	;CIRCLED KATAKANA A
      #x32D1	;CIRCLED KATAKANA I
      #x32D2	;CIRCLED KATAKANA U
      #x32D3	;CIRCLED KATAKANA E
      #x32D4	;CIRCLED KATAKANA O
      #x32D5	;CIRCLED KATAKANA KA
      #x32D6	;CIRCLED KATAKANA KI
      #x32D7	;CIRCLED KATAKANA KU
      #x32D8	;CIRCLED KATAKANA KE
      #x32D9	;CIRCLED KATAKANA KO
      #x32DA	;CIRCLED KATAKANA SA
      #x32DB	;CIRCLED KATAKANA SI
      #x32DC	;CIRCLED KATAKANA SU
      #x32DD	;CIRCLED KATAKANA SE
      #x32DE	;CIRCLED KATAKANA SO
      #x32DF	;CIRCLED KATAKANA TA
      #x32E0	;CIRCLED KATAKANA TI
      #x32E1	;CIRCLED KATAKANA TU
      #x32E2	;CIRCLED KATAKANA TE
      #x32E3	;CIRCLED KATAKANA TO
      #x32E4	;CIRCLED KATAKANA NA
      #x32E5	;CIRCLED KATAKANA NI
      #x32E6	;CIRCLED KATAKANA NU
      #x32E7	;CIRCLED KATAKANA NE
      #x32E8	;CIRCLED KATAKANA NO
      #x32E9	;CIRCLED KATAKANA HA
      #x32EA	;CIRCLED KATAKANA HI
      #x32EB	;CIRCLED KATAKANA HU
      #x32EC	;CIRCLED KATAKANA HE
      #x32ED	;CIRCLED KATAKANA HO
      #x32EE	;CIRCLED KATAKANA MA
      #x32EF	;CIRCLED KATAKANA MI
      #x32F0	;CIRCLED KATAKANA MU
      #x32F1	;CIRCLED KATAKANA ME
      #x32F2	;CIRCLED KATAKANA MO
      #x32F3	;CIRCLED KATAKANA YA
      #x32F4	;CIRCLED KATAKANA YU
      #x32F5	;CIRCLED KATAKANA YO
      #x32F6	;CIRCLED KATAKANA RA
      #x32F7	;CIRCLED KATAKANA RI
      #x32F8	;CIRCLED KATAKANA RU
      #x32F9	;CIRCLED KATAKANA RE
      #x32FA	;CIRCLED KATAKANA RO
      #x32FB	;CIRCLED KATAKANA WA
      #x32FC	;CIRCLED KATAKANA WI
      #x32FD	;CIRCLED KATAKANA WE
      #x32FE	;CIRCLED KATAKANA WO
      #x3300	;SQUARE APAATO
      #x3301	;SQUARE ARUHUA
      #x3302	;SQUARE ANPEA
      #x3303	;SQUARE AARU
      #x3304	;SQUARE ININGU
      #x3305	;SQUARE INTI
      #x3306	;SQUARE UON
      #x3307	;SQUARE ESUKUUDO
      #x3308	;SQUARE EEKAA
      #x3309	;SQUARE ONSU
      #x330A	;SQUARE OOMU
      #x330B	;SQUARE KAIRI
      #x330C	;SQUARE KARATTO
      #x330D	;SQUARE KARORII
      #x330E	;SQUARE GARON
      #x330F	;SQUARE GANMA
      #x3310	;SQUARE GIGA
      #x3311	;SQUARE GINII
      #x3312	;SQUARE KYURII
      #x3313	;SQUARE GIRUDAA
      #x3314	;SQUARE KIRO
      #x3315	;SQUARE KIROGURAMU
      #x3316	;SQUARE KIROMEETORU
      #x3317	;SQUARE KIROWATTO
      #x3318	;SQUARE GURAMU
      #x3319	;SQUARE GURAMUTON
      #x331A	;SQUARE KURUZEIRO
      #x331B	;SQUARE KUROONE
      #x331C	;SQUARE KEESU
      #x331D	;SQUARE KORUNA
      #x331E	;SQUARE KOOPO
      #x331F	;SQUARE SAIKURU
      #x3320	;SQUARE SANTIIMU
      #x3321	;SQUARE SIRINGU
      #x3322	;SQUARE SENTI
      #x3323	;SQUARE SENTO
      #x3324	;SQUARE DAASU
      #x3325	;SQUARE DESI
      #x3326	;SQUARE DORU
      #x3327	;SQUARE TON
      #x3328	;SQUARE NANO
      #x3329	;SQUARE NOTTO
      #x332A	;SQUARE HAITU
      #x332B	;SQUARE PAASENTO
      #x332C	;SQUARE PAATU
      #x332D	;SQUARE BAARERU
      #x332E	;SQUARE PIASUTORU
      #x332F	;SQUARE PIKURU
      #x3330	;SQUARE PIKO
      #x3331	;SQUARE BIRU
      #x3332	;SQUARE HUARADDO
      #x3333	;SQUARE HUIITO
      #x3334	;SQUARE BUSSYERU
      #x3335	;SQUARE HURAN
      #x3336	;SQUARE HEKUTAARU
      #x3337	;SQUARE PESO
      #x3338	;SQUARE PENIHI
      #x3339	;SQUARE HERUTU
      #x333A	;SQUARE PENSU
      #x333B	;SQUARE PEEZI
      #x333C	;SQUARE BEETA
      #x333D	;SQUARE POINTO
      #x333E	;SQUARE BORUTO
      #x333F	;SQUARE HON
      #x3340	;SQUARE PONDO
      #x3341	;SQUARE HOORU
      #x3342	;SQUARE HOON
      #x3343	;SQUARE MAIKURO
      #x3344	;SQUARE MAIRU
      #x3345	;SQUARE MAHHA
      #x3346	;SQUARE MARUKU
      #x3347	;SQUARE MANSYON
      #x3348	;SQUARE MIKURON
      #x3349	;SQUARE MIRI
      #x334A	;SQUARE MIRIBAARU
      #x334B	;SQUARE MEGA
      #x334C	;SQUARE MEGATON
      #x334D	;SQUARE MEETORU
      #x334E	;SQUARE YAADO
      #x334F	;SQUARE YAARU
      #x3350	;SQUARE YUAN
      #x3351	;SQUARE RITTORU
      #x3352	;SQUARE RIRA
      #x3353	;SQUARE RUPII
      #x3354	;SQUARE RUUBURU
      #x3355	;SQUARE REMU
      #x3356	;SQUARE RENTOGEN
      #x3357	;SQUARE WATTO
      #x3358	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ZERO
      #x3359	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ONE
      #x335A	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWO
      #x335B	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THREE
      #x335C	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOUR
      #x335D	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIVE
      #x335E	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIX
      #x335F	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVEN
      #x3360	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHT
      #x3361	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINE
      #x3362	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TEN
      #x3363	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR ELEVEN
      #x3364	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWELVE
      #x3365	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR THIRTEEN
      #x3366	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FOURTEEN
      #x3367	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR FIFTEEN
      #x3368	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SIXTEEN
      #x3369	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR SEVENTEEN
      #x336A	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR EIGHTEEN
      #x336B	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR NINETEEN
      #x336C	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY
      #x336D	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-ONE
      #x336E	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-TWO
      #x336F	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-THREE
      #x3370	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR HOUR TWENTY-FOUR
      #x3371	;SQUARE HPA
      #x3372	;SQUARE DA
      #x3373	;SQUARE AU
      #x3374	;SQUARE BAR
      #x3375	;SQUARE OV
      #x3376	;SQUARE PC
      #x3377	;SQUARE DM
      #x3378	;SQUARE DM SQUARED
      #x3379	;SQUARE DM CUBED
      #x337A	;SQUARE IU
      #x337B	;SQUARE ERA NAME HEISEI
      #x337C	;SQUARE ERA NAME SYOUWA
      #x337D	;SQUARE ERA NAME TAISYOU
      #x337E	;SQUARE ERA NAME MEIZI
      #x337F	;SQUARE CORPORATION
      #x3380	;SQUARE PA AMPS
      #x3381	;SQUARE NA
      #x3382	;SQUARE MU A
      #x3383	;SQUARE MA
      #x3384	;SQUARE KA
      #x3385	;SQUARE KB
      #x3386	;SQUARE MB
      #x3387	;SQUARE GB
      #x3388	;SQUARE CAL
      #x3389	;SQUARE KCAL
      #x338A	;SQUARE PF
      #x338B	;SQUARE NF
      #x338C	;SQUARE MU F
      #x338D	;SQUARE MU G
      #x338E	;SQUARE MG
      #x338F	;SQUARE KG
      #x3390	;SQUARE HZ
      #x3391	;SQUARE KHZ
      #x3392	;SQUARE MHZ
      #x3393	;SQUARE GHZ
      #x3394	;SQUARE THZ
      #x3395	;SQUARE MU L
      #x3396	;SQUARE ML
      #x3397	;SQUARE DL
      #x3398	;SQUARE KL
      #x3399	;SQUARE FM
      #x339A	;SQUARE NM
      #x339B	;SQUARE MU M
      #x339C	;SQUARE MM
      #x339D	;SQUARE CM
      #x339E	;SQUARE KM
      #x339F	;SQUARE MM SQUARED
      #x33A0	;SQUARE CM SQUARED
      #x33A1	;SQUARE M SQUARED
      #x33A2	;SQUARE KM SQUARED
      #x33A3	;SQUARE MM CUBED
      #x33A4	;SQUARE CM CUBED
      #x33A5	;SQUARE M CUBED
      #x33A6	;SQUARE KM CUBED
      #x33A7	;SQUARE M OVER S
      #x33A8	;SQUARE M OVER S SQUARED
      #x33A9	;SQUARE PA
      #x33AA	;SQUARE KPA
      #x33AB	;SQUARE MPA
      #x33AC	;SQUARE GPA
      #x33AD	;SQUARE RAD
      #x33AE	;SQUARE RAD OVER S
      #x33AF	;SQUARE RAD OVER S SQUARED
      #x33B0	;SQUARE PS
      #x33B1	;SQUARE NS
      #x33B2	;SQUARE MU S
      #x33B3	;SQUARE MS
      #x33B4	;SQUARE PV
      #x33B5	;SQUARE NV
      #x33B6	;SQUARE MU V
      #x33B7	;SQUARE MV
      #x33B8	;SQUARE KV
      #x33B9	;SQUARE MV MEGA
      #x33BA	;SQUARE PW
      #x33BB	;SQUARE NW
      #x33BC	;SQUARE MU W
      #x33BD	;SQUARE MW
      #x33BE	;SQUARE KW
      #x33BF	;SQUARE MW MEGA
      #x33C0	;SQUARE K OHM
      #x33C1	;SQUARE M OHM
      #x33C2	;SQUARE AM
      #x33C3	;SQUARE BQ
      #x33C4	;SQUARE CC
      #x33C5	;SQUARE CD
      #x33C6	;SQUARE C OVER KG
      #x33C7	;SQUARE CO
      #x33C8	;SQUARE DB
      #x33C9	;SQUARE GY
      #x33CA	;SQUARE HA
      #x33CB	;SQUARE HP
      #x33CC	;SQUARE IN
      #x33CD	;SQUARE KK
      #x33CE	;SQUARE KM CAPITAL
      #x33CF	;SQUARE KT
      #x33D0	;SQUARE LM
      #x33D1	;SQUARE LN
      #x33D2	;SQUARE LOG
      #x33D3	;SQUARE LX
      #x33D4	;SQUARE MB SMALL
      #x33D5	;SQUARE MIL
      #x33D6	;SQUARE MOL
      #x33D7	;SQUARE PH
      #x33D8	;SQUARE PM
      #x33D9	;SQUARE PPM
      #x33DA	;SQUARE PR
      #x33DB	;SQUARE SR
      #x33DC	;SQUARE SV
      #x33DD	;SQUARE WB
      #x33DE	;SQUARE V OVER M
      #x33DF	;SQUARE A OVER M
      #x33E0	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ONE
      #x33E1	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWO
      #x33E2	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THREE
      #x33E3	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOUR
      #x33E4	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIVE
      #x33E5	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIX
      #x33E6	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVEN
      #x33E7	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHT
      #x33E8	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINE
      #x33E9	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TEN
      #x33EA	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY ELEVEN
      #x33EB	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWELVE
      #x33EC	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTEEN
      #x33ED	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FOURTEEN
      #x33EE	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY FIFTEEN
      #x33EF	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SIXTEEN
      #x33F0	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY SEVENTEEN
      #x33F1	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY EIGHTEEN
      #x33F2	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY NINETEEN
      #x33F3	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY
      #x33F4	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-ONE
      #x33F5	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-TWO
      #x33F6	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-THREE
      #x33F7	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FOUR
      #x33F8	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-FIVE
      #x33F9	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SIX
      #x33FA	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-SEVEN
      #x33FB	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-EIGHT
      #x33FC	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY TWENTY-NINE
      #x33FD	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY
      #x33FE	;IDEOGRAPHIC TELEGRAPH SYMBOL FOR DAY THIRTY-ONE
      #x33FF	;SQUARE GAL
      #x4DC0	;HEXAGRAM FOR THE CREATIVE HEAVEN
      #x4DC1	;HEXAGRAM FOR THE RECEPTIVE EARTH
      #x4DC2	;HEXAGRAM FOR DIFFICULTY AT THE BEGINNING
      #x4DC3	;HEXAGRAM FOR YOUTHFUL FOLLY
      #x4DC4	;HEXAGRAM FOR WAITING
      #x4DC5	;HEXAGRAM FOR CONFLICT
      #x4DC6	;HEXAGRAM FOR THE ARMY
      #x4DC7	;HEXAGRAM FOR HOLDING TOGETHER
      #x4DC8	;HEXAGRAM FOR SMALL TAMING
      #x4DC9	;HEXAGRAM FOR TREADING
      #x4DCA	;HEXAGRAM FOR PEACE
      #x4DCB	;HEXAGRAM FOR STANDSTILL
      #x4DCC	;HEXAGRAM FOR FELLOWSHIP
      #x4DCD	;HEXAGRAM FOR GREAT POSSESSION
      #x4DCE	;HEXAGRAM FOR MODESTY
      #x4DCF	;HEXAGRAM FOR ENTHUSIASM
      #x4DD0	;HEXAGRAM FOR FOLLOWING
      #x4DD1	;HEXAGRAM FOR WORK ON THE DECAYED
      #x4DD2	;HEXAGRAM FOR APPROACH
      #x4DD3	;HEXAGRAM FOR CONTEMPLATION
      #x4DD4	;HEXAGRAM FOR BITING THROUGH
      #x4DD5	;HEXAGRAM FOR GRACE
      #x4DD6	;HEXAGRAM FOR SPLITTING APART
      #x4DD7	;HEXAGRAM FOR RETURN
      #x4DD8	;HEXAGRAM FOR INNOCENCE
      #x4DD9	;HEXAGRAM FOR GREAT TAMING
      #x4DDA	;HEXAGRAM FOR MOUTH CORNERS
      #x4DDB	;HEXAGRAM FOR GREAT PREPONDERANCE
      #x4DDC	;HEXAGRAM FOR THE ABYSMAL WATER
      #x4DDD	;HEXAGRAM FOR THE CLINGING FIRE
      #x4DDE	;HEXAGRAM FOR INFLUENCE
      #x4DDF	;HEXAGRAM FOR DURATION
      #x4DE0	;HEXAGRAM FOR RETREAT
      #x4DE1	;HEXAGRAM FOR GREAT POWER
      #x4DE2	;HEXAGRAM FOR PROGRESS
      #x4DE3	;HEXAGRAM FOR DARKENING OF THE LIGHT
      #x4DE4	;HEXAGRAM FOR THE FAMILY
      #x4DE5	;HEXAGRAM FOR OPPOSITION
      #x4DE6	;HEXAGRAM FOR OBSTRUCTION
      #x4DE7	;HEXAGRAM FOR DELIVERANCE
      #x4DE8	;HEXAGRAM FOR DECREASE
      #x4DE9	;HEXAGRAM FOR INCREASE
      #x4DEA	;HEXAGRAM FOR BREAKTHROUGH
      #x4DEB	;HEXAGRAM FOR COMING TO MEET
      #x4DEC	;HEXAGRAM FOR GATHERING TOGETHER
      #x4DED	;HEXAGRAM FOR PUSHING UPWARD
      #x4DEE	;HEXAGRAM FOR OPPRESSION
      #x4DEF	;HEXAGRAM FOR THE WELL
      #x4DF0	;HEXAGRAM FOR REVOLUTION
      #x4DF1	;HEXAGRAM FOR THE CAULDRON
      #x4DF2	;HEXAGRAM FOR THE AROUSING THUNDER
      #x4DF3	;HEXAGRAM FOR THE KEEPING STILL MOUNTAIN
      #x4DF4	;HEXAGRAM FOR DEVELOPMENT
      #x4DF5	;HEXAGRAM FOR THE MARRYING MAIDEN
      #x4DF6	;HEXAGRAM FOR ABUNDANCE
      #x4DF7	;HEXAGRAM FOR THE WANDERER
      #x4DF8	;HEXAGRAM FOR THE GENTLE WIND
      #x4DF9	;HEXAGRAM FOR THE JOYOUS LAKE
      #x4DFA	;HEXAGRAM FOR DISPERSION
      #x4DFB	;HEXAGRAM FOR LIMITATION
      #x4DFC	;HEXAGRAM FOR INNER TRUTH
      #x4DFD	;HEXAGRAM FOR SMALL PREPONDERANCE
      #x4DFE	;HEXAGRAM FOR AFTER COMPLETION
      #x4DFF	;HEXAGRAM FOR BEFORE COMPLETION
      #xA490	;YI RADICAL QOT
      #xA491	;YI RADICAL LI
      #xA492	;YI RADICAL KIT
      #xA493	;YI RADICAL NYIP
      #xA494	;YI RADICAL CYP
      #xA495	;YI RADICAL SSI
      #xA496	;YI RADICAL GGOP
      #xA497	;YI RADICAL GEP
      #xA498	;YI RADICAL MI
      #xA499	;YI RADICAL HXIT
      #xA49A	;YI RADICAL LYR
      #xA49B	;YI RADICAL BBUT
      #xA49C	;YI RADICAL MOP
      #xA49D	;YI RADICAL YO
      #xA49E	;YI RADICAL PUT
      #xA49F	;YI RADICAL HXUO
      #xA4A0	;YI RADICAL TAT
      #xA4A1	;YI RADICAL GA
      #xA4A2	;YI RADICAL ZUP
      #xA4A3	;YI RADICAL CYT
      #xA4A4	;YI RADICAL DDUR
      #xA4A5	;YI RADICAL BUR
      #xA4A6	;YI RADICAL GGUO
      #xA4A7	;YI RADICAL NYOP
      #xA4A8	;YI RADICAL TU
      #xA4A9	;YI RADICAL OP
      #xA4AA	;YI RADICAL JJUT
      #xA4AB	;YI RADICAL ZOT
      #xA4AC	;YI RADICAL PYT
      #xA4AD	;YI RADICAL HMO
      #xA4AE	;YI RADICAL YIT
      #xA4AF	;YI RADICAL VUR
      #xA4B0	;YI RADICAL SHY
      #xA4B1	;YI RADICAL VEP
      #xA4B2	;YI RADICAL ZA
      #xA4B3	;YI RADICAL JO
      #xA4B4	;YI RADICAL NZUP
      #xA4B5	;YI RADICAL JJY
      #xA4B6	;YI RADICAL GOT
      #xA4B7	;YI RADICAL JJIE
      #xA4B8	;YI RADICAL WO
      #xA4B9	;YI RADICAL DU
      #xA4BA	;YI RADICAL SHUR
      #xA4BB	;YI RADICAL LIE
      #xA4BC	;YI RADICAL CY
      #xA4BD	;YI RADICAL CUOP
      #xA4BE	;YI RADICAL CIP
      #xA4BF	;YI RADICAL HXOP
      #xA4C0	;YI RADICAL SHAT
      #xA4C1	;YI RADICAL ZUR
      #xA4C2	;YI RADICAL SHOP
      #xA4C3	;YI RADICAL CHE
      #xA4C4	;YI RADICAL ZZIET
      #xA4C5	;YI RADICAL NBIE
      #xA4C6	;YI RADICAL KE
      #xFB29	;HEBREW LETTER ALTERNATIVE PLUS SIGN
      #xFDFC	;RIAL SIGN
      #xFDFD	;ARABIC LIGATURE BISMILLAH AR-RAHMAN AR-RAHEEM
      #xFE62	;SMALL PLUS SIGN
      #xFE64	;SMALL LESS-THAN SIGN
      #xFE65	;SMALL GREATER-THAN SIGN
      #xFE66	;SMALL EQUALS SIGN
      #xFE69	;SMALL DOLLAR SIGN
      #xFF04	;FULLWIDTH DOLLAR SIGN
      #xFF0B	;FULLWIDTH PLUS SIGN
      #xFF1C	;FULLWIDTH LESS-THAN SIGN
      #xFF1D	;FULLWIDTH EQUALS SIGN
      #xFF1E	;FULLWIDTH GREATER-THAN SIGN
      #xFF3E	;FULLWIDTH CIRCUMFLEX ACCENT
      #xFF40	;FULLWIDTH GRAVE ACCENT
      #xFF5C	;FULLWIDTH VERTICAL LINE
      #xFF5E	;FULLWIDTH TILDE
      #xFFE0	;FULLWIDTH CENT SIGN
      #xFFE1	;FULLWIDTH POUND SIGN
      #xFFE2	;FULLWIDTH NOT SIGN
      #xFFE3	;FULLWIDTH MACRON
      #xFFE4	;FULLWIDTH BROKEN BAR
      #xFFE5	;FULLWIDTH YEN SIGN
      #xFFE6	;FULLWIDTH WON SIGN
      #xFFE8	;HALFWIDTH FORMS LIGHT VERTICAL
      #xFFE9	;HALFWIDTH LEFTWARDS ARROW
      #xFFEA	;HALFWIDTH UPWARDS ARROW
      #xFFEB	;HALFWIDTH RIGHTWARDS ARROW
      #xFFEC	;HALFWIDTH DOWNWARDS ARROW
      #xFFED	;HALFWIDTH BLACK SQUARE
      #xFFEE	;HALFWIDTH WHITE CIRCLE
      #xFFFC	;OBJECT REPLACEMENT CHARACTER
      #xFFFD	;REPLACEMENT CHARACTER
      #x10102	;AEGEAN CHECK MARK
      #x10137	;AEGEAN WEIGHT BASE UNIT
      #x10138	;AEGEAN WEIGHT FIRST SUBUNIT
      #x10139	;AEGEAN WEIGHT SECOND SUBUNIT
      #x1013A	;AEGEAN WEIGHT THIRD SUBUNIT
      #x1013B	;AEGEAN WEIGHT FOURTH SUBUNIT
      #x1013C	;AEGEAN DRY MEASURE FIRST SUBUNIT
      #x1013D	;AEGEAN LIQUID MEASURE FIRST SUBUNIT
      #x1013E	;AEGEAN MEASURE SECOND SUBUNIT
      #x1013F	;AEGEAN MEASURE THIRD SUBUNIT
      #x1D000	;BYZANTINE MUSICAL SYMBOL PSILI
      #x1D001	;BYZANTINE MUSICAL SYMBOL DASEIA
      #x1D002	;BYZANTINE MUSICAL SYMBOL PERISPOMENI
      #x1D003	;BYZANTINE MUSICAL SYMBOL OXEIA EKFONITIKON
      #x1D004	;BYZANTINE MUSICAL SYMBOL OXEIA DIPLI
      #x1D005	;BYZANTINE MUSICAL SYMBOL VAREIA EKFONITIKON
      #x1D006	;BYZANTINE MUSICAL SYMBOL VAREIA DIPLI
      #x1D007	;BYZANTINE MUSICAL SYMBOL KATHISTI
      #x1D008	;BYZANTINE MUSICAL SYMBOL SYRMATIKI
      #x1D009	;BYZANTINE MUSICAL SYMBOL PARAKLITIKI
      #x1D00A	;BYZANTINE MUSICAL SYMBOL YPOKRISIS
      #x1D00B	;BYZANTINE MUSICAL SYMBOL YPOKRISIS DIPLI
      #x1D00C	;BYZANTINE MUSICAL SYMBOL KREMASTI
      #x1D00D	;BYZANTINE MUSICAL SYMBOL APESO EKFONITIKON
      #x1D00E	;BYZANTINE MUSICAL SYMBOL EXO EKFONITIKON
      #x1D00F	;BYZANTINE MUSICAL SYMBOL TELEIA
      #x1D010	;BYZANTINE MUSICAL SYMBOL KENTIMATA
      #x1D011	;BYZANTINE MUSICAL SYMBOL APOSTROFOS
      #x1D012	;BYZANTINE MUSICAL SYMBOL APOSTROFOS DIPLI
      #x1D013	;BYZANTINE MUSICAL SYMBOL SYNEVMA
      #x1D014	;BYZANTINE MUSICAL SYMBOL THITA
      #x1D015	;BYZANTINE MUSICAL SYMBOL OLIGON ARCHAION
      #x1D016	;BYZANTINE MUSICAL SYMBOL GORGON ARCHAION
      #x1D017	;BYZANTINE MUSICAL SYMBOL PSILON
      #x1D018	;BYZANTINE MUSICAL SYMBOL CHAMILON
      #x1D019	;BYZANTINE MUSICAL SYMBOL VATHY
      #x1D01A	;BYZANTINE MUSICAL SYMBOL ISON ARCHAION
      #x1D01B	;BYZANTINE MUSICAL SYMBOL KENTIMA ARCHAION
      #x1D01C	;BYZANTINE MUSICAL SYMBOL KENTIMATA ARCHAION
      #x1D01D	;BYZANTINE MUSICAL SYMBOL SAXIMATA
      #x1D01E	;BYZANTINE MUSICAL SYMBOL PARICHON
      #x1D01F	;BYZANTINE MUSICAL SYMBOL STAVROS APODEXIA
      #x1D020	;BYZANTINE MUSICAL SYMBOL OXEIAI ARCHAION
      #x1D021	;BYZANTINE MUSICAL SYMBOL VAREIAI ARCHAION
      #x1D022	;BYZANTINE MUSICAL SYMBOL APODERMA ARCHAION
      #x1D023	;BYZANTINE MUSICAL SYMBOL APOTHEMA
      #x1D024	;BYZANTINE MUSICAL SYMBOL KLASMA
      #x1D025	;BYZANTINE MUSICAL SYMBOL REVMA
      #x1D026	;BYZANTINE MUSICAL SYMBOL PIASMA ARCHAION
      #x1D027	;BYZANTINE MUSICAL SYMBOL TINAGMA
      #x1D028	;BYZANTINE MUSICAL SYMBOL ANATRICHISMA
      #x1D029	;BYZANTINE MUSICAL SYMBOL SEISMA
      #x1D02A	;BYZANTINE MUSICAL SYMBOL SYNAGMA ARCHAION
      #x1D02B	;BYZANTINE MUSICAL SYMBOL SYNAGMA META STAVROU
      #x1D02C	;BYZANTINE MUSICAL SYMBOL OYRANISMA ARCHAION
      #x1D02D	;BYZANTINE MUSICAL SYMBOL THEMA
      #x1D02E	;BYZANTINE MUSICAL SYMBOL LEMOI
      #x1D02F	;BYZANTINE MUSICAL SYMBOL DYO
      #x1D030	;BYZANTINE MUSICAL SYMBOL TRIA
      #x1D031	;BYZANTINE MUSICAL SYMBOL TESSERA
      #x1D032	;BYZANTINE MUSICAL SYMBOL KRATIMATA
      #x1D033	;BYZANTINE MUSICAL SYMBOL APESO EXO NEO
      #x1D034	;BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION
      #x1D035	;BYZANTINE MUSICAL SYMBOL IMIFTHORA
      #x1D036	;BYZANTINE MUSICAL SYMBOL TROMIKON ARCHAION
      #x1D037	;BYZANTINE MUSICAL SYMBOL KATAVA TROMIKON
      #x1D038	;BYZANTINE MUSICAL SYMBOL PELASTON
      #x1D039	;BYZANTINE MUSICAL SYMBOL PSIFISTON
      #x1D03A	;BYZANTINE MUSICAL SYMBOL KONTEVMA
      #x1D03B	;BYZANTINE MUSICAL SYMBOL CHOREVMA ARCHAION
      #x1D03C	;BYZANTINE MUSICAL SYMBOL RAPISMA
      #x1D03D	;BYZANTINE MUSICAL SYMBOL PARAKALESMA ARCHAION
      #x1D03E	;BYZANTINE MUSICAL SYMBOL PARAKLITIKI ARCHAION
      #x1D03F	;BYZANTINE MUSICAL SYMBOL ICHADIN
      #x1D040	;BYZANTINE MUSICAL SYMBOL NANA
      #x1D041	;BYZANTINE MUSICAL SYMBOL PETASMA
      #x1D042	;BYZANTINE MUSICAL SYMBOL KONTEVMA ALLO
      #x1D043	;BYZANTINE MUSICAL SYMBOL TROMIKON ALLO
      #x1D044	;BYZANTINE MUSICAL SYMBOL STRAGGISMATA
      #x1D045	;BYZANTINE MUSICAL SYMBOL GRONTHISMATA
      #x1D046	;BYZANTINE MUSICAL SYMBOL ISON NEO
      #x1D047	;BYZANTINE MUSICAL SYMBOL OLIGON NEO
      #x1D048	;BYZANTINE MUSICAL SYMBOL OXEIA NEO
      #x1D049	;BYZANTINE MUSICAL SYMBOL PETASTI
      #x1D04A	;BYZANTINE MUSICAL SYMBOL KOUFISMA
      #x1D04B	;BYZANTINE MUSICAL SYMBOL PETASTOKOUFISMA
      #x1D04C	;BYZANTINE MUSICAL SYMBOL KRATIMOKOUFISMA
      #x1D04D	;BYZANTINE MUSICAL SYMBOL PELASTON NEO
      #x1D04E	;BYZANTINE MUSICAL SYMBOL KENTIMATA NEO ANO
      #x1D04F	;BYZANTINE MUSICAL SYMBOL KENTIMA NEO ANO
      #x1D050	;BYZANTINE MUSICAL SYMBOL YPSILI
      #x1D051	;BYZANTINE MUSICAL SYMBOL APOSTROFOS NEO
      #x1D052	;BYZANTINE MUSICAL SYMBOL APOSTROFOI SYNDESMOS NEO
      #x1D053	;BYZANTINE MUSICAL SYMBOL YPORROI
      #x1D054	;BYZANTINE MUSICAL SYMBOL KRATIMOYPORROON
      #x1D055	;BYZANTINE MUSICAL SYMBOL ELAFRON
      #x1D056	;BYZANTINE MUSICAL SYMBOL CHAMILI
      #x1D057	;BYZANTINE MUSICAL SYMBOL MIKRON ISON
      #x1D058	;BYZANTINE MUSICAL SYMBOL VAREIA NEO
      #x1D059	;BYZANTINE MUSICAL SYMBOL PIASMA NEO
      #x1D05A	;BYZANTINE MUSICAL SYMBOL PSIFISTON NEO
      #x1D05B	;BYZANTINE MUSICAL SYMBOL OMALON
      #x1D05C	;BYZANTINE MUSICAL SYMBOL ANTIKENOMA
      #x1D05D	;BYZANTINE MUSICAL SYMBOL LYGISMA
      #x1D05E	;BYZANTINE MUSICAL SYMBOL PARAKLITIKI NEO
      #x1D05F	;BYZANTINE MUSICAL SYMBOL PARAKALESMA NEO
      #x1D060	;BYZANTINE MUSICAL SYMBOL ETERON PARAKALESMA
      #x1D061	;BYZANTINE MUSICAL SYMBOL KYLISMA
      #x1D062	;BYZANTINE MUSICAL SYMBOL ANTIKENOKYLISMA
      #x1D063	;BYZANTINE MUSICAL SYMBOL TROMIKON NEO
      #x1D064	;BYZANTINE MUSICAL SYMBOL EKSTREPTON
      #x1D065	;BYZANTINE MUSICAL SYMBOL SYNAGMA NEO
      #x1D066	;BYZANTINE MUSICAL SYMBOL SYRMA
      #x1D067	;BYZANTINE MUSICAL SYMBOL CHOREVMA NEO
      #x1D068	;BYZANTINE MUSICAL SYMBOL EPEGERMA
      #x1D069	;BYZANTINE MUSICAL SYMBOL SEISMA NEO
      #x1D06A	;BYZANTINE MUSICAL SYMBOL XIRON KLASMA
      #x1D06B	;BYZANTINE MUSICAL SYMBOL TROMIKOPSIFISTON
      #x1D06C	;BYZANTINE MUSICAL SYMBOL PSIFISTOLYGISMA
      #x1D06D	;BYZANTINE MUSICAL SYMBOL TROMIKOLYGISMA
      #x1D06E	;BYZANTINE MUSICAL SYMBOL TROMIKOPARAKALESMA
      #x1D06F	;BYZANTINE MUSICAL SYMBOL PSIFISTOPARAKALESMA
      #x1D070	;BYZANTINE MUSICAL SYMBOL TROMIKOSYNAGMA
      #x1D071	;BYZANTINE MUSICAL SYMBOL PSIFISTOSYNAGMA
      #x1D072	;BYZANTINE MUSICAL SYMBOL GORGOSYNTHETON
      #x1D073	;BYZANTINE MUSICAL SYMBOL ARGOSYNTHETON
      #x1D074	;BYZANTINE MUSICAL SYMBOL ETERON ARGOSYNTHETON
      #x1D075	;BYZANTINE MUSICAL SYMBOL OYRANISMA NEO
      #x1D076	;BYZANTINE MUSICAL SYMBOL THEMATISMOS ESO
      #x1D077	;BYZANTINE MUSICAL SYMBOL THEMATISMOS EXO
      #x1D078	;BYZANTINE MUSICAL SYMBOL THEMA APLOUN
      #x1D079	;BYZANTINE MUSICAL SYMBOL THES KAI APOTHES
      #x1D07A	;BYZANTINE MUSICAL SYMBOL KATAVASMA
      #x1D07B	;BYZANTINE MUSICAL SYMBOL ENDOFONON
      #x1D07C	;BYZANTINE MUSICAL SYMBOL YFEN KATO
      #x1D07D	;BYZANTINE MUSICAL SYMBOL YFEN ANO
      #x1D07E	;BYZANTINE MUSICAL SYMBOL STAVROS
      #x1D07F	;BYZANTINE MUSICAL SYMBOL KLASMA ANO
      #x1D080	;BYZANTINE MUSICAL SYMBOL DIPLI ARCHAION
      #x1D081	;BYZANTINE MUSICAL SYMBOL KRATIMA ARCHAION
      #x1D082	;BYZANTINE MUSICAL SYMBOL KRATIMA ALLO
      #x1D083	;BYZANTINE MUSICAL SYMBOL KRATIMA NEO
      #x1D084	;BYZANTINE MUSICAL SYMBOL APODERMA NEO
      #x1D085	;BYZANTINE MUSICAL SYMBOL APLI
      #x1D086	;BYZANTINE MUSICAL SYMBOL DIPLI
      #x1D087	;BYZANTINE MUSICAL SYMBOL TRIPLI
      #x1D088	;BYZANTINE MUSICAL SYMBOL TETRAPLI
      #x1D089	;BYZANTINE MUSICAL SYMBOL KORONIS
      #x1D08A	;BYZANTINE MUSICAL SYMBOL LEIMMA ENOS CHRONOU
      #x1D08B	;BYZANTINE MUSICAL SYMBOL LEIMMA DYO CHRONON
      #x1D08C	;BYZANTINE MUSICAL SYMBOL LEIMMA TRION CHRONON
      #x1D08D	;BYZANTINE MUSICAL SYMBOL LEIMMA TESSARON CHRONON
      #x1D08E	;BYZANTINE MUSICAL SYMBOL LEIMMA IMISEOS CHRONOU
      #x1D08F	;BYZANTINE MUSICAL SYMBOL GORGON NEO ANO
      #x1D090	;BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON ARISTERA
      #x1D091	;BYZANTINE MUSICAL SYMBOL GORGON PARESTIGMENON DEXIA
      #x1D092	;BYZANTINE MUSICAL SYMBOL DIGORGON
      #x1D093	;BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA KATO
      #x1D094	;BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON ARISTERA ANO
      #x1D095	;BYZANTINE MUSICAL SYMBOL DIGORGON PARESTIGMENON DEXIA
      #x1D096	;BYZANTINE MUSICAL SYMBOL TRIGORGON
      #x1D097	;BYZANTINE MUSICAL SYMBOL ARGON
      #x1D098	;BYZANTINE MUSICAL SYMBOL IMIDIARGON
      #x1D099	;BYZANTINE MUSICAL SYMBOL DIARGON
      #x1D09A	;BYZANTINE MUSICAL SYMBOL AGOGI POLI ARGI
      #x1D09B	;BYZANTINE MUSICAL SYMBOL AGOGI ARGOTERI
      #x1D09C	;BYZANTINE MUSICAL SYMBOL AGOGI ARGI
      #x1D09D	;BYZANTINE MUSICAL SYMBOL AGOGI METRIA
      #x1D09E	;BYZANTINE MUSICAL SYMBOL AGOGI MESI
      #x1D09F	;BYZANTINE MUSICAL SYMBOL AGOGI GORGI
      #x1D0A0	;BYZANTINE MUSICAL SYMBOL AGOGI GORGOTERI
      #x1D0A1	;BYZANTINE MUSICAL SYMBOL AGOGI POLI GORGI
      #x1D0A2	;BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOS ICHOS
      #x1D0A3	;BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI PROTOS ICHOS
      #x1D0A4	;BYZANTINE MUSICAL SYMBOL MARTYRIA DEYTEROS ICHOS
      #x1D0A5	;BYZANTINE MUSICAL SYMBOL MARTYRIA ALLI DEYTEROS ICHOS
      #x1D0A6	;BYZANTINE MUSICAL SYMBOL MARTYRIA TRITOS ICHOS
      #x1D0A7	;BYZANTINE MUSICAL SYMBOL MARTYRIA TRIFONIAS
      #x1D0A8	;BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS ICHOS
      #x1D0A9	;BYZANTINE MUSICAL SYMBOL MARTYRIA TETARTOS LEGETOS ICHOS
      #x1D0AA	;BYZANTINE MUSICAL SYMBOL MARTYRIA LEGETOS ICHOS
      #x1D0AB	;BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS ICHOS
      #x1D0AC	;BYZANTINE MUSICAL SYMBOL ISAKIA TELOUS ICHIMATOS
      #x1D0AD	;BYZANTINE MUSICAL SYMBOL APOSTROFOI TELOUS ICHIMATOS
      #x1D0AE	;BYZANTINE MUSICAL SYMBOL FANEROSIS TETRAFONIAS
      #x1D0AF	;BYZANTINE MUSICAL SYMBOL FANEROSIS MONOFONIAS
      #x1D0B0	;BYZANTINE MUSICAL SYMBOL FANEROSIS DIFONIAS
      #x1D0B1	;BYZANTINE MUSICAL SYMBOL MARTYRIA VARYS ICHOS
      #x1D0B2	;BYZANTINE MUSICAL SYMBOL MARTYRIA PROTOVARYS ICHOS
      #x1D0B3	;BYZANTINE MUSICAL SYMBOL MARTYRIA PLAGIOS TETARTOS ICHOS
      #x1D0B4	;BYZANTINE MUSICAL SYMBOL GORTHMIKON N APLOUN
      #x1D0B5	;BYZANTINE MUSICAL SYMBOL GORTHMIKON N DIPLOUN
      #x1D0B6	;BYZANTINE MUSICAL SYMBOL ENARXIS KAI FTHORA VOU
      #x1D0B7	;BYZANTINE MUSICAL SYMBOL IMIFONON
      #x1D0B8	;BYZANTINE MUSICAL SYMBOL IMIFTHORON
      #x1D0B9	;BYZANTINE MUSICAL SYMBOL FTHORA ARCHAION DEYTEROU ICHOU
      #x1D0BA	;BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI PA
      #x1D0BB	;BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NANA
      #x1D0BC	;BYZANTINE MUSICAL SYMBOL FTHORA NAOS ICHOS
      #x1D0BD	;BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI DI
      #x1D0BE	;BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON DIATONON DI
      #x1D0BF	;BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI KE
      #x1D0C0	;BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI ZO
      #x1D0C1	;BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI KATO
      #x1D0C2	;BYZANTINE MUSICAL SYMBOL FTHORA DIATONIKI NI ANO
      #x1D0C3	;BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA DIFONIAS
      #x1D0C4	;BYZANTINE MUSICAL SYMBOL FTHORA MALAKON CHROMA MONOFONIAS
      #x1D0C5	;BYZANTINE MUSICAL SYMBOL FHTORA SKLIRON CHROMA VASIS
      #x1D0C6	;BYZANTINE MUSICAL SYMBOL FTHORA SKLIRON CHROMA SYNAFI
      #x1D0C7	;BYZANTINE MUSICAL SYMBOL FTHORA NENANO
      #x1D0C8	;BYZANTINE MUSICAL SYMBOL CHROA ZYGOS
      #x1D0C9	;BYZANTINE MUSICAL SYMBOL CHROA KLITON
      #x1D0CA	;BYZANTINE MUSICAL SYMBOL CHROA SPATHI
      #x1D0CB	;BYZANTINE MUSICAL SYMBOL FTHORA I YFESIS TETARTIMORION
      #x1D0CC	;BYZANTINE MUSICAL SYMBOL FTHORA ENARMONIOS ANTIFONIA
      #x1D0CD	;BYZANTINE MUSICAL SYMBOL YFESIS TRITIMORION
      #x1D0CE	;BYZANTINE MUSICAL SYMBOL DIESIS TRITIMORION
      #x1D0CF	;BYZANTINE MUSICAL SYMBOL DIESIS TETARTIMORION
      #x1D0D0	;BYZANTINE MUSICAL SYMBOL DIESIS APLI DYO DODEKATA
      #x1D0D1	;BYZANTINE MUSICAL SYMBOL DIESIS MONOGRAMMOS TESSERA DODEKATA
      #x1D0D2	;BYZANTINE MUSICAL SYMBOL DIESIS DIGRAMMOS EX DODEKATA
      #x1D0D3	;BYZANTINE MUSICAL SYMBOL DIESIS TRIGRAMMOS OKTO DODEKATA
      #x1D0D4	;BYZANTINE MUSICAL SYMBOL YFESIS APLI DYO DODEKATA
      #x1D0D5	;BYZANTINE MUSICAL SYMBOL YFESIS MONOGRAMMOS TESSERA DODEKATA
      #x1D0D6	;BYZANTINE MUSICAL SYMBOL YFESIS DIGRAMMOS EX DODEKATA
      #x1D0D7	;BYZANTINE MUSICAL SYMBOL YFESIS TRIGRAMMOS OKTO DODEKATA
      #x1D0D8	;BYZANTINE MUSICAL SYMBOL GENIKI DIESIS
      #x1D0D9	;BYZANTINE MUSICAL SYMBOL GENIKI YFESIS
      #x1D0DA	;BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MIKRI
      #x1D0DB	;BYZANTINE MUSICAL SYMBOL DIASTOLI APLI MEGALI
      #x1D0DC	;BYZANTINE MUSICAL SYMBOL DIASTOLI DIPLI
      #x1D0DD	;BYZANTINE MUSICAL SYMBOL DIASTOLI THESEOS
      #x1D0DE	;BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS
      #x1D0DF	;BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS DISIMOU
      #x1D0E0	;BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TRISIMOU
      #x1D0E1	;BYZANTINE MUSICAL SYMBOL SIMANSIS THESEOS TETRASIMOU
      #x1D0E2	;BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS
      #x1D0E3	;BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS DISIMOU
      #x1D0E4	;BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TRISIMOU
      #x1D0E5	;BYZANTINE MUSICAL SYMBOL SIMANSIS ARSEOS TETRASIMOU
      #x1D0E6	;BYZANTINE MUSICAL SYMBOL DIGRAMMA GG
      #x1D0E7	;BYZANTINE MUSICAL SYMBOL DIFTOGGOS OU
      #x1D0E8	;BYZANTINE MUSICAL SYMBOL STIGMA
      #x1D0E9	;BYZANTINE MUSICAL SYMBOL ARKTIKO PA
      #x1D0EA	;BYZANTINE MUSICAL SYMBOL ARKTIKO VOU
      #x1D0EB	;BYZANTINE MUSICAL SYMBOL ARKTIKO GA
      #x1D0EC	;BYZANTINE MUSICAL SYMBOL ARKTIKO DI
      #x1D0ED	;BYZANTINE MUSICAL SYMBOL ARKTIKO KE
      #x1D0EE	;BYZANTINE MUSICAL SYMBOL ARKTIKO ZO
      #x1D0EF	;BYZANTINE MUSICAL SYMBOL ARKTIKO NI
      #x1D0F0	;BYZANTINE MUSICAL SYMBOL KENTIMATA NEO MESO
      #x1D0F1	;BYZANTINE MUSICAL SYMBOL KENTIMA NEO MESO
      #x1D0F2	;BYZANTINE MUSICAL SYMBOL KENTIMATA NEO KATO
      #x1D0F3	;BYZANTINE MUSICAL SYMBOL KENTIMA NEO KATO
      #x1D0F4	;BYZANTINE MUSICAL SYMBOL KLASMA KATO
      #x1D0F5	;BYZANTINE MUSICAL SYMBOL GORGON NEO KATO
      #x1D100	;MUSICAL SYMBOL SINGLE BARLINE
      #x1D101	;MUSICAL SYMBOL DOUBLE BARLINE
      #x1D102	;MUSICAL SYMBOL FINAL BARLINE
      #x1D103	;MUSICAL SYMBOL REVERSE FINAL BARLINE
      #x1D104	;MUSICAL SYMBOL DASHED BARLINE
      #x1D105	;MUSICAL SYMBOL SHORT BARLINE
      #x1D106	;MUSICAL SYMBOL LEFT REPEAT SIGN
      #x1D107	;MUSICAL SYMBOL RIGHT REPEAT SIGN
      #x1D108	;MUSICAL SYMBOL REPEAT DOTS
      #x1D109	;MUSICAL SYMBOL DAL SEGNO
      #x1D10A	;MUSICAL SYMBOL DA CAPO
      #x1D10B	;MUSICAL SYMBOL SEGNO
      #x1D10C	;MUSICAL SYMBOL CODA
      #x1D10D	;MUSICAL SYMBOL REPEATED FIGURE-1
      #x1D10E	;MUSICAL SYMBOL REPEATED FIGURE-2
      #x1D10F	;MUSICAL SYMBOL REPEATED FIGURE-3
      #x1D110	;MUSICAL SYMBOL FERMATA
      #x1D111	;MUSICAL SYMBOL FERMATA BELOW
      #x1D112	;MUSICAL SYMBOL BREATH MARK
      #x1D113	;MUSICAL SYMBOL CAESURA
      #x1D114	;MUSICAL SYMBOL BRACE
      #x1D115	;MUSICAL SYMBOL BRACKET
      #x1D116	;MUSICAL SYMBOL ONE-LINE STAFF
      #x1D117	;MUSICAL SYMBOL TWO-LINE STAFF
      #x1D118	;MUSICAL SYMBOL THREE-LINE STAFF
      #x1D119	;MUSICAL SYMBOL FOUR-LINE STAFF
      #x1D11A	;MUSICAL SYMBOL FIVE-LINE STAFF
      #x1D11B	;MUSICAL SYMBOL SIX-LINE STAFF
      #x1D11C	;MUSICAL SYMBOL SIX-STRING FRETBOARD
      #x1D11D	;MUSICAL SYMBOL FOUR-STRING FRETBOARD
      #x1D11E	;MUSICAL SYMBOL G CLEF
      #x1D11F	;MUSICAL SYMBOL G CLEF OTTAVA ALTA
      #x1D120	;MUSICAL SYMBOL G CLEF OTTAVA BASSA
      #x1D121	;MUSICAL SYMBOL C CLEF
      #x1D122	;MUSICAL SYMBOL F CLEF
      #x1D123	;MUSICAL SYMBOL F CLEF OTTAVA ALTA
      #x1D124	;MUSICAL SYMBOL F CLEF OTTAVA BASSA
      #x1D125	;MUSICAL SYMBOL DRUM CLEF-1
      #x1D126	;MUSICAL SYMBOL DRUM CLEF-2
      #x1D12A	;MUSICAL SYMBOL DOUBLE SHARP
      #x1D12B	;MUSICAL SYMBOL DOUBLE FLAT
      #x1D12C	;MUSICAL SYMBOL FLAT UP
      #x1D12D	;MUSICAL SYMBOL FLAT DOWN
      #x1D12E	;MUSICAL SYMBOL NATURAL UP
      #x1D12F	;MUSICAL SYMBOL NATURAL DOWN
      #x1D130	;MUSICAL SYMBOL SHARP UP
      #x1D131	;MUSICAL SYMBOL SHARP DOWN
      #x1D132	;MUSICAL SYMBOL QUARTER TONE SHARP
      #x1D133	;MUSICAL SYMBOL QUARTER TONE FLAT
      #x1D134	;MUSICAL SYMBOL COMMON TIME
      #x1D135	;MUSICAL SYMBOL CUT TIME
      #x1D136	;MUSICAL SYMBOL OTTAVA ALTA
      #x1D137	;MUSICAL SYMBOL OTTAVA BASSA
      #x1D138	;MUSICAL SYMBOL QUINDICESIMA ALTA
      #x1D139	;MUSICAL SYMBOL QUINDICESIMA BASSA
      #x1D13A	;MUSICAL SYMBOL MULTI REST
      #x1D13B	;MUSICAL SYMBOL WHOLE REST
      #x1D13C	;MUSICAL SYMBOL HALF REST
      #x1D13D	;MUSICAL SYMBOL QUARTER REST
      #x1D13E	;MUSICAL SYMBOL EIGHTH REST
      #x1D13F	;MUSICAL SYMBOL SIXTEENTH REST
      #x1D140	;MUSICAL SYMBOL THIRTY-SECOND REST
      #x1D141	;MUSICAL SYMBOL SIXTY-FOURTH REST
      #x1D142	;MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH REST
      #x1D143	;MUSICAL SYMBOL X NOTEHEAD
      #x1D144	;MUSICAL SYMBOL PLUS NOTEHEAD
      #x1D145	;MUSICAL SYMBOL CIRCLE X NOTEHEAD
      #x1D146	;MUSICAL SYMBOL SQUARE NOTEHEAD WHITE
      #x1D147	;MUSICAL SYMBOL SQUARE NOTEHEAD BLACK
      #x1D148	;MUSICAL SYMBOL TRIANGLE NOTEHEAD UP WHITE
      #x1D149	;MUSICAL SYMBOL TRIANGLE NOTEHEAD UP BLACK
      #x1D14A	;MUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT WHITE
      #x1D14B	;MUSICAL SYMBOL TRIANGLE NOTEHEAD LEFT BLACK
      #x1D14C	;MUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT WHITE
      #x1D14D	;MUSICAL SYMBOL TRIANGLE NOTEHEAD RIGHT BLACK
      #x1D14E	;MUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN WHITE
      #x1D14F	;MUSICAL SYMBOL TRIANGLE NOTEHEAD DOWN BLACK
      #x1D150	;MUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT WHITE
      #x1D151	;MUSICAL SYMBOL TRIANGLE NOTEHEAD UP RIGHT BLACK
      #x1D152	;MUSICAL SYMBOL MOON NOTEHEAD WHITE
      #x1D153	;MUSICAL SYMBOL MOON NOTEHEAD BLACK
      #x1D154	;MUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN WHITE
      #x1D155	;MUSICAL SYMBOL TRIANGLE-ROUND NOTEHEAD DOWN BLACK
      #x1D156	;MUSICAL SYMBOL PARENTHESIS NOTEHEAD
      #x1D157	;MUSICAL SYMBOL VOID NOTEHEAD
      #x1D158	;MUSICAL SYMBOL NOTEHEAD BLACK
      #x1D159	;MUSICAL SYMBOL NULL NOTEHEAD
      #x1D15A	;MUSICAL SYMBOL CLUSTER NOTEHEAD WHITE
      #x1D15B	;MUSICAL SYMBOL CLUSTER NOTEHEAD BLACK
      #x1D15C	;MUSICAL SYMBOL BREVE
      #x1D15D	;MUSICAL SYMBOL WHOLE NOTE
      #x1D15E	;MUSICAL SYMBOL HALF NOTE
      #x1D15F	;MUSICAL SYMBOL QUARTER NOTE
      #x1D160	;MUSICAL SYMBOL EIGHTH NOTE
      #x1D161	;MUSICAL SYMBOL SIXTEENTH NOTE
      #x1D162	;MUSICAL SYMBOL THIRTY-SECOND NOTE
      #x1D163	;MUSICAL SYMBOL SIXTY-FOURTH NOTE
      #x1D164	;MUSICAL SYMBOL ONE HUNDRED TWENTY-EIGHTH NOTE
      #x1D16A	;MUSICAL SYMBOL FINGERED TREMOLO-1
      #x1D16B	;MUSICAL SYMBOL FINGERED TREMOLO-2
      #x1D16C	;MUSICAL SYMBOL FINGERED TREMOLO-3
      #x1D183	;MUSICAL SYMBOL ARPEGGIATO UP
      #x1D184	;MUSICAL SYMBOL ARPEGGIATO DOWN
      #x1D18C	;MUSICAL SYMBOL RINFORZANDO
      #x1D18D	;MUSICAL SYMBOL SUBITO
      #x1D18E	;MUSICAL SYMBOL Z
      #x1D18F	;MUSICAL SYMBOL PIANO
      #x1D190	;MUSICAL SYMBOL MEZZO
      #x1D191	;MUSICAL SYMBOL FORTE
      #x1D192	;MUSICAL SYMBOL CRESCENDO
      #x1D193	;MUSICAL SYMBOL DECRESCENDO
      #x1D194	;MUSICAL SYMBOL GRACE NOTE SLASH
      #x1D195	;MUSICAL SYMBOL GRACE NOTE NO SLASH
      #x1D196	;MUSICAL SYMBOL TR
      #x1D197	;MUSICAL SYMBOL TURN
      #x1D198	;MUSICAL SYMBOL INVERTED TURN
      #x1D199	;MUSICAL SYMBOL TURN SLASH
      #x1D19A	;MUSICAL SYMBOL TURN UP
      #x1D19B	;MUSICAL SYMBOL ORNAMENT STROKE-1
      #x1D19C	;MUSICAL SYMBOL ORNAMENT STROKE-2
      #x1D19D	;MUSICAL SYMBOL ORNAMENT STROKE-3
      #x1D19E	;MUSICAL SYMBOL ORNAMENT STROKE-4
      #x1D19F	;MUSICAL SYMBOL ORNAMENT STROKE-5
      #x1D1A0	;MUSICAL SYMBOL ORNAMENT STROKE-6
      #x1D1A1	;MUSICAL SYMBOL ORNAMENT STROKE-7
      #x1D1A2	;MUSICAL SYMBOL ORNAMENT STROKE-8
      #x1D1A3	;MUSICAL SYMBOL ORNAMENT STROKE-9
      #x1D1A4	;MUSICAL SYMBOL ORNAMENT STROKE-10
      #x1D1A5	;MUSICAL SYMBOL ORNAMENT STROKE-11
      #x1D1A6	;MUSICAL SYMBOL HAUPTSTIMME
      #x1D1A7	;MUSICAL SYMBOL NEBENSTIMME
      #x1D1A8	;MUSICAL SYMBOL END OF STIMME
      #x1D1A9	;MUSICAL SYMBOL DEGREE SLASH
      #x1D1AE	;MUSICAL SYMBOL PEDAL MARK
      #x1D1AF	;MUSICAL SYMBOL PEDAL UP MARK
      #x1D1B0	;MUSICAL SYMBOL HALF PEDAL MARK
      #x1D1B1	;MUSICAL SYMBOL GLISSANDO UP
      #x1D1B2	;MUSICAL SYMBOL GLISSANDO DOWN
      #x1D1B3	;MUSICAL SYMBOL WITH FINGERNAILS
      #x1D1B4	;MUSICAL SYMBOL DAMP
      #x1D1B5	;MUSICAL SYMBOL DAMP ALL
      #x1D1B6	;MUSICAL SYMBOL MAXIMA
      #x1D1B7	;MUSICAL SYMBOL LONGA
      #x1D1B8	;MUSICAL SYMBOL BREVIS
      #x1D1B9	;MUSICAL SYMBOL SEMIBREVIS WHITE
      #x1D1BA	;MUSICAL SYMBOL SEMIBREVIS BLACK
      #x1D1BB	;MUSICAL SYMBOL MINIMA
      #x1D1BC	;MUSICAL SYMBOL MINIMA BLACK
      #x1D1BD	;MUSICAL SYMBOL SEMIMINIMA WHITE
      #x1D1BE	;MUSICAL SYMBOL SEMIMINIMA BLACK
      #x1D1BF	;MUSICAL SYMBOL FUSA WHITE
      #x1D1C0	;MUSICAL SYMBOL FUSA BLACK
      #x1D1C1	;MUSICAL SYMBOL LONGA PERFECTA REST
      #x1D1C2	;MUSICAL SYMBOL LONGA IMPERFECTA REST
      #x1D1C3	;MUSICAL SYMBOL BREVIS REST
      #x1D1C4	;MUSICAL SYMBOL SEMIBREVIS REST
      #x1D1C5	;MUSICAL SYMBOL MINIMA REST
      #x1D1C6	;MUSICAL SYMBOL SEMIMINIMA REST
      #x1D1C7	;MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA
      #x1D1C8	;MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE IMPERFECTA
      #x1D1C9	;MUSICAL SYMBOL TEMPUS PERFECTUM CUM PROLATIONE PERFECTA DIMINUTION-1
      #x1D1CA	;MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE PERFECTA
      #x1D1CB	;MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA
      #x1D1CC	;MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-1
      #x1D1CD	;MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-2
      #x1D1CE	;MUSICAL SYMBOL TEMPUS IMPERFECTUM CUM PROLATIONE IMPERFECTA DIMINUTION-3
      #x1D1CF	;MUSICAL SYMBOL CROIX
      #x1D1D0	;MUSICAL SYMBOL GREGORIAN C CLEF
      #x1D1D1	;MUSICAL SYMBOL GREGORIAN F CLEF
      #x1D1D2	;MUSICAL SYMBOL SQUARE B
      #x1D1D3	;MUSICAL SYMBOL VIRGA
      #x1D1D4	;MUSICAL SYMBOL PODATUS
      #x1D1D5	;MUSICAL SYMBOL CLIVIS
      #x1D1D6	;MUSICAL SYMBOL SCANDICUS
      #x1D1D7	;MUSICAL SYMBOL CLIMACUS
      #x1D1D8	;MUSICAL SYMBOL TORCULUS
      #x1D1D9	;MUSICAL SYMBOL PORRECTUS
      #x1D1DA	;MUSICAL SYMBOL PORRECTUS FLEXUS
      #x1D1DB	;MUSICAL SYMBOL SCANDICUS FLEXUS
      #x1D1DC	;MUSICAL SYMBOL TORCULUS RESUPINUS
      #x1D1DD	;MUSICAL SYMBOL PES SUBPUNCTIS
      #x1D300	;MONOGRAM FOR EARTH
      #x1D301	;DIGRAM FOR HEAVENLY EARTH
      #x1D302	;DIGRAM FOR HUMAN EARTH
      #x1D303	;DIGRAM FOR EARTHLY HEAVEN
      #x1D304	;DIGRAM FOR EARTHLY HUMAN
      #x1D305	;DIGRAM FOR EARTH
      #x1D306	;TETRAGRAM FOR CENTRE
      #x1D307	;TETRAGRAM FOR FULL CIRCLE
      #x1D308	;TETRAGRAM FOR MIRED
      #x1D309	;TETRAGRAM FOR BARRIER
      #x1D30A	;TETRAGRAM FOR KEEPING SMALL
      #x1D30B	;TETRAGRAM FOR CONTRARIETY
      #x1D30C	;TETRAGRAM FOR ASCENT
      #x1D30D	;TETRAGRAM FOR OPPOSITION
      #x1D30E	;TETRAGRAM FOR BRANCHING OUT
      #x1D30F	;TETRAGRAM FOR DEFECTIVENESS OR DISTORTION
      #x1D310	;TETRAGRAM FOR DIVERGENCE
      #x1D311	;TETRAGRAM FOR YOUTHFULNESS
      #x1D312	;TETRAGRAM FOR INCREASE
      #x1D313	;TETRAGRAM FOR PENETRATION
      #x1D314	;TETRAGRAM FOR REACH
      #x1D315	;TETRAGRAM FOR CONTACT
      #x1D316	;TETRAGRAM FOR HOLDING BACK
      #x1D317	;TETRAGRAM FOR WAITING
      #x1D318	;TETRAGRAM FOR FOLLOWING
      #x1D319	;TETRAGRAM FOR ADVANCE
      #x1D31A	;TETRAGRAM FOR RELEASE
      #x1D31B	;TETRAGRAM FOR RESISTANCE
      #x1D31C	;TETRAGRAM FOR EASE
      #x1D31D	;TETRAGRAM FOR JOY
      #x1D31E	;TETRAGRAM FOR CONTENTION
      #x1D31F	;TETRAGRAM FOR ENDEAVOUR
      #x1D320	;TETRAGRAM FOR DUTIES
      #x1D321	;TETRAGRAM FOR CHANGE
      #x1D322	;TETRAGRAM FOR DECISIVENESS
      #x1D323	;TETRAGRAM FOR BOLD RESOLUTION
      #x1D324	;TETRAGRAM FOR PACKING
      #x1D325	;TETRAGRAM FOR LEGION
      #x1D326	;TETRAGRAM FOR CLOSENESS
      #x1D327	;TETRAGRAM FOR KINSHIP
      #x1D328	;TETRAGRAM FOR GATHERING
      #x1D329	;TETRAGRAM FOR STRENGTH
      #x1D32A	;TETRAGRAM FOR PURITY
      #x1D32B	;TETRAGRAM FOR FULLNESS
      #x1D32C	;TETRAGRAM FOR RESIDENCE
      #x1D32D	;TETRAGRAM FOR LAW OR MODEL
      #x1D32E	;TETRAGRAM FOR RESPONSE
      #x1D32F	;TETRAGRAM FOR GOING TO MEET
      #x1D330	;TETRAGRAM FOR ENCOUNTERS
      #x1D331	;TETRAGRAM FOR STOVE
      #x1D332	;TETRAGRAM FOR GREATNESS
      #x1D333	;TETRAGRAM FOR ENLARGEMENT
      #x1D334	;TETRAGRAM FOR PATTERN
      #x1D335	;TETRAGRAM FOR RITUAL
      #x1D336	;TETRAGRAM FOR FLIGHT
      #x1D337	;TETRAGRAM FOR VASTNESS OR WASTING
      #x1D338	;TETRAGRAM FOR CONSTANCY
      #x1D339	;TETRAGRAM FOR MEASURE
      #x1D33A	;TETRAGRAM FOR ETERNITY
      #x1D33B	;TETRAGRAM FOR UNITY
      #x1D33C	;TETRAGRAM FOR DIMINISHMENT
      #x1D33D	;TETRAGRAM FOR CLOSED MOUTH
      #x1D33E	;TETRAGRAM FOR GUARDEDNESS
      #x1D33F	;TETRAGRAM FOR GATHERING IN
      #x1D340	;TETRAGRAM FOR MASSING
      #x1D341	;TETRAGRAM FOR ACCUMULATION
      #x1D342	;TETRAGRAM FOR EMBELLISHMENT
      #x1D343	;TETRAGRAM FOR DOUBT
      #x1D344	;TETRAGRAM FOR WATCH
      #x1D345	;TETRAGRAM FOR SINKING
      #x1D346	;TETRAGRAM FOR INNER
      #x1D347	;TETRAGRAM FOR DEPARTURE
      #x1D348	;TETRAGRAM FOR DARKENING
      #x1D349	;TETRAGRAM FOR DIMMING
      #x1D34A	;TETRAGRAM FOR EXHAUSTION
      #x1D34B	;TETRAGRAM FOR SEVERANCE
      #x1D34C	;TETRAGRAM FOR STOPPAGE
      #x1D34D	;TETRAGRAM FOR HARDNESS
      #x1D34E	;TETRAGRAM FOR COMPLETION
      #x1D34F	;TETRAGRAM FOR CLOSURE
      #x1D350	;TETRAGRAM FOR FAILURE
      #x1D351	;TETRAGRAM FOR AGGRAVATION
      #x1D352	;TETRAGRAM FOR COMPLIANCE
      #x1D353	;TETRAGRAM FOR ON THE VERGE
      #x1D354	;TETRAGRAM FOR DIFFICULTIES
      #x1D355	;TETRAGRAM FOR LABOURING
      #x1D356	;TETRAGRAM FOR FOSTERING
      #x1D6C1	;MATHEMATICAL BOLD NABLA
      #x1D6DB	;MATHEMATICAL BOLD PARTIAL DIFFERENTIAL
      #x1D6FB	;MATHEMATICAL ITALIC NABLA
      #x1D715	;MATHEMATICAL ITALIC PARTIAL DIFFERENTIAL
      #x1D735	;MATHEMATICAL BOLD ITALIC NABLA
      #x1D74F	;MATHEMATICAL BOLD ITALIC PARTIAL DIFFERENTIAL
      #x1D76F	;MATHEMATICAL SANS-SERIF BOLD NABLA
      #x1D789	;MATHEMATICAL SANS-SERIF BOLD PARTIAL DIFFERENTIAL
      #x1D7A9	;MATHEMATICAL SANS-SERIF BOLD ITALIC NABLA
      #x1D7C3	;MATHEMATICAL SANS-SERIF BOLD ITALIC PARTIAL DIFFERENTIAL
)))

(define char-set:blank
  (build-char-set
   '( #x0009      ;HORIZONTAL TABULATION
      #x0020	;SPACE
      #x00A0	;NO-BREAK SPACE
      #x1680	;OGHAM SPACE MARK
      #x180E	;MONGOLIAN VOWEL SEPARATOR
      #x2000	;EN QUAD
      #x2001	;EM QUAD
      #x2002	;EN SPACE
      #x2003	;EM SPACE
      #x2004	;THREE-PER-EM SPACE
      #x2005	;FOUR-PER-EM SPACE
      #x2006	;SIX-PER-EM SPACE
      #x2007	;FIGURE SPACE
      #x2008	;PUNCTUATION SPACE
      #x2009	;THIN SPACE
      #x200A	;HAIR SPACE
      #x2028	;LINE SEPARATOR
      #x2029	;PARAGRAPH SEPARATOR
      #x202F	;NARROW NO-BREAK SPACE
      #x205F	;MEDIUM MATHEMATICAL SPACE
      #x3000	;IDEOGRAPHIC SPACE
)))

(define char-set:ascii 
  (char-set-union
   (ucs-range->char-set #x0000 #x00ff)))

(define char-set:hex-digit
  (string->char-set "0123456789abcdefABCDEF"))

(define char-set:letter+digit
  (char-set-union char-set:letter char-set:digit))

(define char-set:iso-control
  (char-set-union
   (ucs-range->char-set #x0000 #x0020)
   (ucs-range->char-set #x007f #x00a0)))
   
; It is unknown if the following is sufficient.  I bet it isn't.
(define char-set:graphic
  (char-set-union
   char-set:letter
   char-set:digit
   char-set:punctuation
   char-set:symbol))
      
(define char-set:printing
  (char-set-union char-set:whitespace char-set:graphic))

(define char-set:full
  (build-char-set
   '( #x0000	;<control>
      #x0001	;<control>
      #x0002	;<control>
      #x0003	;<control>
      #x0004	;<control>
      #x0005	;<control>
      #x0006	;<control>
      #x0007	;<control>
      #x0008	;<control>
      #x0009	;<control>
      #x000A	;<control>
      #x000B	;<control>
      #x000C	;<control>
      #x000D	;<control>
      #x000E	;<control>
      #x000F	;<control>
      #x0010	;<control>
      #x0011	;<control>
      #x0012	;<control>
      #x0013	;<control>
      #x0014	;<control>
      #x0015	;<control>
      #x0016	;<control>
      #x0017	;<control>
      #x0018	;<control>
      #x0019	;<control>
      #x001A	;<control>
      #x001B	;<control>
      #x001C	;<control>
      #x001D	;<control>
      #x001E	;<control>
      #x001F	;<control>
      #x0020	;SPACE
      #x0021	;EXCLAMATION MARK
      #x0022	;QUOTATION MARK
      #x0023	;NUMBER SIGN
      #x0024	;DOLLAR SIGN
      #x0025	;PERCENT SIGN
      #x0026	;AMPERSAND
      #x0027	;APOSTROPHE
      #x0028	;LEFT PARENTHESIS
      #x0029	;RIGHT PARENTHESIS
      #x002A	;ASTERISK
      #x002B	;PLUS SIGN
      #x002C	;COMMA
      #x002D	;HYPHEN-MINUS
      #x002E	;FULL STOP
      #x002F	;SOLIDUS
      #x0030	;DIGIT ZERO
      #x0031	;DIGIT ONE
      #x0032	;DIGIT TWO
      #x0033	;DIGIT THREE
      #x0034	;DIGIT FOUR
      #x0035	;DIGIT FIVE
      #x0036	;DIGIT SIX
      #x0037	;DIGIT SEVEN
      #x0038	;DIGIT EIGHT
      #x0039	;DIGIT NINE
      #x003A	;COLON
      #x003B	;SEMICOLON
      #x003C	;LESS-THAN SIGN
      #x003D	;EQUALS SIGN
      #x003E	;GREATER-THAN SIGN
      #x003F	;QUESTION MARK
      #x0040	;COMMERCIAL AT
      #x0041	;LATIN CAPITAL LETTER A
      #x0042	;LATIN CAPITAL LETTER B
      #x0043	;LATIN CAPITAL LETTER C
      #x0044	;LATIN CAPITAL LETTER D
      #x0045	;LATIN CAPITAL LETTER E
      #x0046	;LATIN CAPITAL LETTER F
      #x0047	;LATIN CAPITAL LETTER G
      #x0048	;LATIN CAPITAL LETTER H
      #x0049	;LATIN CAPITAL LETTER I
      #x004A	;LATIN CAPITAL LETTER J
      #x004B	;LATIN CAPITAL LETTER K
      #x004C	;LATIN CAPITAL LETTER L
      #x004D	;LATIN CAPITAL LETTER M
      #x004E	;LATIN CAPITAL LETTER N
      #x004F	;LATIN CAPITAL LETTER O
      #x0050	;LATIN CAPITAL LETTER P
      #x0051	;LATIN CAPITAL LETTER Q
      #x0052	;LATIN CAPITAL LETTER R
      #x0053	;LATIN CAPITAL LETTER S
      #x0054	;LATIN CAPITAL LETTER T
      #x0055	;LATIN CAPITAL LETTER U
      #x0056	;LATIN CAPITAL LETTER V
      #x0057	;LATIN CAPITAL LETTER W
      #x0058	;LATIN CAPITAL LETTER X
      #x0059	;LATIN CAPITAL LETTER Y
      #x005A	;LATIN CAPITAL LETTER Z
      #x005B	;LEFT SQUARE BRACKET
      #x005C	;REVERSE SOLIDUS
      #x005D	;RIGHT SQUARE BRACKET
      #x005E	;CIRCUMFLEX ACCENT
      #x005F	;LOW LINE
      #x0060	;GRAVE ACCENT
      #x0061	;LATIN SMALL LETTER A
      #x0062	;LATIN SMALL LETTER B
      #x0063	;LATIN SMALL LETTER C
      #x0064	;LATIN SMALL LETTER D
      #x0065	;LATIN SMALL LETTER E
      #x0066	;LATIN SMALL LETTER F
      #x0067	;LATIN SMALL LETTER G
      #x0068	;LATIN SMALL LETTER H
      #x0069	;LATIN SMALL LETTER I
      #x006A	;LATIN SMALL LETTER J
      #x006B	;LATIN SMALL LETTER K
      #x006C	;LATIN SMALL LETTER L
      #x006D	;LATIN SMALL LETTER M
      #x006E	;LATIN SMALL LETTER N
      #x006F	;LATIN SMALL LETTER O
      #x0070	;LATIN SMALL LETTER P
      #x0071	;LATIN SMALL LETTER Q
      #x0072	;LATIN SMALL LETTER R
      #x0073	;LATIN SMALL LETTER S
      #x0074	;LATIN SMALL LETTER T
      #x0075	;LATIN SMALL LETTER U
      #x0076	;LATIN SMALL LETTER V
      #x0077	;LATIN SMALL LETTER W
      #x0078	;LATIN SMALL LETTER X
      #x0079	;LATIN SMALL LETTER Y
      #x007A	;LATIN SMALL LETTER Z
      #x007B	;LEFT CURLY BRACKET
      #x007C	;VERTICAL LINE
      #x007D	;RIGHT CURLY BRACKET
      #x007E	;TILDE
      #x007F	;<control>
      #x0080	;<control>
      #x0081	;<control>
      #x0082	;<control>
      #x0083	;<control>
      #x0084	;<control>
      #x0085	;<control>
      #x0086	;<control>
      #x0087	;<control>
      #x0088	;<control>
      #x0089	;<control>
      #x008A	;<control>
      #x008B	;<control>
      #x008C	;<control>
      #x008D	;<control>
      #x008E	;<control>
      #x008F	;<control>
      #x0090	;<control>
      #x0091	;<control>
      #x0092	;<control>
      #x0093	;<control>
      #x0094	;<control>
      #x0095	;<control>
      #x0096	;<control>
      #x0097	;<control>
      #x0098	;<control>
      #x0099	;<control>
      #x009A	;<control>
      #x009B	;<control>
      #x009C	;<control>
      #x009D	;<control>
      #x009E	;<control>
      #x009F	;<control>
      #x00A0	;NO-BREAK SPACE
      #x00A1	;INVERTED EXCLAMATION MARK
      #x00A2	;CENT SIGN
      #x00A3	;POUND SIGN
      #x00A4	;CURRENCY SIGN
      #x00A5	;YEN SIGN
      #x00A6	;BROKEN BAR
      #x00A7	;SECTION SIGN
      #x00A8	;DIAERESIS
      #x00A9	;COPYRIGHT SIGN
      #x00AA	;FEMININE ORDINAL INDICATOR
      #x00AB	;LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
      #x00AC	;NOT SIGN
      #x00AD	;SOFT HYPHEN
      #x00AE	;REGISTERED SIGN
      #x00AF	;MACRON
      #x00B0	;DEGREE SIGN
      #x00B1	;PLUS-MINUS SIGN
      #x00B2	;SUPERSCRIPT TWO
      #x00B3	;SUPERSCRIPT THREE
      #x00B4	;ACUTE ACCENT
      #x00B5	;MICRO SIGN
      #x00B6	;PILCROW SIGN
      #x00B7	;MIDDLE DOT
      #x00B8	;CEDILLA
      #x00B9	;SUPERSCRIPT ONE
      #x00BA	;MASCULINE ORDINAL INDICATOR
      #x00BB	;RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
      #x00BC	;VULGAR FRACTION ONE QUARTER
      #x00BD	;VULGAR FRACTION ONE HALF
      #x00BE	;VULGAR FRACTION THREE QUARTERS
      #x00BF	;INVERTED QUESTION MARK
      #x00C0	;LATIN CAPITAL LETTER A WITH GRAVE
      #x00C1	;LATIN CAPITAL LETTER A WITH ACUTE
      #x00C2	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX
      #x00C3	;LATIN CAPITAL LETTER A WITH TILDE
      #x00C4	;LATIN CAPITAL LETTER A WITH DIAERESIS
      #x00C5	;LATIN CAPITAL LETTER A WITH RING ABOVE
      #x00C6	;LATIN CAPITAL LETTER AE
      #x00C7	;LATIN CAPITAL LETTER C WITH CEDILLA
      #x00C8	;LATIN CAPITAL LETTER E WITH GRAVE
      #x00C9	;LATIN CAPITAL LETTER E WITH ACUTE
      #x00CA	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX
      #x00CB	;LATIN CAPITAL LETTER E WITH DIAERESIS
      #x00CC	;LATIN CAPITAL LETTER I WITH GRAVE
      #x00CD	;LATIN CAPITAL LETTER I WITH ACUTE
      #x00CE	;LATIN CAPITAL LETTER I WITH CIRCUMFLEX
      #x00CF	;LATIN CAPITAL LETTER I WITH DIAERESIS
      #x00D0	;LATIN CAPITAL LETTER ETH
      #x00D1	;LATIN CAPITAL LETTER N WITH TILDE
      #x00D2	;LATIN CAPITAL LETTER O WITH GRAVE
      #x00D3	;LATIN CAPITAL LETTER O WITH ACUTE
      #x00D4	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX
      #x00D5	;LATIN CAPITAL LETTER O WITH TILDE
      #x00D6	;LATIN CAPITAL LETTER O WITH DIAERESIS
      #x00D7	;MULTIPLICATION SIGN
      #x00D8	;LATIN CAPITAL LETTER O WITH STROKE
      #x00D9	;LATIN CAPITAL LETTER U WITH GRAVE
      #x00DA	;LATIN CAPITAL LETTER U WITH ACUTE
      #x00DB	;LATIN CAPITAL LETTER U WITH CIRCUMFLEX
      #x00DC	;LATIN CAPITAL LETTER U WITH DIAERESIS
      #x00DD	;LATIN CAPITAL LETTER Y WITH ACUTE
      #x00DE	;LATIN CAPITAL LETTER THORN
      #x00DF	;LATIN SMALL LETTER SHARP S
      #x00E0	;LATIN SMALL LETTER A WITH GRAVE
      #x00E1	;LATIN SMALL LETTER A WITH ACUTE
      #x00E2	;LATIN SMALL LETTER A WITH CIRCUMFLEX
      #x00E3	;LATIN SMALL LETTER A WITH TILDE
      #x00E4	;LATIN SMALL LETTER A WITH DIAERESIS
      #x00E5	;LATIN SMALL LETTER A WITH RING ABOVE
      #x00E6	;LATIN SMALL LETTER AE
      #x00E7	;LATIN SMALL LETTER C WITH CEDILLA
      #x00E8	;LATIN SMALL LETTER E WITH GRAVE
      #x00E9	;LATIN SMALL LETTER E WITH ACUTE
      #x00EA	;LATIN SMALL LETTER E WITH CIRCUMFLEX
      #x00EB	;LATIN SMALL LETTER E WITH DIAERESIS
      #x00EC	;LATIN SMALL LETTER I WITH GRAVE
      #x00ED	;LATIN SMALL LETTER I WITH ACUTE
      #x00EE	;LATIN SMALL LETTER I WITH CIRCUMFLEX
      #x00EF	;LATIN SMALL LETTER I WITH DIAERESIS
      #x00F0	;LATIN SMALL LETTER ETH
      #x00F1	;LATIN SMALL LETTER N WITH TILDE
      #x00F2	;LATIN SMALL LETTER O WITH GRAVE
      #x00F3	;LATIN SMALL LETTER O WITH ACUTE
      #x00F4	;LATIN SMALL LETTER O WITH CIRCUMFLEX
      #x00F5	;LATIN SMALL LETTER O WITH TILDE
      #x00F6	;LATIN SMALL LETTER O WITH DIAERESIS
      #x00F7	;DIVISION SIGN
      #x00F8	;LATIN SMALL LETTER O WITH STROKE
      #x00F9	;LATIN SMALL LETTER U WITH GRAVE
      #x00FA	;LATIN SMALL LETTER U WITH ACUTE
      #x00FB	;LATIN SMALL LETTER U WITH CIRCUMFLEX
      #x00FC	;LATIN SMALL LETTER U WITH DIAERESIS
      #x00FD	;LATIN SMALL LETTER Y WITH ACUTE
      #x00FE	;LATIN SMALL LETTER THORN
      #x00FF	;LATIN SMALL LETTER Y WITH DIAERESIS
      #x0100	;LATIN CAPITAL LETTER A WITH MACRON
      #x0101	;LATIN SMALL LETTER A WITH MACRON
      #x0102	;LATIN CAPITAL LETTER A WITH BREVE
      #x0103	;LATIN SMALL LETTER A WITH BREVE
      #x0104	;LATIN CAPITAL LETTER A WITH OGONEK
      #x0105	;LATIN SMALL LETTER A WITH OGONEK
      #x0106	;LATIN CAPITAL LETTER C WITH ACUTE
      #x0107	;LATIN SMALL LETTER C WITH ACUTE
      #x0108	;LATIN CAPITAL LETTER C WITH CIRCUMFLEX
      #x0109	;LATIN SMALL LETTER C WITH CIRCUMFLEX
      #x010A	;LATIN CAPITAL LETTER C WITH DOT ABOVE
      #x010B	;LATIN SMALL LETTER C WITH DOT ABOVE
      #x010C	;LATIN CAPITAL LETTER C WITH CARON
      #x010D	;LATIN SMALL LETTER C WITH CARON
      #x010E	;LATIN CAPITAL LETTER D WITH CARON
      #x010F	;LATIN SMALL LETTER D WITH CARON
      #x0110	;LATIN CAPITAL LETTER D WITH STROKE
      #x0111	;LATIN SMALL LETTER D WITH STROKE
      #x0112	;LATIN CAPITAL LETTER E WITH MACRON
      #x0113	;LATIN SMALL LETTER E WITH MACRON
      #x0114	;LATIN CAPITAL LETTER E WITH BREVE
      #x0115	;LATIN SMALL LETTER E WITH BREVE
      #x0116	;LATIN CAPITAL LETTER E WITH DOT ABOVE
      #x0117	;LATIN SMALL LETTER E WITH DOT ABOVE
      #x0118	;LATIN CAPITAL LETTER E WITH OGONEK
      #x0119	;LATIN SMALL LETTER E WITH OGONEK
      #x011A	;LATIN CAPITAL LETTER E WITH CARON
      #x011B	;LATIN SMALL LETTER E WITH CARON
      #x011C	;LATIN CAPITAL LETTER G WITH CIRCUMFLEX
      #x011D	;LATIN SMALL LETTER G WITH CIRCUMFLEX
      #x011E	;LATIN CAPITAL LETTER G WITH BREVE
      #x011F	;LATIN SMALL LETTER G WITH BREVE
      #x0120	;LATIN CAPITAL LETTER G WITH DOT ABOVE
      #x0121	;LATIN SMALL LETTER G WITH DOT ABOVE
      #x0122	;LATIN CAPITAL LETTER G WITH CEDILLA
      #x0123	;LATIN SMALL LETTER G WITH CEDILLA
      #x0124	;LATIN CAPITAL LETTER H WITH CIRCUMFLEX
      #x0125	;LATIN SMALL LETTER H WITH CIRCUMFLEX
      #x0126	;LATIN CAPITAL LETTER H WITH STROKE
      #x0127	;LATIN SMALL LETTER H WITH STROKE
      #x0128	;LATIN CAPITAL LETTER I WITH TILDE
      #x0129	;LATIN SMALL LETTER I WITH TILDE
      #x012A	;LATIN CAPITAL LETTER I WITH MACRON
      #x012B	;LATIN SMALL LETTER I WITH MACRON
      #x012C	;LATIN CAPITAL LETTER I WITH BREVE
      #x012D	;LATIN SMALL LETTER I WITH BREVE
      #x012E	;LATIN CAPITAL LETTER I WITH OGONEK
      #x012F	;LATIN SMALL LETTER I WITH OGONEK
      #x0130	;LATIN CAPITAL LETTER I WITH DOT ABOVE
      #x0131	;LATIN SMALL LETTER DOTLESS I
      #x0132	;LATIN CAPITAL LIGATURE IJ
      #x0133	;LATIN SMALL LIGATURE IJ
      #x0134	;LATIN CAPITAL LETTER J WITH CIRCUMFLEX
      #x0135	;LATIN SMALL LETTER J WITH CIRCUMFLEX
      #x0136	;LATIN CAPITAL LETTER K WITH CEDILLA
      #x0137	;LATIN SMALL LETTER K WITH CEDILLA
      #x0138	;LATIN SMALL LETTER KRA
      #x0139	;LATIN CAPITAL LETTER L WITH ACUTE
      #x013A	;LATIN SMALL LETTER L WITH ACUTE
      #x013B	;LATIN CAPITAL LETTER L WITH CEDILLA
      #x013C	;LATIN SMALL LETTER L WITH CEDILLA
      #x013D	;LATIN CAPITAL LETTER L WITH CARON
      #x013E	;LATIN SMALL LETTER L WITH CARON
      #x013F	;LATIN CAPITAL LETTER L WITH MIDDLE DOT
      #x0140	;LATIN SMALL LETTER L WITH MIDDLE DOT
      #x0141	;LATIN CAPITAL LETTER L WITH STROKE
      #x0142	;LATIN SMALL LETTER L WITH STROKE
      #x0143	;LATIN CAPITAL LETTER N WITH ACUTE
      #x0144	;LATIN SMALL LETTER N WITH ACUTE
      #x0145	;LATIN CAPITAL LETTER N WITH CEDILLA
      #x0146	;LATIN SMALL LETTER N WITH CEDILLA
      #x0147	;LATIN CAPITAL LETTER N WITH CARON
      #x0148	;LATIN SMALL LETTER N WITH CARON
      #x0149	;LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
      #x014A	;LATIN CAPITAL LETTER ENG
      #x014B	;LATIN SMALL LETTER ENG
      #x014C	;LATIN CAPITAL LETTER O WITH MACRON
      #x014D	;LATIN SMALL LETTER O WITH MACRON
      #x014E	;LATIN CAPITAL LETTER O WITH BREVE
      #x014F	;LATIN SMALL LETTER O WITH BREVE
      #x0150	;LATIN CAPITAL LETTER O WITH DOUBLE ACUTE
      #x0151	;LATIN SMALL LETTER O WITH DOUBLE ACUTE
      #x0152	;LATIN CAPITAL LIGATURE OE
      #x0153	;LATIN SMALL LIGATURE OE
      #x0154	;LATIN CAPITAL LETTER R WITH ACUTE
      #x0155	;LATIN SMALL LETTER R WITH ACUTE
      #x0156	;LATIN CAPITAL LETTER R WITH CEDILLA
      #x0157	;LATIN SMALL LETTER R WITH CEDILLA
      #x0158	;LATIN CAPITAL LETTER R WITH CARON
      #x0159	;LATIN SMALL LETTER R WITH CARON
      #x015A	;LATIN CAPITAL LETTER S WITH ACUTE
      #x015B	;LATIN SMALL LETTER S WITH ACUTE
      #x015C	;LATIN CAPITAL LETTER S WITH CIRCUMFLEX
      #x015D	;LATIN SMALL LETTER S WITH CIRCUMFLEX
      #x015E	;LATIN CAPITAL LETTER S WITH CEDILLA
      #x015F	;LATIN SMALL LETTER S WITH CEDILLA
      #x0160	;LATIN CAPITAL LETTER S WITH CARON
      #x0161	;LATIN SMALL LETTER S WITH CARON
      #x0162	;LATIN CAPITAL LETTER T WITH CEDILLA
      #x0163	;LATIN SMALL LETTER T WITH CEDILLA
      #x0164	;LATIN CAPITAL LETTER T WITH CARON
      #x0165	;LATIN SMALL LETTER T WITH CARON
      #x0166	;LATIN CAPITAL LETTER T WITH STROKE
      #x0167	;LATIN SMALL LETTER T WITH STROKE
      #x0168	;LATIN CAPITAL LETTER U WITH TILDE
      #x0169	;LATIN SMALL LETTER U WITH TILDE
      #x016A	;LATIN CAPITAL LETTER U WITH MACRON
      #x016B	;LATIN SMALL LETTER U WITH MACRON
      #x016C	;LATIN CAPITAL LETTER U WITH BREVE
      #x016D	;LATIN SMALL LETTER U WITH BREVE
      #x016E	;LATIN CAPITAL LETTER U WITH RING ABOVE
      #x016F	;LATIN SMALL LETTER U WITH RING ABOVE
      #x0170	;LATIN CAPITAL LETTER U WITH DOUBLE ACUTE
      #x0171	;LATIN SMALL LETTER U WITH DOUBLE ACUTE
      #x0172	;LATIN CAPITAL LETTER U WITH OGONEK
      #x0173	;LATIN SMALL LETTER U WITH OGONEK
      #x0174	;LATIN CAPITAL LETTER W WITH CIRCUMFLEX
      #x0175	;LATIN SMALL LETTER W WITH CIRCUMFLEX
      #x0176	;LATIN CAPITAL LETTER Y WITH CIRCUMFLEX
      #x0177	;LATIN SMALL LETTER Y WITH CIRCUMFLEX
      #x0178	;LATIN CAPITAL LETTER Y WITH DIAERESIS
      #x0179	;LATIN CAPITAL LETTER Z WITH ACUTE
      #x017A	;LATIN SMALL LETTER Z WITH ACUTE
      #x017B	;LATIN CAPITAL LETTER Z WITH DOT ABOVE
      #x017C	;LATIN SMALL LETTER Z WITH DOT ABOVE
      #x017D	;LATIN CAPITAL LETTER Z WITH CARON
      #x017E	;LATIN SMALL LETTER Z WITH CARON
      #x017F	;LATIN SMALL LETTER LONG S
      #x0180	;LATIN SMALL LETTER B WITH STROKE
      #x0181	;LATIN CAPITAL LETTER B WITH HOOK
      #x0182	;LATIN CAPITAL LETTER B WITH TOPBAR
      #x0183	;LATIN SMALL LETTER B WITH TOPBAR
      #x0184	;LATIN CAPITAL LETTER TONE SIX
      #x0185	;LATIN SMALL LETTER TONE SIX
      #x0186	;LATIN CAPITAL LETTER OPEN O
      #x0187	;LATIN CAPITAL LETTER C WITH HOOK
      #x0188	;LATIN SMALL LETTER C WITH HOOK
      #x0189	;LATIN CAPITAL LETTER AFRICAN D
      #x018A	;LATIN CAPITAL LETTER D WITH HOOK
      #x018B	;LATIN CAPITAL LETTER D WITH TOPBAR
      #x018C	;LATIN SMALL LETTER D WITH TOPBAR
      #x018D	;LATIN SMALL LETTER TURNED DELTA
      #x018E	;LATIN CAPITAL LETTER REVERSED E
      #x018F	;LATIN CAPITAL LETTER SCHWA
      #x0190	;LATIN CAPITAL LETTER OPEN E
      #x0191	;LATIN CAPITAL LETTER F WITH HOOK
      #x0192	;LATIN SMALL LETTER F WITH HOOK
      #x0193	;LATIN CAPITAL LETTER G WITH HOOK
      #x0194	;LATIN CAPITAL LETTER GAMMA
      #x0195	;LATIN SMALL LETTER HV
      #x0196	;LATIN CAPITAL LETTER IOTA
      #x0197	;LATIN CAPITAL LETTER I WITH STROKE
      #x0198	;LATIN CAPITAL LETTER K WITH HOOK
      #x0199	;LATIN SMALL LETTER K WITH HOOK
      #x019A	;LATIN SMALL LETTER L WITH BAR
      #x019B	;LATIN SMALL LETTER LAMBDA WITH STROKE
      #x019C	;LATIN CAPITAL LETTER TURNED M
      #x019D	;LATIN CAPITAL LETTER N WITH LEFT HOOK
      #x019E	;LATIN SMALL LETTER N WITH LONG RIGHT LEG
      #x019F	;LATIN CAPITAL LETTER O WITH MIDDLE TILDE
      #x01A0	;LATIN CAPITAL LETTER O WITH HORN
      #x01A1	;LATIN SMALL LETTER O WITH HORN
      #x01A2	;LATIN CAPITAL LETTER OI
      #x01A3	;LATIN SMALL LETTER OI
      #x01A4	;LATIN CAPITAL LETTER P WITH HOOK
      #x01A5	;LATIN SMALL LETTER P WITH HOOK
      #x01A6	;LATIN LETTER YR
      #x01A7	;LATIN CAPITAL LETTER TONE TWO
      #x01A8	;LATIN SMALL LETTER TONE TWO
      #x01A9	;LATIN CAPITAL LETTER ESH
      #x01AA	;LATIN LETTER REVERSED ESH LOOP
      #x01AB	;LATIN SMALL LETTER T WITH PALATAL HOOK
      #x01AC	;LATIN CAPITAL LETTER T WITH HOOK
      #x01AD	;LATIN SMALL LETTER T WITH HOOK
      #x01AE	;LATIN CAPITAL LETTER T WITH RETROFLEX HOOK
      #x01AF	;LATIN CAPITAL LETTER U WITH HORN
      #x01B0	;LATIN SMALL LETTER U WITH HORN
      #x01B1	;LATIN CAPITAL LETTER UPSILON
      #x01B2	;LATIN CAPITAL LETTER V WITH HOOK
      #x01B3	;LATIN CAPITAL LETTER Y WITH HOOK
      #x01B4	;LATIN SMALL LETTER Y WITH HOOK
      #x01B5	;LATIN CAPITAL LETTER Z WITH STROKE
      #x01B6	;LATIN SMALL LETTER Z WITH STROKE
      #x01B7	;LATIN CAPITAL LETTER EZH
      #x01B8	;LATIN CAPITAL LETTER EZH REVERSED
      #x01B9	;LATIN SMALL LETTER EZH REVERSED
      #x01BA	;LATIN SMALL LETTER EZH WITH TAIL
      #x01BB	;LATIN LETTER TWO WITH STROKE
      #x01BC	;LATIN CAPITAL LETTER TONE FIVE
      #x01BD	;LATIN SMALL LETTER TONE FIVE
      #x01BE	;LATIN LETTER INVERTED GLOTTAL STOP WITH STROKE
      #x01BF	;LATIN LETTER WYNN
      #x01C0	;LATIN LETTER DENTAL CLICK
      #x01C1	;LATIN LETTER LATERAL CLICK
      #x01C2	;LATIN LETTER ALVEOLAR CLICK
      #x01C3	;LATIN LETTER RETROFLEX CLICK
      #x01C4	;LATIN CAPITAL LETTER DZ WITH CARON
      #x01C5	;LATIN CAPITAL LETTER D WITH SMALL LETTER Z WITH CARON
      #x01C6	;LATIN SMALL LETTER DZ WITH CARON
      #x01C7	;LATIN CAPITAL LETTER LJ
      #x01C8	;LATIN CAPITAL LETTER L WITH SMALL LETTER J
      #x01C9	;LATIN SMALL LETTER LJ
      #x01CA	;LATIN CAPITAL LETTER NJ
      #x01CB	;LATIN CAPITAL LETTER N WITH SMALL LETTER J
      #x01CC	;LATIN SMALL LETTER NJ
      #x01CD	;LATIN CAPITAL LETTER A WITH CARON
      #x01CE	;LATIN SMALL LETTER A WITH CARON
      #x01CF	;LATIN CAPITAL LETTER I WITH CARON
      #x01D0	;LATIN SMALL LETTER I WITH CARON
      #x01D1	;LATIN CAPITAL LETTER O WITH CARON
      #x01D2	;LATIN SMALL LETTER O WITH CARON
      #x01D3	;LATIN CAPITAL LETTER U WITH CARON
      #x01D4	;LATIN SMALL LETTER U WITH CARON
      #x01D5	;LATIN CAPITAL LETTER U WITH DIAERESIS AND MACRON
      #x01D6	;LATIN SMALL LETTER U WITH DIAERESIS AND MACRON
      #x01D7	;LATIN CAPITAL LETTER U WITH DIAERESIS AND ACUTE
      #x01D8	;LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE
      #x01D9	;LATIN CAPITAL LETTER U WITH DIAERESIS AND CARON
      #x01DA	;LATIN SMALL LETTER U WITH DIAERESIS AND CARON
      #x01DB	;LATIN CAPITAL LETTER U WITH DIAERESIS AND GRAVE
      #x01DC	;LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE
      #x01DD	;LATIN SMALL LETTER TURNED E
      #x01DE	;LATIN CAPITAL LETTER A WITH DIAERESIS AND MACRON
      #x01DF	;LATIN SMALL LETTER A WITH DIAERESIS AND MACRON
      #x01E0	;LATIN CAPITAL LETTER A WITH DOT ABOVE AND MACRON
      #x01E1	;LATIN SMALL LETTER A WITH DOT ABOVE AND MACRON
      #x01E2	;LATIN CAPITAL LETTER AE WITH MACRON
      #x01E3	;LATIN SMALL LETTER AE WITH MACRON
      #x01E4	;LATIN CAPITAL LETTER G WITH STROKE
      #x01E5	;LATIN SMALL LETTER G WITH STROKE
      #x01E6	;LATIN CAPITAL LETTER G WITH CARON
      #x01E7	;LATIN SMALL LETTER G WITH CARON
      #x01E8	;LATIN CAPITAL LETTER K WITH CARON
      #x01E9	;LATIN SMALL LETTER K WITH CARON
      #x01EA	;LATIN CAPITAL LETTER O WITH OGONEK
      #x01EB	;LATIN SMALL LETTER O WITH OGONEK
      #x01EC	;LATIN CAPITAL LETTER O WITH OGONEK AND MACRON
      #x01ED	;LATIN SMALL LETTER O WITH OGONEK AND MACRON
      #x01EE	;LATIN CAPITAL LETTER EZH WITH CARON
      #x01EF	;LATIN SMALL LETTER EZH WITH CARON
      #x01F0	;LATIN SMALL LETTER J WITH CARON
      #x01F1	;LATIN CAPITAL LETTER DZ
      #x01F2	;LATIN CAPITAL LETTER D WITH SMALL LETTER Z
      #x01F3	;LATIN SMALL LETTER DZ
      #x01F4	;LATIN CAPITAL LETTER G WITH ACUTE
      #x01F5	;LATIN SMALL LETTER G WITH ACUTE
      #x01F6	;LATIN CAPITAL LETTER HWAIR
      #x01F7	;LATIN CAPITAL LETTER WYNN
      #x01F8	;LATIN CAPITAL LETTER N WITH GRAVE
      #x01F9	;LATIN SMALL LETTER N WITH GRAVE
      #x01FA	;LATIN CAPITAL LETTER A WITH RING ABOVE AND ACUTE
      #x01FB	;LATIN SMALL LETTER A WITH RING ABOVE AND ACUTE
      #x01FC	;LATIN CAPITAL LETTER AE WITH ACUTE
      #x01FD	;LATIN SMALL LETTER AE WITH ACUTE
      #x01FE	;LATIN CAPITAL LETTER O WITH STROKE AND ACUTE
      #x01FF	;LATIN SMALL LETTER O WITH STROKE AND ACUTE
      #x0200	;LATIN CAPITAL LETTER A WITH DOUBLE GRAVE
      #x0201	;LATIN SMALL LETTER A WITH DOUBLE GRAVE
      #x0202	;LATIN CAPITAL LETTER A WITH INVERTED BREVE
      #x0203	;LATIN SMALL LETTER A WITH INVERTED BREVE
      #x0204	;LATIN CAPITAL LETTER E WITH DOUBLE GRAVE
      #x0205	;LATIN SMALL LETTER E WITH DOUBLE GRAVE
      #x0206	;LATIN CAPITAL LETTER E WITH INVERTED BREVE
      #x0207	;LATIN SMALL LETTER E WITH INVERTED BREVE
      #x0208	;LATIN CAPITAL LETTER I WITH DOUBLE GRAVE
      #x0209	;LATIN SMALL LETTER I WITH DOUBLE GRAVE
      #x020A	;LATIN CAPITAL LETTER I WITH INVERTED BREVE
      #x020B	;LATIN SMALL LETTER I WITH INVERTED BREVE
      #x020C	;LATIN CAPITAL LETTER O WITH DOUBLE GRAVE
      #x020D	;LATIN SMALL LETTER O WITH DOUBLE GRAVE
      #x020E	;LATIN CAPITAL LETTER O WITH INVERTED BREVE
      #x020F	;LATIN SMALL LETTER O WITH INVERTED BREVE
      #x0210	;LATIN CAPITAL LETTER R WITH DOUBLE GRAVE
      #x0211	;LATIN SMALL LETTER R WITH DOUBLE GRAVE
      #x0212	;LATIN CAPITAL LETTER R WITH INVERTED BREVE
      #x0213	;LATIN SMALL LETTER R WITH INVERTED BREVE
      #x0214	;LATIN CAPITAL LETTER U WITH DOUBLE GRAVE
      #x0215	;LATIN SMALL LETTER U WITH DOUBLE GRAVE
      #x0216	;LATIN CAPITAL LETTER U WITH INVERTED BREVE
      #x0217	;LATIN SMALL LETTER U WITH INVERTED BREVE
      #x0218	;LATIN CAPITAL LETTER S WITH COMMA BELOW
      #x0219	;LATIN SMALL LETTER S WITH COMMA BELOW
      #x021A	;LATIN CAPITAL LETTER T WITH COMMA BELOW
      #x021B	;LATIN SMALL LETTER T WITH COMMA BELOW
      #x021C	;LATIN CAPITAL LETTER YOGH
      #x021D	;LATIN SMALL LETTER YOGH
      #x021E	;LATIN CAPITAL LETTER H WITH CARON
      #x021F	;LATIN SMALL LETTER H WITH CARON
      #x0220	;LATIN CAPITAL LETTER N WITH LONG RIGHT LEG
      #x0221	;LATIN SMALL LETTER D WITH CURL
      #x0222	;LATIN CAPITAL LETTER OU
      #x0223	;LATIN SMALL LETTER OU
      #x0224	;LATIN CAPITAL LETTER Z WITH HOOK
      #x0225	;LATIN SMALL LETTER Z WITH HOOK
      #x0226	;LATIN CAPITAL LETTER A WITH DOT ABOVE
      #x0227	;LATIN SMALL LETTER A WITH DOT ABOVE
      #x0228	;LATIN CAPITAL LETTER E WITH CEDILLA
      #x0229	;LATIN SMALL LETTER E WITH CEDILLA
      #x022A	;LATIN CAPITAL LETTER O WITH DIAERESIS AND MACRON
      #x022B	;LATIN SMALL LETTER O WITH DIAERESIS AND MACRON
      #x022C	;LATIN CAPITAL LETTER O WITH TILDE AND MACRON
      #x022D	;LATIN SMALL LETTER O WITH TILDE AND MACRON
      #x022E	;LATIN CAPITAL LETTER O WITH DOT ABOVE
      #x022F	;LATIN SMALL LETTER O WITH DOT ABOVE
      #x0230	;LATIN CAPITAL LETTER O WITH DOT ABOVE AND MACRON
      #x0231	;LATIN SMALL LETTER O WITH DOT ABOVE AND MACRON
      #x0232	;LATIN CAPITAL LETTER Y WITH MACRON
      #x0233	;LATIN SMALL LETTER Y WITH MACRON
      #x0234	;LATIN SMALL LETTER L WITH CURL
      #x0235	;LATIN SMALL LETTER N WITH CURL
      #x0236	;LATIN SMALL LETTER T WITH CURL
      #x0250	;LATIN SMALL LETTER TURNED A
      #x0251	;LATIN SMALL LETTER ALPHA
      #x0252	;LATIN SMALL LETTER TURNED ALPHA
      #x0253	;LATIN SMALL LETTER B WITH HOOK
      #x0254	;LATIN SMALL LETTER OPEN O
      #x0255	;LATIN SMALL LETTER C WITH CURL
      #x0256	;LATIN SMALL LETTER D WITH TAIL
      #x0257	;LATIN SMALL LETTER D WITH HOOK
      #x0258	;LATIN SMALL LETTER REVERSED E
      #x0259	;LATIN SMALL LETTER SCHWA
      #x025A	;LATIN SMALL LETTER SCHWA WITH HOOK
      #x025B	;LATIN SMALL LETTER OPEN E
      #x025C	;LATIN SMALL LETTER REVERSED OPEN E
      #x025D	;LATIN SMALL LETTER REVERSED OPEN E WITH HOOK
      #x025E	;LATIN SMALL LETTER CLOSED REVERSED OPEN E
      #x025F	;LATIN SMALL LETTER DOTLESS J WITH STROKE
      #x0260	;LATIN SMALL LETTER G WITH HOOK
      #x0261	;LATIN SMALL LETTER SCRIPT G
      #x0262	;LATIN LETTER SMALL CAPITAL G
      #x0263	;LATIN SMALL LETTER GAMMA
      #x0264	;LATIN SMALL LETTER RAMS HORN
      #x0265	;LATIN SMALL LETTER TURNED H
      #x0266	;LATIN SMALL LETTER H WITH HOOK
      #x0267	;LATIN SMALL LETTER HENG WITH HOOK
      #x0268	;LATIN SMALL LETTER I WITH STROKE
      #x0269	;LATIN SMALL LETTER IOTA
      #x026A	;LATIN LETTER SMALL CAPITAL I
      #x026B	;LATIN SMALL LETTER L WITH MIDDLE TILDE
      #x026C	;LATIN SMALL LETTER L WITH BELT
      #x026D	;LATIN SMALL LETTER L WITH RETROFLEX HOOK
      #x026E	;LATIN SMALL LETTER LEZH
      #x026F	;LATIN SMALL LETTER TURNED M
      #x0270	;LATIN SMALL LETTER TURNED M WITH LONG LEG
      #x0271	;LATIN SMALL LETTER M WITH HOOK
      #x0272	;LATIN SMALL LETTER N WITH LEFT HOOK
      #x0273	;LATIN SMALL LETTER N WITH RETROFLEX HOOK
      #x0274	;LATIN LETTER SMALL CAPITAL N
      #x0275	;LATIN SMALL LETTER BARRED O
      #x0276	;LATIN LETTER SMALL CAPITAL OE
      #x0277	;LATIN SMALL LETTER CLOSED OMEGA
      #x0278	;LATIN SMALL LETTER PHI
      #x0279	;LATIN SMALL LETTER TURNED R
      #x027A	;LATIN SMALL LETTER TURNED R WITH LONG LEG
      #x027B	;LATIN SMALL LETTER TURNED R WITH HOOK
      #x027C	;LATIN SMALL LETTER R WITH LONG LEG
      #x027D	;LATIN SMALL LETTER R WITH TAIL
      #x027E	;LATIN SMALL LETTER R WITH FISHHOOK
      #x027F	;LATIN SMALL LETTER REVERSED R WITH FISHHOOK
      #x0280	;LATIN LETTER SMALL CAPITAL R
      #x0281	;LATIN LETTER SMALL CAPITAL INVERTED R
      #x0282	;LATIN SMALL LETTER S WITH HOOK
      #x0283	;LATIN SMALL LETTER ESH
      #x0284	;LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK
      #x0285	;LATIN SMALL LETTER SQUAT REVERSED ESH
      #x0286	;LATIN SMALL LETTER ESH WITH CURL
      #x0287	;LATIN SMALL LETTER TURNED T
      #x0288	;LATIN SMALL LETTER T WITH RETROFLEX HOOK
      #x0289	;LATIN SMALL LETTER U BAR
      #x028A	;LATIN SMALL LETTER UPSILON
      #x028B	;LATIN SMALL LETTER V WITH HOOK
      #x028C	;LATIN SMALL LETTER TURNED V
      #x028D	;LATIN SMALL LETTER TURNED W
      #x028E	;LATIN SMALL LETTER TURNED Y
      #x028F	;LATIN LETTER SMALL CAPITAL Y
      #x0290	;LATIN SMALL LETTER Z WITH RETROFLEX HOOK
      #x0291	;LATIN SMALL LETTER Z WITH CURL
      #x0292	;LATIN SMALL LETTER EZH
      #x0293	;LATIN SMALL LETTER EZH WITH CURL
      #x0294	;LATIN LETTER GLOTTAL STOP
      #x0295	;LATIN LETTER PHARYNGEAL VOICED FRICATIVE
      #x0296	;LATIN LETTER INVERTED GLOTTAL STOP
      #x0297	;LATIN LETTER STRETCHED C
      #x0298	;LATIN LETTER BILABIAL CLICK
      #x0299	;LATIN LETTER SMALL CAPITAL B
      #x029A	;LATIN SMALL LETTER CLOSED OPEN E
      #x029B	;LATIN LETTER SMALL CAPITAL G WITH HOOK
      #x029C	;LATIN LETTER SMALL CAPITAL H
      #x029D	;LATIN SMALL LETTER J WITH CROSSED-TAIL
      #x029E	;LATIN SMALL LETTER TURNED K
      #x029F	;LATIN LETTER SMALL CAPITAL L
      #x02A0	;LATIN SMALL LETTER Q WITH HOOK
      #x02A1	;LATIN LETTER GLOTTAL STOP WITH STROKE
      #x02A2	;LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE
      #x02A3	;LATIN SMALL LETTER DZ DIGRAPH
      #x02A4	;LATIN SMALL LETTER DEZH DIGRAPH
      #x02A5	;LATIN SMALL LETTER DZ DIGRAPH WITH CURL
      #x02A6	;LATIN SMALL LETTER TS DIGRAPH
      #x02A7	;LATIN SMALL LETTER TESH DIGRAPH
      #x02A8	;LATIN SMALL LETTER TC DIGRAPH WITH CURL
      #x02A9	;LATIN SMALL LETTER FENG DIGRAPH
      #x02AA	;LATIN SMALL LETTER LS DIGRAPH
      #x02AB	;LATIN SMALL LETTER LZ DIGRAPH
      #x02AC	;LATIN LETTER BILABIAL PERCUSSIVE
      #x02AD	;LATIN LETTER BIDENTAL PERCUSSIVE
      #x02AE	;LATIN SMALL LETTER TURNED H WITH FISHHOOK
      #x02AF	;LATIN SMALL LETTER TURNED H WITH FISHHOOK AND TAIL
      #x02B0	;MODIFIER LETTER SMALL H
      #x02B1	;MODIFIER LETTER SMALL H WITH HOOK
      #x02B2	;MODIFIER LETTER SMALL J
      #x02B3	;MODIFIER LETTER SMALL R
      #x02B4	;MODIFIER LETTER SMALL TURNED R
      #x02B5	;MODIFIER LETTER SMALL TURNED R WITH HOOK
      #x02B6	;MODIFIER LETTER SMALL CAPITAL INVERTED R
      #x02B7	;MODIFIER LETTER SMALL W
      #x02B8	;MODIFIER LETTER SMALL Y
      #x02B9	;MODIFIER LETTER PRIME
      #x02BA	;MODIFIER LETTER DOUBLE PRIME
      #x02BB	;MODIFIER LETTER TURNED COMMA
      #x02BC	;MODIFIER LETTER APOSTROPHE
      #x02BD	;MODIFIER LETTER REVERSED COMMA
      #x02BE	;MODIFIER LETTER RIGHT HALF RING
      #x02BF	;MODIFIER LETTER LEFT HALF RING
      #x02C0	;MODIFIER LETTER GLOTTAL STOP
      #x02C1	;MODIFIER LETTER REVERSED GLOTTAL STOP
      #x02C2	;MODIFIER LETTER LEFT ARROWHEAD
      #x02C3	;MODIFIER LETTER RIGHT ARROWHEAD
      #x02C4	;MODIFIER LETTER UP ARROWHEAD
      #x02C5	;MODIFIER LETTER DOWN ARROWHEAD
      #x02C6	;MODIFIER LETTER CIRCUMFLEX ACCENT
      #x02C7	;CARON
      #x02C8	;MODIFIER LETTER VERTICAL LINE
      #x02C9	;MODIFIER LETTER MACRON
      #x02CA	;MODIFIER LETTER ACUTE ACCENT
      #x02CB	;MODIFIER LETTER GRAVE ACCENT
      #x02CC	;MODIFIER LETTER LOW VERTICAL LINE
      #x02CD	;MODIFIER LETTER LOW MACRON
      #x02CE	;MODIFIER LETTER LOW GRAVE ACCENT
      #x02CF	;MODIFIER LETTER LOW ACUTE ACCENT
      #x02D0	;MODIFIER LETTER TRIANGULAR COLON
      #x02D1	;MODIFIER LETTER HALF TRIANGULAR COLON
      #x02D2	;MODIFIER LETTER CENTRED RIGHT HALF RING
      #x02D3	;MODIFIER LETTER CENTRED LEFT HALF RING
      #x02D4	;MODIFIER LETTER UP TACK
      #x02D5	;MODIFIER LETTER DOWN TACK
      #x02D6	;MODIFIER LETTER PLUS SIGN
      #x02D7	;MODIFIER LETTER MINUS SIGN
      #x02D8	;BREVE
      #x02D9	;DOT ABOVE
      #x02DA	;RING ABOVE
      #x02DB	;OGONEK
      #x02DC	;SMALL TILDE
      #x02DD	;DOUBLE ACUTE ACCENT
      #x02DE	;MODIFIER LETTER RHOTIC HOOK
      #x02DF	;MODIFIER LETTER CROSS ACCENT
      #x02E0	;MODIFIER LETTER SMALL GAMMA
      #x02E1	;MODIFIER LETTER SMALL L
      #x02E2	;MODIFIER LETTER SMALL S
      #x02E3	;MODIFIER LETTER SMALL X
      #x02E4	;MODIFIER LETTER SMALL REVERSED GLOTTAL STOP
      #x02E5	;MODIFIER LETTER EXTRA-HIGH TONE BAR
      #x02E6	;MODIFIER LETTER HIGH TONE BAR
      #x02E7	;MODIFIER LETTER MID TONE BAR
      #x02E8	;MODIFIER LETTER LOW TONE BAR
      #x02E9	;MODIFIER LETTER EXTRA-LOW TONE BAR
      #x02EA	;MODIFIER LETTER YIN DEPARTING TONE MARK
      #x02EB	;MODIFIER LETTER YANG DEPARTING TONE MARK
      #x02EC	;MODIFIER LETTER VOICING
      #x02ED	;MODIFIER LETTER UNASPIRATED
      #x02EE	;MODIFIER LETTER DOUBLE APOSTROPHE
      #x02EF	;MODIFIER LETTER LOW DOWN ARROWHEAD
      #x02F0	;MODIFIER LETTER LOW UP ARROWHEAD
      #x02F1	;MODIFIER LETTER LOW LEFT ARROWHEAD
      #x02F2	;MODIFIER LETTER LOW RIGHT ARROWHEAD
      #x02F3	;MODIFIER LETTER LOW RING
      #x02F4	;MODIFIER LETTER MIDDLE GRAVE ACCENT
      #x02F5	;MODIFIER LETTER MIDDLE DOUBLE GRAVE ACCENT
      #x02F6	;MODIFIER LETTER MIDDLE DOUBLE ACUTE ACCENT
      #x02F7	;MODIFIER LETTER LOW TILDE
      #x02F8	;MODIFIER LETTER RAISED COLON
      #x02F9	;MODIFIER LETTER BEGIN HIGH TONE
      #x02FA	;MODIFIER LETTER END HIGH TONE
      #x02FB	;MODIFIER LETTER BEGIN LOW TONE
      #x02FC	;MODIFIER LETTER END LOW TONE
      #x02FD	;MODIFIER LETTER SHELF
      #x02FE	;MODIFIER LETTER OPEN SHELF
      #x02FF	;MODIFIER LETTER LOW LEFT ARROW
      #x0300	;COMBINING GRAVE ACCENT
      #x0301	;COMBINING ACUTE ACCENT
      #x0302	;COMBINING CIRCUMFLEX ACCENT
      #x0303	;COMBINING TILDE
      #x0304	;COMBINING MACRON
      #x0305	;COMBINING OVERLINE
      #x0306	;COMBINING BREVE
      #x0307	;COMBINING DOT ABOVE
      #x0308	;COMBINING DIAERESIS
      #x0309	;COMBINING HOOK ABOVE
      #x030A	;COMBINING RING ABOVE
      #x030B	;COMBINING DOUBLE ACUTE ACCENT
      #x030C	;COMBINING CARON
      #x030D	;COMBINING VERTICAL LINE ABOVE
      #x030E	;COMBINING DOUBLE VERTICAL LINE ABOVE
      #x030F	;COMBINING DOUBLE GRAVE ACCENT
      #x0310	;COMBINING CANDRABINDU
      #x0311	;COMBINING INVERTED BREVE
      #x0312	;COMBINING TURNED COMMA ABOVE
      #x0313	;COMBINING COMMA ABOVE
      #x0314	;COMBINING REVERSED COMMA ABOVE
      #x0315	;COMBINING COMMA ABOVE RIGHT
      #x0316	;COMBINING GRAVE ACCENT BELOW
      #x0317	;COMBINING ACUTE ACCENT BELOW
      #x0318	;COMBINING LEFT TACK BELOW
      #x0319	;COMBINING RIGHT TACK BELOW
      #x031A	;COMBINING LEFT ANGLE ABOVE
      #x031B	;COMBINING HORN
      #x031C	;COMBINING LEFT HALF RING BELOW
      #x031D	;COMBINING UP TACK BELOW
      #x031E	;COMBINING DOWN TACK BELOW
      #x031F	;COMBINING PLUS SIGN BELOW
      #x0320	;COMBINING MINUS SIGN BELOW
      #x0321	;COMBINING PALATALIZED HOOK BELOW
      #x0322	;COMBINING RETROFLEX HOOK BELOW
      #x0323	;COMBINING DOT BELOW
      #x0324	;COMBINING DIAERESIS BELOW
      #x0325	;COMBINING RING BELOW
      #x0326	;COMBINING COMMA BELOW
      #x0327	;COMBINING CEDILLA
      #x0328	;COMBINING OGONEK
      #x0329	;COMBINING VERTICAL LINE BELOW
      #x032A	;COMBINING BRIDGE BELOW
      #x032B	;COMBINING INVERTED DOUBLE ARCH BELOW
      #x032C	;COMBINING CARON BELOW
      #x032D	;COMBINING CIRCUMFLEX ACCENT BELOW
      #x032E	;COMBINING BREVE BELOW
      #x032F	;COMBINING INVERTED BREVE BELOW
      #x0330	;COMBINING TILDE BELOW
      #x0331	;COMBINING MACRON BELOW
      #x0332	;COMBINING LOW LINE
      #x0333	;COMBINING DOUBLE LOW LINE
      #x0334	;COMBINING TILDE OVERLAY
      #x0335	;COMBINING SHORT STROKE OVERLAY
      #x0336	;COMBINING LONG STROKE OVERLAY
      #x0337	;COMBINING SHORT SOLIDUS OVERLAY
      #x0338	;COMBINING LONG SOLIDUS OVERLAY
      #x0339	;COMBINING RIGHT HALF RING BELOW
      #x033A	;COMBINING INVERTED BRIDGE BELOW
      #x033B	;COMBINING SQUARE BELOW
      #x033C	;COMBINING SEAGULL BELOW
      #x033D	;COMBINING X ABOVE
      #x033E	;COMBINING VERTICAL TILDE
      #x033F	;COMBINING DOUBLE OVERLINE
      #x0340	;COMBINING GRAVE TONE MARK
      #x0341	;COMBINING ACUTE TONE MARK
      #x0342	;COMBINING GREEK PERISPOMENI
      #x0343	;COMBINING GREEK KORONIS
      #x0344	;COMBINING GREEK DIALYTIKA TONOS
      #x0345	;COMBINING GREEK YPOGEGRAMMENI
      #x0346	;COMBINING BRIDGE ABOVE
      #x0347	;COMBINING EQUALS SIGN BELOW
      #x0348	;COMBINING DOUBLE VERTICAL LINE BELOW
      #x0349	;COMBINING LEFT ANGLE BELOW
      #x034A	;COMBINING NOT TILDE ABOVE
      #x034B	;COMBINING HOMOTHETIC ABOVE
      #x034C	;COMBINING ALMOST EQUAL TO ABOVE
      #x034D	;COMBINING LEFT RIGHT ARROW BELOW
      #x034E	;COMBINING UPWARDS ARROW BELOW
      #x034F	;COMBINING GRAPHEME JOINER
      #x0350	;COMBINING RIGHT ARROWHEAD ABOVE
      #x0351	;COMBINING LEFT HALF RING ABOVE
      #x0352	;COMBINING FERMATA
      #x0353	;COMBINING X BELOW
      #x0354	;COMBINING LEFT ARROWHEAD BELOW
      #x0355	;COMBINING RIGHT ARROWHEAD BELOW
      #x0356	;COMBINING RIGHT ARROWHEAD AND UP ARROWHEAD BELOW
      #x0357	;COMBINING RIGHT HALF RING ABOVE
      #x035D	;COMBINING DOUBLE BREVE
      #x035E	;COMBINING DOUBLE MACRON
      #x035F	;COMBINING DOUBLE MACRON BELOW
      #x0360	;COMBINING DOUBLE TILDE
      #x0361	;COMBINING DOUBLE INVERTED BREVE
      #x0362	;COMBINING DOUBLE RIGHTWARDS ARROW BELOW
      #x0363	;COMBINING LATIN SMALL LETTER A
      #x0364	;COMBINING LATIN SMALL LETTER E
      #x0365	;COMBINING LATIN SMALL LETTER I
      #x0366	;COMBINING LATIN SMALL LETTER O
      #x0367	;COMBINING LATIN SMALL LETTER U
      #x0368	;COMBINING LATIN SMALL LETTER C
      #x0369	;COMBINING LATIN SMALL LETTER D
      #x036A	;COMBINING LATIN SMALL LETTER H
      #x036B	;COMBINING LATIN SMALL LETTER M
      #x036C	;COMBINING LATIN SMALL LETTER R
      #x036D	;COMBINING LATIN SMALL LETTER T
      #x036E	;COMBINING LATIN SMALL LETTER V
      #x036F	;COMBINING LATIN SMALL LETTER X
      #x0374	;GREEK NUMERAL SIGN
      #x0375	;GREEK LOWER NUMERAL SIGN
      #x037A	;GREEK YPOGEGRAMMENI
      #x037E	;GREEK QUESTION MARK
      #x0384	;GREEK TONOS
      #x0385	;GREEK DIALYTIKA TONOS
      #x0386	;GREEK CAPITAL LETTER ALPHA WITH TONOS
      #x0387	;GREEK ANO TELEIA
      #x0388	;GREEK CAPITAL LETTER EPSILON WITH TONOS
      #x0389	;GREEK CAPITAL LETTER ETA WITH TONOS
      #x038A	;GREEK CAPITAL LETTER IOTA WITH TONOS
      #x038C	;GREEK CAPITAL LETTER OMICRON WITH TONOS
      #x038E	;GREEK CAPITAL LETTER UPSILON WITH TONOS
      #x038F	;GREEK CAPITAL LETTER OMEGA WITH TONOS
      #x0390	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND TONOS
      #x0391	;GREEK CAPITAL LETTER ALPHA
      #x0392	;GREEK CAPITAL LETTER BETA
      #x0393	;GREEK CAPITAL LETTER GAMMA
      #x0394	;GREEK CAPITAL LETTER DELTA
      #x0395	;GREEK CAPITAL LETTER EPSILON
      #x0396	;GREEK CAPITAL LETTER ZETA
      #x0397	;GREEK CAPITAL LETTER ETA
      #x0398	;GREEK CAPITAL LETTER THETA
      #x0399	;GREEK CAPITAL LETTER IOTA
      #x039A	;GREEK CAPITAL LETTER KAPPA
      #x039B	;GREEK CAPITAL LETTER LAMDA
      #x039C	;GREEK CAPITAL LETTER MU
      #x039D	;GREEK CAPITAL LETTER NU
      #x039E	;GREEK CAPITAL LETTER XI
      #x039F	;GREEK CAPITAL LETTER OMICRON
      #x03A0	;GREEK CAPITAL LETTER PI
      #x03A1	;GREEK CAPITAL LETTER RHO
      #x03A3	;GREEK CAPITAL LETTER SIGMA
      #x03A4	;GREEK CAPITAL LETTER TAU
      #x03A5	;GREEK CAPITAL LETTER UPSILON
      #x03A6	;GREEK CAPITAL LETTER PHI
      #x03A7	;GREEK CAPITAL LETTER CHI
      #x03A8	;GREEK CAPITAL LETTER PSI
      #x03A9	;GREEK CAPITAL LETTER OMEGA
      #x03AA	;GREEK CAPITAL LETTER IOTA WITH DIALYTIKA
      #x03AB	;GREEK CAPITAL LETTER UPSILON WITH DIALYTIKA
      #x03AC	;GREEK SMALL LETTER ALPHA WITH TONOS
      #x03AD	;GREEK SMALL LETTER EPSILON WITH TONOS
      #x03AE	;GREEK SMALL LETTER ETA WITH TONOS
      #x03AF	;GREEK SMALL LETTER IOTA WITH TONOS
      #x03B0	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND TONOS
      #x03B1	;GREEK SMALL LETTER ALPHA
      #x03B2	;GREEK SMALL LETTER BETA
      #x03B3	;GREEK SMALL LETTER GAMMA
      #x03B4	;GREEK SMALL LETTER DELTA
      #x03B5	;GREEK SMALL LETTER EPSILON
      #x03B6	;GREEK SMALL LETTER ZETA
      #x03B7	;GREEK SMALL LETTER ETA
      #x03B8	;GREEK SMALL LETTER THETA
      #x03B9	;GREEK SMALL LETTER IOTA
      #x03BA	;GREEK SMALL LETTER KAPPA
      #x03BB	;GREEK SMALL LETTER LAMDA
      #x03BC	;GREEK SMALL LETTER MU
      #x03BD	;GREEK SMALL LETTER NU
      #x03BE	;GREEK SMALL LETTER XI
      #x03BF	;GREEK SMALL LETTER OMICRON
      #x03C0	;GREEK SMALL LETTER PI
      #x03C1	;GREEK SMALL LETTER RHO
      #x03C2	;GREEK SMALL LETTER FINAL SIGMA
      #x03C3	;GREEK SMALL LETTER SIGMA
      #x03C4	;GREEK SMALL LETTER TAU
      #x03C5	;GREEK SMALL LETTER UPSILON
      #x03C6	;GREEK SMALL LETTER PHI
      #x03C7	;GREEK SMALL LETTER CHI
      #x03C8	;GREEK SMALL LETTER PSI
      #x03C9	;GREEK SMALL LETTER OMEGA
      #x03CA	;GREEK SMALL LETTER IOTA WITH DIALYTIKA
      #x03CB	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA
      #x03CC	;GREEK SMALL LETTER OMICRON WITH TONOS
      #x03CD	;GREEK SMALL LETTER UPSILON WITH TONOS
      #x03CE	;GREEK SMALL LETTER OMEGA WITH TONOS
      #x03D0	;GREEK BETA SYMBOL
      #x03D1	;GREEK THETA SYMBOL
      #x03D2	;GREEK UPSILON WITH HOOK SYMBOL
      #x03D3	;GREEK UPSILON WITH ACUTE AND HOOK SYMBOL
      #x03D4	;GREEK UPSILON WITH DIAERESIS AND HOOK SYMBOL
      #x03D5	;GREEK PHI SYMBOL
      #x03D6	;GREEK PI SYMBOL
      #x03D7	;GREEK KAI SYMBOL
      #x03D8	;GREEK LETTER ARCHAIC KOPPA
      #x03D9	;GREEK SMALL LETTER ARCHAIC KOPPA
      #x03DA	;GREEK LETTER STIGMA
      #x03DB	;GREEK SMALL LETTER STIGMA
      #x03DC	;GREEK LETTER DIGAMMA
      #x03DD	;GREEK SMALL LETTER DIGAMMA
      #x03DE	;GREEK LETTER KOPPA
      #x03DF	;GREEK SMALL LETTER KOPPA
      #x03E0	;GREEK LETTER SAMPI
      #x03E1	;GREEK SMALL LETTER SAMPI
      #x03E2	;COPTIC CAPITAL LETTER SHEI
      #x03E3	;COPTIC SMALL LETTER SHEI
      #x03E4	;COPTIC CAPITAL LETTER FEI
      #x03E5	;COPTIC SMALL LETTER FEI
      #x03E6	;COPTIC CAPITAL LETTER KHEI
      #x03E7	;COPTIC SMALL LETTER KHEI
      #x03E8	;COPTIC CAPITAL LETTER HORI
      #x03E9	;COPTIC SMALL LETTER HORI
      #x03EA	;COPTIC CAPITAL LETTER GANGIA
      #x03EB	;COPTIC SMALL LETTER GANGIA
      #x03EC	;COPTIC CAPITAL LETTER SHIMA
      #x03ED	;COPTIC SMALL LETTER SHIMA
      #x03EE	;COPTIC CAPITAL LETTER DEI
      #x03EF	;COPTIC SMALL LETTER DEI
      #x03F0	;GREEK KAPPA SYMBOL
      #x03F1	;GREEK RHO SYMBOL
      #x03F2	;GREEK LUNATE SIGMA SYMBOL
      #x03F3	;GREEK LETTER YOT
      #x03F4	;GREEK CAPITAL THETA SYMBOL
      #x03F5	;GREEK LUNATE EPSILON SYMBOL
      #x03F6	;GREEK REVERSED LUNATE EPSILON SYMBOL
      #x03F7	;GREEK CAPITAL LETTER SHO
      #x03F8	;GREEK SMALL LETTER SHO
      #x03F9	;GREEK CAPITAL LUNATE SIGMA SYMBOL
      #x03FA	;GREEK CAPITAL LETTER SAN
      #x03FB	;GREEK SMALL LETTER SAN
      #x0400	;CYRILLIC CAPITAL LETTER IE WITH GRAVE
      #x0401	;CYRILLIC CAPITAL LETTER IO
      #x0402	;CYRILLIC CAPITAL LETTER DJE
      #x0403	;CYRILLIC CAPITAL LETTER GJE
      #x0404	;CYRILLIC CAPITAL LETTER UKRAINIAN IE
      #x0405	;CYRILLIC CAPITAL LETTER DZE
      #x0406	;CYRILLIC CAPITAL LETTER BYELORUSSIAN-UKRAINIAN I
      #x0407	;CYRILLIC CAPITAL LETTER YI
      #x0408	;CYRILLIC CAPITAL LETTER JE
      #x0409	;CYRILLIC CAPITAL LETTER LJE
      #x040A	;CYRILLIC CAPITAL LETTER NJE
      #x040B	;CYRILLIC CAPITAL LETTER TSHE
      #x040C	;CYRILLIC CAPITAL LETTER KJE
      #x040D	;CYRILLIC CAPITAL LETTER I WITH GRAVE
      #x040E	;CYRILLIC CAPITAL LETTER SHORT U
      #x040F	;CYRILLIC CAPITAL LETTER DZHE
      #x0410	;CYRILLIC CAPITAL LETTER A
      #x0411	;CYRILLIC CAPITAL LETTER BE
      #x0412	;CYRILLIC CAPITAL LETTER VE
      #x0413	;CYRILLIC CAPITAL LETTER GHE
      #x0414	;CYRILLIC CAPITAL LETTER DE
      #x0415	;CYRILLIC CAPITAL LETTER IE
      #x0416	;CYRILLIC CAPITAL LETTER ZHE
      #x0417	;CYRILLIC CAPITAL LETTER ZE
      #x0418	;CYRILLIC CAPITAL LETTER I
      #x0419	;CYRILLIC CAPITAL LETTER SHORT I
      #x041A	;CYRILLIC CAPITAL LETTER KA
      #x041B	;CYRILLIC CAPITAL LETTER EL
      #x041C	;CYRILLIC CAPITAL LETTER EM
      #x041D	;CYRILLIC CAPITAL LETTER EN
      #x041E	;CYRILLIC CAPITAL LETTER O
      #x041F	;CYRILLIC CAPITAL LETTER PE
      #x0420	;CYRILLIC CAPITAL LETTER ER
      #x0421	;CYRILLIC CAPITAL LETTER ES
      #x0422	;CYRILLIC CAPITAL LETTER TE
      #x0423	;CYRILLIC CAPITAL LETTER U
      #x0424	;CYRILLIC CAPITAL LETTER EF
      #x0425	;CYRILLIC CAPITAL LETTER HA
      #x0426	;CYRILLIC CAPITAL LETTER TSE
      #x0427	;CYRILLIC CAPITAL LETTER CHE
      #x0428	;CYRILLIC CAPITAL LETTER SHA
      #x0429	;CYRILLIC CAPITAL LETTER SHCHA
      #x042A	;CYRILLIC CAPITAL LETTER HARD SIGN
      #x042B	;CYRILLIC CAPITAL LETTER YERU
      #x042C	;CYRILLIC CAPITAL LETTER SOFT SIGN
      #x042D	;CYRILLIC CAPITAL LETTER E
      #x042E	;CYRILLIC CAPITAL LETTER YU
      #x042F	;CYRILLIC CAPITAL LETTER YA
      #x0430	;CYRILLIC SMALL LETTER A
      #x0431	;CYRILLIC SMALL LETTER BE
      #x0432	;CYRILLIC SMALL LETTER VE
      #x0433	;CYRILLIC SMALL LETTER GHE
      #x0434	;CYRILLIC SMALL LETTER DE
      #x0435	;CYRILLIC SMALL LETTER IE
      #x0436	;CYRILLIC SMALL LETTER ZHE
      #x0437	;CYRILLIC SMALL LETTER ZE
      #x0438	;CYRILLIC SMALL LETTER I
      #x0439	;CYRILLIC SMALL LETTER SHORT I
      #x043A	;CYRILLIC SMALL LETTER KA
      #x043B	;CYRILLIC SMALL LETTER EL
      #x043C	;CYRILLIC SMALL LETTER EM
      #x043D	;CYRILLIC SMALL LETTER EN
      #x043E	;CYRILLIC SMALL LETTER O
      #x043F	;CYRILLIC SMALL LETTER PE
      #x0440	;CYRILLIC SMALL LETTER ER
      #x0441	;CYRILLIC SMALL LETTER ES
      #x0442	;CYRILLIC SMALL LETTER TE
      #x0443	;CYRILLIC SMALL LETTER U
      #x0444	;CYRILLIC SMALL LETTER EF
      #x0445	;CYRILLIC SMALL LETTER HA
      #x0446	;CYRILLIC SMALL LETTER TSE
      #x0447	;CYRILLIC SMALL LETTER CHE
      #x0448	;CYRILLIC SMALL LETTER SHA
      #x0449	;CYRILLIC SMALL LETTER SHCHA
      #x044A	;CYRILLIC SMALL LETTER HARD SIGN
      #x044B	;CYRILLIC SMALL LETTER YERU
      #x044C	;CYRILLIC SMALL LETTER SOFT SIGN
      #x044D	;CYRILLIC SMALL LETTER E
      #x044E	;CYRILLIC SMALL LETTER YU
      #x044F	;CYRILLIC SMALL LETTER YA
      #x0450	;CYRILLIC SMALL LETTER IE WITH GRAVE
      #x0451	;CYRILLIC SMALL LETTER IO
      #x0452	;CYRILLIC SMALL LETTER DJE
      #x0453	;CYRILLIC SMALL LETTER GJE
      #x0454	;CYRILLIC SMALL LETTER UKRAINIAN IE
      #x0455	;CYRILLIC SMALL LETTER DZE
      #x0456	;CYRILLIC SMALL LETTER BYELORUSSIAN-UKRAINIAN I
      #x0457	;CYRILLIC SMALL LETTER YI
      #x0458	;CYRILLIC SMALL LETTER JE
      #x0459	;CYRILLIC SMALL LETTER LJE
      #x045A	;CYRILLIC SMALL LETTER NJE
      #x045B	;CYRILLIC SMALL LETTER TSHE
      #x045C	;CYRILLIC SMALL LETTER KJE
      #x045D	;CYRILLIC SMALL LETTER I WITH GRAVE
      #x045E	;CYRILLIC SMALL LETTER SHORT U
      #x045F	;CYRILLIC SMALL LETTER DZHE
      #x0460	;CYRILLIC CAPITAL LETTER OMEGA
      #x0461	;CYRILLIC SMALL LETTER OMEGA
      #x0462	;CYRILLIC CAPITAL LETTER YAT
      #x0463	;CYRILLIC SMALL LETTER YAT
      #x0464	;CYRILLIC CAPITAL LETTER IOTIFIED E
      #x0465	;CYRILLIC SMALL LETTER IOTIFIED E
      #x0466	;CYRILLIC CAPITAL LETTER LITTLE YUS
      #x0467	;CYRILLIC SMALL LETTER LITTLE YUS
      #x0468	;CYRILLIC CAPITAL LETTER IOTIFIED LITTLE YUS
      #x0469	;CYRILLIC SMALL LETTER IOTIFIED LITTLE YUS
      #x046A	;CYRILLIC CAPITAL LETTER BIG YUS
      #x046B	;CYRILLIC SMALL LETTER BIG YUS
      #x046C	;CYRILLIC CAPITAL LETTER IOTIFIED BIG YUS
      #x046D	;CYRILLIC SMALL LETTER IOTIFIED BIG YUS
      #x046E	;CYRILLIC CAPITAL LETTER KSI
      #x046F	;CYRILLIC SMALL LETTER KSI
      #x0470	;CYRILLIC CAPITAL LETTER PSI
      #x0471	;CYRILLIC SMALL LETTER PSI
      #x0472	;CYRILLIC CAPITAL LETTER FITA
      #x0473	;CYRILLIC SMALL LETTER FITA
      #x0474	;CYRILLIC CAPITAL LETTER IZHITSA
      #x0475	;CYRILLIC SMALL LETTER IZHITSA
      #x0476	;CYRILLIC CAPITAL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
      #x0477	;CYRILLIC SMALL LETTER IZHITSA WITH DOUBLE GRAVE ACCENT
      #x0478	;CYRILLIC CAPITAL LETTER UK
      #x0479	;CYRILLIC SMALL LETTER UK
      #x047A	;CYRILLIC CAPITAL LETTER ROUND OMEGA
      #x047B	;CYRILLIC SMALL LETTER ROUND OMEGA
      #x047C	;CYRILLIC CAPITAL LETTER OMEGA WITH TITLO
      #x047D	;CYRILLIC SMALL LETTER OMEGA WITH TITLO
      #x047E	;CYRILLIC CAPITAL LETTER OT
      #x047F	;CYRILLIC SMALL LETTER OT
      #x0480	;CYRILLIC CAPITAL LETTER KOPPA
      #x0481	;CYRILLIC SMALL LETTER KOPPA
      #x0482	;CYRILLIC THOUSANDS SIGN
      #x0483	;COMBINING CYRILLIC TITLO
      #x0484	;COMBINING CYRILLIC PALATALIZATION
      #x0485	;COMBINING CYRILLIC DASIA PNEUMATA
      #x0486	;COMBINING CYRILLIC PSILI PNEUMATA
      #x0488	;COMBINING CYRILLIC HUNDRED THOUSANDS SIGN
      #x0489	;COMBINING CYRILLIC MILLIONS SIGN
      #x048A	;CYRILLIC CAPITAL LETTER SHORT I WITH TAIL
      #x048B	;CYRILLIC SMALL LETTER SHORT I WITH TAIL
      #x048C	;CYRILLIC CAPITAL LETTER SEMISOFT SIGN
      #x048D	;CYRILLIC SMALL LETTER SEMISOFT SIGN
      #x048E	;CYRILLIC CAPITAL LETTER ER WITH TICK
      #x048F	;CYRILLIC SMALL LETTER ER WITH TICK
      #x0490	;CYRILLIC CAPITAL LETTER GHE WITH UPTURN
      #x0491	;CYRILLIC SMALL LETTER GHE WITH UPTURN
      #x0492	;CYRILLIC CAPITAL LETTER GHE WITH STROKE
      #x0493	;CYRILLIC SMALL LETTER GHE WITH STROKE
      #x0494	;CYRILLIC CAPITAL LETTER GHE WITH MIDDLE HOOK
      #x0495	;CYRILLIC SMALL LETTER GHE WITH MIDDLE HOOK
      #x0496	;CYRILLIC CAPITAL LETTER ZHE WITH DESCENDER
      #x0497	;CYRILLIC SMALL LETTER ZHE WITH DESCENDER
      #x0498	;CYRILLIC CAPITAL LETTER ZE WITH DESCENDER
      #x0499	;CYRILLIC SMALL LETTER ZE WITH DESCENDER
      #x049A	;CYRILLIC CAPITAL LETTER KA WITH DESCENDER
      #x049B	;CYRILLIC SMALL LETTER KA WITH DESCENDER
      #x049C	;CYRILLIC CAPITAL LETTER KA WITH VERTICAL STROKE
      #x049D	;CYRILLIC SMALL LETTER KA WITH VERTICAL STROKE
      #x049E	;CYRILLIC CAPITAL LETTER KA WITH STROKE
      #x049F	;CYRILLIC SMALL LETTER KA WITH STROKE
      #x04A0	;CYRILLIC CAPITAL LETTER BASHKIR KA
      #x04A1	;CYRILLIC SMALL LETTER BASHKIR KA
      #x04A2	;CYRILLIC CAPITAL LETTER EN WITH DESCENDER
      #x04A3	;CYRILLIC SMALL LETTER EN WITH DESCENDER
      #x04A4	;CYRILLIC CAPITAL LIGATURE EN GHE
      #x04A5	;CYRILLIC SMALL LIGATURE EN GHE
      #x04A6	;CYRILLIC CAPITAL LETTER PE WITH MIDDLE HOOK
      #x04A7	;CYRILLIC SMALL LETTER PE WITH MIDDLE HOOK
      #x04A8	;CYRILLIC CAPITAL LETTER ABKHASIAN HA
      #x04A9	;CYRILLIC SMALL LETTER ABKHASIAN HA
      #x04AA	;CYRILLIC CAPITAL LETTER ES WITH DESCENDER
      #x04AB	;CYRILLIC SMALL LETTER ES WITH DESCENDER
      #x04AC	;CYRILLIC CAPITAL LETTER TE WITH DESCENDER
      #x04AD	;CYRILLIC SMALL LETTER TE WITH DESCENDER
      #x04AE	;CYRILLIC CAPITAL LETTER STRAIGHT U
      #x04AF	;CYRILLIC SMALL LETTER STRAIGHT U
      #x04B0	;CYRILLIC CAPITAL LETTER STRAIGHT U WITH STROKE
      #x04B1	;CYRILLIC SMALL LETTER STRAIGHT U WITH STROKE
      #x04B2	;CYRILLIC CAPITAL LETTER HA WITH DESCENDER
      #x04B3	;CYRILLIC SMALL LETTER HA WITH DESCENDER
      #x04B4	;CYRILLIC CAPITAL LIGATURE TE TSE
      #x04B5	;CYRILLIC SMALL LIGATURE TE TSE
      #x04B6	;CYRILLIC CAPITAL LETTER CHE WITH DESCENDER
      #x04B7	;CYRILLIC SMALL LETTER CHE WITH DESCENDER
      #x04B8	;CYRILLIC CAPITAL LETTER CHE WITH VERTICAL STROKE
      #x04B9	;CYRILLIC SMALL LETTER CHE WITH VERTICAL STROKE
      #x04BA	;CYRILLIC CAPITAL LETTER SHHA
      #x04BB	;CYRILLIC SMALL LETTER SHHA
      #x04BC	;CYRILLIC CAPITAL LETTER ABKHASIAN CHE
      #x04BD	;CYRILLIC SMALL LETTER ABKHASIAN CHE
      #x04BE	;CYRILLIC CAPITAL LETTER ABKHASIAN CHE WITH DESCENDER
      #x04BF	;CYRILLIC SMALL LETTER ABKHASIAN CHE WITH DESCENDER
      #x04C0	;CYRILLIC LETTER PALOCHKA
      #x04C1	;CYRILLIC CAPITAL LETTER ZHE WITH BREVE
      #x04C2	;CYRILLIC SMALL LETTER ZHE WITH BREVE
      #x04C3	;CYRILLIC CAPITAL LETTER KA WITH HOOK
      #x04C4	;CYRILLIC SMALL LETTER KA WITH HOOK
      #x04C5	;CYRILLIC CAPITAL LETTER EL WITH TAIL
      #x04C6	;CYRILLIC SMALL LETTER EL WITH TAIL
      #x04C7	;CYRILLIC CAPITAL LETTER EN WITH HOOK
      #x04C8	;CYRILLIC SMALL LETTER EN WITH HOOK
      #x04C9	;CYRILLIC CAPITAL LETTER EN WITH TAIL
      #x04CA	;CYRILLIC SMALL LETTER EN WITH TAIL
      #x04CB	;CYRILLIC CAPITAL LETTER KHAKASSIAN CHE
      #x04CC	;CYRILLIC SMALL LETTER KHAKASSIAN CHE
      #x04CD	;CYRILLIC CAPITAL LETTER EM WITH TAIL
      #x04CE	;CYRILLIC SMALL LETTER EM WITH TAIL
      #x04D0	;CYRILLIC CAPITAL LETTER A WITH BREVE
      #x04D1	;CYRILLIC SMALL LETTER A WITH BREVE
      #x04D2	;CYRILLIC CAPITAL LETTER A WITH DIAERESIS
      #x04D3	;CYRILLIC SMALL LETTER A WITH DIAERESIS
      #x04D4	;CYRILLIC CAPITAL LIGATURE A IE
      #x04D5	;CYRILLIC SMALL LIGATURE A IE
      #x04D6	;CYRILLIC CAPITAL LETTER IE WITH BREVE
      #x04D7	;CYRILLIC SMALL LETTER IE WITH BREVE
      #x04D8	;CYRILLIC CAPITAL LETTER SCHWA
      #x04D9	;CYRILLIC SMALL LETTER SCHWA
      #x04DA	;CYRILLIC CAPITAL LETTER SCHWA WITH DIAERESIS
      #x04DB	;CYRILLIC SMALL LETTER SCHWA WITH DIAERESIS
      #x04DC	;CYRILLIC CAPITAL LETTER ZHE WITH DIAERESIS
      #x04DD	;CYRILLIC SMALL LETTER ZHE WITH DIAERESIS
      #x04DE	;CYRILLIC CAPITAL LETTER ZE WITH DIAERESIS
      #x04DF	;CYRILLIC SMALL LETTER ZE WITH DIAERESIS
      #x04E0	;CYRILLIC CAPITAL LETTER ABKHASIAN DZE
      #x04E1	;CYRILLIC SMALL LETTER ABKHASIAN DZE
      #x04E2	;CYRILLIC CAPITAL LETTER I WITH MACRON
      #x04E3	;CYRILLIC SMALL LETTER I WITH MACRON
      #x04E4	;CYRILLIC CAPITAL LETTER I WITH DIAERESIS
      #x04E5	;CYRILLIC SMALL LETTER I WITH DIAERESIS
      #x04E6	;CYRILLIC CAPITAL LETTER O WITH DIAERESIS
      #x04E7	;CYRILLIC SMALL LETTER O WITH DIAERESIS
      #x04E8	;CYRILLIC CAPITAL LETTER BARRED O
      #x04E9	;CYRILLIC SMALL LETTER BARRED O
      #x04EA	;CYRILLIC CAPITAL LETTER BARRED O WITH DIAERESIS
      #x04EB	;CYRILLIC SMALL LETTER BARRED O WITH DIAERESIS
      #x04EC	;CYRILLIC CAPITAL LETTER E WITH DIAERESIS
      #x04ED	;CYRILLIC SMALL LETTER E WITH DIAERESIS
      #x04EE	;CYRILLIC CAPITAL LETTER U WITH MACRON
      #x04EF	;CYRILLIC SMALL LETTER U WITH MACRON
      #x04F0	;CYRILLIC CAPITAL LETTER U WITH DIAERESIS
      #x04F1	;CYRILLIC SMALL LETTER U WITH DIAERESIS
      #x04F2	;CYRILLIC CAPITAL LETTER U WITH DOUBLE ACUTE
      #x04F3	;CYRILLIC SMALL LETTER U WITH DOUBLE ACUTE
      #x04F4	;CYRILLIC CAPITAL LETTER CHE WITH DIAERESIS
      #x04F5	;CYRILLIC SMALL LETTER CHE WITH DIAERESIS
      #x04F8	;CYRILLIC CAPITAL LETTER YERU WITH DIAERESIS
      #x04F9	;CYRILLIC SMALL LETTER YERU WITH DIAERESIS
      #x0500	;CYRILLIC CAPITAL LETTER KOMI DE
      #x0501	;CYRILLIC SMALL LETTER KOMI DE
      #x0502	;CYRILLIC CAPITAL LETTER KOMI DJE
      #x0503	;CYRILLIC SMALL LETTER KOMI DJE
      #x0504	;CYRILLIC CAPITAL LETTER KOMI ZJE
      #x0505	;CYRILLIC SMALL LETTER KOMI ZJE
      #x0506	;CYRILLIC CAPITAL LETTER KOMI DZJE
      #x0507	;CYRILLIC SMALL LETTER KOMI DZJE
      #x0508	;CYRILLIC CAPITAL LETTER KOMI LJE
      #x0509	;CYRILLIC SMALL LETTER KOMI LJE
      #x050A	;CYRILLIC CAPITAL LETTER KOMI NJE
      #x050B	;CYRILLIC SMALL LETTER KOMI NJE
      #x050C	;CYRILLIC CAPITAL LETTER KOMI SJE
      #x050D	;CYRILLIC SMALL LETTER KOMI SJE
      #x050E	;CYRILLIC CAPITAL LETTER KOMI TJE
      #x050F	;CYRILLIC SMALL LETTER KOMI TJE
      #x0531	;ARMENIAN CAPITAL LETTER AYB
      #x0532	;ARMENIAN CAPITAL LETTER BEN
      #x0533	;ARMENIAN CAPITAL LETTER GIM
      #x0534	;ARMENIAN CAPITAL LETTER DA
      #x0535	;ARMENIAN CAPITAL LETTER ECH
      #x0536	;ARMENIAN CAPITAL LETTER ZA
      #x0537	;ARMENIAN CAPITAL LETTER EH
      #x0538	;ARMENIAN CAPITAL LETTER ET
      #x0539	;ARMENIAN CAPITAL LETTER TO
      #x053A	;ARMENIAN CAPITAL LETTER ZHE
      #x053B	;ARMENIAN CAPITAL LETTER INI
      #x053C	;ARMENIAN CAPITAL LETTER LIWN
      #x053D	;ARMENIAN CAPITAL LETTER XEH
      #x053E	;ARMENIAN CAPITAL LETTER CA
      #x053F	;ARMENIAN CAPITAL LETTER KEN
      #x0540	;ARMENIAN CAPITAL LETTER HO
      #x0541	;ARMENIAN CAPITAL LETTER JA
      #x0542	;ARMENIAN CAPITAL LETTER GHAD
      #x0543	;ARMENIAN CAPITAL LETTER CHEH
      #x0544	;ARMENIAN CAPITAL LETTER MEN
      #x0545	;ARMENIAN CAPITAL LETTER YI
      #x0546	;ARMENIAN CAPITAL LETTER NOW
      #x0547	;ARMENIAN CAPITAL LETTER SHA
      #x0548	;ARMENIAN CAPITAL LETTER VO
      #x0549	;ARMENIAN CAPITAL LETTER CHA
      #x054A	;ARMENIAN CAPITAL LETTER PEH
      #x054B	;ARMENIAN CAPITAL LETTER JHEH
      #x054C	;ARMENIAN CAPITAL LETTER RA
      #x054D	;ARMENIAN CAPITAL LETTER SEH
      #x054E	;ARMENIAN CAPITAL LETTER VEW
      #x054F	;ARMENIAN CAPITAL LETTER TIWN
      #x0550	;ARMENIAN CAPITAL LETTER REH
      #x0551	;ARMENIAN CAPITAL LETTER CO
      #x0552	;ARMENIAN CAPITAL LETTER YIWN
      #x0553	;ARMENIAN CAPITAL LETTER PIWR
      #x0554	;ARMENIAN CAPITAL LETTER KEH
      #x0555	;ARMENIAN CAPITAL LETTER OH
      #x0556	;ARMENIAN CAPITAL LETTER FEH
      #x0559	;ARMENIAN MODIFIER LETTER LEFT HALF RING
      #x055A	;ARMENIAN APOSTROPHE
      #x055B	;ARMENIAN EMPHASIS MARK
      #x055C	;ARMENIAN EXCLAMATION MARK
      #x055D	;ARMENIAN COMMA
      #x055E	;ARMENIAN QUESTION MARK
      #x055F	;ARMENIAN ABBREVIATION MARK
      #x0561	;ARMENIAN SMALL LETTER AYB
      #x0562	;ARMENIAN SMALL LETTER BEN
      #x0563	;ARMENIAN SMALL LETTER GIM
      #x0564	;ARMENIAN SMALL LETTER DA
      #x0565	;ARMENIAN SMALL LETTER ECH
      #x0566	;ARMENIAN SMALL LETTER ZA
      #x0567	;ARMENIAN SMALL LETTER EH
      #x0568	;ARMENIAN SMALL LETTER ET
      #x0569	;ARMENIAN SMALL LETTER TO
      #x056A	;ARMENIAN SMALL LETTER ZHE
      #x056B	;ARMENIAN SMALL LETTER INI
      #x056C	;ARMENIAN SMALL LETTER LIWN
      #x056D	;ARMENIAN SMALL LETTER XEH
      #x056E	;ARMENIAN SMALL LETTER CA
      #x056F	;ARMENIAN SMALL LETTER KEN
      #x0570	;ARMENIAN SMALL LETTER HO
      #x0571	;ARMENIAN SMALL LETTER JA
      #x0572	;ARMENIAN SMALL LETTER GHAD
      #x0573	;ARMENIAN SMALL LETTER CHEH
      #x0574	;ARMENIAN SMALL LETTER MEN
      #x0575	;ARMENIAN SMALL LETTER YI
      #x0576	;ARMENIAN SMALL LETTER NOW
      #x0577	;ARMENIAN SMALL LETTER SHA
      #x0578	;ARMENIAN SMALL LETTER VO
      #x0579	;ARMENIAN SMALL LETTER CHA
      #x057A	;ARMENIAN SMALL LETTER PEH
      #x057B	;ARMENIAN SMALL LETTER JHEH
      #x057C	;ARMENIAN SMALL LETTER RA
      #x057D	;ARMENIAN SMALL LETTER SEH
      #x057E	;ARMENIAN SMALL LETTER VEW
      #x057F	;ARMENIAN SMALL LETTER TIWN
      #x0580	;ARMENIAN SMALL LETTER REH
      #x0581	;ARMENIAN SMALL LETTER CO
      #x0582	;ARMENIAN SMALL LETTER YIWN
      #x0583	;ARMENIAN SMALL LETTER PIWR
      #x0584	;ARMENIAN SMALL LETTER KEH
      #x0585	;ARMENIAN SMALL LETTER OH
      #x0586	;ARMENIAN SMALL LETTER FEH
      #x0587	;ARMENIAN SMALL LIGATURE ECH YIWN
      #x0589	;ARMENIAN FULL STOP
      #x058A	;ARMENIAN HYPHEN
      #x0591	;HEBREW ACCENT ETNAHTA
      #x0592	;HEBREW ACCENT SEGOL
      #x0593	;HEBREW ACCENT SHALSHELET
      #x0594	;HEBREW ACCENT ZAQEF QATAN
      #x0595	;HEBREW ACCENT ZAQEF GADOL
      #x0596	;HEBREW ACCENT TIPEHA
      #x0597	;HEBREW ACCENT REVIA
      #x0598	;HEBREW ACCENT ZARQA
      #x0599	;HEBREW ACCENT PASHTA
      #x059A	;HEBREW ACCENT YETIV
      #x059B	;HEBREW ACCENT TEVIR
      #x059C	;HEBREW ACCENT GERESH
      #x059D	;HEBREW ACCENT GERESH MUQDAM
      #x059E	;HEBREW ACCENT GERSHAYIM
      #x059F	;HEBREW ACCENT QARNEY PARA
      #x05A0	;HEBREW ACCENT TELISHA GEDOLA
      #x05A1	;HEBREW ACCENT PAZER
      #x05A3	;HEBREW ACCENT MUNAH
      #x05A4	;HEBREW ACCENT MAHAPAKH
      #x05A5	;HEBREW ACCENT MERKHA
      #x05A6	;HEBREW ACCENT MERKHA KEFULA
      #x05A7	;HEBREW ACCENT DARGA
      #x05A8	;HEBREW ACCENT QADMA
      #x05A9	;HEBREW ACCENT TELISHA QETANA
      #x05AA	;HEBREW ACCENT YERAH BEN YOMO
      #x05AB	;HEBREW ACCENT OLE
      #x05AC	;HEBREW ACCENT ILUY
      #x05AD	;HEBREW ACCENT DEHI
      #x05AE	;HEBREW ACCENT ZINOR
      #x05AF	;HEBREW MARK MASORA CIRCLE
      #x05B0	;HEBREW POINT SHEVA
      #x05B1	;HEBREW POINT HATAF SEGOL
      #x05B2	;HEBREW POINT HATAF PATAH
      #x05B3	;HEBREW POINT HATAF QAMATS
      #x05B4	;HEBREW POINT HIRIQ
      #x05B5	;HEBREW POINT TSERE
      #x05B6	;HEBREW POINT SEGOL
      #x05B7	;HEBREW POINT PATAH
      #x05B8	;HEBREW POINT QAMATS
      #x05B9	;HEBREW POINT HOLAM
      #x05BB	;HEBREW POINT QUBUTS
      #x05BC	;HEBREW POINT DAGESH OR MAPIQ
      #x05BD	;HEBREW POINT METEG
      #x05BE	;HEBREW PUNCTUATION MAQAF
      #x05BF	;HEBREW POINT RAFE
      #x05C0	;HEBREW PUNCTUATION PASEQ
      #x05C1	;HEBREW POINT SHIN DOT
      #x05C2	;HEBREW POINT SIN DOT
      #x05C3	;HEBREW PUNCTUATION SOF PASUQ
      #x05C4	;HEBREW MARK UPPER DOT
      #x05D0	;HEBREW LETTER ALEF
      #x05D1	;HEBREW LETTER BET
      #x05D2	;HEBREW LETTER GIMEL
      #x05D3	;HEBREW LETTER DALET
      #x05D4	;HEBREW LETTER HE
      #x05D5	;HEBREW LETTER VAV
      #x05D6	;HEBREW LETTER ZAYIN
      #x05D7	;HEBREW LETTER HET
      #x05D8	;HEBREW LETTER TET
      #x05D9	;HEBREW LETTER YOD
      #x05DA	;HEBREW LETTER FINAL KAF
      #x05DB	;HEBREW LETTER KAF
      #x05DC	;HEBREW LETTER LAMED
      #x05DD	;HEBREW LETTER FINAL MEM
      #x05DE	;HEBREW LETTER MEM
      #x05DF	;HEBREW LETTER FINAL NUN
      #x05E0	;HEBREW LETTER NUN
      #x05E1	;HEBREW LETTER SAMEKH
      #x05E2	;HEBREW LETTER AYIN
      #x05E3	;HEBREW LETTER FINAL PE
      #x05E4	;HEBREW LETTER PE
      #x05E5	;HEBREW LETTER FINAL TSADI
      #x05E6	;HEBREW LETTER TSADI
      #x05E7	;HEBREW LETTER QOF
      #x05E8	;HEBREW LETTER RESH
      #x05E9	;HEBREW LETTER SHIN
      #x05EA	;HEBREW LETTER TAV
      #x05F0	;HEBREW LIGATURE YIDDISH DOUBLE VAV
      #x05F1	;HEBREW LIGATURE YIDDISH VAV YOD
      #x05F2	;HEBREW LIGATURE YIDDISH DOUBLE YOD
      #x05F3	;HEBREW PUNCTUATION GERESH
      #x05F4	;HEBREW PUNCTUATION GERSHAYIM
      #x0600	;ARABIC NUMBER SIGN
      #x0601	;ARABIC SIGN SANAH
      #x0602	;ARABIC FOOTNOTE MARKER
      #x0603	;ARABIC SIGN SAFHA
      #x060C	;ARABIC COMMA
      #x060D	;ARABIC DATE SEPARATOR
      #x060E	;ARABIC POETIC VERSE SIGN
      #x060F	;ARABIC SIGN MISRA
      #x0610	;ARABIC SIGN SALLALLAHOU ALAYHE WASSALLAM
      #x0611	;ARABIC SIGN ALAYHE ASSALLAM
      #x0612	;ARABIC SIGN RAHMATULLAH ALAYHE
      #x0613	;ARABIC SIGN RADI ALLAHOU ANHU
      #x0614	;ARABIC SIGN TAKHALLUS
      #x0615	;ARABIC SMALL HIGH TAH
      #x061B	;ARABIC SEMICOLON
      #x061F	;ARABIC QUESTION MARK
      #x0621	;ARABIC LETTER HAMZA
      #x0622	;ARABIC LETTER ALEF WITH MADDA ABOVE
      #x0623	;ARABIC LETTER ALEF WITH HAMZA ABOVE
      #x0624	;ARABIC LETTER WAW WITH HAMZA ABOVE
      #x0625	;ARABIC LETTER ALEF WITH HAMZA BELOW
      #x0626	;ARABIC LETTER YEH WITH HAMZA ABOVE
      #x0627	;ARABIC LETTER ALEF
      #x0628	;ARABIC LETTER BEH
      #x0629	;ARABIC LETTER TEH MARBUTA
      #x062A	;ARABIC LETTER TEH
      #x062B	;ARABIC LETTER THEH
      #x062C	;ARABIC LETTER JEEM
      #x062D	;ARABIC LETTER HAH
      #x062E	;ARABIC LETTER KHAH
      #x062F	;ARABIC LETTER DAL
      #x0630	;ARABIC LETTER THAL
      #x0631	;ARABIC LETTER REH
      #x0632	;ARABIC LETTER ZAIN
      #x0633	;ARABIC LETTER SEEN
      #x0634	;ARABIC LETTER SHEEN
      #x0635	;ARABIC LETTER SAD
      #x0636	;ARABIC LETTER DAD
      #x0637	;ARABIC LETTER TAH
      #x0638	;ARABIC LETTER ZAH
      #x0639	;ARABIC LETTER AIN
      #x063A	;ARABIC LETTER GHAIN
      #x0640	;ARABIC TATWEEL
      #x0641	;ARABIC LETTER FEH
      #x0642	;ARABIC LETTER QAF
      #x0643	;ARABIC LETTER KAF
      #x0644	;ARABIC LETTER LAM
      #x0645	;ARABIC LETTER MEEM
      #x0646	;ARABIC LETTER NOON
      #x0647	;ARABIC LETTER HEH
      #x0648	;ARABIC LETTER WAW
      #x0649	;ARABIC LETTER ALEF MAKSURA
      #x064A	;ARABIC LETTER YEH
      #x064B	;ARABIC FATHATAN
      #x064C	;ARABIC DAMMATAN
      #x064D	;ARABIC KASRATAN
      #x064E	;ARABIC FATHA
      #x064F	;ARABIC DAMMA
      #x0650	;ARABIC KASRA
      #x0651	;ARABIC SHADDA
      #x0652	;ARABIC SUKUN
      #x0653	;ARABIC MADDAH ABOVE
      #x0654	;ARABIC HAMZA ABOVE
      #x0655	;ARABIC HAMZA BELOW
      #x0656	;ARABIC SUBSCRIPT ALEF
      #x0657	;ARABIC INVERTED DAMMA
      #x0658	;ARABIC MARK NOON GHUNNA
      #x0660	;ARABIC-INDIC DIGIT ZERO
      #x0661	;ARABIC-INDIC DIGIT ONE
      #x0662	;ARABIC-INDIC DIGIT TWO
      #x0663	;ARABIC-INDIC DIGIT THREE
      #x0664	;ARABIC-INDIC DIGIT FOUR
      #x0665	;ARABIC-INDIC DIGIT FIVE
      #x0666	;ARABIC-INDIC DIGIT SIX
      #x0667	;ARABIC-INDIC DIGIT SEVEN
      #x0668	;ARABIC-INDIC DIGIT EIGHT
      #x0669	;ARABIC-INDIC DIGIT NINE
      #x066A	;ARABIC PERCENT SIGN
      #x066B	;ARABIC DECIMAL SEPARATOR
      #x066C	;ARABIC THOUSANDS SEPARATOR
      #x066D	;ARABIC FIVE POINTED STAR
      #x066E	;ARABIC LETTER DOTLESS BEH
      #x066F	;ARABIC LETTER DOTLESS QAF
      #x0670	;ARABIC LETTER SUPERSCRIPT ALEF
      #x0671	;ARABIC LETTER ALEF WASLA
      #x0672	;ARABIC LETTER ALEF WITH WAVY HAMZA ABOVE
      #x0673	;ARABIC LETTER ALEF WITH WAVY HAMZA BELOW
      #x0674	;ARABIC LETTER HIGH HAMZA
      #x0675	;ARABIC LETTER HIGH HAMZA ALEF
      #x0676	;ARABIC LETTER HIGH HAMZA WAW
      #x0677	;ARABIC LETTER U WITH HAMZA ABOVE
      #x0678	;ARABIC LETTER HIGH HAMZA YEH
      #x0679	;ARABIC LETTER TTEH
      #x067A	;ARABIC LETTER TTEHEH
      #x067B	;ARABIC LETTER BEEH
      #x067C	;ARABIC LETTER TEH WITH RING
      #x067D	;ARABIC LETTER TEH WITH THREE DOTS ABOVE DOWNWARDS
      #x067E	;ARABIC LETTER PEH
      #x067F	;ARABIC LETTER TEHEH
      #x0680	;ARABIC LETTER BEHEH
      #x0681	;ARABIC LETTER HAH WITH HAMZA ABOVE
      #x0682	;ARABIC LETTER HAH WITH TWO DOTS VERTICAL ABOVE
      #x0683	;ARABIC LETTER NYEH
      #x0684	;ARABIC LETTER DYEH
      #x0685	;ARABIC LETTER HAH WITH THREE DOTS ABOVE
      #x0686	;ARABIC LETTER TCHEH
      #x0687	;ARABIC LETTER TCHEHEH
      #x0688	;ARABIC LETTER DDAL
      #x0689	;ARABIC LETTER DAL WITH RING
      #x068A	;ARABIC LETTER DAL WITH DOT BELOW
      #x068B	;ARABIC LETTER DAL WITH DOT BELOW AND SMALL TAH
      #x068C	;ARABIC LETTER DAHAL
      #x068D	;ARABIC LETTER DDAHAL
      #x068E	;ARABIC LETTER DUL
      #x068F	;ARABIC LETTER DAL WITH THREE DOTS ABOVE DOWNWARDS
      #x0690	;ARABIC LETTER DAL WITH FOUR DOTS ABOVE
      #x0691	;ARABIC LETTER RREH
      #x0692	;ARABIC LETTER REH WITH SMALL V
      #x0693	;ARABIC LETTER REH WITH RING
      #x0694	;ARABIC LETTER REH WITH DOT BELOW
      #x0695	;ARABIC LETTER REH WITH SMALL V BELOW
      #x0696	;ARABIC LETTER REH WITH DOT BELOW AND DOT ABOVE
      #x0697	;ARABIC LETTER REH WITH TWO DOTS ABOVE
      #x0698	;ARABIC LETTER JEH
      #x0699	;ARABIC LETTER REH WITH FOUR DOTS ABOVE
      #x069A	;ARABIC LETTER SEEN WITH DOT BELOW AND DOT ABOVE
      #x069B	;ARABIC LETTER SEEN WITH THREE DOTS BELOW
      #x069C	;ARABIC LETTER SEEN WITH THREE DOTS BELOW AND THREE DOTS ABOVE
      #x069D	;ARABIC LETTER SAD WITH TWO DOTS BELOW
      #x069E	;ARABIC LETTER SAD WITH THREE DOTS ABOVE
      #x069F	;ARABIC LETTER TAH WITH THREE DOTS ABOVE
      #x06A0	;ARABIC LETTER AIN WITH THREE DOTS ABOVE
      #x06A1	;ARABIC LETTER DOTLESS FEH
      #x06A2	;ARABIC LETTER FEH WITH DOT MOVED BELOW
      #x06A3	;ARABIC LETTER FEH WITH DOT BELOW
      #x06A4	;ARABIC LETTER VEH
      #x06A5	;ARABIC LETTER FEH WITH THREE DOTS BELOW
      #x06A6	;ARABIC LETTER PEHEH
      #x06A7	;ARABIC LETTER QAF WITH DOT ABOVE
      #x06A8	;ARABIC LETTER QAF WITH THREE DOTS ABOVE
      #x06A9	;ARABIC LETTER KEHEH
      #x06AA	;ARABIC LETTER SWASH KAF
      #x06AB	;ARABIC LETTER KAF WITH RING
      #x06AC	;ARABIC LETTER KAF WITH DOT ABOVE
      #x06AD	;ARABIC LETTER NG
      #x06AE	;ARABIC LETTER KAF WITH THREE DOTS BELOW
      #x06AF	;ARABIC LETTER GAF
      #x06B0	;ARABIC LETTER GAF WITH RING
      #x06B1	;ARABIC LETTER NGOEH
      #x06B2	;ARABIC LETTER GAF WITH TWO DOTS BELOW
      #x06B3	;ARABIC LETTER GUEH
      #x06B4	;ARABIC LETTER GAF WITH THREE DOTS ABOVE
      #x06B5	;ARABIC LETTER LAM WITH SMALL V
      #x06B6	;ARABIC LETTER LAM WITH DOT ABOVE
      #x06B7	;ARABIC LETTER LAM WITH THREE DOTS ABOVE
      #x06B8	;ARABIC LETTER LAM WITH THREE DOTS BELOW
      #x06B9	;ARABIC LETTER NOON WITH DOT BELOW
      #x06BA	;ARABIC LETTER NOON GHUNNA
      #x06BB	;ARABIC LETTER RNOON
      #x06BC	;ARABIC LETTER NOON WITH RING
      #x06BD	;ARABIC LETTER NOON WITH THREE DOTS ABOVE
      #x06BE	;ARABIC LETTER HEH DOACHASHMEE
      #x06BF	;ARABIC LETTER TCHEH WITH DOT ABOVE
      #x06C0	;ARABIC LETTER HEH WITH YEH ABOVE
      #x06C1	;ARABIC LETTER HEH GOAL
      #x06C2	;ARABIC LETTER HEH GOAL WITH HAMZA ABOVE
      #x06C3	;ARABIC LETTER TEH MARBUTA GOAL
      #x06C4	;ARABIC LETTER WAW WITH RING
      #x06C5	;ARABIC LETTER KIRGHIZ OE
      #x06C6	;ARABIC LETTER OE
      #x06C7	;ARABIC LETTER U
      #x06C8	;ARABIC LETTER YU
      #x06C9	;ARABIC LETTER KIRGHIZ YU
      #x06CA	;ARABIC LETTER WAW WITH TWO DOTS ABOVE
      #x06CB	;ARABIC LETTER VE
      #x06CC	;ARABIC LETTER FARSI YEH
      #x06CD	;ARABIC LETTER YEH WITH TAIL
      #x06CE	;ARABIC LETTER YEH WITH SMALL V
      #x06CF	;ARABIC LETTER WAW WITH DOT ABOVE
      #x06D0	;ARABIC LETTER E
      #x06D1	;ARABIC LETTER YEH WITH THREE DOTS BELOW
      #x06D2	;ARABIC LETTER YEH BARREE
      #x06D3	;ARABIC LETTER YEH BARREE WITH HAMZA ABOVE
      #x06D4	;ARABIC FULL STOP
      #x06D5	;ARABIC LETTER AE
      #x06D6	;ARABIC SMALL HIGH LIGATURE SAD WITH LAM WITH ALEF MAKSURA
      #x06D7	;ARABIC SMALL HIGH LIGATURE QAF WITH LAM WITH ALEF MAKSURA
      #x06D8	;ARABIC SMALL HIGH MEEM INITIAL FORM
      #x06D9	;ARABIC SMALL HIGH LAM ALEF
      #x06DA	;ARABIC SMALL HIGH JEEM
      #x06DB	;ARABIC SMALL HIGH THREE DOTS
      #x06DC	;ARABIC SMALL HIGH SEEN
      #x06DD	;ARABIC END OF AYAH
      #x06DE	;ARABIC START OF RUB EL HIZB
      #x06DF	;ARABIC SMALL HIGH ROUNDED ZERO
      #x06E0	;ARABIC SMALL HIGH UPRIGHT RECTANGULAR ZERO
      #x06E1	;ARABIC SMALL HIGH DOTLESS HEAD OF KHAH
      #x06E2	;ARABIC SMALL HIGH MEEM ISOLATED FORM
      #x06E3	;ARABIC SMALL LOW SEEN
      #x06E4	;ARABIC SMALL HIGH MADDA
      #x06E5	;ARABIC SMALL WAW
      #x06E6	;ARABIC SMALL YEH
      #x06E7	;ARABIC SMALL HIGH YEH
      #x06E8	;ARABIC SMALL HIGH NOON
      #x06E9	;ARABIC PLACE OF SAJDAH
      #x06EA	;ARABIC EMPTY CENTRE LOW STOP
      #x06EB	;ARABIC EMPTY CENTRE HIGH STOP
      #x06EC	;ARABIC ROUNDED HIGH STOP WITH FILLED CENTRE
      #x06ED	;ARABIC SMALL LOW MEEM
      #x06EE	;ARABIC LETTER DAL WITH INVERTED V
      #x06EF	;ARABIC LETTER REH WITH INVERTED V
      #x06F0	;EXTENDED ARABIC-INDIC DIGIT ZERO
      #x06F1	;EXTENDED ARABIC-INDIC DIGIT ONE
      #x06F2	;EXTENDED ARABIC-INDIC DIGIT TWO
      #x06F3	;EXTENDED ARABIC-INDIC DIGIT THREE
      #x06F4	;EXTENDED ARABIC-INDIC DIGIT FOUR
      #x06F5	;EXTENDED ARABIC-INDIC DIGIT FIVE
      #x06F6	;EXTENDED ARABIC-INDIC DIGIT SIX
      #x06F7	;EXTENDED ARABIC-INDIC DIGIT SEVEN
      #x06F8	;EXTENDED ARABIC-INDIC DIGIT EIGHT
      #x06F9	;EXTENDED ARABIC-INDIC DIGIT NINE
      #x06FA	;ARABIC LETTER SHEEN WITH DOT BELOW
      #x06FB	;ARABIC LETTER DAD WITH DOT BELOW
      #x06FC	;ARABIC LETTER GHAIN WITH DOT BELOW
      #x06FD	;ARABIC SIGN SINDHI AMPERSAND
      #x06FE	;ARABIC SIGN SINDHI POSTPOSITION MEN
      #x06FF	;ARABIC LETTER HEH WITH INVERTED V
      #x0700	;SYRIAC END OF PARAGRAPH
      #x0701	;SYRIAC SUPRALINEAR FULL STOP
      #x0702	;SYRIAC SUBLINEAR FULL STOP
      #x0703	;SYRIAC SUPRALINEAR COLON
      #x0704	;SYRIAC SUBLINEAR COLON
      #x0705	;SYRIAC HORIZONTAL COLON
      #x0706	;SYRIAC COLON SKEWED LEFT
      #x0707	;SYRIAC COLON SKEWED RIGHT
      #x0708	;SYRIAC SUPRALINEAR COLON SKEWED LEFT
      #x0709	;SYRIAC SUBLINEAR COLON SKEWED RIGHT
      #x070A	;SYRIAC CONTRACTION
      #x070B	;SYRIAC HARKLEAN OBELUS
      #x070C	;SYRIAC HARKLEAN METOBELUS
      #x070D	;SYRIAC HARKLEAN ASTERISCUS
      #x070F	;SYRIAC ABBREVIATION MARK
      #x0710	;SYRIAC LETTER ALAPH
      #x0711	;SYRIAC LETTER SUPERSCRIPT ALAPH
      #x0712	;SYRIAC LETTER BETH
      #x0713	;SYRIAC LETTER GAMAL
      #x0714	;SYRIAC LETTER GAMAL GARSHUNI
      #x0715	;SYRIAC LETTER DALATH
      #x0716	;SYRIAC LETTER DOTLESS DALATH RISH
      #x0717	;SYRIAC LETTER HE
      #x0718	;SYRIAC LETTER WAW
      #x0719	;SYRIAC LETTER ZAIN
      #x071A	;SYRIAC LETTER HETH
      #x071B	;SYRIAC LETTER TETH
      #x071C	;SYRIAC LETTER TETH GARSHUNI
      #x071D	;SYRIAC LETTER YUDH
      #x071E	;SYRIAC LETTER YUDH HE
      #x071F	;SYRIAC LETTER KAPH
      #x0720	;SYRIAC LETTER LAMADH
      #x0721	;SYRIAC LETTER MIM
      #x0722	;SYRIAC LETTER NUN
      #x0723	;SYRIAC LETTER SEMKATH
      #x0724	;SYRIAC LETTER FINAL SEMKATH
      #x0725	;SYRIAC LETTER E
      #x0726	;SYRIAC LETTER PE
      #x0727	;SYRIAC LETTER REVERSED PE
      #x0728	;SYRIAC LETTER SADHE
      #x0729	;SYRIAC LETTER QAPH
      #x072A	;SYRIAC LETTER RISH
      #x072B	;SYRIAC LETTER SHIN
      #x072C	;SYRIAC LETTER TAW
      #x072D	;SYRIAC LETTER PERSIAN BHETH
      #x072E	;SYRIAC LETTER PERSIAN GHAMAL
      #x072F	;SYRIAC LETTER PERSIAN DHALATH
      #x0730	;SYRIAC PTHAHA ABOVE
      #x0731	;SYRIAC PTHAHA BELOW
      #x0732	;SYRIAC PTHAHA DOTTED
      #x0733	;SYRIAC ZQAPHA ABOVE
      #x0734	;SYRIAC ZQAPHA BELOW
      #x0735	;SYRIAC ZQAPHA DOTTED
      #x0736	;SYRIAC RBASA ABOVE
      #x0737	;SYRIAC RBASA BELOW
      #x0738	;SYRIAC DOTTED ZLAMA HORIZONTAL
      #x0739	;SYRIAC DOTTED ZLAMA ANGULAR
      #x073A	;SYRIAC HBASA ABOVE
      #x073B	;SYRIAC HBASA BELOW
      #x073C	;SYRIAC HBASA-ESASA DOTTED
      #x073D	;SYRIAC ESASA ABOVE
      #x073E	;SYRIAC ESASA BELOW
      #x073F	;SYRIAC RWAHA
      #x0740	;SYRIAC FEMININE DOT
      #x0741	;SYRIAC QUSHSHAYA
      #x0742	;SYRIAC RUKKAKHA
      #x0743	;SYRIAC TWO VERTICAL DOTS ABOVE
      #x0744	;SYRIAC TWO VERTICAL DOTS BELOW
      #x0745	;SYRIAC THREE DOTS ABOVE
      #x0746	;SYRIAC THREE DOTS BELOW
      #x0747	;SYRIAC OBLIQUE LINE ABOVE
      #x0748	;SYRIAC OBLIQUE LINE BELOW
      #x0749	;SYRIAC MUSIC
      #x074A	;SYRIAC BARREKH
      #x074D	;SYRIAC LETTER SOGDIAN ZHAIN
      #x074E	;SYRIAC LETTER SOGDIAN KHAPH
      #x074F	;SYRIAC LETTER SOGDIAN FE
      #x0780	;THAANA LETTER HAA
      #x0781	;THAANA LETTER SHAVIYANI
      #x0782	;THAANA LETTER NOONU
      #x0783	;THAANA LETTER RAA
      #x0784	;THAANA LETTER BAA
      #x0785	;THAANA LETTER LHAVIYANI
      #x0786	;THAANA LETTER KAAFU
      #x0787	;THAANA LETTER ALIFU
      #x0788	;THAANA LETTER VAAVU
      #x0789	;THAANA LETTER MEEMU
      #x078A	;THAANA LETTER FAAFU
      #x078B	;THAANA LETTER DHAALU
      #x078C	;THAANA LETTER THAA
      #x078D	;THAANA LETTER LAAMU
      #x078E	;THAANA LETTER GAAFU
      #x078F	;THAANA LETTER GNAVIYANI
      #x0790	;THAANA LETTER SEENU
      #x0791	;THAANA LETTER DAVIYANI
      #x0792	;THAANA LETTER ZAVIYANI
      #x0793	;THAANA LETTER TAVIYANI
      #x0794	;THAANA LETTER YAA
      #x0795	;THAANA LETTER PAVIYANI
      #x0796	;THAANA LETTER JAVIYANI
      #x0797	;THAANA LETTER CHAVIYANI
      #x0798	;THAANA LETTER TTAA
      #x0799	;THAANA LETTER HHAA
      #x079A	;THAANA LETTER KHAA
      #x079B	;THAANA LETTER THAALU
      #x079C	;THAANA LETTER ZAA
      #x079D	;THAANA LETTER SHEENU
      #x079E	;THAANA LETTER SAADHU
      #x079F	;THAANA LETTER DAADHU
      #x07A0	;THAANA LETTER TO
      #x07A1	;THAANA LETTER ZO
      #x07A2	;THAANA LETTER AINU
      #x07A3	;THAANA LETTER GHAINU
      #x07A4	;THAANA LETTER QAAFU
      #x07A5	;THAANA LETTER WAAVU
      #x07A6	;THAANA ABAFILI
      #x07A7	;THAANA AABAAFILI
      #x07A8	;THAANA IBIFILI
      #x07A9	;THAANA EEBEEFILI
      #x07AA	;THAANA UBUFILI
      #x07AB	;THAANA OOBOOFILI
      #x07AC	;THAANA EBEFILI
      #x07AD	;THAANA EYBEYFILI
      #x07AE	;THAANA OBOFILI
      #x07AF	;THAANA OABOAFILI
      #x07B0	;THAANA SUKUN
      #x07B1	;THAANA LETTER NAA
      #x0901	;DEVANAGARI SIGN CANDRABINDU
      #x0902	;DEVANAGARI SIGN ANUSVARA
      #x0903	;DEVANAGARI SIGN VISARGA
      #x0904	;DEVANAGARI LETTER SHORT A
      #x0905	;DEVANAGARI LETTER A
      #x0906	;DEVANAGARI LETTER AA
      #x0907	;DEVANAGARI LETTER I
      #x0908	;DEVANAGARI LETTER II
      #x0909	;DEVANAGARI LETTER U
      #x090A	;DEVANAGARI LETTER UU
      #x090B	;DEVANAGARI LETTER VOCALIC R
      #x090C	;DEVANAGARI LETTER VOCALIC L
      #x090D	;DEVANAGARI LETTER CANDRA E
      #x090E	;DEVANAGARI LETTER SHORT E
      #x090F	;DEVANAGARI LETTER E
      #x0910	;DEVANAGARI LETTER AI
      #x0911	;DEVANAGARI LETTER CANDRA O
      #x0912	;DEVANAGARI LETTER SHORT O
      #x0913	;DEVANAGARI LETTER O
      #x0914	;DEVANAGARI LETTER AU
      #x0915	;DEVANAGARI LETTER KA
      #x0916	;DEVANAGARI LETTER KHA
      #x0917	;DEVANAGARI LETTER GA
      #x0918	;DEVANAGARI LETTER GHA
      #x0919	;DEVANAGARI LETTER NGA
      #x091A	;DEVANAGARI LETTER CA
      #x091B	;DEVANAGARI LETTER CHA
      #x091C	;DEVANAGARI LETTER JA
      #x091D	;DEVANAGARI LETTER JHA
      #x091E	;DEVANAGARI LETTER NYA
      #x091F	;DEVANAGARI LETTER TTA
      #x0920	;DEVANAGARI LETTER TTHA
      #x0921	;DEVANAGARI LETTER DDA
      #x0922	;DEVANAGARI LETTER DDHA
      #x0923	;DEVANAGARI LETTER NNA
      #x0924	;DEVANAGARI LETTER TA
      #x0925	;DEVANAGARI LETTER THA
      #x0926	;DEVANAGARI LETTER DA
      #x0927	;DEVANAGARI LETTER DHA
      #x0928	;DEVANAGARI LETTER NA
      #x0929	;DEVANAGARI LETTER NNNA
      #x092A	;DEVANAGARI LETTER PA
      #x092B	;DEVANAGARI LETTER PHA
      #x092C	;DEVANAGARI LETTER BA
      #x092D	;DEVANAGARI LETTER BHA
      #x092E	;DEVANAGARI LETTER MA
      #x092F	;DEVANAGARI LETTER YA
      #x0930	;DEVANAGARI LETTER RA
      #x0931	;DEVANAGARI LETTER RRA
      #x0932	;DEVANAGARI LETTER LA
      #x0933	;DEVANAGARI LETTER LLA
      #x0934	;DEVANAGARI LETTER LLLA
      #x0935	;DEVANAGARI LETTER VA
      #x0936	;DEVANAGARI LETTER SHA
      #x0937	;DEVANAGARI LETTER SSA
      #x0938	;DEVANAGARI LETTER SA
      #x0939	;DEVANAGARI LETTER HA
      #x093C	;DEVANAGARI SIGN NUKTA
      #x093D	;DEVANAGARI SIGN AVAGRAHA
      #x093E	;DEVANAGARI VOWEL SIGN AA
      #x093F	;DEVANAGARI VOWEL SIGN I
      #x0940	;DEVANAGARI VOWEL SIGN II
      #x0941	;DEVANAGARI VOWEL SIGN U
      #x0942	;DEVANAGARI VOWEL SIGN UU
      #x0943	;DEVANAGARI VOWEL SIGN VOCALIC R
      #x0944	;DEVANAGARI VOWEL SIGN VOCALIC RR
      #x0945	;DEVANAGARI VOWEL SIGN CANDRA E
      #x0946	;DEVANAGARI VOWEL SIGN SHORT E
      #x0947	;DEVANAGARI VOWEL SIGN E
      #x0948	;DEVANAGARI VOWEL SIGN AI
      #x0949	;DEVANAGARI VOWEL SIGN CANDRA O
      #x094A	;DEVANAGARI VOWEL SIGN SHORT O
      #x094B	;DEVANAGARI VOWEL SIGN O
      #x094C	;DEVANAGARI VOWEL SIGN AU
      #x094D	;DEVANAGARI SIGN VIRAMA
      #x0950	;DEVANAGARI OM
      #x0951	;DEVANAGARI STRESS SIGN UDATTA
      #x0952	;DEVANAGARI STRESS SIGN ANUDATTA
      #x0953	;DEVANAGARI GRAVE ACCENT
      #x0954	;DEVANAGARI ACUTE ACCENT
      #x0958	;DEVANAGARI LETTER QA
      #x0959	;DEVANAGARI LETTER KHHA
      #x095A	;DEVANAGARI LETTER GHHA
      #x095B	;DEVANAGARI LETTER ZA
      #x095C	;DEVANAGARI LETTER DDDHA
      #x095D	;DEVANAGARI LETTER RHA
      #x095E	;DEVANAGARI LETTER FA
      #x095F	;DEVANAGARI LETTER YYA
      #x0960	;DEVANAGARI LETTER VOCALIC RR
      #x0961	;DEVANAGARI LETTER VOCALIC LL
      #x0962	;DEVANAGARI VOWEL SIGN VOCALIC L
      #x0963	;DEVANAGARI VOWEL SIGN VOCALIC LL
      #x0964	;DEVANAGARI DANDA
      #x0965	;DEVANAGARI DOUBLE DANDA
      #x0966	;DEVANAGARI DIGIT ZERO
      #x0967	;DEVANAGARI DIGIT ONE
      #x0968	;DEVANAGARI DIGIT TWO
      #x0969	;DEVANAGARI DIGIT THREE
      #x096A	;DEVANAGARI DIGIT FOUR
      #x096B	;DEVANAGARI DIGIT FIVE
      #x096C	;DEVANAGARI DIGIT SIX
      #x096D	;DEVANAGARI DIGIT SEVEN
      #x096E	;DEVANAGARI DIGIT EIGHT
      #x096F	;DEVANAGARI DIGIT NINE
      #x0970	;DEVANAGARI ABBREVIATION SIGN
      #x0981	;BENGALI SIGN CANDRABINDU
      #x0982	;BENGALI SIGN ANUSVARA
      #x0983	;BENGALI SIGN VISARGA
      #x0985	;BENGALI LETTER A
      #x0986	;BENGALI LETTER AA
      #x0987	;BENGALI LETTER I
      #x0988	;BENGALI LETTER II
      #x0989	;BENGALI LETTER U
      #x098A	;BENGALI LETTER UU
      #x098B	;BENGALI LETTER VOCALIC R
      #x098C	;BENGALI LETTER VOCALIC L
      #x098F	;BENGALI LETTER E
      #x0990	;BENGALI LETTER AI
      #x0993	;BENGALI LETTER O
      #x0994	;BENGALI LETTER AU
      #x0995	;BENGALI LETTER KA
      #x0996	;BENGALI LETTER KHA
      #x0997	;BENGALI LETTER GA
      #x0998	;BENGALI LETTER GHA
      #x0999	;BENGALI LETTER NGA
      #x099A	;BENGALI LETTER CA
      #x099B	;BENGALI LETTER CHA
      #x099C	;BENGALI LETTER JA
      #x099D	;BENGALI LETTER JHA
      #x099E	;BENGALI LETTER NYA
      #x099F	;BENGALI LETTER TTA
      #x09A0	;BENGALI LETTER TTHA
      #x09A1	;BENGALI LETTER DDA
      #x09A2	;BENGALI LETTER DDHA
      #x09A3	;BENGALI LETTER NNA
      #x09A4	;BENGALI LETTER TA
      #x09A5	;BENGALI LETTER THA
      #x09A6	;BENGALI LETTER DA
      #x09A7	;BENGALI LETTER DHA
      #x09A8	;BENGALI LETTER NA
      #x09AA	;BENGALI LETTER PA
      #x09AB	;BENGALI LETTER PHA
      #x09AC	;BENGALI LETTER BA
      #x09AD	;BENGALI LETTER BHA
      #x09AE	;BENGALI LETTER MA
      #x09AF	;BENGALI LETTER YA
      #x09B0	;BENGALI LETTER RA
      #x09B2	;BENGALI LETTER LA
      #x09B6	;BENGALI LETTER SHA
      #x09B7	;BENGALI LETTER SSA
      #x09B8	;BENGALI LETTER SA
      #x09B9	;BENGALI LETTER HA
      #x09BC	;BENGALI SIGN NUKTA
      #x09BD	;BENGALI SIGN AVAGRAHA
      #x09BE	;BENGALI VOWEL SIGN AA
      #x09BF	;BENGALI VOWEL SIGN I
      #x09C0	;BENGALI VOWEL SIGN II
      #x09C1	;BENGALI VOWEL SIGN U
      #x09C2	;BENGALI VOWEL SIGN UU
      #x09C3	;BENGALI VOWEL SIGN VOCALIC R
      #x09C4	;BENGALI VOWEL SIGN VOCALIC RR
      #x09C7	;BENGALI VOWEL SIGN E
      #x09C8	;BENGALI VOWEL SIGN AI
      #x09CB	;BENGALI VOWEL SIGN O
      #x09CC	;BENGALI VOWEL SIGN AU
      #x09CD	;BENGALI SIGN VIRAMA
      #x09D7	;BENGALI AU LENGTH MARK
      #x09DC	;BENGALI LETTER RRA
      #x09DD	;BENGALI LETTER RHA
      #x09DF	;BENGALI LETTER YYA
      #x09E0	;BENGALI LETTER VOCALIC RR
      #x09E1	;BENGALI LETTER VOCALIC LL
      #x09E2	;BENGALI VOWEL SIGN VOCALIC L
      #x09E3	;BENGALI VOWEL SIGN VOCALIC LL
      #x09E6	;BENGALI DIGIT ZERO
      #x09E7	;BENGALI DIGIT ONE
      #x09E8	;BENGALI DIGIT TWO
      #x09E9	;BENGALI DIGIT THREE
      #x09EA	;BENGALI DIGIT FOUR
      #x09EB	;BENGALI DIGIT FIVE
      #x09EC	;BENGALI DIGIT SIX
      #x09ED	;BENGALI DIGIT SEVEN
      #x09EE	;BENGALI DIGIT EIGHT
      #x09EF	;BENGALI DIGIT NINE
      #x09F0	;BENGALI LETTER RA WITH MIDDLE DIAGONAL
      #x09F1	;BENGALI LETTER RA WITH LOWER DIAGONAL
      #x09F2	;BENGALI RUPEE MARK
      #x09F3	;BENGALI RUPEE SIGN
      #x09F4	;BENGALI CURRENCY NUMERATOR ONE
      #x09F5	;BENGALI CURRENCY NUMERATOR TWO
      #x09F6	;BENGALI CURRENCY NUMERATOR THREE
      #x09F7	;BENGALI CURRENCY NUMERATOR FOUR
      #x09F8	;BENGALI CURRENCY NUMERATOR ONE LESS THAN THE DENOMINATOR
      #x09F9	;BENGALI CURRENCY DENOMINATOR SIXTEEN
      #x09FA	;BENGALI ISSHAR
      #x0A01	;GURMUKHI SIGN ADAK BINDI
      #x0A02	;GURMUKHI SIGN BINDI
      #x0A03	;GURMUKHI SIGN VISARGA
      #x0A05	;GURMUKHI LETTER A
      #x0A06	;GURMUKHI LETTER AA
      #x0A07	;GURMUKHI LETTER I
      #x0A08	;GURMUKHI LETTER II
      #x0A09	;GURMUKHI LETTER U
      #x0A0A	;GURMUKHI LETTER UU
      #x0A0F	;GURMUKHI LETTER EE
      #x0A10	;GURMUKHI LETTER AI
      #x0A13	;GURMUKHI LETTER OO
      #x0A14	;GURMUKHI LETTER AU
      #x0A15	;GURMUKHI LETTER KA
      #x0A16	;GURMUKHI LETTER KHA
      #x0A17	;GURMUKHI LETTER GA
      #x0A18	;GURMUKHI LETTER GHA
      #x0A19	;GURMUKHI LETTER NGA
      #x0A1A	;GURMUKHI LETTER CA
      #x0A1B	;GURMUKHI LETTER CHA
      #x0A1C	;GURMUKHI LETTER JA
      #x0A1D	;GURMUKHI LETTER JHA
      #x0A1E	;GURMUKHI LETTER NYA
      #x0A1F	;GURMUKHI LETTER TTA
      #x0A20	;GURMUKHI LETTER TTHA
      #x0A21	;GURMUKHI LETTER DDA
      #x0A22	;GURMUKHI LETTER DDHA
      #x0A23	;GURMUKHI LETTER NNA
      #x0A24	;GURMUKHI LETTER TA
      #x0A25	;GURMUKHI LETTER THA
      #x0A26	;GURMUKHI LETTER DA
      #x0A27	;GURMUKHI LETTER DHA
      #x0A28	;GURMUKHI LETTER NA
      #x0A2A	;GURMUKHI LETTER PA
      #x0A2B	;GURMUKHI LETTER PHA
      #x0A2C	;GURMUKHI LETTER BA
      #x0A2D	;GURMUKHI LETTER BHA
      #x0A2E	;GURMUKHI LETTER MA
      #x0A2F	;GURMUKHI LETTER YA
      #x0A30	;GURMUKHI LETTER RA
      #x0A32	;GURMUKHI LETTER LA
      #x0A33	;GURMUKHI LETTER LLA
      #x0A35	;GURMUKHI LETTER VA
      #x0A36	;GURMUKHI LETTER SHA
      #x0A38	;GURMUKHI LETTER SA
      #x0A39	;GURMUKHI LETTER HA
      #x0A3C	;GURMUKHI SIGN NUKTA
      #x0A3E	;GURMUKHI VOWEL SIGN AA
      #x0A3F	;GURMUKHI VOWEL SIGN I
      #x0A40	;GURMUKHI VOWEL SIGN II
      #x0A41	;GURMUKHI VOWEL SIGN U
      #x0A42	;GURMUKHI VOWEL SIGN UU
      #x0A47	;GURMUKHI VOWEL SIGN EE
      #x0A48	;GURMUKHI VOWEL SIGN AI
      #x0A4B	;GURMUKHI VOWEL SIGN OO
      #x0A4C	;GURMUKHI VOWEL SIGN AU
      #x0A4D	;GURMUKHI SIGN VIRAMA
      #x0A59	;GURMUKHI LETTER KHHA
      #x0A5A	;GURMUKHI LETTER GHHA
      #x0A5B	;GURMUKHI LETTER ZA
      #x0A5C	;GURMUKHI LETTER RRA
      #x0A5E	;GURMUKHI LETTER FA
      #x0A66	;GURMUKHI DIGIT ZERO
      #x0A67	;GURMUKHI DIGIT ONE
      #x0A68	;GURMUKHI DIGIT TWO
      #x0A69	;GURMUKHI DIGIT THREE
      #x0A6A	;GURMUKHI DIGIT FOUR
      #x0A6B	;GURMUKHI DIGIT FIVE
      #x0A6C	;GURMUKHI DIGIT SIX
      #x0A6D	;GURMUKHI DIGIT SEVEN
      #x0A6E	;GURMUKHI DIGIT EIGHT
      #x0A6F	;GURMUKHI DIGIT NINE
      #x0A70	;GURMUKHI TIPPI
      #x0A71	;GURMUKHI ADDAK
      #x0A72	;GURMUKHI IRI
      #x0A73	;GURMUKHI URA
      #x0A74	;GURMUKHI EK ONKAR
      #x0A81	;GUJARATI SIGN CANDRABINDU
      #x0A82	;GUJARATI SIGN ANUSVARA
      #x0A83	;GUJARATI SIGN VISARGA
      #x0A85	;GUJARATI LETTER A
      #x0A86	;GUJARATI LETTER AA
      #x0A87	;GUJARATI LETTER I
      #x0A88	;GUJARATI LETTER II
      #x0A89	;GUJARATI LETTER U
      #x0A8A	;GUJARATI LETTER UU
      #x0A8B	;GUJARATI LETTER VOCALIC R
      #x0A8C	;GUJARATI LETTER VOCALIC L
      #x0A8D	;GUJARATI VOWEL CANDRA E
      #x0A8F	;GUJARATI LETTER E
      #x0A90	;GUJARATI LETTER AI
      #x0A91	;GUJARATI VOWEL CANDRA O
      #x0A93	;GUJARATI LETTER O
      #x0A94	;GUJARATI LETTER AU
      #x0A95	;GUJARATI LETTER KA
      #x0A96	;GUJARATI LETTER KHA
      #x0A97	;GUJARATI LETTER GA
      #x0A98	;GUJARATI LETTER GHA
      #x0A99	;GUJARATI LETTER NGA
      #x0A9A	;GUJARATI LETTER CA
      #x0A9B	;GUJARATI LETTER CHA
      #x0A9C	;GUJARATI LETTER JA
      #x0A9D	;GUJARATI LETTER JHA
      #x0A9E	;GUJARATI LETTER NYA
      #x0A9F	;GUJARATI LETTER TTA
      #x0AA0	;GUJARATI LETTER TTHA
      #x0AA1	;GUJARATI LETTER DDA
      #x0AA2	;GUJARATI LETTER DDHA
      #x0AA3	;GUJARATI LETTER NNA
      #x0AA4	;GUJARATI LETTER TA
      #x0AA5	;GUJARATI LETTER THA
      #x0AA6	;GUJARATI LETTER DA
      #x0AA7	;GUJARATI LETTER DHA
      #x0AA8	;GUJARATI LETTER NA
      #x0AAA	;GUJARATI LETTER PA
      #x0AAB	;GUJARATI LETTER PHA
      #x0AAC	;GUJARATI LETTER BA
      #x0AAD	;GUJARATI LETTER BHA
      #x0AAE	;GUJARATI LETTER MA
      #x0AAF	;GUJARATI LETTER YA
      #x0AB0	;GUJARATI LETTER RA
      #x0AB2	;GUJARATI LETTER LA
      #x0AB3	;GUJARATI LETTER LLA
      #x0AB5	;GUJARATI LETTER VA
      #x0AB6	;GUJARATI LETTER SHA
      #x0AB7	;GUJARATI LETTER SSA
      #x0AB8	;GUJARATI LETTER SA
      #x0AB9	;GUJARATI LETTER HA
      #x0ABC	;GUJARATI SIGN NUKTA
      #x0ABD	;GUJARATI SIGN AVAGRAHA
      #x0ABE	;GUJARATI VOWEL SIGN AA
      #x0ABF	;GUJARATI VOWEL SIGN I
      #x0AC0	;GUJARATI VOWEL SIGN II
      #x0AC1	;GUJARATI VOWEL SIGN U
      #x0AC2	;GUJARATI VOWEL SIGN UU
      #x0AC3	;GUJARATI VOWEL SIGN VOCALIC R
      #x0AC4	;GUJARATI VOWEL SIGN VOCALIC RR
      #x0AC5	;GUJARATI VOWEL SIGN CANDRA E
      #x0AC7	;GUJARATI VOWEL SIGN E
      #x0AC8	;GUJARATI VOWEL SIGN AI
      #x0AC9	;GUJARATI VOWEL SIGN CANDRA O
      #x0ACB	;GUJARATI VOWEL SIGN O
      #x0ACC	;GUJARATI VOWEL SIGN AU
      #x0ACD	;GUJARATI SIGN VIRAMA
      #x0AD0	;GUJARATI OM
      #x0AE0	;GUJARATI LETTER VOCALIC RR
      #x0AE1	;GUJARATI LETTER VOCALIC LL
      #x0AE2	;GUJARATI VOWEL SIGN VOCALIC L
      #x0AE3	;GUJARATI VOWEL SIGN VOCALIC LL
      #x0AE6	;GUJARATI DIGIT ZERO
      #x0AE7	;GUJARATI DIGIT ONE
      #x0AE8	;GUJARATI DIGIT TWO
      #x0AE9	;GUJARATI DIGIT THREE
      #x0AEA	;GUJARATI DIGIT FOUR
      #x0AEB	;GUJARATI DIGIT FIVE
      #x0AEC	;GUJARATI DIGIT SIX
      #x0AED	;GUJARATI DIGIT SEVEN
      #x0AEE	;GUJARATI DIGIT EIGHT
      #x0AEF	;GUJARATI DIGIT NINE
      #x0AF1	;GUJARATI RUPEE SIGN
      #x0B01	;ORIYA SIGN CANDRABINDU
      #x0B02	;ORIYA SIGN ANUSVARA
      #x0B03	;ORIYA SIGN VISARGA
      #x0B05	;ORIYA LETTER A
      #x0B06	;ORIYA LETTER AA
      #x0B07	;ORIYA LETTER I
      #x0B08	;ORIYA LETTER II
      #x0B09	;ORIYA LETTER U
      #x0B0A	;ORIYA LETTER UU
      #x0B0B	;ORIYA LETTER VOCALIC R
      #x0B0C	;ORIYA LETTER VOCALIC L
      #x0B0F	;ORIYA LETTER E
      #x0B10	;ORIYA LETTER AI
      #x0B13	;ORIYA LETTER O
      #x0B14	;ORIYA LETTER AU
      #x0B15	;ORIYA LETTER KA
      #x0B16	;ORIYA LETTER KHA
      #x0B17	;ORIYA LETTER GA
      #x0B18	;ORIYA LETTER GHA
      #x0B19	;ORIYA LETTER NGA
      #x0B1A	;ORIYA LETTER CA
      #x0B1B	;ORIYA LETTER CHA
      #x0B1C	;ORIYA LETTER JA
      #x0B1D	;ORIYA LETTER JHA
      #x0B1E	;ORIYA LETTER NYA
      #x0B1F	;ORIYA LETTER TTA
      #x0B20	;ORIYA LETTER TTHA
      #x0B21	;ORIYA LETTER DDA
      #x0B22	;ORIYA LETTER DDHA
      #x0B23	;ORIYA LETTER NNA
      #x0B24	;ORIYA LETTER TA
      #x0B25	;ORIYA LETTER THA
      #x0B26	;ORIYA LETTER DA
      #x0B27	;ORIYA LETTER DHA
      #x0B28	;ORIYA LETTER NA
      #x0B2A	;ORIYA LETTER PA
      #x0B2B	;ORIYA LETTER PHA
      #x0B2C	;ORIYA LETTER BA
      #x0B2D	;ORIYA LETTER BHA
      #x0B2E	;ORIYA LETTER MA
      #x0B2F	;ORIYA LETTER YA
      #x0B30	;ORIYA LETTER RA
      #x0B32	;ORIYA LETTER LA
      #x0B33	;ORIYA LETTER LLA
      #x0B35	;ORIYA LETTER VA
      #x0B36	;ORIYA LETTER SHA
      #x0B37	;ORIYA LETTER SSA
      #x0B38	;ORIYA LETTER SA
      #x0B39	;ORIYA LETTER HA
      #x0B3C	;ORIYA SIGN NUKTA
      #x0B3D	;ORIYA SIGN AVAGRAHA
      #x0B3E	;ORIYA VOWEL SIGN AA
      #x0B3F	;ORIYA VOWEL SIGN I
      #x0B40	;ORIYA VOWEL SIGN II
      #x0B41	;ORIYA VOWEL SIGN U
      #x0B42	;ORIYA VOWEL SIGN UU
      #x0B43	;ORIYA VOWEL SIGN VOCALIC R
      #x0B47	;ORIYA VOWEL SIGN E
      #x0B48	;ORIYA VOWEL SIGN AI
      #x0B4B	;ORIYA VOWEL SIGN O
      #x0B4C	;ORIYA VOWEL SIGN AU
      #x0B4D	;ORIYA SIGN VIRAMA
      #x0B56	;ORIYA AI LENGTH MARK
      #x0B57	;ORIYA AU LENGTH MARK
      #x0B5C	;ORIYA LETTER RRA
      #x0B5D	;ORIYA LETTER RHA
      #x0B5F	;ORIYA LETTER YYA
      #x0B60	;ORIYA LETTER VOCALIC RR
      #x0B61	;ORIYA LETTER VOCALIC LL
      #x0B66	;ORIYA DIGIT ZERO
      #x0B67	;ORIYA DIGIT ONE
      #x0B68	;ORIYA DIGIT TWO
      #x0B69	;ORIYA DIGIT THREE
      #x0B6A	;ORIYA DIGIT FOUR
      #x0B6B	;ORIYA DIGIT FIVE
      #x0B6C	;ORIYA DIGIT SIX
      #x0B6D	;ORIYA DIGIT SEVEN
      #x0B6E	;ORIYA DIGIT EIGHT
      #x0B6F	;ORIYA DIGIT NINE
      #x0B70	;ORIYA ISSHAR
      #x0B71	;ORIYA LETTER WA
      #x0B82	;TAMIL SIGN ANUSVARA
      #x0B83	;TAMIL SIGN VISARGA
      #x0B85	;TAMIL LETTER A
      #x0B86	;TAMIL LETTER AA
      #x0B87	;TAMIL LETTER I
      #x0B88	;TAMIL LETTER II
      #x0B89	;TAMIL LETTER U
      #x0B8A	;TAMIL LETTER UU
      #x0B8E	;TAMIL LETTER E
      #x0B8F	;TAMIL LETTER EE
      #x0B90	;TAMIL LETTER AI
      #x0B92	;TAMIL LETTER O
      #x0B93	;TAMIL LETTER OO
      #x0B94	;TAMIL LETTER AU
      #x0B95	;TAMIL LETTER KA
      #x0B99	;TAMIL LETTER NGA
      #x0B9A	;TAMIL LETTER CA
      #x0B9C	;TAMIL LETTER JA
      #x0B9E	;TAMIL LETTER NYA
      #x0B9F	;TAMIL LETTER TTA
      #x0BA3	;TAMIL LETTER NNA
      #x0BA4	;TAMIL LETTER TA
      #x0BA8	;TAMIL LETTER NA
      #x0BA9	;TAMIL LETTER NNNA
      #x0BAA	;TAMIL LETTER PA
      #x0BAE	;TAMIL LETTER MA
      #x0BAF	;TAMIL LETTER YA
      #x0BB0	;TAMIL LETTER RA
      #x0BB1	;TAMIL LETTER RRA
      #x0BB2	;TAMIL LETTER LA
      #x0BB3	;TAMIL LETTER LLA
      #x0BB4	;TAMIL LETTER LLLA
      #x0BB5	;TAMIL LETTER VA
      #x0BB7	;TAMIL LETTER SSA
      #x0BB8	;TAMIL LETTER SA
      #x0BB9	;TAMIL LETTER HA
      #x0BBE	;TAMIL VOWEL SIGN AA
      #x0BBF	;TAMIL VOWEL SIGN I
      #x0BC0	;TAMIL VOWEL SIGN II
      #x0BC1	;TAMIL VOWEL SIGN U
      #x0BC2	;TAMIL VOWEL SIGN UU
      #x0BC6	;TAMIL VOWEL SIGN E
      #x0BC7	;TAMIL VOWEL SIGN EE
      #x0BC8	;TAMIL VOWEL SIGN AI
      #x0BCA	;TAMIL VOWEL SIGN O
      #x0BCB	;TAMIL VOWEL SIGN OO
      #x0BCC	;TAMIL VOWEL SIGN AU
      #x0BCD	;TAMIL SIGN VIRAMA
      #x0BD7	;TAMIL AU LENGTH MARK
      #x0BE7	;TAMIL DIGIT ONE
      #x0BE8	;TAMIL DIGIT TWO
      #x0BE9	;TAMIL DIGIT THREE
      #x0BEA	;TAMIL DIGIT FOUR
      #x0BEB	;TAMIL DIGIT FIVE
      #x0BEC	;TAMIL DIGIT SIX
      #x0BED	;TAMIL DIGIT SEVEN
      #x0BEE	;TAMIL DIGIT EIGHT
      #x0BEF	;TAMIL DIGIT NINE
      #x0BF0	;TAMIL NUMBER TEN
      #x0BF1	;TAMIL NUMBER ONE HUNDRED
      #x0BF2	;TAMIL NUMBER ONE THOUSAND
      #x0BF3	;TAMIL DAY SIGN
      #x0BF4	;TAMIL MONTH SIGN
      #x0BF5	;TAMIL YEAR SIGN
      #x0BF6	;TAMIL DEBIT SIGN
      #x0BF7	;TAMIL CREDIT SIGN
      #x0BF8	;TAMIL AS ABOVE SIGN
      #x0BF9	;TAMIL RUPEE SIGN
      #x0BFA	;TAMIL NUMBER SIGN
      #x0C01	;TELUGU SIGN CANDRABINDU
      #x0C02	;TELUGU SIGN ANUSVARA
      #x0C03	;TELUGU SIGN VISARGA
      #x0C05	;TELUGU LETTER A
      #x0C06	;TELUGU LETTER AA
      #x0C07	;TELUGU LETTER I
      #x0C08	;TELUGU LETTER II
      #x0C09	;TELUGU LETTER U
      #x0C0A	;TELUGU LETTER UU
      #x0C0B	;TELUGU LETTER VOCALIC R
      #x0C0C	;TELUGU LETTER VOCALIC L
      #x0C0E	;TELUGU LETTER E
      #x0C0F	;TELUGU LETTER EE
      #x0C10	;TELUGU LETTER AI
      #x0C12	;TELUGU LETTER O
      #x0C13	;TELUGU LETTER OO
      #x0C14	;TELUGU LETTER AU
      #x0C15	;TELUGU LETTER KA
      #x0C16	;TELUGU LETTER KHA
      #x0C17	;TELUGU LETTER GA
      #x0C18	;TELUGU LETTER GHA
      #x0C19	;TELUGU LETTER NGA
      #x0C1A	;TELUGU LETTER CA
      #x0C1B	;TELUGU LETTER CHA
      #x0C1C	;TELUGU LETTER JA
      #x0C1D	;TELUGU LETTER JHA
      #x0C1E	;TELUGU LETTER NYA
      #x0C1F	;TELUGU LETTER TTA
      #x0C20	;TELUGU LETTER TTHA
      #x0C21	;TELUGU LETTER DDA
      #x0C22	;TELUGU LETTER DDHA
      #x0C23	;TELUGU LETTER NNA
      #x0C24	;TELUGU LETTER TA
      #x0C25	;TELUGU LETTER THA
      #x0C26	;TELUGU LETTER DA
      #x0C27	;TELUGU LETTER DHA
      #x0C28	;TELUGU LETTER NA
      #x0C2A	;TELUGU LETTER PA
      #x0C2B	;TELUGU LETTER PHA
      #x0C2C	;TELUGU LETTER BA
      #x0C2D	;TELUGU LETTER BHA
      #x0C2E	;TELUGU LETTER MA
      #x0C2F	;TELUGU LETTER YA
      #x0C30	;TELUGU LETTER RA
      #x0C31	;TELUGU LETTER RRA
      #x0C32	;TELUGU LETTER LA
      #x0C33	;TELUGU LETTER LLA
      #x0C35	;TELUGU LETTER VA
      #x0C36	;TELUGU LETTER SHA
      #x0C37	;TELUGU LETTER SSA
      #x0C38	;TELUGU LETTER SA
      #x0C39	;TELUGU LETTER HA
      #x0C3E	;TELUGU VOWEL SIGN AA
      #x0C3F	;TELUGU VOWEL SIGN I
      #x0C40	;TELUGU VOWEL SIGN II
      #x0C41	;TELUGU VOWEL SIGN U
      #x0C42	;TELUGU VOWEL SIGN UU
      #x0C43	;TELUGU VOWEL SIGN VOCALIC R
      #x0C44	;TELUGU VOWEL SIGN VOCALIC RR
      #x0C46	;TELUGU VOWEL SIGN E
      #x0C47	;TELUGU VOWEL SIGN EE
      #x0C48	;TELUGU VOWEL SIGN AI
      #x0C4A	;TELUGU VOWEL SIGN O
      #x0C4B	;TELUGU VOWEL SIGN OO
      #x0C4C	;TELUGU VOWEL SIGN AU
      #x0C4D	;TELUGU SIGN VIRAMA
      #x0C55	;TELUGU LENGTH MARK
      #x0C56	;TELUGU AI LENGTH MARK
      #x0C60	;TELUGU LETTER VOCALIC RR
      #x0C61	;TELUGU LETTER VOCALIC LL
      #x0C66	;TELUGU DIGIT ZERO
      #x0C67	;TELUGU DIGIT ONE
      #x0C68	;TELUGU DIGIT TWO
      #x0C69	;TELUGU DIGIT THREE
      #x0C6A	;TELUGU DIGIT FOUR
      #x0C6B	;TELUGU DIGIT FIVE
      #x0C6C	;TELUGU DIGIT SIX
      #x0C6D	;TELUGU DIGIT SEVEN
      #x0C6E	;TELUGU DIGIT EIGHT
      #x0C6F	;TELUGU DIGIT NINE
      #x0C82	;KANNADA SIGN ANUSVARA
      #x0C83	;KANNADA SIGN VISARGA
      #x0C85	;KANNADA LETTER A
      #x0C86	;KANNADA LETTER AA
      #x0C87	;KANNADA LETTER I
      #x0C88	;KANNADA LETTER II
      #x0C89	;KANNADA LETTER U
      #x0C8A	;KANNADA LETTER UU
      #x0C8B	;KANNADA LETTER VOCALIC R
      #x0C8C	;KANNADA LETTER VOCALIC L
      #x0C8E	;KANNADA LETTER E
      #x0C8F	;KANNADA LETTER EE
      #x0C90	;KANNADA LETTER AI
      #x0C92	;KANNADA LETTER O
      #x0C93	;KANNADA LETTER OO
      #x0C94	;KANNADA LETTER AU
      #x0C95	;KANNADA LETTER KA
      #x0C96	;KANNADA LETTER KHA
      #x0C97	;KANNADA LETTER GA
      #x0C98	;KANNADA LETTER GHA
      #x0C99	;KANNADA LETTER NGA
      #x0C9A	;KANNADA LETTER CA
      #x0C9B	;KANNADA LETTER CHA
      #x0C9C	;KANNADA LETTER JA
      #x0C9D	;KANNADA LETTER JHA
      #x0C9E	;KANNADA LETTER NYA
      #x0C9F	;KANNADA LETTER TTA
      #x0CA0	;KANNADA LETTER TTHA
      #x0CA1	;KANNADA LETTER DDA
      #x0CA2	;KANNADA LETTER DDHA
      #x0CA3	;KANNADA LETTER NNA
      #x0CA4	;KANNADA LETTER TA
      #x0CA5	;KANNADA LETTER THA
      #x0CA6	;KANNADA LETTER DA
      #x0CA7	;KANNADA LETTER DHA
      #x0CA8	;KANNADA LETTER NA
      #x0CAA	;KANNADA LETTER PA
      #x0CAB	;KANNADA LETTER PHA
      #x0CAC	;KANNADA LETTER BA
      #x0CAD	;KANNADA LETTER BHA
      #x0CAE	;KANNADA LETTER MA
      #x0CAF	;KANNADA LETTER YA
      #x0CB0	;KANNADA LETTER RA
      #x0CB1	;KANNADA LETTER RRA
      #x0CB2	;KANNADA LETTER LA
      #x0CB3	;KANNADA LETTER LLA
      #x0CB5	;KANNADA LETTER VA
      #x0CB6	;KANNADA LETTER SHA
      #x0CB7	;KANNADA LETTER SSA
      #x0CB8	;KANNADA LETTER SA
      #x0CB9	;KANNADA LETTER HA
      #x0CBC	;KANNADA SIGN NUKTA
      #x0CBD	;KANNADA SIGN AVAGRAHA
      #x0CBE	;KANNADA VOWEL SIGN AA
      #x0CBF	;KANNADA VOWEL SIGN I
      #x0CC0	;KANNADA VOWEL SIGN II
      #x0CC1	;KANNADA VOWEL SIGN U
      #x0CC2	;KANNADA VOWEL SIGN UU
      #x0CC3	;KANNADA VOWEL SIGN VOCALIC R
      #x0CC4	;KANNADA VOWEL SIGN VOCALIC RR
      #x0CC6	;KANNADA VOWEL SIGN E
      #x0CC7	;KANNADA VOWEL SIGN EE
      #x0CC8	;KANNADA VOWEL SIGN AI
      #x0CCA	;KANNADA VOWEL SIGN O
      #x0CCB	;KANNADA VOWEL SIGN OO
      #x0CCC	;KANNADA VOWEL SIGN AU
      #x0CCD	;KANNADA SIGN VIRAMA
      #x0CD5	;KANNADA LENGTH MARK
      #x0CD6	;KANNADA AI LENGTH MARK
      #x0CDE	;KANNADA LETTER FA
      #x0CE0	;KANNADA LETTER VOCALIC RR
      #x0CE1	;KANNADA LETTER VOCALIC LL
      #x0CE6	;KANNADA DIGIT ZERO
      #x0CE7	;KANNADA DIGIT ONE
      #x0CE8	;KANNADA DIGIT TWO
      #x0CE9	;KANNADA DIGIT THREE
      #x0CEA	;KANNADA DIGIT FOUR
      #x0CEB	;KANNADA DIGIT FIVE
      #x0CEC	;KANNADA DIGIT SIX
      #x0CED	;KANNADA DIGIT SEVEN
      #x0CEE	;KANNADA DIGIT EIGHT
      #x0CEF	;KANNADA DIGIT NINE
      #x0D02	;MALAYALAM SIGN ANUSVARA
      #x0D03	;MALAYALAM SIGN VISARGA
      #x0D05	;MALAYALAM LETTER A
      #x0D06	;MALAYALAM LETTER AA
      #x0D07	;MALAYALAM LETTER I
      #x0D08	;MALAYALAM LETTER II
      #x0D09	;MALAYALAM LETTER U
      #x0D0A	;MALAYALAM LETTER UU
      #x0D0B	;MALAYALAM LETTER VOCALIC R
      #x0D0C	;MALAYALAM LETTER VOCALIC L
      #x0D0E	;MALAYALAM LETTER E
      #x0D0F	;MALAYALAM LETTER EE
      #x0D10	;MALAYALAM LETTER AI
      #x0D12	;MALAYALAM LETTER O
      #x0D13	;MALAYALAM LETTER OO
      #x0D14	;MALAYALAM LETTER AU
      #x0D15	;MALAYALAM LETTER KA
      #x0D16	;MALAYALAM LETTER KHA
      #x0D17	;MALAYALAM LETTER GA
      #x0D18	;MALAYALAM LETTER GHA
      #x0D19	;MALAYALAM LETTER NGA
      #x0D1A	;MALAYALAM LETTER CA
      #x0D1B	;MALAYALAM LETTER CHA
      #x0D1C	;MALAYALAM LETTER JA
      #x0D1D	;MALAYALAM LETTER JHA
      #x0D1E	;MALAYALAM LETTER NYA
      #x0D1F	;MALAYALAM LETTER TTA
      #x0D20	;MALAYALAM LETTER TTHA
      #x0D21	;MALAYALAM LETTER DDA
      #x0D22	;MALAYALAM LETTER DDHA
      #x0D23	;MALAYALAM LETTER NNA
      #x0D24	;MALAYALAM LETTER TA
      #x0D25	;MALAYALAM LETTER THA
      #x0D26	;MALAYALAM LETTER DA
      #x0D27	;MALAYALAM LETTER DHA
      #x0D28	;MALAYALAM LETTER NA
      #x0D2A	;MALAYALAM LETTER PA
      #x0D2B	;MALAYALAM LETTER PHA
      #x0D2C	;MALAYALAM LETTER BA
      #x0D2D	;MALAYALAM LETTER BHA
      #x0D2E	;MALAYALAM LETTER MA
      #x0D2F	;MALAYALAM LETTER YA
      #x0D30	;MALAYALAM LETTER RA
      #x0D31	;MALAYALAM LETTER RRA
      #x0D32	;MALAYALAM LETTER LA
      #x0D33	;MALAYALAM LETTER LLA
      #x0D34	;MALAYALAM LETTER LLLA
      #x0D35	;MALAYALAM LETTER VA
      #x0D36	;MALAYALAM LETTER SHA
      #x0D37	;MALAYALAM LETTER SSA
      #x0D38	;MALAYALAM LETTER SA
      #x0D39	;MALAYALAM LETTER HA
      #x0D3E	;MALAYALAM VOWEL SIGN AA
      #x0D3F	;MALAYALAM VOWEL SIGN I
      #x0D40	;MALAYALAM VOWEL SIGN II
      #x0D41	;MALAYALAM VOWEL SIGN U
      #x0D42	;MALAYALAM VOWEL SIGN UU
      #x0D43	;MALAYALAM VOWEL SIGN VOCALIC R
      #x0D46	;MALAYALAM VOWEL SIGN E
      #x0D47	;MALAYALAM VOWEL SIGN EE
      #x0D48	;MALAYALAM VOWEL SIGN AI
      #x0D4A	;MALAYALAM VOWEL SIGN O
      #x0D4B	;MALAYALAM VOWEL SIGN OO
      #x0D4C	;MALAYALAM VOWEL SIGN AU
      #x0D4D	;MALAYALAM SIGN VIRAMA
      #x0D57	;MALAYALAM AU LENGTH MARK
      #x0D60	;MALAYALAM LETTER VOCALIC RR
      #x0D61	;MALAYALAM LETTER VOCALIC LL
      #x0D66	;MALAYALAM DIGIT ZERO
      #x0D67	;MALAYALAM DIGIT ONE
      #x0D68	;MALAYALAM DIGIT TWO
      #x0D69	;MALAYALAM DIGIT THREE
      #x0D6A	;MALAYALAM DIGIT FOUR
      #x0D6B	;MALAYALAM DIGIT FIVE
      #x0D6C	;MALAYALAM DIGIT SIX
      #x0D6D	;MALAYALAM DIGIT SEVEN
      #x0D6E	;MALAYALAM DIGIT EIGHT
      #x0D6F	;MALAYALAM DIGIT NINE
      #x0D82	;SINHALA SIGN ANUSVARAYA
      #x0D83	;SINHALA SIGN VISARGAYA
      #x0D85	;SINHALA LETTER AYANNA
      #x0D86	;SINHALA LETTER AAYANNA
      #x0D87	;SINHALA LETTER AEYANNA
      #x0D88	;SINHALA LETTER AEEYANNA
      #x0D89	;SINHALA LETTER IYANNA
      #x0D8A	;SINHALA LETTER IIYANNA
      #x0D8B	;SINHALA LETTER UYANNA
      #x0D8C	;SINHALA LETTER UUYANNA
      #x0D8D	;SINHALA LETTER IRUYANNA
      #x0D8E	;SINHALA LETTER IRUUYANNA
      #x0D8F	;SINHALA LETTER ILUYANNA
      #x0D90	;SINHALA LETTER ILUUYANNA
      #x0D91	;SINHALA LETTER EYANNA
      #x0D92	;SINHALA LETTER EEYANNA
      #x0D93	;SINHALA LETTER AIYANNA
      #x0D94	;SINHALA LETTER OYANNA
      #x0D95	;SINHALA LETTER OOYANNA
      #x0D96	;SINHALA LETTER AUYANNA
      #x0D9A	;SINHALA LETTER ALPAPRAANA KAYANNA
      #x0D9B	;SINHALA LETTER MAHAAPRAANA KAYANNA
      #x0D9C	;SINHALA LETTER ALPAPRAANA GAYANNA
      #x0D9D	;SINHALA LETTER MAHAAPRAANA GAYANNA
      #x0D9E	;SINHALA LETTER KANTAJA NAASIKYAYA
      #x0D9F	;SINHALA LETTER SANYAKA GAYANNA
      #x0DA0	;SINHALA LETTER ALPAPRAANA CAYANNA
      #x0DA1	;SINHALA LETTER MAHAAPRAANA CAYANNA
      #x0DA2	;SINHALA LETTER ALPAPRAANA JAYANNA
      #x0DA3	;SINHALA LETTER MAHAAPRAANA JAYANNA
      #x0DA4	;SINHALA LETTER TAALUJA NAASIKYAYA
      #x0DA5	;SINHALA LETTER TAALUJA SANYOOGA NAAKSIKYAYA
      #x0DA6	;SINHALA LETTER SANYAKA JAYANNA
      #x0DA7	;SINHALA LETTER ALPAPRAANA TTAYANNA
      #x0DA8	;SINHALA LETTER MAHAAPRAANA TTAYANNA
      #x0DA9	;SINHALA LETTER ALPAPRAANA DDAYANNA
      #x0DAA	;SINHALA LETTER MAHAAPRAANA DDAYANNA
      #x0DAB	;SINHALA LETTER MUURDHAJA NAYANNA
      #x0DAC	;SINHALA LETTER SANYAKA DDAYANNA
      #x0DAD	;SINHALA LETTER ALPAPRAANA TAYANNA
      #x0DAE	;SINHALA LETTER MAHAAPRAANA TAYANNA
      #x0DAF	;SINHALA LETTER ALPAPRAANA DAYANNA
      #x0DB0	;SINHALA LETTER MAHAAPRAANA DAYANNA
      #x0DB1	;SINHALA LETTER DANTAJA NAYANNA
      #x0DB3	;SINHALA LETTER SANYAKA DAYANNA
      #x0DB4	;SINHALA LETTER ALPAPRAANA PAYANNA
      #x0DB5	;SINHALA LETTER MAHAAPRAANA PAYANNA
      #x0DB6	;SINHALA LETTER ALPAPRAANA BAYANNA
      #x0DB7	;SINHALA LETTER MAHAAPRAANA BAYANNA
      #x0DB8	;SINHALA LETTER MAYANNA
      #x0DB9	;SINHALA LETTER AMBA BAYANNA
      #x0DBA	;SINHALA LETTER YAYANNA
      #x0DBB	;SINHALA LETTER RAYANNA
      #x0DBD	;SINHALA LETTER DANTAJA LAYANNA
      #x0DC0	;SINHALA LETTER VAYANNA
      #x0DC1	;SINHALA LETTER TAALUJA SAYANNA
      #x0DC2	;SINHALA LETTER MUURDHAJA SAYANNA
      #x0DC3	;SINHALA LETTER DANTAJA SAYANNA
      #x0DC4	;SINHALA LETTER HAYANNA
      #x0DC5	;SINHALA LETTER MUURDHAJA LAYANNA
      #x0DC6	;SINHALA LETTER FAYANNA
      #x0DCA	;SINHALA SIGN AL-LAKUNA
      #x0DCF	;SINHALA VOWEL SIGN AELA-PILLA
      #x0DD0	;SINHALA VOWEL SIGN KETTI AEDA-PILLA
      #x0DD1	;SINHALA VOWEL SIGN DIGA AEDA-PILLA
      #x0DD2	;SINHALA VOWEL SIGN KETTI IS-PILLA
      #x0DD3	;SINHALA VOWEL SIGN DIGA IS-PILLA
      #x0DD4	;SINHALA VOWEL SIGN KETTI PAA-PILLA
      #x0DD6	;SINHALA VOWEL SIGN DIGA PAA-PILLA
      #x0DD8	;SINHALA VOWEL SIGN GAETTA-PILLA
      #x0DD9	;SINHALA VOWEL SIGN KOMBUVA
      #x0DDA	;SINHALA VOWEL SIGN DIGA KOMBUVA
      #x0DDB	;SINHALA VOWEL SIGN KOMBU DEKA
      #x0DDC	;SINHALA VOWEL SIGN KOMBUVA HAA AELA-PILLA
      #x0DDD	;SINHALA VOWEL SIGN KOMBUVA HAA DIGA AELA-PILLA
      #x0DDE	;SINHALA VOWEL SIGN KOMBUVA HAA GAYANUKITTA
      #x0DDF	;SINHALA VOWEL SIGN GAYANUKITTA
      #x0DF2	;SINHALA VOWEL SIGN DIGA GAETTA-PILLA
      #x0DF3	;SINHALA VOWEL SIGN DIGA GAYANUKITTA
      #x0DF4	;SINHALA PUNCTUATION KUNDDALIYA
      #x0E01	;THAI CHARACTER KO KAI
      #x0E02	;THAI CHARACTER KHO KHAI
      #x0E03	;THAI CHARACTER KHO KHUAT
      #x0E04	;THAI CHARACTER KHO KHWAI
      #x0E05	;THAI CHARACTER KHO KHON
      #x0E06	;THAI CHARACTER KHO RAKHANG
      #x0E07	;THAI CHARACTER NGO NGU
      #x0E08	;THAI CHARACTER CHO CHAN
      #x0E09	;THAI CHARACTER CHO CHING
      #x0E0A	;THAI CHARACTER CHO CHANG
      #x0E0B	;THAI CHARACTER SO SO
      #x0E0C	;THAI CHARACTER CHO CHOE
      #x0E0D	;THAI CHARACTER YO YING
      #x0E0E	;THAI CHARACTER DO CHADA
      #x0E0F	;THAI CHARACTER TO PATAK
      #x0E10	;THAI CHARACTER THO THAN
      #x0E11	;THAI CHARACTER THO NANGMONTHO
      #x0E12	;THAI CHARACTER THO PHUTHAO
      #x0E13	;THAI CHARACTER NO NEN
      #x0E14	;THAI CHARACTER DO DEK
      #x0E15	;THAI CHARACTER TO TAO
      #x0E16	;THAI CHARACTER THO THUNG
      #x0E17	;THAI CHARACTER THO THAHAN
      #x0E18	;THAI CHARACTER THO THONG
      #x0E19	;THAI CHARACTER NO NU
      #x0E1A	;THAI CHARACTER BO BAIMAI
      #x0E1B	;THAI CHARACTER PO PLA
      #x0E1C	;THAI CHARACTER PHO PHUNG
      #x0E1D	;THAI CHARACTER FO FA
      #x0E1E	;THAI CHARACTER PHO PHAN
      #x0E1F	;THAI CHARACTER FO FAN
      #x0E20	;THAI CHARACTER PHO SAMPHAO
      #x0E21	;THAI CHARACTER MO MA
      #x0E22	;THAI CHARACTER YO YAK
      #x0E23	;THAI CHARACTER RO RUA
      #x0E24	;THAI CHARACTER RU
      #x0E25	;THAI CHARACTER LO LING
      #x0E26	;THAI CHARACTER LU
      #x0E27	;THAI CHARACTER WO WAEN
      #x0E28	;THAI CHARACTER SO SALA
      #x0E29	;THAI CHARACTER SO RUSI
      #x0E2A	;THAI CHARACTER SO SUA
      #x0E2B	;THAI CHARACTER HO HIP
      #x0E2C	;THAI CHARACTER LO CHULA
      #x0E2D	;THAI CHARACTER O ANG
      #x0E2E	;THAI CHARACTER HO NOKHUK
      #x0E2F	;THAI CHARACTER PAIYANNOI
      #x0E30	;THAI CHARACTER SARA A
      #x0E31	;THAI CHARACTER MAI HAN-AKAT
      #x0E32	;THAI CHARACTER SARA AA
      #x0E33	;THAI CHARACTER SARA AM
      #x0E34	;THAI CHARACTER SARA I
      #x0E35	;THAI CHARACTER SARA II
      #x0E36	;THAI CHARACTER SARA UE
      #x0E37	;THAI CHARACTER SARA UEE
      #x0E38	;THAI CHARACTER SARA U
      #x0E39	;THAI CHARACTER SARA UU
      #x0E3A	;THAI CHARACTER PHINTHU
      #x0E3F	;THAI CURRENCY SYMBOL BAHT
      #x0E40	;THAI CHARACTER SARA E
      #x0E41	;THAI CHARACTER SARA AE
      #x0E42	;THAI CHARACTER SARA O
      #x0E43	;THAI CHARACTER SARA AI MAIMUAN
      #x0E44	;THAI CHARACTER SARA AI MAIMALAI
      #x0E45	;THAI CHARACTER LAKKHANGYAO
      #x0E46	;THAI CHARACTER MAIYAMOK
      #x0E47	;THAI CHARACTER MAITAIKHU
      #x0E48	;THAI CHARACTER MAI EK
      #x0E49	;THAI CHARACTER MAI THO
      #x0E4A	;THAI CHARACTER MAI TRI
      #x0E4B	;THAI CHARACTER MAI CHATTAWA
      #x0E4C	;THAI CHARACTER THANTHAKHAT
      #x0E4D	;THAI CHARACTER NIKHAHIT
      #x0E4E	;THAI CHARACTER YAMAKKAN
      #x0E4F	;THAI CHARACTER FONGMAN
      #x0E50	;THAI DIGIT ZERO
      #x0E51	;THAI DIGIT ONE
      #x0E52	;THAI DIGIT TWO
      #x0E53	;THAI DIGIT THREE
      #x0E54	;THAI DIGIT FOUR
      #x0E55	;THAI DIGIT FIVE
      #x0E56	;THAI DIGIT SIX
      #x0E57	;THAI DIGIT SEVEN
      #x0E58	;THAI DIGIT EIGHT
      #x0E59	;THAI DIGIT NINE
      #x0E5A	;THAI CHARACTER ANGKHANKHU
      #x0E5B	;THAI CHARACTER KHOMUT
      #x0E81	;LAO LETTER KO
      #x0E82	;LAO LETTER KHO SUNG
      #x0E84	;LAO LETTER KHO TAM
      #x0E87	;LAO LETTER NGO
      #x0E88	;LAO LETTER CO
      #x0E8A	;LAO LETTER SO TAM
      #x0E8D	;LAO LETTER NYO
      #x0E94	;LAO LETTER DO
      #x0E95	;LAO LETTER TO
      #x0E96	;LAO LETTER THO SUNG
      #x0E97	;LAO LETTER THO TAM
      #x0E99	;LAO LETTER NO
      #x0E9A	;LAO LETTER BO
      #x0E9B	;LAO LETTER PO
      #x0E9C	;LAO LETTER PHO SUNG
      #x0E9D	;LAO LETTER FO TAM
      #x0E9E	;LAO LETTER PHO TAM
      #x0E9F	;LAO LETTER FO SUNG
      #x0EA1	;LAO LETTER MO
      #x0EA2	;LAO LETTER YO
      #x0EA3	;LAO LETTER LO LING
      #x0EA5	;LAO LETTER LO LOOT
      #x0EA7	;LAO LETTER WO
      #x0EAA	;LAO LETTER SO SUNG
      #x0EAB	;LAO LETTER HO SUNG
      #x0EAD	;LAO LETTER O
      #x0EAE	;LAO LETTER HO TAM
      #x0EAF	;LAO ELLIPSIS
      #x0EB0	;LAO VOWEL SIGN A
      #x0EB1	;LAO VOWEL SIGN MAI KAN
      #x0EB2	;LAO VOWEL SIGN AA
      #x0EB3	;LAO VOWEL SIGN AM
      #x0EB4	;LAO VOWEL SIGN I
      #x0EB5	;LAO VOWEL SIGN II
      #x0EB6	;LAO VOWEL SIGN Y
      #x0EB7	;LAO VOWEL SIGN YY
      #x0EB8	;LAO VOWEL SIGN U
      #x0EB9	;LAO VOWEL SIGN UU
      #x0EBB	;LAO VOWEL SIGN MAI KON
      #x0EBC	;LAO SEMIVOWEL SIGN LO
      #x0EBD	;LAO SEMIVOWEL SIGN NYO
      #x0EC0	;LAO VOWEL SIGN E
      #x0EC1	;LAO VOWEL SIGN EI
      #x0EC2	;LAO VOWEL SIGN O
      #x0EC3	;LAO VOWEL SIGN AY
      #x0EC4	;LAO VOWEL SIGN AI
      #x0EC6	;LAO KO LA
      #x0EC8	;LAO TONE MAI EK
      #x0EC9	;LAO TONE MAI THO
      #x0ECA	;LAO TONE MAI TI
      #x0ECB	;LAO TONE MAI CATAWA
      #x0ECC	;LAO CANCELLATION MARK
      #x0ECD	;LAO NIGGAHITA
      #x0ED0	;LAO DIGIT ZERO
      #x0ED1	;LAO DIGIT ONE
      #x0ED2	;LAO DIGIT TWO
      #x0ED3	;LAO DIGIT THREE
      #x0ED4	;LAO DIGIT FOUR
      #x0ED5	;LAO DIGIT FIVE
      #x0ED6	;LAO DIGIT SIX
      #x0ED7	;LAO DIGIT SEVEN
      #x0ED8	;LAO DIGIT EIGHT
      #x0ED9	;LAO DIGIT NINE
      #x0EDC	;LAO HO NO
      #x0EDD	;LAO HO MO
      #x0F00	;TIBETAN SYLLABLE OM
      #x0F01	;TIBETAN MARK GTER YIG MGO TRUNCATED A
      #x0F02	;TIBETAN MARK GTER YIG MGO -UM RNAM BCAD MA
      #x0F03	;TIBETAN MARK GTER YIG MGO -UM GTER TSHEG MA
      #x0F04	;TIBETAN MARK INITIAL YIG MGO MDUN MA
      #x0F05	;TIBETAN MARK CLOSING YIG MGO SGAB MA
      #x0F06	;TIBETAN MARK CARET YIG MGO PHUR SHAD MA
      #x0F07	;TIBETAN MARK YIG MGO TSHEG SHAD MA
      #x0F08	;TIBETAN MARK SBRUL SHAD
      #x0F09	;TIBETAN MARK BSKUR YIG MGO
      #x0F0A	;TIBETAN MARK BKA- SHOG YIG MGO
      #x0F0B	;TIBETAN MARK INTERSYLLABIC TSHEG
      #x0F0C	;TIBETAN MARK DELIMITER TSHEG BSTAR
      #x0F0D	;TIBETAN MARK SHAD
      #x0F0E	;TIBETAN MARK NYIS SHAD
      #x0F0F	;TIBETAN MARK TSHEG SHAD
      #x0F10	;TIBETAN MARK NYIS TSHEG SHAD
      #x0F11	;TIBETAN MARK RIN CHEN SPUNGS SHAD
      #x0F12	;TIBETAN MARK RGYA GRAM SHAD
      #x0F13	;TIBETAN MARK CARET -DZUD RTAGS ME LONG CAN
      #x0F14	;TIBETAN MARK GTER TSHEG
      #x0F15	;TIBETAN LOGOTYPE SIGN CHAD RTAGS
      #x0F16	;TIBETAN LOGOTYPE SIGN LHAG RTAGS
      #x0F17	;TIBETAN ASTROLOGICAL SIGN SGRA GCAN -CHAR RTAGS
      #x0F18	;TIBETAN ASTROLOGICAL SIGN -KHYUD PA
      #x0F19	;TIBETAN ASTROLOGICAL SIGN SDONG TSHUGS
      #x0F1A	;TIBETAN SIGN RDEL DKAR GCIG
      #x0F1B	;TIBETAN SIGN RDEL DKAR GNYIS
      #x0F1C	;TIBETAN SIGN RDEL DKAR GSUM
      #x0F1D	;TIBETAN SIGN RDEL NAG GCIG
      #x0F1E	;TIBETAN SIGN RDEL NAG GNYIS
      #x0F1F	;TIBETAN SIGN RDEL DKAR RDEL NAG
      #x0F20	;TIBETAN DIGIT ZERO
      #x0F21	;TIBETAN DIGIT ONE
      #x0F22	;TIBETAN DIGIT TWO
      #x0F23	;TIBETAN DIGIT THREE
      #x0F24	;TIBETAN DIGIT FOUR
      #x0F25	;TIBETAN DIGIT FIVE
      #x0F26	;TIBETAN DIGIT SIX
      #x0F27	;TIBETAN DIGIT SEVEN
      #x0F28	;TIBETAN DIGIT EIGHT
      #x0F29	;TIBETAN DIGIT NINE
      #x0F2A	;TIBETAN DIGIT HALF ONE
      #x0F2B	;TIBETAN DIGIT HALF TWO
      #x0F2C	;TIBETAN DIGIT HALF THREE
      #x0F2D	;TIBETAN DIGIT HALF FOUR
      #x0F2E	;TIBETAN DIGIT HALF FIVE
      #x0F2F	;TIBETAN DIGIT HALF SIX
      #x0F30	;TIBETAN DIGIT HALF SEVEN
      #x0F31	;TIBETAN DIGIT HALF EIGHT
      #x0F32	;TIBETAN DIGIT HALF NINE
      #x0F33	;TIBETAN DIGIT HALF ZERO
      #x0F34	;TIBETAN MARK BSDUS RTAGS
      #x0F35	;TIBETAN MARK NGAS BZUNG NYI ZLA
      #x0F36	;TIBETAN MARK CARET -DZUD RTAGS BZHI MIG CAN
      #x0F37	;TIBETAN MARK NGAS BZUNG SGOR RTAGS
      #x0F38	;TIBETAN MARK CHE MGO
      #x0F39	;TIBETAN MARK TSA -PHRU
      #x0F3A	;TIBETAN MARK GUG RTAGS GYON
      #x0F3B	;TIBETAN MARK GUG RTAGS GYAS
      #x0F3C	;TIBETAN MARK ANG KHANG GYON
      #x0F3D	;TIBETAN MARK ANG KHANG GYAS
      #x0F3E	;TIBETAN SIGN YAR TSHES
      #x0F3F	;TIBETAN SIGN MAR TSHES
      #x0F40	;TIBETAN LETTER KA
      #x0F41	;TIBETAN LETTER KHA
      #x0F42	;TIBETAN LETTER GA
      #x0F43	;TIBETAN LETTER GHA
      #x0F44	;TIBETAN LETTER NGA
      #x0F45	;TIBETAN LETTER CA
      #x0F46	;TIBETAN LETTER CHA
      #x0F47	;TIBETAN LETTER JA
      #x0F49	;TIBETAN LETTER NYA
      #x0F4A	;TIBETAN LETTER TTA
      #x0F4B	;TIBETAN LETTER TTHA
      #x0F4C	;TIBETAN LETTER DDA
      #x0F4D	;TIBETAN LETTER DDHA
      #x0F4E	;TIBETAN LETTER NNA
      #x0F4F	;TIBETAN LETTER TA
      #x0F50	;TIBETAN LETTER THA
      #x0F51	;TIBETAN LETTER DA
      #x0F52	;TIBETAN LETTER DHA
      #x0F53	;TIBETAN LETTER NA
      #x0F54	;TIBETAN LETTER PA
      #x0F55	;TIBETAN LETTER PHA
      #x0F56	;TIBETAN LETTER BA
      #x0F57	;TIBETAN LETTER BHA
      #x0F58	;TIBETAN LETTER MA
      #x0F59	;TIBETAN LETTER TSA
      #x0F5A	;TIBETAN LETTER TSHA
      #x0F5B	;TIBETAN LETTER DZA
      #x0F5C	;TIBETAN LETTER DZHA
      #x0F5D	;TIBETAN LETTER WA
      #x0F5E	;TIBETAN LETTER ZHA
      #x0F5F	;TIBETAN LETTER ZA
      #x0F60	;TIBETAN LETTER -A
      #x0F61	;TIBETAN LETTER YA
      #x0F62	;TIBETAN LETTER RA
      #x0F63	;TIBETAN LETTER LA
      #x0F64	;TIBETAN LETTER SHA
      #x0F65	;TIBETAN LETTER SSA
      #x0F66	;TIBETAN LETTER SA
      #x0F67	;TIBETAN LETTER HA
      #x0F68	;TIBETAN LETTER A
      #x0F69	;TIBETAN LETTER KSSA
      #x0F6A	;TIBETAN LETTER FIXED-FORM RA
      #x0F71	;TIBETAN VOWEL SIGN AA
      #x0F72	;TIBETAN VOWEL SIGN I
      #x0F73	;TIBETAN VOWEL SIGN II
      #x0F74	;TIBETAN VOWEL SIGN U
      #x0F75	;TIBETAN VOWEL SIGN UU
      #x0F76	;TIBETAN VOWEL SIGN VOCALIC R
      #x0F77	;TIBETAN VOWEL SIGN VOCALIC RR
      #x0F78	;TIBETAN VOWEL SIGN VOCALIC L
      #x0F79	;TIBETAN VOWEL SIGN VOCALIC LL
      #x0F7A	;TIBETAN VOWEL SIGN E
      #x0F7B	;TIBETAN VOWEL SIGN EE
      #x0F7C	;TIBETAN VOWEL SIGN O
      #x0F7D	;TIBETAN VOWEL SIGN OO
      #x0F7E	;TIBETAN SIGN RJES SU NGA RO
      #x0F7F	;TIBETAN SIGN RNAM BCAD
      #x0F80	;TIBETAN VOWEL SIGN REVERSED I
      #x0F81	;TIBETAN VOWEL SIGN REVERSED II
      #x0F82	;TIBETAN SIGN NYI ZLA NAA DA
      #x0F83	;TIBETAN SIGN SNA LDAN
      #x0F84	;TIBETAN MARK HALANTA
      #x0F85	;TIBETAN MARK PALUTA
      #x0F86	;TIBETAN SIGN LCI RTAGS
      #x0F87	;TIBETAN SIGN YANG RTAGS
      #x0F88	;TIBETAN SIGN LCE TSA CAN
      #x0F89	;TIBETAN SIGN MCHU CAN
      #x0F8A	;TIBETAN SIGN GRU CAN RGYINGS
      #x0F8B	;TIBETAN SIGN GRU MED RGYINGS
      #x0F90	;TIBETAN SUBJOINED LETTER KA
      #x0F91	;TIBETAN SUBJOINED LETTER KHA
      #x0F92	;TIBETAN SUBJOINED LETTER GA
      #x0F93	;TIBETAN SUBJOINED LETTER GHA
      #x0F94	;TIBETAN SUBJOINED LETTER NGA
      #x0F95	;TIBETAN SUBJOINED LETTER CA
      #x0F96	;TIBETAN SUBJOINED LETTER CHA
      #x0F97	;TIBETAN SUBJOINED LETTER JA
      #x0F99	;TIBETAN SUBJOINED LETTER NYA
      #x0F9A	;TIBETAN SUBJOINED LETTER TTA
      #x0F9B	;TIBETAN SUBJOINED LETTER TTHA
      #x0F9C	;TIBETAN SUBJOINED LETTER DDA
      #x0F9D	;TIBETAN SUBJOINED LETTER DDHA
      #x0F9E	;TIBETAN SUBJOINED LETTER NNA
      #x0F9F	;TIBETAN SUBJOINED LETTER TA
      #x0FA0	;TIBETAN SUBJOINED LETTER THA
      #x0FA1	;TIBETAN SUBJOINED LETTER DA
      #x0FA2	;TIBETAN SUBJOINED LETTER DHA
      #x0FA3	;TIBETAN SUBJOINED LETTER NA
      #x0FA4	;TIBETAN SUBJOINED LETTER PA
      #x0FA5	;TIBETAN SUBJOINED LETTER PHA
      #x0FA6	;TIBETAN SUBJOINED LETTER BA
      #x0FA7	;TIBETAN SUBJOINED LETTER BHA
      #x0FA8	;TIBETAN SUBJOINED LETTER MA
      #x0FA9	;TIBETAN SUBJOINED LETTER TSA
      #x0FAA	;TIBETAN SUBJOINED LETTER TSHA
      #x0FAB	;TIBETAN SUBJOINED LETTER DZA
      #x0FAC	;TIBETAN SUBJOINED LETTER DZHA
      #x0FAD	;TIBETAN SUBJOINED LETTER WA
      #x0FAE	;TIBETAN SUBJOINED LETTER ZHA
      #x0FAF	;TIBETAN SUBJOINED LETTER ZA
      #x0FB0	;TIBETAN SUBJOINED LETTER -A
      #x0FB1	;TIBETAN SUBJOINED LETTER YA
      #x0FB2	;TIBETAN SUBJOINED LETTER RA
      #x0FB3	;TIBETAN SUBJOINED LETTER LA
      #x0FB4	;TIBETAN SUBJOINED LETTER SHA
      #x0FB5	;TIBETAN SUBJOINED LETTER SSA
      #x0FB6	;TIBETAN SUBJOINED LETTER SA
      #x0FB7	;TIBETAN SUBJOINED LETTER HA
      #x0FB8	;TIBETAN SUBJOINED LETTER A
      #x0FB9	;TIBETAN SUBJOINED LETTER KSSA
      #x0FBA	;TIBETAN SUBJOINED LETTER FIXED-FORM WA
      #x0FBB	;TIBETAN SUBJOINED LETTER FIXED-FORM YA
      #x0FBC	;TIBETAN SUBJOINED LETTER FIXED-FORM RA
      #x0FBE	;TIBETAN KU RU KHA
      #x0FBF	;TIBETAN KU RU KHA BZHI MIG CAN
      #x0FC0	;TIBETAN CANTILLATION SIGN HEAVY BEAT
      #x0FC1	;TIBETAN CANTILLATION SIGN LIGHT BEAT
      #x0FC2	;TIBETAN CANTILLATION SIGN CANG TE-U
      #x0FC3	;TIBETAN CANTILLATION SIGN SBUB -CHAL
      #x0FC4	;TIBETAN SYMBOL DRIL BU
      #x0FC5	;TIBETAN SYMBOL RDO RJE
      #x0FC6	;TIBETAN SYMBOL PADMA GDAN
      #x0FC7	;TIBETAN SYMBOL RDO RJE RGYA GRAM
      #x0FC8	;TIBETAN SYMBOL PHUR PA
      #x0FC9	;TIBETAN SYMBOL NOR BU
      #x0FCA	;TIBETAN SYMBOL NOR BU NYIS -KHYIL
      #x0FCB	;TIBETAN SYMBOL NOR BU GSUM -KHYIL
      #x0FCC	;TIBETAN SYMBOL NOR BU BZHI -KHYIL
      #x0FCF	;TIBETAN SIGN RDEL NAG GSUM
      #x1000	;MYANMAR LETTER KA
      #x1001	;MYANMAR LETTER KHA
      #x1002	;MYANMAR LETTER GA
      #x1003	;MYANMAR LETTER GHA
      #x1004	;MYANMAR LETTER NGA
      #x1005	;MYANMAR LETTER CA
      #x1006	;MYANMAR LETTER CHA
      #x1007	;MYANMAR LETTER JA
      #x1008	;MYANMAR LETTER JHA
      #x1009	;MYANMAR LETTER NYA
      #x100A	;MYANMAR LETTER NNYA
      #x100B	;MYANMAR LETTER TTA
      #x100C	;MYANMAR LETTER TTHA
      #x100D	;MYANMAR LETTER DDA
      #x100E	;MYANMAR LETTER DDHA
      #x100F	;MYANMAR LETTER NNA
      #x1010	;MYANMAR LETTER TA
      #x1011	;MYANMAR LETTER THA
      #x1012	;MYANMAR LETTER DA
      #x1013	;MYANMAR LETTER DHA
      #x1014	;MYANMAR LETTER NA
      #x1015	;MYANMAR LETTER PA
      #x1016	;MYANMAR LETTER PHA
      #x1017	;MYANMAR LETTER BA
      #x1018	;MYANMAR LETTER BHA
      #x1019	;MYANMAR LETTER MA
      #x101A	;MYANMAR LETTER YA
      #x101B	;MYANMAR LETTER RA
      #x101C	;MYANMAR LETTER LA
      #x101D	;MYANMAR LETTER WA
      #x101E	;MYANMAR LETTER SA
      #x101F	;MYANMAR LETTER HA
      #x1020	;MYANMAR LETTER LLA
      #x1021	;MYANMAR LETTER A
      #x1023	;MYANMAR LETTER I
      #x1024	;MYANMAR LETTER II
      #x1025	;MYANMAR LETTER U
      #x1026	;MYANMAR LETTER UU
      #x1027	;MYANMAR LETTER E
      #x1029	;MYANMAR LETTER O
      #x102A	;MYANMAR LETTER AU
      #x102C	;MYANMAR VOWEL SIGN AA
      #x102D	;MYANMAR VOWEL SIGN I
      #x102E	;MYANMAR VOWEL SIGN II
      #x102F	;MYANMAR VOWEL SIGN U
      #x1030	;MYANMAR VOWEL SIGN UU
      #x1031	;MYANMAR VOWEL SIGN E
      #x1032	;MYANMAR VOWEL SIGN AI
      #x1036	;MYANMAR SIGN ANUSVARA
      #x1037	;MYANMAR SIGN DOT BELOW
      #x1038	;MYANMAR SIGN VISARGA
      #x1039	;MYANMAR SIGN VIRAMA
      #x1040	;MYANMAR DIGIT ZERO
      #x1041	;MYANMAR DIGIT ONE
      #x1042	;MYANMAR DIGIT TWO
      #x1043	;MYANMAR DIGIT THREE
      #x1044	;MYANMAR DIGIT FOUR
      #x1045	;MYANMAR DIGIT FIVE
      #x1046	;MYANMAR DIGIT SIX
      #x1047	;MYANMAR DIGIT SEVEN
      #x1048	;MYANMAR DIGIT EIGHT
      #x1049	;MYANMAR DIGIT NINE
      #x104A	;MYANMAR SIGN LITTLE SECTION
      #x104B	;MYANMAR SIGN SECTION
      #x104C	;MYANMAR SYMBOL LOCATIVE
      #x104D	;MYANMAR SYMBOL COMPLETED
      #x104E	;MYANMAR SYMBOL AFOREMENTIONED
      #x104F	;MYANMAR SYMBOL GENITIVE
      #x1050	;MYANMAR LETTER SHA
      #x1051	;MYANMAR LETTER SSA
      #x1052	;MYANMAR LETTER VOCALIC R
      #x1053	;MYANMAR LETTER VOCALIC RR
      #x1054	;MYANMAR LETTER VOCALIC L
      #x1055	;MYANMAR LETTER VOCALIC LL
      #x1056	;MYANMAR VOWEL SIGN VOCALIC R
      #x1057	;MYANMAR VOWEL SIGN VOCALIC RR
      #x1058	;MYANMAR VOWEL SIGN VOCALIC L
      #x1059	;MYANMAR VOWEL SIGN VOCALIC LL
      #x10A0	;GEORGIAN CAPITAL LETTER AN
      #x10A1	;GEORGIAN CAPITAL LETTER BAN
      #x10A2	;GEORGIAN CAPITAL LETTER GAN
      #x10A3	;GEORGIAN CAPITAL LETTER DON
      #x10A4	;GEORGIAN CAPITAL LETTER EN
      #x10A5	;GEORGIAN CAPITAL LETTER VIN
      #x10A6	;GEORGIAN CAPITAL LETTER ZEN
      #x10A7	;GEORGIAN CAPITAL LETTER TAN
      #x10A8	;GEORGIAN CAPITAL LETTER IN
      #x10A9	;GEORGIAN CAPITAL LETTER KAN
      #x10AA	;GEORGIAN CAPITAL LETTER LAS
      #x10AB	;GEORGIAN CAPITAL LETTER MAN
      #x10AC	;GEORGIAN CAPITAL LETTER NAR
      #x10AD	;GEORGIAN CAPITAL LETTER ON
      #x10AE	;GEORGIAN CAPITAL LETTER PAR
      #x10AF	;GEORGIAN CAPITAL LETTER ZHAR
      #x10B0	;GEORGIAN CAPITAL LETTER RAE
      #x10B1	;GEORGIAN CAPITAL LETTER SAN
      #x10B2	;GEORGIAN CAPITAL LETTER TAR
      #x10B3	;GEORGIAN CAPITAL LETTER UN
      #x10B4	;GEORGIAN CAPITAL LETTER PHAR
      #x10B5	;GEORGIAN CAPITAL LETTER KHAR
      #x10B6	;GEORGIAN CAPITAL LETTER GHAN
      #x10B7	;GEORGIAN CAPITAL LETTER QAR
      #x10B8	;GEORGIAN CAPITAL LETTER SHIN
      #x10B9	;GEORGIAN CAPITAL LETTER CHIN
      #x10BA	;GEORGIAN CAPITAL LETTER CAN
      #x10BB	;GEORGIAN CAPITAL LETTER JIL
      #x10BC	;GEORGIAN CAPITAL LETTER CIL
      #x10BD	;GEORGIAN CAPITAL LETTER CHAR
      #x10BE	;GEORGIAN CAPITAL LETTER XAN
      #x10BF	;GEORGIAN CAPITAL LETTER JHAN
      #x10C0	;GEORGIAN CAPITAL LETTER HAE
      #x10C1	;GEORGIAN CAPITAL LETTER HE
      #x10C2	;GEORGIAN CAPITAL LETTER HIE
      #x10C3	;GEORGIAN CAPITAL LETTER WE
      #x10C4	;GEORGIAN CAPITAL LETTER HAR
      #x10C5	;GEORGIAN CAPITAL LETTER HOE
      #x10D0	;GEORGIAN LETTER AN
      #x10D1	;GEORGIAN LETTER BAN
      #x10D2	;GEORGIAN LETTER GAN
      #x10D3	;GEORGIAN LETTER DON
      #x10D4	;GEORGIAN LETTER EN
      #x10D5	;GEORGIAN LETTER VIN
      #x10D6	;GEORGIAN LETTER ZEN
      #x10D7	;GEORGIAN LETTER TAN
      #x10D8	;GEORGIAN LETTER IN
      #x10D9	;GEORGIAN LETTER KAN
      #x10DA	;GEORGIAN LETTER LAS
      #x10DB	;GEORGIAN LETTER MAN
      #x10DC	;GEORGIAN LETTER NAR
      #x10DD	;GEORGIAN LETTER ON
      #x10DE	;GEORGIAN LETTER PAR
      #x10DF	;GEORGIAN LETTER ZHAR
      #x10E0	;GEORGIAN LETTER RAE
      #x10E1	;GEORGIAN LETTER SAN
      #x10E2	;GEORGIAN LETTER TAR
      #x10E3	;GEORGIAN LETTER UN
      #x10E4	;GEORGIAN LETTER PHAR
      #x10E5	;GEORGIAN LETTER KHAR
      #x10E6	;GEORGIAN LETTER GHAN
      #x10E7	;GEORGIAN LETTER QAR
      #x10E8	;GEORGIAN LETTER SHIN
      #x10E9	;GEORGIAN LETTER CHIN
      #x10EA	;GEORGIAN LETTER CAN
      #x10EB	;GEORGIAN LETTER JIL
      #x10EC	;GEORGIAN LETTER CIL
      #x10ED	;GEORGIAN LETTER CHAR
      #x10EE	;GEORGIAN LETTER XAN
      #x10EF	;GEORGIAN LETTER JHAN
      #x10F0	;GEORGIAN LETTER HAE
      #x10F1	;GEORGIAN LETTER HE
      #x10F2	;GEORGIAN LETTER HIE
      #x10F3	;GEORGIAN LETTER WE
      #x10F4	;GEORGIAN LETTER HAR
      #x10F5	;GEORGIAN LETTER HOE
      #x10F6	;GEORGIAN LETTER FI
      #x10F7	;GEORGIAN LETTER YN
      #x10F8	;GEORGIAN LETTER ELIFI
      #x10FB	;GEORGIAN PARAGRAPH SEPARATOR
      #x1100	;HANGUL CHOSEONG KIYEOK
      #x1101	;HANGUL CHOSEONG SSANGKIYEOK
      #x1102	;HANGUL CHOSEONG NIEUN
      #x1103	;HANGUL CHOSEONG TIKEUT
      #x1104	;HANGUL CHOSEONG SSANGTIKEUT
      #x1105	;HANGUL CHOSEONG RIEUL
      #x1106	;HANGUL CHOSEONG MIEUM
      #x1107	;HANGUL CHOSEONG PIEUP
      #x1108	;HANGUL CHOSEONG SSANGPIEUP
      #x1109	;HANGUL CHOSEONG SIOS
      #x110A	;HANGUL CHOSEONG SSANGSIOS
      #x110B	;HANGUL CHOSEONG IEUNG
      #x110C	;HANGUL CHOSEONG CIEUC
      #x110D	;HANGUL CHOSEONG SSANGCIEUC
      #x110E	;HANGUL CHOSEONG CHIEUCH
      #x110F	;HANGUL CHOSEONG KHIEUKH
      #x1110	;HANGUL CHOSEONG THIEUTH
      #x1111	;HANGUL CHOSEONG PHIEUPH
      #x1112	;HANGUL CHOSEONG HIEUH
      #x1113	;HANGUL CHOSEONG NIEUN-KIYEOK
      #x1114	;HANGUL CHOSEONG SSANGNIEUN
      #x1115	;HANGUL CHOSEONG NIEUN-TIKEUT
      #x1116	;HANGUL CHOSEONG NIEUN-PIEUP
      #x1117	;HANGUL CHOSEONG TIKEUT-KIYEOK
      #x1118	;HANGUL CHOSEONG RIEUL-NIEUN
      #x1119	;HANGUL CHOSEONG SSANGRIEUL
      #x111A	;HANGUL CHOSEONG RIEUL-HIEUH
      #x111B	;HANGUL CHOSEONG KAPYEOUNRIEUL
      #x111C	;HANGUL CHOSEONG MIEUM-PIEUP
      #x111D	;HANGUL CHOSEONG KAPYEOUNMIEUM
      #x111E	;HANGUL CHOSEONG PIEUP-KIYEOK
      #x111F	;HANGUL CHOSEONG PIEUP-NIEUN
      #x1120	;HANGUL CHOSEONG PIEUP-TIKEUT
      #x1121	;HANGUL CHOSEONG PIEUP-SIOS
      #x1122	;HANGUL CHOSEONG PIEUP-SIOS-KIYEOK
      #x1123	;HANGUL CHOSEONG PIEUP-SIOS-TIKEUT
      #x1124	;HANGUL CHOSEONG PIEUP-SIOS-PIEUP
      #x1125	;HANGUL CHOSEONG PIEUP-SSANGSIOS
      #x1126	;HANGUL CHOSEONG PIEUP-SIOS-CIEUC
      #x1127	;HANGUL CHOSEONG PIEUP-CIEUC
      #x1128	;HANGUL CHOSEONG PIEUP-CHIEUCH
      #x1129	;HANGUL CHOSEONG PIEUP-THIEUTH
      #x112A	;HANGUL CHOSEONG PIEUP-PHIEUPH
      #x112B	;HANGUL CHOSEONG KAPYEOUNPIEUP
      #x112C	;HANGUL CHOSEONG KAPYEOUNSSANGPIEUP
      #x112D	;HANGUL CHOSEONG SIOS-KIYEOK
      #x112E	;HANGUL CHOSEONG SIOS-NIEUN
      #x112F	;HANGUL CHOSEONG SIOS-TIKEUT
      #x1130	;HANGUL CHOSEONG SIOS-RIEUL
      #x1131	;HANGUL CHOSEONG SIOS-MIEUM
      #x1132	;HANGUL CHOSEONG SIOS-PIEUP
      #x1133	;HANGUL CHOSEONG SIOS-PIEUP-KIYEOK
      #x1134	;HANGUL CHOSEONG SIOS-SSANGSIOS
      #x1135	;HANGUL CHOSEONG SIOS-IEUNG
      #x1136	;HANGUL CHOSEONG SIOS-CIEUC
      #x1137	;HANGUL CHOSEONG SIOS-CHIEUCH
      #x1138	;HANGUL CHOSEONG SIOS-KHIEUKH
      #x1139	;HANGUL CHOSEONG SIOS-THIEUTH
      #x113A	;HANGUL CHOSEONG SIOS-PHIEUPH
      #x113B	;HANGUL CHOSEONG SIOS-HIEUH
      #x113C	;HANGUL CHOSEONG CHITUEUMSIOS
      #x113D	;HANGUL CHOSEONG CHITUEUMSSANGSIOS
      #x113E	;HANGUL CHOSEONG CEONGCHIEUMSIOS
      #x113F	;HANGUL CHOSEONG CEONGCHIEUMSSANGSIOS
      #x1140	;HANGUL CHOSEONG PANSIOS
      #x1141	;HANGUL CHOSEONG IEUNG-KIYEOK
      #x1142	;HANGUL CHOSEONG IEUNG-TIKEUT
      #x1143	;HANGUL CHOSEONG IEUNG-MIEUM
      #x1144	;HANGUL CHOSEONG IEUNG-PIEUP
      #x1145	;HANGUL CHOSEONG IEUNG-SIOS
      #x1146	;HANGUL CHOSEONG IEUNG-PANSIOS
      #x1147	;HANGUL CHOSEONG SSANGIEUNG
      #x1148	;HANGUL CHOSEONG IEUNG-CIEUC
      #x1149	;HANGUL CHOSEONG IEUNG-CHIEUCH
      #x114A	;HANGUL CHOSEONG IEUNG-THIEUTH
      #x114B	;HANGUL CHOSEONG IEUNG-PHIEUPH
      #x114C	;HANGUL CHOSEONG YESIEUNG
      #x114D	;HANGUL CHOSEONG CIEUC-IEUNG
      #x114E	;HANGUL CHOSEONG CHITUEUMCIEUC
      #x114F	;HANGUL CHOSEONG CHITUEUMSSANGCIEUC
      #x1150	;HANGUL CHOSEONG CEONGCHIEUMCIEUC
      #x1151	;HANGUL CHOSEONG CEONGCHIEUMSSANGCIEUC
      #x1152	;HANGUL CHOSEONG CHIEUCH-KHIEUKH
      #x1153	;HANGUL CHOSEONG CHIEUCH-HIEUH
      #x1154	;HANGUL CHOSEONG CHITUEUMCHIEUCH
      #x1155	;HANGUL CHOSEONG CEONGCHIEUMCHIEUCH
      #x1156	;HANGUL CHOSEONG PHIEUPH-PIEUP
      #x1157	;HANGUL CHOSEONG KAPYEOUNPHIEUPH
      #x1158	;HANGUL CHOSEONG SSANGHIEUH
      #x1159	;HANGUL CHOSEONG YEORINHIEUH
      #x115F	;HANGUL CHOSEONG FILLER
      #x1160	;HANGUL JUNGSEONG FILLER
      #x1161	;HANGUL JUNGSEONG A
      #x1162	;HANGUL JUNGSEONG AE
      #x1163	;HANGUL JUNGSEONG YA
      #x1164	;HANGUL JUNGSEONG YAE
      #x1165	;HANGUL JUNGSEONG EO
      #x1166	;HANGUL JUNGSEONG E
      #x1167	;HANGUL JUNGSEONG YEO
      #x1168	;HANGUL JUNGSEONG YE
      #x1169	;HANGUL JUNGSEONG O
      #x116A	;HANGUL JUNGSEONG WA
      #x116B	;HANGUL JUNGSEONG WAE
      #x116C	;HANGUL JUNGSEONG OE
      #x116D	;HANGUL JUNGSEONG YO
      #x116E	;HANGUL JUNGSEONG U
      #x116F	;HANGUL JUNGSEONG WEO
      #x1170	;HANGUL JUNGSEONG WE
      #x1171	;HANGUL JUNGSEONG WI
      #x1172	;HANGUL JUNGSEONG YU
      #x1173	;HANGUL JUNGSEONG EU
      #x1174	;HANGUL JUNGSEONG YI
      #x1175	;HANGUL JUNGSEONG I
      #x1176	;HANGUL JUNGSEONG A-O
      #x1177	;HANGUL JUNGSEONG A-U
      #x1178	;HANGUL JUNGSEONG YA-O
      #x1179	;HANGUL JUNGSEONG YA-YO
      #x117A	;HANGUL JUNGSEONG EO-O
      #x117B	;HANGUL JUNGSEONG EO-U
      #x117C	;HANGUL JUNGSEONG EO-EU
      #x117D	;HANGUL JUNGSEONG YEO-O
      #x117E	;HANGUL JUNGSEONG YEO-U
      #x117F	;HANGUL JUNGSEONG O-EO
      #x1180	;HANGUL JUNGSEONG O-E
      #x1181	;HANGUL JUNGSEONG O-YE
      #x1182	;HANGUL JUNGSEONG O-O
      #x1183	;HANGUL JUNGSEONG O-U
      #x1184	;HANGUL JUNGSEONG YO-YA
      #x1185	;HANGUL JUNGSEONG YO-YAE
      #x1186	;HANGUL JUNGSEONG YO-YEO
      #x1187	;HANGUL JUNGSEONG YO-O
      #x1188	;HANGUL JUNGSEONG YO-I
      #x1189	;HANGUL JUNGSEONG U-A
      #x118A	;HANGUL JUNGSEONG U-AE
      #x118B	;HANGUL JUNGSEONG U-EO-EU
      #x118C	;HANGUL JUNGSEONG U-YE
      #x118D	;HANGUL JUNGSEONG U-U
      #x118E	;HANGUL JUNGSEONG YU-A
      #x118F	;HANGUL JUNGSEONG YU-EO
      #x1190	;HANGUL JUNGSEONG YU-E
      #x1191	;HANGUL JUNGSEONG YU-YEO
      #x1192	;HANGUL JUNGSEONG YU-YE
      #x1193	;HANGUL JUNGSEONG YU-U
      #x1194	;HANGUL JUNGSEONG YU-I
      #x1195	;HANGUL JUNGSEONG EU-U
      #x1196	;HANGUL JUNGSEONG EU-EU
      #x1197	;HANGUL JUNGSEONG YI-U
      #x1198	;HANGUL JUNGSEONG I-A
      #x1199	;HANGUL JUNGSEONG I-YA
      #x119A	;HANGUL JUNGSEONG I-O
      #x119B	;HANGUL JUNGSEONG I-U
      #x119C	;HANGUL JUNGSEONG I-EU
      #x119D	;HANGUL JUNGSEONG I-ARAEA
      #x119E	;HANGUL JUNGSEONG ARAEA
      #x119F	;HANGUL JUNGSEONG ARAEA-EO
      #x11A0	;HANGUL JUNGSEONG ARAEA-U
      #x11A1	;HANGUL JUNGSEONG ARAEA-I
      #x11A2	;HANGUL JUNGSEONG SSANGARAEA
      #x11A8	;HANGUL JONGSEONG KIYEOK
      #x11A9	;HANGUL JONGSEONG SSANGKIYEOK
      #x11AA	;HANGUL JONGSEONG KIYEOK-SIOS
      #x11AB	;HANGUL JONGSEONG NIEUN
      #x11AC	;HANGUL JONGSEONG NIEUN-CIEUC
      #x11AD	;HANGUL JONGSEONG NIEUN-HIEUH
      #x11AE	;HANGUL JONGSEONG TIKEUT
      #x11AF	;HANGUL JONGSEONG RIEUL
      #x11B0	;HANGUL JONGSEONG RIEUL-KIYEOK
      #x11B1	;HANGUL JONGSEONG RIEUL-MIEUM
      #x11B2	;HANGUL JONGSEONG RIEUL-PIEUP
      #x11B3	;HANGUL JONGSEONG RIEUL-SIOS
      #x11B4	;HANGUL JONGSEONG RIEUL-THIEUTH
      #x11B5	;HANGUL JONGSEONG RIEUL-PHIEUPH
      #x11B6	;HANGUL JONGSEONG RIEUL-HIEUH
      #x11B7	;HANGUL JONGSEONG MIEUM
      #x11B8	;HANGUL JONGSEONG PIEUP
      #x11B9	;HANGUL JONGSEONG PIEUP-SIOS
      #x11BA	;HANGUL JONGSEONG SIOS
      #x11BB	;HANGUL JONGSEONG SSANGSIOS
      #x11BC	;HANGUL JONGSEONG IEUNG
      #x11BD	;HANGUL JONGSEONG CIEUC
      #x11BE	;HANGUL JONGSEONG CHIEUCH
      #x11BF	;HANGUL JONGSEONG KHIEUKH
      #x11C0	;HANGUL JONGSEONG THIEUTH
      #x11C1	;HANGUL JONGSEONG PHIEUPH
      #x11C2	;HANGUL JONGSEONG HIEUH
      #x11C3	;HANGUL JONGSEONG KIYEOK-RIEUL
      #x11C4	;HANGUL JONGSEONG KIYEOK-SIOS-KIYEOK
      #x11C5	;HANGUL JONGSEONG NIEUN-KIYEOK
      #x11C6	;HANGUL JONGSEONG NIEUN-TIKEUT
      #x11C7	;HANGUL JONGSEONG NIEUN-SIOS
      #x11C8	;HANGUL JONGSEONG NIEUN-PANSIOS
      #x11C9	;HANGUL JONGSEONG NIEUN-THIEUTH
      #x11CA	;HANGUL JONGSEONG TIKEUT-KIYEOK
      #x11CB	;HANGUL JONGSEONG TIKEUT-RIEUL
      #x11CC	;HANGUL JONGSEONG RIEUL-KIYEOK-SIOS
      #x11CD	;HANGUL JONGSEONG RIEUL-NIEUN
      #x11CE	;HANGUL JONGSEONG RIEUL-TIKEUT
      #x11CF	;HANGUL JONGSEONG RIEUL-TIKEUT-HIEUH
      #x11D0	;HANGUL JONGSEONG SSANGRIEUL
      #x11D1	;HANGUL JONGSEONG RIEUL-MIEUM-KIYEOK
      #x11D2	;HANGUL JONGSEONG RIEUL-MIEUM-SIOS
      #x11D3	;HANGUL JONGSEONG RIEUL-PIEUP-SIOS
      #x11D4	;HANGUL JONGSEONG RIEUL-PIEUP-HIEUH
      #x11D5	;HANGUL JONGSEONG RIEUL-KAPYEOUNPIEUP
      #x11D6	;HANGUL JONGSEONG RIEUL-SSANGSIOS
      #x11D7	;HANGUL JONGSEONG RIEUL-PANSIOS
      #x11D8	;HANGUL JONGSEONG RIEUL-KHIEUKH
      #x11D9	;HANGUL JONGSEONG RIEUL-YEORINHIEUH
      #x11DA	;HANGUL JONGSEONG MIEUM-KIYEOK
      #x11DB	;HANGUL JONGSEONG MIEUM-RIEUL
      #x11DC	;HANGUL JONGSEONG MIEUM-PIEUP
      #x11DD	;HANGUL JONGSEONG MIEUM-SIOS
      #x11DE	;HANGUL JONGSEONG MIEUM-SSANGSIOS
      #x11DF	;HANGUL JONGSEONG MIEUM-PANSIOS
      #x11E0	;HANGUL JONGSEONG MIEUM-CHIEUCH
      #x11E1	;HANGUL JONGSEONG MIEUM-HIEUH
      #x11E2	;HANGUL JONGSEONG KAPYEOUNMIEUM
      #x11E3	;HANGUL JONGSEONG PIEUP-RIEUL
      #x11E4	;HANGUL JONGSEONG PIEUP-PHIEUPH
      #x11E5	;HANGUL JONGSEONG PIEUP-HIEUH
      #x11E6	;HANGUL JONGSEONG KAPYEOUNPIEUP
      #x11E7	;HANGUL JONGSEONG SIOS-KIYEOK
      #x11E8	;HANGUL JONGSEONG SIOS-TIKEUT
      #x11E9	;HANGUL JONGSEONG SIOS-RIEUL
      #x11EA	;HANGUL JONGSEONG SIOS-PIEUP
      #x11EB	;HANGUL JONGSEONG PANSIOS
      #x11EC	;HANGUL JONGSEONG IEUNG-KIYEOK
      #x11ED	;HANGUL JONGSEONG IEUNG-SSANGKIYEOK
      #x11EE	;HANGUL JONGSEONG SSANGIEUNG
      #x11EF	;HANGUL JONGSEONG IEUNG-KHIEUKH
      #x11F0	;HANGUL JONGSEONG YESIEUNG
      #x11F1	;HANGUL JONGSEONG YESIEUNG-SIOS
      #x11F2	;HANGUL JONGSEONG YESIEUNG-PANSIOS
      #x11F3	;HANGUL JONGSEONG PHIEUPH-PIEUP
      #x11F4	;HANGUL JONGSEONG KAPYEOUNPHIEUPH
      #x11F5	;HANGUL JONGSEONG HIEUH-NIEUN
      #x11F6	;HANGUL JONGSEONG HIEUH-RIEUL
      #x11F7	;HANGUL JONGSEONG HIEUH-MIEUM
      #x11F8	;HANGUL JONGSEONG HIEUH-PIEUP
      #x11F9	;HANGUL JONGSEONG YEORINHIEUH
      #x1200	;ETHIOPIC SYLLABLE HA
      #x1201	;ETHIOPIC SYLLABLE HU
      #x1202	;ETHIOPIC SYLLABLE HI
      #x1203	;ETHIOPIC SYLLABLE HAA
      #x1204	;ETHIOPIC SYLLABLE HEE
      #x1205	;ETHIOPIC SYLLABLE HE
      #x1206	;ETHIOPIC SYLLABLE HO
      #x1208	;ETHIOPIC SYLLABLE LA
      #x1209	;ETHIOPIC SYLLABLE LU
      #x120A	;ETHIOPIC SYLLABLE LI
      #x120B	;ETHIOPIC SYLLABLE LAA
      #x120C	;ETHIOPIC SYLLABLE LEE
      #x120D	;ETHIOPIC SYLLABLE LE
      #x120E	;ETHIOPIC SYLLABLE LO
      #x120F	;ETHIOPIC SYLLABLE LWA
      #x1210	;ETHIOPIC SYLLABLE HHA
      #x1211	;ETHIOPIC SYLLABLE HHU
      #x1212	;ETHIOPIC SYLLABLE HHI
      #x1213	;ETHIOPIC SYLLABLE HHAA
      #x1214	;ETHIOPIC SYLLABLE HHEE
      #x1215	;ETHIOPIC SYLLABLE HHE
      #x1216	;ETHIOPIC SYLLABLE HHO
      #x1217	;ETHIOPIC SYLLABLE HHWA
      #x1218	;ETHIOPIC SYLLABLE MA
      #x1219	;ETHIOPIC SYLLABLE MU
      #x121A	;ETHIOPIC SYLLABLE MI
      #x121B	;ETHIOPIC SYLLABLE MAA
      #x121C	;ETHIOPIC SYLLABLE MEE
      #x121D	;ETHIOPIC SYLLABLE ME
      #x121E	;ETHIOPIC SYLLABLE MO
      #x121F	;ETHIOPIC SYLLABLE MWA
      #x1220	;ETHIOPIC SYLLABLE SZA
      #x1221	;ETHIOPIC SYLLABLE SZU
      #x1222	;ETHIOPIC SYLLABLE SZI
      #x1223	;ETHIOPIC SYLLABLE SZAA
      #x1224	;ETHIOPIC SYLLABLE SZEE
      #x1225	;ETHIOPIC SYLLABLE SZE
      #x1226	;ETHIOPIC SYLLABLE SZO
      #x1227	;ETHIOPIC SYLLABLE SZWA
      #x1228	;ETHIOPIC SYLLABLE RA
      #x1229	;ETHIOPIC SYLLABLE RU
      #x122A	;ETHIOPIC SYLLABLE RI
      #x122B	;ETHIOPIC SYLLABLE RAA
      #x122C	;ETHIOPIC SYLLABLE REE
      #x122D	;ETHIOPIC SYLLABLE RE
      #x122E	;ETHIOPIC SYLLABLE RO
      #x122F	;ETHIOPIC SYLLABLE RWA
      #x1230	;ETHIOPIC SYLLABLE SA
      #x1231	;ETHIOPIC SYLLABLE SU
      #x1232	;ETHIOPIC SYLLABLE SI
      #x1233	;ETHIOPIC SYLLABLE SAA
      #x1234	;ETHIOPIC SYLLABLE SEE
      #x1235	;ETHIOPIC SYLLABLE SE
      #x1236	;ETHIOPIC SYLLABLE SO
      #x1237	;ETHIOPIC SYLLABLE SWA
      #x1238	;ETHIOPIC SYLLABLE SHA
      #x1239	;ETHIOPIC SYLLABLE SHU
      #x123A	;ETHIOPIC SYLLABLE SHI
      #x123B	;ETHIOPIC SYLLABLE SHAA
      #x123C	;ETHIOPIC SYLLABLE SHEE
      #x123D	;ETHIOPIC SYLLABLE SHE
      #x123E	;ETHIOPIC SYLLABLE SHO
      #x123F	;ETHIOPIC SYLLABLE SHWA
      #x1240	;ETHIOPIC SYLLABLE QA
      #x1241	;ETHIOPIC SYLLABLE QU
      #x1242	;ETHIOPIC SYLLABLE QI
      #x1243	;ETHIOPIC SYLLABLE QAA
      #x1244	;ETHIOPIC SYLLABLE QEE
      #x1245	;ETHIOPIC SYLLABLE QE
      #x1246	;ETHIOPIC SYLLABLE QO
      #x1248	;ETHIOPIC SYLLABLE QWA
      #x124A	;ETHIOPIC SYLLABLE QWI
      #x124B	;ETHIOPIC SYLLABLE QWAA
      #x124C	;ETHIOPIC SYLLABLE QWEE
      #x124D	;ETHIOPIC SYLLABLE QWE
      #x1250	;ETHIOPIC SYLLABLE QHA
      #x1251	;ETHIOPIC SYLLABLE QHU
      #x1252	;ETHIOPIC SYLLABLE QHI
      #x1253	;ETHIOPIC SYLLABLE QHAA
      #x1254	;ETHIOPIC SYLLABLE QHEE
      #x1255	;ETHIOPIC SYLLABLE QHE
      #x1256	;ETHIOPIC SYLLABLE QHO
      #x1258	;ETHIOPIC SYLLABLE QHWA
      #x125A	;ETHIOPIC SYLLABLE QHWI
      #x125B	;ETHIOPIC SYLLABLE QHWAA
      #x125C	;ETHIOPIC SYLLABLE QHWEE
      #x125D	;ETHIOPIC SYLLABLE QHWE
      #x1260	;ETHIOPIC SYLLABLE BA
      #x1261	;ETHIOPIC SYLLABLE BU
      #x1262	;ETHIOPIC SYLLABLE BI
      #x1263	;ETHIOPIC SYLLABLE BAA
      #x1264	;ETHIOPIC SYLLABLE BEE
      #x1265	;ETHIOPIC SYLLABLE BE
      #x1266	;ETHIOPIC SYLLABLE BO
      #x1267	;ETHIOPIC SYLLABLE BWA
      #x1268	;ETHIOPIC SYLLABLE VA
      #x1269	;ETHIOPIC SYLLABLE VU
      #x126A	;ETHIOPIC SYLLABLE VI
      #x126B	;ETHIOPIC SYLLABLE VAA
      #x126C	;ETHIOPIC SYLLABLE VEE
      #x126D	;ETHIOPIC SYLLABLE VE
      #x126E	;ETHIOPIC SYLLABLE VO
      #x126F	;ETHIOPIC SYLLABLE VWA
      #x1270	;ETHIOPIC SYLLABLE TA
      #x1271	;ETHIOPIC SYLLABLE TU
      #x1272	;ETHIOPIC SYLLABLE TI
      #x1273	;ETHIOPIC SYLLABLE TAA
      #x1274	;ETHIOPIC SYLLABLE TEE
      #x1275	;ETHIOPIC SYLLABLE TE
      #x1276	;ETHIOPIC SYLLABLE TO
      #x1277	;ETHIOPIC SYLLABLE TWA
      #x1278	;ETHIOPIC SYLLABLE CA
      #x1279	;ETHIOPIC SYLLABLE CU
      #x127A	;ETHIOPIC SYLLABLE CI
      #x127B	;ETHIOPIC SYLLABLE CAA
      #x127C	;ETHIOPIC SYLLABLE CEE
      #x127D	;ETHIOPIC SYLLABLE CE
      #x127E	;ETHIOPIC SYLLABLE CO
      #x127F	;ETHIOPIC SYLLABLE CWA
      #x1280	;ETHIOPIC SYLLABLE XA
      #x1281	;ETHIOPIC SYLLABLE XU
      #x1282	;ETHIOPIC SYLLABLE XI
      #x1283	;ETHIOPIC SYLLABLE XAA
      #x1284	;ETHIOPIC SYLLABLE XEE
      #x1285	;ETHIOPIC SYLLABLE XE
      #x1286	;ETHIOPIC SYLLABLE XO
      #x1288	;ETHIOPIC SYLLABLE XWA
      #x128A	;ETHIOPIC SYLLABLE XWI
      #x128B	;ETHIOPIC SYLLABLE XWAA
      #x128C	;ETHIOPIC SYLLABLE XWEE
      #x128D	;ETHIOPIC SYLLABLE XWE
      #x1290	;ETHIOPIC SYLLABLE NA
      #x1291	;ETHIOPIC SYLLABLE NU
      #x1292	;ETHIOPIC SYLLABLE NI
      #x1293	;ETHIOPIC SYLLABLE NAA
      #x1294	;ETHIOPIC SYLLABLE NEE
      #x1295	;ETHIOPIC SYLLABLE NE
      #x1296	;ETHIOPIC SYLLABLE NO
      #x1297	;ETHIOPIC SYLLABLE NWA
      #x1298	;ETHIOPIC SYLLABLE NYA
      #x1299	;ETHIOPIC SYLLABLE NYU
      #x129A	;ETHIOPIC SYLLABLE NYI
      #x129B	;ETHIOPIC SYLLABLE NYAA
      #x129C	;ETHIOPIC SYLLABLE NYEE
      #x129D	;ETHIOPIC SYLLABLE NYE
      #x129E	;ETHIOPIC SYLLABLE NYO
      #x129F	;ETHIOPIC SYLLABLE NYWA
      #x12A0	;ETHIOPIC SYLLABLE GLOTTAL A
      #x12A1	;ETHIOPIC SYLLABLE GLOTTAL U
      #x12A2	;ETHIOPIC SYLLABLE GLOTTAL I
      #x12A3	;ETHIOPIC SYLLABLE GLOTTAL AA
      #x12A4	;ETHIOPIC SYLLABLE GLOTTAL EE
      #x12A5	;ETHIOPIC SYLLABLE GLOTTAL E
      #x12A6	;ETHIOPIC SYLLABLE GLOTTAL O
      #x12A7	;ETHIOPIC SYLLABLE GLOTTAL WA
      #x12A8	;ETHIOPIC SYLLABLE KA
      #x12A9	;ETHIOPIC SYLLABLE KU
      #x12AA	;ETHIOPIC SYLLABLE KI
      #x12AB	;ETHIOPIC SYLLABLE KAA
      #x12AC	;ETHIOPIC SYLLABLE KEE
      #x12AD	;ETHIOPIC SYLLABLE KE
      #x12AE	;ETHIOPIC SYLLABLE KO
      #x12B0	;ETHIOPIC SYLLABLE KWA
      #x12B2	;ETHIOPIC SYLLABLE KWI
      #x12B3	;ETHIOPIC SYLLABLE KWAA
      #x12B4	;ETHIOPIC SYLLABLE KWEE
      #x12B5	;ETHIOPIC SYLLABLE KWE
      #x12B8	;ETHIOPIC SYLLABLE KXA
      #x12B9	;ETHIOPIC SYLLABLE KXU
      #x12BA	;ETHIOPIC SYLLABLE KXI
      #x12BB	;ETHIOPIC SYLLABLE KXAA
      #x12BC	;ETHIOPIC SYLLABLE KXEE
      #x12BD	;ETHIOPIC SYLLABLE KXE
      #x12BE	;ETHIOPIC SYLLABLE KXO
      #x12C0	;ETHIOPIC SYLLABLE KXWA
      #x12C2	;ETHIOPIC SYLLABLE KXWI
      #x12C3	;ETHIOPIC SYLLABLE KXWAA
      #x12C4	;ETHIOPIC SYLLABLE KXWEE
      #x12C5	;ETHIOPIC SYLLABLE KXWE
      #x12C8	;ETHIOPIC SYLLABLE WA
      #x12C9	;ETHIOPIC SYLLABLE WU
      #x12CA	;ETHIOPIC SYLLABLE WI
      #x12CB	;ETHIOPIC SYLLABLE WAA
      #x12CC	;ETHIOPIC SYLLABLE WEE
      #x12CD	;ETHIOPIC SYLLABLE WE
      #x12CE	;ETHIOPIC SYLLABLE WO
      #x12D0	;ETHIOPIC SYLLABLE PHARYNGEAL A
      #x12D1	;ETHIOPIC SYLLABLE PHARYNGEAL U
      #x12D2	;ETHIOPIC SYLLABLE PHARYNGEAL I
      #x12D3	;ETHIOPIC SYLLABLE PHARYNGEAL AA
      #x12D4	;ETHIOPIC SYLLABLE PHARYNGEAL EE
      #x12D5	;ETHIOPIC SYLLABLE PHARYNGEAL E
      #x12D6	;ETHIOPIC SYLLABLE PHARYNGEAL O
      #x12D8	;ETHIOPIC SYLLABLE ZA
      #x12D9	;ETHIOPIC SYLLABLE ZU
      #x12DA	;ETHIOPIC SYLLABLE ZI
      #x12DB	;ETHIOPIC SYLLABLE ZAA
      #x12DC	;ETHIOPIC SYLLABLE ZEE
      #x12DD	;ETHIOPIC SYLLABLE ZE
      #x12DE	;ETHIOPIC SYLLABLE ZO
      #x12DF	;ETHIOPIC SYLLABLE ZWA
      #x12E0	;ETHIOPIC SYLLABLE ZHA
      #x12E1	;ETHIOPIC SYLLABLE ZHU
      #x12E2	;ETHIOPIC SYLLABLE ZHI
      #x12E3	;ETHIOPIC SYLLABLE ZHAA
      #x12E4	;ETHIOPIC SYLLABLE ZHEE
      #x12E5	;ETHIOPIC SYLLABLE ZHE
      #x12E6	;ETHIOPIC SYLLABLE ZHO
      #x12E7	;ETHIOPIC SYLLABLE ZHWA
      #x12E8	;ETHIOPIC SYLLABLE YA
      #x12E9	;ETHIOPIC SYLLABLE YU
      #x12EA	;ETHIOPIC SYLLABLE YI
      #x12EB	;ETHIOPIC SYLLABLE YAA
      #x12EC	;ETHIOPIC SYLLABLE YEE
      #x12ED	;ETHIOPIC SYLLABLE YE
      #x12EE	;ETHIOPIC SYLLABLE YO
      #x12F0	;ETHIOPIC SYLLABLE DA
      #x12F1	;ETHIOPIC SYLLABLE DU
      #x12F2	;ETHIOPIC SYLLABLE DI
      #x12F3	;ETHIOPIC SYLLABLE DAA
      #x12F4	;ETHIOPIC SYLLABLE DEE
      #x12F5	;ETHIOPIC SYLLABLE DE
      #x12F6	;ETHIOPIC SYLLABLE DO
      #x12F7	;ETHIOPIC SYLLABLE DWA
      #x12F8	;ETHIOPIC SYLLABLE DDA
      #x12F9	;ETHIOPIC SYLLABLE DDU
      #x12FA	;ETHIOPIC SYLLABLE DDI
      #x12FB	;ETHIOPIC SYLLABLE DDAA
      #x12FC	;ETHIOPIC SYLLABLE DDEE
      #x12FD	;ETHIOPIC SYLLABLE DDE
      #x12FE	;ETHIOPIC SYLLABLE DDO
      #x12FF	;ETHIOPIC SYLLABLE DDWA
      #x1300	;ETHIOPIC SYLLABLE JA
      #x1301	;ETHIOPIC SYLLABLE JU
      #x1302	;ETHIOPIC SYLLABLE JI
      #x1303	;ETHIOPIC SYLLABLE JAA
      #x1304	;ETHIOPIC SYLLABLE JEE
      #x1305	;ETHIOPIC SYLLABLE JE
      #x1306	;ETHIOPIC SYLLABLE JO
      #x1307	;ETHIOPIC SYLLABLE JWA
      #x1308	;ETHIOPIC SYLLABLE GA
      #x1309	;ETHIOPIC SYLLABLE GU
      #x130A	;ETHIOPIC SYLLABLE GI
      #x130B	;ETHIOPIC SYLLABLE GAA
      #x130C	;ETHIOPIC SYLLABLE GEE
      #x130D	;ETHIOPIC SYLLABLE GE
      #x130E	;ETHIOPIC SYLLABLE GO
      #x1310	;ETHIOPIC SYLLABLE GWA
      #x1312	;ETHIOPIC SYLLABLE GWI
      #x1313	;ETHIOPIC SYLLABLE GWAA
      #x1314	;ETHIOPIC SYLLABLE GWEE
      #x1315	;ETHIOPIC SYLLABLE GWE
      #x1318	;ETHIOPIC SYLLABLE GGA
      #x1319	;ETHIOPIC SYLLABLE GGU
      #x131A	;ETHIOPIC SYLLABLE GGI
      #x131B	;ETHIOPIC SYLLABLE GGAA
      #x131C	;ETHIOPIC SYLLABLE GGEE
      #x131D	;ETHIOPIC SYLLABLE GGE
      #x131E	;ETHIOPIC SYLLABLE GGO
      #x1320	;ETHIOPIC SYLLABLE THA
      #x1321	;ETHIOPIC SYLLABLE THU
      #x1322	;ETHIOPIC SYLLABLE THI
      #x1323	;ETHIOPIC SYLLABLE THAA
      #x1324	;ETHIOPIC SYLLABLE THEE
      #x1325	;ETHIOPIC SYLLABLE THE
      #x1326	;ETHIOPIC SYLLABLE THO
      #x1327	;ETHIOPIC SYLLABLE THWA
      #x1328	;ETHIOPIC SYLLABLE CHA
      #x1329	;ETHIOPIC SYLLABLE CHU
      #x132A	;ETHIOPIC SYLLABLE CHI
      #x132B	;ETHIOPIC SYLLABLE CHAA
      #x132C	;ETHIOPIC SYLLABLE CHEE
      #x132D	;ETHIOPIC SYLLABLE CHE
      #x132E	;ETHIOPIC SYLLABLE CHO
      #x132F	;ETHIOPIC SYLLABLE CHWA
      #x1330	;ETHIOPIC SYLLABLE PHA
      #x1331	;ETHIOPIC SYLLABLE PHU
      #x1332	;ETHIOPIC SYLLABLE PHI
      #x1333	;ETHIOPIC SYLLABLE PHAA
      #x1334	;ETHIOPIC SYLLABLE PHEE
      #x1335	;ETHIOPIC SYLLABLE PHE
      #x1336	;ETHIOPIC SYLLABLE PHO
      #x1337	;ETHIOPIC SYLLABLE PHWA
      #x1338	;ETHIOPIC SYLLABLE TSA
      #x1339	;ETHIOPIC SYLLABLE TSU
      #x133A	;ETHIOPIC SYLLABLE TSI
      #x133B	;ETHIOPIC SYLLABLE TSAA
      #x133C	;ETHIOPIC SYLLABLE TSEE
      #x133D	;ETHIOPIC SYLLABLE TSE
      #x133E	;ETHIOPIC SYLLABLE TSO
      #x133F	;ETHIOPIC SYLLABLE TSWA
      #x1340	;ETHIOPIC SYLLABLE TZA
      #x1341	;ETHIOPIC SYLLABLE TZU
      #x1342	;ETHIOPIC SYLLABLE TZI
      #x1343	;ETHIOPIC SYLLABLE TZAA
      #x1344	;ETHIOPIC SYLLABLE TZEE
      #x1345	;ETHIOPIC SYLLABLE TZE
      #x1346	;ETHIOPIC SYLLABLE TZO
      #x1348	;ETHIOPIC SYLLABLE FA
      #x1349	;ETHIOPIC SYLLABLE FU
      #x134A	;ETHIOPIC SYLLABLE FI
      #x134B	;ETHIOPIC SYLLABLE FAA
      #x134C	;ETHIOPIC SYLLABLE FEE
      #x134D	;ETHIOPIC SYLLABLE FE
      #x134E	;ETHIOPIC SYLLABLE FO
      #x134F	;ETHIOPIC SYLLABLE FWA
      #x1350	;ETHIOPIC SYLLABLE PA
      #x1351	;ETHIOPIC SYLLABLE PU
      #x1352	;ETHIOPIC SYLLABLE PI
      #x1353	;ETHIOPIC SYLLABLE PAA
      #x1354	;ETHIOPIC SYLLABLE PEE
      #x1355	;ETHIOPIC SYLLABLE PE
      #x1356	;ETHIOPIC SYLLABLE PO
      #x1357	;ETHIOPIC SYLLABLE PWA
      #x1358	;ETHIOPIC SYLLABLE RYA
      #x1359	;ETHIOPIC SYLLABLE MYA
      #x135A	;ETHIOPIC SYLLABLE FYA
      #x1361	;ETHIOPIC WORDSPACE
      #x1362	;ETHIOPIC FULL STOP
      #x1363	;ETHIOPIC COMMA
      #x1364	;ETHIOPIC SEMICOLON
      #x1365	;ETHIOPIC COLON
      #x1366	;ETHIOPIC PREFACE COLON
      #x1367	;ETHIOPIC QUESTION MARK
      #x1368	;ETHIOPIC PARAGRAPH SEPARATOR
      #x1369	;ETHIOPIC DIGIT ONE
      #x136A	;ETHIOPIC DIGIT TWO
      #x136B	;ETHIOPIC DIGIT THREE
      #x136C	;ETHIOPIC DIGIT FOUR
      #x136D	;ETHIOPIC DIGIT FIVE
      #x136E	;ETHIOPIC DIGIT SIX
      #x136F	;ETHIOPIC DIGIT SEVEN
      #x1370	;ETHIOPIC DIGIT EIGHT
      #x1371	;ETHIOPIC DIGIT NINE
      #x1372	;ETHIOPIC NUMBER TEN
      #x1373	;ETHIOPIC NUMBER TWENTY
      #x1374	;ETHIOPIC NUMBER THIRTY
      #x1375	;ETHIOPIC NUMBER FORTY
      #x1376	;ETHIOPIC NUMBER FIFTY
      #x1377	;ETHIOPIC NUMBER SIXTY
      #x1378	;ETHIOPIC NUMBER SEVENTY
      #x1379	;ETHIOPIC NUMBER EIGHTY
      #x137A	;ETHIOPIC NUMBER NINETY
      #x137B	;ETHIOPIC NUMBER HUNDRED
      #x137C	;ETHIOPIC NUMBER TEN THOUSAND
      #x13A0	;CHEROKEE LETTER A
      #x13A1	;CHEROKEE LETTER E
      #x13A2	;CHEROKEE LETTER I
      #x13A3	;CHEROKEE LETTER O
      #x13A4	;CHEROKEE LETTER U
      #x13A5	;CHEROKEE LETTER V
      #x13A6	;CHEROKEE LETTER GA
      #x13A7	;CHEROKEE LETTER KA
      #x13A8	;CHEROKEE LETTER GE
      #x13A9	;CHEROKEE LETTER GI
      #x13AA	;CHEROKEE LETTER GO
      #x13AB	;CHEROKEE LETTER GU
      #x13AC	;CHEROKEE LETTER GV
      #x13AD	;CHEROKEE LETTER HA
      #x13AE	;CHEROKEE LETTER HE
      #x13AF	;CHEROKEE LETTER HI
      #x13B0	;CHEROKEE LETTER HO
      #x13B1	;CHEROKEE LETTER HU
      #x13B2	;CHEROKEE LETTER HV
      #x13B3	;CHEROKEE LETTER LA
      #x13B4	;CHEROKEE LETTER LE
      #x13B5	;CHEROKEE LETTER LI
      #x13B6	;CHEROKEE LETTER LO
      #x13B7	;CHEROKEE LETTER LU
      #x13B8	;CHEROKEE LETTER LV
      #x13B9	;CHEROKEE LETTER MA
      #x13BA	;CHEROKEE LETTER ME
      #x13BB	;CHEROKEE LETTER MI
      #x13BC	;CHEROKEE LETTER MO
      #x13BD	;CHEROKEE LETTER MU
      #x13BE	;CHEROKEE LETTER NA
      #x13BF	;CHEROKEE LETTER HNA
      #x13C0	;CHEROKEE LETTER NAH
      #x13C1	;CHEROKEE LETTER NE
      #x13C2	;CHEROKEE LETTER NI
      #x13C3	;CHEROKEE LETTER NO
      #x13C4	;CHEROKEE LETTER NU
      #x13C5	;CHEROKEE LETTER NV
      #x13C6	;CHEROKEE LETTER QUA
      #x13C7	;CHEROKEE LETTER QUE
      #x13C8	;CHEROKEE LETTER QUI
      #x13C9	;CHEROKEE LETTER QUO
      #x13CA	;CHEROKEE LETTER QUU
      #x13CB	;CHEROKEE LETTER QUV
      #x13CC	;CHEROKEE LETTER SA
      #x13CD	;CHEROKEE LETTER S
      #x13CE	;CHEROKEE LETTER SE
      #x13CF	;CHEROKEE LETTER SI
      #x13D0	;CHEROKEE LETTER SO
      #x13D1	;CHEROKEE LETTER SU
      #x13D2	;CHEROKEE LETTER SV
      #x13D3	;CHEROKEE LETTER DA
      #x13D4	;CHEROKEE LETTER TA
      #x13D5	;CHEROKEE LETTER DE
      #x13D6	;CHEROKEE LETTER TE
      #x13D7	;CHEROKEE LETTER DI
      #x13D8	;CHEROKEE LETTER TI
      #x13D9	;CHEROKEE LETTER DO
      #x13DA	;CHEROKEE LETTER DU
      #x13DB	;CHEROKEE LETTER DV
      #x13DC	;CHEROKEE LETTER DLA
      #x13DD	;CHEROKEE LETTER TLA
      #x13DE	;CHEROKEE LETTER TLE
      #x13DF	;CHEROKEE LETTER TLI
      #x13E0	;CHEROKEE LETTER TLO
      #x13E1	;CHEROKEE LETTER TLU
      #x13E2	;CHEROKEE LETTER TLV
      #x13E3	;CHEROKEE LETTER TSA
      #x13E4	;CHEROKEE LETTER TSE
      #x13E5	;CHEROKEE LETTER TSI
      #x13E6	;CHEROKEE LETTER TSO
      #x13E7	;CHEROKEE LETTER TSU
      #x13E8	;CHEROKEE LETTER TSV
      #x13E9	;CHEROKEE LETTER WA
      #x13EA	;CHEROKEE LETTER WE
      #x13EB	;CHEROKEE LETTER WI
      #x13EC	;CHEROKEE LETTER WO
      #x13ED	;CHEROKEE LETTER WU
      #x13EE	;CHEROKEE LETTER WV
      #x13EF	;CHEROKEE LETTER YA
      #x13F0	;CHEROKEE LETTER YE
      #x13F1	;CHEROKEE LETTER YI
      #x13F2	;CHEROKEE LETTER YO
      #x13F3	;CHEROKEE LETTER YU
      #x13F4	;CHEROKEE LETTER YV
      #x1401	;CANADIAN SYLLABICS E
      #x1402	;CANADIAN SYLLABICS AAI
      #x1403	;CANADIAN SYLLABICS I
      #x1404	;CANADIAN SYLLABICS II
      #x1405	;CANADIAN SYLLABICS O
      #x1406	;CANADIAN SYLLABICS OO
      #x1407	;CANADIAN SYLLABICS Y-CREE OO
      #x1408	;CANADIAN SYLLABICS CARRIER EE
      #x1409	;CANADIAN SYLLABICS CARRIER I
      #x140A	;CANADIAN SYLLABICS A
      #x140B	;CANADIAN SYLLABICS AA
      #x140C	;CANADIAN SYLLABICS WE
      #x140D	;CANADIAN SYLLABICS WEST-CREE WE
      #x140E	;CANADIAN SYLLABICS WI
      #x140F	;CANADIAN SYLLABICS WEST-CREE WI
      #x1410	;CANADIAN SYLLABICS WII
      #x1411	;CANADIAN SYLLABICS WEST-CREE WII
      #x1412	;CANADIAN SYLLABICS WO
      #x1413	;CANADIAN SYLLABICS WEST-CREE WO
      #x1414	;CANADIAN SYLLABICS WOO
      #x1415	;CANADIAN SYLLABICS WEST-CREE WOO
      #x1416	;CANADIAN SYLLABICS NASKAPI WOO
      #x1417	;CANADIAN SYLLABICS WA
      #x1418	;CANADIAN SYLLABICS WEST-CREE WA
      #x1419	;CANADIAN SYLLABICS WAA
      #x141A	;CANADIAN SYLLABICS WEST-CREE WAA
      #x141B	;CANADIAN SYLLABICS NASKAPI WAA
      #x141C	;CANADIAN SYLLABICS AI
      #x141D	;CANADIAN SYLLABICS Y-CREE W
      #x141E	;CANADIAN SYLLABICS GLOTTAL STOP
      #x141F	;CANADIAN SYLLABICS FINAL ACUTE
      #x1420	;CANADIAN SYLLABICS FINAL GRAVE
      #x1421	;CANADIAN SYLLABICS FINAL BOTTOM HALF RING
      #x1422	;CANADIAN SYLLABICS FINAL TOP HALF RING
      #x1423	;CANADIAN SYLLABICS FINAL RIGHT HALF RING
      #x1424	;CANADIAN SYLLABICS FINAL RING
      #x1425	;CANADIAN SYLLABICS FINAL DOUBLE ACUTE
      #x1426	;CANADIAN SYLLABICS FINAL DOUBLE SHORT VERTICAL STROKES
      #x1427	;CANADIAN SYLLABICS FINAL MIDDLE DOT
      #x1428	;CANADIAN SYLLABICS FINAL SHORT HORIZONTAL STROKE
      #x1429	;CANADIAN SYLLABICS FINAL PLUS
      #x142A	;CANADIAN SYLLABICS FINAL DOWN TACK
      #x142B	;CANADIAN SYLLABICS EN
      #x142C	;CANADIAN SYLLABICS IN
      #x142D	;CANADIAN SYLLABICS ON
      #x142E	;CANADIAN SYLLABICS AN
      #x142F	;CANADIAN SYLLABICS PE
      #x1430	;CANADIAN SYLLABICS PAAI
      #x1431	;CANADIAN SYLLABICS PI
      #x1432	;CANADIAN SYLLABICS PII
      #x1433	;CANADIAN SYLLABICS PO
      #x1434	;CANADIAN SYLLABICS POO
      #x1435	;CANADIAN SYLLABICS Y-CREE POO
      #x1436	;CANADIAN SYLLABICS CARRIER HEE
      #x1437	;CANADIAN SYLLABICS CARRIER HI
      #x1438	;CANADIAN SYLLABICS PA
      #x1439	;CANADIAN SYLLABICS PAA
      #x143A	;CANADIAN SYLLABICS PWE
      #x143B	;CANADIAN SYLLABICS WEST-CREE PWE
      #x143C	;CANADIAN SYLLABICS PWI
      #x143D	;CANADIAN SYLLABICS WEST-CREE PWI
      #x143E	;CANADIAN SYLLABICS PWII
      #x143F	;CANADIAN SYLLABICS WEST-CREE PWII
      #x1440	;CANADIAN SYLLABICS PWO
      #x1441	;CANADIAN SYLLABICS WEST-CREE PWO
      #x1442	;CANADIAN SYLLABICS PWOO
      #x1443	;CANADIAN SYLLABICS WEST-CREE PWOO
      #x1444	;CANADIAN SYLLABICS PWA
      #x1445	;CANADIAN SYLLABICS WEST-CREE PWA
      #x1446	;CANADIAN SYLLABICS PWAA
      #x1447	;CANADIAN SYLLABICS WEST-CREE PWAA
      #x1448	;CANADIAN SYLLABICS Y-CREE PWAA
      #x1449	;CANADIAN SYLLABICS P
      #x144A	;CANADIAN SYLLABICS WEST-CREE P
      #x144B	;CANADIAN SYLLABICS CARRIER H
      #x144C	;CANADIAN SYLLABICS TE
      #x144D	;CANADIAN SYLLABICS TAAI
      #x144E	;CANADIAN SYLLABICS TI
      #x144F	;CANADIAN SYLLABICS TII
      #x1450	;CANADIAN SYLLABICS TO
      #x1451	;CANADIAN SYLLABICS TOO
      #x1452	;CANADIAN SYLLABICS Y-CREE TOO
      #x1453	;CANADIAN SYLLABICS CARRIER DEE
      #x1454	;CANADIAN SYLLABICS CARRIER DI
      #x1455	;CANADIAN SYLLABICS TA
      #x1456	;CANADIAN SYLLABICS TAA
      #x1457	;CANADIAN SYLLABICS TWE
      #x1458	;CANADIAN SYLLABICS WEST-CREE TWE
      #x1459	;CANADIAN SYLLABICS TWI
      #x145A	;CANADIAN SYLLABICS WEST-CREE TWI
      #x145B	;CANADIAN SYLLABICS TWII
      #x145C	;CANADIAN SYLLABICS WEST-CREE TWII
      #x145D	;CANADIAN SYLLABICS TWO
      #x145E	;CANADIAN SYLLABICS WEST-CREE TWO
      #x145F	;CANADIAN SYLLABICS TWOO
      #x1460	;CANADIAN SYLLABICS WEST-CREE TWOO
      #x1461	;CANADIAN SYLLABICS TWA
      #x1462	;CANADIAN SYLLABICS WEST-CREE TWA
      #x1463	;CANADIAN SYLLABICS TWAA
      #x1464	;CANADIAN SYLLABICS WEST-CREE TWAA
      #x1465	;CANADIAN SYLLABICS NASKAPI TWAA
      #x1466	;CANADIAN SYLLABICS T
      #x1467	;CANADIAN SYLLABICS TTE
      #x1468	;CANADIAN SYLLABICS TTI
      #x1469	;CANADIAN SYLLABICS TTO
      #x146A	;CANADIAN SYLLABICS TTA
      #x146B	;CANADIAN SYLLABICS KE
      #x146C	;CANADIAN SYLLABICS KAAI
      #x146D	;CANADIAN SYLLABICS KI
      #x146E	;CANADIAN SYLLABICS KII
      #x146F	;CANADIAN SYLLABICS KO
      #x1470	;CANADIAN SYLLABICS KOO
      #x1471	;CANADIAN SYLLABICS Y-CREE KOO
      #x1472	;CANADIAN SYLLABICS KA
      #x1473	;CANADIAN SYLLABICS KAA
      #x1474	;CANADIAN SYLLABICS KWE
      #x1475	;CANADIAN SYLLABICS WEST-CREE KWE
      #x1476	;CANADIAN SYLLABICS KWI
      #x1477	;CANADIAN SYLLABICS WEST-CREE KWI
      #x1478	;CANADIAN SYLLABICS KWII
      #x1479	;CANADIAN SYLLABICS WEST-CREE KWII
      #x147A	;CANADIAN SYLLABICS KWO
      #x147B	;CANADIAN SYLLABICS WEST-CREE KWO
      #x147C	;CANADIAN SYLLABICS KWOO
      #x147D	;CANADIAN SYLLABICS WEST-CREE KWOO
      #x147E	;CANADIAN SYLLABICS KWA
      #x147F	;CANADIAN SYLLABICS WEST-CREE KWA
      #x1480	;CANADIAN SYLLABICS KWAA
      #x1481	;CANADIAN SYLLABICS WEST-CREE KWAA
      #x1482	;CANADIAN SYLLABICS NASKAPI KWAA
      #x1483	;CANADIAN SYLLABICS K
      #x1484	;CANADIAN SYLLABICS KW
      #x1485	;CANADIAN SYLLABICS SOUTH-SLAVEY KEH
      #x1486	;CANADIAN SYLLABICS SOUTH-SLAVEY KIH
      #x1487	;CANADIAN SYLLABICS SOUTH-SLAVEY KOH
      #x1488	;CANADIAN SYLLABICS SOUTH-SLAVEY KAH
      #x1489	;CANADIAN SYLLABICS CE
      #x148A	;CANADIAN SYLLABICS CAAI
      #x148B	;CANADIAN SYLLABICS CI
      #x148C	;CANADIAN SYLLABICS CII
      #x148D	;CANADIAN SYLLABICS CO
      #x148E	;CANADIAN SYLLABICS COO
      #x148F	;CANADIAN SYLLABICS Y-CREE COO
      #x1490	;CANADIAN SYLLABICS CA
      #x1491	;CANADIAN SYLLABICS CAA
      #x1492	;CANADIAN SYLLABICS CWE
      #x1493	;CANADIAN SYLLABICS WEST-CREE CWE
      #x1494	;CANADIAN SYLLABICS CWI
      #x1495	;CANADIAN SYLLABICS WEST-CREE CWI
      #x1496	;CANADIAN SYLLABICS CWII
      #x1497	;CANADIAN SYLLABICS WEST-CREE CWII
      #x1498	;CANADIAN SYLLABICS CWO
      #x1499	;CANADIAN SYLLABICS WEST-CREE CWO
      #x149A	;CANADIAN SYLLABICS CWOO
      #x149B	;CANADIAN SYLLABICS WEST-CREE CWOO
      #x149C	;CANADIAN SYLLABICS CWA
      #x149D	;CANADIAN SYLLABICS WEST-CREE CWA
      #x149E	;CANADIAN SYLLABICS CWAA
      #x149F	;CANADIAN SYLLABICS WEST-CREE CWAA
      #x14A0	;CANADIAN SYLLABICS NASKAPI CWAA
      #x14A1	;CANADIAN SYLLABICS C
      #x14A2	;CANADIAN SYLLABICS SAYISI TH
      #x14A3	;CANADIAN SYLLABICS ME
      #x14A4	;CANADIAN SYLLABICS MAAI
      #x14A5	;CANADIAN SYLLABICS MI
      #x14A6	;CANADIAN SYLLABICS MII
      #x14A7	;CANADIAN SYLLABICS MO
      #x14A8	;CANADIAN SYLLABICS MOO
      #x14A9	;CANADIAN SYLLABICS Y-CREE MOO
      #x14AA	;CANADIAN SYLLABICS MA
      #x14AB	;CANADIAN SYLLABICS MAA
      #x14AC	;CANADIAN SYLLABICS MWE
      #x14AD	;CANADIAN SYLLABICS WEST-CREE MWE
      #x14AE	;CANADIAN SYLLABICS MWI
      #x14AF	;CANADIAN SYLLABICS WEST-CREE MWI
      #x14B0	;CANADIAN SYLLABICS MWII
      #x14B1	;CANADIAN SYLLABICS WEST-CREE MWII
      #x14B2	;CANADIAN SYLLABICS MWO
      #x14B3	;CANADIAN SYLLABICS WEST-CREE MWO
      #x14B4	;CANADIAN SYLLABICS MWOO
      #x14B5	;CANADIAN SYLLABICS WEST-CREE MWOO
      #x14B6	;CANADIAN SYLLABICS MWA
      #x14B7	;CANADIAN SYLLABICS WEST-CREE MWA
      #x14B8	;CANADIAN SYLLABICS MWAA
      #x14B9	;CANADIAN SYLLABICS WEST-CREE MWAA
      #x14BA	;CANADIAN SYLLABICS NASKAPI MWAA
      #x14BB	;CANADIAN SYLLABICS M
      #x14BC	;CANADIAN SYLLABICS WEST-CREE M
      #x14BD	;CANADIAN SYLLABICS MH
      #x14BE	;CANADIAN SYLLABICS ATHAPASCAN M
      #x14BF	;CANADIAN SYLLABICS SAYISI M
      #x14C0	;CANADIAN SYLLABICS NE
      #x14C1	;CANADIAN SYLLABICS NAAI
      #x14C2	;CANADIAN SYLLABICS NI
      #x14C3	;CANADIAN SYLLABICS NII
      #x14C4	;CANADIAN SYLLABICS NO
      #x14C5	;CANADIAN SYLLABICS NOO
      #x14C6	;CANADIAN SYLLABICS Y-CREE NOO
      #x14C7	;CANADIAN SYLLABICS NA
      #x14C8	;CANADIAN SYLLABICS NAA
      #x14C9	;CANADIAN SYLLABICS NWE
      #x14CA	;CANADIAN SYLLABICS WEST-CREE NWE
      #x14CB	;CANADIAN SYLLABICS NWA
      #x14CC	;CANADIAN SYLLABICS WEST-CREE NWA
      #x14CD	;CANADIAN SYLLABICS NWAA
      #x14CE	;CANADIAN SYLLABICS WEST-CREE NWAA
      #x14CF	;CANADIAN SYLLABICS NASKAPI NWAA
      #x14D0	;CANADIAN SYLLABICS N
      #x14D1	;CANADIAN SYLLABICS CARRIER NG
      #x14D2	;CANADIAN SYLLABICS NH
      #x14D3	;CANADIAN SYLLABICS LE
      #x14D4	;CANADIAN SYLLABICS LAAI
      #x14D5	;CANADIAN SYLLABICS LI
      #x14D6	;CANADIAN SYLLABICS LII
      #x14D7	;CANADIAN SYLLABICS LO
      #x14D8	;CANADIAN SYLLABICS LOO
      #x14D9	;CANADIAN SYLLABICS Y-CREE LOO
      #x14DA	;CANADIAN SYLLABICS LA
      #x14DB	;CANADIAN SYLLABICS LAA
      #x14DC	;CANADIAN SYLLABICS LWE
      #x14DD	;CANADIAN SYLLABICS WEST-CREE LWE
      #x14DE	;CANADIAN SYLLABICS LWI
      #x14DF	;CANADIAN SYLLABICS WEST-CREE LWI
      #x14E0	;CANADIAN SYLLABICS LWII
      #x14E1	;CANADIAN SYLLABICS WEST-CREE LWII
      #x14E2	;CANADIAN SYLLABICS LWO
      #x14E3	;CANADIAN SYLLABICS WEST-CREE LWO
      #x14E4	;CANADIAN SYLLABICS LWOO
      #x14E5	;CANADIAN SYLLABICS WEST-CREE LWOO
      #x14E6	;CANADIAN SYLLABICS LWA
      #x14E7	;CANADIAN SYLLABICS WEST-CREE LWA
      #x14E8	;CANADIAN SYLLABICS LWAA
      #x14E9	;CANADIAN SYLLABICS WEST-CREE LWAA
      #x14EA	;CANADIAN SYLLABICS L
      #x14EB	;CANADIAN SYLLABICS WEST-CREE L
      #x14EC	;CANADIAN SYLLABICS MEDIAL L
      #x14ED	;CANADIAN SYLLABICS SE
      #x14EE	;CANADIAN SYLLABICS SAAI
      #x14EF	;CANADIAN SYLLABICS SI
      #x14F0	;CANADIAN SYLLABICS SII
      #x14F1	;CANADIAN SYLLABICS SO
      #x14F2	;CANADIAN SYLLABICS SOO
      #x14F3	;CANADIAN SYLLABICS Y-CREE SOO
      #x14F4	;CANADIAN SYLLABICS SA
      #x14F5	;CANADIAN SYLLABICS SAA
      #x14F6	;CANADIAN SYLLABICS SWE
      #x14F7	;CANADIAN SYLLABICS WEST-CREE SWE
      #x14F8	;CANADIAN SYLLABICS SWI
      #x14F9	;CANADIAN SYLLABICS WEST-CREE SWI
      #x14FA	;CANADIAN SYLLABICS SWII
      #x14FB	;CANADIAN SYLLABICS WEST-CREE SWII
      #x14FC	;CANADIAN SYLLABICS SWO
      #x14FD	;CANADIAN SYLLABICS WEST-CREE SWO
      #x14FE	;CANADIAN SYLLABICS SWOO
      #x14FF	;CANADIAN SYLLABICS WEST-CREE SWOO
      #x1500	;CANADIAN SYLLABICS SWA
      #x1501	;CANADIAN SYLLABICS WEST-CREE SWA
      #x1502	;CANADIAN SYLLABICS SWAA
      #x1503	;CANADIAN SYLLABICS WEST-CREE SWAA
      #x1504	;CANADIAN SYLLABICS NASKAPI SWAA
      #x1505	;CANADIAN SYLLABICS S
      #x1506	;CANADIAN SYLLABICS ATHAPASCAN S
      #x1507	;CANADIAN SYLLABICS SW
      #x1508	;CANADIAN SYLLABICS BLACKFOOT S
      #x1509	;CANADIAN SYLLABICS MOOSE-CREE SK
      #x150A	;CANADIAN SYLLABICS NASKAPI SKW
      #x150B	;CANADIAN SYLLABICS NASKAPI S-W
      #x150C	;CANADIAN SYLLABICS NASKAPI SPWA
      #x150D	;CANADIAN SYLLABICS NASKAPI STWA
      #x150E	;CANADIAN SYLLABICS NASKAPI SKWA
      #x150F	;CANADIAN SYLLABICS NASKAPI SCWA
      #x1510	;CANADIAN SYLLABICS SHE
      #x1511	;CANADIAN SYLLABICS SHI
      #x1512	;CANADIAN SYLLABICS SHII
      #x1513	;CANADIAN SYLLABICS SHO
      #x1514	;CANADIAN SYLLABICS SHOO
      #x1515	;CANADIAN SYLLABICS SHA
      #x1516	;CANADIAN SYLLABICS SHAA
      #x1517	;CANADIAN SYLLABICS SHWE
      #x1518	;CANADIAN SYLLABICS WEST-CREE SHWE
      #x1519	;CANADIAN SYLLABICS SHWI
      #x151A	;CANADIAN SYLLABICS WEST-CREE SHWI
      #x151B	;CANADIAN SYLLABICS SHWII
      #x151C	;CANADIAN SYLLABICS WEST-CREE SHWII
      #x151D	;CANADIAN SYLLABICS SHWO
      #x151E	;CANADIAN SYLLABICS WEST-CREE SHWO
      #x151F	;CANADIAN SYLLABICS SHWOO
      #x1520	;CANADIAN SYLLABICS WEST-CREE SHWOO
      #x1521	;CANADIAN SYLLABICS SHWA
      #x1522	;CANADIAN SYLLABICS WEST-CREE SHWA
      #x1523	;CANADIAN SYLLABICS SHWAA
      #x1524	;CANADIAN SYLLABICS WEST-CREE SHWAA
      #x1525	;CANADIAN SYLLABICS SH
      #x1526	;CANADIAN SYLLABICS YE
      #x1527	;CANADIAN SYLLABICS YAAI
      #x1528	;CANADIAN SYLLABICS YI
      #x1529	;CANADIAN SYLLABICS YII
      #x152A	;CANADIAN SYLLABICS YO
      #x152B	;CANADIAN SYLLABICS YOO
      #x152C	;CANADIAN SYLLABICS Y-CREE YOO
      #x152D	;CANADIAN SYLLABICS YA
      #x152E	;CANADIAN SYLLABICS YAA
      #x152F	;CANADIAN SYLLABICS YWE
      #x1530	;CANADIAN SYLLABICS WEST-CREE YWE
      #x1531	;CANADIAN SYLLABICS YWI
      #x1532	;CANADIAN SYLLABICS WEST-CREE YWI
      #x1533	;CANADIAN SYLLABICS YWII
      #x1534	;CANADIAN SYLLABICS WEST-CREE YWII
      #x1535	;CANADIAN SYLLABICS YWO
      #x1536	;CANADIAN SYLLABICS WEST-CREE YWO
      #x1537	;CANADIAN SYLLABICS YWOO
      #x1538	;CANADIAN SYLLABICS WEST-CREE YWOO
      #x1539	;CANADIAN SYLLABICS YWA
      #x153A	;CANADIAN SYLLABICS WEST-CREE YWA
      #x153B	;CANADIAN SYLLABICS YWAA
      #x153C	;CANADIAN SYLLABICS WEST-CREE YWAA
      #x153D	;CANADIAN SYLLABICS NASKAPI YWAA
      #x153E	;CANADIAN SYLLABICS Y
      #x153F	;CANADIAN SYLLABICS BIBLE-CREE Y
      #x1540	;CANADIAN SYLLABICS WEST-CREE Y
      #x1541	;CANADIAN SYLLABICS SAYISI YI
      #x1542	;CANADIAN SYLLABICS RE
      #x1543	;CANADIAN SYLLABICS R-CREE RE
      #x1544	;CANADIAN SYLLABICS WEST-CREE LE
      #x1545	;CANADIAN SYLLABICS RAAI
      #x1546	;CANADIAN SYLLABICS RI
      #x1547	;CANADIAN SYLLABICS RII
      #x1548	;CANADIAN SYLLABICS RO
      #x1549	;CANADIAN SYLLABICS ROO
      #x154A	;CANADIAN SYLLABICS WEST-CREE LO
      #x154B	;CANADIAN SYLLABICS RA
      #x154C	;CANADIAN SYLLABICS RAA
      #x154D	;CANADIAN SYLLABICS WEST-CREE LA
      #x154E	;CANADIAN SYLLABICS RWAA
      #x154F	;CANADIAN SYLLABICS WEST-CREE RWAA
      #x1550	;CANADIAN SYLLABICS R
      #x1551	;CANADIAN SYLLABICS WEST-CREE R
      #x1552	;CANADIAN SYLLABICS MEDIAL R
      #x1553	;CANADIAN SYLLABICS FE
      #x1554	;CANADIAN SYLLABICS FAAI
      #x1555	;CANADIAN SYLLABICS FI
      #x1556	;CANADIAN SYLLABICS FII
      #x1557	;CANADIAN SYLLABICS FO
      #x1558	;CANADIAN SYLLABICS FOO
      #x1559	;CANADIAN SYLLABICS FA
      #x155A	;CANADIAN SYLLABICS FAA
      #x155B	;CANADIAN SYLLABICS FWAA
      #x155C	;CANADIAN SYLLABICS WEST-CREE FWAA
      #x155D	;CANADIAN SYLLABICS F
      #x155E	;CANADIAN SYLLABICS THE
      #x155F	;CANADIAN SYLLABICS N-CREE THE
      #x1560	;CANADIAN SYLLABICS THI
      #x1561	;CANADIAN SYLLABICS N-CREE THI
      #x1562	;CANADIAN SYLLABICS THII
      #x1563	;CANADIAN SYLLABICS N-CREE THII
      #x1564	;CANADIAN SYLLABICS THO
      #x1565	;CANADIAN SYLLABICS THOO
      #x1566	;CANADIAN SYLLABICS THA
      #x1567	;CANADIAN SYLLABICS THAA
      #x1568	;CANADIAN SYLLABICS THWAA
      #x1569	;CANADIAN SYLLABICS WEST-CREE THWAA
      #x156A	;CANADIAN SYLLABICS TH
      #x156B	;CANADIAN SYLLABICS TTHE
      #x156C	;CANADIAN SYLLABICS TTHI
      #x156D	;CANADIAN SYLLABICS TTHO
      #x156E	;CANADIAN SYLLABICS TTHA
      #x156F	;CANADIAN SYLLABICS TTH
      #x1570	;CANADIAN SYLLABICS TYE
      #x1571	;CANADIAN SYLLABICS TYI
      #x1572	;CANADIAN SYLLABICS TYO
      #x1573	;CANADIAN SYLLABICS TYA
      #x1574	;CANADIAN SYLLABICS NUNAVIK HE
      #x1575	;CANADIAN SYLLABICS NUNAVIK HI
      #x1576	;CANADIAN SYLLABICS NUNAVIK HII
      #x1577	;CANADIAN SYLLABICS NUNAVIK HO
      #x1578	;CANADIAN SYLLABICS NUNAVIK HOO
      #x1579	;CANADIAN SYLLABICS NUNAVIK HA
      #x157A	;CANADIAN SYLLABICS NUNAVIK HAA
      #x157B	;CANADIAN SYLLABICS NUNAVIK H
      #x157C	;CANADIAN SYLLABICS NUNAVUT H
      #x157D	;CANADIAN SYLLABICS HK
      #x157E	;CANADIAN SYLLABICS QAAI
      #x157F	;CANADIAN SYLLABICS QI
      #x1580	;CANADIAN SYLLABICS QII
      #x1581	;CANADIAN SYLLABICS QO
      #x1582	;CANADIAN SYLLABICS QOO
      #x1583	;CANADIAN SYLLABICS QA
      #x1584	;CANADIAN SYLLABICS QAA
      #x1585	;CANADIAN SYLLABICS Q
      #x1586	;CANADIAN SYLLABICS TLHE
      #x1587	;CANADIAN SYLLABICS TLHI
      #x1588	;CANADIAN SYLLABICS TLHO
      #x1589	;CANADIAN SYLLABICS TLHA
      #x158A	;CANADIAN SYLLABICS WEST-CREE RE
      #x158B	;CANADIAN SYLLABICS WEST-CREE RI
      #x158C	;CANADIAN SYLLABICS WEST-CREE RO
      #x158D	;CANADIAN SYLLABICS WEST-CREE RA
      #x158E	;CANADIAN SYLLABICS NGAAI
      #x158F	;CANADIAN SYLLABICS NGI
      #x1590	;CANADIAN SYLLABICS NGII
      #x1591	;CANADIAN SYLLABICS NGO
      #x1592	;CANADIAN SYLLABICS NGOO
      #x1593	;CANADIAN SYLLABICS NGA
      #x1594	;CANADIAN SYLLABICS NGAA
      #x1595	;CANADIAN SYLLABICS NG
      #x1596	;CANADIAN SYLLABICS NNG
      #x1597	;CANADIAN SYLLABICS SAYISI SHE
      #x1598	;CANADIAN SYLLABICS SAYISI SHI
      #x1599	;CANADIAN SYLLABICS SAYISI SHO
      #x159A	;CANADIAN SYLLABICS SAYISI SHA
      #x159B	;CANADIAN SYLLABICS WOODS-CREE THE
      #x159C	;CANADIAN SYLLABICS WOODS-CREE THI
      #x159D	;CANADIAN SYLLABICS WOODS-CREE THO
      #x159E	;CANADIAN SYLLABICS WOODS-CREE THA
      #x159F	;CANADIAN SYLLABICS WOODS-CREE TH
      #x15A0	;CANADIAN SYLLABICS LHI
      #x15A1	;CANADIAN SYLLABICS LHII
      #x15A2	;CANADIAN SYLLABICS LHO
      #x15A3	;CANADIAN SYLLABICS LHOO
      #x15A4	;CANADIAN SYLLABICS LHA
      #x15A5	;CANADIAN SYLLABICS LHAA
      #x15A6	;CANADIAN SYLLABICS LH
      #x15A7	;CANADIAN SYLLABICS TH-CREE THE
      #x15A8	;CANADIAN SYLLABICS TH-CREE THI
      #x15A9	;CANADIAN SYLLABICS TH-CREE THII
      #x15AA	;CANADIAN SYLLABICS TH-CREE THO
      #x15AB	;CANADIAN SYLLABICS TH-CREE THOO
      #x15AC	;CANADIAN SYLLABICS TH-CREE THA
      #x15AD	;CANADIAN SYLLABICS TH-CREE THAA
      #x15AE	;CANADIAN SYLLABICS TH-CREE TH
      #x15AF	;CANADIAN SYLLABICS AIVILIK B
      #x15B0	;CANADIAN SYLLABICS BLACKFOOT E
      #x15B1	;CANADIAN SYLLABICS BLACKFOOT I
      #x15B2	;CANADIAN SYLLABICS BLACKFOOT O
      #x15B3	;CANADIAN SYLLABICS BLACKFOOT A
      #x15B4	;CANADIAN SYLLABICS BLACKFOOT WE
      #x15B5	;CANADIAN SYLLABICS BLACKFOOT WI
      #x15B6	;CANADIAN SYLLABICS BLACKFOOT WO
      #x15B7	;CANADIAN SYLLABICS BLACKFOOT WA
      #x15B8	;CANADIAN SYLLABICS BLACKFOOT NE
      #x15B9	;CANADIAN SYLLABICS BLACKFOOT NI
      #x15BA	;CANADIAN SYLLABICS BLACKFOOT NO
      #x15BB	;CANADIAN SYLLABICS BLACKFOOT NA
      #x15BC	;CANADIAN SYLLABICS BLACKFOOT KE
      #x15BD	;CANADIAN SYLLABICS BLACKFOOT KI
      #x15BE	;CANADIAN SYLLABICS BLACKFOOT KO
      #x15BF	;CANADIAN SYLLABICS BLACKFOOT KA
      #x15C0	;CANADIAN SYLLABICS SAYISI HE
      #x15C1	;CANADIAN SYLLABICS SAYISI HI
      #x15C2	;CANADIAN SYLLABICS SAYISI HO
      #x15C3	;CANADIAN SYLLABICS SAYISI HA
      #x15C4	;CANADIAN SYLLABICS CARRIER GHU
      #x15C5	;CANADIAN SYLLABICS CARRIER GHO
      #x15C6	;CANADIAN SYLLABICS CARRIER GHE
      #x15C7	;CANADIAN SYLLABICS CARRIER GHEE
      #x15C8	;CANADIAN SYLLABICS CARRIER GHI
      #x15C9	;CANADIAN SYLLABICS CARRIER GHA
      #x15CA	;CANADIAN SYLLABICS CARRIER RU
      #x15CB	;CANADIAN SYLLABICS CARRIER RO
      #x15CC	;CANADIAN SYLLABICS CARRIER RE
      #x15CD	;CANADIAN SYLLABICS CARRIER REE
      #x15CE	;CANADIAN SYLLABICS CARRIER RI
      #x15CF	;CANADIAN SYLLABICS CARRIER RA
      #x15D0	;CANADIAN SYLLABICS CARRIER WU
      #x15D1	;CANADIAN SYLLABICS CARRIER WO
      #x15D2	;CANADIAN SYLLABICS CARRIER WE
      #x15D3	;CANADIAN SYLLABICS CARRIER WEE
      #x15D4	;CANADIAN SYLLABICS CARRIER WI
      #x15D5	;CANADIAN SYLLABICS CARRIER WA
      #x15D6	;CANADIAN SYLLABICS CARRIER HWU
      #x15D7	;CANADIAN SYLLABICS CARRIER HWO
      #x15D8	;CANADIAN SYLLABICS CARRIER HWE
      #x15D9	;CANADIAN SYLLABICS CARRIER HWEE
      #x15DA	;CANADIAN SYLLABICS CARRIER HWI
      #x15DB	;CANADIAN SYLLABICS CARRIER HWA
      #x15DC	;CANADIAN SYLLABICS CARRIER THU
      #x15DD	;CANADIAN SYLLABICS CARRIER THO
      #x15DE	;CANADIAN SYLLABICS CARRIER THE
      #x15DF	;CANADIAN SYLLABICS CARRIER THEE
      #x15E0	;CANADIAN SYLLABICS CARRIER THI
      #x15E1	;CANADIAN SYLLABICS CARRIER THA
      #x15E2	;CANADIAN SYLLABICS CARRIER TTU
      #x15E3	;CANADIAN SYLLABICS CARRIER TTO
      #x15E4	;CANADIAN SYLLABICS CARRIER TTE
      #x15E5	;CANADIAN SYLLABICS CARRIER TTEE
      #x15E6	;CANADIAN SYLLABICS CARRIER TTI
      #x15E7	;CANADIAN SYLLABICS CARRIER TTA
      #x15E8	;CANADIAN SYLLABICS CARRIER PU
      #x15E9	;CANADIAN SYLLABICS CARRIER PO
      #x15EA	;CANADIAN SYLLABICS CARRIER PE
      #x15EB	;CANADIAN SYLLABICS CARRIER PEE
      #x15EC	;CANADIAN SYLLABICS CARRIER PI
      #x15ED	;CANADIAN SYLLABICS CARRIER PA
      #x15EE	;CANADIAN SYLLABICS CARRIER P
      #x15EF	;CANADIAN SYLLABICS CARRIER GU
      #x15F0	;CANADIAN SYLLABICS CARRIER GO
      #x15F1	;CANADIAN SYLLABICS CARRIER GE
      #x15F2	;CANADIAN SYLLABICS CARRIER GEE
      #x15F3	;CANADIAN SYLLABICS CARRIER GI
      #x15F4	;CANADIAN SYLLABICS CARRIER GA
      #x15F5	;CANADIAN SYLLABICS CARRIER KHU
      #x15F6	;CANADIAN SYLLABICS CARRIER KHO
      #x15F7	;CANADIAN SYLLABICS CARRIER KHE
      #x15F8	;CANADIAN SYLLABICS CARRIER KHEE
      #x15F9	;CANADIAN SYLLABICS CARRIER KHI
      #x15FA	;CANADIAN SYLLABICS CARRIER KHA
      #x15FB	;CANADIAN SYLLABICS CARRIER KKU
      #x15FC	;CANADIAN SYLLABICS CARRIER KKO
      #x15FD	;CANADIAN SYLLABICS CARRIER KKE
      #x15FE	;CANADIAN SYLLABICS CARRIER KKEE
      #x15FF	;CANADIAN SYLLABICS CARRIER KKI
      #x1600	;CANADIAN SYLLABICS CARRIER KKA
      #x1601	;CANADIAN SYLLABICS CARRIER KK
      #x1602	;CANADIAN SYLLABICS CARRIER NU
      #x1603	;CANADIAN SYLLABICS CARRIER NO
      #x1604	;CANADIAN SYLLABICS CARRIER NE
      #x1605	;CANADIAN SYLLABICS CARRIER NEE
      #x1606	;CANADIAN SYLLABICS CARRIER NI
      #x1607	;CANADIAN SYLLABICS CARRIER NA
      #x1608	;CANADIAN SYLLABICS CARRIER MU
      #x1609	;CANADIAN SYLLABICS CARRIER MO
      #x160A	;CANADIAN SYLLABICS CARRIER ME
      #x160B	;CANADIAN SYLLABICS CARRIER MEE
      #x160C	;CANADIAN SYLLABICS CARRIER MI
      #x160D	;CANADIAN SYLLABICS CARRIER MA
      #x160E	;CANADIAN SYLLABICS CARRIER YU
      #x160F	;CANADIAN SYLLABICS CARRIER YO
      #x1610	;CANADIAN SYLLABICS CARRIER YE
      #x1611	;CANADIAN SYLLABICS CARRIER YEE
      #x1612	;CANADIAN SYLLABICS CARRIER YI
      #x1613	;CANADIAN SYLLABICS CARRIER YA
      #x1614	;CANADIAN SYLLABICS CARRIER JU
      #x1615	;CANADIAN SYLLABICS SAYISI JU
      #x1616	;CANADIAN SYLLABICS CARRIER JO
      #x1617	;CANADIAN SYLLABICS CARRIER JE
      #x1618	;CANADIAN SYLLABICS CARRIER JEE
      #x1619	;CANADIAN SYLLABICS CARRIER JI
      #x161A	;CANADIAN SYLLABICS SAYISI JI
      #x161B	;CANADIAN SYLLABICS CARRIER JA
      #x161C	;CANADIAN SYLLABICS CARRIER JJU
      #x161D	;CANADIAN SYLLABICS CARRIER JJO
      #x161E	;CANADIAN SYLLABICS CARRIER JJE
      #x161F	;CANADIAN SYLLABICS CARRIER JJEE
      #x1620	;CANADIAN SYLLABICS CARRIER JJI
      #x1621	;CANADIAN SYLLABICS CARRIER JJA
      #x1622	;CANADIAN SYLLABICS CARRIER LU
      #x1623	;CANADIAN SYLLABICS CARRIER LO
      #x1624	;CANADIAN SYLLABICS CARRIER LE
      #x1625	;CANADIAN SYLLABICS CARRIER LEE
      #x1626	;CANADIAN SYLLABICS CARRIER LI
      #x1627	;CANADIAN SYLLABICS CARRIER LA
      #x1628	;CANADIAN SYLLABICS CARRIER DLU
      #x1629	;CANADIAN SYLLABICS CARRIER DLO
      #x162A	;CANADIAN SYLLABICS CARRIER DLE
      #x162B	;CANADIAN SYLLABICS CARRIER DLEE
      #x162C	;CANADIAN SYLLABICS CARRIER DLI
      #x162D	;CANADIAN SYLLABICS CARRIER DLA
      #x162E	;CANADIAN SYLLABICS CARRIER LHU
      #x162F	;CANADIAN SYLLABICS CARRIER LHO
      #x1630	;CANADIAN SYLLABICS CARRIER LHE
      #x1631	;CANADIAN SYLLABICS CARRIER LHEE
      #x1632	;CANADIAN SYLLABICS CARRIER LHI
      #x1633	;CANADIAN SYLLABICS CARRIER LHA
      #x1634	;CANADIAN SYLLABICS CARRIER TLHU
      #x1635	;CANADIAN SYLLABICS CARRIER TLHO
      #x1636	;CANADIAN SYLLABICS CARRIER TLHE
      #x1637	;CANADIAN SYLLABICS CARRIER TLHEE
      #x1638	;CANADIAN SYLLABICS CARRIER TLHI
      #x1639	;CANADIAN SYLLABICS CARRIER TLHA
      #x163A	;CANADIAN SYLLABICS CARRIER TLU
      #x163B	;CANADIAN SYLLABICS CARRIER TLO
      #x163C	;CANADIAN SYLLABICS CARRIER TLE
      #x163D	;CANADIAN SYLLABICS CARRIER TLEE
      #x163E	;CANADIAN SYLLABICS CARRIER TLI
      #x163F	;CANADIAN SYLLABICS CARRIER TLA
      #x1640	;CANADIAN SYLLABICS CARRIER ZU
      #x1641	;CANADIAN SYLLABICS CARRIER ZO
      #x1642	;CANADIAN SYLLABICS CARRIER ZE
      #x1643	;CANADIAN SYLLABICS CARRIER ZEE
      #x1644	;CANADIAN SYLLABICS CARRIER ZI
      #x1645	;CANADIAN SYLLABICS CARRIER ZA
      #x1646	;CANADIAN SYLLABICS CARRIER Z
      #x1647	;CANADIAN SYLLABICS CARRIER INITIAL Z
      #x1648	;CANADIAN SYLLABICS CARRIER DZU
      #x1649	;CANADIAN SYLLABICS CARRIER DZO
      #x164A	;CANADIAN SYLLABICS CARRIER DZE
      #x164B	;CANADIAN SYLLABICS CARRIER DZEE
      #x164C	;CANADIAN SYLLABICS CARRIER DZI
      #x164D	;CANADIAN SYLLABICS CARRIER DZA
      #x164E	;CANADIAN SYLLABICS CARRIER SU
      #x164F	;CANADIAN SYLLABICS CARRIER SO
      #x1650	;CANADIAN SYLLABICS CARRIER SE
      #x1651	;CANADIAN SYLLABICS CARRIER SEE
      #x1652	;CANADIAN SYLLABICS CARRIER SI
      #x1653	;CANADIAN SYLLABICS CARRIER SA
      #x1654	;CANADIAN SYLLABICS CARRIER SHU
      #x1655	;CANADIAN SYLLABICS CARRIER SHO
      #x1656	;CANADIAN SYLLABICS CARRIER SHE
      #x1657	;CANADIAN SYLLABICS CARRIER SHEE
      #x1658	;CANADIAN SYLLABICS CARRIER SHI
      #x1659	;CANADIAN SYLLABICS CARRIER SHA
      #x165A	;CANADIAN SYLLABICS CARRIER SH
      #x165B	;CANADIAN SYLLABICS CARRIER TSU
      #x165C	;CANADIAN SYLLABICS CARRIER TSO
      #x165D	;CANADIAN SYLLABICS CARRIER TSE
      #x165E	;CANADIAN SYLLABICS CARRIER TSEE
      #x165F	;CANADIAN SYLLABICS CARRIER TSI
      #x1660	;CANADIAN SYLLABICS CARRIER TSA
      #x1661	;CANADIAN SYLLABICS CARRIER CHU
      #x1662	;CANADIAN SYLLABICS CARRIER CHO
      #x1663	;CANADIAN SYLLABICS CARRIER CHE
      #x1664	;CANADIAN SYLLABICS CARRIER CHEE
      #x1665	;CANADIAN SYLLABICS CARRIER CHI
      #x1666	;CANADIAN SYLLABICS CARRIER CHA
      #x1667	;CANADIAN SYLLABICS CARRIER TTSU
      #x1668	;CANADIAN SYLLABICS CARRIER TTSO
      #x1669	;CANADIAN SYLLABICS CARRIER TTSE
      #x166A	;CANADIAN SYLLABICS CARRIER TTSEE
      #x166B	;CANADIAN SYLLABICS CARRIER TTSI
      #x166C	;CANADIAN SYLLABICS CARRIER TTSA
      #x166D	;CANADIAN SYLLABICS CHI SIGN
      #x166E	;CANADIAN SYLLABICS FULL STOP
      #x166F	;CANADIAN SYLLABICS QAI
      #x1670	;CANADIAN SYLLABICS NGAI
      #x1671	;CANADIAN SYLLABICS NNGI
      #x1672	;CANADIAN SYLLABICS NNGII
      #x1673	;CANADIAN SYLLABICS NNGO
      #x1674	;CANADIAN SYLLABICS NNGOO
      #x1675	;CANADIAN SYLLABICS NNGA
      #x1676	;CANADIAN SYLLABICS NNGAA
      #x1680	;OGHAM SPACE MARK
      #x1681	;OGHAM LETTER BEITH
      #x1682	;OGHAM LETTER LUIS
      #x1683	;OGHAM LETTER FEARN
      #x1684	;OGHAM LETTER SAIL
      #x1685	;OGHAM LETTER NION
      #x1686	;OGHAM LETTER UATH
      #x1687	;OGHAM LETTER DAIR
      #x1688	;OGHAM LETTER TINNE
      #x1689	;OGHAM LETTER COLL
      #x168A	;OGHAM LETTER CEIRT
      #x168B	;OGHAM LETTER MUIN
      #x168C	;OGHAM LETTER GORT
      #x168D	;OGHAM LETTER NGEADAL
      #x168E	;OGHAM LETTER STRAIF
      #x168F	;OGHAM LETTER RUIS
      #x1690	;OGHAM LETTER AILM
      #x1691	;OGHAM LETTER ONN
      #x1692	;OGHAM LETTER UR
      #x1693	;OGHAM LETTER EADHADH
      #x1694	;OGHAM LETTER IODHADH
      #x1695	;OGHAM LETTER EABHADH
      #x1696	;OGHAM LETTER OR
      #x1697	;OGHAM LETTER UILLEANN
      #x1698	;OGHAM LETTER IFIN
      #x1699	;OGHAM LETTER EAMHANCHOLL
      #x169A	;OGHAM LETTER PEITH
      #x169B	;OGHAM FEATHER MARK
      #x169C	;OGHAM REVERSED FEATHER MARK
      #x16A0	;RUNIC LETTER FEHU FEOH FE F
      #x16A1	;RUNIC LETTER V
      #x16A2	;RUNIC LETTER URUZ UR U
      #x16A3	;RUNIC LETTER YR
      #x16A4	;RUNIC LETTER Y
      #x16A5	;RUNIC LETTER W
      #x16A6	;RUNIC LETTER THURISAZ THURS THORN
      #x16A7	;RUNIC LETTER ETH
      #x16A8	;RUNIC LETTER ANSUZ A
      #x16A9	;RUNIC LETTER OS O
      #x16AA	;RUNIC LETTER AC A
      #x16AB	;RUNIC LETTER AESC
      #x16AC	;RUNIC LETTER LONG-BRANCH-OSS O
      #x16AD	;RUNIC LETTER SHORT-TWIG-OSS O
      #x16AE	;RUNIC LETTER O
      #x16AF	;RUNIC LETTER OE
      #x16B0	;RUNIC LETTER ON
      #x16B1	;RUNIC LETTER RAIDO RAD REID R
      #x16B2	;RUNIC LETTER KAUNA
      #x16B3	;RUNIC LETTER CEN
      #x16B4	;RUNIC LETTER KAUN K
      #x16B5	;RUNIC LETTER G
      #x16B6	;RUNIC LETTER ENG
      #x16B7	;RUNIC LETTER GEBO GYFU G
      #x16B8	;RUNIC LETTER GAR
      #x16B9	;RUNIC LETTER WUNJO WYNN W
      #x16BA	;RUNIC LETTER HAGLAZ H
      #x16BB	;RUNIC LETTER HAEGL H
      #x16BC	;RUNIC LETTER LONG-BRANCH-HAGALL H
      #x16BD	;RUNIC LETTER SHORT-TWIG-HAGALL H
      #x16BE	;RUNIC LETTER NAUDIZ NYD NAUD N
      #x16BF	;RUNIC LETTER SHORT-TWIG-NAUD N
      #x16C0	;RUNIC LETTER DOTTED-N
      #x16C1	;RUNIC LETTER ISAZ IS ISS I
      #x16C2	;RUNIC LETTER E
      #x16C3	;RUNIC LETTER JERAN J
      #x16C4	;RUNIC LETTER GER
      #x16C5	;RUNIC LETTER LONG-BRANCH-AR AE
      #x16C6	;RUNIC LETTER SHORT-TWIG-AR A
      #x16C7	;RUNIC LETTER IWAZ EOH
      #x16C8	;RUNIC LETTER PERTHO PEORTH P
      #x16C9	;RUNIC LETTER ALGIZ EOLHX
      #x16CA	;RUNIC LETTER SOWILO S
      #x16CB	;RUNIC LETTER SIGEL LONG-BRANCH-SOL S
      #x16CC	;RUNIC LETTER SHORT-TWIG-SOL S
      #x16CD	;RUNIC LETTER C
      #x16CE	;RUNIC LETTER Z
      #x16CF	;RUNIC LETTER TIWAZ TIR TYR T
      #x16D0	;RUNIC LETTER SHORT-TWIG-TYR T
      #x16D1	;RUNIC LETTER D
      #x16D2	;RUNIC LETTER BERKANAN BEORC BJARKAN B
      #x16D3	;RUNIC LETTER SHORT-TWIG-BJARKAN B
      #x16D4	;RUNIC LETTER DOTTED-P
      #x16D5	;RUNIC LETTER OPEN-P
      #x16D6	;RUNIC LETTER EHWAZ EH E
      #x16D7	;RUNIC LETTER MANNAZ MAN M
      #x16D8	;RUNIC LETTER LONG-BRANCH-MADR M
      #x16D9	;RUNIC LETTER SHORT-TWIG-MADR M
      #x16DA	;RUNIC LETTER LAUKAZ LAGU LOGR L
      #x16DB	;RUNIC LETTER DOTTED-L
      #x16DC	;RUNIC LETTER INGWAZ
      #x16DD	;RUNIC LETTER ING
      #x16DE	;RUNIC LETTER DAGAZ DAEG D
      #x16DF	;RUNIC LETTER OTHALAN ETHEL O
      #x16E0	;RUNIC LETTER EAR
      #x16E1	;RUNIC LETTER IOR
      #x16E2	;RUNIC LETTER CWEORTH
      #x16E3	;RUNIC LETTER CALC
      #x16E4	;RUNIC LETTER CEALC
      #x16E5	;RUNIC LETTER STAN
      #x16E6	;RUNIC LETTER LONG-BRANCH-YR
      #x16E7	;RUNIC LETTER SHORT-TWIG-YR
      #x16E8	;RUNIC LETTER ICELANDIC-YR
      #x16E9	;RUNIC LETTER Q
      #x16EA	;RUNIC LETTER X
      #x16EB	;RUNIC SINGLE PUNCTUATION
      #x16EC	;RUNIC MULTIPLE PUNCTUATION
      #x16ED	;RUNIC CROSS PUNCTUATION
      #x16EE	;RUNIC ARLAUG SYMBOL
      #x16EF	;RUNIC TVIMADUR SYMBOL
      #x16F0	;RUNIC BELGTHOR SYMBOL
      #x1700	;TAGALOG LETTER A
      #x1701	;TAGALOG LETTER I
      #x1702	;TAGALOG LETTER U
      #x1703	;TAGALOG LETTER KA
      #x1704	;TAGALOG LETTER GA
      #x1705	;TAGALOG LETTER NGA
      #x1706	;TAGALOG LETTER TA
      #x1707	;TAGALOG LETTER DA
      #x1708	;TAGALOG LETTER NA
      #x1709	;TAGALOG LETTER PA
      #x170A	;TAGALOG LETTER BA
      #x170B	;TAGALOG LETTER MA
      #x170C	;TAGALOG LETTER YA
      #x170E	;TAGALOG LETTER LA
      #x170F	;TAGALOG LETTER WA
      #x1710	;TAGALOG LETTER SA
      #x1711	;TAGALOG LETTER HA
      #x1712	;TAGALOG VOWEL SIGN I
      #x1713	;TAGALOG VOWEL SIGN U
      #x1714	;TAGALOG SIGN VIRAMA
      #x1720	;HANUNOO LETTER A
      #x1721	;HANUNOO LETTER I
      #x1722	;HANUNOO LETTER U
      #x1723	;HANUNOO LETTER KA
      #x1724	;HANUNOO LETTER GA
      #x1725	;HANUNOO LETTER NGA
      #x1726	;HANUNOO LETTER TA
      #x1727	;HANUNOO LETTER DA
      #x1728	;HANUNOO LETTER NA
      #x1729	;HANUNOO LETTER PA
      #x172A	;HANUNOO LETTER BA
      #x172B	;HANUNOO LETTER MA
      #x172C	;HANUNOO LETTER YA
      #x172D	;HANUNOO LETTER RA
      #x172E	;HANUNOO LETTER LA
      #x172F	;HANUNOO LETTER WA
      #x1730	;HANUNOO LETTER SA
      #x1731	;HANUNOO LETTER HA
      #x1732	;HANUNOO VOWEL SIGN I
      #x1733	;HANUNOO VOWEL SIGN U
      #x1734	;HANUNOO SIGN PAMUDPOD
      #x1735	;PHILIPPINE SINGLE PUNCTUATION
      #x1736	;PHILIPPINE DOUBLE PUNCTUATION
      #x1740	;BUHID LETTER A
      #x1741	;BUHID LETTER I
      #x1742	;BUHID LETTER U
      #x1743	;BUHID LETTER KA
      #x1744	;BUHID LETTER GA
      #x1745	;BUHID LETTER NGA
      #x1746	;BUHID LETTER TA
      #x1747	;BUHID LETTER DA
      #x1748	;BUHID LETTER NA
      #x1749	;BUHID LETTER PA
      #x174A	;BUHID LETTER BA
      #x174B	;BUHID LETTER MA
      #x174C	;BUHID LETTER YA
      #x174D	;BUHID LETTER RA
      #x174E	;BUHID LETTER LA
      #x174F	;BUHID LETTER WA
      #x1750	;BUHID LETTER SA
      #x1751	;BUHID LETTER HA
      #x1752	;BUHID VOWEL SIGN I
      #x1753	;BUHID VOWEL SIGN U
      #x1760	;TAGBANWA LETTER A
      #x1761	;TAGBANWA LETTER I
      #x1762	;TAGBANWA LETTER U
      #x1763	;TAGBANWA LETTER KA
      #x1764	;TAGBANWA LETTER GA
      #x1765	;TAGBANWA LETTER NGA
      #x1766	;TAGBANWA LETTER TA
      #x1767	;TAGBANWA LETTER DA
      #x1768	;TAGBANWA LETTER NA
      #x1769	;TAGBANWA LETTER PA
      #x176A	;TAGBANWA LETTER BA
      #x176B	;TAGBANWA LETTER MA
      #x176C	;TAGBANWA LETTER YA
      #x176E	;TAGBANWA LETTER LA
      #x176F	;TAGBANWA LETTER WA
      #x1770	;TAGBANWA LETTER SA
      #x1772	;TAGBANWA VOWEL SIGN I
      #x1773	;TAGBANWA VOWEL SIGN U
      #x1780	;KHMER LETTER KA
      #x1781	;KHMER LETTER KHA
      #x1782	;KHMER LETTER KO
      #x1783	;KHMER LETTER KHO
      #x1784	;KHMER LETTER NGO
      #x1785	;KHMER LETTER CA
      #x1786	;KHMER LETTER CHA
      #x1787	;KHMER LETTER CO
      #x1788	;KHMER LETTER CHO
      #x1789	;KHMER LETTER NYO
      #x178A	;KHMER LETTER DA
      #x178B	;KHMER LETTER TTHA
      #x178C	;KHMER LETTER DO
      #x178D	;KHMER LETTER TTHO
      #x178E	;KHMER LETTER NNO
      #x178F	;KHMER LETTER TA
      #x1790	;KHMER LETTER THA
      #x1791	;KHMER LETTER TO
      #x1792	;KHMER LETTER THO
      #x1793	;KHMER LETTER NO
      #x1794	;KHMER LETTER BA
      #x1795	;KHMER LETTER PHA
      #x1796	;KHMER LETTER PO
      #x1797	;KHMER LETTER PHO
      #x1798	;KHMER LETTER MO
      #x1799	;KHMER LETTER YO
      #x179A	;KHMER LETTER RO
      #x179B	;KHMER LETTER LO
      #x179C	;KHMER LETTER VO
      #x179D	;KHMER LETTER SHA
      #x179E	;KHMER LETTER SSO
      #x179F	;KHMER LETTER SA
      #x17A0	;KHMER LETTER HA
      #x17A1	;KHMER LETTER LA
      #x17A2	;KHMER LETTER QA
      #x17A3	;KHMER INDEPENDENT VOWEL QAQ
      #x17A4	;KHMER INDEPENDENT VOWEL QAA
      #x17A5	;KHMER INDEPENDENT VOWEL QI
      #x17A6	;KHMER INDEPENDENT VOWEL QII
      #x17A7	;KHMER INDEPENDENT VOWEL QU
      #x17A8	;KHMER INDEPENDENT VOWEL QUK
      #x17A9	;KHMER INDEPENDENT VOWEL QUU
      #x17AA	;KHMER INDEPENDENT VOWEL QUUV
      #x17AB	;KHMER INDEPENDENT VOWEL RY
      #x17AC	;KHMER INDEPENDENT VOWEL RYY
      #x17AD	;KHMER INDEPENDENT VOWEL LY
      #x17AE	;KHMER INDEPENDENT VOWEL LYY
      #x17AF	;KHMER INDEPENDENT VOWEL QE
      #x17B0	;KHMER INDEPENDENT VOWEL QAI
      #x17B1	;KHMER INDEPENDENT VOWEL QOO TYPE ONE
      #x17B2	;KHMER INDEPENDENT VOWEL QOO TYPE TWO
      #x17B3	;KHMER INDEPENDENT VOWEL QAU
      #x17B4	;KHMER VOWEL INHERENT AQ
      #x17B5	;KHMER VOWEL INHERENT AA
      #x17B6	;KHMER VOWEL SIGN AA
      #x17B7	;KHMER VOWEL SIGN I
      #x17B8	;KHMER VOWEL SIGN II
      #x17B9	;KHMER VOWEL SIGN Y
      #x17BA	;KHMER VOWEL SIGN YY
      #x17BB	;KHMER VOWEL SIGN U
      #x17BC	;KHMER VOWEL SIGN UU
      #x17BD	;KHMER VOWEL SIGN UA
      #x17BE	;KHMER VOWEL SIGN OE
      #x17BF	;KHMER VOWEL SIGN YA
      #x17C0	;KHMER VOWEL SIGN IE
      #x17C1	;KHMER VOWEL SIGN E
      #x17C2	;KHMER VOWEL SIGN AE
      #x17C3	;KHMER VOWEL SIGN AI
      #x17C4	;KHMER VOWEL SIGN OO
      #x17C5	;KHMER VOWEL SIGN AU
      #x17C6	;KHMER SIGN NIKAHIT
      #x17C7	;KHMER SIGN REAHMUK
      #x17C8	;KHMER SIGN YUUKALEAPINTU
      #x17C9	;KHMER SIGN MUUSIKATOAN
      #x17CA	;KHMER SIGN TRIISAP
      #x17CB	;KHMER SIGN BANTOC
      #x17CC	;KHMER SIGN ROBAT
      #x17CD	;KHMER SIGN TOANDAKHIAT
      #x17CE	;KHMER SIGN KAKABAT
      #x17CF	;KHMER SIGN AHSDA
      #x17D0	;KHMER SIGN SAMYOK SANNYA
      #x17D1	;KHMER SIGN VIRIAM
      #x17D2	;KHMER SIGN COENG
      #x17D3	;KHMER SIGN BATHAMASAT
      #x17D4	;KHMER SIGN KHAN
      #x17D5	;KHMER SIGN BARIYOOSAN
      #x17D6	;KHMER SIGN CAMNUC PII KUUH
      #x17D7	;KHMER SIGN LEK TOO
      #x17D8	;KHMER SIGN BEYYAL
      #x17D9	;KHMER SIGN PHNAEK MUAN
      #x17DA	;KHMER SIGN KOOMUUT
      #x17DB	;KHMER CURRENCY SYMBOL RIEL
      #x17DC	;KHMER SIGN AVAKRAHASANYA
      #x17DD	;KHMER SIGN ATTHACAN
      #x17E0	;KHMER DIGIT ZERO
      #x17E1	;KHMER DIGIT ONE
      #x17E2	;KHMER DIGIT TWO
      #x17E3	;KHMER DIGIT THREE
      #x17E4	;KHMER DIGIT FOUR
      #x17E5	;KHMER DIGIT FIVE
      #x17E6	;KHMER DIGIT SIX
      #x17E7	;KHMER DIGIT SEVEN
      #x17E8	;KHMER DIGIT EIGHT
      #x17E9	;KHMER DIGIT NINE
      #x17F0	;KHMER SYMBOL LEK ATTAK SON
      #x17F1	;KHMER SYMBOL LEK ATTAK MUOY
      #x17F2	;KHMER SYMBOL LEK ATTAK PII
      #x17F3	;KHMER SYMBOL LEK ATTAK BEI
      #x17F4	;KHMER SYMBOL LEK ATTAK BUON
      #x17F5	;KHMER SYMBOL LEK ATTAK PRAM
      #x17F6	;KHMER SYMBOL LEK ATTAK PRAM-MUOY
      #x17F7	;KHMER SYMBOL LEK ATTAK PRAM-PII
      #x17F8	;KHMER SYMBOL LEK ATTAK PRAM-BEI
      #x17F9	;KHMER SYMBOL LEK ATTAK PRAM-BUON
      #x1800	;MONGOLIAN BIRGA
      #x1801	;MONGOLIAN ELLIPSIS
      #x1802	;MONGOLIAN COMMA
      #x1803	;MONGOLIAN FULL STOP
      #x1804	;MONGOLIAN COLON
      #x1805	;MONGOLIAN FOUR DOTS
      #x1806	;MONGOLIAN TODO SOFT HYPHEN
      #x1807	;MONGOLIAN SIBE SYLLABLE BOUNDARY MARKER
      #x1808	;MONGOLIAN MANCHU COMMA
      #x1809	;MONGOLIAN MANCHU FULL STOP
      #x180A	;MONGOLIAN NIRUGU
      #x180B	;MONGOLIAN FREE VARIATION SELECTOR ONE
      #x180C	;MONGOLIAN FREE VARIATION SELECTOR TWO
      #x180D	;MONGOLIAN FREE VARIATION SELECTOR THREE
      #x180E	;MONGOLIAN VOWEL SEPARATOR
      #x1810	;MONGOLIAN DIGIT ZERO
      #x1811	;MONGOLIAN DIGIT ONE
      #x1812	;MONGOLIAN DIGIT TWO
      #x1813	;MONGOLIAN DIGIT THREE
      #x1814	;MONGOLIAN DIGIT FOUR
      #x1815	;MONGOLIAN DIGIT FIVE
      #x1816	;MONGOLIAN DIGIT SIX
      #x1817	;MONGOLIAN DIGIT SEVEN
      #x1818	;MONGOLIAN DIGIT EIGHT
      #x1819	;MONGOLIAN DIGIT NINE
      #x1820	;MONGOLIAN LETTER A
      #x1821	;MONGOLIAN LETTER E
      #x1822	;MONGOLIAN LETTER I
      #x1823	;MONGOLIAN LETTER O
      #x1824	;MONGOLIAN LETTER U
      #x1825	;MONGOLIAN LETTER OE
      #x1826	;MONGOLIAN LETTER UE
      #x1827	;MONGOLIAN LETTER EE
      #x1828	;MONGOLIAN LETTER NA
      #x1829	;MONGOLIAN LETTER ANG
      #x182A	;MONGOLIAN LETTER BA
      #x182B	;MONGOLIAN LETTER PA
      #x182C	;MONGOLIAN LETTER QA
      #x182D	;MONGOLIAN LETTER GA
      #x182E	;MONGOLIAN LETTER MA
      #x182F	;MONGOLIAN LETTER LA
      #x1830	;MONGOLIAN LETTER SA
      #x1831	;MONGOLIAN LETTER SHA
      #x1832	;MONGOLIAN LETTER TA
      #x1833	;MONGOLIAN LETTER DA
      #x1834	;MONGOLIAN LETTER CHA
      #x1835	;MONGOLIAN LETTER JA
      #x1836	;MONGOLIAN LETTER YA
      #x1837	;MONGOLIAN LETTER RA
      #x1838	;MONGOLIAN LETTER WA
      #x1839	;MONGOLIAN LETTER FA
      #x183A	;MONGOLIAN LETTER KA
      #x183B	;MONGOLIAN LETTER KHA
      #x183C	;MONGOLIAN LETTER TSA
      #x183D	;MONGOLIAN LETTER ZA
      #x183E	;MONGOLIAN LETTER HAA
      #x183F	;MONGOLIAN LETTER ZRA
      #x1840	;MONGOLIAN LETTER LHA
      #x1841	;MONGOLIAN LETTER ZHI
      #x1842	;MONGOLIAN LETTER CHI
      #x1843	;MONGOLIAN LETTER TODO LONG VOWEL SIGN
      #x1844	;MONGOLIAN LETTER TODO E
      #x1845	;MONGOLIAN LETTER TODO I
      #x1846	;MONGOLIAN LETTER TODO O
      #x1847	;MONGOLIAN LETTER TODO U
      #x1848	;MONGOLIAN LETTER TODO OE
      #x1849	;MONGOLIAN LETTER TODO UE
      #x184A	;MONGOLIAN LETTER TODO ANG
      #x184B	;MONGOLIAN LETTER TODO BA
      #x184C	;MONGOLIAN LETTER TODO PA
      #x184D	;MONGOLIAN LETTER TODO QA
      #x184E	;MONGOLIAN LETTER TODO GA
      #x184F	;MONGOLIAN LETTER TODO MA
      #x1850	;MONGOLIAN LETTER TODO TA
      #x1851	;MONGOLIAN LETTER TODO DA
      #x1852	;MONGOLIAN LETTER TODO CHA
      #x1853	;MONGOLIAN LETTER TODO JA
      #x1854	;MONGOLIAN LETTER TODO TSA
      #x1855	;MONGOLIAN LETTER TODO YA
      #x1856	;MONGOLIAN LETTER TODO WA
      #x1857	;MONGOLIAN LETTER TODO KA
      #x1858	;MONGOLIAN LETTER TODO GAA
      #x1859	;MONGOLIAN LETTER TODO HAA
      #x185A	;MONGOLIAN LETTER TODO JIA
      #x185B	;MONGOLIAN LETTER TODO NIA
      #x185C	;MONGOLIAN LETTER TODO DZA
      #x185D	;MONGOLIAN LETTER SIBE E
      #x185E	;MONGOLIAN LETTER SIBE I
      #x185F	;MONGOLIAN LETTER SIBE IY
      #x1860	;MONGOLIAN LETTER SIBE UE
      #x1861	;MONGOLIAN LETTER SIBE U
      #x1862	;MONGOLIAN LETTER SIBE ANG
      #x1863	;MONGOLIAN LETTER SIBE KA
      #x1864	;MONGOLIAN LETTER SIBE GA
      #x1865	;MONGOLIAN LETTER SIBE HA
      #x1866	;MONGOLIAN LETTER SIBE PA
      #x1867	;MONGOLIAN LETTER SIBE SHA
      #x1868	;MONGOLIAN LETTER SIBE TA
      #x1869	;MONGOLIAN LETTER SIBE DA
      #x186A	;MONGOLIAN LETTER SIBE JA
      #x186B	;MONGOLIAN LETTER SIBE FA
      #x186C	;MONGOLIAN LETTER SIBE GAA
      #x186D	;MONGOLIAN LETTER SIBE HAA
      #x186E	;MONGOLIAN LETTER SIBE TSA
      #x186F	;MONGOLIAN LETTER SIBE ZA
      #x1870	;MONGOLIAN LETTER SIBE RAA
      #x1871	;MONGOLIAN LETTER SIBE CHA
      #x1872	;MONGOLIAN LETTER SIBE ZHA
      #x1873	;MONGOLIAN LETTER MANCHU I
      #x1874	;MONGOLIAN LETTER MANCHU KA
      #x1875	;MONGOLIAN LETTER MANCHU RA
      #x1876	;MONGOLIAN LETTER MANCHU FA
      #x1877	;MONGOLIAN LETTER MANCHU ZHA
      #x1880	;MONGOLIAN LETTER ALI GALI ANUSVARA ONE
      #x1881	;MONGOLIAN LETTER ALI GALI VISARGA ONE
      #x1882	;MONGOLIAN LETTER ALI GALI DAMARU
      #x1883	;MONGOLIAN LETTER ALI GALI UBADAMA
      #x1884	;MONGOLIAN LETTER ALI GALI INVERTED UBADAMA
      #x1885	;MONGOLIAN LETTER ALI GALI BALUDA
      #x1886	;MONGOLIAN LETTER ALI GALI THREE BALUDA
      #x1887	;MONGOLIAN LETTER ALI GALI A
      #x1888	;MONGOLIAN LETTER ALI GALI I
      #x1889	;MONGOLIAN LETTER ALI GALI KA
      #x188A	;MONGOLIAN LETTER ALI GALI NGA
      #x188B	;MONGOLIAN LETTER ALI GALI CA
      #x188C	;MONGOLIAN LETTER ALI GALI TTA
      #x188D	;MONGOLIAN LETTER ALI GALI TTHA
      #x188E	;MONGOLIAN LETTER ALI GALI DDA
      #x188F	;MONGOLIAN LETTER ALI GALI NNA
      #x1890	;MONGOLIAN LETTER ALI GALI TA
      #x1891	;MONGOLIAN LETTER ALI GALI DA
      #x1892	;MONGOLIAN LETTER ALI GALI PA
      #x1893	;MONGOLIAN LETTER ALI GALI PHA
      #x1894	;MONGOLIAN LETTER ALI GALI SSA
      #x1895	;MONGOLIAN LETTER ALI GALI ZHA
      #x1896	;MONGOLIAN LETTER ALI GALI ZA
      #x1897	;MONGOLIAN LETTER ALI GALI AH
      #x1898	;MONGOLIAN LETTER TODO ALI GALI TA
      #x1899	;MONGOLIAN LETTER TODO ALI GALI ZHA
      #x189A	;MONGOLIAN LETTER MANCHU ALI GALI GHA
      #x189B	;MONGOLIAN LETTER MANCHU ALI GALI NGA
      #x189C	;MONGOLIAN LETTER MANCHU ALI GALI CA
      #x189D	;MONGOLIAN LETTER MANCHU ALI GALI JHA
      #x189E	;MONGOLIAN LETTER MANCHU ALI GALI TTA
      #x189F	;MONGOLIAN LETTER MANCHU ALI GALI DDHA
      #x18A0	;MONGOLIAN LETTER MANCHU ALI GALI TA
      #x18A1	;MONGOLIAN LETTER MANCHU ALI GALI DHA
      #x18A2	;MONGOLIAN LETTER MANCHU ALI GALI SSA
      #x18A3	;MONGOLIAN LETTER MANCHU ALI GALI CYA
      #x18A4	;MONGOLIAN LETTER MANCHU ALI GALI ZHA
      #x18A5	;MONGOLIAN LETTER MANCHU ALI GALI ZA
      #x18A6	;MONGOLIAN LETTER ALI GALI HALF U
      #x18A7	;MONGOLIAN LETTER ALI GALI HALF YA
      #x18A8	;MONGOLIAN LETTER MANCHU ALI GALI BHA
      #x18A9	;MONGOLIAN LETTER ALI GALI DAGALGA
      #x1900	;LIMBU VOWEL-CARRIER LETTER
      #x1901	;LIMBU LETTER KA
      #x1902	;LIMBU LETTER KHA
      #x1903	;LIMBU LETTER GA
      #x1904	;LIMBU LETTER GHA
      #x1905	;LIMBU LETTER NGA
      #x1906	;LIMBU LETTER CA
      #x1907	;LIMBU LETTER CHA
      #x1908	;LIMBU LETTER JA
      #x1909	;LIMBU LETTER JHA
      #x190A	;LIMBU LETTER YAN
      #x190B	;LIMBU LETTER TA
      #x190C	;LIMBU LETTER THA
      #x190D	;LIMBU LETTER DA
      #x190E	;LIMBU LETTER DHA
      #x190F	;LIMBU LETTER NA
      #x1910	;LIMBU LETTER PA
      #x1911	;LIMBU LETTER PHA
      #x1912	;LIMBU LETTER BA
      #x1913	;LIMBU LETTER BHA
      #x1914	;LIMBU LETTER MA
      #x1915	;LIMBU LETTER YA
      #x1916	;LIMBU LETTER RA
      #x1917	;LIMBU LETTER LA
      #x1918	;LIMBU LETTER WA
      #x1919	;LIMBU LETTER SHA
      #x191A	;LIMBU LETTER SSA
      #x191B	;LIMBU LETTER SA
      #x191C	;LIMBU LETTER HA
      #x1920	;LIMBU VOWEL SIGN A
      #x1921	;LIMBU VOWEL SIGN I
      #x1922	;LIMBU VOWEL SIGN U
      #x1923	;LIMBU VOWEL SIGN EE
      #x1924	;LIMBU VOWEL SIGN AI
      #x1925	;LIMBU VOWEL SIGN OO
      #x1926	;LIMBU VOWEL SIGN AU
      #x1927	;LIMBU VOWEL SIGN E
      #x1928	;LIMBU VOWEL SIGN O
      #x1929	;LIMBU SUBJOINED LETTER YA
      #x192A	;LIMBU SUBJOINED LETTER RA
      #x192B	;LIMBU SUBJOINED LETTER WA
      #x1930	;LIMBU SMALL LETTER KA
      #x1931	;LIMBU SMALL LETTER NGA
      #x1932	;LIMBU SMALL LETTER ANUSVARA
      #x1933	;LIMBU SMALL LETTER TA
      #x1934	;LIMBU SMALL LETTER NA
      #x1935	;LIMBU SMALL LETTER PA
      #x1936	;LIMBU SMALL LETTER MA
      #x1937	;LIMBU SMALL LETTER RA
      #x1938	;LIMBU SMALL LETTER LA
      #x1939	;LIMBU SIGN MUKPHRENG
      #x193A	;LIMBU SIGN KEMPHRENG
      #x193B	;LIMBU SIGN SA-I
      #x1940	;LIMBU SIGN LOO
      #x1944	;LIMBU EXCLAMATION MARK
      #x1945	;LIMBU QUESTION MARK
      #x1946	;LIMBU DIGIT ZERO
      #x1947	;LIMBU DIGIT ONE
      #x1948	;LIMBU DIGIT TWO
      #x1949	;LIMBU DIGIT THREE
      #x194A	;LIMBU DIGIT FOUR
      #x194B	;LIMBU DIGIT FIVE
      #x194C	;LIMBU DIGIT SIX
      #x194D	;LIMBU DIGIT SEVEN
      #x194E	;LIMBU DIGIT EIGHT
      #x194F	;LIMBU DIGIT NINE
      #x1950	;TAI LE LETTER KA
      #x1951	;TAI LE LETTER XA
      #x1952	;TAI LE LETTER NGA
      #x1953	;TAI LE LETTER TSA
      #x1954	;TAI LE LETTER SA
      #x1955	;TAI LE LETTER YA
      #x1956	;TAI LE LETTER TA
      #x1957	;TAI LE LETTER THA
      #x1958	;TAI LE LETTER LA
      #x1959	;TAI LE LETTER PA
      #x195A	;TAI LE LETTER PHA
      #x195B	;TAI LE LETTER MA
      #x195C	;TAI LE LETTER FA
      #x195D	;TAI LE LETTER VA
      #x195E	;TAI LE LETTER HA
      #x195F	;TAI LE LETTER QA
      #x1960	;TAI LE LETTER KHA
      #x1961	;TAI LE LETTER TSHA
      #x1962	;TAI LE LETTER NA
      #x1963	;TAI LE LETTER A
      #x1964	;TAI LE LETTER I
      #x1965	;TAI LE LETTER EE
      #x1966	;TAI LE LETTER EH
      #x1967	;TAI LE LETTER U
      #x1968	;TAI LE LETTER OO
      #x1969	;TAI LE LETTER O
      #x196A	;TAI LE LETTER UE
      #x196B	;TAI LE LETTER E
      #x196C	;TAI LE LETTER AUE
      #x196D	;TAI LE LETTER AI
      #x1970	;TAI LE LETTER TONE-2
      #x1971	;TAI LE LETTER TONE-3
      #x1972	;TAI LE LETTER TONE-4
      #x1973	;TAI LE LETTER TONE-5
      #x1974	;TAI LE LETTER TONE-6
      #x19E0	;KHMER SYMBOL PATHAMASAT
      #x19E1	;KHMER SYMBOL MUOY KOET
      #x19E2	;KHMER SYMBOL PII KOET
      #x19E3	;KHMER SYMBOL BEI KOET
      #x19E4	;KHMER SYMBOL BUON KOET
      #x19E5	;KHMER SYMBOL PRAM KOET
      #x19E6	;KHMER SYMBOL PRAM-MUOY KOET
      #x19E7	;KHMER SYMBOL PRAM-PII KOET
      #x19E8	;KHMER SYMBOL PRAM-BEI KOET
      #x19E9	;KHMER SYMBOL PRAM-BUON KOET
      #x19EA	;KHMER SYMBOL DAP KOET
      #x19EB	;KHMER SYMBOL DAP-MUOY KOET
      #x19EC	;KHMER SYMBOL DAP-PII KOET
      #x19ED	;KHMER SYMBOL DAP-BEI KOET
      #x19EE	;KHMER SYMBOL DAP-BUON KOET
      #x19EF	;KHMER SYMBOL DAP-PRAM KOET
      #x19F0	;KHMER SYMBOL TUTEYASAT
      #x19F1	;KHMER SYMBOL MUOY ROC
      #x19F2	;KHMER SYMBOL PII ROC
      #x19F3	;KHMER SYMBOL BEI ROC
      #x19F4	;KHMER SYMBOL BUON ROC
      #x19F5	;KHMER SYMBOL PRAM ROC
      #x19F6	;KHMER SYMBOL PRAM-MUOY ROC
      #x19F7	;KHMER SYMBOL PRAM-PII ROC
      #x19F8	;KHMER SYMBOL PRAM-BEI ROC
      #x19F9	;KHMER SYMBOL PRAM-BUON ROC
      #x19FA	;KHMER SYMBOL DAP ROC
      #x19FB	;KHMER SYMBOL DAP-MUOY ROC
      #x19FC	;KHMER SYMBOL DAP-PII ROC
      #x19FD	;KHMER SYMBOL DAP-BEI ROC
      #x19FE	;KHMER SYMBOL DAP-BUON ROC
      #x19FF	;KHMER SYMBOL DAP-PRAM ROC
      #x1D00	;LATIN LETTER SMALL CAPITAL A
      #x1D01	;LATIN LETTER SMALL CAPITAL AE
      #x1D02	;LATIN SMALL LETTER TURNED AE
      #x1D03	;LATIN LETTER SMALL CAPITAL BARRED B
      #x1D04	;LATIN LETTER SMALL CAPITAL C
      #x1D05	;LATIN LETTER SMALL CAPITAL D
      #x1D06	;LATIN LETTER SMALL CAPITAL ETH
      #x1D07	;LATIN LETTER SMALL CAPITAL E
      #x1D08	;LATIN SMALL LETTER TURNED OPEN E
      #x1D09	;LATIN SMALL LETTER TURNED I
      #x1D0A	;LATIN LETTER SMALL CAPITAL J
      #x1D0B	;LATIN LETTER SMALL CAPITAL K
      #x1D0C	;LATIN LETTER SMALL CAPITAL L WITH STROKE
      #x1D0D	;LATIN LETTER SMALL CAPITAL M
      #x1D0E	;LATIN LETTER SMALL CAPITAL REVERSED N
      #x1D0F	;LATIN LETTER SMALL CAPITAL O
      #x1D10	;LATIN LETTER SMALL CAPITAL OPEN O
      #x1D11	;LATIN SMALL LETTER SIDEWAYS O
      #x1D12	;LATIN SMALL LETTER SIDEWAYS OPEN O
      #x1D13	;LATIN SMALL LETTER SIDEWAYS O WITH STROKE
      #x1D14	;LATIN SMALL LETTER TURNED OE
      #x1D15	;LATIN LETTER SMALL CAPITAL OU
      #x1D16	;LATIN SMALL LETTER TOP HALF O
      #x1D17	;LATIN SMALL LETTER BOTTOM HALF O
      #x1D18	;LATIN LETTER SMALL CAPITAL P
      #x1D19	;LATIN LETTER SMALL CAPITAL REVERSED R
      #x1D1A	;LATIN LETTER SMALL CAPITAL TURNED R
      #x1D1B	;LATIN LETTER SMALL CAPITAL T
      #x1D1C	;LATIN LETTER SMALL CAPITAL U
      #x1D1D	;LATIN SMALL LETTER SIDEWAYS U
      #x1D1E	;LATIN SMALL LETTER SIDEWAYS DIAERESIZED U
      #x1D1F	;LATIN SMALL LETTER SIDEWAYS TURNED M
      #x1D20	;LATIN LETTER SMALL CAPITAL V
      #x1D21	;LATIN LETTER SMALL CAPITAL W
      #x1D22	;LATIN LETTER SMALL CAPITAL Z
      #x1D23	;LATIN LETTER SMALL CAPITAL EZH
      #x1D24	;LATIN LETTER VOICED LARYNGEAL SPIRANT
      #x1D25	;LATIN LETTER AIN
      #x1D26	;GREEK LETTER SMALL CAPITAL GAMMA
      #x1D27	;GREEK LETTER SMALL CAPITAL LAMDA
      #x1D28	;GREEK LETTER SMALL CAPITAL PI
      #x1D29	;GREEK LETTER SMALL CAPITAL RHO
      #x1D2A	;GREEK LETTER SMALL CAPITAL PSI
      #x1D2B	;CYRILLIC LETTER SMALL CAPITAL EL
      #x1D2C	;MODIFIER LETTER CAPITAL A
      #x1D2D	;MODIFIER LETTER CAPITAL AE
      #x1D2E	;MODIFIER LETTER CAPITAL B
      #x1D2F	;MODIFIER LETTER CAPITAL BARRED B
      #x1D30	;MODIFIER LETTER CAPITAL D
      #x1D31	;MODIFIER LETTER CAPITAL E
      #x1D32	;MODIFIER LETTER CAPITAL REVERSED E
      #x1D33	;MODIFIER LETTER CAPITAL G
      #x1D34	;MODIFIER LETTER CAPITAL H
      #x1D35	;MODIFIER LETTER CAPITAL I
      #x1D36	;MODIFIER LETTER CAPITAL J
      #x1D37	;MODIFIER LETTER CAPITAL K
      #x1D38	;MODIFIER LETTER CAPITAL L
      #x1D39	;MODIFIER LETTER CAPITAL M
      #x1D3A	;MODIFIER LETTER CAPITAL N
      #x1D3B	;MODIFIER LETTER CAPITAL REVERSED N
      #x1D3C	;MODIFIER LETTER CAPITAL O
      #x1D3D	;MODIFIER LETTER CAPITAL OU
      #x1D3E	;MODIFIER LETTER CAPITAL P
      #x1D3F	;MODIFIER LETTER CAPITAL R
      #x1D40	;MODIFIER LETTER CAPITAL T
      #x1D41	;MODIFIER LETTER CAPITAL U
      #x1D42	;MODIFIER LETTER CAPITAL W
      #x1D43	;MODIFIER LETTER SMALL A
      #x1D44	;MODIFIER LETTER SMALL TURNED A
      #x1D45	;MODIFIER LETTER SMALL ALPHA
      #x1D46	;MODIFIER LETTER SMALL TURNED AE
      #x1D47	;MODIFIER LETTER SMALL B
      #x1D48	;MODIFIER LETTER SMALL D
      #x1D49	;MODIFIER LETTER SMALL E
      #x1D4A	;MODIFIER LETTER SMALL SCHWA
      #x1D4B	;MODIFIER LETTER SMALL OPEN E
      #x1D4C	;MODIFIER LETTER SMALL TURNED OPEN E
      #x1D4D	;MODIFIER LETTER SMALL G
      #x1D4E	;MODIFIER LETTER SMALL TURNED I
      #x1D4F	;MODIFIER LETTER SMALL K
      #x1D50	;MODIFIER LETTER SMALL M
      #x1D51	;MODIFIER LETTER SMALL ENG
      #x1D52	;MODIFIER LETTER SMALL O
      #x1D53	;MODIFIER LETTER SMALL OPEN O
      #x1D54	;MODIFIER LETTER SMALL TOP HALF O
      #x1D55	;MODIFIER LETTER SMALL BOTTOM HALF O
      #x1D56	;MODIFIER LETTER SMALL P
      #x1D57	;MODIFIER LETTER SMALL T
      #x1D58	;MODIFIER LETTER SMALL U
      #x1D59	;MODIFIER LETTER SMALL SIDEWAYS U
      #x1D5A	;MODIFIER LETTER SMALL TURNED M
      #x1D5B	;MODIFIER LETTER SMALL V
      #x1D5C	;MODIFIER LETTER SMALL AIN
      #x1D5D	;MODIFIER LETTER SMALL BETA
      #x1D5E	;MODIFIER LETTER SMALL GREEK GAMMA
      #x1D5F	;MODIFIER LETTER SMALL DELTA
      #x1D60	;MODIFIER LETTER SMALL GREEK PHI
      #x1D61	;MODIFIER LETTER SMALL CHI
      #x1D62	;LATIN SUBSCRIPT SMALL LETTER I
      #x1D63	;LATIN SUBSCRIPT SMALL LETTER R
      #x1D64	;LATIN SUBSCRIPT SMALL LETTER U
      #x1D65	;LATIN SUBSCRIPT SMALL LETTER V
      #x1D66	;GREEK SUBSCRIPT SMALL LETTER BETA
      #x1D67	;GREEK SUBSCRIPT SMALL LETTER GAMMA
      #x1D68	;GREEK SUBSCRIPT SMALL LETTER RHO
      #x1D69	;GREEK SUBSCRIPT SMALL LETTER PHI
      #x1D6A	;GREEK SUBSCRIPT SMALL LETTER CHI
      #x1D6B	;LATIN SMALL LETTER UE
      #x1E00	;LATIN CAPITAL LETTER A WITH RING BELOW
      #x1E01	;LATIN SMALL LETTER A WITH RING BELOW
      #x1E02	;LATIN CAPITAL LETTER B WITH DOT ABOVE
      #x1E03	;LATIN SMALL LETTER B WITH DOT ABOVE
      #x1E04	;LATIN CAPITAL LETTER B WITH DOT BELOW
      #x1E05	;LATIN SMALL LETTER B WITH DOT BELOW
      #x1E06	;LATIN CAPITAL LETTER B WITH LINE BELOW
      #x1E07	;LATIN SMALL LETTER B WITH LINE BELOW
      #x1E08	;LATIN CAPITAL LETTER C WITH CEDILLA AND ACUTE
      #x1E09	;LATIN SMALL LETTER C WITH CEDILLA AND ACUTE
      #x1E0A	;LATIN CAPITAL LETTER D WITH DOT ABOVE
      #x1E0B	;LATIN SMALL LETTER D WITH DOT ABOVE
      #x1E0C	;LATIN CAPITAL LETTER D WITH DOT BELOW
      #x1E0D	;LATIN SMALL LETTER D WITH DOT BELOW
      #x1E0E	;LATIN CAPITAL LETTER D WITH LINE BELOW
      #x1E0F	;LATIN SMALL LETTER D WITH LINE BELOW
      #x1E10	;LATIN CAPITAL LETTER D WITH CEDILLA
      #x1E11	;LATIN SMALL LETTER D WITH CEDILLA
      #x1E12	;LATIN CAPITAL LETTER D WITH CIRCUMFLEX BELOW
      #x1E13	;LATIN SMALL LETTER D WITH CIRCUMFLEX BELOW
      #x1E14	;LATIN CAPITAL LETTER E WITH MACRON AND GRAVE
      #x1E15	;LATIN SMALL LETTER E WITH MACRON AND GRAVE
      #x1E16	;LATIN CAPITAL LETTER E WITH MACRON AND ACUTE
      #x1E17	;LATIN SMALL LETTER E WITH MACRON AND ACUTE
      #x1E18	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX BELOW
      #x1E19	;LATIN SMALL LETTER E WITH CIRCUMFLEX BELOW
      #x1E1A	;LATIN CAPITAL LETTER E WITH TILDE BELOW
      #x1E1B	;LATIN SMALL LETTER E WITH TILDE BELOW
      #x1E1C	;LATIN CAPITAL LETTER E WITH CEDILLA AND BREVE
      #x1E1D	;LATIN SMALL LETTER E WITH CEDILLA AND BREVE
      #x1E1E	;LATIN CAPITAL LETTER F WITH DOT ABOVE
      #x1E1F	;LATIN SMALL LETTER F WITH DOT ABOVE
      #x1E20	;LATIN CAPITAL LETTER G WITH MACRON
      #x1E21	;LATIN SMALL LETTER G WITH MACRON
      #x1E22	;LATIN CAPITAL LETTER H WITH DOT ABOVE
      #x1E23	;LATIN SMALL LETTER H WITH DOT ABOVE
      #x1E24	;LATIN CAPITAL LETTER H WITH DOT BELOW
      #x1E25	;LATIN SMALL LETTER H WITH DOT BELOW
      #x1E26	;LATIN CAPITAL LETTER H WITH DIAERESIS
      #x1E27	;LATIN SMALL LETTER H WITH DIAERESIS
      #x1E28	;LATIN CAPITAL LETTER H WITH CEDILLA
      #x1E29	;LATIN SMALL LETTER H WITH CEDILLA
      #x1E2A	;LATIN CAPITAL LETTER H WITH BREVE BELOW
      #x1E2B	;LATIN SMALL LETTER H WITH BREVE BELOW
      #x1E2C	;LATIN CAPITAL LETTER I WITH TILDE BELOW
      #x1E2D	;LATIN SMALL LETTER I WITH TILDE BELOW
      #x1E2E	;LATIN CAPITAL LETTER I WITH DIAERESIS AND ACUTE
      #x1E2F	;LATIN SMALL LETTER I WITH DIAERESIS AND ACUTE
      #x1E30	;LATIN CAPITAL LETTER K WITH ACUTE
      #x1E31	;LATIN SMALL LETTER K WITH ACUTE
      #x1E32	;LATIN CAPITAL LETTER K WITH DOT BELOW
      #x1E33	;LATIN SMALL LETTER K WITH DOT BELOW
      #x1E34	;LATIN CAPITAL LETTER K WITH LINE BELOW
      #x1E35	;LATIN SMALL LETTER K WITH LINE BELOW
      #x1E36	;LATIN CAPITAL LETTER L WITH DOT BELOW
      #x1E37	;LATIN SMALL LETTER L WITH DOT BELOW
      #x1E38	;LATIN CAPITAL LETTER L WITH DOT BELOW AND MACRON
      #x1E39	;LATIN SMALL LETTER L WITH DOT BELOW AND MACRON
      #x1E3A	;LATIN CAPITAL LETTER L WITH LINE BELOW
      #x1E3B	;LATIN SMALL LETTER L WITH LINE BELOW
      #x1E3C	;LATIN CAPITAL LETTER L WITH CIRCUMFLEX BELOW
      #x1E3D	;LATIN SMALL LETTER L WITH CIRCUMFLEX BELOW
      #x1E3E	;LATIN CAPITAL LETTER M WITH ACUTE
      #x1E3F	;LATIN SMALL LETTER M WITH ACUTE
      #x1E40	;LATIN CAPITAL LETTER M WITH DOT ABOVE
      #x1E41	;LATIN SMALL LETTER M WITH DOT ABOVE
      #x1E42	;LATIN CAPITAL LETTER M WITH DOT BELOW
      #x1E43	;LATIN SMALL LETTER M WITH DOT BELOW
      #x1E44	;LATIN CAPITAL LETTER N WITH DOT ABOVE
      #x1E45	;LATIN SMALL LETTER N WITH DOT ABOVE
      #x1E46	;LATIN CAPITAL LETTER N WITH DOT BELOW
      #x1E47	;LATIN SMALL LETTER N WITH DOT BELOW
      #x1E48	;LATIN CAPITAL LETTER N WITH LINE BELOW
      #x1E49	;LATIN SMALL LETTER N WITH LINE BELOW
      #x1E4A	;LATIN CAPITAL LETTER N WITH CIRCUMFLEX BELOW
      #x1E4B	;LATIN SMALL LETTER N WITH CIRCUMFLEX BELOW
      #x1E4C	;LATIN CAPITAL LETTER O WITH TILDE AND ACUTE
      #x1E4D	;LATIN SMALL LETTER O WITH TILDE AND ACUTE
      #x1E4E	;LATIN CAPITAL LETTER O WITH TILDE AND DIAERESIS
      #x1E4F	;LATIN SMALL LETTER O WITH TILDE AND DIAERESIS
      #x1E50	;LATIN CAPITAL LETTER O WITH MACRON AND GRAVE
      #x1E51	;LATIN SMALL LETTER O WITH MACRON AND GRAVE
      #x1E52	;LATIN CAPITAL LETTER O WITH MACRON AND ACUTE
      #x1E53	;LATIN SMALL LETTER O WITH MACRON AND ACUTE
      #x1E54	;LATIN CAPITAL LETTER P WITH ACUTE
      #x1E55	;LATIN SMALL LETTER P WITH ACUTE
      #x1E56	;LATIN CAPITAL LETTER P WITH DOT ABOVE
      #x1E57	;LATIN SMALL LETTER P WITH DOT ABOVE
      #x1E58	;LATIN CAPITAL LETTER R WITH DOT ABOVE
      #x1E59	;LATIN SMALL LETTER R WITH DOT ABOVE
      #x1E5A	;LATIN CAPITAL LETTER R WITH DOT BELOW
      #x1E5B	;LATIN SMALL LETTER R WITH DOT BELOW
      #x1E5C	;LATIN CAPITAL LETTER R WITH DOT BELOW AND MACRON
      #x1E5D	;LATIN SMALL LETTER R WITH DOT BELOW AND MACRON
      #x1E5E	;LATIN CAPITAL LETTER R WITH LINE BELOW
      #x1E5F	;LATIN SMALL LETTER R WITH LINE BELOW
      #x1E60	;LATIN CAPITAL LETTER S WITH DOT ABOVE
      #x1E61	;LATIN SMALL LETTER S WITH DOT ABOVE
      #x1E62	;LATIN CAPITAL LETTER S WITH DOT BELOW
      #x1E63	;LATIN SMALL LETTER S WITH DOT BELOW
      #x1E64	;LATIN CAPITAL LETTER S WITH ACUTE AND DOT ABOVE
      #x1E65	;LATIN SMALL LETTER S WITH ACUTE AND DOT ABOVE
      #x1E66	;LATIN CAPITAL LETTER S WITH CARON AND DOT ABOVE
      #x1E67	;LATIN SMALL LETTER S WITH CARON AND DOT ABOVE
      #x1E68	;LATIN CAPITAL LETTER S WITH DOT BELOW AND DOT ABOVE
      #x1E69	;LATIN SMALL LETTER S WITH DOT BELOW AND DOT ABOVE
      #x1E6A	;LATIN CAPITAL LETTER T WITH DOT ABOVE
      #x1E6B	;LATIN SMALL LETTER T WITH DOT ABOVE
      #x1E6C	;LATIN CAPITAL LETTER T WITH DOT BELOW
      #x1E6D	;LATIN SMALL LETTER T WITH DOT BELOW
      #x1E6E	;LATIN CAPITAL LETTER T WITH LINE BELOW
      #x1E6F	;LATIN SMALL LETTER T WITH LINE BELOW
      #x1E70	;LATIN CAPITAL LETTER T WITH CIRCUMFLEX BELOW
      #x1E71	;LATIN SMALL LETTER T WITH CIRCUMFLEX BELOW
      #x1E72	;LATIN CAPITAL LETTER U WITH DIAERESIS BELOW
      #x1E73	;LATIN SMALL LETTER U WITH DIAERESIS BELOW
      #x1E74	;LATIN CAPITAL LETTER U WITH TILDE BELOW
      #x1E75	;LATIN SMALL LETTER U WITH TILDE BELOW
      #x1E76	;LATIN CAPITAL LETTER U WITH CIRCUMFLEX BELOW
      #x1E77	;LATIN SMALL LETTER U WITH CIRCUMFLEX BELOW
      #x1E78	;LATIN CAPITAL LETTER U WITH TILDE AND ACUTE
      #x1E79	;LATIN SMALL LETTER U WITH TILDE AND ACUTE
      #x1E7A	;LATIN CAPITAL LETTER U WITH MACRON AND DIAERESIS
      #x1E7B	;LATIN SMALL LETTER U WITH MACRON AND DIAERESIS
      #x1E7C	;LATIN CAPITAL LETTER V WITH TILDE
      #x1E7D	;LATIN SMALL LETTER V WITH TILDE
      #x1E7E	;LATIN CAPITAL LETTER V WITH DOT BELOW
      #x1E7F	;LATIN SMALL LETTER V WITH DOT BELOW
      #x1E80	;LATIN CAPITAL LETTER W WITH GRAVE
      #x1E81	;LATIN SMALL LETTER W WITH GRAVE
      #x1E82	;LATIN CAPITAL LETTER W WITH ACUTE
      #x1E83	;LATIN SMALL LETTER W WITH ACUTE
      #x1E84	;LATIN CAPITAL LETTER W WITH DIAERESIS
      #x1E85	;LATIN SMALL LETTER W WITH DIAERESIS
      #x1E86	;LATIN CAPITAL LETTER W WITH DOT ABOVE
      #x1E87	;LATIN SMALL LETTER W WITH DOT ABOVE
      #x1E88	;LATIN CAPITAL LETTER W WITH DOT BELOW
      #x1E89	;LATIN SMALL LETTER W WITH DOT BELOW
      #x1E8A	;LATIN CAPITAL LETTER X WITH DOT ABOVE
      #x1E8B	;LATIN SMALL LETTER X WITH DOT ABOVE
      #x1E8C	;LATIN CAPITAL LETTER X WITH DIAERESIS
      #x1E8D	;LATIN SMALL LETTER X WITH DIAERESIS
      #x1E8E	;LATIN CAPITAL LETTER Y WITH DOT ABOVE
      #x1E8F	;LATIN SMALL LETTER Y WITH DOT ABOVE
      #x1E90	;LATIN CAPITAL LETTER Z WITH CIRCUMFLEX
      #x1E91	;LATIN SMALL LETTER Z WITH CIRCUMFLEX
      #x1E92	;LATIN CAPITAL LETTER Z WITH DOT BELOW
      #x1E93	;LATIN SMALL LETTER Z WITH DOT BELOW
      #x1E94	;LATIN CAPITAL LETTER Z WITH LINE BELOW
      #x1E95	;LATIN SMALL LETTER Z WITH LINE BELOW
      #x1E96	;LATIN SMALL LETTER H WITH LINE BELOW
      #x1E97	;LATIN SMALL LETTER T WITH DIAERESIS
      #x1E98	;LATIN SMALL LETTER W WITH RING ABOVE
      #x1E99	;LATIN SMALL LETTER Y WITH RING ABOVE
      #x1E9A	;LATIN SMALL LETTER A WITH RIGHT HALF RING
      #x1E9B	;LATIN SMALL LETTER LONG S WITH DOT ABOVE
      #x1EA0	;LATIN CAPITAL LETTER A WITH DOT BELOW
      #x1EA1	;LATIN SMALL LETTER A WITH DOT BELOW
      #x1EA2	;LATIN CAPITAL LETTER A WITH HOOK ABOVE
      #x1EA3	;LATIN SMALL LETTER A WITH HOOK ABOVE
      #x1EA4	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND ACUTE
      #x1EA5	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND ACUTE
      #x1EA6	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND GRAVE
      #x1EA7	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND GRAVE
      #x1EA8	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EA9	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EAA	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND TILDE
      #x1EAB	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND TILDE
      #x1EAC	;LATIN CAPITAL LETTER A WITH CIRCUMFLEX AND DOT BELOW
      #x1EAD	;LATIN SMALL LETTER A WITH CIRCUMFLEX AND DOT BELOW
      #x1EAE	;LATIN CAPITAL LETTER A WITH BREVE AND ACUTE
      #x1EAF	;LATIN SMALL LETTER A WITH BREVE AND ACUTE
      #x1EB0	;LATIN CAPITAL LETTER A WITH BREVE AND GRAVE
      #x1EB1	;LATIN SMALL LETTER A WITH BREVE AND GRAVE
      #x1EB2	;LATIN CAPITAL LETTER A WITH BREVE AND HOOK ABOVE
      #x1EB3	;LATIN SMALL LETTER A WITH BREVE AND HOOK ABOVE
      #x1EB4	;LATIN CAPITAL LETTER A WITH BREVE AND TILDE
      #x1EB5	;LATIN SMALL LETTER A WITH BREVE AND TILDE
      #x1EB6	;LATIN CAPITAL LETTER A WITH BREVE AND DOT BELOW
      #x1EB7	;LATIN SMALL LETTER A WITH BREVE AND DOT BELOW
      #x1EB8	;LATIN CAPITAL LETTER E WITH DOT BELOW
      #x1EB9	;LATIN SMALL LETTER E WITH DOT BELOW
      #x1EBA	;LATIN CAPITAL LETTER E WITH HOOK ABOVE
      #x1EBB	;LATIN SMALL LETTER E WITH HOOK ABOVE
      #x1EBC	;LATIN CAPITAL LETTER E WITH TILDE
      #x1EBD	;LATIN SMALL LETTER E WITH TILDE
      #x1EBE	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND ACUTE
      #x1EBF	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND ACUTE
      #x1EC0	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND GRAVE
      #x1EC1	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND GRAVE
      #x1EC2	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EC3	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND HOOK ABOVE
      #x1EC4	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND TILDE
      #x1EC5	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND TILDE
      #x1EC6	;LATIN CAPITAL LETTER E WITH CIRCUMFLEX AND DOT BELOW
      #x1EC7	;LATIN SMALL LETTER E WITH CIRCUMFLEX AND DOT BELOW
      #x1EC8	;LATIN CAPITAL LETTER I WITH HOOK ABOVE
      #x1EC9	;LATIN SMALL LETTER I WITH HOOK ABOVE
      #x1ECA	;LATIN CAPITAL LETTER I WITH DOT BELOW
      #x1ECB	;LATIN SMALL LETTER I WITH DOT BELOW
      #x1ECC	;LATIN CAPITAL LETTER O WITH DOT BELOW
      #x1ECD	;LATIN SMALL LETTER O WITH DOT BELOW
      #x1ECE	;LATIN CAPITAL LETTER O WITH HOOK ABOVE
      #x1ECF	;LATIN SMALL LETTER O WITH HOOK ABOVE
      #x1ED0	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND ACUTE
      #x1ED1	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND ACUTE
      #x1ED2	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND GRAVE
      #x1ED3	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND GRAVE
      #x1ED4	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
      #x1ED5	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND HOOK ABOVE
      #x1ED6	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND TILDE
      #x1ED7	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND TILDE
      #x1ED8	;LATIN CAPITAL LETTER O WITH CIRCUMFLEX AND DOT BELOW
      #x1ED9	;LATIN SMALL LETTER O WITH CIRCUMFLEX AND DOT BELOW
      #x1EDA	;LATIN CAPITAL LETTER O WITH HORN AND ACUTE
      #x1EDB	;LATIN SMALL LETTER O WITH HORN AND ACUTE
      #x1EDC	;LATIN CAPITAL LETTER O WITH HORN AND GRAVE
      #x1EDD	;LATIN SMALL LETTER O WITH HORN AND GRAVE
      #x1EDE	;LATIN CAPITAL LETTER O WITH HORN AND HOOK ABOVE
      #x1EDF	;LATIN SMALL LETTER O WITH HORN AND HOOK ABOVE
      #x1EE0	;LATIN CAPITAL LETTER O WITH HORN AND TILDE
      #x1EE1	;LATIN SMALL LETTER O WITH HORN AND TILDE
      #x1EE2	;LATIN CAPITAL LETTER O WITH HORN AND DOT BELOW
      #x1EE3	;LATIN SMALL LETTER O WITH HORN AND DOT BELOW
      #x1EE4	;LATIN CAPITAL LETTER U WITH DOT BELOW
      #x1EE5	;LATIN SMALL LETTER U WITH DOT BELOW
      #x1EE6	;LATIN CAPITAL LETTER U WITH HOOK ABOVE
      #x1EE7	;LATIN SMALL LETTER U WITH HOOK ABOVE
      #x1EE8	;LATIN CAPITAL LETTER U WITH HORN AND ACUTE
      #x1EE9	;LATIN SMALL LETTER U WITH HORN AND ACUTE
      #x1EEA	;LATIN CAPITAL LETTER U WITH HORN AND GRAVE
      #x1EEB	;LATIN SMALL LETTER U WITH HORN AND GRAVE
      #x1EEC	;LATIN CAPITAL LETTER U WITH HORN AND HOOK ABOVE
      #x1EED	;LATIN SMALL LETTER U WITH HORN AND HOOK ABOVE
      #x1EEE	;LATIN CAPITAL LETTER U WITH HORN AND TILDE
      #x1EEF	;LATIN SMALL LETTER U WITH HORN AND TILDE
      #x1EF0	;LATIN CAPITAL LETTER U WITH HORN AND DOT BELOW
      #x1EF1	;LATIN SMALL LETTER U WITH HORN AND DOT BELOW
      #x1EF2	;LATIN CAPITAL LETTER Y WITH GRAVE
      #x1EF3	;LATIN SMALL LETTER Y WITH GRAVE
      #x1EF4	;LATIN CAPITAL LETTER Y WITH DOT BELOW
      #x1EF5	;LATIN SMALL LETTER Y WITH DOT BELOW
      #x1EF6	;LATIN CAPITAL LETTER Y WITH HOOK ABOVE
      #x1EF7	;LATIN SMALL LETTER Y WITH HOOK ABOVE
      #x1EF8	;LATIN CAPITAL LETTER Y WITH TILDE
      #x1EF9	;LATIN SMALL LETTER Y WITH TILDE
      #x1F00	;GREEK SMALL LETTER ALPHA WITH PSILI
      #x1F01	;GREEK SMALL LETTER ALPHA WITH DASIA
      #x1F02	;GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA
      #x1F03	;GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA
      #x1F04	;GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA
      #x1F05	;GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA
      #x1F06	;GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI
      #x1F07	;GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI
      #x1F08	;GREEK CAPITAL LETTER ALPHA WITH PSILI
      #x1F09	;GREEK CAPITAL LETTER ALPHA WITH DASIA
      #x1F0A	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA
      #x1F0B	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA
      #x1F0C	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA
      #x1F0D	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA
      #x1F0E	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI
      #x1F0F	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI
      #x1F10	;GREEK SMALL LETTER EPSILON WITH PSILI
      #x1F11	;GREEK SMALL LETTER EPSILON WITH DASIA
      #x1F12	;GREEK SMALL LETTER EPSILON WITH PSILI AND VARIA
      #x1F13	;GREEK SMALL LETTER EPSILON WITH DASIA AND VARIA
      #x1F14	;GREEK SMALL LETTER EPSILON WITH PSILI AND OXIA
      #x1F15	;GREEK SMALL LETTER EPSILON WITH DASIA AND OXIA
      #x1F18	;GREEK CAPITAL LETTER EPSILON WITH PSILI
      #x1F19	;GREEK CAPITAL LETTER EPSILON WITH DASIA
      #x1F1A	;GREEK CAPITAL LETTER EPSILON WITH PSILI AND VARIA
      #x1F1B	;GREEK CAPITAL LETTER EPSILON WITH DASIA AND VARIA
      #x1F1C	;GREEK CAPITAL LETTER EPSILON WITH PSILI AND OXIA
      #x1F1D	;GREEK CAPITAL LETTER EPSILON WITH DASIA AND OXIA
      #x1F20	;GREEK SMALL LETTER ETA WITH PSILI
      #x1F21	;GREEK SMALL LETTER ETA WITH DASIA
      #x1F22	;GREEK SMALL LETTER ETA WITH PSILI AND VARIA
      #x1F23	;GREEK SMALL LETTER ETA WITH DASIA AND VARIA
      #x1F24	;GREEK SMALL LETTER ETA WITH PSILI AND OXIA
      #x1F25	;GREEK SMALL LETTER ETA WITH DASIA AND OXIA
      #x1F26	;GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI
      #x1F27	;GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI
      #x1F28	;GREEK CAPITAL LETTER ETA WITH PSILI
      #x1F29	;GREEK CAPITAL LETTER ETA WITH DASIA
      #x1F2A	;GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA
      #x1F2B	;GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA
      #x1F2C	;GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA
      #x1F2D	;GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA
      #x1F2E	;GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI
      #x1F2F	;GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI
      #x1F30	;GREEK SMALL LETTER IOTA WITH PSILI
      #x1F31	;GREEK SMALL LETTER IOTA WITH DASIA
      #x1F32	;GREEK SMALL LETTER IOTA WITH PSILI AND VARIA
      #x1F33	;GREEK SMALL LETTER IOTA WITH DASIA AND VARIA
      #x1F34	;GREEK SMALL LETTER IOTA WITH PSILI AND OXIA
      #x1F35	;GREEK SMALL LETTER IOTA WITH DASIA AND OXIA
      #x1F36	;GREEK SMALL LETTER IOTA WITH PSILI AND PERISPOMENI
      #x1F37	;GREEK SMALL LETTER IOTA WITH DASIA AND PERISPOMENI
      #x1F38	;GREEK CAPITAL LETTER IOTA WITH PSILI
      #x1F39	;GREEK CAPITAL LETTER IOTA WITH DASIA
      #x1F3A	;GREEK CAPITAL LETTER IOTA WITH PSILI AND VARIA
      #x1F3B	;GREEK CAPITAL LETTER IOTA WITH DASIA AND VARIA
      #x1F3C	;GREEK CAPITAL LETTER IOTA WITH PSILI AND OXIA
      #x1F3D	;GREEK CAPITAL LETTER IOTA WITH DASIA AND OXIA
      #x1F3E	;GREEK CAPITAL LETTER IOTA WITH PSILI AND PERISPOMENI
      #x1F3F	;GREEK CAPITAL LETTER IOTA WITH DASIA AND PERISPOMENI
      #x1F40	;GREEK SMALL LETTER OMICRON WITH PSILI
      #x1F41	;GREEK SMALL LETTER OMICRON WITH DASIA
      #x1F42	;GREEK SMALL LETTER OMICRON WITH PSILI AND VARIA
      #x1F43	;GREEK SMALL LETTER OMICRON WITH DASIA AND VARIA
      #x1F44	;GREEK SMALL LETTER OMICRON WITH PSILI AND OXIA
      #x1F45	;GREEK SMALL LETTER OMICRON WITH DASIA AND OXIA
      #x1F48	;GREEK CAPITAL LETTER OMICRON WITH PSILI
      #x1F49	;GREEK CAPITAL LETTER OMICRON WITH DASIA
      #x1F4A	;GREEK CAPITAL LETTER OMICRON WITH PSILI AND VARIA
      #x1F4B	;GREEK CAPITAL LETTER OMICRON WITH DASIA AND VARIA
      #x1F4C	;GREEK CAPITAL LETTER OMICRON WITH PSILI AND OXIA
      #x1F4D	;GREEK CAPITAL LETTER OMICRON WITH DASIA AND OXIA
      #x1F50	;GREEK SMALL LETTER UPSILON WITH PSILI
      #x1F51	;GREEK SMALL LETTER UPSILON WITH DASIA
      #x1F52	;GREEK SMALL LETTER UPSILON WITH PSILI AND VARIA
      #x1F53	;GREEK SMALL LETTER UPSILON WITH DASIA AND VARIA
      #x1F54	;GREEK SMALL LETTER UPSILON WITH PSILI AND OXIA
      #x1F55	;GREEK SMALL LETTER UPSILON WITH DASIA AND OXIA
      #x1F56	;GREEK SMALL LETTER UPSILON WITH PSILI AND PERISPOMENI
      #x1F57	;GREEK SMALL LETTER UPSILON WITH DASIA AND PERISPOMENI
      #x1F59	;GREEK CAPITAL LETTER UPSILON WITH DASIA
      #x1F5B	;GREEK CAPITAL LETTER UPSILON WITH DASIA AND VARIA
      #x1F5D	;GREEK CAPITAL LETTER UPSILON WITH DASIA AND OXIA
      #x1F5F	;GREEK CAPITAL LETTER UPSILON WITH DASIA AND PERISPOMENI
      #x1F60	;GREEK SMALL LETTER OMEGA WITH PSILI
      #x1F61	;GREEK SMALL LETTER OMEGA WITH DASIA
      #x1F62	;GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA
      #x1F63	;GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA
      #x1F64	;GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA
      #x1F65	;GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA
      #x1F66	;GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI
      #x1F67	;GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI
      #x1F68	;GREEK CAPITAL LETTER OMEGA WITH PSILI
      #x1F69	;GREEK CAPITAL LETTER OMEGA WITH DASIA
      #x1F6A	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA
      #x1F6B	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA
      #x1F6C	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA
      #x1F6D	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA
      #x1F6E	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI
      #x1F6F	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI
      #x1F70	;GREEK SMALL LETTER ALPHA WITH VARIA
      #x1F71	;GREEK SMALL LETTER ALPHA WITH OXIA
      #x1F72	;GREEK SMALL LETTER EPSILON WITH VARIA
      #x1F73	;GREEK SMALL LETTER EPSILON WITH OXIA
      #x1F74	;GREEK SMALL LETTER ETA WITH VARIA
      #x1F75	;GREEK SMALL LETTER ETA WITH OXIA
      #x1F76	;GREEK SMALL LETTER IOTA WITH VARIA
      #x1F77	;GREEK SMALL LETTER IOTA WITH OXIA
      #x1F78	;GREEK SMALL LETTER OMICRON WITH VARIA
      #x1F79	;GREEK SMALL LETTER OMICRON WITH OXIA
      #x1F7A	;GREEK SMALL LETTER UPSILON WITH VARIA
      #x1F7B	;GREEK SMALL LETTER UPSILON WITH OXIA
      #x1F7C	;GREEK SMALL LETTER OMEGA WITH VARIA
      #x1F7D	;GREEK SMALL LETTER OMEGA WITH OXIA
      #x1F80	;GREEK SMALL LETTER ALPHA WITH PSILI AND YPOGEGRAMMENI
      #x1F81	;GREEK SMALL LETTER ALPHA WITH DASIA AND YPOGEGRAMMENI
      #x1F82	;GREEK SMALL LETTER ALPHA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      #x1F83	;GREEK SMALL LETTER ALPHA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      #x1F84	;GREEK SMALL LETTER ALPHA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      #x1F85	;GREEK SMALL LETTER ALPHA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      #x1F86	;GREEK SMALL LETTER ALPHA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F87	;GREEK SMALL LETTER ALPHA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F88	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PROSGEGRAMMENI
      #x1F89	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PROSGEGRAMMENI
      #x1F8A	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1F8B	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1F8C	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1F8D	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1F8E	;GREEK CAPITAL LETTER ALPHA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F8F	;GREEK CAPITAL LETTER ALPHA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F90	;GREEK SMALL LETTER ETA WITH PSILI AND YPOGEGRAMMENI
      #x1F91	;GREEK SMALL LETTER ETA WITH DASIA AND YPOGEGRAMMENI
      #x1F92	;GREEK SMALL LETTER ETA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      #x1F93	;GREEK SMALL LETTER ETA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      #x1F94	;GREEK SMALL LETTER ETA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      #x1F95	;GREEK SMALL LETTER ETA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      #x1F96	;GREEK SMALL LETTER ETA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F97	;GREEK SMALL LETTER ETA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      #x1F98	;GREEK CAPITAL LETTER ETA WITH PSILI AND PROSGEGRAMMENI
      #x1F99	;GREEK CAPITAL LETTER ETA WITH DASIA AND PROSGEGRAMMENI
      #x1F9A	;GREEK CAPITAL LETTER ETA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1F9B	;GREEK CAPITAL LETTER ETA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1F9C	;GREEK CAPITAL LETTER ETA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1F9D	;GREEK CAPITAL LETTER ETA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1F9E	;GREEK CAPITAL LETTER ETA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1F9F	;GREEK CAPITAL LETTER ETA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FA0	;GREEK SMALL LETTER OMEGA WITH PSILI AND YPOGEGRAMMENI
      #x1FA1	;GREEK SMALL LETTER OMEGA WITH DASIA AND YPOGEGRAMMENI
      #x1FA2	;GREEK SMALL LETTER OMEGA WITH PSILI AND VARIA AND YPOGEGRAMMENI
      #x1FA3	;GREEK SMALL LETTER OMEGA WITH DASIA AND VARIA AND YPOGEGRAMMENI
      #x1FA4	;GREEK SMALL LETTER OMEGA WITH PSILI AND OXIA AND YPOGEGRAMMENI
      #x1FA5	;GREEK SMALL LETTER OMEGA WITH DASIA AND OXIA AND YPOGEGRAMMENI
      #x1FA6	;GREEK SMALL LETTER OMEGA WITH PSILI AND PERISPOMENI AND YPOGEGRAMMENI
      #x1FA7	;GREEK SMALL LETTER OMEGA WITH DASIA AND PERISPOMENI AND YPOGEGRAMMENI
      #x1FA8	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PROSGEGRAMMENI
      #x1FA9	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PROSGEGRAMMENI
      #x1FAA	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND VARIA AND PROSGEGRAMMENI
      #x1FAB	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND VARIA AND PROSGEGRAMMENI
      #x1FAC	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND OXIA AND PROSGEGRAMMENI
      #x1FAD	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND OXIA AND PROSGEGRAMMENI
      #x1FAE	;GREEK CAPITAL LETTER OMEGA WITH PSILI AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FAF	;GREEK CAPITAL LETTER OMEGA WITH DASIA AND PERISPOMENI AND PROSGEGRAMMENI
      #x1FB0	;GREEK SMALL LETTER ALPHA WITH VRACHY
      #x1FB1	;GREEK SMALL LETTER ALPHA WITH MACRON
      #x1FB2	;GREEK SMALL LETTER ALPHA WITH VARIA AND YPOGEGRAMMENI
      #x1FB3	;GREEK SMALL LETTER ALPHA WITH YPOGEGRAMMENI
      #x1FB4	;GREEK SMALL LETTER ALPHA WITH OXIA AND YPOGEGRAMMENI
      #x1FB6	;GREEK SMALL LETTER ALPHA WITH PERISPOMENI
      #x1FB7	;GREEK SMALL LETTER ALPHA WITH PERISPOMENI AND YPOGEGRAMMENI
      #x1FB8	;GREEK CAPITAL LETTER ALPHA WITH VRACHY
      #x1FB9	;GREEK CAPITAL LETTER ALPHA WITH MACRON
      #x1FBA	;GREEK CAPITAL LETTER ALPHA WITH VARIA
      #x1FBB	;GREEK CAPITAL LETTER ALPHA WITH OXIA
      #x1FBC	;GREEK CAPITAL LETTER ALPHA WITH PROSGEGRAMMENI
      #x1FBD	;GREEK KORONIS
      #x1FBE	;GREEK PROSGEGRAMMENI
      #x1FBF	;GREEK PSILI
      #x1FC0	;GREEK PERISPOMENI
      #x1FC1	;GREEK DIALYTIKA AND PERISPOMENI
      #x1FC2	;GREEK SMALL LETTER ETA WITH VARIA AND YPOGEGRAMMENI
      #x1FC3	;GREEK SMALL LETTER ETA WITH YPOGEGRAMMENI
      #x1FC4	;GREEK SMALL LETTER ETA WITH OXIA AND YPOGEGRAMMENI
      #x1FC6	;GREEK SMALL LETTER ETA WITH PERISPOMENI
      #x1FC7	;GREEK SMALL LETTER ETA WITH PERISPOMENI AND YPOGEGRAMMENI
      #x1FC8	;GREEK CAPITAL LETTER EPSILON WITH VARIA
      #x1FC9	;GREEK CAPITAL LETTER EPSILON WITH OXIA
      #x1FCA	;GREEK CAPITAL LETTER ETA WITH VARIA
      #x1FCB	;GREEK CAPITAL LETTER ETA WITH OXIA
      #x1FCC	;GREEK CAPITAL LETTER ETA WITH PROSGEGRAMMENI
      #x1FCD	;GREEK PSILI AND VARIA
      #x1FCE	;GREEK PSILI AND OXIA
      #x1FCF	;GREEK PSILI AND PERISPOMENI
      #x1FD0	;GREEK SMALL LETTER IOTA WITH VRACHY
      #x1FD1	;GREEK SMALL LETTER IOTA WITH MACRON
      #x1FD2	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND VARIA
      #x1FD3	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND OXIA
      #x1FD6	;GREEK SMALL LETTER IOTA WITH PERISPOMENI
      #x1FD7	;GREEK SMALL LETTER IOTA WITH DIALYTIKA AND PERISPOMENI
      #x1FD8	;GREEK CAPITAL LETTER IOTA WITH VRACHY
      #x1FD9	;GREEK CAPITAL LETTER IOTA WITH MACRON
      #x1FDA	;GREEK CAPITAL LETTER IOTA WITH VARIA
      #x1FDB	;GREEK CAPITAL LETTER IOTA WITH OXIA
      #x1FDD	;GREEK DASIA AND VARIA
      #x1FDE	;GREEK DASIA AND OXIA
      #x1FDF	;GREEK DASIA AND PERISPOMENI
      #x1FE0	;GREEK SMALL LETTER UPSILON WITH VRACHY
      #x1FE1	;GREEK SMALL LETTER UPSILON WITH MACRON
      #x1FE2	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND VARIA
      #x1FE3	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND OXIA
      #x1FE4	;GREEK SMALL LETTER RHO WITH PSILI
      #x1FE5	;GREEK SMALL LETTER RHO WITH DASIA
      #x1FE6	;GREEK SMALL LETTER UPSILON WITH PERISPOMENI
      #x1FE7	;GREEK SMALL LETTER UPSILON WITH DIALYTIKA AND PERISPOMENI
      #x1FE8	;GREEK CAPITAL LETTER UPSILON WITH VRACHY
      #x1FE9	;GREEK CAPITAL LETTER UPSILON WITH MACRON
      #x1FEA	;GREEK CAPITAL LETTER UPSILON WITH VARIA
      #x1FEB	;GREEK CAPITAL LETTER UPSILON WITH OXIA
      #x1FEC	;GREEK CAPITAL LETTER RHO WITH DASIA
      #x1FED	;GREEK DIALYTIKA AND VARIA
      #x1FEE	;GREEK DIALYTIKA AND OXIA
      #x1FEF	;GREEK VARIA
      #x1FF2	;GREEK SMALL LETTER OMEGA WITH VARIA AND YPOGEGRAMMENI
      #x1FF3	;GREEK SMALL LETTER OMEGA WITH YPOGEGRAMMENI
      #x1FF4	;GREEK SMALL LETTER OMEGA WITH OXIA AND YPOGEGRAMMENI
      #x1FF6	;GREEK SMALL LETTER OMEGA WITH PERISPOMENI
      #x1FF7	;GREEK SMALL LETTER OMEGA WITH PERISPOMENI AND YPOGEGRAMMENI
      #x1FF8	;GREEK CAPITAL LETTER OMICRON WITH VARIA
      #x1FF9	;GREEK CAPITAL LETTER OMICRON WITH OXIA
      #x1FFA	;GREEK CAPITAL LETTER OMEGA WITH VARIA
      #x1FFB	;GREEK CAPITAL LETTER OMEGA WITH OXIA
      #x1FFC	;GREEK CAPITAL LETTER OMEGA WITH PROSGEGRAMMENI
      #x1FFD	;GREEK OXIA
      #x1FFE	;GREEK DASIA
      #x2000	;EN QUAD
      #x2001	;EM QUAD
      #x2002	;EN SPACE
      #x2003	;EM SPACE
      #x2004	;THREE-PER-EM SPACE
      #x2005	;FOUR-PER-EM SPACE
      #x2006	;SIX-PER-EM SPACE
      #x2007	;FIGURE SPACE
      #x2008	;PUNCTUATION SPACE
      #x2009	;THIN SPACE
      #x200A	;HAIR SPACE
      #x200B	;ZERO WIDTH SPACE
      #x200C	;ZERO WIDTH NON-JOINER
      #x200D	;ZERO WIDTH JOINER
      #x200E	;LEFT-TO-RIGHT MARK
      #x200F	;RIGHT-TO-LEFT MARK
      #x2010	;HYPHEN
      #x2011	;NON-BREAKING HYPHEN
      #x2012	;FIGURE DASH
      #x2013	;EN DASH
      #x2014	;EM DASH
      #x2015	;HORIZONTAL BAR
      #x2016	;DOUBLE VERTICAL LINE
      #x2017	;DOUBLE LOW LINE
      #x2018	;LEFT SINGLE QUOTATION MARK
      #x2019	;RIGHT SINGLE QUOTATION MARK
      #x201A	;SINGLE LOW-9 QUOTATION MARK
      #x201B	;SINGLE HIGH-REVERSED-9 QUOTATION MARK
      #x201C	;LEFT DOUBLE QUOTATION MARK
      #x201D	;RIGHT DOUBLE QUOTATION MARK
      #x201E	;DOUBLE LOW-9 QUOTATION MARK
      #x201F	;DOUBLE HIGH-REVERSED-9 QUOTATION MARK
      #x2020	;DAGGER
      #x2021	;DOUBLE DAGGER
      #x2022	;BULLET
      #x2023	;TRIANGULAR BULLET
      #x2024	;ONE DOT LEADER
      #x2025	;TWO DOT LEADER
      #x2026	;HORIZONTAL ELLIPSIS
      #x2027	;HYPHENATION POINT
      #x2028	;LINE SEPARATOR
      #x2029	;PARAGRAPH SEPARATOR
      #x202A	;LEFT-TO-RIGHT EMBEDDING
      #x202B	;RIGHT-TO-LEFT EMBEDDING
      #x202C	;POP DIRECTIONAL FORMATTING
      #x202D	;LEFT-TO-RIGHT OVERRIDE
      #x202E	;RIGHT-TO-LEFT OVERRIDE
      #x202F	;NARROW NO-BREAK SPACE
      #x2030	;PER MILLE SIGN
      #x2031	;PER TEN THOUSAND SIGN
      #x2032	;PRIME
      #x2033	;DOUBLE PRIME
      #x2034	;TRIPLE PRIME
      #x2035	;REVERSED PRIME
      #x2036	;REVERSED DOUBLE PRIME
      #x2037	;REVERSED TRIPLE PRIME
      #x2038	;CARET
      #x2039	;SINGLE LEFT-POINTING ANGLE QUOTATION MARK
      #x203A	;SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
      #x203B	;REFERENCE MARK
      #x203C	;DOUBLE EXCLAMATION MARK
      #x203D	;INTERROBANG
      #x203E	;OVERLINE
      #x203F	;UNDERTIE
      #x2040	;CHARACTER TIE
      #x2041	;CARET INSERTION POINT
      #x2042	;ASTERISM
      #x2043	;HYPHEN BULLET
      #x2044	;FRACTION SLASH
      #x2045	;LEFT SQUARE BRACKET WITH QUILL
      #x2046	;RIGHT SQUARE BRACKET WITH QUILL
      #x2047	;DOUBLE QUESTION MARK
      #x2048	;QUESTION EXCLAMATION MARK
      #x2049	;EXCLAMATION QUESTION MARK
      #x204A	;TIRONIAN SIGN ET
      #x204B	;REVERSED PILCROW SIGN
      #x204C	;BLACK LEFTWARDS BULLET
      #x204D	;BLACK RIGHTWARDS BULLET
      #x204E	;LOW ASTERISK
      #x204F	;REVERSED SEMICOLON
      #x2050	;CLOSE UP
      #x2051	;TWO ASTERISKS ALIGNED VERTICALLY
      #x2052	;COMMERCIAL MINUS SIGN
      #x2053	;SWUNG DASH
      #x2054	;INVERTED UNDERTIE
      #x2057	;QUADRUPLE PRIME
      #x205F	;MEDIUM MATHEMATICAL SPACE
      #x2060	;WORD JOINER
      #x2061	;FUNCTION APPLICATION
      #x2062	;INVISIBLE TIMES
      #x2063	;INVISIBLE SEPARATOR
      #x206A	;INHIBIT SYMMETRIC SWAPPING
      #x206B	;ACTIVATE SYMMETRIC SWAPPING
      #x206C	;INHIBIT ARABIC FORM SHAPING
      #x206D	;ACTIVATE ARABIC FORM SHAPING
      #x206E	;NATIONAL DIGIT SHAPES
      #x206F	;NOMINAL DIGIT SHAPES
      #x2070	;SUPERSCRIPT ZERO
      #x2071	;SUPERSCRIPT LATIN SMALL LETTER I
      #x2074	;SUPERSCRIPT FOUR
      #x2075	;SUPERSCRIPT FIVE
      #x2076	;SUPERSCRIPT SIX
      #x2077	;SUPERSCRIPT SEVEN
      #x2078	;SUPERSCRIPT EIGHT
      #x2079	;SUPERSCRIPT NINE
      #x207A	;SUPERSCRIPT PLUS SIGN
      #x207B	;SUPERSCRIPT MINUS
      #x207C	;SUPERSCRIPT EQUALS SIGN
      #x207D	;SUPERSCRIPT LEFT PARENTHESIS
      #x207E	;SUPERSCRIPT RIGHT PARENTHESIS
      #x207F	;SUPERSCRIPT LATIN SMALL LETTER N
      #x2080	;SUBSCRIPT ZERO
      #x2081	;SUBSCRIPT ONE
      #x2082	;SUBSCRIPT TWO
      #x2083	;SUBSCRIPT THREE
      #x2084	;SUBSCRIPT FOUR
      #x2085	;SUBSCRIPT FIVE
      #x2086	;SUBSCRIPT SIX
      #x2087	;SUBSCRIPT SEVEN
      #x2088	;SUBSCRIPT EIGHT
      #x2089	;SUBSCRIPT NINE
      #x208A	;SUBSCRIPT PLUS SIGN
      #x208B	;SUBSCRIPT MINUS
      #x208C	;SUBSCRIPT EQUALS SIGN
      #x208D	;SUBSCRIPT LEFT PARENTHESIS
      #x208E	;SUBSCRIPT RIGHT PARENTHESIS
      #x20A0	;EURO-CURRENCY SIGN
      #x20A1	;COLON SIGN
      #x20A2	;CRUZEIRO SIGN
      #x20A3	;FRENCH FRANC SIGN
      #x20A4	;LIRA SIGN
      #x20A5	;MILL SIGN
      #x20A6	;NAIRA SIGN
      #x20A7	;PESETA SIGN
      #x20A8	;RUPEE SIGN
      #x20A9	;WON SIGN
      #x20AA	;NEW SHEQEL SIGN
      #x20AB	;DONG SIGN
      #x20AC	;EURO SIGN
      #x20AD	;KIP SIGN
      #x20AE	;TUGRIK SIGN
      #x20AF	;DRACHMA SIGN
      #x20B0	;GERMAN PENNY SIGN
      #x20B1	;PESO SIGN
      #x20D0	;COMBINING LEFT HARPOON ABOVE
      #x20D1	;COMBINING RIGHT HARPOON ABOVE
      #x20D2	;COMBINING LONG VERTICAL LINE OVERLAY
      #x20D3	;COMBINING SHORT VERTICAL LINE OVERLAY
      #x20D4	;COMBINING ANTICLOCKWISE ARROW ABOVE
      #x20D5	;COMBINING CLOCKWISE ARROW ABOVE
      #x20D6	;COMBINING LEFT ARROW ABOVE
      #x20D7	;COMBINING RIGHT ARROW ABOVE
      #x20D8	;COMBINING RING OVERLAY
      #x20D9	;COMBINING CLOCKWISE RING OVERLAY
      #x20DA	;COMBINING ANTICLOCKWISE RING OVERLAY
      #x20DB	;COMBINING THREE DOTS ABOVE
      #x20DC	;COMBINING FOUR DOTS ABOVE
      #x20DD	;COMBINING ENCLOSING CIRCLE
      #x20DE	;COMBINING ENCLOSING SQUARE
      #x20DF	;COMBINING ENCLOSING DIAMOND
      #x20E0	;COMBINING ENCLOSING CIRCLE BACKSLASH
      #x20E1	;COMBINING LEFT RIGHT ARROW ABOVE
      #x20E2	;COMBINING ENCLOSING SCREEN
      #x20E3	;COMBINING ENCLOSING KEYCAP
      #x20E4	;COMBINING ENCLOSING UPWARD POINTING TRIANGLE
      #x20E5	;COMBINING REVERSE SOLIDUS OVERLAY
      #x20E6	;COMBINING DOUBLE VERTICAL STROKE OVERLAY
      #x20E7	;COMBINING ANNUITY SYMBOL
      #x20E8	;COMBINING TRIPLE UNDERDOT
      #x20E9	;COMBINING WIDE BRIDGE ABOVE
      #x20EA	;COMBINING LEFTWARDS ARROW OVERLAY
      #x2100	;ACCOUNT OF
      #x2101	;ADDRESSED TO THE SUBJECT
      #x2102	;DOUBLE-STRUCK CAPITAL C
      #x2103	;DEGREE CELSIUS
      #x2104	;CENTRE LINE SYMBOL
      #x2105	;CARE OF
      #x2106	;CADA UNA
      #x2107	;EULER CONSTANT
      #x2108	;SCRUPLE
      #x2109	;DEGREE FAHRENHEIT
      #x210A	;SCRIPT SMALL G
      #x210B	;SCRIPT CAPITAL H
      #x210C	;BLACK-LETTER CAPITAL H
      #x210D	;DOUBLE-STRUCK CAPITAL H
      #x210E	;PLANCK CONSTANT
      #x210F	;PLANCK CONSTANT OVER TWO PI
      #x2110	;SCRIPT CAPITAL I
      #x2111	;BLACK-LETTER CAPITAL I
      #x2112	;SCRIPT CAPITAL L
      #x2113	;SCRIPT SMALL L
      #x2114	;L B BAR SYMBOL
      #x2115	;DOUBLE-STRUCK CAPITAL N
      #x2116	;NUMERO SIGN
      #x2117	;SOUND RECORDING COPYRIGHT
      #x2118	;SCRIPT CAPITAL P
      #x2119	;DOUBLE-STRUCK CAPITAL P
      #x211A	;DOUBLE-STRUCK CAPITAL Q
      #x211B	;SCRIPT CAPITAL R
      #x211C	;BLACK-LETTER CAPITAL R
      #x211D	;DOUBLE-STRUCK CAPITAL R
      #x211E	;PRESCRIPTION TAKE
      #x211F	;RESPONSE
      #x2120	;SERVICE MARK
      #x2121	;TELEPHONE SIGN
      #x2122	;TRADE MARK SIGN
      #x2123	;VERSICLE
      #x2124	;DOUBLE-STRUCK CAPITAL Z
      #x2125	;OUNCE SIGN
      #x2126	;OHM SIGN
      #x2127	;INVERTED OHM SIGN
      #x2128	;BLACK-LETTER CAPITAL Z
      #x2129	;TURNED GREEK SMALL LETTER IOTA
      #x212A	;KELVIN SIGN
      #x212B	;ANGSTROM SIGN
      #x212C	;SCRIPT CAPITAL B
      #x212D	;BLACK-LETTER CAPITAL C
      #x212E	;ESTIMATED SYMBOL
      #x212F	;SCRIPT SMALL E
      #x2130	;SCRIPT CAPITAL E
      #x2131	;SCRIPT CAPITAL F
      #x2132	;TURNED CAPITAL F
      #x2133	;SCRIPT CAPITAL M
      #x2134	;SCRIPT SMALL O
      #x2135	;ALEF SYMBOL
      #x2136	;BET SYMBOL
      #x2137	;GIMEL SYMBOL
      #x2138	;DALET SYMBOL
      #x2139	;INFORMATION SOURCE
      #x213A	;ROTATED CAPITAL Q
      #x213B	;FACSIMILE SIGN
      #x213D	;DOUBLE-STRUCK SMALL GAMMA
      #x213E	;DOUBLE-STRUCK CAPITAL GAMMA
      #x213F	;DOUBLE-STRUCK CAPITAL PI
      #x2140	;DOUBLE-STRUCK N-ARY SUMMATION
      #x2141	;TURNED SANS-SERIF CAPITAL G
      #x2142	;TURNED SANS-SERIF CAPITAL L
      #x2143	;REVERSED SANS-SERIF CAPITAL L
      #x2144	;TURNED SANS-SERIF CAPITAL Y
      #x2145	;DOUBLE-STRUCK ITALIC CAPITAL D
      #x2146	;DOUBLE-STRUCK ITALIC SMALL D
      #x2147	;DOUBLE-STRUCK ITALIC SMALL E
      #x2148	;DOUBLE-STRUCK ITALIC SMALL I
      #x2149	;DOUBLE-STRUCK ITALIC SMALL J
      #x214A	;PROPERTY LINE
      #x214B	;TURNED AMPERSAND
      #x2153	;VULGAR FRACTION ONE THIRD
      #x2154	;VULGAR FRACTION TWO THIRDS
      #x2155	;VULGAR FRACTION ONE FIFTH
      #x2156	;VULGAR FRACTION TWO FIFTHS
      #x2157	;VULGAR FRACTION THREE FIFTHS
      #x2158	;VULGAR FRACTION FOUR FIFTHS
      #x2159	;VULGAR FRACTION ONE SIXTH
      #x215A	;VULGAR FRACTION FIVE SIXTHS
      #x215B	;VULGAR FRACTION ONE EIGHTH
      #x215C	;VULGAR FRACTION THREE EIGHTHS
      #x215D	;VULGAR FRACTION FIVE EIGHTHS
      #x215E	;VULGAR FRACTION SEVEN EIGHTHS
      #x215F	;FRACTION NUMERATOR ONE
      #x2160	;ROMAN NUMERAL ONE
      #x2161	;ROMAN NUMERAL TWO
      #x2162	;ROMAN NUMERAL THREE
      #x2163	;ROMAN NUMERAL FOUR
      #x2164	;ROMAN NUMERAL FIVE
      #x2165	;ROMAN NUMERAL SIX
      #x2166	;ROMAN NUMERAL SEVEN
      #x2167	;ROMAN NUMERAL EIGHT
      #x2168	;ROMAN NUMERAL NINE
      #x2169	;ROMAN NUMERAL TEN
      #x216A	;ROMAN NUMERAL ELEVEN
      #x216B	;ROMAN NUMERAL TWELVE
      #x216C	;ROMAN NUMERAL FIFTY
      #x216D	;ROMAN NUMERAL ONE HUNDRED
      #x216E	;ROMAN NUMERAL FIVE HUNDRED
      #x216F	;ROMAN NUMERAL ONE THOUSAND
      #x2170	;SMALL ROMAN NUMERAL ONE
      #x2171	;SMALL ROMAN NUMERAL TWO
      #x2172	;SMALL ROMAN NUMERAL THREE
      #x2173	;SMALL ROMAN NUMERAL FOUR
      #x2174	;SMALL ROMAN NUMERAL FIVE
      #x2175	;SMALL ROMAN NUMERAL SIX
      #x2176	;SMALL ROMAN NUMERAL SEVEN
      #x2177	;SMALL ROMAN NUMERAL EIGHT
      #x2178	;SMALL ROMAN NUMERAL NINE
      #x2179	;SMALL ROMAN NUMERAL TEN
      #x217A	;SMALL ROMAN NUMERAL ELEVEN
      #x217B	;SMALL ROMAN NUMERAL TWELVE
      #x217C	;SMALL ROMAN NUMERAL FIFTY
      #x217D	;SMALL ROMAN NUMERAL ONE HUNDRED
      #x217E	;SMALL ROMAN NUMERAL FIVE HUNDRED
      #x217F	;SMALL ROMAN NUMERAL ONE THOUSAND
      #x2180	;ROMAN NUMERAL ONE THOUSAND C D
      #x2181	;ROMAN NUMERAL FIVE THOUSAND
      #x2182	;ROMAN NUMERAL TEN THOUSAND
      #x2183	;ROMAN NUMERAL REVERSED ONE HUNDRED
      #x2190	;LEFTWARDS ARROW
      #x2191	;UPWARDS ARROW
      #x2192	;RIGHTWARDS ARROW
      #x2193	;DOWNWARDS ARROW
      #x2194	;LEFT RIGHT ARROW
      #x2195	;UP DOWN ARROW
      #x2196	;NORTH WEST ARROW
      #x2197	;NORTH EAST ARROW
      #x2198	;SOUTH EAST ARROW
      #x2199	;SOUTH WEST ARROW
      #x219A	;LEFTWARDS ARROW WITH STROKE
      #x219B	;RIGHTWARDS ARROW WITH STROKE
      #x219C	;LEFTWARDS WAVE ARROW
      #x219D	;RIGHTWARDS WAVE ARROW
      #x219E	;LEFTWARDS TWO HEADED ARROW
      #x219F	;UPWARDS TWO HEADED ARROW
      #x21A0	;RIGHTWARDS TWO HEADED ARROW
      #x21A1	;DOWNWARDS TWO HEADED ARROW
      #x21A2	;LEFTWARDS ARROW WITH TAIL
      #x21A3	;RIGHTWARDS ARROW WITH TAIL
      #x21A4	;LEFTWARDS ARROW FROM BAR
      #x21A5	;UPWARDS ARROW FROM BAR
      #x21A6	;RIGHTWARDS ARROW FROM BAR
      #x21A7	;DOWNWARDS ARROW FROM BAR
      #x21A8	;UP DOWN ARROW WITH BASE
      #x21A9	;LEFTWARDS ARROW WITH HOOK
      #x21AA	;RIGHTWARDS ARROW WITH HOOK
      #x21AB	;LEFTWARDS ARROW WITH LOOP
      #x21AC	;RIGHTWARDS ARROW WITH LOOP
      #x21AD	;LEFT RIGHT WAVE ARROW
      #x21AE	;LEFT RIGHT ARROW WITH STROKE
      #x21AF	;DOWNWARDS ZIGZAG ARROW
      #x21B0	;UPWARDS ARROW WITH TIP LEFTWARDS
      #x21B1	;UPWARDS ARROW WITH TIP RIGHTWARDS
      #x21B2	;DOWNWARDS ARROW WITH TIP LEFTWARDS
      #x21B3	;DOWNWARDS ARROW WITH TIP RIGHTWARDS
      #x21B4	;RIGHTWARDS ARROW WITH CORNER DOWNWARDS
      #x21B5	;DOWNWARDS ARROW WITH CORNER LEFTWARDS
      #x21B6	;ANTICLOCKWISE TOP SEMICIRCLE ARROW
      #x21B7	;CLOCKWISE TOP SEMICIRCLE ARROW
      #x21B8	;NORTH WEST ARROW TO LONG BAR
      #x21B9	;LEFTWARDS ARROW TO BAR OVER RIGHTWARDS ARROW TO BAR
      #x21BA	;ANTICLOCKWISE OPEN CIRCLE ARROW
      #x21BB	;CLOCKWISE OPEN CIRCLE ARROW
      #x21BC	;LEFTWARDS HARPOON WITH BARB UPWARDS
      #x21BD	;LEFTWARDS HARPOON WITH BARB DOWNWARDS
      #x21BE	;UPWARDS HARPOON WITH BARB RIGHTWARDS
      #x21BF	;UPWARDS HARPOON WITH BARB LEFTWARDS
      #x21C0	;RIGHTWARDS HARPOON WITH BARB UPWARDS
      #x21C1	;RIGHTWARDS HARPOON WITH BARB DOWNWARDS
      #x21C2	;DOWNWARDS HARPOON WITH BARB RIGHTWARDS
      #x21C3	;DOWNWARDS HARPOON WITH BARB LEFTWARDS
      #x21C4	;RIGHTWARDS ARROW OVER LEFTWARDS ARROW
      #x21C5	;UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW
      #x21C6	;LEFTWARDS ARROW OVER RIGHTWARDS ARROW
      #x21C7	;LEFTWARDS PAIRED ARROWS
      #x21C8	;UPWARDS PAIRED ARROWS
      #x21C9	;RIGHTWARDS PAIRED ARROWS
      #x21CA	;DOWNWARDS PAIRED ARROWS
      #x21CB	;LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON
      #x21CC	;RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON
      #x21CD	;LEFTWARDS DOUBLE ARROW WITH STROKE
      #x21CE	;LEFT RIGHT DOUBLE ARROW WITH STROKE
      #x21CF	;RIGHTWARDS DOUBLE ARROW WITH STROKE
      #x21D0	;LEFTWARDS DOUBLE ARROW
      #x21D1	;UPWARDS DOUBLE ARROW
      #x21D2	;RIGHTWARDS DOUBLE ARROW
      #x21D3	;DOWNWARDS DOUBLE ARROW
      #x21D4	;LEFT RIGHT DOUBLE ARROW
      #x21D5	;UP DOWN DOUBLE ARROW
      #x21D6	;NORTH WEST DOUBLE ARROW
      #x21D7	;NORTH EAST DOUBLE ARROW
      #x21D8	;SOUTH EAST DOUBLE ARROW
      #x21D9	;SOUTH WEST DOUBLE ARROW
      #x21DA	;LEFTWARDS TRIPLE ARROW
      #x21DB	;RIGHTWARDS TRIPLE ARROW
      #x21DC	;LEFTWARDS SQUIGGLE ARROW
      #x21DD	;RIGHTWARDS SQUIGGLE ARROW
      #x21DE	;UPWARDS ARROW WITH DOUBLE STROKE
      #x21DF	;DOWNWARDS ARROW WITH DOUBLE STROKE
      #x21E0	;LEFTWARDS DASHED ARROW
      #x21E1	;UPWARDS DASHED ARROW
      #x21E2	;RIGHTWARDS DASHED ARROW
      #x21E3	;DOWNWARDS DASHED ARROW
      #x21E4	;LEFTWARDS ARROW TO BAR
      #x21E5	;RIGHTWARDS ARROW TO BAR
      #x21E6	;LEFTWARDS WHITE ARROW
      #x21E7	;UPWARDS WHITE ARROW
      #x21E8	;RIGHTWARDS WHITE ARROW
      #x21E9	;DOWNWARDS WHITE ARROW
      #x21EA	;UPWARDS WHITE ARROW FROM BAR
      #x21EB	;UPWARDS WHITE ARROW ON PEDESTAL
      #x21EC	;UPWARDS WHITE ARROW ON PEDESTAL WITH HORIZONTAL BAR
      #x21ED	;UPWARDS WHITE ARROW ON PEDESTAL WITH VERTICAL BAR
      #x21EE	;UPWARDS WHITE DOUBLE ARROW
      #x21EF	;UPWARDS WHITE DOUBLE ARROW ON PEDESTAL
      #x21F0	;RIGHTWARDS WHITE ARROW FROM WALL
      #x21F1	;NORTH WEST ARROW TO CORNER
      #x21F2	;SOUTH EAST ARROW TO CORNER
      #x21F3	;UP DOWN WHITE ARROW
      #x21F4	;RIGHT ARROW WITH SMALL CIRCLE
      #x21F5	;DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW
      #x21F6	;THREE RIGHTWARDS ARROWS
      #x21F7	;LEFTWARDS ARROW WITH VERTICAL STROKE
      #x21F8	;RIGHTWARDS ARROW WITH VERTICAL STROKE
      #x21F9	;LEFT RIGHT ARROW WITH VERTICAL STROKE
      #x21FA	;LEFTWARDS ARROW WITH DOUBLE VERTICAL STROKE
      #x21FB	;RIGHTWARDS ARROW WITH DOUBLE VERTICAL STROKE
      #x21FC	;LEFT RIGHT ARROW WITH DOUBLE VERTICAL STROKE
      #x21FD	;LEFTWARDS OPEN-HEADED ARROW
      #x21FE	;RIGHTWARDS OPEN-HEADED ARROW
      #x21FF	;LEFT RIGHT OPEN-HEADED ARROW
      #x2200	;FOR ALL
      #x2201	;COMPLEMENT
      #x2202	;PARTIAL DIFFERENTIAL
      #x2203	;THERE EXISTS
      #x2204	;THERE DOES NOT EXIST
      #x2205	;EMPTY SET
      #x2206	;INCREMENT
      #x2207	;NABLA
      #x2208	;ELEMENT OF
      #x2209	;NOT AN ELEMENT OF
      #x220A	;SMALL ELEMENT OF
      #x220B	;CONTAINS AS MEMBER
      #x220C	;DOES NOT CONTAIN AS MEMBER
      #x220D	;SMALL CONTAINS AS MEMBER
      #x220E	;END OF PROOF
      #x220F	;N-ARY PRODUCT
      #x2210	;N-ARY COPRODUCT
      #x2211	;N-ARY SUMMATION
      #x2212	;MINUS SIGN
      #x2213	;MINUS-OR-PLUS SIGN
      #x2214	;DOT PLUS
      #x2215	;DIVISION SLASH
      #x2216	;SET MINUS
      #x2217	;ASTERISK OPERATOR
      #x2218	;RING OPERATOR
      #x2219	;BULLET OPERATOR
      #x221A	;SQUARE ROOT
      #x221B	;CUBE ROOT
      #x221C	;FOURTH ROOT
      #x221D	;PROPORTIONAL TO
      #x221E	;INFINITY
      #x221F	;RIGHT ANGLE
      #x2220	;ANGLE
      #x2221	;MEASURED ANGLE
      #x2222	;SPHERICAL ANGLE
      #x2223	;DIVIDES
      #x2224	;DOES NOT DIVIDE
      #x2225	;PARALLEL TO
      #x2226	;NOT PARALLEL TO
      #x2227	;LOGICAL AND
      #x2228	;LOGICAL OR
      #x2229	;INTERSECTION
      #x222A	;UNION
      #x222B	;INTEGRAL
      #x222C	;DOUBLE INTEGRAL
      #x222D	;TRIPLE INTEGRAL
      #x222E	;CONTOUR INTEGRAL
      #x222F	;SURFACE INTEGRAL
      #x2230	;VOLUME INTEGRAL
      #x2231	;CLOCKWISE INTEGRAL
      #x2232	;CLOCKWISE CONTOUR INTEGRAL
      #x2233	;ANTICLOCKWISE CONTOUR INTEGRAL
      #x2234	;THEREFORE
      #x2235	;BECAUSE
      #x2236	;RATIO
      #x2237	;PROPORTION
      #x2238	;DOT MINUS
      #x2239	;EXCESS
      #x223A	;GEOMETRIC PROPORTION
      #x223B	;HOMOTHETIC
      #x223C	;TILDE OPERATOR
      #x223D	;REVERSED TILDE
      #x223E	;INVERTED LAZY S
      #x223F	;SINE WAVE
      #x2240	;WREATH PRODUCT
      #x2241	;NOT TILDE
      #x2242	;MINUS TILDE
      #x2243	;ASYMPTOTICALLY EQUAL TO
      #x2244	;NOT ASYMPTOTICALLY EQUAL TO
      #x2245	;APPROXIMATELY EQUAL TO
      #x2246	;APPROXIMATELY BUT NOT ACTUALLY EQUAL TO
      #x2247	;NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
      #x2248	;ALMOST EQUAL TO
      #x2249	;NOT ALMOST EQUAL TO
      #x224A	;ALMOST EQUAL OR EQUAL TO
      #x224B	;TRIPLE TILDE
      #x224C	;ALL EQUAL TO
      #x224D	;EQUIVALENT TO
      #x224E	;GEOMETRICALLY EQUIVALENT TO
      #x224F	;DIFFERENCE BETWEEN
      #x2250	;APPROACHES THE LIMIT
      #x2251	;GEOMETRICALLY EQUAL TO
      #x2252	;APPROXIMATELY EQUAL TO OR THE IMAGE OF
      #x2253	;IMAGE OF OR APPROXIMATELY EQUAL TO
      #x2254	;COLON EQUALS
      #x2255	;EQUALS COLON
      #x2256	;RING IN EQUAL TO
      #x2257	;RING EQUAL TO
      #x2258	;CORRESPONDS TO
      #x2259	;ESTIMATES
      #x225A	;EQUIANGULAR TO
      #x225B	;STAR EQUALS
      #x225C	;DELTA EQUAL TO
      #x225D	;EQUAL TO BY DEFINITION
      #x225E	;MEASURED BY
      #x225F	;QUESTIONED EQUAL TO
      #x2260	;NOT EQUAL TO
      #x2261	;IDENTICAL TO
      #x2262	;NOT IDENTICAL TO
      #x2263	;STRICTLY EQUIVALENT TO
      #x2264	;LESS-THAN OR EQUAL TO
      #x2265	;GREATER-THAN OR EQUAL TO
      #x2266	;LESS-THAN OVER EQUAL TO
      #x2267	;GREATER-THAN OVER EQUAL TO
      #x2268	;LESS-THAN BUT NOT EQUAL TO
      #x2269	;GREATER-THAN BUT NOT EQUAL TO
      #x226A	;MUCH LESS-THAN
      #x226B	;MUCH GREATER-THAN
      #x226C	;BETWEEN
      #x226D	;NOT EQUIVALENT TO
      #x226E	;NOT LESS-THAN
      #x226F	;NOT GREATER-THAN
      #x2270	;NEITHER LESS-THAN NOR EQUAL TO
      #x2271	;NEITHER GREATER-THAN NOR EQUAL TO
      #x2272	;LESS-THAN OR EQUIVALENT TO
      #x2273	;GREATER-THAN OR EQUIVALENT TO
      #x2274	;NEITHER LESS-THAN NOR EQUIVALENT TO
      #x2275	;NEITHER GREATER-THAN NOR EQUIVALENT TO
      #x2276	;LESS-THAN OR GREATER-THAN
      #x2277	;GREATER-THAN OR LESS-THAN
      #x2278	;NEITHER LESS-THAN NOR GREATER-THAN
      #x2279	;NEITHER GREATER-THAN NOR LESS-THAN
      #x227A	;PRECEDES
      #x227B	;SUCCEEDS
      #x227C	;PRECEDES OR EQUAL TO
      #x227D	;SUCCEEDS OR EQUAL TO
      #x227E	;PRECEDES OR EQUIVALENT TO
      #x227F	;SUCCEEDS OR EQUIVALENT TO
      #x2280	;DOES NOT PRECEDE
      #x2281	;DOES NOT SUCCEED
      #x2282	;SUBSET OF
      #x2283	;SUPERSET OF
      #x2284	;NOT A SUBSET OF
      #x2285	;NOT A SUPERSET OF
      #x2286	;SUBSET OF OR EQUAL TO
      #x2287	;SUPERSET OF OR EQUAL TO
      #x2288	;NEITHER A SUBSET OF NOR EQUAL TO
      #x2289	;NEITHER A SUPERSET OF NOR EQUAL TO
      #x228A	;SUBSET OF WITH NOT EQUAL TO
      #x228B	;SUPERSET OF WITH NOT EQUAL TO
      #x228C	;MULTISET
      #x228D	;MULTISET MULTIPLICATION
      #x228E	;MULTISET UNION
      #x228F	;SQUARE IMAGE OF
      #x2290	;SQUARE ORIGINAL OF
      #x2291	;SQUARE IMAGE OF OR EQUAL TO
      #x2292	;SQUARE ORIGINAL OF OR EQUAL TO
      #x2293	;SQUARE CAP
      #x2294	;SQUARE CUP
      #x2295	;CIRCLED PLUS
      #x2296	;CIRCLED MINUS
      #x2297	;CIRCLED TIMES
      #x2298	;CIRCLED DIVISION SLASH
      #x2299	;CIRCLED DOT OPERATOR
      #x229A	;CIRCLED RING OPERATOR
      #x229B	;CIRCLED ASTERISK OPERATOR
      #x229C	;CIRCLED EQUALS
      #x229D	;CIRCLED DASH
      #x229E	;SQUARED PLUS
      #x229F	;SQUARED MINUS
      #x22A0	;SQUARED TIMES
      #x22A1	;SQUARED DOT OPERATOR
      #x22A2	;RIGHT TACK
      #x22A3	;LEFT TACK
      #x22A4	;DOWN TACK
      #x22A5	;UP TACK
      #x22A6	;ASSERTION
      #x22A7	;MODELS
      #x22A8	;TRUE
      #x22A9	;FORCES
      #x22AA	;TRIPLE VERTICAL BAR RIGHT TURNSTILE
      #x22AB	;DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
      #x22AC	;DOES NOT PROVE
      #x22AD	;NOT TRUE
      #x22AE	;DOES NOT FORCE
      #x22AF	;NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
      #x22B0	;PRECEDES UNDER RELATION
      #x22B1	;SUCCEEDS UNDER RELATION
      #x22B2	;NORMAL SUBGROUP OF
      #x22B3	;CONTAINS AS NORMAL SUBGROUP
      #x22B4	;NORMAL SUBGROUP OF OR EQUAL TO
      #x22B5	;CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
      #x22B6	;ORIGINAL OF
      #x22B7	;IMAGE OF
      #x22B8	;MULTIMAP
      #x22B9	;HERMITIAN CONJUGATE MATRIX
      #x22BA	;INTERCALATE
      #x22BB	;XOR
      #x22BC	;NAND
      #x22BD	;NOR
      #x22BE	;RIGHT ANGLE WITH ARC
      #x22BF	;RIGHT TRIANGLE
      #x22C0	;N-ARY LOGICAL AND
      #x22C1	;N-ARY LOGICAL OR
      #x22C2	;N-ARY INTERSECTION
      #x22C3	;N-ARY UNION
      #x22C4	;DIAMOND OPERATOR
      #x22C5	;DOT OPERATOR
      #x22C6	;STAR OPERATOR
      #x22C7	;DIVISION TIMES
      #x22C8	;BOWTIE
      #x22C9	;LEFT NORMAL FACTOR SEMIDIRECT PRODUCT
      #x22CA	;RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT
      #x22CB	;LEFT SEMIDIRECT PRODUCT
      #x22CC	;RIGHT SEMIDIRECT PRODUCT
      #x22CD	;REVERSED TILDE EQUALS
      #x22CE	;CURLY LOGICAL OR
      #x22CF	;CURLY LOGICAL AND
      #x22D0	;DOUBLE SUBSET
      #x22D1	;DOUBLE SUPERSET
      #x22D2	;DOUBLE INTERSECTION
      #x22D3	;DOUBLE UNION
      #x22D4	;PITCHFORK
      #x22D5	;EQUAL AND PARALLEL TO
      #x22D6	;LESS-THAN WITH DOT
      #x22D7	;GREATER-THAN WITH DOT
      #x22D8	;VERY MUCH LESS-THAN
      #x22D9	;VERY MUCH GREATER-THAN
      #x22DA	;LESS-THAN EQUAL TO OR GREATER-THAN
      #x22DB	;GREATER-THAN EQUAL TO OR LESS-THAN
      #x22DC	;EQUAL TO OR LESS-THAN
      #x22DD	;EQUAL TO OR GREATER-THAN
      #x22DE	;EQUAL TO OR PRECEDES
      #x22DF	;EQUAL TO OR SUCCEEDS
      #x22E0	;DOES NOT PRECEDE OR EQUAL
      #x22E1	;DOES NOT SUCCEED OR EQUAL
      #x22E2	;NOT SQUARE IMAGE OF OR EQUAL TO
      #x22E3	;NOT SQUARE ORIGINAL OF OR EQUAL TO
      #x22E4	;SQUARE IMAGE OF OR NOT EQUAL TO
      #x22E5	;SQUARE ORIGINAL OF OR NOT EQUAL TO
      #x22E6	;LESS-THAN BUT NOT EQUIVALENT TO
      #x22E7	;GREATER-THAN BUT NOT EQUIVALENT TO
      #x22E8	;PRECEDES BUT NOT EQUIVALENT TO
      #x22E9	;SUCCEEDS BUT NOT EQUIVALENT TO
      #x22EA	;NOT NORMAL SUBGROUP OF
      #x22EB	;DOES NOT CONTAIN AS NORMAL SUBGROUP
      #x22EC	;NOT NORMAL SUBGROUP OF OR EQUAL TO
      #x22ED	;DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
      #x22EE	;VERTICAL ELLIPSIS
      #x22EF	;MIDLINE HORIZONTAL ELLIPSIS
      #x22F0	;UP RIGHT DIAGONAL ELLIPSIS
      #x22F1	;DOWN RIGHT DIAGONAL ELLIPSIS
      #x22F2	;ELEMENT OF WITH LONG HORIZONTAL STROKE
      #x22F3	;ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
      #x22F4	;SMALL ELEMENT OF WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
      #x22F5	;ELEMENT OF WITH DOT ABOVE
      #x22F6	;ELEMENT OF WITH OVERBAR
      #x22F7	;SMALL ELEMENT OF WITH OVERBAR
      #x22F8	;ELEMENT OF WITH UNDERBAR
      #x22F9	;ELEMENT OF WITH TWO HORIZONTAL STROKES
      #x22FA	;CONTAINS WITH LONG HORIZONTAL STROKE
      #x22FB	;CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
      #x22FC	;SMALL CONTAINS WITH VERTICAL BAR AT END OF HORIZONTAL STROKE
      #x22FD	;CONTAINS WITH OVERBAR
      #x22FE	;SMALL CONTAINS WITH OVERBAR
      #x22FF	;Z NOTATION BAG MEMBERSHIP
      #x2300	;DIAMETER SIGN
      #x2301	;ELECTRIC ARROW
      #x2302	;HOUSE
      #x2303	;UP ARROWHEAD
      #x2304	;DOWN ARROWHEAD
      #x2305	;PROJECTIVE
      #x2306	;PERSPECTIVE
      #x2307	;WAVY LINE
      #x2308	;LEFT CEILING
      #x2309	;RIGHT CEILING
      #x230A	;LEFT FLOOR
      #x230B	;RIGHT FLOOR
      #x230C	;BOTTOM RIGHT CROP
      #x230D	;BOTTOM LEFT CROP
      #x230E	;TOP RIGHT CROP
      #x230F	;TOP LEFT CROP
      #x2310	;REVERSED NOT SIGN
      #x2311	;SQUARE LOZENGE
      #x2312	;ARC
      #x2313	;SEGMENT
      #x2314	;SECTOR
      #x2315	;TELEPHONE RECORDER
      #x2316	;POSITION INDICATOR
      #x2317	;VIEWDATA SQUARE
      #x2318	;PLACE OF INTEREST SIGN
      #x2319	;TURNED NOT SIGN
      #x231A	;WATCH
      #x231B	;HOURGLASS
      #x231C	;TOP LEFT CORNER
      #x231D	;TOP RIGHT CORNER
      #x231E	;BOTTOM LEFT CORNER
      #x231F	;BOTTOM RIGHT CORNER
      #x2320	;TOP HALF INTEGRAL
      #x2321	;BOTTOM HALF INTEGRAL
      #x2322	;FROWN
      #x2323	;SMILE
      #x2324	;UP ARROWHEAD BETWEEN TWO HORIZONTAL BARS
      #x2325	;OPTION KEY
      #x2326	;ERASE TO THE RIGHT
      #x2327	;X IN A RECTANGLE BOX
      #x2328	;KEYBOARD
      #x2329	;LEFT-POINTING ANGLE BRACKET
      #x232A	;RIGHT-POINTING ANGLE BRACKET
      #x232B	;ERASE TO THE LEFT
      #x232C	;BENZENE RING
      #x232D	;CYLINDRICITY
      #x232E	;ALL AROUND-PROFILE
      #x232F	;SYMMETRY
      #x2330	;TOTAL RUNOUT
      #x2331	;DIMENSION ORIGIN
      #x2332	;CONICAL TAPER
      #x2333	;SLOPE
      #x2334	;COUNTERBORE
      #x2335	;COUNTERSINK
      #x2336	;APL FUNCTIONAL SYMBOL I-BEAM
      #x2337	;APL FUNCTIONAL SYMBOL SQUISH QUAD
      #x2338	;APL FUNCTIONAL SYMBOL QUAD EQUAL
      #x2339	;APL FUNCTIONAL SYMBOL QUAD DIVIDE
      #x233A	;APL FUNCTIONAL SYMBOL QUAD DIAMOND
      #x233B	;APL FUNCTIONAL SYMBOL QUAD JOT
      #x233C	;APL FUNCTIONAL SYMBOL QUAD CIRCLE
      #x233D	;APL FUNCTIONAL SYMBOL CIRCLE STILE
      #x233E	;APL FUNCTIONAL SYMBOL CIRCLE JOT
      #x233F	;APL FUNCTIONAL SYMBOL SLASH BAR
      #x2340	;APL FUNCTIONAL SYMBOL BACKSLASH BAR
      #x2341	;APL FUNCTIONAL SYMBOL QUAD SLASH
      #x2342	;APL FUNCTIONAL SYMBOL QUAD BACKSLASH
      #x2343	;APL FUNCTIONAL SYMBOL QUAD LESS-THAN
      #x2344	;APL FUNCTIONAL SYMBOL QUAD GREATER-THAN
      #x2345	;APL FUNCTIONAL SYMBOL LEFTWARDS VANE
      #x2346	;APL FUNCTIONAL SYMBOL RIGHTWARDS VANE
      #x2347	;APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW
      #x2348	;APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW
      #x2349	;APL FUNCTIONAL SYMBOL CIRCLE BACKSLASH
      #x234A	;APL FUNCTIONAL SYMBOL DOWN TACK UNDERBAR
      #x234B	;APL FUNCTIONAL SYMBOL DELTA STILE
      #x234C	;APL FUNCTIONAL SYMBOL QUAD DOWN CARET
      #x234D	;APL FUNCTIONAL SYMBOL QUAD DELTA
      #x234E	;APL FUNCTIONAL SYMBOL DOWN TACK JOT
      #x234F	;APL FUNCTIONAL SYMBOL UPWARDS VANE
      #x2350	;APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW
      #x2351	;APL FUNCTIONAL SYMBOL UP TACK OVERBAR
      #x2352	;APL FUNCTIONAL SYMBOL DEL STILE
      #x2353	;APL FUNCTIONAL SYMBOL QUAD UP CARET
      #x2354	;APL FUNCTIONAL SYMBOL QUAD DEL
      #x2355	;APL FUNCTIONAL SYMBOL UP TACK JOT
      #x2356	;APL FUNCTIONAL SYMBOL DOWNWARDS VANE
      #x2357	;APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW
      #x2358	;APL FUNCTIONAL SYMBOL QUOTE UNDERBAR
      #x2359	;APL FUNCTIONAL SYMBOL DELTA UNDERBAR
      #x235A	;APL FUNCTIONAL SYMBOL DIAMOND UNDERBAR
      #x235B	;APL FUNCTIONAL SYMBOL JOT UNDERBAR
      #x235C	;APL FUNCTIONAL SYMBOL CIRCLE UNDERBAR
      #x235D	;APL FUNCTIONAL SYMBOL UP SHOE JOT
      #x235E	;APL FUNCTIONAL SYMBOL QUOTE QUAD
      #x235F	;APL FUNCTIONAL SYMBOL CIRCLE STAR
      #x2360	;APL FUNCTIONAL SYMBOL QUAD COLON
      #x2361	;APL FUNCTIONAL SYMBOL UP TACK DIAERESIS
      #x2362	;APL FUNCTIONAL SYMBOL DEL DIAERESIS
      #x2363	;APL FUNCTIONAL SYMBOL STAR DIAERESIS
      #x2364	;APL FUNCTIONAL SYMBOL JOT DIAERESIS
      #x2365	;APL FUNCTIONAL SYMBOL CIRCLE DIAERESIS
      #x2366	;APL FUNCTIONAL SYMBOL DOWN SHOE STILE
      #x2367	;APL FUNCTIONAL SYMBOL LEFT SHOE STILE
      #x2368	;APL FUNCTIONAL SYMBOL TILDE DIAERESIS
      #x2369	;APL FUNCTIONAL SYMBOL GREATER-THAN DIAERESIS
      #x236A	;APL FUNCTIONAL SYMBOL COMMA BAR
      #x236B	;APL FUNCTIONAL SYMBOL DEL TILDE
      #x236C	;APL FUNCTIONAL SYMBOL ZILDE
      #x236D	;APL FUNCTIONAL SYMBOL STILE TILDE
      #x236E	;APL FUNCTIONAL SYMBOL SEMICOLON UNDERBAR
      #x236F	;APL FUNCTIONAL SYMBOL QUAD NOT EQUAL
      #x2370	;APL FUNCTIONAL SYMBOL QUAD QUESTION
      #x2371	;APL FUNCTIONAL SYMBOL DOWN CARET TILDE
      #x2372	;APL FUNCTIONAL SYMBOL UP CARET TILDE
      #x2373	;APL FUNCTIONAL SYMBOL IOTA
      #x2374	;APL FUNCTIONAL SYMBOL RHO
      #x2375	;APL FUNCTIONAL SYMBOL OMEGA
      #x2376	;APL FUNCTIONAL SYMBOL ALPHA UNDERBAR
      #x2377	;APL FUNCTIONAL SYMBOL EPSILON UNDERBAR
      #x2378	;APL FUNCTIONAL SYMBOL IOTA UNDERBAR
      #x2379	;APL FUNCTIONAL SYMBOL OMEGA UNDERBAR
      #x237A	;APL FUNCTIONAL SYMBOL ALPHA
      #x237B	;NOT CHECK MARK
      #x237C	;RIGHT ANGLE WITH DOWNWARDS ZIGZAG ARROW
      #x237D	;SHOULDERED OPEN BOX
      #x237E	;BELL SYMBOL
      #x237F	;VERTICAL LINE WITH MIDDLE DOT
      #x2380	;INSERTION SYMBOL
      #x2381	;CONTINUOUS UNDERLINE SYMBOL
      #x2382	;DISCONTINUOUS UNDERLINE SYMBOL
      #x2383	;EMPHASIS SYMBOL
      #x2384	;COMPOSITION SYMBOL
      #x2385	;WHITE SQUARE WITH CENTRE VERTICAL LINE
      #x2386	;ENTER SYMBOL
      #x2387	;ALTERNATIVE KEY SYMBOL
      #x2388	;HELM SYMBOL
      #x2389	;CIRCLED HORIZONTAL BAR WITH NOTCH
      #x238A	;CIRCLED TRIANGLE DOWN
      #x238B	;BROKEN CIRCLE WITH NORTHWEST ARROW
      #x238C	;UNDO SYMBOL
      #x238D	;MONOSTABLE SYMBOL
      #x238E	;HYSTERESIS SYMBOL
      #x238F	;OPEN-CIRCUIT-OUTPUT H-TYPE SYMBOL
      #x2390	;OPEN-CIRCUIT-OUTPUT L-TYPE SYMBOL
      #x2391	;PASSIVE-PULL-DOWN-OUTPUT SYMBOL
      #x2392	;PASSIVE-PULL-UP-OUTPUT SYMBOL
      #x2393	;DIRECT CURRENT SYMBOL FORM TWO
      #x2394	;SOFTWARE-FUNCTION SYMBOL
      #x2395	;APL FUNCTIONAL SYMBOL QUAD
      #x2396	;DECIMAL SEPARATOR KEY SYMBOL
      #x2397	;PREVIOUS PAGE
      #x2398	;NEXT PAGE
      #x2399	;PRINT SCREEN SYMBOL
      #x239A	;CLEAR SCREEN SYMBOL
      #x239B	;LEFT PARENTHESIS UPPER HOOK
      #x239C	;LEFT PARENTHESIS EXTENSION
      #x239D	;LEFT PARENTHESIS LOWER HOOK
      #x239E	;RIGHT PARENTHESIS UPPER HOOK
      #x239F	;RIGHT PARENTHESIS EXTENSION
      #x23A0	;RIGHT PARENTHESIS LOWER HOOK
      #x23A1	;LEFT SQUARE BRACKET UPPER CORNER
      #x23A2	;LEFT SQUARE BRACKET EXTENSION
      #x23A3	;LEFT SQUARE BRACKET LOWER CORNER
      #x23A4	;RIGHT SQUARE BRACKET UPPER CORNER
      #x23A5	;RIGHT SQUARE BRACKET EXTENSION
      #x23A6	;RIGHT SQUARE BRACKET LOWER CORNER
      #x23A7	;LEFT CURLY BRACKET UPPER HOOK
      #x23A8	;LEFT CURLY BRACKET MIDDLE PIECE
      #x23A9	;LEFT CURLY BRACKET LOWER HOOK
      #x23AA	;CURLY BRACKET EXTENSION
      #x23AB	;RIGHT CURLY BRACKET UPPER HOOK
      #x23AC	;RIGHT CURLY BRACKET MIDDLE PIECE
      #x23AD	;RIGHT CURLY BRACKET LOWER HOOK
      #x23AE	;INTEGRAL EXTENSION
      #x23AF	;HORIZONTAL LINE EXTENSION
      #x23B0	;UPPER LEFT OR LOWER RIGHT CURLY BRACKET SECTION
      #x23B1	;UPPER RIGHT OR LOWER LEFT CURLY BRACKET SECTION
      #x23B2	;SUMMATION TOP
      #x23B3	;SUMMATION BOTTOM
      #x23B4	;TOP SQUARE BRACKET
      #x23B5	;BOTTOM SQUARE BRACKET
      #x23B6	;BOTTOM SQUARE BRACKET OVER TOP SQUARE BRACKET
      #x23B7	;RADICAL SYMBOL BOTTOM
      #x23B8	;LEFT VERTICAL BOX LINE
      #x23B9	;RIGHT VERTICAL BOX LINE
      #x23BA	;HORIZONTAL SCAN LINE-1
      #x23BB	;HORIZONTAL SCAN LINE-3
      #x23BC	;HORIZONTAL SCAN LINE-7
      #x23BD	;HORIZONTAL SCAN LINE-9
      #x23BE	;DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT
      #x23BF	;DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT
      #x23C0	;DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE
      #x23C1	;DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE
      #x23C2	;DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE
      #x23C3	;DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE
      #x23C4	;DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE
      #x23C5	;DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE
      #x23C6	;DENTISTRY SYMBOL LIGHT VERTICAL AND WAVE
      #x23C7	;DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE
      #x23C8	;DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE
      #x23C9	;DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL
      #x23CA	;DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL
      #x23CB	;DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT
      #x23CC	;DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT
      #x23CD	;SQUARE FOOT
      #x23CE	;RETURN SYMBOL
      #x23CF	;EJECT SYMBOL
      #x23D0	;VERTICAL LINE EXTENSION
      #x2400	;SYMBOL FOR NULL
      #x2401	;SYMBOL FOR START OF HEADING
      #x2402	;SYMBOL FOR START OF TEXT
      #x2403	;SYMBOL FOR END OF TEXT
      #x2404	;SYMBOL FOR END OF TRANSMISSION
      #x2405	;SYMBOL FOR ENQUIRY
      #x2406	;SYMBOL FOR ACKNOWLEDGE
      #x2407	;SYMBOL FOR BELL
      #x2408	;SYMBOL FOR BACKSPACE
      #x2409	;SYMBOL FOR HORIZONTAL TABULATION
      #x240A	;SYMBOL FOR LINE FEED
      #x240B	;SYMBOL FOR VERTICAL TABULATION
      #x240C	;SYMBOL FOR FORM FEED
      #x240D	;SYMBOL FOR CARRIAGE RETURN
      #x240E	;SYMBOL FOR SHIFT OUT
      #x240F	;SYMBOL FOR SHIFT IN
      #x2410	;SYMBOL FOR DATA LINK ESCAPE
      #x2411	;SYMBOL FOR DEVICE CONTROL ONE
      #x2412	;SYMBOL FOR DEVICE CONTROL TWO
      #x2413	;SYMBOL FOR DEVICE CONTROL THREE
      #x2414	;SYMBOL FOR DEVICE CONTROL FOUR
      #x2415	;SYMBOL FOR NEGATIVE ACKNOWLEDGE
      #x2416	;SYMBOL FOR SYNCHRONOUS IDLE
      #x2417	;SYMBOL FOR END OF TRANSMISSION BLOCK
      #x2418	;SYMBOL FOR CANCEL
      #x2419	;SYMBOL FOR END OF MEDIUM
      #x241A	;SYMBOL FOR SUBSTITUTE
      #x241B	;SYMBOL FOR ESCAPE
      #x241C	;SYMBOL FOR FILE SEPARATOR
      #x241D	;SYMBOL FOR GROUP SEPARATOR
      #x241E	;SYMBOL FOR RECORD SEPARATOR
      #x241F	;SYMBOL FOR UNIT SEPARATOR
      #x2420	;SYMBOL FOR SPACE
      #x2421	;SYMBOL FOR DELETE
      #x2422	;BLANK SYMBOL
      #x2423	;OPEN BOX
      #x2424	;SYMBOL FOR NEWLINE
      #x2425	;SYMBOL FOR DELETE FORM TWO
      #x2426	;SYMBOL FOR SUBSTITUTE FORM TWO
      #x2440	;OCR HOOK
      #x2441	;OCR CHAIR
      #x2442	;OCR FORK
      #x2443	;OCR INVERTED FORK
      #x2444	;OCR BELT BUCKLE
      #x2445	;OCR BOW TIE
      #x2446	;OCR BRANCH BANK IDENTIFICATION
      #x2447	;OCR AMOUNT OF CHECK
      #x2448	;OCR DASH
      #x2449	;OCR CUSTOMER ACCOUNT NUMBER
      #x244A	;OCR DOUBLE BACKSLASH
      #x2460	;CIRCLED DIGIT ONE
      #x2461	;CIRCLED DIGIT TWO
      #x2462	;CIRCLED DIGIT THREE
      #x2463	;CIRCLED DIGIT FOUR
      #x2464	;CIRCLED DIGIT FIVE
      #x2465	;CIRCLED DIGIT SIX
      #x2466	;CIRCLED DIGIT SEVEN
      #x2467	;CIRCLED DIGIT EIGHT
      #x2468	;CIRCLED DIGIT NINE
      #x2469	;CIRCLED NUMBER TEN
      #x246A	;CIRCLED NUMBER ELEVEN
      #x246B	;CIRCLED NUMBER TWELVE
      #x246C	;CIRCLED NUMBER THIRTEEN
      #x246D	;CIRCLED NUMBER FOURTEEN
      #x246E	;CIRCLED NUMBER FIFTEEN
      #x246F	;CIRCLED NUMBER SIXTEEN
      #x2470	;CIRCLED NUMBER SEVENTEEN
      #x2471	;CIRCLED NUMBER EIGHTEEN
      #x2472	;CIRCLED NUMBER NINETEEN
      #x2473	;CIRCLED NUMBER TWENTY
      #x2474	;PARENTHESIZED DIGIT ONE
      #x2475	;PARENTHESIZED DIGIT TWO
      #x2476	;PARENTHESIZED DIGIT THREE
      #x2477	;PARENTHESIZED DIGIT FOUR
      #x2478	;PARENTHESIZED DIGIT FIVE
      #x2479	;PARENTHESIZED DIGIT SIX
      #x247A	;PARENTHESIZED DIGIT SEVEN
      #x247B	;PARENTHESIZED DIGIT EIGHT
      #x247C	;PARENTHESIZED DIGIT NINE
      #x247D	;PARENTHESIZED NUMBER TEN
      #x247E	;PARENTHESIZED NUMBER ELEVEN
      #x247F	;PARENTHESIZED NUMBER TWELVE
      #x2480	;PARENTHESIZED NUMBER THIRTEEN
      #x2481	;PARENTHESIZED NUMBER FOURTEEN
      #x2482	;PARENTHESIZED NUMBER FIFTEEN
      #x2483	;PARENTHESIZED NUMBER SIXTEEN
      #x2484	;PARENTHESIZED NUMBER SEVENTEEN
      #x2485	;PARENTHESIZED NUMBER EIGHTEEN
      #x2486	;PARENTHESIZED NUMBER NINETEEN
      #x2487	;PARENTHESIZED NUMBER TWENTY
      #x2488	;DIGIT ONE FULL STOP
      #x2489	;DIGIT TWO FULL STOP
      #x248A	;DIGIT THREE FULL STOP
      #x248B	;DIGIT FOUR FULL STOP
      #x248C	;DIGIT FIVE FULL STOP
      #x248D	;DIGIT SIX FULL STOP
      #x248E	;DIGIT SEVEN FULL STOP
      #x248F	;DIGIT EIGHT FULL STOP
      #x2490	;DIGIT NINE FULL STOP
      #x2491	;NUMBER TEN FULL STOP
      #x2492	;NUMBER ELEVEN FULL STOP
      #x2493	;NUMBER TWELVE FULL STOP
      #x2494	;NUMBER THIRTEEN FULL STOP
      #x2495	;NUMBER FOURTEEN FULL STOP
      #x2496	;NUMBER FIFTEEN FULL STOP
      #x2497	;NUMBER SIXTEEN FULL STOP
      #x2498	;NUMBER SEVENTEEN FULL STOP
      #x2499	;NUMBER EIGHTEEN FULL STOP
      #x249A	;NUMBER NINETEEN FULL STOP
      #x249B	;NUMBER TWENTY FULL STOP
      #x249C	;PARENTHESIZED LATIN SMALL LETTER A
      #x249D	;PARENTHESIZED LATIN SMALL LETTER B
      #x249E	;PARENTHESIZED LATIN SMALL LETTER C
      #x249F	;PARENTHESIZED LATIN SMALL LETTER D
      #x24A0	;PARENTHESIZED LATIN SMALL LETTER E
      #x24A1	;PARENTHESIZED LATIN SMALL LETTER F
      #x24A2	;PARENTHESIZED LATIN SMALL LETTER G
      #x24A3	;PARENTHESIZED LATIN SMALL LETTER H
      #x24A4	;PARENTHESIZED LATIN SMALL LETTER I
      #x24A5	;PARENTHESIZED LATIN SMALL LETTER J
      #x24A6	;PARENTHESIZED LATIN SMALL LETTER K
      #x24A7	;PARENTHESIZED LATIN SMALL LETTER L
      #x24A8	;PARENTHESIZED LATIN SMALL LETTER M
      #x24A9	;PARENTHESIZED LATIN SMALL LETTER N
      #x24AA	;PARENTHESIZED LATIN SMALL LETTER O
      #x24AB	;PARENTHESIZED LATIN SMALL LETTER P
      #x24AC	;PARENTHESIZED LATIN SMALL LETTER Q
      #x24AD	;PARENTHESIZED LATIN SMALL LETTER R
      #x24AE	;PARENTHESIZED LATIN SMALL LETTER S
      #x24AF	;PARENTHESIZED LATIN SMALL LETTER T
      #x24B0	;PARENTHESIZED LATIN SMALL LETTER U
      #x24B1	;PARENTHESIZED LATIN SMALL LETTER V
      #x24B2	;PARENTHESIZED LATIN SMALL LETTER W
      #x24B3	;PARENTHESIZED LATIN SMALL LETTER X
      #x24B4	;PARENTHESIZED LATIN SMALL LETTER Y
      #x24B5	;PARENTHESIZED LATIN SMALL LETTER Z
      #x24B6	;CIRCLED LATIN CAPITAL LETTER A
      #x24B7	;CIRCLED LATIN CAPITAL LETTER B
      #x24B8	;CIRCLED LATIN CAPITAL LETTER C
      #x24B9	;CIRCLED LATIN CAPITAL LETTER D
      #x24BA	;CIRCLED LATIN CAPITAL LETTER E
      #x24BB	;CIRCLED LATIN CAPITAL LETTER F
      #x24BC	;CIRCLED LATIN CAPITAL LETTER G
      #x24BD	;CIRCLED LATIN CAPITAL LETTER H
      #x24BE	;CIRCLED LATIN CAPITAL LETTER I
      #x24BF	;CIRCLED LATIN CAPITAL LETTER J
      #x24C0	;CIRCLED LATIN CAPITAL LETTER K
      #x24C1	;CIRCLED LATIN CAPITAL LETTER L
      #x24C2	;CIRCLED LATIN CAPITAL LETTER M
      #x24C3	;CIRCLED LATIN CAPITAL LETTER N
      #x24C4	;CIRCLED LATIN CAPITAL LETTER O
      #x24C5	;CIRCLED LATIN CAPITAL LETTER P
      #x24C6	;CIRCLED LATIN CAPITAL LETTER Q
      #x24C7	;CIRCLED LATIN CAPITAL LETTER R
      #x24C8	;CIRCLED LATIN CAPITAL LETTER S
      #x24C9	;CIRCLED LATIN CAPITAL LETTER T
      #x24CA	;CIRCLED LATIN CAPITAL LETTER U
      #x24CB	;CIRCLED LATIN CAPITAL LETTER V
      #x24CC	;CIRCLED LATIN CAPITAL LETTER W
      #x24CD	;CIRCLED LATIN CAPITAL LETTER X
      #x24CE	;CIRCLED LATIN CAPITAL LETTER Y
      #x24CF	;CIRCLED LATIN CAPITAL LETTER Z
      #x24D0	;CIRCLED LATIN SMALL LETTER A
      #x24D1	;CIRCLED LATIN SMALL LETTER B
      #x24D2	;CIRCLED LATIN SMALL LETTER C
      #x24D3	;CIRCLED LATIN SMALL LETTER D
      #x24D4	;CIRCLED LATIN SMALL LETTER E
      #x24D5	;CIRCLED LATIN SMALL LETTER F
      #x24D6	;CIRCLED LATIN SMALL LETTER G
      #x24D7	;CIRCLED LATIN SMALL LETTER H
      #x24D8	;CIRCLED LATIN SMALL LETTER I
      #x24D9	;CIRCLED LATIN SMALL LETTER J
      #x24DA	;CIRCLED LATIN SMALL LETTER K
      #x24DB	;CIRCLED LATIN SMALL LETTER L
      #x24DC	;CIRCLED LATIN SMALL LETTER M
      #x24DD	;CIRCLED LATIN SMALL LETTER N
      #x24DE	;CIRCLED LATIN SMALL LETTER O
      #x24DF	;CIRCLED LATIN SMALL LETTER P
      #x24E0	;CIRCLED LATIN SMALL LETTER Q
      #x24E1	;CIRCLED LATIN SMALL LETTER R
      #x24E2	;CIRCLED LATIN SMALL LETTER S
      #x24E3	;CIRCLED LATIN SMALL LETTER T
      #x24E4	;CIRCLED LATIN SMALL LETTER U
      #x24E5	;CIRCLED LATIN SMALL LETTER V
      #x24E6	;CIRCLED LATIN SMALL LETTER W
      #x24E7	;CIRCLED LATIN SMALL LETTER X
      #x24E8	;CIRCLED LATIN SMALL LETTER Y
      #x24E9	;CIRCLED LATIN SMALL LETTER Z
      #x24EA	;CIRCLED DIGIT ZERO
      #x24EB	;NEGATIVE CIRCLED NUMBER ELEVEN
      #x24EC	;NEGATIVE CIRCLED NUMBER TWELVE
      #x24ED	;NEGATIVE CIRCLED NUMBER THIRTEEN
      #x24EE	;NEGATIVE CIRCLED NUMBER FOURTEEN
      #x24EF	;NEGATIVE CIRCLED NUMBER FIFTEEN
      #x24F0	;NEGATIVE CIRCLED NUMBER SIXTEEN
      #x24F1	;NEGATIVE CIRCLED NUMBER SEVENTEEN
      #x24F2	;NEGATIVE CIRCLED NUMBER EIGHTEEN
      #x24F3	;NEGATIVE CIRCLED NUMBER NINETEEN
      #x24F4	;NEGATIVE CIRCLED NUMBER TWENTY
      #x24F5	;DOUBLE CIRCLED DIGIT ONE
      #x24F6	;DOUBLE CIRCLED DIGIT TWO
      #x24F7	;DOUBLE CIRCLED DIGIT THREE
      #x24F8	;DOUBLE CIRCLED DIGIT FOUR
      #x24F9	;DOUBLE CIRCLED DIGIT FIVE
      #x24FA	;DOUBLE CIRCLED DIGIT SIX
      #x24FB	;DOUBLE CIRCLED DIGIT SEVEN
      #x24FC	;DOUBLE CIRCLED DIGIT EIGHT
      #x24FD	;DOUBLE CIRCLED DIGIT NINE
      #x24FE	;DOUBLE CIRCLED NUMBER TEN
      #x24FF	;NEGATIVE CIRCLED DIGIT ZERO
      #x2500	;BOX DRAWINGS LIGHT HORIZONTAL
      #x2501	;BOX DRAWINGS HEAVY HORIZONTAL
      #x2502	;BOX DRAWINGS LIGHT VERTICAL
      #x2503	;BOX DRAWINGS HEAVY VERTICAL
      #x2504	;BOX DRAWINGS LIGHT TRIPLE DASH HORIZONTAL
      #x2505	;BOX DRAWINGS HEAVY TRIPLE DASH HORIZONTAL
      #x2506	;BOX DRAWINGS LIGHT TRIPLE DASH VERTICAL
      #x2507	;BOX DRAWINGS HEAVY TRIPLE DASH VERTICAL
      #x2508	;BOX DRAWINGS LIGHT QUADRUPLE DASH HORIZONTAL
      #x2509	;BOX DRAWINGS HEAVY QUADRUPLE DASH HORIZONTAL
      #x250A	;BOX DRAWINGS LIGHT QUADRUPLE DASH VERTICAL
      #x250B	;BOX DRAWINGS HEAVY QUADRUPLE DASH VERTICAL
      #x250C	;BOX DRAWINGS LIGHT DOWN AND RIGHT
      #x250D	;BOX DRAWINGS DOWN LIGHT AND RIGHT HEAVY
      #x250E	;BOX DRAWINGS DOWN HEAVY AND RIGHT LIGHT
      #x250F	;BOX DRAWINGS HEAVY DOWN AND RIGHT
      #x2510	;BOX DRAWINGS LIGHT DOWN AND LEFT
      #x2511	;BOX DRAWINGS DOWN LIGHT AND LEFT HEAVY
      #x2512	;BOX DRAWINGS DOWN HEAVY AND LEFT LIGHT
      #x2513	;BOX DRAWINGS HEAVY DOWN AND LEFT
      #x2514	;BOX DRAWINGS LIGHT UP AND RIGHT
      #x2515	;BOX DRAWINGS UP LIGHT AND RIGHT HEAVY
      #x2516	;BOX DRAWINGS UP HEAVY AND RIGHT LIGHT
      #x2517	;BOX DRAWINGS HEAVY UP AND RIGHT
      #x2518	;BOX DRAWINGS LIGHT UP AND LEFT
      #x2519	;BOX DRAWINGS UP LIGHT AND LEFT HEAVY
      #x251A	;BOX DRAWINGS UP HEAVY AND LEFT LIGHT
      #x251B	;BOX DRAWINGS HEAVY UP AND LEFT
      #x251C	;BOX DRAWINGS LIGHT VERTICAL AND RIGHT
      #x251D	;BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY
      #x251E	;BOX DRAWINGS UP HEAVY AND RIGHT DOWN LIGHT
      #x251F	;BOX DRAWINGS DOWN HEAVY AND RIGHT UP LIGHT
      #x2520	;BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT
      #x2521	;BOX DRAWINGS DOWN LIGHT AND RIGHT UP HEAVY
      #x2522	;BOX DRAWINGS UP LIGHT AND RIGHT DOWN HEAVY
      #x2523	;BOX DRAWINGS HEAVY VERTICAL AND RIGHT
      #x2524	;BOX DRAWINGS LIGHT VERTICAL AND LEFT
      #x2525	;BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY
      #x2526	;BOX DRAWINGS UP HEAVY AND LEFT DOWN LIGHT
      #x2527	;BOX DRAWINGS DOWN HEAVY AND LEFT UP LIGHT
      #x2528	;BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT
      #x2529	;BOX DRAWINGS DOWN LIGHT AND LEFT UP HEAVY
      #x252A	;BOX DRAWINGS UP LIGHT AND LEFT DOWN HEAVY
      #x252B	;BOX DRAWINGS HEAVY VERTICAL AND LEFT
      #x252C	;BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
      #x252D	;BOX DRAWINGS LEFT HEAVY AND RIGHT DOWN LIGHT
      #x252E	;BOX DRAWINGS RIGHT HEAVY AND LEFT DOWN LIGHT
      #x252F	;BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY
      #x2530	;BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT
      #x2531	;BOX DRAWINGS RIGHT LIGHT AND LEFT DOWN HEAVY
      #x2532	;BOX DRAWINGS LEFT LIGHT AND RIGHT DOWN HEAVY
      #x2533	;BOX DRAWINGS HEAVY DOWN AND HORIZONTAL
      #x2534	;BOX DRAWINGS LIGHT UP AND HORIZONTAL
      #x2535	;BOX DRAWINGS LEFT HEAVY AND RIGHT UP LIGHT
      #x2536	;BOX DRAWINGS RIGHT HEAVY AND LEFT UP LIGHT
      #x2537	;BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY
      #x2538	;BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT
      #x2539	;BOX DRAWINGS RIGHT LIGHT AND LEFT UP HEAVY
      #x253A	;BOX DRAWINGS LEFT LIGHT AND RIGHT UP HEAVY
      #x253B	;BOX DRAWINGS HEAVY UP AND HORIZONTAL
      #x253C	;BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
      #x253D	;BOX DRAWINGS LEFT HEAVY AND RIGHT VERTICAL LIGHT
      #x253E	;BOX DRAWINGS RIGHT HEAVY AND LEFT VERTICAL LIGHT
      #x253F	;BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY
      #x2540	;BOX DRAWINGS UP HEAVY AND DOWN HORIZONTAL LIGHT
      #x2541	;BOX DRAWINGS DOWN HEAVY AND UP HORIZONTAL LIGHT
      #x2542	;BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT
      #x2543	;BOX DRAWINGS LEFT UP HEAVY AND RIGHT DOWN LIGHT
      #x2544	;BOX DRAWINGS RIGHT UP HEAVY AND LEFT DOWN LIGHT
      #x2545	;BOX DRAWINGS LEFT DOWN HEAVY AND RIGHT UP LIGHT
      #x2546	;BOX DRAWINGS RIGHT DOWN HEAVY AND LEFT UP LIGHT
      #x2547	;BOX DRAWINGS DOWN LIGHT AND UP HORIZONTAL HEAVY
      #x2548	;BOX DRAWINGS UP LIGHT AND DOWN HORIZONTAL HEAVY
      #x2549	;BOX DRAWINGS RIGHT LIGHT AND LEFT VERTICAL HEAVY
      #x254A	;BOX DRAWINGS LEFT LIGHT AND RIGHT VERTICAL HEAVY
      #x254B	;BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL
      #x254C	;BOX DRAWINGS LIGHT DOUBLE DASH HORIZONTAL
      #x254D	;BOX DRAWINGS HEAVY DOUBLE DASH HORIZONTAL
      #x254E	;BOX DRAWINGS LIGHT DOUBLE DASH VERTICAL
      #x254F	;BOX DRAWINGS HEAVY DOUBLE DASH VERTICAL
      #x2550	;BOX DRAWINGS DOUBLE HORIZONTAL
      #x2551	;BOX DRAWINGS DOUBLE VERTICAL
      #x2552	;BOX DRAWINGS DOWN SINGLE AND RIGHT DOUBLE
      #x2553	;BOX DRAWINGS DOWN DOUBLE AND RIGHT SINGLE
      #x2554	;BOX DRAWINGS DOUBLE DOWN AND RIGHT
      #x2555	;BOX DRAWINGS DOWN SINGLE AND LEFT DOUBLE
      #x2556	;BOX DRAWINGS DOWN DOUBLE AND LEFT SINGLE
      #x2557	;BOX DRAWINGS DOUBLE DOWN AND LEFT
      #x2558	;BOX DRAWINGS UP SINGLE AND RIGHT DOUBLE
      #x2559	;BOX DRAWINGS UP DOUBLE AND RIGHT SINGLE
      #x255A	;BOX DRAWINGS DOUBLE UP AND RIGHT
      #x255B	;BOX DRAWINGS UP SINGLE AND LEFT DOUBLE
      #x255C	;BOX DRAWINGS UP DOUBLE AND LEFT SINGLE
      #x255D	;BOX DRAWINGS DOUBLE UP AND LEFT
      #x255E	;BOX DRAWINGS VERTICAL SINGLE AND RIGHT DOUBLE
      #x255F	;BOX DRAWINGS VERTICAL DOUBLE AND RIGHT SINGLE
      #x2560	;BOX DRAWINGS DOUBLE VERTICAL AND RIGHT
      #x2561	;BOX DRAWINGS VERTICAL SINGLE AND LEFT DOUBLE
      #x2562	;BOX DRAWINGS VERTICAL DOUBLE AND LEFT SINGLE
      #x2563	;BOX DRAWINGS DOUBLE VERTICAL AND LEFT
      #x2564	;BOX DRAWINGS DOWN SINGLE AND HORIZONTAL DOUBLE
      #x2565	;BOX DRAWINGS DOWN DOUBLE AND HORIZONTAL SINGLE
      #x2566	;BOX DRAWINGS DOUBLE DOWN AND HORIZONTAL
      #x2567	;BOX DRAWINGS UP SINGLE AND HORIZONTAL DOUBLE
      #x2568	;BOX DRAWINGS UP DOUBLE AND HORIZONTAL SINGLE
      #x2569	;BOX DRAWINGS DOUBLE UP AND HORIZONTAL
      #x256A	;BOX DRAWINGS VERTICAL SINGLE AND HORIZONTAL DOUBLE
      #x256B	;BOX DRAWINGS VERTICAL DOUBLE AND HORIZONTAL SINGLE
      #x256C	;BOX DRAWINGS DOUBLE VERTICAL AND HORIZONTAL
      #x256D	;BOX DRAWINGS LIGHT ARC DOWN AND RIGHT
      #x256E	;BOX DRAWINGS LIGHT ARC DOWN AND LEFT
      #x256F	;BOX DRAWINGS LIGHT ARC UP AND LEFT
      #x2570	;BOX DRAWINGS LIGHT ARC UP AND RIGHT
      #x2571	;BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
      #x2572	;BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
      #x2573	;BOX DRAWINGS LIGHT DIAGONAL CROSS
      #x2574	;BOX DRAWINGS LIGHT LEFT
      #x2575	;BOX DRAWINGS LIGHT UP
      #x2576	;BOX DRAWINGS LIGHT RIGHT
      #x2577	;BOX DRAWINGS LIGHT DOWN
      #x2578	;BOX DRAWINGS HEAVY LEFT
      #x2579	;BOX DRAWINGS HEAVY UP
      #x257A	;BOX DRAWINGS HEAVY RIGHT
      #x257B	;BOX DRAWINGS HEAVY DOWN
      #x257C	;BOX DRAWINGS LIGHT LEFT AND HEAVY RIGHT
      #x257D	;BOX DRAWINGS LIGHT UP AND HEAVY DOWN
      #x257E	;BOX DRAWINGS HEAVY LEFT AND LIGHT RIGHT
      #x257F	;BOX DRAWINGS HEAVY UP AND LIGHT DOWN
      #x2580	;UPPER HALF BLOCK
      #x2581	;LOWER ONE EIGHTH BLOCK
      #x2582	;LOWER ONE QUARTER BLOCK
      #x2583	;LOWER THREE EIGHTHS BLOCK
      #x2584	;LOWER HALF BLOCK
      #x2585	;LOWER FIVE EIGHTHS BLOCK
      #x2586	;LOWER THREE QUARTERS BLOCK
      #x2587	;LOWER SEVEN EIGHTHS BLOCK
      #x2588	;FULL BLOCK
      #x2589	;LEFT SEVEN EIGHTHS BLOCK
      #x258A	;LEFT THREE QUARTERS BLOCK
      #x258B	;LEFT FIVE EIGHTHS BLOCK
      #x258C	;LEFT HALF BLOCK
      #x258D	;LEFT THREE EIGHTHS BLOCK
      #x258E	;LEFT ONE QUARTER BLOCK
      #x258F	;LEFT ONE EIGHTH BLOCK
      #x2590	;RIGHT HALF BLOCK
      #x2591	;LIGHT SHADE
      #x2592	;MEDIUM SHADE
      #x2593	;DARK SHADE
      #x2594	;UPPER ONE EIGHTH BLOCK
      #x2595	;RIGHT ONE EIGHTH BLOCK
      #x2596	;QUADRANT LOWER LEFT
      #x2597	;QUADRANT LOWER RIGHT
      #x2598	;QUADRANT UPPER LEFT
      #x2599	;QUADRANT UPPER LEFT AND LOWER LEFT AND LOWER RIGHT
      #x259A	;QUADRANT UPPER LEFT AND LOWER RIGHT
      #x259B	;QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER LEFT
      #x259C	;QUADRANT UPPER LEFT AND UPPER RIGHT AND LOWER RIGHT
      #x259D	;QUADRANT UPPER RIGHT
      #x259E	;QUADRANT UPPER RIGHT AND LOWER LEFT
      #x259F	;QUADRANT UPPER RIGHT AND LOWER LEFT AND LOWER RIGHT
      #x25A0	;BLACK SQUARE
      #x25A1	;WHITE SQUARE
      #x25A2	;WHITE SQUARE WITH ROUNDED CORNERS
      #x25A3	;WHITE SQUARE CONTAINING BLACK SMALL SQUARE
      #x25A4	;SQUARE WITH HORIZONTAL FILL
      #x25A5	;SQUARE WITH VERTICAL FILL
      #x25A6	;SQUARE WITH ORTHOGONAL CROSSHATCH FILL
      #x25A7	;SQUARE WITH UPPER LEFT TO LOWER RIGHT FILL
      #x25A8	;SQUARE WITH UPPER RIGHT TO LOWER LEFT FILL
      #x25A9	;SQUARE WITH DIAGONAL CROSSHATCH FILL
      #x25AA	;BLACK SMALL SQUARE
      #x25AB	;WHITE SMALL SQUARE
      #x25AC	;BLACK RECTANGLE
      #x25AD	;WHITE RECTANGLE
      #x25AE	;BLACK VERTICAL RECTANGLE
      #x25AF	;WHITE VERTICAL RECTANGLE
      #x25B0	;BLACK PARALLELOGRAM
      #x25B1	;WHITE PARALLELOGRAM
      #x25B2	;BLACK UP-POINTING TRIANGLE
      #x25B3	;WHITE UP-POINTING TRIANGLE
      #x25B4	;BLACK UP-POINTING SMALL TRIANGLE
      #x25B5	;WHITE UP-POINTING SMALL TRIANGLE
      #x25B6	;BLACK RIGHT-POINTING TRIANGLE
      #x25B7	;WHITE RIGHT-POINTING TRIANGLE
      #x25B8	;BLACK RIGHT-POINTING SMALL TRIANGLE
      #x25B9	;WHITE RIGHT-POINTING SMALL TRIANGLE
      #x25BA	;BLACK RIGHT-POINTING POINTER
      #x25BB	;WHITE RIGHT-POINTING POINTER
      #x25BC	;BLACK DOWN-POINTING TRIANGLE
      #x25BD	;WHITE DOWN-POINTING TRIANGLE
      #x25BE	;BLACK DOWN-POINTING SMALL TRIANGLE
      #x25BF	;WHITE DOWN-POINTING SMALL TRIANGLE
      #x25C0	;BLACK LEFT-POINTING TRIANGLE
      #x25C1	;WHITE LEFT-POINTING TRIANGLE
      #x25C2	;BLACK LEFT-POINTING SMALL TRIANGLE
      #x25C3	;WHITE LEFT-POINTING SMALL TRIANGLE
      #x25C4	;BLACK LEFT-POINTING POINTER
      #x25C5	;WHITE LEFT-POINTING POINTER
      #x25C6	;BLACK DIAMOND
      #x25C7	;WHITE DIAMOND
      #x25C8	;WHITE DIAMOND CONTAINING BLACK SMALL DIAMOND
      #x25C9	;FISHEYE
      #x25CA	;LOZENGE
      #x25CB	;WHITE CIRCLE
      #x25CC	;DOTTED CIRCLE
      #x25CD	;CIRCLE WITH VERTICAL FILL
      #x25CE	;BULLSEYE
      #x25CF	;BLACK CIRCLE
      #x25D0	;CIRCLE WITH LEFT HALF BLACK
      #x25D1	;CIRCLE WITH RIGHT HALF BLACK
      #x25D2	;CIRCLE WITH LOWER HALF BLACK
      #x25D3	;CIRCLE WITH UPPER HALF BLACK
      #x25D4	;CIRCLE WITH UPPER RIGHT QUADRANT BLACK
      #x25D5	;CIRCLE WITH ALL BUT UPPER LEFT QUADRANT BLACK
      #x25D6	;LEFT HALF BLACK CIRCLE
      #x25D7	;RIGHT HALF BLACK CIRCLE
      #x25D8	;INVERSE BULLET
      #x25D9	;INVERSE WHITE CIRCLE
      #x25DA	;UPPER HALF INVERSE WHITE CIRCLE
      #x25DB	;LOWER HALF INVERSE WHITE CIRCLE
      #x25DC	;UPPER LEFT QUADRANT CIRCULAR ARC
      #x25DD	;UPPER RIGHT QUADRANT CIRCULAR ARC
      #x25DE	;LOWER RIGHT QUADRANT CIRCULAR ARC
      #x25DF	;LOWER LEFT QUADRANT CIRCULAR ARC
      #x25E0	;UPPER HALF CIRCLE
      #x25E1	;LOWER HALF CIRCLE
      #x25E2	;BLACK LOWER RIGHT TRIANGLE
      #x25E3	;BLACK LOWER LEFT TRIANGLE
      #x25E4	;BLACK UPPER LEFT TRIANGLE
      #x25E5	;BLACK UPPER RIGHT TRIANGLE
      #x25E6	;WHITE BULLET
      #x25E7	;SQUARE WITH LEFT HALF BLACK
      #x25E8	;SQUARE WITH RIGHT HALF BLACK
      #x25E9	;SQUARE WITH UPPER LEFT DIAGONAL HALF BLACK
      #x25EA	;SQUARE WITH LOWER RIGHT DIAGONAL HALF BLACK
      #x25EB	;WHITE SQUARE WITH VERTICAL BISECTING LINE
      #x25EC	;WHITE UP-POINTING TRIANGLE WITH DOT
      #x25ED	;UP-POINTING TRIANGLE WITH LEFT HALF BLACK
      #x25EE	;UP-POINTING TRIANGLE WITH RIGHT HALF BLACK
      #x25EF	;LARGE CIRCLE
      #x25F0	;WHITE SQUARE WITH UPPER LEFT QUADRANT
      #x25F1	;WHITE SQUARE WITH LOWER LEFT QUADRANT
      #x25F2	;WHITE SQUARE WITH LOWER RIGHT QUADRANT
      #x25F3	;WHITE SQUARE WITH UPPER RIGHT QUADRANT
      #x25F4	;WHITE CIRCLE WITH UPPER LEFT QUADRANT
      #x25F5	;WHITE CIRCLE WITH LOWER LEFT QUADRANT
      #x25F6	;WHITE CIRCLE WITH LOWER RIGHT QUADRANT
      #x25F7	;WHITE CIRCLE WITH UPPER RIGHT QUADRANT
      #x25F8	;UPPER LEFT TRIANGLE
      #x25F9	;UPPER RIGHT TRIANGLE
      #x25FA	;LOWER LEFT TRIANGLE
      #x25FB	;WHITE MEDIUM SQUARE
      #x25FC	;BLACK MEDIUM SQUARE
      #x25FD	;WHITE MEDIUM SMALL SQUARE
      #x25FE	;BLACK MEDIUM SMALL SQUARE
      #x25FF	;LOWER RIGHT TRIANGLE
      #x2600	;BLACK SUN WITH RAYS
      #x2601	;CLOUD
      #x2602	;UMBRELLA
      #x2603	;SNOWMAN
      #x2604	;COMET
      #x2605	;BLACK STAR
      #x2606	;WHITE STAR
      #x2607	;LIGHTNING
      #x2608	;THUNDERSTORM
      #x2609	;SUN
      #x260A	;ASCENDING NODE
      #x260B	;DESCENDING NODE
      #x260C	;CONJUNCTION
      #x260D	;OPPOSITION
      #x260E	;BLACK TELEPHONE
      #x260F	;WHITE TELEPHONE
      #x2610	;BALLOT BOX
      #x2611	;BALLOT BOX WITH CHECK
      #x2612	;BALLOT BOX WITH X
      #x2613	;SALTIRE
      #x2614	;UMBRELLA WITH RAIN DROPS
      #x2615	;HOT BEVERAGE
      #x2616	;WHITE SHOGI PIECE
      #x2617	;BLACK SHOGI PIECE
      #x2619	;REVERSED ROTATED FLORAL HEART BULLET
      #x261A	;BLACK LEFT POINTING INDEX
      #x261B	;BLACK RIGHT POINTING INDEX
      #x261C	;WHITE LEFT POINTING INDEX
      #x261D	;WHITE UP POINTING INDEX
      #x261E	;WHITE RIGHT POINTING INDEX
      #x261F	;WHITE DOWN POINTING INDEX
      #x2620	;SKULL AND CROSSBONES
      #x2621	;CAUTION SIGN
      #x2622	;RADIOACTIVE SIGN
      #x2623	;BIOHAZARD SIGN
      #x2624	;CADUCEUS
      #x2625	;ANKH
      #x2626	;ORTHODOX CROSS
      #x2627	;CHI RHO
      #x2628	;CROSS OF LORRAINE
      #x2629	;CROSS OF JERUSALEM
      #x262A	;STAR AND CRESCENT
      #x262B	;FARSI SYMBOL
      #x262C	;ADI SHAKTI
      #x262D	;HAMMER AND SICKLE
      #x262E	;PEACE SYMBOL
      #x262F	;YIN YANG
      #x2630	;TRIGRAM FOR HEAVEN
      #x2631	;TRIGRAM FOR LAKE
      #x2632	;TRIGRAM FOR FIRE
      #x2633	;TRIGRAM FOR THUNDER
      #x2634	;TRIGRAM FOR WIND
      #x2635	;TRIGRAM FOR WATER
      #x2636	;TRIGRAM FOR MOUNTAIN
      #x2637	;TRIGRAM FOR EARTH
      #x2638	;WHEEL OF DHARMA
      #x2639	;WHITE FROWNING FACE
      #x263A	;WHITE SMILING FACE
      #x263B	;BLACK SMILING FACE
      #x263C	;WHITE SUN WITH RAYS
      #x263D	;FIRST QUARTER MOON
      #x263E	;LAST QUARTER MOON
      #x263F	;MERCURY
      #x2640	;FEMALE SIGN
      #x2641	;EARTH
      #x2642	;MALE SIGN
      #x2643	;JUPITER
      #x2644	;SATURN
      #x2645	;URANUS
      #x2646	;NEPTUNE
      #x2647	;PLUTO
      #x2648	;ARIES
      #x2649	;TAURUS
      #x264A	;GEMINI
      #x264B	;CANCER
      #x264C	;LEO
      #x264D	;VIRGO
      #x264E	;LIBRA
      #x264F	;SCORPIUS
      #x2650	;SAGITTARIUS
      #x2651	;CAPRICORN
      #x2652	;AQUARIUS
      #x2653	;PISCES
      #x2654	;WHITE CHESS KING
      #x2655	;WHITE CHESS QUEEN
      #x2656	;WHITE CHESS ROOK
      #x2657	;WHITE CHESS BISHOP
      #x2658	;WHITE CHESS KNIGHT
      #x2659	;WHITE CHESS PAWN
      #x265A	;BLACK CHESS KING
      #x265B	;BLACK CHESS QUEEN
      #x265C	;BLACK CHESS ROOK
      #x265D	;BLACK CHESS BISHOP
      #x265E	;BLACK CHESS KNIGHT
      #x265F	;BLACK CHESS PAWN
      #x2660	;BLACK SPADE SUIT
      #x2661	;WHITE HEART SUIT
      #x2662	;WHITE DIAMOND SUIT
      #x2663	;BLACK CLUB SUIT
      #x2664	;WHITE SPADE SUIT
      #x2665	;BLACK HEART SUIT
      #x2666	;BLACK DIAMOND SUIT
      #x2667	;WHITE CLUB SUIT
      #x2668	;HOT SPRINGS
      #x2669	;QUARTER NOTE
      #x266A	;EIGHTH NOTE
      #x266B	;BEAMED EIGHTH NOTES
      #x266C	;BEAMED SIXTEENTH NOTES
      #x266D	;MUSIC FLAT SIGN
      #x266E	;MUSIC NATURAL SIGN
      #x266F	;MUSIC SHARP SIGN
      #x2670	;WEST SYRIAC CROSS
      #x2671	;EAST SYRIAC CROSS
      #x2672	;UNIVERSAL RECYCLING SYMBOL
      #x2673	;RECYCLING SYMBOL FOR TYPE-1 PLASTICS
      #x2674	;RECYCLING SYMBOL FOR TYPE-2 PLASTICS
      #x2675	;RECYCLING SYMBOL FOR TYPE-3 PLASTICS
      #x2676	;RECYCLING SYMBOL FOR TYPE-4 PLASTICS
      #x2677	;RECYCLING SYMBOL FOR TYPE-5 PLASTICS
      #x2678	;RECYCLING SYMBOL FOR TYPE-6 PLASTICS
      #x2679	;RECYCLING SYMBOL FOR TYPE-7 PLASTICS
      #x267A	;RECYCLING SYMBOL FOR GENERIC MATERIALS
      #x267B	;BLACK UNIVERSAL RECYCLING SYMBOL
      #x267C	;RECYCLED PAPER SYMBOL
      #x267D	;PARTIALLY-RECYCLED PAPER SYMBOL
      #x2680	;DIE FACE-1
      #x2681	;DIE FACE-2
      #x2682	;DIE FACE-3
      #x2683	;DIE FACE-4
      #x2684	;DIE FACE-5
      #x2685	;DIE FACE-6
      #x2686	;WHITE CIRCLE WITH DOT RIGHT
      #x2687	;WHITE CIRCLE WITH TWO DOTS
      #x2688	;BLACK CIRCLE WITH WHITE DOT RIGHT
      #x2689	;BLACK CIRCLE WITH TWO WHITE DOTS
      #x268A	;MONOGRAM FOR YANG
      #x268B	;MONOGRAM FOR YIN
      #x268C	;DIGRAM FOR GREATER YANG
      #x268D	;DIGRAM FOR LESSER YIN
      #x268E	;DIGRAM FOR LESSER YANG
      #x268F	;DIGRAM FOR GREATER YIN
      #x2690	;WHITE FLAG
      #x2691	;BLACK FLAG
      #x26A0	;WARNING SIGN
      #x26A1	;HIGH VOLTAGE SIGN
      #x2701	;UPPER BLADE SCISSORS
      #x2702	;BLACK SCISSORS
      #x2703	;LOWER BLADE SCISSORS
      #x2704	;WHITE SCISSORS
      #x2706	;TELEPHONE LOCATION SIGN
      #x2707	;TAPE DRIVE
      #x2708	;AIRPLANE
      #x2709	;ENVELOPE
      #x270C	;VICTORY HAND
      #x270D	;WRITING HAND
      #x270E	;LOWER RIGHT PENCIL
      #x270F	;PENCIL
      #x2710	;UPPER RIGHT PENCIL
      #x2711	;WHITE NIB
      #x2712	;BLACK NIB
      #x2713	;CHECK MARK
      #x2714	;HEAVY CHECK MARK
      #x2715	;MULTIPLICATION X
      #x2716	;HEAVY MULTIPLICATION X
      #x2717	;BALLOT X
      #x2718	;HEAVY BALLOT X
      #x2719	;OUTLINED GREEK CROSS
      #x271A	;HEAVY GREEK CROSS
      #x271B	;OPEN CENTRE CROSS
      #x271C	;HEAVY OPEN CENTRE CROSS
      #x271D	;LATIN CROSS
      #x271E	;SHADOWED WHITE LATIN CROSS
      #x271F	;OUTLINED LATIN CROSS
      #x2720	;MALTESE CROSS
      #x2721	;STAR OF DAVID
      #x2722	;FOUR TEARDROP-SPOKED ASTERISK
      #x2723	;FOUR BALLOON-SPOKED ASTERISK
      #x2724	;HEAVY FOUR BALLOON-SPOKED ASTERISK
      #x2725	;FOUR CLUB-SPOKED ASTERISK
      #x2726	;BLACK FOUR POINTED STAR
      #x2727	;WHITE FOUR POINTED STAR
      #x2729	;STRESS OUTLINED WHITE STAR
      #x272A	;CIRCLED WHITE STAR
      #x272B	;OPEN CENTRE BLACK STAR
      #x272C	;BLACK CENTRE WHITE STAR
      #x272D	;OUTLINED BLACK STAR
      #x272E	;HEAVY OUTLINED BLACK STAR
      #x272F	;PINWHEEL STAR
      #x2730	;SHADOWED WHITE STAR
      #x2731	;HEAVY ASTERISK
      #x2732	;OPEN CENTRE ASTERISK
      #x2733	;EIGHT SPOKED ASTERISK
      #x2734	;EIGHT POINTED BLACK STAR
      #x2735	;EIGHT POINTED PINWHEEL STAR
      #x2736	;SIX POINTED BLACK STAR
      #x2737	;EIGHT POINTED RECTILINEAR BLACK STAR
      #x2738	;HEAVY EIGHT POINTED RECTILINEAR BLACK STAR
      #x2739	;TWELVE POINTED BLACK STAR
      #x273A	;SIXTEEN POINTED ASTERISK
      #x273B	;TEARDROP-SPOKED ASTERISK
      #x273C	;OPEN CENTRE TEARDROP-SPOKED ASTERISK
      #x273D	;HEAVY TEARDROP-SPOKED ASTERISK
      #x273E	;SIX PETALLED BLACK AND WHITE FLORETTE
      #x273F	;BLACK FLORETTE
      #x2740	;WHITE FLORETTE
      #x2741	;EIGHT PETALLED OUTLINED BLACK FLORETTE
      #x2742	;CIRCLED OPEN CENTRE EIGHT POINTED STAR
      #x2743	;HEAVY TEARDROP-SPOKED PINWHEEL ASTERISK
      #x2744	;SNOWFLAKE
      #x2745	;TIGHT TRIFOLIATE SNOWFLAKE
      #x2746	;HEAVY CHEVRON SNOWFLAKE
      #x2747	;SPARKLE
      #x2748	;HEAVY SPARKLE
      #x2749	;BALLOON-SPOKED ASTERISK
      #x274A	;EIGHT TEARDROP-SPOKED PROPELLER ASTERISK
      #x274B	;HEAVY EIGHT TEARDROP-SPOKED PROPELLER ASTERISK
      #x274D	;SHADOWED WHITE CIRCLE
      #x274F	;LOWER RIGHT DROP-SHADOWED WHITE SQUARE
      #x2750	;UPPER RIGHT DROP-SHADOWED WHITE SQUARE
      #x2751	;LOWER RIGHT SHADOWED WHITE SQUARE
      #x2752	;UPPER RIGHT SHADOWED WHITE SQUARE
      #x2756	;BLACK DIAMOND MINUS WHITE X
      #x2758	;LIGHT VERTICAL BAR
      #x2759	;MEDIUM VERTICAL BAR
      #x275A	;HEAVY VERTICAL BAR
      #x275B	;HEAVY SINGLE TURNED COMMA QUOTATION MARK ORNAMENT
      #x275C	;HEAVY SINGLE COMMA QUOTATION MARK ORNAMENT
      #x275D	;HEAVY DOUBLE TURNED COMMA QUOTATION MARK ORNAMENT
      #x275E	;HEAVY DOUBLE COMMA QUOTATION MARK ORNAMENT
      #x2761	;CURVED STEM PARAGRAPH SIGN ORNAMENT
      #x2762	;HEAVY EXCLAMATION MARK ORNAMENT
      #x2763	;HEAVY HEART EXCLAMATION MARK ORNAMENT
      #x2764	;HEAVY BLACK HEART
      #x2765	;ROTATED HEAVY BLACK HEART BULLET
      #x2766	;FLORAL HEART
      #x2767	;ROTATED FLORAL HEART BULLET
      #x2768	;MEDIUM LEFT PARENTHESIS ORNAMENT
      #x2769	;MEDIUM RIGHT PARENTHESIS ORNAMENT
      #x276A	;MEDIUM FLATTENED LEFT PARENTHESIS ORNAMENT
      #x276B	;MEDIUM FLATTENED RIGHT PARENTHESIS ORNAMENT
      #x276C	;MEDIUM LEFT-POINTING ANGLE BRACKET ORNAMENT
      #x276D	;MEDIUM RIGHT-POINTING ANGLE BRACKET ORNAMENT
      #x276E	;HEAVY LEFT-POINTING ANGLE QUOTATION MARK ORNAMENT
      #x276F	;HEAVY RIGHT-POINTING ANGLE QUOTATION MARK ORNAMENT
      #x2770	;HEAVY LEFT-POINTING ANGLE BRACKET ORNAMENT
      #x2771	;HEAVY RIGHT-POINTING ANGLE BRACKET ORNAMENT
      #x2772	;LIGHT LEFT TORTOISE SHELL BRACKET ORNAMENT
      #x2773	;LIGHT RIGHT TORTOISE SHELL BRACKET ORNAMENT
      #x2774	;MEDIUM LEFT CURLY BRACKET ORNAMENT
      #x2775	;MEDIUM RIGHT CURLY BRACKET ORNAMENT
      #x2776	;DINGBAT NEGATIVE CIRCLED DIGIT ONE
      #x2777	;DINGBAT NEGATIVE CIRCLED DIGIT TWO
      #x2778	;DINGBAT NEGATIVE CIRCLED DIGIT THREE
      #x2779	;DINGBAT NEGATIVE CIRCLED DIGIT FOUR
      #x277A	;DINGBAT NEGATIVE CIRCLED DIGIT FIVE
      #x277B	;DINGBAT NEGATIVE CIRCLED DIGIT SIX
      #x277C	;DINGBAT NEGATIVE CIRCLED DIGIT SEVEN
      #x277D	;DINGBAT NEGATIVE CIRCLED DIGIT EIGHT
      #x277E	;DINGBAT NEGATIVE CIRCLED DIGIT NINE
      #x277F	;DINGBAT NEGATIVE CIRCLED NUMBER TEN
      #x2780	;DINGBAT CIRCLED SANS-SERIF DIGIT ONE
      #x2781	;DINGBAT CIRCLED SANS-SERIF DIGIT TWO
      #x2782	;DINGBAT CIRCLED SANS-SERIF DIGIT THREE
      #x2783	;DINGBAT CIRCLED SANS-SERIF DIGIT FOUR
      #x2784	;DINGBAT CIRCLED SANS-SERIF DIGIT FIVE
      #x2785	;DINGBAT CIRCLED SANS-SERIF DIGIT SIX
      #x2786	;DINGBAT CIRCLED SANS-SERIF DIGIT SEVEN
      #x2787	;DINGBAT CIRCLED SANS-SERIF DIGIT EIGHT
      #x2788	;DINGBAT CIRCLED SANS-SERIF DIGIT NINE
      #x2789	;DINGBAT CIRCLED SANS-SERIF NUMBER TEN
      #x278A	;DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT ONE
      #x278B	;DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT TWO
      #x278C	;DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT THREE
      #x278D	;DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FOUR
      #x278E	;DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT FIVE
      #x278F	;DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SIX
      #x2790	;DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT SEVEN
      #x2791	;DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT EIGHT
      #x2792	;DINGBAT NEGATIVE CIRCLED SANS-SERIF DIGIT NINE
      #x2793	;DINGBAT NEGATIVE CIRCLED SANS-SERIF NUMBER TEN
      #x2794	;HEAVY WIDE-HEADED RIGHTWARDS ARROW
      #x2798	;HEAVY SOUTH EAST ARROW
      #x2799	;HEAVY RIGHTWARDS ARROW
      #x279A	;HEAVY NORTH EAST ARROW
      #x279B	;DRAFTING POINT RIGHTWARDS ARROW
      #x279C	;HEAVY ROUND-TIPPED RIGHTWARDS ARROW
      #x279D	;TRIANGLE-HEADED RIGHTWARDS ARROW
      #x279E	;HEAVY TRIANGLE-HEADED RIGHTWARDS ARROW
      #x279F	;DASHED TRIANGLE-HEADED RIGHTWARDS ARROW
      #x27A0	;HEAVY DASHED TRIANGLE-HEADED RIGHTWARDS ARROW
      #x27A1	;BLACK RIGHTWARDS ARROW
      #x27A2	;THREE-D TOP-LIGHTED RIGHTWARDS ARROWHEAD
      #x27A3	;THREE-D BOTTOM-LIGHTED RIGHTWARDS ARROWHEAD
      #x27A4	;BLACK RIGHTWARDS ARROWHEAD
      #x27A5	;HEAVY BLACK CURVED DOWNWARDS AND RIGHTWARDS ARROW
      #x27A6	;HEAVY BLACK CURVED UPWARDS AND RIGHTWARDS ARROW
      #x27A7	;SQUAT BLACK RIGHTWARDS ARROW
      #x27A8	;HEAVY CONCAVE-POINTED BLACK RIGHTWARDS ARROW
      #x27A9	;RIGHT-SHADED WHITE RIGHTWARDS ARROW
      #x27AA	;LEFT-SHADED WHITE RIGHTWARDS ARROW
      #x27AB	;BACK-TILTED SHADOWED WHITE RIGHTWARDS ARROW
      #x27AC	;FRONT-TILTED SHADOWED WHITE RIGHTWARDS ARROW
      #x27AD	;HEAVY LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
      #x27AE	;HEAVY UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
      #x27AF	;NOTCHED LOWER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
      #x27B1	;NOTCHED UPPER RIGHT-SHADOWED WHITE RIGHTWARDS ARROW
      #x27B2	;CIRCLED HEAVY WHITE RIGHTWARDS ARROW
      #x27B3	;WHITE-FEATHERED RIGHTWARDS ARROW
      #x27B4	;BLACK-FEATHERED SOUTH EAST ARROW
      #x27B5	;BLACK-FEATHERED RIGHTWARDS ARROW
      #x27B6	;BLACK-FEATHERED NORTH EAST ARROW
      #x27B7	;HEAVY BLACK-FEATHERED SOUTH EAST ARROW
      #x27B8	;HEAVY BLACK-FEATHERED RIGHTWARDS ARROW
      #x27B9	;HEAVY BLACK-FEATHERED NORTH EAST ARROW
      #x27BA	;TEARDROP-BARBED RIGHTWARDS ARROW
      #x27BB	;HEAVY TEARDROP-SHANKED RIGHTWARDS ARROW
      #x27BC	;WEDGE-TAILED RIGHTWARDS ARROW
      #x27BD	;HEAVY WEDGE-TAILED RIGHTWARDS ARROW
      #x27BE	;OPEN-OUTLINED RIGHTWARDS ARROW
      #x27D0	;WHITE DIAMOND WITH CENTRED DOT
      #x27D1	;AND WITH DOT
      #x27D2	;ELEMENT OF OPENING UPWARDS
      #x27D3	;LOWER RIGHT CORNER WITH DOT
      #x27D4	;UPPER LEFT CORNER WITH DOT
      #x27D5	;LEFT OUTER JOIN
      #x27D6	;RIGHT OUTER JOIN
      #x27D7	;FULL OUTER JOIN
      #x27D8	;LARGE UP TACK
      #x27D9	;LARGE DOWN TACK
      #x27DA	;LEFT AND RIGHT DOUBLE TURNSTILE
      #x27DB	;LEFT AND RIGHT TACK
      #x27DC	;LEFT MULTIMAP
      #x27DD	;LONG RIGHT TACK
      #x27DE	;LONG LEFT TACK
      #x27DF	;UP TACK WITH CIRCLE ABOVE
      #x27E0	;LOZENGE DIVIDED BY HORIZONTAL RULE
      #x27E1	;WHITE CONCAVE-SIDED DIAMOND
      #x27E2	;WHITE CONCAVE-SIDED DIAMOND WITH LEFTWARDS TICK
      #x27E3	;WHITE CONCAVE-SIDED DIAMOND WITH RIGHTWARDS TICK
      #x27E4	;WHITE SQUARE WITH LEFTWARDS TICK
      #x27E5	;WHITE SQUARE WITH RIGHTWARDS TICK
      #x27E6	;MATHEMATICAL LEFT WHITE SQUARE BRACKET
      #x27E7	;MATHEMATICAL RIGHT WHITE SQUARE BRACKET
      #x27E8	;MATHEMATICAL LEFT ANGLE BRACKET
      #x27E9	;MATHEMATICAL RIGHT ANGLE BRACKET
      #x27EA	;MATHEMATICAL LEFT DOUBLE ANGLE BRACKET
      #x27EB	;MATHEMATICAL RIGHT DOUBLE ANGLE BRACKET
      #x27F0	;UPWARDS QUADRUPLE ARROW
      #x27F1	;DOWNWARDS QUADRUPLE ARROW
      #x27F2	;ANTICLOCKWISE GAPPED CIRCLE ARROW
      #x27F3	;CLOCKWISE GAPPED CIRCLE ARROW
      #x27F4	;RIGHT ARROW WITH CIRCLED PLUS
      #x27F5	;LONG LEFTWARDS ARROW
      #x27F6	;LONG RIGHTWARDS ARROW
      #x27F7	;LONG LEFT RIGHT ARROW
      #x27F8	;LONG LEFTWARDS DOUBLE ARROW
      #x27F9	;LONG RIGHTWARDS DOUBLE ARROW
      #x27FA	;LONG LEFT RIGHT DOUBLE ARROW
      #x27FB	;LONG LEFTWARDS ARROW FROM BAR
      #x27FC	;LONG RIGHTWARDS ARROW FROM BAR
      #x27FD	;LONG LEFTWARDS DOUBLE ARROW FROM BAR
      #x27FE	;LONG RIGHTWARDS DOUBLE ARROW FROM BAR
      #x27FF	;LONG RIGHTWARDS SQUIGGLE ARROW
      #x2800	;BRAILLE PATTERN BLANK
      #x2801	;BRAILLE PATTERN DOTS-1
      #x2802	;BRAILLE PATTERN DOTS-2
      #x2803	;BRAILLE PATTERN DOTS-12
      #x2804	;BRAILLE PATTERN DOTS-3
      #x2805	;BRAILLE PATTERN DOTS-13
      #x2806	;BRAILLE PATTERN DOTS-23
      #x2807	;BRAILLE PATTERN DOTS-123
      #x2808	;BRAILLE PATTERN DOTS-4
      #x2809	;BRAILLE PATTERN DOTS-14
      #x280A	;BRAILLE PATTERN DOTS-24
      #x280B	;BRAILLE PATTERN DOTS-124
      #x280C	;BRAILLE PATTERN DOTS-34
      #x280D	;BRAILLE PATTERN DOTS-134
      #x280E	;BRAILLE PATTERN DOTS-234
      #x280F	;BRAILLE PATTERN DOTS-1234
      #x2810	;BRAILLE PATTERN DOTS-5
      #x2811	;BRAILLE PATTERN DOTS-15
      #x2812	;BRAILLE PATTERN DOTS-25
      #x2813	;BRAILLE PATTERN DOTS-125
      #x2814	;BRAILLE PATTERN DOTS-35
      #x2815	;BRAILLE PATTERN DOTS-135
      #x2816	;BRAILLE PATTERN DOTS-235
      #x2817	;BRAILLE PATTERN DOTS-1235
      #x2818	;BRAILLE PATTERN DOTS-45
      #x2819	;BRAILLE PATTERN DOTS-145
      #x281A	;BRAILLE PATTERN DOTS-245
      #x281B	;BRAILLE PATTERN DOTS-1245
      #x281C	;BRAILLE PATTERN DOTS-345
      #x281D	;BRAILLE PATTERN DOTS-1345
      #x281E	;BRAILLE PATTERN DOTS-2345
      #x281F	;BRAILLE PATTERN DOTS-12345
      #x2820	;BRAILLE PATTERN DOTS-6
      #x2821	;BRAILLE PATTERN DOTS-16
      #x2822	;BRAILLE PATTERN DOTS-26
      #x2823	;BRAILLE PATTERN DOTS-126
      #x2824	;BRAILLE PATTERN DOTS-36
      #x2825	;BRAILLE PATTERN DOTS-136
      #x2826	;BRAILLE PATTERN DOTS-236
      #x2827	;BRAILLE PATTERN DOTS-1236
      #x2828	;BRAILLE PATTERN DOTS-46
      #x2829	;BRAILLE PATTERN DOTS-146
      #x282A	;BRAILLE PATTERN DOTS-246
      #x282B	;BRAILLE PATTERN DOTS-1246
      #x282C	;BRAILLE PATTERN DOTS-346
      #x282D	;BRAILLE PATTERN DOTS-1346
      #x282E	;BRAILLE PATTERN DOTS-2346
      #x282F	;BRAILLE PATTERN DOTS-12346
      #x2830	;BRAILLE PATTERN DOTS-56
      #x2831	;BRAILLE PATTERN DOTS-156
      #x2832	;BRAILLE PATTERN DOTS-256
      #x2833	;BRAILLE PATTERN DOTS-1256
      #x2834	;BRAILLE PATTERN DOTS-356
      #x2835	;BRAILLE PATTERN DOTS-1356
      #x2836	;BRAILLE PATTERN DOTS-2356
      #x2837	;BRAILLE PATTERN DOTS-12356
      #x2838	;BRAILLE PATTERN DOTS-456
      #x2839	;BRAILLE PATTERN DOTS-1456
      #x283A	;BRAILLE PATTERN DOTS-2456
      #x283B	;BRAILLE PATTERN DOTS-12456
      #x283C	;BRAILLE PATTERN DOTS-3456
      #x283D	;BRAILLE PATTERN DOTS-13456
      #x283E	;BRAILLE PATTERN DOTS-23456
      #x283F	;BRAILLE PATTERN DOTS-123456
      #x2840	;BRAILLE PATTERN DOTS-7
      #x2841	;BRAILLE PATTERN DOTS-17
      #x2842	;BRAILLE PATTERN DOTS-27
      #x2843	;BRAILLE PATTERN DOTS-127
      #x2844	;BRAILLE PATTERN DOTS-37
      #x2845	;BRAILLE PATTERN DOTS-137
      #x2846	;BRAILLE PATTERN DOTS-237
      #x2847	;BRAILLE PATTERN DOTS-1237
      #x2848	;BRAILLE PATTERN DOTS-47
      #x2849	;BRAILLE PATTERN DOTS-147
      #x284A	;BRAILLE PATTERN DOTS-247
      #x284B	;BRAILLE PATTERN DOTS-1247
      #x284C	;BRAILLE PATTERN DOTS-347
      #x284D	;BRAILLE PATTERN DOTS-1347
      #x284E	;BRAILLE PATTERN DOTS-2347
      #x284F	;BRAILLE PATTERN DOTS-12347
      #x2850	;BRAILLE PATTERN DOTS-57
      #x2851	;BRAILLE PATTERN DOTS-157
      #x2852	;BRAILLE PATTERN DOTS-257
      #x2853	;BRAILLE PATTERN DOTS-1257
      #x2854	;BRAILLE PATTERN DOTS-357
      #x2855	;BRAILLE PATTERN DOTS-1357
      #x2856	;BRAILLE PATTERN DOTS-2357
      #x2857	;BRAILLE PATTERN DOTS-12357
      #x2858	;BRAILLE PATTERN DOTS-457
      #x2859	;BRAILLE PATTERN DOTS-1457
      #x285A	;BRAILLE PATTERN DOTS-2457
      #x285B	;BRAILLE PATTERN DOTS-12457
      #x285C	;BRAILLE PATTERN DOTS-3457
      #x285D	;BRAILLE PATTERN DOTS-13457
      #x285E	;BRAILLE PATTERN DOTS-23457
      #x285F	;BRAILLE PATTERN DOTS-123457
      #x2860	;BRAILLE PATTERN DOTS-67
      #x2861	;BRAILLE PATTERN DOTS-167
      #x2862	;BRAILLE PATTERN DOTS-267
      #x2863	;BRAILLE PATTERN DOTS-1267
      #x2864	;BRAILLE PATTERN DOTS-367
      #x2865	;BRAILLE PATTERN DOTS-1367
      #x2866	;BRAILLE PATTERN DOTS-2367
      #x2867	;BRAILLE PATTERN DOTS-12367
      #x2868	;BRAILLE PATTERN DOTS-467
      #x2869	;BRAILLE PATTERN DOTS-1467
      #x286A	;BRAILLE PATTERN DOTS-2467
      #x286B	;BRAILLE PATTERN DOTS-12467
      #x286C	;BRAILLE PATTERN DOTS-3467
      #x286D	;BRAILLE PATTERN DOTS-13467
      #x286E	;BRAILLE PATTERN DOTS-23467
      #x286F	;BRAILLE PATTERN DOTS-123467
      #x2870	;BRAILLE PATTERN DOTS-567
      #x2871	;BRAILLE PATTERN DOTS-1567
      #x2872	;BRAILLE PATTERN DOTS-2567
      #x2873	;BRAILLE PATTERN DOTS-12567
      #x2874	;BRAILLE PATTERN DOTS-3567
      #x2875	;BRAILLE PATTERN DOTS-13567
      #x2876	;BRAILLE PATTERN DOTS-23567
      #x2877	;BRAILLE PATTERN DOTS-123567
      #x2878	;BRAILLE PATTERN DOTS-4567
      #x2879	;BRAILLE PATTERN DOTS-14567
      #x287A	;BRAILLE PATTERN DOTS-24567
      #x287B	;BRAILLE PATTERN DOTS-124567
      #x287C	;BRAILLE PATTERN DOTS-34567
      #x287D	;BRAILLE PATTERN DOTS-134567
      #x287E	;BRAILLE PATTERN DOTS-234567
      #x287F	;BRAILLE PATTERN DOTS-1234567
      #x2880	;BRAILLE PATTERN DOTS-8
      #x2881	;BRAILLE PATTERN DOTS-18
      #x2882	;BRAILLE PATTERN DOTS-28
      #x2883	;BRAILLE PATTERN DOTS-128
      #x2884	;BRAILLE PATTERN DOTS-38
      #x2885	;BRAILLE PATTERN DOTS-138
      #x2886	;BRAILLE PATTERN DOTS-238
      #x2887	;BRAILLE PATTERN DOTS-1238
      #x2888	;BRAILLE PATTERN DOTS-48
      #x2889	;BRAILLE PATTERN DOTS-148
      #x288A	;BRAILLE PATTERN DOTS-248
      #x288B	;BRAILLE PATTERN DOTS-1248
      #x288C	;BRAILLE PATTERN DOTS-348
      #x288D	;BRAILLE PATTERN DOTS-1348
      #x288E	;BRAILLE PATTERN DOTS-2348
      #x288F	;BRAILLE PATTERN DOTS-12348
      #x2890	;BRAILLE PATTERN DOTS-58
      #x2891	;BRAILLE PATTERN DOTS-158
      #x2892	;BRAILLE PATTERN DOTS-258
      #x2893	;BRAILLE PATTERN DOTS-1258
      #x2894	;BRAILLE PATTERN DOTS-358
      #x2895	;BRAILLE PATTERN DOTS-1358
      #x2896	;BRAILLE PATTERN DOTS-2358
      #x2897	;BRAILLE PATTERN DOTS-12358
      #x2898	;BRAILLE PATTERN DOTS-458
      #x2899	;BRAILLE PATTERN DOTS-1458
      #x289A	;BRAILLE PATTERN DOTS-2458
      #x289B	;BRAILLE PATTERN DOTS-12458
      #x289C	;BRAILLE PATTERN DOTS-3458
      #x289D	;BRAILLE PATTERN DOTS-13458
      #x289E	;BRAILLE PATTERN DOTS-23458
      #x289F	;BRAILLE PATTERN DOTS-123458
      #x28A0	;BRAILLE PATTERN DOTS-68
      #x28A1	;BRAILLE PATTERN DOTS-168
      #x28A2	;BRAILLE PATTERN DOTS-268
      #x28A3	;BRAILLE PATTERN DOTS-1268
      #x28A4	;BRAILLE PATTERN DOTS-368
      #x28A5	;BRAILLE PATTERN DOTS-1368
      #x28A6	;BRAILLE PATTERN DOTS-2368
      #x28A7	;BRAILLE PATTERN DOTS-12368
      #x28A8	;BRAILLE PATTERN DOTS-468
      #x28A9	;BRAILLE PATTERN DOTS-1468
      #x28AA	;BRAILLE PATTERN DOTS-2468
      #x28AB	;BRAILLE PATTERN DOTS-12468
      #x28AC	;BRAILLE PATTERN DOTS-3468
      #x28AD	;BRAILLE PATTERN DOTS-13468
      #x28AE	;BRAILLE PATTERN DOTS-23468
      #x28AF	;BRAILLE PATTERN DOTS-123468
      #x28B0	;BRAILLE PATTERN DOTS-568
      #x28B1	;BRAILLE PATTERN DOTS-1568
      #x28B2	;BRAILLE PATTERN DOTS-2568
      #x28B3	;BRAILLE PATTERN DOTS-12568
      #x28B4	;BRAILLE PATTERN DOTS-3568
      #x28B5	;BRAILLE PATTERN DOTS-13568
      #x28B6	;BRAILLE PATTERN DOTS-23568
      #x28B7	;BRAILLE PATTERN DOTS-123568
      #x28B8	;BRAILLE PATTERN DOTS-4568
      #x28B9	;BRAILLE PATTERN DOTS-14568
      #x28BA	;BRAILLE PATTERN DOTS-24568
      #x28BB	;BRAILLE PATTERN DOTS-124568
      #x28BC	;BRAILLE PATTERN DOTS-34568
      #x28BD	;BRAILLE PATTERN DOTS-134568
      #x28BE	;BRAILLE PATTERN DOTS-234568
      #x28BF	;BRAILLE PATTERN DOTS-1234568
      #x28C0	;BRAILLE PATTERN DOTS-78
      #x28C1	;BRAILLE PATTERN DOTS-178
      #x28C2	;BRAILLE PATTERN DOTS-278
      #x28C3	;BRAILLE PATTERN DOTS-1278
      #x28C4	;BRAILLE PATTERN DOTS-378
      #x28C5	;BRAILLE PATTERN DOTS-1378
      #x28C6	;BRAILLE PATTERN DOTS-2378
      #x28C7	;BRAILLE PATTERN DOTS-12378
      #x28C8	;BRAILLE PATTERN DOTS-478
      #x28C9	;BRAILLE PATTERN DOTS-1478
      #x28CA	;BRAILLE PATTERN DOTS-2478
      #x28CB	;BRAILLE PATTERN DOTS-12478
      #x28CC	;BRAILLE PATTERN DOTS-3478
      #x28CD	;BRAILLE PATTERN DOTS-13478
      #x28CE	;BRAILLE PATTERN DOTS-23478
      #x28CF	;BRAILLE PATTERN DOTS-123478
      #x28D0	;BRAILLE PATTERN DOTS-578
      #x28D1	;BRAILLE PATTERN DOTS-1578
      #x28D2	;BRAILLE PATTERN DOTS-2578
      #x28D3	;BRAILLE PATTERN DOTS-12578
      #x28D4	;BRAILLE PATTERN DOTS-3578
      #x28D5	;BRAILLE PATTERN DOTS-13578
      #x28D6	;BRAILLE PATTERN DOTS-23578
      #x28D7	;BRAILLE PATTERN DOTS-123578
      #x28D8	;BRAILLE PATTERN DOTS-4578
      #x28D9	;BRAILLE PATTERN DOTS-14578
      #x28DA	;BRAILLE PATTERN DOTS-24578
      #x28DB	;BRAILLE PATTERN DOTS-124578
      #x28DC	;BRAILLE PATTERN DOTS-34578
      #x28DD	;BRAILLE PATTERN DOTS-134578
      #x28DE	;BRAILLE PATTERN DOTS-234578
      #x28DF	;BRAILLE PATTERN DOTS-1234578
      #x28E0	;BRAILLE PATTERN DOTS-678
      #x28E1	;BRAILLE PATTERN DOTS-1678
      #x28E2	;BRAILLE PATTERN DOTS-2678
      #x28E3	;BRAILLE PATTERN DOTS-12678
      #x28E4	;BRAILLE PATTERN DOTS-3678
      #x28E5	;BRAILLE PATTERN DOTS-13678
      #x28E6	;BRAILLE PATTERN DOTS-23678
      #x28E7	;BRAILLE PATTERN DOTS-123678
      #x28E8	;BRAILLE PATTERN DOTS-4678
      #x28E9	;BRAILLE PATTERN DOTS-14678
      #x28EA	;BRAILLE PATTERN DOTS-24678
      #x28EB	;BRAILLE PATTERN DOTS-124678
      #x28EC	;BRAILLE PATTERN DOTS-34678
      #x28ED	;BRAILLE PATTERN DOTS-134678
      #x28EE	;BRAILLE PATTERN DOTS-234678
      #x28EF	;BRAILLE PATTERN DOTS-1234678
      #x28F0	;BRAILLE PATTERN DOTS-5678
      #x28F1	;BRAILLE PATTERN DOTS-15678
      #x28F2	;BRAILLE PATTERN DOTS-25678
      #x28F3	;BRAILLE PATTERN DOTS-125678
      #x28F4	;BRAILLE PATTERN DOTS-35678
      #x28F5	;BRAILLE PATTERN DOTS-135678
      #x28F6	;BRAILLE PATTERN DOTS-235678
      #x28F7	;BRAILLE PATTERN DOTS-1235678
      #x28F8	;BRAILLE PATTERN DOTS-45678
      #x28F9	;BRAILLE PATTERN DOTS-145678
      #x28FA	;BRAILLE PATTERN DOTS-245678
      #x28FB	;BRAILLE PATTERN DOTS-1245678
      #x28FC	;BRAILLE PATTERN DOTS-345678
      #x28FD	;BRAILLE PATTERN DOTS-1345678
      #x28FE	;BRAILLE PATTERN DOTS-2345678
      #x28FF	;BRAILLE PATTERN DOTS-12345678
      #x2900	;RIGHTWARDS TWO-HEADED ARROW WITH VERTICAL STROKE
      #x2901	;RIGHTWARDS TWO-HEADED ARROW WITH DOUBLE VERTICAL STROKE
      #x2902	;LEFTWARDS DOUBLE ARROW WITH VERTICAL STROKE
      #x2903	;RIGHTWARDS DOUBLE ARROW WITH VERTICAL STROKE
      #x2904	;LEFT RIGHT DOUBLE ARROW WITH VERTICAL STROKE
      #x2905	;RIGHTWARDS TWO-HEADED ARROW FROM BAR
      #x2906	;LEFTWARDS DOUBLE ARROW FROM BAR
      #x2907	;RIGHTWARDS DOUBLE ARROW FROM BAR
      #x2908	;DOWNWARDS ARROW WITH HORIZONTAL STROKE
      #x2909	;UPWARDS ARROW WITH HORIZONTAL STROKE
      #x290A	;UPWARDS TRIPLE ARROW
      #x290B	;DOWNWARDS TRIPLE ARROW
      #x290C	;LEFTWARDS DOUBLE DASH ARROW
      #x290D	;RIGHTWARDS DOUBLE DASH ARROW
      #x290E	;LEFTWARDS TRIPLE DASH ARROW
      #x290F	;RIGHTWARDS TRIPLE DASH ARROW
      #x2910	;RIGHTWARDS TWO-HEADED TRIPLE DASH ARROW
      #x2911	;RIGHTWARDS ARROW WITH DOTTED STEM
      #x2912	;UPWARDS ARROW TO BAR
      #x2913	;DOWNWARDS ARROW TO BAR
      #x2914	;RIGHTWARDS ARROW WITH TAIL WITH VERTICAL STROKE
      #x2915	;RIGHTWARDS ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
      #x2916	;RIGHTWARDS TWO-HEADED ARROW WITH TAIL
      #x2917	;RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH VERTICAL STROKE
      #x2918	;RIGHTWARDS TWO-HEADED ARROW WITH TAIL WITH DOUBLE VERTICAL STROKE
      #x2919	;LEFTWARDS ARROW-TAIL
      #x291A	;RIGHTWARDS ARROW-TAIL
      #x291B	;LEFTWARDS DOUBLE ARROW-TAIL
      #x291C	;RIGHTWARDS DOUBLE ARROW-TAIL
      #x291D	;LEFTWARDS ARROW TO BLACK DIAMOND
      #x291E	;RIGHTWARDS ARROW TO BLACK DIAMOND
      #x291F	;LEFTWARDS ARROW FROM BAR TO BLACK DIAMOND
      #x2920	;RIGHTWARDS ARROW FROM BAR TO BLACK DIAMOND
      #x2921	;NORTH WEST AND SOUTH EAST ARROW
      #x2922	;NORTH EAST AND SOUTH WEST ARROW
      #x2923	;NORTH WEST ARROW WITH HOOK
      #x2924	;NORTH EAST ARROW WITH HOOK
      #x2925	;SOUTH EAST ARROW WITH HOOK
      #x2926	;SOUTH WEST ARROW WITH HOOK
      #x2927	;NORTH WEST ARROW AND NORTH EAST ARROW
      #x2928	;NORTH EAST ARROW AND SOUTH EAST ARROW
      #x2929	;SOUTH EAST ARROW AND SOUTH WEST ARROW
      #x292A	;SOUTH WEST ARROW AND NORTH WEST ARROW
      #x292B	;RISING DIAGONAL CROSSING FALLING DIAGONAL
      #x292C	;FALLING DIAGONAL CROSSING RISING DIAGONAL
      #x292D	;SOUTH EAST ARROW CROSSING NORTH EAST ARROW
      #x292E	;NORTH EAST ARROW CROSSING SOUTH EAST ARROW
      #x292F	;FALLING DIAGONAL CROSSING NORTH EAST ARROW
      #x2930	;RISING DIAGONAL CROSSING SOUTH EAST ARROW
      #x2931	;NORTH EAST ARROW CROSSING NORTH WEST ARROW
      #x2932	;NORTH WEST ARROW CROSSING NORTH EAST ARROW
      #x2933	;WAVE ARROW POINTING DIRECTLY RIGHT
      #x2934	;ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS
      #x2935	;ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS
      #x2936	;ARROW POINTING DOWNWARDS THEN CURVING LEFTWARDS
      #x2937	;ARROW POINTING DOWNWARDS THEN CURVING RIGHTWARDS
      #x2938	;RIGHT-SIDE ARC CLOCKWISE ARROW
      #x2939	;LEFT-SIDE ARC ANTICLOCKWISE ARROW
      #x293A	;TOP ARC ANTICLOCKWISE ARROW
      #x293B	;BOTTOM ARC ANTICLOCKWISE ARROW
      #x293C	;TOP ARC CLOCKWISE ARROW WITH MINUS
      #x293D	;TOP ARC ANTICLOCKWISE ARROW WITH PLUS
      #x293E	;LOWER RIGHT SEMICIRCULAR CLOCKWISE ARROW
      #x293F	;LOWER LEFT SEMICIRCULAR ANTICLOCKWISE ARROW
      #x2940	;ANTICLOCKWISE CLOSED CIRCLE ARROW
      #x2941	;CLOCKWISE CLOSED CIRCLE ARROW
      #x2942	;RIGHTWARDS ARROW ABOVE SHORT LEFTWARDS ARROW
      #x2943	;LEFTWARDS ARROW ABOVE SHORT RIGHTWARDS ARROW
      #x2944	;SHORT RIGHTWARDS ARROW ABOVE LEFTWARDS ARROW
      #x2945	;RIGHTWARDS ARROW WITH PLUS BELOW
      #x2946	;LEFTWARDS ARROW WITH PLUS BELOW
      #x2947	;RIGHTWARDS ARROW THROUGH X
      #x2948	;LEFT RIGHT ARROW THROUGH SMALL CIRCLE
      #x2949	;UPWARDS TWO-HEADED ARROW FROM SMALL CIRCLE
      #x294A	;LEFT BARB UP RIGHT BARB DOWN HARPOON
      #x294B	;LEFT BARB DOWN RIGHT BARB UP HARPOON
      #x294C	;UP BARB RIGHT DOWN BARB LEFT HARPOON
      #x294D	;UP BARB LEFT DOWN BARB RIGHT HARPOON
      #x294E	;LEFT BARB UP RIGHT BARB UP HARPOON
      #x294F	;UP BARB RIGHT DOWN BARB RIGHT HARPOON
      #x2950	;LEFT BARB DOWN RIGHT BARB DOWN HARPOON
      #x2951	;UP BARB LEFT DOWN BARB LEFT HARPOON
      #x2952	;LEFTWARDS HARPOON WITH BARB UP TO BAR
      #x2953	;RIGHTWARDS HARPOON WITH BARB UP TO BAR
      #x2954	;UPWARDS HARPOON WITH BARB RIGHT TO BAR
      #x2955	;DOWNWARDS HARPOON WITH BARB RIGHT TO BAR
      #x2956	;LEFTWARDS HARPOON WITH BARB DOWN TO BAR
      #x2957	;RIGHTWARDS HARPOON WITH BARB DOWN TO BAR
      #x2958	;UPWARDS HARPOON WITH BARB LEFT TO BAR
      #x2959	;DOWNWARDS HARPOON WITH BARB LEFT TO BAR
      #x295A	;LEFTWARDS HARPOON WITH BARB UP FROM BAR
      #x295B	;RIGHTWARDS HARPOON WITH BARB UP FROM BAR
      #x295C	;UPWARDS HARPOON WITH BARB RIGHT FROM BAR
      #x295D	;DOWNWARDS HARPOON WITH BARB RIGHT FROM BAR
      #x295E	;LEFTWARDS HARPOON WITH BARB DOWN FROM BAR
      #x295F	;RIGHTWARDS HARPOON WITH BARB DOWN FROM BAR
      #x2960	;UPWARDS HARPOON WITH BARB LEFT FROM BAR
      #x2961	;DOWNWARDS HARPOON WITH BARB LEFT FROM BAR
      #x2962	;LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN
      #x2963	;UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
      #x2964	;RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
      #x2965	;DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
      #x2966	;LEFTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB UP
      #x2967	;LEFTWARDS HARPOON WITH BARB DOWN ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
      #x2968	;RIGHTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB UP
      #x2969	;RIGHTWARDS HARPOON WITH BARB DOWN ABOVE LEFTWARDS HARPOON WITH BARB DOWN
      #x296A	;LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
      #x296B	;LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
      #x296C	;RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
      #x296D	;RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
      #x296E	;UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
      #x296F	;DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
      #x2970	;RIGHT DOUBLE ARROW WITH ROUNDED HEAD
      #x2971	;EQUALS SIGN ABOVE RIGHTWARDS ARROW
      #x2972	;TILDE OPERATOR ABOVE RIGHTWARDS ARROW
      #x2973	;LEFTWARDS ARROW ABOVE TILDE OPERATOR
      #x2974	;RIGHTWARDS ARROW ABOVE TILDE OPERATOR
      #x2975	;RIGHTWARDS ARROW ABOVE ALMOST EQUAL TO
      #x2976	;LESS-THAN ABOVE LEFTWARDS ARROW
      #x2977	;LEFTWARDS ARROW THROUGH LESS-THAN
      #x2978	;GREATER-THAN ABOVE RIGHTWARDS ARROW
      #x2979	;SUBSET ABOVE RIGHTWARDS ARROW
      #x297A	;LEFTWARDS ARROW THROUGH SUBSET
      #x297B	;SUPERSET ABOVE LEFTWARDS ARROW
      #x297C	;LEFT FISH TAIL
      #x297D	;RIGHT FISH TAIL
      #x297E	;UP FISH TAIL
      #x297F	;DOWN FISH TAIL
      #x2980	;TRIPLE VERTICAL BAR DELIMITER
      #x2981	;Z NOTATION SPOT
      #x2982	;Z NOTATION TYPE COLON
      #x2983	;LEFT WHITE CURLY BRACKET
      #x2984	;RIGHT WHITE CURLY BRACKET
      #x2985	;LEFT WHITE PARENTHESIS
      #x2986	;RIGHT WHITE PARENTHESIS
      #x2987	;Z NOTATION LEFT IMAGE BRACKET
      #x2988	;Z NOTATION RIGHT IMAGE BRACKET
      #x2989	;Z NOTATION LEFT BINDING BRACKET
      #x298A	;Z NOTATION RIGHT BINDING BRACKET
      #x298B	;LEFT SQUARE BRACKET WITH UNDERBAR
      #x298C	;RIGHT SQUARE BRACKET WITH UNDERBAR
      #x298D	;LEFT SQUARE BRACKET WITH TICK IN TOP CORNER
      #x298E	;RIGHT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
      #x298F	;LEFT SQUARE BRACKET WITH TICK IN BOTTOM CORNER
      #x2990	;RIGHT SQUARE BRACKET WITH TICK IN TOP CORNER
      #x2991	;LEFT ANGLE BRACKET WITH DOT
      #x2992	;RIGHT ANGLE BRACKET WITH DOT
      #x2993	;LEFT ARC LESS-THAN BRACKET
      #x2994	;RIGHT ARC GREATER-THAN BRACKET
      #x2995	;DOUBLE LEFT ARC GREATER-THAN BRACKET
      #x2996	;DOUBLE RIGHT ARC LESS-THAN BRACKET
      #x2997	;LEFT BLACK TORTOISE SHELL BRACKET
      #x2998	;RIGHT BLACK TORTOISE SHELL BRACKET
      #x2999	;DOTTED FENCE
      #x299A	;VERTICAL ZIGZAG LINE
      #x299B	;MEASURED ANGLE OPENING LEFT
      #x299C	;RIGHT ANGLE VARIANT WITH SQUARE
      #x299D	;MEASURED RIGHT ANGLE WITH DOT
      #x299E	;ANGLE WITH S INSIDE
      #x299F	;ACUTE ANGLE
      #x29A0	;SPHERICAL ANGLE OPENING LEFT
      #x29A1	;SPHERICAL ANGLE OPENING UP
      #x29A2	;TURNED ANGLE
      #x29A3	;REVERSED ANGLE
      #x29A4	;ANGLE WITH UNDERBAR
      #x29A5	;REVERSED ANGLE WITH UNDERBAR
      #x29A6	;OBLIQUE ANGLE OPENING UP
      #x29A7	;OBLIQUE ANGLE OPENING DOWN
      #x29A8	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND RIGHT
      #x29A9	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING UP AND LEFT
      #x29AA	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND RIGHT
      #x29AB	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING DOWN AND LEFT
      #x29AC	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND UP
      #x29AD	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND UP
      #x29AE	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING RIGHT AND DOWN
      #x29AF	;MEASURED ANGLE WITH OPEN ARM ENDING IN ARROW POINTING LEFT AND DOWN
      #x29B0	;REVERSED EMPTY SET
      #x29B1	;EMPTY SET WITH OVERBAR
      #x29B2	;EMPTY SET WITH SMALL CIRCLE ABOVE
      #x29B3	;EMPTY SET WITH RIGHT ARROW ABOVE
      #x29B4	;EMPTY SET WITH LEFT ARROW ABOVE
      #x29B5	;CIRCLE WITH HORIZONTAL BAR
      #x29B6	;CIRCLED VERTICAL BAR
      #x29B7	;CIRCLED PARALLEL
      #x29B8	;CIRCLED REVERSE SOLIDUS
      #x29B9	;CIRCLED PERPENDICULAR
      #x29BA	;CIRCLE DIVIDED BY HORIZONTAL BAR AND TOP HALF DIVIDED BY VERTICAL BAR
      #x29BB	;CIRCLE WITH SUPERIMPOSED X
      #x29BC	;CIRCLED ANTICLOCKWISE-ROTATED DIVISION SIGN
      #x29BD	;UP ARROW THROUGH CIRCLE
      #x29BE	;CIRCLED WHITE BULLET
      #x29BF	;CIRCLED BULLET
      #x29C0	;CIRCLED LESS-THAN
      #x29C1	;CIRCLED GREATER-THAN
      #x29C2	;CIRCLE WITH SMALL CIRCLE TO THE RIGHT
      #x29C3	;CIRCLE WITH TWO HORIZONTAL STROKES TO THE RIGHT
      #x29C4	;SQUARED RISING DIAGONAL SLASH
      #x29C5	;SQUARED FALLING DIAGONAL SLASH
      #x29C6	;SQUARED ASTERISK
      #x29C7	;SQUARED SMALL CIRCLE
      #x29C8	;SQUARED SQUARE
      #x29C9	;TWO JOINED SQUARES
      #x29CA	;TRIANGLE WITH DOT ABOVE
      #x29CB	;TRIANGLE WITH UNDERBAR
      #x29CC	;S IN TRIANGLE
      #x29CD	;TRIANGLE WITH SERIFS AT BOTTOM
      #x29CE	;RIGHT TRIANGLE ABOVE LEFT TRIANGLE
      #x29CF	;LEFT TRIANGLE BESIDE VERTICAL BAR
      #x29D0	;VERTICAL BAR BESIDE RIGHT TRIANGLE
      #x29D1	;BOWTIE WITH LEFT HALF BLACK
      #x29D2	;BOWTIE WITH RIGHT HALF BLACK
      #x29D3	;BLACK BOWTIE
      #x29D4	;TIMES WITH LEFT HALF BLACK
      #x29D5	;TIMES WITH RIGHT HALF BLACK
      #x29D6	;WHITE HOURGLASS
      #x29D7	;BLACK HOURGLASS
      #x29D8	;LEFT WIGGLY FENCE
      #x29D9	;RIGHT WIGGLY FENCE
      #x29DA	;LEFT DOUBLE WIGGLY FENCE
      #x29DB	;RIGHT DOUBLE WIGGLY FENCE
      #x29DC	;INCOMPLETE INFINITY
      #x29DD	;TIE OVER INFINITY
      #x29DE	;INFINITY NEGATED WITH VERTICAL BAR
      #x29DF	;DOUBLE-ENDED MULTIMAP
      #x29E0	;SQUARE WITH CONTOURED OUTLINE
      #x29E1	;INCREASES AS
      #x29E2	;SHUFFLE PRODUCT
      #x29E3	;EQUALS SIGN AND SLANTED PARALLEL
      #x29E4	;EQUALS SIGN AND SLANTED PARALLEL WITH TILDE ABOVE
      #x29E5	;IDENTICAL TO AND SLANTED PARALLEL
      #x29E6	;GLEICH STARK
      #x29E7	;THERMODYNAMIC
      #x29E8	;DOWN-POINTING TRIANGLE WITH LEFT HALF BLACK
      #x29E9	;DOWN-POINTING TRIANGLE WITH RIGHT HALF BLACK
      #x29EA	;BLACK DIAMOND WITH DOWN ARROW
      #x29EB	;BLACK LOZENGE
      #x29EC	;WHITE CIRCLE WITH DOWN ARROW
      #x29ED	;BLACK CIRCLE WITH DOWN ARROW
      #x29EE	;ERROR-BARRED WHITE SQUARE
      #x29EF	;ERROR-BARRED BLACK SQUARE
      #x29F0	;ERROR-BARRED WHITE DIAMOND
      #x29F1	;ERROR-BARRED BLACK DIAMOND
      #x29F2	;ERROR-BARRED WHITE CIRCLE
      #x29F3	;ERROR-BARRED BLACK CIRCLE
      #x29F4	;RULE-DELAYED
      #x29F5	;REVERSE SOLIDUS OPERATOR
      #x29F6	;SOLIDUS WITH OVERBAR
      #x29F7	;REVERSE SOLIDUS WITH HORIZONTAL STROKE
      #x29F8	;BIG SOLIDUS
      #x29F9	;BIG REVERSE SOLIDUS
      #x29FA	;DOUBLE PLUS
      #x29FB	;TRIPLE PLUS
      #x29FC	;LEFT-POINTING CURVED ANGLE BRACKET
      #x29FD	;RIGHT-POINTING CURVED ANGLE BRACKET
      #x29FE	;TINY
      #x29FF	;MINY
      #x2A00	;N-ARY CIRCLED DOT OPERATOR
      #x2A01	;N-ARY CIRCLED PLUS OPERATOR
      #x2A02	;N-ARY CIRCLED TIMES OPERATOR
      #x2A03	;N-ARY UNION OPERATOR WITH DOT
      #x2A04	;N-ARY UNION OPERATOR WITH PLUS
      #x2A05	;N-ARY SQUARE INTERSECTION OPERATOR
      #x2A06	;N-ARY SQUARE UNION OPERATOR
      #x2A07	;TWO LOGICAL AND OPERATOR
      #x2A08	;TWO LOGICAL OR OPERATOR
      #x2A09	;N-ARY TIMES OPERATOR
      #x2A0A	;MODULO TWO SUM
      #x2A0B	;SUMMATION WITH INTEGRAL
      #x2A0C	;QUADRUPLE INTEGRAL OPERATOR
      #x2A0D	;FINITE PART INTEGRAL
      #x2A0E	;INTEGRAL WITH DOUBLE STROKE
      #x2A0F	;INTEGRAL AVERAGE WITH SLASH
      #x2A10	;CIRCULATION FUNCTION
      #x2A11	;ANTICLOCKWISE INTEGRATION
      #x2A12	;LINE INTEGRATION WITH RECTANGULAR PATH AROUND POLE
      #x2A13	;LINE INTEGRATION WITH SEMICIRCULAR PATH AROUND POLE
      #x2A14	;LINE INTEGRATION NOT INCLUDING THE POLE
      #x2A15	;INTEGRAL AROUND A POINT OPERATOR
      #x2A16	;QUATERNION INTEGRAL OPERATOR
      #x2A17	;INTEGRAL WITH LEFTWARDS ARROW WITH HOOK
      #x2A18	;INTEGRAL WITH TIMES SIGN
      #x2A19	;INTEGRAL WITH INTERSECTION
      #x2A1A	;INTEGRAL WITH UNION
      #x2A1B	;INTEGRAL WITH OVERBAR
      #x2A1C	;INTEGRAL WITH UNDERBAR
      #x2A1D	;JOIN
      #x2A1E	;LARGE LEFT TRIANGLE OPERATOR
      #x2A1F	;Z NOTATION SCHEMA COMPOSITION
      #x2A20	;Z NOTATION SCHEMA PIPING
      #x2A21	;Z NOTATION SCHEMA PROJECTION
      #x2A22	;PLUS SIGN WITH SMALL CIRCLE ABOVE
      #x2A23	;PLUS SIGN WITH CIRCUMFLEX ACCENT ABOVE
      #x2A24	;PLUS SIGN WITH TILDE ABOVE
      #x2A25	;PLUS SIGN WITH DOT BELOW
      #x2A26	;PLUS SIGN WITH TILDE BELOW
      #x2A27	;PLUS SIGN WITH SUBSCRIPT TWO
      #x2A28	;PLUS SIGN WITH BLACK TRIANGLE
      #x2A29	;MINUS SIGN WITH COMMA ABOVE
      #x2A2A	;MINUS SIGN WITH DOT BELOW
      #x2A2B	;MINUS SIGN WITH FALLING DOTS
      #x2A2C	;MINUS SIGN WITH RISING DOTS
      #x2A2D	;PLUS SIGN IN LEFT HALF CIRCLE
      #x2A2E	;PLUS SIGN IN RIGHT HALF CIRCLE
      #x2A2F	;VECTOR OR CROSS PRODUCT
      #x2A30	;MULTIPLICATION SIGN WITH DOT ABOVE
      #x2A31	;MULTIPLICATION SIGN WITH UNDERBAR
      #x2A32	;SEMIDIRECT PRODUCT WITH BOTTOM CLOSED
      #x2A33	;SMASH PRODUCT
      #x2A34	;MULTIPLICATION SIGN IN LEFT HALF CIRCLE
      #x2A35	;MULTIPLICATION SIGN IN RIGHT HALF CIRCLE
      #x2A36	;CIRCLED MULTIPLICATION SIGN WITH CIRCUMFLEX ACCENT
      #x2A37	;MULTIPLICATION SIGN IN DOUBLE CIRCLE
      #x2A38	;CIRCLED DIVISION SIGN
      #x2A39	;PLUS SIGN IN TRIANGLE
      #x2A3A	;MINUS SIGN IN TRIANGLE
      #x2A3B	;MULTIPLICATION SIGN IN TRIANGLE
      #x2A3C	;INTERIOR PRODUCT
      #x2A3D	;RIGHTHAND INTERIOR PRODUCT
      #x2A3E	;Z NOTATION RELATIONAL COMPOSITION
      #x2A3F	;AMALGAMATION OR COPRODUCT
      #x2A40	;INTERSECTION WITH DOT
      #x2A41	;UNION WITH MINUS SIGN
      #x2A42	;UNION WITH OVERBAR
      #x2A43	;INTERSECTION WITH OVERBAR
      #x2A44	;INTERSECTION WITH LOGICAL AND
      #x2A45	;UNION WITH LOGICAL OR
      #x2A46	;UNION ABOVE INTERSECTION
      #x2A47	;INTERSECTION ABOVE UNION
      #x2A48	;UNION ABOVE BAR ABOVE INTERSECTION
      #x2A49	;INTERSECTION ABOVE BAR ABOVE UNION
      #x2A4A	;UNION BESIDE AND JOINED WITH UNION
      #x2A4B	;INTERSECTION BESIDE AND JOINED WITH INTERSECTION
      #x2A4C	;CLOSED UNION WITH SERIFS
      #x2A4D	;CLOSED INTERSECTION WITH SERIFS
      #x2A4E	;DOUBLE SQUARE INTERSECTION
      #x2A4F	;DOUBLE SQUARE UNION
      #x2A50	;CLOSED UNION WITH SERIFS AND SMASH PRODUCT
      #x2A51	;LOGICAL AND WITH DOT ABOVE
      #x2A52	;LOGICAL OR WITH DOT ABOVE
      #x2A53	;DOUBLE LOGICAL AND
      #x2A54	;DOUBLE LOGICAL OR
      #x2A55	;TWO INTERSECTING LOGICAL AND
      #x2A56	;TWO INTERSECTING LOGICAL OR
      #x2A57	;SLOPING LARGE OR
      #x2A58	;SLOPING LARGE AND
      #x2A59	;LOGICAL OR OVERLAPPING LOGICAL AND
      #x2A5A	;LOGICAL AND WITH MIDDLE STEM
      #x2A5B	;LOGICAL OR WITH MIDDLE STEM
      #x2A5C	;LOGICAL AND WITH HORIZONTAL DASH
      #x2A5D	;LOGICAL OR WITH HORIZONTAL DASH
      #x2A5E	;LOGICAL AND WITH DOUBLE OVERBAR
      #x2A5F	;LOGICAL AND WITH UNDERBAR
      #x2A60	;LOGICAL AND WITH DOUBLE UNDERBAR
      #x2A61	;SMALL VEE WITH UNDERBAR
      #x2A62	;LOGICAL OR WITH DOUBLE OVERBAR
      #x2A63	;LOGICAL OR WITH DOUBLE UNDERBAR
      #x2A64	;Z NOTATION DOMAIN ANTIRESTRICTION
      #x2A65	;Z NOTATION RANGE ANTIRESTRICTION
      #x2A66	;EQUALS SIGN WITH DOT BELOW
      #x2A67	;IDENTICAL WITH DOT ABOVE
      #x2A68	;TRIPLE HORIZONTAL BAR WITH DOUBLE VERTICAL STROKE
      #x2A69	;TRIPLE HORIZONTAL BAR WITH TRIPLE VERTICAL STROKE
      #x2A6A	;TILDE OPERATOR WITH DOT ABOVE
      #x2A6B	;TILDE OPERATOR WITH RISING DOTS
      #x2A6C	;SIMILAR MINUS SIMILAR
      #x2A6D	;CONGRUENT WITH DOT ABOVE
      #x2A6E	;EQUALS WITH ASTERISK
      #x2A6F	;ALMOST EQUAL TO WITH CIRCUMFLEX ACCENT
      #x2A70	;APPROXIMATELY EQUAL OR EQUAL TO
      #x2A71	;EQUALS SIGN ABOVE PLUS SIGN
      #x2A72	;PLUS SIGN ABOVE EQUALS SIGN
      #x2A73	;EQUALS SIGN ABOVE TILDE OPERATOR
      #x2A74	;DOUBLE COLON EQUAL
      #x2A75	;TWO CONSECUTIVE EQUALS SIGNS
      #x2A76	;THREE CONSECUTIVE EQUALS SIGNS
      #x2A77	;EQUALS SIGN WITH TWO DOTS ABOVE AND TWO DOTS BELOW
      #x2A78	;EQUIVALENT WITH FOUR DOTS ABOVE
      #x2A79	;LESS-THAN WITH CIRCLE INSIDE
      #x2A7A	;GREATER-THAN WITH CIRCLE INSIDE
      #x2A7B	;LESS-THAN WITH QUESTION MARK ABOVE
      #x2A7C	;GREATER-THAN WITH QUESTION MARK ABOVE
      #x2A7D	;LESS-THAN OR SLANTED EQUAL TO
      #x2A7E	;GREATER-THAN OR SLANTED EQUAL TO
      #x2A7F	;LESS-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
      #x2A80	;GREATER-THAN OR SLANTED EQUAL TO WITH DOT INSIDE
      #x2A81	;LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
      #x2A82	;GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE
      #x2A83	;LESS-THAN OR SLANTED EQUAL TO WITH DOT ABOVE RIGHT
      #x2A84	;GREATER-THAN OR SLANTED EQUAL TO WITH DOT ABOVE LEFT
      #x2A85	;LESS-THAN OR APPROXIMATE
      #x2A86	;GREATER-THAN OR APPROXIMATE
      #x2A87	;LESS-THAN AND SINGLE-LINE NOT EQUAL TO
      #x2A88	;GREATER-THAN AND SINGLE-LINE NOT EQUAL TO
      #x2A89	;LESS-THAN AND NOT APPROXIMATE
      #x2A8A	;GREATER-THAN AND NOT APPROXIMATE
      #x2A8B	;LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN
      #x2A8C	;GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN
      #x2A8D	;LESS-THAN ABOVE SIMILAR OR EQUAL
      #x2A8E	;GREATER-THAN ABOVE SIMILAR OR EQUAL
      #x2A8F	;LESS-THAN ABOVE SIMILAR ABOVE GREATER-THAN
      #x2A90	;GREATER-THAN ABOVE SIMILAR ABOVE LESS-THAN
      #x2A91	;LESS-THAN ABOVE GREATER-THAN ABOVE DOUBLE-LINE EQUAL
      #x2A92	;GREATER-THAN ABOVE LESS-THAN ABOVE DOUBLE-LINE EQUAL
      #x2A93	;LESS-THAN ABOVE SLANTED EQUAL ABOVE GREATER-THAN ABOVE SLANTED EQUAL
      #x2A94	;GREATER-THAN ABOVE SLANTED EQUAL ABOVE LESS-THAN ABOVE SLANTED EQUAL
      #x2A95	;SLANTED EQUAL TO OR LESS-THAN
      #x2A96	;SLANTED EQUAL TO OR GREATER-THAN
      #x2A97	;SLANTED EQUAL TO OR LESS-THAN WITH DOT INSIDE
      #x2A98	;SLANTED EQUAL TO OR GREATER-THAN WITH DOT INSIDE
      #x2A99	;DOUBLE-LINE EQUAL TO OR LESS-THAN
      #x2A9A	;DOUBLE-LINE EQUAL TO OR GREATER-THAN
      #x2A9B	;DOUBLE-LINE SLANTED EQUAL TO OR LESS-THAN
      #x2A9C	;DOUBLE-LINE SLANTED EQUAL TO OR GREATER-THAN
      #x2A9D	;SIMILAR OR LESS-THAN
      #x2A9E	;SIMILAR OR GREATER-THAN
      #x2A9F	;SIMILAR ABOVE LESS-THAN ABOVE EQUALS SIGN
      #x2AA0	;SIMILAR ABOVE GREATER-THAN ABOVE EQUALS SIGN
      #x2AA1	;DOUBLE NESTED LESS-THAN
      #x2AA2	;DOUBLE NESTED GREATER-THAN
      #x2AA3	;DOUBLE NESTED LESS-THAN WITH UNDERBAR
      #x2AA4	;GREATER-THAN OVERLAPPING LESS-THAN
      #x2AA5	;GREATER-THAN BESIDE LESS-THAN
      #x2AA6	;LESS-THAN CLOSED BY CURVE
      #x2AA7	;GREATER-THAN CLOSED BY CURVE
      #x2AA8	;LESS-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
      #x2AA9	;GREATER-THAN CLOSED BY CURVE ABOVE SLANTED EQUAL
      #x2AAA	;SMALLER THAN
      #x2AAB	;LARGER THAN
      #x2AAC	;SMALLER THAN OR EQUAL TO
      #x2AAD	;LARGER THAN OR EQUAL TO
      #x2AAE	;EQUALS SIGN WITH BUMPY ABOVE
      #x2AAF	;PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
      #x2AB0	;SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
      #x2AB1	;PRECEDES ABOVE SINGLE-LINE NOT EQUAL TO
      #x2AB2	;SUCCEEDS ABOVE SINGLE-LINE NOT EQUAL TO
      #x2AB3	;PRECEDES ABOVE EQUALS SIGN
      #x2AB4	;SUCCEEDS ABOVE EQUALS SIGN
      #x2AB5	;PRECEDES ABOVE NOT EQUAL TO
      #x2AB6	;SUCCEEDS ABOVE NOT EQUAL TO
      #x2AB7	;PRECEDES ABOVE ALMOST EQUAL TO
      #x2AB8	;SUCCEEDS ABOVE ALMOST EQUAL TO
      #x2AB9	;PRECEDES ABOVE NOT ALMOST EQUAL TO
      #x2ABA	;SUCCEEDS ABOVE NOT ALMOST EQUAL TO
      #x2ABB	;DOUBLE PRECEDES
      #x2ABC	;DOUBLE SUCCEEDS
      #x2ABD	;SUBSET WITH DOT
      #x2ABE	;SUPERSET WITH DOT
      #x2ABF	;SUBSET WITH PLUS SIGN BELOW
      #x2AC0	;SUPERSET WITH PLUS SIGN BELOW
      #x2AC1	;SUBSET WITH MULTIPLICATION SIGN BELOW
      #x2AC2	;SUPERSET WITH MULTIPLICATION SIGN BELOW
      #x2AC3	;SUBSET OF OR EQUAL TO WITH DOT ABOVE
      #x2AC4	;SUPERSET OF OR EQUAL TO WITH DOT ABOVE
      #x2AC5	;SUBSET OF ABOVE EQUALS SIGN
      #x2AC6	;SUPERSET OF ABOVE EQUALS SIGN
      #x2AC7	;SUBSET OF ABOVE TILDE OPERATOR
      #x2AC8	;SUPERSET OF ABOVE TILDE OPERATOR
      #x2AC9	;SUBSET OF ABOVE ALMOST EQUAL TO
      #x2ACA	;SUPERSET OF ABOVE ALMOST EQUAL TO
      #x2ACB	;SUBSET OF ABOVE NOT EQUAL TO
      #x2ACC	;SUPERSET OF ABOVE NOT EQUAL TO
      #x2ACD	;SQUARE LEFT OPEN BOX OPERATOR
      #x2ACE	;SQUARE RIGHT OPEN BOX OPERATOR
      #x2ACF	;CLOSED SUBSET
      #x2AD0	;CLOSED SUPERSET
      #x2AD1	;CLOSED SUBSET OR EQUAL TO
      #x2AD2	;CLOSED SUPERSET OR EQUAL TO
      #x2AD3	;SUBSET ABOVE SUPERSET
      #x2AD4	;SUPERSET ABOVE SUBSET
      #x2AD5	;SUBSET ABOVE SUBSET
      #x2AD6	;SUPERSET ABOVE SUPERSET
      #x2AD7	;SUPERSET BESIDE SUBSET
      #x2AD8	;SUPERSET BESIDE AND JOINED BY DASH WITH SUBSET
      #x2AD9	;ELEMENT OF OPENING DOWNWARDS
      #x2ADA	;PITCHFORK WITH TEE TOP
      #x2ADB	;TRANSVERSAL INTERSECTION
      #x2ADC	;FORKING
      #x2ADD	;NONFORKING
      #x2ADE	;SHORT LEFT TACK
      #x2ADF	;SHORT DOWN TACK
      #x2AE0	;SHORT UP TACK
      #x2AE1	;PERPENDICULAR WITH S
      #x2AE2	;VERTICAL BAR TRIPLE RIGHT TURNSTILE
      #x2AE3	;DOUBLE VERTICAL BAR LEFT TURNSTILE
      #x2AE4	;VERTICAL BAR DOUBLE LEFT TURNSTILE
      #x2AE5	;DOUBLE VERTICAL BAR DOUBLE LEFT TURNSTILE
      #x2AE6	;LONG DASH FROM LEFT MEMBER OF DOUBLE VERTICAL
      #x2AE7	;SHORT DOWN TACK WITH OVERBAR
      #x2AE8	;SHORT UP TACK WITH UNDERBAR
      #x2AE9	;SHORT UP TACK ABOVE SHORT DOWN TACK
      #x2AEA	;DOUBLE DOWN TACK
      #x2AEB	;DOUBLE UP TACK
      #x2AEC	;DOUBLE STROKE NOT SIGN
      #x2AED	;REVERSED DOUBLE STROKE NOT SIGN
      #x2AEE	;DOES NOT DIVIDE WITH REVERSED NEGATION SLASH
      #x2AEF	;VERTICAL LINE WITH CIRCLE ABOVE
      #x2AF0	;VERTICAL LINE WITH CIRCLE BELOW
      #x2AF1	;DOWN TACK WITH CIRCLE BELOW
      #x2AF2	;PARALLEL WITH HORIZONTAL STROKE
      #x2AF3	;PARALLEL WITH TILDE OPERATOR
      #x2AF4	;TRIPLE VERTICAL BAR BINARY RELATION
      #x2AF5	;TRIPLE VERTICAL BAR WITH HORIZONTAL STROKE
      #x2AF6	;TRIPLE COLON OPERATOR
      #x2AF7	;TRIPLE NESTED LESS-THAN
      #x2AF8	;TRIPLE NESTED GREATER-THAN
      #x2AF9	;DOUBLE-LINE SLANTED LESS-THAN OR EQUAL TO
      #x2AFA	;DOUBLE-LINE SLANTED GREATER-THAN OR EQUAL TO
      #x2AFB	;TRIPLE SOLIDUS BINARY RELATION
      #x2AFC	;LARGE TRIPLE VERTICAL BAR OPERATOR
      #x2AFD	;DOUBLE SOLIDUS OPERATOR
      #x2AFE	;WHITE VERTICAL BAR
      #x2AFF	;N-ARY WHITE VERTICAL BAR
      #x2B00	;NORTH EAST WHITE ARROW
      #x2B01	;NORTH WEST WHITE ARROW
      #x2B02	;SOUTH EAST WHITE ARROW
      #x2B03	;SOUTH WEST WHITE ARROW
      #x2B04	;LEFT RIGHT WHITE ARROW
      #x2B05	;LEFTWARDS BLACK ARROW
      #x2B06	;UPWARDS BLACK ARROW
      #x2B07	;DOWNWARDS BLACK ARROW
      #x2B08	;NORTH EAST BLACK ARROW
      #x2B09	;NORTH WEST BLACK ARROW
      #x2B0A	;SOUTH EAST BLACK ARROW
      #x2B0B	;SOUTH WEST BLACK ARROW
      #x2B0C	;LEFT RIGHT BLACK ARROW
      #x2B0D	;UP DOWN BLACK ARROW
      #x2E80	;CJK RADICAL REPEAT
      #x2E81	;CJK RADICAL CLIFF
      #x2E82	;CJK RADICAL SECOND ONE
      #x2E83	;CJK RADICAL SECOND TWO
      #x2E84	;CJK RADICAL SECOND THREE
      #x2E85	;CJK RADICAL PERSON
      #x2E86	;CJK RADICAL BOX
      #x2E87	;CJK RADICAL TABLE
      #x2E88	;CJK RADICAL KNIFE ONE
      #x2E89	;CJK RADICAL KNIFE TWO
      #x2E8A	;CJK RADICAL DIVINATION
      #x2E8B	;CJK RADICAL SEAL
      #x2E8C	;CJK RADICAL SMALL ONE
      #x2E8D	;CJK RADICAL SMALL TWO
      #x2E8E	;CJK RADICAL LAME ONE
      #x2E8F	;CJK RADICAL LAME TWO
      #x2E90	;CJK RADICAL LAME THREE
      #x2E91	;CJK RADICAL LAME FOUR
      #x2E92	;CJK RADICAL SNAKE
      #x2E93	;CJK RADICAL THREAD
      #x2E94	;CJK RADICAL SNOUT ONE
      #x2E95	;CJK RADICAL SNOUT TWO
      #x2E96	;CJK RADICAL HEART ONE
      #x2E97	;CJK RADICAL HEART TWO
      #x2E98	;CJK RADICAL HAND
      #x2E99	;CJK RADICAL RAP
      #x2E9B	;CJK RADICAL CHOKE
      #x2E9C	;CJK RADICAL SUN
      #x2E9D	;CJK RADICAL MOON
      #x2E9E	;CJK RADICAL DEATH
      #x2E9F	;CJK RADICAL MOTHER
      #x2EA0	;CJK RADICAL CIVILIAN
      #x2EA1	;CJK RADICAL WATER ONE
      #x2EA2	;CJK RADICAL WATER TWO
      #x2EA3	;CJK RADICAL FIRE
      #x2EA4	;CJK RADICAL PAW ONE
      #x2EA5	;CJK RADICAL PAW TWO
      #x2EA6	;CJK RADICAL SIMPLIFIED HALF TREE TRUNK
      #x2EA7	;CJK RADICAL COW
      #x2EA8	;CJK RADICAL DOG
      #x2EA9	;CJK RADICAL JADE
      #x2EAA	;CJK RADICAL BOLT OF CLOTH
      #x2EAB	;CJK RADICAL EYE
      #x2EAC	;CJK RADICAL SPIRIT ONE
      #x2EAD	;CJK RADICAL SPIRIT TWO
      #x2EAE	;CJK RADICAL BAMBOO
      #x2EAF	;CJK RADICAL SILK
      #x2EB0	;CJK RADICAL C-SIMPLIFIED SILK
      #x2EB1	;CJK RADICAL NET ONE
      #x2EB2	;CJK RADICAL NET TWO
      #x2EB3	;CJK RADICAL NET THREE
      #x2EB4	;CJK RADICAL NET FOUR
      #x2EB5	;CJK RADICAL MESH
      #x2EB6	;CJK RADICAL SHEEP
      #x2EB7	;CJK RADICAL RAM
      #x2EB8	;CJK RADICAL EWE
      #x2EB9	;CJK RADICAL OLD
      #x2EBA	;CJK RADICAL BRUSH ONE
      #x2EBB	;CJK RADICAL BRUSH TWO
      #x2EBC	;CJK RADICAL MEAT
      #x2EBD	;CJK RADICAL MORTAR
      #x2EBE	;CJK RADICAL GRASS ONE
      #x2EBF	;CJK RADICAL GRASS TWO
      #x2EC0	;CJK RADICAL GRASS THREE
      #x2EC1	;CJK RADICAL TIGER
      #x2EC2	;CJK RADICAL CLOTHES
      #x2EC3	;CJK RADICAL WEST ONE
      #x2EC4	;CJK RADICAL WEST TWO
      #x2EC5	;CJK RADICAL C-SIMPLIFIED SEE
      #x2EC6	;CJK RADICAL SIMPLIFIED HORN
      #x2EC7	;CJK RADICAL HORN
      #x2EC8	;CJK RADICAL C-SIMPLIFIED SPEECH
      #x2EC9	;CJK RADICAL C-SIMPLIFIED SHELL
      #x2ECA	;CJK RADICAL FOOT
      #x2ECB	;CJK RADICAL C-SIMPLIFIED CART
      #x2ECC	;CJK RADICAL SIMPLIFIED WALK
      #x2ECD	;CJK RADICAL WALK ONE
      #x2ECE	;CJK RADICAL WALK TWO
      #x2ECF	;CJK RADICAL CITY
      #x2ED0	;CJK RADICAL C-SIMPLIFIED GOLD
      #x2ED1	;CJK RADICAL LONG ONE
      #x2ED2	;CJK RADICAL LONG TWO
      #x2ED3	;CJK RADICAL C-SIMPLIFIED LONG
      #x2ED4	;CJK RADICAL C-SIMPLIFIED GATE
      #x2ED5	;CJK RADICAL MOUND ONE
      #x2ED6	;CJK RADICAL MOUND TWO
      #x2ED7	;CJK RADICAL RAIN
      #x2ED8	;CJK RADICAL BLUE
      #x2ED9	;CJK RADICAL C-SIMPLIFIED TANNED LEATHER
      #x2EDA	;CJK RADICAL C-SIMPLIFIED LEAF
      #x2EDB	;CJK RADICAL C-SIMPLIFIED WIND
      #x2EDC	;CJK RADICAL C-SIMPLIFIED FLY
      #x2EDD	;CJK RADICAL EAT ONE
      #x2EDE	;CJK RADICAL EAT TWO
      #x2EDF	;CJK RADICAL EAT THREE
      #x2EE0	;CJK RADICAL C-SIMPLIFIED EAT
      #x2EE1	;CJK RADICAL HEAD
      #x2EE2	;CJK RADICAL C-SIMPLIFIED HORSE
      #x2EE3	;CJK RADICAL BONE
      #x2EE4	;CJK RADICAL GHOST
      #x2EE5	;CJK RADICAL C-SIMPLIFIED FISH
      #x2EE6	;CJK RADICAL C-SIMPLIFIED BIRD
      #x2EE7	;CJK RADICAL C-SIMPLIFIED SALT
      #x2EE8	;CJK RADICAL SIMPLIFIED WHEAT
      #x2EE9	;CJK RADICAL SIMPLIFIED YELLOW
      #x2EEA	;CJK RADICAL C-SIMPLIFIED FROG
      #x2EEB	;CJK RADICAL J-SIMPLIFIED EVEN
      #x2EEC	;CJK RADICAL C-SIMPLIFIED EVEN
      #x2EED	;CJK RADICAL J-SIMPLIFIED TOOTH
      #x2EEE	;CJK RADICAL C-SIMPLIFIED TOOTH
      #x2EEF	;CJK RADICAL J-SIMPLIFIED DRAGON
      #x2EF0	;CJK RADICAL C-SIMPLIFIED DRAGON
      #x2EF1	;CJK RADICAL TURTLE
      #x2EF2	;CJK RADICAL J-SIMPLIFIED TURTLE
      #x2EF3	;CJK RADICAL C-SIMPLIFIED TURTLE
      #x2F00	;KANGXI RADICAL ONE
      #x2F01	;KANGXI RADICAL LINE
      #x2F02	;KANGXI RADICAL DOT
      #x2F03	;KANGXI RADICAL SLASH
      #x2F04	;KANGXI RADICAL SECOND
      #x2F05	;KANGXI RADICAL HOOK
      #x2F06	;KANGXI RADICAL TWO
      #x2F07	;KANGXI RADICAL LID
      #x2F08	;KANGXI RADICAL MAN
      #x2F09	;KANGXI RADICAL LEGS
      #x2F0A	;KANGXI RADICAL ENTER
      #x2F0B	;KANGXI RADICAL EIGHT
      #x2F0C	;KANGXI RADICAL DOWN BOX
      #x2F0D	;KANGXI RADICAL COVER
      #x2F0E	;KANGXI RADICAL ICE
      #x2F0F	;KANGXI RADICAL TABLE
      #x2F10	;KANGXI RADICAL OPEN BOX
      #x2F11	;KANGXI RADICAL KNIFE
      #x2F12	;KANGXI RADICAL POWER
      #x2F13	;KANGXI RADICAL WRAP
      #x2F14	;KANGXI RADICAL SPOON
      #x2F15	;KANGXI RADICAL RIGHT OPEN BOX
      #x2F16	;KANGXI RADICAL HIDING ENCLOSURE
      #x2F17	;KANGXI RADICAL TEN
      #x2F18	;KANGXI RADICAL DIVINATION
      #x2F19	;KANGXI RADICAL SEAL
      #x2F1A	;KANGXI RADICAL CLIFF
      #x2F1B	;KANGXI RADICAL PRIVATE
      #x2F1C	;KANGXI RADICAL AGAIN
      #x2F1D	;KANGXI RADICAL MOUTH
      #x2F1E	;KANGXI RADICAL ENCLOSURE
      #x2F1F	;KANGXI RADICAL EARTH
      #x2F20	;KANGXI RADICAL SCHOLAR
      #x2F21	;KANGXI RADICAL GO
      #x2F22	;KANGXI RADICAL GO SLOWLY
      #x2F23	;KANGXI RADICAL EVENING
      #x2F24	;KANGXI RADICAL BIG
      #x2F25	;KANGXI RADICAL WOMAN
      #x2F26	;KANGXI RADICAL CHILD
      #x2F27	;KANGXI RADICAL ROOF
      #x2F28	;KANGXI RADICAL INCH
      #x2F29	;KANGXI RADICAL SMALL
      #x2F2A	;KANGXI RADICAL LAME
      #x2F2B	;KANGXI RADICAL CORPSE
      #x2F2C	;KANGXI RADICAL SPROUT
      #x2F2D	;KANGXI RADICAL MOUNTAIN
      #x2F2E	;KANGXI RADICAL RIVER
      #x2F2F	;KANGXI RADICAL WORK
      #x2F30	;KANGXI RADICAL ONESELF
      #x2F31	;KANGXI RADICAL TURBAN
      #x2F32	;KANGXI RADICAL DRY
      #x2F33	;KANGXI RADICAL SHORT THREAD
      #x2F34	;KANGXI RADICAL DOTTED CLIFF
      #x2F35	;KANGXI RADICAL LONG STRIDE
      #x2F36	;KANGXI RADICAL TWO HANDS
      #x2F37	;KANGXI RADICAL SHOOT
      #x2F38	;KANGXI RADICAL BOW
      #x2F39	;KANGXI RADICAL SNOUT
      #x2F3A	;KANGXI RADICAL BRISTLE
      #x2F3B	;KANGXI RADICAL STEP
      #x2F3C	;KANGXI RADICAL HEART
      #x2F3D	;KANGXI RADICAL HALBERD
      #x2F3E	;KANGXI RADICAL DOOR
      #x2F3F	;KANGXI RADICAL HAND
      #x2F40	;KANGXI RADICAL BRANCH
      #x2F41	;KANGXI RADICAL RAP
      #x2F42	;KANGXI RADICAL SCRIPT
      #x2F43	;KANGXI RADICAL DIPPER
      #x2F44	;KANGXI RADICAL AXE
      #x2F45	;KANGXI RADICAL SQUARE
      #x2F46	;KANGXI RADICAL NOT
      #x2F47	;KANGXI RADICAL SUN
      #x2F48	;KANGXI RADICAL SAY
      #x2F49	;KANGXI RADICAL MOON
      #x2F4A	;KANGXI RADICAL TREE
      #x2F4B	;KANGXI RADICAL LACK
      #x2F4C	;KANGXI RADICAL STOP
      #x2F4D	;KANGXI RADICAL DEATH
      #x2F4E	;KANGXI RADICAL WEAPON
      #x2F4F	;KANGXI RADICAL DO NOT
      #x2F50	;KANGXI RADICAL COMPARE
      #x2F51	;KANGXI RADICAL FUR
      #x2F52	;KANGXI RADICAL CLAN
      #x2F53	;KANGXI RADICAL STEAM
      #x2F54	;KANGXI RADICAL WATER
      #x2F55	;KANGXI RADICAL FIRE
      #x2F56	;KANGXI RADICAL CLAW
      #x2F57	;KANGXI RADICAL FATHER
      #x2F58	;KANGXI RADICAL DOUBLE X
      #x2F59	;KANGXI RADICAL HALF TREE TRUNK
      #x2F5A	;KANGXI RADICAL SLICE
      #x2F5B	;KANGXI RADICAL FANG
      #x2F5C	;KANGXI RADICAL COW
      #x2F5D	;KANGXI RADICAL DOG
      #x2F5E	;KANGXI RADICAL PROFOUND
      #x2F5F	;KANGXI RADICAL JADE
      #x2F60	;KANGXI RADICAL MELON
      #x2F61	;KANGXI RADICAL TILE
      #x2F62	;KANGXI RADICAL SWEET
      #x2F63	;KANGXI RADICAL LIFE
      #x2F64	;KANGXI RADICAL USE
      #x2F65	;KANGXI RADICAL FIELD
      #x2F66	;KANGXI RADICAL BOLT OF CLOTH
      #x2F67	;KANGXI RADICAL SICKNESS
      #x2F68	;KANGXI RADICAL DOTTED TENT
      #x2F69	;KANGXI RADICAL WHITE
      #x2F6A	;KANGXI RADICAL SKIN
      #x2F6B	;KANGXI RADICAL DISH
      #x2F6C	;KANGXI RADICAL EYE
      #x2F6D	;KANGXI RADICAL SPEAR
      #x2F6E	;KANGXI RADICAL ARROW
      #x2F6F	;KANGXI RADICAL STONE
      #x2F70	;KANGXI RADICAL SPIRIT
      #x2F71	;KANGXI RADICAL TRACK
      #x2F72	;KANGXI RADICAL GRAIN
      #x2F73	;KANGXI RADICAL CAVE
      #x2F74	;KANGXI RADICAL STAND
      #x2F75	;KANGXI RADICAL BAMBOO
      #x2F76	;KANGXI RADICAL RICE
      #x2F77	;KANGXI RADICAL SILK
      #x2F78	;KANGXI RADICAL JAR
      #x2F79	;KANGXI RADICAL NET
      #x2F7A	;KANGXI RADICAL SHEEP
      #x2F7B	;KANGXI RADICAL FEATHER
      #x2F7C	;KANGXI RADICAL OLD
      #x2F7D	;KANGXI RADICAL AND
      #x2F7E	;KANGXI RADICAL PLOW
      #x2F7F	;KANGXI RADICAL EAR
      #x2F80	;KANGXI RADICAL BRUSH
      #x2F81	;KANGXI RADICAL MEAT
      #x2F82	;KANGXI RADICAL MINISTER
      #x2F83	;KANGXI RADICAL SELF
      #x2F84	;KANGXI RADICAL ARRIVE
      #x2F85	;KANGXI RADICAL MORTAR
      #x2F86	;KANGXI RADICAL TONGUE
      #x2F87	;KANGXI RADICAL OPPOSE
      #x2F88	;KANGXI RADICAL BOAT
      #x2F89	;KANGXI RADICAL STOPPING
      #x2F8A	;KANGXI RADICAL COLOR
      #x2F8B	;KANGXI RADICAL GRASS
      #x2F8C	;KANGXI RADICAL TIGER
      #x2F8D	;KANGXI RADICAL INSECT
      #x2F8E	;KANGXI RADICAL BLOOD
      #x2F8F	;KANGXI RADICAL WALK ENCLOSURE
      #x2F90	;KANGXI RADICAL CLOTHES
      #x2F91	;KANGXI RADICAL WEST
      #x2F92	;KANGXI RADICAL SEE
      #x2F93	;KANGXI RADICAL HORN
      #x2F94	;KANGXI RADICAL SPEECH
      #x2F95	;KANGXI RADICAL VALLEY
      #x2F96	;KANGXI RADICAL BEAN
      #x2F97	;KANGXI RADICAL PIG
      #x2F98	;KANGXI RADICAL BADGER
      #x2F99	;KANGXI RADICAL SHELL
      #x2F9A	;KANGXI RADICAL RED
      #x2F9B	;KANGXI RADICAL RUN
      #x2F9C	;KANGXI RADICAL FOOT
      #x2F9D	;KANGXI RADICAL BODY
      #x2F9E	;KANGXI RADICAL CART
      #x2F9F	;KANGXI RADICAL BITTER
      #x2FA0	;KANGXI RADICAL MORNING
      #x2FA1	;KANGXI RADICAL WALK
      #x2FA2	;KANGXI RADICAL CITY
      #x2FA3	;KANGXI RADICAL WINE
      #x2FA4	;KANGXI RADICAL DISTINGUISH
      #x2FA5	;KANGXI RADICAL VILLAGE
      #x2FA6	;KANGXI RADICAL GOLD
      #x2FA7	;KANGXI RADICAL LONG
      #x2FA8	;KANGXI RADICAL GATE
      #x2FA9	;KANGXI RADICAL MOUND
      #x2FAA	;KANGXI RADICAL SLAVE
      #x2FAB	;KANGXI RADICAL SHORT TAILED BIRD
      #x2FAC	;KANGXI RADICAL RAIN
      #x2FAD	;KANGXI RADICAL BLUE
      #x2FAE	;KANGXI RADICAL WRONG
      #x2FAF	;KANGXI RADICAL FACE
      #x2FB0	;KANGXI RADICAL LEATHER
      #x2FB1	;KANGXI RADICAL TANNED LEATHER
      #x2FB2	;KANGXI RADICAL LEEK
      #x2FB3	;KANGXI RADICAL SOUND
      #x2FB4	;KANGXI RADICAL LEAF
      #x2FB5	;KANGXI RADICAL WIND
      #x2FB6	;KANGXI RADICAL FLY
      #x2FB7	;KANGXI RADICAL EAT
      #x2FB8	;KANGXI RADICAL HEAD
      #x2FB9	;KANGXI RADICAL FRAGRANT
      #x2FBA	;KANGXI RADICAL HORSE
      #x2FBB	;KANGXI RADICAL BONE
      #x2FBC	;KANGXI RADICAL TALL
      #x2FBD	;KANGXI RADICAL HAIR
      #x2FBE	;KANGXI RADICAL FIGHT
      #x2FBF	;KANGXI RADICAL SACRIFICIAL WINE
      #x2FC0	;KANGXI RADICAL CAULDRON
      #x2FC1	;KANGXI RADICAL GHOST
      #x2FC2	;KANGXI RADICAL FISH
      #x2FC3	;KANGXI RADICAL BIRD
      #x2FC4	;KANGXI RADICAL SALT
      #x2FC5	;KANGXI RADICAL DEER
      #x2FC6	;KANGXI RADICAL WHEAT
      #x2FC7	;KANGXI RADICAL HEMP
      #x2FC8	;KANGXI RADICAL YELLOW
      #x2FC9	;KANGXI RADICAL MILLET
      #x2FCA	;KANGXI RADICAL BLACK
      #x2FCB	;KANGXI RADICAL EMBROIDERY
      #x2FCC	;KANGXI RADICAL FROG
      #x2FCD	;KANGXI RADICAL TRIPOD
      #x2FCE	;KANGXI RADICAL DRUM
      #x2FCF	;KANGXI RADICAL RAT
      #x2FD0	;KANGXI RADICAL NOSE
      #x2FD1	;KANGXI RADICAL EVEN
      #x2FD2	;KANGXI RADICAL TOOTH
      #x2FD3	;KANGXI RADICAL DRAGON
      #x2FD4	;KANGXI RADICAL TURTLE
      #x2FD5	;KANGXI RADICAL FLUTE
      #x2FF0	;IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO RIGHT
      #x2FF1	;IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO BELOW
      #x2FF2	;IDEOGRAPHIC DESCRIPTION CHARACTER LEFT TO MIDDLE AND RIGHT
      #x2FF3	;IDEOGRAPHIC DESCRIPTION CHARACTER ABOVE TO MIDDLE AND BELOW
      #x2FF4	;IDEOGRAPHIC DESCRIPTION CHARACTER FULL SURROUND
      #x2FF5	;IDEOGRAPHIC DESCRIPTION CHARACTER SURROUND FROM ABOVE
      #x2FF6	;IDEOGRAPHIC DESCRIPTION 