/************************************************************************
 *
 * Copyright (C) 2023 IRCAD France
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

// This file was automatically generated by the '/libs/core/data/dicom/class_generator.py' script. DO NOT EDIT !
// Used arguments: 'Namespace(verbose=False, source_url='http://dicom.nema.org/medical/dicom/current/source/docbook',
// sop_list=None, mandatory_tags=[Tag(group='7FE0', element='0010'), Tag(group='0062', element='0002'),
// Tag(group='0066', element='0002'), Tag(group='0066', element='0011'), Tag(group='0070', element='031C')])'

#include "attribute_test.hpp"

#include <data/dicom/attribute.hpp>

CPPUNIT_TEST_SUITE_REGISTRATION(sight::data::dicom::ut::attribute_test);

// cspell: ignore Wundefined afterloader angio autorefraction autosequence boli bscan cadsr ciexy ctdi ctdivol decf
// cspell: ignore deidentification dermoscopic diconde dicos dvhroi exif fiducials fluence fnumber frameof gpsdop hicpp
// cspell: ignore hpgl imager inms inua inus iods isop ivol ivus keratoconus keratometer keratometric kerma lensometry
// cspell: ignore lookat meterset metersets mrfov multiway nmpet nmtomo nolintbegin nolintend octb octz oecf olink
// cspell: ignore postamble powerline prcs presaturation radiofluoroscopic relaxivity reprojection rgblut rtdvh rtroi
// cspell: ignore sddn sdhn sdvn softcopy soundpath stereometric stowrs tlhc tomo tomosynthesis tomotherapeutic toric
// cspell: ignore tractography xaxrf Ascan Framek

// NOLINTBEGIN

namespace sight::data::dicom::ut
{

//------------------------------------------------------------------------------

void attribute_test::setUp()
{
}

//------------------------------------------------------------------------------

void attribute_test::tearDown()
{
}

//------------------------------------------------------------------------------

void attribute_test::attributeTest()
{
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecificCharacterSet>::s_keyword,
        attribute::get(0x0008, 0x0005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecificCharacterSet>::s_keyword,
        attribute::get(attribute::Keyword::SpecificCharacterSet).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LanguageCodeSequence>::s_keyword,
        attribute::get(0x0008, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LanguageCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::LanguageCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageType>::s_keyword,
        attribute::get(0x0008, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageType>::s_keyword,
        attribute::get(attribute::Keyword::ImageType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceCreationDate>::s_keyword,
        attribute::get(0x0008, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceCreationDate>::s_keyword,
        attribute::get(attribute::Keyword::InstanceCreationDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceCreationTime>::s_keyword,
        attribute::get(0x0008, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceCreationTime>::s_keyword,
        attribute::get(attribute::Keyword::InstanceCreationTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceCreatorUID>::s_keyword,
        attribute::get(0x0008, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceCreatorUID>::s_keyword,
        attribute::get(attribute::Keyword::InstanceCreatorUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceCoercionDateTime>::s_keyword,
        attribute::get(0x0008, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceCoercionDateTime>::s_keyword,
        attribute::get(attribute::Keyword::InstanceCoercionDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::sop_classUID>::s_keyword,
        attribute::get(0x0008, 0x0016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::sop_classUID>::s_keyword,
        attribute::get(attribute::Keyword::sop_classUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionUID>::s_keyword,
        attribute::get(0x0008, 0x0017).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionUID>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SOPInstanceUID>::s_keyword,
        attribute::get(0x0008, 0x0018).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SOPInstanceUID>::s_keyword,
        attribute::get(attribute::Keyword::SOPInstanceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PyramidUID>::s_keyword,
        attribute::get(0x0008, 0x0019).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PyramidUID>::s_keyword,
        attribute::get(attribute::Keyword::PyramidUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelatedGeneralsop_classUID>::s_keyword,
        attribute::get(0x0008, 0x001A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelatedGeneralsop_classUID>::s_keyword,
        attribute::get(attribute::Keyword::RelatedGeneralsop_classUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OriginalSpecializedsop_classUID>::s_keyword,
        attribute::get(0x0008, 0x001B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OriginalSpecializedsop_classUID>::s_keyword,
        attribute::get(attribute::Keyword::OriginalSpecializedsop_classUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudyDate>::s_keyword,
        attribute::get(0x0008, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudyDate>::s_keyword,
        attribute::get(attribute::Keyword::StudyDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesDate>::s_keyword,
        attribute::get(0x0008, 0x0021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesDate>::s_keyword,
        attribute::get(attribute::Keyword::SeriesDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDate>::s_keyword,
        attribute::get(0x0008, 0x0022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDate>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentDate>::s_keyword,
        attribute::get(0x0008, 0x0023).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentDate>::s_keyword,
        attribute::get(attribute::Keyword::ContentDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDateTime>::s_keyword,
        attribute::get(0x0008, 0x002A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDateTime>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudyTime>::s_keyword,
        attribute::get(0x0008, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudyTime>::s_keyword,
        attribute::get(attribute::Keyword::StudyTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesTime>::s_keyword,
        attribute::get(0x0008, 0x0031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesTime>::s_keyword,
        attribute::get(attribute::Keyword::SeriesTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionTime>::s_keyword,
        attribute::get(0x0008, 0x0032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionTime>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentTime>::s_keyword,
        attribute::get(0x0008, 0x0033).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentTime>::s_keyword,
        attribute::get(attribute::Keyword::ContentTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AccessionNumber>::s_keyword,
        attribute::get(0x0008, 0x0050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AccessionNumber>::s_keyword,
        attribute::get(attribute::Keyword::AccessionNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfAccessionNumberSequence>::s_keyword,
        attribute::get(0x0008, 0x0051).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfAccessionNumberSequence>::s_keyword,
        attribute::get(attribute::Keyword::IssuerOfAccessionNumberSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QueryRetrieveView>::s_keyword,
        attribute::get(0x0008, 0x0053).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QueryRetrieveView>::s_keyword,
        attribute::get(attribute::Keyword::QueryRetrieveView).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RetrieveAETitle>::s_keyword,
        attribute::get(0x0008, 0x0054).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RetrieveAETitle>::s_keyword,
        attribute::get(attribute::Keyword::RetrieveAETitle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StationAETitle>::s_keyword,
        attribute::get(0x0008, 0x0055).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StationAETitle>::s_keyword,
        attribute::get(attribute::Keyword::StationAETitle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Modality>::s_keyword,
        attribute::get(0x0008, 0x0060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Modality>::s_keyword,
        attribute::get(attribute::Keyword::Modality).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConversionType>::s_keyword,
        attribute::get(0x0008, 0x0064).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConversionType>::s_keyword,
        attribute::get(attribute::Keyword::ConversionType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PresentationIntentType>::s_keyword,
        attribute::get(0x0008, 0x0068).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PresentationIntentType>::s_keyword,
        attribute::get(attribute::Keyword::PresentationIntentType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Manufacturer>::s_keyword,
        attribute::get(0x0008, 0x0070).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Manufacturer>::s_keyword,
        attribute::get(attribute::Keyword::Manufacturer).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstitutionName>::s_keyword,
        attribute::get(0x0008, 0x0080).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstitutionName>::s_keyword,
        attribute::get(attribute::Keyword::InstitutionName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstitutionAddress>::s_keyword,
        attribute::get(0x0008, 0x0081).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstitutionAddress>::s_keyword,
        attribute::get(attribute::Keyword::InstitutionAddress).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstitutionCodeSequence>::s_keyword,
        attribute::get(0x0008, 0x0082).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstitutionCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::InstitutionCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferringPhysicianName>::s_keyword,
        attribute::get(0x0008, 0x0090).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferringPhysicianName>::s_keyword,
        attribute::get(attribute::Keyword::ReferringPhysicianName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferringPhysicianIdentificationSequence>::s_keyword,
        attribute::get(0x0008, 0x0096).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferringPhysicianIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferringPhysicianIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConsultingPhysicianName>::s_keyword,
        attribute::get(0x0008, 0x009C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConsultingPhysicianName>::s_keyword,
        attribute::get(attribute::Keyword::ConsultingPhysicianName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConsultingPhysicianIdentificationSequence>::s_keyword,
        attribute::get(0x0008, 0x009D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConsultingPhysicianIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::ConsultingPhysicianIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodeValue>::s_keyword,
        attribute::get(0x0008, 0x0100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodeValue>::s_keyword,
        attribute::get(attribute::Keyword::CodeValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeDesignator>::s_keyword,
        attribute::get(0x0008, 0x0102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeDesignator>::s_keyword,
        attribute::get(attribute::Keyword::CodingSchemeDesignator).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeVersion>::s_keyword,
        attribute::get(0x0008, 0x0103).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeVersion>::s_keyword,
        attribute::get(attribute::Keyword::CodingSchemeVersion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodeMeaning>::s_keyword,
        attribute::get(0x0008, 0x0104).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodeMeaning>::s_keyword,
        attribute::get(attribute::Keyword::CodeMeaning).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MappingResource>::s_keyword,
        attribute::get(0x0008, 0x0105).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MappingResource>::s_keyword,
        attribute::get(attribute::Keyword::MappingResource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextGroupVersion>::s_keyword,
        attribute::get(0x0008, 0x0106).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextGroupVersion>::s_keyword,
        attribute::get(attribute::Keyword::ContextGroupVersion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextGroupLocalVersion>::s_keyword,
        attribute::get(0x0008, 0x0107).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextGroupLocalVersion>::s_keyword,
        attribute::get(attribute::Keyword::ContextGroupLocalVersion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeResourcesSequence>::s_keyword,
        attribute::get(0x0008, 0x0109).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeResourcesSequence>::s_keyword,
        attribute::get(attribute::Keyword::CodingSchemeResourcesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextGroupExtensionFlag>::s_keyword,
        attribute::get(0x0008, 0x010B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextGroupExtensionFlag>::s_keyword,
        attribute::get(attribute::Keyword::ContextGroupExtensionFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeUID>::s_keyword,
        attribute::get(0x0008, 0x010C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeUID>::s_keyword,
        attribute::get(attribute::Keyword::CodingSchemeUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextGroupExtensionCreatorUID>::s_keyword,
        attribute::get(0x0008, 0x010D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextGroupExtensionCreatorUID>::s_keyword,
        attribute::get(attribute::Keyword::ContextGroupExtensionCreatorUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextIdentifier>::s_keyword,
        attribute::get(0x0008, 0x010F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::ContextIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeIdentificationSequence>::s_keyword,
        attribute::get(0x0008, 0x0110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::CodingSchemeIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeRegistry>::s_keyword,
        attribute::get(0x0008, 0x0112).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeRegistry>::s_keyword,
        attribute::get(attribute::Keyword::CodingSchemeRegistry).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeExternalID>::s_keyword,
        attribute::get(0x0008, 0x0114).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeExternalID>::s_keyword,
        attribute::get(attribute::Keyword::CodingSchemeExternalID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeName>::s_keyword,
        attribute::get(0x0008, 0x0115).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeName>::s_keyword,
        attribute::get(attribute::Keyword::CodingSchemeName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeResponsibleOrganization>::s_keyword,
        attribute::get(0x0008, 0x0116).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CodingSchemeResponsibleOrganization>::s_keyword,
        attribute::get(attribute::Keyword::CodingSchemeResponsibleOrganization).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextUID>::s_keyword,
        attribute::get(0x0008, 0x0117).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextUID>::s_keyword,
        attribute::get(attribute::Keyword::ContextUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MappingResourceUID>::s_keyword,
        attribute::get(0x0008, 0x0118).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MappingResourceUID>::s_keyword,
        attribute::get(attribute::Keyword::MappingResourceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LongCodeValue>::s_keyword,
        attribute::get(0x0008, 0x0119).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LongCodeValue>::s_keyword,
        attribute::get(attribute::Keyword::LongCodeValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::URNCodeValue>::s_keyword,
        attribute::get(0x0008, 0x0120).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::URNCodeValue>::s_keyword,
        attribute::get(attribute::Keyword::URNCodeValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EquivalentCodeSequence>::s_keyword,
        attribute::get(0x0008, 0x0121).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EquivalentCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::EquivalentCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MappingResourceName>::s_keyword,
        attribute::get(0x0008, 0x0122).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MappingResourceName>::s_keyword,
        attribute::get(attribute::Keyword::MappingResourceName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextGroupIdentificationSequence>::s_keyword,
        attribute::get(0x0008, 0x0123).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContextGroupIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContextGroupIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MappingResourceIdentificationSequence>::s_keyword,
        attribute::get(0x0008, 0x0124).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MappingResourceIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::MappingResourceIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimezoneOffsetFromUTC>::s_keyword,
        attribute::get(0x0008, 0x0201).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimezoneOffsetFromUTC>::s_keyword,
        attribute::get(attribute::Keyword::TimezoneOffsetFromUTC).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ResponsibleGroupCodeSequence>::s_keyword,
        attribute::get(0x0008, 0x0220).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ResponsibleGroupCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ResponsibleGroupCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrivateDataElementCharacteristicsSequence>::s_keyword,
        attribute::get(0x0008, 0x0300).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrivateDataElementCharacteristicsSequence>::s_keyword,
        attribute::get(attribute::Keyword::PrivateDataElementCharacteristicsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrivateGroupReference>::s_keyword,
        attribute::get(0x0008, 0x0301).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrivateGroupReference>::s_keyword,
        attribute::get(attribute::Keyword::PrivateGroupReference).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrivateCreatorReference>::s_keyword,
        attribute::get(0x0008, 0x0302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrivateCreatorReference>::s_keyword,
        attribute::get(attribute::Keyword::PrivateCreatorReference).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlockIdentifyingInformationStatus>::s_keyword,
        attribute::get(0x0008, 0x0303).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlockIdentifyingInformationStatus>::s_keyword,
        attribute::get(attribute::Keyword::BlockIdentifyingInformationStatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NonidentifyingPrivateElements>::s_keyword,
        attribute::get(0x0008, 0x0304).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NonidentifyingPrivateElements>::s_keyword,
        attribute::get(attribute::Keyword::NonidentifyingPrivateElements).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeidentificationActionSequence>::s_keyword,
        attribute::get(0x0008, 0x0305).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeidentificationActionSequence>::s_keyword,
        attribute::get(attribute::Keyword::DeidentificationActionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrivateDataElementDefinitionSequence>::s_keyword,
        attribute::get(0x0008, 0x0310).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrivateDataElementDefinitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::PrivateDataElementDefinitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StationName>::s_keyword,
        attribute::get(0x0008, 0x1010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StationName>::s_keyword,
        attribute::get(attribute::Keyword::StationName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudyDescription>::s_keyword,
        attribute::get(0x0008, 0x1030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudyDescription>::s_keyword,
        attribute::get(attribute::Keyword::StudyDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProcedureCodeSequence>::s_keyword,
        attribute::get(0x0008, 0x1032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProcedureCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ProcedureCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesDescription>::s_keyword,
        attribute::get(0x0008, 0x103E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesDescription>::s_keyword,
        attribute::get(attribute::Keyword::SeriesDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesDescriptionCodeSequence>::s_keyword,
        attribute::get(0x0008, 0x103F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesDescriptionCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::SeriesDescriptionCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstitutionalDepartmentName>::s_keyword,
        attribute::get(0x0008, 0x1040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstitutionalDepartmentName>::s_keyword,
        attribute::get(attribute::Keyword::InstitutionalDepartmentName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstitutionalDepartmentTypeCodeSequence>::s_keyword,
        attribute::get(0x0008, 0x1041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstitutionalDepartmentTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::InstitutionalDepartmentTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysiciansOfRecord>::s_keyword,
        attribute::get(0x0008, 0x1048).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysiciansOfRecord>::s_keyword,
        attribute::get(attribute::Keyword::PhysiciansOfRecord).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysiciansOfRecordIdentificationSequence>::s_keyword,
        attribute::get(0x0008, 0x1049).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysiciansOfRecordIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::PhysiciansOfRecordIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformingPhysicianName>::s_keyword,
        attribute::get(0x0008, 0x1050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformingPhysicianName>::s_keyword,
        attribute::get(attribute::Keyword::PerformingPhysicianName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformingPhysicianIdentificationSequence>::s_keyword,
        attribute::get(0x0008, 0x1052).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformingPhysicianIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::PerformingPhysicianIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NameOfPhysiciansReadingStudy>::s_keyword,
        attribute::get(0x0008, 0x1060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NameOfPhysiciansReadingStudy>::s_keyword,
        attribute::get(attribute::Keyword::NameOfPhysiciansReadingStudy).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysiciansReadingStudyIdentificationSequence>::s_keyword,
        attribute::get(0x0008, 0x1062).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysiciansReadingStudyIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::PhysiciansReadingStudyIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OperatorsName>::s_keyword,
        attribute::get(0x0008, 0x1070).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OperatorsName>::s_keyword,
        attribute::get(attribute::Keyword::OperatorsName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OperatorIdentificationSequence>::s_keyword,
        attribute::get(0x0008, 0x1072).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OperatorIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::OperatorIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdmittingDiagnosesDescription>::s_keyword,
        attribute::get(0x0008, 0x1080).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdmittingDiagnosesDescription>::s_keyword,
        attribute::get(attribute::Keyword::AdmittingDiagnosesDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdmittingDiagnosesCodeSequence>::s_keyword,
        attribute::get(0x0008, 0x1084).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdmittingDiagnosesCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::AdmittingDiagnosesCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PyramidDescription>::s_keyword,
        attribute::get(0x0008, 0x1088).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PyramidDescription>::s_keyword,
        attribute::get(attribute::Keyword::PyramidDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ManufacturerModelName>::s_keyword,
        attribute::get(0x0008, 0x1090).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ManufacturerModelName>::s_keyword,
        attribute::get(attribute::Keyword::ManufacturerModelName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedStudySequence>::s_keyword,
        attribute::get(0x0008, 0x1110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedStudySequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedStudySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPerformedProcedureStepSequence>::s_keyword,
        attribute::get(0x0008, 0x1111).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPerformedProcedureStepSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedPerformedProcedureStepSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSeriesSequence>::s_keyword,
        attribute::get(0x0008, 0x1115).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSeriesSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSeriesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPatientSequence>::s_keyword,
        attribute::get(0x0008, 0x1120).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPatientSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedPatientSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedStereometricInstanceSequence>::s_keyword,
        attribute::get(0x0008, 0x1134).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedStereometricInstanceSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedStereometricInstanceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedWaveformSequence>::s_keyword,
        attribute::get(0x0008, 0x113A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedWaveformSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedWaveformSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedImageSequence>::s_keyword,
        attribute::get(0x0008, 0x1140).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedImageSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedImageSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedInstanceSequence>::s_keyword,
        attribute::get(0x0008, 0x114A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedInstanceSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedInstanceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedRealWorldValueMappingInstanceSequence>::s_keyword,
        attribute::get(0x0008, 0x114B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedRealWorldValueMappingInstanceSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedRealWorldValueMappingInstanceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSOPClassUID>::s_keyword,
        attribute::get(0x0008, 0x1150).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSOPClassUID>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSOPClassUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSOPInstanceUID>::s_keyword,
        attribute::get(0x0008, 0x1155).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSOPInstanceUID>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSOPInstanceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DefinitionSourceSequence>::s_keyword,
        attribute::get(0x0008, 0x1156).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DefinitionSourceSequence>::s_keyword,
        attribute::get(attribute::Keyword::DefinitionSourceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedFrameNumber>::s_keyword,
        attribute::get(0x0008, 0x1160).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedFrameNumber>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedFrameNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SimpleFrameList>::s_keyword,
        attribute::get(0x0008, 0x1161).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SimpleFrameList>::s_keyword,
        attribute::get(attribute::Keyword::SimpleFrameList).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalculatedFrameList>::s_keyword,
        attribute::get(0x0008, 0x1162).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalculatedFrameList>::s_keyword,
        attribute::get(attribute::Keyword::CalculatedFrameList).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeRange>::s_keyword,
        attribute::get(0x0008, 0x1163).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeRange>::s_keyword,
        attribute::get(attribute::Keyword::TimeRange).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameExtractionSequence>::s_keyword,
        attribute::get(0x0008, 0x1164).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameExtractionSequence>::s_keyword,
        attribute::get(attribute::Keyword::FrameExtractionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultiFrameSourceSOPInstanceUID>::s_keyword,
        attribute::get(0x0008, 0x1167).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultiFrameSourceSOPInstanceUID>::s_keyword,
        attribute::get(attribute::Keyword::MultiFrameSourceSOPInstanceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RetrieveURL>::s_keyword,
        attribute::get(0x0008, 0x1190).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RetrieveURL>::s_keyword,
        attribute::get(attribute::Keyword::RetrieveURL).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSOPSequence>::s_keyword,
        attribute::get(0x0008, 0x1199).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSOPSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSOPSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudiesContainingOtherReferencedInstancesSequence>::s_keyword,
        attribute::get(0x0008, 0x1200).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudiesContainingOtherReferencedInstancesSequence>::s_keyword,
        attribute::get(attribute::Keyword::StudiesContainingOtherReferencedInstancesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelatedSeriesSequence>::s_keyword,
        attribute::get(0x0008, 0x1250).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelatedSeriesSequence>::s_keyword,
        attribute::get(attribute::Keyword::RelatedSeriesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DerivationDescription>::s_keyword,
        attribute::get(0x0008, 0x2111).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DerivationDescription>::s_keyword,
        attribute::get(attribute::Keyword::DerivationDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceImageSequence>::s_keyword,
        attribute::get(0x0008, 0x2112).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceImageSequence>::s_keyword,
        attribute::get(attribute::Keyword::SourceImageSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StageName>::s_keyword,
        attribute::get(0x0008, 0x2120).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StageName>::s_keyword,
        attribute::get(attribute::Keyword::StageName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StageNumber>::s_keyword,
        attribute::get(0x0008, 0x2122).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StageNumber>::s_keyword,
        attribute::get(attribute::Keyword::StageNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfStages>::s_keyword,
        attribute::get(0x0008, 0x2124).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfStages>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfStages).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewName>::s_keyword,
        attribute::get(0x0008, 0x2127).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewName>::s_keyword,
        attribute::get(attribute::Keyword::ViewName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewNumber>::s_keyword,
        attribute::get(0x0008, 0x2128).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewNumber>::s_keyword,
        attribute::get(attribute::Keyword::ViewNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfEventTimers>::s_keyword,
        attribute::get(0x0008, 0x2129).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfEventTimers>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfEventTimers).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfViewsInStage>::s_keyword,
        attribute::get(0x0008, 0x212A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfViewsInStage>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfViewsInStage).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EventElapsedTimes>::s_keyword,
        attribute::get(0x0008, 0x2130).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EventElapsedTimes>::s_keyword,
        attribute::get(attribute::Keyword::EventElapsedTimes).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EventTimerNames>::s_keyword,
        attribute::get(0x0008, 0x2132).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EventTimerNames>::s_keyword,
        attribute::get(attribute::Keyword::EventTimerNames).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EventTimerSequence>::s_keyword,
        attribute::get(0x0008, 0x2133).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EventTimerSequence>::s_keyword,
        attribute::get(attribute::Keyword::EventTimerSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EventTimeOffset>::s_keyword,
        attribute::get(0x0008, 0x2134).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EventTimeOffset>::s_keyword,
        attribute::get(attribute::Keyword::EventTimeOffset).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EventCodeSequence>::s_keyword,
        attribute::get(0x0008, 0x2135).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EventCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::EventCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartTrim>::s_keyword,
        attribute::get(0x0008, 0x2142).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartTrim>::s_keyword,
        attribute::get(attribute::Keyword::StartTrim).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StopTrim>::s_keyword,
        attribute::get(0x0008, 0x2143).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StopTrim>::s_keyword,
        attribute::get(attribute::Keyword::StopTrim).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedDisplayFrameRate>::s_keyword,
        attribute::get(0x0008, 0x2144).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedDisplayFrameRate>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedDisplayFrameRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnatomicRegionSequence>::s_keyword,
        attribute::get(0x0008, 0x2218).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnatomicRegionSequence>::s_keyword,
        attribute::get(attribute::Keyword::AnatomicRegionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnatomicRegionModifierSequence>::s_keyword,
        attribute::get(0x0008, 0x2220).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnatomicRegionModifierSequence>::s_keyword,
        attribute::get(attribute::Keyword::AnatomicRegionModifierSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryAnatomicStructureSequence>::s_keyword,
        attribute::get(0x0008, 0x2228).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryAnatomicStructureSequence>::s_keyword,
        attribute::get(attribute::Keyword::PrimaryAnatomicStructureSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryAnatomicStructureModifierSequence>::s_keyword,
        attribute::get(0x0008, 0x2230).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryAnatomicStructureModifierSequence>::s_keyword,
        attribute::get(attribute::Keyword::PrimaryAnatomicStructureModifierSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IrradiationEventUID>::s_keyword,
        attribute::get(0x0008, 0x3010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IrradiationEventUID>::s_keyword,
        attribute::get(attribute::Keyword::IrradiationEventUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceIrradiationEventSequence>::s_keyword,
        attribute::get(0x0008, 0x3011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceIrradiationEventSequence>::s_keyword,
        attribute::get(attribute::Keyword::SourceIrradiationEventSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalAdministrationEventUID>::s_keyword,
        attribute::get(0x0008, 0x3012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalAdministrationEventUID>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalAdministrationEventUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameType>::s_keyword,
        attribute::get(0x0008, 0x9007).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameType>::s_keyword,
        attribute::get(attribute::Keyword::FrameType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedImageEvidenceSequence>::s_keyword,
        attribute::get(0x0008, 0x9092).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedImageEvidenceSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedImageEvidenceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedRawDataSequence>::s_keyword,
        attribute::get(0x0008, 0x9121).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedRawDataSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedRawDataSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DerivationImageSequence>::s_keyword,
        attribute::get(0x0008, 0x9124).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DerivationImageSequence>::s_keyword,
        attribute::get(attribute::Keyword::DerivationImageSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceImageEvidenceSequence>::s_keyword,
        attribute::get(0x0008, 0x9154).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceImageEvidenceSequence>::s_keyword,
        attribute::get(attribute::Keyword::SourceImageEvidenceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelPresentation>::s_keyword,
        attribute::get(0x0008, 0x9205).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelPresentation>::s_keyword,
        attribute::get(attribute::Keyword::PixelPresentation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumetricProperties>::s_keyword,
        attribute::get(0x0008, 0x9206).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumetricProperties>::s_keyword,
        attribute::get(attribute::Keyword::VolumetricProperties).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumeBasedCalculationTechnique>::s_keyword,
        attribute::get(0x0008, 0x9207).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumeBasedCalculationTechnique>::s_keyword,
        attribute::get(attribute::Keyword::VolumeBasedCalculationTechnique).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ComplexImageComponent>::s_keyword,
        attribute::get(0x0008, 0x9208).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ComplexImageComponent>::s_keyword,
        attribute::get(attribute::Keyword::ComplexImageComponent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionContrast>::s_keyword,
        attribute::get(0x0008, 0x9209).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionContrast>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionContrast).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DerivationCodeSequence>::s_keyword,
        attribute::get(0x0008, 0x9215).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DerivationCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::DerivationCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPresentationStateSequence>::s_keyword,
        attribute::get(0x0008, 0x9237).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPresentationStateSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedPresentationStateSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedOtherPlaneSequence>::s_keyword,
        attribute::get(0x0008, 0x9410).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedOtherPlaneSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedOtherPlaneSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameDisplaySequence>::s_keyword,
        attribute::get(0x0008, 0x9458).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameDisplaySequence>::s_keyword,
        attribute::get(attribute::Keyword::FrameDisplaySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedDisplayFrameRateInFloat>::s_keyword,
        attribute::get(0x0008, 0x9459).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedDisplayFrameRateInFloat>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedDisplayFrameRateInFloat).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SkipFrameRangeFlag>::s_keyword,
        attribute::get(0x0008, 0x9460).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SkipFrameRangeFlag>::s_keyword,
        attribute::get(attribute::Keyword::SkipFrameRangeFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientName>::s_keyword,
        attribute::get(0x0010, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientName>::s_keyword,
        attribute::get(attribute::Keyword::PatientName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientID>::s_keyword,
        attribute::get(0x0010, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientID>::s_keyword,
        attribute::get(attribute::Keyword::PatientID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfPatientID>::s_keyword,
        attribute::get(0x0010, 0x0021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfPatientID>::s_keyword,
        attribute::get(attribute::Keyword::IssuerOfPatientID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TypeOfPatientID>::s_keyword,
        attribute::get(0x0010, 0x0022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TypeOfPatientID>::s_keyword,
        attribute::get(attribute::Keyword::TypeOfPatientID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfPatientIDQualifiersSequence>::s_keyword,
        attribute::get(0x0010, 0x0024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfPatientIDQualifiersSequence>::s_keyword,
        attribute::get(attribute::Keyword::IssuerOfPatientIDQualifiersSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourcePatientGroupIdentificationSequence>::s_keyword,
        attribute::get(0x0010, 0x0026).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourcePatientGroupIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::SourcePatientGroupIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GroupOfPatientsIdentificationSequence>::s_keyword,
        attribute::get(0x0010, 0x0027).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GroupOfPatientsIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::GroupOfPatientsIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubjectRelativePositionInImage>::s_keyword,
        attribute::get(0x0010, 0x0028).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubjectRelativePositionInImage>::s_keyword,
        attribute::get(attribute::Keyword::SubjectRelativePositionInImage).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBirthDate>::s_keyword,
        attribute::get(0x0010, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBirthDate>::s_keyword,
        attribute::get(attribute::Keyword::PatientBirthDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBirthTime>::s_keyword,
        attribute::get(0x0010, 0x0032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBirthTime>::s_keyword,
        attribute::get(attribute::Keyword::PatientBirthTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBirthDateInAlternativeCalendar>::s_keyword,
        attribute::get(0x0010, 0x0033).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBirthDateInAlternativeCalendar>::s_keyword,
        attribute::get(attribute::Keyword::PatientBirthDateInAlternativeCalendar).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientDeathDateInAlternativeCalendar>::s_keyword,
        attribute::get(0x0010, 0x0034).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientDeathDateInAlternativeCalendar>::s_keyword,
        attribute::get(attribute::Keyword::PatientDeathDateInAlternativeCalendar).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientAlternativeCalendar>::s_keyword,
        attribute::get(0x0010, 0x0035).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientAlternativeCalendar>::s_keyword,
        attribute::get(attribute::Keyword::PatientAlternativeCalendar).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSex>::s_keyword,
        attribute::get(0x0010, 0x0040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSex>::s_keyword,
        attribute::get(attribute::Keyword::PatientSex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QualityControlSubject>::s_keyword,
        attribute::get(0x0010, 0x0200).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QualityControlSubject>::s_keyword,
        attribute::get(attribute::Keyword::QualityControlSubject).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainDescription>::s_keyword,
        attribute::get(0x0010, 0x0212).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainDescription>::s_keyword,
        attribute::get(attribute::Keyword::StrainDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainNomenclature>::s_keyword,
        attribute::get(0x0010, 0x0213).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainNomenclature>::s_keyword,
        attribute::get(attribute::Keyword::StrainNomenclature).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainStockNumber>::s_keyword,
        attribute::get(0x0010, 0x0214).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainStockNumber>::s_keyword,
        attribute::get(attribute::Keyword::StrainStockNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainSourceRegistryCodeSequence>::s_keyword,
        attribute::get(0x0010, 0x0215).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainSourceRegistryCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::StrainSourceRegistryCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainStockSequence>::s_keyword,
        attribute::get(0x0010, 0x0216).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainStockSequence>::s_keyword,
        attribute::get(attribute::Keyword::StrainStockSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainSource>::s_keyword,
        attribute::get(0x0010, 0x0217).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainSource>::s_keyword,
        attribute::get(attribute::Keyword::StrainSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainAdditionalInformation>::s_keyword,
        attribute::get(0x0010, 0x0218).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainAdditionalInformation>::s_keyword,
        attribute::get(attribute::Keyword::StrainAdditionalInformation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainCodeSequence>::s_keyword,
        attribute::get(0x0010, 0x0219).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StrainCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::StrainCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneticModificationsSequence>::s_keyword,
        attribute::get(0x0010, 0x0221).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneticModificationsSequence>::s_keyword,
        attribute::get(attribute::Keyword::GeneticModificationsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneticModificationsDescription>::s_keyword,
        attribute::get(0x0010, 0x0222).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneticModificationsDescription>::s_keyword,
        attribute::get(attribute::Keyword::GeneticModificationsDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneticModificationsNomenclature>::s_keyword,
        attribute::get(0x0010, 0x0223).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneticModificationsNomenclature>::s_keyword,
        attribute::get(attribute::Keyword::GeneticModificationsNomenclature).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneticModificationsCodeSequence>::s_keyword,
        attribute::get(0x0010, 0x0229).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneticModificationsCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::GeneticModificationsCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OtherPatientNames>::s_keyword,
        attribute::get(0x0010, 0x1001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OtherPatientNames>::s_keyword,
        attribute::get(attribute::Keyword::OtherPatientNames).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OtherPatientIDsSequence>::s_keyword,
        attribute::get(0x0010, 0x1002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OtherPatientIDsSequence>::s_keyword,
        attribute::get(attribute::Keyword::OtherPatientIDsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientAge>::s_keyword,
        attribute::get(0x0010, 0x1010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientAge>::s_keyword,
        attribute::get(attribute::Keyword::PatientAge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSize>::s_keyword,
        attribute::get(0x0010, 0x1020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSize>::s_keyword,
        attribute::get(attribute::Keyword::PatientSize).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSizeCodeSequence>::s_keyword,
        attribute::get(0x0010, 0x1021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSizeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientSizeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBodyMassIndex>::s_keyword,
        attribute::get(0x0010, 0x1022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBodyMassIndex>::s_keyword,
        attribute::get(attribute::Keyword::PatientBodyMassIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeasuredAPDimension>::s_keyword,
        attribute::get(0x0010, 0x1023).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeasuredAPDimension>::s_keyword,
        attribute::get(attribute::Keyword::MeasuredAPDimension).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeasuredLateralDimension>::s_keyword,
        attribute::get(0x0010, 0x1024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeasuredLateralDimension>::s_keyword,
        attribute::get(attribute::Keyword::MeasuredLateralDimension).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientWeight>::s_keyword,
        attribute::get(0x0010, 0x1030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientWeight>::s_keyword,
        attribute::get(attribute::Keyword::PatientWeight).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPatientPhotoSequence>::s_keyword,
        attribute::get(0x0010, 0x1100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPatientPhotoSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedPatientPhotoSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MedicalAlerts>::s_keyword,
        attribute::get(0x0010, 0x2000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MedicalAlerts>::s_keyword,
        attribute::get(attribute::Keyword::MedicalAlerts).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Allergies>::s_keyword,
        attribute::get(0x0010, 0x2110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Allergies>::s_keyword,
        attribute::get(attribute::Keyword::Allergies).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EthnicGroup>::s_keyword,
        attribute::get(0x0010, 0x2160).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EthnicGroup>::s_keyword,
        attribute::get(attribute::Keyword::EthnicGroup).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Occupation>::s_keyword,
        attribute::get(0x0010, 0x2180).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Occupation>::s_keyword,
        attribute::get(attribute::Keyword::Occupation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SmokingStatus>::s_keyword,
        attribute::get(0x0010, 0x21A0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SmokingStatus>::s_keyword,
        attribute::get(attribute::Keyword::SmokingStatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdditionalPatientHistory>::s_keyword,
        attribute::get(0x0010, 0x21B0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdditionalPatientHistory>::s_keyword,
        attribute::get(attribute::Keyword::AdditionalPatientHistory).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PregnancyStatus>::s_keyword,
        attribute::get(0x0010, 0x21C0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PregnancyStatus>::s_keyword,
        attribute::get(attribute::Keyword::PregnancyStatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LastMenstrualDate>::s_keyword,
        attribute::get(0x0010, 0x21D0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LastMenstrualDate>::s_keyword,
        attribute::get(attribute::Keyword::LastMenstrualDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSpeciesDescription>::s_keyword,
        attribute::get(0x0010, 0x2201).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSpeciesDescription>::s_keyword,
        attribute::get(attribute::Keyword::PatientSpeciesDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSpeciesCodeSequence>::s_keyword,
        attribute::get(0x0010, 0x2202).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSpeciesCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientSpeciesCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSexNeutered>::s_keyword,
        attribute::get(0x0010, 0x2203).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSexNeutered>::s_keyword,
        attribute::get(attribute::Keyword::PatientSexNeutered).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnatomicalOrientationType>::s_keyword,
        attribute::get(0x0010, 0x2210).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnatomicalOrientationType>::s_keyword,
        attribute::get(attribute::Keyword::AnatomicalOrientationType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBreedDescription>::s_keyword,
        attribute::get(0x0010, 0x2292).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBreedDescription>::s_keyword,
        attribute::get(attribute::Keyword::PatientBreedDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBreedCodeSequence>::s_keyword,
        attribute::get(0x0010, 0x2293).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientBreedCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientBreedCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreedRegistrationSequence>::s_keyword,
        attribute::get(0x0010, 0x2294).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreedRegistrationSequence>::s_keyword,
        attribute::get(attribute::Keyword::BreedRegistrationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreedRegistrationNumber>::s_keyword,
        attribute::get(0x0010, 0x2295).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreedRegistrationNumber>::s_keyword,
        attribute::get(attribute::Keyword::BreedRegistrationNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreedRegistryCodeSequence>::s_keyword,
        attribute::get(0x0010, 0x2296).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreedRegistryCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::BreedRegistryCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ResponsiblePerson>::s_keyword,
        attribute::get(0x0010, 0x2297).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ResponsiblePerson>::s_keyword,
        attribute::get(attribute::Keyword::ResponsiblePerson).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ResponsiblePersonRole>::s_keyword,
        attribute::get(0x0010, 0x2298).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ResponsiblePersonRole>::s_keyword,
        attribute::get(attribute::Keyword::ResponsiblePersonRole).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ResponsibleOrganization>::s_keyword,
        attribute::get(0x0010, 0x2299).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ResponsibleOrganization>::s_keyword,
        attribute::get(attribute::Keyword::ResponsibleOrganization).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientComments>::s_keyword,
        attribute::get(0x0010, 0x4000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientComments>::s_keyword,
        attribute::get(attribute::Keyword::PatientComments).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExaminedBodyThickness>::s_keyword,
        attribute::get(0x0010, 0x9431).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExaminedBodyThickness>::s_keyword,
        attribute::get(attribute::Keyword::ExaminedBodyThickness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSponsorName>::s_keyword,
        attribute::get(0x0012, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSponsorName>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialSponsorName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialProtocolID>::s_keyword,
        attribute::get(0x0012, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialProtocolID>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialProtocolID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialProtocolName>::s_keyword,
        attribute::get(0x0012, 0x0021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialProtocolName>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialProtocolName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSiteID>::s_keyword,
        attribute::get(0x0012, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSiteID>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialSiteID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSiteName>::s_keyword,
        attribute::get(0x0012, 0x0031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSiteName>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialSiteName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSubjectID>::s_keyword,
        attribute::get(0x0012, 0x0040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSubjectID>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialSubjectID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSubjectReadingID>::s_keyword,
        attribute::get(0x0012, 0x0042).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSubjectReadingID>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialSubjectReadingID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialTimePointID>::s_keyword,
        attribute::get(0x0012, 0x0050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialTimePointID>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialTimePointID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialTimePointDescription>::s_keyword,
        attribute::get(0x0012, 0x0051).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialTimePointDescription>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialTimePointDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LongitudinalTemporalOffsetFromEvent>::s_keyword,
        attribute::get(0x0012, 0x0052).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LongitudinalTemporalOffsetFromEvent>::s_keyword,
        attribute::get(attribute::Keyword::LongitudinalTemporalOffsetFromEvent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LongitudinalTemporalEventType>::s_keyword,
        attribute::get(0x0012, 0x0053).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LongitudinalTemporalEventType>::s_keyword,
        attribute::get(attribute::Keyword::LongitudinalTemporalEventType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialTimePointTypeCodeSequence>::s_keyword,
        attribute::get(0x0012, 0x0054).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialTimePointTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialTimePointTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialCoordinatingCenterName>::s_keyword,
        attribute::get(0x0012, 0x0060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialCoordinatingCenterName>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialCoordinatingCenterName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientIdentityRemoved>::s_keyword,
        attribute::get(0x0012, 0x0062).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientIdentityRemoved>::s_keyword,
        attribute::get(attribute::Keyword::PatientIdentityRemoved).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeidentificationMethod>::s_keyword,
        attribute::get(0x0012, 0x0063).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeidentificationMethod>::s_keyword,
        attribute::get(attribute::Keyword::DeidentificationMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeidentificationMethodCodeSequence>::s_keyword,
        attribute::get(0x0012, 0x0064).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeidentificationMethodCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::DeidentificationMethodCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSeriesID>::s_keyword,
        attribute::get(0x0012, 0x0071).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSeriesID>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialSeriesID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSeriesDescription>::s_keyword,
        attribute::get(0x0012, 0x0072).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialSeriesDescription>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialSeriesDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialProtocolEthicsCommitteeName>::s_keyword,
        attribute::get(0x0012, 0x0081).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialProtocolEthicsCommitteeName>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialProtocolEthicsCommitteeName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialProtocolEthicsCommitteeApprovalNumber>::s_keyword,
        attribute::get(0x0012, 0x0082).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalTrialProtocolEthicsCommitteeApprovalNumber>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalTrialProtocolEthicsCommitteeApprovalNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConsentForClinicalTrialUseSequence>::s_keyword,
        attribute::get(0x0012, 0x0083).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConsentForClinicalTrialUseSequence>::s_keyword,
        attribute::get(attribute::Keyword::ConsentForClinicalTrialUseSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistributionType>::s_keyword,
        attribute::get(0x0012, 0x0084).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistributionType>::s_keyword,
        attribute::get(attribute::Keyword::DistributionType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConsentForDistributionFlag>::s_keyword,
        attribute::get(0x0012, 0x0085).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConsentForDistributionFlag>::s_keyword,
        attribute::get(attribute::Keyword::ConsentForDistributionFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WhitePoint>::s_keyword,
        attribute::get(0x0016, 0x0001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WhitePoint>::s_keyword,
        attribute::get(attribute::Keyword::WhitePoint).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryChromaticities>::s_keyword,
        attribute::get(0x0016, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryChromaticities>::s_keyword,
        attribute::get(attribute::Keyword::PrimaryChromaticities).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BatteryLevel>::s_keyword,
        attribute::get(0x0016, 0x0003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BatteryLevel>::s_keyword,
        attribute::get(attribute::Keyword::BatteryLevel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureTimeInSeconds>::s_keyword,
        attribute::get(0x0016, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureTimeInSeconds>::s_keyword,
        attribute::get(attribute::Keyword::ExposureTimeInSeconds).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FNumber>::s_keyword,
        attribute::get(0x0016, 0x0005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FNumber>::s_keyword,
        attribute::get(attribute::Keyword::FNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OECFRows>::s_keyword,
        attribute::get(0x0016, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OECFRows>::s_keyword,
        attribute::get(attribute::Keyword::OECFRows).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OECFColumns>::s_keyword,
        attribute::get(0x0016, 0x0007).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OECFColumns>::s_keyword,
        attribute::get(attribute::Keyword::OECFColumns).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OECFColumnNames>::s_keyword,
        attribute::get(0x0016, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OECFColumnNames>::s_keyword,
        attribute::get(attribute::Keyword::OECFColumnNames).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OECFValues>::s_keyword,
        attribute::get(0x0016, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OECFValues>::s_keyword,
        attribute::get(attribute::Keyword::OECFValues).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialFrequencyResponseRows>::s_keyword,
        attribute::get(0x0016, 0x000A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialFrequencyResponseRows>::s_keyword,
        attribute::get(attribute::Keyword::SpatialFrequencyResponseRows).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialFrequencyResponseColumns>::s_keyword,
        attribute::get(0x0016, 0x000B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialFrequencyResponseColumns>::s_keyword,
        attribute::get(attribute::Keyword::SpatialFrequencyResponseColumns).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialFrequencyResponseColumnNames>::s_keyword,
        attribute::get(0x0016, 0x000C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialFrequencyResponseColumnNames>::s_keyword,
        attribute::get(attribute::Keyword::SpatialFrequencyResponseColumnNames).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialFrequencyResponseValues>::s_keyword,
        attribute::get(0x0016, 0x000D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialFrequencyResponseValues>::s_keyword,
        attribute::get(attribute::Keyword::SpatialFrequencyResponseValues).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColorFilterArrayPatternRows>::s_keyword,
        attribute::get(0x0016, 0x000E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColorFilterArrayPatternRows>::s_keyword,
        attribute::get(attribute::Keyword::ColorFilterArrayPatternRows).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColorFilterArrayPatternColumns>::s_keyword,
        attribute::get(0x0016, 0x000F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColorFilterArrayPatternColumns>::s_keyword,
        attribute::get(attribute::Keyword::ColorFilterArrayPatternColumns).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColorFilterArrayPatternValues>::s_keyword,
        attribute::get(0x0016, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColorFilterArrayPatternValues>::s_keyword,
        attribute::get(attribute::Keyword::ColorFilterArrayPatternValues).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashFiringStatus>::s_keyword,
        attribute::get(0x0016, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashFiringStatus>::s_keyword,
        attribute::get(attribute::Keyword::FlashFiringStatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashReturnStatus>::s_keyword,
        attribute::get(0x0016, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashReturnStatus>::s_keyword,
        attribute::get(attribute::Keyword::FlashReturnStatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashMode>::s_keyword,
        attribute::get(0x0016, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashMode>::s_keyword,
        attribute::get(attribute::Keyword::FlashMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashFunctionPresent>::s_keyword,
        attribute::get(0x0016, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashFunctionPresent>::s_keyword,
        attribute::get(attribute::Keyword::FlashFunctionPresent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashRedEyeMode>::s_keyword,
        attribute::get(0x0016, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashRedEyeMode>::s_keyword,
        attribute::get(attribute::Keyword::FlashRedEyeMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureProgram>::s_keyword,
        attribute::get(0x0016, 0x0016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureProgram>::s_keyword,
        attribute::get(attribute::Keyword::ExposureProgram).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpectralSensitivity>::s_keyword,
        attribute::get(0x0016, 0x0017).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpectralSensitivity>::s_keyword,
        attribute::get(attribute::Keyword::SpectralSensitivity).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhotographicSensitivity>::s_keyword,
        attribute::get(0x0016, 0x0018).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhotographicSensitivity>::s_keyword,
        attribute::get(attribute::Keyword::PhotographicSensitivity).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SelfTimerMode>::s_keyword,
        attribute::get(0x0016, 0x0019).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SelfTimerMode>::s_keyword,
        attribute::get(attribute::Keyword::SelfTimerMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SensitivityType>::s_keyword,
        attribute::get(0x0016, 0x001A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SensitivityType>::s_keyword,
        attribute::get(attribute::Keyword::SensitivityType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StandardOutputSensitivity>::s_keyword,
        attribute::get(0x0016, 0x001B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StandardOutputSensitivity>::s_keyword,
        attribute::get(attribute::Keyword::StandardOutputSensitivity).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedExposureIndex>::s_keyword,
        attribute::get(0x0016, 0x001C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedExposureIndex>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedExposureIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ISOSpeed>::s_keyword,
        attribute::get(0x0016, 0x001D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ISOSpeed>::s_keyword,
        attribute::get(attribute::Keyword::ISOSpeed).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ISOSpeedLatitudeyyy>::s_keyword,
        attribute::get(0x0016, 0x001E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ISOSpeedLatitudeyyy>::s_keyword,
        attribute::get(attribute::Keyword::ISOSpeedLatitudeyyy).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ISOSpeedLatitudezzz>::s_keyword,
        attribute::get(0x0016, 0x001F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ISOSpeedLatitudezzz>::s_keyword,
        attribute::get(attribute::Keyword::ISOSpeedLatitudezzz).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EXIFVersion>::s_keyword,
        attribute::get(0x0016, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EXIFVersion>::s_keyword,
        attribute::get(attribute::Keyword::EXIFVersion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterSpeedValue>::s_keyword,
        attribute::get(0x0016, 0x0021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterSpeedValue>::s_keyword,
        attribute::get(attribute::Keyword::ShutterSpeedValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApertureValue>::s_keyword,
        attribute::get(0x0016, 0x0022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApertureValue>::s_keyword,
        attribute::get(attribute::Keyword::ApertureValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BrightnessValue>::s_keyword,
        attribute::get(0x0016, 0x0023).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BrightnessValue>::s_keyword,
        attribute::get(attribute::Keyword::BrightnessValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureBiasValue>::s_keyword,
        attribute::get(0x0016, 0x0024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureBiasValue>::s_keyword,
        attribute::get(attribute::Keyword::ExposureBiasValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaxApertureValue>::s_keyword,
        attribute::get(0x0016, 0x0025).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaxApertureValue>::s_keyword,
        attribute::get(attribute::Keyword::MaxApertureValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubjectDistance>::s_keyword,
        attribute::get(0x0016, 0x0026).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubjectDistance>::s_keyword,
        attribute::get(attribute::Keyword::SubjectDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeteringMode>::s_keyword,
        attribute::get(0x0016, 0x0027).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeteringMode>::s_keyword,
        attribute::get(attribute::Keyword::MeteringMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LightSource>::s_keyword,
        attribute::get(0x0016, 0x0028).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LightSource>::s_keyword,
        attribute::get(attribute::Keyword::LightSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocalLength>::s_keyword,
        attribute::get(0x0016, 0x0029).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocalLength>::s_keyword,
        attribute::get(attribute::Keyword::FocalLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubjectArea>::s_keyword,
        attribute::get(0x0016, 0x002A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubjectArea>::s_keyword,
        attribute::get(attribute::Keyword::SubjectArea).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MakerNote>::s_keyword,
        attribute::get(0x0016, 0x002B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MakerNote>::s_keyword,
        attribute::get(attribute::Keyword::MakerNote).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Temperature>::s_keyword,
        attribute::get(0x0016, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Temperature>::s_keyword,
        attribute::get(attribute::Keyword::Temperature).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Humidity>::s_keyword,
        attribute::get(0x0016, 0x0031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Humidity>::s_keyword,
        attribute::get(attribute::Keyword::Humidity).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Pressure>::s_keyword,
        attribute::get(0x0016, 0x0032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Pressure>::s_keyword,
        attribute::get(attribute::Keyword::Pressure).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WaterDepth>::s_keyword,
        attribute::get(0x0016, 0x0033).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WaterDepth>::s_keyword,
        attribute::get(attribute::Keyword::WaterDepth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Acceleration>::s_keyword,
        attribute::get(0x0016, 0x0034).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Acceleration>::s_keyword,
        attribute::get(attribute::Keyword::Acceleration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CameraElevationAngle>::s_keyword,
        attribute::get(0x0016, 0x0035).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CameraElevationAngle>::s_keyword,
        attribute::get(attribute::Keyword::CameraElevationAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashEnergy>::s_keyword,
        attribute::get(0x0016, 0x0036).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlashEnergy>::s_keyword,
        attribute::get(attribute::Keyword::FlashEnergy).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubjectLocation>::s_keyword,
        attribute::get(0x0016, 0x0037).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubjectLocation>::s_keyword,
        attribute::get(attribute::Keyword::SubjectLocation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhotographicExposureIndex>::s_keyword,
        attribute::get(0x0016, 0x0038).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhotographicExposureIndex>::s_keyword,
        attribute::get(attribute::Keyword::PhotographicExposureIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SensingMethod>::s_keyword,
        attribute::get(0x0016, 0x0039).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SensingMethod>::s_keyword,
        attribute::get(attribute::Keyword::SensingMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FileSource>::s_keyword,
        attribute::get(0x0016, 0x003A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FileSource>::s_keyword,
        attribute::get(attribute::Keyword::FileSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SceneType>::s_keyword,
        attribute::get(0x0016, 0x003B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SceneType>::s_keyword,
        attribute::get(attribute::Keyword::SceneType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CustomRendered>::s_keyword,
        attribute::get(0x0016, 0x0041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CustomRendered>::s_keyword,
        attribute::get(attribute::Keyword::CustomRendered).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureMode>::s_keyword,
        attribute::get(0x0016, 0x0042).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureMode>::s_keyword,
        attribute::get(attribute::Keyword::ExposureMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WhiteBalance>::s_keyword,
        attribute::get(0x0016, 0x0043).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WhiteBalance>::s_keyword,
        attribute::get(attribute::Keyword::WhiteBalance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalZoomRatio>::s_keyword,
        attribute::get(0x0016, 0x0044).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalZoomRatio>::s_keyword,
        attribute::get(attribute::Keyword::DigitalZoomRatio).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocalLengthIn35mmFilm>::s_keyword,
        attribute::get(0x0016, 0x0045).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocalLengthIn35mmFilm>::s_keyword,
        attribute::get(attribute::Keyword::FocalLengthIn35mmFilm).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SceneCaptureType>::s_keyword,
        attribute::get(0x0016, 0x0046).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SceneCaptureType>::s_keyword,
        attribute::get(attribute::Keyword::SceneCaptureType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GainControl>::s_keyword,
        attribute::get(0x0016, 0x0047).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GainControl>::s_keyword,
        attribute::get(attribute::Keyword::GainControl).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Contrast>::s_keyword,
        attribute::get(0x0016, 0x0048).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Contrast>::s_keyword,
        attribute::get(attribute::Keyword::Contrast).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Saturation>::s_keyword,
        attribute::get(0x0016, 0x0049).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Saturation>::s_keyword,
        attribute::get(attribute::Keyword::Saturation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Sharpness>::s_keyword,
        attribute::get(0x0016, 0x004A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Sharpness>::s_keyword,
        attribute::get(attribute::Keyword::Sharpness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceSettingDescription>::s_keyword,
        attribute::get(0x0016, 0x004B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceSettingDescription>::s_keyword,
        attribute::get(attribute::Keyword::DeviceSettingDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubjectDistanceRange>::s_keyword,
        attribute::get(0x0016, 0x004C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubjectDistanceRange>::s_keyword,
        attribute::get(attribute::Keyword::SubjectDistanceRange).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CameraOwnerName>::s_keyword,
        attribute::get(0x0016, 0x004D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CameraOwnerName>::s_keyword,
        attribute::get(attribute::Keyword::CameraOwnerName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LensSpecification>::s_keyword,
        attribute::get(0x0016, 0x004E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LensSpecification>::s_keyword,
        attribute::get(attribute::Keyword::LensSpecification).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LensMake>::s_keyword,
        attribute::get(0x0016, 0x004F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LensMake>::s_keyword,
        attribute::get(attribute::Keyword::LensMake).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LensModel>::s_keyword,
        attribute::get(0x0016, 0x0050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LensModel>::s_keyword,
        attribute::get(attribute::Keyword::LensModel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LensSerialNumber>::s_keyword,
        attribute::get(0x0016, 0x0051).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LensSerialNumber>::s_keyword,
        attribute::get(attribute::Keyword::LensSerialNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InteroperabilityIndex>::s_keyword,
        attribute::get(0x0016, 0x0061).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InteroperabilityIndex>::s_keyword,
        attribute::get(attribute::Keyword::InteroperabilityIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InteroperabilityVersion>::s_keyword,
        attribute::get(0x0016, 0x0062).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InteroperabilityVersion>::s_keyword,
        attribute::get(attribute::Keyword::InteroperabilityVersion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSVersionID>::s_keyword,
        attribute::get(0x0016, 0x0070).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSVersionID>::s_keyword,
        attribute::get(attribute::Keyword::GPSVersionID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSLatitudeRef>::s_keyword,
        attribute::get(0x0016, 0x0071).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSLatitudeRef>::s_keyword,
        attribute::get(attribute::Keyword::GPSLatitudeRef).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSLatitude>::s_keyword,
        attribute::get(0x0016, 0x0072).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSLatitude>::s_keyword,
        attribute::get(attribute::Keyword::GPSLatitude).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSLongitudeRef>::s_keyword,
        attribute::get(0x0016, 0x0073).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSLongitudeRef>::s_keyword,
        attribute::get(attribute::Keyword::GPSLongitudeRef).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSLongitude>::s_keyword,
        attribute::get(0x0016, 0x0074).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSLongitude>::s_keyword,
        attribute::get(attribute::Keyword::GPSLongitude).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSAltitudeRef>::s_keyword,
        attribute::get(0x0016, 0x0075).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSAltitudeRef>::s_keyword,
        attribute::get(attribute::Keyword::GPSAltitudeRef).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSAltitude>::s_keyword,
        attribute::get(0x0016, 0x0076).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSAltitude>::s_keyword,
        attribute::get(attribute::Keyword::GPSAltitude).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSTimeStamp>::s_keyword,
        attribute::get(0x0016, 0x0077).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSTimeStamp>::s_keyword,
        attribute::get(attribute::Keyword::GPSTimeStamp).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSSatellites>::s_keyword,
        attribute::get(0x0016, 0x0078).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSSatellites>::s_keyword,
        attribute::get(attribute::Keyword::GPSSatellites).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPstatus>::s_keyword,
        attribute::get(0x0016, 0x0079).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPstatus>::s_keyword,
        attribute::get(attribute::Keyword::GPstatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSMeasureMode>::s_keyword,
        attribute::get(0x0016, 0x007A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSMeasureMode>::s_keyword,
        attribute::get(attribute::Keyword::GPSMeasureMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDOP>::s_keyword,
        attribute::get(0x0016, 0x007B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDOP>::s_keyword,
        attribute::get(attribute::Keyword::GPSDOP).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSSpeedRef>::s_keyword,
        attribute::get(0x0016, 0x007C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSSpeedRef>::s_keyword,
        attribute::get(attribute::Keyword::GPSSpeedRef).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSSpeed>::s_keyword,
        attribute::get(0x0016, 0x007D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSSpeed>::s_keyword,
        attribute::get(attribute::Keyword::GPSSpeed).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSTrackRef>::s_keyword,
        attribute::get(0x0016, 0x007E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSTrackRef>::s_keyword,
        attribute::get(attribute::Keyword::GPSTrackRef).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSTrack>::s_keyword,
        attribute::get(0x0016, 0x007F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSTrack>::s_keyword,
        attribute::get(attribute::Keyword::GPSTrack).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSImgDirectionRef>::s_keyword,
        attribute::get(0x0016, 0x0080).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSImgDirectionRef>::s_keyword,
        attribute::get(attribute::Keyword::GPSImgDirectionRef).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSImgDirection>::s_keyword,
        attribute::get(0x0016, 0x0081).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSImgDirection>::s_keyword,
        attribute::get(attribute::Keyword::GPSImgDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSMapDatum>::s_keyword,
        attribute::get(0x0016, 0x0082).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSMapDatum>::s_keyword,
        attribute::get(attribute::Keyword::GPSMapDatum).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestLatitudeRef>::s_keyword,
        attribute::get(0x0016, 0x0083).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestLatitudeRef>::s_keyword,
        attribute::get(attribute::Keyword::GPSDestLatitudeRef).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestLatitude>::s_keyword,
        attribute::get(0x0016, 0x0084).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestLatitude>::s_keyword,
        attribute::get(attribute::Keyword::GPSDestLatitude).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestLongitudeRef>::s_keyword,
        attribute::get(0x0016, 0x0085).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestLongitudeRef>::s_keyword,
        attribute::get(attribute::Keyword::GPSDestLongitudeRef).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestLongitude>::s_keyword,
        attribute::get(0x0016, 0x0086).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestLongitude>::s_keyword,
        attribute::get(attribute::Keyword::GPSDestLongitude).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestBearingRef>::s_keyword,
        attribute::get(0x0016, 0x0087).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestBearingRef>::s_keyword,
        attribute::get(attribute::Keyword::GPSDestBearingRef).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestBearing>::s_keyword,
        attribute::get(0x0016, 0x0088).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestBearing>::s_keyword,
        attribute::get(attribute::Keyword::GPSDestBearing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestDistanceRef>::s_keyword,
        attribute::get(0x0016, 0x0089).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestDistanceRef>::s_keyword,
        attribute::get(attribute::Keyword::GPSDestDistanceRef).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestDistance>::s_keyword,
        attribute::get(0x0016, 0x008A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDestDistance>::s_keyword,
        attribute::get(attribute::Keyword::GPSDestDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSProcessingMethod>::s_keyword,
        attribute::get(0x0016, 0x008B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSProcessingMethod>::s_keyword,
        attribute::get(attribute::Keyword::GPSProcessingMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSAreaInformation>::s_keyword,
        attribute::get(0x0016, 0x008C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSAreaInformation>::s_keyword,
        attribute::get(attribute::Keyword::GPSAreaInformation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDateStamp>::s_keyword,
        attribute::get(0x0016, 0x008D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDateStamp>::s_keyword,
        attribute::get(attribute::Keyword::GPSDateStamp).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDifferential>::s_keyword,
        attribute::get(0x0016, 0x008E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GPSDifferential>::s_keyword,
        attribute::get(attribute::Keyword::GPSDifferential).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LightSourcePolarization>::s_keyword,
        attribute::get(0x0016, 0x1001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LightSourcePolarization>::s_keyword,
        attribute::get(attribute::Keyword::LightSourcePolarization).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EmitterColorTemperature>::s_keyword,
        attribute::get(0x0016, 0x1002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EmitterColorTemperature>::s_keyword,
        attribute::get(attribute::Keyword::EmitterColorTemperature).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContactMethod>::s_keyword,
        attribute::get(0x0016, 0x1003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContactMethod>::s_keyword,
        attribute::get(attribute::Keyword::ContactMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImmersionMedia>::s_keyword,
        attribute::get(0x0016, 0x1004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImmersionMedia>::s_keyword,
        attribute::get(attribute::Keyword::ImmersionMedia).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OpticalMagnificationFactor>::s_keyword,
        attribute::get(0x0016, 0x1005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OpticalMagnificationFactor>::s_keyword,
        attribute::get(attribute::Keyword::OpticalMagnificationFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgent>::s_keyword,
        attribute::get(0x0018, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgent>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusAgent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgentSequence>::s_keyword,
        attribute::get(0x0018, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgentSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusAgentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusT1Relaxivity>::s_keyword,
        attribute::get(0x0018, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusT1Relaxivity>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusT1Relaxivity).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAdministrationRouteSequence>::s_keyword,
        attribute::get(0x0018, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAdministrationRouteSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusAdministrationRouteSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BodyPartExamined>::s_keyword,
        attribute::get(0x0018, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BodyPartExamined>::s_keyword,
        attribute::get(attribute::Keyword::BodyPartExamined).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanningSequence>::s_keyword,
        attribute::get(0x0018, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanningSequence>::s_keyword,
        attribute::get(attribute::Keyword::ScanningSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SequenceVariant>::s_keyword,
        attribute::get(0x0018, 0x0021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SequenceVariant>::s_keyword,
        attribute::get(attribute::Keyword::SequenceVariant).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanOptions>::s_keyword,
        attribute::get(0x0018, 0x0022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanOptions>::s_keyword,
        attribute::get(attribute::Keyword::ScanOptions).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRAcquisitionType>::s_keyword,
        attribute::get(0x0018, 0x0023).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRAcquisitionType>::s_keyword,
        attribute::get(attribute::Keyword::MRAcquisitionType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SequenceName>::s_keyword,
        attribute::get(0x0018, 0x0024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SequenceName>::s_keyword,
        attribute::get(attribute::Keyword::SequenceName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AngioFlag>::s_keyword,
        attribute::get(0x0018, 0x0025).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AngioFlag>::s_keyword,
        attribute::get(attribute::Keyword::AngioFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugInformationSequence>::s_keyword,
        attribute::get(0x0018, 0x0026).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugInformationSequence>::s_keyword,
        attribute::get(attribute::Keyword::InterventionDrugInformationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugStopTime>::s_keyword,
        attribute::get(0x0018, 0x0027).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugStopTime>::s_keyword,
        attribute::get(attribute::Keyword::InterventionDrugStopTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugDose>::s_keyword,
        attribute::get(0x0018, 0x0028).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugDose>::s_keyword,
        attribute::get(attribute::Keyword::InterventionDrugDose).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x0029).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::InterventionDrugCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdditionalDrugSequence>::s_keyword,
        attribute::get(0x0018, 0x002A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdditionalDrugSequence>::s_keyword,
        attribute::get(attribute::Keyword::AdditionalDrugSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Radiopharmaceutical>::s_keyword,
        attribute::get(0x0018, 0x0031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Radiopharmaceutical>::s_keyword,
        attribute::get(attribute::Keyword::Radiopharmaceutical).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugName>::s_keyword,
        attribute::get(0x0018, 0x0034).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugName>::s_keyword,
        attribute::get(attribute::Keyword::InterventionDrugName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugStartTime>::s_keyword,
        attribute::get(0x0018, 0x0035).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDrugStartTime>::s_keyword,
        attribute::get(attribute::Keyword::InterventionDrugStartTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionSequence>::s_keyword,
        attribute::get(0x0018, 0x0036).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionSequence>::s_keyword,
        attribute::get(attribute::Keyword::InterventionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionStatus>::s_keyword,
        attribute::get(0x0018, 0x0038).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionStatus>::s_keyword,
        attribute::get(attribute::Keyword::InterventionStatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDescription>::s_keyword,
        attribute::get(0x0018, 0x003A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterventionDescription>::s_keyword,
        attribute::get(attribute::Keyword::InterventionDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CineRate>::s_keyword,
        attribute::get(0x0018, 0x0040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CineRate>::s_keyword,
        attribute::get(attribute::Keyword::CineRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InitialCineRunState>::s_keyword,
        attribute::get(0x0018, 0x0042).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InitialCineRunState>::s_keyword,
        attribute::get(attribute::Keyword::InitialCineRunState).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceThickness>::s_keyword,
        attribute::get(0x0018, 0x0050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceThickness>::s_keyword,
        attribute::get(attribute::Keyword::SliceThickness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::KVP>::s_keyword,
        attribute::get(0x0018, 0x0060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::KVP>::s_keyword,
        attribute::get(attribute::Keyword::KVP).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CountsAccumulated>::s_keyword,
        attribute::get(0x0018, 0x0070).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CountsAccumulated>::s_keyword,
        attribute::get(attribute::Keyword::CountsAccumulated).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionTerminationCondition>::s_keyword,
        attribute::get(0x0018, 0x0071).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionTerminationCondition>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionTerminationCondition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EffectiveDuration>::s_keyword,
        attribute::get(0x0018, 0x0072).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EffectiveDuration>::s_keyword,
        attribute::get(attribute::Keyword::EffectiveDuration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionStartCondition>::s_keyword,
        attribute::get(0x0018, 0x0073).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionStartCondition>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionStartCondition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionStartConditionData>::s_keyword,
        attribute::get(0x0018, 0x0074).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionStartConditionData>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionStartConditionData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionTerminationConditionData>::s_keyword,
        attribute::get(0x0018, 0x0075).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionTerminationConditionData>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionTerminationConditionData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RepetitionTime>::s_keyword,
        attribute::get(0x0018, 0x0080).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RepetitionTime>::s_keyword,
        attribute::get(attribute::Keyword::RepetitionTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EchoTime>::s_keyword,
        attribute::get(0x0018, 0x0081).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EchoTime>::s_keyword,
        attribute::get(attribute::Keyword::EchoTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InversionTime>::s_keyword,
        attribute::get(0x0018, 0x0082).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InversionTime>::s_keyword,
        attribute::get(attribute::Keyword::InversionTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfAverages>::s_keyword,
        attribute::get(0x0018, 0x0083).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfAverages>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfAverages).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagingFrequency>::s_keyword,
        attribute::get(0x0018, 0x0084).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagingFrequency>::s_keyword,
        attribute::get(attribute::Keyword::ImagingFrequency).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagedNucleus>::s_keyword,
        attribute::get(0x0018, 0x0085).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagedNucleus>::s_keyword,
        attribute::get(attribute::Keyword::ImagedNucleus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EchoNumbers>::s_keyword,
        attribute::get(0x0018, 0x0086).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EchoNumbers>::s_keyword,
        attribute::get(attribute::Keyword::EchoNumbers).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MagneticFieldStrength>::s_keyword,
        attribute::get(0x0018, 0x0087).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MagneticFieldStrength>::s_keyword,
        attribute::get(attribute::Keyword::MagneticFieldStrength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpacingBetweenSlices>::s_keyword,
        attribute::get(0x0018, 0x0088).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpacingBetweenSlices>::s_keyword,
        attribute::get(attribute::Keyword::SpacingBetweenSlices).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfPhaseEncodingSteps>::s_keyword,
        attribute::get(0x0018, 0x0089).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfPhaseEncodingSteps>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfPhaseEncodingSteps).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataCollectionDiameter>::s_keyword,
        attribute::get(0x0018, 0x0090).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataCollectionDiameter>::s_keyword,
        attribute::get(attribute::Keyword::DataCollectionDiameter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EchoTrainLength>::s_keyword,
        attribute::get(0x0018, 0x0091).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EchoTrainLength>::s_keyword,
        attribute::get(attribute::Keyword::EchoTrainLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PercentSampling>::s_keyword,
        attribute::get(0x0018, 0x0093).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PercentSampling>::s_keyword,
        attribute::get(attribute::Keyword::PercentSampling).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PercentPhaseFieldOfView>::s_keyword,
        attribute::get(0x0018, 0x0094).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PercentPhaseFieldOfView>::s_keyword,
        attribute::get(attribute::Keyword::PercentPhaseFieldOfView).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelBandwidth>::s_keyword,
        attribute::get(0x0018, 0x0095).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelBandwidth>::s_keyword,
        attribute::get(attribute::Keyword::PixelBandwidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceSerialNumber>::s_keyword,
        attribute::get(0x0018, 0x1000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceSerialNumber>::s_keyword,
        attribute::get(attribute::Keyword::DeviceSerialNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceUID>::s_keyword,
        attribute::get(0x0018, 0x1002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceUID>::s_keyword,
        attribute::get(attribute::Keyword::DeviceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceID>::s_keyword,
        attribute::get(0x0018, 0x1003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceID>::s_keyword,
        attribute::get(attribute::Keyword::DeviceID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlateID>::s_keyword,
        attribute::get(0x0018, 0x1004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlateID>::s_keyword,
        attribute::get(attribute::Keyword::PlateID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneratorID>::s_keyword,
        attribute::get(0x0018, 0x1005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneratorID>::s_keyword,
        attribute::get(attribute::Keyword::GeneratorID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridID>::s_keyword,
        attribute::get(0x0018, 0x1006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridID>::s_keyword,
        attribute::get(attribute::Keyword::GridID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CassetteID>::s_keyword,
        attribute::get(0x0018, 0x1007).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CassetteID>::s_keyword,
        attribute::get(attribute::Keyword::CassetteID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryID>::s_keyword,
        attribute::get(0x0018, 0x1008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryID>::s_keyword,
        attribute::get(attribute::Keyword::GantryID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UniqueDeviceIdentifier>::s_keyword,
        attribute::get(0x0018, 0x1009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UniqueDeviceIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::UniqueDeviceIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UDISequence>::s_keyword,
        attribute::get(0x0018, 0x100A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UDISequence>::s_keyword,
        attribute::get(attribute::Keyword::UDISequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ManufacturerDeviceClassUID>::s_keyword,
        attribute::get(0x0018, 0x100B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ManufacturerDeviceClassUID>::s_keyword,
        attribute::get(attribute::Keyword::ManufacturerDeviceClassUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCaptureDeviceID>::s_keyword,
        attribute::get(0x0018, 0x1010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCaptureDeviceID>::s_keyword,
        attribute::get(attribute::Keyword::SecondaryCaptureDeviceID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateOfSecondaryCapture>::s_keyword,
        attribute::get(0x0018, 0x1012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateOfSecondaryCapture>::s_keyword,
        attribute::get(attribute::Keyword::DateOfSecondaryCapture).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfSecondaryCapture>::s_keyword,
        attribute::get(0x0018, 0x1014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfSecondaryCapture>::s_keyword,
        attribute::get(attribute::Keyword::TimeOfSecondaryCapture).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCaptureDeviceManufacturer>::s_keyword,
        attribute::get(0x0018, 0x1016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCaptureDeviceManufacturer>::s_keyword,
        attribute::get(attribute::Keyword::SecondaryCaptureDeviceManufacturer).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCaptureDeviceManufacturerModelName>::s_keyword,
        attribute::get(0x0018, 0x1018).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCaptureDeviceManufacturerModelName>::s_keyword,
        attribute::get(attribute::Keyword::SecondaryCaptureDeviceManufacturerModelName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCaptureDeviceSoftwareVersions>::s_keyword,
        attribute::get(0x0018, 0x1019).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCaptureDeviceSoftwareVersions>::s_keyword,
        attribute::get(attribute::Keyword::SecondaryCaptureDeviceSoftwareVersions).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SoftwareVersions>::s_keyword,
        attribute::get(0x0018, 0x1020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SoftwareVersions>::s_keyword,
        attribute::get(attribute::Keyword::SoftwareVersions).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VideoImageFormatAcquired>::s_keyword,
        attribute::get(0x0018, 0x1022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VideoImageFormatAcquired>::s_keyword,
        attribute::get(attribute::Keyword::VideoImageFormatAcquired).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalImageFormatAcquired>::s_keyword,
        attribute::get(0x0018, 0x1023).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalImageFormatAcquired>::s_keyword,
        attribute::get(attribute::Keyword::DigitalImageFormatAcquired).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProtocolName>::s_keyword,
        attribute::get(0x0018, 0x1030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProtocolName>::s_keyword,
        attribute::get(attribute::Keyword::ProtocolName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusRoute>::s_keyword,
        attribute::get(0x0018, 0x1040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusRoute>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusRoute).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusVolume>::s_keyword,
        attribute::get(0x0018, 0x1041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusVolume>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusVolume).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusStartTime>::s_keyword,
        attribute::get(0x0018, 0x1042).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusStartTime>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusStartTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusStopTime>::s_keyword,
        attribute::get(0x0018, 0x1043).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusStopTime>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusStopTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusTotalDose>::s_keyword,
        attribute::get(0x0018, 0x1044).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusTotalDose>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusTotalDose).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastFlowRate>::s_keyword,
        attribute::get(0x0018, 0x1046).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastFlowRate>::s_keyword,
        attribute::get(attribute::Keyword::ContrastFlowRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastFlowDuration>::s_keyword,
        attribute::get(0x0018, 0x1047).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastFlowDuration>::s_keyword,
        attribute::get(attribute::Keyword::ContrastFlowDuration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusIngredient>::s_keyword,
        attribute::get(0x0018, 0x1048).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusIngredient>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusIngredient).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusIngredientConcentration>::s_keyword,
        attribute::get(0x0018, 0x1049).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusIngredientConcentration>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusIngredientConcentration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialResolution>::s_keyword,
        attribute::get(0x0018, 0x1050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialResolution>::s_keyword,
        attribute::get(attribute::Keyword::SpatialResolution).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TriggerTime>::s_keyword,
        attribute::get(0x0018, 0x1060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TriggerTime>::s_keyword,
        attribute::get(attribute::Keyword::TriggerTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TriggerSourceOrType>::s_keyword,
        attribute::get(0x0018, 0x1061).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TriggerSourceOrType>::s_keyword,
        attribute::get(attribute::Keyword::TriggerSourceOrType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalInterval>::s_keyword,
        attribute::get(0x0018, 0x1062).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalInterval>::s_keyword,
        attribute::get(attribute::Keyword::NominalInterval).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameTime>::s_keyword,
        attribute::get(0x0018, 0x1063).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameTime>::s_keyword,
        attribute::get(attribute::Keyword::FrameTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacFramingType>::s_keyword,
        attribute::get(0x0018, 0x1064).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacFramingType>::s_keyword,
        attribute::get(attribute::Keyword::CardiacFramingType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameTimeVector>::s_keyword,
        attribute::get(0x0018, 0x1065).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameTimeVector>::s_keyword,
        attribute::get(attribute::Keyword::FrameTimeVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameDelay>::s_keyword,
        attribute::get(0x0018, 0x1066).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameDelay>::s_keyword,
        attribute::get(attribute::Keyword::FrameDelay).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageTriggerDelay>::s_keyword,
        attribute::get(0x0018, 0x1067).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageTriggerDelay>::s_keyword,
        attribute::get(attribute::Keyword::ImageTriggerDelay).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SynchronizationTrigger>::s_keyword,
        attribute::get(0x0018, 0x106A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SynchronizationTrigger>::s_keyword,
        attribute::get(attribute::Keyword::SynchronizationTrigger).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SynchronizationChannel>::s_keyword,
        attribute::get(0x0018, 0x106C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SynchronizationChannel>::s_keyword,
        attribute::get(attribute::Keyword::SynchronizationChannel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalRoute>::s_keyword,
        attribute::get(0x0018, 0x1070).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalRoute>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalRoute).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalVolume>::s_keyword,
        attribute::get(0x0018, 0x1071).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalVolume>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalVolume).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalStartTime>::s_keyword,
        attribute::get(0x0018, 0x1072).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalStartTime>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalStartTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalStopTime>::s_keyword,
        attribute::get(0x0018, 0x1073).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalStopTime>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalStopTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadionuclideTotalDose>::s_keyword,
        attribute::get(0x0018, 0x1074).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadionuclideTotalDose>::s_keyword,
        attribute::get(attribute::Keyword::RadionuclideTotalDose).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadionuclideHalfLife>::s_keyword,
        attribute::get(0x0018, 0x1075).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadionuclideHalfLife>::s_keyword,
        attribute::get(attribute::Keyword::RadionuclideHalfLife).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadionuclidePositronFraction>::s_keyword,
        attribute::get(0x0018, 0x1076).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadionuclidePositronFraction>::s_keyword,
        attribute::get(attribute::Keyword::RadionuclidePositronFraction).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalSpecificActivity>::s_keyword,
        attribute::get(0x0018, 0x1077).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalSpecificActivity>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalSpecificActivity).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalStartDateTime>::s_keyword,
        attribute::get(0x0018, 0x1078).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalStartDateTime>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalStartDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalStopDateTime>::s_keyword,
        attribute::get(0x0018, 0x1079).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalStopDateTime>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalStopDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeatRejectionFlag>::s_keyword,
        attribute::get(0x0018, 0x1080).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeatRejectionFlag>::s_keyword,
        attribute::get(attribute::Keyword::BeatRejectionFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LowRRValue>::s_keyword,
        attribute::get(0x0018, 0x1081).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LowRRValue>::s_keyword,
        attribute::get(attribute::Keyword::LowRRValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HighRRValue>::s_keyword,
        attribute::get(0x0018, 0x1082).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HighRRValue>::s_keyword,
        attribute::get(attribute::Keyword::HighRRValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntervalsAcquired>::s_keyword,
        attribute::get(0x0018, 0x1083).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntervalsAcquired>::s_keyword,
        attribute::get(attribute::Keyword::IntervalsAcquired).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntervalsRejected>::s_keyword,
        attribute::get(0x0018, 0x1084).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntervalsRejected>::s_keyword,
        attribute::get(attribute::Keyword::IntervalsRejected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PVCRejection>::s_keyword,
        attribute::get(0x0018, 0x1085).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PVCRejection>::s_keyword,
        attribute::get(attribute::Keyword::PVCRejection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SkipBeats>::s_keyword,
        attribute::get(0x0018, 0x1086).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SkipBeats>::s_keyword,
        attribute::get(attribute::Keyword::SkipBeats).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HeartRate>::s_keyword,
        attribute::get(0x0018, 0x1088).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HeartRate>::s_keyword,
        attribute::get(attribute::Keyword::HeartRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacNumberOfImages>::s_keyword,
        attribute::get(0x0018, 0x1090).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacNumberOfImages>::s_keyword,
        attribute::get(attribute::Keyword::CardiacNumberOfImages).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TriggerWindow>::s_keyword,
        attribute::get(0x0018, 0x1094).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TriggerWindow>::s_keyword,
        attribute::get(attribute::Keyword::TriggerWindow).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionDiameter>::s_keyword,
        attribute::get(0x0018, 0x1100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionDiameter>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionDiameter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceSourceToDetector>::s_keyword,
        attribute::get(0x0018, 0x1110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceSourceToDetector>::s_keyword,
        attribute::get(attribute::Keyword::DistanceSourceToDetector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceSourceToPatient>::s_keyword,
        attribute::get(0x0018, 0x1111).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceSourceToPatient>::s_keyword,
        attribute::get(attribute::Keyword::DistanceSourceToPatient).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EstimatedRadiographicMagnificationFactor>::s_keyword,
        attribute::get(0x0018, 0x1114).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EstimatedRadiographicMagnificationFactor>::s_keyword,
        attribute::get(attribute::Keyword::EstimatedRadiographicMagnificationFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryDetectorTilt>::s_keyword,
        attribute::get(0x0018, 0x1120).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryDetectorTilt>::s_keyword,
        attribute::get(attribute::Keyword::GantryDetectorTilt).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryDetectorSlew>::s_keyword,
        attribute::get(0x0018, 0x1121).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryDetectorSlew>::s_keyword,
        attribute::get(attribute::Keyword::GantryDetectorSlew).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableHeight>::s_keyword,
        attribute::get(0x0018, 0x1130).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableHeight>::s_keyword,
        attribute::get(attribute::Keyword::TableHeight).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTraverse>::s_keyword,
        attribute::get(0x0018, 0x1131).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTraverse>::s_keyword,
        attribute::get(attribute::Keyword::TableTraverse).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableMotion>::s_keyword,
        attribute::get(0x0018, 0x1134).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableMotion>::s_keyword,
        attribute::get(attribute::Keyword::TableMotion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableVerticalIncrement>::s_keyword,
        attribute::get(0x0018, 0x1135).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableVerticalIncrement>::s_keyword,
        attribute::get(attribute::Keyword::TableVerticalIncrement).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableLateralIncrement>::s_keyword,
        attribute::get(0x0018, 0x1136).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableLateralIncrement>::s_keyword,
        attribute::get(attribute::Keyword::TableLateralIncrement).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableLongitudinalIncrement>::s_keyword,
        attribute::get(0x0018, 0x1137).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableLongitudinalIncrement>::s_keyword,
        attribute::get(attribute::Keyword::TableLongitudinalIncrement).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableAngle>::s_keyword,
        attribute::get(0x0018, 0x1138).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableAngle>::s_keyword,
        attribute::get(attribute::Keyword::TableAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableType>::s_keyword,
        attribute::get(0x0018, 0x113A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableType>::s_keyword,
        attribute::get(attribute::Keyword::TableType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RotationDirection>::s_keyword,
        attribute::get(0x0018, 0x1140).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RotationDirection>::s_keyword,
        attribute::get(attribute::Keyword::RotationDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadialPosition>::s_keyword,
        attribute::get(0x0018, 0x1142).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadialPosition>::s_keyword,
        attribute::get(attribute::Keyword::RadialPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanArc>::s_keyword,
        attribute::get(0x0018, 0x1143).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanArc>::s_keyword,
        attribute::get(attribute::Keyword::ScanArc).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AngularStep>::s_keyword,
        attribute::get(0x0018, 0x1144).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AngularStep>::s_keyword,
        attribute::get(attribute::Keyword::AngularStep).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfRotationOffset>::s_keyword,
        attribute::get(0x0018, 0x1145).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfRotationOffset>::s_keyword,
        attribute::get(attribute::Keyword::CenterOfRotationOffset).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewShape>::s_keyword,
        attribute::get(0x0018, 0x1147).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewShape>::s_keyword,
        attribute::get(attribute::Keyword::FieldOfViewShape).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewDimensions>::s_keyword,
        attribute::get(0x0018, 0x1149).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewDimensions>::s_keyword,
        attribute::get(attribute::Keyword::FieldOfViewDimensions).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureTime>::s_keyword,
        attribute::get(0x0018, 0x1150).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureTime>::s_keyword,
        attribute::get(attribute::Keyword::ExposureTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayTubeCurrent>::s_keyword,
        attribute::get(0x0018, 0x1151).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayTubeCurrent>::s_keyword,
        attribute::get(attribute::Keyword::XRayTubeCurrent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Exposure>::s_keyword,
        attribute::get(0x0018, 0x1152).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Exposure>::s_keyword,
        attribute::get(attribute::Keyword::Exposure).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureInuAs>::s_keyword,
        attribute::get(0x0018, 0x1153).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureInuAs>::s_keyword,
        attribute::get(attribute::Keyword::ExposureInuAs).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AveragePulseWidth>::s_keyword,
        attribute::get(0x0018, 0x1154).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AveragePulseWidth>::s_keyword,
        attribute::get(attribute::Keyword::AveragePulseWidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationSetting>::s_keyword,
        attribute::get(0x0018, 0x1155).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationSetting>::s_keyword,
        attribute::get(attribute::Keyword::RadiationSetting).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RectificationType>::s_keyword,
        attribute::get(0x0018, 0x1156).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RectificationType>::s_keyword,
        attribute::get(attribute::Keyword::RectificationType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationMode>::s_keyword,
        attribute::get(0x0018, 0x115A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationMode>::s_keyword,
        attribute::get(attribute::Keyword::RadiationMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageAndFluoroscopyAreaDoseProduct>::s_keyword,
        attribute::get(0x0018, 0x115E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageAndFluoroscopyAreaDoseProduct>::s_keyword,
        attribute::get(attribute::Keyword::ImageAndFluoroscopyAreaDoseProduct).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterType>::s_keyword,
        attribute::get(0x0018, 0x1160).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterType>::s_keyword,
        attribute::get(attribute::Keyword::FilterType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TypeOfFilters>::s_keyword,
        attribute::get(0x0018, 0x1161).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TypeOfFilters>::s_keyword,
        attribute::get(attribute::Keyword::TypeOfFilters).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntensifierSize>::s_keyword,
        attribute::get(0x0018, 0x1162).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntensifierSize>::s_keyword,
        attribute::get(attribute::Keyword::IntensifierSize).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagerPixelSpacing>::s_keyword,
        attribute::get(0x0018, 0x1164).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagerPixelSpacing>::s_keyword,
        attribute::get(attribute::Keyword::ImagerPixelSpacing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Grid>::s_keyword,
        attribute::get(0x0018, 0x1166).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Grid>::s_keyword,
        attribute::get(attribute::Keyword::Grid).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneratorPower>::s_keyword,
        attribute::get(0x0018, 0x1170).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneratorPower>::s_keyword,
        attribute::get(attribute::Keyword::GeneratorPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorGridName>::s_keyword,
        attribute::get(0x0018, 0x1180).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorGridName>::s_keyword,
        attribute::get(attribute::Keyword::CollimatorGridName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorType>::s_keyword,
        attribute::get(0x0018, 0x1181).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorType>::s_keyword,
        attribute::get(attribute::Keyword::CollimatorType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocalDistance>::s_keyword,
        attribute::get(0x0018, 0x1182).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocalDistance>::s_keyword,
        attribute::get(attribute::Keyword::FocalDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XFocusCenter>::s_keyword,
        attribute::get(0x0018, 0x1183).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XFocusCenter>::s_keyword,
        attribute::get(attribute::Keyword::XFocusCenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::YFocusCenter>::s_keyword,
        attribute::get(0x0018, 0x1184).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::YFocusCenter>::s_keyword,
        attribute::get(attribute::Keyword::YFocusCenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocalSpots>::s_keyword,
        attribute::get(0x0018, 0x1190).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocalSpots>::s_keyword,
        attribute::get(attribute::Keyword::FocalSpots).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnodeTargetMaterial>::s_keyword,
        attribute::get(0x0018, 0x1191).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnodeTargetMaterial>::s_keyword,
        attribute::get(attribute::Keyword::AnodeTargetMaterial).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BodyPartThickness>::s_keyword,
        attribute::get(0x0018, 0x11A0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BodyPartThickness>::s_keyword,
        attribute::get(attribute::Keyword::BodyPartThickness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CompressionForce>::s_keyword,
        attribute::get(0x0018, 0x11A2).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CompressionForce>::s_keyword,
        attribute::get(attribute::Keyword::CompressionForce).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CompressionPressure>::s_keyword,
        attribute::get(0x0018, 0x11A3).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CompressionPressure>::s_keyword,
        attribute::get(attribute::Keyword::CompressionPressure).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PaddleDescription>::s_keyword,
        attribute::get(0x0018, 0x11A4).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PaddleDescription>::s_keyword,
        attribute::get(attribute::Keyword::PaddleDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CompressionContactArea>::s_keyword,
        attribute::get(0x0018, 0x11A5).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CompressionContactArea>::s_keyword,
        attribute::get(attribute::Keyword::CompressionContactArea).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateOfLastCalibration>::s_keyword,
        attribute::get(0x0018, 0x1200).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateOfLastCalibration>::s_keyword,
        attribute::get(attribute::Keyword::DateOfLastCalibration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfLastCalibration>::s_keyword,
        attribute::get(0x0018, 0x1201).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfLastCalibration>::s_keyword,
        attribute::get(attribute::Keyword::TimeOfLastCalibration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateOfManufacture>::s_keyword,
        attribute::get(0x0018, 0x1204).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateOfManufacture>::s_keyword,
        attribute::get(attribute::Keyword::DateOfManufacture).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateOfInstallation>::s_keyword,
        attribute::get(0x0018, 0x1205).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateOfInstallation>::s_keyword,
        attribute::get(attribute::Keyword::DateOfInstallation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConvolutionKernel>::s_keyword,
        attribute::get(0x0018, 0x1210).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConvolutionKernel>::s_keyword,
        attribute::get(attribute::Keyword::ConvolutionKernel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ActualFrameDuration>::s_keyword,
        attribute::get(0x0018, 0x1242).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ActualFrameDuration>::s_keyword,
        attribute::get(attribute::Keyword::ActualFrameDuration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CountRate>::s_keyword,
        attribute::get(0x0018, 0x1243).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CountRate>::s_keyword,
        attribute::get(attribute::Keyword::CountRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PreferredPlaybackSequencing>::s_keyword,
        attribute::get(0x0018, 0x1244).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PreferredPlaybackSequencing>::s_keyword,
        attribute::get(attribute::Keyword::PreferredPlaybackSequencing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReceiveCoilName>::s_keyword,
        attribute::get(0x0018, 0x1250).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReceiveCoilName>::s_keyword,
        attribute::get(attribute::Keyword::ReceiveCoilName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransmitCoilName>::s_keyword,
        attribute::get(0x0018, 0x1251).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransmitCoilName>::s_keyword,
        attribute::get(attribute::Keyword::TransmitCoilName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlateType>::s_keyword,
        attribute::get(0x0018, 0x1260).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlateType>::s_keyword,
        attribute::get(attribute::Keyword::PlateType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhosphorType>::s_keyword,
        attribute::get(0x0018, 0x1261).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhosphorType>::s_keyword,
        attribute::get(attribute::Keyword::PhosphorType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WaterEquivalentDiameter>::s_keyword,
        attribute::get(0x0018, 0x1271).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WaterEquivalentDiameter>::s_keyword,
        attribute::get(attribute::Keyword::WaterEquivalentDiameter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WaterEquivalentDiameterCalculationMethodCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x1272).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WaterEquivalentDiameterCalculationMethodCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::WaterEquivalentDiameterCalculationMethodCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanVelocity>::s_keyword,
        attribute::get(0x0018, 0x1300).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanVelocity>::s_keyword,
        attribute::get(attribute::Keyword::ScanVelocity).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WholeBodyTechnique>::s_keyword,
        attribute::get(0x0018, 0x1301).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WholeBodyTechnique>::s_keyword,
        attribute::get(attribute::Keyword::WholeBodyTechnique).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanLength>::s_keyword,
        attribute::get(0x0018, 0x1302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanLength>::s_keyword,
        attribute::get(attribute::Keyword::ScanLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionMatrix>::s_keyword,
        attribute::get(0x0018, 0x1310).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionMatrix>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionMatrix).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InPlanePhaseEncodingDirection>::s_keyword,
        attribute::get(0x0018, 0x1312).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InPlanePhaseEncodingDirection>::s_keyword,
        attribute::get(attribute::Keyword::InPlanePhaseEncodingDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlipAngle>::s_keyword,
        attribute::get(0x0018, 0x1314).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlipAngle>::s_keyword,
        attribute::get(attribute::Keyword::FlipAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VariableFlipAngleFlag>::s_keyword,
        attribute::get(0x0018, 0x1315).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VariableFlipAngleFlag>::s_keyword,
        attribute::get(attribute::Keyword::VariableFlipAngleFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SAR>::s_keyword,
        attribute::get(0x0018, 0x1316).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SAR>::s_keyword,
        attribute::get(attribute::Keyword::SAR).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::dBdt>::s_keyword,
        attribute::get(0x0018, 0x1318).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::dBdt>::s_keyword,
        attribute::get(attribute::Keyword::dBdt).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::B1rms>::s_keyword,
        attribute::get(0x0018, 0x1320).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::B1rms>::s_keyword,
        attribute::get(attribute::Keyword::B1rms).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDeviceProcessingDescription>::s_keyword,
        attribute::get(0x0018, 0x1400).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDeviceProcessingDescription>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionDeviceProcessingDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDeviceProcessingCode>::s_keyword,
        attribute::get(0x0018, 0x1401).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDeviceProcessingCode>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionDeviceProcessingCode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CassetteOrientation>::s_keyword,
        attribute::get(0x0018, 0x1402).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CassetteOrientation>::s_keyword,
        attribute::get(attribute::Keyword::CassetteOrientation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CassetteSize>::s_keyword,
        attribute::get(0x0018, 0x1403).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CassetteSize>::s_keyword,
        attribute::get(attribute::Keyword::CassetteSize).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposuresOnPlate>::s_keyword,
        attribute::get(0x0018, 0x1404).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposuresOnPlate>::s_keyword,
        attribute::get(attribute::Keyword::ExposuresOnPlate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelativeXRayExposure>::s_keyword,
        attribute::get(0x0018, 0x1405).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelativeXRayExposure>::s_keyword,
        attribute::get(attribute::Keyword::RelativeXRayExposure).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureIndex>::s_keyword,
        attribute::get(0x0018, 0x1411).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureIndex>::s_keyword,
        attribute::get(attribute::Keyword::ExposureIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TargetExposureIndex>::s_keyword,
        attribute::get(0x0018, 0x1412).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TargetExposureIndex>::s_keyword,
        attribute::get(attribute::Keyword::TargetExposureIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviationIndex>::s_keyword,
        attribute::get(0x0018, 0x1413).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviationIndex>::s_keyword,
        attribute::get(attribute::Keyword::DeviationIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColumnAngulation>::s_keyword,
        attribute::get(0x0018, 0x1450).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColumnAngulation>::s_keyword,
        attribute::get(attribute::Keyword::ColumnAngulation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TomoLayerHeight>::s_keyword,
        attribute::get(0x0018, 0x1460).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TomoLayerHeight>::s_keyword,
        attribute::get(attribute::Keyword::TomoLayerHeight).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TomoAngle>::s_keyword,
        attribute::get(0x0018, 0x1470).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TomoAngle>::s_keyword,
        attribute::get(attribute::Keyword::TomoAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TomoTime>::s_keyword,
        attribute::get(0x0018, 0x1480).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TomoTime>::s_keyword,
        attribute::get(attribute::Keyword::TomoTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TomoType>::s_keyword,
        attribute::get(0x0018, 0x1490).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TomoType>::s_keyword,
        attribute::get(attribute::Keyword::TomoType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TomoClass>::s_keyword,
        attribute::get(0x0018, 0x1491).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TomoClass>::s_keyword,
        attribute::get(attribute::Keyword::TomoClass).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTomosynthesisSourceImages>::s_keyword,
        attribute::get(0x0018, 0x1495).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTomosynthesisSourceImages>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfTomosynthesisSourceImages).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerMotion>::s_keyword,
        attribute::get(0x0018, 0x1500).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerMotion>::s_keyword,
        attribute::get(attribute::Keyword::PositionerMotion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerType>::s_keyword,
        attribute::get(0x0018, 0x1508).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerType>::s_keyword,
        attribute::get(attribute::Keyword::PositionerType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerPrimaryAngle>::s_keyword,
        attribute::get(0x0018, 0x1510).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerPrimaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::PositionerPrimaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerSecondaryAngle>::s_keyword,
        attribute::get(0x0018, 0x1511).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerSecondaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::PositionerSecondaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerPrimaryAngleIncrement>::s_keyword,
        attribute::get(0x0018, 0x1520).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerPrimaryAngleIncrement>::s_keyword,
        attribute::get(attribute::Keyword::PositionerPrimaryAngleIncrement).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerSecondaryAngleIncrement>::s_keyword,
        attribute::get(0x0018, 0x1521).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerSecondaryAngleIncrement>::s_keyword,
        attribute::get(attribute::Keyword::PositionerSecondaryAngleIncrement).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorPrimaryAngle>::s_keyword,
        attribute::get(0x0018, 0x1530).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorPrimaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::DetectorPrimaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorSecondaryAngle>::s_keyword,
        attribute::get(0x0018, 0x1531).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorSecondaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::DetectorSecondaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterShape>::s_keyword,
        attribute::get(0x0018, 0x1600).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterShape>::s_keyword,
        attribute::get(attribute::Keyword::ShutterShape).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterLeftVerticalEdge>::s_keyword,
        attribute::get(0x0018, 0x1602).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterLeftVerticalEdge>::s_keyword,
        attribute::get(attribute::Keyword::ShutterLeftVerticalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterRightVerticalEdge>::s_keyword,
        attribute::get(0x0018, 0x1604).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterRightVerticalEdge>::s_keyword,
        attribute::get(attribute::Keyword::ShutterRightVerticalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterUpperHorizontalEdge>::s_keyword,
        attribute::get(0x0018, 0x1606).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterUpperHorizontalEdge>::s_keyword,
        attribute::get(attribute::Keyword::ShutterUpperHorizontalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterLowerHorizontalEdge>::s_keyword,
        attribute::get(0x0018, 0x1608).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterLowerHorizontalEdge>::s_keyword,
        attribute::get(attribute::Keyword::ShutterLowerHorizontalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfCircularShutter>::s_keyword,
        attribute::get(0x0018, 0x1610).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfCircularShutter>::s_keyword,
        attribute::get(attribute::Keyword::CenterOfCircularShutter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiusOfCircularShutter>::s_keyword,
        attribute::get(0x0018, 0x1612).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiusOfCircularShutter>::s_keyword,
        attribute::get(attribute::Keyword::RadiusOfCircularShutter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerticesOfThePolygonalShutter>::s_keyword,
        attribute::get(0x0018, 0x1620).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerticesOfThePolygonalShutter>::s_keyword,
        attribute::get(attribute::Keyword::VerticesOfThePolygonalShutter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterPresentationValue>::s_keyword,
        attribute::get(0x0018, 0x1622).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterPresentationValue>::s_keyword,
        attribute::get(attribute::Keyword::ShutterPresentationValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterOverlayGroup>::s_keyword,
        attribute::get(0x0018, 0x1623).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterOverlayGroup>::s_keyword,
        attribute::get(attribute::Keyword::ShutterOverlayGroup).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterPresentationColorCIELabValue>::s_keyword,
        attribute::get(0x0018, 0x1624).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShutterPresentationColorCIELabValue>::s_keyword,
        attribute::get(attribute::Keyword::ShutterPresentationColorCIELabValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutlineShapeType>::s_keyword,
        attribute::get(0x0018, 0x1630).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutlineShapeType>::s_keyword,
        attribute::get(attribute::Keyword::OutlineShapeType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutlineLeftVerticalEdge>::s_keyword,
        attribute::get(0x0018, 0x1631).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutlineLeftVerticalEdge>::s_keyword,
        attribute::get(attribute::Keyword::OutlineLeftVerticalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutlineRightVerticalEdge>::s_keyword,
        attribute::get(0x0018, 0x1632).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutlineRightVerticalEdge>::s_keyword,
        attribute::get(attribute::Keyword::OutlineRightVerticalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutlineUpperHorizontalEdge>::s_keyword,
        attribute::get(0x0018, 0x1633).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutlineUpperHorizontalEdge>::s_keyword,
        attribute::get(attribute::Keyword::OutlineUpperHorizontalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutlineLowerHorizontalEdge>::s_keyword,
        attribute::get(0x0018, 0x1634).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutlineLowerHorizontalEdge>::s_keyword,
        attribute::get(attribute::Keyword::OutlineLowerHorizontalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfCircularOutline>::s_keyword,
        attribute::get(0x0018, 0x1635).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfCircularOutline>::s_keyword,
        attribute::get(attribute::Keyword::CenterOfCircularOutline).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiameterOfCircularOutline>::s_keyword,
        attribute::get(0x0018, 0x1636).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiameterOfCircularOutline>::s_keyword,
        attribute::get(attribute::Keyword::DiameterOfCircularOutline).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfPolygonalVertices>::s_keyword,
        attribute::get(0x0018, 0x1637).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfPolygonalVertices>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfPolygonalVertices).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerticesOfThePolygonalOutline>::s_keyword,
        attribute::get(0x0018, 0x1638).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerticesOfThePolygonalOutline>::s_keyword,
        attribute::get(attribute::Keyword::VerticesOfThePolygonalOutline).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorShape>::s_keyword,
        attribute::get(0x0018, 0x1700).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorShape>::s_keyword,
        attribute::get(attribute::Keyword::CollimatorShape).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorLeftVerticalEdge>::s_keyword,
        attribute::get(0x0018, 0x1702).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorLeftVerticalEdge>::s_keyword,
        attribute::get(attribute::Keyword::CollimatorLeftVerticalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorRightVerticalEdge>::s_keyword,
        attribute::get(0x0018, 0x1704).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorRightVerticalEdge>::s_keyword,
        attribute::get(attribute::Keyword::CollimatorRightVerticalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorUpperHorizontalEdge>::s_keyword,
        attribute::get(0x0018, 0x1706).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorUpperHorizontalEdge>::s_keyword,
        attribute::get(attribute::Keyword::CollimatorUpperHorizontalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorLowerHorizontalEdge>::s_keyword,
        attribute::get(0x0018, 0x1708).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorLowerHorizontalEdge>::s_keyword,
        attribute::get(attribute::Keyword::CollimatorLowerHorizontalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfCircularCollimator>::s_keyword,
        attribute::get(0x0018, 0x1710).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfCircularCollimator>::s_keyword,
        attribute::get(attribute::Keyword::CenterOfCircularCollimator).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiusOfCircularCollimator>::s_keyword,
        attribute::get(0x0018, 0x1712).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiusOfCircularCollimator>::s_keyword,
        attribute::get(attribute::Keyword::RadiusOfCircularCollimator).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerticesOfThePolygonalCollimator>::s_keyword,
        attribute::get(0x0018, 0x1720).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerticesOfThePolygonalCollimator>::s_keyword,
        attribute::get(attribute::Keyword::VerticesOfThePolygonalCollimator).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionTimeSynchronized>::s_keyword,
        attribute::get(0x0018, 0x1800).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionTimeSynchronized>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionTimeSynchronized).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeSource>::s_keyword,
        attribute::get(0x0018, 0x1801).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeSource>::s_keyword,
        attribute::get(attribute::Keyword::TimeSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeDistributionProtocol>::s_keyword,
        attribute::get(0x0018, 0x1802).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeDistributionProtocol>::s_keyword,
        attribute::get(attribute::Keyword::TimeDistributionProtocol).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NTPSourceAddress>::s_keyword,
        attribute::get(0x0018, 0x1803).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NTPSourceAddress>::s_keyword,
        attribute::get(attribute::Keyword::NTPSourceAddress).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PageNumberVector>::s_keyword,
        attribute::get(0x0018, 0x2001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PageNumberVector>::s_keyword,
        attribute::get(attribute::Keyword::PageNumberVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameLabelVector>::s_keyword,
        attribute::get(0x0018, 0x2002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameLabelVector>::s_keyword,
        attribute::get(attribute::Keyword::FrameLabelVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FramePrimaryAngleVector>::s_keyword,
        attribute::get(0x0018, 0x2003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FramePrimaryAngleVector>::s_keyword,
        attribute::get(attribute::Keyword::FramePrimaryAngleVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameSecondaryAngleVector>::s_keyword,
        attribute::get(0x0018, 0x2004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameSecondaryAngleVector>::s_keyword,
        attribute::get(attribute::Keyword::FrameSecondaryAngleVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceLocationVector>::s_keyword,
        attribute::get(0x0018, 0x2005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceLocationVector>::s_keyword,
        attribute::get(attribute::Keyword::SliceLocationVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplayWindowLabelVector>::s_keyword,
        attribute::get(0x0018, 0x2006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplayWindowLabelVector>::s_keyword,
        attribute::get(attribute::Keyword::DisplayWindowLabelVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalScannedPixelSpacing>::s_keyword,
        attribute::get(0x0018, 0x2010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalScannedPixelSpacing>::s_keyword,
        attribute::get(attribute::Keyword::NominalScannedPixelSpacing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitizingDeviceTransportDirection>::s_keyword,
        attribute::get(0x0018, 0x2020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitizingDeviceTransportDirection>::s_keyword,
        attribute::get(attribute::Keyword::DigitizingDeviceTransportDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RotationOfScannedFilm>::s_keyword,
        attribute::get(0x0018, 0x2030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RotationOfScannedFilm>::s_keyword,
        attribute::get(attribute::Keyword::RotationOfScannedFilm).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BiopsyTargetSequence>::s_keyword,
        attribute::get(0x0018, 0x2041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BiopsyTargetSequence>::s_keyword,
        attribute::get(attribute::Keyword::BiopsyTargetSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TargetUID>::s_keyword,
        attribute::get(0x0018, 0x2042).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TargetUID>::s_keyword,
        attribute::get(attribute::Keyword::TargetUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LocalizingCursorPosition>::s_keyword,
        attribute::get(0x0018, 0x2043).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LocalizingCursorPosition>::s_keyword,
        attribute::get(attribute::Keyword::LocalizingCursorPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalculatedTargetPosition>::s_keyword,
        attribute::get(0x0018, 0x2044).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalculatedTargetPosition>::s_keyword,
        attribute::get(attribute::Keyword::CalculatedTargetPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TargetLabel>::s_keyword,
        attribute::get(0x0018, 0x2045).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TargetLabel>::s_keyword,
        attribute::get(attribute::Keyword::TargetLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplayedZValue>::s_keyword,
        attribute::get(0x0018, 0x2046).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplayedZValue>::s_keyword,
        attribute::get(attribute::Keyword::DisplayedZValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IVUSAcquisition>::s_keyword,
        attribute::get(0x0018, 0x3100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IVUSAcquisition>::s_keyword,
        attribute::get(attribute::Keyword::IVUSAcquisition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IVUSPullbackRate>::s_keyword,
        attribute::get(0x0018, 0x3101).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IVUSPullbackRate>::s_keyword,
        attribute::get(attribute::Keyword::IVUSPullbackRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IVUSGatedRate>::s_keyword,
        attribute::get(0x0018, 0x3102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IVUSGatedRate>::s_keyword,
        attribute::get(attribute::Keyword::IVUSGatedRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IVUSPullbackStartFrameNumber>::s_keyword,
        attribute::get(0x0018, 0x3103).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IVUSPullbackStartFrameNumber>::s_keyword,
        attribute::get(attribute::Keyword::IVUSPullbackStartFrameNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IVUSPullbackStopFrameNumber>::s_keyword,
        attribute::get(0x0018, 0x3104).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IVUSPullbackStopFrameNumber>::s_keyword,
        attribute::get(attribute::Keyword::IVUSPullbackStopFrameNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LesionNumber>::s_keyword,
        attribute::get(0x0018, 0x3105).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LesionNumber>::s_keyword,
        attribute::get(attribute::Keyword::LesionNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutputPower>::s_keyword,
        attribute::get(0x0018, 0x5000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OutputPower>::s_keyword,
        attribute::get(attribute::Keyword::OutputPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerData>::s_keyword,
        attribute::get(0x0018, 0x5010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerData>::s_keyword,
        attribute::get(attribute::Keyword::TransducerData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerIdentificationSequence>::s_keyword,
        attribute::get(0x0018, 0x5011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::TransducerIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocusDepth>::s_keyword,
        attribute::get(0x0018, 0x5012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocusDepth>::s_keyword,
        attribute::get(attribute::Keyword::FocusDepth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProcessingFunction>::s_keyword,
        attribute::get(0x0018, 0x5020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProcessingFunction>::s_keyword,
        attribute::get(attribute::Keyword::ProcessingFunction).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MechanicalIndex>::s_keyword,
        attribute::get(0x0018, 0x5022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MechanicalIndex>::s_keyword,
        attribute::get(attribute::Keyword::MechanicalIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BoneThermalIndex>::s_keyword,
        attribute::get(0x0018, 0x5024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BoneThermalIndex>::s_keyword,
        attribute::get(attribute::Keyword::BoneThermalIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CranialThermalIndex>::s_keyword,
        attribute::get(0x0018, 0x5026).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CranialThermalIndex>::s_keyword,
        attribute::get(attribute::Keyword::CranialThermalIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SoftTissueThermalIndex>::s_keyword,
        attribute::get(0x0018, 0x5027).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SoftTissueThermalIndex>::s_keyword,
        attribute::get(attribute::Keyword::SoftTissueThermalIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SoftTissueFocusThermalIndex>::s_keyword,
        attribute::get(0x0018, 0x5028).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SoftTissueFocusThermalIndex>::s_keyword,
        attribute::get(attribute::Keyword::SoftTissueFocusThermalIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SoftTissueSurfaceThermalIndex>::s_keyword,
        attribute::get(0x0018, 0x5029).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SoftTissueSurfaceThermalIndex>::s_keyword,
        attribute::get(attribute::Keyword::SoftTissueSurfaceThermalIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DepthOfScanField>::s_keyword,
        attribute::get(0x0018, 0x5050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DepthOfScanField>::s_keyword,
        attribute::get(attribute::Keyword::DepthOfScanField).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientPosition>::s_keyword,
        attribute::get(0x0018, 0x5100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientPosition>::s_keyword,
        attribute::get(attribute::Keyword::PatientPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewPosition>::s_keyword,
        attribute::get(0x0018, 0x5101).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewPosition>::s_keyword,
        attribute::get(attribute::Keyword::ViewPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProjectionEponymousNameCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x5104).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProjectionEponymousNameCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ProjectionEponymousNameCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Sensitivity>::s_keyword,
        attribute::get(0x0018, 0x6000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Sensitivity>::s_keyword,
        attribute::get(attribute::Keyword::Sensitivity).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SequenceOfUltrasoundRegions>::s_keyword,
        attribute::get(0x0018, 0x6011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SequenceOfUltrasoundRegions>::s_keyword,
        attribute::get(attribute::Keyword::SequenceOfUltrasoundRegions).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionSpatialFormat>::s_keyword,
        attribute::get(0x0018, 0x6012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionSpatialFormat>::s_keyword,
        attribute::get(attribute::Keyword::RegionSpatialFormat).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionDataType>::s_keyword,
        attribute::get(0x0018, 0x6014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionDataType>::s_keyword,
        attribute::get(attribute::Keyword::RegionDataType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionFlags>::s_keyword,
        attribute::get(0x0018, 0x6016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionFlags>::s_keyword,
        attribute::get(attribute::Keyword::RegionFlags).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionLocationMinX0>::s_keyword,
        attribute::get(0x0018, 0x6018).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionLocationMinX0>::s_keyword,
        attribute::get(attribute::Keyword::RegionLocationMinX0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionLocationMinY0>::s_keyword,
        attribute::get(0x0018, 0x601A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionLocationMinY0>::s_keyword,
        attribute::get(attribute::Keyword::RegionLocationMinY0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionLocationMaxX1>::s_keyword,
        attribute::get(0x0018, 0x601C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionLocationMaxX1>::s_keyword,
        attribute::get(attribute::Keyword::RegionLocationMaxX1).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionLocationMaxY1>::s_keyword,
        attribute::get(0x0018, 0x601E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegionLocationMaxY1>::s_keyword,
        attribute::get(attribute::Keyword::RegionLocationMaxY1).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencePixelX0>::s_keyword,
        attribute::get(0x0018, 0x6020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencePixelX0>::s_keyword,
        attribute::get(attribute::Keyword::ReferencePixelX0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencePixelY0>::s_keyword,
        attribute::get(0x0018, 0x6022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencePixelY0>::s_keyword,
        attribute::get(attribute::Keyword::ReferencePixelY0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysicalUnitsXDirection>::s_keyword,
        attribute::get(0x0018, 0x6024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysicalUnitsXDirection>::s_keyword,
        attribute::get(attribute::Keyword::PhysicalUnitsXDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysicalUnitsYDirection>::s_keyword,
        attribute::get(0x0018, 0x6026).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysicalUnitsYDirection>::s_keyword,
        attribute::get(attribute::Keyword::PhysicalUnitsYDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencePixelPhysicalValueX>::s_keyword,
        attribute::get(0x0018, 0x6028).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencePixelPhysicalValueX>::s_keyword,
        attribute::get(attribute::Keyword::ReferencePixelPhysicalValueX).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencePixelPhysicalValueY>::s_keyword,
        attribute::get(0x0018, 0x602A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencePixelPhysicalValueY>::s_keyword,
        attribute::get(attribute::Keyword::ReferencePixelPhysicalValueY).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysicalDeltaX>::s_keyword,
        attribute::get(0x0018, 0x602C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysicalDeltaX>::s_keyword,
        attribute::get(attribute::Keyword::PhysicalDeltaX).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysicalDeltaY>::s_keyword,
        attribute::get(0x0018, 0x602E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysicalDeltaY>::s_keyword,
        attribute::get(attribute::Keyword::PhysicalDeltaY).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerFrequency>::s_keyword,
        attribute::get(0x0018, 0x6030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerFrequency>::s_keyword,
        attribute::get(attribute::Keyword::TransducerFrequency).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerType>::s_keyword,
        attribute::get(0x0018, 0x6031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerType>::s_keyword,
        attribute::get(attribute::Keyword::TransducerType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PulseRepetitionFrequency>::s_keyword,
        attribute::get(0x0018, 0x6032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PulseRepetitionFrequency>::s_keyword,
        attribute::get(attribute::Keyword::PulseRepetitionFrequency).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DopplerCorrectionAngle>::s_keyword,
        attribute::get(0x0018, 0x6034).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DopplerCorrectionAngle>::s_keyword,
        attribute::get(attribute::Keyword::DopplerCorrectionAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SteeringAngle>::s_keyword,
        attribute::get(0x0018, 0x6036).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SteeringAngle>::s_keyword,
        attribute::get(attribute::Keyword::SteeringAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DopplerSampleVolumeXPosition>::s_keyword,
        attribute::get(0x0018, 0x6039).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DopplerSampleVolumeXPosition>::s_keyword,
        attribute::get(attribute::Keyword::DopplerSampleVolumeXPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DopplerSampleVolumeYPosition>::s_keyword,
        attribute::get(0x0018, 0x603B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DopplerSampleVolumeYPosition>::s_keyword,
        attribute::get(attribute::Keyword::DopplerSampleVolumeYPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TMLinePositionX0>::s_keyword,
        attribute::get(0x0018, 0x603D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TMLinePositionX0>::s_keyword,
        attribute::get(attribute::Keyword::TMLinePositionX0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TMLinePositionY0>::s_keyword,
        attribute::get(0x0018, 0x603F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TMLinePositionY0>::s_keyword,
        attribute::get(attribute::Keyword::TMLinePositionY0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TMLinePositionX1>::s_keyword,
        attribute::get(0x0018, 0x6041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TMLinePositionX1>::s_keyword,
        attribute::get(attribute::Keyword::TMLinePositionX1).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TMLinePositionY1>::s_keyword,
        attribute::get(0x0018, 0x6043).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TMLinePositionY1>::s_keyword,
        attribute::get(attribute::Keyword::TMLinePositionY1).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentOrganization>::s_keyword,
        attribute::get(0x0018, 0x6044).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentOrganization>::s_keyword,
        attribute::get(attribute::Keyword::PixelComponentOrganization).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentMask>::s_keyword,
        attribute::get(0x0018, 0x6046).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentMask>::s_keyword,
        attribute::get(attribute::Keyword::PixelComponentMask).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentRangeStart>::s_keyword,
        attribute::get(0x0018, 0x6048).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentRangeStart>::s_keyword,
        attribute::get(attribute::Keyword::PixelComponentRangeStart).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentRangeStop>::s_keyword,
        attribute::get(0x0018, 0x604A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentRangeStop>::s_keyword,
        attribute::get(attribute::Keyword::PixelComponentRangeStop).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentPhysicalUnits>::s_keyword,
        attribute::get(0x0018, 0x604C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentPhysicalUnits>::s_keyword,
        attribute::get(attribute::Keyword::PixelComponentPhysicalUnits).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentDataType>::s_keyword,
        attribute::get(0x0018, 0x604E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelComponentDataType>::s_keyword,
        attribute::get(attribute::Keyword::PixelComponentDataType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTableBreakPoints>::s_keyword,
        attribute::get(0x0018, 0x6050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTableBreakPoints>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfTableBreakPoints).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableOfXBreakPoints>::s_keyword,
        attribute::get(0x0018, 0x6052).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableOfXBreakPoints>::s_keyword,
        attribute::get(attribute::Keyword::TableOfXBreakPoints).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableOfYBreakPoints>::s_keyword,
        attribute::get(0x0018, 0x6054).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableOfYBreakPoints>::s_keyword,
        attribute::get(attribute::Keyword::TableOfYBreakPoints).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTableEntries>::s_keyword,
        attribute::get(0x0018, 0x6056).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTableEntries>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfTableEntries).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableOfPixelValues>::s_keyword,
        attribute::get(0x0018, 0x6058).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableOfPixelValues>::s_keyword,
        attribute::get(attribute::Keyword::TableOfPixelValues).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableOfParameterValues>::s_keyword,
        attribute::get(0x0018, 0x605A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableOfParameterValues>::s_keyword,
        attribute::get(attribute::Keyword::TableOfParameterValues).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RWaveTimeVector>::s_keyword,
        attribute::get(0x0018, 0x6060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RWaveTimeVector>::s_keyword,
        attribute::get(attribute::Keyword::RWaveTimeVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ActiveImageAreaOverlayGroup>::s_keyword,
        attribute::get(0x0018, 0x6070).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ActiveImageAreaOverlayGroup>::s_keyword,
        attribute::get(attribute::Keyword::ActiveImageAreaOverlayGroup).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorConditionsNominalFlag>::s_keyword,
        attribute::get(0x0018, 0x7000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorConditionsNominalFlag>::s_keyword,
        attribute::get(attribute::Keyword::DetectorConditionsNominalFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorTemperature>::s_keyword,
        attribute::get(0x0018, 0x7001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorTemperature>::s_keyword,
        attribute::get(attribute::Keyword::DetectorTemperature).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorType>::s_keyword,
        attribute::get(0x0018, 0x7004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorType>::s_keyword,
        attribute::get(attribute::Keyword::DetectorType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorConfiguration>::s_keyword,
        attribute::get(0x0018, 0x7005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorConfiguration>::s_keyword,
        attribute::get(attribute::Keyword::DetectorConfiguration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorDescription>::s_keyword,
        attribute::get(0x0018, 0x7006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorDescription>::s_keyword,
        attribute::get(attribute::Keyword::DetectorDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorMode>::s_keyword,
        attribute::get(0x0018, 0x7008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorMode>::s_keyword,
        attribute::get(attribute::Keyword::DetectorMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorID>::s_keyword,
        attribute::get(0x0018, 0x700A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorID>::s_keyword,
        attribute::get(attribute::Keyword::DetectorID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateOfLastDetectorCalibration>::s_keyword,
        attribute::get(0x0018, 0x700C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateOfLastDetectorCalibration>::s_keyword,
        attribute::get(attribute::Keyword::DateOfLastDetectorCalibration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfLastDetectorCalibration>::s_keyword,
        attribute::get(0x0018, 0x700E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfLastDetectorCalibration>::s_keyword,
        attribute::get(attribute::Keyword::TimeOfLastDetectorCalibration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposuresOnDetectorSinceLastCalibration>::s_keyword,
        attribute::get(0x0018, 0x7010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposuresOnDetectorSinceLastCalibration>::s_keyword,
        attribute::get(attribute::Keyword::ExposuresOnDetectorSinceLastCalibration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposuresOnDetectorSinceManufactured>::s_keyword,
        attribute::get(0x0018, 0x7011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposuresOnDetectorSinceManufactured>::s_keyword,
        attribute::get(attribute::Keyword::ExposuresOnDetectorSinceManufactured).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorTimeSinceLastExposure>::s_keyword,
        attribute::get(0x0018, 0x7012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorTimeSinceLastExposure>::s_keyword,
        attribute::get(attribute::Keyword::DetectorTimeSinceLastExposure).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveTime>::s_keyword,
        attribute::get(0x0018, 0x7014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveTime>::s_keyword,
        attribute::get(attribute::Keyword::DetectorActiveTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActivationOffsetFromExposure>::s_keyword,
        attribute::get(0x0018, 0x7016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActivationOffsetFromExposure>::s_keyword,
        attribute::get(attribute::Keyword::DetectorActivationOffsetFromExposure).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorBinning>::s_keyword,
        attribute::get(0x0018, 0x701A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorBinning>::s_keyword,
        attribute::get(attribute::Keyword::DetectorBinning).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorElementPhysicalSize>::s_keyword,
        attribute::get(0x0018, 0x7020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorElementPhysicalSize>::s_keyword,
        attribute::get(attribute::Keyword::DetectorElementPhysicalSize).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorElementSpacing>::s_keyword,
        attribute::get(0x0018, 0x7022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorElementSpacing>::s_keyword,
        attribute::get(attribute::Keyword::DetectorElementSpacing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveShape>::s_keyword,
        attribute::get(0x0018, 0x7024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveShape>::s_keyword,
        attribute::get(attribute::Keyword::DetectorActiveShape).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveDimensions>::s_keyword,
        attribute::get(0x0018, 0x7026).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveDimensions>::s_keyword,
        attribute::get(attribute::Keyword::DetectorActiveDimensions).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveOrigin>::s_keyword,
        attribute::get(0x0018, 0x7028).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveOrigin>::s_keyword,
        attribute::get(attribute::Keyword::DetectorActiveOrigin).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorManufacturerName>::s_keyword,
        attribute::get(0x0018, 0x702A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorManufacturerName>::s_keyword,
        attribute::get(attribute::Keyword::DetectorManufacturerName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorManufacturerModelName>::s_keyword,
        attribute::get(0x0018, 0x702B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorManufacturerModelName>::s_keyword,
        attribute::get(attribute::Keyword::DetectorManufacturerModelName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewOrigin>::s_keyword,
        attribute::get(0x0018, 0x7030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewOrigin>::s_keyword,
        attribute::get(attribute::Keyword::FieldOfViewOrigin).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewRotation>::s_keyword,
        attribute::get(0x0018, 0x7032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewRotation>::s_keyword,
        attribute::get(attribute::Keyword::FieldOfViewRotation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewHorizontalFlip>::s_keyword,
        attribute::get(0x0018, 0x7034).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewHorizontalFlip>::s_keyword,
        attribute::get(attribute::Keyword::FieldOfViewHorizontalFlip).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelDataAreaOriginRelativeToFOV>::s_keyword,
        attribute::get(0x0018, 0x7036).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelDataAreaOriginRelativeToFOV>::s_keyword,
        attribute::get(attribute::Keyword::PixelDataAreaOriginRelativeToFOV).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelDataAreaRotationAngleRelativeToFOV>::s_keyword,
        attribute::get(0x0018, 0x7038).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelDataAreaRotationAngleRelativeToFOV>::s_keyword,
        attribute::get(attribute::Keyword::PixelDataAreaRotationAngleRelativeToFOV).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridAbsorbingMaterial>::s_keyword,
        attribute::get(0x0018, 0x7040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridAbsorbingMaterial>::s_keyword,
        attribute::get(attribute::Keyword::GridAbsorbingMaterial).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridSpacingMaterial>::s_keyword,
        attribute::get(0x0018, 0x7041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridSpacingMaterial>::s_keyword,
        attribute::get(attribute::Keyword::GridSpacingMaterial).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridThickness>::s_keyword,
        attribute::get(0x0018, 0x7042).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridThickness>::s_keyword,
        attribute::get(attribute::Keyword::GridThickness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridPitch>::s_keyword,
        attribute::get(0x0018, 0x7044).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridPitch>::s_keyword,
        attribute::get(attribute::Keyword::GridPitch).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridAspectRatio>::s_keyword,
        attribute::get(0x0018, 0x7046).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridAspectRatio>::s_keyword,
        attribute::get(attribute::Keyword::GridAspectRatio).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridPeriod>::s_keyword,
        attribute::get(0x0018, 0x7048).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridPeriod>::s_keyword,
        attribute::get(attribute::Keyword::GridPeriod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridFocalDistance>::s_keyword,
        attribute::get(0x0018, 0x704C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridFocalDistance>::s_keyword,
        attribute::get(attribute::Keyword::GridFocalDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterMaterial>::s_keyword,
        attribute::get(0x0018, 0x7050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterMaterial>::s_keyword,
        attribute::get(attribute::Keyword::FilterMaterial).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterThicknessMinimum>::s_keyword,
        attribute::get(0x0018, 0x7052).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterThicknessMinimum>::s_keyword,
        attribute::get(attribute::Keyword::FilterThicknessMinimum).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterThicknessMaximum>::s_keyword,
        attribute::get(0x0018, 0x7054).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterThicknessMaximum>::s_keyword,
        attribute::get(attribute::Keyword::FilterThicknessMaximum).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterBeamPathLengthMinimum>::s_keyword,
        attribute::get(0x0018, 0x7056).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterBeamPathLengthMinimum>::s_keyword,
        attribute::get(attribute::Keyword::FilterBeamPathLengthMinimum).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterBeamPathLengthMaximum>::s_keyword,
        attribute::get(0x0018, 0x7058).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FilterBeamPathLengthMaximum>::s_keyword,
        attribute::get(attribute::Keyword::FilterBeamPathLengthMaximum).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlMode>::s_keyword,
        attribute::get(0x0018, 0x7060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlMode>::s_keyword,
        attribute::get(attribute::Keyword::ExposureControlMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlModeDescription>::s_keyword,
        attribute::get(0x0018, 0x7062).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlModeDescription>::s_keyword,
        attribute::get(attribute::Keyword::ExposureControlModeDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureStatus>::s_keyword,
        attribute::get(0x0018, 0x7064).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureStatus>::s_keyword,
        attribute::get(attribute::Keyword::ExposureStatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhototimerSetting>::s_keyword,
        attribute::get(0x0018, 0x7065).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhototimerSetting>::s_keyword,
        attribute::get(attribute::Keyword::PhototimerSetting).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureTimeInuS>::s_keyword,
        attribute::get(0x0018, 0x8150).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureTimeInuS>::s_keyword,
        attribute::get(attribute::Keyword::ExposureTimeInuS).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayTubeCurrentInuA>::s_keyword,
        attribute::get(0x0018, 0x8151).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayTubeCurrentInuA>::s_keyword,
        attribute::get(attribute::Keyword::XRayTubeCurrentInuA).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentQualification>::s_keyword,
        attribute::get(0x0018, 0x9004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentQualification>::s_keyword,
        attribute::get(attribute::Keyword::ContentQualification).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PulseSequenceName>::s_keyword,
        attribute::get(0x0018, 0x9005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PulseSequenceName>::s_keyword,
        attribute::get(attribute::Keyword::PulseSequenceName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRImagingModifierSequence>::s_keyword,
        attribute::get(0x0018, 0x9006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRImagingModifierSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRImagingModifierSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EchoPulseSequence>::s_keyword,
        attribute::get(0x0018, 0x9008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EchoPulseSequence>::s_keyword,
        attribute::get(attribute::Keyword::EchoPulseSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InversionRecovery>::s_keyword,
        attribute::get(0x0018, 0x9009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InversionRecovery>::s_keyword,
        attribute::get(attribute::Keyword::InversionRecovery).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlowCompensation>::s_keyword,
        attribute::get(0x0018, 0x9010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlowCompensation>::s_keyword,
        attribute::get(attribute::Keyword::FlowCompensation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultipleSpinEcho>::s_keyword,
        attribute::get(0x0018, 0x9011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultipleSpinEcho>::s_keyword,
        attribute::get(attribute::Keyword::MultipleSpinEcho).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultiPlanarExcitation>::s_keyword,
        attribute::get(0x0018, 0x9012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultiPlanarExcitation>::s_keyword,
        attribute::get(attribute::Keyword::MultiPlanarExcitation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhaseContrast>::s_keyword,
        attribute::get(0x0018, 0x9014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhaseContrast>::s_keyword,
        attribute::get(attribute::Keyword::PhaseContrast).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfFlightContrast>::s_keyword,
        attribute::get(0x0018, 0x9015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfFlightContrast>::s_keyword,
        attribute::get(attribute::Keyword::TimeOfFlightContrast).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Spoiling>::s_keyword,
        attribute::get(0x0018, 0x9016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Spoiling>::s_keyword,
        attribute::get(attribute::Keyword::Spoiling).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SteadyStatePulseSequence>::s_keyword,
        attribute::get(0x0018, 0x9017).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SteadyStatePulseSequence>::s_keyword,
        attribute::get(attribute::Keyword::SteadyStatePulseSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EchoPlanarPulseSequence>::s_keyword,
        attribute::get(0x0018, 0x9018).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EchoPlanarPulseSequence>::s_keyword,
        attribute::get(attribute::Keyword::EchoPlanarPulseSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TagAngleFirstAxis>::s_keyword,
        attribute::get(0x0018, 0x9019).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TagAngleFirstAxis>::s_keyword,
        attribute::get(attribute::Keyword::TagAngleFirstAxis).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MagnetizationTransfer>::s_keyword,
        attribute::get(0x0018, 0x9020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MagnetizationTransfer>::s_keyword,
        attribute::get(attribute::Keyword::MagnetizationTransfer).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::T2Preparation>::s_keyword,
        attribute::get(0x0018, 0x9021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::T2Preparation>::s_keyword,
        attribute::get(attribute::Keyword::T2Preparation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BloodSignalNulling>::s_keyword,
        attribute::get(0x0018, 0x9022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BloodSignalNulling>::s_keyword,
        attribute::get(attribute::Keyword::BloodSignalNulling).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SaturationRecovery>::s_keyword,
        attribute::get(0x0018, 0x9024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SaturationRecovery>::s_keyword,
        attribute::get(attribute::Keyword::SaturationRecovery).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpectrallySelectedSuppression>::s_keyword,
        attribute::get(0x0018, 0x9025).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpectrallySelectedSuppression>::s_keyword,
        attribute::get(attribute::Keyword::SpectrallySelectedSuppression).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpectrallySelectedExcitation>::s_keyword,
        attribute::get(0x0018, 0x9026).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpectrallySelectedExcitation>::s_keyword,
        attribute::get(attribute::Keyword::SpectrallySelectedExcitation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialPresaturation>::s_keyword,
        attribute::get(0x0018, 0x9027).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialPresaturation>::s_keyword,
        attribute::get(attribute::Keyword::SpatialPresaturation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Tagging>::s_keyword,
        attribute::get(0x0018, 0x9028).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Tagging>::s_keyword,
        attribute::get(attribute::Keyword::Tagging).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OversamplingPhase>::s_keyword,
        attribute::get(0x0018, 0x9029).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OversamplingPhase>::s_keyword,
        attribute::get(attribute::Keyword::OversamplingPhase).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TagSpacingFirstDimension>::s_keyword,
        attribute::get(0x0018, 0x9030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TagSpacingFirstDimension>::s_keyword,
        attribute::get(attribute::Keyword::TagSpacingFirstDimension).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeometryOfKSpaceTraversal>::s_keyword,
        attribute::get(0x0018, 0x9032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeometryOfKSpaceTraversal>::s_keyword,
        attribute::get(attribute::Keyword::GeometryOfKSpaceTraversal).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedKSpaceTraversal>::s_keyword,
        attribute::get(0x0018, 0x9033).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedKSpaceTraversal>::s_keyword,
        attribute::get(attribute::Keyword::SegmentedKSpaceTraversal).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RectilinearPhaseEncodeReordering>::s_keyword,
        attribute::get(0x0018, 0x9034).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RectilinearPhaseEncodeReordering>::s_keyword,
        attribute::get(attribute::Keyword::RectilinearPhaseEncodeReordering).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TagThickness>::s_keyword,
        attribute::get(0x0018, 0x9035).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TagThickness>::s_keyword,
        attribute::get(attribute::Keyword::TagThickness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PartialFourierDirection>::s_keyword,
        attribute::get(0x0018, 0x9036).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PartialFourierDirection>::s_keyword,
        attribute::get(attribute::Keyword::PartialFourierDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacSynchronizationTechnique>::s_keyword,
        attribute::get(0x0018, 0x9037).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacSynchronizationTechnique>::s_keyword,
        attribute::get(attribute::Keyword::CardiacSynchronizationTechnique).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReceiveCoilManufacturerName>::s_keyword,
        attribute::get(0x0018, 0x9041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReceiveCoilManufacturerName>::s_keyword,
        attribute::get(attribute::Keyword::ReceiveCoilManufacturerName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRReceiveCoilSequence>::s_keyword,
        attribute::get(0x0018, 0x9042).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRReceiveCoilSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRReceiveCoilSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReceiveCoilType>::s_keyword,
        attribute::get(0x0018, 0x9043).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReceiveCoilType>::s_keyword,
        attribute::get(attribute::Keyword::ReceiveCoilType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QuadratureReceiveCoil>::s_keyword,
        attribute::get(0x0018, 0x9044).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QuadratureReceiveCoil>::s_keyword,
        attribute::get(attribute::Keyword::QuadratureReceiveCoil).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultiCoilDefinitionSequence>::s_keyword,
        attribute::get(0x0018, 0x9045).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultiCoilDefinitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::MultiCoilDefinitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultiCoilConfiguration>::s_keyword,
        attribute::get(0x0018, 0x9046).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultiCoilConfiguration>::s_keyword,
        attribute::get(attribute::Keyword::MultiCoilConfiguration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRTransmitCoilSequence>::s_keyword,
        attribute::get(0x0018, 0x9049).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRTransmitCoilSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRTransmitCoilSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransmitCoilManufacturerName>::s_keyword,
        attribute::get(0x0018, 0x9050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransmitCoilManufacturerName>::s_keyword,
        attribute::get(attribute::Keyword::TransmitCoilManufacturerName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransmitCoilType>::s_keyword,
        attribute::get(0x0018, 0x9051).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransmitCoilType>::s_keyword,
        attribute::get(attribute::Keyword::TransmitCoilType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRAcquisitionFrequencyEncodingSteps>::s_keyword,
        attribute::get(0x0018, 0x9058).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRAcquisitionFrequencyEncodingSteps>::s_keyword,
        attribute::get(attribute::Keyword::MRAcquisitionFrequencyEncodingSteps).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::KSpaceFiltering>::s_keyword,
        attribute::get(0x0018, 0x9064).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::KSpaceFiltering>::s_keyword,
        attribute::get(attribute::Keyword::KSpaceFiltering).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelReductionFactorInPlane>::s_keyword,
        attribute::get(0x0018, 0x9069).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelReductionFactorInPlane>::s_keyword,
        attribute::get(attribute::Keyword::ParallelReductionFactorInPlane).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacRRIntervalSpecified>::s_keyword,
        attribute::get(0x0018, 0x9070).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacRRIntervalSpecified>::s_keyword,
        attribute::get(attribute::Keyword::CardiacRRIntervalSpecified).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDuration>::s_keyword,
        attribute::get(0x0018, 0x9073).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDuration>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionDuration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameAcquisitionDateTime>::s_keyword,
        attribute::get(0x0018, 0x9074).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameAcquisitionDateTime>::s_keyword,
        attribute::get(attribute::Keyword::FrameAcquisitionDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiffusionDirectionality>::s_keyword,
        attribute::get(0x0018, 0x9075).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiffusionDirectionality>::s_keyword,
        attribute::get(attribute::Keyword::DiffusionDirectionality).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiffusionGradientDirectionSequence>::s_keyword,
        attribute::get(0x0018, 0x9076).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiffusionGradientDirectionSequence>::s_keyword,
        attribute::get(attribute::Keyword::DiffusionGradientDirectionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelAcquisition>::s_keyword,
        attribute::get(0x0018, 0x9077).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelAcquisition>::s_keyword,
        attribute::get(attribute::Keyword::ParallelAcquisition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelAcquisitionTechnique>::s_keyword,
        attribute::get(0x0018, 0x9078).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelAcquisitionTechnique>::s_keyword,
        attribute::get(attribute::Keyword::ParallelAcquisitionTechnique).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InversionTimes>::s_keyword,
        attribute::get(0x0018, 0x9079).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InversionTimes>::s_keyword,
        attribute::get(attribute::Keyword::InversionTimes).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MetaboliteMapDescription>::s_keyword,
        attribute::get(0x0018, 0x9080).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MetaboliteMapDescription>::s_keyword,
        attribute::get(attribute::Keyword::MetaboliteMapDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PartialFourier>::s_keyword,
        attribute::get(0x0018, 0x9081).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PartialFourier>::s_keyword,
        attribute::get(attribute::Keyword::PartialFourier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EffectiveEchoTime>::s_keyword,
        attribute::get(0x0018, 0x9082).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EffectiveEchoTime>::s_keyword,
        attribute::get(attribute::Keyword::EffectiveEchoTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MetaboliteMapCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x9083).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MetaboliteMapCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::MetaboliteMapCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ChemicalShiftSequence>::s_keyword,
        attribute::get(0x0018, 0x9084).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ChemicalShiftSequence>::s_keyword,
        attribute::get(attribute::Keyword::ChemicalShiftSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacSignalSource>::s_keyword,
        attribute::get(0x0018, 0x9085).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacSignalSource>::s_keyword,
        attribute::get(attribute::Keyword::CardiacSignalSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiffusionBValue>::s_keyword,
        attribute::get(0x0018, 0x9087).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiffusionBValue>::s_keyword,
        attribute::get(attribute::Keyword::DiffusionBValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VelocityEncodingDirection>::s_keyword,
        attribute::get(0x0018, 0x9090).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VelocityEncodingDirection>::s_keyword,
        attribute::get(attribute::Keyword::VelocityEncodingDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VelocityEncodingMinimumValue>::s_keyword,
        attribute::get(0x0018, 0x9091).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VelocityEncodingMinimumValue>::s_keyword,
        attribute::get(attribute::Keyword::VelocityEncodingMinimumValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VelocityEncodingAcquisitionSequence>::s_keyword,
        attribute::get(0x0018, 0x9092).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VelocityEncodingAcquisitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::VelocityEncodingAcquisitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfKSpaceTrajectories>::s_keyword,
        attribute::get(0x0018, 0x9093).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfKSpaceTrajectories>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfKSpaceTrajectories).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CoverageOfKSpace>::s_keyword,
        attribute::get(0x0018, 0x9094).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CoverageOfKSpace>::s_keyword,
        attribute::get(attribute::Keyword::CoverageOfKSpace).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransmitterFrequency>::s_keyword,
        attribute::get(0x0018, 0x9098).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransmitterFrequency>::s_keyword,
        attribute::get(attribute::Keyword::TransmitterFrequency).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ResonantNucleus>::s_keyword,
        attribute::get(0x0018, 0x9100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ResonantNucleus>::s_keyword,
        attribute::get(attribute::Keyword::ResonantNucleus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SlabThickness>::s_keyword,
        attribute::get(0x0018, 0x9104).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SlabThickness>::s_keyword,
        attribute::get(attribute::Keyword::SlabThickness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SlabOrientation>::s_keyword,
        attribute::get(0x0018, 0x9105).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SlabOrientation>::s_keyword,
        attribute::get(attribute::Keyword::SlabOrientation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MidSlabPosition>::s_keyword,
        attribute::get(0x0018, 0x9106).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MidSlabPosition>::s_keyword,
        attribute::get(attribute::Keyword::MidSlabPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRSpatialSaturationSequence>::s_keyword,
        attribute::get(0x0018, 0x9107).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRSpatialSaturationSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRSpatialSaturationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRTimingAndRelatedParametersSequence>::s_keyword,
        attribute::get(0x0018, 0x9112).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRTimingAndRelatedParametersSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRTimingAndRelatedParametersSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MREchoSequence>::s_keyword,
        attribute::get(0x0018, 0x9114).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MREchoSequence>::s_keyword,
        attribute::get(attribute::Keyword::MREchoSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRModifierSequence>::s_keyword,
        attribute::get(0x0018, 0x9115).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRModifierSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRModifierSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRDiffusionSequence>::s_keyword,
        attribute::get(0x0018, 0x9117).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRDiffusionSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRDiffusionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacSynchronizationSequence>::s_keyword,
        attribute::get(0x0018, 0x9118).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacSynchronizationSequence>::s_keyword,
        attribute::get(attribute::Keyword::CardiacSynchronizationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRAveragesSequence>::s_keyword,
        attribute::get(0x0018, 0x9119).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRAveragesSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRAveragesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRFOVGeometrySequence>::s_keyword,
        attribute::get(0x0018, 0x9125).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRFOVGeometrySequence>::s_keyword,
        attribute::get(attribute::Keyword::MRFOVGeometrySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiffusionAnisotropyType>::s_keyword,
        attribute::get(0x0018, 0x9147).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiffusionAnisotropyType>::s_keyword,
        attribute::get(attribute::Keyword::DiffusionAnisotropyType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameReferenceDateTime>::s_keyword,
        attribute::get(0x0018, 0x9151).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameReferenceDateTime>::s_keyword,
        attribute::get(attribute::Keyword::FrameReferenceDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRMetaboliteMapSequence>::s_keyword,
        attribute::get(0x0018, 0x9152).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRMetaboliteMapSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRMetaboliteMapSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelReductionFactorOutOfPlane>::s_keyword,
        attribute::get(0x0018, 0x9155).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelReductionFactorOutOfPlane>::s_keyword,
        attribute::get(attribute::Keyword::ParallelReductionFactorOutOfPlane).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelReductionFactorSecondInPlane>::s_keyword,
        attribute::get(0x0018, 0x9168).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelReductionFactorSecondInPlane>::s_keyword,
        attribute::get(attribute::Keyword::ParallelReductionFactorSecondInPlane).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacBeatRejectionTechnique>::s_keyword,
        attribute::get(0x0018, 0x9169).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacBeatRejectionTechnique>::s_keyword,
        attribute::get(attribute::Keyword::CardiacBeatRejectionTechnique).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratoryMotionCompensationTechnique>::s_keyword,
        attribute::get(0x0018, 0x9170).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratoryMotionCompensationTechnique>::s_keyword,
        attribute::get(attribute::Keyword::RespiratoryMotionCompensationTechnique).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratorySignalSource>::s_keyword,
        attribute::get(0x0018, 0x9171).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratorySignalSource>::s_keyword,
        attribute::get(attribute::Keyword::RespiratorySignalSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BulkMotionCompensationTechnique>::s_keyword,
        attribute::get(0x0018, 0x9172).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BulkMotionCompensationTechnique>::s_keyword,
        attribute::get(attribute::Keyword::BulkMotionCompensationTechnique).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BulkMotionSignalSource>::s_keyword,
        attribute::get(0x0018, 0x9173).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BulkMotionSignalSource>::s_keyword,
        attribute::get(attribute::Keyword::BulkMotionSignalSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicableSafetyStandardAgency>::s_keyword,
        attribute::get(0x0018, 0x9174).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicableSafetyStandardAgency>::s_keyword,
        attribute::get(attribute::Keyword::ApplicableSafetyStandardAgency).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicableSafetyStandardDescription>::s_keyword,
        attribute::get(0x0018, 0x9175).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicableSafetyStandardDescription>::s_keyword,
        attribute::get(attribute::Keyword::ApplicableSafetyStandardDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OperatingModeSequence>::s_keyword,
        attribute::get(0x0018, 0x9176).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OperatingModeSequence>::s_keyword,
        attribute::get(attribute::Keyword::OperatingModeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GradientOutputType>::s_keyword,
        attribute::get(0x0018, 0x9180).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GradientOutputType>::s_keyword,
        attribute::get(attribute::Keyword::GradientOutputType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GradientOutput>::s_keyword,
        attribute::get(0x0018, 0x9182).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GradientOutput>::s_keyword,
        attribute::get(attribute::Keyword::GradientOutput).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlowCompensationDirection>::s_keyword,
        attribute::get(0x0018, 0x9183).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlowCompensationDirection>::s_keyword,
        attribute::get(attribute::Keyword::FlowCompensationDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TaggingDelay>::s_keyword,
        attribute::get(0x0018, 0x9184).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TaggingDelay>::s_keyword,
        attribute::get(attribute::Keyword::TaggingDelay).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRVelocityEncodingSequence>::s_keyword,
        attribute::get(0x0018, 0x9197).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRVelocityEncodingSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRVelocityEncodingSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratoryCyclePosition>::s_keyword,
        attribute::get(0x0018, 0x9214).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratoryCyclePosition>::s_keyword,
        attribute::get(attribute::Keyword::RespiratoryCyclePosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VelocityEncodingMaximumValue>::s_keyword,
        attribute::get(0x0018, 0x9217).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VelocityEncodingMaximumValue>::s_keyword,
        attribute::get(attribute::Keyword::VelocityEncodingMaximumValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TagSpacingSecondDimension>::s_keyword,
        attribute::get(0x0018, 0x9218).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TagSpacingSecondDimension>::s_keyword,
        attribute::get(attribute::Keyword::TagSpacingSecondDimension).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TagAngleSecondAxis>::s_keyword,
        attribute::get(0x0018, 0x9219).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TagAngleSecondAxis>::s_keyword,
        attribute::get(attribute::Keyword::TagAngleSecondAxis).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameAcquisitionDuration>::s_keyword,
        attribute::get(0x0018, 0x9220).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameAcquisitionDuration>::s_keyword,
        attribute::get(attribute::Keyword::FrameAcquisitionDuration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRImageFrameTypeSequence>::s_keyword,
        attribute::get(0x0018, 0x9226).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRImageFrameTypeSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRImageFrameTypeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRAcquisitionPhaseEncodingStepsInPlane>::s_keyword,
        attribute::get(0x0018, 0x9231).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRAcquisitionPhaseEncodingStepsInPlane>::s_keyword,
        attribute::get(attribute::Keyword::MRAcquisitionPhaseEncodingStepsInPlane).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRAcquisitionPhaseEncodingStepsOutOfPlane>::s_keyword,
        attribute::get(0x0018, 0x9232).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRAcquisitionPhaseEncodingStepsOutOfPlane>::s_keyword,
        attribute::get(attribute::Keyword::MRAcquisitionPhaseEncodingStepsOutOfPlane).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacCyclePosition>::s_keyword,
        attribute::get(0x0018, 0x9236).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CardiacCyclePosition>::s_keyword,
        attribute::get(attribute::Keyword::CardiacCyclePosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecificAbsorptionRateSequence>::s_keyword,
        attribute::get(0x0018, 0x9239).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecificAbsorptionRateSequence>::s_keyword,
        attribute::get(attribute::Keyword::SpecificAbsorptionRateSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RFEchoTrainLength>::s_keyword,
        attribute::get(0x0018, 0x9240).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RFEchoTrainLength>::s_keyword,
        attribute::get(attribute::Keyword::RFEchoTrainLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GradientEchoTrainLength>::s_keyword,
        attribute::get(0x0018, 0x9241).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GradientEchoTrainLength>::s_keyword,
        attribute::get(attribute::Keyword::GradientEchoTrainLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ArterialSpinLabelingContrast>::s_keyword,
        attribute::get(0x0018, 0x9250).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ArterialSpinLabelingContrast>::s_keyword,
        attribute::get(attribute::Keyword::ArterialSpinLabelingContrast).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRArterialSpinLabelingSequence>::s_keyword,
        attribute::get(0x0018, 0x9251).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MRArterialSpinLabelingSequence>::s_keyword,
        attribute::get(attribute::Keyword::MRArterialSpinLabelingSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLTechniqueDescription>::s_keyword,
        attribute::get(0x0018, 0x9252).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLTechniqueDescription>::s_keyword,
        attribute::get(attribute::Keyword::ASLTechniqueDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLContext>::s_keyword,
        attribute::get(0x0018, 0x9257).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLContext>::s_keyword,
        attribute::get(attribute::Keyword::ASLContext).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLCrusherFlag>::s_keyword,
        attribute::get(0x0018, 0x9259).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLCrusherFlag>::s_keyword,
        attribute::get(attribute::Keyword::ASLCrusherFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLCrusherFlowLimit>::s_keyword,
        attribute::get(0x0018, 0x925A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLCrusherFlowLimit>::s_keyword,
        attribute::get(attribute::Keyword::ASLCrusherFlowLimit).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLCrusherDescription>::s_keyword,
        attribute::get(0x0018, 0x925B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLCrusherDescription>::s_keyword,
        attribute::get(attribute::Keyword::ASLCrusherDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLBolusCutoffFlag>::s_keyword,
        attribute::get(0x0018, 0x925C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLBolusCutoffFlag>::s_keyword,
        attribute::get(attribute::Keyword::ASLBolusCutoffFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLBolusCutoffTimingSequence>::s_keyword,
        attribute::get(0x0018, 0x925D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLBolusCutoffTimingSequence>::s_keyword,
        attribute::get(attribute::Keyword::ASLBolusCutoffTimingSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLSlabSequence>::s_keyword,
        attribute::get(0x0018, 0x9260).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ASLSlabSequence>::s_keyword,
        attribute::get(attribute::Keyword::ASLSlabSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTAcquisitionTypeSequence>::s_keyword,
        attribute::get(0x0018, 0x9301).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTAcquisitionTypeSequence>::s_keyword,
        attribute::get(attribute::Keyword::CTAcquisitionTypeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionType>::s_keyword,
        attribute::get(0x0018, 0x9302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionType>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TubeAngle>::s_keyword,
        attribute::get(0x0018, 0x9303).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TubeAngle>::s_keyword,
        attribute::get(attribute::Keyword::TubeAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTAcquisitionDetailsSequence>::s_keyword,
        attribute::get(0x0018, 0x9304).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTAcquisitionDetailsSequence>::s_keyword,
        attribute::get(attribute::Keyword::CTAcquisitionDetailsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RevolutionTime>::s_keyword,
        attribute::get(0x0018, 0x9305).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RevolutionTime>::s_keyword,
        attribute::get(attribute::Keyword::RevolutionTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SingleCollimationWidth>::s_keyword,
        attribute::get(0x0018, 0x9306).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SingleCollimationWidth>::s_keyword,
        attribute::get(attribute::Keyword::SingleCollimationWidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TotalCollimationWidth>::s_keyword,
        attribute::get(0x0018, 0x9307).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TotalCollimationWidth>::s_keyword,
        attribute::get(attribute::Keyword::TotalCollimationWidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTTableDynamicsSequence>::s_keyword,
        attribute::get(0x0018, 0x9308).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTTableDynamicsSequence>::s_keyword,
        attribute::get(attribute::Keyword::CTTableDynamicsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableSpeed>::s_keyword,
        attribute::get(0x0018, 0x9309).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableSpeed>::s_keyword,
        attribute::get(attribute::Keyword::TableSpeed).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableFeedPerRotation>::s_keyword,
        attribute::get(0x0018, 0x9310).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableFeedPerRotation>::s_keyword,
        attribute::get(attribute::Keyword::TableFeedPerRotation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpiralPitchFactor>::s_keyword,
        attribute::get(0x0018, 0x9311).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpiralPitchFactor>::s_keyword,
        attribute::get(attribute::Keyword::SpiralPitchFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTGeometrySequence>::s_keyword,
        attribute::get(0x0018, 0x9312).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTGeometrySequence>::s_keyword,
        attribute::get(attribute::Keyword::CTGeometrySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataCollectionCenterPatient>::s_keyword,
        attribute::get(0x0018, 0x9313).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataCollectionCenterPatient>::s_keyword,
        attribute::get(attribute::Keyword::DataCollectionCenterPatient).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTReconstructionSequence>::s_keyword,
        attribute::get(0x0018, 0x9314).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTReconstructionSequence>::s_keyword,
        attribute::get(attribute::Keyword::CTReconstructionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionAlgorithm>::s_keyword,
        attribute::get(0x0018, 0x9315).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionAlgorithm>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionAlgorithm).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConvolutionKernelGroup>::s_keyword,
        attribute::get(0x0018, 0x9316).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConvolutionKernelGroup>::s_keyword,
        attribute::get(attribute::Keyword::ConvolutionKernelGroup).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionFieldOfView>::s_keyword,
        attribute::get(0x0018, 0x9317).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionFieldOfView>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionFieldOfView).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionTargetCenterPatient>::s_keyword,
        attribute::get(0x0018, 0x9318).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionTargetCenterPatient>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionTargetCenterPatient).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionAngle>::s_keyword,
        attribute::get(0x0018, 0x9319).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionAngle>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageFilter>::s_keyword,
        attribute::get(0x0018, 0x9320).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageFilter>::s_keyword,
        attribute::get(attribute::Keyword::ImageFilter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTExposureSequence>::s_keyword,
        attribute::get(0x0018, 0x9321).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTExposureSequence>::s_keyword,
        attribute::get(attribute::Keyword::CTExposureSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionPixelSpacing>::s_keyword,
        attribute::get(0x0018, 0x9322).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionPixelSpacing>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionPixelSpacing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureModulationType>::s_keyword,
        attribute::get(0x0018, 0x9323).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureModulationType>::s_keyword,
        attribute::get(attribute::Keyword::ExposureModulationType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTXRayDetailsSequence>::s_keyword,
        attribute::get(0x0018, 0x9325).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTXRayDetailsSequence>::s_keyword,
        attribute::get(attribute::Keyword::CTXRayDetailsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTPositionSequence>::s_keyword,
        attribute::get(0x0018, 0x9326).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTPositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::CTPositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TablePosition>::s_keyword,
        attribute::get(0x0018, 0x9327).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TablePosition>::s_keyword,
        attribute::get(attribute::Keyword::TablePosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureTimeInms>::s_keyword,
        attribute::get(0x0018, 0x9328).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureTimeInms>::s_keyword,
        attribute::get(attribute::Keyword::ExposureTimeInms).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTImageFrameTypeSequence>::s_keyword,
        attribute::get(0x0018, 0x9329).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTImageFrameTypeSequence>::s_keyword,
        attribute::get(attribute::Keyword::CTImageFrameTypeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayTubeCurrentInmA>::s_keyword,
        attribute::get(0x0018, 0x9330).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayTubeCurrentInmA>::s_keyword,
        attribute::get(attribute::Keyword::XRayTubeCurrentInmA).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureInmAs>::s_keyword,
        attribute::get(0x0018, 0x9332).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureInmAs>::s_keyword,
        attribute::get(attribute::Keyword::ExposureInmAs).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConstantVolumeFlag>::s_keyword,
        attribute::get(0x0018, 0x9333).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConstantVolumeFlag>::s_keyword,
        attribute::get(attribute::Keyword::ConstantVolumeFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FluoroscopyFlag>::s_keyword,
        attribute::get(0x0018, 0x9334).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FluoroscopyFlag>::s_keyword,
        attribute::get(attribute::Keyword::FluoroscopyFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceSourceToDataCollectionCenter>::s_keyword,
        attribute::get(0x0018, 0x9335).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceSourceToDataCollectionCenter>::s_keyword,
        attribute::get(attribute::Keyword::DistanceSourceToDataCollectionCenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgentNumber>::s_keyword,
        attribute::get(0x0018, 0x9337).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgentNumber>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusAgentNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusIngredientCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x9338).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusIngredientCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusIngredientCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastAdministrationProfileSequence>::s_keyword,
        attribute::get(0x0018, 0x9340).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastAdministrationProfileSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContrastAdministrationProfileSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusUsageSequence>::s_keyword,
        attribute::get(0x0018, 0x9341).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusUsageSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusUsageSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgentAdministered>::s_keyword,
        attribute::get(0x0018, 0x9342).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgentAdministered>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusAgentAdministered).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgentDetected>::s_keyword,
        attribute::get(0x0018, 0x9343).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgentDetected>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusAgentDetected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgentPhase>::s_keyword,
        attribute::get(0x0018, 0x9344).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusAgentPhase>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusAgentPhase).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTDIvol>::s_keyword,
        attribute::get(0x0018, 0x9345).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTDIvol>::s_keyword,
        attribute::get(attribute::Keyword::CTDIvol).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTDIPhantomTypeCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x9346).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTDIPhantomTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::CTDIPhantomTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalciumScoringMassFactorPatient>::s_keyword,
        attribute::get(0x0018, 0x9351).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalciumScoringMassFactorPatient>::s_keyword,
        attribute::get(attribute::Keyword::CalciumScoringMassFactorPatient).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalciumScoringMassFactorDevice>::s_keyword,
        attribute::get(0x0018, 0x9352).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalciumScoringMassFactorDevice>::s_keyword,
        attribute::get(attribute::Keyword::CalciumScoringMassFactorDevice).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWeightingFactor>::s_keyword,
        attribute::get(0x0018, 0x9353).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWeightingFactor>::s_keyword,
        attribute::get(attribute::Keyword::EnergyWeightingFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTAdditionalXRaySourceSequence>::s_keyword,
        attribute::get(0x0018, 0x9360).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CTAdditionalXRaySourceSequence>::s_keyword,
        attribute::get(attribute::Keyword::CTAdditionalXRaySourceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTAcquisition>::s_keyword,
        attribute::get(0x0018, 0x9361).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTAcquisition>::s_keyword,
        attribute::get(attribute::Keyword::MultienergyCTAcquisition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTAcquisitionSequence>::s_keyword,
        attribute::get(0x0018, 0x9362).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTAcquisitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::MultienergyCTAcquisitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTProcessingSequence>::s_keyword,
        attribute::get(0x0018, 0x9363).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTProcessingSequence>::s_keyword,
        attribute::get(attribute::Keyword::MultienergyCTProcessingSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTCharacteristicsSequence>::s_keyword,
        attribute::get(0x0018, 0x9364).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTCharacteristicsSequence>::s_keyword,
        attribute::get(attribute::Keyword::MultienergyCTCharacteristicsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTXRaySourceSequence>::s_keyword,
        attribute::get(0x0018, 0x9365).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTXRaySourceSequence>::s_keyword,
        attribute::get(attribute::Keyword::MultienergyCTXRaySourceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRaySourceIndex>::s_keyword,
        attribute::get(0x0018, 0x9366).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRaySourceIndex>::s_keyword,
        attribute::get(attribute::Keyword::XRaySourceIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRaySourceID>::s_keyword,
        attribute::get(0x0018, 0x9367).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRaySourceID>::s_keyword,
        attribute::get(attribute::Keyword::XRaySourceID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergySourceTechnique>::s_keyword,
        attribute::get(0x0018, 0x9368).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergySourceTechnique>::s_keyword,
        attribute::get(attribute::Keyword::MultienergySourceTechnique).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceStartDateTime>::s_keyword,
        attribute::get(0x0018, 0x9369).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceStartDateTime>::s_keyword,
        attribute::get(attribute::Keyword::SourceStartDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceEndDateTime>::s_keyword,
        attribute::get(0x0018, 0x936A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceEndDateTime>::s_keyword,
        attribute::get(attribute::Keyword::SourceEndDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SwitchingPhaseNumber>::s_keyword,
        attribute::get(0x0018, 0x936B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SwitchingPhaseNumber>::s_keyword,
        attribute::get(attribute::Keyword::SwitchingPhaseNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SwitchingPhaseNominalDuration>::s_keyword,
        attribute::get(0x0018, 0x936C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SwitchingPhaseNominalDuration>::s_keyword,
        attribute::get(attribute::Keyword::SwitchingPhaseNominalDuration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SwitchingPhaseTransitionDuration>::s_keyword,
        attribute::get(0x0018, 0x936D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SwitchingPhaseTransitionDuration>::s_keyword,
        attribute::get(attribute::Keyword::SwitchingPhaseTransitionDuration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EffectiveBinEnergy>::s_keyword,
        attribute::get(0x0018, 0x936E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EffectiveBinEnergy>::s_keyword,
        attribute::get(attribute::Keyword::EffectiveBinEnergy).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTXRayDetectorSequence>::s_keyword,
        attribute::get(0x0018, 0x936F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTXRayDetectorSequence>::s_keyword,
        attribute::get(attribute::Keyword::MultienergyCTXRayDetectorSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayDetectorIndex>::s_keyword,
        attribute::get(0x0018, 0x9370).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayDetectorIndex>::s_keyword,
        attribute::get(attribute::Keyword::XRayDetectorIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayDetectorID>::s_keyword,
        attribute::get(0x0018, 0x9371).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayDetectorID>::s_keyword,
        attribute::get(attribute::Keyword::XRayDetectorID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyDetectorType>::s_keyword,
        attribute::get(0x0018, 0x9372).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyDetectorType>::s_keyword,
        attribute::get(attribute::Keyword::MultienergyDetectorType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayDetectorLabel>::s_keyword,
        attribute::get(0x0018, 0x9373).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayDetectorLabel>::s_keyword,
        attribute::get(attribute::Keyword::XRayDetectorLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalMaxEnergy>::s_keyword,
        attribute::get(0x0018, 0x9374).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalMaxEnergy>::s_keyword,
        attribute::get(attribute::Keyword::NominalMaxEnergy).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalMinEnergy>::s_keyword,
        attribute::get(0x0018, 0x9375).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalMinEnergy>::s_keyword,
        attribute::get(attribute::Keyword::NominalMinEnergy).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedXRayDetectorIndex>::s_keyword,
        attribute::get(0x0018, 0x9376).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedXRayDetectorIndex>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedXRayDetectorIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedXRaySourceIndex>::s_keyword,
        attribute::get(0x0018, 0x9377).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedXRaySourceIndex>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedXRaySourceIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPathIndex>::s_keyword,
        attribute::get(0x0018, 0x9378).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPathIndex>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedPathIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTPathSequence>::s_keyword,
        attribute::get(0x0018, 0x9379).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTPathSequence>::s_keyword,
        attribute::get(attribute::Keyword::MultienergyCTPathSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTPathIndex>::s_keyword,
        attribute::get(0x0018, 0x937A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyCTPathIndex>::s_keyword,
        attribute::get(attribute::Keyword::MultienergyCTPathIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyAcquisitionDescription>::s_keyword,
        attribute::get(0x0018, 0x937B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultienergyAcquisitionDescription>::s_keyword,
        attribute::get(attribute::Keyword::MultienergyAcquisitionDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MonoenergeticEnergyEquivalent>::s_keyword,
        attribute::get(0x0018, 0x937C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MonoenergeticEnergyEquivalent>::s_keyword,
        attribute::get(attribute::Keyword::MonoenergeticEnergyEquivalent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecompositionMethod>::s_keyword,
        attribute::get(0x0018, 0x937E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecompositionMethod>::s_keyword,
        attribute::get(attribute::Keyword::DecompositionMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecompositionDescription>::s_keyword,
        attribute::get(0x0018, 0x937F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecompositionDescription>::s_keyword,
        attribute::get(attribute::Keyword::DecompositionDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecompositionAlgorithmIdentificationSequence>::s_keyword,
        attribute::get(0x0018, 0x9380).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecompositionAlgorithmIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::DecompositionAlgorithmIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecompositionMaterialSequence>::s_keyword,
        attribute::get(0x0018, 0x9381).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecompositionMaterialSequence>::s_keyword,
        attribute::get(attribute::Keyword::DecompositionMaterialSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProjectionPixelCalibrationSequence>::s_keyword,
        attribute::get(0x0018, 0x9401).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProjectionPixelCalibrationSequence>::s_keyword,
        attribute::get(attribute::Keyword::ProjectionPixelCalibrationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceSourceToIsocenter>::s_keyword,
        attribute::get(0x0018, 0x9402).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceSourceToIsocenter>::s_keyword,
        attribute::get(attribute::Keyword::DistanceSourceToIsocenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceObjectToTableTop>::s_keyword,
        attribute::get(0x0018, 0x9403).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceObjectToTableTop>::s_keyword,
        attribute::get(attribute::Keyword::DistanceObjectToTableTop).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObjectPixelSpacingInCenterOfBeam>::s_keyword,
        attribute::get(0x0018, 0x9404).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObjectPixelSpacingInCenterOfBeam>::s_keyword,
        attribute::get(attribute::Keyword::ObjectPixelSpacingInCenterOfBeam).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerPositionSequence>::s_keyword,
        attribute::get(0x0018, 0x9405).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerPositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::PositionerPositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TablePositionSequence>::s_keyword,
        attribute::get(0x0018, 0x9406).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TablePositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::TablePositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorShapeSequence>::s_keyword,
        attribute::get(0x0018, 0x9407).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CollimatorShapeSequence>::s_keyword,
        attribute::get(attribute::Keyword::CollimatorShapeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanesInAcquisition>::s_keyword,
        attribute::get(0x0018, 0x9410).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanesInAcquisition>::s_keyword,
        attribute::get(attribute::Keyword::PlanesInAcquisition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XAXRFFrameCharacteristicsSequence>::s_keyword,
        attribute::get(0x0018, 0x9412).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XAXRFFrameCharacteristicsSequence>::s_keyword,
        attribute::get(attribute::Keyword::XAXRFFrameCharacteristicsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameAcquisitionSequence>::s_keyword,
        attribute::get(0x0018, 0x9417).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameAcquisitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::FrameAcquisitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayReceptorType>::s_keyword,
        attribute::get(0x0018, 0x9420).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayReceptorType>::s_keyword,
        attribute::get(attribute::Keyword::XRayReceptorType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionProtocolName>::s_keyword,
        attribute::get(0x0018, 0x9423).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionProtocolName>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionProtocolName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionProtocolDescription>::s_keyword,
        attribute::get(0x0018, 0x9424).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionProtocolDescription>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionProtocolDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusIngredientOpaque>::s_keyword,
        attribute::get(0x0018, 0x9425).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusIngredientOpaque>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusIngredientOpaque).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceReceptorPlaneToDetectorHousing>::s_keyword,
        attribute::get(0x0018, 0x9426).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceReceptorPlaneToDetectorHousing>::s_keyword,
        attribute::get(attribute::Keyword::DistanceReceptorPlaneToDetectorHousing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntensifierActiveShape>::s_keyword,
        attribute::get(0x0018, 0x9427).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntensifierActiveShape>::s_keyword,
        attribute::get(attribute::Keyword::IntensifierActiveShape).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntensifierActiveDimensions>::s_keyword,
        attribute::get(0x0018, 0x9428).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntensifierActiveDimensions>::s_keyword,
        attribute::get(attribute::Keyword::IntensifierActiveDimensions).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysicalDetectorSize>::s_keyword,
        attribute::get(0x0018, 0x9429).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhysicalDetectorSize>::s_keyword,
        attribute::get(attribute::Keyword::PhysicalDetectorSize).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionOfIsocenterProjection>::s_keyword,
        attribute::get(0x0018, 0x9430).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionOfIsocenterProjection>::s_keyword,
        attribute::get(attribute::Keyword::PositionOfIsocenterProjection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewSequence>::s_keyword,
        attribute::get(0x0018, 0x9432).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewSequence>::s_keyword,
        attribute::get(attribute::Keyword::FieldOfViewSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewDescription>::s_keyword,
        attribute::get(0x0018, 0x9433).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewDescription>::s_keyword,
        attribute::get(attribute::Keyword::FieldOfViewDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionsSequence>::s_keyword,
        attribute::get(0x0018, 0x9434).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionsSequence>::s_keyword,
        attribute::get(attribute::Keyword::ExposureControlSensingRegionsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionShape>::s_keyword,
        attribute::get(0x0018, 0x9435).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionShape>::s_keyword,
        attribute::get(attribute::Keyword::ExposureControlSensingRegionShape).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionLeftVerticalEdge>::s_keyword,
        attribute::get(0x0018, 0x9436).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionLeftVerticalEdge>::s_keyword,
        attribute::get(attribute::Keyword::ExposureControlSensingRegionLeftVerticalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionRightVerticalEdge>::s_keyword,
        attribute::get(0x0018, 0x9437).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionRightVerticalEdge>::s_keyword,
        attribute::get(attribute::Keyword::ExposureControlSensingRegionRightVerticalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionUpperHorizontalEdge>::s_keyword,
        attribute::get(0x0018, 0x9438).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionUpperHorizontalEdge>::s_keyword,
        attribute::get(attribute::Keyword::ExposureControlSensingRegionUpperHorizontalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionLowerHorizontalEdge>::s_keyword,
        attribute::get(0x0018, 0x9439).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureControlSensingRegionLowerHorizontalEdge>::s_keyword,
        attribute::get(attribute::Keyword::ExposureControlSensingRegionLowerHorizontalEdge).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfCircularExposureControlSensingRegion>::s_keyword,
        attribute::get(0x0018, 0x9440).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfCircularExposureControlSensingRegion>::s_keyword,
        attribute::get(attribute::Keyword::CenterOfCircularExposureControlSensingRegion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiusOfCircularExposureControlSensingRegion>::s_keyword,
        attribute::get(0x0018, 0x9441).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiusOfCircularExposureControlSensingRegion>::s_keyword,
        attribute::get(attribute::Keyword::RadiusOfCircularExposureControlSensingRegion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerticesOfThePolygonalExposureControlSensingRegion>::s_keyword,
        attribute::get(0x0018, 0x9442).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerticesOfThePolygonalExposureControlSensingRegion>::s_keyword,
        attribute::get(attribute::Keyword::VerticesOfThePolygonalExposureControlSensingRegion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColumnAngulationPatient>::s_keyword,
        attribute::get(0x0018, 0x9447).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColumnAngulationPatient>::s_keyword,
        attribute::get(attribute::Keyword::ColumnAngulationPatient).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamAngle>::s_keyword,
        attribute::get(0x0018, 0x9449).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamAngle>::s_keyword,
        attribute::get(attribute::Keyword::BeamAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameDetectorParametersSequence>::s_keyword,
        attribute::get(0x0018, 0x9451).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameDetectorParametersSequence>::s_keyword,
        attribute::get(attribute::Keyword::FrameDetectorParametersSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalculatedAnatomyThickness>::s_keyword,
        attribute::get(0x0018, 0x9452).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalculatedAnatomyThickness>::s_keyword,
        attribute::get(attribute::Keyword::CalculatedAnatomyThickness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalibrationSequence>::s_keyword,
        attribute::get(0x0018, 0x9455).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalibrationSequence>::s_keyword,
        attribute::get(attribute::Keyword::CalibrationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObjectThicknessSequence>::s_keyword,
        attribute::get(0x0018, 0x9456).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObjectThicknessSequence>::s_keyword,
        attribute::get(attribute::Keyword::ObjectThicknessSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlaneIdentification>::s_keyword,
        attribute::get(0x0018, 0x9457).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlaneIdentification>::s_keyword,
        attribute::get(attribute::Keyword::PlaneIdentification).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewDimensionsInFloat>::s_keyword,
        attribute::get(0x0018, 0x9461).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FieldOfViewDimensionsInFloat>::s_keyword,
        attribute::get(attribute::Keyword::FieldOfViewDimensionsInFloat).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IsocenterReferenceSystemSequence>::s_keyword,
        attribute::get(0x0018, 0x9462).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IsocenterReferenceSystemSequence>::s_keyword,
        attribute::get(attribute::Keyword::IsocenterReferenceSystemSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerIsocenterPrimaryAngle>::s_keyword,
        attribute::get(0x0018, 0x9463).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerIsocenterPrimaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::PositionerIsocenterPrimaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerIsocenterSecondaryAngle>::s_keyword,
        attribute::get(0x0018, 0x9464).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerIsocenterSecondaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::PositionerIsocenterSecondaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerIsocenterDetectorRotationAngle>::s_keyword,
        attribute::get(0x0018, 0x9465).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerIsocenterDetectorRotationAngle>::s_keyword,
        attribute::get(attribute::Keyword::PositionerIsocenterDetectorRotationAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableXPositionToIsocenter>::s_keyword,
        attribute::get(0x0018, 0x9466).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableXPositionToIsocenter>::s_keyword,
        attribute::get(attribute::Keyword::TableXPositionToIsocenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableYPositionToIsocenter>::s_keyword,
        attribute::get(0x0018, 0x9467).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableYPositionToIsocenter>::s_keyword,
        attribute::get(attribute::Keyword::TableYPositionToIsocenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableZPositionToIsocenter>::s_keyword,
        attribute::get(0x0018, 0x9468).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableZPositionToIsocenter>::s_keyword,
        attribute::get(attribute::Keyword::TableZPositionToIsocenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableHorizontalRotationAngle>::s_keyword,
        attribute::get(0x0018, 0x9469).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableHorizontalRotationAngle>::s_keyword,
        attribute::get(attribute::Keyword::TableHorizontalRotationAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableHeadTiltAngle>::s_keyword,
        attribute::get(0x0018, 0x9470).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableHeadTiltAngle>::s_keyword,
        attribute::get(attribute::Keyword::TableHeadTiltAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableCradleTiltAngle>::s_keyword,
        attribute::get(0x0018, 0x9471).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableCradleTiltAngle>::s_keyword,
        attribute::get(attribute::Keyword::TableCradleTiltAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameDisplayShutterSequence>::s_keyword,
        attribute::get(0x0018, 0x9472).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameDisplayShutterSequence>::s_keyword,
        attribute::get(attribute::Keyword::FrameDisplayShutterSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquiredImageAreaDoseProduct>::s_keyword,
        attribute::get(0x0018, 0x9473).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquiredImageAreaDoseProduct>::s_keyword,
        attribute::get(attribute::Keyword::AcquiredImageAreaDoseProduct).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CArmPositionerTabletopRelationship>::s_keyword,
        attribute::get(0x0018, 0x9474).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CArmPositionerTabletopRelationship>::s_keyword,
        attribute::get(attribute::Keyword::CArmPositionerTabletopRelationship).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayGeometrySequence>::s_keyword,
        attribute::get(0x0018, 0x9476).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayGeometrySequence>::s_keyword,
        attribute::get(attribute::Keyword::XRayGeometrySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IrradiationEventIdentificationSequence>::s_keyword,
        attribute::get(0x0018, 0x9477).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IrradiationEventIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::IrradiationEventIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRay3DFrameTypeSequence>::s_keyword,
        attribute::get(0x0018, 0x9504).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRay3DFrameTypeSequence>::s_keyword,
        attribute::get(attribute::Keyword::XRay3DFrameTypeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContributingSourcesSequence>::s_keyword,
        attribute::get(0x0018, 0x9506).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContributingSourcesSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContributingSourcesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRay3DAcquisitionSequence>::s_keyword,
        attribute::get(0x0018, 0x9507).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRay3DAcquisitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::XRay3DAcquisitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryPositionerScanArc>::s_keyword,
        attribute::get(0x0018, 0x9508).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryPositionerScanArc>::s_keyword,
        attribute::get(attribute::Keyword::PrimaryPositionerScanArc).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryPositionerScanArc>::s_keyword,
        attribute::get(0x0018, 0x9509).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryPositionerScanArc>::s_keyword,
        attribute::get(attribute::Keyword::SecondaryPositionerScanArc).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryPositionerScanStartAngle>::s_keyword,
        attribute::get(0x0018, 0x9510).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryPositionerScanStartAngle>::s_keyword,
        attribute::get(attribute::Keyword::PrimaryPositionerScanStartAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryPositionerScanStartAngle>::s_keyword,
        attribute::get(0x0018, 0x9511).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryPositionerScanStartAngle>::s_keyword,
        attribute::get(attribute::Keyword::SecondaryPositionerScanStartAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryPositionerIncrement>::s_keyword,
        attribute::get(0x0018, 0x9514).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryPositionerIncrement>::s_keyword,
        attribute::get(attribute::Keyword::PrimaryPositionerIncrement).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryPositionerIncrement>::s_keyword,
        attribute::get(0x0018, 0x9515).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryPositionerIncrement>::s_keyword,
        attribute::get(attribute::Keyword::SecondaryPositionerIncrement).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartAcquisitionDateTime>::s_keyword,
        attribute::get(0x0018, 0x9516).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartAcquisitionDateTime>::s_keyword,
        attribute::get(attribute::Keyword::StartAcquisitionDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EndAcquisitionDateTime>::s_keyword,
        attribute::get(0x0018, 0x9517).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EndAcquisitionDateTime>::s_keyword,
        attribute::get(attribute::Keyword::EndAcquisitionDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryPositionerIncrementSign>::s_keyword,
        attribute::get(0x0018, 0x9518).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryPositionerIncrementSign>::s_keyword,
        attribute::get(attribute::Keyword::PrimaryPositionerIncrementSign).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryPositionerIncrementSign>::s_keyword,
        attribute::get(0x0018, 0x9519).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryPositionerIncrementSign>::s_keyword,
        attribute::get(attribute::Keyword::SecondaryPositionerIncrementSign).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicationName>::s_keyword,
        attribute::get(0x0018, 0x9524).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicationName>::s_keyword,
        attribute::get(attribute::Keyword::ApplicationName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicationVersion>::s_keyword,
        attribute::get(0x0018, 0x9525).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicationVersion>::s_keyword,
        attribute::get(attribute::Keyword::ApplicationVersion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicationManufacturer>::s_keyword,
        attribute::get(0x0018, 0x9526).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicationManufacturer>::s_keyword,
        attribute::get(attribute::Keyword::ApplicationManufacturer).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmType>::s_keyword,
        attribute::get(0x0018, 0x9527).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmType>::s_keyword,
        attribute::get(attribute::Keyword::AlgorithmType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmDescription>::s_keyword,
        attribute::get(0x0018, 0x9528).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmDescription>::s_keyword,
        attribute::get(attribute::Keyword::AlgorithmDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRay3DReconstructionSequence>::s_keyword,
        attribute::get(0x0018, 0x9530).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRay3DReconstructionSequence>::s_keyword,
        attribute::get(attribute::Keyword::XRay3DReconstructionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionDescription>::s_keyword,
        attribute::get(0x0018, 0x9531).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionDescription>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerProjectionAcquisitionSequence>::s_keyword,
        attribute::get(0x0018, 0x9538).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerProjectionAcquisitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::PerProjectionAcquisitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorPositionSequence>::s_keyword,
        attribute::get(0x0018, 0x9541).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorPositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::DetectorPositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayAcquisitionDoseSequence>::s_keyword,
        attribute::get(0x0018, 0x9542).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayAcquisitionDoseSequence>::s_keyword,
        attribute::get(attribute::Keyword::XRayAcquisitionDoseSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRaySourceIsocenterPrimaryAngle>::s_keyword,
        attribute::get(0x0018, 0x9543).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRaySourceIsocenterPrimaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::XRaySourceIsocenterPrimaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRaySourceIsocenterSecondaryAngle>::s_keyword,
        attribute::get(0x0018, 0x9544).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRaySourceIsocenterSecondaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::XRaySourceIsocenterSecondaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastSupportIsocenterPrimaryAngle>::s_keyword,
        attribute::get(0x0018, 0x9545).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastSupportIsocenterPrimaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::BreastSupportIsocenterPrimaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastSupportIsocenterSecondaryAngle>::s_keyword,
        attribute::get(0x0018, 0x9546).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastSupportIsocenterSecondaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::BreastSupportIsocenterSecondaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastSupportXPositionToIsocenter>::s_keyword,
        attribute::get(0x0018, 0x9547).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastSupportXPositionToIsocenter>::s_keyword,
        attribute::get(attribute::Keyword::BreastSupportXPositionToIsocenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastSupportYPositionToIsocenter>::s_keyword,
        attribute::get(0x0018, 0x9548).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastSupportYPositionToIsocenter>::s_keyword,
        attribute::get(attribute::Keyword::BreastSupportYPositionToIsocenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastSupportZPositionToIsocenter>::s_keyword,
        attribute::get(0x0018, 0x9549).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastSupportZPositionToIsocenter>::s_keyword,
        attribute::get(attribute::Keyword::BreastSupportZPositionToIsocenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorIsocenterPrimaryAngle>::s_keyword,
        attribute::get(0x0018, 0x9550).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorIsocenterPrimaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::DetectorIsocenterPrimaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorIsocenterSecondaryAngle>::s_keyword,
        attribute::get(0x0018, 0x9551).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorIsocenterSecondaryAngle>::s_keyword,
        attribute::get(attribute::Keyword::DetectorIsocenterSecondaryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorXPositionToIsocenter>::s_keyword,
        attribute::get(0x0018, 0x9552).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorXPositionToIsocenter>::s_keyword,
        attribute::get(attribute::Keyword::DetectorXPositionToIsocenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorYPositionToIsocenter>::s_keyword,
        attribute::get(0x0018, 0x9553).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorYPositionToIsocenter>::s_keyword,
        attribute::get(attribute::Keyword::DetectorYPositionToIsocenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorZPositionToIsocenter>::s_keyword,
        attribute::get(0x0018, 0x9554).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorZPositionToIsocenter>::s_keyword,
        attribute::get(attribute::Keyword::DetectorZPositionToIsocenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayGridSequence>::s_keyword,
        attribute::get(0x0018, 0x9555).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayGridSequence>::s_keyword,
        attribute::get(attribute::Keyword::XRayGridSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayFilterSequence>::s_keyword,
        attribute::get(0x0018, 0x9556).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayFilterSequence>::s_keyword,
        attribute::get(attribute::Keyword::XRayFilterSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveAreaTLHCPosition>::s_keyword,
        attribute::get(0x0018, 0x9557).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveAreaTLHCPosition>::s_keyword,
        attribute::get(attribute::Keyword::DetectorActiveAreaTLHCPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveAreaOrientation>::s_keyword,
        attribute::get(0x0018, 0x9558).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorActiveAreaOrientation>::s_keyword,
        attribute::get(attribute::Keyword::DetectorActiveAreaOrientation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerPrimaryAngleDirection>::s_keyword,
        attribute::get(0x0018, 0x9559).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionerPrimaryAngleDirection>::s_keyword,
        attribute::get(attribute::Keyword::PositionerPrimaryAngleDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiffusionBMatrixSequence>::s_keyword,
        attribute::get(0x0018, 0x9601).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiffusionBMatrixSequence>::s_keyword,
        attribute::get(attribute::Keyword::DiffusionBMatrixSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FunctionalMRSequence>::s_keyword,
        attribute::get(0x0018, 0x9621).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FunctionalMRSequence>::s_keyword,
        attribute::get(attribute::Keyword::FunctionalMRSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FunctionalSettlingPhaseFramesPresent>::s_keyword,
        attribute::get(0x0018, 0x9622).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FunctionalSettlingPhaseFramesPresent>::s_keyword,
        attribute::get(attribute::Keyword::FunctionalSettlingPhaseFramesPresent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FunctionalSyncPulse>::s_keyword,
        attribute::get(0x0018, 0x9623).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FunctionalSyncPulse>::s_keyword,
        attribute::get(attribute::Keyword::FunctionalSyncPulse).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SettlingPhaseFrame>::s_keyword,
        attribute::get(0x0018, 0x9624).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SettlingPhaseFrame>::s_keyword,
        attribute::get(attribute::Keyword::SettlingPhaseFrame).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecayCorrectionDateTime>::s_keyword,
        attribute::get(0x0018, 0x9701).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecayCorrectionDateTime>::s_keyword,
        attribute::get(attribute::Keyword::DecayCorrectionDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartDensityThreshold>::s_keyword,
        attribute::get(0x0018, 0x9715).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartDensityThreshold>::s_keyword,
        attribute::get(attribute::Keyword::StartDensityThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartRelativeDensityDifferenceThreshold>::s_keyword,
        attribute::get(0x0018, 0x9716).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartRelativeDensityDifferenceThreshold>::s_keyword,
        attribute::get(attribute::Keyword::StartRelativeDensityDifferenceThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartCardiacTriggerCountThreshold>::s_keyword,
        attribute::get(0x0018, 0x9717).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartCardiacTriggerCountThreshold>::s_keyword,
        attribute::get(attribute::Keyword::StartCardiacTriggerCountThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartRespiratoryTriggerCountThreshold>::s_keyword,
        attribute::get(0x0018, 0x9718).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartRespiratoryTriggerCountThreshold>::s_keyword,
        attribute::get(attribute::Keyword::StartRespiratoryTriggerCountThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationCountsThreshold>::s_keyword,
        attribute::get(0x0018, 0x9719).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationCountsThreshold>::s_keyword,
        attribute::get(attribute::Keyword::TerminationCountsThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationDensityThreshold>::s_keyword,
        attribute::get(0x0018, 0x9720).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationDensityThreshold>::s_keyword,
        attribute::get(attribute::Keyword::TerminationDensityThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationRelativeDensityThreshold>::s_keyword,
        attribute::get(0x0018, 0x9721).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationRelativeDensityThreshold>::s_keyword,
        attribute::get(attribute::Keyword::TerminationRelativeDensityThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationTimeThreshold>::s_keyword,
        attribute::get(0x0018, 0x9722).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationTimeThreshold>::s_keyword,
        attribute::get(attribute::Keyword::TerminationTimeThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationCardiacTriggerCountThreshold>::s_keyword,
        attribute::get(0x0018, 0x9723).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationCardiacTriggerCountThreshold>::s_keyword,
        attribute::get(attribute::Keyword::TerminationCardiacTriggerCountThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationRespiratoryTriggerCountThreshold>::s_keyword,
        attribute::get(0x0018, 0x9724).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TerminationRespiratoryTriggerCountThreshold>::s_keyword,
        attribute::get(attribute::Keyword::TerminationRespiratoryTriggerCountThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorGeometry>::s_keyword,
        attribute::get(0x0018, 0x9725).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorGeometry>::s_keyword,
        attribute::get(attribute::Keyword::DetectorGeometry).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransverseDetectorSeparation>::s_keyword,
        attribute::get(0x0018, 0x9726).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransverseDetectorSeparation>::s_keyword,
        attribute::get(attribute::Keyword::TransverseDetectorSeparation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialDetectorDimension>::s_keyword,
        attribute::get(0x0018, 0x9727).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialDetectorDimension>::s_keyword,
        attribute::get(attribute::Keyword::AxialDetectorDimension).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalAgentNumber>::s_keyword,
        attribute::get(0x0018, 0x9729).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalAgentNumber>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalAgentNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETFrameAcquisitionSequence>::s_keyword,
        attribute::get(0x0018, 0x9732).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETFrameAcquisitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::PETFrameAcquisitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETDetectorMotionDetailsSequence>::s_keyword,
        attribute::get(0x0018, 0x9733).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETDetectorMotionDetailsSequence>::s_keyword,
        attribute::get(attribute::Keyword::PETDetectorMotionDetailsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETTableDynamicsSequence>::s_keyword,
        attribute::get(0x0018, 0x9734).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETTableDynamicsSequence>::s_keyword,
        attribute::get(attribute::Keyword::PETTableDynamicsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETPositionSequence>::s_keyword,
        attribute::get(0x0018, 0x9735).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETPositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::PETPositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETFrameCorrectionFactorsSequence>::s_keyword,
        attribute::get(0x0018, 0x9736).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETFrameCorrectionFactorsSequence>::s_keyword,
        attribute::get(attribute::Keyword::PETFrameCorrectionFactorsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalUsageSequence>::s_keyword,
        attribute::get(0x0018, 0x9737).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalUsageSequence>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalUsageSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AttenuationCorrectionSource>::s_keyword,
        attribute::get(0x0018, 0x9738).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AttenuationCorrectionSource>::s_keyword,
        attribute::get(attribute::Keyword::AttenuationCorrectionSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfIterations>::s_keyword,
        attribute::get(0x0018, 0x9739).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfIterations>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfIterations).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfSubsets>::s_keyword,
        attribute::get(0x0018, 0x9740).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfSubsets>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfSubsets).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETReconstructionSequence>::s_keyword,
        attribute::get(0x0018, 0x9749).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETReconstructionSequence>::s_keyword,
        attribute::get(attribute::Keyword::PETReconstructionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETFrameTypeSequence>::s_keyword,
        attribute::get(0x0018, 0x9751).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PETFrameTypeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PETFrameTypeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfFlightInformationUsed>::s_keyword,
        attribute::get(0x0018, 0x9755).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfFlightInformationUsed>::s_keyword,
        attribute::get(attribute::Keyword::TimeOfFlightInformationUsed).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionType>::s_keyword,
        attribute::get(0x0018, 0x9756).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionType>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecayCorrected>::s_keyword,
        attribute::get(0x0018, 0x9758).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecayCorrected>::s_keyword,
        attribute::get(attribute::Keyword::DecayCorrected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AttenuationCorrected>::s_keyword,
        attribute::get(0x0018, 0x9759).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AttenuationCorrected>::s_keyword,
        attribute::get(attribute::Keyword::AttenuationCorrected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScatterCorrected>::s_keyword,
        attribute::get(0x0018, 0x9760).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScatterCorrected>::s_keyword,
        attribute::get(attribute::Keyword::ScatterCorrected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeadTimeCorrected>::s_keyword,
        attribute::get(0x0018, 0x9761).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeadTimeCorrected>::s_keyword,
        attribute::get(attribute::Keyword::DeadTimeCorrected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryMotionCorrected>::s_keyword,
        attribute::get(0x0018, 0x9762).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryMotionCorrected>::s_keyword,
        attribute::get(attribute::Keyword::GantryMotionCorrected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientMotionCorrected>::s_keyword,
        attribute::get(0x0018, 0x9763).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientMotionCorrected>::s_keyword,
        attribute::get(attribute::Keyword::PatientMotionCorrected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CountLossNormalizationCorrected>::s_keyword,
        attribute::get(0x0018, 0x9764).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CountLossNormalizationCorrected>::s_keyword,
        attribute::get(attribute::Keyword::CountLossNormalizationCorrected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RandomsCorrected>::s_keyword,
        attribute::get(0x0018, 0x9765).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RandomsCorrected>::s_keyword,
        attribute::get(attribute::Keyword::RandomsCorrected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NonUniformRadialSamplingCorrected>::s_keyword,
        attribute::get(0x0018, 0x9766).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NonUniformRadialSamplingCorrected>::s_keyword,
        attribute::get(attribute::Keyword::NonUniformRadialSamplingCorrected).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SensitivityCalibrated>::s_keyword,
        attribute::get(0x0018, 0x9767).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SensitivityCalibrated>::s_keyword,
        attribute::get(attribute::Keyword::SensitivityCalibrated).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorNormalizationCorrection>::s_keyword,
        attribute::get(0x0018, 0x9768).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorNormalizationCorrection>::s_keyword,
        attribute::get(attribute::Keyword::DetectorNormalizationCorrection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IterativeReconstructionMethod>::s_keyword,
        attribute::get(0x0018, 0x9769).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IterativeReconstructionMethod>::s_keyword,
        attribute::get(attribute::Keyword::IterativeReconstructionMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AttenuationCorrectionTemporalRelationship>::s_keyword,
        attribute::get(0x0018, 0x9770).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AttenuationCorrectionTemporalRelationship>::s_keyword,
        attribute::get(attribute::Keyword::AttenuationCorrectionTemporalRelationship).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientPhysiologicalStateSequence>::s_keyword,
        attribute::get(0x0018, 0x9771).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientPhysiologicalStateSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientPhysiologicalStateSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientPhysiologicalStateCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x9772).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientPhysiologicalStateCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientPhysiologicalStateCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DepthsOfFocus>::s_keyword,
        attribute::get(0x0018, 0x9801).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DepthsOfFocus>::s_keyword,
        attribute::get(attribute::Keyword::DepthsOfFocus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcludedIntervalsSequence>::s_keyword,
        attribute::get(0x0018, 0x9803).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcludedIntervalsSequence>::s_keyword,
        attribute::get(attribute::Keyword::ExcludedIntervalsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExclusionStartDateTime>::s_keyword,
        attribute::get(0x0018, 0x9804).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExclusionStartDateTime>::s_keyword,
        attribute::get(attribute::Keyword::ExclusionStartDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExclusionDuration>::s_keyword,
        attribute::get(0x0018, 0x9805).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExclusionDuration>::s_keyword,
        attribute::get(attribute::Keyword::ExclusionDuration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::USImageDescriptionSequence>::s_keyword,
        attribute::get(0x0018, 0x9806).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::USImageDescriptionSequence>::s_keyword,
        attribute::get(attribute::Keyword::USImageDescriptionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageDataTypeSequence>::s_keyword,
        attribute::get(0x0018, 0x9807).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageDataTypeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ImageDataTypeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataType>::s_keyword,
        attribute::get(0x0018, 0x9808).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataType>::s_keyword,
        attribute::get(attribute::Keyword::DataType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerScanPatternCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x9809).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerScanPatternCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::TransducerScanPatternCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AliasedDataType>::s_keyword,
        attribute::get(0x0018, 0x980B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AliasedDataType>::s_keyword,
        attribute::get(attribute::Keyword::AliasedDataType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionMeasuringDeviceUsed>::s_keyword,
        attribute::get(0x0018, 0x980C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionMeasuringDeviceUsed>::s_keyword,
        attribute::get(attribute::Keyword::PositionMeasuringDeviceUsed).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerGeometryCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x980D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerGeometryCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::TransducerGeometryCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerBeamSteeringCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x980E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerBeamSteeringCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::TransducerBeamSteeringCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerApplicationCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x980F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerApplicationCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::TransducerApplicationCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ZeroVelocityPixelValue>::s_keyword,
        attribute::get(0x0018, 0x9810).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ZeroVelocityPixelValue>::s_keyword,
        attribute::get(attribute::Keyword::ZeroVelocityPixelValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhotoacousticExcitationCharacteristicsSequence>::s_keyword,
        attribute::get(0x0018, 0x9821).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhotoacousticExcitationCharacteristicsSequence>::s_keyword,
        attribute::get(attribute::Keyword::PhotoacousticExcitationCharacteristicsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcitationSpectralWidth>::s_keyword,
        attribute::get(0x0018, 0x9822).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcitationSpectralWidth>::s_keyword,
        attribute::get(attribute::Keyword::ExcitationSpectralWidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcitationEnergy>::s_keyword,
        attribute::get(0x0018, 0x9823).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcitationEnergy>::s_keyword,
        attribute::get(attribute::Keyword::ExcitationEnergy).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcitationPulseDuration>::s_keyword,
        attribute::get(0x0018, 0x9824).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcitationPulseDuration>::s_keyword,
        attribute::get(attribute::Keyword::ExcitationPulseDuration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcitationWavelengthSequence>::s_keyword,
        attribute::get(0x0018, 0x9825).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcitationWavelengthSequence>::s_keyword,
        attribute::get(attribute::Keyword::ExcitationWavelengthSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcitationWavelength>::s_keyword,
        attribute::get(0x0018, 0x9826).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExcitationWavelength>::s_keyword,
        attribute::get(attribute::Keyword::ExcitationWavelength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationTranslationFlag>::s_keyword,
        attribute::get(0x0018, 0x9828).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationTranslationFlag>::s_keyword,
        attribute::get(attribute::Keyword::IlluminationTranslationFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcousticCouplingMediumFlag>::s_keyword,
        attribute::get(0x0018, 0x9829).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcousticCouplingMediumFlag>::s_keyword,
        attribute::get(attribute::Keyword::AcousticCouplingMediumFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcousticCouplingMediumCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x982A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcousticCouplingMediumCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::AcousticCouplingMediumCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcousticCouplingMediumTemperature>::s_keyword,
        attribute::get(0x0018, 0x982B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcousticCouplingMediumTemperature>::s_keyword,
        attribute::get(attribute::Keyword::AcousticCouplingMediumTemperature).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerResponseSequence>::s_keyword,
        attribute::get(0x0018, 0x982C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerResponseSequence>::s_keyword,
        attribute::get(attribute::Keyword::TransducerResponseSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterFrequency>::s_keyword,
        attribute::get(0x0018, 0x982D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterFrequency>::s_keyword,
        attribute::get(attribute::Keyword::CenterFrequency).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FractionalBandwidth>::s_keyword,
        attribute::get(0x0018, 0x982E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FractionalBandwidth>::s_keyword,
        attribute::get(attribute::Keyword::FractionalBandwidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LowerCutoffFrequency>::s_keyword,
        attribute::get(0x0018, 0x982F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LowerCutoffFrequency>::s_keyword,
        attribute::get(attribute::Keyword::LowerCutoffFrequency).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UpperCutoffFrequency>::s_keyword,
        attribute::get(0x0018, 0x9830).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UpperCutoffFrequency>::s_keyword,
        attribute::get(attribute::Keyword::UpperCutoffFrequency).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerTechnologySequence>::s_keyword,
        attribute::get(0x0018, 0x9831).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransducerTechnologySequence>::s_keyword,
        attribute::get(attribute::Keyword::TransducerTechnologySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SoundSpeedCorrectionMechanismCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x9832).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SoundSpeedCorrectionMechanismCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::SoundSpeedCorrectionMechanismCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObjectSoundSpeed>::s_keyword,
        attribute::get(0x0018, 0x9833).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObjectSoundSpeed>::s_keyword,
        attribute::get(attribute::Keyword::ObjectSoundSpeed).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcousticCouplingMediumSoundSpeed>::s_keyword,
        attribute::get(0x0018, 0x9834).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcousticCouplingMediumSoundSpeed>::s_keyword,
        attribute::get(attribute::Keyword::AcousticCouplingMediumSoundSpeed).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhotoacousticImageFrameTypeSequence>::s_keyword,
        attribute::get(0x0018, 0x9835).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhotoacousticImageFrameTypeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PhotoacousticImageFrameTypeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageDataTypeCodeSequence>::s_keyword,
        attribute::get(0x0018, 0x9836).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageDataTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ImageDataTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedDefinedProtocolSequence>::s_keyword,
        attribute::get(0x0018, 0x990C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedDefinedProtocolSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedDefinedProtocolSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPerformedProtocolSequence>::s_keyword,
        attribute::get(0x0018, 0x990D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPerformedProtocolSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedPerformedProtocolSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceAcquisitionProtocolElementNumber>::s_keyword,
        attribute::get(0x0018, 0x9938).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceAcquisitionProtocolElementNumber>::s_keyword,
        attribute::get(attribute::Keyword::SourceAcquisitionProtocolElementNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceReconstructionProtocolElementNumber>::s_keyword,
        attribute::get(0x0018, 0x993A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceReconstructionProtocolElementNumber>::s_keyword,
        attribute::get(attribute::Keyword::SourceReconstructionProtocolElementNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionAlgorithmSequence>::s_keyword,
        attribute::get(0x0018, 0x993D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionAlgorithmSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionAlgorithmSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContributingEquipmentSequence>::s_keyword,
        attribute::get(0x0018, 0xA001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContributingEquipmentSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContributingEquipmentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContributionDateTime>::s_keyword,
        attribute::get(0x0018, 0xA002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContributionDateTime>::s_keyword,
        attribute::get(attribute::Keyword::ContributionDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContributionDescription>::s_keyword,
        attribute::get(0x0018, 0xA003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContributionDescription>::s_keyword,
        attribute::get(attribute::Keyword::ContributionDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudyInstanceUID>::s_keyword,
        attribute::get(0x0020, 0x000D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudyInstanceUID>::s_keyword,
        attribute::get(attribute::Keyword::StudyInstanceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesInstanceUID>::s_keyword,
        attribute::get(0x0020, 0x000E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesInstanceUID>::s_keyword,
        attribute::get(attribute::Keyword::SeriesInstanceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudyID>::s_keyword,
        attribute::get(0x0020, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StudyID>::s_keyword,
        attribute::get(attribute::Keyword::StudyID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesNumber>::s_keyword,
        attribute::get(0x0020, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesNumber>::s_keyword,
        attribute::get(attribute::Keyword::SeriesNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionNumber>::s_keyword,
        attribute::get(0x0020, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionNumber>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceNumber>::s_keyword,
        attribute::get(0x0020, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceNumber>::s_keyword,
        attribute::get(attribute::Keyword::InstanceNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientOrientation>::s_keyword,
        attribute::get(0x0020, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientOrientation>::s_keyword,
        attribute::get(attribute::Keyword::PatientOrientation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PyramidLabel>::s_keyword,
        attribute::get(0x0020, 0x0027).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PyramidLabel>::s_keyword,
        attribute::get(attribute::Keyword::PyramidLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePositionPatient>::s_keyword,
        attribute::get(0x0020, 0x0032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePositionPatient>::s_keyword,
        attribute::get(attribute::Keyword::ImagePositionPatient).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageOrientationPatient>::s_keyword,
        attribute::get(0x0020, 0x0037).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageOrientationPatient>::s_keyword,
        attribute::get(attribute::Keyword::ImageOrientationPatient).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameOfReferenceUID>::s_keyword,
        attribute::get(0x0020, 0x0052).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameOfReferenceUID>::s_keyword,
        attribute::get(attribute::Keyword::FrameOfReferenceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Laterality>::s_keyword,
        attribute::get(0x0020, 0x0060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Laterality>::s_keyword,
        attribute::get(attribute::Keyword::Laterality).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageLaterality>::s_keyword,
        attribute::get(0x0020, 0x0062).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageLaterality>::s_keyword,
        attribute::get(attribute::Keyword::ImageLaterality).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalPositionIdentifier>::s_keyword,
        attribute::get(0x0020, 0x0100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalPositionIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::TemporalPositionIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTemporalPositions>::s_keyword,
        attribute::get(0x0020, 0x0105).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTemporalPositions>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfTemporalPositions).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalResolution>::s_keyword,
        attribute::get(0x0020, 0x0110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalResolution>::s_keyword,
        attribute::get(attribute::Keyword::TemporalResolution).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SynchronizationFrameOfReferenceUID>::s_keyword,
        attribute::get(0x0020, 0x0200).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SynchronizationFrameOfReferenceUID>::s_keyword,
        attribute::get(attribute::Keyword::SynchronizationFrameOfReferenceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SOPInstanceUIDOfConcatenationSource>::s_keyword,
        attribute::get(0x0020, 0x0242).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SOPInstanceUIDOfConcatenationSource>::s_keyword,
        attribute::get(attribute::Keyword::SOPInstanceUIDOfConcatenationSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagesInAcquisition>::s_keyword,
        attribute::get(0x0020, 0x1002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagesInAcquisition>::s_keyword,
        attribute::get(attribute::Keyword::ImagesInAcquisition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionReferenceIndicator>::s_keyword,
        attribute::get(0x0020, 0x1040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PositionReferenceIndicator>::s_keyword,
        attribute::get(attribute::Keyword::PositionReferenceIndicator).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceLocation>::s_keyword,
        attribute::get(0x0020, 0x1041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceLocation>::s_keyword,
        attribute::get(attribute::Keyword::SliceLocation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageComments>::s_keyword,
        attribute::get(0x0020, 0x4000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageComments>::s_keyword,
        attribute::get(attribute::Keyword::ImageComments).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StackID>::s_keyword,
        attribute::get(0x0020, 0x9056).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StackID>::s_keyword,
        attribute::get(attribute::Keyword::StackID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InStackPositionNumber>::s_keyword,
        attribute::get(0x0020, 0x9057).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InStackPositionNumber>::s_keyword,
        attribute::get(attribute::Keyword::InStackPositionNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameAnatomySequence>::s_keyword,
        attribute::get(0x0020, 0x9071).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameAnatomySequence>::s_keyword,
        attribute::get(attribute::Keyword::FrameAnatomySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameLaterality>::s_keyword,
        attribute::get(0x0020, 0x9072).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameLaterality>::s_keyword,
        attribute::get(attribute::Keyword::FrameLaterality).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameContentSequence>::s_keyword,
        attribute::get(0x0020, 0x9111).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameContentSequence>::s_keyword,
        attribute::get(attribute::Keyword::FrameContentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanePositionSequence>::s_keyword,
        attribute::get(0x0020, 0x9113).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanePositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::PlanePositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlaneOrientationSequence>::s_keyword,
        attribute::get(0x0020, 0x9116).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlaneOrientationSequence>::s_keyword,
        attribute::get(attribute::Keyword::PlaneOrientationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalPositionIndex>::s_keyword,
        attribute::get(0x0020, 0x9128).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalPositionIndex>::s_keyword,
        attribute::get(attribute::Keyword::TemporalPositionIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalCardiacTriggerDelayTime>::s_keyword,
        attribute::get(0x0020, 0x9153).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalCardiacTriggerDelayTime>::s_keyword,
        attribute::get(attribute::Keyword::NominalCardiacTriggerDelayTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalCardiacTriggerTimePriorToRPeak>::s_keyword,
        attribute::get(0x0020, 0x9154).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalCardiacTriggerTimePriorToRPeak>::s_keyword,
        attribute::get(attribute::Keyword::NominalCardiacTriggerTimePriorToRPeak).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ActualCardiacTriggerTimePriorToRPeak>::s_keyword,
        attribute::get(0x0020, 0x9155).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ActualCardiacTriggerTimePriorToRPeak>::s_keyword,
        attribute::get(attribute::Keyword::ActualCardiacTriggerTimePriorToRPeak).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameAcquisitionNumber>::s_keyword,
        attribute::get(0x0020, 0x9156).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameAcquisitionNumber>::s_keyword,
        attribute::get(attribute::Keyword::FrameAcquisitionNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionIndexValues>::s_keyword,
        attribute::get(0x0020, 0x9157).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionIndexValues>::s_keyword,
        attribute::get(attribute::Keyword::DimensionIndexValues).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameComments>::s_keyword,
        attribute::get(0x0020, 0x9158).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameComments>::s_keyword,
        attribute::get(attribute::Keyword::FrameComments).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConcatenationUID>::s_keyword,
        attribute::get(0x0020, 0x9161).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConcatenationUID>::s_keyword,
        attribute::get(attribute::Keyword::ConcatenationUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InConcatenationNumber>::s_keyword,
        attribute::get(0x0020, 0x9162).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InConcatenationNumber>::s_keyword,
        attribute::get(attribute::Keyword::InConcatenationNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InConcatenationTotalNumber>::s_keyword,
        attribute::get(0x0020, 0x9163).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InConcatenationTotalNumber>::s_keyword,
        attribute::get(attribute::Keyword::InConcatenationTotalNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionOrganizationUID>::s_keyword,
        attribute::get(0x0020, 0x9164).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionOrganizationUID>::s_keyword,
        attribute::get(attribute::Keyword::DimensionOrganizationUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionIndexPointer>::s_keyword,
        attribute::get(0x0020, 0x9165).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionIndexPointer>::s_keyword,
        attribute::get(attribute::Keyword::DimensionIndexPointer).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FunctionalGroupPointer>::s_keyword,
        attribute::get(0x0020, 0x9167).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FunctionalGroupPointer>::s_keyword,
        attribute::get(attribute::Keyword::FunctionalGroupPointer).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UnassignedSharedConvertedAttributesSequence>::s_keyword,
        attribute::get(0x0020, 0x9170).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UnassignedSharedConvertedAttributesSequence>::s_keyword,
        attribute::get(attribute::Keyword::UnassignedSharedConvertedAttributesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UnassignedPerFrameConvertedAttributesSequence>::s_keyword,
        attribute::get(0x0020, 0x9171).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UnassignedPerFrameConvertedAttributesSequence>::s_keyword,
        attribute::get(attribute::Keyword::UnassignedPerFrameConvertedAttributesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConversionSourceAttributesSequence>::s_keyword,
        attribute::get(0x0020, 0x9172).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConversionSourceAttributesSequence>::s_keyword,
        attribute::get(attribute::Keyword::ConversionSourceAttributesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionIndexPrivateCreator>::s_keyword,
        attribute::get(0x0020, 0x9213).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionIndexPrivateCreator>::s_keyword,
        attribute::get(attribute::Keyword::DimensionIndexPrivateCreator).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionOrganizationSequence>::s_keyword,
        attribute::get(0x0020, 0x9221).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionOrganizationSequence>::s_keyword,
        attribute::get(attribute::Keyword::DimensionOrganizationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionIndexSequence>::s_keyword,
        attribute::get(0x0020, 0x9222).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionIndexSequence>::s_keyword,
        attribute::get(attribute::Keyword::DimensionIndexSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConcatenationFrameOffsetNumber>::s_keyword,
        attribute::get(0x0020, 0x9228).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConcatenationFrameOffsetNumber>::s_keyword,
        attribute::get(attribute::Keyword::ConcatenationFrameOffsetNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FunctionalGroupPrivateCreator>::s_keyword,
        attribute::get(0x0020, 0x9238).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FunctionalGroupPrivateCreator>::s_keyword,
        attribute::get(attribute::Keyword::FunctionalGroupPrivateCreator).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalPercentageOfCardiacPhase>::s_keyword,
        attribute::get(0x0020, 0x9241).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalPercentageOfCardiacPhase>::s_keyword,
        attribute::get(attribute::Keyword::NominalPercentageOfCardiacPhase).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalPercentageOfRespiratoryPhase>::s_keyword,
        attribute::get(0x0020, 0x9245).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalPercentageOfRespiratoryPhase>::s_keyword,
        attribute::get(attribute::Keyword::NominalPercentageOfRespiratoryPhase).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartingRespiratoryAmplitude>::s_keyword,
        attribute::get(0x0020, 0x9246).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartingRespiratoryAmplitude>::s_keyword,
        attribute::get(attribute::Keyword::StartingRespiratoryAmplitude).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartingRespiratoryPhase>::s_keyword,
        attribute::get(0x0020, 0x9247).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartingRespiratoryPhase>::s_keyword,
        attribute::get(attribute::Keyword::StartingRespiratoryPhase).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EndingRespiratoryAmplitude>::s_keyword,
        attribute::get(0x0020, 0x9248).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EndingRespiratoryAmplitude>::s_keyword,
        attribute::get(attribute::Keyword::EndingRespiratoryAmplitude).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EndingRespiratoryPhase>::s_keyword,
        attribute::get(0x0020, 0x9249).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EndingRespiratoryPhase>::s_keyword,
        attribute::get(attribute::Keyword::EndingRespiratoryPhase).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratoryTriggerType>::s_keyword,
        attribute::get(0x0020, 0x9250).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratoryTriggerType>::s_keyword,
        attribute::get(attribute::Keyword::RespiratoryTriggerType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RRIntervalTimeNominal>::s_keyword,
        attribute::get(0x0020, 0x9251).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RRIntervalTimeNominal>::s_keyword,
        attribute::get(attribute::Keyword::RRIntervalTimeNominal).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ActualCardiacTriggerDelayTime>::s_keyword,
        attribute::get(0x0020, 0x9252).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ActualCardiacTriggerDelayTime>::s_keyword,
        attribute::get(attribute::Keyword::ActualCardiacTriggerDelayTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratorySynchronizationSequence>::s_keyword,
        attribute::get(0x0020, 0x9253).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratorySynchronizationSequence>::s_keyword,
        attribute::get(attribute::Keyword::RespiratorySynchronizationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratoryIntervalTime>::s_keyword,
        attribute::get(0x0020, 0x9254).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratoryIntervalTime>::s_keyword,
        attribute::get(attribute::Keyword::RespiratoryIntervalTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalRespiratoryTriggerDelayTime>::s_keyword,
        attribute::get(0x0020, 0x9255).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalRespiratoryTriggerDelayTime>::s_keyword,
        attribute::get(attribute::Keyword::NominalRespiratoryTriggerDelayTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratoryTriggerDelayThreshold>::s_keyword,
        attribute::get(0x0020, 0x9256).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RespiratoryTriggerDelayThreshold>::s_keyword,
        attribute::get(attribute::Keyword::RespiratoryTriggerDelayThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ActualRespiratoryTriggerDelayTime>::s_keyword,
        attribute::get(0x0020, 0x9257).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ActualRespiratoryTriggerDelayTime>::s_keyword,
        attribute::get(attribute::Keyword::ActualRespiratoryTriggerDelayTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePositionVolume>::s_keyword,
        attribute::get(0x0020, 0x9301).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePositionVolume>::s_keyword,
        attribute::get(attribute::Keyword::ImagePositionVolume).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageOrientationVolume>::s_keyword,
        attribute::get(0x0020, 0x9302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageOrientationVolume>::s_keyword,
        attribute::get(attribute::Keyword::ImageOrientationVolume).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UltrasoundAcquisitionGeometry>::s_keyword,
        attribute::get(0x0020, 0x9307).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UltrasoundAcquisitionGeometry>::s_keyword,
        attribute::get(attribute::Keyword::UltrasoundAcquisitionGeometry).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApexPosition>::s_keyword,
        attribute::get(0x0020, 0x9308).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApexPosition>::s_keyword,
        attribute::get(attribute::Keyword::ApexPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumeToTransducerMappingMatrix>::s_keyword,
        attribute::get(0x0020, 0x9309).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumeToTransducerMappingMatrix>::s_keyword,
        attribute::get(attribute::Keyword::VolumeToTransducerMappingMatrix).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumeToTableMappingMatrix>::s_keyword,
        attribute::get(0x0020, 0x930A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumeToTableMappingMatrix>::s_keyword,
        attribute::get(attribute::Keyword::VolumeToTableMappingMatrix).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumeToTransducerRelationship>::s_keyword,
        attribute::get(0x0020, 0x930B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumeToTransducerRelationship>::s_keyword,
        attribute::get(attribute::Keyword::VolumeToTransducerRelationship).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientFrameOfReferenceSource>::s_keyword,
        attribute::get(0x0020, 0x930C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientFrameOfReferenceSource>::s_keyword,
        attribute::get(attribute::Keyword::PatientFrameOfReferenceSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalPositionTimeOffset>::s_keyword,
        attribute::get(0x0020, 0x930D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalPositionTimeOffset>::s_keyword,
        attribute::get(attribute::Keyword::TemporalPositionTimeOffset).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanePositionVolumeSequence>::s_keyword,
        attribute::get(0x0020, 0x930E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanePositionVolumeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PlanePositionVolumeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlaneOrientationVolumeSequence>::s_keyword,
        attribute::get(0x0020, 0x930F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlaneOrientationVolumeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PlaneOrientationVolumeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalPositionSequence>::s_keyword,
        attribute::get(0x0020, 0x9310).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalPositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::TemporalPositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionOrganizationType>::s_keyword,
        attribute::get(0x0020, 0x9311).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionOrganizationType>::s_keyword,
        attribute::get(attribute::Keyword::DimensionOrganizationType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumeFrameOfReferenceUID>::s_keyword,
        attribute::get(0x0020, 0x9312).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VolumeFrameOfReferenceUID>::s_keyword,
        attribute::get(attribute::Keyword::VolumeFrameOfReferenceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableFrameOfReferenceUID>::s_keyword,
        attribute::get(0x0020, 0x9313).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableFrameOfReferenceUID>::s_keyword,
        attribute::get(attribute::Keyword::TableFrameOfReferenceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionDescriptionLabel>::s_keyword,
        attribute::get(0x0020, 0x9421).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DimensionDescriptionLabel>::s_keyword,
        attribute::get(attribute::Keyword::DimensionDescriptionLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientOrientationInFrameSequence>::s_keyword,
        attribute::get(0x0020, 0x9450).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientOrientationInFrameSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientOrientationInFrameSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameLabel>::s_keyword,
        attribute::get(0x0020, 0x9453).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameLabel>::s_keyword,
        attribute::get(attribute::Keyword::FrameLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionIndex>::s_keyword,
        attribute::get(0x0020, 0x9518).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionIndex>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContributingSOPInstancesReferenceSequence>::s_keyword,
        attribute::get(0x0020, 0x9529).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContributingSOPInstancesReferenceSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContributingSOPInstancesReferenceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionIndex>::s_keyword,
        attribute::get(0x0020, 0x9536).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionIndex>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LightPathFilterPassThroughWavelength>::s_keyword,
        attribute::get(0x0022, 0x0001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LightPathFilterPassThroughWavelength>::s_keyword,
        attribute::get(attribute::Keyword::LightPathFilterPassThroughWavelength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LightPathFilterPassBand>::s_keyword,
        attribute::get(0x0022, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LightPathFilterPassBand>::s_keyword,
        attribute::get(attribute::Keyword::LightPathFilterPassBand).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePathFilterPassThroughWavelength>::s_keyword,
        attribute::get(0x0022, 0x0003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePathFilterPassThroughWavelength>::s_keyword,
        attribute::get(attribute::Keyword::ImagePathFilterPassThroughWavelength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePathFilterPassBand>::s_keyword,
        attribute::get(0x0022, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePathFilterPassBand>::s_keyword,
        attribute::get(attribute::Keyword::ImagePathFilterPassBand).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientEyeMovementCommanded>::s_keyword,
        attribute::get(0x0022, 0x0005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientEyeMovementCommanded>::s_keyword,
        attribute::get(attribute::Keyword::PatientEyeMovementCommanded).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientEyeMovementCommandCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientEyeMovementCommandCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientEyeMovementCommandCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SphericalLensPower>::s_keyword,
        attribute::get(0x0022, 0x0007).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SphericalLensPower>::s_keyword,
        attribute::get(attribute::Keyword::SphericalLensPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CylinderLensPower>::s_keyword,
        attribute::get(0x0022, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CylinderLensPower>::s_keyword,
        attribute::get(attribute::Keyword::CylinderLensPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CylinderAxis>::s_keyword,
        attribute::get(0x0022, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CylinderAxis>::s_keyword,
        attribute::get(attribute::Keyword::CylinderAxis).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EmmetropicMagnification>::s_keyword,
        attribute::get(0x0022, 0x000A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EmmetropicMagnification>::s_keyword,
        attribute::get(attribute::Keyword::EmmetropicMagnification).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntraOcularPressure>::s_keyword,
        attribute::get(0x0022, 0x000B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntraOcularPressure>::s_keyword,
        attribute::get(attribute::Keyword::IntraOcularPressure).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HorizontalFieldOfView>::s_keyword,
        attribute::get(0x0022, 0x000C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HorizontalFieldOfView>::s_keyword,
        attribute::get(attribute::Keyword::HorizontalFieldOfView).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PupilDilated>::s_keyword,
        attribute::get(0x0022, 0x000D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PupilDilated>::s_keyword,
        attribute::get(attribute::Keyword::PupilDilated).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DegreeOfDilation>::s_keyword,
        attribute::get(0x0022, 0x000E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DegreeOfDilation>::s_keyword,
        attribute::get(attribute::Keyword::DegreeOfDilation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDeviceTypeCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDeviceTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionDeviceTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationTypeCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x0016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::IlluminationTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LightPathFilterTypeStackCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x0017).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LightPathFilterTypeStackCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::LightPathFilterTypeStackCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePathFilterTypeStackCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x0018).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePathFilterTypeStackCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ImagePathFilterTypeStackCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LensesCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x0019).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LensesCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::LensesCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ChannelDescriptionCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x001A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ChannelDescriptionCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ChannelDescriptionCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RefractiveStateSequence>::s_keyword,
        attribute::get(0x0022, 0x001B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RefractiveStateSequence>::s_keyword,
        attribute::get(attribute::Keyword::RefractiveStateSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MydriaticAgentCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x001C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MydriaticAgentCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::MydriaticAgentCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelativeImagePositionCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x001D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelativeImagePositionCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::RelativeImagePositionCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CameraAngleOfView>::s_keyword,
        attribute::get(0x0022, 0x001E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CameraAngleOfView>::s_keyword,
        attribute::get(attribute::Keyword::CameraAngleOfView).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StereoPairsPresent>::s_keyword,
        attribute::get(0x0022, 0x0028).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StereoPairsPresent>::s_keyword,
        attribute::get(attribute::Keyword::StereoPairsPresent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialLengthOfTheEye>::s_keyword,
        attribute::get(0x0022, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialLengthOfTheEye>::s_keyword,
        attribute::get(attribute::Keyword::AxialLengthOfTheEye).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicFrameLocationSequence>::s_keyword,
        attribute::get(0x0022, 0x0031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicFrameLocationSequence>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicFrameLocationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferenceCoordinates>::s_keyword,
        attribute::get(0x0022, 0x0032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferenceCoordinates>::s_keyword,
        attribute::get(attribute::Keyword::ReferenceCoordinates).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DepthSpatialResolution>::s_keyword,
        attribute::get(0x0022, 0x0035).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DepthSpatialResolution>::s_keyword,
        attribute::get(attribute::Keyword::DepthSpatialResolution).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumDepthDistortion>::s_keyword,
        attribute::get(0x0022, 0x0036).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumDepthDistortion>::s_keyword,
        attribute::get(attribute::Keyword::MaximumDepthDistortion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlongScanSpatialResolution>::s_keyword,
        attribute::get(0x0022, 0x0037).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlongScanSpatialResolution>::s_keyword,
        attribute::get(attribute::Keyword::AlongScanSpatialResolution).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumAlongScanDistortion>::s_keyword,
        attribute::get(0x0022, 0x0038).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumAlongScanDistortion>::s_keyword,
        attribute::get(attribute::Keyword::MaximumAlongScanDistortion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicImageOrientation>::s_keyword,
        attribute::get(0x0022, 0x0039).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicImageOrientation>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicImageOrientation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DepthOfTransverseImage>::s_keyword,
        attribute::get(0x0022, 0x0041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DepthOfTransverseImage>::s_keyword,
        attribute::get(attribute::Keyword::DepthOfTransverseImage).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MydriaticAgentConcentrationUnitsSequence>::s_keyword,
        attribute::get(0x0022, 0x0042).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MydriaticAgentConcentrationUnitsSequence>::s_keyword,
        attribute::get(attribute::Keyword::MydriaticAgentConcentrationUnitsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcrossScanSpatialResolution>::s_keyword,
        attribute::get(0x0022, 0x0048).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcrossScanSpatialResolution>::s_keyword,
        attribute::get(attribute::Keyword::AcrossScanSpatialResolution).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumAcrossScanDistortion>::s_keyword,
        attribute::get(0x0022, 0x0049).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumAcrossScanDistortion>::s_keyword,
        attribute::get(attribute::Keyword::MaximumAcrossScanDistortion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MydriaticAgentConcentration>::s_keyword,
        attribute::get(0x0022, 0x004E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MydriaticAgentConcentration>::s_keyword,
        attribute::get(attribute::Keyword::MydriaticAgentConcentration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationWaveLength>::s_keyword,
        attribute::get(0x0022, 0x0055).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationWaveLength>::s_keyword,
        attribute::get(attribute::Keyword::IlluminationWaveLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationPower>::s_keyword,
        attribute::get(0x0022, 0x0056).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationPower>::s_keyword,
        attribute::get(attribute::Keyword::IlluminationPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationBandwidth>::s_keyword,
        attribute::get(0x0022, 0x0057).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationBandwidth>::s_keyword,
        attribute::get(attribute::Keyword::IlluminationBandwidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MydriaticAgentSequence>::s_keyword,
        attribute::get(0x0022, 0x0058).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MydriaticAgentSequence>::s_keyword,
        attribute::get(attribute::Keyword::MydriaticAgentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicAxialLength>::s_keyword,
        attribute::get(0x0022, 0x1019).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicAxialLength>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicAxialLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantName>::s_keyword,
        attribute::get(0x0022, 0x1095).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantName>::s_keyword,
        attribute::get(attribute::Keyword::ImplantName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantPartNumber>::s_keyword,
        attribute::get(0x0022, 0x1097).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantPartNumber>::s_keyword,
        attribute::get(attribute::Keyword::ImplantPartNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicMappingDeviceType>::s_keyword,
        attribute::get(0x0022, 0x1415).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicMappingDeviceType>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicMappingDeviceType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionMethodCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x1420).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionMethodCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionMethodCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionMethodAlgorithmSequence>::s_keyword,
        attribute::get(0x0022, 0x1423).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionMethodAlgorithmSequence>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionMethodAlgorithmSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicThicknessMapTypeCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x1436).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicThicknessMapTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicThicknessMapTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicThicknessMappingNormalsSequence>::s_keyword,
        attribute::get(0x0022, 0x1443).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicThicknessMappingNormalsSequence>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicThicknessMappingNormalsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RetinalThicknessDefinitionCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x1445).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RetinalThicknessDefinitionCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::RetinalThicknessDefinitionCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelValueMappingToCodedConceptSequence>::s_keyword,
        attribute::get(0x0022, 0x1450).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelValueMappingToCodedConceptSequence>::s_keyword,
        attribute::get(attribute::Keyword::PixelValueMappingToCodedConceptSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MappedPixelValue>::s_keyword,
        attribute::get(0x0022, 0x1452).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MappedPixelValue>::s_keyword,
        attribute::get(attribute::Keyword::MappedPixelValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelValueMappingExplanation>::s_keyword,
        attribute::get(0x0022, 0x1454).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelValueMappingExplanation>::s_keyword,
        attribute::get(attribute::Keyword::PixelValueMappingExplanation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicThicknessMapQualityThresholdSequence>::s_keyword,
        attribute::get(0x0022, 0x1458).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicThicknessMapQualityThresholdSequence>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicThicknessMapQualityThresholdSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnatomicStructureReferencePoint>::s_keyword,
        attribute::get(0x0022, 0x1463).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnatomicStructureReferencePoint>::s_keyword,
        attribute::get(attribute::Keyword::AnatomicStructureReferencePoint).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegistrationToLocalizerSequence>::s_keyword,
        attribute::get(0x0022, 0x1465).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegistrationToLocalizerSequence>::s_keyword,
        attribute::get(attribute::Keyword::RegistrationToLocalizerSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegisteredLocalizerUnits>::s_keyword,
        attribute::get(0x0022, 0x1466).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegisteredLocalizerUnits>::s_keyword,
        attribute::get(attribute::Keyword::RegisteredLocalizerUnits).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegisteredLocalizerTopLeftHandCorner>::s_keyword,
        attribute::get(0x0022, 0x1467).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegisteredLocalizerTopLeftHandCorner>::s_keyword,
        attribute::get(attribute::Keyword::RegisteredLocalizerTopLeftHandCorner).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegisteredLocalizerBottomRightHandCorner>::s_keyword,
        attribute::get(0x0022, 0x1468).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegisteredLocalizerBottomRightHandCorner>::s_keyword,
        attribute::get(attribute::Keyword::RegisteredLocalizerBottomRightHandCorner).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicThicknessMapQualityRatingSequence>::s_keyword,
        attribute::get(0x0022, 0x1470).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicThicknessMapQualityRatingSequence>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicThicknessMapQualityRatingSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelevantOPTAttributesSequence>::s_keyword,
        attribute::get(0x0022, 0x1472).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelevantOPTAttributesSequence>::s_keyword,
        attribute::get(attribute::Keyword::RelevantOPTAttributesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransformationMethodCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x1512).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransformationMethodCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::TransformationMethodCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransformationAlgorithmSequence>::s_keyword,
        attribute::get(0x0022, 0x1513).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransformationAlgorithmSequence>::s_keyword,
        attribute::get(attribute::Keyword::TransformationAlgorithmSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicAxialLengthMethod>::s_keyword,
        attribute::get(0x0022, 0x1515).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicAxialLengthMethod>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicAxialLengthMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicFOV>::s_keyword,
        attribute::get(0x0022, 0x1517).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicFOV>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicFOV).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDimensionalToThreeDimensionalMapSequence>::s_keyword,
        attribute::get(0x0022, 0x1518).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDimensionalToThreeDimensionalMapSequence>::s_keyword,
        attribute::get(attribute::Keyword::TwoDimensionalToThreeDimensionalMapSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WideFieldOphthalmicPhotographyQualityRatingSequence>::s_keyword,
        attribute::get(0x0022, 0x1525).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WideFieldOphthalmicPhotographyQualityRatingSequence>::s_keyword,
        attribute::get(attribute::Keyword::WideFieldOphthalmicPhotographyQualityRatingSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WideFieldOphthalmicPhotographyQualityThresholdSequence>::s_keyword,
        attribute::get(0x0022, 0x1526).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WideFieldOphthalmicPhotographyQualityThresholdSequence>::s_keyword,
        attribute::get(attribute::Keyword::WideFieldOphthalmicPhotographyQualityThresholdSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XCoordinatesCenterPixelViewAngle>::s_keyword,
        attribute::get(0x0022, 0x1528).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XCoordinatesCenterPixelViewAngle>::s_keyword,
        attribute::get(attribute::Keyword::XCoordinatesCenterPixelViewAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::YCoordinatesCenterPixelViewAngle>::s_keyword,
        attribute::get(0x0022, 0x1529).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::YCoordinatesCenterPixelViewAngle>::s_keyword,
        attribute::get(attribute::Keyword::YCoordinatesCenterPixelViewAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfMapPoints>::s_keyword,
        attribute::get(0x0022, 0x1530).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfMapPoints>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfMapPoints).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDimensionalToThreeDimensionalMapData>::s_keyword,
        attribute::get(0x0022, 0x1531).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDimensionalToThreeDimensionalMapData>::s_keyword,
        attribute::get(attribute::Keyword::TwoDimensionalToThreeDimensionalMapData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DerivationAlgorithmSequence>::s_keyword,
        attribute::get(0x0022, 0x1612).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DerivationAlgorithmSequence>::s_keyword,
        attribute::get(attribute::Keyword::DerivationAlgorithmSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicImageTypeCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x1615).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicImageTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicImageTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicImageTypeDescription>::s_keyword,
        attribute::get(0x0022, 0x1616).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicImageTypeDescription>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicImageTypeDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanPatternTypeCodeSequence>::s_keyword,
        attribute::get(0x0022, 0x1618).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanPatternTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ScanPatternTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSurfaceMeshIdentificationSequence>::s_keyword,
        attribute::get(0x0022, 0x1620).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSurfaceMeshIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSurfaceMeshIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicVolumetricPropertiesFlag>::s_keyword,
        attribute::get(0x0022, 0x1622).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicVolumetricPropertiesFlag>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicVolumetricPropertiesFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicAnatomicReferencePointXCoordinate>::s_keyword,
        attribute::get(0x0022, 0x1624).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicAnatomicReferencePointXCoordinate>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicAnatomicReferencePointXCoordinate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicAnatomicReferencePointYCoordinate>::s_keyword,
        attribute::get(0x0022, 0x1626).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicAnatomicReferencePointYCoordinate>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicAnatomicReferencePointYCoordinate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicEnFaceImageQualityRatingSequence>::s_keyword,
        attribute::get(0x0022, 0x1628).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OphthalmicEnFaceImageQualityRatingSequence>::s_keyword,
        attribute::get(attribute::Keyword::OphthalmicEnFaceImageQualityRatingSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QualityThreshold>::s_keyword,
        attribute::get(0x0022, 0x1630).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QualityThreshold>::s_keyword,
        attribute::get(attribute::Keyword::QualityThreshold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTBscanAnalysisAcquisitionParametersSequence>::s_keyword,
        attribute::get(0x0022, 0x1640).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTBscanAnalysisAcquisitionParametersSequence>::s_keyword,
        attribute::get(attribute::Keyword::OCTBscanAnalysisAcquisitionParametersSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfBscansPerFrame>::s_keyword,
        attribute::get(0x0022, 0x1642).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfBscansPerFrame>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfBscansPerFrame).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BscanSlabThickness>::s_keyword,
        attribute::get(0x0022, 0x1643).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BscanSlabThickness>::s_keyword,
        attribute::get(attribute::Keyword::BscanSlabThickness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceBetweenBscanSlabs>::s_keyword,
        attribute::get(0x0022, 0x1644).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceBetweenBscanSlabs>::s_keyword,
        attribute::get(attribute::Keyword::DistanceBetweenBscanSlabs).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BscanCycleTime>::s_keyword,
        attribute::get(0x0022, 0x1645).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BscanCycleTime>::s_keyword,
        attribute::get(attribute::Keyword::BscanCycleTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BscanCycleTimeVector>::s_keyword,
        attribute::get(0x0022, 0x1646).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BscanCycleTimeVector>::s_keyword,
        attribute::get(attribute::Keyword::BscanCycleTimeVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AscanRate>::s_keyword,
        attribute::get(0x0022, 0x1649).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AscanRate>::s_keyword,
        attribute::get(attribute::Keyword::AscanRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BscanRate>::s_keyword,
        attribute::get(0x0022, 0x1650).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BscanRate>::s_keyword,
        attribute::get(attribute::Keyword::BscanRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceMeshZPixelOffset>::s_keyword,
        attribute::get(0x0022, 0x1658).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceMeshZPixelOffset>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceMeshZPixelOffset).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmSource>::s_keyword,
        attribute::get(0x0024, 0x0202).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmSource>::s_keyword,
        attribute::get(attribute::Keyword::AlgorithmSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataSetName>::s_keyword,
        attribute::get(0x0024, 0x0306).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataSetName>::s_keyword,
        attribute::get(attribute::Keyword::DataSetName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataSetVersion>::s_keyword,
        attribute::get(0x0024, 0x0307).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataSetVersion>::s_keyword,
        attribute::get(attribute::Keyword::DataSetVersion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataSetSource>::s_keyword,
        attribute::get(0x0024, 0x0308).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataSetSource>::s_keyword,
        attribute::get(attribute::Keyword::DataSetSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataSetDescription>::s_keyword,
        attribute::get(0x0024, 0x0309).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataSetDescription>::s_keyword,
        attribute::get(attribute::Keyword::DataSetDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SamplesPerPixel>::s_keyword,
        attribute::get(0x0028, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SamplesPerPixel>::s_keyword,
        attribute::get(attribute::Keyword::SamplesPerPixel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SamplesPerPixelUsed>::s_keyword,
        attribute::get(0x0028, 0x0003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SamplesPerPixelUsed>::s_keyword,
        attribute::get(attribute::Keyword::SamplesPerPixelUsed).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhotometricInterpretation>::s_keyword,
        attribute::get(0x0028, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhotometricInterpretation>::s_keyword,
        attribute::get(attribute::Keyword::PhotometricInterpretation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanarConfiguration>::s_keyword,
        attribute::get(0x0028, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanarConfiguration>::s_keyword,
        attribute::get(attribute::Keyword::PlanarConfiguration).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFrames>::s_keyword,
        attribute::get(0x0028, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFrames>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfFrames).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameIncrementPointer>::s_keyword,
        attribute::get(0x0028, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameIncrementPointer>::s_keyword,
        attribute::get(attribute::Keyword::FrameIncrementPointer).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameDimensionPointer>::s_keyword,
        attribute::get(0x0028, 0x000A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameDimensionPointer>::s_keyword,
        attribute::get(attribute::Keyword::FrameDimensionPointer).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Rows>::s_keyword,
        attribute::get(0x0028, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Rows>::s_keyword,
        attribute::get(attribute::Keyword::Rows).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Columns>::s_keyword,
        attribute::get(0x0028, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Columns>::s_keyword,
        attribute::get(attribute::Keyword::Columns).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UltrasoundColorDataPresent>::s_keyword,
        attribute::get(0x0028, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UltrasoundColorDataPresent>::s_keyword,
        attribute::get(attribute::Keyword::UltrasoundColorDataPresent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelSpacing>::s_keyword,
        attribute::get(0x0028, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelSpacing>::s_keyword,
        attribute::get(attribute::Keyword::PixelSpacing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ZoomFactor>::s_keyword,
        attribute::get(0x0028, 0x0031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ZoomFactor>::s_keyword,
        attribute::get(attribute::Keyword::ZoomFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ZoomCenter>::s_keyword,
        attribute::get(0x0028, 0x0032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ZoomCenter>::s_keyword,
        attribute::get(attribute::Keyword::ZoomCenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelAspectRatio>::s_keyword,
        attribute::get(0x0028, 0x0034).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelAspectRatio>::s_keyword,
        attribute::get(attribute::Keyword::PixelAspectRatio).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CorrectedImage>::s_keyword,
        attribute::get(0x0028, 0x0051).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CorrectedImage>::s_keyword,
        attribute::get(attribute::Keyword::CorrectedImage).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BitsAllocated>::s_keyword,
        attribute::get(0x0028, 0x0100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BitsAllocated>::s_keyword,
        attribute::get(attribute::Keyword::BitsAllocated).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BitsStored>::s_keyword,
        attribute::get(0x0028, 0x0101).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BitsStored>::s_keyword,
        attribute::get(attribute::Keyword::BitsStored).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HighBit>::s_keyword,
        attribute::get(0x0028, 0x0102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HighBit>::s_keyword,
        attribute::get(attribute::Keyword::HighBit).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelRepresentation>::s_keyword,
        attribute::get(0x0028, 0x0103).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelRepresentation>::s_keyword,
        attribute::get(attribute::Keyword::PixelRepresentation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SmallestImagePixelValue>::s_keyword,
        attribute::get(0x0028, 0x0106).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SmallestImagePixelValue>::s_keyword,
        attribute::get(attribute::Keyword::SmallestImagePixelValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LargestImagePixelValue>::s_keyword,
        attribute::get(0x0028, 0x0107).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LargestImagePixelValue>::s_keyword,
        attribute::get(attribute::Keyword::LargestImagePixelValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SmallestPixelValueInSeries>::s_keyword,
        attribute::get(0x0028, 0x0108).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SmallestPixelValueInSeries>::s_keyword,
        attribute::get(attribute::Keyword::SmallestPixelValueInSeries).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LargestPixelValueInSeries>::s_keyword,
        attribute::get(0x0028, 0x0109).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LargestPixelValueInSeries>::s_keyword,
        attribute::get(attribute::Keyword::LargestPixelValueInSeries).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelPaddingValue>::s_keyword,
        attribute::get(0x0028, 0x0120).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelPaddingValue>::s_keyword,
        attribute::get(attribute::Keyword::PixelPaddingValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelPaddingRangeLimit>::s_keyword,
        attribute::get(0x0028, 0x0121).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelPaddingRangeLimit>::s_keyword,
        attribute::get(attribute::Keyword::PixelPaddingRangeLimit).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FloatPixelPaddingValue>::s_keyword,
        attribute::get(0x0028, 0x0122).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FloatPixelPaddingValue>::s_keyword,
        attribute::get(attribute::Keyword::FloatPixelPaddingValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoubleFloatPixelPaddingValue>::s_keyword,
        attribute::get(0x0028, 0x0123).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoubleFloatPixelPaddingValue>::s_keyword,
        attribute::get(attribute::Keyword::DoubleFloatPixelPaddingValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FloatPixelPaddingRangeLimit>::s_keyword,
        attribute::get(0x0028, 0x0124).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FloatPixelPaddingRangeLimit>::s_keyword,
        attribute::get(attribute::Keyword::FloatPixelPaddingRangeLimit).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoubleFloatPixelPaddingRangeLimit>::s_keyword,
        attribute::get(0x0028, 0x0125).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoubleFloatPixelPaddingRangeLimit>::s_keyword,
        attribute::get(attribute::Keyword::DoubleFloatPixelPaddingRangeLimit).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QualityControlImage>::s_keyword,
        attribute::get(0x0028, 0x0300).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QualityControlImage>::s_keyword,
        attribute::get(attribute::Keyword::QualityControlImage).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BurnedInAnnotation>::s_keyword,
        attribute::get(0x0028, 0x0301).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BurnedInAnnotation>::s_keyword,
        attribute::get(attribute::Keyword::BurnedInAnnotation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecognizableVisualFeatures>::s_keyword,
        attribute::get(0x0028, 0x0302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecognizableVisualFeatures>::s_keyword,
        attribute::get(attribute::Keyword::RecognizableVisualFeatures).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LongitudinalTemporalInformationModified>::s_keyword,
        attribute::get(0x0028, 0x0303).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LongitudinalTemporalInformationModified>::s_keyword,
        attribute::get(attribute::Keyword::LongitudinalTemporalInformationModified).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedColorPaletteInstanceUID>::s_keyword,
        attribute::get(0x0028, 0x0304).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedColorPaletteInstanceUID>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedColorPaletteInstanceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelSpacingCalibrationType>::s_keyword,
        attribute::get(0x0028, 0x0A02).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelSpacingCalibrationType>::s_keyword,
        attribute::get(attribute::Keyword::PixelSpacingCalibrationType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelSpacingCalibrationDescription>::s_keyword,
        attribute::get(0x0028, 0x0A04).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelSpacingCalibrationDescription>::s_keyword,
        attribute::get(attribute::Keyword::PixelSpacingCalibrationDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelIntensityRelationship>::s_keyword,
        attribute::get(0x0028, 0x1040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelIntensityRelationship>::s_keyword,
        attribute::get(attribute::Keyword::PixelIntensityRelationship).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelIntensityRelationshipSign>::s_keyword,
        attribute::get(0x0028, 0x1041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelIntensityRelationshipSign>::s_keyword,
        attribute::get(attribute::Keyword::PixelIntensityRelationshipSign).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WindowCenter>::s_keyword,
        attribute::get(0x0028, 0x1050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WindowCenter>::s_keyword,
        attribute::get(attribute::Keyword::WindowCenter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WindowWidth>::s_keyword,
        attribute::get(0x0028, 0x1051).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WindowWidth>::s_keyword,
        attribute::get(attribute::Keyword::WindowWidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RescaleIntercept>::s_keyword,
        attribute::get(0x0028, 0x1052).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RescaleIntercept>::s_keyword,
        attribute::get(attribute::Keyword::RescaleIntercept).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RescaleSlope>::s_keyword,
        attribute::get(0x0028, 0x1053).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RescaleSlope>::s_keyword,
        attribute::get(attribute::Keyword::RescaleSlope).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RescaleType>::s_keyword,
        attribute::get(0x0028, 0x1054).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RescaleType>::s_keyword,
        attribute::get(attribute::Keyword::RescaleType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WindowCenterWidthExplanation>::s_keyword,
        attribute::get(0x0028, 0x1055).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WindowCenterWidthExplanation>::s_keyword,
        attribute::get(attribute::Keyword::WindowCenterWidthExplanation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VOILUTFunction>::s_keyword,
        attribute::get(0x0028, 0x1056).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VOILUTFunction>::s_keyword,
        attribute::get(attribute::Keyword::VOILUTFunction).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedViewingMode>::s_keyword,
        attribute::get(0x0028, 0x1090).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedViewingMode>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedViewingMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RedPaletteColorLookupTableDescriptor>::s_keyword,
        attribute::get(0x0028, 0x1101).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RedPaletteColorLookupTableDescriptor>::s_keyword,
        attribute::get(attribute::Keyword::RedPaletteColorLookupTableDescriptor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GreenPaletteColorLookupTableDescriptor>::s_keyword,
        attribute::get(0x0028, 0x1102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GreenPaletteColorLookupTableDescriptor>::s_keyword,
        attribute::get(attribute::Keyword::GreenPaletteColorLookupTableDescriptor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BluePaletteColorLookupTableDescriptor>::s_keyword,
        attribute::get(0x0028, 0x1103).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BluePaletteColorLookupTableDescriptor>::s_keyword,
        attribute::get(attribute::Keyword::BluePaletteColorLookupTableDescriptor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlphaPaletteColorLookupTableDescriptor>::s_keyword,
        attribute::get(0x0028, 0x1104).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlphaPaletteColorLookupTableDescriptor>::s_keyword,
        attribute::get(attribute::Keyword::AlphaPaletteColorLookupTableDescriptor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PaletteColorLookupTableUID>::s_keyword,
        attribute::get(0x0028, 0x1199).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PaletteColorLookupTableUID>::s_keyword,
        attribute::get(attribute::Keyword::PaletteColorLookupTableUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RedPaletteColorLookupTableData>::s_keyword,
        attribute::get(0x0028, 0x1201).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RedPaletteColorLookupTableData>::s_keyword,
        attribute::get(attribute::Keyword::RedPaletteColorLookupTableData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GreenPaletteColorLookupTableData>::s_keyword,
        attribute::get(0x0028, 0x1202).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GreenPaletteColorLookupTableData>::s_keyword,
        attribute::get(attribute::Keyword::GreenPaletteColorLookupTableData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BluePaletteColorLookupTableData>::s_keyword,
        attribute::get(0x0028, 0x1203).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BluePaletteColorLookupTableData>::s_keyword,
        attribute::get(attribute::Keyword::BluePaletteColorLookupTableData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlphaPaletteColorLookupTableData>::s_keyword,
        attribute::get(0x0028, 0x1204).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlphaPaletteColorLookupTableData>::s_keyword,
        attribute::get(attribute::Keyword::AlphaPaletteColorLookupTableData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedRedPaletteColorLookupTableData>::s_keyword,
        attribute::get(0x0028, 0x1221).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedRedPaletteColorLookupTableData>::s_keyword,
        attribute::get(attribute::Keyword::SegmentedRedPaletteColorLookupTableData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedGreenPaletteColorLookupTableData>::s_keyword,
        attribute::get(0x0028, 0x1222).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedGreenPaletteColorLookupTableData>::s_keyword,
        attribute::get(attribute::Keyword::SegmentedGreenPaletteColorLookupTableData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedBluePaletteColorLookupTableData>::s_keyword,
        attribute::get(0x0028, 0x1223).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedBluePaletteColorLookupTableData>::s_keyword,
        attribute::get(attribute::Keyword::SegmentedBluePaletteColorLookupTableData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StoredValueColorRangeSequence>::s_keyword,
        attribute::get(0x0028, 0x1230).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StoredValueColorRangeSequence>::s_keyword,
        attribute::get(attribute::Keyword::StoredValueColorRangeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MinimumStoredValueMapped>::s_keyword,
        attribute::get(0x0028, 0x1231).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MinimumStoredValueMapped>::s_keyword,
        attribute::get(attribute::Keyword::MinimumStoredValueMapped).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumStoredValueMapped>::s_keyword,
        attribute::get(0x0028, 0x1232).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumStoredValueMapped>::s_keyword,
        attribute::get(attribute::Keyword::MaximumStoredValueMapped).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastImplantPresent>::s_keyword,
        attribute::get(0x0028, 0x1300).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BreastImplantPresent>::s_keyword,
        attribute::get(attribute::Keyword::BreastImplantPresent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PartialView>::s_keyword,
        attribute::get(0x0028, 0x1350).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PartialView>::s_keyword,
        attribute::get(attribute::Keyword::PartialView).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PartialViewDescription>::s_keyword,
        attribute::get(0x0028, 0x1351).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PartialViewDescription>::s_keyword,
        attribute::get(attribute::Keyword::PartialViewDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PartialViewCodeSequence>::s_keyword,
        attribute::get(0x0028, 0x1352).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PartialViewCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PartialViewCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialLocationsPreserved>::s_keyword,
        attribute::get(0x0028, 0x135A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialLocationsPreserved>::s_keyword,
        attribute::get(attribute::Keyword::SpatialLocationsPreserved).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataFrameAssignmentSequence>::s_keyword,
        attribute::get(0x0028, 0x1401).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataFrameAssignmentSequence>::s_keyword,
        attribute::get(attribute::Keyword::DataFrameAssignmentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataPathAssignment>::s_keyword,
        attribute::get(0x0028, 0x1402).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataPathAssignment>::s_keyword,
        attribute::get(attribute::Keyword::DataPathAssignment).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BitsMappedToColorLookupTable>::s_keyword,
        attribute::get(0x0028, 0x1403).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BitsMappedToColorLookupTable>::s_keyword,
        attribute::get(attribute::Keyword::BitsMappedToColorLookupTable).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLUT1Sequence>::s_keyword,
        attribute::get(0x0028, 0x1404).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLUT1Sequence>::s_keyword,
        attribute::get(attribute::Keyword::BlendingLUT1Sequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLUT1TransferFunction>::s_keyword,
        attribute::get(0x0028, 0x1405).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLUT1TransferFunction>::s_keyword,
        attribute::get(attribute::Keyword::BlendingLUT1TransferFunction).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingWeightConstant>::s_keyword,
        attribute::get(0x0028, 0x1406).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingWeightConstant>::s_keyword,
        attribute::get(attribute::Keyword::BlendingWeightConstant).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLookupTableDescriptor>::s_keyword,
        attribute::get(0x0028, 0x1407).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLookupTableDescriptor>::s_keyword,
        attribute::get(attribute::Keyword::BlendingLookupTableDescriptor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLookupTableData>::s_keyword,
        attribute::get(0x0028, 0x1408).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLookupTableData>::s_keyword,
        attribute::get(attribute::Keyword::BlendingLookupTableData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnhancedPaletteColorLookupTableSequence>::s_keyword,
        attribute::get(0x0028, 0x140B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnhancedPaletteColorLookupTableSequence>::s_keyword,
        attribute::get(attribute::Keyword::EnhancedPaletteColorLookupTableSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLUT2Sequence>::s_keyword,
        attribute::get(0x0028, 0x140C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLUT2Sequence>::s_keyword,
        attribute::get(attribute::Keyword::BlendingLUT2Sequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLUT2TransferFunction>::s_keyword,
        attribute::get(0x0028, 0x140D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlendingLUT2TransferFunction>::s_keyword,
        attribute::get(attribute::Keyword::BlendingLUT2TransferFunction).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataPathID>::s_keyword,
        attribute::get(0x0028, 0x140E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataPathID>::s_keyword,
        attribute::get(attribute::Keyword::DataPathID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RGBLUTTransferFunction>::s_keyword,
        attribute::get(0x0028, 0x140F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RGBLUTTransferFunction>::s_keyword,
        attribute::get(attribute::Keyword::RGBLUTTransferFunction).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlphaLUTTransferFunction>::s_keyword,
        attribute::get(0x0028, 0x1410).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlphaLUTTransferFunction>::s_keyword,
        attribute::get(attribute::Keyword::AlphaLUTTransferFunction).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ICCProfile>::s_keyword,
        attribute::get(0x0028, 0x2000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ICCProfile>::s_keyword,
        attribute::get(attribute::Keyword::ICCProfile).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColorSpace>::s_keyword,
        attribute::get(0x0028, 0x2002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColorSpace>::s_keyword,
        attribute::get(attribute::Keyword::ColorSpace).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LossyImageCompression>::s_keyword,
        attribute::get(0x0028, 0x2110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LossyImageCompression>::s_keyword,
        attribute::get(attribute::Keyword::LossyImageCompression).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LossyImageCompressionRatio>::s_keyword,
        attribute::get(0x0028, 0x2112).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LossyImageCompressionRatio>::s_keyword,
        attribute::get(attribute::Keyword::LossyImageCompressionRatio).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LossyImageCompressionMethod>::s_keyword,
        attribute::get(0x0028, 0x2114).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LossyImageCompressionMethod>::s_keyword,
        attribute::get(attribute::Keyword::LossyImageCompressionMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModalityLUTSequence>::s_keyword,
        attribute::get(0x0028, 0x3000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModalityLUTSequence>::s_keyword,
        attribute::get(attribute::Keyword::ModalityLUTSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LUTDescriptor>::s_keyword,
        attribute::get(0x0028, 0x3002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LUTDescriptor>::s_keyword,
        attribute::get(attribute::Keyword::LUTDescriptor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LUTExplanation>::s_keyword,
        attribute::get(0x0028, 0x3003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LUTExplanation>::s_keyword,
        attribute::get(attribute::Keyword::LUTExplanation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModalityLUTType>::s_keyword,
        attribute::get(0x0028, 0x3004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModalityLUTType>::s_keyword,
        attribute::get(attribute::Keyword::ModalityLUTType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LUTData>::s_keyword,
        attribute::get(0x0028, 0x3006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LUTData>::s_keyword,
        attribute::get(attribute::Keyword::LUTData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VOILUTSequence>::s_keyword,
        attribute::get(0x0028, 0x3010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VOILUTSequence>::s_keyword,
        attribute::get(attribute::Keyword::VOILUTSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RepresentativeFrameNumber>::s_keyword,
        attribute::get(0x0028, 0x6010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RepresentativeFrameNumber>::s_keyword,
        attribute::get(attribute::Keyword::RepresentativeFrameNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameNumbersOfInterest>::s_keyword,
        attribute::get(0x0028, 0x6020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameNumbersOfInterest>::s_keyword,
        attribute::get(attribute::Keyword::FrameNumbersOfInterest).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameOfInterestDescription>::s_keyword,
        attribute::get(0x0028, 0x6022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameOfInterestDescription>::s_keyword,
        attribute::get(attribute::Keyword::FrameOfInterestDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameOfInterestType>::s_keyword,
        attribute::get(0x0028, 0x6023).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameOfInterestType>::s_keyword,
        attribute::get(attribute::Keyword::FrameOfInterestType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RWavePointer>::s_keyword,
        attribute::get(0x0028, 0x6040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RWavePointer>::s_keyword,
        attribute::get(attribute::Keyword::RWavePointer).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskSubtractionSequence>::s_keyword,
        attribute::get(0x0028, 0x6100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskSubtractionSequence>::s_keyword,
        attribute::get(attribute::Keyword::MaskSubtractionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskOperation>::s_keyword,
        attribute::get(0x0028, 0x6101).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskOperation>::s_keyword,
        attribute::get(attribute::Keyword::MaskOperation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicableFrameRange>::s_keyword,
        attribute::get(0x0028, 0x6102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicableFrameRange>::s_keyword,
        attribute::get(attribute::Keyword::ApplicableFrameRange).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskFrameNumbers>::s_keyword,
        attribute::get(0x0028, 0x6110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskFrameNumbers>::s_keyword,
        attribute::get(attribute::Keyword::MaskFrameNumbers).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastFrameAveraging>::s_keyword,
        attribute::get(0x0028, 0x6112).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastFrameAveraging>::s_keyword,
        attribute::get(attribute::Keyword::ContrastFrameAveraging).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskSubPixelShift>::s_keyword,
        attribute::get(0x0028, 0x6114).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskSubPixelShift>::s_keyword,
        attribute::get(attribute::Keyword::MaskSubPixelShift).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TIDOffset>::s_keyword,
        attribute::get(0x0028, 0x6120).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TIDOffset>::s_keyword,
        attribute::get(attribute::Keyword::TIDOffset).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskOperationExplanation>::s_keyword,
        attribute::get(0x0028, 0x6190).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskOperationExplanation>::s_keyword,
        attribute::get(attribute::Keyword::MaskOperationExplanation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelDataProviderURL>::s_keyword,
        attribute::get(0x0028, 0x7FE0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelDataProviderURL>::s_keyword,
        attribute::get(attribute::Keyword::PixelDataProviderURL).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelMeasuresSequence>::s_keyword,
        attribute::get(0x0028, 0x9110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelMeasuresSequence>::s_keyword,
        attribute::get(attribute::Keyword::PixelMeasuresSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameVOILUTSequence>::s_keyword,
        attribute::get(0x0028, 0x9132).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameVOILUTSequence>::s_keyword,
        attribute::get(attribute::Keyword::FrameVOILUTSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelValueTransformationSequence>::s_keyword,
        attribute::get(0x0028, 0x9145).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelValueTransformationSequence>::s_keyword,
        attribute::get(attribute::Keyword::PixelValueTransformationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplayFilterPercentage>::s_keyword,
        attribute::get(0x0028, 0x9411).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplayFilterPercentage>::s_keyword,
        attribute::get(attribute::Keyword::DisplayFilterPercentage).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FramePixelShiftSequence>::s_keyword,
        attribute::get(0x0028, 0x9415).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FramePixelShiftSequence>::s_keyword,
        attribute::get(attribute::Keyword::FramePixelShiftSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubtractionItemID>::s_keyword,
        attribute::get(0x0028, 0x9416).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SubtractionItemID>::s_keyword,
        attribute::get(attribute::Keyword::SubtractionItemID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelIntensityRelationshipLUTSequence>::s_keyword,
        attribute::get(0x0028, 0x9422).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelIntensityRelationshipLUTSequence>::s_keyword,
        attribute::get(attribute::Keyword::PixelIntensityRelationshipLUTSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FramePixelDataPropertiesSequence>::s_keyword,
        attribute::get(0x0028, 0x9443).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FramePixelDataPropertiesSequence>::s_keyword,
        attribute::get(attribute::Keyword::FramePixelDataPropertiesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeometricalProperties>::s_keyword,
        attribute::get(0x0028, 0x9444).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeometricalProperties>::s_keyword,
        attribute::get(attribute::Keyword::GeometricalProperties).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeometricMaximumDistortion>::s_keyword,
        attribute::get(0x0028, 0x9445).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeometricMaximumDistortion>::s_keyword,
        attribute::get(attribute::Keyword::GeometricMaximumDistortion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageProcessingApplied>::s_keyword,
        attribute::get(0x0028, 0x9446).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageProcessingApplied>::s_keyword,
        attribute::get(attribute::Keyword::ImageProcessingApplied).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskSelectionMode>::s_keyword,
        attribute::get(0x0028, 0x9454).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskSelectionMode>::s_keyword,
        attribute::get(attribute::Keyword::MaskSelectionMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LUTFunction>::s_keyword,
        attribute::get(0x0028, 0x9474).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LUTFunction>::s_keyword,
        attribute::get(attribute::Keyword::LUTFunction).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskVisibilityPercentage>::s_keyword,
        attribute::get(0x0028, 0x9478).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaskVisibilityPercentage>::s_keyword,
        attribute::get(attribute::Keyword::MaskVisibilityPercentage).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageToEquipmentMappingMatrix>::s_keyword,
        attribute::get(0x0028, 0x9520).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageToEquipmentMappingMatrix>::s_keyword,
        attribute::get(attribute::Keyword::ImageToEquipmentMappingMatrix).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EquipmentCoordinateSystemIdentification>::s_keyword,
        attribute::get(0x0028, 0x9537).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EquipmentCoordinateSystemIdentification>::s_keyword,
        attribute::get(attribute::Keyword::EquipmentCoordinateSystemIdentification).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestingService>::s_keyword,
        attribute::get(0x0032, 0x1033).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestingService>::s_keyword,
        attribute::get(attribute::Keyword::RequestingService).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestingServiceCodeSequence>::s_keyword,
        attribute::get(0x0032, 0x1034).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestingServiceCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::RequestingServiceCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestedProcedureDescription>::s_keyword,
        attribute::get(0x0032, 0x1060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestedProcedureDescription>::s_keyword,
        attribute::get(attribute::Keyword::RequestedProcedureDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestedProcedureCodeSequence>::s_keyword,
        attribute::get(0x0032, 0x1064).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestedProcedureCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::RequestedProcedureCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForVisit>::s_keyword,
        attribute::get(0x0032, 0x1066).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForVisit>::s_keyword,
        attribute::get(attribute::Keyword::ReasonForVisit).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForVisitCodeSequence>::s_keyword,
        attribute::get(0x0032, 0x1067).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForVisitCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReasonForVisitCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameOriginTimestamp>::s_keyword,
        attribute::get(0x0034, 0x0007).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameOriginTimestamp>::s_keyword,
        attribute::get(attribute::Keyword::FrameOriginTimestamp).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IncludesImagingSubject>::s_keyword,
        attribute::get(0x0034, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IncludesImagingSubject>::s_keyword,
        attribute::get(attribute::Keyword::IncludesImagingSubject).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameUsefulnessGroupSequence>::s_keyword,
        attribute::get(0x0034, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameUsefulnessGroupSequence>::s_keyword,
        attribute::get(attribute::Keyword::FrameUsefulnessGroupSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CameraPositionGroupSequence>::s_keyword,
        attribute::get(0x0034, 0x000B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CameraPositionGroupSequence>::s_keyword,
        attribute::get(attribute::Keyword::CameraPositionGroupSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IncludesInformation>::s_keyword,
        attribute::get(0x0034, 0x000C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IncludesInformation>::s_keyword,
        attribute::get(attribute::Keyword::IncludesInformation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfFrameGroupSequence>::s_keyword,
        attribute::get(0x0034, 0x000D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeOfFrameGroupSequence>::s_keyword,
        attribute::get(attribute::Keyword::TimeOfFrameGroupSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdmissionID>::s_keyword,
        attribute::get(0x0038, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdmissionID>::s_keyword,
        attribute::get(attribute::Keyword::AdmissionID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfAdmissionIDSequence>::s_keyword,
        attribute::get(0x0038, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfAdmissionIDSequence>::s_keyword,
        attribute::get(attribute::Keyword::IssuerOfAdmissionIDSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ServiceEpisodeID>::s_keyword,
        attribute::get(0x0038, 0x0060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ServiceEpisodeID>::s_keyword,
        attribute::get(attribute::Keyword::ServiceEpisodeID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ServiceEpisodeDescription>::s_keyword,
        attribute::get(0x0038, 0x0062).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ServiceEpisodeDescription>::s_keyword,
        attribute::get(attribute::Keyword::ServiceEpisodeDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfServiceEpisodeIDSequence>::s_keyword,
        attribute::get(0x0038, 0x0064).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfServiceEpisodeIDSequence>::s_keyword,
        attribute::get(attribute::Keyword::IssuerOfServiceEpisodeIDSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientState>::s_keyword,
        attribute::get(0x0038, 0x0500).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientState>::s_keyword,
        attribute::get(attribute::Keyword::PatientState).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ChannelSourceSequence>::s_keyword,
        attribute::get(0x003A, 0x0208).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ChannelSourceSequence>::s_keyword,
        attribute::get(attribute::Keyword::ChannelSourceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultiplexedAudioChannelsDescriptionCodeSequence>::s_keyword,
        attribute::get(0x003A, 0x0300).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MultiplexedAudioChannelsDescriptionCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::MultiplexedAudioChannelsDescriptionCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ChannelIdentificationCode>::s_keyword,
        attribute::get(0x003A, 0x0301).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ChannelIdentificationCode>::s_keyword,
        attribute::get(attribute::Keyword::ChannelIdentificationCode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ChannelMode>::s_keyword,
        attribute::get(0x003A, 0x0302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ChannelMode>::s_keyword,
        attribute::get(attribute::Keyword::ChannelMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScheduledProcedureStepDescription>::s_keyword,
        attribute::get(0x0040, 0x0007).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScheduledProcedureStepDescription>::s_keyword,
        attribute::get(attribute::Keyword::ScheduledProcedureStepDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScheduledProtocolCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScheduledProtocolCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ScheduledProtocolCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScheduledProcedureStepID>::s_keyword,
        attribute::get(0x0040, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScheduledProcedureStepID>::s_keyword,
        attribute::get(attribute::Keyword::ScheduledProcedureStepID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StageCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x000A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StageCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::StageCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OrderPlacerIdentifierSequence>::s_keyword,
        attribute::get(0x0040, 0x0026).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OrderPlacerIdentifierSequence>::s_keyword,
        attribute::get(attribute::Keyword::OrderPlacerIdentifierSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OrderFillerIdentifierSequence>::s_keyword,
        attribute::get(0x0040, 0x0027).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OrderFillerIdentifierSequence>::s_keyword,
        attribute::get(attribute::Keyword::OrderFillerIdentifierSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LocalNamespaceEntityID>::s_keyword,
        attribute::get(0x0040, 0x0031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LocalNamespaceEntityID>::s_keyword,
        attribute::get(attribute::Keyword::LocalNamespaceEntityID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UniversalEntityID>::s_keyword,
        attribute::get(0x0040, 0x0032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UniversalEntityID>::s_keyword,
        attribute::get(attribute::Keyword::UniversalEntityID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UniversalEntityIDType>::s_keyword,
        attribute::get(0x0040, 0x0033).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UniversalEntityIDType>::s_keyword,
        attribute::get(attribute::Keyword::UniversalEntityIDType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IdentifierTypeCode>::s_keyword,
        attribute::get(0x0040, 0x0035).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IdentifierTypeCode>::s_keyword,
        attribute::get(attribute::Keyword::IdentifierTypeCode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AssigningFacilitySequence>::s_keyword,
        attribute::get(0x0040, 0x0036).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AssigningFacilitySequence>::s_keyword,
        attribute::get(attribute::Keyword::AssigningFacilitySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AssigningJurisdictionCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x0039).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AssigningJurisdictionCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::AssigningJurisdictionCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AssigningAgencyOrDepartmentCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x003A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AssigningAgencyOrDepartmentCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::AssigningAgencyOrDepartmentCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepStartDate>::s_keyword,
        attribute::get(0x0040, 0x0244).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepStartDate>::s_keyword,
        attribute::get(attribute::Keyword::PerformedProcedureStepStartDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepStartTime>::s_keyword,
        attribute::get(0x0040, 0x0245).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepStartTime>::s_keyword,
        attribute::get(attribute::Keyword::PerformedProcedureStepStartTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepEndDate>::s_keyword,
        attribute::get(0x0040, 0x0250).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepEndDate>::s_keyword,
        attribute::get(attribute::Keyword::PerformedProcedureStepEndDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepEndTime>::s_keyword,
        attribute::get(0x0040, 0x0251).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepEndTime>::s_keyword,
        attribute::get(attribute::Keyword::PerformedProcedureStepEndTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepID>::s_keyword,
        attribute::get(0x0040, 0x0253).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepID>::s_keyword,
        attribute::get(attribute::Keyword::PerformedProcedureStepID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepDescription>::s_keyword,
        attribute::get(0x0040, 0x0254).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureStepDescription>::s_keyword,
        attribute::get(attribute::Keyword::PerformedProcedureStepDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProtocolCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x0260).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProtocolCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PerformedProtocolCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProtocolType>::s_keyword,
        attribute::get(0x0040, 0x0261).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProtocolType>::s_keyword,
        attribute::get(attribute::Keyword::PerformedProtocolType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestAttributesSequence>::s_keyword,
        attribute::get(0x0040, 0x0275).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestAttributesSequence>::s_keyword,
        attribute::get(attribute::Keyword::RequestAttributesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CommentsOnThePerformedProcedureStep>::s_keyword,
        attribute::get(0x0040, 0x0280).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CommentsOnThePerformedProcedureStep>::s_keyword,
        attribute::get(attribute::Keyword::CommentsOnThePerformedProcedureStep).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EntranceDose>::s_keyword,
        attribute::get(0x0040, 0x0302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EntranceDose>::s_keyword,
        attribute::get(attribute::Keyword::EntranceDose).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposedArea>::s_keyword,
        attribute::get(0x0040, 0x0303).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposedArea>::s_keyword,
        attribute::get(attribute::Keyword::ExposedArea).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceSourceToEntrance>::s_keyword,
        attribute::get(0x0040, 0x0306).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceSourceToEntrance>::s_keyword,
        attribute::get(attribute::Keyword::DistanceSourceToEntrance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CommentsOnRadiationDose>::s_keyword,
        attribute::get(0x0040, 0x0310).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CommentsOnRadiationDose>::s_keyword,
        attribute::get(attribute::Keyword::CommentsOnRadiationDose).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayOutput>::s_keyword,
        attribute::get(0x0040, 0x0312).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayOutput>::s_keyword,
        attribute::get(attribute::Keyword::XRayOutput).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HalfValueLayer>::s_keyword,
        attribute::get(0x0040, 0x0314).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HalfValueLayer>::s_keyword,
        attribute::get(attribute::Keyword::HalfValueLayer).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OrganDose>::s_keyword,
        attribute::get(0x0040, 0x0316).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OrganDose>::s_keyword,
        attribute::get(attribute::Keyword::OrganDose).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OrganExposed>::s_keyword,
        attribute::get(0x0040, 0x0318).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OrganExposed>::s_keyword,
        attribute::get(attribute::Keyword::OrganExposed).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProtocolContextSequence>::s_keyword,
        attribute::get(0x0040, 0x0440).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ProtocolContextSequence>::s_keyword,
        attribute::get(attribute::Keyword::ProtocolContextSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentItemModifierSequence>::s_keyword,
        attribute::get(0x0040, 0x0441).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentItemModifierSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContentItemModifierSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerIdentifier>::s_keyword,
        attribute::get(0x0040, 0x0512).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::ContainerIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfTheContainerIdentifierSequence>::s_keyword,
        attribute::get(0x0040, 0x0513).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfTheContainerIdentifierSequence>::s_keyword,
        attribute::get(attribute::Keyword::IssuerOfTheContainerIdentifierSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlternateContainerIdentifierSequence>::s_keyword,
        attribute::get(0x0040, 0x0515).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlternateContainerIdentifierSequence>::s_keyword,
        attribute::get(attribute::Keyword::AlternateContainerIdentifierSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerTypeCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x0518).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContainerTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerDescription>::s_keyword,
        attribute::get(0x0040, 0x051A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerDescription>::s_keyword,
        attribute::get(attribute::Keyword::ContainerDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentSequence>::s_keyword,
        attribute::get(0x0040, 0x0520).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContainerComponentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenIdentifier>::s_keyword,
        attribute::get(0x0040, 0x0551).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::SpecimenIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenUID>::s_keyword,
        attribute::get(0x0040, 0x0554).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenUID>::s_keyword,
        attribute::get(attribute::Keyword::SpecimenUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionContextSequence>::s_keyword,
        attribute::get(0x0040, 0x0555).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionContextSequence>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionContextSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionContextDescription>::s_keyword,
        attribute::get(0x0040, 0x0556).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionContextDescription>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionContextDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenDescriptionSequence>::s_keyword,
        attribute::get(0x0040, 0x0560).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenDescriptionSequence>::s_keyword,
        attribute::get(attribute::Keyword::SpecimenDescriptionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfTheSpecimenIdentifierSequence>::s_keyword,
        attribute::get(0x0040, 0x0562).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IssuerOfTheSpecimenIdentifierSequence>::s_keyword,
        attribute::get(attribute::Keyword::IssuerOfTheSpecimenIdentifierSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenTypeCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x059A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::SpecimenTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenShortDescription>::s_keyword,
        attribute::get(0x0040, 0x0600).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenShortDescription>::s_keyword,
        attribute::get(attribute::Keyword::SpecimenShortDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenDetailedDescription>::s_keyword,
        attribute::get(0x0040, 0x0602).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenDetailedDescription>::s_keyword,
        attribute::get(attribute::Keyword::SpecimenDetailedDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenPreparationSequence>::s_keyword,
        attribute::get(0x0040, 0x0610).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenPreparationSequence>::s_keyword,
        attribute::get(attribute::Keyword::SpecimenPreparationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenLocalizationContentItemSequence>::s_keyword,
        attribute::get(0x0040, 0x0620).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenLocalizationContentItemSequence>::s_keyword,
        attribute::get(attribute::Keyword::SpecimenLocalizationContentItemSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WholeSlideMicroscopyImageFrameTypeSequence>::s_keyword,
        attribute::get(0x0040, 0x0710).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WholeSlideMicroscopyImageFrameTypeSequence>::s_keyword,
        attribute::get(attribute::Keyword::WholeSlideMicroscopyImageFrameTypeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageCenterPointCoordinatesSequence>::s_keyword,
        attribute::get(0x0040, 0x071A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageCenterPointCoordinatesSequence>::s_keyword,
        attribute::get(attribute::Keyword::ImageCenterPointCoordinatesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XOffsetInSlideCoordinateSystem>::s_keyword,
        attribute::get(0x0040, 0x072A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XOffsetInSlideCoordinateSystem>::s_keyword,
        attribute::get(attribute::Keyword::XOffsetInSlideCoordinateSystem).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::YOffsetInSlideCoordinateSystem>::s_keyword,
        attribute::get(0x0040, 0x073A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::YOffsetInSlideCoordinateSystem>::s_keyword,
        attribute::get(attribute::Keyword::YOffsetInSlideCoordinateSystem).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ZOffsetInSlideCoordinateSystem>::s_keyword,
        attribute::get(0x0040, 0x074A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ZOffsetInSlideCoordinateSystem>::s_keyword,
        attribute::get(attribute::Keyword::ZOffsetInSlideCoordinateSystem).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeasurementUnitsCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x08EA).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeasurementUnitsCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::MeasurementUnitsCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestedProcedureID>::s_keyword,
        attribute::get(0x0040, 0x1001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RequestedProcedureID>::s_keyword,
        attribute::get(attribute::Keyword::RequestedProcedureID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForTheRequestedProcedure>::s_keyword,
        attribute::get(0x0040, 0x1002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForTheRequestedProcedure>::s_keyword,
        attribute::get(attribute::Keyword::ReasonForTheRequestedProcedure).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForRequestedProcedureCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x100A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForRequestedProcedureCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReasonForRequestedProcedureCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForPerformedProcedureCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x1012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForPerformedProcedureCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReasonForPerformedProcedureCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PersonIdentificationCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x1101).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PersonIdentificationCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PersonIdentificationCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PersonAddress>::s_keyword,
        attribute::get(0x0040, 0x1102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PersonAddress>::s_keyword,
        attribute::get(attribute::Keyword::PersonAddress).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PersonTelephoneNumbers>::s_keyword,
        attribute::get(0x0040, 0x1103).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PersonTelephoneNumbers>::s_keyword,
        attribute::get(attribute::Keyword::PersonTelephoneNumbers).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PersonTelecomInformation>::s_keyword,
        attribute::get(0x0040, 0x1104).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PersonTelecomInformation>::s_keyword,
        attribute::get(attribute::Keyword::PersonTelecomInformation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlacerOrderNumberImagingServiceRequest>::s_keyword,
        attribute::get(0x0040, 0x2016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlacerOrderNumberImagingServiceRequest>::s_keyword,
        attribute::get(attribute::Keyword::PlacerOrderNumberImagingServiceRequest).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FillerOrderNumberImagingServiceRequest>::s_keyword,
        attribute::get(0x0040, 0x2017).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FillerOrderNumberImagingServiceRequest>::s_keyword,
        attribute::get(attribute::Keyword::FillerOrderNumberImagingServiceRequest).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EntranceDoseInmGy>::s_keyword,
        attribute::get(0x0040, 0x8302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EntranceDoseInmGy>::s_keyword,
        attribute::get(attribute::Keyword::EntranceDoseInmGy).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EntranceDoseDerivation>::s_keyword,
        attribute::get(0x0040, 0x8303).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EntranceDoseDerivation>::s_keyword,
        attribute::get(attribute::Keyword::EntranceDoseDerivation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParametricMapFrameTypeSequence>::s_keyword,
        attribute::get(0x0040, 0x9092).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParametricMapFrameTypeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ParametricMapFrameTypeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueMappingSequence>::s_keyword,
        attribute::get(0x0040, 0x9096).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueMappingSequence>::s_keyword,
        attribute::get(attribute::Keyword::RealWorldValueMappingSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelValueMappingCodeSequence>::s_keyword,
        attribute::get(0x0040, 0x9098).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelValueMappingCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PixelValueMappingCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LUTLabel>::s_keyword,
        attribute::get(0x0040, 0x9210).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LUTLabel>::s_keyword,
        attribute::get(attribute::Keyword::LUTLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueLastValueMapped>::s_keyword,
        attribute::get(0x0040, 0x9211).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueLastValueMapped>::s_keyword,
        attribute::get(attribute::Keyword::RealWorldValueLastValueMapped).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueLUTData>::s_keyword,
        attribute::get(0x0040, 0x9212).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueLUTData>::s_keyword,
        attribute::get(attribute::Keyword::RealWorldValueLUTData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoubleFloatRealWorldValueLastValueMapped>::s_keyword,
        attribute::get(0x0040, 0x9213).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoubleFloatRealWorldValueLastValueMapped>::s_keyword,
        attribute::get(attribute::Keyword::DoubleFloatRealWorldValueLastValueMapped).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoubleFloatRealWorldValueFirstValueMapped>::s_keyword,
        attribute::get(0x0040, 0x9214).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoubleFloatRealWorldValueFirstValueMapped>::s_keyword,
        attribute::get(attribute::Keyword::DoubleFloatRealWorldValueFirstValueMapped).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueFirstValueMapped>::s_keyword,
        attribute::get(0x0040, 0x9216).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueFirstValueMapped>::s_keyword,
        attribute::get(attribute::Keyword::RealWorldValueFirstValueMapped).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QuantityDefinitionSequence>::s_keyword,
        attribute::get(0x0040, 0x9220).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::QuantityDefinitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::QuantityDefinitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueIntercept>::s_keyword,
        attribute::get(0x0040, 0x9224).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueIntercept>::s_keyword,
        attribute::get(attribute::Keyword::RealWorldValueIntercept).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueSlope>::s_keyword,
        attribute::get(0x0040, 0x9225).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RealWorldValueSlope>::s_keyword,
        attribute::get(attribute::Keyword::RealWorldValueSlope).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelationshipType>::s_keyword,
        attribute::get(0x0040, 0xA010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelationshipType>::s_keyword,
        attribute::get(attribute::Keyword::RelationshipType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerifyingOrganization>::s_keyword,
        attribute::get(0x0040, 0xA027).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerifyingOrganization>::s_keyword,
        attribute::get(attribute::Keyword::VerifyingOrganization).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerificationDateTime>::s_keyword,
        attribute::get(0x0040, 0xA030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerificationDateTime>::s_keyword,
        attribute::get(attribute::Keyword::VerificationDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObservationDateTime>::s_keyword,
        attribute::get(0x0040, 0xA032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObservationDateTime>::s_keyword,
        attribute::get(attribute::Keyword::ObservationDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObservationStartDateTime>::s_keyword,
        attribute::get(0x0040, 0xA033).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObservationStartDateTime>::s_keyword,
        attribute::get(attribute::Keyword::ObservationStartDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ValueType>::s_keyword,
        attribute::get(0x0040, 0xA040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ValueType>::s_keyword,
        attribute::get(attribute::Keyword::ValueType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConceptNameCodeSequence>::s_keyword,
        attribute::get(0x0040, 0xA043).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConceptNameCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ConceptNameCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContinuityOfContent>::s_keyword,
        attribute::get(0x0040, 0xA050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContinuityOfContent>::s_keyword,
        attribute::get(attribute::Keyword::ContinuityOfContent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerifyingObserverSequence>::s_keyword,
        attribute::get(0x0040, 0xA073).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerifyingObserverSequence>::s_keyword,
        attribute::get(attribute::Keyword::VerifyingObserverSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerifyingObserverName>::s_keyword,
        attribute::get(0x0040, 0xA075).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerifyingObserverName>::s_keyword,
        attribute::get(attribute::Keyword::VerifyingObserverName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AuthorObserverSequence>::s_keyword,
        attribute::get(0x0040, 0xA078).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AuthorObserverSequence>::s_keyword,
        attribute::get(attribute::Keyword::AuthorObserverSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParticipantSequence>::s_keyword,
        attribute::get(0x0040, 0xA07A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParticipantSequence>::s_keyword,
        attribute::get(attribute::Keyword::ParticipantSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CustodialOrganizationSequence>::s_keyword,
        attribute::get(0x0040, 0xA07C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CustodialOrganizationSequence>::s_keyword,
        attribute::get(attribute::Keyword::CustodialOrganizationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParticipationType>::s_keyword,
        attribute::get(0x0040, 0xA080).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParticipationType>::s_keyword,
        attribute::get(attribute::Keyword::ParticipationType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParticipationDateTime>::s_keyword,
        attribute::get(0x0040, 0xA082).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParticipationDateTime>::s_keyword,
        attribute::get(attribute::Keyword::ParticipationDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObserverType>::s_keyword,
        attribute::get(0x0040, 0xA084).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObserverType>::s_keyword,
        attribute::get(attribute::Keyword::ObserverType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerifyingObserverIdentificationCodeSequence>::s_keyword,
        attribute::get(0x0040, 0xA088).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerifyingObserverIdentificationCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::VerifyingObserverIdentificationCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedWaveformChannels>::s_keyword,
        attribute::get(0x0040, 0xA0B0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedWaveformChannels>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedWaveformChannels).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateTime>::s_keyword,
        attribute::get(0x0040, 0xA120).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DateTime>::s_keyword,
        attribute::get(attribute::Keyword::DateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Date>::s_keyword,
        attribute::get(0x0040, 0xA121).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Date>::s_keyword,
        attribute::get(attribute::Keyword::Date).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Time>::s_keyword,
        attribute::get(0x0040, 0xA122).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Time>::s_keyword,
        attribute::get(attribute::Keyword::Time).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PersonName>::s_keyword,
        attribute::get(0x0040, 0xA123).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PersonName>::s_keyword,
        attribute::get(attribute::Keyword::PersonName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UID>::s_keyword,
        attribute::get(0x0040, 0xA124).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UID>::s_keyword,
        attribute::get(attribute::Keyword::UID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalRangeType>::s_keyword,
        attribute::get(0x0040, 0xA130).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemporalRangeType>::s_keyword,
        attribute::get(attribute::Keyword::TemporalRangeType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSamplePositions>::s_keyword,
        attribute::get(0x0040, 0xA132).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSamplePositions>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSamplePositions).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedTimeOffsets>::s_keyword,
        attribute::get(0x0040, 0xA138).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedTimeOffsets>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedTimeOffsets).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedDateTime>::s_keyword,
        attribute::get(0x0040, 0xA13A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedDateTime>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TextValue>::s_keyword,
        attribute::get(0x0040, 0xA160).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TextValue>::s_keyword,
        attribute::get(attribute::Keyword::TextValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FloatingPointValue>::s_keyword,
        attribute::get(0x0040, 0xA161).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FloatingPointValue>::s_keyword,
        attribute::get(attribute::Keyword::FloatingPointValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RationalNumeratorValue>::s_keyword,
        attribute::get(0x0040, 0xA162).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RationalNumeratorValue>::s_keyword,
        attribute::get(attribute::Keyword::RationalNumeratorValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RationalDenominatorValue>::s_keyword,
        attribute::get(0x0040, 0xA163).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RationalDenominatorValue>::s_keyword,
        attribute::get(attribute::Keyword::RationalDenominatorValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConceptCodeSequence>::s_keyword,
        attribute::get(0x0040, 0xA168).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConceptCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ConceptCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PurposeOfReferenceCodeSequence>::s_keyword,
        attribute::get(0x0040, 0xA170).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PurposeOfReferenceCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PurposeOfReferenceCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObservationUID>::s_keyword,
        attribute::get(0x0040, 0xA171).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObservationUID>::s_keyword,
        attribute::get(attribute::Keyword::ObservationUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeasuredValueSequence>::s_keyword,
        attribute::get(0x0040, 0xA300).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeasuredValueSequence>::s_keyword,
        attribute::get(attribute::Keyword::MeasuredValueSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumericValueQualifierCodeSequence>::s_keyword,
        attribute::get(0x0040, 0xA301).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumericValueQualifierCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::NumericValueQualifierCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumericValue>::s_keyword,
        attribute::get(0x0040, 0xA30A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumericValue>::s_keyword,
        attribute::get(attribute::Keyword::NumericValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PredecessorDocumentsSequence>::s_keyword,
        attribute::get(0x0040, 0xA360).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PredecessorDocumentsSequence>::s_keyword,
        attribute::get(attribute::Keyword::PredecessorDocumentsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedRequestSequence>::s_keyword,
        attribute::get(0x0040, 0xA370).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedRequestSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedRequestSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureCodeSequence>::s_keyword,
        attribute::get(0x0040, 0xA372).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcedureCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PerformedProcedureCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CurrentRequestedProcedureEvidenceSequence>::s_keyword,
        attribute::get(0x0040, 0xA375).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CurrentRequestedProcedureEvidenceSequence>::s_keyword,
        attribute::get(attribute::Keyword::CurrentRequestedProcedureEvidenceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PertinentOtherEvidenceSequence>::s_keyword,
        attribute::get(0x0040, 0xA385).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PertinentOtherEvidenceSequence>::s_keyword,
        attribute::get(attribute::Keyword::PertinentOtherEvidenceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HL7StructuredDocumentReferenceSequence>::s_keyword,
        attribute::get(0x0040, 0xA390).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HL7StructuredDocumentReferenceSequence>::s_keyword,
        attribute::get(attribute::Keyword::HL7StructuredDocumentReferenceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CompletionFlag>::s_keyword,
        attribute::get(0x0040, 0xA491).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CompletionFlag>::s_keyword,
        attribute::get(attribute::Keyword::CompletionFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CompletionFlagDescription>::s_keyword,
        attribute::get(0x0040, 0xA492).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CompletionFlagDescription>::s_keyword,
        attribute::get(attribute::Keyword::CompletionFlagDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerificationFlag>::s_keyword,
        attribute::get(0x0040, 0xA493).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerificationFlag>::s_keyword,
        attribute::get(attribute::Keyword::VerificationFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PreliminaryFlag>::s_keyword,
        attribute::get(0x0040, 0xA496).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PreliminaryFlag>::s_keyword,
        attribute::get(attribute::Keyword::PreliminaryFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentTemplateSequence>::s_keyword,
        attribute::get(0x0040, 0xA504).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentTemplateSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContentTemplateSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IdenticalDocumentsSequence>::s_keyword,
        attribute::get(0x0040, 0xA525).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IdenticalDocumentsSequence>::s_keyword,
        attribute::get(attribute::Keyword::IdenticalDocumentsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentSequence>::s_keyword,
        attribute::get(0x0040, 0xA730).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TabulatedValuesSequence>::s_keyword,
        attribute::get(0x0040, 0xA801).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TabulatedValuesSequence>::s_keyword,
        attribute::get(attribute::Keyword::TabulatedValuesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTableRows>::s_keyword,
        attribute::get(0x0040, 0xA802).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTableRows>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfTableRows).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTableColumns>::s_keyword,
        attribute::get(0x0040, 0xA803).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTableColumns>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfTableColumns).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableRowDefinitionSequence>::s_keyword,
        attribute::get(0x0040, 0xA806).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableRowDefinitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::TableRowDefinitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableColumnDefinitionSequence>::s_keyword,
        attribute::get(0x0040, 0xA807).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableColumnDefinitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::TableColumnDefinitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CellValuesSequence>::s_keyword,
        attribute::get(0x0040, 0xA808).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CellValuesSequence>::s_keyword,
        attribute::get(attribute::Keyword::CellValuesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemplateIdentifier>::s_keyword,
        attribute::get(0x0040, 0xDB00).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TemplateIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::TemplateIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedContentItemIdentifier>::s_keyword,
        attribute::get(0x0040, 0xDB73).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedContentItemIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedContentItemIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HL7InstanceIdentifier>::s_keyword,
        attribute::get(0x0040, 0xE001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HL7InstanceIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::HL7InstanceIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DocumentClassCodeSequence>::s_keyword,
        attribute::get(0x0040, 0xE008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DocumentClassCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::DocumentClassCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RetrieveURI>::s_keyword,
        attribute::get(0x0040, 0xE010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RetrieveURI>::s_keyword,
        attribute::get(attribute::Keyword::RetrieveURI).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RetrieveLocationUID>::s_keyword,
        attribute::get(0x0040, 0xE011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RetrieveLocationUID>::s_keyword,
        attribute::get(attribute::Keyword::RetrieveLocationUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TypeOfInstances>::s_keyword,
        attribute::get(0x0040, 0xE020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TypeOfInstances>::s_keyword,
        attribute::get(attribute::Keyword::TypeOfInstances).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DICOMRetrievalSequence>::s_keyword,
        attribute::get(0x0040, 0xE021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DICOMRetrievalSequence>::s_keyword,
        attribute::get(attribute::Keyword::DICOMRetrievalSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DICOMMediaRetrievalSequence>::s_keyword,
        attribute::get(0x0040, 0xE022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DICOMMediaRetrievalSequence>::s_keyword,
        attribute::get(attribute::Keyword::DICOMMediaRetrievalSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WADORetrievalSequence>::s_keyword,
        attribute::get(0x0040, 0xE023).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WADORetrievalSequence>::s_keyword,
        attribute::get(attribute::Keyword::WADORetrievalSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XDSRetrievalSequence>::s_keyword,
        attribute::get(0x0040, 0xE024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XDSRetrievalSequence>::s_keyword,
        attribute::get(attribute::Keyword::XDSRetrievalSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WADORSRetrievalSequence>::s_keyword,
        attribute::get(0x0040, 0xE025).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::WADORSRetrievalSequence>::s_keyword,
        attribute::get(attribute::Keyword::WADORSRetrievalSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RepositoryUniqueID>::s_keyword,
        attribute::get(0x0040, 0xE030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RepositoryUniqueID>::s_keyword,
        attribute::get(attribute::Keyword::RepositoryUniqueID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HomeCommunityID>::s_keyword,
        attribute::get(0x0040, 0xE031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HomeCommunityID>::s_keyword,
        attribute::get(attribute::Keyword::HomeCommunityID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DocumentTitle>::s_keyword,
        attribute::get(0x0042, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DocumentTitle>::s_keyword,
        attribute::get(attribute::Keyword::DocumentTitle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncapsulatedDocument>::s_keyword,
        attribute::get(0x0042, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncapsulatedDocument>::s_keyword,
        attribute::get(attribute::Keyword::EncapsulatedDocument).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MIMETypeOfEncapsulatedDocument>::s_keyword,
        attribute::get(0x0042, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MIMETypeOfEncapsulatedDocument>::s_keyword,
        attribute::get(attribute::Keyword::MIMETypeOfEncapsulatedDocument).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceInstanceSequence>::s_keyword,
        attribute::get(0x0042, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceInstanceSequence>::s_keyword,
        attribute::get(attribute::Keyword::SourceInstanceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ListOfMIMETypes>::s_keyword,
        attribute::get(0x0042, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ListOfMIMETypes>::s_keyword,
        attribute::get(attribute::Keyword::ListOfMIMETypes).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncapsulatedDocumentLength>::s_keyword,
        attribute::get(0x0042, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncapsulatedDocumentLength>::s_keyword,
        attribute::get(attribute::Keyword::EncapsulatedDocumentLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OrganizationalRoleCodeSequence>::s_keyword,
        attribute::get(0x0044, 0x010A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OrganizationalRoleCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::OrganizationalRoleCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SteepKeratometricAxisSequence>::s_keyword,
        attribute::get(0x0046, 0x0074).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SteepKeratometricAxisSequence>::s_keyword,
        attribute::get(attribute::Keyword::SteepKeratometricAxisSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiusOfCurvature>::s_keyword,
        attribute::get(0x0046, 0x0075).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiusOfCurvature>::s_keyword,
        attribute::get(attribute::Keyword::RadiusOfCurvature).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::KeratometricPower>::s_keyword,
        attribute::get(0x0046, 0x0076).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::KeratometricPower>::s_keyword,
        attribute::get(attribute::Keyword::KeratometricPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::KeratometricAxis>::s_keyword,
        attribute::get(0x0046, 0x0077).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::KeratometricAxis>::s_keyword,
        attribute::get(attribute::Keyword::KeratometricAxis).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlatKeratometricAxisSequence>::s_keyword,
        attribute::get(0x0046, 0x0080).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FlatKeratometricAxisSequence>::s_keyword,
        attribute::get(attribute::Keyword::FlatKeratometricAxisSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealTopographySurface>::s_keyword,
        attribute::get(0x0046, 0x0201).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealTopographySurface>::s_keyword,
        attribute::get(attribute::Keyword::CornealTopographySurface).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealVertexLocation>::s_keyword,
        attribute::get(0x0046, 0x0202).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealVertexLocation>::s_keyword,
        attribute::get(attribute::Keyword::CornealVertexLocation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PupilCentroidXCoordinate>::s_keyword,
        attribute::get(0x0046, 0x0203).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PupilCentroidXCoordinate>::s_keyword,
        attribute::get(attribute::Keyword::PupilCentroidXCoordinate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PupilCentroidYCoordinate>::s_keyword,
        attribute::get(0x0046, 0x0204).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PupilCentroidYCoordinate>::s_keyword,
        attribute::get(attribute::Keyword::PupilCentroidYCoordinate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EquivalentPupilRadius>::s_keyword,
        attribute::get(0x0046, 0x0205).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EquivalentPupilRadius>::s_keyword,
        attribute::get(attribute::Keyword::EquivalentPupilRadius).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealTopographyMapTypeCodeSequence>::s_keyword,
        attribute::get(0x0046, 0x0207).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealTopographyMapTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::CornealTopographyMapTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerticesOfTheOutlineOfPupil>::s_keyword,
        attribute::get(0x0046, 0x0208).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VerticesOfTheOutlineOfPupil>::s_keyword,
        attribute::get(attribute::Keyword::VerticesOfTheOutlineOfPupil).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealTopographyMappingNormalsSequence>::s_keyword,
        attribute::get(0x0046, 0x0210).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealTopographyMappingNormalsSequence>::s_keyword,
        attribute::get(attribute::Keyword::CornealTopographyMappingNormalsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumCornealCurvatureSequence>::s_keyword,
        attribute::get(0x0046, 0x0211).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumCornealCurvatureSequence>::s_keyword,
        attribute::get(attribute::Keyword::MaximumCornealCurvatureSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumCornealCurvature>::s_keyword,
        attribute::get(0x0046, 0x0212).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumCornealCurvature>::s_keyword,
        attribute::get(attribute::Keyword::MaximumCornealCurvature).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumCornealCurvatureLocation>::s_keyword,
        attribute::get(0x0046, 0x0213).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumCornealCurvatureLocation>::s_keyword,
        attribute::get(attribute::Keyword::MaximumCornealCurvatureLocation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MinimumKeratometricSequence>::s_keyword,
        attribute::get(0x0046, 0x0215).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MinimumKeratometricSequence>::s_keyword,
        attribute::get(attribute::Keyword::MinimumKeratometricSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SimulatedKeratometricCylinderSequence>::s_keyword,
        attribute::get(0x0046, 0x0218).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SimulatedKeratometricCylinderSequence>::s_keyword,
        attribute::get(attribute::Keyword::SimulatedKeratometricCylinderSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AverageCornealPower>::s_keyword,
        attribute::get(0x0046, 0x0220).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AverageCornealPower>::s_keyword,
        attribute::get(attribute::Keyword::AverageCornealPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealISValue>::s_keyword,
        attribute::get(0x0046, 0x0224).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealISValue>::s_keyword,
        attribute::get(attribute::Keyword::CornealISValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnalyzedArea>::s_keyword,
        attribute::get(0x0046, 0x0227).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AnalyzedArea>::s_keyword,
        attribute::get(attribute::Keyword::AnalyzedArea).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceRegularityIndex>::s_keyword,
        attribute::get(0x0046, 0x0230).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceRegularityIndex>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceRegularityIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceAsymmetryIndex>::s_keyword,
        attribute::get(0x0046, 0x0232).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceAsymmetryIndex>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceAsymmetryIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealEccentricityIndex>::s_keyword,
        attribute::get(0x0046, 0x0234).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealEccentricityIndex>::s_keyword,
        attribute::get(attribute::Keyword::CornealEccentricityIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::KeratoconusPredictionIndex>::s_keyword,
        attribute::get(0x0046, 0x0236).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::KeratoconusPredictionIndex>::s_keyword,
        attribute::get(attribute::Keyword::KeratoconusPredictionIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecimalPotentialVisualAcuity>::s_keyword,
        attribute::get(0x0046, 0x0238).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecimalPotentialVisualAcuity>::s_keyword,
        attribute::get(attribute::Keyword::DecimalPotentialVisualAcuity).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealTopographyMapQualityEvaluation>::s_keyword,
        attribute::get(0x0046, 0x0242).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealTopographyMapQualityEvaluation>::s_keyword,
        attribute::get(attribute::Keyword::CornealTopographyMapQualityEvaluation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceImageCornealProcessedDataSequence>::s_keyword,
        attribute::get(0x0046, 0x0244).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceImageCornealProcessedDataSequence>::s_keyword,
        attribute::get(attribute::Keyword::SourceImageCornealProcessedDataSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealPointLocation>::s_keyword,
        attribute::get(0x0046, 0x0247).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealPointLocation>::s_keyword,
        attribute::get(attribute::Keyword::CornealPointLocation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealPointEstimated>::s_keyword,
        attribute::get(0x0046, 0x0248).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealPointEstimated>::s_keyword,
        attribute::get(attribute::Keyword::CornealPointEstimated).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialPower>::s_keyword,
        attribute::get(0x0046, 0x0249).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialPower>::s_keyword,
        attribute::get(attribute::Keyword::AxialPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TangentialPower>::s_keyword,
        attribute::get(0x0046, 0x0250).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TangentialPower>::s_keyword,
        attribute::get(attribute::Keyword::TangentialPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RefractivePower>::s_keyword,
        attribute::get(0x0046, 0x0251).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RefractivePower>::s_keyword,
        attribute::get(attribute::Keyword::RefractivePower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelativeElevation>::s_keyword,
        attribute::get(0x0046, 0x0252).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelativeElevation>::s_keyword,
        attribute::get(attribute::Keyword::RelativeElevation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealWavefront>::s_keyword,
        attribute::get(0x0046, 0x0253).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CornealWavefront>::s_keyword,
        attribute::get(attribute::Keyword::CornealWavefront).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagedVolumeWidth>::s_keyword,
        attribute::get(0x0048, 0x0001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagedVolumeWidth>::s_keyword,
        attribute::get(attribute::Keyword::ImagedVolumeWidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagedVolumeHeight>::s_keyword,
        attribute::get(0x0048, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagedVolumeHeight>::s_keyword,
        attribute::get(attribute::Keyword::ImagedVolumeHeight).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagedVolumeDepth>::s_keyword,
        attribute::get(0x0048, 0x0003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagedVolumeDepth>::s_keyword,
        attribute::get(attribute::Keyword::ImagedVolumeDepth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TotalPixelMatrixColumns>::s_keyword,
        attribute::get(0x0048, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TotalPixelMatrixColumns>::s_keyword,
        attribute::get(attribute::Keyword::TotalPixelMatrixColumns).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TotalPixelMatrixRows>::s_keyword,
        attribute::get(0x0048, 0x0007).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TotalPixelMatrixRows>::s_keyword,
        attribute::get(attribute::Keyword::TotalPixelMatrixRows).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TotalPixelMatrixOriginSequence>::s_keyword,
        attribute::get(0x0048, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TotalPixelMatrixOriginSequence>::s_keyword,
        attribute::get(attribute::Keyword::TotalPixelMatrixOriginSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenLabelInImage>::s_keyword,
        attribute::get(0x0048, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenLabelInImage>::s_keyword,
        attribute::get(attribute::Keyword::SpecimenLabelInImage).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocusMethod>::s_keyword,
        attribute::get(0x0048, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FocusMethod>::s_keyword,
        attribute::get(attribute::Keyword::FocusMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExtendedDepthOfField>::s_keyword,
        attribute::get(0x0048, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExtendedDepthOfField>::s_keyword,
        attribute::get(attribute::Keyword::ExtendedDepthOfField).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFocalPlanes>::s_keyword,
        attribute::get(0x0048, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFocalPlanes>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfFocalPlanes).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceBetweenFocalPlanes>::s_keyword,
        attribute::get(0x0048, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DistanceBetweenFocalPlanes>::s_keyword,
        attribute::get(attribute::Keyword::DistanceBetweenFocalPlanes).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedAbsentPixelCIELabValue>::s_keyword,
        attribute::get(0x0048, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedAbsentPixelCIELabValue>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedAbsentPixelCIELabValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminatorTypeCodeSequence>::s_keyword,
        attribute::get(0x0048, 0x0100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminatorTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::IlluminatorTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageOrientationSlide>::s_keyword,
        attribute::get(0x0048, 0x0102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageOrientationSlide>::s_keyword,
        attribute::get(attribute::Keyword::ImageOrientationSlide).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OpticalPathSequence>::s_keyword,
        attribute::get(0x0048, 0x0105).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OpticalPathSequence>::s_keyword,
        attribute::get(attribute::Keyword::OpticalPathSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OpticalPathIdentifier>::s_keyword,
        attribute::get(0x0048, 0x0106).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OpticalPathIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::OpticalPathIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OpticalPathDescription>::s_keyword,
        attribute::get(0x0048, 0x0107).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OpticalPathDescription>::s_keyword,
        attribute::get(attribute::Keyword::OpticalPathDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationColorCodeSequence>::s_keyword,
        attribute::get(0x0048, 0x0108).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IlluminationColorCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::IlluminationColorCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenReferenceSequence>::s_keyword,
        attribute::get(0x0048, 0x0110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpecimenReferenceSequence>::s_keyword,
        attribute::get(attribute::Keyword::SpecimenReferenceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CondenserLensPower>::s_keyword,
        attribute::get(0x0048, 0x0111).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CondenserLensPower>::s_keyword,
        attribute::get(attribute::Keyword::CondenserLensPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObjectiveLensPower>::s_keyword,
        attribute::get(0x0048, 0x0112).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObjectiveLensPower>::s_keyword,
        attribute::get(attribute::Keyword::ObjectiveLensPower).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObjectiveLensNumericalAperture>::s_keyword,
        attribute::get(0x0048, 0x0113).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ObjectiveLensNumericalAperture>::s_keyword,
        attribute::get(attribute::Keyword::ObjectiveLensNumericalAperture).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PaletteColorLookupTableSequence>::s_keyword,
        attribute::get(0x0048, 0x0120).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PaletteColorLookupTableSequence>::s_keyword,
        attribute::get(attribute::Keyword::PaletteColorLookupTableSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OpticalPathIdentificationSequence>::s_keyword,
        attribute::get(0x0048, 0x0207).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OpticalPathIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::OpticalPathIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanePositionSlideSequence>::s_keyword,
        attribute::get(0x0048, 0x021A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanePositionSlideSequence>::s_keyword,
        attribute::get(attribute::Keyword::PlanePositionSlideSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColumnPositionInTotalImagePixelMatrix>::s_keyword,
        attribute::get(0x0048, 0x021E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ColumnPositionInTotalImagePixelMatrix>::s_keyword,
        attribute::get(attribute::Keyword::ColumnPositionInTotalImagePixelMatrix).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RowPositionInTotalImagePixelMatrix>::s_keyword,
        attribute::get(0x0048, 0x021F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RowPositionInTotalImagePixelMatrix>::s_keyword,
        attribute::get(attribute::Keyword::RowPositionInTotalImagePixelMatrix).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelOriginInterpretation>::s_keyword,
        attribute::get(0x0048, 0x0301).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelOriginInterpretation>::s_keyword,
        attribute::get(attribute::Keyword::PixelOriginInterpretation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfOpticalPaths>::s_keyword,
        attribute::get(0x0048, 0x0302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfOpticalPaths>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfOpticalPaths).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TotalPixelMatrixFocalPlanes>::s_keyword,
        attribute::get(0x0048, 0x0303).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TotalPixelMatrixFocalPlanes>::s_keyword,
        attribute::get(attribute::Keyword::TotalPixelMatrixFocalPlanes).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalibrationImage>::s_keyword,
        attribute::get(0x0050, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalibrationImage>::s_keyword,
        attribute::get(attribute::Keyword::CalibrationImage).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceSequence>::s_keyword,
        attribute::get(0x0050, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceSequence>::s_keyword,
        attribute::get(attribute::Keyword::DeviceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentTypeCodeSequence>::s_keyword,
        attribute::get(0x0050, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContainerComponentTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentThickness>::s_keyword,
        attribute::get(0x0050, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentThickness>::s_keyword,
        attribute::get(attribute::Keyword::ContainerComponentThickness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceLength>::s_keyword,
        attribute::get(0x0050, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceLength>::s_keyword,
        attribute::get(attribute::Keyword::DeviceLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentWidth>::s_keyword,
        attribute::get(0x0050, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentWidth>::s_keyword,
        attribute::get(attribute::Keyword::ContainerComponentWidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceDiameter>::s_keyword,
        attribute::get(0x0050, 0x0016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceDiameter>::s_keyword,
        attribute::get(attribute::Keyword::DeviceDiameter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceDiameterUnits>::s_keyword,
        attribute::get(0x0050, 0x0017).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceDiameterUnits>::s_keyword,
        attribute::get(attribute::Keyword::DeviceDiameterUnits).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceVolume>::s_keyword,
        attribute::get(0x0050, 0x0018).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceVolume>::s_keyword,
        attribute::get(attribute::Keyword::DeviceVolume).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterMarkerDistance>::s_keyword,
        attribute::get(0x0050, 0x0019).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterMarkerDistance>::s_keyword,
        attribute::get(attribute::Keyword::InterMarkerDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentMaterial>::s_keyword,
        attribute::get(0x0050, 0x001A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentMaterial>::s_keyword,
        attribute::get(attribute::Keyword::ContainerComponentMaterial).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentID>::s_keyword,
        attribute::get(0x0050, 0x001B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentID>::s_keyword,
        attribute::get(attribute::Keyword::ContainerComponentID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentLength>::s_keyword,
        attribute::get(0x0050, 0x001C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentLength>::s_keyword,
        attribute::get(attribute::Keyword::ContainerComponentLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentDiameter>::s_keyword,
        attribute::get(0x0050, 0x001D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentDiameter>::s_keyword,
        attribute::get(attribute::Keyword::ContainerComponentDiameter).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentDescription>::s_keyword,
        attribute::get(0x0050, 0x001E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContainerComponentDescription>::s_keyword,
        attribute::get(attribute::Keyword::ContainerComponentDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceDescription>::s_keyword,
        attribute::get(0x0050, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceDescription>::s_keyword,
        attribute::get(attribute::Keyword::DeviceDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LongDeviceDescription>::s_keyword,
        attribute::get(0x0050, 0x0021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LongDeviceDescription>::s_keyword,
        attribute::get(attribute::Keyword::LongDeviceDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusIngredientPercentByVolume>::s_keyword,
        attribute::get(0x0052, 0x0001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContrastBolusIngredientPercentByVolume>::s_keyword,
        attribute::get(attribute::Keyword::ContrastBolusIngredientPercentByVolume).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTFocalDistance>::s_keyword,
        attribute::get(0x0052, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTFocalDistance>::s_keyword,
        attribute::get(attribute::Keyword::OCTFocalDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamSpotSize>::s_keyword,
        attribute::get(0x0052, 0x0003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamSpotSize>::s_keyword,
        attribute::get(attribute::Keyword::BeamSpotSize).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EffectiveRefractiveIndex>::s_keyword,
        attribute::get(0x0052, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EffectiveRefractiveIndex>::s_keyword,
        attribute::get(attribute::Keyword::EffectiveRefractiveIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTAcquisitionDomain>::s_keyword,
        attribute::get(0x0052, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTAcquisitionDomain>::s_keyword,
        attribute::get(attribute::Keyword::OCTAcquisitionDomain).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTOpticalCenterWavelength>::s_keyword,
        attribute::get(0x0052, 0x0007).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTOpticalCenterWavelength>::s_keyword,
        attribute::get(attribute::Keyword::OCTOpticalCenterWavelength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialResolution>::s_keyword,
        attribute::get(0x0052, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialResolution>::s_keyword,
        attribute::get(attribute::Keyword::AxialResolution).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RangingDepth>::s_keyword,
        attribute::get(0x0052, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RangingDepth>::s_keyword,
        attribute::get(attribute::Keyword::RangingDepth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ALineRate>::s_keyword,
        attribute::get(0x0052, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ALineRate>::s_keyword,
        attribute::get(attribute::Keyword::ALineRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ALinesPerFrame>::s_keyword,
        attribute::get(0x0052, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ALinesPerFrame>::s_keyword,
        attribute::get(attribute::Keyword::ALinesPerFrame).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CatheterRotationalRate>::s_keyword,
        attribute::get(0x0052, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CatheterRotationalRate>::s_keyword,
        attribute::get(attribute::Keyword::CatheterRotationalRate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ALinePixelSpacing>::s_keyword,
        attribute::get(0x0052, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ALinePixelSpacing>::s_keyword,
        attribute::get(attribute::Keyword::ALinePixelSpacing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModeOfPercutaneousAccessSequence>::s_keyword,
        attribute::get(0x0052, 0x0016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModeOfPercutaneousAccessSequence>::s_keyword,
        attribute::get(attribute::Keyword::ModeOfPercutaneousAccessSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntravascularOCTFrameTypeSequence>::s_keyword,
        attribute::get(0x0052, 0x0025).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntravascularOCTFrameTypeSequence>::s_keyword,
        attribute::get(attribute::Keyword::IntravascularOCTFrameTypeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTZOffsetApplied>::s_keyword,
        attribute::get(0x0052, 0x0026).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTZOffsetApplied>::s_keyword,
        attribute::get(attribute::Keyword::OCTZOffsetApplied).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntravascularFrameContentSequence>::s_keyword,
        attribute::get(0x0052, 0x0027).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntravascularFrameContentSequence>::s_keyword,
        attribute::get(attribute::Keyword::IntravascularFrameContentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntravascularLongitudinalDistance>::s_keyword,
        attribute::get(0x0052, 0x0028).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntravascularLongitudinalDistance>::s_keyword,
        attribute::get(attribute::Keyword::IntravascularLongitudinalDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntravascularOCTFrameContentSequence>::s_keyword,
        attribute::get(0x0052, 0x0029).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IntravascularOCTFrameContentSequence>::s_keyword,
        attribute::get(attribute::Keyword::IntravascularOCTFrameContentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTZOffsetCorrection>::s_keyword,
        attribute::get(0x0052, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OCTZOffsetCorrection>::s_keyword,
        attribute::get(attribute::Keyword::OCTZOffsetCorrection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CatheterDirectionOfRotation>::s_keyword,
        attribute::get(0x0052, 0x0031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CatheterDirectionOfRotation>::s_keyword,
        attribute::get(attribute::Keyword::CatheterDirectionOfRotation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeamLineLocation>::s_keyword,
        attribute::get(0x0052, 0x0033).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeamLineLocation>::s_keyword,
        attribute::get(attribute::Keyword::SeamLineLocation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FirstALineLocation>::s_keyword,
        attribute::get(0x0052, 0x0034).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FirstALineLocation>::s_keyword,
        attribute::get(attribute::Keyword::FirstALineLocation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeamLineIndex>::s_keyword,
        attribute::get(0x0052, 0x0036).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeamLineIndex>::s_keyword,
        attribute::get(attribute::Keyword::SeamLineIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfPaddedALines>::s_keyword,
        attribute::get(0x0052, 0x0038).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfPaddedALines>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfPaddedALines).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterpolationType>::s_keyword,
        attribute::get(0x0052, 0x0039).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InterpolationType>::s_keyword,
        attribute::get(attribute::Keyword::InterpolationType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RefractiveIndexApplied>::s_keyword,
        attribute::get(0x0052, 0x003A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RefractiveIndexApplied>::s_keyword,
        attribute::get(attribute::Keyword::RefractiveIndexApplied).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowVector>::s_keyword,
        attribute::get(0x0054, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowVector>::s_keyword,
        attribute::get(attribute::Keyword::EnergyWindowVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfEnergyWindows>::s_keyword,
        attribute::get(0x0054, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfEnergyWindows>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfEnergyWindows).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowInformationSequence>::s_keyword,
        attribute::get(0x0054, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowInformationSequence>::s_keyword,
        attribute::get(attribute::Keyword::EnergyWindowInformationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowRangeSequence>::s_keyword,
        attribute::get(0x0054, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowRangeSequence>::s_keyword,
        attribute::get(attribute::Keyword::EnergyWindowRangeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowLowerLimit>::s_keyword,
        attribute::get(0x0054, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowLowerLimit>::s_keyword,
        attribute::get(attribute::Keyword::EnergyWindowLowerLimit).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowUpperLimit>::s_keyword,
        attribute::get(0x0054, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowUpperLimit>::s_keyword,
        attribute::get(attribute::Keyword::EnergyWindowUpperLimit).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalInformationSequence>::s_keyword,
        attribute::get(0x0054, 0x0016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalInformationSequence>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalInformationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowName>::s_keyword,
        attribute::get(0x0054, 0x0018).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnergyWindowName>::s_keyword,
        attribute::get(attribute::Keyword::EnergyWindowName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorVector>::s_keyword,
        attribute::get(0x0054, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorVector>::s_keyword,
        attribute::get(attribute::Keyword::DetectorVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfDetectors>::s_keyword,
        attribute::get(0x0054, 0x0021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfDetectors>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfDetectors).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorInformationSequence>::s_keyword,
        attribute::get(0x0054, 0x0022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorInformationSequence>::s_keyword,
        attribute::get(attribute::Keyword::DetectorInformationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhaseVector>::s_keyword,
        attribute::get(0x0054, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhaseVector>::s_keyword,
        attribute::get(attribute::Keyword::PhaseVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfPhases>::s_keyword,
        attribute::get(0x0054, 0x0031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfPhases>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfPhases).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhaseInformationSequence>::s_keyword,
        attribute::get(0x0054, 0x0032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhaseInformationSequence>::s_keyword,
        attribute::get(attribute::Keyword::PhaseInformationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFramesInPhase>::s_keyword,
        attribute::get(0x0054, 0x0033).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFramesInPhase>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfFramesInPhase).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhaseDelay>::s_keyword,
        attribute::get(0x0054, 0x0036).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhaseDelay>::s_keyword,
        attribute::get(attribute::Keyword::PhaseDelay).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PauseBetweenFrames>::s_keyword,
        attribute::get(0x0054, 0x0038).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PauseBetweenFrames>::s_keyword,
        attribute::get(attribute::Keyword::PauseBetweenFrames).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhaseDescription>::s_keyword,
        attribute::get(0x0054, 0x0039).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PhaseDescription>::s_keyword,
        attribute::get(attribute::Keyword::PhaseDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RotationVector>::s_keyword,
        attribute::get(0x0054, 0x0050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RotationVector>::s_keyword,
        attribute::get(attribute::Keyword::RotationVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfRotations>::s_keyword,
        attribute::get(0x0054, 0x0051).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfRotations>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfRotations).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RotationInformationSequence>::s_keyword,
        attribute::get(0x0054, 0x0052).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RotationInformationSequence>::s_keyword,
        attribute::get(attribute::Keyword::RotationInformationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFramesInRotation>::s_keyword,
        attribute::get(0x0054, 0x0053).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFramesInRotation>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfFramesInRotation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RRIntervalVector>::s_keyword,
        attribute::get(0x0054, 0x0060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RRIntervalVector>::s_keyword,
        attribute::get(attribute::Keyword::RRIntervalVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfRRIntervals>::s_keyword,
        attribute::get(0x0054, 0x0061).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfRRIntervals>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfRRIntervals).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GatedInformationSequence>::s_keyword,
        attribute::get(0x0054, 0x0062).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GatedInformationSequence>::s_keyword,
        attribute::get(attribute::Keyword::GatedInformationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataInformationSequence>::s_keyword,
        attribute::get(0x0054, 0x0063).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataInformationSequence>::s_keyword,
        attribute::get(attribute::Keyword::DataInformationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeSlotVector>::s_keyword,
        attribute::get(0x0054, 0x0070).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeSlotVector>::s_keyword,
        attribute::get(attribute::Keyword::TimeSlotVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTimeSlots>::s_keyword,
        attribute::get(0x0054, 0x0071).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTimeSlots>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfTimeSlots).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceVector>::s_keyword,
        attribute::get(0x0054, 0x0080).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceVector>::s_keyword,
        attribute::get(attribute::Keyword::SliceVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfSlices>::s_keyword,
        attribute::get(0x0054, 0x0081).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfSlices>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfSlices).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AngularViewVector>::s_keyword,
        attribute::get(0x0054, 0x0090).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AngularViewVector>::s_keyword,
        attribute::get(attribute::Keyword::AngularViewVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeSliceVector>::s_keyword,
        attribute::get(0x0054, 0x0100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TimeSliceVector>::s_keyword,
        attribute::get(attribute::Keyword::TimeSliceVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTimeSlices>::s_keyword,
        attribute::get(0x0054, 0x0101).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTimeSlices>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfTimeSlices).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartAngle>::s_keyword,
        attribute::get(0x0054, 0x0200).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartAngle>::s_keyword,
        attribute::get(attribute::Keyword::StartAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TypeOfDetectorMotion>::s_keyword,
        attribute::get(0x0054, 0x0202).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TypeOfDetectorMotion>::s_keyword,
        attribute::get(attribute::Keyword::TypeOfDetectorMotion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TriggerVector>::s_keyword,
        attribute::get(0x0054, 0x0210).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TriggerVector>::s_keyword,
        attribute::get(attribute::Keyword::TriggerVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTriggersInPhase>::s_keyword,
        attribute::get(0x0054, 0x0211).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfTriggersInPhase>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfTriggersInPhase).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewCodeSequence>::s_keyword,
        attribute::get(0x0054, 0x0220).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ViewCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewModifierCodeSequence>::s_keyword,
        attribute::get(0x0054, 0x0222).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewModifierCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ViewModifierCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadionuclideCodeSequence>::s_keyword,
        attribute::get(0x0054, 0x0300).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadionuclideCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::RadionuclideCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdministrationRouteCodeSequence>::s_keyword,
        attribute::get(0x0054, 0x0302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AdministrationRouteCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::AdministrationRouteCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalCodeSequence>::s_keyword,
        attribute::get(0x0054, 0x0304).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiopharmaceuticalCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::RadiopharmaceuticalCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalibrationDataSequence>::s_keyword,
        attribute::get(0x0054, 0x0306).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CalibrationDataSequence>::s_keyword,
        attribute::get(attribute::Keyword::CalibrationDataSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageID>::s_keyword,
        attribute::get(0x0054, 0x0400).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageID>::s_keyword,
        attribute::get(attribute::Keyword::ImageID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientOrientationCodeSequence>::s_keyword,
        attribute::get(0x0054, 0x0410).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientOrientationCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientOrientationCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientOrientationModifierCodeSequence>::s_keyword,
        attribute::get(0x0054, 0x0412).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientOrientationModifierCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientOrientationModifierCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientGantryRelationshipCodeSequence>::s_keyword,
        attribute::get(0x0054, 0x0414).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientGantryRelationshipCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientGantryRelationshipCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceProgressionDirection>::s_keyword,
        attribute::get(0x0054, 0x0500).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceProgressionDirection>::s_keyword,
        attribute::get(attribute::Keyword::SliceProgressionDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanProgressionDirection>::s_keyword,
        attribute::get(0x0054, 0x0501).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScanProgressionDirection>::s_keyword,
        attribute::get(attribute::Keyword::ScanProgressionDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesType>::s_keyword,
        attribute::get(0x0054, 0x1000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SeriesType>::s_keyword,
        attribute::get(attribute::Keyword::SeriesType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Units>::s_keyword,
        attribute::get(0x0054, 0x1001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Units>::s_keyword,
        attribute::get(attribute::Keyword::Units).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CountsSource>::s_keyword,
        attribute::get(0x0054, 0x1002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CountsSource>::s_keyword,
        attribute::get(attribute::Keyword::CountsSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReprojectionMethod>::s_keyword,
        attribute::get(0x0054, 0x1004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReprojectionMethod>::s_keyword,
        attribute::get(attribute::Keyword::ReprojectionMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SUVType>::s_keyword,
        attribute::get(0x0054, 0x1006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SUVType>::s_keyword,
        attribute::get(attribute::Keyword::SUVType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RandomsCorrectionMethod>::s_keyword,
        attribute::get(0x0054, 0x1100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RandomsCorrectionMethod>::s_keyword,
        attribute::get(attribute::Keyword::RandomsCorrectionMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AttenuationCorrectionMethod>::s_keyword,
        attribute::get(0x0054, 0x1101).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AttenuationCorrectionMethod>::s_keyword,
        attribute::get(attribute::Keyword::AttenuationCorrectionMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecayCorrection>::s_keyword,
        attribute::get(0x0054, 0x1102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecayCorrection>::s_keyword,
        attribute::get(attribute::Keyword::DecayCorrection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionMethod>::s_keyword,
        attribute::get(0x0054, 0x1103).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReconstructionMethod>::s_keyword,
        attribute::get(attribute::Keyword::ReconstructionMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorLinesOfResponseUsed>::s_keyword,
        attribute::get(0x0054, 0x1104).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorLinesOfResponseUsed>::s_keyword,
        attribute::get(attribute::Keyword::DetectorLinesOfResponseUsed).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScatterCorrectionMethod>::s_keyword,
        attribute::get(0x0054, 0x1105).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScatterCorrectionMethod>::s_keyword,
        attribute::get(attribute::Keyword::ScatterCorrectionMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialAcceptance>::s_keyword,
        attribute::get(0x0054, 0x1200).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialAcceptance>::s_keyword,
        attribute::get(attribute::Keyword::AxialAcceptance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialMash>::s_keyword,
        attribute::get(0x0054, 0x1201).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxialMash>::s_keyword,
        attribute::get(attribute::Keyword::AxialMash).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransverseMash>::s_keyword,
        attribute::get(0x0054, 0x1202).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TransverseMash>::s_keyword,
        attribute::get(attribute::Keyword::TransverseMash).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorElementSize>::s_keyword,
        attribute::get(0x0054, 0x1203).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DetectorElementSize>::s_keyword,
        attribute::get(attribute::Keyword::DetectorElementSize).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CoincidenceWindowWidth>::s_keyword,
        attribute::get(0x0054, 0x1210).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CoincidenceWindowWidth>::s_keyword,
        attribute::get(attribute::Keyword::CoincidenceWindowWidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCountsType>::s_keyword,
        attribute::get(0x0054, 0x1220).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCountsType>::s_keyword,
        attribute::get(attribute::Keyword::SecondaryCountsType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameReferenceTime>::s_keyword,
        attribute::get(0x0054, 0x1300).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameReferenceTime>::s_keyword,
        attribute::get(attribute::Keyword::FrameReferenceTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryPromptsCountsAccumulated>::s_keyword,
        attribute::get(0x0054, 0x1310).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryPromptsCountsAccumulated>::s_keyword,
        attribute::get(attribute::Keyword::PrimaryPromptsCountsAccumulated).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCountsAccumulated>::s_keyword,
        attribute::get(0x0054, 0x1311).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SecondaryCountsAccumulated>::s_keyword,
        attribute::get(attribute::Keyword::SecondaryCountsAccumulated).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceSensitivityFactor>::s_keyword,
        attribute::get(0x0054, 0x1320).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SliceSensitivityFactor>::s_keyword,
        attribute::get(attribute::Keyword::SliceSensitivityFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecayFactor>::s_keyword,
        attribute::get(0x0054, 0x1321).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DecayFactor>::s_keyword,
        attribute::get(attribute::Keyword::DecayFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseCalibrationFactor>::s_keyword,
        attribute::get(0x0054, 0x1322).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseCalibrationFactor>::s_keyword,
        attribute::get(attribute::Keyword::DoseCalibrationFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScatterFractionFactor>::s_keyword,
        attribute::get(0x0054, 0x1323).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScatterFractionFactor>::s_keyword,
        attribute::get(attribute::Keyword::ScatterFractionFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeadTimeFactor>::s_keyword,
        attribute::get(0x0054, 0x1324).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeadTimeFactor>::s_keyword,
        attribute::get(attribute::Keyword::DeadTimeFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageIndex>::s_keyword,
        attribute::get(0x0054, 0x1330).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageIndex>::s_keyword,
        attribute::get(attribute::Keyword::ImageIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramSequence>::s_keyword,
        attribute::get(0x0060, 0x3000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramSequence>::s_keyword,
        attribute::get(attribute::Keyword::HistogramSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramNumberOfBins>::s_keyword,
        attribute::get(0x0060, 0x3002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramNumberOfBins>::s_keyword,
        attribute::get(attribute::Keyword::HistogramNumberOfBins).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramFirstBinValue>::s_keyword,
        attribute::get(0x0060, 0x3004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramFirstBinValue>::s_keyword,
        attribute::get(attribute::Keyword::HistogramFirstBinValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramLastBinValue>::s_keyword,
        attribute::get(0x0060, 0x3006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramLastBinValue>::s_keyword,
        attribute::get(attribute::Keyword::HistogramLastBinValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramBinWidth>::s_keyword,
        attribute::get(0x0060, 0x3008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramBinWidth>::s_keyword,
        attribute::get(attribute::Keyword::HistogramBinWidth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramExplanation>::s_keyword,
        attribute::get(0x0060, 0x3010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramExplanation>::s_keyword,
        attribute::get(attribute::Keyword::HistogramExplanation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramData>::s_keyword,
        attribute::get(0x0060, 0x3020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HistogramData>::s_keyword,
        attribute::get(attribute::Keyword::HistogramData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentationType>::s_keyword,
        attribute::get(0x0062, 0x0001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentationType>::s_keyword,
        attribute::get(attribute::Keyword::SegmentationType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentSequence>::s_keyword,
        attribute::get(0x0062, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentSequence>::s_keyword,
        attribute::get(attribute::Keyword::SegmentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedPropertyCategoryCodeSequence>::s_keyword,
        attribute::get(0x0062, 0x0003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedPropertyCategoryCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::SegmentedPropertyCategoryCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentNumber>::s_keyword,
        attribute::get(0x0062, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentNumber>::s_keyword,
        attribute::get(attribute::Keyword::SegmentNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentLabel>::s_keyword,
        attribute::get(0x0062, 0x0005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentLabel>::s_keyword,
        attribute::get(attribute::Keyword::SegmentLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentDescription>::s_keyword,
        attribute::get(0x0062, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentDescription>::s_keyword,
        attribute::get(attribute::Keyword::SegmentDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentationAlgorithmIdentificationSequence>::s_keyword,
        attribute::get(0x0062, 0x0007).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentationAlgorithmIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::SegmentationAlgorithmIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentAlgorithmType>::s_keyword,
        attribute::get(0x0062, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentAlgorithmType>::s_keyword,
        attribute::get(attribute::Keyword::SegmentAlgorithmType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentAlgorithmName>::s_keyword,
        attribute::get(0x0062, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentAlgorithmName>::s_keyword,
        attribute::get(attribute::Keyword::SegmentAlgorithmName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentIdentificationSequence>::s_keyword,
        attribute::get(0x0062, 0x000A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::SegmentIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSegmentNumber>::s_keyword,
        attribute::get(0x0062, 0x000B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSegmentNumber>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSegmentNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedDisplayGrayscaleValue>::s_keyword,
        attribute::get(0x0062, 0x000C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedDisplayGrayscaleValue>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedDisplayGrayscaleValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedDisplayCIELabValue>::s_keyword,
        attribute::get(0x0062, 0x000D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedDisplayCIELabValue>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedDisplayCIELabValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumFractionalValue>::s_keyword,
        attribute::get(0x0062, 0x000E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumFractionalValue>::s_keyword,
        attribute::get(attribute::Keyword::MaximumFractionalValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedPropertyTypeCodeSequence>::s_keyword,
        attribute::get(0x0062, 0x000F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedPropertyTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::SegmentedPropertyTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentationFractionalType>::s_keyword,
        attribute::get(0x0062, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentationFractionalType>::s_keyword,
        attribute::get(attribute::Keyword::SegmentationFractionalType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedPropertyTypeModifierCodeSequence>::s_keyword,
        attribute::get(0x0062, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentedPropertyTypeModifierCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::SegmentedPropertyTypeModifierCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentsOverlap>::s_keyword,
        attribute::get(0x0062, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SegmentsOverlap>::s_keyword,
        attribute::get(attribute::Keyword::SegmentsOverlap).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TrackingID>::s_keyword,
        attribute::get(0x0062, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TrackingID>::s_keyword,
        attribute::get(attribute::Keyword::TrackingID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TrackingUID>::s_keyword,
        attribute::get(0x0062, 0x0021).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TrackingUID>::s_keyword,
        attribute::get(attribute::Keyword::TrackingUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfSurfaces>::s_keyword,
        attribute::get(0x0066, 0x0001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfSurfaces>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfSurfaces).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceSequence>::s_keyword,
        attribute::get(0x0066, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceSequence>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceNumber>::s_keyword,
        attribute::get(0x0066, 0x0003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceNumber>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceComments>::s_keyword,
        attribute::get(0x0066, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceComments>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceComments).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceProcessing>::s_keyword,
        attribute::get(0x0066, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceProcessing>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceProcessing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceProcessingRatio>::s_keyword,
        attribute::get(0x0066, 0x000A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceProcessingRatio>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceProcessingRatio).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceProcessingDescription>::s_keyword,
        attribute::get(0x0066, 0x000B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceProcessingDescription>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceProcessingDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedPresentationOpacity>::s_keyword,
        attribute::get(0x0066, 0x000C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedPresentationOpacity>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedPresentationOpacity).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedPresentationType>::s_keyword,
        attribute::get(0x0066, 0x000D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedPresentationType>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedPresentationType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FiniteVolume>::s_keyword,
        attribute::get(0x0066, 0x000E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FiniteVolume>::s_keyword,
        attribute::get(attribute::Keyword::FiniteVolume).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Manifold>::s_keyword,
        attribute::get(0x0066, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Manifold>::s_keyword,
        attribute::get(attribute::Keyword::Manifold).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfacePointsSequence>::s_keyword,
        attribute::get(0x0066, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfacePointsSequence>::s_keyword,
        attribute::get(attribute::Keyword::SurfacePointsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfacePointsNormalsSequence>::s_keyword,
        attribute::get(0x0066, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfacePointsNormalsSequence>::s_keyword,
        attribute::get(attribute::Keyword::SurfacePointsNormalsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceMeshPrimitivesSequence>::s_keyword,
        attribute::get(0x0066, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceMeshPrimitivesSequence>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceMeshPrimitivesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfSurfacePoints>::s_keyword,
        attribute::get(0x0066, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfSurfacePoints>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfSurfacePoints).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PointCoordinatesData>::s_keyword,
        attribute::get(0x0066, 0x0016).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PointCoordinatesData>::s_keyword,
        attribute::get(attribute::Keyword::PointCoordinatesData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PointPositionAccuracy>::s_keyword,
        attribute::get(0x0066, 0x0017).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PointPositionAccuracy>::s_keyword,
        attribute::get(attribute::Keyword::PointPositionAccuracy).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeanPointDistance>::s_keyword,
        attribute::get(0x0066, 0x0018).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MeanPointDistance>::s_keyword,
        attribute::get(attribute::Keyword::MeanPointDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumPointDistance>::s_keyword,
        attribute::get(0x0066, 0x0019).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaximumPointDistance>::s_keyword,
        attribute::get(attribute::Keyword::MaximumPointDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PointsBoundingBoxCoordinates>::s_keyword,
        attribute::get(0x0066, 0x001A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PointsBoundingBoxCoordinates>::s_keyword,
        attribute::get(attribute::Keyword::PointsBoundingBoxCoordinates).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxisOfRotation>::s_keyword,
        attribute::get(0x0066, 0x001B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AxisOfRotation>::s_keyword,
        attribute::get(attribute::Keyword::AxisOfRotation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfRotation>::s_keyword,
        attribute::get(0x0066, 0x001C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CenterOfRotation>::s_keyword,
        attribute::get(attribute::Keyword::CenterOfRotation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceCount>::s_keyword,
        attribute::get(0x0066, 0x002A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceCount>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceCount).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSurfaceSequence>::s_keyword,
        attribute::get(0x0066, 0x002B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSurfaceSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSurfaceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSurfaceNumber>::s_keyword,
        attribute::get(0x0066, 0x002C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSurfaceNumber>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSurfaceNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmFamilyCodeSequence>::s_keyword,
        attribute::get(0x0066, 0x002F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmFamilyCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::AlgorithmFamilyCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmNameCodeSequence>::s_keyword,
        attribute::get(0x0066, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmNameCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::AlgorithmNameCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmVersion>::s_keyword,
        attribute::get(0x0066, 0x0031).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmVersion>::s_keyword,
        attribute::get(attribute::Keyword::AlgorithmVersion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmParameters>::s_keyword,
        attribute::get(0x0066, 0x0032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmParameters>::s_keyword,
        attribute::get(attribute::Keyword::AlgorithmParameters).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceProcessingAlgorithmIdentificationSequence>::s_keyword,
        attribute::get(0x0066, 0x0035).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceProcessingAlgorithmIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceProcessingAlgorithmIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmName>::s_keyword,
        attribute::get(0x0066, 0x0036).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlgorithmName>::s_keyword,
        attribute::get(attribute::Keyword::AlgorithmName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedPointRadius>::s_keyword,
        attribute::get(0x0066, 0x0037).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedPointRadius>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedPointRadius).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedLineThickness>::s_keyword,
        attribute::get(0x0066, 0x0038).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedLineThickness>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedLineThickness).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantSize>::s_keyword,
        attribute::get(0x0068, 0x6210).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantSize>::s_keyword,
        attribute::get(attribute::Keyword::ImplantSize).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantTemplateVersion>::s_keyword,
        attribute::get(0x0068, 0x6221).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantTemplateVersion>::s_keyword,
        attribute::get(attribute::Keyword::ImplantTemplateVersion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReplacedImplantTemplateSequence>::s_keyword,
        attribute::get(0x0068, 0x6222).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReplacedImplantTemplateSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReplacedImplantTemplateSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantType>::s_keyword,
        attribute::get(0x0068, 0x6223).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantType>::s_keyword,
        attribute::get(attribute::Keyword::ImplantType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DerivationImplantTemplateSequence>::s_keyword,
        attribute::get(0x0068, 0x6224).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DerivationImplantTemplateSequence>::s_keyword,
        attribute::get(attribute::Keyword::DerivationImplantTemplateSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OriginalImplantTemplateSequence>::s_keyword,
        attribute::get(0x0068, 0x6225).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OriginalImplantTemplateSequence>::s_keyword,
        attribute::get(attribute::Keyword::OriginalImplantTemplateSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EffectiveDateTime>::s_keyword,
        attribute::get(0x0068, 0x6226).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EffectiveDateTime>::s_keyword,
        attribute::get(attribute::Keyword::EffectiveDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantTargetAnatomySequence>::s_keyword,
        attribute::get(0x0068, 0x6230).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantTargetAnatomySequence>::s_keyword,
        attribute::get(attribute::Keyword::ImplantTargetAnatomySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InformationFromManufacturerSequence>::s_keyword,
        attribute::get(0x0068, 0x6260).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InformationFromManufacturerSequence>::s_keyword,
        attribute::get(attribute::Keyword::InformationFromManufacturerSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NotificationFromManufacturerSequence>::s_keyword,
        attribute::get(0x0068, 0x6265).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NotificationFromManufacturerSequence>::s_keyword,
        attribute::get(attribute::Keyword::NotificationFromManufacturerSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InformationIssueDateTime>::s_keyword,
        attribute::get(0x0068, 0x6270).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InformationIssueDateTime>::s_keyword,
        attribute::get(attribute::Keyword::InformationIssueDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InformationSummary>::s_keyword,
        attribute::get(0x0068, 0x6280).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InformationSummary>::s_keyword,
        attribute::get(attribute::Keyword::InformationSummary).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantRegulatoryDisapprovalCodeSequence>::s_keyword,
        attribute::get(0x0068, 0x62A0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantRegulatoryDisapprovalCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ImplantRegulatoryDisapprovalCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverallTemplateSpatialTolerance>::s_keyword,
        attribute::get(0x0068, 0x62A5).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverallTemplateSpatialTolerance>::s_keyword,
        attribute::get(attribute::Keyword::OverallTemplateSpatialTolerance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLDocumentSequence>::s_keyword,
        attribute::get(0x0068, 0x62C0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLDocumentSequence>::s_keyword,
        attribute::get(attribute::Keyword::HPGLDocumentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLDocumentID>::s_keyword,
        attribute::get(0x0068, 0x62D0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLDocumentID>::s_keyword,
        attribute::get(attribute::Keyword::HPGLDocumentID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLDocumentLabel>::s_keyword,
        attribute::get(0x0068, 0x62D5).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLDocumentLabel>::s_keyword,
        attribute::get(attribute::Keyword::HPGLDocumentLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewOrientationCodeSequence>::s_keyword,
        attribute::get(0x0068, 0x62E0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewOrientationCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ViewOrientationCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewOrientationModifierCodeSequence>::s_keyword,
        attribute::get(0x0068, 0x62F0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewOrientationModifierCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ViewOrientationModifierCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLDocumentScaling>::s_keyword,
        attribute::get(0x0068, 0x62F2).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLDocumentScaling>::s_keyword,
        attribute::get(attribute::Keyword::HPGLDocumentScaling).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLDocument>::s_keyword,
        attribute::get(0x0068, 0x6300).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLDocument>::s_keyword,
        attribute::get(attribute::Keyword::HPGLDocument).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLContourPenNumber>::s_keyword,
        attribute::get(0x0068, 0x6310).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLContourPenNumber>::s_keyword,
        attribute::get(attribute::Keyword::HPGLContourPenNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLPenSequence>::s_keyword,
        attribute::get(0x0068, 0x6320).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HPGLPenSequence>::s_keyword,
        attribute::get(attribute::Keyword::HPGLPenSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedRotationPoint>::s_keyword,
        attribute::get(0x0068, 0x6346).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RecommendedRotationPoint>::s_keyword,
        attribute::get(attribute::Keyword::RecommendedRotationPoint).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BoundingRectangle>::s_keyword,
        attribute::get(0x0068, 0x6347).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BoundingRectangle>::s_keyword,
        attribute::get(attribute::Keyword::BoundingRectangle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantTemplate3DModelSurfaceNumber>::s_keyword,
        attribute::get(0x0068, 0x6350).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantTemplate3DModelSurfaceNumber>::s_keyword,
        attribute::get(attribute::Keyword::ImplantTemplate3DModelSurfaceNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceModelDescriptionSequence>::s_keyword,
        attribute::get(0x0068, 0x6360).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceModelDescriptionSequence>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceModelDescriptionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceModelLabel>::s_keyword,
        attribute::get(0x0068, 0x6380).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceModelLabel>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceModelLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceModelScalingFactor>::s_keyword,
        attribute::get(0x0068, 0x6390).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceModelScalingFactor>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceModelScalingFactor).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaterialsCodeSequence>::s_keyword,
        attribute::get(0x0068, 0x63A0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MaterialsCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::MaterialsCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CoatingMaterialsCodeSequence>::s_keyword,
        attribute::get(0x0068, 0x63A4).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CoatingMaterialsCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::CoatingMaterialsCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantTypeCodeSequence>::s_keyword,
        attribute::get(0x0068, 0x63A8).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImplantTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ImplantTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FixationMethodCodeSequence>::s_keyword,
        attribute::get(0x0068, 0x63AC).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FixationMethodCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::FixationMethodCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MatingFeatureSetsSequence>::s_keyword,
        attribute::get(0x0068, 0x63B0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MatingFeatureSetsSequence>::s_keyword,
        attribute::get(attribute::Keyword::MatingFeatureSetsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MatingFeatureSetID>::s_keyword,
        attribute::get(0x0068, 0x63C0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MatingFeatureSetID>::s_keyword,
        attribute::get(attribute::Keyword::MatingFeatureSetID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MatingFeatureSetLabel>::s_keyword,
        attribute::get(0x0068, 0x63D0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MatingFeatureSetLabel>::s_keyword,
        attribute::get(attribute::Keyword::MatingFeatureSetLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MatingFeatureSequence>::s_keyword,
        attribute::get(0x0068, 0x63E0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MatingFeatureSequence>::s_keyword,
        attribute::get(attribute::Keyword::MatingFeatureSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedHPGLDocumentID>::s_keyword,
        attribute::get(0x0068, 0x6440).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedHPGLDocumentID>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedHPGLDocumentID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkPointSequence>::s_keyword,
        attribute::get(0x0068, 0x6500).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkPointSequence>::s_keyword,
        attribute::get(attribute::Keyword::PlanningLandmarkPointSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkLineSequence>::s_keyword,
        attribute::get(0x0068, 0x6510).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkLineSequence>::s_keyword,
        attribute::get(attribute::Keyword::PlanningLandmarkLineSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkPlaneSequence>::s_keyword,
        attribute::get(0x0068, 0x6520).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkPlaneSequence>::s_keyword,
        attribute::get(attribute::Keyword::PlanningLandmarkPlaneSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkID>::s_keyword,
        attribute::get(0x0068, 0x6530).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkID>::s_keyword,
        attribute::get(attribute::Keyword::PlanningLandmarkID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkDescription>::s_keyword,
        attribute::get(0x0068, 0x6540).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkDescription>::s_keyword,
        attribute::get(attribute::Keyword::PlanningLandmarkDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkIdentificationCodeSequence>::s_keyword,
        attribute::get(0x0068, 0x6545).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanningLandmarkIdentificationCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PlanningLandmarkIdentificationCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDPointCoordinatesSequence>::s_keyword,
        attribute::get(0x0068, 0x6550).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDPointCoordinatesSequence>::s_keyword,
        attribute::get(attribute::Keyword::TwoDPointCoordinatesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDPointCoordinates>::s_keyword,
        attribute::get(0x0068, 0x6560).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDPointCoordinates>::s_keyword,
        attribute::get(attribute::Keyword::TwoDPointCoordinates).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ThreeDPointCoordinates>::s_keyword,
        attribute::get(0x0068, 0x6590).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ThreeDPointCoordinates>::s_keyword,
        attribute::get(attribute::Keyword::ThreeDPointCoordinates).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDLineCoordinatesSequence>::s_keyword,
        attribute::get(0x0068, 0x65A0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDLineCoordinatesSequence>::s_keyword,
        attribute::get(attribute::Keyword::TwoDLineCoordinatesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDLineCoordinates>::s_keyword,
        attribute::get(0x0068, 0x65B0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDLineCoordinates>::s_keyword,
        attribute::get(attribute::Keyword::TwoDLineCoordinates).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ThreeDLineCoordinates>::s_keyword,
        attribute::get(0x0068, 0x65D0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ThreeDLineCoordinates>::s_keyword,
        attribute::get(attribute::Keyword::ThreeDLineCoordinates).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDPlaneCoordinatesSequence>::s_keyword,
        attribute::get(0x0068, 0x65E0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDPlaneCoordinatesSequence>::s_keyword,
        attribute::get(attribute::Keyword::TwoDPlaneCoordinatesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDPlaneIntersection>::s_keyword,
        attribute::get(0x0068, 0x65F0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TwoDPlaneIntersection>::s_keyword,
        attribute::get(attribute::Keyword::TwoDPlaneIntersection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ThreeDPlaneOrigin>::s_keyword,
        attribute::get(0x0068, 0x6610).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ThreeDPlaneOrigin>::s_keyword,
        attribute::get(attribute::Keyword::ThreeDPlaneOrigin).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ThreeDPlaneNormal>::s_keyword,
        attribute::get(0x0068, 0x6620).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ThreeDPlaneNormal>::s_keyword,
        attribute::get(attribute::Keyword::ThreeDPlaneNormal).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModelModification>::s_keyword,
        attribute::get(0x0068, 0x7001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModelModification>::s_keyword,
        attribute::get(attribute::Keyword::ModelModification).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModelMirroring>::s_keyword,
        attribute::get(0x0068, 0x7002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModelMirroring>::s_keyword,
        attribute::get(attribute::Keyword::ModelMirroring).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModelUsageCodeSequence>::s_keyword,
        attribute::get(0x0068, 0x7003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModelUsageCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ModelUsageCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModelGroupUID>::s_keyword,
        attribute::get(0x0068, 0x7004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModelGroupUID>::s_keyword,
        attribute::get(attribute::Keyword::ModelGroupUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelativeURIReferenceWithinEncapsulatedDocument>::s_keyword,
        attribute::get(0x0068, 0x7005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RelativeURIReferenceWithinEncapsulatedDocument>::s_keyword,
        attribute::get(attribute::Keyword::RelativeURIReferenceWithinEncapsulatedDocument).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UnformattedTextValue>::s_keyword,
        attribute::get(0x0070, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UnformattedTextValue>::s_keyword,
        attribute::get(attribute::Keyword::UnformattedTextValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BoundingBoxTextHorizontalJustification>::s_keyword,
        attribute::get(0x0070, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BoundingBoxTextHorizontalJustification>::s_keyword,
        attribute::get(attribute::Keyword::BoundingBoxTextHorizontalJustification).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GraphicData>::s_keyword,
        attribute::get(0x0070, 0x0022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GraphicData>::s_keyword,
        attribute::get(attribute::Keyword::GraphicData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GraphicType>::s_keyword,
        attribute::get(0x0070, 0x0023).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GraphicType>::s_keyword,
        attribute::get(attribute::Keyword::GraphicType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentLabel>::s_keyword,
        attribute::get(0x0070, 0x0080).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentLabel>::s_keyword,
        attribute::get(attribute::Keyword::ContentLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentDescription>::s_keyword,
        attribute::get(0x0070, 0x0081).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentDescription>::s_keyword,
        attribute::get(attribute::Keyword::ContentDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PresentationCreationDate>::s_keyword,
        attribute::get(0x0070, 0x0082).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PresentationCreationDate>::s_keyword,
        attribute::get(attribute::Keyword::PresentationCreationDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PresentationCreationTime>::s_keyword,
        attribute::get(0x0070, 0x0083).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PresentationCreationTime>::s_keyword,
        attribute::get(attribute::Keyword::PresentationCreationTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentCreatorName>::s_keyword,
        attribute::get(0x0070, 0x0084).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentCreatorName>::s_keyword,
        attribute::get(attribute::Keyword::ContentCreatorName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentCreatorIdentificationCodeSequence>::s_keyword,
        attribute::get(0x0070, 0x0086).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ContentCreatorIdentificationCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ContentCreatorIdentificationCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlternateContentDescriptionSequence>::s_keyword,
        attribute::get(0x0070, 0x0087).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AlternateContentDescriptionSequence>::s_keyword,
        attribute::get(attribute::Keyword::AlternateContentDescriptionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FiducialUID>::s_keyword,
        attribute::get(0x0070, 0x031A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FiducialUID>::s_keyword,
        attribute::get(attribute::Keyword::FiducialUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FiducialSetSequence>::s_keyword,
        attribute::get(0x0070, 0x031C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FiducialSetSequence>::s_keyword,
        attribute::get(attribute::Keyword::FiducialSetSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FiducialSequence>::s_keyword,
        attribute::get(0x0070, 0x031E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FiducialSequence>::s_keyword,
        attribute::get(attribute::Keyword::FiducialSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GraphicLayerRecommendedDisplayCIELabValue>::s_keyword,
        attribute::get(0x0070, 0x0401).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GraphicLayerRecommendedDisplayCIELabValue>::s_keyword,
        attribute::get(attribute::Keyword::GraphicLayerRecommendedDisplayCIELabValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSpatialRegistrationSequence>::s_keyword,
        attribute::get(0x0070, 0x0404).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSpatialRegistrationSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSpatialRegistrationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RenderProjection>::s_keyword,
        attribute::get(0x0070, 0x1602).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RenderProjection>::s_keyword,
        attribute::get(attribute::Keyword::RenderProjection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewpointPosition>::s_keyword,
        attribute::get(0x0070, 0x1603).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewpointPosition>::s_keyword,
        attribute::get(attribute::Keyword::ViewpointPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewpointLookAtPoint>::s_keyword,
        attribute::get(0x0070, 0x1604).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewpointLookAtPoint>::s_keyword,
        attribute::get(attribute::Keyword::ViewpointLookAtPoint).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewpointUpDirection>::s_keyword,
        attribute::get(0x0070, 0x1605).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ViewpointUpDirection>::s_keyword,
        attribute::get(attribute::Keyword::ViewpointUpDirection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RenderFieldOfView>::s_keyword,
        attribute::get(0x0070, 0x1606).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RenderFieldOfView>::s_keyword,
        attribute::get(attribute::Keyword::RenderFieldOfView).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HangingProtocolName>::s_keyword,
        attribute::get(0x0072, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HangingProtocolName>::s_keyword,
        attribute::get(attribute::Keyword::HangingProtocolName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HangingProtocolCreator>::s_keyword,
        attribute::get(0x0072, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::HangingProtocolCreator>::s_keyword,
        attribute::get(attribute::Keyword::HangingProtocolCreator).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfScreens>::s_keyword,
        attribute::get(0x0072, 0x0100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfScreens>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfScreens).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalScreenDefinitionSequence>::s_keyword,
        attribute::get(0x0072, 0x0102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NominalScreenDefinitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::NominalScreenDefinitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfVerticalPixels>::s_keyword,
        attribute::get(0x0072, 0x0104).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfVerticalPixels>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfVerticalPixels).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfHorizontalPixels>::s_keyword,
        attribute::get(0x0072, 0x0106).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfHorizontalPixels>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfHorizontalPixels).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplayEnvironmentSpatialPosition>::s_keyword,
        attribute::get(0x0072, 0x0108).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplayEnvironmentSpatialPosition>::s_keyword,
        attribute::get(attribute::Keyword::DisplayEnvironmentSpatialPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScreenMinimumGrayscaleBitDepth>::s_keyword,
        attribute::get(0x0072, 0x010A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScreenMinimumGrayscaleBitDepth>::s_keyword,
        attribute::get(attribute::Keyword::ScreenMinimumGrayscaleBitDepth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScreenMinimumColorBitDepth>::s_keyword,
        attribute::get(0x0072, 0x010C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ScreenMinimumColorBitDepth>::s_keyword,
        attribute::get(attribute::Keyword::ScreenMinimumColorBitDepth).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicationMaximumRepaintTime>::s_keyword,
        attribute::get(0x0072, 0x010E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicationMaximumRepaintTime>::s_keyword,
        attribute::get(attribute::Keyword::ApplicationMaximumRepaintTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxNumber>::s_keyword,
        attribute::get(0x0072, 0x0302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxNumber>::s_keyword,
        attribute::get(attribute::Keyword::ImageBoxNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxLayoutType>::s_keyword,
        attribute::get(0x0072, 0x0304).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxLayoutType>::s_keyword,
        attribute::get(attribute::Keyword::ImageBoxLayoutType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxTileHorizontalDimension>::s_keyword,
        attribute::get(0x0072, 0x0306).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxTileHorizontalDimension>::s_keyword,
        attribute::get(attribute::Keyword::ImageBoxTileHorizontalDimension).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxTileVerticalDimension>::s_keyword,
        attribute::get(0x0072, 0x0308).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxTileVerticalDimension>::s_keyword,
        attribute::get(attribute::Keyword::ImageBoxTileVerticalDimension).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxOverlapPriority>::s_keyword,
        attribute::get(0x0072, 0x0320).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxOverlapPriority>::s_keyword,
        attribute::get(attribute::Keyword::ImageBoxOverlapPriority).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CineRelativeToRealTime>::s_keyword,
        attribute::get(0x0072, 0x0330).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CineRelativeToRealTime>::s_keyword,
        attribute::get(attribute::Keyword::CineRelativeToRealTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StructuredDisplayBackgroundCIELabValue>::s_keyword,
        attribute::get(0x0072, 0x0420).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StructuredDisplayBackgroundCIELabValue>::s_keyword,
        attribute::get(attribute::Keyword::StructuredDisplayBackgroundCIELabValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EmptyImageBoxCIELabValue>::s_keyword,
        attribute::get(0x0072, 0x0421).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EmptyImageBoxCIELabValue>::s_keyword,
        attribute::get(attribute::Keyword::EmptyImageBoxCIELabValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StructuredDisplayImageBoxSequence>::s_keyword,
        attribute::get(0x0072, 0x0422).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StructuredDisplayImageBoxSequence>::s_keyword,
        attribute::get(attribute::Keyword::StructuredDisplayImageBoxSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StructuredDisplayTextBoxSequence>::s_keyword,
        attribute::get(0x0072, 0x0424).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StructuredDisplayTextBoxSequence>::s_keyword,
        attribute::get(attribute::Keyword::StructuredDisplayTextBoxSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedFirstFrameSequence>::s_keyword,
        attribute::get(0x0072, 0x0427).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedFirstFrameSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedFirstFrameSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxSynchronizationSequence>::s_keyword,
        attribute::get(0x0072, 0x0430).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageBoxSynchronizationSequence>::s_keyword,
        attribute::get(attribute::Keyword::ImageBoxSynchronizationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SynchronizedImageBoxList>::s_keyword,
        attribute::get(0x0072, 0x0432).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SynchronizedImageBoxList>::s_keyword,
        attribute::get(attribute::Keyword::SynchronizedImageBoxList).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TypeOfSynchronization>::s_keyword,
        attribute::get(0x0072, 0x0434).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TypeOfSynchronization>::s_keyword,
        attribute::get(attribute::Keyword::TypeOfSynchronization).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplaySetHorizontalJustification>::s_keyword,
        attribute::get(0x0072, 0x0717).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplaySetHorizontalJustification>::s_keyword,
        attribute::get(attribute::Keyword::DisplaySetHorizontalJustification).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplaySetVerticalJustification>::s_keyword,
        attribute::get(0x0072, 0x0718).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DisplaySetVerticalJustification>::s_keyword,
        attribute::get(attribute::Keyword::DisplaySetVerticalJustification).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcessingParametersSequence>::s_keyword,
        attribute::get(0x0074, 0x1212).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerformedProcessingParametersSequence>::s_keyword,
        attribute::get(attribute::Keyword::PerformedProcessingParametersSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceScanAcquisitionTypeCodeSequence>::s_keyword,
        attribute::get(0x0080, 0x0001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceScanAcquisitionTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceScanAcquisitionTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceScanModeCodeSequence>::s_keyword,
        attribute::get(0x0080, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfaceScanModeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::SurfaceScanModeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegistrationMethodCodeSequence>::s_keyword,
        attribute::get(0x0080, 0x0003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RegistrationMethodCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::RegistrationMethodCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShotDurationTime>::s_keyword,
        attribute::get(0x0080, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShotDurationTime>::s_keyword,
        attribute::get(attribute::Keyword::ShotDurationTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShotOffsetTime>::s_keyword,
        attribute::get(0x0080, 0x0005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ShotOffsetTime>::s_keyword,
        attribute::get(attribute::Keyword::ShotOffsetTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfacePointPresentationValueData>::s_keyword,
        attribute::get(0x0080, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfacePointPresentationValueData>::s_keyword,
        attribute::get(attribute::Keyword::SurfacePointPresentationValueData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfacePointColorCIELabValueData>::s_keyword,
        attribute::get(0x0080, 0x0007).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SurfacePointColorCIELabValueData>::s_keyword,
        attribute::get(attribute::Keyword::SurfacePointColorCIELabValueData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UVMappingSequence>::s_keyword,
        attribute::get(0x0080, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UVMappingSequence>::s_keyword,
        attribute::get(attribute::Keyword::UVMappingSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TextureLabel>::s_keyword,
        attribute::get(0x0080, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TextureLabel>::s_keyword,
        attribute::get(attribute::Keyword::TextureLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UValueData>::s_keyword,
        attribute::get(0x0080, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::UValueData>::s_keyword,
        attribute::get(attribute::Keyword::UValueData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VValueData>::s_keyword,
        attribute::get(0x0080, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::VValueData>::s_keyword,
        attribute::get(attribute::Keyword::VValueData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedTextureSequence>::s_keyword,
        attribute::get(0x0080, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedTextureSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedTextureSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSurfaceDataSequence>::s_keyword,
        attribute::get(0x0080, 0x0013).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSurfaceDataSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSurfaceDataSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StorageMediaFileSetID>::s_keyword,
        attribute::get(0x0088, 0x0130).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StorageMediaFileSetID>::s_keyword,
        attribute::get(attribute::Keyword::StorageMediaFileSetID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StorageMediaFileSetUID>::s_keyword,
        attribute::get(0x0088, 0x0140).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StorageMediaFileSetUID>::s_keyword,
        attribute::get(attribute::Keyword::StorageMediaFileSetUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IconImageSequence>::s_keyword,
        attribute::get(0x0088, 0x0200).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IconImageSequence>::s_keyword,
        attribute::get(attribute::Keyword::IconImageSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SOPInstanceStatus>::s_keyword,
        attribute::get(0x0100, 0x0410).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SOPInstanceStatus>::s_keyword,
        attribute::get(attribute::Keyword::SOPInstanceStatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SOPAuthorizationDateTime>::s_keyword,
        attribute::get(0x0100, 0x0420).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SOPAuthorizationDateTime>::s_keyword,
        attribute::get(attribute::Keyword::SOPAuthorizationDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SOPAuthorizationComment>::s_keyword,
        attribute::get(0x0100, 0x0424).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SOPAuthorizationComment>::s_keyword,
        attribute::get(attribute::Keyword::SOPAuthorizationComment).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AuthorizationEquipmentCertificationNumber>::s_keyword,
        attribute::get(0x0100, 0x0426).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AuthorizationEquipmentCertificationNumber>::s_keyword,
        attribute::get(attribute::Keyword::AuthorizationEquipmentCertificationNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MACIDNumber>::s_keyword,
        attribute::get(0x0400, 0x0005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MACIDNumber>::s_keyword,
        attribute::get(attribute::Keyword::MACIDNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MACCalculationTransferSyntaxUID>::s_keyword,
        attribute::get(0x0400, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MACCalculationTransferSyntaxUID>::s_keyword,
        attribute::get(attribute::Keyword::MACCalculationTransferSyntaxUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MACAlgorithm>::s_keyword,
        attribute::get(0x0400, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MACAlgorithm>::s_keyword,
        attribute::get(attribute::Keyword::MACAlgorithm).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataElementsSigned>::s_keyword,
        attribute::get(0x0400, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DataElementsSigned>::s_keyword,
        attribute::get(attribute::Keyword::DataElementsSigned).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalSignatureUID>::s_keyword,
        attribute::get(0x0400, 0x0100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalSignatureUID>::s_keyword,
        attribute::get(attribute::Keyword::DigitalSignatureUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalSignatureDateTime>::s_keyword,
        attribute::get(0x0400, 0x0105).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalSignatureDateTime>::s_keyword,
        attribute::get(attribute::Keyword::DigitalSignatureDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CertificateType>::s_keyword,
        attribute::get(0x0400, 0x0110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CertificateType>::s_keyword,
        attribute::get(attribute::Keyword::CertificateType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CertificateOfSigner>::s_keyword,
        attribute::get(0x0400, 0x0115).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CertificateOfSigner>::s_keyword,
        attribute::get(attribute::Keyword::CertificateOfSigner).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Signature>::s_keyword,
        attribute::get(0x0400, 0x0120).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Signature>::s_keyword,
        attribute::get(attribute::Keyword::Signature).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CertifiedTimestampType>::s_keyword,
        attribute::get(0x0400, 0x0305).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CertifiedTimestampType>::s_keyword,
        attribute::get(attribute::Keyword::CertifiedTimestampType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CertifiedTimestamp>::s_keyword,
        attribute::get(0x0400, 0x0310).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CertifiedTimestamp>::s_keyword,
        attribute::get(attribute::Keyword::CertifiedTimestamp).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalSignaturePurposeCodeSequence>::s_keyword,
        attribute::get(0x0400, 0x0401).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalSignaturePurposeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::DigitalSignaturePurposeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedDigitalSignatureSequence>::s_keyword,
        attribute::get(0x0400, 0x0402).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedDigitalSignatureSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedDigitalSignatureSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSOPInstanceMACSequence>::s_keyword,
        attribute::get(0x0400, 0x0403).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedSOPInstanceMACSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedSOPInstanceMACSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncryptedAttributesSequence>::s_keyword,
        attribute::get(0x0400, 0x0500).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncryptedAttributesSequence>::s_keyword,
        attribute::get(attribute::Keyword::EncryptedAttributesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncryptedContentTransferSyntaxUID>::s_keyword,
        attribute::get(0x0400, 0x0510).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncryptedContentTransferSyntaxUID>::s_keyword,
        attribute::get(attribute::Keyword::EncryptedContentTransferSyntaxUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncryptedContent>::s_keyword,
        attribute::get(0x0400, 0x0520).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncryptedContent>::s_keyword,
        attribute::get(attribute::Keyword::EncryptedContent).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModifiedAttributesSequence>::s_keyword,
        attribute::get(0x0400, 0x0550).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModifiedAttributesSequence>::s_keyword,
        attribute::get(attribute::Keyword::ModifiedAttributesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NonconformingModifiedAttributesSequence>::s_keyword,
        attribute::get(0x0400, 0x0551).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NonconformingModifiedAttributesSequence>::s_keyword,
        attribute::get(attribute::Keyword::NonconformingModifiedAttributesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OriginalAttributesSequence>::s_keyword,
        attribute::get(0x0400, 0x0561).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OriginalAttributesSequence>::s_keyword,
        attribute::get(attribute::Keyword::OriginalAttributesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AttributeModificationDateTime>::s_keyword,
        attribute::get(0x0400, 0x0562).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AttributeModificationDateTime>::s_keyword,
        attribute::get(attribute::Keyword::AttributeModificationDateTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModifyingSystem>::s_keyword,
        attribute::get(0x0400, 0x0563).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ModifyingSystem>::s_keyword,
        attribute::get(attribute::Keyword::ModifyingSystem).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceOfPreviousValues>::s_keyword,
        attribute::get(0x0400, 0x0564).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceOfPreviousValues>::s_keyword,
        attribute::get(attribute::Keyword::SourceOfPreviousValues).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForTheAttributeModification>::s_keyword,
        attribute::get(0x0400, 0x0565).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReasonForTheAttributeModification>::s_keyword,
        attribute::get(attribute::Keyword::ReasonForTheAttributeModification).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceOriginStatus>::s_keyword,
        attribute::get(0x0400, 0x0600).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceOriginStatus>::s_keyword,
        attribute::get(attribute::Keyword::InstanceOriginStatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Illumination>::s_keyword,
        attribute::get(0x2010, 0x015E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::Illumination>::s_keyword,
        attribute::get(attribute::Keyword::Illumination).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReflectedAmbientLight>::s_keyword,
        attribute::get(0x2010, 0x0160).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReflectedAmbientLight>::s_keyword,
        attribute::get(attribute::Keyword::ReflectedAmbientLight).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PresentationLUTShape>::s_keyword,
        attribute::get(0x2050, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PresentationLUTShape>::s_keyword,
        attribute::get(attribute::Keyword::PresentationLUTShape).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LabelText>::s_keyword,
        attribute::get(0x2200, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::LabelText>::s_keyword,
        attribute::get(attribute::Keyword::LabelText).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BarcodeValue>::s_keyword,
        attribute::get(0x2200, 0x0005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BarcodeValue>::s_keyword,
        attribute::get(attribute::Keyword::BarcodeValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageLabel>::s_keyword,
        attribute::get(0x3002, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageLabel>::s_keyword,
        attribute::get(attribute::Keyword::RTImageLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageName>::s_keyword,
        attribute::get(0x3002, 0x0003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageName>::s_keyword,
        attribute::get(attribute::Keyword::RTImageName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageDescription>::s_keyword,
        attribute::get(0x3002, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageDescription>::s_keyword,
        attribute::get(attribute::Keyword::RTImageDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReportedValuesOrigin>::s_keyword,
        attribute::get(0x3002, 0x000A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReportedValuesOrigin>::s_keyword,
        attribute::get(attribute::Keyword::ReportedValuesOrigin).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImagePlane>::s_keyword,
        attribute::get(0x3002, 0x000C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImagePlane>::s_keyword,
        attribute::get(attribute::Keyword::RTImagePlane).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayImageReceptorTranslation>::s_keyword,
        attribute::get(0x3002, 0x000D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayImageReceptorTranslation>::s_keyword,
        attribute::get(attribute::Keyword::XRayImageReceptorTranslation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayImageReceptorAngle>::s_keyword,
        attribute::get(0x3002, 0x000E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::XRayImageReceptorAngle>::s_keyword,
        attribute::get(attribute::Keyword::XRayImageReceptorAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageOrientation>::s_keyword,
        attribute::get(0x3002, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageOrientation>::s_keyword,
        attribute::get(attribute::Keyword::RTImageOrientation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePlanePixelSpacing>::s_keyword,
        attribute::get(0x3002, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagePlanePixelSpacing>::s_keyword,
        attribute::get(attribute::Keyword::ImagePlanePixelSpacing).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImagePosition>::s_keyword,
        attribute::get(0x3002, 0x0012).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImagePosition>::s_keyword,
        attribute::get(attribute::Keyword::RTImagePosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationMachineName>::s_keyword,
        attribute::get(0x3002, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationMachineName>::s_keyword,
        attribute::get(attribute::Keyword::RadiationMachineName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationMachineSAD>::s_keyword,
        attribute::get(0x3002, 0x0022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationMachineSAD>::s_keyword,
        attribute::get(attribute::Keyword::RadiationMachineSAD).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationMachineSSD>::s_keyword,
        attribute::get(0x3002, 0x0024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationMachineSSD>::s_keyword,
        attribute::get(attribute::Keyword::RadiationMachineSSD).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageSID>::s_keyword,
        attribute::get(0x3002, 0x0026).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageSID>::s_keyword,
        attribute::get(attribute::Keyword::RTImageSID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceToReferenceObjectDistance>::s_keyword,
        attribute::get(0x3002, 0x0028).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SourceToReferenceObjectDistance>::s_keyword,
        attribute::get(attribute::Keyword::SourceToReferenceObjectDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FractionNumber>::s_keyword,
        attribute::get(0x3002, 0x0029).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FractionNumber>::s_keyword,
        attribute::get(attribute::Keyword::FractionNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureSequence>::s_keyword,
        attribute::get(0x3002, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExposureSequence>::s_keyword,
        attribute::get(attribute::Keyword::ExposureSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MetersetExposure>::s_keyword,
        attribute::get(0x3002, 0x0032).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MetersetExposure>::s_keyword,
        attribute::get(attribute::Keyword::MetersetExposure).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiaphragmPosition>::s_keyword,
        attribute::get(0x3002, 0x0034).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DiaphragmPosition>::s_keyword,
        attribute::get(attribute::Keyword::DiaphragmPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FluenceMapSequence>::s_keyword,
        attribute::get(0x3002, 0x0040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FluenceMapSequence>::s_keyword,
        attribute::get(attribute::Keyword::FluenceMapSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FluenceDataSource>::s_keyword,
        attribute::get(0x3002, 0x0041).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FluenceDataSource>::s_keyword,
        attribute::get(attribute::Keyword::FluenceDataSource).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FluenceDataScale>::s_keyword,
        attribute::get(0x3002, 0x0042).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FluenceDataScale>::s_keyword,
        attribute::get(attribute::Keyword::FluenceDataScale).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryFluenceModeSequence>::s_keyword,
        attribute::get(0x3002, 0x0050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryFluenceModeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PrimaryFluenceModeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SelectedFrameNumber>::s_keyword,
        attribute::get(0x3002, 0x0100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SelectedFrameNumber>::s_keyword,
        attribute::get(attribute::Keyword::SelectedFrameNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SelectedFrameFunctionalGroupsSequence>::s_keyword,
        attribute::get(0x3002, 0x0101).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SelectedFrameFunctionalGroupsSequence>::s_keyword,
        attribute::get(attribute::Keyword::SelectedFrameFunctionalGroupsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFrameGeneralContentSequence>::s_keyword,
        attribute::get(0x3002, 0x0102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFrameGeneralContentSequence>::s_keyword,
        attribute::get(attribute::Keyword::RTImageFrameGeneralContentSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFrameContextSequence>::s_keyword,
        attribute::get(0x3002, 0x0103).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFrameContextSequence>::s_keyword,
        attribute::get(attribute::Keyword::RTImageFrameContextSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageScopeSequence>::s_keyword,
        attribute::get(0x3002, 0x0104).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageScopeSequence>::s_keyword,
        attribute::get(attribute::Keyword::RTImageScopeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamModifierCoordinatesPresenceFlag>::s_keyword,
        attribute::get(0x3002, 0x0105).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamModifierCoordinatesPresenceFlag>::s_keyword,
        attribute::get(attribute::Keyword::BeamModifierCoordinatesPresenceFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartCumulativeMeterset>::s_keyword,
        attribute::get(0x3002, 0x0106).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartCumulativeMeterset>::s_keyword,
        attribute::get(attribute::Keyword::StartCumulativeMeterset).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StopCumulativeMeterset>::s_keyword,
        attribute::get(0x3002, 0x0107).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StopCumulativeMeterset>::s_keyword,
        attribute::get(attribute::Keyword::StopCumulativeMeterset).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFrameImagingDevicePositionSequence>::s_keyword,
        attribute::get(0x3002, 0x0109).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFrameImagingDevicePositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::RTImageFrameImagingDevicePositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFramekVRadiationAcquisitionSequence>::s_keyword,
        attribute::get(0x3002, 0x010A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFramekVRadiationAcquisitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::RTImageFramekVRadiationAcquisitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFrameMVRadiationAcquisitionSequence>::s_keyword,
        attribute::get(0x3002, 0x010B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFrameMVRadiationAcquisitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::RTImageFrameMVRadiationAcquisitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFrameRadiationAcquisitionSequence>::s_keyword,
        attribute::get(0x3002, 0x010C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTImageFrameRadiationAcquisitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::RTImageFrameRadiationAcquisitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagingSourcePositionSequence>::s_keyword,
        attribute::get(0x3002, 0x010D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImagingSourcePositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::ImagingSourcePositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageReceptorPositionSequence>::s_keyword,
        attribute::get(0x3002, 0x010E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageReceptorPositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::ImageReceptorPositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DevicePositionToEquipmentMappingMatrix>::s_keyword,
        attribute::get(0x3002, 0x010F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DevicePositionToEquipmentMappingMatrix>::s_keyword,
        attribute::get(attribute::Keyword::DevicePositionToEquipmentMappingMatrix).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DevicePositionParameterSequence>::s_keyword,
        attribute::get(0x3002, 0x0110).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DevicePositionParameterSequence>::s_keyword,
        attribute::get(attribute::Keyword::DevicePositionParameterSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfAcquisitionDevices>::s_keyword,
        attribute::get(0x3002, 0x0116).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfAcquisitionDevices>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfAcquisitionDevices).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDeviceSequence>::s_keyword,
        attribute::get(0x3002, 0x0117).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AcquisitionDeviceSequence>::s_keyword,
        attribute::get(attribute::Keyword::AcquisitionDeviceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHType>::s_keyword,
        attribute::get(0x3004, 0x0001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHType>::s_keyword,
        attribute::get(attribute::Keyword::DVHType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseUnits>::s_keyword,
        attribute::get(0x3004, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseUnits>::s_keyword,
        attribute::get(attribute::Keyword::DoseUnits).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseType>::s_keyword,
        attribute::get(0x3004, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseType>::s_keyword,
        attribute::get(attribute::Keyword::DoseType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialTransformOfDose>::s_keyword,
        attribute::get(0x3004, 0x0005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SpatialTransformOfDose>::s_keyword,
        attribute::get(attribute::Keyword::SpatialTransformOfDose).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseComment>::s_keyword,
        attribute::get(0x3004, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseComment>::s_keyword,
        attribute::get(attribute::Keyword::DoseComment).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NormalizationPoint>::s_keyword,
        attribute::get(0x3004, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NormalizationPoint>::s_keyword,
        attribute::get(attribute::Keyword::NormalizationPoint).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseSummationType>::s_keyword,
        attribute::get(0x3004, 0x000A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseSummationType>::s_keyword,
        attribute::get(attribute::Keyword::DoseSummationType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridFrameOffsetVector>::s_keyword,
        attribute::get(0x3004, 0x000C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GridFrameOffsetVector>::s_keyword,
        attribute::get(attribute::Keyword::GridFrameOffsetVector).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseGridScaling>::s_keyword,
        attribute::get(0x3004, 0x000E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoseGridScaling>::s_keyword,
        attribute::get(attribute::Keyword::DoseGridScaling).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TissueHeterogeneityCorrection>::s_keyword,
        attribute::get(0x3004, 0x0014).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TissueHeterogeneityCorrection>::s_keyword,
        attribute::get(attribute::Keyword::TissueHeterogeneityCorrection).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHNormalizationPoint>::s_keyword,
        attribute::get(0x3004, 0x0040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHNormalizationPoint>::s_keyword,
        attribute::get(attribute::Keyword::DVHNormalizationPoint).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHNormalizationDoseValue>::s_keyword,
        attribute::get(0x3004, 0x0042).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHNormalizationDoseValue>::s_keyword,
        attribute::get(attribute::Keyword::DVHNormalizationDoseValue).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHSequence>::s_keyword,
        attribute::get(0x3004, 0x0050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHSequence>::s_keyword,
        attribute::get(attribute::Keyword::DVHSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHDoseScaling>::s_keyword,
        attribute::get(0x3004, 0x0052).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHDoseScaling>::s_keyword,
        attribute::get(attribute::Keyword::DVHDoseScaling).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHVolumeUnits>::s_keyword,
        attribute::get(0x3004, 0x0054).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHVolumeUnits>::s_keyword,
        attribute::get(attribute::Keyword::DVHVolumeUnits).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHNumberOfBins>::s_keyword,
        attribute::get(0x3004, 0x0056).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHNumberOfBins>::s_keyword,
        attribute::get(attribute::Keyword::DVHNumberOfBins).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHData>::s_keyword,
        attribute::get(0x3004, 0x0058).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHData>::s_keyword,
        attribute::get(attribute::Keyword::DVHData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHReferencedROISequence>::s_keyword,
        attribute::get(0x3004, 0x0060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHReferencedROISequence>::s_keyword,
        attribute::get(attribute::Keyword::DVHReferencedROISequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHMinimumDose>::s_keyword,
        attribute::get(0x3004, 0x0070).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHMinimumDose>::s_keyword,
        attribute::get(attribute::Keyword::DVHMinimumDose).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHMaximumDose>::s_keyword,
        attribute::get(0x3004, 0x0072).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHMaximumDose>::s_keyword,
        attribute::get(attribute::Keyword::DVHMaximumDose).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHMeanDose>::s_keyword,
        attribute::get(0x3004, 0x0074).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DVHMeanDose>::s_keyword,
        attribute::get(attribute::Keyword::DVHMeanDose).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedFrameOfReferenceUID>::s_keyword,
        attribute::get(0x3006, 0x0024).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedFrameOfReferenceUID>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedFrameOfReferenceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedROINumber>::s_keyword,
        attribute::get(0x3006, 0x0084).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedROINumber>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedROINumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameOfReferenceTransformationComment>::s_keyword,
        attribute::get(0x3006, 0x00C8).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FrameOfReferenceTransformationComment>::s_keyword,
        attribute::get(attribute::Keyword::FrameOfReferenceTransformationComment).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientLocationCoordinatesSequence>::s_keyword,
        attribute::get(0x3006, 0x00C9).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientLocationCoordinatesSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientLocationCoordinatesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientLocationCoordinatesCodeSequence>::s_keyword,
        attribute::get(0x3006, 0x00CA).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientLocationCoordinatesCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientLocationCoordinatesCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportPositionSequence>::s_keyword,
        attribute::get(0x3006, 0x00CB).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportPositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientSupportPositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CurrentFractionNumber>::s_keyword,
        attribute::get(0x3008, 0x0022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::CurrentFractionNumber>::s_keyword,
        attribute::get(attribute::Keyword::CurrentFractionNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedTreatmentRecordSequence>::s_keyword,
        attribute::get(0x3008, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedTreatmentRecordSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedTreatmentRecordSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnhancedRTBeamLimitingDeviceSequence>::s_keyword,
        attribute::get(0x3008, 0x00A1).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnhancedRTBeamLimitingDeviceSequence>::s_keyword,
        attribute::get(attribute::Keyword::EnhancedRTBeamLimitingDeviceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnhancedRTBeamLimitingOpeningSequence>::s_keyword,
        attribute::get(0x3008, 0x00A2).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnhancedRTBeamLimitingOpeningSequence>::s_keyword,
        attribute::get(attribute::Keyword::EnhancedRTBeamLimitingOpeningSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnhancedRTBeamLimitingDeviceDefinitionFlag>::s_keyword,
        attribute::get(0x3008, 0x00A3).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EnhancedRTBeamLimitingDeviceDefinitionFlag>::s_keyword,
        attribute::get(attribute::Keyword::EnhancedRTBeamLimitingDeviceDefinitionFlag).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterOpeningExtents>::s_keyword,
        attribute::get(0x3008, 0x00A4).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterOpeningExtents>::s_keyword,
        attribute::get(attribute::Keyword::ParallelRTBeamDelimiterOpeningExtents).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTPlanLabel>::s_keyword,
        attribute::get(0x300A, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTPlanLabel>::s_keyword,
        attribute::get(attribute::Keyword::RTPlanLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryDosimeterUnit>::s_keyword,
        attribute::get(0x300A, 0x00B3).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrimaryDosimeterUnit>::s_keyword,
        attribute::get(attribute::Keyword::PrimaryDosimeterUnit).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamLimitingDeviceSequence>::s_keyword,
        attribute::get(0x300A, 0x00B6).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamLimitingDeviceSequence>::s_keyword,
        attribute::get(attribute::Keyword::BeamLimitingDeviceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfBlocks>::s_keyword,
        attribute::get(0x300A, 0x00F0).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfBlocks>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfBlocks).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlockSequence>::s_keyword,
        attribute::get(0x300A, 0x00F4).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BlockSequence>::s_keyword,
        attribute::get(attribute::Keyword::BlockSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicatorSequence>::s_keyword,
        attribute::get(0x300A, 0x0107).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApplicatorSequence>::s_keyword,
        attribute::get(attribute::Keyword::ApplicatorSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryAngle>::s_keyword,
        attribute::get(0x300A, 0x011E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryAngle>::s_keyword,
        attribute::get(attribute::Keyword::GantryAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamLimitingDeviceAngle>::s_keyword,
        attribute::get(0x300A, 0x0120).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamLimitingDeviceAngle>::s_keyword,
        attribute::get(attribute::Keyword::BeamLimitingDeviceAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportAngle>::s_keyword,
        attribute::get(0x300A, 0x0122).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportAngle>::s_keyword,
        attribute::get(attribute::Keyword::PatientSupportAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopEccentricAxisDistance>::s_keyword,
        attribute::get(0x300A, 0x0124).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopEccentricAxisDistance>::s_keyword,
        attribute::get(attribute::Keyword::TableTopEccentricAxisDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopEccentricAngle>::s_keyword,
        attribute::get(0x300A, 0x0125).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopEccentricAngle>::s_keyword,
        attribute::get(attribute::Keyword::TableTopEccentricAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopVerticalPosition>::s_keyword,
        attribute::get(0x300A, 0x0128).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopVerticalPosition>::s_keyword,
        attribute::get(attribute::Keyword::TableTopVerticalPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopLongitudinalPosition>::s_keyword,
        attribute::get(0x300A, 0x0129).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopLongitudinalPosition>::s_keyword,
        attribute::get(attribute::Keyword::TableTopLongitudinalPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopLateralPosition>::s_keyword,
        attribute::get(0x300A, 0x012A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopLateralPosition>::s_keyword,
        attribute::get(attribute::Keyword::TableTopLateralPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IsocenterPosition>::s_keyword,
        attribute::get(0x300A, 0x012C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::IsocenterPosition>::s_keyword,
        attribute::get(attribute::Keyword::IsocenterPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopPitchAngle>::s_keyword,
        attribute::get(0x300A, 0x0140).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopPitchAngle>::s_keyword,
        attribute::get(attribute::Keyword::TableTopPitchAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopRollAngle>::s_keyword,
        attribute::get(0x300A, 0x0144).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TableTopRollAngle>::s_keyword,
        attribute::get(attribute::Keyword::TableTopRollAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryPitchAngle>::s_keyword,
        attribute::get(0x300A, 0x014A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GantryPitchAngle>::s_keyword,
        attribute::get(attribute::Keyword::GantryPitchAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneralAccessorySequence>::s_keyword,
        attribute::get(0x300A, 0x0420).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneralAccessorySequence>::s_keyword,
        attribute::get(attribute::Keyword::GeneralAccessorySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedDefinedDeviceIndex>::s_keyword,
        attribute::get(0x300A, 0x0602).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedDefinedDeviceIndex>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedDefinedDeviceIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TreatmentPositionIndex>::s_keyword,
        attribute::get(0x300A, 0x0606).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TreatmentPositionIndex>::s_keyword,
        attribute::get(attribute::Keyword::TreatmentPositionIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedDeviceIndex>::s_keyword,
        attribute::get(0x300A, 0x0607).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedDeviceIndex>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedDeviceIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedTreatmentPositionIndex>::s_keyword,
        attribute::get(0x300A, 0x060B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedTreatmentPositionIndex>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedTreatmentPositionIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedRTAccessoryHolderDeviceIndex>::s_keyword,
        attribute::get(0x300A, 0x060E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedRTAccessoryHolderDeviceIndex>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedRTAccessoryHolderDeviceIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTAccessoryHolderSlotID>::s_keyword,
        attribute::get(0x300A, 0x0611).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTAccessoryHolderSlotID>::s_keyword,
        attribute::get(attribute::Keyword::RTAccessoryHolderSlotID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTAccessorySlotDistance>::s_keyword,
        attribute::get(0x300A, 0x0613).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTAccessorySlotDistance>::s_keyword,
        attribute::get(attribute::Keyword::RTAccessorySlotDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTAccessoryDeviceSlotID>::s_keyword,
        attribute::get(0x300A, 0x0615).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTAccessoryDeviceSlotID>::s_keyword,
        attribute::get(attribute::Keyword::RTAccessoryDeviceSlotID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TreatmentPositionSequence>::s_keyword,
        attribute::get(0x300A, 0x063F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TreatmentPositionSequence>::s_keyword,
        attribute::get(attribute::Keyword::TreatmentPositionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfRTBeamLimitingDevices>::s_keyword,
        attribute::get(0x300A, 0x0641).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfRTBeamLimitingDevices>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfRTBeamLimitingDevices).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamLimitingDeviceProximalDistance>::s_keyword,
        attribute::get(0x300A, 0x0642).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamLimitingDeviceProximalDistance>::s_keyword,
        attribute::get(attribute::Keyword::RTBeamLimitingDeviceProximalDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamLimitingDeviceDistalDistance>::s_keyword,
        attribute::get(0x300A, 0x0643).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamLimitingDeviceDistalDistance>::s_keyword,
        attribute::get(attribute::Keyword::RTBeamLimitingDeviceDistalDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence>::s_keyword,
        attribute::get(0x300A, 0x0644).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ParallelRTBeamDelimiterDeviceOrientationLabelCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamModifierOrientationAngle>::s_keyword,
        attribute::get(0x300A, 0x0645).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::BeamModifierOrientationAngle>::s_keyword,
        attribute::get(attribute::Keyword::BeamModifierOrientationAngle).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FixedRTBeamDelimiterDeviceSequence>::s_keyword,
        attribute::get(0x300A, 0x0646).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FixedRTBeamDelimiterDeviceSequence>::s_keyword,
        attribute::get(attribute::Keyword::FixedRTBeamDelimiterDeviceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterDeviceSequence>::s_keyword,
        attribute::get(0x300A, 0x0647).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterDeviceSequence>::s_keyword,
        attribute::get(attribute::Keyword::ParallelRTBeamDelimiterDeviceSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfParallelRTBeamDelimiters>::s_keyword,
        attribute::get(0x300A, 0x0648).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfParallelRTBeamDelimiters>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfParallelRTBeamDelimiters).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterBoundaries>::s_keyword,
        attribute::get(0x300A, 0x0649).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterBoundaries>::s_keyword,
        attribute::get(attribute::Keyword::ParallelRTBeamDelimiterBoundaries).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterPositions>::s_keyword,
        attribute::get(0x300A, 0x064A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterPositions>::s_keyword,
        attribute::get(attribute::Keyword::ParallelRTBeamDelimiterPositions).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamLimitingDeviceOffset>::s_keyword,
        attribute::get(0x300A, 0x064B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamLimitingDeviceOffset>::s_keyword,
        attribute::get(attribute::Keyword::RTBeamLimitingDeviceOffset).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamDelimiterGeometrySequence>::s_keyword,
        attribute::get(0x300A, 0x064C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamDelimiterGeometrySequence>::s_keyword,
        attribute::get(attribute::Keyword::RTBeamDelimiterGeometrySequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamLimitingDeviceDefinitionSequence>::s_keyword,
        attribute::get(0x300A, 0x064D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamLimitingDeviceDefinitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::RTBeamLimitingDeviceDefinitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterOpeningMode>::s_keyword,
        attribute::get(0x300A, 0x064E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterOpeningMode>::s_keyword,
        attribute::get(attribute::Keyword::ParallelRTBeamDelimiterOpeningMode).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterLeafMountingSide>::s_keyword,
        attribute::get(0x300A, 0x064F).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ParallelRTBeamDelimiterLeafMountingSide>::s_keyword,
        attribute::get(attribute::Keyword::ParallelRTBeamDelimiterLeafMountingSide).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamLimitingDeviceOpeningSequence>::s_keyword,
        attribute::get(0x300A, 0x0656).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamLimitingDeviceOpeningSequence>::s_keyword,
        attribute::get(attribute::Keyword::RTBeamLimitingDeviceOpeningSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationDosimeterUnitSequence>::s_keyword,
        attribute::get(0x300A, 0x0658).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RadiationDosimeterUnitSequence>::s_keyword,
        attribute::get(attribute::Keyword::RadiationDosimeterUnitSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTDeviceDistanceReferenceLocationCodeSequence>::s_keyword,
        attribute::get(0x300A, 0x0659).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTDeviceDistanceReferenceLocationCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::RTDeviceDistanceReferenceLocationCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportPositionParameterSequence>::s_keyword,
        attribute::get(0x300A, 0x065B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportPositionParameterSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientSupportPositionParameterSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportPositionSpecificationMethod>::s_keyword,
        attribute::get(0x300A, 0x065C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportPositionSpecificationMethod>::s_keyword,
        attribute::get(attribute::Keyword::PatientSupportPositionSpecificationMethod).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportPositionDeviceParameterSequence>::s_keyword,
        attribute::get(0x300A, 0x065D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportPositionDeviceParameterSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientSupportPositionDeviceParameterSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceOrderIndex>::s_keyword,
        attribute::get(0x300A, 0x065E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceOrderIndex>::s_keyword,
        attribute::get(attribute::Keyword::DeviceOrderIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneralAccessoryDefinitionSequence>::s_keyword,
        attribute::get(0x300A, 0x0671).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::GeneralAccessoryDefinitionSequence>::s_keyword,
        attribute::get(attribute::Keyword::GeneralAccessoryDefinitionSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfGeneralAccessories>::s_keyword,
        attribute::get(0x300A, 0x0672).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfGeneralAccessories>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfGeneralAccessories).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EquipmentFrameOfReferenceUID>::s_keyword,
        attribute::get(0x300A, 0x0675).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EquipmentFrameOfReferenceUID>::s_keyword,
        attribute::get(attribute::Keyword::EquipmentFrameOfReferenceUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportDevicesSequence>::s_keyword,
        attribute::get(0x300A, 0x0686).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientSupportDevicesSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientSupportDevicesSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfPatientSupportDevices>::s_keyword,
        attribute::get(0x300A, 0x0687).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfPatientSupportDevices>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfPatientSupportDevices).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamModifierDefinitionDistance>::s_keyword,
        attribute::get(0x300A, 0x0688).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTBeamModifierDefinitionDistance>::s_keyword,
        attribute::get(attribute::Keyword::RTBeamModifierDefinitionDistance).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TreatmentSessionUID>::s_keyword,
        attribute::get(0x300A, 0x0700).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TreatmentSessionUID>::s_keyword,
        attribute::get(attribute::Keyword::TreatmentSessionUID).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTRadiationSetDeliveryNumber>::s_keyword,
        attribute::get(0x300A, 0x0704).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::RTRadiationSetDeliveryNumber>::s_keyword,
        attribute::get(attribute::Keyword::RTRadiationSetDeliveryNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalFractionNumber>::s_keyword,
        attribute::get(0x300A, 0x0705).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ClinicalFractionNumber>::s_keyword,
        attribute::get(attribute::Keyword::ClinicalFractionNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedRTPlanSequence>::s_keyword,
        attribute::get(0x300C, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedRTPlanSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedRTPlanSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedBeamSequence>::s_keyword,
        attribute::get(0x300C, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedBeamSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedBeamSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedBeamNumber>::s_keyword,
        attribute::get(0x300C, 0x0006).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedBeamNumber>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedBeamNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartCumulativeMetersetWeight>::s_keyword,
        attribute::get(0x300C, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::StartCumulativeMetersetWeight>::s_keyword,
        attribute::get(attribute::Keyword::StartCumulativeMetersetWeight).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EndCumulativeMetersetWeight>::s_keyword,
        attribute::get(0x300C, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EndCumulativeMetersetWeight>::s_keyword,
        attribute::get(attribute::Keyword::EndCumulativeMetersetWeight).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedFractionGroupSequence>::s_keyword,
        attribute::get(0x300C, 0x0020).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedFractionGroupSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedFractionGroupSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedFractionGroupNumber>::s_keyword,
        attribute::get(0x300C, 0x0022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedFractionGroupNumber>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedFractionGroupNumber).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedStructureSetSequence>::s_keyword,
        attribute::get(0x300C, 0x0060).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedStructureSetSequence>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedStructureSetSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrescriptionOverviewSequence>::s_keyword,
        attribute::get(0x300C, 0x0114).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PrescriptionOverviewSequence>::s_keyword,
        attribute::get(attribute::Keyword::PrescriptionOverviewSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanOverviewSequence>::s_keyword,
        attribute::get(0x300C, 0x0116).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanOverviewSequence>::s_keyword,
        attribute::get(attribute::Keyword::PlanOverviewSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanOverviewIndex>::s_keyword,
        attribute::get(0x300C, 0x0117).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PlanOverviewIndex>::s_keyword,
        attribute::get(attribute::Keyword::PlanOverviewIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPlanOverviewIndex>::s_keyword,
        attribute::get(0x300C, 0x0118).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReferencedPlanOverviewIndex>::s_keyword,
        attribute::get(attribute::Keyword::ReferencedPlanOverviewIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFractionsIncluded>::s_keyword,
        attribute::get(0x300C, 0x0119).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFractionsIncluded>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfFractionsIncluded).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApprovalStatus>::s_keyword,
        attribute::get(0x300E, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ApprovalStatus>::s_keyword,
        attribute::get(attribute::Keyword::ApprovalStatus).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReviewDate>::s_keyword,
        attribute::get(0x300E, 0x0004).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReviewDate>::s_keyword,
        attribute::get(attribute::Keyword::ReviewDate).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReviewTime>::s_keyword,
        attribute::get(0x300E, 0x0005).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReviewTime>::s_keyword,
        attribute::get(attribute::Keyword::ReviewTime).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReviewerName>::s_keyword,
        attribute::get(0x300E, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ReviewerName>::s_keyword,
        attribute::get(attribute::Keyword::ReviewerName).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AuthorIdentificationSequence>::s_keyword,
        attribute::get(0x3010, 0x0019).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::AuthorIdentificationSequence>::s_keyword,
        attribute::get(attribute::Keyword::AuthorIdentificationSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ManufacturerModelVersion>::s_keyword,
        attribute::get(0x3010, 0x001A).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ManufacturerModelVersion>::s_keyword,
        attribute::get(attribute::Keyword::ManufacturerModelVersion).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceAlternateIdentifier>::s_keyword,
        attribute::get(0x3010, 0x001B).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceAlternateIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::DeviceAlternateIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceAlternateIdentifierType>::s_keyword,
        attribute::get(0x3010, 0x001C).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceAlternateIdentifierType>::s_keyword,
        attribute::get(attribute::Keyword::DeviceAlternateIdentifierType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceAlternateIdentifierFormat>::s_keyword,
        attribute::get(0x3010, 0x001D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceAlternateIdentifierFormat>::s_keyword,
        attribute::get(attribute::Keyword::DeviceAlternateIdentifierFormat).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConceptualVolumeSequence>::s_keyword,
        attribute::get(0x3010, 0x0025).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ConceptualVolumeSequence>::s_keyword,
        attribute::get(attribute::Keyword::ConceptualVolumeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceLabel>::s_keyword,
        attribute::get(0x3010, 0x002D).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceLabel>::s_keyword,
        attribute::get(attribute::Keyword::DeviceLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceTypeCodeSequence>::s_keyword,
        attribute::get(0x3010, 0x002E).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceTypeCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::DeviceTypeCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientEquipmentRelationshipCodeSequence>::s_keyword,
        attribute::get(0x3010, 0x0030).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PatientEquipmentRelationshipCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::PatientEquipmentRelationshipCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EntityDescription>::s_keyword,
        attribute::get(0x3010, 0x0037).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EntityDescription>::s_keyword,
        attribute::get(attribute::Keyword::EntityDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EntityLongLabel>::s_keyword,
        attribute::get(0x3010, 0x0038).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EntityLongLabel>::s_keyword,
        attribute::get(attribute::Keyword::EntityLongLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceIndex>::s_keyword,
        attribute::get(0x3010, 0x0039).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DeviceIndex>::s_keyword,
        attribute::get(attribute::Keyword::DeviceIndex).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ManufacturerDeviceIdentifier>::s_keyword,
        attribute::get(0x3010, 0x0043).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ManufacturerDeviceIdentifier>::s_keyword,
        attribute::get(attribute::Keyword::ManufacturerDeviceIdentifier).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceLevelReferencedPerformedProcedureStepSequence>::s_keyword,
        attribute::get(0x3010, 0x0044).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::InstanceLevelReferencedPerformedProcedureStepSequence>::s_keyword,
        attribute::get(attribute::Keyword::InstanceLevelReferencedPerformedProcedureStepSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TreatmentSite>::s_keyword,
        attribute::get(0x3010, 0x0077).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TreatmentSite>::s_keyword,
        attribute::get(attribute::Keyword::TreatmentSite).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TreatmentSiteCodeSequence>::s_keyword,
        attribute::get(0x3010, 0x0078).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::TreatmentSiteCodeSequence>::s_keyword,
        attribute::get(attribute::Keyword::TreatmentSiteCodeSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MACParametersSequence>::s_keyword,
        attribute::get(0x4FFE, 0x0001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::MACParametersSequence>::s_keyword,
        attribute::get(attribute::Keyword::MACParametersSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SharedFunctionalGroupsSequence>::s_keyword,
        attribute::get(0x5200, 0x9229).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::SharedFunctionalGroupsSequence>::s_keyword,
        attribute::get(attribute::Keyword::SharedFunctionalGroupsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerFrameFunctionalGroupsSequence>::s_keyword,
        attribute::get(0x5200, 0x9230).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PerFrameFunctionalGroupsSequence>::s_keyword,
        attribute::get(attribute::Keyword::PerFrameFunctionalGroupsSequence).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayRows>::s_keyword,
        attribute::get(0x6000, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayRows>::s_keyword,
        attribute::get(attribute::Keyword::OverlayRows).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayColumns>::s_keyword,
        attribute::get(0x6000, 0x0011).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayColumns>::s_keyword,
        attribute::get(attribute::Keyword::OverlayColumns).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFramesInOverlay>::s_keyword,
        attribute::get(0x6000, 0x0015).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::NumberOfFramesInOverlay>::s_keyword,
        attribute::get(attribute::Keyword::NumberOfFramesInOverlay).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayDescription>::s_keyword,
        attribute::get(0x6000, 0x0022).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayDescription>::s_keyword,
        attribute::get(attribute::Keyword::OverlayDescription).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayType>::s_keyword,
        attribute::get(0x6000, 0x0040).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayType>::s_keyword,
        attribute::get(attribute::Keyword::OverlayType).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlaySubtype>::s_keyword,
        attribute::get(0x6000, 0x0045).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlaySubtype>::s_keyword,
        attribute::get(attribute::Keyword::OverlaySubtype).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayOrigin>::s_keyword,
        attribute::get(0x6000, 0x0050).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayOrigin>::s_keyword,
        attribute::get(attribute::Keyword::OverlayOrigin).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageFrameOrigin>::s_keyword,
        attribute::get(0x6000, 0x0051).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ImageFrameOrigin>::s_keyword,
        attribute::get(attribute::Keyword::ImageFrameOrigin).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayBitsAllocated>::s_keyword,
        attribute::get(0x6000, 0x0100).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayBitsAllocated>::s_keyword,
        attribute::get(attribute::Keyword::OverlayBitsAllocated).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayBitPosition>::s_keyword,
        attribute::get(0x6000, 0x0102).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayBitPosition>::s_keyword,
        attribute::get(attribute::Keyword::OverlayBitPosition).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ROIArea>::s_keyword,
        attribute::get(0x6000, 0x1301).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ROIArea>::s_keyword,
        attribute::get(attribute::Keyword::ROIArea).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ROIMean>::s_keyword,
        attribute::get(0x6000, 0x1302).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ROIMean>::s_keyword,
        attribute::get(attribute::Keyword::ROIMean).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ROIStandardDeviation>::s_keyword,
        attribute::get(0x6000, 0x1303).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ROIStandardDeviation>::s_keyword,
        attribute::get(attribute::Keyword::ROIStandardDeviation).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayLabel>::s_keyword,
        attribute::get(0x6000, 0x1500).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayLabel>::s_keyword,
        attribute::get(attribute::Keyword::OverlayLabel).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayData>::s_keyword,
        attribute::get(0x6000, 0x3000).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::OverlayData>::s_keyword,
        attribute::get(attribute::Keyword::OverlayData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExtendedOffsetTable>::s_keyword,
        attribute::get(0x7FE0, 0x0001).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExtendedOffsetTable>::s_keyword,
        attribute::get(attribute::Keyword::ExtendedOffsetTable).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExtendedOffsetTableLengths>::s_keyword,
        attribute::get(0x7FE0, 0x0002).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::ExtendedOffsetTableLengths>::s_keyword,
        attribute::get(attribute::Keyword::ExtendedOffsetTableLengths).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncapsulatedPixelDataValueTotalLength>::s_keyword,
        attribute::get(0x7FE0, 0x0003).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::EncapsulatedPixelDataValueTotalLength>::s_keyword,
        attribute::get(attribute::Keyword::EncapsulatedPixelDataValueTotalLength).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FloatPixelData>::s_keyword,
        attribute::get(0x7FE0, 0x0008).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::FloatPixelData>::s_keyword,
        attribute::get(attribute::Keyword::FloatPixelData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoubleFloatPixelData>::s_keyword,
        attribute::get(0x7FE0, 0x0009).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DoubleFloatPixelData>::s_keyword,
        attribute::get(attribute::Keyword::DoubleFloatPixelData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelData>::s_keyword,
        attribute::get(0x7FE0, 0x0010).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::PixelData>::s_keyword,
        attribute::get(attribute::Keyword::PixelData).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalSignaturesSequence>::s_keyword,
        attribute::get(0xFFFA, 0xFFFA).m_keyword
    );
    CPPUNIT_ASSERT_EQUAL(
        attribute::Attribute<attribute::Keyword::DigitalSignaturesSequence>::s_keyword,
        attribute::get(attribute::Keyword::DigitalSignaturesSequence).m_keyword
    );
}

//------------------------------------------------------------------------------

} // namespace sight::data::dicom::ut

// NOLINTEND
