# S3

If you want to use S3 storage for the sccache cache, you need to set the `SCCACHE_BUCKET` environment variable to the name of the S3 bucket to use.

You can configure the region using the `SCCACHE_REGION` environment variable, or specify the `region` key in `~/.aws/credentials`. Alternatively you can specify the endpoint URL using the `SCCACHE_ENDPOINT` environment variable. To connect to a minio storage for example you can set `SCCACHE_ENDPOINT=<ip>:<port>`.

If your endpoint requires HTTPS/TLS, set `SCCACHE_S3_USE_SSL=true`. If you don't need a secure network layer, HTTP (`SCCACHE_S3_USE_SSL=false`) might be better for performance.

You can also define a prefix that will be prepended to the keys of all cache objects created and read within the S3 bucket, effectively creating a scope. To do that use the `SCCACHE_S3_KEY_PREFIX` environment variable. This can be useful when sharing a bucket with another application.

# R2

Cloudflare R2 is an S3-compatible object storage and works with the same configuration options as above. To use R2, you **must** define `SCCACHE_ENDPOINT`, otherwise sccache will default to AWS as the endpoint to hit. R2 also requires endpoint connections to be secure, therefore `https://` either needs to be included in `SCCACHE_ENDPOINT` or `SCCACHE_S3_USE_SSL=true` can be used, if the protocol is omitted. There are no regions in R2, so `SCCACHE_REGION` must point to `auto`. The below environment variables are recommended.

* `SCCACHE_BUCKET` is the name of your R2 bucket.
* `SCCACHE_ENDPOINT` should follow the format of `https://<ACCOUNT_ID>.r2.cloudflarestorage.com`. It is recommended that `https://` be included in this env var. Your account ID can be found [here](https://developers.cloudflare.com/fundamentals/get-started/basic-tasks/find-account-and-zone-ids/).
* `SCCACHE_REGION` should be set to `auto`.

## Credentials

Sccache is able to load credentials from various sources. Including:

- Static: `AWS_ACCESS_KEY_ID` and `AWS_SECRET_ACCESS_KEY`.
- Profile: `~/.aws/credentials` and `~/.aws/config`. The AWS_PROFILE environment variable can be used to select a specific profile if multiple profiles are available.
- EC2 Metadata Services: Via [IMDSv2](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/configuring-instance-metadata-service.html).
- AssumeRole: assume role with the role specified by `AWS_ROLE_ARN`.
- AssumeRoleWithWebIdentity: assume role with web webIdentity specified by `AWS_ROLE_ARN` and `AWS_WEB_IDENTITY_TOKEN_FILE`.

Alternatively, the `SCCACHE_S3_NO_CREDENTIALS` environment variable can be set to use public readonly access to the S3 bucket, without the need for credentials. This can be useful for implementing a readonly cache for pull requests, which typically cannot be given access to credentials for security reasons.
