/*
 * Decompiled with CFR 0.152.
 */
package info.monitorenter.gui.chart.traces.painters;

import info.monitorenter.gui.chart.ITracePoint2D;
import info.monitorenter.gui.chart.traces.painters.ATracePainter;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.List;

public class TracePainterPolyline
extends ATracePainter {
    private List<Integer> m_xPoints;
    private List<Integer> m_yPoints;

    public void endPaintIteration(Graphics g2d) {
        if (g2d != null) {
            int[] x = new int[this.m_xPoints.size() + 1];
            int count = 0;
            for (Integer xpoint : this.m_xPoints) {
                x[count] = xpoint;
                ++count;
            }
            x[count] = this.getPreviousX();
            int[] y = new int[this.m_yPoints.size() + 1];
            count = 0;
            for (Integer ypoint : this.m_yPoints) {
                y[count] = ypoint;
                ++count;
            }
            y[count] = this.getPreviousY();
            g2d.drawPolyline(x, y, x.length);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TracePainterPolyline other = (TracePainterPolyline)obj;
        if (this.m_xPoints == null ? other.m_xPoints != null : !((Object)this.m_xPoints).equals(other.m_xPoints)) {
            return false;
        }
        return !(this.m_yPoints == null ? other.m_yPoints != null : !((Object)this.m_yPoints).equals(other.m_yPoints));
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_xPoints == null ? 0 : ((Object)this.m_xPoints).hashCode());
        result = 31 * result + (this.m_yPoints == null ? 0 : ((Object)this.m_yPoints).hashCode());
        return result;
    }

    public void paintPoint(int absoluteX, int absoluteY, int nextX, int nextY, Graphics g, ITracePoint2D original) {
        super.paintPoint(absoluteX, absoluteY, nextX, nextY, g, original);
        this.m_xPoints.add(new Integer(absoluteX));
        this.m_yPoints.add(new Integer(absoluteY));
    }

    public void startPaintIteration(Graphics g2d) {
        super.startPaintIteration(g2d);
        if (this.m_xPoints == null) {
            this.m_xPoints = new LinkedList<Integer>();
        } else {
            this.m_xPoints.clear();
        }
        if (this.m_yPoints == null) {
            this.m_yPoints = new LinkedList<Integer>();
        } else {
            this.m_yPoints.clear();
        }
    }
}

