% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppParallel-package.R
\docType{package}
\name{RcppParallel-package}
\alias{RcppParallel-package}
\alias{RcppParallel}
\title{Parallel programming tools for Rcpp}
\description{
High level functions for doing parallel programming with Rcpp.  For example,
the \code{parallelFor()} function can be used to convert the work of a
standard serial "for" loop into a parallel one, and the \code{parallelReduce()}
function can be used for accumulating aggregate or other values.
}
\details{
The high level interface enables safe and robust parallel programming
without direct manipulation of operating system threads. On Windows, macOS,
and Linux systems the underlying implementation is based on Intel TBB
(Threading Building Blocks). On other platforms, a less-performant fallback
implementation based on the TinyThread library is used.

For additional documentation, see the package website at:

\url{https://rcppcore.github.io/RcppParallel/}
}
\keyword{package}
\keyword{parallel}
