# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class CustomAlertRule(_serialization.Model):
    """A custom alert rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ListCustomAlertRule, ThresholdCustomAlertRule

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
    }

    _subtype_map = {
        "rule_type": {
            "ListCustomAlertRule": "ListCustomAlertRule",
            "ThresholdCustomAlertRule": "ThresholdCustomAlertRule",
        }
    }

    def __init__(self, *, is_enabled: bool, **kwargs):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        """
        super().__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.is_enabled = is_enabled
        self.rule_type = None  # type: Optional[str]


class ThresholdCustomAlertRule(CustomAlertRule):
    """A custom alert rule that checks if a value (depends on the custom alert type) is within the given range.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    TimeWindowCustomAlertRule

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
    }

    _subtype_map = {"rule_type": {"TimeWindowCustomAlertRule": "TimeWindowCustomAlertRule"}}

    def __init__(self, *, is_enabled: bool, min_threshold: int, max_threshold: int, **kwargs):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.rule_type = "ThresholdCustomAlertRule"  # type: str
        self.min_threshold = min_threshold
        self.max_threshold = max_threshold


class TimeWindowCustomAlertRule(ThresholdCustomAlertRule):
    """A custom alert rule that checks if the number of activities (depends on the custom alert type) in a time window is within the given range.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ActiveConnectionsNotInAllowedRange, AmqpC2DMessagesNotInAllowedRange,
    AmqpC2DRejectedMessagesNotInAllowedRange, AmqpD2CMessagesNotInAllowedRange,
    DirectMethodInvokesNotInAllowedRange, FailedLocalLoginsNotInAllowedRange,
    FileUploadsNotInAllowedRange, HttpC2DMessagesNotInAllowedRange,
    HttpC2DRejectedMessagesNotInAllowedRange, HttpD2CMessagesNotInAllowedRange,
    MqttC2DMessagesNotInAllowedRange, MqttC2DRejectedMessagesNotInAllowedRange,
    MqttD2CMessagesNotInAllowedRange, QueuePurgesNotInAllowedRange, TwinUpdatesNotInAllowedRange,
    UnauthorizedOperationsNotInAllowedRange

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    _subtype_map = {
        "rule_type": {
            "ActiveConnectionsNotInAllowedRange": "ActiveConnectionsNotInAllowedRange",
            "AmqpC2DMessagesNotInAllowedRange": "AmqpC2DMessagesNotInAllowedRange",
            "AmqpC2DRejectedMessagesNotInAllowedRange": "AmqpC2DRejectedMessagesNotInAllowedRange",
            "AmqpD2CMessagesNotInAllowedRange": "AmqpD2CMessagesNotInAllowedRange",
            "DirectMethodInvokesNotInAllowedRange": "DirectMethodInvokesNotInAllowedRange",
            "FailedLocalLoginsNotInAllowedRange": "FailedLocalLoginsNotInAllowedRange",
            "FileUploadsNotInAllowedRange": "FileUploadsNotInAllowedRange",
            "HttpC2DMessagesNotInAllowedRange": "HttpC2DMessagesNotInAllowedRange",
            "HttpC2DRejectedMessagesNotInAllowedRange": "HttpC2DRejectedMessagesNotInAllowedRange",
            "HttpD2CMessagesNotInAllowedRange": "HttpD2CMessagesNotInAllowedRange",
            "MqttC2DMessagesNotInAllowedRange": "MqttC2DMessagesNotInAllowedRange",
            "MqttC2DRejectedMessagesNotInAllowedRange": "MqttC2DRejectedMessagesNotInAllowedRange",
            "MqttD2CMessagesNotInAllowedRange": "MqttD2CMessagesNotInAllowedRange",
            "QueuePurgesNotInAllowedRange": "QueuePurgesNotInAllowedRange",
            "TwinUpdatesNotInAllowedRange": "TwinUpdatesNotInAllowedRange",
            "UnauthorizedOperationsNotInAllowedRange": "UnauthorizedOperationsNotInAllowedRange",
        }
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(is_enabled=is_enabled, min_threshold=min_threshold, max_threshold=max_threshold, **kwargs)
        self.rule_type = "TimeWindowCustomAlertRule"  # type: str
        self.time_window_size = time_window_size


class ActiveConnectionsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of active connections is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "ActiveConnectionsNotInAllowedRange"  # type: str


class AdditionalWorkspacesProperties(_serialization.Model):
    """Properties of the additional workspaces.

    :ivar workspace: Workspace resource id.
    :vartype workspace: str
    :ivar type: Workspace type. "Sentinel"
    :vartype type: str or ~azure.mgmt.security.v2019_08_01.models.AdditionalWorkspaceType
    :ivar data_types: List of data types sent to workspace.
    :vartype data_types: list[str or
     ~azure.mgmt.security.v2019_08_01.models.AdditionalWorkspaceDataType]
    """

    _attribute_map = {
        "workspace": {"key": "workspace", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "data_types": {"key": "dataTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        workspace: Optional[str] = None,
        type: Union[str, "_models.AdditionalWorkspaceType"] = "Sentinel",
        data_types: Optional[List[Union[str, "_models.AdditionalWorkspaceDataType"]]] = None,
        **kwargs
    ):
        """
        :keyword workspace: Workspace resource id.
        :paramtype workspace: str
        :keyword type: Workspace type. "Sentinel"
        :paramtype type: str or ~azure.mgmt.security.v2019_08_01.models.AdditionalWorkspaceType
        :keyword data_types: List of data types sent to workspace.
        :paramtype data_types: list[str or
         ~azure.mgmt.security.v2019_08_01.models.AdditionalWorkspaceDataType]
        """
        super().__init__(**kwargs)
        self.workspace = workspace
        self.type = type
        self.data_types = data_types


class ListCustomAlertRule(CustomAlertRule):
    """A List custom alert rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AllowlistCustomAlertRule, DenylistCustomAlertRule

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.v2019_08_01.models.ValueType
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
    }

    _subtype_map = {
        "rule_type": {
            "AllowlistCustomAlertRule": "AllowlistCustomAlertRule",
            "DenylistCustomAlertRule": "DenylistCustomAlertRule",
        }
    }

    def __init__(self, *, is_enabled: bool, **kwargs):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.rule_type = "ListCustomAlertRule"  # type: str
        self.value_type = None


class AllowlistCustomAlertRule(ListCustomAlertRule):
    """A custom alert rule that checks if a value (depends on the custom alert type) is allowed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ConnectionFromIpNotAllowed, ConnectionToIpNotAllowed, LocalUserNotAllowed, ProcessNotAllowed

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.v2019_08_01.models.ValueType
    :ivar allowlist_values: The values to allow. The format of the values depends on the rule type.
     Required.
    :vartype allowlist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "allowlist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "allowlist_values": {"key": "allowlistValues", "type": "[str]"},
    }

    _subtype_map = {
        "rule_type": {
            "ConnectionFromIpNotAllowed": "ConnectionFromIpNotAllowed",
            "ConnectionToIpNotAllowed": "ConnectionToIpNotAllowed",
            "LocalUserNotAllowed": "LocalUserNotAllowed",
            "ProcessNotAllowed": "ProcessNotAllowed",
        }
    }

    def __init__(self, *, is_enabled: bool, allowlist_values: List[str], **kwargs):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword allowlist_values: The values to allow. The format of the values depends on the rule
         type. Required.
        :paramtype allowlist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.rule_type = "AllowlistCustomAlertRule"  # type: str
        self.allowlist_values = allowlist_values


class AmqpC2DMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of cloud to device messages (AMQP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "AmqpC2DMessagesNotInAllowedRange"  # type: str


class AmqpC2DRejectedMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of rejected cloud to device messages (AMQP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "AmqpC2DRejectedMessagesNotInAllowedRange"  # type: str


class AmqpD2CMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device to cloud messages (AMQP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "AmqpD2CMessagesNotInAllowedRange"  # type: str


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2019_08_01.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.v2019_08_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ConnectionFromIpNotAllowed(AllowlistCustomAlertRule):
    """Inbound connection from an ip that isn't allowed. Allow list consists of ipv4 or ipv6 range in CIDR notation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.v2019_08_01.models.ValueType
    :ivar allowlist_values: The values to allow. The format of the values depends on the rule type.
     Required.
    :vartype allowlist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "allowlist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "allowlist_values": {"key": "allowlistValues", "type": "[str]"},
    }

    def __init__(self, *, is_enabled: bool, allowlist_values: List[str], **kwargs):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword allowlist_values: The values to allow. The format of the values depends on the rule
         type. Required.
        :paramtype allowlist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, allowlist_values=allowlist_values, **kwargs)
        self.rule_type = "ConnectionFromIpNotAllowed"  # type: str


class ConnectionToIpNotAllowed(AllowlistCustomAlertRule):
    """Outbound connection to an ip that isn't allowed. Allow list consists of ipv4 or ipv6 range in CIDR notation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.v2019_08_01.models.ValueType
    :ivar allowlist_values: The values to allow. The format of the values depends on the rule type.
     Required.
    :vartype allowlist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "allowlist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "allowlist_values": {"key": "allowlistValues", "type": "[str]"},
    }

    def __init__(self, *, is_enabled: bool, allowlist_values: List[str], **kwargs):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword allowlist_values: The values to allow. The format of the values depends on the rule
         type. Required.
        :paramtype allowlist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, allowlist_values=allowlist_values, **kwargs)
        self.rule_type = "ConnectionToIpNotAllowed"  # type: str


class DenylistCustomAlertRule(ListCustomAlertRule):
    """A custom alert rule that checks if a value (depends on the custom alert type) is denied.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.v2019_08_01.models.ValueType
    :ivar denylist_values: The values to deny. The format of the values depends on the rule type.
     Required.
    :vartype denylist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "denylist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "denylist_values": {"key": "denylistValues", "type": "[str]"},
    }

    def __init__(self, *, is_enabled: bool, denylist_values: List[str], **kwargs):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword denylist_values: The values to deny. The format of the values depends on the rule
         type. Required.
        :paramtype denylist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, **kwargs)
        self.rule_type = "DenylistCustomAlertRule"  # type: str
        self.denylist_values = denylist_values


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class DeviceSecurityGroup(Resource):
    """The device security group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar threshold_rules: The list of custom alert threshold rules.
    :vartype threshold_rules:
     list[~azure.mgmt.security.v2019_08_01.models.ThresholdCustomAlertRule]
    :ivar time_window_rules: The list of custom alert time-window rules.
    :vartype time_window_rules:
     list[~azure.mgmt.security.v2019_08_01.models.TimeWindowCustomAlertRule]
    :ivar allowlist_rules: The allow-list custom alert rules.
    :vartype allowlist_rules:
     list[~azure.mgmt.security.v2019_08_01.models.AllowlistCustomAlertRule]
    :ivar denylist_rules: The deny-list custom alert rules.
    :vartype denylist_rules: list[~azure.mgmt.security.v2019_08_01.models.DenylistCustomAlertRule]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "threshold_rules": {"key": "properties.thresholdRules", "type": "[ThresholdCustomAlertRule]"},
        "time_window_rules": {"key": "properties.timeWindowRules", "type": "[TimeWindowCustomAlertRule]"},
        "allowlist_rules": {"key": "properties.allowlistRules", "type": "[AllowlistCustomAlertRule]"},
        "denylist_rules": {"key": "properties.denylistRules", "type": "[DenylistCustomAlertRule]"},
    }

    def __init__(
        self,
        *,
        threshold_rules: Optional[List["_models.ThresholdCustomAlertRule"]] = None,
        time_window_rules: Optional[List["_models.TimeWindowCustomAlertRule"]] = None,
        allowlist_rules: Optional[List["_models.AllowlistCustomAlertRule"]] = None,
        denylist_rules: Optional[List["_models.DenylistCustomAlertRule"]] = None,
        **kwargs
    ):
        """
        :keyword threshold_rules: The list of custom alert threshold rules.
        :paramtype threshold_rules:
         list[~azure.mgmt.security.v2019_08_01.models.ThresholdCustomAlertRule]
        :keyword time_window_rules: The list of custom alert time-window rules.
        :paramtype time_window_rules:
         list[~azure.mgmt.security.v2019_08_01.models.TimeWindowCustomAlertRule]
        :keyword allowlist_rules: The allow-list custom alert rules.
        :paramtype allowlist_rules:
         list[~azure.mgmt.security.v2019_08_01.models.AllowlistCustomAlertRule]
        :keyword denylist_rules: The deny-list custom alert rules.
        :paramtype denylist_rules:
         list[~azure.mgmt.security.v2019_08_01.models.DenylistCustomAlertRule]
        """
        super().__init__(**kwargs)
        self.threshold_rules = threshold_rules
        self.time_window_rules = time_window_rules
        self.allowlist_rules = allowlist_rules
        self.denylist_rules = denylist_rules


class DeviceSecurityGroupList(_serialization.Model):
    """List of device security groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of device security group objects.
    :vartype value: list[~azure.mgmt.security.v2019_08_01.models.DeviceSecurityGroup]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeviceSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DeviceSecurityGroup"]] = None, **kwargs):
        """
        :keyword value: List of device security group objects.
        :paramtype value: list[~azure.mgmt.security.v2019_08_01.models.DeviceSecurityGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DirectMethodInvokesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of direct method invokes is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "DirectMethodInvokesNotInAllowedRange"  # type: str


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class FailedLocalLoginsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of failed local logins is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "FailedLocalLoginsNotInAllowedRange"  # type: str


class FileUploadsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of file uploads is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "FileUploadsNotInAllowedRange"  # type: str


class HttpC2DMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of cloud to device messages (HTTP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "HttpC2DMessagesNotInAllowedRange"  # type: str


class HttpC2DRejectedMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of rejected cloud to device messages (HTTP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "HttpC2DRejectedMessagesNotInAllowedRange"  # type: str


class HttpD2CMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device to cloud messages (HTTP protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "HttpD2CMessagesNotInAllowedRange"  # type: str


class TagsResource(_serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class IoTSecurityAggregatedAlert(Resource, TagsResource):  # pylint: disable=too-many-instance-attributes
    """Security Solution Aggregated Alert information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar alert_type: Name of the alert type.
    :vartype alert_type: str
    :ivar alert_display_name: Display name of the alert type.
    :vartype alert_display_name: str
    :ivar aggregated_date_utc: Date of detection.
    :vartype aggregated_date_utc: ~datetime.date
    :ivar vendor_name: Name of the organization that raised the alert.
    :vartype vendor_name: str
    :ivar reported_severity: Assessed alert severity. Known values are: "Informational", "Low",
     "Medium", and "High".
    :vartype reported_severity: str or ~azure.mgmt.security.v2019_08_01.models.ReportedSeverity
    :ivar remediation_steps: Recommended steps for remediation.
    :vartype remediation_steps: str
    :ivar description: Description of the suspected vulnerability and meaning.
    :vartype description: str
    :ivar count: Number of alerts occurrences within the aggregated time window.
    :vartype count: int
    :ivar effected_resource_type: Azure resource ID of the resource that received the alerts.
    :vartype effected_resource_type: str
    :ivar system_source: The type of the alerted resource (Azure, Non-Azure).
    :vartype system_source: str
    :ivar action_taken: IoT Security solution alert response.
    :vartype action_taken: str
    :ivar log_analytics_query: Log analytics query for getting the list of affected devices/alerts.
    :vartype log_analytics_query: str
    :ivar top_devices_list: 10 devices with the highest number of occurrences of this alert type,
     on this day.
    :vartype top_devices_list:
     list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityAggregatedAlertPropertiesTopDevicesListItem]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "alert_type": {"readonly": True},
        "alert_display_name": {"readonly": True},
        "aggregated_date_utc": {"readonly": True},
        "vendor_name": {"readonly": True},
        "reported_severity": {"readonly": True},
        "remediation_steps": {"readonly": True},
        "description": {"readonly": True},
        "count": {"readonly": True},
        "effected_resource_type": {"readonly": True},
        "system_source": {"readonly": True},
        "action_taken": {"readonly": True},
        "log_analytics_query": {"readonly": True},
        "top_devices_list": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "alert_type": {"key": "properties.alertType", "type": "str"},
        "alert_display_name": {"key": "properties.alertDisplayName", "type": "str"},
        "aggregated_date_utc": {"key": "properties.aggregatedDateUtc", "type": "date"},
        "vendor_name": {"key": "properties.vendorName", "type": "str"},
        "reported_severity": {"key": "properties.reportedSeverity", "type": "str"},
        "remediation_steps": {"key": "properties.remediationSteps", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "count": {"key": "properties.count", "type": "int"},
        "effected_resource_type": {"key": "properties.effectedResourceType", "type": "str"},
        "system_source": {"key": "properties.systemSource", "type": "str"},
        "action_taken": {"key": "properties.actionTaken", "type": "str"},
        "log_analytics_query": {"key": "properties.logAnalyticsQuery", "type": "str"},
        "top_devices_list": {
            "key": "properties.topDevicesList",
            "type": "[IoTSecurityAggregatedAlertPropertiesTopDevicesListItem]",
        },
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(tags=tags, **kwargs)
        self.tags = tags
        self.alert_type = None
        self.alert_display_name = None
        self.aggregated_date_utc = None
        self.vendor_name = None
        self.reported_severity = None
        self.remediation_steps = None
        self.description = None
        self.count = None
        self.effected_resource_type = None
        self.system_source = None
        self.action_taken = None
        self.log_analytics_query = None
        self.top_devices_list = None
        self.id = None
        self.name = None
        self.type = None


class IoTSecurityAggregatedAlertList(_serialization.Model):
    """List of IoT Security solution aggregated alert data.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of aggregated alerts data. Required.
    :vartype value: list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityAggregatedAlert]
    :ivar next_link: When there is too much alert data for one page, use this URI to fetch the next
     page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IoTSecurityAggregatedAlert]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IoTSecurityAggregatedAlert"], **kwargs):
        """
        :keyword value: List of aggregated alerts data. Required.
        :paramtype value: list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityAggregatedAlert]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IoTSecurityAggregatedAlertPropertiesTopDevicesListItem(_serialization.Model):
    """IoTSecurityAggregatedAlertPropertiesTopDevicesListItem.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_id: Name of the device.
    :vartype device_id: str
    :ivar alerts_count: Number of alerts raised for this device.
    :vartype alerts_count: int
    :ivar last_occurrence: Most recent time this alert was raised for this device, on this day.
    :vartype last_occurrence: str
    """

    _validation = {
        "device_id": {"readonly": True},
        "alerts_count": {"readonly": True},
        "last_occurrence": {"readonly": True},
    }

    _attribute_map = {
        "device_id": {"key": "deviceId", "type": "str"},
        "alerts_count": {"key": "alertsCount", "type": "int"},
        "last_occurrence": {"key": "lastOccurrence", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.device_id = None
        self.alerts_count = None
        self.last_occurrence = None


class IoTSecurityAggregatedRecommendation(Resource, TagsResource):  # pylint: disable=too-many-instance-attributes
    """IoT Security solution recommendation information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar recommendation_name: Name of the recommendation.
    :vartype recommendation_name: str
    :ivar recommendation_display_name: Display name of the recommendation type.
    :vartype recommendation_display_name: str
    :ivar description: Description of the suspected vulnerability and meaning.
    :vartype description: str
    :ivar recommendation_type_id: Recommendation-type GUID.
    :vartype recommendation_type_id: str
    :ivar detected_by: Name of the organization that made the recommendation.
    :vartype detected_by: str
    :ivar remediation_steps: Recommended steps for remediation.
    :vartype remediation_steps: str
    :ivar reported_severity: Assessed recommendation severity. Known values are: "Informational",
     "Low", "Medium", and "High".
    :vartype reported_severity: str or ~azure.mgmt.security.v2019_08_01.models.ReportedSeverity
    :ivar healthy_devices: Number of healthy devices within the IoT Security solution.
    :vartype healthy_devices: int
    :ivar unhealthy_device_count: Number of unhealthy devices within the IoT Security solution.
    :vartype unhealthy_device_count: int
    :ivar log_analytics_query: Log analytics query for getting the list of affected devices/alerts.
    :vartype log_analytics_query: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "recommendation_display_name": {"readonly": True},
        "description": {"readonly": True},
        "recommendation_type_id": {"readonly": True},
        "detected_by": {"readonly": True},
        "remediation_steps": {"readonly": True},
        "reported_severity": {"readonly": True},
        "healthy_devices": {"readonly": True},
        "unhealthy_device_count": {"readonly": True},
        "log_analytics_query": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "recommendation_name": {"key": "properties.recommendationName", "type": "str"},
        "recommendation_display_name": {"key": "properties.recommendationDisplayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "recommendation_type_id": {"key": "properties.recommendationTypeId", "type": "str"},
        "detected_by": {"key": "properties.detectedBy", "type": "str"},
        "remediation_steps": {"key": "properties.remediationSteps", "type": "str"},
        "reported_severity": {"key": "properties.reportedSeverity", "type": "str"},
        "healthy_devices": {"key": "properties.healthyDevices", "type": "int"},
        "unhealthy_device_count": {"key": "properties.unhealthyDeviceCount", "type": "int"},
        "log_analytics_query": {"key": "properties.logAnalyticsQuery", "type": "str"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, recommendation_name: Optional[str] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword recommendation_name: Name of the recommendation.
        :paramtype recommendation_name: str
        """
        super().__init__(tags=tags, **kwargs)
        self.tags = tags
        self.recommendation_name = recommendation_name
        self.recommendation_display_name = None
        self.description = None
        self.recommendation_type_id = None
        self.detected_by = None
        self.remediation_steps = None
        self.reported_severity = None
        self.healthy_devices = None
        self.unhealthy_device_count = None
        self.log_analytics_query = None
        self.id = None
        self.name = None
        self.type = None


class IoTSecurityAggregatedRecommendationList(_serialization.Model):
    """List of IoT Security solution aggregated recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of aggregated recommendations data. Required.
    :vartype value:
     list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityAggregatedRecommendation]
    :ivar next_link: When there is too much alert data for one page, use this URI to fetch the next
     page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IoTSecurityAggregatedRecommendation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IoTSecurityAggregatedRecommendation"], **kwargs):
        """
        :keyword value: List of aggregated recommendations data. Required.
        :paramtype value:
         list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityAggregatedRecommendation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IoTSecurityAlertedDevice(_serialization.Model):
    """Statistical information about the number of alerts per device during last set number of days.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_id: Device identifier.
    :vartype device_id: str
    :ivar alerts_count: Number of alerts raised for this device.
    :vartype alerts_count: int
    """

    _validation = {
        "device_id": {"readonly": True},
        "alerts_count": {"readonly": True},
    }

    _attribute_map = {
        "device_id": {"key": "deviceId", "type": "str"},
        "alerts_count": {"key": "alertsCount", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.device_id = None
        self.alerts_count = None


class IoTSecurityDeviceAlert(_serialization.Model):
    """Statistical information about the number of alerts per alert type during last set number of days.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar alert_display_name: Display name of the alert.
    :vartype alert_display_name: str
    :ivar reported_severity: Assessed Alert severity. Known values are: "Informational", "Low",
     "Medium", and "High".
    :vartype reported_severity: str or ~azure.mgmt.security.v2019_08_01.models.ReportedSeverity
    :ivar alerts_count: Number of alerts raised for this alert type.
    :vartype alerts_count: int
    """

    _validation = {
        "alert_display_name": {"readonly": True},
        "reported_severity": {"readonly": True},
        "alerts_count": {"readonly": True},
    }

    _attribute_map = {
        "alert_display_name": {"key": "alertDisplayName", "type": "str"},
        "reported_severity": {"key": "reportedSeverity", "type": "str"},
        "alerts_count": {"key": "alertsCount", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.alert_display_name = None
        self.reported_severity = None
        self.alerts_count = None


class IoTSecurityDeviceRecommendation(_serialization.Model):
    """Statistical information about the number of recommendations per device, per recommendation type.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar recommendation_display_name: Display name of the recommendation.
    :vartype recommendation_display_name: str
    :ivar reported_severity: Assessed recommendation severity. Known values are: "Informational",
     "Low", "Medium", and "High".
    :vartype reported_severity: str or ~azure.mgmt.security.v2019_08_01.models.ReportedSeverity
    :ivar devices_count: Number of devices with this recommendation.
    :vartype devices_count: int
    """

    _validation = {
        "recommendation_display_name": {"readonly": True},
        "reported_severity": {"readonly": True},
        "devices_count": {"readonly": True},
    }

    _attribute_map = {
        "recommendation_display_name": {"key": "recommendationDisplayName", "type": "str"},
        "reported_severity": {"key": "reportedSeverity", "type": "str"},
        "devices_count": {"key": "devicesCount", "type": "int"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.recommendation_display_name = None
        self.reported_severity = None
        self.devices_count = None


class IoTSecuritySolutionAnalyticsModel(Resource):
    """Security analytics of your IoT Security solution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar metrics: Security analytics of your IoT Security solution.
    :vartype metrics: ~azure.mgmt.security.v2019_08_01.models.IoTSeverityMetrics
    :ivar unhealthy_device_count: Number of unhealthy devices within your IoT Security solution.
    :vartype unhealthy_device_count: int
    :ivar devices_metrics: List of device metrics by the aggregation date.
    :vartype devices_metrics:
     list[~azure.mgmt.security.v2019_08_01.models.IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem]
    :ivar top_alerted_devices: List of the 3 devices with the most alerts.
    :vartype top_alerted_devices:
     list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityAlertedDevice]
    :ivar most_prevalent_device_alerts: List of the 3 most prevalent device alerts.
    :vartype most_prevalent_device_alerts:
     list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityDeviceAlert]
    :ivar most_prevalent_device_recommendations: List of the 3 most prevalent device
     recommendations.
    :vartype most_prevalent_device_recommendations:
     list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityDeviceRecommendation]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "metrics": {"readonly": True},
        "unhealthy_device_count": {"readonly": True},
        "devices_metrics": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "metrics": {"key": "properties.metrics", "type": "IoTSeverityMetrics"},
        "unhealthy_device_count": {"key": "properties.unhealthyDeviceCount", "type": "int"},
        "devices_metrics": {
            "key": "properties.devicesMetrics",
            "type": "[IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem]",
        },
        "top_alerted_devices": {"key": "properties.topAlertedDevices", "type": "[IoTSecurityAlertedDevice]"},
        "most_prevalent_device_alerts": {
            "key": "properties.mostPrevalentDeviceAlerts",
            "type": "[IoTSecurityDeviceAlert]",
        },
        "most_prevalent_device_recommendations": {
            "key": "properties.mostPrevalentDeviceRecommendations",
            "type": "[IoTSecurityDeviceRecommendation]",
        },
    }

    def __init__(
        self,
        *,
        top_alerted_devices: Optional[List["_models.IoTSecurityAlertedDevice"]] = None,
        most_prevalent_device_alerts: Optional[List["_models.IoTSecurityDeviceAlert"]] = None,
        most_prevalent_device_recommendations: Optional[List["_models.IoTSecurityDeviceRecommendation"]] = None,
        **kwargs
    ):
        """
        :keyword top_alerted_devices: List of the 3 devices with the most alerts.
        :paramtype top_alerted_devices:
         list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityAlertedDevice]
        :keyword most_prevalent_device_alerts: List of the 3 most prevalent device alerts.
        :paramtype most_prevalent_device_alerts:
         list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityDeviceAlert]
        :keyword most_prevalent_device_recommendations: List of the 3 most prevalent device
         recommendations.
        :paramtype most_prevalent_device_recommendations:
         list[~azure.mgmt.security.v2019_08_01.models.IoTSecurityDeviceRecommendation]
        """
        super().__init__(**kwargs)
        self.metrics = None
        self.unhealthy_device_count = None
        self.devices_metrics = None
        self.top_alerted_devices = top_alerted_devices
        self.most_prevalent_device_alerts = most_prevalent_device_alerts
        self.most_prevalent_device_recommendations = most_prevalent_device_recommendations


class IoTSecuritySolutionAnalyticsModelList(_serialization.Model):
    """List of Security analytics of your IoT Security solution.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of Security analytics of your IoT Security solution. Required.
    :vartype value: list[~azure.mgmt.security.v2019_08_01.models.IoTSecuritySolutionAnalyticsModel]
    :ivar next_link: When there is too much alert data for one page, use this URI to fetch the next
     page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IoTSecuritySolutionAnalyticsModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IoTSecuritySolutionAnalyticsModel"], **kwargs):
        """
        :keyword value: List of Security analytics of your IoT Security solution. Required.
        :paramtype value:
         list[~azure.mgmt.security.v2019_08_01.models.IoTSecuritySolutionAnalyticsModel]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem(_serialization.Model):
    """IoTSecuritySolutionAnalyticsModelPropertiesDevicesMetricsItem.

    :ivar date: Aggregation of IoT Security solution device alert metrics by date.
    :vartype date: ~datetime.datetime
    :ivar devices_metrics: Device alert count by severity.
    :vartype devices_metrics: ~azure.mgmt.security.v2019_08_01.models.IoTSeverityMetrics
    """

    _attribute_map = {
        "date": {"key": "date", "type": "iso-8601"},
        "devices_metrics": {"key": "devicesMetrics", "type": "IoTSeverityMetrics"},
    }

    def __init__(
        self,
        *,
        date: Optional[datetime.datetime] = None,
        devices_metrics: Optional["_models.IoTSeverityMetrics"] = None,
        **kwargs
    ):
        """
        :keyword date: Aggregation of IoT Security solution device alert metrics by date.
        :paramtype date: ~datetime.datetime
        :keyword devices_metrics: Device alert count by severity.
        :paramtype devices_metrics: ~azure.mgmt.security.v2019_08_01.models.IoTSeverityMetrics
        """
        super().__init__(**kwargs)
        self.date = date
        self.devices_metrics = devices_metrics


class IoTSecuritySolutionModel(Resource, TagsResource):  # pylint: disable=too-many-instance-attributes
    """IoT Security solution configuration and resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: The resource location.
    :vartype location: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.v2019_08_01.models.SystemData
    :ivar workspace: Workspace resource ID.
    :vartype workspace: str
    :ivar display_name: Resource display name.
    :vartype display_name: str
    :ivar status: Status of the IoT Security solution. Known values are: "Enabled" and "Disabled".
    :vartype status: str or ~azure.mgmt.security.v2019_08_01.models.SecuritySolutionStatus
    :ivar export: List of additional options for exporting to workspace data.
    :vartype export: list[str or ~azure.mgmt.security.v2019_08_01.models.ExportData]
    :ivar disabled_data_sources: Disabled data sources. Disabling these data sources compromises
     the system.
    :vartype disabled_data_sources: list[str or ~azure.mgmt.security.v2019_08_01.models.DataSource]
    :ivar iot_hubs: IoT Hub resource IDs.
    :vartype iot_hubs: list[str]
    :ivar user_defined_resources: Properties of the IoT Security solution's user defined resources.
    :vartype user_defined_resources:
     ~azure.mgmt.security.v2019_08_01.models.UserDefinedResourcesProperties
    :ivar auto_discovered_resources: List of resources that were automatically discovered as
     relevant to the security solution.
    :vartype auto_discovered_resources: list[str]
    :ivar recommendations_configuration: List of the configuration status for each recommendation
     type.
    :vartype recommendations_configuration:
     list[~azure.mgmt.security.v2019_08_01.models.RecommendationConfigurationProperties]
    :ivar unmasked_ip_logging_status: Unmasked IP address logging status. Known values are:
     "Disabled" and "Enabled".
    :vartype unmasked_ip_logging_status: str or
     ~azure.mgmt.security.v2019_08_01.models.UnmaskedIpLoggingStatus
    :ivar additional_workspaces: List of additional workspaces.
    :vartype additional_workspaces:
     list[~azure.mgmt.security.v2019_08_01.models.AdditionalWorkspacesProperties]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "auto_discovered_resources": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "workspace": {"key": "properties.workspace", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "export": {"key": "properties.export", "type": "[str]"},
        "disabled_data_sources": {"key": "properties.disabledDataSources", "type": "[str]"},
        "iot_hubs": {"key": "properties.iotHubs", "type": "[str]"},
        "user_defined_resources": {"key": "properties.userDefinedResources", "type": "UserDefinedResourcesProperties"},
        "auto_discovered_resources": {"key": "properties.autoDiscoveredResources", "type": "[str]"},
        "recommendations_configuration": {
            "key": "properties.recommendationsConfiguration",
            "type": "[RecommendationConfigurationProperties]",
        },
        "unmasked_ip_logging_status": {"key": "properties.unmaskedIpLoggingStatus", "type": "str"},
        "additional_workspaces": {"key": "properties.additionalWorkspaces", "type": "[AdditionalWorkspacesProperties]"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        location: Optional[str] = None,
        workspace: Optional[str] = None,
        display_name: Optional[str] = None,
        status: Union[str, "_models.SecuritySolutionStatus"] = "Enabled",
        export: Optional[List[Union[str, "_models.ExportData"]]] = None,
        disabled_data_sources: Optional[List[Union[str, "_models.DataSource"]]] = None,
        iot_hubs: Optional[List[str]] = None,
        user_defined_resources: Optional["_models.UserDefinedResourcesProperties"] = None,
        recommendations_configuration: Optional[List["_models.RecommendationConfigurationProperties"]] = None,
        unmasked_ip_logging_status: Union[str, "_models.UnmaskedIpLoggingStatus"] = "Disabled",
        additional_workspaces: Optional[List["_models.AdditionalWorkspacesProperties"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The resource location.
        :paramtype location: str
        :keyword workspace: Workspace resource ID.
        :paramtype workspace: str
        :keyword display_name: Resource display name.
        :paramtype display_name: str
        :keyword status: Status of the IoT Security solution. Known values are: "Enabled" and
         "Disabled".
        :paramtype status: str or ~azure.mgmt.security.v2019_08_01.models.SecuritySolutionStatus
        :keyword export: List of additional options for exporting to workspace data.
        :paramtype export: list[str or ~azure.mgmt.security.v2019_08_01.models.ExportData]
        :keyword disabled_data_sources: Disabled data sources. Disabling these data sources compromises
         the system.
        :paramtype disabled_data_sources: list[str or
         ~azure.mgmt.security.v2019_08_01.models.DataSource]
        :keyword iot_hubs: IoT Hub resource IDs.
        :paramtype iot_hubs: list[str]
        :keyword user_defined_resources: Properties of the IoT Security solution's user defined
         resources.
        :paramtype user_defined_resources:
         ~azure.mgmt.security.v2019_08_01.models.UserDefinedResourcesProperties
        :keyword recommendations_configuration: List of the configuration status for each
         recommendation type.
        :paramtype recommendations_configuration:
         list[~azure.mgmt.security.v2019_08_01.models.RecommendationConfigurationProperties]
        :keyword unmasked_ip_logging_status: Unmasked IP address logging status. Known values are:
         "Disabled" and "Enabled".
        :paramtype unmasked_ip_logging_status: str or
         ~azure.mgmt.security.v2019_08_01.models.UnmaskedIpLoggingStatus
        :keyword additional_workspaces: List of additional workspaces.
        :paramtype additional_workspaces:
         list[~azure.mgmt.security.v2019_08_01.models.AdditionalWorkspacesProperties]
        """
        super().__init__(tags=tags, **kwargs)
        self.tags = tags
        self.location = location
        self.system_data = None
        self.workspace = workspace
        self.display_name = display_name
        self.status = status
        self.export = export
        self.disabled_data_sources = disabled_data_sources
        self.iot_hubs = iot_hubs
        self.user_defined_resources = user_defined_resources
        self.auto_discovered_resources = None
        self.recommendations_configuration = recommendations_configuration
        self.unmasked_ip_logging_status = unmasked_ip_logging_status
        self.additional_workspaces = additional_workspaces
        self.id = None
        self.name = None
        self.type = None


class IoTSecuritySolutionsList(_serialization.Model):
    """List of IoT Security solutions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar value: List of IoT Security solutions. Required.
    :vartype value: list[~azure.mgmt.security.v2019_08_01.models.IoTSecuritySolutionModel]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[IoTSecuritySolutionModel]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.IoTSecuritySolutionModel"], **kwargs):
        """
        :keyword value: List of IoT Security solutions. Required.
        :paramtype value: list[~azure.mgmt.security.v2019_08_01.models.IoTSecuritySolutionModel]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class IoTSeverityMetrics(_serialization.Model):
    """IoT Security solution analytics severity metrics.

    :ivar high: Count of high severity alerts/recommendations.
    :vartype high: int
    :ivar medium: Count of medium severity alerts/recommendations.
    :vartype medium: int
    :ivar low: Count of low severity alerts/recommendations.
    :vartype low: int
    """

    _attribute_map = {
        "high": {"key": "high", "type": "int"},
        "medium": {"key": "medium", "type": "int"},
        "low": {"key": "low", "type": "int"},
    }

    def __init__(
        self, *, high: Optional[int] = None, medium: Optional[int] = None, low: Optional[int] = None, **kwargs
    ):
        """
        :keyword high: Count of high severity alerts/recommendations.
        :paramtype high: int
        :keyword medium: Count of medium severity alerts/recommendations.
        :paramtype medium: int
        :keyword low: Count of low severity alerts/recommendations.
        :paramtype low: int
        """
        super().__init__(**kwargs)
        self.high = high
        self.medium = medium
        self.low = low


class LocalUserNotAllowed(AllowlistCustomAlertRule):
    """Login by a local user that isn't allowed. Allow list consists of login names to allow.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.v2019_08_01.models.ValueType
    :ivar allowlist_values: The values to allow. The format of the values depends on the rule type.
     Required.
    :vartype allowlist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "allowlist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "allowlist_values": {"key": "allowlistValues", "type": "[str]"},
    }

    def __init__(self, *, is_enabled: bool, allowlist_values: List[str], **kwargs):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword allowlist_values: The values to allow. The format of the values depends on the rule
         type. Required.
        :paramtype allowlist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, allowlist_values=allowlist_values, **kwargs)
        self.rule_type = "LocalUserNotAllowed"  # type: str


class MqttC2DMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of cloud to device messages (MQTT protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "MqttC2DMessagesNotInAllowedRange"  # type: str


class MqttC2DRejectedMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of rejected cloud to device messages (MQTT protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "MqttC2DRejectedMessagesNotInAllowedRange"  # type: str


class MqttD2CMessagesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device to cloud messages (MQTT protocol) is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "MqttD2CMessagesNotInAllowedRange"  # type: str


class ProcessNotAllowed(AllowlistCustomAlertRule):
    """Execution of a process that isn't allowed. Allow list consists of process names to allow.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar value_type: The value type of the items in the list. Known values are: "IpCidr" and
     "String".
    :vartype value_type: str or ~azure.mgmt.security.v2019_08_01.models.ValueType
    :ivar allowlist_values: The values to allow. The format of the values depends on the rule type.
     Required.
    :vartype allowlist_values: list[str]
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "value_type": {"readonly": True},
        "allowlist_values": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "value_type": {"key": "valueType", "type": "str"},
        "allowlist_values": {"key": "allowlistValues", "type": "[str]"},
    }

    def __init__(self, *, is_enabled: bool, allowlist_values: List[str], **kwargs):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword allowlist_values: The values to allow. The format of the values depends on the rule
         type. Required.
        :paramtype allowlist_values: list[str]
        """
        super().__init__(is_enabled=is_enabled, allowlist_values=allowlist_values, **kwargs)
        self.rule_type = "ProcessNotAllowed"  # type: str


class QueuePurgesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of device queue purges is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "QueuePurgesNotInAllowedRange"  # type: str


class RecommendationConfigurationProperties(_serialization.Model):
    """The type of IoT Security recommendation.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar recommendation_type: The type of IoT Security recommendation. Required. Known values are:
     "IoT_ACRAuthentication", "IoT_AgentSendsUnutilizedMessages", "IoT_Baseline",
     "IoT_EdgeHubMemOptimize", "IoT_EdgeLoggingOptions", "IoT_InconsistentModuleSettings",
     "IoT_InstallAgent", "IoT_IPFilter_DenyAll", "IoT_IPFilter_PermissiveRule", "IoT_OpenPorts",
     "IoT_PermissiveFirewallPolicy", "IoT_PermissiveInputFirewallRules",
     "IoT_PermissiveOutputFirewallRules", "IoT_PrivilegedDockerOptions", "IoT_SharedCredentials",
     and "IoT_VulnerableTLSCipherSuite".
    :vartype recommendation_type: str or ~azure.mgmt.security.v2019_08_01.models.RecommendationType
    :ivar name:
    :vartype name: str
    :ivar status: Recommendation status. When the recommendation status is disabled recommendations
     are not generated. Known values are: "Disabled" and "Enabled".
    :vartype status: str or ~azure.mgmt.security.v2019_08_01.models.RecommendationConfigStatus
    """

    _validation = {
        "recommendation_type": {"required": True},
        "name": {"readonly": True},
        "status": {"required": True},
    }

    _attribute_map = {
        "recommendation_type": {"key": "recommendationType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        recommendation_type: Union[str, "_models.RecommendationType"],
        status: Union[str, "_models.RecommendationConfigStatus"] = "Enabled",
        **kwargs
    ):
        """
        :keyword recommendation_type: The type of IoT Security recommendation. Required. Known values
         are: "IoT_ACRAuthentication", "IoT_AgentSendsUnutilizedMessages", "IoT_Baseline",
         "IoT_EdgeHubMemOptimize", "IoT_EdgeLoggingOptions", "IoT_InconsistentModuleSettings",
         "IoT_InstallAgent", "IoT_IPFilter_DenyAll", "IoT_IPFilter_PermissiveRule", "IoT_OpenPorts",
         "IoT_PermissiveFirewallPolicy", "IoT_PermissiveInputFirewallRules",
         "IoT_PermissiveOutputFirewallRules", "IoT_PrivilegedDockerOptions", "IoT_SharedCredentials",
         and "IoT_VulnerableTLSCipherSuite".
        :paramtype recommendation_type: str or
         ~azure.mgmt.security.v2019_08_01.models.RecommendationType
        :keyword status: Recommendation status. When the recommendation status is disabled
         recommendations are not generated. Known values are: "Disabled" and "Enabled".
        :paramtype status: str or ~azure.mgmt.security.v2019_08_01.models.RecommendationConfigStatus
        """
        super().__init__(**kwargs)
        self.recommendation_type = recommendation_type
        self.name = None
        self.status = status


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.security.v2019_08_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.security.v2019_08_01.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.security.v2019_08_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.security.v2019_08_01.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TwinUpdatesNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of twin updates is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "TwinUpdatesNotInAllowedRange"  # type: str


class UnauthorizedOperationsNotInAllowedRange(TimeWindowCustomAlertRule):
    """Number of unauthorized operations is not in allowed range.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar display_name: The display name of the custom alert.
    :vartype display_name: str
    :ivar description: The description of the custom alert.
    :vartype description: str
    :ivar is_enabled: Status of the custom alert. Required.
    :vartype is_enabled: bool
    :ivar rule_type: The type of the custom alert rule. Required.
    :vartype rule_type: str
    :ivar min_threshold: The minimum threshold. Required.
    :vartype min_threshold: int
    :ivar max_threshold: The maximum threshold. Required.
    :vartype max_threshold: int
    :ivar time_window_size: The time window size in iso8601 format. Required.
    :vartype time_window_size: ~datetime.timedelta
    """

    _validation = {
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "is_enabled": {"required": True},
        "rule_type": {"required": True},
        "min_threshold": {"required": True},
        "max_threshold": {"required": True},
        "time_window_size": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "is_enabled": {"key": "isEnabled", "type": "bool"},
        "rule_type": {"key": "ruleType", "type": "str"},
        "min_threshold": {"key": "minThreshold", "type": "int"},
        "max_threshold": {"key": "maxThreshold", "type": "int"},
        "time_window_size": {"key": "timeWindowSize", "type": "duration"},
    }

    def __init__(
        self,
        *,
        is_enabled: bool,
        min_threshold: int,
        max_threshold: int,
        time_window_size: datetime.timedelta,
        **kwargs
    ):
        """
        :keyword is_enabled: Status of the custom alert. Required.
        :paramtype is_enabled: bool
        :keyword min_threshold: The minimum threshold. Required.
        :paramtype min_threshold: int
        :keyword max_threshold: The maximum threshold. Required.
        :paramtype max_threshold: int
        :keyword time_window_size: The time window size in iso8601 format. Required.
        :paramtype time_window_size: ~datetime.timedelta
        """
        super().__init__(
            is_enabled=is_enabled,
            min_threshold=min_threshold,
            max_threshold=max_threshold,
            time_window_size=time_window_size,
            **kwargs
        )
        self.rule_type = "UnauthorizedOperationsNotInAllowedRange"  # type: str


class UpdateIotSecuritySolutionData(TagsResource):
    """UpdateIotSecuritySolutionData.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar user_defined_resources: Properties of the IoT Security solution's user defined resources.
    :vartype user_defined_resources:
     ~azure.mgmt.security.v2019_08_01.models.UserDefinedResourcesProperties
    :ivar recommendations_configuration: List of the configuration status for each recommendation
     type.
    :vartype recommendations_configuration:
     list[~azure.mgmt.security.v2019_08_01.models.RecommendationConfigurationProperties]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "user_defined_resources": {"key": "properties.userDefinedResources", "type": "UserDefinedResourcesProperties"},
        "recommendations_configuration": {
            "key": "properties.recommendationsConfiguration",
            "type": "[RecommendationConfigurationProperties]",
        },
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        user_defined_resources: Optional["_models.UserDefinedResourcesProperties"] = None,
        recommendations_configuration: Optional[List["_models.RecommendationConfigurationProperties"]] = None,
        **kwargs
    ):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword user_defined_resources: Properties of the IoT Security solution's user defined
         resources.
        :paramtype user_defined_resources:
         ~azure.mgmt.security.v2019_08_01.models.UserDefinedResourcesProperties
        :keyword recommendations_configuration: List of the configuration status for each
         recommendation type.
        :paramtype recommendations_configuration:
         list[~azure.mgmt.security.v2019_08_01.models.RecommendationConfigurationProperties]
        """
        super().__init__(tags=tags, **kwargs)
        self.user_defined_resources = user_defined_resources
        self.recommendations_configuration = recommendations_configuration


class UserDefinedResourcesProperties(_serialization.Model):
    """Properties of the IoT Security solution's user defined resources.

    All required parameters must be populated in order to send to Azure.

    :ivar query: Azure Resource Graph query which represents the security solution's user defined
     resources. Required to start with "where type != "Microsoft.Devices/IotHubs"". Required.
    :vartype query: str
    :ivar query_subscriptions: List of Azure subscription ids on which the user defined resources
     query should be executed. Required.
    :vartype query_subscriptions: list[str]
    """

    _validation = {
        "query": {"required": True},
        "query_subscriptions": {"required": True},
    }

    _attribute_map = {
        "query": {"key": "query", "type": "str"},
        "query_subscriptions": {"key": "querySubscriptions", "type": "[str]"},
    }

    def __init__(self, *, query: str, query_subscriptions: List[str], **kwargs):
        """
        :keyword query: Azure Resource Graph query which represents the security solution's user
         defined resources. Required to start with "where type != "Microsoft.Devices/IotHubs"".
         Required.
        :paramtype query: str
        :keyword query_subscriptions: List of Azure subscription ids on which the user defined
         resources query should be executed. Required.
        :paramtype query_subscriptions: list[str]
        """
        super().__init__(**kwargs)
        self.query = query
        self.query_subscriptions = query_subscriptions
