/**********************************************************************
 * $vpi_util_test example -- PLI application using VPI routines
 *
 * A set of tests for the VPI utility applications shown in this book.
 * Only the routines to access arguments of system tasks are tested in
 * this file.  Other utility applications are tested separately.
 *
 * Usage: initial $vpi_util_test();
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *********************************************************************/

#include <stdlib.h>    /* ANSI C standard library */
#include <stdio.h>     /* ANSI C standard input/output library */
#include "vpi_user.h"  /* IEEE 1364 PLI VPI routine library  */

/* prototypes of the PLI application routines */
int PLIbook_UtilTestCall();

/**********************************************************************
 * VPI Registration Data
 *********************************************************************/
void PLIbook_UtilTest_register()
{
  s_vpi_systf_data tf_data;
  tf_data.type      = vpiSysTask;
  tf_data.tfname    = "$vpi_util_test";
  tf_data.calltf    = PLIbook_UtilTestCall;
  tf_data.compiletf = NULL;
  tf_data.sizetf    = NULL;
  vpi_register_systf(&tf_data);
}
/**********************************************************************/

#include "vpi_utilities.c"  /* include the VPI utility applications */

/**********************************************************************
 * calltf routine to exercise various utility functions.
 *********************************************************************/
int PLIbook_UtilTestCall()
{
  int num_args, int1;
  double real1;
  char *string1;
  vpiHandle arg0_h, arg1_h, arg2_h, arg3_h, arg4_h, arg5_h, arg6_h;

  vpi_printf("\n*** Testing Utility Apps With Good Values ***\n");

  /* test PLIbook_numargs_vpi() */
  vpi_printf("\n  Testing PLIbook_numargs_vpi()...\n");
  num_args = PLIbook_numargs_vpi();
  vpi_printf("    Number of args found = %d:  EXPECTED 5\n", num_args);

  /* test PLIbook_getarg_handle_vpi() */
  vpi_printf("\n  Testing PLIbook_getarg_handle_vpi()...\n");
  arg1_h = PLIbook_getarg_handle_vpi(1);
  vpi_printf("    Handle to arg 1 is %s:  EXPECTED i1\n", 
             vpi_get_str(vpiName, arg1_h));
  arg3_h = PLIbook_getarg_handle_vpi(3);
  vpi_printf("    Handle to arg 3 is %s:  EXPECTED ci\n", 
             vpi_get_str(vpiName, arg3_h));
  
  /* test PLIbook_getarg_intval_vpi() */
  vpi_printf("\n  Testing PLIbook_getarg_intval_vpi()...\n");
  int1 = PLIbook_getarg_intval_vpi(3);
  vpi_printf("    Value of arg 3 is %d:  EXPECTED 1\n", int1);

  /* test PLIbook_getarg_realval_vpi() */
  vpi_printf("\n  Testing PLIbook_getarg_realval_vpi()...\n");
  real1 = PLIbook_getarg_realval_vpi(2);
  vpi_printf("    Value of arg 2 is %1.1f:  EXPECTED 0.5\n", real1);

  /* test PLIbook_getarg_stringval_vpi() */
  vpi_printf("\n  Testing PLIbook_getarg_stringval_vpi()...\n");
  string1 = PLIbook_getarg_stringval_vpi(4);
  vpi_printf("    Value of arg 4 is %s:  EXPECTED Hello world\n", string1);

  /* test PLIbook_vpi_get_str() */
  vpi_printf("\n  Testing PLIbook_vpi_get_str()...\n");
  arg1_h = PLIbook_getarg_handle_vpi(1);
  string1 = PLIbook_vpi_get_str(vpiFullName, arg1_h);
  vpi_printf("    Full name of arg 1 is %s:  EXPECTED test.i1\n", string1);
  

  vpi_printf("\n*** Testing Utility Routines With Bad Values ***\n");

  /* test PLIbook_getarg_handle_vpi() */
  vpi_printf("\n  Testing PLIbook_getarg_handle_vpi() with out-of-range index...\n");
  arg0_h = PLIbook_getarg_handle_vpi(0);
  vpi_printf("    Handle to arg 0 is %d:  EXPECTED 0 (NULL)\n", 
             arg0_h);
  arg6_h = PLIbook_getarg_handle_vpi(6);
  vpi_printf("    Handle to arg 6 is %d:  EXPECTED 0 (NULL)\n", 
             arg6_h); 
  
  /* test PLIbook_getarg_intval_vpi() */
  vpi_printf("\n  Testing PLIbook_getarg_intval_vpi() on a string...\n");
  int1 = PLIbook_getarg_intval_vpi(4);
  vpi_printf("    Value of arg 4 is %d:  EXPECTED 0\n", int1);

  /* test PLIbook_getarg_realval_vpi() */
  vpi_printf("\n  Testing PLIbook_getarg_realval_vpi() on a module instance...\n");
  real1 = PLIbook_getarg_realval_vpi(1);
  vpi_printf("    Value of arg 1 is %1.1f:  EXPECTED 0.0\n", real1);

  /* test PLIbook_getarg_stringval_vpi() */
  vpi_printf("\n  Testing PLIbook_getarg_stringval_vpi() on a real number...\n");
  string1 = PLIbook_getarg_stringval_vpi(2);
  vpi_printf("    Value of arg 2 is %s:  EXPECTED <null string>\n", string1);

  /* test PLIbook_vpi_get_str() */
  vpi_printf("\n  Testing PLIbook_vpi_get_str() with NULL object handle...\n");
  string1 = PLIbook_vpi_get_str(vpiFullName, NULL);
  vpi_printf("    Full name of NULL is %s:  EXPECTED <null string>\n", string1);

  vpi_printf("\n*** All Tests Completed ***\n\n");
}
/*********************************************************************/
