/**********************************************************************
 * $count_loads example -- C source code using ACC PLI routines
 *
 * C source to count the number of loads on an output port and return
 * the count back to simulation.
 *
 * For the book, "The Verilog PLI Handbook" by Stuart Sutherland
 *  Book copyright 1999, Kluwer Academic Publishers, Norwell, MA, USA
 *   Contact: www.wkap.il
 *  Example copyright 1998, Sutherland HDL Inc, Portland, Oregon, USA
 *   Contact: www.sutherland.com or (503) 692-0898
 *
 * Usage: count = $count_loads(<module_port_name>);
 *
 * Routine definitions for a veriusertfs array:
 *  /* routine prototypes -/
 *   extern int PLIbook_CountLoads_checktf(),
 *              PLIbook_CountLoads_sizetf(),
 *              PLIbook_CountLoads_calltf();
 *  /* table entries -/
 *   {userfunction,                   /* type of PLI routine -/
 *     0,                             /* user_data value -/
 *     PLIbook_CountLoads_checktf,    /* checktf routine -/
 *     PLIbook_CountLoads_sizetf,     /* sizetf routine -/
 *     PLIbook_CountLoads_calltf,     /* calltf routine -/
 *     0,                             /* misctf routine -/
 *     "$count_loads",                /* system task/function name -/
 *     1                              /* forward reference = true -/
 *   },
 *********************************************************************/

#include "veriuser.h"         /* IEEE 1364 PLI TF  routine library */
#include "acc_user.h"         /* IEEE 1364 PLI ACC routine library */
/**********************************************************************
 * Sizetf application
 *********************************************************************/
int PLIbook_CountLoads_sizetf()
{
  return(0);
}

/**********************************************************************
 * checktf routine
 *********************************************************************/
int PLIbook_CountLoads_checktf()
{
  static int valid_args[4] = {accNet, accReg, accRegBit, 0};
  int    direction;
  handle tfarg_h, port_h;
  
  acc_initialize();
  if (tf_nump() != 1)
    tf_error("$count_loads must have 1 argument.");
  else if (tf_typep(1) == TF_NULLPARAM)
    tf_error("$count_loads arg cannot be null.");
  /* acc_handle_tfarg() returns a loconn handle, not a port handle */
  else if (tf_sizep(1) != 1)
    tf_error("$count_loads arg must be scalar or a bit-select.");
  else {
    tfarg_h = acc_handle_tfarg(1);
    if (!acc_object_in_typelist(tfarg_h, valid_args)) {
      tf_error("$count_loads arg must be a net or reg signal");
      return(0);
    }
    port_h = acc_next_port(tfarg_h, null);
    if (port_h == null) {
      tf_error("$count_loads arg is not connected to a module port.");
      return(0);
    }
    direction = acc_fetch_direction(port_h);
    if (   direction != accOutput
        && direction != accInout)
      tf_error("$count_loads arg must be an output or inout port.");
  }
  acc_close();
  return(0);
}

/**********************************************************************
 * calltf routine
 *********************************************************************/
int PLIbook_CountLoads_calltf()
{
  handle loconn_h, port_h, hiconn_h;
  int    load_count;

  acc_initialize();
  acc_configure(accDisplayWarnings, "true");

  /* acc_handle_tfarg() returns a loconn handle, not a port handle */
  loconn_h = acc_handle_tfarg(1);
  port_h = acc_next_port(loconn_h, null);
  hiconn_h = acc_handle_hiconn(port_h);
  load_count = acc_count(acc_next_cell_load, hiconn_h);
  tf_putp(0, load_count);
  acc_close();
  return(0);
}
/*********************************************************************/
