
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2455197.3,
          {-3.3045,0.09176,184.503,0.04687,0.002502,1.6943}, /*cmx*/
          {-0.855987,-0.7633,-5.1251,-4.6456}, /*cfx*/
          {0.0201,0.00878,17.9808,0.09555,0.000708,0.1854}, /*cmy*/
          {-0.187613,-0.2481,-3.179,-4.0281}, /*cfy*/
          {4.6108,0.01233,184.9099,0.11145,0.000744,1.7723}, /*cmz*/
          {-5.570261,-3.8754,-4.5001,-3.1366} /*cfz*/
     },
     {
          2455252.3,
          {1.9852,0.06318,184.3834,0.26123,0.001458,1.6599}, /*cmx*/
          {-4.841713,-3.3164,-0.3396,-1.0407}, /*cfx*/
          {0.529,0.00108,21.1503,0.02686,0.000551,0.1909}, /*cmy*/
          {-4.240152,-5.3642,-1.5805,-0.5262}, /*cfy*/
          {5.1798,-0.07021,185.3032,0.32296,0.002459,1.6948}, /*cmz*/
          {-3.269793,-1.6254,-4.6232,-5.7506} /*cfz*/
     },
     {
          2455307.3,
          {5.5163,-0.02564,184.4628,0.08421,0.002666,1.7539}, /*cmx*/
          {-2.525523,-1.5065,-4.3808,-3.7818}, /*cfx*/
          {0.5947,-0.00934,20.3945,0.04453,0.000697,0.183}, /*cmy*/
          {-2.004477,-5.2784,-0.2044,-3.2049}, /*cfy*/
          {1.0393,-0.09017,186.0407,0.15412,0.003626,1.6613}, /*cmz*/
          {-0.954364,-5.101,-2.0804,-2.1846} /*cfz*/
     },
     {
          2455362.3,
          {3.8595,-0.07923,184.6067,0.25563,0.001675,1.711}, /*cmx*/
          {-0.282915,-1.6826,-2.4727,-0.3231}, /*cfx*/
          {0.0338,-0.00894,17.7036,0.09434,0.000407,0.1604}, /*cmy*/
          {-5.894648,-3.7674,-5.8492,-5.7232}, /*cfy*/
          {-4.0092,-0.02665,186.1492,0.29649,0.000784,1.6222}, /*cmz*/
          {-4.990995,-0.5017,-5.5535,-5.0467} /*cfz*/
     },
     {
          2455417.3,
          {-0.6276,-0.0718,184.5316,0.41134,0.001566,1.6878}, /*cmx*/
          {-4.401694,-5.8069,-1.1797,-3.1879}, /*cfx*/
          {-0.4652,-0.00068,16.833,0.06389,0.000867,0.1668}, /*cmy*/
          {-3.367805,-2.1576,-4.1715,-2.0065}, /*cfy*/
          {-5.4483,0.03995,185.3855,0.48941,0.001635,1.6837}, /*cmz*/
          {-2.823457,-4.4754,-1.1836,-1.5828} /*cfz*/
     },
     {
          2455472.3,
          {-4.6772,-0.01217,184.8536,0.31701,0.00033,1.7029}, /*cmx*/
          {-2.265106,-3.7909,-5.7761,-6.0461}, /*cfx*/
          {-0.5058,0.00743,19.9056,0.10935,0.000434,0.2104}, /*cmy*/
          {-1.035863,-1.3364,-2.1134,-4.8614}, /*cfy*/
          {-3.1015,0.08165,184.3065,0.43123,0.002542,1.7025}, /*cmz*/
          {-0.683308,-2.2057,-4.9842,-4.428} /*cfz*/
     },
     {
          2455527.3,
          {-5.3097,0.05395,185.4103,0.13762,0.001232,1.6704}, /*cmx*/
          {-0.097053,-1.8509,-5.2954,-2.4748}, /*cfx*/
          {-0.0861,0.01332,26.3832,0.163,0.000706,0.284}, /*cmy*/
          {-5.166875,-5.5084,-2.5906,-1.3385}, /*cfy*/
          {1.5183,0.06365,183.6531,0.19846,0.002386,1.6908}, /*cmz*/
          {-4.796902,-0.1048,-3.119,-0.9144} /*cfz*/
     },
     {
          2455582.3,
          {-2.185,0.09522,185.8321,0.13192,0.001921,1.7003}, /*cmx*/
          {-4.14246,-1.9129,-3.4017,-5.1789}, /*cfx*/
          {0.7253,0.00588,33.0281,0.09361,0.001242,0.3254}, /*cmy*/
          {-2.961096,-2.8849,-0.0312,-4.003}, /*cfy*/
          {5.2056,-0.00984,182.8233,0.06512,0.001937,1.7309}, /*cmz*/
          {-2.555258,-1.3999,-0.6313,-3.6049} /*cfz*/
     },
     {
          2455637.3,
          {3.2779,0.04137,185.7204,0.21873,0.000979,1.6868}, /*cmx*/
          {-1.831411,-0.0329,-2.5193,-1.5753}, /*cfx*/
          {1.0208,-0.0123,34.5584,0.05303,0.000383,0.2947}, /*cmy*/
          {-0.665448,-4.5807,-4.1502,-0.3563}, /*cfy*/
          {4.489,-0.08393,182.4947,0.20933,0.001126,1.6506}, /*cmz*/
          {-0.24617,-5.1093,-2.3768,-6.265} /*cfz*/
     },
     {
          2455692.3,
          {5.5638,-0.04482,185.53,0.04745,0.00218,1.7478}, /*cmx*/
          {-5.803979,-3.2952,-0.7923,-4.2757}, /*cfx*/
          {0.2862,-0.01624,31.4865,0.08369,0.000314,0.2727}, /*cmy*/
          {-4.611875,-2.2896,-5.1732,-3.0615}, /*cfy*/
          {-0.358,-0.07946,182.2727,0.09418,0.003068,1.6467}, /*cmz*/
          {-4.222158,-3.9704,-0.0718,-2.7261} /*cfz*/
     },
     {
          2455747.3,
          {2.8729,-0.08494,185.4811,0.28252,0.001058,1.7057}, /*cmx*/
          {-3.570792,-5.1309,-5.5612,-0.8474}, /*cfx*/
          {-0.6358,-0.00468,29.2707,0.0633,0.00114,0.2705}, /*cmy*/
          {-2.257373,-0.5172,-3.3074,-5.8023}, /*cfy*/
          {-4.8203,-0.00589,182.337,0.19773,0.003183,1.6482}, /*cmz*/
          {-1.998443,-3.2542,-3.9684,-5.5752} /*cfz*/
     },
     {
          2455802.3,
          {-1.9064,-0.0583,185.6424,0.42815,0.000572,1.6867}, /*cmx*/
          {-1.410106,-3.0158,-5.6521,-3.7226}, /*cfx*/
          {-0.8748,0.00598,30.3796,0.05553,0.001219,0.2893}, /*cmy*/
          {-6.266913,-0.4437,-1.0044,-2.2438}, /*cfy*/
          {-5.0686,0.05407,182.876,0.32216,0.001225,1.6398}, /*cmz*/
          {-6.125137,-1.4235,-1.6817,-2.098} /*cfz*/
     },
     {
          2455857.3,
          {-5.2415,0.00548,185.5542,0.43613,0.002684,1.7608}, /*cmx*/
          {-5.549204,-0.8143,-3.7487,-0.2787}, /*cfx*/
          {-0.5423,0.01594,35.2803,0.15857,0.000543,0.3446}, /*cmy*/
          {-4.131449,-4.8899,-3.7631,-5.1365}, /*cfy*/
          {-1.9354,0.0817,182.8663,0.33076,0.001648,1.6318}, /*cmz*/
          {-3.979978,-5.8464,-3.1596,-4.9486} /*cfz*/
     },
     {
          2455912.3,
          {-4.8549,0.06867,185.0262,0.23803,0.003455,1.6933}, /*cmx*/
          {-3.373684,-4.8444,-1.6351,-3.0103}, /*cfx*/
          {0.3823,0.01808,43.343,0.16813,0.001299,0.4253}, /*cmy*/
          {-1.995208,-2.4166,-6.1862,-1.6226}, /*cfy*/
          {2.6946,0.04657,181.237,0.20128,0.003056,1.629}, /*cmz*/
          {-1.795323,-3.7977,-0.5253,-1.4284} /*cfz*/
     },
     {
          2455967.3,
          {-0.8401,0.08991,184.4113,0.13348,0.001981,1.6641}, /*cmx*/
          {-1.128461,-0.2011,-4.9785,-5.6896}, /*cfx*/
          {1.4388,-0.00392,49.8069,0.06801,0.001191,0.4979}, /*cmy*/
          {-6.028473,-5.2887,-3.4325,-4.2497}, /*cfy*/
          {5.3708,-0.03039,179.2641,0.12248,0.001685,1.7562}, /*cmz*/
          {-5.828411,-3.741,-4.8482,-4.0774} /*cfz*/
     },
     {
          2456022.3,
          {4.326,0.01963,184.5047,0.32726,0.0033,1.6552}, /*cmx*/
          {-5.10058,-3.6636,-0.5823,-2.0976}, /*cfx*/
          {1.1451,-0.02504,49.8029,0.12028,0.000369,0.4588}, /*cmy*/
          {-3.684073,-1.4884,-5.8866,-0.6247}, /*cfy*/
          {3.4612,-0.08933,179.1555,0.23774,0.001881,1.6853}, /*cmz*/
          {-3.51615,-1.9145,-4.8818,-0.4835} /*cfz*/
     },
     {
          2456077.3,
          {5.2776,-0.06122,185.0346,0.09723,0.004105,1.7122}, /*cmx*/
          {-2.796583,-1.5902,-4.4714,-4.7806}, /*cfx*/
          {-0.2854,-0.01704,45.7091,0.11181,0.001048,0.3997}, /*cmy*/
          {-1.327455,-5.1035,-2.144,-3.3053}, /*cfy*/
          {-1.6636,-0.06353,180.4422,0.03214,0.002603,1.6042}, /*cmz*/
          {-1.215558,-4.5145,-2.5174,-3.2442} /*cfz*/
     },
     {
          2456132.3,
          {1.6556,-0.08437,185.6536,0.23413,0.0022,1.6912}, /*cmx*/
          {-0.573958,-2.2565,-1.9896,-1.3428}, /*cfx*/
          {-1.2205,0.00165,43.0239,0.04837,0.000947,0.3965}, /*cmy*/
          {-5.317613,-1.0898,-6.069,-6.1498}, /*cfy*/
          {-5.2201,0.0118,181.0859,0.36992,0.000546,1.661}, /*cmz*/
          {-5.276618,-0.6097,-2.9257,-6.1281} /*cfz*/
     },
     {
          2456187.3,
          {-3.059,-0.04343,185.9034,0.43323,0.000741,1.661}, /*cmx*/
          {-4.699763,-0.0675,-3.3978,-4.225}, /*cfx*/
          {-1.1126,0.01317,44.0953,0.1762,0.000394,0.4238}, /*cmy*/
          {-3.15181,-4.2798,-2.9882,-2.7581}, /*cfy*/
          {-4.4329,0.06423,180.1106,0.49043,0.002373,1.626}, /*cmz*/
          {-3.120716,-4.6929,-1.0407,-2.6699} /*cfz*/
     },
     {
          2456242.3,
          {-5.5073,0.02271,185.7516,0.367,0.002082,1.7663}, /*cmx*/
          {-2.557346,-4.2526,-1.2839,-0.7668}, /*cfx*/
          {-0.3793,0.02519,50.0137,0.24453,0.001054,0.5024}, /*cmy*/
          {-1.060931,-1.7357,-5.1558,-5.6176}, /*cfy*/
          {-0.744,0.07743,177.739,0.36769,0.002758,1.6021}, /*cmz*/
          {-0.976539,-2.4564,-5.0136,-5.4647} /*cfz*/
     },
     {
          2456297.3,
          {-4.131,0.08051,185.7037,0.12803,0.002432,1.7151}, /*cmx*/
          {-0.374903,-2.1351,-5.2762,-3.511}, /*cfx*/
          {1.0904,0.0153,58.9036,0.16995,0.001525,0.5694}, /*cmy*/
          {-5.182294,-5.2247,-2.5895,-2.049}, /*cfy*/
          {3.6455,0.02808,175.1322,0.07595,0.001194,1.5825}, /*cmz*/
          {-5.077509,-0.4157,-3.1665,-1.9339} /*cfz*/
     },
     {
          2456352.3,
          {0.4797,0.0817,186.1397,0.17906,0.001407,1.6964}, /*cmx*/
          {-4.397711,-2.4741,-3.602,-6.1614}, /*cfx*/
          {1.9699,-0.01798,64.2917,0.13728,0.001355,0.5941}, /*cmy*/
          {-2.890973,-1.6023,-5.896,-4.6209}, /*cfy*/
          {5.2254,-0.04752,173.6488,0.18937,0.000283,1.626}, /*cmz*/
          {-2.820776,-1.383,-5.2611,-4.58} /*cfz*/
     },
     {
          2456407.3,
          {5.136,-0.00536,186.2551,0.17515,0.000805,1.7081}, /*cmx*/
          {-2.071517,-0.2905,-3.1346,-2.5938}, /*cfx*/
          {0.8416,-0.03238,62.7603,0.17775,0.001158,0.5474}, /*cmy*/
          {-0.524198,-4.6572,-2.077,-0.973}, /*cfy*/
          {2.3351,-0.09129,174.5399,0.25367,0.002638,1.6168}, /*cmz*/
          {-0.504238,-5.3073,-1.9875,-0.9925} /*cfz*/
     },
     {
          2456462.3,
          {4.6828,-0.07393,185.7243,0.11326,0.001072,1.6638}, /*cmx*/
          {-6.054875,-1.3801,-1.5966,-5.3209}, /*cfx*/
          {-0.9698,-0.01231,57.616,0.0955,0.001392,0.5016}, /*cmy*/
          {-4.465319,-1.7003,-5.5674,-3.7099}, /*cfy*/
          {-2.8092,-0.04587,176.1658,0.05453,0.002507,1.6044}, /*cmz*/
          {-4.492779,-5.0984,-6.2641,-3.7528} /*cfz*/
     },
     {
          2456517.3,
          {0.4172,-0.08055,184.8419,0.39401,0.001877,1.6743}, /*cmx*/
          {-3.844641,-5.2311,-0.6595,-1.8695}, /*cfx*/
          {-1.6363,0.00835,54.5824,0.0914,0.001416,0.5139}, /*cmy*/
          {-2.240161,-3.9369,-3.2087,-0.3071}, /*cfy*/
          {-5.3439,0.02933,177.1154,0.25429,0.001713,1.6619}, /*cmz*/
          {-2.285411,-3.8619,-4.0835,-0.3334} /*cfz*/
     },
     {
          2456572.3,
          {-4.0949,-0.02526,184.6603,0.4091,0.001492,1.683}, /*cmx*/
          {-1.701166,-3.1167,-4.8023,-4.7408}, /*cfx*/
          {-1.1639,0.02162,56.9724,0.19885,0.000659,0.5305}, /*cmy*/
          {-0.130119,-1.2152,-0.2192,-3.2032}, /*cfy*/
          {-3.5803,0.0714,176.8633,0.35819,9.5e-05,1.582}, /*cmz*/
          {-0.133742,-1.889,-5.5534,-3.1841} /*cfz*/
     },
     {
          2456627.3,
          {-5.5275,0.03939,185.0912,0.31464,0.00152,1.751}, /*cmx*/
          {-5.842541,-1.01,-3.7933,-1.2442}, /*cfx*/
          {0.0608,0.02997,64.8036,0.19915,0.001361,0.6144}, /*cmy*/
          {-4.304506,-5.0678,-2.7823,-6.0278}, /*cfy*/
          {0.4521,0.06715,174.7445,0.34025,0.00227,1.5529}, /*cmz*/
          {-4.266642,-6.2652,-3.3047,-5.9889} /*cfz*/
     },
     {
          2456682.3,
          {-3.1916,0.08858,185.4015,0.07332,0.00218,1.7112}, /*cmx*/
          {-3.650583,-5.2392,-2.1237,-3.997}, /*cfx*/
          {1.8287,0.00599,72.936,0.10615,0.00202,0.6883}, /*cmy*/
          {-2.091245,-2.1627,-6.248,-2.4508}, /*cfy*/
          {4.2867,0.00979,171.3857,0.19892,0.003681,1.5575}, /*cmz*/
          {-2.071996,-4.0987,-0.7677,-2.4635} /*cfz*/
     },
     {
          2456737.3,
          {1.9207,0.06406,185.185,0.21262,0.000647,1.7004}, /*cmx*/
          {-1.376748,-6.2104,-4.9931,-0.3939}, /*cfx*/
          {2.1221,-0.03097,75.7564,0.13138,0.000941,0.7001}, /*cmy*/
          {-6.053488,-4.2915,-3.2406,-4.9814}, /*cfy*/
          {4.8266,-0.06199,169.6028,0.09208,0.001869,1.5655}, /*cmz*/
          {-6.091083,-4.4388,-4.711,-5.0509} /*cfz*/
     },
     {
          2456792.3,
          {5.5493,-0.02756,184.9728,0.30897,0.003839,1.7494}, /*cmx*/
          {-5.335797,-3.7664,-0.583,-3.1017}, /*cfx*/
          {0.2723,-0.03356,72.2841,0.14986,0.000994,0.6627}, /*cmy*/
          {-3.684959,-1.3725,-5.3662,-1.346}, /*cfy*/
          {1.137,-0.08635,170.6602,0.17898,0.001639,1.5884}, /*cmz*/
          {-3.771185,-2.6603,-5.8936,-1.4596} /*cfz*/
     },
     {
          2456847.3,
          {3.7805,-0.08203,185.4177,0.0194,0.003938,1.657}, /*cmx*/
          {-3.048255,-0.5731,-4.5092,-5.8194}, /*cfx*/
          {-1.5784,-0.00542,66.6734,0.07882,0.001545,0.5918}, /*cmy*/
          {-1.379379,-4.2371,-2.5961,-4.1682}, /*cfy*/
          {-3.761,-0.02563,172.7511,0.08471,0.002827,1.568}, /*cmz*/
          {-1.485085,-2.0615,-3.4602,-4.2731} /*cfz*/
     },
     {
          2456902.3,
          {-0.8953,-0.07007,186.2405,0.31534,0.001843,1.6355}, /*cmx*/
          {-0.847634,-2.668,-1.7534,-2.3779}, /*cfx*/
          {-1.8646,0.01459,64.4475,0.18829,0.00064,0.6245}, /*cmy*/
          {-5.48593,-0.6244,-6.2369,-0.7924}, /*cfy*/
          {-5.1538,0.04287,173.7168,0.32167,0.001648,1.6448}, /*cmz*/
          {-5.565036,-0.751,-1.9666,-0.8264} /*cfz*/
     },
     {
          2456957.3,
          {-4.8182,-0.00803,186.5677,0.51197,0.002425,1.6478}, /*cmx*/
          {-4.982901,-0.4189,-3.7226,-5.288}, /*cfx*/
          {-1.0223,0.03012,68.3034,0.26319,0.000871,0.6756}, /*cmy*/
          {-3.391329,-4.3956,-1.7014,-3.6859}, /*cfy*/
          {-2.5846,0.07277,172.1542,0.39689,0.0011,1.5841}, /*cmz*/
          {-3.41695,-5.0748,-0.9737,-3.6783} /*cfz*/
     },
     {
          2457012.3,
          {-5.2527,0.05381,185.9143,0.40705,0.003873,1.703}, /*cmx*/
          {-2.835352,-4.493,-1.3298,-1.7474}, /*cfx*/
          {0.71,0.02946,76.123,0.20233,0.001801,0.7391}, /*cmy*/
          {-1.255526,-1.7808,-5.2648,-0.1873}, /*cfy*/
          {1.5141,0.05558,168.5796,0.31328,0.001822,1.5314}, /*cmz*/
          {-1.271547,-2.9502,-5.7727,-0.2076} /*cfz*/
     },
     {
          2457067.3,
          {-2.0914,0.09078,185.2122,0.0914,0.003192,1.7239}, /*cmx*/
          {-0.634385,-1.8935,-5.1216,-4.4553}, /*cfx*/
          {2.4083,-0.00737,82.1388,0.12213,0.001143,0.7828}, /*cmy*/
          {-5.297972,-4.3069,-2.4053,-2.8854}, /*cfy*/
          {4.6819,-0.0065,165.8403,0.02852,0.001291,1.5619}, /*cmz*/
          {-5.366748,-1.2324,-4.1849,-2.9716} /*cfz*/
     },
     {
          2457122.3,
          {3.1056,0.04606,185.1386,0.24881,0.000298,1.6682}, /*cmx*/
          {-4.634053,-3.0653,-0.6493,-0.8389}, /*cfx*/
          {1.898,-0.04008,82.6867,0.21274,0.001292,0.7359}, /*cmy*/
          {-2.96194,-1.1182,-4.9285,-5.4481}, /*cfy*/
          {4.222,-0.07254,166.3164,0.26595,0.001,1.5387}, /*cmz*/
          {-3.094978,-1.6053,-4.2699,-5.5895} /*cfz*/
     },
     {
          2457177.3,
          {5.653,-0.04807,185.2133,0.16855,0.002063,1.744}, /*cmx*/
          {-2.302412,-0.8405,-4.0867,-3.5487}, /*cfx*/
          {-0.4299,-0.02947,78.4863,0.18554,0.002278,0.6857}, /*cmy*/
          {-0.605412,-4.5203,-1.8113,-1.8082}, /*cfy*/
          {-0.0406,-0.07898,169.101,0.2621,0.003358,1.55}, /*cmz*/
          {-0.766535,-5.4297,-2.021,-1.9719} /*cfz*/
     },
     {
          2457232.3,
          {2.7311,-0.08565,184.9671,0.16762,0.001959,1.7154}, /*cmx*/
          {-0.022972,-1.342,-2.1134,-0.0614}, /*cfx*/
          {-2.0158,0.0014,73.6291,0.1317,0.001645,0.6362}, /*cmy*/
          {-4.617675,-0.6474,-5.3018,-4.6495}, /*cfy*/
          {-4.427,-0.00652,171.4656,0.11463,0.001547,1.5049}, /*cmz*/
          {-4.761114,-0.3317,-6.0684,-4.7806} /*cfz*/
     },
     {
          2457287.3,
          {-2.0943,-0.05843,184.5248,0.4224,0.001986,1.6774}, /*cmx*/
          {-4.119913,-5.4928,-0.8333,-2.9035}, /*cfx*/
          {-1.9408,0.0224,73.0069,0.24003,0.000807,0.6828}, /*cmy*/
          {-2.473869,-3.8889,-2.0611,-1.2524}, /*cfy*/
          {-4.7076,0.05342,171.2048,0.37723,0.000306,1.5562}, /*cmz*/
          {-2.563103,-4.3071,-0.3536,-1.3172} /*cfz*/
     },
     {
          2457342.3,
          {-5.3534,0.01003,184.5977,0.37441,0.001076,1.6817}, /*cmx*/
          {-1.988246,-3.4252,-4.9539,-5.7748}, /*cfx*/
          {-0.6576,0.03651,78.1807,0.24981,0.001421,0.7504}, /*cmy*/
          {-0.369074,-1.3687,-4.7979,-4.1332}, /*cfy*/
          {-1.6135,0.07213,168.3482,0.44928,0.001624,1.5547}, /*cmz*/
          {-0.421131,-2.1352,-4.8568,-4.1851} /*cfz*/
     },
     {
          2457397.3,
          {-4.738,0.06679,185.2747,0.20903,0.001039,1.6747}, /*cmx*/
          {-6.123643,-1.4324,-4.7052,-2.2297}, /*cfx*/
          {1.4363,0.02188,84.8759,0.1051,0.001545,0.7879}, /*cmy*/
          {-4.480479,-5.0361,-2.4079,-0.5936}, /*cfy*/
          {2.4224,0.04275,165.1476,0.32392,0.002388,1.5112}, /*cmz*/
          {-4.564216,-0.0135,-3.1671,-0.7169} /*cfz*/
     },
     {
          2457452.3,
          {-0.8801,0.08882,185.6207,0.08554,0.001912,1.7007}, /*cmx*/
          {-3.908111,-1.4609,-2.9964,-4.9437}, /*cfx*/
          {2.6971,-0.02162,87.6431,0.07189,0.001314,0.8212}, /*cmy*/
          {-2.207285,-0.666,-6.1926,-3.2473}, /*cfy*/
          {4.9171,-0.02216,164.0421,0.09351,0.003121,1.5563}, /*cmz*/
          {-2.365688,-3.6001,-0.725,-3.4408} /*cfz*/
     },
     {
          2457507.3,
          {4.2008,0.02166,185.404,0.24736,0.000633,1.689}, /*cmx*/
          {-1.607705,-6.1382,-1.5709,-1.3362}, /*cfx*/
          {1.365,-0.04266,85.5043,0.14868,0.000657,0.7634}, /*cmy*/
          {-6.149405,-4.1106,-2.1462,-5.8524}, /*cfy*/
          {3.5424,-0.08239,165.208,0.20151,0.00089,1.4991}, /*cmz*/
          {-0.077471,-5.0896,-4.0072,-6.0716} /*cfz*/
     },
     {
          2457562.3,
          {5.3533,-0.06417,185.1565,0.19164,0.002972,1.7752}, /*cmx*/
          {-5.561553,-3.8022,-0.5976,-4.0086}, /*cfx*/
          {-1.0641,-0.02319,80.7707,0.06548,0.001226,0.7127}, /*cmy*/
          {-3.817102,-0.9372,-5.4053,-2.2618}, /*cfy*/
          {-1.242,-0.06576,166.8653,0.19031,0.002619,1.5036}, /*cmz*/
          {-4.0257,-3.0418,-6.2481,-2.468} /*cfz*/
     },
     {
          2457617.3,
          {1.5547,-0.08492,185.4358,0.15974,0.002195,1.7129}, /*cmx*/
          {-3.294535,-4.9779,-4.7881,-0.5397}, /*cfx*/
          {-2.3277,0.00929,77.2759,0.13114,0.001254,0.7032}, /*cmy*/
          {-1.592792,-2.9968,-3.1536,-5.15}, /*cfy*/
          {-4.9113,0.01309,167.7821,0.09532,0.003806,1.5124}, /*cmz*/
          {-1.751919,-2.3678,-3.793,-5.2822} /*cfz*/
     },
     {
          2457672.3,
          {-3.199,-0.04173,185.8581,0.41232,0.000272,1.6557}, /*cmx*/
          {-1.11732,-2.7855,-1.9489,-3.4078}, /*cfx*/
          {-1.8025,0.02961,79.2206,0.22349,0.000297,0.7599}, /*cmy*/
          {-5.751122,-0.5381,-2.0746,-1.7156}, /*cfy*/
          {-4.0715,0.06037,167.3595,0.28517,0.002114,1.5127}, /*cmz*/
          {-5.852428,-1.1903,-1.5461,-1.8023} /*cfz*/
     },
     {
          2457727.3,
          {-5.5701,0.02596,185.8919,0.51129,0.002872,1.7325}, /*cmx*/
          {-5.263008,-0.6031,-3.6226,-6.2789}, /*cfx*/
          {-0.0721,0.03775,84.9775,0.15775,0.000866,0.8037}, /*cmy*/
          {-3.620912,-4.5687,-1.5679,-4.5517}, /*cfy*/
          {-0.5958,0.06753,165.375,0.38315,0.000959,1.4827}, /*cmz*/
          {-3.720429,-5.535,-3.379,-4.673} /*cfz*/
     },
     {
          2457782.3,
          {-4.0276,0.07612,184.9899,0.33223,0.003895,1.6879}, /*cmx*/
          {-3.106179,-4.6705,-1.4217,-2.7384}, /*cfx*/
          {2.0804,0.00898,88.7843,0.01945,0.001224,0.8032}, /*cmy*/
          {-1.413004,-2.331,-5.7014,-1.0102}, /*cfy*/
          {3.1929,0.03089,163.8912,0.30158,0.00301,1.479}, /*cmz*/
          {-1.577889,-3.2769,-0.3269,-1.2055} /*cfz*/
     },
     {
          2457837.3,
          {0.3972,0.07986,183.8489,0.06604,0.002918,1.6605}, /*cmx*/
          {-0.881731,-0.7687,-5.1083,-5.4042}, /*cfx*/
          {2.5589,-0.0311,87.8455,0.13535,0.000118,0.8392}, /*cmy*/
          {-5.410418,-3.349,-0.7348,-3.6616}, /*cfy*/
          {4.987,-0.03835,164.6142,0.0311,0.002243,1.6241}, /*cmz*/
          {-5.651057,-4.1823,-4.3189,-3.897} /*cfz*/
     },
     {
          2457892.3,
          {4.9501,0.00029,183.6483,0.33572,0.002152,1.6381}, /*cmx*/
          {-4.86191,-3.4484,-0.566,-1.8005}, /*cfx*/
          {0.7007,-0.04057,84.5625,0.16349,0.001456,0.78}, /*cmy*/
          {-3.080763,-0.943,-4.2777,-0.036}, /*cfy*/
          {2.6406,-0.08664,166.606,0.30132,0.000963,1.5892}, /*cmz*/
          {-3.345595,-1.7809,-4.7015,-0.2677} /*cfz*/
     },
     {
          2457947.3,
          {4.7964,-0.07643,184.3071,0.19386,0.003923,1.7209}, /*cmx*/
          {-2.534536,-1.2141,-4.2668,-4.4706}, /*cfx*/
          {-1.5716,-0.01568,81.5403,0.0748,0.002034,0.7123}, /*cmy*/
          {-0.77983,-4.0404,-1.7555,-2.7473}, /*cfy*/
          {-2.3365,-0.04983,168.2007,0.21073,0.003269,1.4991}, /*cmz*/
          {-1.006106,-5.4945,-2.3183,-2.9421} /*cfz*/
     },
     {
          2458002.3,
          {0.3125,-0.07961,184.9198,0.16565,0.002887,1.7326}, /*cmx*/
          {-0.27955,-1.7224,-2.0014,-0.9967}, /*cfx*/
          {-2.4228,0.0161,81.0739,0.19712,0.000822,0.7253}, /*cmy*/
          {-4.857711,-0.1438,-4.6328,-5.6592}, /*cfy*/
          {-5.054,0.02836,168.3226,0.23067,0.00087,1.5041}, /*cmz*/
          {-5.017132,-0.6124,-0.0279,-5.8004} /*cfz*/
     },
     {
          2458057.3,
          {-4.0914,-0.02592,185.2202,0.43119,0.000503,1.6719}, /*cmx*/
          {-4.395593,-5.9656,-1.3028,-3.871}, /*cfx*/
          {-1.4918,0.03628,84.1247,0.25316,0.001575,0.7672}, /*cmy*/
          {-2.718666,-3.9832,-0.8773,-2.2127}, /*cfy*/
          {-3.3423,0.064,165.9598,0.48813,0.00133,1.4798}, /*cmz*/
          {-2.843346,-4.5206,-0.9273,-2.3573} /*cfz*/
     },
     {
          2458112.3,
          {-5.525,0.04082,185.0373,0.38473,0.001157,1.7449}, /*cmx*/
          {-2.2643,-3.9094,-0.8249,-0.4504}, /*cfx*/
          {0.6138,0.0326,87.4861,0.15035,0.002054,0.8061}, /*cmy*/
          {-0.558015,-1.7267,-4.6007,-4.9544}, /*cfy*/
          {0.2912,0.0647,163.3792,0.49041,0.002658,1.4882}, /*cmz*/
          {-0.722849,-2.1999,-5.0118,-5.1823} /*cfz*/
     },
     {
          2458167.3,
          {-3.1337,0.08271,184.7661,0.18232,0.002152,1.6929}, /*cmx*/
          {-0.10122,-1.9121,-5.1532,-3.2065}, /*cfx*/
          {2.441,-0.00442,87.1249,0.04131,0.000755,0.7772}, /*cmy*/
          {-4.613931,-2.1329,-1.9457,-1.3866}, /*cfy*/
          {3.9486,0.01685,164.03,0.2263,0.002228,1.5072}, /*cmz*/
          {-4.865095,-6.0125,-2.9237,-1.6891} /*cfz*/
     },
     {
          2458222.3,
          {1.585,0.06862,184.7992,0.14214,0.001945,1.6803}, /*cmx*/
          {-4.145153,-2.0568,-3.2941,-5.8559}, /*cfx*/
          {2.1464,-0.0359,83.4874,0.10465,0.000199,0.766}, /*cmy*/
          {-2.323015,-0.0779,-3.5015,-4.0365}, /*cfy*/
          {4.9274,-0.05498,166.7865,0.14785,0.001716,1.5774}, /*cmz*/
          {-2.633598,-1.6756,-0.3505,-4.3444} /*cfz*/
     },
     {
          2458277.3,
          {5.488,-0.02416,185.2034,0.23876,0.000796,1.6964}, /*cmx*/
          {-1.824781,-0.0367,-1.9659,-2.2631}, /*cfx*/
          {0.0475,-0.03557,80.2288,0.06811,0.000984,0.7441}, /*cmy*/
          {-0.012188,-4.3989,-1.3987,-0.4562}, /*cfy*/
          {1.6038,-0.08825,168.3607,0.32787,0.001759,1.5519}, /*cmz*/
          {-0.310214,-5.0744,-2.1742,-0.7186} /*cfz*/
     },
     {
          2458332.3,
          {3.9808,-0.08427,185.2548,0.04361,0.001771,1.6788}, /*cmx*/
          {-5.781624,-3.692,-0.9174,-4.9411}, /*cfx*/
          {-1.9273,-0.00843,79.4298,0.0735,0.000878,0.732}, /*cmy*/
          {-4.025102,-5.03,-5.6898,-3.2327}, /*cfy*/
          {-3.3734,-0.03065,167.9334,0.13063,0.003057,1.5164}, /*cmz*/
          {-4.255589,-2.8093,-6.0632,-3.4225} /*cfz*/
     },
     {
          2458387.3,
          {-0.8675,-0.07166,184.931,0.32565,0.00126,1.6993}, /*cmx*/
          {-3.538862,-5.0115,-6.2391,-1.472}, /*cfx*/
          {-2.3922,0.0251,81.3661,0.16063,0.000856,0.7743}, /*cmy*/
          {-1.839606,-2.7863,-4.2099,-6.1077}, /*cfy*/
          {-5.0111,0.04229,166.3772,0.15277,0.003176,1.534}, /*cmz*/
          {-2.007745,-3.5921,-3.7683,-6.2629} /*cfz*/
     },
     {
          2458442.3,
          {-4.8431,-0.00711,184.5452,0.44494,0.001417,1.685}, /*cmx*/
          {-1.38441,-2.8654,-4.6423,-4.3575}, /*cfx*/
          {-0.9307,0.03834,85.0687,0.12062,0.000723,0.7738}, /*cmy*/
          {-5.967831,-0.8375,-2.9996,-2.625}, /*cfy*/
          {-2.5458,0.06757,165.3617,0.36785,0.001136,1.4669}, /*cmz*/
          {-6.138586,-1.5314,-0.9826,-2.8312} /*cfz*/
     },
     {
          2458497.3,
          {-5.2538,0.05372,184.3068,0.40481,0.002043,1.7496}, /*cmx*/
          {-5.534381,-0.7747,-3.5597,-0.8908}, /*cfx*/
          {1.2672,0.02158,85.79,0.07725,0.000252,0.7589}, /*cmy*/
          {-3.774072,-0.3126,-1.8364,-5.3599}, /*cfy*/
          {1.2553,0.05852,166.3873,0.37721,0.002207,1.4859}, /*cmz*/
          {-4.017736,-5.6913,-3.1776,-5.6654} /*cfz*/
     },
     {
          2458552.3,
          {-2.1074,0.08546,183.6824,0.17889,0.002676,1.7106}, /*cmx*/
          {-3.36165,-4.8604,-1.7043,-3.6495}, /*cfx*/
          {2.4442,-0.01605,81.5275,0.1501,0.000958,0.707}, /*cmy*/
          {-1.521221,-4.7278,-1.0202,-1.8108}, /*cfy*/
          {4.6089,0.00026,169.3582,0.21761,0.003896,1.5401}, /*cmz*/
          {-1.849221,-3.3712,-0.4074,-2.1641} /*cfz*/
     },
     {
          2458607.3,
          {2.8129,0.05045,183.3557,0.14049,0.001839,1.6669}, /*cmx*/
          {-1.110125,-6.2438,-5.2566,-0.0423}, /*cfx*/
          {1.5164,-0.03469,75.8286,0.09388,0.001116,0.6971}, /*cmy*/
          {-5.520846,-2.6668,-5.44,-4.4369}, /*cfy*/
          {4.599,-0.07066,171.464,0.11042,0.002343,1.615}, /*cmz*/
          {-5.875968,-4.2567,-4.2308,-4.7501} /*cfz*/
     },
     {
          2458662.3,
          {5.6413,-0.04382,183.6164,0.37461,0.003303,1.6964}, /*cmx*/
          {-5.072168,-3.6208,-0.5327,-2.7356}, /*cfx*/
          {-0.4912,-0.02926,74.265,0.01757,0.000727,0.7158}, /*cmy*/
          {-3.240338,-2.6454,-3.879,-0.8711}, /*cfy*/
          {0.3914,-0.08185,171.3131,0.26823,0.001142,1.6328}, /*cmz*/
          {-3.54266,-1.8801,-5.4609,-1.1123} /*cfz*/
     },
     {
          2458717.3,
          {2.9372,-0.0875,184.512,0.14961,0.004661,1.6687}, /*cmx*/
          {-2.755879,-1.2854,-4.3238,-5.401}, /*cfx*/
          {-2.1364,0.00027,76.904,0.08772,0.000631,0.6993}, /*cmy*/
          {-0.991759,-1.6985,-2.5538,-3.6849}, /*cfy*/
          {-4.2067,-0.01084,169.5624,0.08992,0.003192,1.5192}, /*cmz*/
          {-1.216818,-5.5338,-2.8113,-3.8783} /*cfz*/
     },
     {
          2458772.3,
          {-2.053,-0.05867,185.3611,0.21772,0.002772,1.6607}, /*cmx*/
          {-0.526626,-2.3065,-1.8752,-1.9175}, /*cfx*/
          {-2.1049,0.03134,80.8073,0.15957,0.000995,0.7593}, /*cmy*/
          {-5.074926,-6.2623,-2.6773,-0.2516}, /*cfy*/
          {-4.7297,0.05184,167.7602,0.31887,0.000976,1.5722}, /*cmz*/
          {-5.267475,-0.6201,-0.8588,-0.4501} /*cfz*/
     },
     {
          2458827.3,
          {-5.2771,0.00935,185.6216,0.48139,0.001536,1.6223}, /*cmx*/
          {-4.655078,-0.1267,-3.6554,-4.8318}, /*cfx*/
          {-0.2448,0.03446,82.1298,0.11831,0.001635,0.751}, /*cmy*/
          {-2.887096,-4.5384,-0.4652,-3.0338}, /*cfy*/
          {-1.7007,0.07008,167.0102,0.49563,0.001438,1.5684}, /*cmz*/
          {-3.125682,-4.6027,-1.1296,-3.3185} /*cfz*/
     },
     {
          2458882.3,
          {-4.727,0.06412,184.5721,0.42065,0.003106,1.7059}, /*cmx*/
          {-2.515656,-4.2404,-1.1783,-1.3334}, /*cfx*/
          {1.7017,0.00786,78.0254,0.11966,0.000883,0.6695}, /*cmy*/
          {-0.667622,-3.4456,-4.5898,-5.7087}, /*cfy*/
          {2.2611,0.0509,169.0989,0.40306,0.002832,1.5645}, /*cmz*/
          {-1.000644,-2.2328,-5.2148,-6.1294} /*cfz*/
     },
     {
          2458937.3,
          {-0.9984,0.08444,183.8316,0.15529,0.003221,1.7362}, /*cmx*/
          {-0.332376,-1.9333,-5.0761,-4.0685}, /*cfx*/
          {2.0877,-0.02122,70.0927,0.12555,0.00067,0.6062}, /*cmy*/
          {-4.698348,-1.6947,-5.3919,-2.1508}, /*cfy*/
          {5.1632,-0.01939,172.7725,0.10241,0.001617,1.6065}, /*cmz*/
          {-5.102034,-5.3187,-2.8179,-2.5995} /*cfz*/
     },
     {
          2458992.3,
          {3.807,0.03189,184.32,0.19701,0.000932,1.6698}, /*cmx*/
          {-4.351092,-2.7179,-3.0239,-0.4395}, /*cfx*/
          {0.8696,-0.03031,64.8472,0.02012,0.00103,0.6034}, /*cmy*/
          {-2.44229,-6.2117,-2.8519,-4.852}, /*cfy*/
          {3.9627,-0.08282,174.9675,0.27832,0.000844,1.6016}, /*cmz*/
          {-2.82834,-1.3112,-5.3309,-5.2008} /*cfz*/
     },
     {
          2459047.3,
          {5.5585,-0.06338,185.1006,0.22741,0.001056,1.7237}, /*cmx*/
          {-2.01715,-0.3743,-3.4724,-3.1254}, /*cfx*/
          {-0.8805,-0.02337,66.685,0.10206,0.00072,0.6553}, /*cmy*/
          {-0.189717,-6.2759,-1.5626,-1.3027}, /*cfy*/
          {-0.8922,-0.07198,174.2541,0.3643,0.003479,1.598}, /*cmz*/
          {-0.490217,-4.991,-1.888,-1.5575} /*cfz*/
     },
     {
          2459102.3,
          {1.7934,-0.08668,184.9388,0.07188,0.001737,1.6873}, /*cmx*/
          {-5.988579,-1.0081,-1.6675,-5.8849}, /*cfx*/
          {-2.1738,0.00942,72.435,0.11003,0.000637,0.6761}, /*cmy*/
          {-4.225201,-4.6103,-0.6287,-4.087}, /*cfy*/
          {-4.8203,0.00805,171.9209,0.08411,0.002955,1.5206}, /*cmz*/
          {-4.458753,-1.3582,-5.698,-4.3162} /*cfz*/
     },
     {
          2459157.3,
          {-3.0857,-0.04515,184.0502,0.40466,0.001957,1.6589}, /*cmx*/
          {-3.773271,-5.18,-0.6174,-2.4048}, /*cfx*/
          {-1.5972,0.03503,76.2062,0.06711,0.001079,0.7119}, /*cmy*/
          {-2.006599,-3.1919,-5.252,-0.604}, /*cfy*/
          {-4.2982,0.06174,170.1859,0.32893,0.0012,1.5776}, /*cmz*/
          {-2.247766,-3.9135,-3.2792,-0.8727} /*cfz*/
     },
     {
          2459212.3,
          {-5.5608,0.02685,183.1385,0.40887,0.001683,1.6548}, /*cmx*/
          {-1.633592,-3.039,-4.7179,-5.2713}, /*cfx*/
          {0.4378,0.02476,74.4283,0.12467,0.000568,0.6754}, /*cmy*/
          {-6.072653,-2.6977,-3.351,-3.3927}, /*cfy*/
          {-0.7601,0.07243,171.6226,0.44005,0.001267,1.6047}, /*cmz*/
          {-0.111786,-1.607,-5.0218,-3.755} /*cfz*/
     },
     {
          2455197.4,
          {1.5877,0.0009,237.8289,0.01679,0.001427,0.6454}, /*cmx*/
          {-0.315713,-2.7443,-5.1051,-5.7727}, /*cfx*/
          {0.1808,-0.00259,25.8039,0.01505,0.000869,0.0701}, /*cmy*/
          {-5.669668,-1.749,-1.7867,-4.1654}, /*cfy*/
          {-0.2135,-0.00885,237.2127,0.02063,0.001131,0.6295}, /*cmz*/
          {-5.024145,-4.2766,-3.346,-4.2109} /*cfz*/
     },
     {
          2455297.4,
          {1.3898,-0.00976,237.3774,0.13167,0.003325,0.5385}, /*cmx*/
          {-0.338491,-5.1692,-1.9758,-0.2169}, /*cfx*/
          {0.0636,-0.00088,20.0395,0.13616,0.001332,0.05}, /*cmy*/
          {-6.084146,-1.7675,-4.9732,-5.809}, /*cfy*/
          {-1.1877,-0.00492,237.8203,0.12287,0.003245,0.5693}, /*cmz*/
          {-5.047515,-3.6163,-0.4054,-4.8926} /*cfz*/
     },
     {
          2455397.4,
          {0.5962,-0.00969,237.5286,0.5645,0.000799,0.516}, /*cmx*/
          {-0.492459,-2.0455,-3.5214,-1.2442}, /*cfx*/
          {-0.0921,-0.0009,20.6893,0.15144,0.000506,0.0948}, /*cmy*/
          {-6.199875,-5.1473,-6.2481,-0.3002}, /*cfy*/
          {-1.543,-0.00261,237.7997,0.5733,0.000815,0.4981}, /*cmz*/
          {-5.200051,-0.4967,-2.2336,-5.9013} /*cfz*/
     },
     {
          2455497.4,
          {-0.2191,-0.00775,238.0651,0.56369,0.002943,0.5502}, /*cmx*/
          {-0.803724,-2.4188,-5.5401,-2.1296}, /*cfx*/
          {-0.2509,-0.00058,35.1166,0.20434,0.001171,0.1086}, /*cmy*/
          {-5.901825,-5.747,-2.5685,-0.9389}, /*cfy*/
          {-1.6314,0.00108,236.072,0.5579,0.002949,0.519}, /*cmz*/
          {-5.508403,-0.8924,-4.0043,-0.5684} /*cfz*/
     },
     {
          2455597.4,
          {-1.1278,-0.00342,237.8519,0.16114,6.8e-05,0.5229}, /*cmx*/
          {-0.992426,-5.7169,-3.6132,-2.6995}, /*cfx*/
          {-0.2902,0.00046,44.1166,0.09504,0.000276,0.0664}, /*cmy*/
          {-5.953569,-2.7149,-1.8165,-1.9982}, /*cfy*/
          {-1.744,0.01462,234.7681,0.19392,0.000424,0.5554}, /*cmz*/
          {-5.698526,-4.1175,-0.6816,-1.0805} /*cfz*/
     },
     {
          2455697.4,
          {-1.6612,-0.00168,237.714,0.03553,0.002979,0.6231}, /*cmx*/
          {-1.003898,-2.1654,-2.6828,-3.6988}, /*cfx*/
          {-0.1871,0.00217,33.9024,0.06527,0.001227,0.0732}, /*cmy*/
          {-6.120772,-2.4048,-5.925,-2.3212}, /*cfy*/
          {-0.3297,0.00794,236.0059,0.05946,0.002744,0.6183}, /*cmz*/
          {-5.707803,-0.5449,-1.1971,-2.098} /*cfz*/
     },
     {
          2455797.4,
          {-1.7324,0.00284,238.1777,0.62487,0.000815,0.6362}, /*cmx*/
          {-1.210016,-2.815,-5.3515,-4.6854}, /*cfx*/
          {0.0116,0.00214,40.0002,0.19785,0.000302,0.1186}, /*cmy*/
          {-6.223616,-6.2534,-2.0292,-3.1286}, /*cfy*/
          {0.6209,0.00301,235.0909,0.6225,0.001058,0.616}, /*cmz*/
          {-5.913624,-1.2622,-3.64,-3.1096} /*cfz*/
     },
     {
          2455897.4,
          {-1.4427,0.00791,238.2773,0.44293,0.003146,0.5918}, /*cmx*/
          {-1.514993,-3.1269,-6.2682,-5.611}, /*cfx*/
          {0.244,0.00168,58.0124,0.15756,0.001267,0.1513}, /*cmy*/
          {-0.066826,-0.3989,-3.481,-4.1156}, /*cfy*/
          {1.0399,0.00566,231.2737,0.43351,0.003064,0.5678}, /*cmz*/
          {-6.219904,-1.6423,-4.8015,-4.071} /*cfz*/
     },
     {
          2455997.4,
          {-0.5001,0.01123,238.0667,0.30396,0.00184,0.57}, /*cmx*/
          {-1.647563,-0.0881,-3.2675,-0.2214}, /*cfx*/
          {0.3437,0.00028,61.2587,0.14926,0.000638,0.1673}, /*cmy*/
          {-0.169563,-3.4606,-0.7334,-4.9226}, /*cfy*/
          {1.3937,0.00509,230.6206,0.2889,0.001721,0.5502}, /*cmz*/
          {-0.068796,-4.8148,-1.5745,-4.9592} /*cfz*/
     },
     {
          2456097.4,
          {0.5848,0.00643,237.9207,0.2179,0.002312,0.5185}, /*cmx*/
          {-1.670884,-3.1654,-3.4728,-0.9219}, /*cfx*/
          {0.3964,-0.00038,52.0076,0.04193,0.000901,0.124}, /*cmy*/
          {-0.264455,-1.2239,-0.668,-5.9433}, /*cfy*/
          {1.7808,-0.00804,232.127,0.21281,0.002371,0.4813}, /*cmz*/
          {-0.09279,-1.4994,-2.0887,-5.5655} /*cfz*/
     },
     {
          2456197.4,
          {1.1323,0.00596,238.1626,0.6802,0.001669,0.5123}, /*cmx*/
          {-1.923424,-3.5188,-0.1036,-1.8943}, /*cfx*/
          {0.4332,-0.00283,62.5649,0.23174,0.000625,0.1463}, /*cmy*/
          {-0.44764,-0.9521,-3.6403,-0.6127}, /*cfy*/
          {1.2266,-0.00798,230.0417,0.64628,0.001475,0.472}, /*cmz*/
          {-0.347336,-2.0294,-4.8138,-0.3506} /*cfz*/
     },
     {
          2456297.4,
          {1.7363,-0.00039,238.1916,0.27515,0.002784,0.5972}, /*cmx*/
          {-2.215098,-3.7905,-0.647,-2.7414}, /*cfx*/
          {0.175,-0.00245,77.4073,0.09435,0.001098,0.1872}, /*cmy*/
          {-0.65904,-1.4059,-4.3961,-1.1682}, /*cfy*/
          {0.5416,-0.00795,225.3044,0.28844,0.002929,0.5789}, /*cmz*/
          {-0.641302,-2.3183,-5.486,-1.2009} /*cfz*/
     },
     {
          2456397.4,
          {1.865,-0.00845,238.3399,0.31318,0.002984,0.5969}, /*cmx*/
          {-2.292459,-0.6881,-3.8335,-3.4948}, /*cfx*/
          {-0.2086,-0.00154,75.6975,0.14097,0.00104,0.1558}, /*cmy*/
          {-0.737572,-4.1594,-1.3216,-1.9128}, /*cfy*/
          {-0.5299,-0.00731,225.9325,0.29162,0.002728,0.5676}, /*cmz*/
          {-0.717748,-5.5538,-2.3622,-1.8995} /*cfz*/
     },
     {
          2456497.4,
          {0.8855,-0.00475,238.0111,0.40733,0.001465,0.6162}, /*cmx*/
          {-2.356824,-3.8863,-4.4541,-4.598}, /*cfx*/
          {-0.3324,-0.00313,70.6576,0.12009,0.000623,0.2053}, /*cmy*/
          {-0.83646,-1.6056,-1.9872,-2.9419}, /*cfy*/
          {-1.2856,-0.00479,227.3823,0.37243,0.00169,0.5722}, /*cmz*/
          {-0.782427,-2.3724,-2.9281,-3.0377} /*cfz*/
     },
     {
          2456597.4,
          {0.2297,-0.00457,238.3558,0.68426,0.002385,0.6101}, /*cmx*/
          {-2.650945,-4.2548,-0.974,-5.5892}, /*cfx*/
          {-0.5935,-0.00116,82.8081,0.23705,0.000837,0.2369}, /*cmy*/
          {-1.075361,-1.9825,-4.9016,-3.958}, /*cfy*/
          {-1.6883,0.00086,223.7978,0.66196,0.002244,0.5628}, /*cmz*/
          {-1.080934,-2.8043,-5.8741,-4.048} /*cfz*/
     },
     {
          2456697.4,
          {-0.1435,-0.01438,238.4818,0.08151,0.001885,0.4815}, /*cmx*/
          {-2.914015,-4.7254,-1.4377,-0.1431}, /*cfx*/
          {-0.7099,0.00379,91.9388,0.02522,0.000734,0.2107}, /*cmy*/
          {-1.293375,-2.6207,-5.2316,-4.8576}, /*cfy*/
          {-1.583,0.00576,219.6797,0.08433,0.001968,0.4761}, /*cmz*/
          {-1.352129,-2.8242,-6.1071,-4.8363} /*cfz*/
     },
     {
          2456797.4,
          {-1.3454,-0.00478,238.1554,0.21615,0.003426,0.5386}, /*cmx*/
          {-2.945411,-1.3773,-4.5194,-0.8147}, /*cfx*/
          {-0.3958,0.00364,87.694,0.0938,0.001242,0.2019}, /*cmy*/
          {-1.339904,-4.9587,-2.2277,-5.5304}, /*cfy*/
          {-0.9907,0.00824,221.4524,0.22668,0.003388,0.5017}, /*cmz*/
          {-1.380785,-6.2521,-3.0579,-5.5213} /*cfz*/
     },
     {
          2456897.4,
          {-1.9393,0.00466,237.806,0.53424,0.001121,0.5515}, /*cmx*/
          {-3.068176,-4.5915,-5.6912,-1.6552}, /*cfx*/
          {0.0107,0.00193,87.1908,0.18824,0.00045,0.1897}, /*cmy*/
          {-1.472094,-2.4904,-3.4322,-0.1232}, /*cfy*/
          {-0.1656,0.0063,221.7866,0.51649,0.000878,0.5058}, /*cmz*/
          {-1.500623,-3.149,-4.0857,-0.1171} /*cfz*/
     },
     {
          2456997.4,
          {-1.7358,0.00571,238.2465,0.6235,0.00293,0.5503}, /*cmx*/
          {-3.386738,-4.9996,-1.8077,-2.7049}, /*cfx*/
          {0.2382,0.00353,97.3024,0.23626,0.001167,0.2366}, /*cmy*/
          {-1.747358,-2.9727,-6.0196,-1.0673}, /*cfy*/
          {0.3821,0.00769,217.7259,0.61314,0.002942,0.519}, /*cmz*/
          {-1.827789,-3.5078,-0.3385,-1.1566} /*cfz*/
     },
     {
          2457097.4,
          {-1.0609,0.00564,238.1071,0.11021,0.00067,0.6974}, /*cmx*/
          {-3.600629,-1.9289,-2.1508,-3.545}, /*cfx*/
          {0.6355,0.00141,101.1267,0.0534,0.000202,0.2816}, /*cmy*/
          {-1.939216,-6.2792,-5.2104,-1.8299}, /*cfy*/
          {1.3647,0.00209,215.8767,0.14457,0.000344,0.6412}, /*cmz*/
          {-2.052775,-0.6117,-0.148,-1.998} /*cfz*/
     },
     {
          2457197.4,
          {-0.1967,0.0113,237.8625,0.06932,0.003396,0.5688}, /*cmx*/
          {-3.604581,-2.3969,-5.2887,-4.422}, /*cfx*/
          {0.7287,-0.00127,97.4965,0.02333,0.001246,0.2383}, /*cmy*/
          {-1.961951,-5.3965,-3.1642,-2.7411}, /*cfy*/
          {1.5905,-0.00166,217.2472,0.07093,0.003217,0.5071}, /*cmz*/
          {-2.047846,-0.8566,-3.7686,-2.8403} /*cfz*/
     },
     {
          2457297.4,
          {0.7374,0.00737,238.1648,0.64005,0.00083,0.5543}, /*cmx*/
          {-3.787275,-5.37,-1.0889,-5.4846}, /*cfx*/
          {0.5711,-0.00109,100.0646,0.25798,0.000472,0.2475}, /*cmy*/
          {-2.139123,-3.3954,-5.6132,-3.8316}, /*cfy*/
          {1.2303,-0.00055,216.2801,0.6274,0.000874,0.4876}, /*cmz*/
          {-2.231552,-3.8668,-6.1474,-3.9694} /*cfz*/
     },
     {
          2457397.4,
          {1.3796,0.00306,238.0504,0.52616,0.003411,0.5421}, /*cmx*/
          {-4.111882,-5.7402,-2.5991,-0.057}, /*cfx*/
          {0.4303,-0.00345,106.1181,0.1948,0.001286,0.2415}, /*cmy*/
          {-2.427838,-3.9115,-0.7184,-4.648}, /*cfy*/
          {1.0459,-0.00638,213.8826,0.49397,0.00321,0.491}, /*cmz*/
          {-2.569146,-4.2002,-1.0582,-4.7999} /*cfz*/
     },
     {
          2457497.4,
          {1.8187,-0.0047,237.6409,0.27656,0.001064,0.4728}, /*cmx*/
          {-4.267094,-2.7007,-5.8757,-0.7391}, /*cfx*/
          {0.1487,-0.00662,106.6094,0.11556,0.000614,0.2138}, /*cmy*/
          {-2.56888,-0.7426,-3.9402,-5.2893}, /*cfy*/
          {0.6457,-0.01623,214.1715,0.28862,0.001259,0.4067}, /*cmz*/
          {-2.729058,-1.077,-4.1471,-5.3716} /*cfz*/
     },
     {
          2457597.4,
          {1.4378,-0.00375,237.7587,0.1218,0.003029,0.6005}, /*cmx*/
          {-4.272807,-5.688,-6.0174,-1.5223}, /*cfx*/
          {-0.4998,-0.0023,104.9402,0.07136,0.001056,0.2563}, /*cmy*/
          {-2.592767,-3.8956,-4.1972,-6.1155}, /*cfy*/
          {-0.9044,-0.00352,213.851,0.12884,0.002681,0.5393}, /*cmz*/
          {-2.726222,-4.1156,-4.5418,-6.266} /*cfz*/
     },
     {
          2457697.4,
          {0.9967,-0.00663,238.1441,0.71903,0.001462,0.6043}, /*cmx*/
          {-4.515823,-6.1401,-2.6703,-2.5465}, /*cfx*/
          {-0.7944,0.00071,107.606,0.28881,0.000777,0.2767}, /*cmy*/
          {-2.823384,-4.2917,-0.5848,-0.852}, /*cfy*/
          {-1.448,0.00088,212.9348,0.66335,0.001377,0.5453}, /*cmz*/
          {-2.976274,-4.5769,-1.0314,-1.0197} /*cfz*/
     },
     {
          2457797.4,
          {0.2995,-0.00986,237.4918,0.35699,0.003202,0.5856}, /*cmx*/
          {-4.831785,-0.1407,-3.2795,-3.5911}, /*cfx*/
          {-0.7711,0.00045,108.3683,0.13427,0.001186,0.2725}, /*cmy*/
          {-3.105191,-4.8634,-1.717,-1.8676}, /*cfy*/
          {-1.4972,-0.00086,213.0517,0.33224,0.002995,0.5365}, /*cmz*/
          {-3.300622,-4.8745,-1.7422,-2.06} /*cfz*/
     },
     {
          2457897.4,
          {-0.8899,-0.00731,237.3768,0.35963,0.002786,0.6502}, /*cmx*/
          {-4.926707,-3.3694,-0.2372,-4.3685}, /*cfx*/
          {-0.5962,0.0026,108.0453,0.12346,0.001082,0.2846}, /*cmy*/
          {-3.196666,-1.6556,-4.6959,-2.6354}, /*cfy*/
          {-1.2972,0.00337,213.4196,0.32061,0.002421,0.5768}, /*cmz*/
          {-3.394207,-1.7239,-4.8713,-2.84} /*cfz*/
     },
     {
          2457997.4,
          {-1.5025,-0.00232,237.3793,0.3533,0.00205,0.5079}, /*cmx*/
          {-4.963969,-0.1976,-0.6416,-5.2257}, /*cfx*/
          {-0.3493,0.00554,108.856,0.15802,0.000889,0.2255}, /*cmy*/
          {-3.254861,-4.5926,-5.5119,-3.5651}, /*cfy*/
          {-0.9185,0.01024,212.08,0.30869,0.002049,0.4324}, /*cmz*/
          {-3.430962,-4.9086,-5.4173,-3.7493} /*cfz*/
     },
     {
          2458097.4,
          {-1.5733,-0.00195,237.4522,0.74565,0.002482,0.4959}, /*cmx*/
          {-5.260135,-0.5875,-3.5691,-6.2522}, /*cfx*/
          {0.1088,0.00339,109.4293,0.28775,0.000984,0.2334}, /*cmy*/
          {-3.528208,-5.2632,-1.8461,-4.4699}, /*cfy*/
          {-0.1613,0.0075,212.8554,0.66763,0.002075,0.4785}, /*cmz*/
          {-3.732444,-5.3143,-2.0346,-4.7529} /*cfz*/
     },
     {
          2458197.4,
          {-1.8317,0.00967,237.251,0.14159,0.002342,0.5687}, /*cmx*/
          {-5.546953,-0.8775,-3.9927,-0.6237}, /*cfx*/
          {0.4482,0.00219,105.483,0.06317,0.000976,0.2605}, /*cmy*/
          {-3.777648,-5.7063,-2.6131,-5.1617}, /*cfy*/
          {0.5815,0.00542,214.7262,0.1559,0.002408,0.5046}, /*cmz*/
          {-4.020687,-5.4998,-2.3576,-5.3853} /*cfz*/
     },
     {
          2458297.4,
          {-1.0132,0.0126,237.3536,0.30027,0.003592,0.5776}, /*cmx*/
          {-5.586224,-3.9842,-0.8489,-1.4219}, /*cfx*/
          {0.7683,5e-05,106.9406,0.10654,0.001384,0.2568}, /*cmy*/
          {-3.826759,-2.7021,-5.5926,-5.9898}, /*cfy*/
          {1.3823,0.00166,213.9836,0.26739,0.003195,0.4956}, /*cmz*/
          {-4.060318,-2.3838,-5.5726,-6.2116} /*cfz*/
     },
     {
          2458397.4,
          {0.374,0.00332,237.0446,0.53804,0.001157,0.644}, /*cmx*/
          {-5.680024,-0.9398,-1.912,-2.471}, /*cfx*/
          {0.7489,-0.00088,108.8775,0.21696,0.00064,0.2914}, /*cmy*/
          {-3.933788,-5.5574,-0.5455,-0.7377}, /*cfy*/
          {1.5204,0.00054,212.9998,0.46315,0.001086,0.5822}, /*cmz*/
          {-4.156168,-5.7018,-6.2642,-0.9529} /*cfz*/
     },
     {
          2458497.4,
          {0.8868,0.004,237.1487,0.66424,0.002922,0.603}, /*cmx*/
          {-6.006768,-1.3384,-4.4157,-3.4891}, /*cfx*/
          {0.6539,-0.00411,104.4256,0.26063,0.001192,0.26}, /*cmy*/
          {-4.226075,-6.2509,-3.0217,-1.76}, /*cfy*/
          {1.5089,-0.00458,215.9001,0.60894,0.00268,0.5634}, /*cmz*/
          {-4.483413,-6.0373,-2.8724,-1.9427} /*cfz*/
     },
     {
          2458597.4,
          {1.1631,0.00905,237.1462,0.06964,0.00109,0.54}, /*cmx*/
          {-6.239381,-4.3611,-4.8322,-4.4749}, /*cfx*/
          {0.2244,-0.00414,97.9239,0.03047,0.000415,0.2107}, /*cmy*/
          {-4.428795,-3.6068,-3.6079,-2.5506}, /*cfy*/
          {0.9751,-0.01054,218.4847,0.06334,0.001044,0.5089}, /*cmz*/
          {-4.716056,-3.2533,-2.7824,-2.8861} /*cfz*/
     },
     {
          2458697.4,
          {1.7922,-0.00428,236.6712,0.15189,0.003705,0.5255}, /*cmx*/
          {-6.242993,-4.8017,-1.5987,-5.0304}, /*cfx*/
          {-0.2541,-0.00289,102.7011,0.07611,0.001493,0.226}, /*cmy*/
          {-4.454382,-3.9459,-0.211,-3.274}, /*cfy*/
          {-0.0978,-0.00743,216.1965,0.14359,0.003435,0.4828}, /*cmz*/
          {-4.720246,-3.0087,-6.2555,-3.5588} /*cfz*/
     },
     {
          2458797.4,
          {1.5808,-0.0089,236.7179,0.63418,0.000972,0.4717}, /*cmx*/
          {-0.12127,-1.6741,-3.4993,-5.9644}, /*cfx*/
          {-0.5179,-0.00173,103.17,0.26066,0.000677,0.2215}, /*cmy*/
          {-4.614253,-0.2,-2.2907,-4.1137}, /*cfy*/
          {-0.7934,-0.00549,216.1724,0.59235,0.000594,0.4624}, /*cmz*/
          {-4.879929,-0.1205,-2.1567,-4.4734} /*cfz*/
     },
     {
          2458897.4,
          {0.9454,-0.00832,236.9347,0.54406,0.0032,0.5542}, /*cmx*/
          {-0.451032,-2.0666,-5.1927,-0.7203}, /*cfx*/
          {-0.6207,-0.00053,93.3205,0.20402,0.001219,0.2216}, /*cmy*/
          {-4.90045,-0.9111,-4.0414,-5.0445}, /*cfy*/
          {-1.2893,-0.00396,220.7564,0.50394,0.002977,0.5204}, /*cmz*/
          {-5.207813,-0.4159,-3.5383,-5.4316} /*cfz*/
     },
     {
          2458997.4,
          {-0.1096,-0.00653,236.8206,0.21529,0.000354,0.6483}, /*cmx*/
          {-0.621602,-5.2783,-1.9878,-1.3015}, /*cfx*/
          {-0.7671,0.00395,87.876,0.10482,0.00029,0.2682}, /*cmy*/
          {-5.048992,-4.3069,-0.3097,-5.8733}, /*cfy*/
          {-1.8918,0.00562,223.135,0.23524,0.000725,0.5924}, /*cmz*/
          {-5.379316,-3.6653,-0.7872,-6.0675} /*cfz*/
     },
     {
          2459097.4,
          {-0.9837,-0.00808,236.4977,0.06438,0.003272,0.5998}, /*cmx*/
          {-0.622465,-1.7007,-2.3705,-2.3819}, /*cfx*/
          {-0.3822,0.00293,95.4807,0.07038,0.001227,0.2339}, /*cmy*/
          {-5.077065,-5.9349,-1.2561,-0.5933}, /*cfy*/
          {-1.2383,0.0055,219.6003,0.06904,0.002796,0.5629}, /*cmz*/
          {-5.38054,-0.6848,-0.6778,-0.8583} /*cfz*/
     },
     {
          2459197.4,
          {-1.6168,-0.00216,237.0007,0.69767,0.001279,0.5979}, /*cmx*/
          {-0.849718,-2.4614,-5.1913,-3.4249}, /*cfx*/
          {-0.0083,0.00115,91.6081,0.26048,0.000789,0.1965}, /*cmy*/
          {-5.288046,-1.1764,-3.5696,-1.6009}, /*cfy*/
          {-0.5437,0.0033,221.5812,0.65786,0.001353,0.5805}, /*cmz*/
          {-5.605768,-0.8225,-3.5877,-1.8788} /*cfz*/
     },
     {
          2455197.3,
          {-0.042,0.00185,294.8735,0.20128,0.001767,0.1463}, /*cmx*/
          {-5.447152,-3.8558,-3.7481,-4.3358}, /*cfx*/
          {0.0106,-0.00072,31.5121,0.04958,0.000963,0.064}, /*cmy*/
          {-4.339503,-1.3793,-0.425,-1.1899}, /*cfy*/
          {-0.1563,0.00025,293.363,0.21184,0.001582,0.1878}, /*cmz*/
          {-3.871309,-2.4269,-2.0861,-2.6522} /*cfz*/
     },
     {
          2455302.3,
          {-0.0191,-5e-05,294.5729,0.36608,0.0039,0.0395}, /*cmx*/
          {-1.45058,-6.1489,-3.0096,-3.1006}, /*cfx*/
          {-0.0013,0.00017,20.4209,0.15018,0.001641,0.0123}, /*cmy*/
          {-0.776462,-2.9255,-6.0679,-5.8695}, /*cfy*/
          {0.0131,-0.00067,294.7117,0.36284,0.003851,0.0296}, /*cmz*/
          {-6.16081,-4.5936,-1.4513,-1.8706} /*cfz*/
     },
     {
          2455407.3,
          {0.1071,-0.00056,294.7307,0.49573,0.000409,0.1023}, /*cmx*/
          {-3.880251,-5.4642,-1.41,-5.7568}, /*cfx*/
          {-0.0496,0.00028,21.4659,0.21903,0.000335,0.0483}, /*cmy*/
          {-3.12123,-2.2678,-3.7935,-2.6417}, /*cfy*/
          {-0.0105,0.00105,294.4926,0.47827,0.000523,0.083}, /*cmz*/
          {-2.306489,-3.8933,-5.7785,-4.5401} /*cfz*/
     },
     {
          2455512.3,
          {-0.0489,0.00054,294.8031,0.40479,0.003811,0.0267}, /*cmx*/
          {-0.18014,-1.7713,-4.913,-2.0818}, /*cfx*/
          {0.0249,-0.00025,41.7719,0.21556,0.001587,0.0121}, /*cmy*/
          {-5.175057,-5.0358,-1.9256,-5.5611}, /*cfy*/
          {0.0056,-0.00015,292.3142,0.40083,0.003778,0.0239}, /*cmz*/
          {-4.886646,-0.2791,-3.4024,-1.1485} /*cfz*/
     },
     {
          2455617.3,
          {-0.0136,-0.00128,295.2864,0.56266,0.001805,0.164}, /*cmx*/
          {-2.605374,-0.9733,-4.171,-1.3844}, /*cfx*/
          {0.0101,0.00049,47.3746,0.19063,0.000677,0.0708}, /*cmy*/
          {-1.276955,-4.2552,-1.3502,-4.5837}, /*cfy*/
          {0.2008,-0.00135,291.3693,0.57656,0.002009,0.1726}, /*cmz*/
          {-1.028502,-5.7714,-2.7055,-5.853} /*cfz*/
     },
     {
          2455722.3,
          {0.0762,-0.00096,294.3955,0.05035,0.002602,0.0812}, /*cmx*/
          {-4.892761,-6.0829,-0.3066,-0.1839}, /*cfx*/
          {-0.0349,0.00039,35.5581,0.04083,0.001164,0.0344}, /*cmy*/
          {-3.799383,-3.4951,-3.6067,-3.2999}, /*cfy*/
          {0.053,0.00048,293.1106,0.03441,0.002591,0.1012}, /*cmz*/
          {-3.316863,-4.6128,-5.0555,-5.1493} /*cfz*/
     },
     {
          2455827.3,
          {-0.1007,0.00099,294.8413,0.59902,0.00205,0.09}, /*cmx*/
          {-1.135449,-2.7362,-5.7917,-3.1956}, /*cfx*/
          {0.0323,-0.00055,51.6317,0.29218,0.000753,0.0349}, /*cmy*/
          {-6.146707,-6.1065,-2.8522,-0.6226}, /*cfy*/
          {-0.0609,-0.00039,290.9196,0.56922,0.001885,0.109}, /*cmz*/
          {-5.839576,-1.2601,-4.2778,-2.0025} /*cfz*/
     },
     {
          2455932.3,
          {-0.0865,-0.00039,294.5181,0.02806,0.002953,0.1379}, /*cmx*/
          {-3.69085,-4.4191,-2.0148,-2.5284}, /*cfx*/
          {0.0344,-0.00012,74.0074,0.07954,0.001208,0.0489}, /*cmy*/
          {-2.282236,-1.911,-5.511,-6.1321}, /*cfy*/
          {0.0284,-0.00133,285.8705,0.02878,0.002987,0.0975}, /*cmz*/
          {-2.109884,-4.3051,-0.5944,-1.11} /*cfz*/
     },
     {
          2456037.3,
          {0.0266,-0.00025,294.8684,0.52708,0.003872,0.0372}, /*cmx*/
          {-6.01072,-4.3939,-1.2531,-4.9139}, /*cfx*/
          {-0.0165,0.0001,69.1903,0.15753,0.001463,0.0196}, /*cmy*/
          {-4.641912,-1.6481,-4.7113,-1.5983}, /*cfy*/
          {-0.0631,0.00075,287.2011,0.52397,0.003845,0.0192}, /*cmz*/
          {-4.428648,-2.898,-6.057,-3.178} /*cfz*/
     },
     {
          2456142.3,
          {-0.0565,0.00123,294.3755,0.38141,0.000946,0.0833}, /*cmx*/
          {-2.09996,-3.6231,-4.2184,-4.1566}, /*cfx*/
          {0.0075,-0.0005,68.624,0.19176,0.000425,0.0366}, /*cmy*/
          {-0.758368,-0.7208,-1.5845,-1.3883}, /*cfy*/
          {-0.1085,0.00031,287.3673,0.37317,0.00089,0.114}, /*cmz*/
          {-0.517292,-2.2135,-2.7276,-2.524} /*cfz*/
     },
     {
          2456247.3,
          {0.0382,-0.00071,294.9919,0.52873,0.003588,0.0454}, /*cmx*/
          {-4.679148,-6.2755,-3.1291,-0.5586}, /*cfx*/
          {0.0072,0.00011,91.37,0.23773,0.001403,0.025}, /*cmy*/
          {-3.203775,-3.4774,-0.5789,-4.6569}, /*cfy*/
          {0.0733,-0.00036,280.7933,0.524,0.003466,0.0653}, /*cmz*/
          {-3.098999,-4.8694,-1.6977,-5.3491} /*cfz*/
     },
     {
          2456352.3,
          {0.2037,-0.00087,294.7935,0.454,0.000473,0.2053}, /*cmx*/
          {-0.872472,-5.5956,-3.1686,-5.7461}, /*cfx*/
          {-0.0669,0.00058,102.4442,0.16799,0.000266,0.0671}, /*cmy*/
          {-5.616132,-3.4054,-1.0269,-3.1565}, /*cfy*/
          {0.0005,0.0017,277.1216,0.41362,0.000162,0.172}, /*cmz*/
          {-5.580865,-4.0458,-2.1071,-4.5375} /*cfz*/
     },
     {
          2456457.3,
          {0.0081,0.00072,294.7877,0.17444,0.003517,0.0655}, /*cmx*/
          {-3.145156,-1.6161,-4.7415,-5.0254}, /*cfx*/
          {-0.0143,-0.00019,92.5384,0.05987,0.00127,0.0293}, /*cmy*/
          {-1.633316,-5.8982,-2.1873,-2.1209}, /*cfy*/
          {-0.0595,0.00056,280.0737,0.15696,0.003426,0.0598}, /*cmz*/
          {-1.567304,-0.1329,-3.3014,-3.198} /*cfz*/
     },
     {
          2456562.3,
          {-0.0267,-0.00091,294.9322,0.57661,0.001143,0.1067}, /*cmx*/
          {-5.62788,-0.929,-3.8001,-1.6038}, /*cfx*/
          {0.0399,0.0,101.3236,0.22409,0.000549,0.0525}, /*cmy*/
          {-4.06602,-4.5943,-1.2206,-5.4237}, /*cfy*/
          {0.1137,-0.00098,277.344,0.59456,0.001241,0.1037}, /*cmz*/
          {-4.055544,-5.7811,-2.4086,-6.0922} /*cfz*/
     },
     {
          2456667.3,
          {0.0166,-0.00063,294.8584,0.23074,0.003843,0.0424}, /*cmx*/
          {-1.925364,-3.5005,-0.3483,-0.5653}, /*cfx*/
          {0.0005,0.00038,116.1783,0.0732,0.001403,0.025}, /*cmy*/
          {-0.286662,-0.7445,-4.2946,-5.0403}, /*cfy*/
          {0.0159,0.00056,271.1663,0.24183,0.003764,0.0591}, /*cmz*/
          {-0.366702,-2.0023,-5.1445,-5.6456} /*cfz*/
     },
     {
          2456772.3,
          {-0.1563,0.00124,294.8909,0.63234,0.003453,0.1071}, /*cmx*/
          {-4.288697,-2.6818,-5.8326,-2.7755}, /*cfx*/
          {0.0362,-0.00042,113.8919,0.24091,0.001302,0.0316}, /*cmy*/
          {-2.635511,-0.4159,-3.5404,-0.4297}, /*cfy*/
          {-0.0412,-0.00036,272.8189,0.59927,0.003213,0.1166}, /*cmz*/
          {-2.731804,-1.1922,-4.3499,-1.6222} /*cfz*/
     },
     {
          2456877.3,
          {-0.0923,-0.00023,294.7806,0.23947,0.001878,0.1284}, /*cmx*/
          {-0.327222,-1.863,-2.1045,-2.2164}, /*cfx*/
          {0.0493,-0.00026,107.7778,0.09625,0.000703,0.0475}, /*cmy*/
          {-4.970954,-5.666,-0.0625,-5.8966}, /*cfy*/
          {0.0704,-0.00125,274.4911,0.24527,0.001837,0.0909}, /*cmz*/
          {-5.048928,-0.3451,-0.6967,-0.7042} /*cfz*/
     },
     {
          2456982.3,
          {0.0682,7e-05,294.8303,0.61381,0.00308,0.096}, /*cmx*/
          {-2.895416,-4.5159,-1.3625,-5.2449}, /*cfx*/
          {-0.0393,0.00045,117.7316,0.22924,0.001207,0.0296}, /*cmy*/
          {-1.220747,-2.3706,-5.4549,-3.1973}, /*cfy*/
          {-0.0666,0.00096,271.0913,0.60849,0.00308,0.0642}, /*cmz*/
          {-1.342956,-3.0209,-6.142,-3.6105} /*cfz*/
     },
     {
          2457087.3,
          {-0.048,0.00192,294.7703,0.25171,0.001598,0.1554}, /*cmx*/
          {-5.420327,-3.8293,-3.7033,-4.3119}, /*cfx*/
          {-0.0524,-0.00017,122.0513,0.09882,0.000478,0.075}, /*cmy*/
          {-3.723923,-1.8812,-1.4036,-2.2534}, /*cfy*/
          {-0.1653,0.00035,268.7758,0.25334,0.001439,0.1926}, /*cmz*/
          {-3.874392,-2.4387,-2.0479,-2.6413} /*cfz*/
     },
     {
          2457192.3,
          {-0.0161,-0.00013,294.7404,0.37864,0.004153,0.0365}, /*cmx*/
          {-1.412581,-6.1203,-2.9793,-3.038}, /*cfx*/
          {0.0089,-0.00015,116.6608,0.12166,0.001569,0.0098}, /*cmy*/
          {-6.027167,-4.0335,-0.861,-0.6494}, /*cfy*/
          {0.0169,-0.00067,271.212,0.37444,0.00403,0.026}, /*cmz*/
          {-6.143123,-4.6103,-1.4857,-1.9206} /*cfz*/
     },
     {
          2457297.3,
          {0.1274,-0.00066,294.9832,0.55693,0.00054,0.1243}, /*cmx*/
          {-3.846864,-5.4405,-1.5056,-5.75}, /*cfx*/
          {-0.031,0.00066,118.729,0.23249,0.000413,0.0366}, /*cmy*/
          {-2.190402,-3.3085,-5.4652,-3.8998}, /*cfy*/
          {-0.0041,0.00113,270.1173,0.51882,0.000465,0.0969}, /*cmz*/
          {-2.292062,-3.9394,-6.0917,-4.5708} /*cfz*/
     },
     {
          2457402.3,
          {-0.0393,0.00064,294.6786,0.41311,0.004182,0.0088}, /*cmx*/
          {-0.163726,-1.7566,-4.8977,-1.6921}, /*cfx*/
          {-0.0035,-2e-05,126.6732,0.15997,0.001576,0.0115}, /*cmy*/
          {-4.773892,-6.1401,-3.0748,-2.0437}, /*cfy*/
          {0.006,0.0,266.832,0.39057,0.003943,0.0084}, /*cmz*/
          {-4.898696,-0.2436,-3.3692,-1.2262} /*cfz*/
     },
     {
          2457507.3,
          {-0.006,-0.00133,295.2329,0.6191,0.002152,0.166}, /*cmx*/
          {-2.578691,-0.9503,-4.1382,-1.3454}, /*cfx*/
          {0.0734,-0.00027,128.001,0.22754,0.000899,0.071}, /*cmy*/
          {-0.907558,-5.5046,-2.313,-5.5061}, /*cfy*/
          {0.2026,-0.00131,266.1383,0.60162,0.002237,0.1731}, /*cmz*/
          {-1.030965,-5.727,-2.672,-5.8265} /*cfz*/
     },
     {
          2457612.3,
          {0.0921,-0.00107,294.6426,0.07966,0.002863,0.0954}, /*cmx*/
          {-4.858782,-6.1156,-0.3076,-0.1357}, /*cfx*/
          {0.0012,0.00048,127.5456,0.06194,0.00108,0.0432}, /*cmy*/
          {-3.217343,-3.7164,-4.7802,-4.6802}, /*cfy*/
          {0.0617,0.00051,265.9511,0.05966,0.002757,0.1113}, /*cmz*/
          {-3.305454,-5.0351,-5.0086,-5.1997} /*cfz*/
     },
     {
          2457717.3,
          {-0.1088,0.00117,295.0167,0.67942,0.002589,0.0946}, /*cmx*/
          {-1.120239,-2.7363,-5.8011,-3.2545}, /*cfx*/
          {-0.0256,-0.00018,133.9575,0.25066,0.001064,0.0502}, /*cmy*/
          {-5.743149,-0.8635,-3.9095,-1.9909}, /*cfy*/
          {-0.0551,-0.00039,263.2629,0.62709,0.002258,0.1062}, /*cmz*/
          {-5.856545,-1.2184,-4.32,-1.9262} /*cfz*/
     },
     {
          2457822.3,
          {-0.1075,-0.00029,294.0861,0.04306,0.002907,0.1588}, /*cmx*/
          {-3.684626,-2.6641,-1.9893,-2.5239}, /*cfx*/
          {0.0213,-0.0006,136.1713,0.04065,0.001096,0.0458}, /*cmy*/
          {-1.986769,-0.5382,-0.443,-0.9192}, /*cfy*/
          {0.039,-0.00137,262.4807,0.01652,0.002793,0.1064}, /*cmz*/
          {-2.148464,-0.7984,-0.4774,-1.0074} /*cfz*/
     },
     {
          2457927.3,
          {0.0304,-0.00026,294.595,0.55755,0.004348,0.0387}, /*cmx*/
          {-5.986971,-4.3791,-1.2399,-4.9197}, /*cfx*/
          {-0.0273,0.00035,137.8396,0.22971,0.001685,0.007}, /*cmy*/
          {-4.292196,-2.7829,-5.8234,-2.8044}, /*cfy*/
          {-0.0636,0.00076,261.6046,0.51385,0.004095,0.0195}, /*cmz*/
          {-4.450461,-2.8169,-5.9774,-2.9467} /*cfz*/
     },
     {
          2458032.3,
          {-0.062,0.00153,294.1048,0.46928,0.000883,0.1025}, /*cmx*/
          {-2.082316,-3.628,-4.4557,-4.1789}, /*cfx*/
          {-0.0512,4e-05,140.1247,0.17083,0.000487,0.0614}, /*cmy*/
          {-0.385399,-1.822,-3.341,-2.3442}, /*cfy*/
          {-0.123,0.00032,260.4484,0.4477,0.00058,0.1306}, /*cmz*/
          {-0.548797,-2.1429,-2.5569,-2.4808} /*cfz*/
     },
     {
          2458137.3,
          {0.0258,-0.00052,293.8023,0.54792,0.004008,0.0336}, /*cmx*/
          {-4.686523,-0.0204,-3.1537,-0.7501}, /*cfx*/
          {0.0339,-0.00034,138.7305,0.18239,0.001516,0.0205}, /*cmy*/
          {-2.936635,-4.9676,-1.6218,-5.9525}, /*cfy*/
          {0.0486,-0.00029,261.9812,0.51088,0.003668,0.0431}, /*cmz*/
          {-3.165677,-4.6839,-1.5801,-5.12} /*cfz*/
     },
     {
          2458242.3,
          {0.2177,-0.00091,293.0568,0.51728,0.00079,0.217}, /*cmx*/
          {-0.872007,-5.5892,-2.8545,-5.7383}, /*cfx*/
          {-0.0005,0.00066,134.5645,0.2141,0.00024,0.0686}, /*cmy*/
          {-5.367487,-3.914,-0.8576,-4.5004}, /*cfy*/
          {-0.0309,0.00178,265.0489,0.45023,0.000461,0.1622}, /*cmz*/
          {-5.639052,-3.9726,-1.219,-4.3568} /*cfz*/
     },
     {
          2458347.3,
          {0.0133,0.00092,293.1506,0.14162,0.003828,0.0851}, /*cmx*/
          {-3.13488,-1.6505,-4.7598,-5.009}, /*cfx*/
          {-0.0387,0.00022,137.8569,0.05855,0.001462,0.0398}, /*cmy*/
          {-1.362325,-0.1889,-3.3256,-2.8845}, /*cfy*/
          {-0.0732,0.00061,262.5062,0.11341,0.0034,0.0735}, /*cmz*/
          {-1.617324,-0.1075,-3.1784,-3.1322} /*cfz*/
     },
     {
          2458452.3,
          {-0.0403,-0.0008,293.0692,0.66329,0.001692,0.1154}, /*cmx*/
          {-5.640785,-0.9612,-3.9334,-1.6898}, /*cfx*/
          {0.0481,-0.00062,134.684,0.25999,0.000839,0.0389}, /*cmy*/
          {-3.844271,-5.8823,-2.1431,-0.1425}, /*cfy*/
          {0.1121,-0.00091,264.9582,0.61844,0.00168,0.1016}, /*cmz*/
          {-4.126067,-5.635,-2.4287,-5.9894} /*cfz*/
     },
     {
          2458557.3,
          {0.0224,-0.00081,292.7359,0.18027,0.003776,0.0553}, /*cmx*/
          {-1.949713,-3.5038,-0.3607,-0.7166}, /*cfx*/
          {0.0142,0.00014,122.4342,0.10245,0.001406,0.0287}, /*cmy*/
          {-0.103283,-2.8365,-5.4651,-5.6254}, /*cfy*/
          {0.0302,0.00052,270.673,0.16205,0.003418,0.0742}, /*cmz*/
          {-0.432135,-1.6428,-4.9701,-5.5507} /*cfz*/
     },
     {
          2458662.3,
          {-0.1597,0.00131,292.9878,0.65637,0.003889,0.1073}, /*cmx*/
          {-4.297682,-2.6909,-5.8336,-2.7769}, /*cfx*/
          {-0.024,-8e-05,121.9699,0.23202,0.001438,0.0496}, /*cmy*/
          {-2.460268,-1.2702,-4.4169,-1.7305}, /*cfy*/
          {-0.0205,-0.00048,271.3795,0.59164,0.003408,0.1023}, /*cmz*/
          {-2.777962,-1.0675,-4.2144,-1.4974} /*cfz*/
     },
     {
          2458767.3,
          {-0.12,-0.00012,293.0958,0.32689,0.001602,0.155}, /*cmx*/
          {-0.342798,-1.8905,-2.1958,-2.2547}, /*cfx*/
          {0.0386,-0.00072,125.3004,0.1486,0.000788,0.0464}, /*cmy*/
          {-4.813324,-0.4091,-1.3433,-0.7436}, /*cfy*/
          {0.0829,-0.00137,268.8238,0.29784,0.001466,0.0999}, /*cmz*/
          {-5.104264,-0.2344,-0.6157,-0.601} /*cfz*/
     },
     {
          2458872.3,
          {0.0593,-0.00011,293.4104,0.60652,0.003392,0.0729}, /*cmx*/
          {-2.932072,-4.5452,-1.4017,-5.3197}, /*cfx*/
          {0.006,0.00031,114.1928,0.26165,0.001296,0.038}, /*cmy*/
          {-1.099051,-3.4741,-0.1681,-4.7831}, /*cfy*/
          {-0.0573,0.00073,274.101,0.55433,0.00316,0.0457}, /*cmz*/
          {-1.403928,-2.8811,-6.0367,-3.5033} /*cfz*/
     },
     {
          2458977.3,
          {-0.0495,0.00189,293.732,0.30403,0.001232,0.1559}, /*cmx*/
          {-5.44376,-3.8486,-3.6756,-4.3166}, /*cfx*/
          {-0.0627,0.00043,103.0178,0.09437,0.000515,0.0707}, /*cmy*/
          {-3.593985,-2.6265,-2.8034,-3.059}, /*cfy*/
          {-0.1573,0.00012,277.7844,0.29856,0.001048,0.1871}, /*cmz*/
          {-3.908742,-2.3309,-1.7366,-2.5318} /*cfz*/
     },
     {
          2459082.3,
          {-0.036,-2e-05,293.5991,0.33954,0.004268,0.0545}, /*cmx*/
          {-1.430243,-6.1506,-3.0088,-3.0105}, /*cfx*/
          {0.0109,-0.00042,112.701,0.13156,0.001657,0.0194}, /*cmy*/
          {-5.906439,-5.1481,-1.8558,-1.7195}, /*cfy*/
          {0.0136,-0.00075,274.0183,0.32106,0.003973,0.0376}, /*cmz*/
          {-6.181471,-4.481,-1.3581,-1.7889} /*cfz*/
     },
     {
          2459187.3,
          {0.1272,-0.00086,293.9618,0.60529,0.000999,0.1156}, /*cmx*/
          {-3.882285,-5.4824,-1.994,-5.8157}, /*cfx*/
          {0.0283,0.00025,111.7993,0.23228,0.000617,0.0517}, /*cmy*/
          {-2.080954,-4.3105,-0.228,-5.1669}, /*cfy*/
          {-0.0116,0.00109,274.2656,0.54561,0.000782,0.0888}, /*cmz*/
          {-2.348179,-3.8175,-0.2898,-4.4692} /*cfz*/
     },
     {
          2455197.4,
          {-1.0517,-0.00018,377.0279,0.04405,0.002869,0.5711}, /*cmx*/
          {5.349526,3.7437,0.6732,-4.0929}, /*cfx*/
          {-0.0753,0.00066,41.1121,0.02715,0.00134,0.0846}, /*cmy*/
          {6.272957,3.6226,3.941,-1.8983}, /*cfy*/
          {0.4356,0.00353,376.0716,0.0159,0.002458,0.2413}, /*cmz*/
          {0.640804,5.8935,2.2013,-2.3237} /*cfz*/
     },
     {
          2455297.4,
          {-0.9853,0.00115,376.6017,0.32866,0.005045,0.4017}, /*cmx*/
          {2.529844,4.0966,0.952,-3.5524}, /*cfx*/
          {-0.0547,0.00022,31.9586,0.20718,0.002148,0.0412}, /*cmy*/
          {3.068364,1.1035,4.2037,-3.0327}, /*cfy*/
          {0.7259,0.00157,377.2257,0.3161,0.004891,0.4454}, /*cmz*/
          {4.103661,5.6358,2.504,-1.8995} /*cfz*/
     },
     {
          2455397.4,
          {-0.9208,0.00011,376.3093,0.74751,0.001254,0.4285}, /*cmx*/
          {5.891785,4.3504,3.3429,-2.9803}, /*cfx*/
          {-0.0115,0.00076,33.0067,0.25724,0.000741,0.0398}, /*cmy*/
          {0.182261,1.2774,0.0821,-4.1009}, /*cfy*/
          {0.8997,-0.00132,377.4466,0.73679,0.001165,0.4484}, /*cmz*/
          {1.183027,5.8767,4.7998,-1.8858} /*cfz*/
     },
     {
          2455497.4,
          {-0.8982,0.0,377.0982,0.86908,0.004397,0.4303}, /*cmx*/
          {2.800601,1.2012,4.373,-3.3104}, /*cfx*/
          {0.0478,0.00081,55.8733,0.32217,0.001855,0.0944}, /*cmy*/
          {3.985727,4.1744,1.0906,-1.6425}, /*cfy*/
          {0.7817,0.00091,374.602,0.86285,0.004407,0.3412}, /*cmz*/
          {4.379615,2.6942,5.8534,-1.4013} /*cfz*/
     },
     {
          2455597.4,
          {-0.84,0.00237,377.9049,0.28017,0.000353,0.3333}, /*cmx*/
          {6.087986,1.4772,0.9821,-3.4818}, /*cfx*/
          {0.0869,4e-05,70.0279,0.16092,0.000217,0.1749}, /*cmy*/
          {1.135971,4.4806,4.8844,-1.6638}, /*cfy*/
          {0.7389,0.00431,371.0971,0.27081,0.00038,0.4802}, /*cmz*/
          {1.384987,2.7891,3.6912,-0.9444} /*cfz*/
     },
     {
          2455697.4,
          {-0.6294,0.00146,376.8342,0.07769,0.004566,0.345}, /*cmx*/
          {3.288213,4.5871,1.6392,-2.4474}, /*cfx*/
          {0.0964,0.0003,53.511,0.08731,0.001885,0.0766}, /*cmy*/
          {4.453717,1.7478,4.6723,-1.5509}, /*cfy*/
          {1.0235,0.00104,374.2066,0.08819,0.00457,0.4663}, /*cmz*/
          {4.865667,6.0413,3.1565,-0.914} /*cfz*/
     },
     {
          2455797.4,
          {-0.5421,-0.00071,377.148,0.88288,0.001111,0.5439}, /*cmx*/
          {0.31423,5.0292,2.8816,-2.1877}, /*cfx*/
          {0.1608,0.00093,63.2679,0.31532,0.000647,0.0717}, /*cmy*/
          {1.578373,1.6613,5.9452,-0.0331}, /*cfy*/
          {1.1559,-0.00157,373.0191,0.85285,0.000971,0.3262}, /*cmz*/
          {1.891908,0.2376,4.442,-0.6787} /*cfz*/
     },
     {
          2455897.4,
          {-0.604,0.00115,377.5748,0.72169,0.005023,0.3767}, /*cmx*/
          {3.503587,1.9023,5.0467,-2.0968}, /*cfx*/
          {0.248,0.00034,91.9602,0.25197,0.002012,0.1142}, /*cmy*/
          {4.949544,4.6028,1.5324,-0.5868}, /*cfy*/
          {1.0253,0.00067,366.7147,0.70997,0.00495,0.4048}, /*cmz*/
          {5.081795,3.3806,0.2256,-0.3758} /*cfz*/
     },
     {
          2455997.4,
          {-0.5261,0.00457,377.5336,0.50171,0.002308,0.2677}, /*cmx*/
          {0.561229,2.1651,5.3077,-1.2223}, /*cfx*/
          {0.2877,-0.00074,97.3428,0.2372,0.000917,0.1081}, /*cmy*/
          {2.039164,5.0595,1.7372,-1.0652}, /*cfy*/
          {1.0029,0.00235,365.4907,0.46179,0.001932,0.4873}, /*cmz*/
          {2.141388,3.6271,0.4773,-0.389} /*cfz*/
     },
     {
          2456097.4,
          {-0.2004,0.00145,377.3268,0.19148,0.00376,0.4167}, /*cmx*/
          {4.037343,2.5877,2.3073,-1.1962}, /*cfx*/
          {0.2659,0.00022,82.6688,0.04243,0.001454,0.0679}, /*cmy*/
          {5.443467,4.9494,5.0555,-0.0587}, /*cfy*/
          {1.1621,0.00014,368.1998,0.1838,0.003852,0.3732}, /*cmz*/
          {5.61603,4.2251,3.753,-0.0738} /*cfz*/
     },
     {
          2456197.4,
          {-0.0963,-0.00141,378.0071,0.97175,0.002005,0.4646}, /*cmx*/
          {1.015156,5.6971,2.8795,-1.4247}, /*cfx*/
          {0.3255,0.00086,99.4214,0.35238,0.000936,0.1705}, /*cmy*/
          {2.492674,2.0475,5.7318,-5.6709}, /*cfy*/
          {1.2375,-0.00123,364.4544,0.93826,0.001807,0.4212}, /*cmz*/
          {2.591904,0.9048,4.4265,-5.6389} /*cfz*/
     },
     {
          2456297.4,
          {-0.1816,0.00143,377.5716,0.47546,0.004789,0.3781}, /*cmx*/
          {4.213572,2.6322,5.7713,-1.0203}, /*cfx*/
          {0.4065,-3e-05,122.8996,0.15241,0.001784,0.1625}, /*cmy*/
          {5.769541,5.0023,2.0065,-5.6144}, /*cfy*/
          {1.1728,-0.00029,357.2548,0.47425,0.004833,0.4486}, /*cmz*/
          {5.78633,4.1052,0.9408,-5.5223} /*cfz*/
     },
     {
          2456397.4,
          {-0.0288,0.00394,377.5112,0.54173,0.004031,0.475}, /*cmx*/
          {1.331897,2.9188,6.0568,-0.4327}, /*cfx*/
          {0.407,-0.00082,120.0025,0.23085,0.001581,0.0855}, /*cmy*/
          {2.885209,5.6236,2.3354,-5.1411}, /*cfy*/
          {1.1496,-0.00042,358.6634,0.54474,0.003964,0.2549}, /*cmz*/
          {2.903792,4.4095,1.2914,-5.4715} /*cfz*/
     },
     {
          2456497.4,
          {0.2565,0.0009,377.4387,0.43887,0.002883,0.4748}, /*cmx*/
          {4.773798,3.2625,2.8983,-0.4036}, /*cfx*/
          {0.3744,0.00011,112.1233,0.15448,0.001053,0.1287}, /*cmy*/
          {0.015227,5.6932,5.2775,-4.7918}, /*cfy*/
          {1.1277,-0.0005,360.2414,0.44261,0.002813,0.2456}, /*cmz*/
          {0.067317,4.778,4.3006,-4.9302} /*cfz*/
     },
     {
          2456597.4,
          {0.3447,-0.00149,378.2275,0.99827,0.003167,0.3332}, /*cmx*/
          {1.71083,0.0911,3.344,-0.18}, /*cfx*/
          {0.4142,0.00066,131.0273,0.369,0.001344,0.2063}, /*cmy*/
          {3.289065,2.4291,5.8323,-4.9301}, /*cfy*/
          {1.1462,-0.00031,354.3097,0.98232,0.003138,0.5156}, /*cmz*/
          {3.281943,1.5859,4.8637,-4.8616} /*cfz*/
     },
     {
          2456697.4,
          {0.336,0.00087,377.3966,0.16931,0.003695,0.3797}, /*cmx*/
          {4.93484,3.4267,0.2652,-5.8254}, /*cfx*/
          {0.4487,-8e-05,145.6819,0.03748,0.001194,0.1779}, /*cmy*/
          {0.26971,5.2072,2.5626,-4.7567}, /*cfy*/
          {1.1352,-0.00055,348.6511,0.14515,0.003502,0.5337}, /*cmz*/
          {0.212197,4.861,1.6773,-4.7394} /*cfz*/
     },
     {
          2456797.4,
          {0.5307,0.00195,377.7294,0.44831,0.005058,0.4187}, /*cmx*/
          {2.104457,3.6928,0.5481,-5.7875}, /*cfx*/
          {0.398,-0.00048,139.0092,0.16943,0.001882,0.146}, /*cmy*/
          {3.709469,6.1838,2.8894,-4.0272}, /*cfy*/
          {1.0385,-0.00129,351.1788,0.4545,0.005005,0.3432}, /*cmz*/
          {3.669113,5.1427,2.0157,-4.0099} /*cfz*/
     },
     {
          2456897.4,
          {0.6692,0.00024,377.2194,0.67725,0.001897,0.329}, /*cmx*/
          {5.496426,3.9651,3.2852,-5.8537}, /*cfx*/
          {0.3787,-1e-05,138.3128,0.25528,0.000766,0.1908}, /*cmy*/
          {0.80935,6.2015,5.248,-3.8874}, /*cfy*/
          {0.9491,-0.00065,351.4726,0.67134,0.001634,0.3847}, /*cmz*/
          {0.78133,5.4247,4.7353,-3.6487} /*cfz*/
     },
     {
          2456997.4,
          {0.7091,-0.00065,377.717,0.96081,0.004368,0.4326}, /*cmx*/
          {2.402569,0.7856,3.9681,-5.2139}, /*cfx*/
          {0.3945,0.00032,154.4936,0.35945,0.001738,0.1745}, /*cmy*/
          {4.041979,2.8303,6.0896,-3.9723}, /*cfy*/
          {0.9353,0.00041,345.3352,0.94075,0.004373,0.4032}, /*cmz*/
          {3.961315,2.2753,5.4464,-4.0732} /*cfz*/
     },
     {
          2457097.4,
          {0.7825,0.00116,377.8276,0.17146,0.001581,0.6464}, /*cmx*/
          {5.666922,1.0425,0.9533,-4.9143}, /*cfx*/
          {0.3604,-0.0001,160.3651,0.07542,0.000428,0.1223}, /*cmy*/
          {1.047577,3.1077,3.326,-3.3271}, /*cfy*/
          {0.8688,5e-05,341.8425,0.19407,0.001248,0.2977}, /*cmz*/
          {0.932533,2.3413,2.6192,-3.9106} /*cfz*/
     },
     {
          2457197.4,
          {0.9443,0.00092,377.261,0.23472,0.005268,0.4376}, /*cmx*/
          {2.869853,4.3648,1.2495,-4.7082}, /*cfx*/
          {0.2796,-0.00027,154.6301,0.07646,0.001961,0.176}, /*cmy*/
          {4.513466,0.3585,3.3621,-2.8569}, /*cfy*/
          {0.7029,-0.00055,344.6497,0.23525,0.005066,0.3618}, /*cmz*/
          {4.425759,5.8735,2.75,-2.9795} /*cfz*/
     },
     {
          2457297.4,
          {0.9829,-0.00027,377.1252,0.89148,0.001183,0.259}, /*cmx*/
          {6.202525,4.6419,3.0272,-4.175}, /*cfx*/
          {0.2783,-0.00018,158.5657,0.34264,0.000683,0.1907}, /*cmy*/
          {1.566396,0.3824,4.9182,-3.032}, /*cfy*/
          {0.6841,-0.00053,343.3172,0.84508,0.000799,0.4428}, /*cmz*/
          {1.472962,6.1064,4.4513,-2.9675} /*cfz*/
     },
     {
          2457397.4,
          {0.9658,0.00047,377.1573,0.83736,0.005302,0.4477}, /*cmx*/
          {3.092064,1.479,4.6286,-4.3224}, /*cfx*/
          {0.2788,-0.00021,168.11,0.31242,0.001997,0.1551}, /*cmy*/
          {4.77674,3.2786,0.1858,-2.6868}, /*cfy*/
          {0.6845,-0.00014,339.3093,0.7872,0.005009,0.3238}, /*cmz*/
          {4.634913,2.9965,6.1342,-2.8278} /*cfz*/
     },
     {
          2457497.4,
          {1.0266,0.00228,377.3645,0.48056,0.001365,0.5537}, /*cmx*/
          {0.126367,1.7531,4.9492,-4.3761}, /*cfx*/
          {0.1896,-0.00056,168.6216,0.16315,0.000479,0.2221}, /*cmy*/
          {1.828451,3.6124,0.3991,-1.9594}, /*cfy*/
          {0.5047,-0.00045,338.6872,0.42608,0.001066,0.3805}, /*cmz*/
          {1.668534,3.2112,6.165,-1.9981} /*cfz*/
     },
     {
          2457597.4,
          {1.1353,0.00103,376.9434,0.07177,0.004636,0.3704}, /*cmx*/
          {3.62047,2.4795,1.9108,-3.7598}, /*cfx*/
          {0.0899,-0.00028,166.185,0.04594,0.001809,0.2312}, /*cmy*/
          {5.29748,4.5151,3.738,-1.8837}, /*cfy*/
          {0.2958,0.00013,339.2389,0.04611,0.004523,0.4444}, /*cmz*/
          {5.164751,4.0761,3.4444,-1.927} /*cfz*/
     },
     {
          2457697.4,
          {1.1782,-0.00066,377.1971,1.04114,0.001949,0.4599}, /*cmx*/
          {0.608734,5.2956,2.6426,-3.0982}, /*cfx*/
          {0.1029,-0.0003,170.6959,0.40308,0.00093,0.1423}, /*cmy*/
          {2.298935,0.8371,4.6654,-1.9236}, /*cfy*/
          {0.373,-0.00033,337.8371,0.9517,0.00156,0.305}, /*cmz*/
          {2.147195,0.5311,4.0767,-2.1613} /*cfz*/
     },
     {
          2457797.4,
          {1.1447,0.00038,376.5447,0.59319,0.005315,0.4309}, /*cmx*/
          {3.783946,2.1784,5.3158,-3.1941}, /*cfx*/
          {0.1036,-0.00087,171.895,0.22535,0.002007,0.1514}, /*cmy*/
          {5.510386,3.7761,0.6495,-1.4366}, /*cfy*/
          {0.4198,-0.00179,337.7082,0.5523,0.004978,0.3064}, /*cmz*/
          {5.315224,3.7529,0.6095,-1.7076} /*cfz*/
     },
     {
          2457897.4,
          {1.1246,0.00191,376.2583,0.61165,0.003773,0.2657}, /*cmx*/
          {0.883205,2.4662,5.6046,-2.9862}, /*cfx*/
          {-0.0144,-0.00116,171.4863,0.21754,0.001406,0.2497}, /*cmy*/
          {2.613222,4.1621,1.1063,-1.2433}, /*cfy*/
          {0.1589,-0.00213,338.6,0.55297,0.003272,0.529}, /*cmz*/
          {2.415298,4.076,0.9187,-1.3594} /*cfz*/
     },
     {
          2457997.4,
          {1.1439,0.00134,376.6403,0.37341,0.003579,0.3575}, /*cmx*/
          {4.35088,2.845,2.5245,-2.3687}, /*cfx*/
          {-0.1245,-0.00032,172.6635,0.17333,0.001439,0.2221}, /*cmy*/
          {6.062651,4.7687,3.9983,-1.1106}, /*cfy*/
          {-0.0796,0.0001,336.2471,0.34419,0.003381,0.4734}, /*cmz*/
          {5.885697,4.4047,4.0558,-1.2318} /*cfz*/
     },
     {
          2458097.4,
          {1.2489,-0.00095,377.0038,1.08522,0.003244,0.5083}, /*cmx*/
          {1.286263,5.9459,2.9644,-2.4265}, /*cfx*/
          {-0.0992,-0.00032,173.1677,0.42032,0.00133,0.1448}, /*cmy*/
          {3.019381,1.2887,4.748,-0.4215}, /*cfy*/
          {0.0257,-0.0001,337.1482,0.98825,0.00285,0.2747}, /*cmz*/
          {2.814518,1.2489,4.5518,-0.5996} /*cfz*/
     },
     {
          2458197.4,
          {1.2669,-0.00149,375.6287,0.27154,0.004286,0.4267}, /*cmx*/
          {4.48723,2.9495,6.0783,-2.3095}, /*cfx*/
          {-0.0937,-0.00125,167.142,0.10561,0.001662,0.1778}, /*cmy*/
          {6.254543,4.3084,1.1437,-0.0193}, /*cfy*/
          {0.0779,-0.00262,340.8323,0.25085,0.004015,0.3403}, /*cmz*/
          {6.011645,4.4843,1.3642,-0.2025} /*cfz*/
     },
     {
          2458297.4,
          {1.1291,-7e-05,376.0314,0.55175,0.005188,0.4046}, /*cmx*/
          {1.646211,3.2287,0.0873,-1.5842}, /*cfx*/
          {-0.2275,-0.00114,169.4585,0.21129,0.002057,0.1753}, /*cmy*/
          {3.402805,4.649,1.6554,-0.2248}, /*cfy*/
          {-0.215,-0.00254,339.6057,0.52261,0.004851,0.3639}, /*cmz*/
          {3.170182,4.8591,1.6889,-0.4844} /*cfz*/
     },
     {
          2458397.4,
          {1.0251,0.00133,375.8801,0.65331,0.002299,0.5153}, /*cmx*/
          {5.06141,3.5242,2.967,-1.4285}, /*cfx*/
          {-0.3133,-0.00021,172.4649,0.28456,0.001026,0.1378}, /*cmy*/
          {0.526792,5.2018,4.0379,-0.1071}, /*cfy*/
          {-0.4047,-0.00036,337.421,0.61879,0.001899,0.3089}, /*cmz*/
          {0.305934,5.0809,4.5418,-0.3968} /*cfz*/
     },
     {
          2458497.4,
          {1.1788,-0.00101,376.2747,1.01741,0.004275,0.3843}, /*cmx*/
          {1.960298,0.3322,3.5239,-1.5141}, /*cfx*/
          {-0.2749,-0.00022,165.4322,0.39178,0.001673,0.1946}, /*cmy*/
          {3.740213,1.7296,4.9852,-5.6089}, /*cfy*/
          {-0.3475,1e-05,341.8961,0.94061,0.003977,0.4257}, /*cmz*/
          {3.484854,1.9569,5.1627,-5.9061} /*cfz*/
     },
     {
          2458597.4,
          {1.2415,-0.0033,375.5433,0.05458,0.002519,0.2311}, /*cmx*/
          {5.207074,0.3905,0.5681,-0.836}, /*cfx*/
          {-0.2832,-0.00089,155.4788,0.03396,0.000902,0.2518}, /*cmy*/
          {0.732623,1.5183,1.6371,-5.3899}, /*cfy*/
          {-0.3932,-0.00134,346.4576,0.08048,0.001993,0.5345}, /*cmz*/
          {0.445673,2.1441,2.1854,-5.6656} /*cfz*/
     },
     {
          2458697.4,
          {0.965,-0.00125,375.5716,0.35459,0.005717,0.4051}, /*cmx*/
          {2.404077,3.9481,0.8097,-0.5624}, /*cfx*/
          {-0.4118,-0.00036,163.0177,0.14523,0.002214,0.158}, /*cmy*/
          {4.192886,5.0032,2.1635,-5.2176}, /*cfy*/
          {-0.6384,-0.00111,342.7616,0.32178,0.005175,0.3378}, /*cmz*/
          {3.926985,5.6296,2.4297,-5.4785} /*cfz*/
     },
     {
          2458797.4,
          {0.8121,0.001,375.2336,0.87928,0.001228,0.4982}, /*cmx*/
          {5.755795,4.1992,2.8023,-0.78}, /*cfx*/
          {-0.4324,6e-05,163.7286,0.35296,0.000862,0.1147}, /*cmy*/
          {1.261998,5.6325,3.8242,-4.7081}, /*cfy*/
          {-0.6942,-0.00078,342.857,0.80967,0.000798,0.2849}, /*cmz*/
          {0.995724,5.7731,4.3623,-5.0673} /*cfz*/
     },
     {
          2458897.4,
          {0.9595,-0.00094,375.5523,0.86447,0.00492,0.3724}, /*cmx*/
          {2.640356,1.0251,4.1795,-0.2472}, /*cfx*/
          {-0.38,0.0,148.1005,0.32943,0.001918,0.1912}, /*cmy*/
          {4.474994,2.1621,5.2888,-4.7552}, /*cfy*/
          {-0.7073,-0.00017,350.3524,0.79941,0.004576,0.4299}, /*cmz*/
          {4.166802,2.6602,5.8226,-5.0936} /*cfz*/
     },
     {
          2458997.4,
          {0.9404,-0.00296,375.9836,0.36375,0.000177,0.5412}, /*cmx*/
          {5.941979,1.311,5.1633,-5.7003}, /*cfx*/
          {-0.4209,-1e-05,138.9327,0.16054,9.1e-05,0.1974}, /*cmy*/
          {1.517955,2.1416,5.6984,-4.7333}, /*cfy*/
          {-0.8768,0.00042,353.2343,0.33152,0.000385,0.3778}, /*cmz*/
          {1.187752,2.8768,5.1405,-5.0167} /*cfz*/
     },
     {
          2459097.4,
          {0.595,-0.00052,375.0015,0.05622,0.005099,0.4841}, /*cmx*/
          {3.152754,4.0547,1.4645,-5.7694}, /*cfx*/
          {-0.5027,0.00053,151.3178,0.07449,0.00201,0.128}, /*cmy*/
          {4.978805,4.7963,2.6039,-3.9767}, /*cfy*/
          {-0.9987,0.00027,348.3192,0.04706,0.004689,0.298}, /*cmz*/
          {4.676417,0.1545,3.1467,-4.3192} /*cfz*/
     },
     {
          2459197.4,
          {0.5215,0.0005,375.2297,1.00819,0.001722,0.3027}, /*cmx*/
          {0.157489,4.8582,2.2993,-6.1172}, /*cfx*/
          {-0.448,0.00035,145.3826,0.37627,0.000928,0.1581}, /*cmy*/
          {1.999537,6.029,3.6729,-3.5191}, /*cfy*/
          {-0.9433,-0.00093,351.4205,0.90932,0.001362,0.443}, /*cmz*/
          {1.682608,0.1928,3.8513,-4.1117} /*cfz*/
     },
     {
          2455197.4,
          {-0.3945,0.00431,526.4005,0.06796,0.004719,0.5062}, /*cmx*/
          {3.160772,2.1223,4.8462,3.6007}, /*cfx*/
          {0.1601,-0.00203,56.3184,0.03936,0.002022,0.1169}, /*cmy*/
          {4.14321,1.0029,1.808,0.4234}, /*cfy*/
          {0.6875,0.00166,525.0021,0.08613,0.00469,0.3304}, /*cmz*/
          {4.738128,3.3537,0.0312,-1.4388} /*cfz*/
     },
     {
          2455287.4,
          {-0.1724,0.00145,526.4356,0.67392,0.006701,0.3116}, /*cmx*/
          {2.744104,4.3397,1.1925,2.6834}, /*cfx*/
          {0.0393,-0.00059,43.6903,0.33541,0.002943,0.0289}, /*cmy*/
          {3.415663,1.3139,4.4294,-0.1884}, /*cfy*/
          {0.6668,0.0003,526.6244,0.63813,0.00637,0.2737}, /*cmz*/
          {4.318544,5.8723,2.736,-2.2472} /*cfz*/
     },
     {
          2455377.4,
          {0.0462,-0.00247,525.7656,0.6807,0.003146,0.2588}, /*cmx*/
          {2.283501,0.7539,0.3849,1.0034}, /*cfx*/
          {-0.0525,0.00131,41.4395,0.26111,0.001369,0.0876}, /*cmy*/
          {2.793072,4.0034,3.3828,3.107}, /*cfy*/
          {0.6688,-0.00237,527.0565,0.64906,0.003305,0.1517}, /*cmz*/
          {3.857246,2.2833,1.9318,2.233} /*cfz*/
     },
     {
          2455467.4,
          {-0.1631,0.00031,527.0096,1.23182,0.003627,0.1411}, /*cmx*/
          {1.64996,0.0528,3.3534,-0.1331}, /*cfx*/
          {0.0658,-0.00053,64.7308,0.48448,0.001657,0.0974}, /*cmy*/
          {2.761218,3.1076,0.2135,1.0838}, /*cfy*/
          {0.7538,-0.00275,524.4192,1.23442,0.003691,0.2542}, /*cmz*/
          {3.227759,1.5616,4.829,1.1991} /*cfz*/
     },
     {
          2455557.4,
          {-0.2301,-0.00174,526.6651,0.4137,0.006388,0.2392}, /*cmx*/
          {1.020855,5.7644,2.6083,-0.0062}, /*cfx*/
          {0.0484,0.00091,94.8167,0.11917,0.002638,0.0399}, /*cmy*/
          {2.365301,2.4355,5.6153,-2.1012}, /*cfy*/
          {0.4299,0.00093,519.3081,0.39407,0.006122,0.1319}, /*cmz*/
          {2.59891,0.9905,4.1128,1.4458} /*cfz*/
     },
     {
          2455647.4,
          {-0.2112,-0.00226,526.737,0.76583,0.005269,0.2431}, /*cmx*/
          {0.569848,2.1405,5.2669,-0.498}, /*cfx*/
          {0.0589,0.00089,85.4288,0.36104,0.002315,0.0668}, /*cmy*/
          {1.873175,5.2174,2.0058,-2.4337}, /*cfy*/
          {0.3893,0.00173,521.3013,0.7571,0.005319,0.1079}, /*cmz*/
          {2.148302,3.678,0.5319,0.5162} /*cfz*/
     },
     {
          2455737.4,
          {-0.3194,0.00159,526.5575,0.41012,0.004499,0.3896}, /*cmx*/
          {0.145789,4.8855,4.7129,-2.5495}, /*cfx*/
          {0.1038,-0.00082,72.2869,0.15046,0.001797,0.0876}, /*cmy*/
          {1.341931,1.6191,1.3383,0.1927}, /*cfy*/
          {0.6657,-0.00067,522.8153,0.39539,0.004489,0.2701}, /*cmz*/
          {1.722286,0.1832,6.1512,-0.8866} /*cfz*/
     },
     {
          2455827.4,
          {-0.4463,0.0006,526.9731,1.23896,0.002534,0.3358}, /*cmx*/
          {5.820432,4.2296,1.3716,2.8535}, /*cfx*/
          {0.1392,5e-05,99.1261,0.47738,0.001299,0.0616}, /*cmy*/
          {0.902869,0.8329,4.4459,-1.4735}, /*cfy*/
          {0.4688,0.00161,518.9593,1.20433,0.002259,0.387}, /*cmz*/
          {1.115385,5.7089,2.8965,-2.257} /*cfz*/
     },
     {
          2455917.4,
          {-0.3726,7e-05,527.33,0.69649,0.006979,0.2096}, /*cmx*/
          {5.173785,3.5862,0.4454,1.4367}, /*cfx*/
          {0.111,-0.00018,132.2137,0.23449,0.002759,0.0661}, /*cmy*/
          {0.376474,6.2614,3.2016,2.8619}, /*cfy*/
          {0.4915,-0.00049,510.68,0.69664,0.007013,0.1942}, /*cmz*/
          {0.467041,5.0814,1.922,2.8534} /*cfz*/
     },
     {
          2456007.4,
          {-0.2304,0.00093,527.2017,0.7255,0.003213,0.1388}, /*cmx*/
          {4.68519,6.2789,3.1147,0.1057}, /*cfx*/
          {0.0661,-0.00074,131.14,0.3217,0.001404,0.0904}, /*cmy*/
          {6.174471,2.8405,5.8528,1.4337}, /*cfy*/
          {0.6886,-0.00436,511.175,0.75897,0.003433,0.3164}, /*cmz*/
          {6.259692,1.4333,4.4847,0.9068} /*cfz*/
     },
     {
          2456097.4,
          {-0.3744,-0.00123,527.073,0.10959,0.005767,0.2157}, /*cmx*/
          {4.284763,2.916,2.6137,0.0862}, /*cfx*/
          {0.1017,0.00062,113.7458,0.03432,0.00223,0.0047}, /*cmy*/
          {5.716642,5.4614,5.3817,1.6392}, /*cfy*/
          {0.3622,0.00142,514.8567,0.12414,0.005548,0.1562}, /*cmz*/
          {5.86275,4.4067,4.1046,2.1156} /*cfz*/
     },
     {
          2456187.4,
          {-0.2809,-0.00359,527.5636,1.17151,0.001185,0.2407}, /*cmx*/
          {3.708,2.1087,6.0169,-0.372}, /*cfx*/
          {0.0425,0.00119,133.1409,0.45191,0.000905,0.0329}, /*cmy*/
          {5.194314,4.8065,2.5083,-2.5498}, /*cfy*/
          {0.3318,-0.00075,510.4478,1.15619,0.001433,0.1767}, /*cmz*/
          {5.283736,3.6069,1.2832,0.6181} /*cfz*/
     },
     {
          2456277.4,
          {-0.4151,-0.00107,527.4762,0.95087,0.00712,0.181}, /*cmx*/
          {3.050256,1.4483,4.5898,-2.1324}, /*cfx*/
          {0.106,-9e-05,164.7864,0.3275,0.002689,0.0613}, /*cmy*/
          {4.609781,3.9135,0.8531,-0.5716}, /*cfy*/
          {0.3438,-0.00094,501.2965,0.9264,0.006924,0.2248}, /*cmz*/
          {4.622095,2.9196,6.0494,-0.6187} /*cfz*/
     },
     {
          2456367.4,
          {-0.8108,0.00444,527.8949,0.61568,0.001057,0.4897}, /*cmx*/
          {2.520106,4.099,0.6168,3.1435}, /*cfx*/
          {0.2113,-0.00056,170.3377,0.25201,0.000507,0.0873}, /*cmy*/
          {4.097708,0.459,3.2717,-1.199}, /*cfy*/
          {0.2572,0.00488,498.5724,0.57608,0.000727,0.4902}, /*cmz*/
          {4.09024,5.49,1.6372,-2.2228} /*cfz*/
     },
     {
          2456457.4,
          {-0.3674,-0.00099,527.0897,0.17782,0.006563,0.2102}, /*cmx*/
          {2.133334,3.6079,0.5207,1.6251}, /*cfx*/
          {0.0732,0.00023,153.7489,0.06545,0.002462,0.0847}, /*cmy*/
          {3.673197,0.0931,3.0855,3.4088}, /*cfy*/
          {0.4088,-0.00155,504.4405,0.18784,0.006607,0.1255}, /*cmz*/
          {3.707167,5.1144,1.9955,3.1562} /*cfz*/
     },
     {
          2456547.4,
          {-0.4096,0.00019,527.5013,1.06261,0.00133,0.1265}, /*cmx*/
          {1.591409,0.022,5.1352,0.4819}, /*cfx*/
          {0.1289,-0.00102,164.7318,0.40408,0.000826,0.0976}, /*cmy*/
          {3.149461,2.5084,0.9578,1.5354}, /*cfy*/
          {0.4941,-0.00366,500.9532,1.06794,0.000987,0.1946}, /*cmz*/
          {3.164754,1.4764,0.2584,1.324} /*cfz*/
     },
     {
          2456637.4,
          {-0.5856,0.00166,527.8298,1.13416,0.006496,0.1194}, /*cmx*/
          {0.930445,5.5903,2.4606,-1.0376}, /*cfx*/
          {0.1444,-0.00064,191.512,0.41065,0.002525,0.0859}, /*cmy*/
          {2.537183,1.5777,4.8063,0.8855}, /*cfy*/
          {0.3241,-0.00111,491.5943,1.11049,0.006465,0.1676}, /*cmz*/
          {2.495436,0.8041,3.9491,1.0323} /*cfz*/
     },
     {
          2456727.4,
          {-0.318,-0.00535,526.9347,0.35079,0.002164,0.4226}, /*cmx*/
          {0.3598,1.8008,2.2621,0.0706}, /*cfx*/
          {-0.0316,0.00158,200.6207,0.15545,0.000512,0.0436}, /*cmy*/
          {1.988955,4.322,4.6266,3.0723}, /*cfy*/
          {-0.0152,0.00052,487.9572,0.3289,0.001962,0.1963}, /*cmz*/
          {1.922879,3.3617,3.5637,1.0247} /*cfz*/
     },
     {
          2456817.4,
          {-0.5493,0.00018,527.2964,0.46795,0.007185,0.2379}, /*cmx*/
          {6.255202,1.5405,4.6809,-1.948}, /*cfx*/
          {0.1106,-0.00019,188.2888,0.15982,0.002636,0.0765}, /*cmy*/
          {1.577105,3.9628,0.7601,-0.1434}, /*cfy*/
          {0.2379,1e-05,492.577,0.45983,0.006979,0.2077}, /*cmz*/
          {1.537801,3.0038,6.1448,-0.4226} /*cfz*/
     },
     {
          2456907.4,
          {-0.6988,0.00169,526.9984,0.93935,0.00213,0.3792}, /*cmx*/
          {5.753526,4.1927,3.597,3.2266}, /*cfx*/
          {0.1403,-0.00031,192.0958,0.35675,0.001081,0.1115}, /*cmy*/
          {1.074741,0.2371,5.409,-1.3203}, /*cfy*/
          {0.1998,0.00093,491.4296,0.89047,0.002195,0.332}, /*cmz*/
          {1.035809,5.6453,5.1701,-1.9433} /*cfz*/
     },
     {
          2456997.4,
          {-0.6405,-0.00075,527.5373,1.26638,0.005646,0.2721}, /*cmx*/
          {5.094477,3.4837,0.4006,1.8214}, /*cfx*/
          {0.0253,0.00081,212.6307,0.46812,0.002155,0.1687}, /*cmy*/
          {0.453493,5.5462,2.5408,3.6066}, /*cfy*/
          {-0.0067,0.00149,483.3391,1.23408,0.005511,0.3641}, /*cmz*/
          {0.36954,4.9612,1.8343,3.5104} /*cfz*/
     },
     {
          2457087.4,
          {-0.5647,0.00253,526.4073,0.02181,0.004651,0.017}, /*cmx*/
          {4.489928,4.6107,6.1185,0.6029}, /*cfx*/
          {0.1365,-0.00159,221.1806,0.0243,0.00154,0.1069}, /*cmy*/
          {6.153397,2.0369,1.9392,1.2678}, /*cfy*/
          {0.2997,-0.00299,479.4285,0.05437,0.004232,0.2198}, /*cmz*/
          {6.039913,0.5001,1.4022,1.1345} /*cfz*/
     },
     {
          2457177.4,
          {-0.5653,0.00071,526.9425,0.69529,0.006969,0.1186}, /*cmx*/
          {4.0838,5.654,2.5159,-0.0091}, /*cfx*/
          {0.0769,-0.00038,214.8109,0.24678,0.002648,0.0798}, /*cmy*/
          {5.734554,1.506,4.6501,1.3117}, /*cfy*/
          {0.1612,-0.00094,482.2256,0.68469,0.006829,0.1654}, /*cmz*/
          {5.638839,0.8812,4.0114,1.2714} /*cfz*/
     },
     {
          2457267.4,
          {-0.5036,-0.0028,527.1373,0.72444,0.003647,0.2994}, /*cmx*/
          {3.623336,2.0568,1.7532,-0.1073}, /*cfx*/
          {-0.0053,0.00073,214.1635,0.29889,0.001363,0.0433}, /*cmy*/
          {5.265124,4.2286,3.4809,2.0956}, /*cfy*/
          {-0.034,-0.00021,481.8354,0.69706,0.003338,0.1629}, /*cmz*/
          {5.179334,3.5648,3.2084,1.2087} /*cfz*/
     },
     {
          2457357.4,
          {-0.4247,-0.00218,526.9653,1.36929,0.004665,0.1863}, /*cmx*/
          {2.976238,1.3606,4.5985,-1.0906}, /*cfx*/
          {0.0302,-0.00115,227.8564,0.50655,0.001802,0.1295}, /*cmy*/
          {4.644762,3.2889,0.4217,0.1766}, /*cfy*/
          {0.0135,-0.00295,476.9867,1.27179,0.004201,0.2807}, /*cmz*/
          {4.524255,2.8664,6.0992,0.0837} /*cfz*/
     },
     {
          2457447.4,
          {-0.7391,0.00081,526.4841,0.31586,0.006265,0.3186}, /*cmx*/
          {2.340277,0.7867,3.9312,3.2576}, /*cfx*/
          {-0.0295,0.00104,233.0119,0.11986,0.002362,0.1478}, /*cmy*/
          {4.03494,2.4994,5.7297,-1.6975}, /*cfy*/
          {-0.196,0.00283,473.7971,0.31252,0.006159,0.348}, /*cmz*/
          {3.880953,2.3966,5.4796,-1.8972} /*cfz*/
     },
     {
          2457537.4,
          {-0.7612,0.00101,526.7858,0.83556,0.006051,0.2987}, /*cmx*/
          {1.904975,3.5052,0.3603,2.4073}, /*cfx*/
          {-0.003,0.00102,231.146,0.3003,0.002271,0.1615}, /*cmy*/
          {3.592185,5.3439,2.241,-2.4327}, /*cfy*/
          {-0.1609,0.00337,474.9734,0.8065,0.005723,0.4074}, /*cmz*/
          {3.447104,4.9933,1.8225,-2.6223} /*cfz*/
     },
     {
          2457627.4,
          {-0.5231,0.00039,526.5373,0.46871,0.005044,0.1443}, /*cmx*/
          {1.481004,6.2663,5.9609,1.1026}, /*cfx*/
          {0.0534,-0.0015,230.3079,0.20481,0.001905,0.0698}, /*cmy*/
          {3.156202,1.9648,1.4457,1.9174}, /*cfy*/
          {0.1097,-0.00355,474.8293,0.45852,0.004554,0.1351}, /*cmz*/
          {3.028679,1.4229,1.2684,1.5891} /*cfz*/
     },
     {
          2457717.4,
          {-0.7066,0.00341,526.9963,1.37352,0.003178,0.0838}, /*cmx*/
          {0.855248,5.5169,2.5986,-1.5105}, /*cfx*/
          {0.0433,-0.00086,236.9493,0.53807,0.001545,0.0691}, /*cmy*/
          {2.549134,1.0424,4.6103,1.3787}, /*cfy*/
          {0.018,-0.002,472.3606,1.29355,0.0032,0.1602}, /*cmz*/
          {2.394712,0.7866,4.1212,1.1837} /*cfz*/
     },
     {
          2457807.4,
          {-0.5005,-0.00107,525.8315,0.64622,0.00745,0.214}, /*cmx*/
          {0.195797,4.9044,1.7621,-0.335}, /*cfx*/
          {-0.0751,-4e-05,237.2251,0.24239,0.002756,0.0932}, /*cmy*/
          {1.918712,0.1889,3.3547,1.1323}, /*cfy*/
          {-0.2405,-0.00046,472.7076,0.59841,0.006867,0.1956}, /*cmz*/
          {1.729276,0.1807,3.3171,0.8818} /*cfz*/
     },
     {
          2457897.4,
          {-0.3158,-0.00492,526.337,0.87055,0.00432,0.3245}, /*cmx*/
          {6.003815,1.2961,4.372,-0.4083}, /*cfx*/
          {-0.1135,-0.00013,236.7174,0.30635,0.001551,0.124}, /*cmy*/
          {1.444294,2.9509,6.1574,0.3959}, /*cfy*/
          {-0.307,-0.00113,472.7105,0.76961,0.003659,0.3031}, /*cmz*/
          {1.255238,2.8619,5.9607,0.353} /*cfz*/
     },
     {
          2457987.4,
          {-0.7509,0.00215,525.6858,0.19479,0.006151,0.3778}, /*cmx*/
          {5.61088,4.1928,3.9177,3.5447}, /*cfx*/
          {-0.0182,1e-05,238.8259,0.0962,0.002445,0.1293}, /*cmy*/
          {1.032295,6.2713,5.5236,-1.1564}, /*cfy*/
          {-0.1827,0.00087,471.5343,0.15807,0.005896,0.2763}, /*cmz*/
          {0.864385,5.5827,5.4858,-1.5437} /*cfz*/
     },
     {
          2458077.4,
          {-0.6742,5e-05,526.1393,1.33306,0.002144,0.2948}, /*cmx*/
          {5.013298,3.4201,0.8389,2.1873}, /*cfx*/
          {-0.1382,0.00077,240.4001,0.53121,0.001131,0.1914}, /*cmy*/
          {0.450604,5.0628,2.6225,-2.4492}, /*cfy*/
          {-0.3797,0.00167,471.3864,1.24665,0.001815,0.4138}, /*cmz*/
          {0.264062,4.9594,2.1591,-2.5334} /*cfz*/
     },
     {
          2458167.4,
          {-0.5274,-0.00017,525.5353,0.91279,0.007577,0.225}, /*cmx*/
          {4.340469,2.73,5.8717,1.1442}, /*cfx*/
          {-0.1207,-0.00017,234.1383,0.3465,0.002876,0.0872}, /*cmy*/
          {6.090673,4.1909,1.0465,2.9065}, /*cfy*/
          {-0.3598,0.0,474.9487,0.84043,0.006996,0.2151}, /*cmz*/
          {5.868459,4.3397,1.1998,2.7831} /*cfz*/
     },
     {
          2458257.4,
          {-0.6354,0.00461,524.7638,0.69809,0.00141,0.1656}, /*cmx*/
          {3.822638,5.3483,1.8637,-2.3457}, /*cfx*/
          {-0.0013,-0.00082,231.8221,0.27043,0.00064,0.0746}, /*cmy*/
          {5.581286,0.5524,3.6921,1.2849}, /*cfy*/
          {-0.0678,-0.00234,476.6482,0.6621,0.001583,0.2288}, /*cmz*/
          {5.351206,0.7363,3.6783,0.8806} /*cfz*/
     },
     {
          2458347.4,
          {-0.5059,-0.00145,525.4183,0.13841,0.007354,0.2817}, /*cmx*/
          {3.444995,4.9134,1.8207,-0.0255}, /*cfx*/
          {-0.1501,0.00027,238.3253,0.06664,0.002791,0.0878}, /*cmy*/
          {5.181988,5.632,3.2936,1.703}, /*cfy*/
          {-0.3926,8e-05,472.1842,0.12442,0.006646,0.1791}, /*cmz*/
          {4.973649,0.2756,3.3969,1.3655} /*cfz*/
     },
     {
          2458437.4,
          {-0.3563,-0.00182,525.2412,1.2567,0.001232,0.2746}, /*cmx*/
          {2.885865,1.294,5.5739,-0.7262}, /*cfx*/
          {-0.1162,-0.00127,237.5161,0.48332,0.000993,0.1712}, /*cmy*/
          {4.63137,2.8332,0.9791,0.4693}, /*cfy*/
          {-0.3773,-0.00261,473.5629,1.12182,0.000957,0.3046}, /*cmz*/
          {4.412784,2.8774,1.0998,0.344} /*cfz*/
     },
     {
          2458527.4,
          {-0.4072,0.00039,525.1045,1.10893,0.007083,0.2491}, /*cmx*/
          {2.206894,0.5978,3.7513,-2.5733}, /*cfx*/
          {-0.117,-0.00068,224.6156,0.42562,0.002724,0.1291}, /*cmy*/
          {3.987833,1.8917,5.0277,-0.6691}, /*cfy*/
          {-0.4108,-0.00173,480.2907,1.0201,0.006479,0.2456}, /*cmz*/
          {3.733622,2.2106,5.3597,-0.7788} /*cfz*/
     },
     {
          2458617.4,
          {-0.5939,-0.00155,524.5076,0.43023,0.001436,0.3207}, /*cmx*/
          {1.649984,3.2116,3.4058,2.2735}, /*cfx*/
          {-0.2993,0.0021,216.8561,0.18411,0.000535,0.2176}, /*cmy*/
          {3.445796,4.3328,4.9128,-2.4045}, /*cfy*/
          {-0.7555,0.00576,483.6607,0.4218,0.001398,0.5719}, /*cmz*/
          {3.174762,4.7796,5.3877,-2.4655} /*cfz*/
     },
     {
          2458707.4,
          {-0.4806,0.00024,524.7975,0.43696,0.007798,0.2133}, /*cmx*/
          {1.268787,2.8067,5.9552,1.5758}, /*cfx*/
          {-0.1402,-0.00038,228.0345,0.17544,0.003031,0.0816}, /*cmy*/
          {3.043636,3.9351,1.0273,3.1892}, /*cfy*/
          {-0.4103,-0.0007,478.1445,0.39832,0.007136,0.1949}, /*cmz*/
          {2.794668,4.4973,1.3074,2.9548} /*cfz*/
     },
     {
          2458797.4,
          {-0.5584,0.00408,525.171,1.07102,0.001709,0.0118}, /*cmx*/
          {0.75273,5.4452,4.6971,-0.8978}, /*cfx*/
          {-0.1054,-0.00057,227.5913,0.42452,0.001122,0.0482}, /*cmy*/
          {2.529283,0.6139,5.4444,2.1849}, /*cfy*/
          {-0.3044,-0.00254,478.1744,0.99314,0.001382,0.1759}, /*cmz*/
          {2.277654,0.7932,6.2264,1.4226} /*cfz*/
     },
     {
          2458887.4,
          {-0.495,0.0025,524.7475,1.25144,0.006229,0.15}, /*cmx*/
          {0.079438,4.7448,1.6273,-1.0661}, /*cfx*/
          {-0.2264,0.001,209.1916,0.46535,0.0023,0.0724}, /*cmy*/
          {1.894001,5.8837,2.7845,2.3225}, /*cfy*/
          {-0.5333,0.00035,487.7438,1.12879,0.005565,0.1398}, /*cmz*/
          {1.606401,0.1083,3.2924,1.0623} /*cfz*/
     },
     {
          2458977.4,
          {-0.0418,-0.00365,524.6067,0.13735,0.0037,0.3048}, /*cmx*/
          {5.768644,0.9169,1.1859,-0.5553}, /*cfx*/
          {-0.1148,-0.00186,193.7528,0.06478,0.001617,0.2168}, /*cmy*/
          {1.331303,1.4868,2.2446,0.5263}, /*cfy*/
          {-0.5775,-0.00271,493.106,0.09303,0.003704,0.3937}, /*cmz*/
          {1.016154,2.4988,2.817,0.4748} /*cfz*/
     },
     {
          2459067.4,
          {-0.32,-0.00092,524.5765,0.67313,0.007574,0.2447}, /*cmx*/
          {5.370648,0.6763,3.8154,-2.1251}, /*cfx*/
          {-0.1865,-0.00042,206.9434,0.28138,0.00295,0.1361}, /*cmy*/
          {0.908257,1.6584,4.9506,-0.3955}, /*cfy*/
          {-0.5788,-0.00063,488.1499,0.61077,0.006865,0.2747}, /*cmz*/
          {0.61482,2.3308,5.4443,-0.5949} /*cfz*/
     },
     {
          2459157.4,
          {-0.5118,0.00118,524.3529,0.85222,0.002945,0.3207}, /*cmx*/
          {4.896907,3.3517,2.8476,2.6362}, /*cfx*/
          {-0.2713,0.00128,210.7895,0.33631,0.001295,0.1673}, /*cmy*/
          {0.429984,4.6287,3.6518,-2.2552}, /*cfy*/
          {-0.696,0.0022,486.4848,0.79043,0.002578,0.4334}, /*cmz*/
          {0.141684,4.9423,4.6346,-2.2806} /*cfz*/
     },
     {
          2455197.3,
          {-22.8898,0.02301,1219.1996,0.29627,0.015124,17.6084}, /*cmx*/
          {5.833616,4.2543,1.1329,2.699}, /*cfx*/
          {2.9429,-0.01257,128.5444,0.05622,0.006203,1.7531}, /*cmy*/
          {0.5236,1.4948,4.3335,3.62}, /*cfy*/
          {47.3381,0.01784,1216.7188,0.23825,0.01399,17.5314}, /*cmz*/
          {1.125903,5.8671,2.6802,4.2686} /*cfz*/
     },
     {
          2455267.3,
          {-20.7905,0.06173,1218.8469,1.86521,0.00871,17.6224}, /*cmx*/
          {2.038484,3.6235,0.4116,1.3846}, /*cfx*/
          {1.8042,-0.02509,109.251,0.81226,0.004479,1.4104}, /*cmy*/
          {2.8356,0.5577,3.6073,1.9723}, /*cfy*/
          {48.8422,0.01752,1219.6986,1.85927,0.009064,17.5971}, /*cmz*/
          {3.613052,5.1932,2.032,2.9548} /*cfz*/
     },
     {
          2455337.3,
          {-16.8228,-0.02524,1218.477,0.31563,0.015275,17.5517}, /*cmx*/
          {4.55628,6.1553,2.99,0.012}, /*cfx*/
          {0.2211,0.01499,92.3849,0.04323,0.006496,1.3799}, /*cmy*/
          {4.985047,3.2128,6.2188,0.5439}, /*cfy*/
          {50.129,-0.01074,1220.4208,0.30177,0.014684,17.5537}, /*cmz*/
          {6.129503,1.2874,4.4923,1.5799} /*cfz*/
     },
     {
          2455407.3,
          {-18.9619,-0.08842,1218.3305,1.88199,0.005014,17.5625}, /*cmx*/
          {0.678859,5.416,4.884,4.8146}, /*cfx*/
          {1.4469,0.04056,105.5719,0.89412,0.002262,1.8752}, /*cmy*/
          {1.396592,2.3453,1.3057,5.7861}, /*cfy*/
          {49.5403,-0.04765,1219.5832,1.80351,0.005284,17.5594}, /*cmz*/
          {2.253227,0.6572,0.1594,0.1014} /*cfz*/
     },
     {
          2455477.3,
          {-25.2845,-0.07982,1219.3116,2.50715,0.007573,17.5326}, /*cmx*/
          {3.001782,1.4304,4.7697,3.3013}, /*cfx*/
          {4.2876,0.03056,160.2019,1.07751,0.003918,2.7603}, /*cmy*/
          {4.15741,4.5019,1.6272,4.5676}, /*cfy*/
          {46.0532,-0.04645,1212.5956,2.51139,0.008079,17.4357}, /*cmz*/
          {4.579674,2.9334,6.25,4.8768} /*cfz*/
     },
     {
          2455547.3,
          {-30.9158,-0.00564,1220.5957,1.34245,0.017438,17.5333}, /*cmx*/
          {5.336629,3.7421,0.6009,1.8464}, /*cfx*/
          {6.342,-0.00053,215.0871,0.49152,0.007187,3.1862}, /*cmy*/
          {0.389419,0.4311,3.5766,3.2029}, /*cfy*/
          {42.3784,-0.00425,1203.7231,1.29055,0.016687,17.3686}, /*cmz*/
          {0.631257,5.2408,2.0892,3.4247} /*cfz*/
     },
     {
          2455617.3,
          {-31.3982,0.06532,1220.0529,1.42958,0.001414,17.5753}, /*cmx*/
          {1.49088,3.0507,4.1255,0.5097}, /*cfx*/
          {6.3387,-0.02524,215.8426,0.64763,0.000906,2.7994}, /*cmy*/
          {2.836007,6.036,2.0132,1.807}, /*cfy*/
          {42.2169,0.04367,1203.5211,1.35225,0.001713,17.4564}, /*cmz*/
          {3.069551,4.5714,5.0731,2.0867} /*cfz*/
     },
     {
          2455687.3,
          {-26.7776,0.00614,1220.2714,1.27053,0.016136,17.5065}, /*cmx*/
          {4.020785,5.6346,2.4978,5.4589}, /*cfx*/
          {4.5783,0.00117,174.6037,0.45126,0.006924,2.4482}, /*cmy*/
          {5.25238,2.3992,5.5589,0.3914}, /*cfy*/
          {45.3106,0.00238,1210.1403,1.25027,0.015841,17.4758}, /*cmz*/
          {5.598397,0.8344,3.9664,0.7545} /*cfz*/
     },
     {
          2455757.3,
          {-26.5147,-0.06438,1219.1289,1.11686,0.009678,17.5339}, /*cmx*/
          {0.193881,4.9744,4.6788,4.0156}, /*cfx*/
          {4.77,0.02737,176.2536,0.5748,0.003738,2.8946}, /*cmy*/
          {1.4199,1.7688,1.2069,5.3186}, /*cfy*/
          {45.6548,-0.0511,1210.1548,1.10704,0.009315,17.409}, /*cmz*/
          {1.7718,0.1461,6.2207,5.5976} /*cfz*/
     },
     {
          2455827.3,
          {-31.1673,-0.08244,1220.2754,2.44809,0.003026,17.5756}, /*cmx*/
          {2.540945,0.9679,4.7768,2.5065}, /*cfx*/
          {6.7066,0.02584,231.2605,1.05149,0.002434,3.8155}, /*cmy*/
          {3.909897,3.9085,1.4775,3.9396}, /*cfy*/
          {41.9563,-0.06814,1199.9987,2.44924,0.003614,17.174}, /*cmz*/
          {4.119521,2.4603,0.009,4.0897} /*cfz*/
     },
     {
          2455897.3,
          {-37.117,-0.02705,1221.4924,2.09824,0.015592,17.5875}, /*cmx*/
          {4.859414,3.262,0.1294,1.0179}, /*cfx*/
          {8.4162,0.00414,294.9727,0.79163,0.006389,4.4667}, /*cmy*/
          {0.048414,6.0398,2.9389,2.5178}, /*cfy*/
          {36.634,-0.03211,1186.1806,2.0384,0.014865,16.9644}, /*cmz*/
          {0.152759,4.7319,1.5847,2.5984} /*cfz*/
     },
     {
          2455967.3,
          {-39.3166,0.03894,1221.3261,0.42612,0.010404,17.6227}, /*cmx*/
          {0.964133,2.5467,2.5757,5.9221}, /*cfx*/
          {8.7272,-0.00936,318.6107,0.2286,0.003634,4.3929}, /*cmy*/
          {2.470179,5.3369,5.3496,1.1338}, /*cfy*/
          {34.0766,0.04658,1178.697,0.38462,0.011026,17.041}, /*cmz*/
          {2.540431,3.8207,4.1366,1.2189} /*cfz*/
     },
     {
          2456037.3,
          {-36.2117,0.03055,1221.691,1.8336,0.012562,17.599}, /*cmx*/
          {3.475057,5.09,1.9577,4.6095}, /*cfx*/
          {7.9657,-0.00637,287.3147,0.68902,0.005442,3.9074}, /*cmy*/
          {4.947637,1.6144,4.7988,6.0634}, /*cfy*/
          {37.8,0.02185,1187.377,1.8445,0.012831,17.0866}, /*cmz*/
          {5.051599,0.261,3.3645,6.1908} /*cfz*/
     },
     {
          2456107.3,
          {-34.0482,-0.0348,1220.2083,0.16806,0.013993,17.6062}, /*cmx*/
          {5.976527,4.7624,4.3161,3.2137}, /*cfx*/
          {7.5887,0.01208,266.544,0.18361,0.005303,4.0286}, /*cmy*/
          {1.130247,1.3312,0.8037,4.6691}, /*cfy*/
          {39.7667,-0.0397,1192.1843,0.20969,0.013138,17.0542}, /*cmz*/
          {1.271609,5.9855,5.8038,4.7936} /*cfz*/
     },
     {
          2456177.3,
          {-36.6012,-0.07351,1220.8998,2.13932,0.003229,17.6196}, /*cmx*/
          {2.077481,0.5102,6.0793,1.7249}, /*cfx*/
          {8.481,0.0151,302.8328,0.91501,0.002011,4.783}, /*cmy*/
          {3.558942,3.3192,1.7708,3.236}, /*cfy*/
          {36.8584,-0.08039,1183.2574,2.11988,0.003488,16.8575}, /*cmz*/
          {3.654392,1.9839,1.1903,3.2982} /*cfz*/
     },
     {
          2456247.3,
          {-41.8776,-0.03944,1221.5771,2.52737,0.011388,17.5607}, /*cmx*/
          {4.394154,2.8054,6.0266,0.2144}, /*cfx*/
          {9.3682,0.00064,363.0242,0.94995,0.004756,5.5122}, /*cmy*/
          {5.938655,5.4118,2.4565,1.7744}, /*cfy*/
          {30.6028,-0.05965,1166.9598,2.4683,0.010762,16.6109}, /*cmz*/
          {5.967145,4.2546,1.1528,1.7814} /*cfz*/
     },
     {
          2456317.3,
          {-44.8995,0.00831,1221.6659,0.75411,0.016659,17.6116}, /*cmx*/
          {0.458865,5.1356,2.0065,5.0696}, /*cfx*/
          {9.2971,-5e-05,399.4192,0.22552,0.00604,5.7238}, /*cmy*/
          {2.039328,1.2849,4.5303,0.3635}, /*cfy*/
          {25.9006,0.01713,1153.8007,0.71024,0.015924,16.6047}, /*cmz*/
          {2.02836,0.4069,3.5138,0.3521} /*cfz*/
     },
     {
          2456387.3,
          {-44.2139,0.0433,1221.7167,1.75048,0.00419,17.5547}, /*cmx*/
          {2.927473,4.5176,1.2506,3.7532}, /*cfx*/
          {9.4206,-0.00489,388.3417,0.67248,0.002206,5.3347}, /*cmy*/
          {4.503059,0.77,3.8266,5.306}, /*cfy*/
          {27.9408,0.04202,1157.949,1.79783,0.005203,16.696}, /*cmz*/
          {4.497151,5.973,2.6422,5.3174} /*cfz*/
     },
     {
          2456457.3,
          {-41.1491,-0.00789,1221.0706,0.84122,0.016492,17.5338}, /*cmx*/
          {5.456282,0.7283,3.8731,2.4001}, /*cfx*/
          {9.2298,0.00283,359.0363,0.23606,0.006171,5.1938}, /*cmy*/
          {0.720685,3.1346,0.2085,3.94}, /*cfy*/
          {31.6128,-0.0127,1166.8736,0.79702,0.015872,16.7489}, /*cmz*/
          {0.746775,2.2011,5.3169,3.9669} /*cfz*/
     },
     {
          2456527.3,
          {-41.6784,-0.05623,1221.1791,1.56747,0.007598,17.521}, /*cmx*/
          {1.604004,0.0515,6.0423,0.9391}, /*cfx*/
          {9.4441,0.00282,372.3126,0.67825,0.002959,5.7025}, /*cmy*/
          {3.158112,2.7275,1.8851,2.505}, /*cfy*/
          {30.6056,-0.08069,1162.9427,1.53822,0.007676,16.6465}, /*cmz*/
          {3.176619,1.497,1.2467,2.5048} /*cfz*/
     },
     {
          2456597.3,
          {-45.6301,-0.04165,1221.215,2.64817,0.006376,17.4557}, /*cmx*/
          {3.933577,2.3561,5.8045,5.7014}, /*cfx*/
          {9.4384,-0.00896,420.4721,0.99565,0.003111,6.3582}, /*cmy*/
          {5.526011,4.7985,2.1972,1.0253}, /*cfy*/
          {24.3795,-0.08151,1147.37,2.59869,0.005941,16.3598}, /*cmz*/
          {5.501496,3.7986,0.843,0.9809} /*cfz*/
     },
     {
          2456667.3,
          {-48.7823,-0.00698,1221.4072,1.73387,0.017462,17.5116}, /*cmx*/
          {6.254203,4.6556,1.5123,4.2282}, /*cfx*/
          {8.6314,-0.00599,459.5067,0.59486,0.00635,6.7051}, /*cmy*/
          {1.596879,0.6022,3.7958,5.8601}, /*cfy*/
          {18.089,-0.02507,1132.3092,1.66714,0.016652,16.2866}, /*cmz*/
          {1.532648,6.13,2.9693,5.7876} /*cfz*/
     },
     {
          2456737.3,
          {-49.6913,0.03736,1220.5488,1.04201,0.006239,17.442}, /*cmx*/
          {2.387565,3.9139,4.1995,2.878}, /*cfx*/
          {8.4667,0.00459,464.4503,0.43088,0.001582,6.5395}, /*cmy*/
          {4.02175,6.2406,0.2146,4.5048}, /*cfy*/
          {16.8751,0.05251,1130.0012,1.04554,0.005567,16.3394}, /*cmz*/
          {3.947443,5.4091,5.6384,4.4423} /*cfz*/
     },
     {
          2456807.3,
          {-47.0537,0.00618,1221.016,1.66944,0.015681,17.4463}, /*cmx*/
          {4.91584,0.2091,3.3443,1.5573}, /*cfx*/
          {9.0041,0.00547,441.9473,0.56948,0.005928,6.2772}, /*cmy*/
          {0.249729,2.4988,5.7478,3.1687}, /*cfy*/
          {21.3932,0.02106,1138.5338,1.62458,0.015307,16.4048}, /*cmz*/
          {0.196975,1.6918,4.8022,3.1251} /*cfz*/
     },
     {
          2456877.3,
          {-46.3369,-0.03352,1220.9608,0.73708,0.012255,17.514}, /*cmx*/
          {1.113389,5.8843,5.6962,0.1371}, /*cfx*/
          {9.3437,-0.00667,437.3102,0.35501,0.004494,6.5063}, /*cmy*/
          {2.721243,2.1952,1.5881,1.7593}, /*cfy*/
          {22.9416,-0.06708,1140.3405,0.72508,0.011939,16.3379}, /*cmz*/
          {2.678794,0.9823,0.9259,1.707} /*cfz*/
     },
     {
          2456947.3,
          {-48.6376,-0.03468,1220.7028,2.48389,0.002769,17.4699}, /*cmx*/
          {3.470971,1.9049,0.1482,4.909}, /*cfx*/
          {8.7024,-0.02006,468.6789,0.94576,0.002195,6.9791}, /*cmy*/
          {5.100187,4.1921,2.3336,0.2744}, /*cfy*/
          {17.7895,-0.09333,1128.423,2.43783,0.001742,16.0569}, /*cmz*/
          {5.03215,3.3516,1.3579,0.1884} /*cfz*/
     },
     {
          2457017.3,
          {-51.2991,-0.00609,1221.1273,2.40227,0.014445,17.5282}, /*cmx*/
          {5.778975,4.1728,1.0554,3.4024}, /*cfx*/
          {7.0702,-0.01947,502.3511,0.87738,0.005573,7.3242}, /*cmy*/
          {1.154396,6.2397,3.1926,5.0756}, /*cfy*/
          {10.6157,-0.06194,1114.9007,2.32927,0.0141,15.9451}, /*cmz*/
          {1.049198,5.6631,2.5228,4.958} /*cfz*/
     },
     {
          2457087.3,
          {-52.2156,0.01652,1219.5853,0.0722,0.014303,17.5441}, /*cmx*/
          {1.86302,0.9854,3.5005,2.0068}, /*cfx*/
          {5.7551,0.01001,513.5891,0.02556,0.005019,7.3032}, /*cmy*/
          {3.537647,0.3143,5.4824,3.686}, /*cfy*/
          {6.2394,0.03883,1109.0788,0.09427,0.013952,15.8885}, /*cmz*/
          {3.412119,2.5152,4.9996,3.5631} /*cfz*/
     },
     {
          2457157.3,
          {-50.95,0.00447,1220.3089,2.0387,0.010503,17.5125}, /*cmx*/
          {4.36126,5.9398,2.7443,0.6966}, /*cfx*/
          {6.7178,0.01486,503.9528,0.72478,0.003909,7.1077}, /*cmy*/
          {6.028674,1.7351,4.95,2.3596}, /*cfy*/
          {9.8767,0.04545,1113.5806,1.91107,0.009475,15.9472}, /*cmz*/
          {5.913397,1.1521,4.2177,2.2553} /*cfz*/
     },
     {
          2457227.3,
          {-50.1823,-0.01089,1220.31,0.29272,0.01625,17.5978}, /*cmx*/
          {0.599621,2.0595,5.2672,5.6104}, /*cfx*/
          {7.8127,-0.00826,493.3227,0.10668,0.005925,7.1426}, /*cmy*/
          {2.251861,3.3158,1.0787,0.9837}, /*cfy*/
          {13.586,-0.03774,1118.0592,0.24893,0.01527,15.9669}, /*cmz*/
          {2.155058,3.7769,0.4933,0.8827} /*cfz*/
     },
     {
          2457297.3,
          {-50.9098,-0.0217,1220.0124,2.03741,0.005901,17.5118}, /*cmx*/
          {2.999556,1.445,0.9194,4.1231}, /*cfx*/
          {7.0986,-0.02777,508.0362,0.79586,0.002677,7.4345}, /*cmy*/
          {4.660097,3.59,2.5712,5.7948}, /*cfy*/
          {10.5705,-0.09273,1111.5004,1.99376,0.004715,15.8031}, /*cmz*/
          {4.552218,2.9033,2.536,5.6718} /*cfz*/
     },
     {
          2457367.3,
          {-52.6166,0.00502,1220.5754,2.7708,0.009948,17.5195}, /*cmx*/
          {5.31101,3.7021,0.6668,2.5979}, /*cfx*/
          {4.8699,-0.03247,531.3221,1.04144,0.00418,7.6885}, /*cmy*/
          {0.712489,5.6469,2.7927,4.2918}, /*cfy*/
          {3.3936,-0.08691,1102.111,2.6412,0.009619,15.7361}, /*cmz*/
          {0.572556,5.2228,2.1728,4.1367} /*cfz*/
     },
     {
          2457437.3,
          {-52.4687,0.00189,1218.7282,1.20749,0.018247,17.5126}, /*cmx*/
          {1.35672,6.0613,2.9213,1.1557}, /*cfx*/
          {2.4739,0.00047,540.1098,0.42748,0.006697,7.7247}, /*cmy*/
          {3.061902,1.5364,4.7445,2.8572}, /*cfy*/
          {-3.0103,0.00189,1097.6316,1.12574,0.016997,15.7408}, /*cmz*/
          {2.895237,1.3495,4.4756,2.6864} /*cfz*/
     },
     {
          2457507.3,
          {-52.3097,-0.00378,1219.1907,1.66623,0.000941,17.4627}, /*cmx*/
          {3.805498,5.3908,1.4916,6.1097}, /*cfx*/
          {2.8607,0.01992,538.0096,0.60324,0.000276,7.6531}, /*cmy*/
          {5.512733,0.9301,2.7477,1.5204}, /*cfy*/
          {-1.9479,0.05125,1098.6327,1.52325,0.001581,15.7352}, /*cmz*/
          {5.344636,0.5893,2.1284,1.3618} /*cfz*/
     },
     {
          2457577.3,
          {-52.3185,0.00056,1219.425,1.30868,0.017753,17.4953}, /*cmx*/
          {0.060614,1.6399,4.7817,4.7808}, /*cfx*/
          {4.5518,0.00198,533.0569,0.46025,0.006498,7.6688}, /*cmy*/
          {1.752568,3.4127,0.4147,0.1787}, /*cfy*/
          {2.5512,0.00432,1100.8286,1.20824,0.016455,15.826}, /*cmz*/
          {1.603807,3.163,6.276,0.0337} /*cfz*/
     },
     {
          2457647.3,
          {-52.1986,-0.00735,1219.0304,1.31038,0.010832,17.4523}, /*cmx*/
          {2.512349,0.9696,0.7359,3.3297}, /*cfx*/
          {4.5387,-0.02859,537.2671,0.53476,0.00408,7.7912}, /*cmy*/
          {4.202243,3.0063,2.4037,5.0232}, /*cfy*/
          {2.4955,-0.07916,1098.6216,1.27806,0.009515,15.7233}, /*cmz*/
          {4.055229,2.4452,2.2995,4.8658} /*cfz*/
     },
     {
          2457717.3,
          {-52.8234,0.02126,1219.3867,2.83229,0.005229,17.4215}, /*cmx*/
          {4.84413,3.2447,0.4887,1.7993}, /*cfx*/
          {2.2149,-0.04027,548.6933,1.07063,0.002778,7.8983}, /*cmy*/
          {0.268733,5.0709,2.6833,3.5171}, /*cfy*/
          {-3.7302,-0.09839,1094.5047,2.62615,0.004599,15.7089}, /*cmz*/
          {0.097202,4.7868,2.0215,3.3308} /*cfz*/
     },
     {
          2457787.3,
          {-51.3576,0.00847,1217.523,2.1148,0.017499,17.4078}, /*cmx*/
          {0.866396,5.5566,2.4282,0.3104}, /*cfx*/
          {-0.7332,-0.01649,549.5837,0.77632,0.006431,7.8834}, /*cmy*/
          {2.597527,0.8939,4.0876,2.0484}, /*cfy*/
          {-10.9364,-0.04015,1094.9272,1.92848,0.015724,15.804}, /*cmz*/
          {2.396794,0.8408,3.9842,1.841} /*cfz*/
     },
     {
          2457857.3,
          {-50.9256,-0.00915,1217.2566,0.64853,0.01029,17.3826}, /*cmx*/
          {3.261545,4.8358,4.8831,5.2253}, /*cfx*/
          {-1.6091,0.0168,545.3071,0.25803,0.003798,7.8521}, /*cmy*/
          {5.003072,0.1453,0.3077,0.6801}, /*cfy*/
          {-13.0972,0.04046,1096.8621,0.61887,0.009504,15.7371}, /*cmz*/
          {4.790552,6.2821,0.2752,0.4748} /*cfz*/
     },
     {
          2457927.3,
          {-51.5958,-0.01066,1217.7543,1.9684,0.014445,17.4391}, /*cmx*/
          {5.784655,1.0871,4.2193,3.9161}, /*cfx*/
          {-0.1043,0.01844,548.7513,0.75227,0.005612,7.9387}, /*cmy*/
          {1.230937,2.7242,5.9201,5.644}, /*cfy*/
          {-9.4208,0.04446,1095.0406,1.8563,0.013839,15.7458}, /*cmz*/
          {1.03254,2.6369,5.7414,5.4549} /*cfz*/
     },
     {
          2457997.3,
          {-52.0389,0.00317,1217.7625,0.34311,0.015298,17.4442}, /*cmx*/
          {2.003186,0.4994,0.3638,2.5169}, /*cfx*/
          {1.0445,-0.02147,552.8331,0.17113,0.005764,7.9707}, /*cmy*/
          {3.723207,2.6704,1.9821,4.244}, /*cfy*/
          {-6.5426,-0.05374,1092.645,0.34021,0.013922,15.6883}, /*cmz*/
          {3.536371,1.9354,1.9248,4.0522} /*cfz*/
     },
     {
          2458067.3,
          {-51.8687,0.03754,1217.6293,2.5599,0.00284,17.43}, /*cmx*/
          {4.37176,2.7928,1.41,1.0014}, /*cfx*/
          {-0.7771,-0.04001,554.986,0.96801,0.002291,7.9072}, /*cmy*/
          {6.10278,4.4892,2.9812,2.7502}, /*cfy*/
          {-10.9409,-0.09593,1092.6059,2.31858,0.00233,15.6823}, /*cmz*/
          {5.900873,4.3458,3.2894,2.5338} /*cfz*/
     },
     {
          2458137.3,
          {-49.2884,0.0315,1216.3254,2.66302,0.013559,17.4975}, /*cmx*/
          {0.387686,5.077,2.0038,5.7665}, /*cfx*/
          {-3.7014,-0.0276,545.7332,1.00811,0.005216,7.7235}, /*cmy*/
          {2.14354,0.2856,3.5551,1.2576}, /*cfy*/
          {-17.9519,-0.07113,1098.7057,2.43247,0.012235,15.8054}, /*cmz*/
          {1.913328,0.3751,3.5486,1.0153} /*cfz*/
     },
     {
          2458207.3,
          {-47.1909,-0.00693,1215.5512,0.54549,0.016952,17.461}, /*cmx*/
          {2.736673,1.1719,4.3134,4.3515}, /*cfx*/
          {-5.5289,0.00672,531.5961,0.19511,0.006291,7.6167}, /*cmy*/
          {4.511267,2.5453,5.7525,6.1297}, /*cfy*/
          {-22.6745,0.01674,1105.4595,0.48506,0.015262,15.7905}, /*cmz*/
          {4.261254,2.8515,5.948,5.8795} /*cfz*/
     },
     {
          2458277.3,
          {-47.6091,-0.03773,1215.2259,1.98616,0.006416,17.537}, /*cmx*/
          {5.217861,0.4945,3.4684,3.0397}, /*cfx*/
          {-4.8484,0.02378,536.3579,0.76948,0.002511,7.779}, /*cmy*/
          {0.703637,1.9834,5.0792,4.8035}, /*cfy*/
          {-20.9263,0.06112,1103.7595,1.84826,0.006211,15.7209}, /*cmz*/
          {0.459207,2.1204,5.174,4.5666} /*cfz*/
     },
     {
          2458347.3,
          {-49.8135,0.00467,1216.3515,0.74562,0.018201,17.515}, /*cmx*/
          {1.468955,3.0402,6.1784,1.6892}, /*cfx*/
          {-3.1069,-0.00811,549.049,0.28758,0.006961,7.8892}, /*cmy*/
          {3.222642,4.4126,1.42,3.4451}, /*cfy*/
          {-16.4591,-0.01923,1096.8711,0.67132,0.016568,15.7059}, /*cmz*/
          {2.994982,4.6866,1.4949,3.2162} /*cfz*/
     },
     {
          2458417.3,
          {-49.5384,0.04769,1215.7472,1.94435,0.007006,17.4674}, /*cmx*/
          {3.88756,2.3382,1.8604,0.2079}, /*cfx*/
          {-3.9612,-0.03125,548.7721,0.73972,0.003231,7.7307}, /*cmy*/
          {5.644463,3.8922,3.1312,1.9762}, /*cfy*/
          {-18.3782,-0.08055,1097.1285,1.73952,0.006673,15.7389}, /*cmz*/
          {5.41192,3.8954,3.62,1.7301} /*cfz*/
     },
     {
          2458487.3,
          {-46.3174,0.05835,1215.3627,2.8656,0.008513,17.5107}, /*cmx*/
          {6.198724,4.608,1.6713,4.9637}, /*cfx*/
          {-6.328,-0.02803,530.5724,1.10306,0.003662,7.3946}, /*cmy*/
          {1.696615,5.9843,3.215,0.4718}, /*cfy*/
          {-24.3771,-0.08565,1107.3307,2.62686,0.007809,15.9705}, /*cmz*/
          {1.439334,6.213,3.2112,0.1985} /*cfz*/
     },
     {
          2458557.3,
          {-42.1463,0.00853,1214.7452,1.57163,0.018128,17.4256}, /*cmx*/
          {2.232764,0.6386,3.7798,3.5007}, /*cfx*/
          {-8.2241,-0.00464,502.8603,0.58967,0.006782,7.1226}, /*cmy*/
          {4.040121,1.8794,5.0368,5.3073}, /*cfy*/
          {-30.3277,-0.0136,1119.9356,1.42805,0.01642,16.0944}, /*cmz*/
          {3.757193,2.2994,5.4429,5.0187} /*cfz*/
     },
     {
          2458627.3,
          {-41.2783,-0.05196,1213.8102,1.31341,0.004174,17.4378}, /*cmx*/
          {4.660057,6.1977,0.3071,2.1576}, /*cfx*/
          {-8.3306,0.01207,497.728,0.47757,0.002012,7.3035}, /*cmy*/
          {0.190244,1.169,1.5064,3.9532}, /*cfy*/
          {-30.8157,0.04836,1123.0157,1.14817,0.004252,16.0839}, /*cmz*/
          {6.185643,1.5909,1.7255,3.6733} /*cfz*/
     },
     {
          2458697.3,
          {-44.868,-0.0079,1215.3032,1.68236,0.017781,17.4796}, /*cmx*/
          {0.912963,2.5101,5.654,0.8419}, /*cfx*/
          {-7.226,0.00628,519.5309,0.63752,0.006597,7.5502}, /*cmy*/
          {2.707126,3.8026,0.7091,2.6248}, /*cfy*/
          {-26.8465,0.0186,1113.0,1.48527,0.015557,15.9648}, /*cmz*/
          {2.437162,4.1459,0.9984,2.3597} /*cfz*/
     },
     {
          2458767.3,
          {-45.5013,0.04598,1214.2579,1.02415,0.012302,17.3935}, /*cmx*/
          {3.386074,1.886,1.6124,5.6879}, /*cfx*/
          {-7.0488,-0.01715,526.6909,0.39811,0.004802,7.4287}, /*cmy*/
          {5.174001,3.2914,2.8625,1.1956}, /*cfy*/
          {-26.0691,-0.05566,1109.1162,0.91528,0.011348,15.9989}, /*cmz*/
          {4.908977,3.4306,3.3252,0.9228} /*cfz*/
     },
     {
          2458837.3,
          {-42.3843,0.0795,1214.6624,2.74049,0.003685,17.4051}, /*cmx*/
          {5.727429,4.1434,1.684,4.1634}, /*cfx*/
          {-8.4934,-0.01964,504.4704,1.06431,0.002391,6.9843}, /*cmy*/
          {1.252983,5.3991,3.2026,5.9848}, /*cfy*/
          {-30.4132,-0.085,1120.0378,2.5206,0.003393,16.2962}, /*cmz*/
          {0.968715,5.7748,3.215,5.6854} /*cfz*/
     },
     {
          2458907.3,
          {-36.6447,0.03644,1214.1347,2.29503,0.015745,17.3715}, /*cmx*/
          {1.746937,0.1511,3.3084,2.6624}, /*cfx*/
          {-9.7683,-0.00797,463.8461,0.86408,0.005802,6.468}, /*cmy*/
          {3.588526,1.2255,4.4062,4.5166}, /*cfy*/
          {-36.3702,-0.03939,1137.4328,2.06271,0.013893,16.4716}, /*cmz*/
          {3.273996,1.8183,4.9956,4.1925} /*cfz*/
     },
     {
          2458977.3,
          {-33.8083,-0.03786,1213.9071,0.19112,0.012593,17.4087}, /*cmx*/
          {4.124194,5.6716,5.7273,1.2701}, /*cfx*/
          {-10.0993,-0.00064,440.6151,0.07009,0.005125,6.4729}, /*cmy*/
          {5.986588,6.2801,0.5528,3.1279}, /*cfy*/
          {-38.756,0.02312,1146.7846,0.11833,0.012301,16.5036}, /*cmz*/
          {5.654967,0.9551,1.1078,2.8039} /*cfz*/
     },
     {
          2459047.3,
          {-36.8801,-0.03558,1214.8889,2.0497,0.011786,17.4394}, /*cmx*/
          {0.347344,1.9605,5.1043,6.2508}, /*cfx*/
          {-10.1002,0.01114,461.2658,0.80238,0.004581,6.873}, /*cmy*/
          {2.192183,3.0154,6.0972,1.801}, /*cfy*/
          {-36.7249,0.04703,1138.861,1.83349,0.010276,16.3582}, /*cmz*/
          {1.875485,3.5824,0.3925,1.4958} /*cfz*/
     },
     {
          2459117.3,
          {-39.421,0.03015,1213.5172,0.10228,0.016701,17.3964}, /*cmx*/
          {2.864088,3.8663,1.2215,4.864}, /*cfx*/
          {-9.5233,-0.00425,483.8817,0.04227,0.006328,6.8924}, /*cmy*/
          {4.691677,4.6867,2.3539,0.4162}, /*cfy*/
          {-33.8475,-0.02719,1129.3432,0.07291,0.015106,16.2859}, /*cmz*/
          {4.389698,6.1316,2.9162,0.1115} /*cfz*/
     },
     {
          2459187.3,
          {-37.3446,0.08959,1214.2343,2.30307,0.003591,17.4608}, /*cmx*/
          {5.251082,3.6757,2.9263,3.3626}, /*cfx*/
          {-10.0546,-0.00622,466.0875,0.89896,0.002358,6.39}, /*cmy*/
          {0.809518,4.7979,3.5665,5.2306}, /*cfy*/
          {-36.1836,-0.07222,1136.5636,2.11778,0.00339,16.5124}, /*cmz*/
          {0.495336,5.3378,4.5033,4.8992} /*cfz*/
     },
     {
          2455197.4,
          {-170.9738,11.39125,1563.8778,175.01662,4.955542,9.7792}, /*cmx*/
          {1.904271,6.2589,3.8013,1.0413}, /*cfx*/
          {-29.9875,1.53879,148.9604,16.44544,0.462572,1.0318}, /*cmy*/
          {2.991918,1.0987,4.9477,2.1811}, /*cfy*/
          {-242.2281,10.67045,1496.0684,169.53105,4.826899,10.6274}, /*cmz*/
          {3.513513,1.6238,5.4782,2.6259} /*cfz*/
     },
     {
          2455219.4,
          {-160.6601,11.83721,1520.5912,168.05636,4.930061,9.3623}, /*cmx*/
          {2.14197,0.2707,4.1231,1.7484}, /*cfx*/
          {-29.7137,1.65687,141.9882,15.40151,0.449515,0.929}, /*cmy*/
          {3.215386,1.3599,5.2352,2.8837}, /*cfy*/
          {-224.8825,9.85256,1461.6609,164.0636,4.863188,10.4243}, /*cmz*/
          {3.753978,1.9246,5.8085,3.3191} /*cfz*/
     },
     {
          2455241.4,
          {-173.6428,14.32299,1490.9942,158.73762,4.739496,9.0577}, /*cmx*/
          {2.374108,0.547,4.4278,2.5711}, /*cfx*/
          {-28.7381,1.77382,128.8343,13.62724,0.411574,0.8435}, /*cmy*/
          {3.404185,1.5896,5.5026,3.556}, /*cfy*/
          {-202.0978,8.38886,1444.3432,160.42474,4.96509,10.0241}, /*cmz*/
          {4.006747,2.2295,6.1394,4.0001} /*cfz*/
     },
     {
          2455263.4,
          {-190.5957,17.19343,1459.6735,147.65879,4.468617,9.8524}, /*cmx*/
          {2.611042,0.8292,4.7532,3.3668}, /*cfx*/
          {-25.261,1.69671,114.4475,11.99896,0.377544,0.7185}, /*cmy*/
          {3.56412,1.785,5.7293,4.1341}, /*cfy*/
          {-157.5605,4.74034,1463.1595,160.63544,5.145132,8.7284}, /*cmz*/
          {4.263344,2.5066,0.1433,4.7488} /*cfz*/
     },
     {
          2455285.4,
          {-188.1022,18.36377,1430.5568,139.91455,4.379959,10.2847}, /*cmx*/
          {2.866598,1.1355,5.1078,4.0406}, /*cfx*/
          {-19.7512,1.42204,103.1477,10.88527,0.356276,0.5818}, /*cmy*/
          {3.695801,1.9442,5.9056,4.7189}, /*cfy*/
          {-98.8886,-0.46826,1503.3534,160.99544,5.242938,8.152}, /*cmz*/
          {4.507872,2.7455,0.3884,5.6695} /*cfz*/
     },
     {
          2455307.4,
          {-160.2286,17.28404,1420.4542,138.76952,4.569629,9.6456}, /*cmx*/
          {3.135403,1.4427,5.4439,4.7253}, /*cfx*/
          {-13.6789,1.04023,97.1616,10.27285,0.346695,0.5279}, /*cmy*/
          {3.820202,2.0934,6.0657,5.4047}, /*cfy*/
          {-48.515,-5.20258,1532.7591,158.22681,5.197688,9.3403}, /*cmz*/
          {4.737477,2.9693,0.631,0.2216} /*cfz*/
     },
     {
          2455329.4,
          {-121.4513,15.25783,1430.932,141.01553,4.844619,9.2943}, /*cmx*/
          {3.393637,1.7164,5.7323,5.4813}, /*cfx*/
          {-8.4121,0.64892,96.0497,9.9608,0.34358,0.5882}, /*cmy*/
          {3.977179,2.2759,6.2665,6.1007}, /*cfy*/
          {-21.8468,-7.98712,1536.9267,153.07607,5.109854,10.4367}, /*cmz*/
          {4.959033,3.2016,0.8979,0.8734} /*cfz*/
     },
     {
          2455351.4,
          {-91.3696,14.0884,1442.3697,141.17032,4.999217,9.7997}, /*cmx*/
          {3.623581,1.9553,5.9952,6.1704}, /*cfx*/
          {-5.0412,0.34073,97.842,9.75425,0.343855,0.6818}, /*cmy*/
          {4.195798,2.5302,0.2751,0.437}, /*cfy*/
          {-15.2103,-9.04931,1526.7184,148.13308,5.083852,10.8046}, /*cmz*/
          {5.174018,3.4392,1.1761,1.475} /*cfz*/
     },
     {
          2455373.4,
          {-78.77,14.61911,1438.0016,137.29944,5.012394,10.0891}, /*cmx*/
          {3.825628,2.1783,6.2608,0.4652}, /*cfx*/
          {-3.7942,0.14488,102.1419,9.80546,0.358683,0.7358}, /*cmy*/
          {4.481336,2.8679,0.6645,1.0742}, /*cfy*/
          {-11.5273,-9.86466,1518.203,143.82497,5.06748,11.1827}, /*cmz*/
          {5.373246,3.6563,1.4339,2.0513} /*cfz*/
     },
     {
          2455395.4,
          {-77.5916,16.32667,1420.5027,131.46867,4.989731,9.8408}, /*cmx*/
          {4.008991,2.3952,0.248,1.0177}, /*cfx*/
          {-3.3055,-0.04892,111.6787,10.51293,0.400517,0.8155}, /*cmy*/
          {4.807551,3.233,1.0728,1.7833}, /*cfy*/
          {6.0876,-11.94898,1515.1779,137.87064,4.903247,11.63}, /*cmz*/
          {5.545129,3.8312,1.659,2.5405} /*cfz*/
     },
     {
          2455417.4,
          {-73.1474,17.85377,1406.7727,126.69104,4.998235,9.784}, /*cmx*/
          {4.180453,2.5949,0.4987,1.575}, /*cfx*/
          {-1.0846,-0.45626,129.1198,11.76092,0.45147,0.9892}, /*cmy*/
          {5.117868,3.533,1.4182,2.4107}, /*cfy*/
          {44.6153,-15.96457,1510.7143,128.21255,4.495063,11.3771}, /*cmz*/
          {5.686376,3.9605,1.8648,2.933} /*cfz*/
     },
     {
          2455439.4,
          {-51.0523,17.81178,1413.8346,124.28505,4.985707,10.2978}, /*cmx*/
          {4.340383,2.7536,0.7024,2.0643}, /*cfx*/
          {4.944,-1.26079,153.0993,12.86709,0.476239,1.1324}, /*cmy*/
          {5.371665,3.7366,1.7042,2.8743}, /*cfy*/
          {99.4533,-21.53898,1497.5201,115.10157,3.883287,9.9903}, /*cmz*/
          {5.80435,4.0539,2.0766,3.2789} /*cfz*/
     },
     {
          2455461.4,
          {-3.2766,15.34504,1448.8593,123.84099,4.847501,10.7799}, /*cmx*/
          {4.485682,2.8541,0.8488,2.4294}, /*cfx*/
          {15.0617,-2.48657,179.269,13.33854,0.457241,1.1011}, /*cmy*/
          {5.572288,3.8669,1.9772,3.2577}, /*cfy*/
          {158.4736,-27.60999,1473.7078,100.7905,3.213128,7.7746}, /*cmz*/
          {5.912809,4.1275,2.3222,3.6515} /*cfz*/
     },
     {
          2455483.4,
          {70.2522,10.29643,1507.6166,124.74518,4.52255,10.502}, /*cmx*/
          {4.615428,2.8983,0.9406,2.6853}, /*cfx*/
          {27.4035,-3.95981,203.4092,13.21341,0.407297,0.8838}, /*cmy*/
          {5.745066,3.9607,2.2864,3.6819}, /*cfy*/
          {207.6969,-32.93102,1442.7515,88.16644,2.65885,5.5841}, /*cmz*/
          {6.02693,4.2024,2.6166,4.1514} /*cfz*/
     },
     {
          2455505.4,
          {163.2772,3.07872,1578.583,126.87996,4.024064,9.2116}, /*cmx*/
          {4.733561,2.9039,0.9822,2.8573}, /*cfx*/
          {38.6891,-5.36972,223.0106,12.91217,0.359818,0.6335}, /*cmy*/
          {5.915422,4.0577,2.6512,4.3251}, /*cfy*/
          {235.5691,-36.45995,1411.8021,79.67956,2.331152,4.4464}, /*cmz*/
          {6.159823,4.3031,2.9316,4.8232} /*cfz*/
     },
     {
          2455527.4,
          {266.1319,-5.57783,1647.8755,130.14062,3.421958,7.1217}, /*cmx*/
          {4.847642,2.8966,0.9738,2.9433}, /*cfx*/
          {45.4501,-6.37624,237.5432,12.97149,0.339941,0.5869}, /*cmy*/
          {6.101159,4.1938,3.0058,5.1591}, /*cfy*/
          {234.7287,-37.51992,1390.4437,77.04306,2.208606,4.4532}, /*cmz*/
          {0.037076,4.4463,3.1936,5.4167} /*cfz*/
     },
     {
          2455549.4,
          {368.1758,-14.83488,1702.3974,133.80681,2.814886,4.7997}, /*cmx*/
          {4.966522,2.9015,0.9107,2.8769}, /*cfx*/
          {45.1537,-6.71116,248.0618,13.86871,0.340542,0.6703}, /*cmy*/
          {0.027265,4.3804,3.2332,5.6779}, /*cfy*/
          {201.6054,-35.75409,1389.5709,81.33943,2.190746,4.5343}, /*cmz*/
          {0.227913,4.626,3.3444,5.7492} /*cfz*/
     },
     {
          2455571.4,
          {458.6518,-23.80469,1731.1269,136.48301,2.305307,3.239}, /*cmx*/
          {5.099157,2.9391,0.7949,2.4971}, /*cfx*/
          {36.9168,-6.24578,256.1861,15.84641,0.345745,0.6582}, /*cmy*/
          {0.257985,4.5925,3.2777,5.8334}, /*cfy*/
          {135.1461,-30.9889,1419.4333,92.92593,2.222216,4.0984}, /*cmz*/
          {0.445133,4.8174,3.3683,5.8224} /*cfz*/
     },
     {
          2455593.4,
          {525.9214,-31.44489,1726.0339,136.58056,1.957972,3.2375}, /*cmx*/
          {5.254945,3.0277,0.67,2.0428}, /*cfx*/
          {21.84,-5.03063,262.6209,18.6904,0.364152,0.57}, /*cmy*/
          {0.499039,4.7966,3.1618,5.6074}, /*cfy*/
          {36.5938,-23.18936,1485.6655,111.11126,2.348578,3.6282}, /*cmz*/
          {0.678207,4.9992,3.2798,5.5485} /*cfz*/
     },
     {
          2455615.4,
          {556.8341,-36.44981,1685.4351,133.37135,1.745634,3.5021}, /*cmx*/
          {5.444646,3.189,0.6499,2.0179}, /*cfx*/
          {2.9256,-3.30659,266.1545,21.71977,0.415505,0.6581}, /*cmy*/
          {0.735525,4.9795,2.9959,5.1184}, /*cfy*/
          {-88.0908,-12.67691,1582.6847,133.71602,2.670271,4.556}, /*cmz*/
          {0.91333,5.166,3.14,5.1075} /*cfz*/
     },
     {
          2455637.4,
          {539.4515,-37.46065,1621.3552,128.93279,1.633522,3.0213}, /*cmx*/
          {5.679077,3.4479,0.8773,2.4776}, /*cfx*/
          {-15.8639,-1.44105,264.6057,24.1167,0.490063,0.9448}, /*cmy*/
          {0.956315,5.1465,2.8987,4.913}, /*cfy*/
          {-224.1286,-0.5554,1688.0714,156.62904,3.194422,6.7282}, /*cmz*/
          {1.139806,5.3251,3.04,4.9652} /*cfz*/
     },
     {
          2455659.4,
          {470.3402,-33.75965,1563.957,129.5072,1.83595,3.433}, /*cmx*/
          {5.960846,3.8055,1.3654,3.5389}, /*cfx*/
          {-31.3915,0.23033,257.4852,25.40144,0.556132,1.201}, /*cmy*/
          {1.158962,5.3094,2.8968,4.9658}, /*cfy*/
          {-347.0749,11.10481,1766.6968,174.34773,3.750218,8.5839}, /*cmz*/
          {1.355669,5.4912,3.0329,5.0614} /*cfz*/
     },
     {
          2455681.4,
          {361.7318,-26.04373,1546.5367,140.9194,2.58206,6.2996}, /*cmx*/
          {6.270979,4.196,1.826,4.2597}, /*cfx*/
          {-42.4255,1.52781,247.1278,25.63186,0.594443,1.3104}, /*cmy*/
          {1.35013,5.4831,2.9761,5.1677}, /*cfy*/
          {-430.0741,19.83522,1788.1809,182.42396,4.112226,9.0858}, /*cmz*/
          {1.568123,5.6835,3.1317,5.3224} /*cfz*/
     },
     {
          2455703.4,
          {241.0222,-16.52969,1572.8407,160.02543,3.603012,9.4078}, /*cmx*/
          {0.289146,4.5387,2.1347,4.6653}, /*cfx*/
          {-48.8728,2.39145,236.7379,25.17387,0.604825,1.2665}, /*cmy*/
          {1.544212,5.6876,3.1368,5.5249}, /*cfy*/
          {-456.8449,23.95504,1746.8011,180.71352,4.202059,8.3861}, /*cmz*/
          {1.788872,5.9215,3.3433,5.7842} /*cfz*/
     },
     {
          2455725.4,
          {140.1554,-8.06929,1608.8771,176.98929,4.484245,11.1161}, /*cmx*/
          {0.555474,4.8215,2.3732,5.0328}, /*cfx*/
          {-50.7534,2.79967,228.6919,24.51728,0.601948,1.186}, /*cmy*/
          {1.75919,5.9471,3.3993,6.1028}, /*cfy*/
          {-431.5143,23.56878,1666.9405,174.34243,4.186469,8.0419}, /*cmz*/
          {2.025907,6.2132,3.664,0.1819} /*cfz*/
     },
     {
          2455747.4,
          {80.2526,-2.72086,1616.6443,184.74405,4.995196,11.1326}, /*cmx*/
          {0.787033,5.075,2.608,5.4755}, /*cfx*/
          {-48.7715,2.81283,225.4737,24.37586,0.617799,1.287}, /*cmy*/
          {2.005372,6.2698,3.7651,0.5529}, /*cfy*/
          {-377.6539,20.60436,1585.8189,169.57592,4.303765,8.9634}, /*cmz*/
          {2.274024,0.2533,4.0394,0.8701} /*cfz*/
     },
     {
          2455769.4,
          {60.9416,-0.67209,1587.3708,183.41566,5.175265,10.4592}, /*cmx*/
          {0.99836,5.3275,2.8699,6.0404}, /*cfx*/
          {-45.3957,2.66449,229.9723,25.34117,0.678902,1.5444}, /*cmy*/
          {2.271322,0.3373,4.1655,1.2216}, /*cfy*/
          {-325.6086,17.73426,1524.7365,167.32574,4.532314,9.7539}, /*cmz*/
          {2.514124,0.5634,4.3882,1.4557} /*cfz*/
     },
     {
          2455791.4,
          {62.0719,-0.27849,1543.5861,178.26976,5.234102,10.0186}, /*cmx*/
          {1.20155,5.5852,3.1522,0.3848}, /*cfx*/
          {-44.0487,2.68814,242.495,27.04707,0.764799,1.7236}, /*cmy*/
          {2.52913,0.6642,4.5258,1.8519}, /*cfy*/
          {-295.1744,16.79056,1478.5499,163.43901,4.64609,9.5634}, /*cmz*/
          {2.729617,0.8362,4.6879,2.0587} /*cfz*/
     },
     {
          2455813.4,
          {57.9434,0.71119,1515.4571,173.88362,5.306246,9.295}, /*cmx*/
          {1.397714,5.8294,3.4184,1.0135}, /*cfx*/
          {-46.2991,3.05912,259.5314,28.54171,0.836664,1.8359}, /*cmy*/
          {2.763987,0.9562,4.8494,2.5538}, /*cfy*/
          {-285.1295,17.73816,1434.4976,155.57396,4.559968,9.2905}, /*cmz*/
          {2.922694,1.0839,4.9684,2.7517} /*cfz*/
     },
     {
          2455835.4,
          {34.6272,3.57282,1514.5446,170.40582,5.341065,7.9806}, /*cmx*/
          {1.581296,6.0404,3.6432,1.7412}, /*cfx*/
          {-49.791,3.59239,277.7479,29.6305,0.897064,2.0352}, /*cmy*/
          {2.987328,1.2359,5.1699,3.2737}, /*cfy*/
          {-277.2981,18.95791,1392.9074,146.56949,4.429726,9.5634}, /*cmz*/
          {3.111099,1.33,5.2573,3.4383} /*cfz*/
     },
     {
          2455857.4,
          {-1.7133,7.78738,1527.728,165.56369,5.25097,7.6764}, /*cmx*/
          {1.753139,6.2237,3.8417,2.6427}, /*cfx*/
          {-49.7932,3.86559,297.5431,31.097,0.984182,2.1667}, /*cmy*/
          {3.217479,1.5157,5.4852,3.9376}, /*cfy*/
          {-252.2594,18.63182,1367.657,141.32853,4.460406,9.4112}, /*cmz*/
          {3.311437,1.5818,5.5452,4.0703} /*cfz*/
     },
     {
          2455879.4,
          {-31.7605,11.60386,1533.6389,158.39222,5.058128,9.0647}, /*cmx*/
          {1.925488,0.1254,4.0538,3.4433}, /*cfx*/
          {-43.4812,3.60295,321.0181,33.46106,1.109713,2.0731}, /*cmy*/
          {3.457087,1.7801,5.7644,4.6518}, /*cfy*/
          {-204.8305,16.17275,1370.2327,141.45396,4.672029,8.505}, /*cmz*/
          {3.525044,1.8239,5.8038,4.766} /*cfz*/
     },
     {
          2455901.4,
          {-39.5381,13.51643,1522.9596,150.4572,4.889949,10.2556}, /*cmx*/
          {2.113551,0.3404,4.3106,4.079}, /*cfx*/
          {-33.0161,2.96838,346.1964,35.93037,1.232109,2.0768}, /*cmy*/
          {3.69351,2.0168,6.0079,5.5006}, /*cfy*/
          {-147.839,12.63102,1393.4022,143.55885,4.90332,8.2647}, /*cmz*/
          {3.741054,2.0467,6.0358,5.5834} /*cfz*/
     },
     {
          2455923.4,
          {-25.8935,13.52662,1504.5323,144.12718,4.847311,10.5985}, /*cmx*/
          {2.323052,0.5884,4.6049,4.7014}, /*cfx*/
          {-24.0314,2.44891,365.495,37.07581,1.301307,2.3923}, /*cmy*/
          {3.918946,2.2417,6.2536,6.2816}, /*cfy*/
          {-101.8982,9.82129,1413.8373,142.97189,5.004859,9.2152}, /*cmz*/
          {3.953087,2.2653,6.2766,0.0456} /*cfz*/
     },
     {
          2455945.4,
          {-8.8983,13.24606,1491.1583,138.97913,4.842669,10.977}, /*cmx*/
          {2.544128,0.8431,4.9047,5.3407}, /*cfx*/
          {-20.4896,2.39668,372.3103,36.33528,1.310964,2.6239}, /*cmy*/
          {4.139904,2.4811,0.2529,0.6441}, /*cfy*/
          {-79.1666,8.8561,1414.4352,138.32338,4.985119,9.9186}, /*cmz*/
          {4.167015,2.504,0.2753,0.6731} /*cfz*/
     },
     {
          2455967.4,
          {-10.6615,14.73989,1480.4638,130.99023,4.65621,11.4251}, /*cmx*/
          {2.760252,1.081,5.2049,5.911}, /*cfx*/
          {-20.6692,2.65418,367.9654,34.53018,1.295664,2.6432}, /*cmy*/
          {4.366756,2.7407,0.5661,1.2833}, /*cfy*/
          {-72.8993,9.15559,1402.8205,132.52492,4.973807,10.0354}, /*cmz*/
          {4.392248,2.7681,0.592,1.3029} /*cfz*/
     },
     {
          2455989.4,
          {-40.1127,18.94082,1456.8084,117.14005,4.20946,10.7949}, /*cmx*/
          {2.965698,1.3079,5.5401,0.129}, /*cfx*/
          {-18.212,2.631,360.3874,32.71124,1.265539,2.7214}, /*cmy*/
          {4.597772,2.9859,0.8598,1.9185}, /*cfy*/
          {-60.4179,8.65818,1405.7127,128.77405,4.991767,10.5691}, /*cmz*/
          {4.62675,3.0232,0.8953,1.9353} /*cfz*/
     },
     {
          2456011.4,
          {-84.2381,24.76884,1413.0045,99.97922,3.732601,8.8935}, /*cmx*/
          {3.171763,1.5519,5.9474,0.678}, /*cfx*/
          {-7.5463,1.79131,355.7259,30.9148,1.181315,2.8321}, /*cmy*/
          {4.815399,3.167,1.0927,2.4262}, /*cfy*/
          {-18.0812,5.15077,1441.5331,126.17099,4.841122,11.416}, /*cmz*/
          {4.852107,3.2178,1.1433,2.4476} /*cfz*/
     },
     {
          2456033.4,
          {-115.1907,29.68426,1365.6294,86.84744,3.548777,7.3872}, /*cmx*/
          {3.395648,1.8299,0.0967,1.3961}, /*cfx*/
          {11.6276,0.07748,353.6654,28.77533,1.018509,2.6619}, /*cmy*/
          {5.003564,3.267,1.2638,2.7888}, /*cfy*/
          {62.0166,-2.18253,1500.0634,121.77747,4.32889,11.1803}, /*cmz*/
          {5.049979,3.3289,1.333,2.8191} /*cfz*/
     },
     {
          2456055.4,
          {-108.1345,31.27938,1347.2151,83.79628,3.62001,7.6893}, /*cmx*/
          {3.641024,2.0951,0.4285,2.0893}, /*cfx*/
          {34.9924,-2.12888,351.4213,26.47043,0.80406,2.1334}, /*cmy*/
          {5.163243,3.3071,1.3951,3.0658}, /*cfy*/
          {166.5548,-12.18443,1553.0824,115.09377,3.482501,9.2057}, /*cmz*/
          {5.219246,3.3725,1.4832,3.11} /*cfz*/
     },
     {
          2456077.4,
          {-55.2175,28.60638,1380.1018,90.53378,3.653481,8.3486}, /*cmx*/
          {3.888351,2.2734,0.6116,2.5183}, /*cfx*/
          {57.637,-4.36962,348.4435,24.47541,0.585991,1.4112}, /*cmy*/
          {5.307886,3.3266,1.5142,3.3132}, /*cfy*/
          {270.6176,-22.54079,1578.5801,107.95738,2.515507,6.0592}, /*cmz*/
          {5.372369,3.3881,1.6181,3.3865} /*cfz*/
     },
     {
          2456099.4,
          {34.1644,22.29558,1458.1808,103.27575,3.516791,7.9573}, /*cmx*/
          {4.111673,2.3634,0.6695,2.7447}, /*cfx*/
          {76.6765,-6.3609,346.3709,23.08185,0.399938,0.6946}, /*cmy*/
          {5.452384,3.3637,1.6526,3.5999}, /*cfy*/
          {352.6252,-31.14557,1572.1782,101.97796,1.665266,2.8448}, /*cmz*/
          {5.523346,3.4211,1.7641,3.7637} /*cfz*/
     },
     {
          2456121.4,
          {142.9148,13.74773,1556.7171,118.74981,3.27929,6.518}, /*cmx*/
          {4.300349,2.4099,0.6296,2.8104}, /*cfx*/
          {91.0523,-7.98509,347.1021,22.37935,0.264896,0.1503}, /*cmy*/
          {5.607441,3.4464,1.8505,4.4802}, /*cfy*/
          {402.4038,-36.89329,1543.2634,97.79855,1.079471,0.8724}, /*cmz*/
          {5.68115,3.5036,1.9462,5.0436} /*cfz*/
     },
     {
          2456143.4,
          {255.6041,4.28865,1652.4214,134.69488,3.080884,4.8609}, /*cmx*/
          {4.458799,2.4476,0.5165,2.6446}, /*cfx*/
          {100.3235,-9.18122,351.9433,22.46087,0.192653,0.2883}, /*cmy*/
          {5.778621,3.5896,2.1303,0.3423}, /*cfy*/
          {419.8561,-39.61658,1505.839,95.93995,0.798816,1.4471}, /*cmz*/
          {5.8491,3.6456,2.1472,0.1757} /*cfz*/
     },
     {
          2456165.4,
          {362.2587,-5.19886,1731.8458,149.58604,3.028949,4.3858}, /*cmx*/
          {4.596308,2.4924,0.3676,2.2026}, /*cfx*/
          {103.8332,-9.86528,361.854,23.59432,0.18921,0.3731}, /*cmy*/
          {5.967387,3.7938,2.3709,0.7427}, /*cfy*/
          {409.2776,-39.5975,1472.1169,97.271,0.793737,1.494}, /*cmz*/
          {6.027081,3.8386,2.2694,0.603} /*cfz*/
     },
     {
          2456187.4,
          {457.0821,-14.18301,1788.8991,162.33651,3.145477,5.5988}, /*cmx*/
          {4.721625,2.5508,0.2331,1.8895}, /*cfx*/
          {100.4218,-9.90135,377.9809,26.27085,0.255585,0.1466}, /*cmy*/
          {6.172327,4.0424,2.431,1.3344}, /*cfy*/
          {374.5751,-37.13106,1451.1166,102.84534,1.032238,0.4555}, /*cmz*/
          {6.213959,4.0635,2.2925,1.1542} /*cfz*/
     },
     {
          2456209.4,
          {534.9682,-22.17496,1819.7055,171.89473,3.366875,7.2316}, /*cmx*/
          {4.842696,2.6279,0.1537,1.8612}, /*cfx*/
          {88.6699,-9.12374,401.8579,31.03244,0.403963,0.4816}, /*cmy*/
          {0.105958,4.3036,2.4075,4.026}, /*cfy*/
          {317.7411,-32.36956,1449.8233,113.52953,1.507529,1.6763}, /*cmz*/
          {0.124988,4.2975,2.2992,4.0319} /*cfz*/
     },
     {
          2456231.4,
          {588.6422,-28.46131,1819.8569,177.09101,3.5846,8.2683}, /*cmx*/
          {4.968267,2.7323,0.1524,2.0073}, /*cfx*/
          {67.8228,-7.42425,434.5082,38.04422,0.643367,1.4149}, /*cmy*/
          {0.326689,4.5468,2.4031,4.3339}, /*cfy*/
          {240.5815,-25.46257,1472.7988,129.37347,2.201262,4.5474}, /*cmz*/
          {0.323291,4.5211,2.3297,4.3123} /*cfz*/
     },
     {
          2456253.4,
          {608.625,-32.08424,1786.1132,177.18052,3.702966,8.3179}, /*cmx*/
          {5.109239,2.8786,0.246,2.3069}, /*cfx*/
          {39.2805,-4.89492,474.0909,46.63486,0.955608,2.524}, /*cmy*/
          {0.541394,4.7599,2.4389,4.5668}, /*cfy*/
          {148.3482,-16.88048,1518.1762,148.77305,3.047791,7.7218}, /*cmz*/
          {0.520236,4.7249,2.388,4.5427} /*cfz*/
     },
     {
          2456275.4,
          {587.0209,-32.17342,1722.1611,173.16176,3.717306,7.8573}, /*cmx*/
          {5.27821,3.0851,0.4555,2.8186}, /*cfx*/
          {7.8726,-1.9561,513.5849,55.13169,1.285013,3.4999}, /*cmy*/
          {0.743551,4.9506,2.515,4.8114}, /*cfy*/
          {52.9078,-7.71098,1572.7323,168.03233,3.911294,10.4223}, /*cmz*/
          {0.711011,4.9127,2.4757,4.7858} /*cfz*/
     },
     {
          2456297.4,
          {524.5173,-28.59272,1644.4773,168.85671,3.783005,8.4317}, /*cmx*/
          {5.485054,3.3619,0.7861,3.5152}, /*cfx*/
          {-18.6325,0.67524,541.6003,61.27351,1.54919,4.0041}, /*cmy*/
          {0.935069,5.1384,2.6374,5.1153}, /*cfy*/
          {-27.6178,0.35453,1612.4843,182.07754,4.601724,11.8301}, /*cmz*/
          {0.896115,5.0994,2.602,5.0845} /*cfz*/
     },
     {
          2456319.4,
          {436.32,-22.52083,1578.2743,168.79925,4.09704,10.4906}, /*cmx*/
          {5.727681,3.689,1.1781,4.1489}, /*cfx*/
          {-32.7829,2.27491,547.8273,63.31239,1.68057,3.9363}, /*cmy*/
          {1.126493,5.3474,2.8217,5.5426}, /*cfy*/
          {-75.2644,5.58775,1613.4431,186.77265,4.961062,11.7003}, /*cmz*/
          {1.083693,5.3066,2.7847,5.5001} /*cfz*/
     },
     {
          2456341.4,
          {350.74,-16.39167,1537.3691,172.42092,4.574181,12.2152}, /*cmx*/
          {5.986496,4.02,1.544,4.6789}, /*cfx*/
          {-32.5977,2.59246,530.8148,61.38807,1.683971,3.6751}, /*cmy*/
          {1.332282,5.5993,3.0846,6.1447}, /*cfy*/
          {-83.7217,7.27909,1569.5471,182.20205,4.999931,11.024}, /*cmz*/
          {1.287019,5.5565,3.0439,6.0893} /*cfz*/
     },
     {
          2456363.4,
          {295.2708,-12.68712,1508.1207,173.17503,4.884225,12.4219}, /*cmx*/
          {6.238929,4.3296,1.8711,5.2441}, /*cfx*/
          {-24.4197,2.14497,501.0949,57.67512,1.640867,3.6492}, /*cmy*/
          {1.560734,5.8955,3.4147,0.5499}, /*cfy*/
          {-67.3473,6.61343,1503.986,173.77306,4.937096,11.1189}, /*cmz*/
          {1.515571,5.8545,3.3749,0.4968} /*cfz*/
     },
     {
          2456385.4,
          {276.3636,-12.08978,1468.8518,166.93567,4.881701,12.1052}, /*cmx*/
          {0.198932,4.633,2.2028,5.9319}, /*cfx*/
          {-19.1933,1.91711,473.3469,54.16617,1.606964,3.5642}, /*cmy*/
          {1.802237,6.2014,3.7516,1.2127}, /*cfy*/
          {-55.8603,6.27243,1454.234,167.0314,4.946624,11.2446}, /*cmz*/
          {1.76189,6.1689,3.7216,1.1682} /*cfz*/
     },
     {
          2456407.4,
          {271.6032,-12.67409,1425.1714,158.25663,4.800675,12.3815}, /*cmx*/
          {0.448424,4.9515,2.5631,0.3653}, /*cfx*/
          {-23.5766,2.56046,453.4951,50.68227,1.545303,3.1948}, /*cmy*/
          {2.035118,0.1931,4.047,1.9463}, /*cfy*/
          {-71.8637,8.43224,1434.9972,161.02473,4.907886,10.4505}, /*cmz*/
          {2.003457,0.1719,4.0286,1.9023} /*cfz*/
     },
     {
          2456429.4,
          {248.2191,-11.47966,1410.2328,154.91848,4.925268,11.9501}, /*cmx*/
          {0.71222,5.2664,2.9068,1.0394}, /*cfx*/
          {-34.3922,3.85173,437.6447,46.47033,1.426873,3.1109}, /*cmy*/
          {2.253009,0.4404,4.3207,2.8029}, /*cfy*/
          {-109.5001,12.75163,1426.5989,151.93393,4.668725,10.3403}, /*cmz*/
          {2.230212,0.4268,4.309,2.7645} /*cfz*/
     },
     {
          2456451.4,
          {193.78,-7.29302,1442.0191,157.43204,5.186329,10.4258}, /*cmx*/
          {0.97372,5.5355,3.1809,1.8116}, /*cfx*/
          {-42.3,4.97824,422.7419,42.30983,1.309549,3.435}, /*cmy*/
          {2.473978,0.7001,4.626,3.5606}, /*cfy*/
          {-138.932,16.63768,1407.6587,140.95085,4.365972,11.5099}, /*cmz*/
          {2.457609,0.688,4.614,3.5414} /*cfz*/
     },
     {
          2456473.4,
          {127.2016,-1.75453,1494.1808,159.64728,5.347847,10.2952}, /*cmx*/
          {1.214112,5.7588,3.4086,2.7234}, /*cfx*/
          {-40.2633,5.29328,412.7838,40.05246,1.287531,3.5204}, /*cmy*/
          {2.718109,0.9979,4.9745,4.2115}, /*cfy*/
          {-134.8565,17.76173,1383.5341,133.81889,4.297405,11.8164}, /*cmz*/
          {2.704062,0.9808,4.9558,4.208} /*cfz*/
     },
     {
          2456495.4,
          {79.6158,2.27931,1524.7206,157.26326,5.340438,11.7547}, /*cmx*/
          {1.436695,5.9766,3.6499,3.4966}, /*cfx*/
          {-29.0328,4.83746,414.3613,40.49603,1.379045,3.3512}, /*cmy*/
          {2.980819,1.3049,5.3099,4.9195}, /*cfy*/
          {-99.7798,16.23373,1373.9113,133.16313,4.517908,11.155}, /*cmz*/
          {2.963836,1.2781,5.2819,4.922} /*cfz*/
     },
     {
          2456517.4,
          {65.4655,3.36882,1520.5422,151.65839,5.301477,12.4653}, /*cmx*/
          {1.655707,6.2195,3.9361,4.143}, /*cfx*/
          {-16.1914,4.28442,426.9594,42.03517,1.498149,3.4642}, /*cmy*/
          {3.234464,1.5807,5.6057,5.6783}, /*cfy*/
          {-60.3543,14.38812,1378.0458,133.88109,4.745332,11.2644}, /*cmz*/
          {3.210137,1.5429,5.5687,5.6719} /*cfz*/
     },
     {
          2456539.4,
          {70.5565,2.67505,1503.5633,146.5824,5.35018,12.5515}, /*cmx*/
          {1.874346,0.1919,4.2384,4.7957}, /*cfx*/
          {-10.3241,4.42797,441.1468,42.25857,1.558859,3.764}, /*cmy*/
          {3.459801,1.8303,5.8998,0.0464}, /*cfy*/
          {-43.567,14.68299,1370.7922,129.12738,4.730159,11.7582}, /*cmz*/
          {3.425587,1.7803,5.8531,0.0264} /*cfz*/
     },
     {
          2456561.4,
          {64.0375,2.97194,1500.1476,141.93316,5.341655,13.1876}, /*cmx*/
          {2.077279,0.4132,4.5073,5.411}, /*cfx*/
          {-14.3214,5.56346,448.7386,40.44968,1.56548,3.7308}, /*cmy*/
          {3.662432,2.0848,6.2336,0.6305}, /*cfy*/
          {-55.3627,17.72294,1335.7022,117.95782,4.523346,11.1377}, /*cmz*/
          {3.616295,2.0202,6.1763,0.595} /*cfz*/
     },
     {
          2456583.4,
          {21.4668,6.57964,1513.7191,133.66037,4.999084,13.5839}, /*cmx*/
          {2.24593,0.5649,4.7322,5.8941}, /*cfx*/
          {-22.6279,7.20666,451.8148,38.13178,1.591912,3.4915}, /*cmy*/
          {3.859947,2.3558,0.3104,1.2804}, /*cfy*/
          {-77.5943,21.89445,1286.3913,105.69876,4.370464,9.8914}, /*cmz*/
          {3.799887,2.2765,0.246,1.225} /*cfz*/
     },
     {
          2456605.4,
          {-59.3947,13.88045,1529.1443,119.72347,4.222524,12.2876}, /*cmx*/
          {2.378865,0.6432,4.9394,6.2762}, /*cfx*/
          {-24.5045,8.35779,461.2016,37.23244,1.657283,3.6291}, /*cmy*/
          {4.062347,2.6013,0.6243,1.9546}, /*cfy*/
          {-81.8901,24.55845,1256.0151,98.18801,4.35619,9.6925}, /*cmz*/
          {3.988381,2.5148,0.5598,1.8934} /*cfz*/
     },
     {
          2456627.4,
          {-159.1105,23.28425,1531.2354,102.77823,3.180799,9.2131}, /*cmx*/
          {2.493542,0.6647,5.1772,0.3698}, /*cfx*/
          {-10.7216,8.09781,486.8479,38.0977,1.679857,4.019}, /*cmy*/
          {4.262117,2.7551,0.8414,2.4602}, /*cfy*/
          {-47.336,23.6501,1271.7536,96.70492,4.294747,10.3335}, /*cmz*/
          {4.178349,2.6721,0.7805,2.4098} /*cfz*/
     },
     {
          2456649.4,
          {-249.1619,32.30888,1514.051,87.51133,2.206057,5.6517}, /*cmx*/
          {2.614719,0.6673,5.5173,0.9071}, /*cfx*/
          {21.3101,6.07096,529.0745,40.17265,1.581692,4.0139}, /*cmy*/
          {4.444858,2.8001,0.96,2.7854}, /*cfy*/
          {30.163,18.57376,1336.7846,99.75801,4.002451,10.1935}, /*cmz*/
          {4.357493,2.7267,0.9034,2.745} /*cfz*/
     },
     {
          2456671.4,
          {-305.6211,38.79953,1482.1404,77.11729,1.624714,3.7931}, /*cmx*/
          {2.763892,0.7136,6.0008,1.8521}, /*cfx*/
          {67.0163,2.56592,578.5167,43.24912,1.363268,3.348}, /*cmy*/
          {4.606791,2.7783,0.9872,2.988}, /*cfy*/
          {139.8826,10.08011,1432.2215,106.45139,3.472121,8.5795}, /*cmz*/
          {4.520189,2.7151,0.9372,2.9544} /*cfz*/
     },
     {
          2456693.4,
          {-316.0687,41.56284,1449.3338,72.97355,1.479177,4.1849}, /*cmx*/
          {2.953469,0.8621,0.1607,2.6798}, /*cfx*/
          {117.9344,-1.74888,622.6566,47.01662,1.09234,2.2066}, /*cmy*/
          {4.756004,2.7489,0.9131,3.0528}, /*cfy*/
          {264.4776,-0.43588,1531.6626,115.86062,2.837613,5.8591}, /*cmz*/
          {4.671602,2.6928,0.8769,3.0306} /*cfz*/
     },
     {
          2456715.4,
          {-278.4358,40.26823,1434.8415,76.69124,1.489924,4.2658}, /*cmx*/
          {3.184166,1.1135,0.3481,3.078}, /*cfx*/
          {165.5093,-6.14773,651.5341,50.56311,0.864642,1.1194}, /*cmy*/
          {4.903851,2.7524,0.719,2.6903}, /*cfy*/
          {387.2378,-11.57189,1612.8283,125.94519,2.292371,3.1578}, /*cmz*/
          {4.821238,2.6982,0.7066,2.7368} /*cfz*/
     },
     {
          2456737.4,
          {-196.6777,35.05306,1456.5562,89.85196,1.53373,3.0482}, /*cmx*/
          {3.444126,1.4006,0.2669,3.1796}, /*cfx*/
          {203.1327,-10.02076,659.9837,52.80289,0.752171,1.1803}, /*cmy*/
          {5.059843,2.8055,0.4534,1.7535}, /*cfy*/
          {494.5057,-22.11936,1660.9601,134.14728,2.005827,3.0467}, /*cmz*/
          {4.977789,2.7478,0.4555,1.8406} /*cfz*/
     },
     {
          2456759.4,
          {-78.4167,26.31646,1522.5204,111.69595,1.774194,1.691}, /*cmx*/
          {3.711736,1.6573,0.0079,2.2812}, /*cfx*/
          {226.4105,-12.89323,647.8017,53.05971,0.733185,1.8091}, /*cmy*/
          {5.231282,2.915,0.273,1.5996}, /*cfy*/
          {574.3484,-30.91367,1668.2919,138.32976,1.974396,4.7941}, /*cmz*/
          {5.148387,2.8489,0.2564,1.6192} /*cfz*/
     },
     {
          2456781.4,
          {64.0507,14.86244,1623.6693,138.7639,2.373321,4.346}, /*cmx*/
          {3.964438,1.8664,6.0592,1.4774}, /*cfx*/
          {233.0505,-14.42535,619.7693,51.46532,0.722023,2.0576}, /*cmy*/
          {5.424427,3.0891,0.2829,1.8018}, /*cfy*/
          {615.6871,-36.73226,1635.4463,137.69331,2.001441,5.7565}, /*cmz*/
          {5.339769,3.0108,0.228,1.7832} /*cfz*/
     },
     {
          2456803.4,
          {212.4809,2.10758,1734.1894,166.0376,3.2203,8.1155}, /*cmx*/
          {4.189025,2.0398,5.9559,1.5061}, /*cfx*/
          {222.982,-14.45609,585.4276,49.2484,0.686849,1.8866}, /*cmy*/
          {5.64437,3.3386,0.519,2.2599}, /*cfy*/
          {610.731,-38.54046,1575.4619,134.08692,1.952668,5.4998}, /*cmz*/
          {5.558067,3.2473,0.4168,2.1863} /*cfz*/
     },
     {
          2456825.4,
          {344.4023,-9.99921,1821.6121,188.24502,4.065009,11.2068}, /*cmx*/
          {4.385072,2.1961,5.9563,1.6748}, /*cfx*/
          {198.2879,-13.03964,557.1134,48.63189,0.707637,1.8629}, /*cmy*/
          {5.891495,3.6601,0.9852,3.0752}, /*cfy*/
          {559.1993,-35.96095,1514.0443,132.69172,1.978269,5.2158}, /*cmz*/
          {5.804671,3.5602,0.8425,2.9325} /*cfz*/
     },
     {
          2456847.4,
          {438.3225,-19.43933,1860.3171,201.4254,4.687138,12.7819}, /*cmx*/
          {4.561372,2.3541,6.0325,1.9207}, /*cfx*/
          {162.8667,-10.44068,545.5323,51.66513,0.906749,2.731}, /*cmy*/
          {6.155246,4.0102,1.4894,3.8497}, /*cfy*/
          {470.8649,-29.60582,1478.9094,139.27629,2.426881,7.1206}, /*cmz*/
          {6.06911,3.9108,1.3555,3.739} /*cfz*/
     },
     {
          2456869.4,
          {479.4341,-24.68939,1840.2872,204.3138,4.978092,12.7363}, /*cmx*/
          {4.730865,2.5329,6.1801,2.2717}, /*cfx*/
          {122.6271,-7.15503,553.9581,58.30988,1.262556,4.0868}, /*cmy*/
          {0.129919,4.3262,1.843,4.3223}, /*cfy*/
          {364.8595,-21.07368,1480.8696,154.23246,3.298904,10.5034}, /*cmz*/
          {0.044966,4.2335,1.7374,4.249} /*cfz*/
     },
     {
          2456891.4,
          {465.0901,-25.28495,1770.8147,199.29768,5.001032,12.0886}, /*cmx*/
          {4.906212,2.7488,0.1242,2.7758}, /*cfx*/
          {85.4215,-3.89758,575.1513,66.18688,1.651307,5.2434}, /*cmy*/
          {0.360492,4.5851,2.0842,4.6793}, /*cfy*/
          {265.6247,-12.58935,1503.6133,171.26275,4.242124,13.3525}, /*cmz*/
          {0.276008,4.498,1.995,4.6175} /*cfz*/
     },
     {
          2456913.4,
          {407.7938,-22.15182,1677.7577,191.78796,4.97964,12.5006}, /*cmx*/
          {5.094525,3.0059,0.4264,3.3895}, /*cfx*/
          {59.5751,-1.4645,595.222,72.26405,1.957037,5.8016}, /*cmy*/
          {0.55752,4.8046,2.2865,5.0471}, /*cfy*/
          {195.8606,-6.33636,1515.3484,182.59146,4.93229,14.5649}, /*cmz*/
          {0.471391,4.7182,2.2016,4.9817} /*cfz*/
     },
     {
          2456935.4,
          {333.3041,-17.48279,1591.7795,186.68109,5.113255,14.0333}, /*cmx*/
          {5.291165,3.2834,0.7564,3.9592}, /*cfx*/
          {50.5148,-0.42017,602.2217,74.58002,2.115235,5.8024}, /*cmy*/
          {0.729779,5.0144,2.4988,5.5076}, /*cfy*/
          {167.8814,-3.6244,1491.6521,183.84699,5.215529,14.2626}, /*cmz*/
          {0.63862,4.9224,2.4084,5.4273} /*cfz*/
     },
     {
          2456957.4,
          {272.0292,-13.98415,1530.4128,183.75822,5.331091,14.9576}, /*cmx*/
          {5.479237,3.5431,1.0516,4.4678}, /*cfx*/
          {56.9233,-0.73013,593.7872,73.33749,2.147388,5.7727}, /*cmy*/
          {0.892843,5.2391,2.7497,6.0868}, /*cfy*/
          {176.8356,-4.21096,1431.7381,176.16626,5.160822,13.7515}, /*cmz*/
          {0.79275,5.1361,2.647,5.99} /*cfz*/
     },
     {
          2456979.4,
          {245.1801,-13.61139,1489.3609,178.19717,5.36993,14.4531}, /*cmx*/
          {5.642705,3.7635,1.2946,5.0236}, /*cfx*/
          {69.4628,-1.61537,579.3814,70.79828,2.149809,6.0505}, /*cmy*/
          {1.060326,5.4846,3.0352,0.4134}, /*cfy*/
          {200.5565,-6.219,1360.3908,165.38817,5.014376,14.0195}, /*cmz*/
          {0.948836,5.3698,2.921,0.3118} /*cfz*/
     },
     {
          2457001.4,
          {252.0388,-16.3616,1453.6521,166.6051,5.092222,13.9343}, /*cmx*/
          {5.784045,3.9563,1.5158,5.7096}, /*cfx*/
          {74.7341,-1.88283,574.2896,69.31377,2.194999,6.122}, /*cmy*/
          {1.235319,5.726,3.3074,0.9956}, /*cfy*/
          {209.1866,-6.95916,1314.2659,157.76927,4.98777,14.0782}, /*cmz*/
          {1.114185,5.6059,3.1911,0.887} /*cfz*/
     },
     {
          2457023.4,
          {267.7463,-19.99129,1415.5479,151.50965,4.66008,14.9495}, /*cmx*/
          {5.928556,4.1575,1.7631,0.1376}, /*cfx*/
          {63.8102,-0.69264,587.055,69.02478,2.249585,5.6024}, /*cmy*/
          {1.409552,5.9286,3.5219,1.6512}, /*cfy*/
          {182.3972,-4.48886,1316.6331,154.7864,5.055986,12.8474}, /*cmz*/
          {1.284317,5.8103,3.4096,1.5136} /*cfz*/
     },
     {
          2457045.4,
          {257.7238,-21.26064,1384.4474,140.48616,4.446964,15.8869}, /*cmx*/
          {6.110522,4.4024,2.0614,0.7641}, /*cfx*/
          {39.9012,1.71919,610.4272,68.22366,2.239474,5.3492}, /*cmy*/
          {1.579234,6.0942,3.6943,2.4832}, /*cfy*/
          {124.8734,0.92166,1356.6628,152.92724,5.054095,11.8393}, /*cmz*/
          {1.453571,5.977,3.581,2.3177} /*cfz*/
     },
     {
          2457067.4,
          {203.7412,-18.30876,1383.8045,139.85465,4.680779,15.0385}, /*cmx*/
          {0.062332,4.6821,2.3661,1.4153}, /*cfx*/
          {17.8465,4.03814,626.4267,65.54179,2.149755,6.0862}, /*cmy*/
          {1.759204,6.2701,3.8915,3.2847}, /*cfy*/
          {67.1317,6.61174,1394.8354,148.08743,4.896426,13.1745}, /*cmz*/
          {1.63132,6.146,3.7659,3.1427} /*cfz*/
     },
     {
          2457089.4,
          {123.5512,-12.54386,1422.374,146.32628,5.131253,14.2179}, /*cmx*/
          {0.328009,4.9526,2.6356,2.2124}, /*cfx*/
          {12.9238,4.85365,623.35,61.62174,2.06109,6.6283}, /*cmy*/
          {1.975209,0.2322,4.1828,3.9457}, /*cfy*/
          {44.9319,9.31684,1396.9911,139.88242,4.693371,14.6888}, /*cmz*/
          {1.840948,0.0947,4.0392,3.8168} /*cfz*/
     },
     {
          2457111.4,
          {62.8003,-8.06328,1462.45,148.58399,5.360739,15.3421}, /*cmx*/
          {0.591516,5.2137,2.9129,2.998}, /*cfx*/
          {26.4164,3.98872,608.9802,58.9879,2.088414,6.4019}, /*cmy*/
          {2.239555,0.5564,4.5552,4.6351}, /*cfy*/
          {67.6694,8.05534,1370.4774,133.33662,4.712689,14.4456}, /*cmz*/
          {2.099657,0.4135,4.4102,4.4907} /*cfz*/
     },
     {
          2457133.4,
          {57.1602,-8.28804,1452.5315,140.30931,5.263615,15.739}, /*cmx*/
          {0.850653,5.5144,3.2727,3.6624}, /*cfx*/
          {41.6493,2.92907,599.5458,57.85434,2.168181,6.3865}, /*cmy*/
          {2.525235,0.8861,4.9188,5.3967}, /*cfy*/
          {103.0914,5.65233,1354.4482,131.26552,4.93349,14.3138}, /*cmz*/
          {2.389015,0.7559,4.789,5.253} /*cfz*/
     },
     {
          2457155.4,
          {94.2018,-12.38468,1398.8379,128.8441,5.244782,14.3204}, /*cmx*/
          {1.126125,5.8844,3.7179,4.3749}, /*cfx*/
          {37.6367,3.64283,593.2821,53.93629,2.074163,6.6133}, /*cmy*/
          {2.783163,1.1618,5.2589,6.0501}, /*cfy*/
          {100.4019,6.79353,1357.115,125.20201,4.845233,15.1068}, /*cmz*/
          {2.657671,1.0429,5.1329,5.9318} /*cfz*/
     },
     {
          2457177.4,
          {116.5091,-15.2994,1371.337,124.12497,5.454712,14.1956}, /*cmx*/
          {1.417086,6.2407,4.1214,5.1659}, /*cfx*/
          {9.1358,6.73644,574.7032,44.688,1.757782,5.8904}, /*cmy*/
          {2.998831,1.4061,5.659,0.321}, /*cfy*/
          {37.3694,13.74369,1340.9205,106.5837,4.169969,14.0152}, /*cmz*/
          {2.879242,1.2777,5.5112,0.2014} /*cfz*/
     },
     {
          2457199.4,
          {69.7943,-11.98225,1419.1924,121.83561,5.332487,15.2737}, /*cmx*/
          {1.678461,0.1692,4.4009,5.7718}, /*cfx*/
          {-27.7405,10.84816,542.3071,33.55189,1.480033,4.3914}, /*cmy*/
          {3.202648,1.6855,6.1946,0.9855}, /*cfy*/
          {-55.8433,23.98054,1285.5438,80.30647,3.388778,10.5633}, /*cmz*/
          {3.077984,1.5192,6.0248,0.8207} /*cfz*/
     },
     {
          2457221.4,
          {-52.8819,-1.50822,1515.3523,115.34749,4.4942,14.0594}, /*cmx*/
          {1.876488,0.2097,4.5816,6.1787}, /*cfx*/
          {-49.3045,13.82017,514.7163,26.74902,1.459404,3.7546}, /*cmy*/
          {3.434056,2.0241,0.4328,1.8664}, /*cfy*/
          {-122.018,32.2815,1220.4633,60.65097,3.176235,8.3377}, /*cmz*/
          {3.296634,1.8196,0.3034,1.6947} /*cfz*/
     },
     {
          2457243.4,
          {-212.4031,12.80225,1603.2962,107.99942,3.159072,9.9393}, /*cmx*/
          {2.027188,0.1352,4.7014,0.2342}, /*cfx*/
          {-41.5372,14.26772,514.8331,26.92133,1.510478,4.1269}, /*cmy*/
          {3.698341,2.2721,0.7401,2.5328}, /*cfy*/
          {-122.0216,34.80146,1197.8224,57.11669,3.271352,8.9663}, /*cmz*/
          {3.551646,2.0882,0.6622,2.4424} /*cfz*/
     },
     {
          2457265.4,
          {-358.9793,26.4522,1648.9722,104.61662,1.806166,4.77}, /*cmx*/
          {2.163641,0.0479,4.7711,0.668}, /*cfx*/
          {-5.7529,12.15384,550.0379,32.2152,1.439076,4.0419}, /*cmy*/
          {3.957805,2.34,0.8514,2.9047}, /*cfy*/
          {-55.5234,31.11479,1244.5406,67.28374,3.141365,9.0307}, /*cmz*/
          {3.813254,2.1956,0.7994,2.8579} /*cfz*/
     },
     {
          2457287.4,
          {-462.6987,36.57128,1649.8653,104.40137,0.79347,1.539}, /*cmx*/
          {2.307714,0.0347,4.7241,2.2067}, /*cfx*/
          {47.2489,8.31795,607.7498,40.63877,1.261251,3.1091}, /*cmy*/
          {4.179598,2.3349,0.808,3.1109}, /*cfy*/
          {51.6224,23.24794,1341.0244,85.29194,2.766311,7.1873}, /*cmz*/
          {4.043456,2.2158,0.7676,3.091} /*cfz*/
     },
     {
          2457309.4,
          {-519.0187,42.53402,1622.0124,105.01438,0.298929,3.3147}, /*cmx*/
          {2.466262,0.1166,4.1158,3.5812}, /*cfx*/
          {105.9945,3.70439,670.0848,50.47237,1.095763,1.6959}, /*cmy*/
          {4.361887,2.3398,0.6166,3.0666}, /*cfy*/
          {171.2237,13.59213,1449.7772,106.25353,2.40531,4.1473}, /*cmz*/
          {4.232927,2.2347,0.586,3.1172} /*cfz*/
     },
     {
          2457331.4,
          {-536.4201,44.93938,1583.721,106.13177,0.331931,4.4232}, /*cmx*/
          {2.63779,0.2758,3.4819,4.0895}, /*cfx*/
          {163.2728,-1.08534,725.6214,60.2874,1.06169,1.0851}, /*cmy*/
          {4.516067,2.3722,0.3251,1.9514}, /*cfy*/
          {286.7,3.61525,1546.9916,126.89727,2.313723,2.1042}, /*cmz*/
          {4.390663,2.2738,0.3052,2.1888} /*cfz*/
     },
     {
          2457353.4,
          {-522.5421,44.38604,1548.4197,108.95773,0.451942,4.2598}, /*cmx*/
          {2.820603,0.4922,3.866,4.6036}, /*cfx*/
          {215.8073,-5.7731,769.5191,69.17517,1.191021,2.448}, /*cmy*/
          {4.652441,2.4273,0.0674,1.4577}, /*cfy*/
          {392.7267,-6.1636,1625.495,145.74275,2.565732,4.6662}, /*cmz*/
          {4.527196,2.33,0.0477,1.4549} /*cfz*/
     },
     {
          2457375.4,
          {-478.5511,40.94339,1527.4586,115.73375,0.779965,3.5488}, /*cmx*/
          {3.016223,0.7504,4.501,5.4204}, /*cfx*/
          {261.2091,-10.13409,799.0972,76.39513,1.413198,3.9152}, /*cmy*/
          {4.779175,2.5014,6.2094,1.5368}, /*cfy*/
          {487.5047,-15.51456,1683.4773,161.88946,3.040463,7.9698}, /*cmz*/
          {4.650941,2.3997,6.176,1.4912} /*cfz*/
     },
     {
          2457397.4,
          {-401.8393,34.36139,1533.6153,129.27453,1.492877,4.7982}, /*cmx*/
          {3.225875,1.0276,4.9047,0.2405}, /*cfx*/
          {295.4056,-13.76309,811.0617,81.07157,1.629265,4.926}, /*cmy*/
          {4.905487,2.5993,6.1807,1.7369}, /*cfy*/
          {565.6355,-23.86141,1715.689,173.86987,3.554018,10.542}, /*cmz*/
          {4.770631,2.4868,6.1242,1.6659} /*cfz*/
     },
     {
          2457419.4,
          {-293.1493,24.69211,1576.8651,150.81707,2.555153,8.7282}, /*cmx*/
          {3.444247,1.2915,5.1369,0.8794}, /*cfx*/
          {312.4146,-16.05112,802.2887,82.43234,1.757407,5.2435}, /*cmy*/
          {5.043887,2.7357,6.254,2.0315}, /*cfy*/
          {615.7605,-30.05668,1712.589,179.64358,3.92934,11.7651}, /*cmz*/
          {4.897832,2.6038,6.1643,1.9217} /*cfz*/
     },
     {
          2457441.4,
          {-163.407,12.90728,1652.6051,177.50995,3.811461,13.344}, /*cmx*/
          {3.659505,1.523,5.3006,1.2541}, /*cfx*/
          {306.5888,-16.3907,773.3923,80.6324,1.76697,5.0028}, /*cmy*/
          {5.210092,2.9332,0.1615,2.4836}, /*cfy*/
          {623.8324,-32.66409,1667.0074,178.0132,4.045934,11.5425}, /*cmz*/
          {5.047734,2.772,0.0221,2.3026} /*cfz*/
     },
     {
          2457463.4,
          {-36.2135,1.14517,1733.4043,202.35888,4.992951,16.9117}, /*cmx*/
          {3.86223,1.7275,5.4486,1.5687}, /*cfx*/
          {276.3949,-14.53039,732.803,77.73062,1.732923,5.037}, /*cmy*/
          {5.418907,3.2124,0.4984,3.1405}, /*cfy*/
          {581.107,-30.68442,1585.4469,171.13001,3.952163,11.0651}, /*cmz*/
          {5.237135,3.0166,0.2941,2.8843} /*cfz*/
     },
     {
          2457485.4,
          {57.3372,-7.72787,1776.8356,217.01908,5.783775,18.221}, /*cmx*/
          {4.05359,1.9273,5.6157,1.921}, /*cfx*/
          {227.9857,-10.92318,696.4018,77.23761,1.830374,6.149}, /*cmy*/
          {5.672547,3.5613,0.9462,3.8043}, /*cfy*/
          {493.801,-24.46575,1495.6159,165.79613,3.960993,12.5164}, /*cmz*/
          {5.475879,3.3455,0.7045,3.5757} /*cfz*/
     },
     {
          2457507.4,
          {92.9703,-11.40482,1750.3213,216.65645,5.999605,17.5131}, /*cmx*/
          {4.245302,2.1511,5.8358,2.3956}, /*cfx*/
          {175.7959,-6.81401,676.6228,80.46547,2.114444,7.6075}, /*cmy*/
          {5.947061,3.9165,1.3655,4.318}, /*cfy*/
          {388.0734,-16.22708,1433.3256,168.27077,4.372863,15.5381}, /*cmz*/
          {5.750325,3.7127,1.1506,4.1483} /*cfz*/
     },
     {
          2457529.4,
          {70.4464,-9.74392,1658.4429,204.61836,5.793386,17.0614}, /*cmx*/
          {4.452866,2.4249,6.1397,3.0255}, /*cfx*/
          {137.5259,-3.81164,668.2415,83.87026,2.391613,8.2726}, /*cmy*/
          {6.203379,4.2246,1.6925,4.7785}, /*cfy*/
          {302.5218,-9.45604,1406.2743,174.9079,4.953405,17.4844}, /*cmz*/
          {6.0205,4.0468,1.5165,4.6293} /*cfz*/
     },
     {
          2457551.4,
          {20.0216,-5.44695,1548.4942,191.45451,5.613914,18.3792}, /*cmx*/
          {4.682372,2.7464,0.2311,3.671}, /*cfx*/
          {124.3601,-2.99641,653.5088,82.90561,2.464338,8.003}, /*cmy*/
          {0.138529,4.4912,1.9731,5.3131}, /*cfy*/
          {267.2804,-7.03277,1382.3596,175.17677,5.209133,17.2564}, /*cmz*/
          {6.253287,4.3286,1.8126,5.1529} /*cfz*/
     },
     {
          2457573.4,
          {-13.1481,-2.71443,1475.8409,184.32338,5.684657,19.3333}, /*cmx*/
          {4.915083,3.0608,0.5859,4.2373}, /*cfx*/
          {133.1738,-4.16928,623.7741,77.01075,2.331671,7.799}, /*cmy*/
          {0.329598,4.7523,2.2694,5.9685}, /*cfy*/
          {282.9651,-9.23882,1331.1288,164.39826,4.984694,16.5756}, /*cmz*/
          {0.166449,4.5882,2.1021,5.8002} /*cfz*/
     },
     {
          2457595.4,
          {1.6109,-4.55237,1456.5733,179.28423,5.718579,18.1801}, /*cmx*/
          {5.116707,3.3077,0.8504,4.8272}, /*cfx*/
          {147.7257,-5.90576,590.0855,70.13246,2.177931,8.2598}, /*cmy*/
          {0.518588,5.0335,2.607,0.3369}, /*cfy*/
          {318.0298,-13.3808,1261.5419,148.72178,4.593066,17.3479}, /*cmz*/
          {0.351466,4.86,2.4287,0.1914} /*cfz*/
     },
     {
          2457617.4,
          {59.0826,-10.71147,1464.6043,169.72111,5.432948,16.89}, /*cmx*/
          {5.276082,3.4852,1.0431,5.5564}, /*cfx*/
          {148.7943,-6.44935,574.4231,66.92802,2.175965,8.4307}, /*cmy*/
          {0.721927,5.3124,2.9282,0.9139}, /*cfy*/
          {329.1279,-15.54473,1214.9535,138.917,4.472091,17.9968}, /*cmz*/
          {0.549401,5.14,2.7596,0.7819} /*cfz*/
     },
     {
          2457639.4,
          {121.067,-17.81999,1466.891,155.664,4.923397,18.0873}, /*cmx*/
          {5.418972,3.6414,1.2293,0.0246}, /*cfx*/
          {126.6709,-4.86012,590.6853,68.20701,2.302043,7.6734}, /*cmy*/
          {0.929999,5.5335,3.1545,1.5325}, /*cfy*/
          {290.3319,-13.25837,1227.6933,139.48382,4.69239,16.6253}, /*cmz*/
          {0.759638,5.3765,3.0084,1.3771} /*cfz*/
     },
     {
          2457661.4,
          {142.2668,-21.67076,1450.6005,143.21275,4.562391,19.6258}, /*cmx*/
          {5.584764,3.8389,1.476,0.6463}, /*cfx*/
          {88.1743,-1.69602,629.8844,71.03099,2.429792,7.066}, /*cmy*/
          {1.122843,5.6899,3.3019,2.3134}, /*cfy*/
          {210.9779,-7.20829,1293.6697,145.49738,5.001792,14.8378}, /*cmz*/
          {0.960434,5.5457,3.1671,2.1195} /*cfz*/
     },
     {
          2457683.4,
          {102.4213,-20.18197,1432.2781,139.585,4.695105,18.9367}, /*cmx*/
          {5.796058,4.1011,1.7793,1.2431}, /*cfx*/
          {52.9851,1.27069,665.2671,71.99466,2.474395,7.7321}, /*cmy*/
          {1.301225,5.8352,3.4533,3.0927}, /*cfy*/
          {129.8638,-0.83085,1363.7513,149.05025,5.168486,15.5594}, /*cmz*/
          {1.142617,5.6893,3.3102,2.9147} /*cfz*/
     },
     {
          2457705.4,
          {23.3308,-15.07624,1438.0944,145.16173,5.226731,17.5778}, /*cmx*/
          {6.036593,4.3757,2.0639,1.9462}, /*cfx*/
          {39.9904,2.27222,674.3472,69.72552,2.445321,8.4006}, /*cmy*/
          {1.486183,6.0336,3.6892,3.7217}, /*cfy*/
          {88.5281,2.05136,1386.9789,145.47296,5.132262,17.067}, /*cmz*/
          {1.320911,5.8696,3.5208,3.5616} /*cfz*/
     },
     {
          2457727.4,
          {-43.2599,-10.93047,1459.6598,149.27178,5.621493,18.1715}, /*cmx*/
          {6.263462,4.6146,2.3171,2.6667}, /*cfx*/
          {52.2144,0.94442,658.2238,66.29157,2.46505,8.0667}, /*cmy*/
          {1.698125,0.0309,4.026,4.3408}, /*cfy*/
          {100.6261,0.0502,1353.9759,137.22494,5.092547,16.6644}, /*cmz*/
          {1.5173,6.1272,3.8357,4.1588} /*cfz*/
     },
     {
          2457749.4,
          {-51.1061,-12.02935,1451.7376,140.0177,5.451923,18.7046}, /*cmx*/
          {0.169075,4.8354,2.6009,3.2558}, /*cfx*/
          {72.1357,-1.17473,640.0333,64.49656,2.588898,7.7143}, /*cmy*/
          {1.932533,0.3423,4.379,5.0528}, /*cfy*/
          {138.8069,-4.46743,1305.5875,131.27087,5.276805,15.5837}, /*cmz*/
          {1.738447,0.1535,4.1949,4.8449} /*cfz*/
     },
     {
          2457771.4,
          {5.1458,-19.08623,1386.9543,116.72351,4.88119,16.4871}, /*cmx*/
          {0.333541,5.0946,2.9954,3.8127}, /*cfx*/
          {72.9143,-1.59568,639.1103,62.34387,2.609897,8.109}, /*cmy*/
          {2.150096,0.5869,4.6721,5.7075}, /*cfy*/
          {150.4558,-6.66516,1293.1508,127.61208,5.426764,16.1442}, /*cmz*/
          {1.957508,0.4189,4.5037,5.5279} /*cfz*/
     },
     {
          2457793.4,
          {81.5381,-28.29884,1293.6727,92.4089,4.587952,13.2917}, /*cmx*/
          {0.511969,5.4445,3.4964,4.533}, /*cfx*/
          {38.1974,1.33356,651.1936,55.3652,2.287069,7.9054}, /*cmy*/
          {2.315494,0.7179,4.9252,6.2001}, /*cfy*/
          {93.6908,-2.44534,1326.7642,117.71301,4.996521,16.4569}, /*cmz*/
          {2.134467,0.5679,4.7501,6.0463} /*cfz*/
     },
     {
          2457815.4,
          {111.6533,-33.60014,1243.0368,81.34488,4.728079,13.0936}, /*cmx*/
          {0.738639,5.8009,3.924,5.3408}, /*cfx*/
          {-24.8881,7.17972,659.7542,43.534,1.638645,6.1237}, /*cmy*/
          {2.440417,0.7324,5.2266,0.3637}, /*cfy*/
          {-31.3763,8.62928,1374.9941,98.30108,3.803748,13.744}, /*cmz*/
          {2.265678,0.5827,4.991,0.1836} /*cfz*/
     },
     {
          2457837.4,
          {50.2657,-30.55054,1297.2818,82.48844,4.611465,13.9192}, /*cmx*/
          {1.001106,5.9475,4.1771,5.8945}, /*cfx*/
          {-90.0003,13.7026,653.1301,31.8036,0.990879,3.6192}, /*cmy*/
          {2.572524,0.6511,5.7731,1.0235}, /*cfy*/
          {-180.0465,22.89822,1399.2909,77.14211,2.25906,8.5006}, /*cmz*/
          {2.38937,0.4763,5.3607,0.6991} /*cfz*/
     },
     {
          2457859.4,
          {-99.4305,-18.91202,1449.6886,91.85871,3.833415,11.9384}, /*cmx*/
          {1.250497,5.8759,4.2775,6.2437}, /*cfx*/
          {-128.9681,18.34837,632.0877,24.64372,0.796537,2.7169}, /*cmy*/
          {2.76196,0.6086,0.3394,2.1805}, /*cfy*/
          {-291.5796,34.97908,1379.3546,63.25105,1.266968,4.6939}, /*cmz*/
          {2.554192,0.3617,6.1923,1.7709} /*cfz*/
     },
     {
          2457881.4,
          {-293.7221,-2.16139,1628.9148,109.61791,2.648276,7.0333}, /*cmx*/
          {1.468255,5.767,4.2002,0.1995}, /*cfx*/
          {-127.6697,19.67408,613.012,23.00652,0.86724,3.2233}, /*cmy*/
          {3.033004,0.8377,0.8198,2.9637}, /*cfy*/
          {-325.5372,40.95921,1330.3527,56.84769,1.327259,5.5371}, /*cmz*/
          {2.792976,0.4586,0.7421,2.8729} /*cfz*/
     },
     {
          2457903.4,
          {-480.4149,15.18714,1763.6401,129.74127,1.736815,1.3693}, /*cmx*/
          {1.668285,5.7425,3.7889,6.1331}, /*cfx*/
          {-89.2477,17.69379,618.1666,28.55354,0.79976,2.8644}, /*cmy*/
          {3.362863,1.2644,0.8939,3.3806}, /*cfy*/
          {-277.7251,39.90762,1298.5334,59.14973,1.35096,5.7629}, /*cmz*/
          {3.104289,0.8426,0.9669,3.3965} /*cfz*/
     },
     {
          2457925.4,
          {-624.7873,29.83258,1822.3088,144.59465,1.735555,4.3248}, /*cmx*/
          {1.865645,5.8096,3.2146,4.2824}, /*cfx*/
          {-26.2926,13.26706,655.1269,40.80218,0.656968,1.3841}, /*cmy*/
          {3.694233,1.6096,0.5691,3.6516}, /*cfy*/
          {-169.3434,33.09481,1323.4764,75.7364,1.082751,3.5546}, /*cmz*/
          {3.446019,1.2939,0.7145,3.7803} /*cfz*/
     },
     {
          2457947.4,
          {-713.3411,40.10707,1809.5504,151.03375,2.133724,7.6442}, /*cmx*/
          {2.067722,5.9479,3.019,4.503}, /*cfx*/
          {48.1509,7.37637,712.6368,56.08521,0.772875,0.8426}, /*cmy*/
          {3.983723,1.8449,6.2452,1.0665}, /*cfy*/
          {-27.3515,22.44083,1406.3853,103.53168,1.214386,0.5928}, /*cmz*/
          {3.764278,1.6258,6.2613,0.3508} /*cfz*/
     },
     {
          2457969.4,
          {-743.8775,45.27488,1748.3143,150.23421,2.33061,8.8103}, /*cmx*/
          {2.279172,6.1498,3.1032,4.8553}, /*cfx*/
          {123.8016,0.87596,773.8829,71.33032,1.199543,3.2821}, /*cmy*/
          {4.220351,2.0192,5.9373,1.1998}, /*cfy*/
          {125.4184,9.74874,1519.5584,135.07298,2.098377,5.4907}, /*cmz*/
          {4.029964,1.8531,5.8723,1.0613} /*cfz*/
     },
     {
          2457991.4,
          {-718.3509,45.06768,1669.6588,146.92288,2.282104,8.328}, /*cmx*/
          {2.505197,0.1368,3.3999,5.3761}, /*cfx*/
          {191.6377,-5.39173,824.3419,84.26886,1.69704,5.458}, /*cmy*/
          {4.411636,2.1633,5.8693,1.4282}, /*cfy*/
          {269.2327,-3.20924,1629.1151,164.30924,3.204961,10.2862}, /*cmz*/
          {4.241442,2.0217,5.7907,1.3255} /*cfz*/
     },
     {
          2458013.4,
          {-643.6542,39.84115,1607.2312,148.47546,2.348567,8.4489}, /*cmx*/
          {2.746603,0.4664,3.9133,6.1445}, /*cfx*/
          {242.5704,-10.5194,852.9502,93.08949,2.108588,6.8929}, /*cmy*/
          {4.572163,2.2989,5.9063,1.6787}, /*cfy*/
          {385.0599,-14.55815,1706.4781,186.64452,4.192227,13.8781}, /*cmz*/
          {4.411127,2.1632,5.8177,1.5736} /*cfz*/
     },
     {
          2458035.4,
          {-534.6121,30.84759,1585.5225,160.39865,2.992529,11.4769}, /*cmx*/
          {2.9919,0.804,4.4465,0.5727}, /*cfx*/
          {268.787,-13.69131,853.4864,96.76407,2.34887,7.3622}, /*cmy*/
          {4.718569,2.4462,6.0124,1.9825}, /*cfy*/
          {456.4052,-22.57334,1733.4804,199.14134,4.86646,15.6079}, /*cmz*/
          {4.555826,2.3018,5.904,1.8496} /*cfz*/
     },
     {
          2458057.4,
          {-413.6312,20.16779,1605.1267,180.74231,4.101573,15.9717}, /*cmx*/
          {3.219979,1.0924,4.8059,1.0339}, /*cfx*/
          {266.6081,-14.46238,826.6334,95.63979,2.406297,7.1226}, /*cmy*/
          {4.866636,2.6243,6.19,2.3919}, /*cfy*/
          {473.7639,-26.14404,1705.4553,201.29785,5.15655,15.6069}, /*cmz*/
          {4.692084,2.4575,6.0466,2.2009} /*cfz*/
     },
     {
          2458079.4,
          {-306.3882,10.27552,1641.2134,201.60425,5.232481,19.6445}, /*cmx*/
          {3.414732,1.3193,5.0384,1.3778}, /*cfx*/
          {238.684,-12.96996,780.7101,91.70243,2.358318,6.984}, /*cmy*/
          {5.028541,2.8472,0.1672,2.9336}, /*cfy*/
          {438.2767,-25.13984,1632.1496,195.58746,5.142611,15.0508}, /*cmz*/
          {4.833951,2.6473,6.2565,2.672} /*cfz*/
     },
     {
          2458101.4,
          {-235.4519,3.41592,1659.1763,214.8464,6.032009,21.2802}, /*cmx*/
          {3.57412,1.5051,5.2196,1.7129}, /*cfx*/
          {194.2248,-9.965,729.3629,87.86282,2.340888,7.657}, /*cmy*/
          {5.208617,3.1119,0.4967,3.5079}, /*cfy*/
          {362.9193,-20.53966,1535.605,187.01503,5.046682,15.6388}, /*cmz*/
          {4.990574,2.8791,0.2548,3.2303} /*cfz*/
     },
     {
          2458123.4,
          {-213.6617,0.96439,1633.4039,215.72224,6.319141,20.9651}, /*cmx*/
          {3.707243,1.6776,5.3977,2.1143}, /*cfx*/
          {146.9916,-6.63914,685.5826,85.96753,2.432009,8.7483}, /*cmy*/
          {5.39828,3.3891,0.8335,3.9986}, /*cfy*/
          {270.945,-14.30604,1443.4316,180.74536,5.103612,17.6559}, /*cmz*/
          {5.161839,3.1401,0.5759,3.7542} /*cfz*/
     },
     {
          2458145.4,
          {-238.4658,2.87336,1559.3144,204.53368,6.126712,20.2293}, /*cmx*/
          {3.828949,1.8633,5.6082,2.6291}, /*cfx*/
          {111.3607,-4.27357,654.6777,85.06543,2.556988,9.3278}, /*cmy*/
          {5.577316,3.6394,1.1169,4.4349}, /*cfy*/
          {191.1786,-8.97162,1376.7993,178.12003,5.328808,19.4616}, /*cmz*/
          {5.334751,3.3953,0.8741,4.2098} /*cfz*/
     },
     {
          2458167.4,
          {-289.1021,7.37644,1457.9156,187.08237,5.720016,20.8875}, /*cmx*/
          {3.956828,2.0831,5.8747,3.2114}, /*cfx*/
          {97.2431,-3.7771,632.629,82.37422,2.56977,9.0271}, /*cmy*/
          {5.7276,3.8463,1.3416,4.9133}, /*cfy*/
          {149.4966,-6.87428,1339.274,175.10123,5.475875,19.5663}, /*cmz*/
          {5.489359,3.6133,1.114,4.6716} /*cfz*/
     },
     {
          2458189.4,
          {-330.3595,11.28928,1371.4239,172.40214,5.467089,22.3637}, /*cmx*/
          {4.1065,2.3353,6.1793,3.7598}, /*cfx*/
          {105.3078,-5.24047,612.1322,76.04739,2.394157,8.5099}, /*cmy*/
          {5.84959,4.0235,1.542,5.5194}, /*cfy*/
          {157.1541,-9.08838,1317.722,166.15193,5.283559,18.3981}, /*cmz*/
          {5.616212,3.7902,1.3087,5.2421} /*cfz*/
     },
     {
          2458211.4,
          {-326.032,11.20864,1345.1712,166.33284,5.504934,22.2427}, /*cmx*/
          {4.280404,2.5773,0.1659,4.2899}, /*cfx*/
          {124.7928,-7.71346,589.8013,67.06087,2.094386,8.8753}, /*cmy*/
          {5.968476,4.2079,1.7708,6.2017}, /*cfy*/
          {200.4593,-14.44723,1294.7799,149.80156,4.724554,18.4483}, /*cmz*/
          {5.730894,3.9531,1.5027,5.9387} /*cfz*/
     },
     {
          2458233.4,
          {-260.7213,5.51877,1394.7515,166.4049,5.616956,20.1284}, /*cmx*/
          {4.463017,2.7626,0.3518,4.9266}, /*cfx*/
          {136.7443,-9.47061,569.958,59.35434,1.868907,9.7272}, /*cmy*/
          {6.126903,4.4453,2.0741,0.5303}, /*cfy*/
          {241.0972,-19.50501,1262.179,131.37169,4.10183,20.3894}, /*cmz*/
          {5.873082,4.1536,1.7592,0.3182} /*cfz*/
     },
     {
          2458255.4,
          {-158.5594,-3.80685,1481.8205,165.52724,5.551039,19.538}, /*cmx*/
          {4.643812,2.9047,0.4898,5.7302}, /*cfx*/
          {124.2288,-8.92535,566.4008,57.74125,1.916346,9.6456}, /*cmy*/
          {0.0745,4.7384,2.4057,1.1093}, /*cfy*/
          {235.7146,-20.26257,1234.3117,121.38981,3.922837,21.0818}, /*cmz*/
          {6.085971,4.4348,2.0982,0.9061} /*cfz*/
     },
     {
          2458277.4,
          {-77.0505,-11.62261,1536.4758,158.77046,5.270033,21.8809}, /*cmx*/
          {4.838815,3.0746,0.6764,0.194}, /*cfx*/
          {86.0268,-5.89972,593.1435,62.78648,2.196422,8.704}, /*cmy*/
          {0.358491,5.014,2.6647,1.8115}, /*cfy*/
          {169.7229,-15.2667,1248.6416,126.72291,4.378868,19.1897}, /*cmz*/
          {0.089825,4.75,2.4164,1.5649} /*cfz*/
     },
     {
          2458299.4,
          {-66.7929,-13.19753,1521.5504,148.85743,5.067825,22.6565}, /*cmx*/
          {5.07892,3.3505,1.003,0.8253}, /*cfx*/
          {42.4487,-2.21918,637.5453,68.63003,2.461153,8.7358}, /*cmy*/
          {0.637717,5.2445,2.8781,2.6372}, /*cfy*/
          {77.9446,-7.61864,1312.2887,139.04465,5.008346,18.1521}, /*cmz*/
          {0.3935,5.0215,2.6665,2.3781} /*cfz*/
     },
     {
          2458321.4,
          {-123.7374,-8.65842,1477.43,146.14626,5.386691,20.7392}, /*cmx*/
          {5.374718,3.726,1.421,1.5182}, /*cfx*/
          {22.1993,-0.57613,660.8709,68.88825,2.519546,9.5068}, /*cmy*/
          {0.889847,5.4874,3.147,3.3431}, /*cfy*/
          {22.9084,-3.14165,1359.887,142.35242,5.243338,19.4731}, /*cmz*/
          {0.664362,5.2722,2.9311,3.1266} /*cfz*/
     },
     {
          2458343.4,
          {-184.3701,-3.65847,1465.9845,150.21434,5.928949,20.2779}, /*cmx*/
          {5.678925,4.0751,1.7855,2.3019}, /*cfx*/
          {36.9013,-2.1926,642.6659,63.61081,2.464028,9.0712}, /*cmy*/
          {1.138662,5.8127,3.5441,3.9733}, /*cfy*/
          {40.709,-5.4495,1329.0615,131.47002,5.067496,19.0538}, /*cmz*/
          {0.911465,5.5768,3.3041,3.7538} /*cfz*/
     },
     {
          2458365.4,
          {-176.782,-4.88564,1472.7057,143.66626,5.839491,21.1567}, /*cmx*/
          {5.921393,4.3301,2.0952,2.9521}, /*cfx*/
          {67.6932,-5.4951,607.2072,59.26508,2.555736,8.0164}, /*cmy*/
          {1.407741,6.2115,4.0012,4.7156}, /*cfy*/
          {105.1945,-12.49309,1244.273,118.1068,5.068495,16.4598}, /*cmz*/
          {1.166832,5.9701,3.7751,4.4542} /*cfz*/
     },
     {
          2458387.4,
          {-81.5152,-14.45218,1441.8721,117.04564,4.887449,18.9087}, /*cmx*/
          {6.088753,4.5278,2.455,3.4811}, /*cfx*/
          {78.8038,-7.23769,596.5306,57.99611,2.687449,8.1718}, /*cmy*/
          {1.672626,0.2524,4.3608,5.4746}, /*cfy*/
          {146.441,-18.00344,1193.89,113.28002,5.37433,15.8512}, /*cmz*/
          {1.431647,0.056,4.1806,5.2478} /*cfz*/
     },
     {
          2458409.4,
          {53.211,-28.26333,1365.4314,80.33453,3.839688,13.7491}, /*cmx*/
          {6.224271,4.7352,2.9856,4.1089}, /*cfx*/
          {45.8311,-5.04843,622.6523,54.41885,2.495127,8.3647}, /*cmy*/
          {1.87599,0.3889,4.5993,6.0147}, /*cfy*/
          {105.1263,-16.34732,1233.6729,109.75186,5.282975,16.7874}, /*cmz*/
          {1.657344,0.2443,4.4443,5.8513} /*cfz*/
     },
     {
          2458431.4,
          {150.2427,-39.31848,1287.0908,52.96592,3.583857,10.8925}, /*cmx*/
          {0.105296,5.0105,3.5798,5.0086}, /*cfx*/
          {-26.4732,0.87326,664.2045,47.29472,1.884213,6.8804}, /*cmy*/
          {2.009577,0.3277,4.7695,0.1317}, /*cfy*/
          {-25.8548,-6.42791,1340.1699,101.05077,4.375153,15.0979}, /*cmz*/
          {1.813779,0.2191,4.6047,6.2614} /*cfz*/
     },
     {
          2458453.4,
          {158.1216,-42.63842,1264.6996,46.85424,3.651743,11.6188}, /*cmx*/
          {0.331263,5.2303,3.946,5.7501}, /*cfx*/
          {-110.407,8.19563,694.9921,41.83812,1.075984,4.0672}, /*cmy*/
          {2.117142,0.1287,4.923,0.5692}, /*cfy*/
          {-203.4072,8.27404,1455.5342,94.54661,2.900653,10.1541}, /*cmz*/
          {1.92878,0.0391,4.6937,0.3417} /*cfz*/
     },
     {
          2458475.4,
          {76.5849,-37.7296,1329.4516,59.86602,3.323438,10.999}, /*cmx*/
          {0.591936,5.2437,4.0793,6.1866}, /*cfx*/
          {-176.9635,14.34008,700.3204,40.70361,0.367327,1.617}, /*cmy*/
          {2.24283,6.2526,5.143,1.5462}, /*cfy*/
          {-370.4042,22.81238,1533.8883,96.64896,1.404956,4.2071}, /*cmz*/
          {2.044107,6.1474,4.667,0.9023} /*cfz*/
     },
     {
          2458497.4,
          {-60.1471,-27.26889,1459.123,85.52963,2.639261,7.6174}, /*cmx*/
          {0.838694,5.2236,4.0108,0.2032}, /*cfx*/
          {-212.6226,18.01154,681.6246,40.95325,0.094402,1.8502}, /*cmy*/
          {2.408267,6.2623,1.5385,3.1428}, /*cfy*/
          {-490.9185,33.94169,1559.3373,102.50706,0.44866,2.3816}, /*cmz*/
          {2.183955,6.1031,3.8916,2.9933} /*cfz*/
     },
     {
          2458519.4,
          {-217.3384,-14.13861,1607.785,116.38697,2.078603,2.5519}, /*cmx*/
          {1.054487,5.2559,3.6711,0.2797}, /*cfx*/
          {-219.2578,19.25206,650.9635,40.71867,0.261768,2.4766}, /*cmy*/
          {2.615475,0.1517,2.1044,3.8321}, /*cfy*/
          {-557.4927,40.85155,1541.4705,106.45467,0.723668,5.1282}, /*cmz*/
          {2.354884,6.1917,2.7813,3.8875} /*cfz*/
     },
     {
          2458541.4,
          {-377.6421,0.19204,1746.4257,147.44998,2.234252,3.5755}, /*cmx*/
          {1.244774,5.3285,3.1645,4.3103}, /*cfx*/
          {-203.1685,18.50297,621.7654,40.96056,0.220224,2.2792}, /*cmy*/
          {2.859098,0.4504,2.5468,4.4168}, /*cfy*/
          {-573.8267,43.67811,1498.5612,107.55362,0.989866,6.2884}, /*cmz*/
          {2.557872,0.1052,2.8316,4.405} /*cfz*/
     },
     {
          2458563.4,
          {-532.1252,14.89208,1859.4982,175.43928,3.06075,9.1864}, /*cmx*/
          {1.417641,5.4247,2.8774,4.4448}, /*cfx*/
          {-167.1476,15.90802,606.848,44.22021,0.178895,1.6399}, /*cmy*/
          {3.134018,0.8331,4.2267,5.3819}, /*cfy*/
          {-537.8903,42.00492,1452.2903,108.86182,0.950033,5.6779}, /*cmz*/
          {2.798543,0.409,3.2891,5.0369} /*cfz*/
     },
     {
          2458585.4,
          {-663.383,28.24944,1926.0334,195.84484,3.990423,13.4449}, /*cmx*/
          {1.583031,5.5444,2.8153,4.7011}, /*cfx*/
          {-111.9356,11.44614,618.4919,53.02134,0.609262,2.5151}, /*cmy*/
          {3.426253,1.2163,5.054,0.4408}, /*cfy*/
          {-443.6699,35.02882,1434.7031,118.00023,1.148823,5.5112}, /*cmz*/
          {3.080571,0.8028,4.2656,6.1156} /*cfz*/
     },
     {
          2458607.4,
          {-742.1371,37.35558,1921.127,203.54664,4.561745,15.0874}, /*cmx*/
          {1.757321,5.7056,2.8947,5.0302}, /*cfx*/
          {-42.393,5.4937,659.6376,66.82682,1.240575,4.8845}, /*cmy*/
          {3.706391,1.526,5.2897,1.052}, /*cfy*/
          {-296.8183,23.01235,1477.0624,141.39407,2.2716,9.5382}, /*cmz*/
          {3.384316,1.1935,4.9161,0.7431} /*cfz*/
     },
     {
          2458629.4,
          {-742.3975,39.50512,1839.5786,197.78539,4.576493,14.3031}, /*cmx*/
          {1.962504,5.9399,3.1127,5.5188}, /*cfx*/
          {28.8865,-0.83663,714.8069,81.54527,1.89508,7.1429}, /*cmy*/
          {3.950883,1.7638,5.4468,1.4167}, /*cfy*/
          {-125.9847,8.37842,1572.0039,173.68483,3.807371,15.0793}, /*cmz*/
          {3.669754,1.5044,5.2115,1.2171} /*cfz*/
     },
     {
          2458651.4,
          {-662.5646,34.19755,1717.5928,187.24168,4.329418,14.1731}, /*cmx*/
          {2.216584,6.2745,3.5103,6.2337}, /*cfx*/
          {84.2599,-5.92754,756.6694,92.08146,2.389111,8.3687}, /*cmy*/
          {4.160983,1.9695,5.6053,1.7578}, /*cfy*/
          {23.5062,-4.80469,1663.2791,201.14767,5.134678,18.8583}, /*cmz*/
          {3.913871,1.748,5.413,1.5752} /*cfz*/
     },
     {
          2458673.4,
          {-533.5712,24.00142,1619.0798,185.9519,4.530135,17.4598}, /*cmx*/
          {2.512652,0.3952,4.034,0.6392}, /*cfx*/
          {109.3322,-8.41348,763.738,95.2766,2.599393,8.3847}, /*cmy*/
          {4.354665,2.1829,5.8047,2.1775}, /*cfy*/
          {111.4634,-12.80428,1690.1925,212.98341,5.838582,19.6274}, /*cmz*/
          {4.123786,1.9683,5.6121,1.961} /*cfz*/
     },
     {
          2458695.4,
          {-405.7416,13.44674,1578.6421,196.63629,5.322152,21.508}, /*cmx*/
          {2.806406,0.7683,4.4783,1.1347}, /*cfx*/
          {101.4703,-7.9821,734.1598,91.98376,2.561295,8.0603}, /*cmy*/
          {4.551492,2.4339,6.0773,2.7369}, /*cfy*/
          {124.1295,-14.22808,1633.3762,207.93282,5.872326,18.5849}, /*cmz*/
          {4.319159,2.2033,5.8552,2.4594} /*cfz*/
     },
     {
          2458717.4,
          {-323.0176,6.67093,1567.8472,206.9592,6.059073,23.2777}, /*cmx*/
          {3.050474,1.0572,4.7861,1.5539}, /*cfx*/
          {71.6962,-5.58521,685.7558,86.55787,2.466074,8.5328}, /*cmy*/
          {4.76111,2.7299,0.1443,3.3545}, /*cfy*/
          {79.1482,-10.56581,1522.1697,193.98751,5.578126,18.4762}, /*cmz*/
          {4.515956,2.474,6.1662,3.0613} /*cfz*/
     },
     {
          2458739.4,
          {-303.5295,5.55979,1538.1273,205.84387,6.26361,22.6065}, /*cmx*/
          {3.232729,1.2821,5.0231,2.0112}, /*cfx*/
          {38.3945,-2.88776,641.8925,83.00677,2.479543,9.5015}, /*cmy*/
          {4.973795,3.0359,0.5075,3.8822}, /*cfy*/
          {13.0648,-5.10245,1408.9263,181.73283,5.409904,20.1306}, /*cmz*/
          {4.716213,2.7685,0.2349,3.6247} /*cfz*/
     },
     {
          2458761.4,
          {-336.2819,9.33913,1470.7206,192.09441,5.928476,21.6281}, /*cmx*/
          {3.368766,1.4807,5.2495,2.56}, /*cfx*/
          {18.0386,-1.41702,614.8825,81.27609,2.556804,9.849}, /*cmy*/
          {5.162441,3.2948,0.7982,4.3362}, /*cfy*/
          {-37.107,-1.23681,1334.4419,175.6896,5.499179,21.4973}, /*cmz*/
          {4.903577,3.0391,0.5477,4.0957} /*cfz*/
     },
     {
          2458783.4,
          {-390.2137,15.32678,1382.5231,172.3253,5.37013,22.3156}, /*cmx*/
          {3.483322,1.6825,5.5014,3.1381}, /*cfx*/
          {18.484,-1.92889,602.0543,78.55667,2.545413,9.2316}, /*cmy*/
          {5.304572,3.4796,0.9973,4.8167}, /*cfy*/
          {-47.8284,-1.1793,1309.3918,172.41123,5.606792,20.9869}, /*cmz*/
          {5.054674,3.2426,0.7703,4.5509} /*cfz*/
     },
     {
          2458805.4,
          {-427.8524,20.14328,1308.8802,155.92403,4.98947,23.7746}, /*cmx*/
          {3.601224,1.8962,5.7741,3.6506}, /*cfx*/
          {36.7413,-4.18081,594.4292,73.05655,2.37322,8.4159}, /*cmy*/
          {5.402559,3.6023,1.1343,5.4088}, /*cfy*/
          {-15.633,-5.31318,1320.9997,166.80218,5.491878,19.2377}, /*cmz*/
          {5.161531,3.3735,0.9119,5.09} /*cfz*/
     },
     {
          2458827.4,
          {-419.4531,20.99864,1284.6121,149.50471,4.990618,23.7347}, /*cmx*/
          {3.738504,2.0976,6.0099,4.119}, /*cfx*/
          {60.86,-7.08454,584.2585,65.36063,2.088281,8.4736}, /*cmy*/
          {5.482523,3.698,1.2546,6.0662}, /*cfy*/
          {42.6041,-12.13527,1348.1595,157.20284,5.123389,18.7028}, /*cmz*/
          {5.240673,3.4581,1.0105,5.741} /*cfz*/
     },
     {
          2458849.4,
          {-354.9259,16.80458,1326.7319,153.2794,5.284051,21.617}, /*cmx*/
          {3.89306,2.2518,6.162,4.6428}, /*cfx*/
          {75.3032,-9.18653,567.2996,57.61461,1.813477,9.1163}, /*cmy*/
          {5.581291,3.8177,1.4151,0.3623}, /*cfy*/
          {95.3306,-18.73972,1369.3037,145.41793,4.652458,20.4666}, /*cmz*/
          {5.324153,3.5433,1.1211,0.0858} /*cfz*/
     },
     {
          2458871.4,
          {-251.2688,8.90699,1418.7565,161.92017,5.656233,19.7377}, /*cmx*/
          {4.050765,2.3616,6.2544,5.3105}, /*cfx*/
          {68.4587,-9.35641,545.4122,52.45914,1.689308,9.1475}, /*cmy*/
          {5.731653,4.0104,1.6576,0.8734}, /*cfy*/
          {108.7372,-21.92664,1370.0842,135.21656,4.333581,22.1535}, /*cmz*/
          {5.446032,3.6879,1.3084,0.6167} /*cfz*/
     },
     {
          2458893.4,
          {-149.3932,0.8768,1510.7381,167.66215,5.887568,20.7823}, /*cmx*/
          {4.205926,2.4696,0.0734,6.0227}, /*cfx*/
          {39.6766,-7.45019,528.3499,51.81789,1.785861,8.2776}, /*cmy*/
          {5.944239,4.2717,1.9415,1.4348}, /*cfy*/
          {64.8065,-19.852,1357.0818,131.80257,4.446972,21.5801}, /*cmz*/
          {5.629062,3.9254,1.5888,1.1419} /*cfz*/
     },
     {
          2458915.4,
          {-96.4737,-3.02006,1545.3331,164.16148,5.842984,22.681}, /*cmx*/
          {4.370408,2.632,0.2623,0.3375}, /*cfx*/
          {1.6241,-4.56205,524.8447,54.41184,1.998221,7.5595}, /*cmy*/
          {6.191637,4.5365,2.1989,2.1264}, /*cfy*/
          {-22.1305,-13.59558,1357.9128,137.88125,5.022793,19.8362}, /*cmz*/
          {5.866352,4.2129,1.887,1.781} /*cfz*/
     },
     {
          2458937.4,
          {-115.9967,-0.52992,1501.1897,152.79764,5.712165,22.0313}, /*cmx*/
          {4.567468,2.8995,0.5906,0.8993}, /*cfx*/
          {-25.1259,-2.56988,527.2294,55.4218,2.111681,7.772}, /*cmy*/
          {0.144271,4.7744,2.4463,2.8174}, /*cfy*/
          {-103.8128,-7.42293,1382.9369,145.54211,5.589876,20.0109}, /*cmz*/
          {6.114189,4.4783,2.1554,2.4982} /*cfz*/
     },
     {
          2458959.4,
          {-182.2414,6.17411,1423.3431,144.22215,5.925227,19.8325}, /*cmx*/
          {4.813556,3.2653,1.0082,1.5795}, /*cfx*/
          {-24.3475,-3.03448,515.6704,50.77311,2.002621,7.7699}, /*cmy*/
          {0.350128,5.0249,2.7632,3.394}, /*cfy*/
          {-122.6379,-6.66832,1391.4965,139.94967,5.54302,21.0145}, /*cmz*/
          {0.046957,4.7174,2.4422,3.1124} /*cfz*/
     },
     {
          2458981.4,
          {-224.2016,10.65729,1392.6757,141.88808,6.272611,20.0059}, /*cmx*/
          {5.082585,3.6065,1.3791,2.3283}, /*cfx*/
          {3.1906,-6.01861,482.11,41.6392,1.814078,6.6345}, /*cmy*/
          {0.549684,5.3689,3.2375,3.9901}, /*cfy*/
          {-55.7522,-13.73708,1333.4426,115.08277,4.838442,18.9458}, /*cmz*/
          {0.23271,4.9944,2.8542,3.6672} /*cfz*/
     },
     {
          2459003.4,
          {-171.093,6.19889,1434.3413,131.30986,5.862425,20.6901}, /*cmx*/
          {5.308212,3.8104,1.6735,2.9129}, /*cfx*/
          {35.8067,-9.65433,445.9208,34.94685,1.847719,5.5424}, /*cmy*/
          {0.788594,5.8409,3.7935,4.7995}, /*cfy*/
          {53.6618,-25.0789,1219.632,84.78689,4.364329,14.5791}, /*cmz*/
          {0.433836,5.4141,3.4514,4.3888} /*cfz*/
     },
     {
          2459025.4,
          {-13.4067,-8.59624,1493.8796,103.81008,4.315465,17.1126}, /*cmx*/
          {5.468909,3.8508,1.9795,3.3868}, /*cfx*/
          {41.8417,-11.04479,445.5463,34.23807,1.988192,5.9304}, /*cmy*/
          {1.080746,6.2117,4.1976,5.5958}, /*cfy*/
          {115.4905,-32.61338,1138.4396,71.95103,4.616501,13.6305}, /*cmz*/
          {0.705523,5.909,3.9848,5.3009} /*cfz*/
     },
     {
          2459047.4,
          {177.5484,-27.67562,1508.5939,72.34408,2.419461,10.104}, /*cmx*/
          {5.615728,3.7215,2.5318,4.0187}, /*cfx*/
          {1.7696,-8.2312,501.0607,34.89455,1.83837,6.0327}, /*cmy*/
          {1.361063,6.2636,4.4203,6.1015}, /*cfy*/
          {60.2411,-29.68105,1188.8205,73.8326,4.557749,14.6419}, /*cmz*/
          {1.028215,6.0926,4.278,5.9311} /*cfz*/
     },
     {
          2459069.4,
          {303.1669,-42.00748,1463.0059,54.291,1.803796,6.7029}, /*cmx*/
          {5.81746,3.5735,3.5449,5.2485}, /*cfx*/
          {-75.3758,-1.75975,585.9751,37.19425,1.31417,4.4346}, /*cmy*/
          {1.582939,6.0756,4.5021,0.1789}, /*cfy*/
          {-105.1857,-16.27698,1360.2732,82.87593,3.595562,12.0936}, /*cmz*/
          {1.312466,5.9494,4.3826,0.0355} /*cfz*/
     },
     {
          2459091.4,
          {313.3185,-46.40676,1406.852,50.3712,2.018818,8.0023}, /*cmx*/
          {6.107829,3.7848,4.0834,6.1401}, /*cfx*/
          {-159.6523,5.84603,656.0382,43.23747,0.677188,1.7526}, /*cmy*/
          {1.771863,5.9056,4.3329,0.5562}, /*cfy*/
          {-312.4041,1.8872,1545.2725,101.9607,2.207808,6.2091}, /*cmz*/
          {1.537908,5.7822,4.2588,0.3324} /*cfz*/
     },
     {
          2459113.4,
          {226.2356,-41.68517,1409.7726,63.68358,1.737657,6.8931}, /*cmx*/
          {0.170642,4.2761,4.1475,0.3352}, /*cfx*/
          {-224.5165,12.17659,686.8366,49.31057,0.404596,0.8158}, /*cmy*/
          {1.961047,5.8906,3.4118,3.6755}, /*cfy*/
          {-494.8169,18.8504,1663.9471,122.87609,1.389986,0.3972}, /*cmz*/
          {1.735242,5.7502,3.6448,4.7045} /*cfz*/
     },
     {
          2459135.4,
          {86.3635,-31.22241,1487.9441,93.51238,1.259017,2.8756}, /*cmx*/
          {0.503595,4.6567,3.696,0.7834}, /*cfx*/
          {-260.3114,16.1914,679.9924,52.24366,0.594274,2.4415}, /*cmy*/
          {2.164316,6.0047,2.9081,4.202}, /*cfy*/
          {-624.8694,31.84295,1703.642,137.54327,1.703373,5.3651}, /*cmz*/
          {1.925378,5.8269,3.0572,4.2392} /*cfz*/
     },
     {
          2459157.4,
          {-74.7967,-17.56736,1612.6565,130.53792,1.69678,2.9831}, /*cmx*/
          {0.784808,4.9039,2.9098,3.9356}, /*cfx*/
          {-267.8857,17.75081,648.7093,52.03373,0.710492,3.0124}, /*cmy*/
          {2.385864,6.2155,2.9939,4.6528}, /*cfy*/
          {-700.4819,40.27914,1683.5743,144.26142,2.204411,8.3628}, /*cmz*/
          {2.116646,5.9745,2.9709,4.5864} /*cfz*/
     },
     {
          2459179.4,
          {-238.6703,-2.38987,1749.9809,168.10428,2.963225,9.3038}, /*cmx*/
          {1.010293,5.0815,2.6425,4.3156}, /*cfx*/
          {-249.432,16.87055,608.2505,50.68632,0.6942,2.7478}, /*cmy*/
          {2.631673,0.2369,3.3794,5.2778}, /*cfy*/
          {-720.1051,43.65314,1626.162,144.55818,2.41469,9.0802}, /*cmz*/
          {2.318674,6.1889,3.1323,5.0292} /*cfz*/
     },
     {
          2459201.4,
          {-383.8643,12.18268,1864.7738,200.14255,4.317195,14.7149}, /*cmx*/
          {1.190957,5.227,2.6175,4.598}, /*cfx*/
          {-208.6525,13.77246,574.6475,51.61021,0.747712,2.8065}, /*cmy*/
          {2.903083,0.6168,4.0609,6.2378}, /*cfy*/
          {-679.5732,41.31052,1558.4991,143.54875,2.406817,8.6068}, /*cmz*/
          {2.544597,0.2022,3.5178,5.6961} /*cfz*/
     },
     {
          2459223.4,
          {-483.1086,23.36134,1922.5008,220.5317,5.342476,17.8031}, /*cmx*/
          {1.344438,5.3684,2.6871,4.8915}, /*cfx*/
          {-154.5361,9.23416,558.434,56.79081,1.073874,4.1981}, /*cmy*/
          {3.180943,0.9905,4.6528,0.7321}, /*cfy*/
          {-584.5069,33.59257,1515.1566,149.85469,2.703344,10.2796}, /*cmz*/
          {2.797108,0.5631,4.0955,0.2552} /*cfz*/
     },
     {
          2455197.3,
          {72.5273,-0.58749,3413.641,3.61697,0.036012,50.3167}, /*cmx*/
          {0.883715,1.0696,3.3855,4.8204}, /*cfx*/
          {25.7071,-0.2456,896.2206,0.96207,0.02008,13.6202}, /*cmy*/
          {3.278424,3.6196,6.1276,0.9386}, /*cfy*/
          {319.9882,-3.25098,3449.1557,8.1209,0.08872,53.2681}, /*cmz*/
          {2.466413,1.8383,4.9502,0.1136} /*cfz*/
     },
     {
          2455302.3,
          {76.8133,-0.7409,3529.3592,2.70641,0.02997,49.5403}, /*cmx*/
          {3.004039,4.5086,1.183,2.6193}, /*cfx*/
          {32.2119,-0.33934,824.9989,2.40633,0.02496,11.1188}, /*cmy*/
          {5.405852,1.6552,4.9294,5.0837}, /*cfy*/
          {227.0429,-1.48155,3607.1463,5.14672,0.034677,47.8233}, /*cmz*/
          {4.527643,0.5564,3.6862,4.1866} /*cfz*/
     },
     {
          2455407.3,
          {84.2138,-1.21096,3537.9835,4.95877,0.016382,49.5205}, /*cmx*/
          {4.992371,2.9239,4.6819,0.3126}, /*cfx*/
          {34.9851,-0.21312,826.6662,2.90682,0.011683,13.2417}, /*cmy*/
          {1.129622,0.6737,5.2222,2.5558}, /*cfy*/
          {245.3204,-1.93277,3450.4888,1.27434,0.042876,50.6634}, /*cmz*/
          {0.239784,4.7209,5.2678,1.8026} /*cfz*/
     },
     {
          2455512.3,
          {-23.4772,0.31104,3498.5328,7.00504,0.051525,49.9911}, /*cmx*/
          {0.566898,5.192,2.1263,4.2581}, /*cfx*/
          {50.4683,-0.30874,1042.0858,3.25169,0.025692,15.6386}, /*cmy*/
          {2.948111,1.8767,5.1048,0.3448}, /*cfy*/
          {196.4219,-0.91114,3462.8293,7.41634,0.047809,49.3256}, /*cmz*/
          {2.102183,0.7249,3.9758,5.8043} /*cfz*/
     },
     {
          2455617.3,
          {58.654,-1.21724,3440.4887,4.961,0.036711,50.1405}, /*cmx*/
          {2.547291,3.3928,5.8599,2.0351}, /*cfx*/
          {31.631,0.02565,1064.3497,2.79253,0.012279,14.1131}, /*cmy*/
          {4.894384,0.5632,3.4729,4.4353}, /*cfy*/
          {164.7435,-0.56031,3492.0574,4.55907,0.018316,48.8393}, /*cmz*/
          {4.057896,5.4028,0.9266,3.5614} /*cfz*/
     },
     {
          2455722.3,
          {-21.9502,0.52482,3448.5942,1.82667,0.048092,49.3773}, /*cmx*/
          {4.666165,5.3589,2.8647,6.0778}, /*cfx*/
          {42.7592,-0.23303,969.4317,1.02008,0.018526,14.9457}, /*cmy*/
          {0.766519,1.2521,5.6949,2.1107}, /*cfy*/
          {258.5094,-2.13962,3458.7289,5.25663,0.073848,52.444}, /*cmz*/
          {6.161589,1.7743,4.992,1.341} /*cfz*/
     },
     {
          2455827.3,
          {-38.8364,0.21543,3495.6379,7.99864,0.023179,48.7866}, /*cmx*/
          {0.302556,4.9273,2.0826,3.781}, /*cfx*/
          {55.7949,-0.25754,1104.1943,3.82729,0.014974,16.2129}, /*cmy*/
          {2.674822,1.5894,5.1202,6.1232}, /*cfy*/
          {197.9695,-1.09853,3435.5873,7.35242,0.020315,46.7173}, /*cmz*/
          {1.826871,0.4942,4.7882,5.3098} /*cfz*/
     },
     {
          2455932.3,
          {-85.1507,1.01052,3484.2218,2.69725,0.052164,47.6902}, /*cmx*/
          {2.133794,6.0631,3.4088,1.4354}, /*cfx*/
          {64.8251,-0.43323,1225.2377,1.07346,0.021676,16.497}, /*cmy*/
          {4.487868,2.5478,6.2337,3.7669}, /*cfy*/
          {240.1678,-1.98637,3544.7039,6.72418,0.08605,49.5669}, /*cmz*/
          {3.67423,1.9716,5.3605,2.8897} /*cfz*/
     },
     {
          2456037.3,
          {-157.8005,2.5321,3315.2258,10.98973,0.09217,52.6282}, /*cmx*/
          {4.220952,5.3689,2.3937,5.5178}, /*cfx*/
          {83.0518,-0.78929,1134.0938,4.07938,0.034305,17.6787}, /*cmy*/
          {0.275474,2.0066,5.3618,1.6221}, /*cfy*/
          {208.345,-1.05009,3459.3436,9.51745,0.065712,53.3162}, /*cmz*/
          {5.714219,1.1493,4.4187,0.8216} /*cfz*/
     },
     {
          2456142.3,
          {-111.4835,1.36262,3510.7341,7.46986,0.025665,49.2269}, /*cmx*/
          {0.032244,4.7742,2.7083,3.3537}, /*cfx*/
          {75.0749,-0.52484,1157.516,3.32675,0.014746,16.2917}, /*cmy*/
          {2.39484,1.4574,5.6516,5.6783}, /*cfy*/
          {196.7842,-1.06734,3415.2274,4.22746,0.037513,46.1159}, /*cmz*/
          {1.531203,0.5249,5.5655,4.8415} /*cfz*/
     },
     {
          2456247.3,
          {-257.5973,3.65268,3623.0519,11.63349,0.102817,42.8664}, /*cmx*/
          {1.812218,5.5201,2.4682,0.8177}, /*cfx*/
          {90.2806,-0.64458,1308.2179,3.71723,0.027796,17.2811}, /*cmy*/
          {4.185071,2.2492,5.4482,3.1333}, /*cfy*/
          {110.0821,0.64062,3468.7803,6.54809,0.041828,47.2154}, /*cmz*/
          {3.349857,1.404,4.2458,2.3644} /*cfz*/
     },
     {
          2456352.3,
          {-216.0206,2.67543,3274.6901,10.32636,0.055434,56.5631}, /*cmx*/
          {3.752119,4.8816,1.7702,4.9102}, /*cfx*/
          {84.7897,-0.50857,1249.2332,3.31868,0.013847,20.5411}, /*cmy*/
          {6.084056,1.3819,4.5393,1.029}, /*cfy*/
          {37.9925,1.95877,3372.5833,6.16382,0.046962,53.7969}, /*cmz*/
          {5.289926,5.9505,2.3432,0.143} /*cfz*/
     },
     {
          2456457.3,
          {-170.4467,2.1266,3475.6842,3.34233,0.037096,50.4612}, /*cmx*/
          {5.954576,5.0742,3.0189,2.8805}, /*cfx*/
          {62.1468,-0.17041,1241.7324,0.59204,0.012945,17.6668}, /*cmy*/
          {1.993373,2.3874,0.2208,5.1651}, /*cfy*/
          {98.5655,0.75321,3493.0119,1.55174,0.02556,50.6281}, /*cmz*/
          {1.14094,3.4939,5.9345,4.3308} /*cfz*/
     },
     {
          2456562.3,
          {-198.3163,2.0937,3580.2203,9.28995,0.056522,43.5606}, /*cmx*/
          {1.565016,5.4259,1.9059,0.352}, /*cfx*/
          {56.141,0.10712,1299.5882,2.30274,0.004757,17.1591}, /*cmy*/
          {3.912403,2.1593,3.9965,2.7113}, /*cfy*/
          {-7.851,2.71253,3425.0709,3.87238,0.061422,43.143}, /*cmz*/
          {3.049581,0.1315,2.4782,1.933} /*cfz*/
     },
     {
          2456667.3,
          {-121.9421,0.44422,3391.1346,3.31074,0.035722,51.8978}, /*cmx*/
          {3.411678,2.2719,5.2313,4.2651}, /*cfx*/
          {36.0682,0.4344,1292.6045,2.03842,0.020135,19.0786}, /*cmy*/
          {5.760801,4.5687,1.539,0.2993}, /*cfy*/
          {-6.9172,2.26872,3327.829,7.15683,0.054029,51.8287}, /*cmz*/
          {4.940094,4.2867,1.2423,5.7165} /*cfz*/
     },
     {
          2456772.3,
          {-151.4876,1.24982,3422.0265,4.57245,0.029056,53.7098}, /*cmx*/
          {5.471126,0.3051,2.9286,2.2301}, /*cfx*/
          {32.2165,0.50845,1317.8883,2.00139,0.006737,21.1741}, /*cmy*/
          {1.503063,3.6154,1.2182,4.5477}, /*cfy*/
          {-18.5285,2.81065,3574.0304,2.39236,0.029351,57.2581}, /*cmz*/
          {0.689034,3.644,2.4295,3.754} /*cfz*/
     },
     {
          2456877.3,
          {-83.7132,-0.30564,3449.3703,1.26066,0.044262,46.0612}, /*cmx*/
          {1.268983,4.6612,6.2703,6.2475}, /*cfx*/
          {28.1862,0.63392,1289.2885,0.53803,0.022792,17.1005}, /*cmy*/
          {3.586945,5.1986,2.25,2.3135}, /*cfy*/
          {-33.2778,2.8941,3444.5406,6.12584,0.084808,42.7582}, /*cmz*/
          {2.727236,5.1758,1.9232,1.4685} /*cfz*/
     },
     {
          2456982.3,
          {-58.8659,-0.88356,3459.8631,10.0063,0.04788,46.1196}, /*cmx*/
          {3.15597,1.5709,4.891,3.7127}, /*cfx*/
          {21.2564,0.67036,1294.1722,3.91001,0.020095,17.21}, /*cmy*/
          {5.494702,4.0844,1.4999,6.0081}, /*cfy*/
          {25.1148,1.33141,3353.3511,8.0998,0.029788,48.7088}, /*cmz*/
          {4.655874,3.505,0.9534,5.1903} /*cfz*/
     },
     {
          2457087.3,
          {-43.5645,-1.41616,3510.0754,3.42586,0.051255,56.3093}, /*cmx*/
          {4.999484,1.651,6.103,1.4967}, /*cfx*/
          {3.6355,1.04153,1313.648,2.1023,0.031551,20.8492}, /*cmy*/
          {1.068287,4.8542,2.3475,3.8678}, /*cfy*/
          {-38.025,2.561,3536.6654,4.81665,0.078772,54.6874}, /*cmz*/
          {0.26678,4.9517,2.1107,3.076} /*cfz*/
     },
     {
          2457192.3,
          {3.6713,-2.07295,3324.5534,9.51266,0.092242,48.3678}, /*cmx*/
          {0.848435,2.1378,5.4958,5.765}, /*cfx*/
          {5.1612,0.95886,1254.5406,4.00098,0.036132,17.2314}, /*cmy*/
          {3.151836,4.7009,1.8053,1.7942}, /*cfy*/
          {17.2499,1.44091,3454.672,8.26381,0.069586,46.569}, /*cmz*/
          {2.332981,4.2509,1.2293,0.9195} /*cfz*/
     },
     {
          2457297.3,
          {-8.6636,-1.90372,3482.7733,10.81335,0.038911,44.4162}, /*cmx*/
          {2.904588,1.393,5.1705,3.228}, /*cfx*/
          {30.6287,0.42066,1283.7013,3.08608,0.01441,16.9796}, /*cmy*/
          {5.213492,3.7814,1.8635,5.5694}, /*cfy*/
          {81.1954,0.03083,3420.6297,6.32261,0.008125,46.9385}, /*cmz*/
          {4.377581,2.9079,1.4489,4.7692} /*cfz*/
     },
     {
          2457402.3,
          {-12.5748,-2.15524,3571.9635,8.53836,0.08133,52.2466}, /*cmx*/
          {4.668356,2.443,5.7316,0.9342}, /*cfx*/
          {35.9756,0.19811,1230.4274,2.94224,0.023298,17.0651}, /*cmy*/
          {0.7265,4.7813,1.7829,3.2941}, /*cfy*/
          {80.7355,-0.44641,3464.3548,5.37841,0.045643,49.8086}, /*cmz*/
          {6.191718,4.45,1.2267,2.4374} /*cfz*/
     },
     {
          2457507.3,
          {-32.9744,-1.3797,3337.6178,10.29467,0.055243,48.6669}, /*cmx*/
          {0.36636,1.6184,4.7004,5.0992}, /*cfx*/
          {45.8673,0.02774,1159.3672,2.67608,0.010271,16.6827}, /*cmy*/
          {2.707259,3.7412,0.4191,1.099}, /*cfy*/
          {139.9084,-1.35066,3383.9899,7.07387,0.04642,50.1105}, /*cmz*/
          {1.907038,2.8707,5.664,0.3042} /*cfz*/
     },
     {
          2457612.3,
          {-36.7119,-1.5389,3458.5968,3.96606,0.030404,46.6411}, /*cmx*/
          {2.555865,1.4561,6.2555,2.7719}, /*cfx*/
          {57.1208,-0.14084,1247.8283,0.45253,0.010675,16.7686}, /*cmy*/
          {4.847282,3.0334,2.6955,5.1491}, /*cfy*/
          {137.523,-1.27104,3513.592,2.95489,0.012369,45.9342}, /*cmz*/
          {4.038347,1.8061,3.0492,4.3286} /*cfz*/
     },
     {
          2457717.3,
          {-82.3842,-0.88785,3518.1826,8.42149,0.032292,47.8853}, /*cmx*/
          {4.412389,2.5701,5.5084,0.4466}, /*cfx*/
          {45.3526,-0.09694,1184.3878,3.17979,0.009616,15.1739}, /*cmy*/
          {0.44837,4.527,1.6769,2.821}, /*cfy*/
          {117.4303,-1.48293,3463.7564,5.51303,0.023304,48.4003}, /*cmz*/
          {5.913882,4.0171,0.0157,1.9403} /*cfz*/
     },
     {
          2457822.3,
          {-132.3727,0.00028,3449.8305,1.94277,0.0393,48.5038}, /*cmx*/
          {6.257795,5.7229,1.9492,4.4447}, /*cfx*/
          {43.257,-0.06913,1032.9546,0.76531,0.01615,14.5256}, /*cmy*/
          {2.303551,0.3782,3.455,0.4892}, /*cfy*/
          {104.7291,-1.23967,3401.6401,4.10978,0.042374,49.1337}, /*cmz*/
          {1.514376,1.2347,3.9771,5.9951} /*cfz*/
     },
     {
          2457927.3,
          {-73.2729,-1.2306,3434.1306,6.35616,0.056434,49.374}, /*cmx*/
          {2.087309,3.2183,0.0452,2.2696}, /*cfx*/
          {32.0951,0.14373,1074.586,2.62718,0.020816,15.8254}, /*cmy*/
          {4.397531,5.1807,2.066,4.6012}, /*cfy*/
          {85.7177,-0.89795,3503.79,3.96498,0.027409,47.3168}, /*cmz*/
          {3.604644,5.2029,1.7041,3.7949} /*cfz*/
     },
     {
          2458032.3,
          {-87.7103,-0.89515,3531.5111,5.90877,0.007706,47.275}, /*cmx*/
          {4.131408,2.2592,3.9473,0.0017}, /*cfx*/
          {36.756,-0.05201,1130.4046,2.34947,0.005395,14.1726}, /*cmy*/
          {0.159875,4.2506,2.897,2.3694}, /*cfy*/
          {112.0208,-1.63495,3492.0058,3.53044,0.030787,48.6995}, /*cmz*/
          {5.631709,3.307,5.0005,1.5003} /*cfz*/
     },
     {
          2458137.3,
          {-101.0991,-0.87823,3497.2954,5.38528,0.032895,47.4769}, /*cmx*/
          {5.943657,4.1875,0.7698,3.8781}, /*cfx*/
          {54.6468,-0.61049,929.0441,1.89072,0.004059,12.3633}, /*cmy*/
          {1.99337,6.0899,3.1391,0.0029}, /*cfy*/
          {104.2036,-2.00831,3393.7011,5.1427,0.016824,46.7624}, /*cmz*/
          {1.209456,0.3331,4.1284,5.4791} /*cfz*/
     },
     {
          2458242.3,
          {-44.1132,-1.81301,3410.3654,6.96446,0.049811,51.7006}, /*cmx*/
          {1.619225,2.3352,5.0196,1.6787}, /*cfx*/
          {42.043,-0.40563,850.6962,1.54739,0.015992,13.2182}, /*cmy*/
          {3.933357,3.7514,6.0236,3.9533}, /*cfy*/
          {84.8772,-1.77073,3510.6811,2.90404,0.050896,49.4388}, /*cmz*/
          {3.170425,3.3615,5.7991,3.1836} /*cfz*/
     },
     {
          2458347.3,
          {-111.8839,-0.53047,3542.608,1.98908,0.035467,48.9868}, /*cmx*/
          {3.755623,6.1416,2.4582,5.8079}, /*cfx*/
          {59.1779,-0.60647,969.0031,1.49338,0.016655,14.095}, /*cmy*/
          {6.022843,1.5103,4.3476,1.8184}, /*cfy*/
          {135.142,-2.35486,3562.8989,6.58014,0.062416,51.9466}, /*cmz*/
          {5.255503,1.4761,4.6109,1.0489} /*cfz*/
     },
     {
          2458452.3,
          {-142.9519,-0.0379,3512.8343,6.66906,0.003438,47.1709}, /*cmx*/
          {5.691893,4.1204,1.9071,3.4282}, /*cfx*/
          {63.1752,-0.90998,849.2348,1.34415,0.014647,10.4001}, /*cmy*/
          {1.714553,5.956,5.3219,5.8885}, /*cfy*/
          {111.5906,-2.49714,3384.847,3.94624,0.040435,44.4131}, /*cmz*/
          {0.94077,0.2719,5.3567,5.0069} /*cfz*/
     },
     {
          2458557.3,
          {-196.1494,1.07269,3584.2529,5.82,0.07117,49.2005}, /*cmx*/
          {1.240694,5.7444,2.7897,1.0258}, /*cfx*/
          {44.1122,-0.57356,686.2393,2.88644,0.026689,8.7383}, /*cmy*/
          {3.544415,1.2423,4.5126,3.1945}, /*cfy*/
          {79.1455,-2.01096,3543.1579,8.26578,0.081229,50.7798}, /*cmz*/
          {2.82483,1.5311,4.8343,2.5389} /*cfz*/
     },
     {
          2458662.3,
          {-233.2094,1.5286,3480.8929,10.79309,0.068788,54.9678}, /*cmx*/
          {3.262439,4.8988,1.9394,5.2104}, /*cfx*/
          {41.0593,-0.46011,688.2985,2.53554,0.010403,13.0155}, /*cmy*/
          {5.508772,0.3789,3.818,1.1703}, /*cfy*/
          {55.2555,-1.30746,3596.0541,8.17814,0.04101,55.3609}, /*cmz*/
          {4.818598,0.6529,4.1331,0.5249} /*cfz*/
     },
     {
          2458767.3,
          {-193.5575,0.91702,3502.9703,3.8481,0.037742,47.7173}, /*cmx*/
          {5.400063,4.3883,3.1865,3.0119}, /*cfx*/
          {38.3336,-0.50416,747.4716,0.20184,0.01944,9.337}, /*cmy*/
          {1.369216,5.4123,5.0923,5.3869}, /*cfy*/
          {37.6386,-1.24993,3460.7293,1.16258,0.047699,46.1426}, /*cmz*/
          {0.643079,0.5689,5.2955,4.5379} /*cfz*/
     },
     {
          2458872.3,
          {-286.9827,2.61387,3710.8607,13.14182,0.089877,45.494}, /*cmx*/
          {0.963073,5.2359,2.1941,0.4391}, /*cfx*/
          {0.081,0.09845,563.6737,3.50037,0.016352,5.3906}, /*cmy*/
          {3.172238,0.2819,3.3414,2.8041}, /*cfy*/
          {-38.4087,-0.06405,3566.4899,8.56206,0.046231,48.0121}, /*cmz*/
          {2.522275,0.783,3.8745,2.0345} /*cfz*/
     },
     {
          2458977.3,
          {-258.0669,2.03445,3510.7914,7.46474,0.029177,59.1175}, /*cmx*/
          {2.810822,4.596,2.252,4.5443}, /*cfx*/
          {-6.6956,0.15072,373.8363,0.96654,0.008166,7.0764}, /*cmy*/
          {5.053657,4.847,6.1929,0.2216}, /*cfy*/
          {-114.889,1.17148,3486.9571,4.17711,0.016069,55.5074}, /*cmz*/
          {4.413203,5.4524,1.3941,6.1055} /*cfz*/
     },
     {
          2459082.3,
          {-243.8721,1.86102,3462.0806,5.91706,0.070172,50.3305}, /*cmx*/
          {5.003504,5.6804,2.8439,2.519}, /*cfx*/
          {15.0368,-0.12846,507.7604,1.98222,0.022876,7.9967}, /*cmy*/
          {0.903222,1.3579,4.5208,4.6999}, /*cfy*/
          {-62.1499,0.43793,3533.9925,3.15411,0.03861,51.3529}, /*cmz*/
          {0.265013,1.6334,4.72,4.0395} /*cfz*/
     },
     {
          2459187.3,
          {-283.0603,2.47944,3721.7551,12.21946,0.056654,45.556}, /*cmx*/
          {0.70351,4.9669,1.839,6.2598}, /*cfx*/
          {-25.3205,0.47696,472.1024,3.3198,0.010968,4.1484}, /*cmy*/
          {2.798128,5.9238,2.1906,2.5306}, /*cfy*/
          {-155.5998,1.88193,3617.3941,7.13593,0.048269,45.0175}, /*cmz*/
          {2.23049,6.1213,2.4009,1.6181} /*cfz*/
     }

};

static unsigned idn_list[] = {2,76,117,156,197,242,300,484};
static double freq_list[] = {6.667,4.586,3.328,2.296,1.391,0.394,0.394,0.079};
static double delt_list[] = {55.0,100.0,105.0,100.0,90.0,70.0,22.0,105.0};

BDL_Dataset saturne_1020 = {
     8, /*nsat*/
     2455197.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};

