module Bseed = struct
  let random5 = "lxm1:\239w\2416\219\017\139\172\171p\201\164\255\230}3\157\n\004f_\130\157\187\210\128\129\244!%\233T"
  let random4 = "lfsr2:\147\178\146\004MXF$\001\236'\017\161\t\239&F\177\195\024\144W\127\016\203\149r4oR\133\011|K\146\011)\192\1963\209\021\178-\202`\194\b\224\186\137\024\246\228e'6,,2\244\150v9T\233\224:\205\182}\007.V\168\017\176t\210\018\025`o,\1998H?\188\136\243\017xJP\bn*\207$Q\177\184(U\186}9 \206k\015\222\185>)\194\197\149-\186[\2153\138%=2\025\218\231-Z\133\244'\202\132\248)\170+\235$\149\147\217.!$\185\031\200\162\137#of\135:U\180}\024\234u[$=\234\179\007\019r\156&\255\162\252\027\0219b5\152\198\2546\222R\158\t\205%\210\020\213\207\252\011\219P\011)'\143\206+\151V\244\005\165\145\"+\031\169\139\020\000"
  let random3 = "lfsr1:\147\178\1461MXF9\001\236g\020\161\to\025F\177\195\022\144W\127\020\203\149r\roRE\"|KR\018)\192\004\028\209\021\242+\202`\194\002\224\186\137&\246\228\16596,\172\028\244\1506\030T\233`>\205\182\189!.V\2324\176tR$\025`o\027\1998\136?\188\136\179\004xJP\018n*\2079Q\177\184\nU\186=. \206\171\003\222\185~:\194\197\213\011\186[\023<\138%\189\012\025\218\167\011Z\1334\025\202\132\184*\170+\235\025\149\147Y\027!$y\023\200\162I\024of\007\014U\180}\022\234u[)=\234s\017\019r\0289\255\162<&\0219\"=\152\198~=\222R\222\002\205%\210\021\213\207<2\219PK:'\143\014*\151V\180!\165\145\226\n\031\169\139\005\000"
end

module Ref = struct
  let random5 =
    [51205518; 143567504; 373210087; 931777272; 1024888384; 482316132; 215395062;
     287774887; 122637722; 38242823; 350835997; 630681959; 718778024; 1065436210;
     43244835; 609003301; 259142195; 1039388409; 905127179; 164615882; 221116766;
     383401359; 788855748; 722758384; 662498126; 495247601; 671365454; 719912258;
     474192479; 734524651; 577331096; 1019075908; 545637817; 578658943; 980379849;
     457833426; 808752211; 1027037899; 384530842; 586472994; 779070294; 504262909;
     839642021; 569868070; 653106634; 462343329; 195606612; 400414219; 437410999;
     1065973528; 184562054; 8977365; 701766686; 1030788046; 201158226; 993355978;
     513186390; 793044777; 266183426; 748055767; 106963046; 264533467; 468538478;
     914245566; 530582367; 967537841; 998977830; 845571161; 555948857; 1005737806;
     106600589; 262202732; 675506221; 116323840; 529666627; 137258302; 696020801;
     237746569; 109239396; 85391287; 662583924; 1035066826; 170367049; 48279585;
     434780163; 686477977; 637582722; 537604125; 339045636; 673659184; 443413333;
     773842082; 430598577; 531224810; 63845424; 720907323; 1042853427; 730867490;
     834910774; 749645142]
  let random4 =
    [218040752; 178628190; 911923154; 33712936; 1041571162; 675934603; 1036154868;
     964306322; 465126794; 397056657; 766348408; 123948673; 119474438; 364236535;
     872283479; 324967838; 735653048; 425476195; 963569356; 141296398; 883585517;
     150097740; 300850522; 966873161; 884310298; 579406628; 993680718; 791875681;
     414734201; 140707010; 919590950; 988210111; 848964519; 542334128; 653104864;
     753840348; 134419897; 558635725; 872516612; 876018147; 1007030409; 895579830;
     771735681; 589016056; 186124294; 721208282; 486338680; 11227775; 626593843;
     578434971; 876253760; 983484546; 873783548; 645547631; 1043595994; 28609232;
     758034815; 831862039; 825588618; 382563518; 816641633; 882003984; 878774605;
     240349486; 939390794; 345711438; 877789022; 253894334; 922872266; 671058258;
     127244154; 668941622; 247314213; 661563217; 730312450; 1069709821; 871306018;
     787189194; 978100948; 437162291; 84099792; 796192659; 701618424; 214775921;
     786254645; 889445143; 1016819314; 533257533; 300454327; 404951677; 62662024;
     951061534; 366897901; 677549419; 42625831; 872679393; 167549434; 575782901;
     842910375; 35254733]
  let random3 =
    [67045790; 44410454; 488298433; 289565476; 542448978; 160035205; 788690937;
     502932885; 892945795; 380279451; 481135732; 31673973; 287246615; 888524542;
     742260067; 350133673; 186199223; 106709099; 493807299; 28050200; 1017803228;
     36851540; 355376470; 262230075; 1022722342; 680069936; 767188295; 473108597;
     381179751; 27460825; 1045420061; 262595511; 467282864; 131292299; 724408014;
     1001304295; 553850278; 122428097; 738298884; 196540888; 397445; 773945009;
     989839496; 928754710; 840435731; 700236795; 398258311; 552292996; 949555264;
     398079902; 733647423; 509528179; 219472121; 448415349; 20185806; 16026308;
     724480390; 181744904; 762674073; 923628729; 187496030; 760369174; 765528396;
     286486835; 511571750; 131801922; 1032978268; 841096893; 1010952639; 406817127;
     546674561; 186596668; 880654108; 409904971; 956804910; 784497135; 737088335;
     753634781; 814523071; 898535782; 4408014; 427093894; 982636776; 600651872;
     475876174; 1065605867; 278621819; 118021430; 313037203; 413340263; 851191200;
     741346308; 882797271; 430085456; 483027723; 511969195; 905746931; 949075940;
     696109779; 777646546]
end

let gen bits = List.init 100 (fun _ -> bits ())

let failure reader seed = try ignore (reader seed); false with Failure _ -> true

let () =
  let () = Random3.(set_state @@ State.of_binary_string @@ Bseed.random3) in
  let () = Random4.(set_state @@ State.of_binary_string @@ Bseed.random4) in
  let () = Random5.(set_state @@ State.of_binary_string @@ Bseed.random5) in
  let () = Random5o.(set_state @@ State.of_binary_string @@ Bseed.random5) in
  assert (gen Random3.bits = Ref.random3);
  assert (gen Random4.bits = Ref.random4);
  assert (gen Random5.bits = Ref.random5);
  assert (gen Random5o.bits = Ref.random5);
  assert(failure Random5.State.of_binary_string Bseed.random4);
  assert(failure Random4.State.of_binary_string Bseed.random5);
  assert(failure Random3.State.of_binary_string Bseed.random4)
