/*
 * nsfDecls.h --
 *
 *	Declarations of functions in the platform independent public Nsf API.
 *
 * This file is part of the Next Scripting Framework.
 *
 * Copyright (C) 1999-2014 Gustaf Neumann (a, b)
 * Copyright (C) 1999-2007 Uwe Zdun (a, b)
 *
 * (a) University of Essen
 *     Specification of Software Systems
 *     Altendorferstrasse 97-101
 *     D-45143 Essen, Germany
 *
 * (b) Vienna University of Economics and Business
 *     Institute of Information Systems and New Media
 *     A-1090, Augasse 2-6
 *     Vienna, Austria
 *
 * This work is licensed under the MIT License https://www.opensource.org/licenses/MIT
 *
 * Copyright:
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef _NSFDECLS
#define _NSFDECLS

/*
 * WARNING: This file is automatically generated by the tools/genStubs.tcl
 * script.  Any modifications to the function declarations below should be made
 * in the nsf.decls script.
 */

/* !BEGIN!: Do not edit below this line. */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Exported function declarations:
 */

/* 0 */
EXTERN int		Nsf_Init(Tcl_Interp *interp);
/* Slot 1 is reserved */
/* 2 */
EXTERN struct Nsf_Class * NsfIsClass(Tcl_Interp *interp, ClientData cd);
/* 3 */
EXTERN struct Nsf_Object * NsfGetObject(Tcl_Interp *interp, const char *name);
/* 4 */
EXTERN struct Nsf_Class * NsfGetClass(Tcl_Interp *interp, const char *name);
/* 5 */
EXTERN int		NsfDeleteObject(Tcl_Interp *interp,
				struct Nsf_Object *object);
/* 6 */
EXTERN int		NsfRemoveObjectMethod(Tcl_Interp *interp,
				struct Nsf_Object *object,
				const char *methodName);
/* 7 */
EXTERN int		NsfRemoveClassMethod(Tcl_Interp *interp,
				struct Nsf_Class *class,
				const char *methodName);
/* 8 */
EXTERN Tcl_Obj *	Nsf_ObjSetVar2(struct Nsf_Object *object,
				Tcl_Interp *interp, Tcl_Obj *name1,
				Tcl_Obj *name2, Tcl_Obj *valueObj,
				unsigned int flags);
/* 9 */
EXTERN Tcl_Obj *	Nsf_ObjGetVar2(struct Nsf_Object *object,
				Tcl_Interp *interp, Tcl_Obj *name1,
				Tcl_Obj *name2, unsigned int flags);
/* 10 */
EXTERN int		Nsf_UnsetVar2(struct Nsf_Object *object,
				Tcl_Interp *interp, const char *name1,
				const char *name2, unsigned int flags);
/* 11 */
EXTERN void		NsfDStringVPrintf(Tcl_DString *dsPtr,
				const char *fmt, va_list argPtr);
/* 12 */
EXTERN int		NsfPrintError(Tcl_Interp *interp, const char *fmt, ...);
/* 13 */
EXTERN int		NsfErrInProc(Tcl_Interp *interp, Tcl_Obj *objName,
				Tcl_Obj *clName, const char *procName);
/* 14 */
EXTERN int		NsfObjErrType(Tcl_Interp *interp,
				const char *context, Tcl_Obj *value,
				const char *type,
				Nsf_Param const *NsfObjErrType);
/* 15 */
EXTERN void		NsfStackDump(Tcl_Interp *interp);
/* 16 */
EXTERN void		NsfSetObjClientData(Tcl_Interp *interp,
				Nsf_Object *object, ClientData data);
/* 17 */
EXTERN ClientData	NsfGetObjClientData(Tcl_Interp *interp,
				Nsf_Object *object);
/* 18 */
EXTERN void		NsfSetClassClientData(Tcl_Interp *interp,
				Nsf_Class *cl, ClientData data);
/* 19 */
EXTERN ClientData	NsfGetClassClientData(Tcl_Interp *interp,
				Nsf_Class *cl);
/* 20 */
EXTERN void		NsfRequireObjNamespace(Tcl_Interp *interp,
				Nsf_Object *object);
/* 21 */
EXTERN int		NsfCallMethodWithArgs(Tcl_Interp *interp,
				Nsf_Object *object, Tcl_Obj *methodObj,
				Tcl_Obj *arg1, int givenObjc,
				Tcl_Obj *const objv[], unsigned int flags);
/* 22 */
EXTERN int		NsfAddObjectMethod(Tcl_Interp *interp,
				struct Nsf_Object *object,
				const char *methodName, Tcl_ObjCmdProc *proc,
				ClientData clientData, Tcl_CmdDeleteProc *dp,
				unsigned int flags);
/* 23 */
EXTERN int		NsfAddClassMethod(Tcl_Interp *interp,
				struct Nsf_Class *class,
				const char *methodName, Tcl_ObjCmdProc *proc,
				ClientData clientData, Tcl_CmdDeleteProc *dp,
				unsigned int flags);
/* 24 */
EXTERN int		NsfCreate(Tcl_Interp *interp, Nsf_Class *class,
				Tcl_Obj *nameObj, int objc,
				Tcl_Obj *const objv[]);
/* 25 */
EXTERN int		Nsf_ArgumentParse(Tcl_Interp *interp, int objc,
				Tcl_Obj *const objv[], Nsf_Object *object,
				Tcl_Obj *procNameObj,
				Nsf_Param const *paramPtr, int nrParams,
				int serial, unsigned int processFlags,
				Nsf_ParseContext *pcPtr);
/* 26 */
EXTERN void		NsfLog(Tcl_Interp *interp, int requiredLevel,
				const char *fmt, ...);
/* 27 */
EXTERN int		Nsf_PointerAdd(Tcl_Interp *interp, char *buffer,
				size_t size, const char *typeName,
				void *valuePtr);
/* 28 */
EXTERN int		Nsf_PointerDelete(const char *key, void *valuePtr,
				int free);
/* 29 */
EXTERN int		Nsf_PointerTypeRegister(Tcl_Interp *interp,
				const char*typeName, int *counterPtr);
/* 30 */
EXTERN int		Nsf_ConvertToBoolean(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param const *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
/* 31 */
EXTERN int		Nsf_ConvertToClass(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param const *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
/* 32 */
EXTERN int		Nsf_ConvertToInt32(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param const *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
/* 33 */
EXTERN int		Nsf_ConvertToInteger(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param const *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
/* 34 */
EXTERN int		Nsf_ConvertToObject(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param const *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
/* 35 */
EXTERN int		Nsf_ConvertToPointer(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param const *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
/* 36 */
EXTERN int		Nsf_ConvertToString(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param const *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
/* 37 */
EXTERN int		Nsf_ConvertToTclobj(Tcl_Interp *interp,
				Tcl_Obj *objPtr, Nsf_Param const *pPtr,
				ClientData *clientData, Tcl_Obj **outObjPtr);
/* 38 */
EXTERN int		Nsf_EnumerationTypeRegister(Tcl_Interp *interp,
				Nsf_EnumeratorConverterEntry *typeRecords);
/* 39 */
EXTERN int		Nsf_CmdDefinitionRegister(Tcl_Interp *interp,
				Nsf_methodDefinition *definitionRecords);
/* 40 */
EXTERN int		NsfArgumentError(Tcl_Interp *interp,
				const char *errorMsg,
				Nsf_Param const *paramPtr,
				Tcl_Obj *cmdNameObj, Tcl_Obj *methodPathObj);
/* 41 */
EXTERN void		Nsf_DStringPrintf(Tcl_DString *dsPtr,
				const char *fmt, ...);

typedef struct {
    const struct NsfIntStubs *nsfIntStubs;
} NsfStubHooks;

typedef struct NsfStubs {
    int magic;
    const NsfStubHooks *hooks;

    int (*nsf_Init) (Tcl_Interp *interp); /* 0 */
    void (*reserved1)(void);
    struct Nsf_Class * (*nsfIsClass) (Tcl_Interp *interp, ClientData cd); /* 2 */
    struct Nsf_Object * (*nsfGetObject) (Tcl_Interp *interp, const char *name); /* 3 */
    struct Nsf_Class * (*nsfGetClass) (Tcl_Interp *interp, const char *name); /* 4 */
    int (*nsfDeleteObject) (Tcl_Interp *interp, struct Nsf_Object *object); /* 5 */
    int (*nsfRemoveObjectMethod) (Tcl_Interp *interp, struct Nsf_Object *object, const char *methodName); /* 6 */
    int (*nsfRemoveClassMethod) (Tcl_Interp *interp, struct Nsf_Class *class, const char *methodName); /* 7 */
    Tcl_Obj * (*nsf_ObjSetVar2) (struct Nsf_Object *object, Tcl_Interp *interp, Tcl_Obj *name1, Tcl_Obj *name2, Tcl_Obj *valueObj, unsigned int flags); /* 8 */
    Tcl_Obj * (*nsf_ObjGetVar2) (struct Nsf_Object *object, Tcl_Interp *interp, Tcl_Obj *name1, Tcl_Obj *name2, unsigned int flags); /* 9 */
    int (*nsf_UnsetVar2) (struct Nsf_Object *object, Tcl_Interp *interp, const char *name1, const char *name2, unsigned int flags); /* 10 */
    void (*nsfDStringVPrintf) (Tcl_DString *dsPtr, const char *fmt, va_list argPtr); /* 11 */
    int (*nsfPrintError) (Tcl_Interp *interp, const char *fmt, ...); /* 12 */
    int (*nsfErrInProc) (Tcl_Interp *interp, Tcl_Obj *objName, Tcl_Obj *clName, const char *procName); /* 13 */
    int (*nsfObjErrType) (Tcl_Interp *interp, const char *context, Tcl_Obj *value, const char *type, Nsf_Param const *NsfObjErrType); /* 14 */
    void (*nsfStackDump) (Tcl_Interp *interp); /* 15 */
    void (*nsfSetObjClientData) (Tcl_Interp *interp, Nsf_Object *object, ClientData data); /* 16 */
    ClientData (*nsfGetObjClientData) (Tcl_Interp *interp, Nsf_Object *object); /* 17 */
    void (*nsfSetClassClientData) (Tcl_Interp *interp, Nsf_Class *cl, ClientData data); /* 18 */
    ClientData (*nsfGetClassClientData) (Tcl_Interp *interp, Nsf_Class *cl); /* 19 */
    void (*nsfRequireObjNamespace) (Tcl_Interp *interp, Nsf_Object *object); /* 20 */
    int (*nsfCallMethodWithArgs) (Tcl_Interp *interp, Nsf_Object *object, Tcl_Obj *methodObj, Tcl_Obj *arg1, int givenObjc, Tcl_Obj *const objv[], unsigned int flags); /* 21 */
    int (*nsfAddObjectMethod) (Tcl_Interp *interp, struct Nsf_Object *object, const char *methodName, Tcl_ObjCmdProc *proc, ClientData clientData, Tcl_CmdDeleteProc *dp, unsigned int flags); /* 22 */
    int (*nsfAddClassMethod) (Tcl_Interp *interp, struct Nsf_Class *class, const char *methodName, Tcl_ObjCmdProc *proc, ClientData clientData, Tcl_CmdDeleteProc *dp, unsigned int flags); /* 23 */
    int (*nsfCreate) (Tcl_Interp *interp, Nsf_Class *class, Tcl_Obj *nameObj, int objc, Tcl_Obj *const objv[]); /* 24 */
    int (*nsf_ArgumentParse) (Tcl_Interp *interp, int objc, Tcl_Obj *const objv[], Nsf_Object *object, Tcl_Obj *procNameObj, Nsf_Param const *paramPtr, int nrParams, int serial, unsigned int processFlags, Nsf_ParseContext *pcPtr); /* 25 */
    void (*nsfLog) (Tcl_Interp *interp, int requiredLevel, const char *fmt, ...); /* 26 */
    int (*nsf_PointerAdd) (Tcl_Interp *interp, char *buffer, size_t size, const char *typeName, void *valuePtr); /* 27 */
    int (*nsf_PointerDelete) (const char *key, void *valuePtr, int free); /* 28 */
    int (*nsf_PointerTypeRegister) (Tcl_Interp *interp, const char*typeName, int *counterPtr); /* 29 */
    int (*nsf_ConvertToBoolean) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param const *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 30 */
    int (*nsf_ConvertToClass) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param const *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 31 */
    int (*nsf_ConvertToInt32) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param const *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 32 */
    int (*nsf_ConvertToInteger) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param const *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 33 */
    int (*nsf_ConvertToObject) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param const *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 34 */
    int (*nsf_ConvertToPointer) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param const *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 35 */
    int (*nsf_ConvertToString) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param const *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 36 */
    int (*nsf_ConvertToTclobj) (Tcl_Interp *interp, Tcl_Obj *objPtr, Nsf_Param const *pPtr, ClientData *clientData, Tcl_Obj **outObjPtr); /* 37 */
    int (*nsf_EnumerationTypeRegister) (Tcl_Interp *interp, Nsf_EnumeratorConverterEntry *typeRecords); /* 38 */
    int (*nsf_CmdDefinitionRegister) (Tcl_Interp *interp, Nsf_methodDefinition *definitionRecords); /* 39 */
    int (*nsfArgumentError) (Tcl_Interp *interp, const char *errorMsg, Nsf_Param const *paramPtr, Tcl_Obj *cmdNameObj, Tcl_Obj *methodPathObj); /* 40 */
    void (*nsf_DStringPrintf) (Tcl_DString *dsPtr, const char *fmt, ...); /* 41 */
} NsfStubs;

extern const NsfStubs *nsfStubsPtr;

#ifdef __cplusplus
}
#endif

#if defined(USE_NSF_STUBS)

/*
 * Inline function declarations:
 */

#define Nsf_Init \
	(nsfStubsPtr->nsf_Init) /* 0 */
/* Slot 1 is reserved */
#define NsfIsClass \
	(nsfStubsPtr->nsfIsClass) /* 2 */
#define NsfGetObject \
	(nsfStubsPtr->nsfGetObject) /* 3 */
#define NsfGetClass \
	(nsfStubsPtr->nsfGetClass) /* 4 */
#define NsfDeleteObject \
	(nsfStubsPtr->nsfDeleteObject) /* 5 */
#define NsfRemoveObjectMethod \
	(nsfStubsPtr->nsfRemoveObjectMethod) /* 6 */
#define NsfRemoveClassMethod \
	(nsfStubsPtr->nsfRemoveClassMethod) /* 7 */
#define Nsf_ObjSetVar2 \
	(nsfStubsPtr->nsf_ObjSetVar2) /* 8 */
#define Nsf_ObjGetVar2 \
	(nsfStubsPtr->nsf_ObjGetVar2) /* 9 */
#define Nsf_UnsetVar2 \
	(nsfStubsPtr->nsf_UnsetVar2) /* 10 */
#define NsfDStringVPrintf \
	(nsfStubsPtr->nsfDStringVPrintf) /* 11 */
#define NsfPrintError \
	(nsfStubsPtr->nsfPrintError) /* 12 */
#define NsfErrInProc \
	(nsfStubsPtr->nsfErrInProc) /* 13 */
#define NsfObjErrType \
	(nsfStubsPtr->nsfObjErrType) /* 14 */
#define NsfStackDump \
	(nsfStubsPtr->nsfStackDump) /* 15 */
#define NsfSetObjClientData \
	(nsfStubsPtr->nsfSetObjClientData) /* 16 */
#define NsfGetObjClientData \
	(nsfStubsPtr->nsfGetObjClientData) /* 17 */
#define NsfSetClassClientData \
	(nsfStubsPtr->nsfSetClassClientData) /* 18 */
#define NsfGetClassClientData \
	(nsfStubsPtr->nsfGetClassClientData) /* 19 */
#define NsfRequireObjNamespace \
	(nsfStubsPtr->nsfRequireObjNamespace) /* 20 */
#define NsfCallMethodWithArgs \
	(nsfStubsPtr->nsfCallMethodWithArgs) /* 21 */
#define NsfAddObjectMethod \
	(nsfStubsPtr->nsfAddObjectMethod) /* 22 */
#define NsfAddClassMethod \
	(nsfStubsPtr->nsfAddClassMethod) /* 23 */
#define NsfCreate \
	(nsfStubsPtr->nsfCreate) /* 24 */
#define Nsf_ArgumentParse \
	(nsfStubsPtr->nsf_ArgumentParse) /* 25 */
#define NsfLog \
	(nsfStubsPtr->nsfLog) /* 26 */
#define Nsf_PointerAdd \
	(nsfStubsPtr->nsf_PointerAdd) /* 27 */
#define Nsf_PointerDelete \
	(nsfStubsPtr->nsf_PointerDelete) /* 28 */
#define Nsf_PointerTypeRegister \
	(nsfStubsPtr->nsf_PointerTypeRegister) /* 29 */
#define Nsf_ConvertToBoolean \
	(nsfStubsPtr->nsf_ConvertToBoolean) /* 30 */
#define Nsf_ConvertToClass \
	(nsfStubsPtr->nsf_ConvertToClass) /* 31 */
#define Nsf_ConvertToInt32 \
	(nsfStubsPtr->nsf_ConvertToInt32) /* 32 */
#define Nsf_ConvertToInteger \
	(nsfStubsPtr->nsf_ConvertToInteger) /* 33 */
#define Nsf_ConvertToObject \
	(nsfStubsPtr->nsf_ConvertToObject) /* 34 */
#define Nsf_ConvertToPointer \
	(nsfStubsPtr->nsf_ConvertToPointer) /* 35 */
#define Nsf_ConvertToString \
	(nsfStubsPtr->nsf_ConvertToString) /* 36 */
#define Nsf_ConvertToTclobj \
	(nsfStubsPtr->nsf_ConvertToTclobj) /* 37 */
#define Nsf_EnumerationTypeRegister \
	(nsfStubsPtr->nsf_EnumerationTypeRegister) /* 38 */
#define Nsf_CmdDefinitionRegister \
	(nsfStubsPtr->nsf_CmdDefinitionRegister) /* 39 */
#define NsfArgumentError \
	(nsfStubsPtr->nsfArgumentError) /* 40 */
#define Nsf_DStringPrintf \
	(nsfStubsPtr->nsf_DStringPrintf) /* 41 */

#endif /* defined(USE_NSF_STUBS) */

/* !END!: Do not edit above this line. */

#endif /* _NSFDECLS */

