find_package(TCL REQUIRED)
find_package(TclStub REQUIRED)
find_package(X11 REQUIRED)
find_package(PCAP)
pkg_check_modules(OTCL REQUIRED otcl)
pkg_check_modules(TCLCL REQUIRED tclcl)

INCLUDE (CheckFunctionExists)
INCLUDE (CheckIncludeFiles)
INCLUDE (CheckTypeSize)
INCLUDE (CheckSymbolExists)

CHECK_INCLUDE_FILES(stdlib.h STDC_HEADERS)
CHECK_INCLUDE_FILES(string.h HAVE_STRING_H)
CHECK_INCLUDE_FILES(strings.h STRINGS_H)
CHECK_INCLUDE_FILES(arpa/inet.h HAVE_ARPA_INET_H)
CHECK_INCLUDE_FILES(netinet/in.h HAVE_NETINET_IN_H)
CHECK_INCLUDE_FILES(net/ethernet.h HAVE_NET_ETHERNET_H)
CHECK_INCLUDE_FILES(fenv.h HAVE_FENV_H)

CHECK_TYPE_SIZE("long" SIZEOF_LONG)
CHECK_TYPE_SIZE("socklen_t" SOCKLEN_T)

CHECK_FUNCTION_EXISTS(bcopy HAVE_BCOPY)
CHECK_FUNCTION_EXISTS(bzero HAVE_BZERO)
CHECK_FUNCTION_EXISTS(getrusage HAVE_GETRUSAGE)
CHECK_FUNCTION_EXISTS(sbrk HAVE_SBRK)
CHECK_FUNCTION_EXISTS(snprintf HAVE_SNPRINTF)
CHECK_FUNCTION_EXISTS(strtoll HAVE_STRTOLL)
CHECK_FUNCTION_EXISTS(strtoq HAVE_STRTOQ)
CHECK_FUNCTION_EXISTS(addr2ascii HAVE_ADDR2ASCII)
CHECK_FUNCTION_EXISTS(feenableexcept HAVE_FEENABLEEXCEPT)

SET(CMAKE_EXTRA_INCLUDE_FILES net/ethernet.h)
CHECK_TYPE_SIZE("struct ether_header" HAVE_ETHER_HEADER_STRUCT)
CHECK_TYPE_SIZE("struct ether_addr" HAVE_ETHER_ADDRESS_STRUCT)
SET(CMAKE_EXTRA_INCLUDE_FILES)
CHECK_SYMBOL_EXISTS("SIOCGIFHWADDR" net/ethernet.h HAVE_SIOCGIFHWADDR)

configure_file(config-ns.h.cmake ${CMAKE_CURRENT_BINARY_DIR}/autoconf.h)
