import {builtinModules} from 'node:module';
import fs from 'node:fs';
import { nodeResolve } from '@rollup/plugin-node-resolve';
const pkg = JSON.parse(fs.readFileSync('package.json').toString());
if(!pkg.dependencies) pkg.dependencies={};
const file = 'index.cjs';

const config = {
	input: 'index.js',
	output: [{
		format: 'cjs',
		exports: 'default',
		file: file,
		interop: 'auto',
		freeze: false,
		strict: false
	}],
	external: [
		...builtinModules,
	],
	plugins: [
		nodeResolve({
			modulePaths: ['node_modules', ...process.config.variables.node_relative_path.split(':').map((str) => process.config.variables.node_prefix + '/' + str)],
		}),
	]
}

export default config;
