/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wrapper;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Properties;
import org.apache.maven.wrapper.BootstrapMainStarter;
import org.apache.maven.wrapper.Installer;
import org.apache.maven.wrapper.WrapperConfiguration;

public class WrapperExecutor {
    public static final String DISTRIBUTION_URL_PROPERTY = "distributionUrl";
    public static final String DISTRIBUTION_BASE_PROPERTY = "distributionBase";
    public static final String ZIP_STORE_BASE_PROPERTY = "zipStoreBase";
    public static final String DISTRIBUTION_PATH_PROPERTY = "distributionPath";
    public static final String ZIP_STORE_PATH_PROPERTY = "zipStorePath";
    private final Properties properties;
    private final Path propertiesFile;
    private final WrapperConfiguration config = new WrapperConfiguration();

    public static WrapperExecutor forProjectDirectory(Path projectDir) {
        return new WrapperExecutor(projectDir.resolve("maven/wrapper/maven-wrapper.properties"), new Properties());
    }

    public static WrapperExecutor forWrapperPropertiesFile(Path propertiesFile) {
        if (Files.notExists(propertiesFile, new LinkOption[0])) {
            throw new RuntimeException(String.format(Locale.ROOT, "Wrapper properties file '%s' does not exist.", propertiesFile));
        }
        return new WrapperExecutor(propertiesFile, new Properties());
    }

    WrapperExecutor(Path propertiesFile, Properties properties) {
        this.properties = properties;
        this.propertiesFile = propertiesFile;
        if (Files.exists(propertiesFile, new LinkOption[0])) {
            try {
                WrapperExecutor.loadProperties(propertiesFile, properties);
                this.config.setDistribution(this.prepareDistributionUri());
                this.config.setDistributionBase(this.getProperty(DISTRIBUTION_BASE_PROPERTY, this.config.getDistributionBase()));
                this.config.setDistributionPath(Paths.get(this.getProperty(DISTRIBUTION_PATH_PROPERTY, this.config.getDistributionPath().toString()), new String[0]));
                this.config.setZipBase(this.getProperty(ZIP_STORE_BASE_PROPERTY, this.config.getZipBase()));
                this.config.setZipPath(Paths.get(this.getProperty(ZIP_STORE_PATH_PROPERTY, this.config.getZipPath().toString()), new String[0]));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format(Locale.ROOT, "Could not load wrapper properties from '%s'.", propertiesFile), e);
            }
        }
    }

    private URI prepareDistributionUri() throws URISyntaxException {
        URI source = this.readDistroUrl();
        if (source.getScheme() == null) {
            return this.propertiesFile.getParent().resolve(source.getSchemeSpecificPart()).toUri();
        }
        return source;
    }

    private URI readDistroUrl() throws URISyntaxException {
        return new URI(this.getProperty(DISTRIBUTION_URL_PROPERTY));
    }

    private static void loadProperties(Path propertiesFile, Properties properties) throws IOException {
        try (InputStream inStream = Files.newInputStream(propertiesFile, new OpenOption[0]);){
            properties.load(inStream);
        }
    }

    public URI getDistribution() {
        return this.config.getDistribution();
    }

    public WrapperConfiguration getConfiguration() {
        return this.config;
    }

    public void execute(String[] args, Installer install, BootstrapMainStarter bootstrapMainStarter) throws Exception {
        Path mavenHome = install.createDist(this.config);
        bootstrapMainStarter.start(args, mavenHome);
    }

    private String getProperty(String propertyName) {
        return this.getProperty(propertyName, null);
    }

    private String getProperty(String propertyName, String defaultValue) {
        String value = this.properties.getProperty(propertyName, defaultValue);
        if (value == null) {
            this.reportMissingProperty(propertyName);
        }
        return value;
    }

    private void reportMissingProperty(String propertyName) {
        throw new RuntimeException(String.format(Locale.ROOT, "No value with key '%s' specified in wrapper properties file '%s'.", propertyName, this.propertiesFile));
    }
}

