# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.poly_data_algorithm import PolyDataAlgorithm


class LineSource(PolyDataAlgorithm):
    r"""
    LineSource - create a line defined by two end points
    
    Superclass: PolyDataAlgorithm
    
    LineSource is a source object that creates a polyline defined by
    two endpoints or a collection of connected line segments. To define
    the line by end points, use `set_point1` and `set_point2` methods. To
    define a broken line comprising of multiple line segments, use
    `set_points` to provide the corner points that for the line.
    
    Intermediate points within line segment (when specifying end points
    alone) or each of the individual line segments (when specifying
    broken line) can be specified in two ways. First, when
    `use_regular_refinement` is true (default), the `Resolution` is used to
    determine how many intermediate points to add using regular
    refinement. Thus, if `Resolution` is set to 1, a mid point will be
    added for each of the line segments resulting in a line with 3
    points: the two end points and the mid point. Second, when
    `use_regular_refinement` is false, refinement ratios for points per
    segment are specified using `set_refinement_ratio` and
    `set_number_of_refinement_ratios`. To generate same points as
    `Resolution` set to 1, the refinement ratios will be `[0, 0.5, 1.0]`.
    To add the end points of the line segment `0.0` and `1.0` must be
    included in the collection of refinement ratios.
    
    @section changes_vtk9 Changes in VTK 9.0
    
    Prior to VTK 9.0, when broken line was being generated, the texture
    coordinates for each of the individual breaks in the line ranged from
    [0.0, 1.0]. This has been changed to generate texture coordinates in
    the range [0.0, 1.0] over the entire output line irrespective of
    whether the line was generated by simply specifying the end points or
    multiple line segments.
    
    @par Thanks: This class was extended by Philippe Pebay, Kitware SAS
    2011, to support broken lines as well as simple lines.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkLineSource, obj, update, **traits)
    
    use_regular_refinement = tvtk_base.true_bool_trait(desc=\
        r"""
        Set/Get how the line segment is to be refined. One can choose to
        add points at regular intervals per segment (defined using
        `Resolution`) or explicit locations (defined using
        `set_refinement_ratio`). Default is true i.e `Resolution` will be
        used to determine placement of points within each line segment.
        """
    )

    def _use_regular_refinement_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseRegularRefinement,
                        self.use_regular_refinement_)

    number_of_refinement_ratios = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        API for setting/getting refinement ratios for points added to the
        line segment. The ratio is in the range `[0.0, 1.0]` where 0.0 is
        the start of the line segment and 1.0 is the end. When generating
        broken lines i.e. using `set_points`, this specifies refinement
        points for each of the individual line segment. Note that `0.0`
        and `1.0` must be explicitly included to generate a point and the
        start and/or end of the line segment. This is used only when
        `use_regular_refinement` is false.
        """
    )

    def _number_of_refinement_ratios_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfRefinementRatios,
                        self.number_of_refinement_ratios)

    output_points_precision = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/get the desired precision for the output points.
        Algorithm::SINGLE_PRECISION - Output single-precision floating
        point. Algorithm::DOUBLE_PRECISION - Output double-precision
        floating point.
        """
    )

    def _output_points_precision_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetOutputPointsPrecision,
                        self.output_points_precision)

    point1 = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(-0.5, 0.0, 0.0), cols=3, desc=\
        r"""
        Set position of first end point.
        """
    )

    def _point1_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPoint1,
                        self.point1)

    point2 = traits.Array(enter_set=True, auto_set=False, shape=(3,), dtype="float", value=(0.5, 0.0, 0.0), cols=3, desc=\
        r"""
        Set position of other end point.
        """
    )

    def _point2_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPoint2,
                        self.point2)

    def _get_points(self):
        return wrap_vtk(self._vtk_obj.GetPoints())
    def _set_points(self, arg):
        old_val = self._get_points()
        my_arg = deref_array([arg], [['vtkPoints']])
        self._wrap_call(self._vtk_obj.SetPoints,
                        my_arg[0])
        self.trait_property_changed('points', old_val, arg)
    points = traits.Property(_get_points, _set_points, desc=\
        r"""
        
        """
    )

    def get_refinement_ratio(self, *args):
        """
        get_refinement_ratio(self, index:int) -> float
        C++: double get_refinement_ratio(int index)"""
        ret = self._wrap_call(self._vtk_obj.GetRefinementRatio, *args)
        return ret

    def set_refinement_ratio(self, *args):
        """
        set_refinement_ratio(self, index:int, value:float) -> None
        C++: void set_refinement_ratio(int index, double value)"""
        ret = self._wrap_call(self._vtk_obj.SetRefinementRatio, *args)
        return ret

    resolution = traits.Trait(1, traits.Range(1, 2147483647, enter_set=True, auto_set=False), desc=\
        r"""
        Divide line into Resolution number of pieces. This is used when
        `use_regular_refinement` is true.
        """
    )

    def _resolution_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResolution,
                        self.resolution)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    _updateable_traits_ = \
    (('use_regular_refinement', 'GetUseRegularRefinement'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('number_of_refinement_ratios', 'GetNumberOfRefinementRatios'),
    ('output_points_precision', 'GetOutputPointsPrecision'), ('point1',
    'GetPoint1'), ('point2', 'GetPoint2'), ('resolution',
    'GetResolution'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'use_regular_refinement',
    'number_of_refinement_ratios', 'output_points_precision', 'point1',
    'point2', 'progress_text', 'resolution'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(LineSource, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit LineSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['use_regular_refinement'], [], ['number_of_refinement_ratios',
            'output_points_precision', 'point1', 'point2', 'resolution']),
            title='Edit LineSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit LineSource properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

