#!/bin/sh -e

DATE=$(echo $1|sed 's/^.*\+cvs//')
DIR=libyanfs-java-$1.orig
TAR=../libyanfs-java_$1.orig.tar.gz
echo -n "Enter username for cvs.dev.java.net: "; read USERNAME
CVSROOT=:pserver:$USERNAME@cvs.dev.java.net:/cvs

# checkout the sources and clean them up
cvs -d$CVSROOT login
cvs -z9 -d$CVSROOT export -D $DATE -d $DIR yanfs
mkdir $DIR/src $DIR/src/com 
(cd $DIR/orig; tar -x -f images.tar.gz)
(cd $DIR/orig/xfilechooser; tar -x -f beanImages.tgz)
mv $DIR/orig/ $DIR/src/com/sun
GZIP=--best tar -c -z -f $TAR -X debian/orig-tar.exclude $DIR
rm -rf $DIR

# move to directory 'tarballs'
if [ -r .svn/deb-layout ]; then
  . .svn/deb-layout
  mv $TAR $origDir
  echo "moved $TAR to $origDir"
fi

exit 0
