/*
 * Decompiled with CFR 0.152.
 */
package com.vldocking.swing.docking.ui;

import com.vldocking.swing.docking.DockView;
import com.vldocking.swing.docking.SplitContainer;
import com.vldocking.swing.docking.TabbedDockableContainer;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;

public class DockViewUI
extends PanelUI {
    protected ViewAncestorListener ancestorListener = new ViewAncestorListener();
    private static DockViewUI instance = new DockViewUI();

    public static ComponentUI createUI(JComponent c) {
        return instance;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        c.addAncestorListener(this.ancestorListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.removeAncestorListener(this.ancestorListener);
    }

    protected void installSingleDockableBorder(DockView v) {
        Border b = UIManager.getBorder("DockView.singleDockableBorder");
        v.setBorder(b);
    }

    protected void installTabbedDockableBorder(DockView v) {
        Border b = UIManager.getBorder("DockView.tabbedDockableBorder");
        v.setBorder(b);
    }

    protected void installMaximizedDockableBorder(DockView v) {
        Border b = UIManager.getBorder("DockView.maximizedDockableBorder");
        v.setBorder(b);
    }

    class ViewAncestorListener
    implements AncestorListener {
        ViewAncestorListener() {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            DockView v = (DockView)ancestorEvent.getComponent();
            Container parent = v.getParent();
            if (parent instanceof TabbedDockableContainer) {
                DockViewUI.this.installTabbedDockableBorder(v);
            } else if (parent instanceof SplitContainer) {
                DockViewUI.this.installSingleDockableBorder(v);
            } else {
                DockViewUI.this.installMaximizedDockableBorder(v);
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
        }
    }
}

